<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    '_shared.webstatDomainIsSuspended' => 'Website %%domainName%% is suspended.',
    '_shared.webstatHostingNotConfigured' => 'There is no hosting configured on %%domainName%%.',
    '_shared.webstatNotSelected' => 'You did not select a web statistics program to be used for website at %%domainName%%.',
    '_shared.domainDisabled' => 'This domain (website) was disabled by hosting provider.',
    '_shared.domainSuspended' => 'This domain (website) was suspended by hosting provider.',
    '_shared.operationSelectorHint' => 'To proceed with the operation, please select a webspace.',
    '_shared.operationSelectorTitle' => 'Webspace',
    '_shared.willBeAppliedAfterApacheRestartInterval' => 'The website settings will be applied in %%restartInterval%% minutes.',

    'add-domain-alias.noDomains' => 'Unable to create an alias: There are no domains available.',
    'add-domain.noDomains' => 'Unable to create an addon domain: There are no domains available.',
    'add-subdomain.noDomains' => 'Unable to create a subdomain: There are no domains available.',

    'change-status.changed' => 'The website status for %%domainName%% was changed.',
    'change-status.notActivatedSuspended' => 'The website %%domainName%% cannot be activated because it was suspended by your hosting provider.',
    'change-status.notActivatedDisabled' => 'The website %%domainName%% cannot be activated because it was disabled by your hosting provider.',

    'change-status-alias.activated' => 'The domain alias %%domainAliasName%% was successfully activated.',
    'change-status-alias.deactivated' => 'The domain alias %%domainAliasName%% was disabled.',
    'change-status-alias.notActivated' => 'The domain alias %%domainAliasName%% cannot be activated because it was disabled by your hosting provider.',

    'delete.sitesNotSpecified' => 'No sites specified for removal',
    'delete.domainDeletionNotAllowed' => 'Domain deletion is not allowed.',
    'delete.subdomainDeletionNotAllowed' => 'Subdomain deletion is not allowed.',
    'delete.aliasDeletionNotAllowed' => 'Alias deletion is not allowed',
    'delete.domainDeletedSuccessfully' => 'The domain was removed.',
    'delete.subdomainDeletedSuccessfully' => 'The subdomain was removed.',
    'delete.aliasDeletedSuccessfully' => 'The alias was removed.',

    'download-web-deploy-publish-settings.hostingNotConfigured' => 'There is no hosting configured on %%domainName%%.',
    'download-web-deploy-publish-settings.webDeployNotSupported' => 'Web Deploy is not supported.',
    'download-web-deploy-publish-settings.webDeployNotInstalled' => 'Web Deploy is not installed.',
    'download-web-deploy-publish-settings.webDeployNotConfigured' => 'There is no Web Deploy publishing configured on %%domainName%%.',

    'index.title' => 'Websites & Domains',
    'index.home' => 'Home',

    'overview.title' => 'Domain overview',
    'overview.suspended' => 'Suspended',
    'overview.disabled' => 'Disabled',

    'php-settings.title' => 'PHP Settings for %%domainName%%',
    'php-settings.updatedSuccessfully' => 'The settings were successfully updated.',
    'php-settings.showPhpInfoError' => 'Unable to retrieve information about the PHP configuration.',
    'php-settings.phpHandlerNotFound' => 'Unable to retrieve information about the domain\'s PHP version. Reinstall it or select another PHP version for the domain.',
    'php-settings.phpHandlerNotRegistered' => "PHP version %%fullVersion%% is not installed. PHP scripting for the domain '%%domainName%%' is unavailable. Install PHP <nobr>version %%fullVersion%%</nobr> or select another PHP version for the domain.",

    'site-copy.title' => 'Copy %%siteName%% Files',
    'site-copy.description' => 'Copy the website files to another site of yours hosted under this account or to an FTP storage. Such copying is useful if this is a production website and you are planning to make major site changes. In such a case, you can clone the site to a staging environment and let your designers and programmers work on the clone without interrupting operations of the production site. Copying the site files is a part of cloning the site: You will also need to copy databases used by the site to complete the cloning. If you do not have another site to use as a staging environment, you can add a domain or a subdomain for that purpose.',
    'site-copy.siteCopiedSuccessfully' => 'Files of the site %%sourceName%% were copied to %%destinationName%%.',

    'statistics.show' => 'Show',
    'statistics.webStatistics' => 'Web Statistics',
    'statistics.sslWebStatistics' => 'SSL/TLS Web Statistics',
    'statistics.ftpStatistics' => 'FTP Statistics',
    'statistics.anonymousFtpStatistics' => 'Anonymous FTP Statistics',
    'statistics.hostingNotConfigured' => 'There is no web hosting configured on domain %%domainName%%',
    'statistics.webstatNotSelected' => 'You did not select a web statistics program to be used on domain %%domainName%%',

    'subscription-delete.infoSubscriptionDeleted' => 'The selected webspaces were removed.',
    'subscription-delete.infoSubscriptionNotDeleted' => 'Some of the selected webspaces were not removed.',

    'subscriptions.title' => 'Webspace',
    'subscriptions.buttonRemove' => 'Remove',
    'subscriptions.buttonRemoveDescription' => 'Remove the selected webspaces.',
    'subscriptions.confirmOnDelete' => 'Do you want to remove the selected webspaces?',
    'subscriptions.buttonAddNew' => 'Add Webspace',
    'subscriptions.buttonAddNewDescription' => 'Create a webspace.',
    'subscriptions.buttonMyResources' => 'My Resources',
    'subscriptions.buttonMyResourcesDescription' => 'View available resources.',
    'subscriptions.subscriptionsHintTitle' => 'Webspace Summary',
    'subscriptions.subscriptionsHintWaitMessage' => 'Loading...',

    'view.title' => 'Websites & Domains',
    'view.suspended' => 'Suspended',
    'view.disabled' => 'Disabled',
    'view.buttonDeleteDomain' => 'Remove Website',
    'view.buttonDeleteDomainHint' => 'Removing this website will also delete all related files, directories, mail, and web applications from the server.',
    'view.buttonDeleteSubdomain' => 'Remove Subdomain',
    'view.buttonDeleteSubdomainHint' => 'Removing this website will also delete all related files, directories, mail, and web applications from the server.',
    'view.buttonDeleteAlias' => 'Remove Domain Alias',
    'view.buttonDeleteAliasHint' => 'Remove this alias.',
    'view.warningSubscriptionUsesSNWithoutLicense' => 'Hosting management operations are not allowed for this subscription: %%reason%%. Please contact your service provider.',
    'view.warningSubscriptionIsSuspended' => 'Subscription was suspended. All your sites are not available.',
    'view.warningSubscriptionIsSuspendedByBackupRestore' => 'The subscription is temporarily unavailable because the data backup or restoration is in progress. Please try again later.',
    'view.warningSubscriptionIsSuspended_powerUser' => 'The webspace was suspended. All sites hosted within the webspace are not available.',
    'view.buttonIssAppPoolHint_powerUser' => 'Set up a dedicated IIS application pool for serving websites hosted within the currently selected webspace.',
    'view.buttonSitebuilder' => 'Presence Builder',
    'view.buttonApplications' => 'Applications',
    'view.buttonConnectionInfo' => 'Connection Info',
    'view.buttonConnectionInfoDesc' => 'for FTP, Database',
    'view.buttonFileManager' => 'Files',
    'view.buttonWebStatistics' => 'Web Statistics',
    'view.buttonWebStatisticsSsl' => 'Web Statistics SSL/TLS',
    'view.buttonTransferStats' => 'Data transfer',
    'view.buttonTransferStatsComment' => 'HTTP, FTP, Mail',
    'view.buttonStatistics' => 'Disk space and traffic',
    'view.buttonFTPStats' => 'FTP transfer report',
    'view.buttonAnonFTPStats' => 'Anonymous FTP downloads',
    'view.buttonFtpAccess' => 'FTP',
    'view.buttonDnsSettings' => 'DNS',
    'view.domainNotResolvedComment' => 'Domain is not resolvable',
    'view.buttonWhoisInfo' => 'Whois Information',
    'view.buttonSslCertificates' => 'SSL/TLS Certificates',
    'view.buttonWebAppFirewall' => 'Web Application Firewall',
    'view.buttonBackup' => 'Backup & Restore',
    'view.buttonBackupHint' => 'Back up and restore your domains, including settings and content of websites and mail accounts.',
    'view.buttonHosting' => 'Hosting',
    'view.buttonHostingDesc' => 'Hosting Settings and Web Hosting Access',
    'view.buttonEmailAddresses' => 'Mail Accounts',
    'view.buttonMailSettings' => 'Mail Settings',
    'view.buttonMailLists' => 'Mailing Lists',
    'view.buttonOutgoingSpamSettings' => 'Limit Outgoing Messages',
    'view.buttonPhpSettings' => 'PHP',
    'view.buttonPhpSettingsVersion' => 'Version',
    'view.buttonWebServerSettingsUnix' => 'Apache & nginx',
    'view.buttonWebServerSettingsWindows' => 'IIS Settings',
    'view.buttonProtectedDirectories' => 'Password-Protected Directories',
    'view.buttonSheduledTasks' => 'Scheduled Tasks',
    'view.buttonSheduledTasksHint' => 'View and manage scheduled tasks.',
    'view.buttonDatabases' => 'Databases',
    'view.buttonDatabasesHint' => 'Create and remove databases used by your websites, and manage them using integrated administrative web application.',
    'view.buttonLogs' => 'Logs',
    'view.buttonLogsDescProblem' => 'Issues detected',
    'view.buttonFailedRequests' => 'Failed Request Tracing',
    'view.buttonHotlinkProtection' => 'Hotlink Protection',
    'view.buttonVirtualFolder' => 'Virtual Directories',
    'view.buttonBandwidthLimiting' => 'Bandwidth Limiting',
    'view.buttonWebUsers' => 'Web Users',
    'view.buttonOdbcDataSources' => 'ODBC Data Sources',
    'view.buttonAspNetSettings' => 'ASP.NET Settings',
    'view.buttonCustomerIisAppPool' => 'Dedicated IIS Application Pool for Your Account',
    'view.buttonCustomerIisAppPoolHint' => 'Set up a dedicated IIS application pool for serving all websites hosted under your account.',
    'view.buttonIssAppPool' => 'Dedicated IIS Application Pool for Website',
    'view.buttonSiteCopy' => 'Website Copying',
    'view.buttonWebDeploy' => 'Web Deploy Publishing Settings',
    'view.buttonSubscriptions' => 'Webspaces',
    'view.buttonSubscriptionsHint' => 'View and manage webspaces.',
    'view.buttonOutgoingMailControl' => 'Outgoing Mail Control',
    'view.buttonOutgoingMailControlHint' => 'View and manage outgoing mail.',
    'view.buttonInstallApsApplication' => 'More Apps',
    'view.buttonFilesUpload' => 'Upload Files',
    'view.forceUpdateApplicationsNotification' => 'Now your applications can be updated automatically. Use this setting with care because updates can significantly affect the app functionality. For example, app extensions may stop working with another version of the app. %%link%%.',
    'view.forceUpdateAllApplicationsNotificationLink' => 'Switch on automatic updates for all applications',
    'view.unnotifiedApplicationsUpdatesMessage' => 'Updates are available for the following applications: ',
    'view.updatedAutomaticallyApplicationsMessage' => 'The following applications were automatically updated: ',
    'view.activeStateComponentsWarning' => 'You have ActivePython and/or ActivePerl components installed on your server. Plesk no longer licenses them from ActiveState. To avoid violating the license agreement, %%link%%.',
    'view.activeStateComponentsWarningLink' => 'you need to take action',
    'view.toSecurePasswordsGoTo' => 'To improve Plesk security, we recommend that you turn on the enhanced security mode on this %%link%%.',
    'view.securePasswords' => 'page',
    'view.upgradeDnsSyncSkip' => 'Note that after the upgrade, all existing DNS zones are considered as user-modified. This means that you can apply DNS template changes to such zones only by using the \'Apply the changes to all zones\' option during the %%link%%. %%learnMoreLink%%.',
    'view.serverDns' => 'sync',
    'view.learnMore' => 'Learn more',
    'view.backEncryptionRequired' => 'For security reasons, we recommend that you protect data contained in backups. Please go to %%link%% and update backup security settings.',
    'view.backupSettingPage' => 'Backup Settings',
    'view.subscriptionNotExist' => 'The subscription does not exist',
    'view.phpHandlerOutdated' => '(Outdated)',
    'view.updatesAvailable' => 'Updates are available',
    'view.apsInstall' => 'Install',
    'view.apsApplicationInstall' => 'Install %%app%%',
    'view.apsInstallAll' => 'Install all',
    'view.apsChangelog' => 'Changelog',
    'view.apsApplicationChangelog' => '%%app%% Changelog',
    'view.apsInstances' => '%%total%% installations',
    'view.loading' => 'Loading...',
    'view.close' => 'Close',
    'view.viewMore' => 'View %%number%% more updates',
    'view.unableGetChangelog' => 'Unable to retrieve the changelog. Please refresh the page and try again.',

    'web-server-settings.titleUnix' => 'Apache & nginx Settings for %%domainName%%',
    'web-server-settings.titleWindows' => 'IIS Settings for %%domainName%%',
    'web-server-settings.updatedSuccessfully' => 'The settings were updated.',

    'setup.title' => 'Websites & Domains',
    'setup.noDomainTitle' => 'All set for launching websites',
    'setup.description' => 'Add a new domain to start creating your website.',
    'setup.openTutorial' => 'If you need help, read our %%link%%.',
    'setup.openTutorialLink' => 'website creation tutorial',
    'setup.addDomain' => 'Add Domain',
];
