<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'action-log.logFiles' => "日誌檔",
    'action-log.fromDate' => "開始時間：",
    'action-log.toDate' => "結束時間：",
    'action-log.clearLog' => "清除日誌",
    'action-log.downloadLog' => "下載",
    'action-log.loggedActions' => "記錄的操作",
    'action-log.storeLogsInDb' => "在資料庫中存儲記錄",
    'action-log.storeNumber' => "項目",
    'action-log.dontRemoveRecs' => "不要刪除記錄",
    'action-log.confirmCleanLog' => "您確定要刪除相應操作的日誌記錄嗎？",
    'action-log.incorrectDate' => "指定的日期無效。",
    'action-log.incorrectNumPeriods' => "指定的迴圈週期無效。",
    'action-log.incorrectNumRecords' => "指定的記錄數無效。",
    'action-log.yes' => "是",
    'action-log.no' => "否",
    'action-log.mixed' => "（混合）",
    'action-log.period' => "時段",
    'action-log.invalidDatePeriod' => "無效的日期期間",
    'action-log.submitDone' => "操作日誌變更已保存。",
    'action-log.clearDone' => "操作日誌已清除。",
    'action-log.periodDay' => "天",
    'action-log.periodWeek' => "星期",
    'action-log.periodMonth' => "月",

    'admin-info.adminInfoSection' => '管理員的資訊',
    'admin-info.description-admin' => '管理員的描述',
    'admin-info.description-reseller' => '代理商的描述',
    'admin-info.description-owner' => '所有者的描述',
    'admin-info.description' => '描述',
    'admin-info.descriptionSuccess' => '該描述已被更新。',
    'admin-info.longDescription' => '指定的描述太長。不得超過 %%max%% 個字元。',
    'admin-info.add' => '添加描述',
    'admin-info.edit' => '編輯',
    'admin-info.remove' => '刪除',
    'admin-info.confirmOnRemove' => '您要移除該描述嗎？',
    'admin-info.popupTitle-customer' => '客戶 %%name%% 的 %%descriptionType%%',
    'admin-info.popupTitle-reseller' => '代理商 %%name%% 的 %%descriptionType%%',
    'admin-info.popupTitle-subscription' => '訂閱 %%name%% 的 %%descriptionType%%',
    'admin-info.popupTitle-site' => '%%name%% %%descriptionType%%',
    'admin-info.popupHint-admin' => '僅管理員可見該描述。',
    'admin-info.popupHint-reseller' => '代理商和管理員可見該描述。',
    'admin-info.popupHint-owner' => '其創建者和創建者的主機提供商可見該描述。',
    'admin-info.customerDescriptionHint' => '客戶無法看到該描述。',
    'admin-info.subscriptionDescriptionHint' => "僅主機提供商可見該資訊（Plesk 管理員或代理商）。",

    'apache-settings.formGeneralHint' => '您可在此為網站指定 Apache web 伺服器設定。當您想要在網站上使用新類型的索引檔或要建立某個 MIME 類型與某個文件副檔名之間的關聯時，可自訂 Apache 配置。使用預設值則表示 Apache 將會使用來自伺服器級配置的相應指令。如果運行 Apache 時以 nginx 作為前端伺服器，您還可在此頁面上指定 nginx 設定。',
    'apache-settings.general' => '通用 Apache 設定',
    'apache-settings.example' => "例如：\n%%example%%",
    'apache-settings.settingOn' => '打開',
    'apache-settings.settingOff' => '關閉（默認）',
    'apache-settings.settingDefault' => '默認',
    'apache-settings.settingCustom' => '輸入自訂值',
    'apache-settings.mimeTypes' => 'MIME 類型',
    'apache-settings.mimeTypesExample' => "text/plain .txt\nimage/jpeg .jpeg",
    'apache-settings.mimeTypesFullDescription' => 'MIME類型會將檔副檔名與檔案類型關聯起來。通常，這用於為常見的檔案類型創建自訂的文件副檔名。',
    'apache-settings.handlers' => '處理器',
    'apache-settings.handlersExample' => "php-script .php\ncgi-script .cgi",
    'apache-settings.handlersFullDescription' => "Apache處理常式定義了web伺服器在被請求時如何處理具有某些副檔名的檔。例如，字串 'php-script .script' 意味著Apache將處理 .script 檔作為php腳本。",
    'apache-settings.deny' => '拒絕存取該網站',
    'apache-settings.allow' => '排除',
    'apache-settings.denyExample' => "10.1.0.0/16\n192.168.1.110\n\n禁止指定的主機和網路存取該網站。使用 '*' 拒絕所有連接。",
    'apache-settings.allowExample' => "192.168.0.0/16\n10.1.1.21\n\n允許指定的主機和網站存取該網站。",
    'apache-settings.directoryIndex' => '索引檔',
    'apache-settings.directoryIndexExample' => "index.htm index.php index.pl",
    'apache-settings.directoryIndexFullDescription' => "當請求網站的索引頁面時，Apache將查找指定的檔。",
    'apache-settings.expires' => '到期',
    'apache-settings.expiresStaticOnly' => '帶有 Expires 頭的回應僅用於靜態檔',
    'apache-settings.expiresFullDescription' => 'web 伺服器將會把 “Expires” 回應頭添加到網頁。以請求某網頁的時間點開始，持續指定的時間長，整個時段即為過期時間戳記。',
    'apache-settings.expiresStaticOnlyDescription' => '"Expires" 頭將只用於靜態檔。哪些檔會被視作靜態檔由 "靜態檔智慧處理" 和 "由 nginx 直接服務靜態檔" 選項決定。',
    'apache-settings.expiresUnitDays' => '天',
    'apache-settings.expiresUnitHours' => '小時',
    'apache-settings.expiresUnitMinutes' => '分鐘',
    'apache-settings.expiresUnitSeconds' => '秒',
    'apache-settings.headers' => '其它資訊頭',
    'apache-settings.headersExample' => "Cache-Control: public\nStrict-Transport-Security: max-age=63072000\nX-Frame-Options: DENY",
    'apache-settings.headersFullDescription' => "Web伺服器將添加指定的HTTP回應頭。",
    'apache-settings.restrictFollowSymLinks' => '限制遵循符號連結',
    'apache-settings.restrictFollowSymLinksDescription' => "選擇該選項以阻止使用者在 .htaccess 中使用 FollowSymLink 指令來提高伺服器的安全性。",
    'apache-settings.nginx' => 'nginx 設定',
    'apache-settings.nginxProxyMode' => '代理模式',
    'apache-settings.nginxProxyModeDescription' => 'Nginx 將請求轉發到 Apache。關閉以停止使用 Apache。',
    'apache-settings.nginxTransparentMode' => '靜態檔智慧處理',
    'apache-settings.nginxTransparentModeDescription' => '如果已被關閉，Apache 將會處理所有靜態檔的請求。nginx 會不做修改通過請求和回應。關閉此選項僅用於故障排除。',
    'apache-settings.nginxServeStatic' => '由 nginx 直接服務靜態檔',
    'apache-settings.nginxStaticExtensions' => '指定檔副檔名由空格或 "|" 符號隔開。對這些檔的請求將會由 nginx 進行處理不會到達 Apache。注意：Apache 覆蓋規則將不會被應用。',
    'apache-settings.nginxServePhp' => '由 nginx 處理 PHP',
    'apache-settings.nginxServePhpDescription' => 'PHP 文件 (.php) 將會由 nginx 和 PHP-FPM 處理。如果處於關閉狀態，PHP 將會由 Apache 進行處理。',
    'apache-settings.nginxClientMaxBodySize' => '允許的最大HTTP請求正文大小',
    'apache-settings.nginxClientMaxBodySizeDescription' => '主體超過限制的請求將被丟棄，因為HTTP 413 有效負載太大（配置"client_max_body_size" nginx 指令值）。',
    'apache-settings.nginxClientMaxBodySizeDisabled' => '選項通過panel.ini中的指令"clientMaxBodySize"的空/零值執行全域禁用',
    'apache-settings.nginxCacheEnabled' => '啟用 nginx 緩存',
    'apache-settings.nginxCacheEnabledDescription' => '緩存可能會減少網站回應時間和伺服器負載，但是需慎重使用。',
    'apache-settings.nginxCacheSize' => '緩存大小',
    'apache-settings.nginxCacheSizeGb' => 'GB',
    'apache-settings.nginxCacheSizeMb' => 'MB',
    'apache-settings.nginxCacheSizeKb' => 'KB',
    'apache-settings.nginxCacheSizeBytes' => 'B',
    'apache-settings.nginxCacheTimeout' => '緩存超時',
    'apache-settings.nginxCacheTimeoutDays' => '天',
    'apache-settings.nginxCacheTimeoutHours' => '小時',
    'apache-settings.nginxCacheTimeoutMinutes' => '分鐘',
    'apache-settings.nginxCacheTimeoutSeconds' => '秒',
    'apache-settings.nginxCacheKey' => '緩存金鑰',
    'apache-settings.nginxCacheCookies' => '使用 cookies 緩存請求',
    'apache-settings.nginxCacheBypassLocations' => '禁用位置緩存',
    'apache-settings.nginxCacheBypass' => '繞過緩存，當：',
    'apache-settings.nginxCacheBypassHeaderNocache' => '在請求中接收到了 HTTP no-cache 頭',
    'apache-settings.nginxCacheBypassHeaderAuth' => '在請求中接收到了 HTTP 授權頭',
    'apache-settings.nginxCacheBypassGetNocache' => '在請求中接收到了 GET nocache 參數',
    'apache-settings.nginxCacheUseStale' => '返回緩存過期記錄',
    'apache-settings.nginxCacheUseStale5xx' => 'Upstream 返回 5xx 伺服器錯誤',
    'apache-settings.nginxCacheUseStale4xx' => 'Upstream 返回 4xx 用戶端錯誤',
    'apache-settings.nginxCacheUseStaleUpdating' => '緩存正被更新',
    'apache-settings.additional' => '其他 Apache 指令。',
    'apache-settings.additionalSettingsDescription' => '如果您無法找到某些設定，可添加這些設定到以下欄位。這些設定將會覆蓋伺服器級的 Apache 指令。當訪客通過 HTTP 存取網站時則會應用第一欄位元的指令。第二欄位元則包含用於 HTTPS 的指令。一般來說您需要為兩個欄位元添加指令。請使用與 httpd.include 相同的句法。例如，如果您想要設定一個自訂錯誤頁面，可添加該行：ErrorDocument 401 /my_error_page.html',
    'apache-settings.additionalSettings' => 'HTTP 的其它指令',
    'apache-settings.additionalSslSettings' => 'HTTPS 的其它指令',
    'apache-settings.additionalSettingsError' => '無效的 Apache 配置： %%error%%',
    'apache-settings.rollbackFailed' => '無法使用當前的 Apache 設定檔且無法回滾到檔的原版本因為它們包含無效的配置。',
    'apache-settings.additionalNginx' => '其它 Nginx 指令',
    'apache-settings.additionalNginxSettingsDescription' => '您可在此為在 Apache 前端運行的 nginx 反向代理伺服器指定相應設定。您的指令將會覆蓋伺服器級的 nginx 配置。例如，可能想要更改連接逾時或使用 gzip 打包請求。請使用與 nginx.conf 相同的句法。例如，如果您想要使用 gzip 打包所有的代理請求，可添加行：\'gzip_proxied any;\'。',
    'apache-settings.additionalNginxSettings' => '其它 Nginx 指令',
    'apache-settings.additionalNginxSettingsError' => '無效的 Nginx 配置：%%error%%',
    'apache-settings.nginxRollbackFailed' => '無法使用當前的 nginx 設定檔並回滾至檔的原版本，因為它們都包含無效的配置。',
    'apache-settings.clearCache' => '清除緩存',
    'apache-settings.clearCacheHint' => '清除 %%website%% 的nginx緩存',
    'apache-settings.cacheHasClearedSuccessfuly' => '快取已成功清除',

    'backup.backup-password-protection.securitySettingsSection' => '備份安全設定',
    'backup.backup-password-protection.backupPasswordFromFtpSettings' => '從遠端存放的設定獲取密碼',
    'backup.backup-password-protection.backupPasswordManualInput' => '手動輸入密碼',
    'backup.backup-password-protection.providePasswordCheckbox' => '提供密碼',
    'backup.backup-password-protection.backupPassword' => '密碼',
    'backup.backup-password-protection.inputPasswordType' => '密碼類型',
    'backup.backup-password-protection.confirmBackupPassword' => '重複密碼',
    'backup.backup-password-protection.backupPasswordHint' => '如果您已忘記密碼，請清空此選項。注意在這樣的情況下一些敏感性資料不會正常恢復。例如，使用者密碼將會被一個任意密碼替換，有關已安裝的 APS 應用程式將會丟失，等等。',
    'backup.backup-password-protection.backupPasswordFtpHint' => '如果此備份有密碼保護，請在以下欄位輸入該密碼。注意如果您提供的密碼不正確，Plesk 將不會恢復該備份。而是會把備份複製到本機存放區中。',

    'backup.conflict-database.dbMappingLegend' => '資料庫伺服器映射',
    'backup.conflict-database.serverType' => '伺服器類型',
    'backup.conflict-database.hostName' => '主機名稱',
    'backup.conflict-database.port' => '埠',
    'backup.conflict-database.destinationDbServer' => '目的資料庫伺服器',
    'backup.conflict-database.mysql' => 'MariaDB/MySQL',
    'backup.conflict-database.postgresql' => 'PostgreSQL',
    'backup.conflict-database.mssql' => 'MS SQL中',
    'backup.conflict-database.migrationDbServerNotFind' => '資料庫無法被恢復：沒有合適的資料庫伺服器。',

    'backup.conflict-ip.buttonUploadMappingFile' => '上傳 IP 映射文件',
    'backup.conflict-ip.ipMappingLegend' => 'IP 映射',
    'backup.conflict-ip.buttonSaveCurrentMapping' => '保存當前IP映射到文件',
    'backup.conflict-ip.ipAddressNotFound' => '無此類可用 IP 地址。',
    'backup.conflict-ip.sharedIp' => '共用',
    'backup.conflict-ip.dedicatedIp' => '獨立',
    'backup.conflict-ip.fileNotFound' => '該檔不得為空。',
    'backup.conflict-ip.invalidIpToMap' => '舊 IP 位址的一個無效值：%%ip%%',
    'backup.conflict-ip.invalidMappingValue' => '新 IP 位址的一個無效值：%%ip%%',
    'backup.conflict-ip.ipNotFound' => '資料庫中未找到 IP 位址 %%ip%%。',
    'backup.conflict-ip.uploadIpMappingFileLegend' => '上傳 IP 映射文件',
    'backup.conflict-ip.ipMappingFileHint' => 'IP 映射文件是純文字文件。該檔的每一行都包含 IP 映射，其格式為：<old IP address> <new IP address>',
    'backup.conflict-ip.oldIp' => '舊 IP 地址',
    'backup.conflict-ip.newIp' => '新 IP 地址',

    'backup.copy-to-server.ignoreBackupSign' => '上傳沒有有效簽名的備份檔案',
    'backup.copy-to-server.wrongPassword' => '指定的密碼不正確。在備份恢復過程中，Plesk 將會提示您再次輸入密碼。',
    'backup.copy-to-server.corruptedSignatureUploaded' => '上傳的備份檔案 %%fileName%% 已在不支援簽名備份的其它伺服器或早期版本的 Plesk 上被修改、損壞、創建。要從該備份檔案恢復資料，請確認是否可以信任該檔源。',
    'backup.copy-to-server.corruptedSignatureNotUploadedUser' => '無法上傳備份檔案 %%fileName%%。該檔包含已修改或已損壞的資料，或該檔是在其它伺服器或更早版本的 Plesk 上創建的。要從該檔案修復恢復資料，請聯繫您的主機提供商。',
    'backup.copy-to-server.corruptedSignatureNotUploadedAdmin' => '無法上傳備份檔案 %%fileName%%。檔已在不支援簽名備份的其它伺服器或早期版本的 Plesk 上被修改、損壞、創建。如果您信任該備份，那麼請選擇“上傳沒有有效簽名的備份檔案”選項並再次上傳。',
    'backup.copy-to-server.unableToMoveToLocalRepository' => "無法移動所選備份 %%fileName%% 到伺服器存儲。錯誤：%%error%%.",
    'backup.copy-to-server.missedPartsWarning' => "增量備份的以下部分未被複製：%%endl%%%%missedParts%%%%endl%%請複製丟失的部分。",

    'backup.ftp-settings.isActive' => '使用 FTP(S) 存儲',
    'backup.ftp-settings.host' => 'FTP伺服器主機名稱或IP',
    'backup.ftp-settings.directory' => '備份檔案存放目錄',
    'backup.ftp-settings.directoryHint' => '如/myfolder/mybackups/',
    'backup.ftp-settings.ftpLogin' => 'FTP 用戶名',
    'backup.ftp-settings.ftpPassword' => 'FTP密碼',
    'backup.ftp-settings.usePassiveMode' => '使用被動模式',
    'backup.ftp-settings.useFtps' => '使用 FTPS',
    'backup.ftp-settings.errorHostIsLocal' => '禁止使用本地 Plesk 的 FTP 伺服器作為遠端存放。請指定一個遠端位址。',
    'backup.ftp-settings.warningHostIsLocal' => '已配置FTP(S) 存儲設定，以存儲訂閱檔所在的伺服器上的備份。由於存在資料丟失和硬碟過度使用的風險，不建議這樣的配置。',
    'backup.ftp-settings.enterFtpLogin' => '輸入正確的用戶名。',
    'backup.ftp-settings.enterFtpPassword' => '輸入正確的密碼。',

    'backup.remote-settings.isActive' => '使用存儲',
    'backup.remote-settings.initError' => '無法初始化 %%extName%% 設定頁面：%%error%%',

    'backup.remote-storages.backupSecuritySettings' => '備份安全設定',

    'backup.restore.detailsSection' => '詳情',
    'backup.restore.contentInfoSection' => '備份內容',
    'backup.restore.restorationOptionsSection' => '恢復選項',
    'backup.restore.emailNotification' => '恢復任務結束時，發送通知到',
    'backup.restore.comments' => '備註',
    'backup.restore.creationDate' => '創建日',
    'backup.restore.systemNotes' => '系統日誌',
    'backup.restore.ownerAdmin' => '由管理員創建的。',
    'backup.restore.ownerReseller' => '由代理商創建的。',
    'backup.restore.ownerCustomer' => '由客戶創建的。',
    'backup.restore.ownerServiceUser' => '由其他的用戶創建。',
    'backup.restore.partOfParentBackup' => '%%type%% 備份的一部分。',
    'backup.restore.server' => '伺服器',
    'backup.restore.reseller' => '代理商',
    'backup.restore.client' => '客戶',
    'backup.restore.incremental' => '增量',
    'backup.restore.multiVolume' => '多卷宗',
    'backup.restore.backupSize' => '備份大小',
    'backup.restore.backupSizeFirstIncremental' => '%%this%%（該備份）+ %%base%%（初始備份）= %%total%%',
    'backup.restore.backupSizeIncremental' => '%%this%%（該備份）+ %%prev%%（之前的備份）+ %%base%%（初始備份）= %%total%%',
    'backup.restore.download' => '下載',
    'backup.restore.downloadHint' => '下載備份檔案到您的本地電腦。',
    'backup.restore.downloadDisabled' => '暫時無法下載備份檔案。請稍候再試或聯繫您的服務提供者。',
    'backup.restore.copy' => '複製到伺服器存儲',
    'backup.restore.copyHint' => '複製所選備份檔案到伺服器存儲。',
    'backup.restore.contentInfo' => '備份內容',
    'backup.restore.restoreButton' => '恢復',
    'backup.restore.mail' => '郵件',
    'backup.restore.domainConfiguration' => '域名配置',
    'backup.restore.virtualHost' => '虛擬主機內容',
    'backup.restore.database' => '資料庫',
    'backup.restore.serverConfiguration' => '伺服器設定',
    'backup.restore.serverConfigurationLicense' => '許可證金鑰',
    'backup.restore.serverPersonalConfiguration' => '管理員帳戶配置',
    'backup.restore.serverPersonalDomains' => '管理員域名',
    'backup.restore.serverPersonalClients' => '管理員客戶',
    'backup.restore.resellers' => '代理商',
    'backup.restore.resellerPersonalConfiguration' => '代理商帳戶配置',
    'backup.restore.resellerPersonalDomains' => '代理商域名',
    'backup.restore.resellerPersonalClients' => '代理商客戶',
    'backup.restore.clientPersonalConfiguration' => '客戶帳戶配置',
    'backup.restore.clientPersonalDomains' => '客戶域名',
    'backup.restore.restoreModifiedSection' => '儘管簽名損壞仍恢復備份檔案',
    'backup.restore.restoreModifiedDump' => '儘管沒有有效的簽名仍然恢復該備份',
    'backup.restore.resolutionPolicy' => '解決策略',
    'backup.restore.resolutionPolicyDescription' => '計時衝突出現情況: 當恢復對象已在系統中，且新近修改日期更接近，或恢復對象當前沒有出現在系統中。',
    'backup.restore.backupRestoreFtpWrongPassword' => '指定的密碼不正確。將不會複製該備份檔案至伺服器的本機存放區。',
    'backup.restore.backupRestoreLocalWrongPassword' => '無法恢復備份。指定的密碼不正確。',
    'backup.restore.serverContentAndConfiguration' => '伺服器配置及內容',
    'backup.restore.serverConfigurationOnly' => '伺服器配置',
    'backup.restore.resellerContentAndConfiguration' => '代理商帳戶配置及內容',
    'backup.restore.resellerConfigurationOnly' => '代理商帳戶配置',
    'backup.restore.clientContentAndConfiguration' => '客戶帳戶配置及內容',
    'backup.restore.clientConfigurationOnly' => '客戶帳戶配置',
    'backup.restore.domainContentAndConfiguration' => '域名配置與內容',
    'backup.restore.domainConfigurationOnly' => '域名配置',
    'backup.restore.restoreType' => '您想要恢復什麼？',
    'backup.restore.restoreTypeFull' => '所有對象（整個系統）',
    'backup.restore.restoreTypeGranular' => '選定的對象',
    'backup.restore.restoreObjectType' => '要恢復的對象的類型',
    'backup.restore.restoreObjectTypeSubscriptions' => '訂閱',
    'backup.restore.restoreObjectTypeCustomers' => '客戶',
    'backup.restore.restoreObjectTypeResellers' => '代理商',
    'backup.restore.restoreObjectTypeMailUsers' => '郵件帳戶',
    'backup.restore.restoreObjectTypeDatabases' => '資料庫',
    'backup.restore.restoreObjectTypeCertificates' => 'SSL/TLS 證書',
    'backup.restore.restoreObjectTypeSites' => '網站',
    'backup.restore.restoreObjectTypeDnsZones' => 'DNS 區域',
    'backup.restore.restoreObjectTypeMailLists' => '郵寄清單',
    'backup.restore.restoreObjectTypeWebContent' => '域名的文件',
    'backup.restore.restoreObjects' => '%%objectType%%',
    'backup.restore.restoreObjectsWebContent' => '選擇檔',
    'backup.restore.restoreSubscriptionLookup' => '訂閱',
    'backup.restore.restoreComponents' => '要恢復的組件',
    'backup.restore.errorLog' => '錯誤日誌',
    'backup.restore.backupDetailsLogDoesntExist' => '備份日誌不可用。',
    'backup.restore.dumpFailedSection' => '錯誤日誌',
    'backup.restore.dumpFailed' => '無法恢復資料：該備份檔案無效。',
    'backup.restore.granularNotSupported' => '您可以選擇僅當恢復在 Plesk 12.0 或更新版本中創建的備份時要恢復的對象。',
    'backup.restore.fullNotSupportedInResellerPowerUser' => '在代理商高級使用者視圖中不支援從備份恢復所有資料。選擇用於恢復的對象。您可以在 %%interfaceLink%% 中修改您的介面視圖',
    'backup.restore.interfaceLink' => '介面偏好設定',
    'backup.restore.contentRestoreType' => '恢復',
    'backup.restore.contentRestoreTypeSettingsOnly' => '僅被選定對象的配置',
    'backup.restore.contentRestoreTypeFull' => '被選定對象的配置和內容',
    'backup.restore.errorWrongFormat' => '無法恢復備份：該檔包含錯誤格式。',
    'backup.restore.errorContentError' => '並非所有資料都可以恢復：備份包含內容錯誤。',
    'backup.restore.warningSignError' => '無法驗證備份簽名。備份檔案可能是在其它伺服器或早期版本的 Plesk 上被修改過、損壞過或創建的。',
    'backup.restore.warningSignErrorNotAdmin' => '只有 Plesk 管理員才能恢復該備份。',
    'backup.restore.warningPartial' => "未找到增量備份的以下部分：%%endl%%%%missedParts%%%%endl%%可能不會恢復所有檔。請上傳丟失的部分然後再嘗試恢復。",
    'backup.restore.warningDeprecatedBackupVersion' => '您要嘗試恢復的備份是在不支援的 Plesk 版本中創建的，因而不能恢復。請使用 Plesk Migrator 擴展從舊的 Plesk 版本遷移您的資料。',
    'backup.restore.encryptionKeyError' => '該備份中的一個或多個帳戶的密碼無法被恢復且將要被重設。可能該備份是在其它 Plesk 伺服器上創建的且使用加密金鑰加密。',
    'backup.restore.errorCorruptedContent' => '下列檔找不到或已損壞：  ',
    'backup.restore.statusSection' => '備份狀態',
    'backup.restore.statusDetails' => '狀態詳情',
    'backup.restore.restoreBlocked' => '該備份無法被恢復。',
    'backup.restore.restoreBlockedDescription' => '現在無法恢復備份類型 %%backupType%%。若要進行恢復，請以備份所有者的身份登入並在備份管理員中點按該備份名稱。',

    'backup.schedule.scheduleSection' => '計畫',
    'backup.schedule.backupEnable' => '啟動此備份任務',
    'backup.schedule.backupPeriod' => '運行此備份任務',
    'backup.schedule.on' => '打開',
    'backup.schedule.at' => '在',
    'backup.schedule.every' => '每',
    'backup.schedule.hours' => '{period, plural, other {小時}}',
    'backup.schedule.retainHours' => '小時',
    'backup.schedule.useIncremental' => '使用增量式備份',
    'backup.schedule.useIncrementalDisableHint' => '已選的備份內容僅能用於建立完整的備份。',
    'backup.schedule.fullBackupPeriod' => '執行全量備份',
    'backup.schedule.hourly' => '小時計',
    'backup.schedule.daily' => '每日',
    'backup.schedule.weekly' => '每週',
    'backup.schedule.monthly' => '每月',
    'backup.schedule.yearly' => '每年',
    'backup.schedule.days' => '天',
    'backup.schedule.weeks' => '星期',
    'backup.schedule.months' => '月',
    'backup.schedule.years' => '年',
    'backup.schedule.backupTimeDescription' => '時區：%%timezone%%。',
    'backup.schedule.systemTimeZone' => '系統默認時區',
    'backup.schedule.first' => '首頁',
    'backup.schedule.last' => '最後',
    'backup.schedule.dayOfMonth' => '日',
    'backup.schedule.email' => '如果在執行此計畫備份任務的過程中出現任何錯誤，則會發送通知到',
    'backup.schedule.invalidFields' => '一些欄位為空或者含有無效值：%%fields%%。',
    'backup.schedule.maxDumpFiles' => '可存儲的全量備份檔案的最大數量（包括計畫的和手動的備份）',
    'backup.schedule.retainDumpFilesFor' => '完整備份保留：',
    'backup.schedule.maxDumpFilesUnlimitedDescription' => '如果您不想自動移除全量備份請保留該欄位為空。',
    'backup.schedule.maxDumpFilesLimitedDescription' => '主機提供商指定的伺服器存儲限制值為 %%max%%。您為其指定的限制值必須低於或等於 %%max%%。',
    'backup.schedule.retainLimitedDescription' => '主機服務提供者指定的伺服器儲存空間限制為 {max, plural, other {# 完全備份}}（包含所有預定及手動備份）。',
    'backup.schedule.backupToCloudIsNotAllowed' => '在遠端雲存儲中存儲定期訂閱備份是一項高級功能，可以在Plesk線上商店中進行購買。',
    'backup.schedule.backupHourlyWarning' => '啟用小時計備份可能導致伺服器資源消耗量變多。',
    'backup.schedule.titleHourly' => '小時計備份設定',
    'backup.schedule.titleDaily' => '每日備份設定',
    'backup.schedule.titleWeekly' => '每週備份設定',
    'backup.schedule.titleMonthly' => '每月備份設定',
    'backup.schedule.titleCustom' => '自訂備份設定',

    'backup.secure-backup.hint' => '您可以在備份中使用一個密碼加密包含在 Plesk 資料庫中的使用者密碼。注意在沒有提供密碼的情況下恢復受密碼保護的備份會導致 Plesk 任意生成使用者密碼。',
    'backup.secure-backup.hintAdmin' => '您可以使用 Plesk 加密金鑰或一個密碼加密包含在備份中的 Plesk 資料庫密碼。此金鑰對於每個 Plesk 安裝實例都是唯一的。使用金鑰加密的備份只能在創建這些備份的 Plesk 安裝實例中恢復而不能在其它的 Plesk 安裝實例中恢復。請注意 Plesk 不會保護備份中所有的敏感性資料。我們建議您將備份保存在遠端的雲存儲系統中並在雲存儲系統端啟用備份加密。',
    'backup.secure-backup.usePasswordProtection' => '使用密碼保護（推薦）',
    'backup.secure-backup.backupPasswordSource' => '密碼類型',
    'backup.secure-backup.pleskKey' => 'Plesk 的加密金鑰',
    'backup.secure-backup.userPassword' => '指定的密碼',
    'backup.secure-backup.password' => '密碼',
    'backup.secure-backup.passwordConfirmation' => '重複密碼',

    'backup.subform.settingsSection' => '備份設定',
    'backup.subform.prefix' => '添加首碼到備份名',
    'backup.subform.comment' => '備註',
    'backup.subform.splitSize' => '創建多卷宗備份，卷宗大小 (MB)',
    'backup.subform.repository' => '存儲於',
    'backup.subform.repositoryDescription' => 'FTP(S) 存儲設定未指定。%%configure%%',
    'backup.subform.localAndSpecialRepositoryBackup' => '伺服器存儲和 %%name%%',
    'backup.subform.remoteRepositoryOption' => '遠端存放',
    'backup.subform.remoteRepository' => '遠端存放',
    'backup.subform.remoteRepositoryText' => '選擇遠端的雲存儲',
    'backup.subform.configureRemoteRepositories' => '<a href="%%url%%">配置遠端存放</a>以將您的備份內容儲存至雲端。',
    'backup.subform.configureFtpRepository' => '<a href="%%url%%">配置 FTP 儲存</a>以離線儲存您的備份內容。',
    'backup.subform.configureRemoteDesc' => '%%link%% 以將您的備份保留至雲端。',
    'backup.subform.configureRemoteLink' => '配置遠端儲存',
    'backup.subform.configureFtpDesc' => '%%link%% 以離線保留您的備份。',
    'backup.subform.configureFtpLink' => '配置 FTP 存儲',
    'backup.subform.repositoryConfigure' => '配置',
    'backup.subform.email' => '當備份任務結束時，發送通知郵件到',
    'backup.subform.contentSection' => '備份內容',
    'backup.subform.domainConfiguration' => '配置',
    'backup.subform.domainConfigurationVhost' => '使用者檔與資料庫',
    'backup.subform.domainConfigurationFile' => '使用者檔案',
    'backup.subform.domainConfigurationDatabase' => '資料庫',
    'backup.subform.domainConfigurationMail' => '郵件資訊',
    'backup.subform.content' => '備份',
    'backup.subform.backupAll' => '所有配置及內容',
    'backup.subform.backupConfiguration' => '僅配置',
    'backup.subform.backupVhost' => '除郵件消息外的所有配置和內容',
    'backup.subform.backupMailFile' => '除使用者資料庫外的所有配置和內容',
    'backup.subform.backupMailDatabase' => '除使用者檔案外的所有配置和內容',
    'backup.subform.backupMail' => '僅配置和郵件資訊',
    'backup.subform.backupDatabase' => '僅配置和使用者資料庫',
    'backup.subform.backupFile' => '僅配置和使用者檔案',
    'backup.subform.mssqlNativeBackup' => '如果可能請使用本地 MS SQL 備份功能',
    'backup.subform.mssqlNativeBackupAdmin' => '請使用本地 MS SQL 備份功能（對於遠端資料庫，請確保您已在 工具與設定> 資料庫伺服器 中配置了遠端 MS SQL 伺服器的備份設定）',
    'backup.subform.localRepository' => '伺服器存儲',
    'backup.subform.localRepositoryPath' => '位於 %%path%% 的伺服器存儲',
    'backup.subform.backupNodeRepository' => '',
    'backup.subform.ftpRepository' => '位於%%uri%% 的FTP(S) 存儲<a href="%%link%%">Change Settings</a>',
    'backup.subform.ftpRepositoryText' => '位於 %%uri%% 的 FTP(S) 存儲',
    'backup.subform.type' => '類型',
    'backup.subform.typeFullBackup' => '全量',
    'backup.subform.typeIncremental' => '增量',
    'backup.subform.typeIncrementalDescription' => '備份自上次備份起已被更改的網站和郵件主機資料（資料庫資料總是會全量備份）。',
    'backup.subform.incrementalNotAvailable' => '若要創建增量備份，請首先創建全量備份。',
    'backup.subform.excludeLogs' => '排除日誌檔',
    'backup.subform.excludeFiles' => '排除備份指定的檔',
    'backup.subform.excludeFilesDescription' => '您只能排除主機空間內的檔。指定與主機空間根目錄的相對路徑，以逗號隔開各個檔。允許使用面具標誌（例如：/somedir/log*）。',

    'backup.upload.uploadHint' => '在此處您可上傳備份檔案到 Plesk 存儲。最大檔容量限於 2 GB。',
    'backup.upload.backupFile' => '備份檔案',
    'backup.upload.removeLink' => '移除',
    'backup.upload.addFileLink' => '上傳更多檔',
    'backup.upload.backupSecuritySettings' => '備份安全設定',
    'backup.upload.signatureHint' => 'Plesk 會查看備份檔案是否有有效的結構和簽名。在其它伺服器上修改、損壞或創建的文件不可信。下面的選項能夠讓您從此類檔案修復資料。只有在您信任備份源的情況下才選擇此選項，因為上傳此類檔可能會給安全帶來隱患或影響伺服器的操作。注意：在早於 11.5 版本的 Plesk 中所做的備份檔案會被視作不可信任備份檔案，因為沒有簽名。如果您信任該檔源請務必恢復此類檔。',
    'backup.upload.ignoreSign' => '上傳沒有有效簽名的備份檔案',
    'backup.upload.passwordHint' => '如果此備份有密碼保護，請在以下欄位輸入該密碼。注意如果輸入的密碼不正確，Plesk 將給以警告但仍會上傳備份到伺服器。然而，在恢復備份的過程中，會提示再次輸入該密碼。',
    'backup.upload.alreadyExistsWarning' => '該備份檔案 %%fileName%% 已經存在於伺服器的本機存放區中。',
    'backup.upload.incorrectPasswordWarning' => '指定的密碼不正確。在備份恢復過程中，Plesk 將會提示您再次輸入密碼。',
    'backup.upload.deprecatedDumpError' => '您要嘗試上傳的備份是在不支援的 Plesk 版本中創建的，因而不能導入。請使用 Plesk Migrator 擴展從舊的 Plesk 版本遷移您的資料。',
    'backup.upload.mailFormatWarning' => '備份檔案 %%fileName%% 已被上傳到存儲中。重要說明：備份檔案 %%fileName%% 包含無法恢復的郵件內容，因為其格式 (Plesk 8.3 - 8.6) 不被支援。要恢復該郵件內容，使用 Plesk 備份工具對其備份，請選擇選項 備份郵箱內容，並選擇選項 恢復轉儲至任何郵件伺服器。',
    'backup.upload.corruptedSignatureAdminWarning' => '上傳的備份檔案 %%fileName%% 已在不支援簽名備份的其它伺服器或早期版本的 Plesk 上被修改、損壞、創建。要從該備份檔案恢復資料，請確保是否可以信任該檔源。',
    'backup.upload.corruptedSignatureAdminError' => '無法上傳備份檔案 (%%fileName%%)。檔已在不支援簽名備份的其它伺服器或早期版本的 Plesk 上被修改、損壞、創建。如果您信任該備份，那麼請選擇“上傳沒有有效簽名的備份檔案”選項並再次上傳。',
    'backup.upload.corruptedSignatureUserWarning' => '上傳的備份檔案 (%%fileName%%) 包含已修改或已損壞的資料，或該檔是在其它伺服器或更早版本的 Plesk 上創建的。',
    'backup.upload.corruptedSignatureUserError' => '無法上傳備份檔案 (%%fileName%%)。該檔包含已修改或已損壞的資料，或該檔是在其它伺服器或更早版本的 Plesk 上創建的。要從該檔案修復恢復資料，請聯繫您的主機提供商。',
    'backup.upload.uploadError' => '無法上傳 %%fileName%% 到伺服器存儲：%%error%%',
    'backup.upload.fileNotSelected' => '沒有選定要上傳的檔。至少選擇一個檔。',
    'backup.upload.missedPartsWarning' => "增量備份的以下部分未被上傳：%%endl%%%%missedParts%%%%endl%%請上傳丟失的部分。",
    'backup.upload.unknownType' => '未知的對象類型',
    'backup.upload.storageLink' => '其它存儲',
    'backup.upload.anotherStorage' => '轉儲已被上傳至 %%storageLink%%。',
    'backup.upload.resellerNotFound' => '未找到代理商 %%name%%。請首先創建它以恢復已上傳的轉儲。',
    'backup.upload.clientNotFound' => '未找到客戶 %%name%%。請首先創建它以恢復已上傳的轉儲。',
    'backup.upload.domainNotFound' => '未找到域名 %%name%%。請首先創建它以恢復已上傳的轉儲。',

    'backup.web-content-dynamic.addButtonTitle' => '添加文件',
    'backup.web-content-dynamic.noItems' => '無選定的文件',
    'backup.web-content-dynamic.hint' => '勾選核取方塊選擇檔和資料夾。',
    'backup.web-content-dynamic.title' => '選擇檔',
    'backup.web-content-dynamic.columnName' => '名稱',
    'backup.web-content-dynamic.columnChangeDate' => '修改日期',
    'backup.web-content-dynamic.columnSize' => '大小',
    'backup.web-content-dynamic.columnPermissions' => '許可權',
    'backup.web-content-dynamic.columnUser' => '用戶',
    'backup.web-content-dynamic.columnGroup' => '組',
    'backup.web-content-dynamic.waitButtonTitle' => '請稍候',
    'backup.web-content-dynamic.loadingTitle' => '請稍候。正在載入...',

    'backup.invalidFields' => '一些欄位為空或者含有無效值。',
    'backup.notEnoughDiskSpace' => '%%path%% 沒有足夠的磁碟空間用於備份創建。至少需要 %%required%% GB 可用空間（%%available%% GB 可用）',

    'change-subscriptions-owner.ownerSection' => '新所有者',
    'change-subscriptions-owner.subscriptionsSection' => '所選訂閱',
    'change-subscriptions-owner.owner' => '所有者',
    'change-subscriptions-owner.subscriptionName' => '訂閱',
    'change-subscriptions-owner.ownerName' => '所有者',
    'change-subscriptions-owner.currentIpAddress' => '目前 IP 位址',
    'change-subscriptions-owner.newIpAddress' => '新 IP 地址',
    'change-subscriptions-owner.noIpAddress' => '無可用的 IP 位址',
    'change-subscriptions-owner.submit' => '重新分配',
    'change-subscriptions-owner.warningCustom' => "即將取消訂閱目前的服務方案，並改為「自訂」。",
    'change-subscriptions-owner.warningEmptyPool' => "新所有者提供商的 IP 池為空。請確保提供商的 IP 池中至少有一個 IP 位址。",

    'cgroups-settings.cgroupsSettingsTab' => 'RAM 記憶體、CPU、磁片 I/O',
    'cgroups-settings.cgroupsSettingsTabDescription' => '對訂閱所消耗的系統資源設定限制。Plesk 會使用名為控制組群 (cgroups) 的 Linux 內核功能來確保不會超過限制。',
    'cgroups-settings.cpuSettings' => 'CPU',
    'cgroups-settings.cpuSettingsDescription' => '限制單個訂閱只能使用指定量的 CPU。',
    'cgroups-settings.cpuPeriodLimit' => '檢查 CPU 使用量的時段',
    'cgroups-settings.percentUsageDescription' => 'CPU 總時間等於您伺服器的 %%total%%%%units%%',
    'cgroups-settings.ramSettings' => 'RAM 記憶體',
    'cgroups-settings.ramSettingsDescription' => '限制單個訂閱只能使用指定量的 RAM 記憶體。注意如果訂閱超過該限制，消耗大部分記憶體的進程將會被停止。',
    'cgroups-settings.ramPeriodLimit' => '檢查記憶體使用量的時段',
    'cgroups-settings.diskSettings' => '磁片 I/O',
    'cgroups-settings.diskReadSettings' => '磁片讀取',
    'cgroups-settings.diskReadSettingsDescription' => '允許單個訂閱只能使用指定限制內的磁片讀取頻寬。',
    'cgroups-settings.diskReadPeriodLimit' => '檢查磁片讀取使用量的時段',
    'cgroups-settings.diskWriteSettings' => '磁片寫入',
    'cgroups-settings.diskWriteSettingsDescription' => '允許單個訂閱只能使用指定限制內的磁片寫入頻寬。',
    'cgroups-settings.diskWritePeriodLimit' => '檢查磁片寫入使用量的時段',
    'cgroups-settings.limit' => '限制',
    'cgroups-settings.threshold' => '超過時通知',
    'cgroups-settings.limitNotificationEnabled' => '通知已啟用',
    'cgroups-settings.periodFiveMinutes' => '5 分鐘',
    'cgroups-settings.periodHour' => '1 小時',
    'cgroups-settings.periodDay' => '1 日（24 小時）',
    'cgroups-settings.mb' => 'MB',
    'cgroups-settings.mbs' => 'MB/秒',

    'custom-button.privateLabel' => '僅向我顯示',
    'custom-button.textLabel' => '按鈕標籤',
    'custom-button.tooltipLabel' => '工具提示文本',
    'custom-button.iconLabel' => '背景圖片',
    'custom-button.priorityLabel' => '優先順序',
    'custom-button.urlLabel' => 'URL',
    'custom-button.urlParamsLabel' => '添加參數到 URL',
    'custom-button.placeLabel' => '位置',
    'custom-button.internalLabel' => '在 Plesk 中打開 URL',
    'custom-button.internalDescription' => '指定是否在 Plesk 頁面上或新的瀏覽器視窗中打開 URL。',
    'custom-button.noFrameLabel' => '不要使用幀',
    'custom-button.noFrameDescription' => '如果您添加一個引向客戶面板中的 Plesk 擴展或應用程式的自訂按鈕，您可指定該擴展/應用程式顯示的方式：在幀中或作為 Plesk GUI 的一部分。',
    'custom-button.urlParamLabel_dom_id' => '包括訂閱 ID、域名 ID 和域名別名 ID',
    'custom-button.urlParamLabel_dom_name' => '包括主域名',
    'custom-button.urlParamLabel_ftp_user' => '包含FTP用戶名',
    'custom-button.urlParamLabel_ftp_pass' => '包含FTP密碼',
    'custom-button.urlParamLabel_cl_id' => '包含客戶ID',
    'custom-button.urlParamLabel_cname' => '包含客戶的公司名稱',
    'custom-button.urlParamLabel_pname' => '包含客戶的聯繫名稱',
    'custom-button.urlParamLabel_email' => '包含客戶的電子郵箱',
    'custom-button.buttonPlace_navigation' => '通用存取',
    'custom-button.buttonPlace_admin' => '管理員首頁',
    'custom-button.buttonPlace_admin-settings' => '管理員的 工具與設定 頁面',
    'custom-button.buttonPlace_reseller' => "代理商首頁",
    'custom-button.buttonPlace_reseller-settings' => '代理商的 工具與實用程式 頁面',
    'custom-button.buttonPlace_client' => '客戶首頁',
    'custom-button.buttonPlace_domain' => "訂閱的 網站與域名 頁面",
    'custom-button.buttonPlace_domain_powerUser' => "主機空間的 網站與域名 頁面",
    'custom-button.buttonPlace_domain-properties' => '網站工具',

    'database-server-change-password.adminPassword' => '管理員密碼',
    'database-server-change-password.success' => '已經成功更新管理員密碼。',

    'database-server-create.general' => '常用',
    'database-server-create.type' => '資料庫伺服器類型',
    'database-server-create.unixSocket' => '(本地連接)',
    'database-server-create.host' => '主機名稱稱或 IP 地址',
    'database-server-create.port' => '埠號',
    'database-server-create.portDescription' => '將默認埠號保留為空',
    'database-server-create.version' => '資料庫伺服器版本',
    'database-server-create.default' => '使用此伺服器作為 %%type%% 的默認伺服器',
    'database-server-create.externalConnections' => '允許本端 MariaDB/MySQL 伺服器接受外部連線',
    'database-server-create.externalConnectionsDescription' => '變更此設定導致本端 MariaDB/MySQL 伺服器重新啟動。如需啟用在 Plesk 遠端存取其他 MariaDB/MySQL 伺服器的功能，請手動變更其設定。',
    'database-server-create.authentication' => '驗證',
    'database-server-create.authenticationAddDescription' => '指定 Plesk 將用於存取資料庫伺服器的資料庫管理員驗證憑據。在資料庫伺服器上必須存在帶有這些驗證憑據的管理員帳戶。',
    'database-server-create.authenticationEditDescription' => '在此處您可以更改 Plesk 將用於存取資料庫伺服器的驗證憑據。這些驗證憑據必須匹配資料庫管理員的驗證憑據。例如，您在資料庫伺服器上更改了管理員驗證憑據後，有必要在 Plesk 中對其進行相應更改。',
    'database-server-create.authenticationChangeDescription' => '在此處您可以更改 Plesk 將用於存取資料庫伺服器的驗證憑據。如果您修改下面的用戶名和密碼，將會在資料庫伺服器上和 Plesk 中同時更新帶有管理許可權的資料庫使用者帳戶。',
    'database-server-create.adminLogin' => '用戶名',
    'database-server-create.adminPassword' => '密碼',
    'database-server-create.createSuccess' => '資料庫伺服器已成功建立。',
    'database-server-create.createError' => '創建了資料庫伺服器，但出現錯誤：%%error%%',
    'database-server-create.updateSuccess' => '資料庫伺服器已成功更新。',
    'database-server-create.updateError' => '資料庫伺服器已更新，但出現錯誤：%%error%%。',
    'database-server-create.backupSettings' => '備份',
    'database-server-create.backupTempDir' => '臨時目錄',
    'database-server-create.backupTempDirDescription' => '進入 MS SQL 伺服器所在的遠端伺服器上的物理資料夾的路徑。該 MS SQL 伺服器必須能夠存取該資料夾以讀取和寫入臨時備份檔案。例如，C:\\DirectoryPath',
    'database-server-create.backupNetworkTempDir' => '臨時網路目錄',
    'database-server-create.backupNetworkTempDirDescription' => '網路共用的路徑被映射到以上指定的物理資料夾。Plesk 將會存取共用資料夾以下載和上傳備份檔案。例如，\\\\ServerName\\DirectoryPath',
    'database-server-create.backupNetworkUser' => '用戶名',
    'database-server-create.backupNetworkUserDescription' => '在遠端伺服器上創建的網路使用者的用戶名。例如，ServerName\\UserName。該用戶必須有存取以上指定的共用資料夾的許可權。',
    'database-server-create.backupNetworkPassword' => '密碼',

    'domain.connection-info.title' => '連接資訊',
    'domain.connection-info.systemUserCredentials' => '系統使用者驗證憑據',
    'domain.connection-info.systemUserCredentialsHint' => '總是啟用通過 FTP 進行存取，通過 SSH 或遠端桌面進行存取 — 只有在 %%details%% 的情況下。',
    'domain.connection-info.systemUserCredentialsHintDetails' => '已授予許可權',
    'domain.connection-info.systemUserRemoveAccessEnabled' => '已啟用您的 SSH 或遠端桌面存取功能，您無法管理其狀態。',
    'domain.connection-info.systemUserRemoveAccessDisabled' => '已禁用您的 SSH 或遠端桌面存取功能，您無法管理其狀態。',
    'domain.connection-info.ipAddress' => 'IP 地址',
    'domain.connection-info.username' => '用戶名',
    'domain.connection-info.password' => '密碼',
    'domain.connection-info.changeSystemUserPasswordTitle' => '系統使用者密碼更改',
    'domain.connection-info.changePasswordTooltip' => '更改密碼',
    'domain.connection-info.newPassword' => '新密碼',
    'domain.connection-info.manageAccess' => '管理存取',
    'domain.connection-info.additionalFtpAccounts' => '其它 FTP 帳戶',
    'domain.connection-info.database' => '資料庫',
    'domain.connection-info.databaseHint' => '屬於訂閱的 %%number%% 中的1個資料庫。',
    'domain.connection-info.databaseNotCreatedHint' => '未創建資料庫。',
    'domain.connection-info.databaseType.mysql' => 'MySQL',
    'domain.connection-info.databaseType.mssql' => 'MS SQL Server',
    'domain.connection-info.databaseType.postgresql' => 'PostgreSQL',
    'domain.connection-info.databaseType.mariadb' => 'MariaDB',
    'domain.connection-info.databaseType.percona' => 'Percona',
    'domain.connection-info.databaseHost' => '主機',
    'domain.connection-info.databaseHostValue' => '%%value%% (%%fork%%)',
    'domain.connection-info.databaseName' => '資料庫名稱',
    'domain.connection-info.addDatabase' => '添加資料庫',
    'domain.connection-info.manageDatabases' => '管理資料庫',
    'domain.connection-info.phpMyAdmin' => 'phpMyAdmin',
    'domain.connection-info.changeDatabaseUserPasswordTitle' => '資料庫使用者密碼更改',
    'domain.connection-info.changeDatabaseUserPasswordNotice' => '不要忘記在此處更改應用程式後更新其設定檔中的密碼。',
    'domain.connection-info.buttonSave' => '保存',
    'domain.connection-info.buttonSaving' => '正在保存......',
    'domain.connection-info.buttonCancel' => '取消',

    'domain.move.title' => '移動域名 %%name%%',
    'domain.move.hint' => '域名將連同其內容、設定檔、日誌檔和 APS 應用程式一起被移動到新訂閱。',
    'domain.move.hintMain' => '域名將與其內容、設定檔、日誌檔、資料庫、資料庫使用者、其它 FTP 使用者、計畫任務、smb 使用者和 APS 應用程式一同被移動到新的訂閱。',
    'domain.move.hintSubdomains' => '子域名 %%subdomains%% 將與父級域名一起移動。',
    'domain.move.hintAliases' => '域名別名 %%aliases%% 將與父級域名一起移動。',
    'domain.move.hintSubdomainsAndAliases' => '子域名 %%subdomains%% 和域名別名 %%aliases%% 將與父級域名一起移動。',
    'domain.move.labelDatabases' => '您移動了域名後，請打開 "資料庫" 標籤以移動相關聯的資料庫。',
    'domain.move.hintDatabases' => '如有必要，請單獨移動資料庫。',

    'domain.move.Form.submitButton' => '移動',
    'domain.move.Form.cancelButton' => '取消',

    'domain.move.selectTarget' => '可用的訂閱',
    'domain.move.nothingFound' => '未找到任何項',
    'domain.move.targetIsRequred' => '選擇要將域名移動到的訂閱。',
    'domain.move.selectNewSubscription' => '創建一個新訂閱',
    'domain.move.ipv4Address' => 'IPv4 地址',
    'domain.move.ipv4AddressHint' => '託管網站的 IP 位址是網站的虛擬主機的網路位址。',
    'domain.move.ipv6Address' => 'IPv6 地址',
    'domain.move.ipv6AddressHint' => '託管網站的 IP 位址是網站的虛擬主機的網路位址。',
    'domain.move.ipAddressIsNotSelected' => '必須至少選定一個 IP 位址。',
    'domain.move.username' => '用戶名',
    'domain.move.usernameHint' => '系統使用者帳戶與主機空間建立關聯。 用於通過 FTP 和 SSH 存取託管的檔。',
    'domain.move.usernameIsRequred' => '您必須要提供用戶名。',
    'domain.move.password' => '密碼',
    'domain.move.passwordIsRequred' => '您必須要提供密碼。',
    'domain.move.noAvailableSubscriptions' => '沒有可用的訂閱',
    'domain.move.noWebHosting' => '域名沒有 web 主機因此目前不創建系統使用者。',

    'domain.rename.title' => '更改域名',
    'domain.rename.titleAlias' => '更改域名別名',
    'domain.rename.hint' => '您現在正在更改域名 %%domainName%%',
    'domain.rename.hintAlias' => '您現在正在更改域名別名 %%domainName%%',
    'domain.rename.name' => '新域名',
    'domain.rename.nameAlias' => '新域名別名',
    'domain.rename.domainNameIsRequired' => '必填欄位為空。請在此欄位中輸入相應的值。',
    'domain.rename.submitButton' => '更改',
    'domain.rename.submitButtonProgress' => '更改',
    'domain.rename.successMessage' => '域名 %%oldName%% 已被更改為 %%newName%%。',
    'domain.rename.successMessageAlias' => '域名別名 %%oldName%% 已被更改為 %%newName%%。',

    'domain.rename.Form.cancelButton' => '取消',

    'domain.outgoing-messages.hint' => '在此處您可以修改該域名傳出資訊的數量限制。將無法發送超過指定數量限制的資訊。',
    'domain.outgoing-messages.domainOutgoingMessagesSubscriptionDefault' => '默認（每小時 %%domainOutgoingMessages%% 條資訊）',
    'domain.outgoing-messages.domainOutgoingMessagesSpecificHint' => '條資訊（每小時）',
    'domain.outgoing-messages.domainOutgoingMessages' => '傳出資訊的限制',
    'domain.outgoing-messages.domainOutgoingMessagesCustomLimit' => '該域名的自訂值',

    'domain.tech-domain-name.title' => '選擇您的域名',
    'domain.tech-domain-name.techDomainTitle' => '臨時域名',
    'domain.tech-domain-name.customDomainTitle' => '註冊的域名',
    'domain.tech-domain-name.techDomainText' => '我還沒有註冊的域名',
    'domain.tech-domain-name.customDomainText' => '我已經有一個註冊的域名',
    'domain.tech-domain-name.techDomain' => '您的臨時域名',
    'domain.tech-domain-name.customDomain' => '註冊的域名',
    'domain.tech-domain-name.domainName' => '域名',
    'domain.tech-domain-name.techDomainDesc' => '臨時域名用於在註冊和購買合適的域名之前存取網站。在下列條件下免費提供：',
    'domain.tech-domain-name.techDomainRandom' => '名稱是隨機生成的',
    'domain.tech-domain-name.techDomainDns' => '它們在 .plesk.page DNS 區域中託管',
    'domain.tech-domain-name.techDomainSwitch' => '您可以在之後的任何時間在域名設定中重命名域名以切換到註冊的域名。',
    'domain.tech-domain-name.error' => '發生意外錯誤。',
    'domain.tech-domain-name.errorNoIpAddress' => '您必須要選擇 IP 位址。',
    'domain.tech-domain-name.generating' => '生成中......',

    'get-password.label' => '重設密碼',
    'get-password.text' => '請輸入您在 Plesk 中註冊的電子郵箱位址或用戶名，我們將給您發送一封密碼重設郵件。',
    'get-password.emailLabel' => '電郵地址',
    'get-password.loginLabel' => '用戶名',
    'get-password.send' => '發送',
    'get-password.cancel' => '取消',
    'get-password.errorInvalidEmail' => '該電子郵箱未被識別。請再檢查一遍，然後再試。',
    'get-password.messageSend' => "密碼重設郵件已發送到相關聯的電子郵箱地址。\n若郵件未抵達，請聯繫您的 Plesk 管理員。",

    'iis-settings.formGeneralHint' => '在此處您可通過更改預設值來指定網站的  IIS web 伺服器設定。自訂 IIS 配置是很有幫助的，例如，當您想要在網站上使用新類型的索引檔或要為某個 MIME 類型及某個文件副檔名建立關聯時。預設值由您的主機提供商進行定義。',
    'iis-settings.formGeneralHint_powerUser' => '在此處您可指定網站的 IIS web 伺服器設定。自訂 IIS 配置是很有幫助的，例如，當您想要在網站上使用新類型的索引檔或要為某個 MIME 類型及某個文件副檔名建立關聯時。預設值表示 IIS 將會使用來自其預設配置的回應指令。',
    'iis-settings.virtualDirectoryLoadError' => '無法獲取指定的虛擬目錄的屬性：%%errorMessage%%',
    'iis-settings.general' => '通用設定',
    'iis-settings.example' => "例如：\n%%example%%",
    'iis-settings.settingOn' => '打開',
    'iis-settings.settingOff' => '關閉（默認）',
    'iis-settings.settingDefault' => '默認',
    'iis-settings.settingCustom' => '輸入自訂值',
    'iis-settings.mimeTypes' => 'MIME 類型',
    'iis-settings.mimeTypesExample' => "text/plain .mytxt\nimage/jpeg .myjpeg",
    'iis-settings.mimeTypesFullDescription' => 'MIME類型會將檔副檔名與檔案類型關聯起來。通常，這用於為常見的檔案類型創建自訂的文件副檔名。',
    'iis-settings.documents' => '默認文檔',
    'iis-settings.documentsOff' => '禁用',
    'iis-settings.documentsCustom' => '輸入數值',
    'iis-settings.documentsExample' => "Index.html\nIndex.htm\nIndex.cfm",
    'iis-settings.documentsFullDescription' => '當瀏覽器不提供您網站內文檔的名稱時，IIS 會尋找指定的預設文檔並服務第一個找到的文檔。如果您不指定默認的文檔，但是打開了目錄流覽，那麼該目錄清單會在瀏覽器而不是在索引頁面中顯示。',
    'iis-settings.expires' => '到期',
    'iis-settings.expiresFullDescription' => 'web 伺服器將會把 “Expires” 回應頭添加到網頁。以請求某網頁的時間點開始，持續指定的時間長，整個時段即為過期時間戳記。',
    'iis-settings.expiresUnitDays' => '天',
    'iis-settings.expiresUnitHours' => '小時',
    'iis-settings.expiresUnitMinutes' => '分鐘',
    'iis-settings.expiresUnitSeconds' => '秒',
    'iis-settings.headers' => '其它資訊頭',
    'iis-settings.headersExample' => "Cache-Control: public\nStrict-Transport-Security: max-age=63072000; includeSubdomains;\nX-Frame-Options: DENY",
    'iis-settings.headersFullDescription' => 'Web伺服器將添加指定的HTTP回應頭。',
    'iis-settings.directoryBrowsing' => '目錄流覽',
    'iis-settings.directoryBrowsingDescription' => '允許用戶在 web 瀏覽器中看到網址目錄清單，例如，當無法使用預設的索引頁面時。',
    'iis-settings.securityTabDirectory' => '目錄安全設定',
    'iis-settings.allowAnonymous' => '匿名驗證',
    'iis-settings.allowAnonymousDescription' => '匿名驗證允許用戶存取您網站的公共內容。匿名使用者將無法存取網站上有密碼保護的內容以及檔案系統層的受保護內容。',
    'iis-settings.allowWindows' => 'Windows 驗證',
    'iis-settings.allowWindowsDescription' => 'Windows 驗證（以前稱之為 NTLM）會保護檔案系統層的網站內容。',
    'iis-settings.requireSsl' => '需要 SSL/TLS',
    'iis-settings.requireSslDescription' => '如果您已為您的網站啟用 SSL/TLS 支援，該選項會強制 web 用戶端（瀏覽器）僅使用安全的 HTTPS 連接。',
    'iis-settings.securityTabIpDeny' => '存取限制設定',
    'iis-settings.deny' => '拒絕存取該網站',
    'iis-settings.denyOff' => '默認',
    'iis-settings.denyCustom' => '數值自定義值',
    'iis-settings.allow' => '排除',
    'iis-settings.denyExample' => "10.1.0.0/16\n192.168.1.110\n\n禁止指定的主機和網站存取該網站。使用 '*' 拒絕所有連接。",
    'iis-settings.allowExample' => "192.168.0.0/16\n10.1.1.21\n\n允許指定的主機和網站存取該網站。",
    'iis-settings.dynamicIpSecurity' => '通過限制 IIS 動態 IP 以阻止 DoS 攻擊。',
    'iis-settings.isDenyByConcurrentRequests' => '拒絕IP位址（基於來自特定IP位址的併發請求數量）',
    'iis-settings.maxConcurrentRequests' => '併發請求的最大數量',
    'iis-settings.isDenyByRequestRate' => '拒絕IP位址（基於一段時間內的請求數量）',
    'iis-settings.maxRequests' => '請求的最大數量',
    'iis-settings.requestInterval' => '時段（以毫秒為單位）',

    'ip-addresses-selector.ipAddress' => 'IP 地址',
    'ip-addresses-selector.ipv4Address' => 'IPv4 地址',
    'ip-addresses-selector.ipv4AddressHint' => "託管網站的 IP 位址是網站虛擬主機的網路位址。",
    'ip-addresses-selector.ipv6Address' => 'IPv6 地址',
    'ip-addresses-selector.ipv6AddressHint' => "託管網站的 IP 位址是網站虛擬主機的網路位址。",
    'ip-addresses-selector.noIpAddressHint' => '無',
    'ip-addresses-selector.shared' => '共用',
    'ip-addresses-selector.exclusive' => '獨立',
    'ip-addresses-selector.ipV6OnlyNotSupported' => 'FTP 伺服器不支援 IPv6。至少分配一個 IPv4 位址，不然用戶將無法通過 FTP 上傳檔到伺服器。',

    'license-key-revert.description' => '具有下列屬性的許可證將被恢復:',
    'license-key-revert.submitButton' => '回滾',

    'license-key-upload.description' => '輸入啟動碼來安裝您的許可證金鑰。',
    'license-key-upload.descriptionWithFileUpload' => '可通過輸入啟動代碼或上傳許可證金鑰檔來安裝許可證金鑰',
    'license-key-upload.type' => '選擇下面的一項：',
    'license-key-upload.code' => '輸入啟動代碼',
    'license-key-upload.codeDescription' => '粘上收到的啟動碼。',
    'license-key-upload.file' => '上傳許可證金鑰檔',
    'license-key-upload.fileDescription' => '指定進入包含許可證金鑰的檔的路徑。',
    'license-key-upload.submitButton' => '安裝',

    'log-rotation.customLogsDescription' => '注意您的自訂日誌不會迴圈。',
    'log-rotation.logRotation' => '日誌迴圈',
    'log-rotation.logRotationCondition' => '日誌迴圈條件',
    'log-rotation.logRotationBySize' => '按大小',
    'log-rotation.logRotationByTime' => '按時間',
    'log-rotation.logRotationDaily' => '每日',
    'log-rotation.logRotationWeekly' => '每週',
    'log-rotation.logRotationMonthly' => '每月',
    'log-rotation.logRotationSizeDescription' => '大小值必須介於 %%min%% 和 %%max%% kB 之間。',
    'log-rotation.maximumNumberOfFiles' => '日誌檔的最大數量',
    'log-rotation.compress' => '壓縮日誌檔',
    'log-rotation.sendLogToEmail' => 'Plesk 從 web 和 FTP 伺服器的日誌檔索取資料後，會通過郵件發送日誌檔到該位址',
    'log-rotation.kb' => 'KB',
    'log-rotation.logRotationPeriodGreater' => '周期不能比服务器范围内的限制%%max%%大。',

    'login.loginLabel' => '用戶名',
    'login.passwdLabel' => '密碼',
    'login.localeLabel' => '介面語言',
    'login.defaultLocale' => '默認',
    'login.loginButtonLabel' => '登入',
    'login.enterUsername' => '輸入您的用戶名。',
    'login.enterPassword' => '輸入您的密碼。',
    'login.whatUsernamePassword' => '要使用什麼用戶名和密碼？',
    'login.forgotPasswordLabel' => '忘記您的密碼？',
    'login.cookies' => 'Plesk 中的 Cookies 策略',
    'login.avoidSSLWarningsMsg' => '若要在登入Plesk 的過程中避免 SSL 警告，請使用 %%link%%',
    'login.digitalOceanMsg' => 'Plesk on DigitalOcean 新功能？創建此 droplet 時使用 “root” 和密碼進行登入。%%link%%',
    'login.amazonLightsailMsg' => 'Plesk on Lightsail 新功能？要登入 Plesk，請通過 SSH 存取伺服器，並使用 "plesk login" 命令。%%link%%',
    'login.readGuide' => '閱讀完整的指南。',
    'login.mobileApplicationMessage' => '為了更佳體驗，我們建議您安裝 %%name%% 應用程式。',
    'login.mobileApplicationInstall' => '現在安裝',
    'login.mobileApplicationHide' => '不，謝謝',

    'force-reset-password.saveButton' => '保存',
    'force-reset-password.title' => '更改您的密碼',
    'force-reset-password.passwordLabel' => '新密碼',

    'panel-access.title' => '自訂 Plesk URL',
    'panel-access.hint' => '選擇用於登入 Plesk 的自訂 URL。這不會影響通過埠 %%httpsPort%% 登入 Plesk 的方式。%%link%%',
    'panel-access.details' => '更多詳情',
    'panel-access.proxyEnabled' => '解析為伺服器 IP 位址但不用於主機的所有域名和子域名',
    'panel-access.proxyDomain' => '指定的解析為伺服器 IP 位址但不用於主機的域名或子域名',
    'panel-access.proxyDisabled' => '沒有自訂 URL。 只有 https://<server-IP-or-hostname>:%%httpsPort%%',

    'panel-access.Form.submitButton' => '保存',
    'panel-access.Form.cancelButton' => '取消',

    'panel-access.domainNameIsRequired' => '您必須要提供一個域名。',
    'panel-access.successMessage' => '應用了選定的登入方式。',
    'panel-access.notSupported' => '您的 Plesk 不支援選定的登入方式。',
    'panel-access.notViaDomainName' => '若要應用此登入方式，請選擇第一個選項（“所有域名和子域名......”），通過 https://%%domainName%% 登入 Plesk，然後選擇第二個選項。',
    'panel-access.notViaPort' => '若要應用此登入方式，請首先通過 https://<server-IP-or-hostname>:%%httpsPort%% 登入 Plesk。',

    'php-settings.performance' => '性能和安全設定',
    'php-settings.settings' => '通用設定',
    'php-settings.fastCgiSettings' => 'FastCGI 設定',
    'php-settings.fpmSettings' => 'PHP-FPM 設定',
    'php-settings.enableFastcgi' => '啟用 FastCGI 設定',
    'php-settings.plainTextEditing' => '其他指令',
    'php-settings.placeAdditionalCustomizationDirectivesHere' => '您可以定義任何 PHP 參數，方法是將其輸入到下面的欄位中。這些指令將會包括在 PHP 配置中。請使用與 php.ini 相同的句法。例如，要自動載入 mSQL 擴展，請添加以下行：extension=msql.so.',
    'php-settings.placeAdditionalCustomizationDirectivesHereAddonPlan' => '如果您無法找到某個 PHP 參數，請添加到以下欄位。這些其它的指令會與主服務方案中的指令合併。使用如 php.ini 中相同的句法。例如，如果您想要自動載入 mSQL 擴展，需添加：extension=msql.so。',
    'php-settings.placeFpmAdditionalCustomizationDirectivesHere' => '您可以定義任何 PHP 參數，方法是將其輸入到下面的欄位中。這些指令將會包括在 PHP 配置中。請使用與 php.ini 相同的句法。例如，要自動載入 mSQL 擴展，請添加以下行：extension=msql.so.若要自訂 PHP-FPM 池的設定，請添加 [php-fpm-pool-settings] 分隔符號並在下面輸入所需的設定。',
    'php-settings.additionalConfigurationDirectives' => '其它的配置指令',
    'php-settings.defaultValue' => '默認',
    'php-settings.predefinedValue' => '選擇值',
    'php-settings.customValue' => '輸入自訂值',
    'php-settings.phpSettingDescription_memory_limit' => '允許腳本分配的最大記憶體容量（位元組）。',
    'php-settings.phpSettingDescription_max_execution_time' => '腳本終止前允許運行的最大時間（以秒為單位）。',
    'php-settings.phpSettingDescription_max_input_time' => '允許腳本解析輸入資料的最大時間（以秒為單位）。',
    'php-settings.phpSettingDescription_post_max_size' => '可通過 POST 方式發佈的最大資料量（位元組）。通常應大於 upload_max_filesize 而小於 memory_limit。',
    'php-settings.phpSettingDescription_upload_max_filesize' => '上傳檔的最大容量（位元組）。',
    'php-settings.phpSettingDescription_safe_mode' => '出於安全考慮，PHP 安全模式會對腳本的執行設定一系列限制。',
    'php-settings.phpSettingDescription_safe_mode_include_dir' => '當 safe_mode 指令生效時 PHP 腳本則能夠存取指定目錄中的檔。該目錄必須在 include_path 中。',
    'php-settings.phpSettingDescription_safe_mode_exec_dir' => '當 safe_mode 指令生效時 PHP 腳本則能夠執行指定目錄中的程式。',
    'php-settings.phpSettingDescription_include_path' => '腳本在其上面查找檔（類似系統的 PATH 變數）的目錄清單。若要隔開目錄，請在 Linux 上使用冒號 (:) 而在 Windows 上使用分號 (;)。',
    'php-settings.phpSettingDescription_sessionsave_path' => '存儲 PHP 會話檔的目錄。',
    'php-settings.phpSettingDescription_mailforce_extra_parameters' => 'mail() 函數的其它參數。',
    'php-settings.phpSettingDescription_register_globals' => '註冊 EGPCS 的內容（環境、GET、POST、Cookie、伺服器）變數作為全域變數。',
    'php-settings.phpSettingDescription_open_basedir' => 'PHP 腳本可存取指定目錄中的檔。若要隔開目錄，請在 Linux 上使用冒號 (:) 而在 Windows 上使用分號 (;)。',
    'php-settings.phpSettingDescription_error_reporting' => '錯誤報告級別：',
    'php-settings.phpSettingDescription_display_errors' => '確定錯誤是否以輸出的一部分顯示。',
    'php-settings.phpSettingDescription_log_errors' => '啟用記錄 PHP 錯誤。',
    'php-settings.phpSettingDescription_allow_url_fopen' => '允許 PHP 檔函數通過 FTP 或 HTTP 從遠端位址檢索資料。',
    'php-settings.phpSettingDescription_file_uploads' => '允許通過 HTTP 上傳檔。',
    'php-settings.phpSettingDescription_short_open_tag' => '允許使用 PHP 的 open tag 的簡短格式 ( )。',
    'php-settings.phpSettingDescription_magic_quotes_gpc' => '為 GPC (Get/Post/Cookie) 操作設定 magic_quotes 狀態。當啟用 magic_quotes 時，所有單引號、雙引號、反斜線和空字元都將自動轉為反斜線。',
    'php-settings.phpSettingDescription_disable_functions' => '該指令能夠讓您禁用某些功能。會使用以逗號隔開的功能名稱列表。',
    'php-settings.phpSupport' => 'PHP 支援',
    'php-settings.phpRunAs' => '運行 PHP 以',
    'php-settings.phpVersion' => 'PHP 版本',
    'php-settings.phpHandlerOutdated' => '（已過時）',
    'php-settings.phpHandlerDeprecated' => '（已棄用）',
    'php-settings.phpServedByApache' => '由 Apache 服務',
    'php-settings.phpServedByNginx' => '由 nginx 服務',
    'php-settings.phpSettingsPhpVersion' => '您的 PHP 版本是 %%version%%。',
    'php-settings.phpSettingsPhpDisabled' => 'PHP 已被關閉。',
    'php-settings.phpHandlerTypeHint' => '以下是有關網站的 PHP 配置的詳情。如果主機提供商給以您相應的許可權則可以更改 PHP 配置。',
    'php-settings.fpmDedicatedHandlerHint' => '使用此處理常式可以增強網站的穩定性，但也會導致額外的記憶體消耗。',
    'php-settings.phpHandlerChangeHint' => '您已更改了 PHP handler 設定。如果您保存這些更改，您網站上的 PHP 腳本可能會因您的伺服器配置停止 %%interval%% 秒。',
    'php-settings.phpHandlerOutdatedHint' => '若要檢查新的PHP版本是否可用，請將%%link%%並查看產品元件的“Web 主機”類別。',
    'php-settings.phpHandlerOutdatedHintLink' => '打開 Plesk 安裝程式',
    'php-settings.phpHandlerTypeHelpLink' => '瞭解如何選擇最適合的 PHP 設定',
    'php-settings.phpHandlerTypeNotAvailableHint' => '不能禁用 PHP 支援，因為當前的主機配置不包括任何該功能變數名稱可以使用的 PHP 版本。',
    'php-settings.phpHandlersNotAvailableHint' => 'PHP 支援無法啟用，因為目前的 Plesk 設定不包含任何可用的 PHP 版本。',
    'php-settings.phpHandlerTypeNotAvailableHelpLink' => '了解如何啟用其他 PHP 版本。',
    'php-settings.phpSupportEditable' => '（PHP 版本 %%version%%，以 %%handler%% 運行 PHP）%%link%%',
    'php-settings.phpSupportReadonly' => '（版本： %%version%%; 處理器：%%handler%%) %%link%%',
    'php-settings.phpSupportReadonlyNotRegistered' => '（未註冊）%%link%%',
    'php-settings.showPhpInfo' => '查看 phpinfo() 頁面',
    'php-settings.phpSettingsFormError' => '無法索取 PHP 設定因為所需資料缺失。',
    'php-settings.phpSettingsFormBrokenPhpHandler' => '由於未安裝此 PHP 版本，故無法取回 PHP 設定。若想繼續，請安裝所選的 PHP 版本，或選擇網域的另一個版本。',
    'php-settings.showPhpInfoTitle' => '查看 phpinfo()',
    'php-settings.showPhpInfoDescription' => '您的一些 PHP 設定已被更改但是更改還未保存。若要查看 phpinfo() 頁面上的新值，請首先應用更改。否則您將會看到當前的值。',
    'php-settings.showPhpInfoButton' => '查看 phpinfo()',
    'php-settings.onState' => '啟用',
    'php-settings.offState' => '關閉',
    'php-settings.description' => '該頁面會顯示網站的 PHP 配置。這些設定針對該網站，而不會影響訂閱上的其它網站。如果主機提供商給以您相應的許可權則可以更改 PHP 配置。當您想要限制 PHP 腳本消耗的系統資源或想要達到某個 web 應用程式的要求時，自訂 PHP 配置可能會有用。當您設定一個參數為預設值時，PHP 會使用伺服器級的 PHP 配置的該參數值。',
    'php-settings.availableVariables' => '您可在參數值中使用以下預留位置：',
    'php-settings.variableDocroot' => '{DOCROOT} 代表網站的文檔根目錄。當前的值為 %%DOCROOT%%。%%HTTPS_DOCROOT%%',
    'php-settings.variableDocrootHttpsSame' => 'HTTPS 文檔根目錄與 http 的相同。',
    'php-settings.variableDocrootHttpsDifferent' => 'HTTPS 文檔根目錄是 %%DOCROOT%%。',
    'php-settings.variableWebspaceRoot' => '{WEBSPACEROOT} 代表訂閱主網站的文檔根目錄。',
    'php-settings.variableTmp' => '{TMP} - 用於存儲暫存檔案的目錄。',
    'php-settings.note' => '注意：以下設定可能會被 .htaccess、php.ini 或 .user.ini 檔案中指定的參數覆蓋。',

    'pmm.agent.sync.check' => '遷移與傳輸代理 正在檢查更新。',
    'pmm.agent.sync.updating' => '同步與下載 遷移與傳輸代理',
    'pmm.agent.sync.done' => '已經成功同步 遷移與傳輸代理',
    'pmm.agent.sync.downloadLink' => '在開始遷移之前點按下載應該安裝於源主機上的 遷移與傳輸代理 檔。',
    'pmm.agent.sync.error' => '遷移與傳輸代理 獲取更新失敗。請稍候再試。',

    'restore-password.title' => '更改您的密碼',
    'restore-password.passwordLabel' => '新密碼',
    'restore-password.buttonRestore' => '保存',
    'restore-password.buttonCancel' => '取消',
    'restore-password.isEmpty' => '必填欄位為空。您需要指定一個值。',
    'restore-password.errorInvalidSecret' => '無效密碼',
    'restore-password.errorNotFoundSecret' => '請申請一個新密碼',
    'restore-password.restoreSuccess' => '您的密碼已更新。使用新的密碼登入到 Plesk 或到您的電子郵箱位址。',

    'scheduler.settings.schedulerNotification' => '計畫程式通知',
    'scheduler.settings.notificationOff' => "已關閉",
    'scheduler.settings.notificationDefault' => "發送到默認電郵地址 (%%email%%)",
    'scheduler.settings.notificationCustom' => "發送到我指定的電子郵件",
    'scheduler.settings.crontabSecureShell' => 'Crontab shell',
    'scheduler.settings.schedulerTimezoneSelector' => '使用時區顯示任務計畫',
    'scheduler.settings.schedulerTimezoneSelectorDefaultWithLabel' => '使用系統預設的時區 (%%timezone%%)',
    'scheduler.settings.schedulerTimezoneSelectorDefault' => '使用系統預設的時區',
    'scheduler.settings.schedulerTimezoneSelectorCustom' => '使用我指定的時區',

    'scheduler.task.active' => '活動',
    'scheduler.task.subscription' => '訂閱',
    'scheduler.task.subscription_powerUser' => '主機空間',
    'scheduler.task.type' => '任務類型',
    'scheduler.task.typeCommand' => '運行命令',
    'scheduler.task.typeUrl' => '獲取 URL',
    'scheduler.task.typeScript' => '運行 PHP 腳本',
    'scheduler.task.command' => '命令',
    'scheduler.task.arguments' => '帶有參數',
    'scheduler.task.url' => 'URL',
    'scheduler.task.urlDescription' => '指定絕對 URL，例如 http://example.com。如回應狀態代碼是 2xx 或 3xx，表示工作已順利完成。',
    'scheduler.task.script' => '腳本路徑',
    'scheduler.task.scriptRelativePathDescription' => '示例：%%path%%',
    'scheduler.task.scriptAbsolutePathDescription' => '指定該腳本的完整路徑。示例：%%path%%',
    'scheduler.task.scriptPhpVersion' => '使用 PHP 版本',
    'scheduler.task.scriptPathPopupTitle' => '腳本路徑',
    'scheduler.task.run' => '運行',
    'scheduler.task.on' => '打開',
    'scheduler.task.at' => '在',
    'scheduler.task.sysUser' => '系統使用者',
    'scheduler.task.hourly' => '每小時',
    'scheduler.task.daily' => '每日',
    'scheduler.task.weekly' => '每週',
    'scheduler.task.monthly' => '每月',
    'scheduler.task.yearly' => '每年',
    'scheduler.task.cronStyle' => 'Cron 類型',
    'scheduler.task.cronStyleHint' => '請使用 UNIX crontab 格式 "分鐘 小時 日 月 星期"。例如 "0 22 * * 1-5"。Plesk 將會使用預設的系統時區運行任務。',
    'scheduler.task.cronStyleWinHint' => '請使用格式 "分鐘 小時 日 月 星期"，例如，"0 22 * * 6,7"。Plesk 將會使用預設的系統時區運行任務。',
    'scheduler.task.notify' => '通知',
    'scheduler.task.notifyIgnore' => '不通知',
    'scheduler.task.notifyErrors' => '僅錯誤',
    'scheduler.task.notifyAlways' => '每次',
    'scheduler.task.notifyErrorsHint' => '通知包含命令的標準錯誤流。如果輸出流為空，則不會發送通知。',
    'scheduler.task.notifyErrorsHintWin' => '通知包含命令輸出，只有在退出代碼為非零值時才發送。',
    'scheduler.task.notifyAlwaysHint' => '通知包含命令輸出。如果輸出為空，則不會發送通知。',
    'scheduler.task.notifyAlwaysHintWin' => '通知包含命令輸出，不管命令退出代碼是什麼都會發送該通知。',
    'scheduler.task.emailType' => '發送通知到',
    'scheduler.task.emailTypeDefault' => '預設的系統使用者 (%%email%%)',
    'scheduler.task.emailTypeOwner' => '訂閱所有者 (%%email%%)',
    'scheduler.task.emailTypeOwnerAdmin' => '管理員 (%%email%%)',
    'scheduler.task.emailTypeCustom' => '其它用戶',
    'scheduler.task.emailTypeCustomDescription' => '您可以指定多個位址，以逗號隔開。',
    'scheduler.task.minute' => '分鐘',
    'scheduler.task.shortMinute' => '分鐘',
    'scheduler.task.dayOfMonth' => '日',
    'scheduler.task.description' => '描述',
    'scheduler.task.scheduleTimezoneHint' => '運行任務的時區是 %%timezone%%',
    'scheduler.task.runTaskNow' => '現在運行',
    'scheduler.task.runningTask' => '正在運行任務 "%%task%%"...',

    'server-settings.submitDone' => "伺服器設定已更改。",
    'server-settings.systemSettings' => "系統設定",
    'server-settings.fullHostName' => "完整的主機名稱",
    'server-settings.trafficStatisticsPeriod' => "保留網站和流量統計",
    'server-settings.trafficStatisticsPeriodUnit' => "月",
    'server-settings.diskSpaceUsageCalculation' => "包含在磁碟空間使用量計算中",
    'server-settings.includeLogs' => "日誌檔",
    'server-settings.includeLogsAndStats' => "日誌檔和統計報告",
    'server-settings.includeMysqlDatabases' => "MariaDB/MySQL 資料庫",
    'server-settings.includeMssqlDatabases' => "Microsoft SQL Server 資料庫",
    'server-settings.includePgsqlDatabases' => "PostgreSQL 資料庫",
    'server-settings.includeDatabases' => "資料庫",
    'server-settings.includeRemoteDatabases' => "遠端資料庫",
    'server-settings.includeMailboxes' => "郵箱",
    'server-settings.includeMailLists' => "郵寄清單",
    'server-settings.includeDomainDumps' => "域名備份檔案",
    'server-settings.includeAdminDumps' => "管理員創建備份檔案",
    'server-settings.calculatingDiskSpaceUsage' => "當計算磁碟空間使用量時，計算",
    'server-settings.typeByte' => "文件大小",
    'server-settings.typeBlock' => "磁碟空間使用量",
    'server-settings.trafficCalculation' => "包含在流量計算中",
    'server-settings.inboundAndOutbound' => "入站和出站流量",
    'server-settings.onlyInbound' => "僅入站流量",
    'server-settings.onlyOutbound' => "僅出站流量",
    'server-settings.forbidCreateDnsSubZone' => "不允許用戶在其它使用者的 DNS 主區域中創建 DNS 子區域",
    'server-settings.webDeployIncludePassword' => "將使用者的密碼包含到帶有 Web Deploy 發佈設定的檔中。",
    'server-settings.forbidSysUserRename' => "客戶可更改其系統使用者的名稱",
    'server-settings.alwaysAllowSysUserRename' => "總是",
    'server-settings.ifPermissionIsGrantedAllowSysUserRename' => "只有在已授予主機管理許可權的情況下",
    'server-settings.neverAllowSysUserRename' => "從不",
    'server-settings.forbidSubscriptionRename' => "禁止客戶和代理商更改其主域名",
    'server-settings.preferredDomain' => "網站的偏好域名",
    'server-settings.preferredDomainNone' => "無",
    'server-settings.preferredDomainToLanding' => "domain.tld",
    'server-settings.preferredDomainToWww' => "www.domain.tld",
    'server-settings.ipLogging' => "IP 日誌記錄",
    'server-settings.disableIpLogging' => "禁用 IIS、FTP 和郵件日誌中的 IP 日誌記錄",
    'server-settings.disableIpLoggingDescription' => "如果選定，IIS 和 MailEnable 不再會將 IP 位址寫入到日誌檔中",
    'server-settings.anonymizeIps' => "隐藏IP地址",
    'server-settings.logrotateAnonymizeIps' => "在日志轮转和收集web统计数据时隐藏IP地址",
    'server-settings.logrotateAnonymizeIpsDescription' => '归档前，postrotate脚本会用"0"替换掉IPv4 地址的最后八位字节。在 IPv6 地址中，脚本会用"0000" （完整的形式）或"0"（简短的形式） 替换掉该地址的后半部分',
    'server-settings.logrotate' => "日志轮转",
    'server-settings.logrotateForce' => "强制为所有域名执行每日日志轮转",
    'server-settings.allowToStoreLogs' => "允許存儲網站日誌",
    'server-settings.logrotatePeriod' => "天",
    'server-settings.configureUpdatePolicy' => "配置更新策略",

    'service-plan.mail.outgoing-messages.outgoingMessagesDefault' => '默認的伺服器級的值（每小時 %%default%% 條資訊）',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificPlan' => '方案的自訂值',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificSubscription' => '訂閱的自訂值',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificHint' => '信息',
    'service-plan.mail.outgoing-messages.mboxOutgoingMessages' => '發自一個郵箱的資訊（每小時）',
    'service-plan.mail.outgoing-messages.domainOutgoingMessages' => '發自一個域名的資訊（每小時）',
    'service-plan.mail.outgoing-messages.subscriptionOutgoingMessages' => '發自一個訂閱的資訊（每小時）',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimit' => '超過應在接下來一小時內發送的每小時資訊限額的百分比',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimitDescription' => '如果郵箱每小時傳出郵件的限額為 100 而百分比為 10%，那麼將可允許用戶每小時提交 110  個資訊，一個小時內可發送 100 個資訊，而另外 10 個資訊將會列入郵件佇列中，準備在下一個小時發送。',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmail' => 'Sendmail 使用策略',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailDefault' => '默認的伺服器級設定（允許使用 Sendmail）',
    'service-plan.mail.outgoing-messages.outgoingMessagesNotEnableSendmailDefault' => '默認的伺服器級設定（不允許使用 Sendmail）',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomPlan' => '方案的自訂設定',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomSubscription' => '訂閱的自訂設定',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomLabel' => '允許把 Sendmail 用於該訂閱上的腳本和用戶',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomHint' => '即使在超過了郵箱和域名的限制的情況下腳本和使用者也將能夠使用  Sendmail 發送郵件資訊（代表訂閱的系統使用者）。可通過 Sendmail 發送的資訊最大數量將由整個訂閱的限制所定義。',

    'setup.hint' => '歡迎來到 Plesk，這是一款能夠幫助您更優管理伺服器的全能控制台。Plesk 提供即購即可編碼的環境，並配備一整套功能強大的擴展，幫助您更方便快捷地開發網站和應用。完成設定流程以開始使用 Plesk（只需要一分鐘時間）。',
    'setup.contactInfoSection' => '聯繫資訊',
    'setup.contactInfoSectionHint' => '輸入您的姓名和電子郵箱位址，以便確定您是伺服器的所有者，並接收有關該伺服器的重要通知資訊。如果您是一名企業伺服器管理人員，請不要輸入您的個人姓名或電子電郵地址。請使用您的職位名稱和企業電子電郵地址，以避免違反資料保護法。',
    'setup.contactName' => '連絡人姓名',
    'setup.emptyContactName' => '請提供一個連絡人姓名。',
    'setup.contactNameTooLong' => '連絡人姓名太長（最多允許 %max% 個字元）。',
    'setup.email' => '電子郵箱',
    'setup.emptyEmail' => '請提供電郵地址。',
    'setup.passwordSection' => '密碼',
    'setup.passwordSectionHint' => '下次您登入 Plesk 時，請使用用戶名 \'admin\' 和在下面輸入的密碼。',
    'setup.password' => '密碼',
    'setup.licenseSection' => '許可證',
    'setup.licenseSectionHint' => '您需要安裝一個許可證才能使用 Plesk。',
    'setup.licenseType' => '選擇您的許可證類型',
    'setup.licenseTypePaid' => '使用付費許可證',
    'setup.onlineStoreLink' => '線上商店',
    'setup.licenseTypeTrial' => '使用全功能的試用許可證',
    'setup.activationCodeHint' => '如果您已購買了 Plesk 許可證，請在此處貼上您收到的啟動碼。如還未購買，可以進入我們的 %%onlineStoreLink%% 購買新的許可證。',
    'setup.privacyPolicyLink' => 'WebPros隱私權政策',
    'setup.trialLicenseAgreement' => '為了簽發試用許可證，WebPros International GmbH 將根據 %%privacyPolicyLink%% 使用和處理其內部系統中提供的資訊。',
    'setup.eulaAgreementLabel' => '我確認已閱讀並接受 %%link%%',
    'setup.eula' => '使用者授權合約',
    'setup.invalidEulaAgreementValue' => '您必須接受使用者授權合約',
    'setup.sendButton' => '進入 Plesk >>',
    'setup.resetPasswordOnFirstLogin' => '在下次登入時重置管理員的密碼',

    'spam-filter.add.titleBlack' => '將地址添加到黑名單中。',
    'spam-filter.add.titleWhite' => '將地址添加到白名單中。',
    'spam-filter.add.fileDescription' => '上傳 UTF-8 文本編碼的文字檔案（例如：*.txt 或 *.csv 檔案）。',
    'spam-filter.add.listDescription' => '格式規則：<ul><li>使用逗號、冒號或換行符號、空白或 Tab 字元拆分各個地址。</li><li>請勿使用 @ 符號左側的非 ASCII 字元。</li><li>你可使用「*」及「?」等萬用字元（例如： <nobr>*@domain.com,</nobr> <nobr>user?@*.com</nobr>）。</li><li>請勿在網域名稱的非 ASCII 區塊使用萬用字元。</li></ul>',
    'spam-filter.add.fromFile' => '來自文件',
    'spam-filter.add.fromList' => '來自列表',
    'spam-filter.add.success' => '地址已新增',

    'ssl-certificate.add.name' => '證書名稱',
    'ssl-certificate.add.longName' => '指定的證書名稱太長（允許最多 %max% 個字元）。',
    'ssl-certificate.add.certificateNameUsed' => '名為 %%name%% 的證書已存在。',
    'ssl-certificate.add.certificateAdded' => 'SSL/TLS 證書已簽發。若要令其運行工作，請分配證書以保護域名、郵件或 web 郵箱的安全。',
    'ssl-certificate.add.certificateUpdated' => 'SSL/TLS 證書已被成功更新。',
    'ssl-certificate.add.settings' => '設定',
    'ssl-certificate.add.settingsHint' => '使用該表格生成證書請求，從提供商購買證書，或者生成自簽章憑證。',
    'ssl-certificate.add.settingsHint2' => '一個請求是包含有關您在表格中指定的域名資訊的 CSR 檔。您可以將此請求發給憑證授權，他們即可為您頒發證書。然後您可以用以下的上傳表格將其上傳。',
    'ssl-certificate.add.settingsHint3' => '自簽章憑證是由其創建者簽發的身份證書。如果您使用此類證書，表示您自己要核實您網站的身份。儘管自簽章憑證允許使用 SSL/TLS，但其可信度低，安全性不高。',
    'ssl-certificate.add.bits' => '比特',
    'ssl-certificate.add.country' => '國家',
    'ssl-certificate.add.state' => '省/市/自治區',
    'ssl-certificate.add.longState' => '指定的州或省份名稱太長。',
    'ssl-certificate.add.city' => '地址（市）',
    'ssl-certificate.add.longCity' => '指定的城市名稱太長。',
    'ssl-certificate.add.shortCity' => '指定的城市名稱太短。',
    'ssl-certificate.add.companyName' => '組織名稱(公司)',
    'ssl-certificate.add.longCompanyName' => '指定的公司名稱太長。',
    'ssl-certificate.add.companyUnitName' => '組織部門/分部名稱',
    'ssl-certificate.add.longCompanyUnitName' => '指定的機構部門名稱太長（允許最多 %max% 個字元）。',
    'ssl-certificate.add.domainName' => '域名',
    'ssl-certificate.add.email' => '電子郵件',
    'ssl-certificate.add.request' => '請求',
    'ssl-certificate.add.buyCertificate' => '購買 SSL/TLS 證書',
    'ssl-certificate.add.selfSigned' => '自簽名',
    'ssl-certificate.add.invalidCertificateParams' => '一些欄位為空或包含不合適的值。該值應限於 64 個字元。如果您正使用國際域名，請確定在轉換為 ASCII 格式時各個點號之間的域名部分不超過 63 個字元。檢查欄位：',
    'ssl-certificate.add.unableCreateCsr' => '無法創建 CSR：%%error%%',
    'ssl-certificate.add.unableCreateSelfSigned' => '無法創建自簽證書：%%error%%',
    'ssl-certificate.add.unableCreateUpload' => '無法設定證書資料：%%error%%',
    'ssl-certificate.add.unableSaveCertificate' => '無法在資料庫中保存證書：%%error%%',
    'ssl-certificate.add.uploadFiles' => '上傳證書文件',
    'ssl-certificate.add.uploadFilesHint' => '使用該表格以組成檔形式上傳證書的組成部分。',
    'ssl-certificate.add.csr' => 'CSR',
    'ssl-certificate.add.privateKey' => "私密金鑰 (*.key)",
    'ssl-certificate.add.certificate' => "證書 (*.crt)",
    'ssl-certificate.add.caCertificate' => "CA 證書 (*-ca.crt)",
    'ssl-certificate.add.sendFiles' => "上傳證書",
    'ssl-certificate.add.fileNotUploaded' => '無法上傳證書文件：%%name%%.',
    'ssl-certificate.add.unableSetPrivateKey' => '無法設定私密金鑰：%%error%%',
    'ssl-certificate.add.unableSetCertificate' => '無法設定證書：%%error%%。',
    'ssl-certificate.add.unableSetCaCertificate' => '無法設定 CA 證書：%%error%%',
    'ssl-certificate.add.unableCheckCaCertificate' => '無法檢查 CA 證書是否簽署了證書：%%error%%',
    'ssl-certificate.add.removeCaCertificate' => '移除',
    'ssl-certificate.add.removeCaCertificateConfirmation' => '您想要移除 CA 證書嗎？',
    'ssl-certificate.add.unableRemoveCaCertificate' => '無法清除 CA 證書：%%error%%',
    'ssl-certificate.add.caCertificateRemoved' => '證書的 CA 部分已被移除。',
    'ssl-certificate.add.rename' => '重命名',
    'ssl-certificate.add.unableRenameCertificate' => '無法重命名證書：%%error%%',
    'ssl-certificate.add.certificateRenamed' => '證書已被重命名為 %%name%%。',
    'ssl-certificate.add.uploadText' => "以文本形式上傳證書",
    'ssl-certificate.add.uploadTextHint' => '使用該表格以文本形式上傳證書的組成部分。複製檔內容並貼上到相應的欄位。',
    'ssl-certificate.add.sendText' => "上傳證書",
    'ssl-certificate.add.componentIsMissing' => '該組件已丟失。',

    'ssl-certificate.find-private-key.findPrivateKey' => '在此處上傳證書',
    'ssl-certificate.find-private-key.formGeneralHint' => '如果您在該伺服器上創建了證書簽名請求且收到了證書文件，請在此處上傳它。如果您想要上傳證書和在其它伺服器上生成的私密金鑰對，或生成自簽章憑證，請點按 <b> 添加 SSL/TLS 證書</b>.',
    'ssl-certificate.find-private-key.formCertificateAddingHint' => '給域名添加 SSL/TLS 證書後，需要在網站主機設定中啟用 SSL/TLS 支援並選擇該證書：<b>網站與域名</b> > <b>主機設定</b>（該域名）/> <b>安全</b>。',
    'ssl-certificate.find-private-key.uploadCertificate' => '證書 (*.crt)',
    'ssl-certificate.find-private-key.sendFile' => '上傳證書',
    'ssl-certificate.find-private-key.fileNotUploaded' => '無法上傳證書文件。',
    'ssl-certificate.find-private-key.invalidCertificateFormat' => '無效的證書格式。',
    'ssl-certificate.find-private-key.unableFindPrivateKey' => '無法為證書找到合適的私密金鑰。',

    'ssl-certificate.secure.certificate' => '選擇證書',
    'ssl-certificate.secure.serverPool' => '伺服器池',
    'ssl-certificate.secure.certificateName' => '%%certificateName%%（%%repositoryName%%）',

    'system-time.date' => "日期",
    'system-time.dateAndTime' => "日期和時間",
    'system-time.daylight' => "自動將時鐘調整為夏令時制",
    'system-time.dayMonthYear' => "日-月-年",
    'system-time.domainNameOrIp' => "域名或 IP",
    'system-time.hoursMinutesSeconds' => "時：分：秒",
    'system-time.networkTime' => "網路時間",
    'system-time.submitDone' => "系統時間設定已更改。",
    'system-time.synchronizedSystemTime' => "同步系統時間",
    'system-time.title' => "系統日期和時間",
    'system-time.timezone' => "時區",
    'system-time.time' => "時間",
    'system-time.updateSystemTime' => "更新系統時間",
    'system-time.yourTimezone' => "您的時區",

    'web-app-firewall.pageHint' => 'Web 應用程式防火牆會基於使用者定義的規則檢查和過濾接收的 HTTP 請求來保護 web 應用程式以令其免受攻擊。',
    'web-app-firewall.webSitePageHint' => '在此處您可以配置 web 應用程式防火牆 (ModSecurity)。',
    'web-app-firewall.ruleEngine' => 'Web 應用程式防火牆模式',
    'web-app-firewall.ruleEngineOn' => '啟用',
    'web-app-firewall.ruleEngineOnDescription' => '會針對一組規則對每次傳入的 HTTP 請求以及相應回應進行檢查。如果檢查成功，該 HTTP 請求就會被傳遞到網站內容。如果檢查失敗，該事件就會被記錄下來，會發送一個通知，且該 HTTP 響應會帶有一個錯誤代碼。',
    'web-app-firewall.ruleEngineOff' => '停用',
    'web-app-firewall.ruleEngineOffDescription' => '傳入的 HTTP 請求和相關回應不會被檢查。',
    'web-app-firewall.ruleEngineDetectionOnly' => '僅檢測',
    'web-app-firewall.ruleEngineDetectionOnlyDescription' => '會針對一組規則對每次傳入的 HTTP 請求以及相應回應進行檢查。如果檢查成功，該 HTTP 請求就會被傳遞到網站內容。如果檢查失敗，該事件就會被記錄下來且 ModSecurity 不會執行其他操作。其他服務（例如 Fail2ban）仍可以在檢查失敗的 HTTP 請求上執行其操作。',
    'web-app-firewall.ruleSetsSection' => '規則集',
    'web-app-firewall.ruleSetsSectionHint' => '選擇用於檢查接收的 HTTP 請求的規則集（包含安全規則的檔包）。',
    'web-app-firewall.ruleSet' => '規則集',
    'web-app-firewall.ruleSetCrs' => 'OWASP (免費)',
    'web-app-firewall.ruleSetCrsDescription' => 'OWASP ModSecurity 核心規則集合極為嚴格且可能封鎖部分功能 (例如，檔案共用、網頁郵件) 以及網頁應用程式的部分功能 (例如，WordPress 外掛程式)。',
    'web-app-firewall.ruleSetCrsConfirmTitle' => '應用更改？',
    'web-app-firewall.ruleSetCrsConfirmDescription' => 'OWASP 規則會非常嚴格，因此可能會阻止一些功能，例如，檔共用、web 郵箱和某些 web 應用程式。',
    'web-app-firewall.ruleSetTortix' => 'Atomic 標準 (免費，可升級為 Atomic Advanced)',
    'web-app-firewall.ruleSetTortixDescription' => 'Atomicorp 的入門版 ModSecurity 規則。提供基本防護以及每月更新。',
    'web-app-firewall.ruleSetTortixHowTo' => '如需將此規則升級為 Atomic Advanced：',
    'web-app-firewall.ruleSetTortixBuy' => '從 Plesk 網站和 %%linkDocumentation%% 購買 %%linkPleskStore%%。',
    'web-app-firewall.ruleSetTortixLinkPleskStoreLabel' => 'Atomicorp 的 Advanced ModSecurity 規則',
    'web-app-firewall.ruleSetTortixLinkDocumentationLabel' => '安裝購買的額外授權碼',
    'web-app-firewall.ruleSetTortixSelect' => '選取此規則，其名稱將變更為「Atomic Advanced (購自 Plesk)」',
    'web-app-firewall.ruleSetTortixPro' => 'Atomic Advanced (購自 Plesk)',
    'web-app-firewall.ruleSetTortixProDescription' => 'Atomicorp 的 Advanced ModSecurity 規則包含 Atomic 標準規則以及數個進階功能。',
    'web-app-firewall.ruleSetAtomic' => 'Atomic Advanced (購自 Atomicorp)',
    'web-app-firewall.ruleSetAtomicDescription' => 'Atomicorp 的 Advanced ModSecurity 規則包含 Atomic 標準規則以及數個進階功能。',
    'web-app-firewall.ruleSetAtomicInstall' => '切換到其它的 Atomicorp 帳號。',
    'web-app-firewall.ruleSetAtomicInstalled' => '規則集已啟動。',
    'web-app-firewall.ruleSetAtomicHowTo' => '如果您已經有 Atomicorp 帳號並購買了 Atomic 高級規則，請在下面輸入帳號驗證憑據以啟用此規則集。',
    'web-app-firewall.ruleSetAtomicSwitchHowTo' => '如果您已經有 Atomicorp 帳號並購買了 Atomic 高級規則，請在下面輸入帳號驗證憑據以切換帳號。',
    'web-app-firewall.ruleSetAtomicLogin' => '用戶名',
    'web-app-firewall.ruleSetAtomicPassword' => '密碼',
    'web-app-firewall.ruleSetComodo' => 'Comodo (免費訂閱)',
    'web-app-firewall.ruleSetComodoDescription' => 'Comodo 的免費 ModSecurity 規則。提供基本防護。',
    'web-app-firewall.ruleSetComodoInstall' => '切換到其它的 Comodo 帳號。',
    'web-app-firewall.ruleSetComodoInstalled' => '規則集已啟動。',
    'web-app-firewall.ruleSetComodoHowTo' => '要啟用該規則集：',
    'web-app-firewall.ruleSetComodoSwitchHowTo' => '若要切換到其它的帳號，請如下操作：',
    'web-app-firewall.ruleSetComodoRegister' => '在 Comodo 網站註冊。',
    'web-app-firewall.ruleSetComodoCredentials' => '輸入您在該網站的使用者名稱和密碼。',
    'web-app-firewall.ruleSetComodoLogin' => '用戶名',
    'web-app-firewall.ruleSetComodoPassword' => '密碼',
    'web-app-firewall.ruleSetComodoFree' => 'Comodo (免費)',
    'web-app-firewall.ruleSetComodoFreeDescription' => 'Comodo 的免費 ModSecurity 規則。提供基本防護。',
    'web-app-firewall.ruleSetCustom' => '自訂規則集',
    'web-app-firewall.ruleSetCustomDescription' => '請上傳自訂 web 應用程式防火牆規則集。支援的格式：zip、tar.gz、tgz、tar.bz2、conf。',
    'web-app-firewall.ruleSetCustomUpload' => '選擇其它文件',
    'web-app-firewall.ruleSetError' => '安裝 ModSecurity 規則集失敗：%%error%%',
    'web-app-firewall.ruleSetOWASPMissingError' => 'OWASP 規則集缺失。使用 Plesk 安裝程式重新安裝 ModSecurity。',
    'web-app-firewall.ruleSetCustomMissingError' => '自訂規則集缺失。重新安裝規則集。',
    'web-app-firewall.ruleSetAuthError' => '指定的用戶名或密碼無效。',
    'web-app-firewall.ruleSetInvalid' => '選定的規則集無法在 %%webServer%% 上運行。',
    'web-app-firewall.ruleSetSelectedInvalid' => '選定的規則集無法在選定的 web 伺服器上運行。',
    'web-app-firewall.webServer' => '運行規則於',
    'web-app-firewall.webServerHint' => '選擇所需的 web 伺服器和 ModSecurity 版本組合以查看相容的規則集。',
    'web-app-firewall.webServerApache' => 'Apache (ModSecurity 2.9)',
    'web-app-firewall.webServerNginx' => 'Nginx (ModSecurity 3.0)',
    'web-app-firewall.webServerIis' => 'IIS (ModSecurity 2.9)',
    'web-app-firewall.nginxNotRunning' => '反向代理伺服器 (nginx) 已關閉而無法用於處理請求。請選擇<a href="%%serverUrl%%">其它的 web 伺服器</a>或在<a href="%%servicesUrl%%">服務管理頁面</a>上開啟反向代理伺服器。',
    'web-app-firewall.nginxIsIncompatible' => '選擇不同的 ModSecurity 版本可能會導致某些設定不再有效（例如，您無法使用規則運算式關閉 ModSecurity 3 的安全規則）。請確保您的設定在應用更改後仍能照常運行。另外，您可以將可關閉安全規則的設定重設為預設值。',
    'web-app-firewall.nginxResetCustomizations' => '將可關閉安全規則的伺服器和域名設定重設為預設值。',
    'web-app-firewall.ruleSetUpdate' => '更新規則集',
    'web-app-firewall.ruleSetUpdateDaily' => '每日',
    'web-app-firewall.ruleSetUpdateWeekly' => '每週',
    'web-app-firewall.ruleSetUpdateMonthly' => '每月',
    'web-app-firewall.currentRuleSet' => '規則集',
    'web-app-firewall.currentRuleSetValue' => '%%ruleSet%% %%changeRuleSetLink%%',
    'web-app-firewall.currentRuleSetRunningOn' => '在 %%webServer%% 上運行的 %%ruleSet%%',
    'web-app-firewall.changeRuleSetLink' => '修改規則集',
    'web-app-firewall.ruleSetRollbackFailed' => '無法使用當前的 ModSecurity 規則集和回滾到之前的版本，因為它們包含無效的規則。',
    'web-app-firewall.configurationSection' => '配置',
    'web-app-firewall.configurationSectionHint' => '請使用預定義的參數集或您自訂的 ModSecurity 指令配置 web 應用程式防火牆。',
    'web-app-firewall.configPreset' => '預先定義的值',
    'web-app-firewall.configPresetFast' => '快速',
    'web-app-firewall.configPresetFastDescription' => 'HTTP 請求 URI 和部分標頭將會被分析。',
    'web-app-firewall.configPresetTradeOff' => '權衡',
    'web-app-firewall.configPresetTradeOffDescription' => 'HTTP 請求 URI、標頭和請求 POST 資料將會被分析。',
    'web-app-firewall.configPresetThrough' => '徹底',
    'web-app-firewall.configPresetThroughDescription' => '整個 HTTP 請求標頭、請求 POST 資料和 HTTP 回應文本內容將被分析。',
    'web-app-firewall.configCustom' => '自訂指令',
    'web-app-firewall.configCustomDescription' => "在此處輸入 ModSecurity 指令。它將會覆蓋之前指定的指令（規則集、具體規則、預先定義的值，等等）\n例如：SecDebugLogLevel 6",
    'web-app-firewall.configCustomError' => 'ModSecurity 配置無效：%%error%%',
    'web-app-firewall.configRollbackFailed' => '無法使用當前的 ModSecurity 設定檔且無法回滾到檔的原版本因為它們包含無效的配置。',
    'web-app-firewall.rulesSection' => '關閉安全規則',
    'web-app-firewall.rulesSectionHint' => '您可在此關閉安全規則。若您能夠找出對某些網站太過嚴格的安全規則，那就方便了。要停用安全規則，請指定其 ID（例如 340003 或 340005-340007）、標籤（例如 CVE-2011-4898）或規則資訊（例如 XSS）中的規則運算式。',
    'web-app-firewall.rulesSectionNginxHint' => '您可在此關閉安全規則。若您能夠找出對某些網站太過嚴格的安全規則，那就方便了。要停用安全規則，請指定其 ID（例如 340003 或 340005-340007）、標籤（例如 CVE-2011-4898）或規則資訊（例如 "Found User-Agent associated with security scanner"）。',
    'web-app-firewall.filterById' => '安全規則 ID',
    'web-app-firewall.filterByIdInvalid' => '下列值無效：%%values%%。規則 ID 應包含數位或數位範圍，如 913100、913105-913107。',
    'web-app-firewall.filterByIdInvalidRanges' => '以下範圍無效：%%ranges%%。',
    'web-app-firewall.filterByTag' => '標籤',
    'web-app-firewall.filterByTagActive' => '已啟用：',
    'web-app-firewall.filterByTagDeactivated' => '已停用：',
    'web-app-firewall.filterByTagInvalid' => '下列選定的值無效：%%values%%。',
    'web-app-firewall.filterByRegexp' => '規則資訊中的規則運算式',
    'web-app-firewall.filterByRegexpInvalid' => '以下值無效：%%values%%。其不得包含任何 “,” 字元。',
    'web-app-firewall.filterByRegexpNginx' => '規則資訊',
    'web-app-firewall.filterByRegexpNginxHint' => '只支持嚴格匹配的。',
    'web-app-firewall.filterByRegexpNginxInvalid' => '以下值無效：%%values%%。規則資訊必須由字母、數位、空格或字元 -:;.,!?#&$%*()/ 組成。',
    'web-app-firewall.auditLogSection' => 'ModSecurity 審計日誌',
    'web-app-firewall.auditLogHint1' => 'ModSecurity 審計日誌檔是系統中最重要的資訊。當 ModSecurity 檢測到任何發生的事件，就會在審計日誌檔中生成一個條目。',
    'web-app-firewall.auditLogHint2' => '當您修改 web 應用程式防火牆模式從關閉或僅檢測到打開時，一個網站可能會停止運行。如果出現這樣的情況，請分析 ModSecurity 審計日誌查找原因。您可以關閉特別嚴格的安全規則或調整網站。',
    'web-app-firewall.auditLogHint3' => '要找出為何一個網站上的 HTTP 請求無法完成：',
    'web-app-firewall.auditLogPoint1' => '點按下面的 ModSecurity 日誌檔連結並在新的瀏覽器視窗中打開審計日誌。',
    'web-app-firewall.auditLogPoint2' => '使用搜索（在大部分的 web 瀏覽器中按下 Ctrl+F）查找出問題的網站（域名）。例如，your_domain.tld。瀏覽器將會凸顯如 HOST: your_domain.tld 的條目。',
    'web-app-firewall.auditLogPoint3' => '在凸顯條目以上的三行中，找到如 --eece5138-B-- 的字串。連字號中間的八個字元（即 eece5138）是 HTTP 請求觸發的事件的 ID。',
    'web-app-firewall.auditLogPoint4' => '進一步查找帶有相同事件 ID 的其它條目。查找事件 ID 後面帶有字母 H 的條目（例如，eece5138-H--）。該條目包含 ID 和當檢查 HTTP 請求時觸發的安全規則的描述。安全規則 ID 是在方框內帶有 ID 首碼置於引號中的一個整數（例如， [id "340003"]）。',
    'web-app-firewall.auditLogPoint5' => '使用子字串（例如：[id "3）在事件中查找安全規則 ID。',
    'web-app-firewall.auditLogPoint6' => '在下面的安全規則部分關閉帶有該 ID 的安全規則：請輸入安全規則 ID（僅數位）到安全規則 ID 欄位然後點按確定。',
    'web-app-firewall.auditLogViewLink' => 'ModSecurity 日誌檔',
    'web-app-firewall.auditLogListLink' => '日誌壓縮檔',
    'web-app-firewall.errorLogSection' => '錯誤日誌',
    'web-app-firewall.errorLogSectionHint' => '當您修改 web 應用程式防火牆模式從關閉或僅檢測到打開時，一個網站可能會停止運行。如果出現這樣的情況，請分析錯誤日誌查找原因。您可以關閉特別嚴格的安全規則或調整網站。',
    'web-app-firewall.errorLogViewLink' => '錯誤日誌檔',
    'web-app-firewall.notificationStateEnabled' => '有關規則集更新的 Plesk UI 通知已開啟：%%notificationLink%%',
    'web-app-firewall.notificationStateDisabled' => '有關規則集更新的 Plesk UI 通知已關閉：%%notificationLink%%',
    'web-app-firewall.notificationLink' => '在通知頁面上對其管理',
    'web-app-firewall.tradeoffAndThoroughModeWarning' => '選擇“權衡”或“徹底”選項可能會導致WordPress網站故障，以及其他不必要的副作用，因為以下 <a href="https://github.com/SpiderLabs/ModSecurity/issues/562" target="_blank">ModSecurity 問題</a>。',

    'ProtectedDirectory.pathLabel' => '目錄名稱',
    'ProtectedDirectory.realmLabel' => '受保護區的標題',
    'ProtectedDirectory.locationLabel' => '目錄位置',
    'ProtectedDirectory.isNonSslLabel' => '非 SSL/TLS',
    'ProtectedDirectory.isCgiBinLabel' => 'cgi-bin',

    'SummaryReport.Layout.name' => '報告名稱',
    'SummaryReport.Layout.isDefault' => '作為默認報告',
    'SummaryReport.Layout.sections' => '部分',
    'SummaryReport.Layout.general' => '常用',
    'SummaryReport.Layout.resellers' => '代理商',
    'SummaryReport.Layout.clients' => '客戶',
    'SummaryReport.Layout.personalClients' => '個人客戶',
    'SummaryReport.Layout.domains' => '域名',
    'SummaryReport.Layout.personalDomains' => '個人域名',
    'SummaryReport.Layout.type.full' => '全量',
    'SummaryReport.Layout.type.summary' => '匯總',

    'SummaryReport.Schedule.enable' => '啟用',
    'SummaryReport.Schedule.period' => '發送頻率',
    'SummaryReport.Schedule.daily' => '每日',
    'SummaryReport.Schedule.weekly' => '每週',
    'SummaryReport.Schedule.monthly' => '每月',
    'SummaryReport.Schedule.email' => '發送到',
    'SummaryReport.Schedule.isEmpty' => '請輸入有效的電子郵件地址。',

    'MassMailForm.name' => '範本名稱',
    'MassMailForm.fromEmail' => '發自（電郵地址）',
    'MassMailForm.sendToAdmins' => '發送給 Plesk 管理員',
    'MassMailForm.sendToResellers' => '發送給代理商',
    'MassMailForm.sendToClients' => '發送給客戶',
    'MassMailForm.subject' => '主題',
    'MassMailForm.body' => '資訊文本',
    'MassMailForm.bodyDescription' => '
您可以在資訊文本（但不是標頭）中使用<name> 變數。這將會被客戶或代理商的連絡人名稱代替。',
    'MassMailForm.sendToResellersMode' => '發送給',
    'MassMailForm.sendToResellersModeAll' => '所有代理商',
    'MassMailForm.sendToResellersModeSelect' => '所選代理商',
    'MassMailForm.sendToResellersModeExcept' => '除所選外的全部代理商',
    'MassMailForm.sendToClientsMode' => '發送給',
    'MassMailForm.sendToClientsModeAll' => '所有客戶',
    'MassMailForm.sendToClientsModeSelect' => '所選客戶',
    'MassMailForm.sendToClientsModeExcept' => '除所選外的全部客戶',

    'VirtualDirectory.DirectorySection.title' => '虛擬目錄',
    'VirtualDirectory.DirectorySection.name' => '名稱',
    'VirtualDirectory.DirectorySection.accessSource' => '腳本源存取',
    'VirtualDirectory.DirectorySection.accessRead' => '讀取許可權',
    'VirtualDirectory.DirectorySection.accessWrite' => '寫入許可權',
    'VirtualDirectory.DirectorySection.enableDirBrowsing' => '目錄流覽',
    'VirtualDirectory.DirectorySection.log' => '日誌存取',
    'VirtualDirectory.Path.path' => '路徑',
    'VirtualDirectory.Path.autoPathLabel' => '建立與虛擬目錄相同名稱的實體目錄',
    'VirtualDirectory.ApplicationSettingsSection.title' => '應用程式設定',
    'VirtualDirectory.ApplicationSettingsSection.appCreate' => '創建應用程式',
    'VirtualDirectory.ApplicationSettingsSection.aspEnableParentPaths' => '允許使用父路徑',
    'VirtualDirectory.ApplicationSettingsSection.aspExecuteInMTA' => '允許應用程式在MTA(多執行緒單元)模式下運行',
    'VirtualDirectory.ScriptExecuteField.scriptExecute' => '執行許可權',
    'VirtualDirectory.SecuritySection.title' => '目錄安全性',
    'VirtualDirectory.SecuritySection.authAnonymous' => '啟用匿名驗證',
    'VirtualDirectory.SecuritySection.authNTLM' => '啟用 Windows 驗證',
    'VirtualDirectory.SecuritySection.requireSSL' => '需要 SSL/TLS',
    'VirtualDirectory.scriptExecuteOption.none' => '無',
    'VirtualDirectory.scriptExecuteOption.script' => '僅腳本',
    'VirtualDirectory.scriptExecuteOption.scriptExecute' => '腳本和可執行檔',
    'VirtualDirectory.AspSection.title' => 'ASP設定',
    'VirtualDirectory.AspSection.aspBufferingLimit' => 'ASP最大緩衝大小(KB)',
    'VirtualDirectory.AspSection.aspMaxRequestEntityAllowed' => 'ASP請求郵件正文的最大容量 (KB)',
    'VirtualDirectory.AspSection.aspEnableServerDebug' => '啟用 ASP 伺服器端腳本調試',
    'VirtualDirectory.AspSection.aspEnableClientDebug' => '啟用 ASP 用戶端腳本調試',
    'VirtualDirectory.AspSection.definedByIis' => '由IIS定義',
    'VirtualDirectory.AspSection.definedByIisWithSize' => '由IIS定義(%%size%% KB)',
    'VirtualDirectory.AspSection.definedByParent' => '由主目錄定義',
    'VirtualDirectory.AspSection.definedByParentWithSize' => '由主目錄定義(%%size%% KB)',
    'VirtualDirectory.AspSection.kbytes' => 'KB',
    'VirtualDirectory.CheckboxField.true' => '是',
    'VirtualDirectory.CheckboxField.false' => '否',
    'VirtualDirectory.DocumentsSection.title' => '文檔',
    'VirtualDirectory.DocumentsSection.enableDefaultDoc' => '使用默認文檔',
    'VirtualDirectory.DefaultDocsField.defaultDocs' => '預設文檔搜尋順序',
    'VirtualDirectory.DefaultDocsField.remove' => '移除',
    'VirtualDirectory.NewDefaultDoc.add' => '添加',
    'VirtualDirectory.NewDefaultDoc.addTooltip' => '按一下向列表中添加文件。',
    'VirtualDirectory.NewDefaultDoc.requiredWarning' => '輸入要添加到列表的檔案名.',
    'VirtualDirectory.PhysicalDirectoryConflictDialog.description' => '相同名稱的實體目錄已存在。若繼續，將無法存取此目錄。仍要繼續嗎？',
    'VirtualDirectory.PhysicalDirectoryConflictDialog.proceed' => '繼續',

    'VirtualDirectoryMimeType.extension' => '擴展名',
    'VirtualDirectoryMimeType.content' => '內容',
    'VirtualDirectoryMimeType.custom' => '自訂',
];