<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.

$messages = [
    'additional-key-info.title' => 'Властивості додаткового ключа',
    'additional-key-info.update' => 'Вивести додатковий ключ',
    'additional-key-info.updateDescription' => 'Отримайте додатковий ключ і встановіть його.',
    'additional-key-info.download' => 'Скачати ключ',
    'additional-key-info.downloadDescription' => 'Завантажте поточний ліцензійний ключ.',
    'additional-key-info.install' => 'Установити ключ',
    'additional-key-info.installDescription' => 'Установіть поточний ліцензійний ключ.',
    'additional-key-info.revert' => 'Повернутися до попереднього ключа',
    'additional-key-info.revertDescription' => 'Відновити попередній встановлений ліцензійний ключ.',
    'additional-key-info.revertNotAvailableDescription' => 'Жодного ключа не встановлено.',
    'additional-key-info.installSuccess' => 'Установлення ліцензійного ключа розпочато.',

    'additional-key-revert.title' => 'Відкат додаткового ключа',
    'additional-key-revert.success' => 'Відкат додаткового ключа виконано.',

    'additional-key-upload.title' => 'Установлення ліцензійного ключа',
    'additional-key-upload.success' => 'Новий додатковий ключ передано.',

    'additional-keys.title' => 'Додаткові ключі ліцензії',

    'change-subscriptions-owner.title' => 'Призначення нового власника для вибраних підписок',
    'change-subscriptions-owner.success' => 'Власника підписки змінено',

    'customers.hint' => 'Саме тут ви управляєте обліковими записами ваших хостинг-клієнтів: створюєте нові облікові записи поряд з підписками, керуєте існуючими клієнтами, і видаляєте облікові записи. Для адміністрування вебсайтів, поштових або будь-яких інших послуг, що надаються замовнику, перейдіть до Панелі Замовника, натиснувши на посилання в правому стовпчику переліку.',

    'customer-domains.hint' => 'Сторінка налаштування та управління веб-сайтами.',

    'customer-subscriptions.hint' => 'На цій сторінці ви можете управляти підписками замовника.',

    'domains.hint' => 'Тут доступна інформація стосовно імен усіх доменів, зареєстрованих у системі. Також тут можна отримати доступ до керування службами хостингу. Щоб додати домен для себе чи замовників, клацніть Add Domain (Додати домен). Під час створення домену вам буде запропоновано створити нового замовника й підписку або вибрати їх із існуючих.',

    'database-servers.title' => 'Сервери бази даних',

    'database-server-create.title' => 'Новий сервер бази даних',

    'database-server-properties.title' => 'Сервер бази даних',

    'database-server-upgrade.drawerTitle' => 'Оновлення MariaDB',
    'database-server-upgrade.drawerTitle.completed' => 'Оновлення завершено',
    'database-server-upgrade.drawerSubTitle.line1' => 'Неможливо закрити панель під час оновлення.',
    'database-server-upgrade.drawerSubTitle.line2' => 'Якщо під час оновлення виникають проблеми, перегляньте %%troubleshootingArticle%%.',
    'database-server-upgrade.drawerSubTitle.completed' => 'Сервер бази даних MariaDB оновлено до версії %%releaseVersion%%. Якщо у вас виникли проблеми, дотримуйтеся інструкцій з %%troubleshootingArticle%%.',
    'database-server-upgrade.upToDate' => 'У вас уже встановлена LTS-версія.',
    'database-server-upgrade.troubleshootingArticle' => 'стаття бази знань',
    'database-server-upgrade.troubleshootingArticleDescription' => 'Скористайтеся %%troubleshootingArticle%% для усунення проблем під час оновлення MariaDB.',

    'database-server-upgrade.chooseReleaseStep.infoBlock.par1' => 'Оновіть ваш локальний сервер бази даних MariaDB до поточної версії довгострокової підтримки (LTS).',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par2' => 'Наполегливо рекомендуємо перед оновленням зробити резервну копію сервера й розпочинати цей процес у непікові години роботи вебсайту.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par3' => 'Під час оновлення MariaDB сервер Plesk і розміщені на ньому вебсайти будуть недоступні. Зазвичай оновлення MariaDB відбувається без помилок і займає близько 10 хвилин, але воно здатне впливати на роботу всього сервера.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par4' => 'Примітка: якщо ви використовуєте MariaDB 5.5, Plesk спочатку оновить її до MariaDB 10.5. Після завершення оновлення запустіть майстра ще раз, щоб оновитися до поточної LTS-версії MariaDB.',
    'database-server-upgrade.chooseReleaseStep.currentVersionTitle' => 'Поточна версія',
    'database-server-upgrade.chooseReleaseStep.currentMariaDBVersion' => 'MariaDB %%version%%',
    'database-server-upgrade.chooseReleaseStep.selectVersion' => 'Обрати версію, до якої потрібно оновитися',
    'database-server-upgrade.chooseReleaseStep.noMajorReleases' => 'Основні випуски відсутні',
    'database-server-upgrade.chooseReleaseStep.releaseNotes' => 'Нотатки про випуск',
    'database-server-upgrade.chooseReleaseStep.releaseDate' => 'Дата випуску: %%date%%',
    'database-server-upgrade.chooseReleaseStep.endOfLifeDate' => 'Дата кінця терміну використання: %%date%%',
    'database-server-upgrade.chooseReleaseStep.notDetected' => 'Оновити можна лише відгалуження MariaDB, надані постачальниками ОС або MariaDB.',

    'database-server-upgrade.preUpgradeCheckProgressStep.title' => 'Перевірки перед оновленням',
    'database-server-upgrade.preUpgradeCheckProgressStep.configChecker' => 'Розбір файлів конфігурації MariaDB',
    'database-server-upgrade.preUpgradeCheckProgressStep.mysqlChecker' => 'Аналіз баз даних через mysqlcheck',
    'database-server-upgrade.preUpgradeCheckProgressStep.packageManagerChecker' => 'Аналіз конфігурації диспетчера пакетів',
    'database-server-upgrade.preUpgradeCheckProgressStep.systemCompatibilityChecker' => 'Перевірка сумісності системи',
    'database-server-upgrade.preUpgradeCheckProgressStep.webSocketChecker' => 'Перевірка WebSocket',

    'database-server-upgrade.preUpgradeCheckStep.shouldBeConfirmed' => 'Щоб продовжити оновлення, встановіть всі прапорці. Необхідно підтвердити, що ви згодні зі змінами конфігурації в результаті оновлення й що у вас є доступ до опцій відновлення.',
    'database-server-upgrade.preUpgradeCheckStep.removedSystemVariables' => 'Для сумісності з новою версією наступні змінні буде видалено:',
    'database-server-upgrade.preUpgradeCheckStep.fromFiles' => '{variable} з {count, plural, one {# файлу} few {# файлів} many {# файлів} other {# файлів}}',
    'database-server-upgrade.preUpgradeCheckStep.accessToolsSection' => 'Доступ до опцій відновлення (консоль командного рядка сервера й Repair Kit)',
    'database-server-upgrade.preUpgradeCheckStep.sshAccess' => 'Я підтверджую, що маю SSH-доступ до сервера',
    'database-server-upgrade.preUpgradeCheckStep.sshAccessDescription' => 'Використовуйте SSH-клієнт або відкрийте %%sshTerminalExtension%% у новій вкладці браузера (не закривайте вікно розширення SSH-термінала до завершення оновлення). Якщо оновлення не вдасться, наявність SSH-доступу допоможе у відновленні.',
    'database-server-upgrade.preUpgradeCheckStep.sshTerminalExtension' => 'Розширення SSH-терміналу',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccess' => 'Я підтверджую, що маю доступ до Repair Kit',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccessDescription' => 'Відкрийте %%repairKit%% у новій вкладці браузера й увійдіть до системи, використовуючи облікові дані адміністратора. Не закривайте вікно розширення Repair Kit до завершення оновлення.',
    'database-server-upgrade.preUpgradeCheckStep.repairKit' => 'Repair Kit',
    'database-server-upgrade.preUpgradeCheckStep.dumpSection' => 'Створити резервну копію баз даних',
    'database-server-upgrade.preUpgradeCheckStep.withDump' => 'Перед оновленням створіть резервну копію всіх баз даних, розміщених на сервері',
    'database-server-upgrade.preUpgradeCheckStep.withDumpDescription' => 'Plesk зберігатиме резервну копію баз даних у каталозі %%path%%.',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailable' => 'WebSocket у Plesk недоступний',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailableDescription' => 'Без WebSocket ви не зможете побачити результати процесу оновлення в реальному часі.',

    'database-server-upgrade.submitPopover.title' => 'Щоб запобігти потенційній втраті даних, ми наполегливо рекомендуємо створити дамп розміщених баз даних перед тим, як продовжити. Продовжити без створення дампу?',

    'database-server-databases.title' => 'Бази даних',

    'database-server-change-password.title' => 'Пароль адміністратора',

    'home.title' => 'Головна сторінка',

    'license.title' => 'Інформація про ліцензію',

    'primary-key-info.title' => 'Ліцензійний ключ Plesk',
    'primary-key-info.update' => 'Отримання ключів',
    'primary-key-info.updateDescription' => 'Отримати замовлені ліцензійні ключі та встановити їх.',
    'primary-key-info.upload' => 'Установити ключ',
    'primary-key-info.uploadDescription' => 'Вивантажити та встановити новий ліцензійний ключ.',
    'primary-key-info.revert' => 'Повернутися до попереднього ключа',
    'primary-key-info.revertDescription' => 'Відновити попередній встановлений ліцензійний ключ.',

    'primary-key-revert.title' => 'Відкат ліцензійного ключа',
    'primary-key-revert.success' => 'Відкат ключа Plesk виконано.',

    'primary-key-upload.title' => 'Установлення ліцензійного ключа',
    'primary-key-upload.success' => 'Новий ключ Plesk передано.',

    'resellers.hint' => 'Тут доступне керування обліковими записами посередників, тобто ваших замовників, які перепродають послуги з хостингу та розміщують свої власні сайти. Тут можна створювати облікові записи та підписки на послуги, керувати існуючими посередниками та видаляти облікові записи.',

    'reseller-customers.hint' => 'Тут доступне налаштування та керування замовниками.',

    'reseller-domains.hint' => 'Сторінка налаштування та управління веб-сайтами.',

    'reseller-subscriptions.hint' => 'Тут доступне керування підписками посередників.',

    'subscriptions.hint' => 'Клієнти отримують послуги з хостингу, коли оформлюють підписку на певний план. Тут можна керувати цими та власними підписками, які ви створюєте для розміщення власних сайтів. Для адміністрування сайтів, поштових чи будь-яких інших послуг, що надаються за підпискою, перейдіть до клієнтської панелі (Customer Panel) передплатника, клацнувши на посилання у правому стовпчику списку.',

    'server-mail-settings.title' => 'Налаштування',
    'server-mail-spam-filter.title' => 'Фільтрація спаму',
    'server-mail-antivirus.title' => 'Антивірус',
    'server-mail-black-list.title' => 'Чорний список',
    'server-mail-white-list.title' => 'Білий список',
    'server-mail-queue.title' => 'Черга електронної пошти',
    'server-mail-statistics.title' => 'Статистика',
    'server-mail-smarthost.title' => 'Smarthost',

    'server-spam-filter.settings' => 'Налаштування',
    'server-spam-filter.black-list' => 'Чорний список',
    'server-spam-filter.white-list' => 'Білий список',

    'firewall.title' => 'Управління мережевим екраном',
    'firewall-general.title' => 'Загальні дані',
    'firewall-general.toggleStatus' => 'Захист брандмауером',
    'firewall-general.buttonDefault' => 'Відновити налаштування за замовчуванням',
    'firewall-general.buttonPanic' => 'Panic Mode',
    'firewall-general.confirmationDefault' => 'Скинути налаштування брандмауера на стандартні?',
    'firewall-general.confirmationPanic' => 'Увімкнути режим паніки? Користувачі не зможуть отримати доступ до своїх доменів, а деякі мережеві служби можуть припинити працювати.',
    'firewall-general.successDefault' => 'Параметри брандмауера скинуто до значень за умовчанням.',
    'firewall-general.successPanic' => 'Режим паніки ввімкнено.',
    'firewall-general.info' => 'З міркувань безпеки брандмауер блокує всі підключення, крім явно дозволених. Аби дозволити підключення, можна створити правило. Додаткову інформацію див. у документації',
    'firewall-general.interfaces' => 'Інтерфейси мережі',
    'firewall-icmp.title' => 'Протокол ICMP',
    'firewall-rules.title' => 'Правила мережевого екрана',

    'dns.title' => 'Налаштування DNS',
    'dns-records.title' => 'Шаблон зональних записів',
    'dns-soa-record.title' => 'Шаблон налаштувань зони',

    'php-handler.title' => 'Параметри для %%name%%',
    'php-handler.extensions.title' => 'Розширення',
    'php-handler.extensions.description' => 'Ці налаштування PHP-розширення є тільки для цього обробника.',
    'php-handler.extensions.descriptionShared' => 'Ці налаштування є спільними для таких обробників PHP: %%handlers%%. Налаштування застосовуються до всіх вебсайтів, що використовують ці обробники.',
    'php-handler.extensions.buttonManage' => 'Керування пакетами PECL',
    'php-handler.extensions.manage.title' => 'Керування пакетами PECL',
    'php-handler.extensions.manage.risks' => 'Розширення PHP надаються сторонніми пакетами PECL. Установлюйте їх на власний ризик.',
    'php-handler.extensions.manage.description' => 'Установлення, оновлення й видалення пакетів PECL. Зміни буде застосовано до всіх вебсайтів, які працюють на %%handlers%%.',
    'php-handler.extensions.manage.notFound' => 'Чому потрібного пакету немає в списку?',
    'php-handler.extensions.manage.limitations' => 'Розширення PHP, надані постачальником панелі керування та постачальниками ОС, не відображаються у списку.',
    'php-handler.php-ini.title' => 'php.ini',


    'ServerInformation.refresh' => "Оновити",
    'ServerInformation.sectionGeneral' => "Загальні дані",
    'ServerInformation.cpu' => "ЦП",
    'ServerInformation.version' => "Версія",
    'ServerInformation.os' => "Операційна система",
    'ServerInformation.key' => "Ліцензійний ключ Plesk",
    'ServerInformation.uptime' => "Час роботи",
    'ServerInformation.uptimeValue' => "{days, plural, =0 {} one {# день} few {# дні} many {# днів} other {# дні}} {hours, plural, one {# година} few {# години} many {# годин} other {# години}} {minutes, plural, one {# хвилина} few {# хвилини} many {# хвилин} other {# хвилини}}",
    'ServerInformation.sectionCpu' => "Використання ЦП",
    'ServerInformation.la1min' => "Останню хвилину",
    'ServerInformation.la5min' => "Останні 5 хвилин",
    'ServerInformation.la15min' => "Останні 15 хвилин",
    'ServerInformation.sectionMemory' => "Використання пам’яті",
    'ServerInformation.memoryHardware' => "Апаратне забезпечення",
    'ServerInformation.memoryTotalNoKernel' => "Загалом (за винятком ядра)",
    'ServerInformation.memoryTotal' => "Повний",
    'ServerInformation.memoryUsed' => "Використано",
    'ServerInformation.memoryFree' => "Вільно",
    'ServerInformation.memoryShared' => "Спільного користування",
    'ServerInformation.memoryBuffer' => "Буфер",
    'ServerInformation.memoryCached' => "Збережено",
    'ServerInformation.memoryAvailable' => "Доступний",
    'ServerInformation.memoryUsage' => "Використання",
    'ServerInformation.sectionSwap' => "Користування обміном",
    'ServerInformation.sectionVirtualMemory' => "Використання віртуальної пам’яті",
    'ServerInformation.swapTotal' => "Повний",
    'ServerInformation.swapUsed' => "Використано",
    'ServerInformation.swapFree' => "Вільно",
    'ServerInformation.swapUsage' => "Використання",
    'ServerInformation.sectionHarddisk' => "Використання жорсткого диску",
    'ServerInformation.harddiskDirectory' => "Система файлів",
    'ServerInformation.harddiskProtectedDir' => "Важливі каталоги",
    'ServerInformation.harddiskTotal' => "Повний",
    'ServerInformation.harddiskUsed' => "Використано",
    'ServerInformation.harddiskAvailable' => "Доступний",
    'ServerInformation.harddiskCapacity' => "Ємкість",
    'ServerInformation.sectionDomains' => "Домени",
    'ServerInformation.activeDomains' => "Активне",
    'ServerInformation.inactiveDomains' => "Неактивне",
    'ServerInformation.problemDomains' => "Помилки",
    'ServerInformation.refreshed' => "Інформацію оновлено.",

    'ServerAbout.copyright' => '© 2024 WebPros International GmbH. Всі права захищені.',
    'ServerAbout.linkLicenseManagement' => 'Перейти до інформації про ліцензію',
    'ServerAbout.panelVersion' => 'Версія',
    'ServerAbout.installedPatchVersion' => 'Оновлення #%%patch%%',
    'ServerAbout.licenseKey' => 'Ліцензійний ключ',
    'ServerAbout.productDescription' => 'Plesk є передовою платформою WebOps із запуску, автоматизації та розвитку застосункыв, вебсайтів та хостингу бізнесу.',
    'ServerAbout.readEula' => 'Читайте %%link%%.',
    'ServerAbout.linkEula' => 'Ліцензійна угода для кінцевого користувача',
    'ServerAbout.visitForum' => 'Відвідайте %%link%%.',
    'ServerAbout.linkForum' => 'Форум Plesk',
    'ServerAbout.followUs' => 'Слідкуйте за нами',
    'ServerAbout.visitSite' => 'Дізнайтеся більше за адресою %%link%%',
    'ServerAbout.linkSite' => 'plesk.com',
    'ServerAbout.visitBlog' => 'Знайдіть натхнення на %%link%%',
    'ServerAbout.linkBlog' => 'Блог Plesk',

    'ServerAbout.darkThemePromoTitle' => 'Вітаємо!',
    'ServerAbout.darkThemePromoDescription' => 'Ви знайшли чарівне кошенятко.',
    'ServerAbout.darkThemePromoButton' => 'Вжух! Переходьте на темну сторону!',
    'ServerAbout.darkThemeTourDescription' => 'Увімкніть або вимкніть цей параметр, щоб увімкнути чи вимкнути темну тему інтерфейсу.',
    'ServerAbout.darkThemeTourButton' => 'Зрозуміло',

    'ts-sessions.title' => 'Сеанси термінального сервера',
    'ts-sessions-properties.title' => 'Властивості сеансу',

    'BandwidthLimiting.bandwidthThrottling' => 'Ви не можете регулювати смугу пропускання, оскільки не встановлено QoS.',
    'BandwidthLimiting.virtualHostingRequired' => 'Обмеження смуги пропускання доступне тільки для доменів із веб-хостингом.',
    'BandwidthLimiting.bandwidthLabel' => 'Максимальне використання смуги пропускання',
    'BandwidthLimiting.bandwidthHint' => 'Обмеження використання смуги пропускання застосовується лише до даних, що передаються через протокол HTTP.',
    'BandwidthLimiting.maxConnectionLabel' => 'З’єднання обмежені до',
    'BandwidthLimiting.maxConnectionHint' => 'Якщо ви обмежуєте смугу пропускання, рекомендується також обмежити кількість одночасних підключень до вебсайту. Інакше в разі частих запитів до сайту процеси вебсервера збільшать навантаження на сервер.',
    'BandwidthLimiting.kbps' => 'КБ/с',
    'BandwidthLimiting.success' => 'Налаштування обмеження смуги пропускання змінено.',
    'BandwidthLimiting.unlimited' => 'Необмежений',

    'ip-address-domains.title' => 'Вебсайти, які використовують %%type%% ІР-адресу %%ipAddress%%',
    'ip-address-domains.site' => 'Сайт',
    'ip-address-domains.setAsDefault' => 'Встановити за замовчуванням',
    'ip-address-domains.type-SHARED' => 'спільна',
    'ip-address-domains.type-EXCLUSIVE' => 'виділена',

    'HotlinkProtection.virtualHostingRequired' => 'Захист від прямого посилання доступний тільки для доменів із веб-хостингом.',
    'HotlinkProtection.enabledLabel' => 'Увімкнути захист від прямого посилання',
    'HotlinkProtection.extensionsLabel' => 'Розширення захищених файлів',
    'HotlinkProtection.friendsLabel' => 'Адреси дружніх вебсайтів',
    'HotlinkProtection.success' => 'Налаштування захисту від прямого посилання змінені.',

    'Odbc.add' => 'Додати нове ODBC DSN',
    'Odbc.resourceUsage' => '%%used%% створено / %%allowed%% дозволено',
    'Odbc.limitExceeded' => 'Обмеження для підключення ODBC DSN перевищено.',
    'Odbc.unlimited' => 'Необмежений',
    'Odbc.addTooltip' => 'Додати джерело даних ODBC.',
    'Odbc.status' => 'Статус',
    'Odbc.name' => 'Ім’я з’єднання',
    'Odbc.driver' => 'Драйвер',
    'Odbc.description' => 'Опис з’эднання',
    'Odbc.hostname' => 'Ім’я вузла',
    'Odbc.statusSystem' => 'Це системний DSN.',
    'Odbc.statusConfigured' => 'DSN сконфігуровано.',
    'Odbc.statusNotConfigured' => 'DSN не сконфігуровано.',
    'Odbc.noSelectionText' => 'Виберіть один або кілька елементів, які потрібно видалити.',
    'Odbc.removeConfirmation' => 'Видалити {count, plural, =1 {підключення {name}} one {# вибране підключення} few {# вибрані підключення} many {# вибраних підключень} other {# вибрані підключення}}?',
    'Odbc.removeSuccess' => 'Вибрані підключення видалено.',

    'DomainAliasSettings.title' => 'Налаштування псевдоніма домену',
    'DomainAliasSettings.updateSuccess' => 'Властивості псевдоніма домену %%name%% змінено. %%apacheRestartInterval%%',
    'DomainAliasSettings.apacheRestartInterval' => 'Параметри веб-сайту будуть застосовані через %%restartInterval%% хвилин.',

    'Home.Backup.offStatus' => 'Це недійсна резервна копія. Дані не можна відновити з цього файлу.',
    'Home.Backup.task-failedStatus' => 'Завдання з резервного копіювання пройшло невдало.',
    'Home.Backup.activeSchedule' => 'План: %%schedule%%',
    'Home.Backup.activeSchedules' => 'Плани: %%schedules%%',
    'Home.Backup.noSchedule' => "План резервного копіювання не встановлено",
    'Home.Backup.period_hourly' => 'Щогодинний %%schedule%%',
    'Home.Backup.period_daily' => 'Щоденний %%schedule%%',
    'Home.Backup.period_weekly' => 'Щотижневий %%schedule%%',
    'Home.Backup.period_monthly' => 'Щомісячний %%schedule%%',
    'Home.Backup.create' => 'Створити резервну копію',
    'Home.Backup.schedule' => 'Графік',
    'Home.ChangeLog.seeHistory' => 'Подивитися історію змін',
    'Home.CustomButtons.add' => 'Додати користувацьку кнопку',
    'Home.CustomButtons.noButtons' => 'Немає користувацьких кнопок',
    'Home.Customization.title' => 'Панель',
    'Home.Customization.description' => 'Виберіть, які опції ви хотіли б бачити',
    'Home.Customization.pleskSection' => 'Plesk',
    'Home.Customization.serverSection' => 'Сервер',
    'Home.Customization.securitySection' => 'Безпека',
    'Home.Customization.backup' => 'Остання резервна копія сервера',
    'Home.Customization.ipBan' => 'Заборона IP-адреси',
    'Home.Customization.mailQueue' => 'Черга електронної пошти',
    'Home.Customization.mySubscriptions' => 'Мої підписки',
    'Home.Customization.overusedSubscriptions' => 'Підписки з надмірним використанням',
    'Home.Customization.serverInfo' => 'Інформація сервера',
    'Home.Customization.updates' => 'Оновлення Plesk',
    'Home.Customization.promo' => 'Рекламний ролик',
    'Home.Customization.changeLog' => 'Що нового',
    'Home.Customization.customButtons' => 'Користувацькі кнопки',
    'Home.EmptyView.title' => 'Отримайте максимум від своєї панелі, вибравши, що хочете бачити.',
    'Home.EmptyView.titleLocked' => 'Ваш постачальник послуг заблокував панель.',
    'Home.EmptyView.customize' => 'Персоналізувати',
    'Home.Extension.title' => 'Модуль',
    'Home.IpBan.banned' => 'Заборонено',
    'Home.IpBan.trusted' => 'Надійний',
    'Home.IpBan.more' => 'Докладніше',
    'Home.MailQueue.total' => 'Повний',
    'Home.MailQueue.deferred' => 'Відкладено',
    'Home.MailQueue.held' => 'Утримано',
    'Home.MailQueue.more' => 'Докладніше',
    'Home.MailQueue.clean' => 'Очистити чергу пошти',
    'Home.MailQueue.checkLogs' => 'Перевірити журнали',
    'Home.MailQueue.repair' => 'Відновити',
    'Home.MailQueue.cleanConfirmQuestion' => 'Очистити чергу пошти?',
    'Home.MailQueue.cleanConfirmYes' => 'Так',
    'Home.MailQueue.cleanConfirmNo' => 'Ні',
    'Home.MailQueue.queueCleaned' => 'Поштова чергу успішно очищено.',
    'Home.MailQueue.Promo.title' => 'З легкістю отримуйте доступ до статусу доставки й журналів',
    'Home.MailQueue.Promo.link' => 'Спробуйте нову чергу пошти прямо зараз',
    'Home.OverusedSubscriptions.empty' => 'Підписок із надмірним використанням не знайдено',
    'Home.OverusedSubscriptions.usage' => '%%formattedUsed%% з %%formattedValue%%',
    'Home.OverusedSubscriptions.more' => 'Переглянути всі з надмірним використанням: [%%total%%]',
    'Home.OverusedSubscriptions.list' => 'Відкрити в списку',
    'Home.PromoNewHomeView.title' => 'Ласкаво просимо до нової головної сторінки!',
    'Home.PromoNewHomeView.description' => 'Якщо у вас виникли проблеми, надішліть нам відгук. Це допоможе нам у подальшому вдосконаленні.',
    'Home.PromoNewHomeView.feedback' => 'Надати відгук',
    'Home.PromoNewHomeView.switch' => 'Перемкнути назад на головну сторінку',
    'Home.ServerInfo.hostname' => 'Ім’я вузла',
    'Home.ServerInfo.ipAddress' => 'IP-адреса',
    'Home.ServerInfo.publicIpAddress' => 'Загальнодоступна IP-адреса',
    'Home.ServerInfo.os' => 'ОС',
    'Home.ServerInfo.uptime' => 'Час роботи',
    'Home.ServerInfo.uptimeValue' => "{days, plural, =0 {} one {# день} few {# дні} many {# днів} other {# дні}} {hours, plural, one {# година} few {# години} many {# годин} other {# години}} {minutes, plural, one {# хвилина} few {# хвилини} many {# хвилин} other {# хвилини}}",
    'Home.ServerInfo.more' => 'Докладніше',
    'Home.Subscriptions.add' => 'Додати нову',
    'Home.Subscriptions.empty' => 'Створюйте підписки для розміщення кількох вебсайтів у ізольованому просторі на сервері. %%link%%',
    'Home.Subscriptions.help' => 'Дізнатися більше',
    'Home.Updates.title' => 'Оновлення продукту',
    'Home.Updates.version' => '%%name%% %%version%%',
    'Home.Updates.patch' => '%%version%% Оновити #%%patch%%',
    'Home.Updates.manageComponents' => 'Додати або видалити компоненти',
    'Home.Updates.lastUpdated' => 'Дата останнього оновлення: %%lastUpdateDate%%',
    'Home.Updates.checkUpdates' => 'Перевірити оновлення',
    'Home.Updates.enableAutoupdate' => 'Дозволити автоматичні оновлення',
    'Home.Updates.lastChecked' => 'Дата останньої перевірки: %%lastCheckDate%%',
    'Home.Updates.newVersionAvailable' => 'Доступна версія: %%availableVersion%%',
    'Home.Updates.installNewVersion' => 'Установити зараз',
    'Home.Updates.patchAvailable' => 'Доступні поточні оновлення',
    'Home.Updates.patchAvailableVersion' => 'Доступні поточні оновлення для %%currentVersion%%',
    'Home.Updates.installPatch' => 'Оновити зараз',
    'Home.Updates.pumUpdates' => 'Доступно: {total, select, 1 {оновлення для {package}} other {оновлень для {package}}}',
    'Home.Updates.pumPackage' => '%%name%% %%availableVersion%%',
    'Home.Updates.pumPackages' => '{total, plural, one {# пакет} few {# пакети} many {# пакетів} other {# пакети}}',
    'Home.Updates.installUpdates' => '{total, select, 1 {Оновити зараз} other {Оновити все}}',
    'Home.Promo.Customize.title' => 'Персоналізуйте свою панель!',
    'Home.Promo.Customize.content' => 'Улюблені функції завжди під рукою завдяки новій налаштовуваній панелі',
    'Home.Promo.Customize.action' => 'Персоналізувати',
    'Home.Promo.SwitchToPuv.title' => 'Чи знаєте ви про подання інтерфейсів у Plesk?',
    'Home.Promo.SwitchToPuv.content' => 'Якщо ви не надаєте своїм клієнтам послуги хостингу за планами послуг, спробуйте інтерфейс, який є зручнішим для керування вебсайтами, їхніми файлами, базами даних, обліковими записами електронної пошти й вебпрограмами.',
    'Home.Promo.SwitchToPuv.action' => 'Спробувати зараз',
    'Home.Status.error' => 'Помилка',
    'Home.Status.warning' => 'Попередження',
    'Home.Status.info' => 'Інформація',

    'HostingSettings.title' => 'Параметри хостингу',
    'HostingSettings.updateSuccess' => 'Параметри оновлені.',
    'HostingSettings.emptyLogin' => 'Вам необхідно вказати ім’я користувача',
    'HostingSettings.emptyPassword' => 'Вам необхідно ввести пароль.',
    'HostingSettings.ipV6OnlyNotSupported' => 'Сервер FTP не підтримує IPv6. Виділіть хоча б одну IPv4-адресу, інакше користувач не зможе вивантажувати файли на сервер через FTP.',
    'HostingSettings.domainSettingsSection.sectionTitle' => 'Налаштування домену',
    'HostingSettings.domainSettingsSection.domainName' => 'Ім\'я домену',
    'HostingSettings.domainSettingsSection.description' => 'Наприклад: example.com ',

    'HostingSettings.submitPopover.title' => 'Видалити вміст %%website%%',
    'HostingSettings.submitPopover.descriptionMainDomain' => 'При переключенні типу хостингу "Веб-сайт" на %%type%% буде остаточно видалено весь вміст сайту, включаючи наступні каталоги:',
    'HostingSettings.submitPopover.descriptionSubDomain' => 'Ви хочете змінити тип хостингу для вашого веб-сайту?',

    'HostingSettings.domainSettingsSection.creatingWebspaceAlert' => 'Щоб отримати доступ до додаткових налаштувань, уведіть облікові дані користувача системи й клацніть «Створити вебпростір».',
    'HostingSettings.domainSettingsSection.creatingHostingAlert' => 'Щоб отримати доступ до додаткових налаштувань, клацніть «Далі», щоб створити хостинг.',
    'HostingSettings.domainSettingsSection.hostingTypeTitle' => 'Тип хостингу',
    'HostingSettings.domainSettingsSection.hostingType.title' => 'Тип',
    'HostingSettings.domainSettingsSection.hostingType.website' => 'Веб-сайт',
    'HostingSettings.domainSettingsSection.hostingType.forwarding' => 'Пересилання',
    'HostingSettings.domainSettingsSection.hostingType.noHosting' => 'Немає веб-хостингу',
    'HostingSettings.domainSettingsSection.hostingType.noHostingHint' => 'Щоб розмістити поштові скриньки під цим доменним іменем, використовуйте зону DNS домену',
    'HostingSettings.domainSettingsSection.hostingType.pathToTheWebsite' => 'Шлях до домашнього каталогу вебсайту',
    'HostingSettings.domainSettingsSection.preferredDomainTitle' => 'Домен, якому надається перевага',
    'HostingSettings.domainSettingsSection.preferredDomainDescription' => 'Відвідувачів буде переспрямовано сюди за допомогою переспрямовування HTTP 301, яке підтримує SEO.',
    'HostingSettings.domainSettingsSection.forwardVisitorsTo' => 'Переадресувати відвідувачів до',
    'HostingSettings.domainSettingsSection.forwardingType.title' => 'Тип переспрямування',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanently' => 'Переміщений назавжди (код 301)',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanentlyDescription' => 'Переспрямовуйте відвідувачів вебсайту на інший вебсайт і показуйте їм адресу призначення. Таке переспрямування збереже пошуковий рейтинг сайту',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarily' => 'Переміщений тимчасово (код 302)',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarilyDescription' => 'Переспрямувати відвідувачів веб-сайту на тимчасову копію сайту, коли ви не бажаєте, щоб системи пошуку індексували цей тимчасовий сайт.',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwarding' => 'Переадресація фрейму',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwardingDescription' => 'Переспрямувати відвідувачів на інший сайт, але сховати цільову адресу, щоб користувачі про переспрямування не знали.',
    'HostingSettings.domainSettingsSection.preferredDomain.title' => 'Домен, якому надається перевага',
    'HostingSettings.domainSettingsSection.preferredDomain.none' => 'Немає',
    'HostingSettings.domainSettingsSection.preferredDomain.www' => 'www.%%domainName%%',
    'HostingSettings.domainSettingsSection.documentRootTitle' => 'Кореневий каталог документів',
    'HostingSettings.domainSettingsSection.documentRootHint' => 'Неможливо змінити кореневий каталог документів, тому що на цьому сайті є встановлені веб-застосунки.',
    'HostingSettings.domainSettingsSection.save' => 'Зберегти',
    'HostingSettings.domainSettingsSection.sameSsl.title' => 'Режим сумісності',
    'HostingSettings.domainSettingsSection.sameSsl.enabled' => 'Запустіть вебсайт у режимі сумісності для старої опції "Розділяти контент SSL/TLS та non-SSL/TLS"',
    'HostingSettings.domainSettingsSection.sameSsl.hint' => 'Цей вебсайт працює в режимі сумісності, тому ним не можна керувати за допомогою інтерфейсу Plesk. Це пов\'язано з тим, що перед оновленням ви використовували застарілу опцію «Різний вміст з SSL/TLS і без SSL/TLS». Починаючи з Plesk 11, вміст вебсайту, доступний через з’єднання HTTP й HTTPS, зберігається в одному каталозі. Ми рекомендуємо перемістити всі дані з каталогу «httpsdocs/» до «httpdocs/», а потім вимкнути режим сумісності. Це також зробить програми, встановлені в каталозі «httpsdocs/» доступними через Інтернет. Зверніть увагу, що ви не зможете знову увімкнути режим сумісності.',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogTitle' => 'Змінити це налаштування?',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogDescription' => 'Зміна цього налаштування суперечить політиці безпеки сервера й може негативно вплинути на продуктивність або призвести до вразливості сервера.',
    'HostingSettings.domainSettingsSection.security.buttonChange' => 'Змінити',
    'HostingSettings.domainSettingsSection.security.buttonRevert' => 'Повернути',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetApplied' => 'Застосовано шаблон безпечних налаштувань',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetMessage' => 'Для покращення безпеки використовуйте попередньо встановлені налаштування безпеки. Зверніть увагу, що певні дозволи надають передплатникам можливість змінювати ці налаштування.',
    'HostingSettings.domainSettingsSection.security.applySecureSettingsPreset' => 'Застосувати попереднє налаштування безпеки',
    'HostingSettings.domainSettingsSection.security.exploreSecureSettings' => 'Дізнайтеся про налаштування безпеки хостингу',
    'HostingSettings.domainSettingsSection.security.sslTlsSupport' => 'Підтримка SSL/TLS',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportEnabled' => 'Увімкнено',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportDescription' => 'Шифрувати з\'єднання між вебсайтом і браузером відвідувача.',
    'HostingSettings.domainSettingsSection.security.certificate' => 'Сертифікат',
    'HostingSettings.domainSettingsSection.security.certificateDescription' => 'Щоб увімкнути HTTPS, завантажте у репозиторій домену сертифікат SSL/TLS і виберіть його тут.',
    'HostingSettings.domainSettingsSection.security.permanentRedirect' => 'Переспрямовувати відвідувачів з HTTP на HTTPS за допомогою переспрямовування 301, що підтримує SEO',
    'HostingSettings.domainSettingsSection.security.noCertificates' => 'У вашому сховищі немає жодного сертифікату SSL/TLS. Щоб додати сертифікат, перейдіть за посиланням %%link%%.',
    'HostingSettings.domainSettingsSection.security.noCertificatesLink' => 'ця сторінка',
    'HostingSettings.domainSettingsSection.security.certificateFromDomainRepository' => '%%name%% (%%repository%%)',
    'HostingSettings.domainSettingsSection.security.certificateFromOtherRepository' => '%%name%% (інше сховище)',
    'HostingSettings.domainSettingsSection.security.certificateNotSelected' => 'Не вибрано',
    'HostingSettings.domainSettingsSection.webScripting.title' => 'Написання веб-скриптів',
    'HostingSettings.domainSettingsSection.webScripting.description' => 'Вибрати мови програмування й опису сценаріїв, які вебсервер має виконувати в режимі інтерпретування.',
    'HostingSettings.domainSettingsSection.webScripting.fastCgi' => 'FastCGI',
    'HostingSettings.domainSettingsSection.webScripting.cgi' => 'CGI',
    'HostingSettings.domainSettingsSection.webScripting.cgiReadonly' => 'каталог cgi-bin розташований у %%value%%',
    'HostingSettings.domainSettingsSection.webScripting.ssi' => 'SSI',
    'HostingSettings.domainSettingsSection.webScripting.ssiHtml' => 'Використовувати SSI для файлів *.htm, *.html',
    'HostingSettings.domainSettingsSection.webScripting.asp' => 'Microsoft ASP',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNet' => 'Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNetVersion' => 'Версія Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.perl' => 'Perl',
    'HostingSettings.domainSettingsSection.webScripting.python' => 'Python',
    'HostingSettings.domainSettingsSection.webScripting.customErrorDocuments' => 'Персоналізовані документи помилок',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.title' => 'каталог cgi-bin розташований у',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.wwwRoot' => 'корінь документа цього домену',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.webspace' => 'кореневий каталог веб-простору',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.oldStyle' => 'кореневий каталог старого стилю цього домену',
    'HostingSettings.domainSettingsSection.webScripting.errorDocs' => 'Персоналізовані документи помилок',
    'HostingSettings.domainSettingsSection.webScripting.writeModify' => 'Додаткові права запису/модифікування',
    'HostingSettings.domainSettingsSection.webScripting.webDeploy' => 'Публікування Web Deploy',
    'HostingSettings.domainSettingsSection.webStatistics.title' => 'Веб-статистика',
    'HostingSettings.domainSettingsSection.webStatistics.tool' => 'Інструмент',
    'HostingSettings.domainSettingsSection.webStatistics.webstatProtected' => 'Заблокуйте доступ до статистики вашого вебсайту, використовуючи ваше користувацьке ім\'я FTP та пароль.',
    'HostingSettings.domainSettingsSection.webStatistics.disabled' => 'Вимкнений',

    'HostingSettings.webspaceSettingsSection.sectionTitle' => 'Налаштування веб-простору',
    'HostingSettings.webspaceSettingsSection.ipAddresses' => 'ІР-адреси',
    'HostingSettings.webspaceSettingsSection.quota.title' => 'Квота дискового простору',
    'HostingSettings.webspaceSettingsSection.quota.enabled' => 'Увімкнено',
    'HostingSettings.webspaceSettingsSection.quota.description' => 'Заборонити операції з файлами вебсайту, якщо квоту дискового простору, вибрану в налаштуваннях підписки (якщо є), перевищено.',
    'HostingSettings.webspaceSettingsSection.quota.unlimitedDesc' => 'Квота жорсткого диска не підтримується конфігурацією файлової системи сервера.',
    'HostingSettings.webspaceSettingsSection.quota.mbUnits' => 'Мбайт',
    'HostingSettings.webspaceSettingsSection.quota.readonly' => '%%quota%% MB',
    'HostingSettings.webspaceSettingsSection.systemUser' => 'Дані входу користувачів системи',
    'HostingSettings.webspaceSettingsSection.systemUserUnixDesc' => 'Керувати файлами й папками вебсайту через FTP або за допомогою файлового менеджера. Отримати доступ до сервера через SSH, якщо дозволено.',
    'HostingSettings.webspaceSettingsSection.systemUserWinDesc' => 'Керувати файлами й папками вебсайту через FTP або за допомогою файлового менеджера. Отримати доступ до сервера через віддалений робочий стіл, якщо дозволено.',
    'HostingSettings.webspaceSettingsSection.systemUserLogin' => 'Ім\'я користувача',
    'HostingSettings.webspaceSettingsSection.systemUserPasswd' => 'Пароль',
    'HostingSettings.webspaceSettingsSection.systemUserPasswdDesc' => 'Для того, щоб змінити пароль системного користувача, укажіть новий пароль тут.',
    'HostingSettings.webspaceSettingsSection.shell.unixTitle' => 'SSH-доступ',
    'HostingSettings.webspaceSettingsSection.shell.winTitle' => 'Доступ до віддаленого робочого столу',
    'HostingSettings.webspaceSettingsSection.shell.enabled' => 'Увімкнено',
    'HostingSettings.webspaceSettingsSection.shell.description' => "Отримати доступ до сервера за допомогою облікових даних системного користувача.",
    'HostingSettings.webspaceSettingsSection.shell.type' => 'Тип',
    'HostingSettings.webspaceSettingsSection.shell.disabled' => 'Вимкнений',
    'HostingSettings.webspaceSettingsSection.affectedDomainsLabel' => 'Для {count, plural, one {домену} few {# доменів} many {# доменів} other {# доменів}}',
    'HostingSettings.webspaceSettingsSection.affectedDomainsDescription' => 'Наступні налаштування є спільними для {count, plural, one {домену у веб-просторі {name}} few {# доменів у веб-просторі {name}} many {# доменів у веб-просторі {name}} other {# доменів у веб-просторі {name}}}:',

    'OdbcAdd.title' => 'Додати нове ODBC DSN',
    'OdbcAdd.nameLabel' => 'Ім’я з’єднання',
    'OdbcAdd.descriptionLabel' => 'Опис з’эднання',
    'OdbcAdd.driver' => 'Драйвер',
    'OdbcAdd.submit' => 'Створити ODBC DSN',

    'OdbcEdit.title' => 'Встановити підключення ODBC',
    'OdbcEdit.saveSuccess' => 'Налаштування підключення збережено.',
    'OdbcEdit.test' => 'Тестове з’єднання',
    'OdbcEdit.connectSuccess' => 'Підключення встановлене.',

    'OdbcEdit.excel.driver.label' => 'Драйвер',
    'OdbcEdit.excel.dbq.label' => 'Путь до файлу бази даних',
    'OdbcEdit.excel.defaultdir.label' => 'Папка даних за замовчуванням',
    'OdbcEdit.excel.fil.label' => 'Версія бази даних',
    'OdbcEdit.excel.maxbuffersize.label' => 'Максимальний розмір буфера',
    'OdbcEdit.excel.pagetimeout.label' => 'Тайм-аут сторінки',

    'OdbcEdit.access.driver.label' => 'Драйвер',
    'OdbcEdit.access.dbq.label' => 'Путь до файлу бази даних',
    'OdbcEdit.access.uid.label' => 'Ідентифікатор входу в систему',
    'OdbcEdit.access.pwd.label' => 'Пароль',
    'OdbcEdit.access.pagetimeout.label' => 'Тайм-аут сторінки',
    'OdbcEdit.access.pagetimeout.description' => 'Проміжок часу (у десятих долях секунди), протягом якого сторінка, що не використовується, залишається в буфері. Цей параметр застосовується для всіх джерел даних, які використовують драйвер Microsoft Access.',
    'OdbcEdit.access.maxbuffersize.label' => 'Максимальний розмір буфера',
    'OdbcEdit.access.maxbuffersize.description' => 'Розмір внутрішнього буферу, кратний 256 КБ.',
    'OdbcEdit.access.readonly.label' => 'Лише для читання',
    'OdbcEdit.access.readonly.description' => 'Визначає базу даних як доступну лише для читання для заборони будь-яких оновлень.',
    'OdbcEdit.access.exclusive.label' => 'Монопольно',
    'OdbcEdit.access.exclusive.description' => 'Визначає базу даних як таку, що не отримуватиме спільні оновлення.',
    'OdbcEdit.access.safetransactions.label' => 'Безпечні транзакції',
    'OdbcEdit.access.safetransactions.description' => 'Якщо встановлений 0 (значення за замовчуванням) всі транзакції приймаються негайно. Якщо встановлена 1, всі транзакції зберігаються на диск лише після операції підтвердження, але при цьому знижується продуктивність.',
    'OdbcEdit.access.threads.label' => 'Потоки',
    'OdbcEdit.access.threads.description' => 'Кількість використовуваних фонових потоків рушія.',
    'OdbcEdit.access.maxscanrows.label' => 'Максимум рядків для сканування',
    'OdbcEdit.access.maxscanrows.description' => 'Кількість рядків, які будуть оброблені при визначенні типу даних стовпчика на основі вже існуючих даних.',
    'OdbcEdit.access.implicitcommitsync.label' => 'ImplicitCommitSync',
    'OdbcEdit.access.implicitcommitsync.description' => 'Визначає, яким чином зміни, зроблені за межами транзакції, будуть записуватись у базу даних.',
    'OdbcEdit.access.usercommitsync.label' => 'UserCommitSync',
    'OdbcEdit.access.usercommitsync.description' => 'Визначає, чи буде драйвер MS Access виконувати задані користувачем явні транзакції асинхронно.',

    'OdbcEdit.mssql.driver.label' => 'Драйвер',
    'OdbcEdit.mssql.server.label' => 'Сервер',
    'OdbcEdit.mssql.uid.label' => 'Ідентифікатор входу в систему',
    'OdbcEdit.mssql.pwd.label' => 'Пароль',
    'OdbcEdit.mssql.database.label' => 'База даних за замовчуванням',
    'OdbcEdit.mssql.app.label' => 'Назва програми',
    'OdbcEdit.mssql.wsid.label' => 'Ідентифікатор робочої станції',
    'OdbcEdit.mssql.language.label' => 'Відсутність мови',
    'OdbcEdit.mssql.oemtoansi.label' => 'Перетворення символів національного алфавіту в символи OEM (оригінальний виробник обладнання)',

    'OdbcEdit.mysql.driver.label' => 'ODBC драйвер MySQL',
    'OdbcEdit.mysql.server.label' => 'Сервер',
    'OdbcEdit.mysql.server.description' => 'Назва вузла серверу MariaDB/MySQL',
    'OdbcEdit.mysql.database.label' => 'База даних за замовчуванням',
    'OdbcEdit.mysql.user.label' => 'Ім\'я користувача',
    'OdbcEdit.mysql.user.description' => 'Ім’я користувача, яке використовується для підключення до MariaDB/MySQL',
    'OdbcEdit.mysql.password.label' => 'Пароль',
    'OdbcEdit.mysql.password.description' => 'Пароль облікового запису користувача на сервері.',
    'OdbcEdit.mysql.port.label' => 'Порт',
    'OdbcEdit.mysql.port.description' => 'Порт TCP/IP, який буде використовуватись, якщо сервер не є локальним вузлом',
    'OdbcEdit.mysql.socket.label' => 'Сокет',
    'OdbcEdit.mysql.socket.description' => 'Іменований канал Windows, до якого підключатись, якщо сервер є локальним вузлом',
    'OdbcEdit.mysql.option.label' => 'Опція',
    'OdbcEdit.mysql.option.description' => 'Параметри, що вказують, як має працювати MyODBC. Див. <a target="_blank" href="https://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">documentation</a>',

    'ProtectedDirectoryList.add' => 'Додати захищений каталог',
    'ProtectedDirectoryList.addTooltip' => 'Створити новий захищений каталог.',
    'ProtectedDirectoryList.name' => 'Ім’я',
    'ProtectedDirectoryList.realmTitle' => 'Заголовок захищеної зони',
    'ProtectedDirectoryList.noSelectionText' => 'Виберіть один або кілька елементів, які потрібно видалити.',
    'ProtectedDirectoryList.edit' => 'Редагувати',
    'ProtectedDirectoryList.remove' => 'Зняти захист',
    'ProtectedDirectoryList.removeTooltip' => 'Зняти захист з вибраних каталогів.',
    'ProtectedDirectoryList.removeConfirmation' => 'Ця операція призведе до скасування захисту {count, plural, =1 {# каталогу {name}} one {# обраного каталогу} other {# обраних каталогів}}. Користувачі мережі Інтернет отримають вільний доступ до {count, plural, =1 {# цього каталогу} one {# цього каталогу} other {# цих каталогів}}.',
    'ProtectedDirectoryList.removeSuccess' => 'Вибрані каталоги видалено.',

    'ProtectedDirectoryAdd.title' => 'Створити новий захищений каталог',
    'ProtectedDirectoryAdd.submit' => 'Створити',
    'ProtectedDirectoryAdd.success' => 'Захищений каталог %%path%% успішно створено',

    'ProtectedDirectoryEdit.title' => 'Налаштування захищеного каталогу',
    'ProtectedDirectoryEdit.success' => 'Налаштування захищеного каталогу було змінено',

    'ProtectedDirectoryUserAdd.title' => 'Створити користувача захищеного каталогу',
    'ProtectedDirectoryUserAdd.subtitle' => 'Каталог %%directory%%',
    'ProtectedDirectoryUserAdd.loginLabel' => 'Ім\'я користувача',
    'ProtectedDirectoryUserAdd.passwordLabel' => 'Пароль',
    'ProtectedDirectoryUserAdd.submit' => 'Створити',
    'ProtectedDirectoryUserAdd.success' => '%%login%% користувача захищеного каталогу створено.',

    'ProtectedDirectoryUserPassword.title' => 'Пароль користувача захищеного каталогу',
    'ProtectedDirectoryUserPassword.subtitle' => '%%login%% користувача',
    'ProtectedDirectoryUserPassword.passwordLabel' => 'Пароль',
    'ProtectedDirectoryUserPassword.submit' => 'Зберегти',
    'ProtectedDirectoryUserPassword.success' => 'Дані користувача збережено.',

    'SummaryReport.Layout.title' => 'Параметри шаблону звіту',
    'SummaryReport.Layout.success' => 'Макет звіту %%name%% оновлено.',
    'SummaryReport.Layouts.title' => 'Шаблони звітів',

    'SummaryReport.Layout.Add.title' => 'Створити шаблон звіту',
    'SummaryReport.Layout.Add.success' => 'Макет звіту %%name%% створено.',

    'SummaryReport.Report.title' => 'Зведений звіт',
    'SummaryReport.Report.buttonLayouts' => 'Макети',
    'SummaryReport.Report.buttonSchedule' => 'Графік',
    'SummaryReport.Report.buttonProperties' => 'Параметри',
    'SummaryReport.Report.buttonTrafficHistory' => 'Історія трафіку',
    'SummaryReport.Report.buttonPrint' => 'Друкувати',
    'SummaryReport.Report.buttonSend' => 'Надіслати електронною поштою',
    'SummaryReport.Report.successSent' => 'Звіт був відправлений до %%email%%',

    'SummaryReport.Schedule.title' => 'Графіки доставки для %%name%%',
    'SummaryReport.Schedule.Properties.title' => 'Графік доставки для %%name%%',
    'SummaryReport.Schedule.Properties.success' => 'Оновлено розклад доставки звіту.',

    'SummaryReport.Schedule.Add.title' => 'Створити плани доставки для %%name%%',
    'SummaryReport.Schedule.Add.success' => 'Створено розклад доставки звіту.',

    'SummaryReport.TrafficHistory.title' => 'Історія трафіку',

    'VirtualDirectory.errNotExist' => 'Цей віртуальний каталог посилається на фізичну папку, що не існує.',
    'VirtualDirectory.errNoPermissions' => 'У вас немає прав доступу для перегляду вмісту цього каталогу.',
    'VirtualDirectory.buttonProperties' => 'Властивості каталогу',
    'VirtualDirectory.buttonPropertiesHint' => 'Переглянути та змінити властивості віртуального каталогу.',
    'VirtualDirectory.buttonPermissions' => 'Права доступу до каталогу',
    'VirtualDirectory.buttonPermissionsHint' => 'Налаштування прав доступу до каталогу.',
    'VirtualDirectory.buttonAspDotNet' => 'ASP.NET',
    'VirtualDirectory.buttonAspDotNetHint' => 'Налаштувати параметри ASP.NET.',
    'VirtualDirectory.buttonPhp' => 'PHP',
    'VirtualDirectory.buttonPhpHint' => 'Налаштувати параметри PHP.',
    'VirtualDirectory.tabBrowse' => 'Каталоги',
    'VirtualDirectory.tabBrowseHint' => 'Робота із фізичними та віртуальними файлами і каталогами на веб-сайті %%site%%.',
    'VirtualDirectory.tabMimeTypes' => 'Типи MIME',
    'VirtualDirectory.tabMimeTypesHint' => 'Управління зареєстрованими типами МІМЕ.',
    'VirtualDirectory.tabErrorDocs' => 'Документи помилок',
    'VirtualDirectory.tabErrorDocsHint' => 'Управління документами помилок.',
    'VirtualDirectory.tabProtection' => 'Захист',
    'VirtualDirectory.tabProtectionHint' => 'Обмежити доступ до каталогу, захищеного паролем.',

    'VirtualDirectory.errorDocType.default' => 'За замовчуванням',
    'VirtualDirectory.errorDocType.file' => 'Файл',
    'VirtualDirectory.errorDocType.url' => 'URL',

    'VirtualDirectory.CreateDirectory.title' => 'Створіть каталог',
    'VirtualDirectory.CreateDirectory.name' => 'Назва каталогу',
    'VirtualDirectory.CreateDirectory.success' => 'Було створено каталог %%name%%.',
    'VirtualDirectory.CreateDirectory.errExists' => 'Каталог %%name%% вже існує.',

    'VirtualDirectory.CreateVirtualDirectory.title' => 'Створіть віртуальний каталог',
    'VirtualDirectory.CreateVirtualDirectory.success' => 'Було створено каталог %%name%%.',

    'VirtualDirectory.EditVirtualDirectory.title' => 'Властивості віртуального каталогу',
    'VirtualDirectory.EditVirtualDirectory.success' => 'Віртуальний каталог було змінено.',
    'VirtualDirectory.EditVirtualDirectory.close' => 'Закрити',

    'VirtualDirectory.MimeTypeList.add' => 'Додати тип МІМЕ',
    'VirtualDirectory.MimeTypeList.edit' => 'Редагувати тип MIME',
    'VirtualDirectory.MimeTypeList.addHint' => 'Зареєструвати новий тип МІМЕ.',
    'VirtualDirectory.MimeTypeList.columnExtension' => 'Модуль',
    'VirtualDirectory.MimeTypeList.columnContent' => 'Вміст',
    'VirtualDirectory.MimeTypeList.noSelectionText' => 'Виберіть один або кілька елементів, які потрібно видалити.',
    'VirtualDirectory.MimeTypeList.removeConfirmation' => 'Видалити {count, plural, =1 {вибраний тип MIME} one {# вибраний тип MIME} few {# вибрані типи MIME} many {# вибраних типів MIME} other {# вибрані типи MIME}}?',
    'VirtualDirectory.MimeTypeList.removeSuccess' => 'Вибрані типи MIME видалено.',

    'VirtualDirectory.CreateMimeType.title' => 'Додати тип МІМЕ',
    'VirtualDirectory.CreateMimeType.success' => 'Зареєстровано новий тип MIME.',

    'VirtualDirectory.EditMimeType.title' => 'Редагувати тип MIME',
    'VirtualDirectory.EditMimeType.success' => 'Тип MIME змінено.',

    'VirtualDirectory.ErrorDocList.columnCode' => 'Помилка',
    'VirtualDirectory.ErrorDocList.columnName' => 'Опис',
    'VirtualDirectory.ErrorDocList.columnType' => 'Тип',
    'VirtualDirectory.ErrorDocList.columnLocation' => 'Положення',
    'VirtualDirectory.ErrorDocList.edit' => 'Редагувати',

    'VirtualDirectory.EditErrorDoc.title' => 'Редагувати документ про помилки',
    'VirtualDirectory.EditErrorDoc.success' => 'Документ про помилки відредаговано.',

    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.error' => 'Помилка',
    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.type' => 'Тип',
    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.location' => 'Положення',

    'VirtualDirectory.Protection.notSupported' => 'Захист каталогу не підтримується для цього каталогу, оскільки кількість символів у його імені перевищує 245 або його ім’я містить непідтримувані символи.',
    'VirtualDirectory.Protection.NoProtectionView.title' => 'Захист віртуального каталогу вимкнено',
    'VirtualDirectory.Protection.NoProtectionView.protect' => 'Захистити',
    'VirtualDirectory.Protection.NoProtectionView.successProtection' => '%%path%% до каталогу захищено.',
    'VirtualDirectory.Protection.tools' => 'Інструменти',
    'VirtualDirectory.Protection.removeProtection' => 'Зняти захист',
    'VirtualDirectory.Protection.removeProtectionTooltip' => 'Встановіть URL, який відповідає каталогу, що є доступним усім.',
    'VirtualDirectory.Protection.removeProtectionConfirmation' => 'Зняти захист з віртуального каталогу? Це також призведе до видалення всіх користувачів захищеного каталогу й налаштувань захисту каталогу.',
    'VirtualDirectory.Protection.settings' => 'Налаштування',
    'VirtualDirectory.Protection.settingsTooltip' => 'Переглянути розташування каталогу та вказати ім’я захищеної області.',

    'VirtualDirectory.AspDotNet.title' => 'Налаштувати параметри ASP.NET',

    'VirtualDirectory.Php.title' => 'Версія РНР',
    'VirtualDirectory.Php.version' => 'Версія',
    'VirtualDirectory.Php.success' => 'Версію PHP оновлено.',


    'MassMailPage.sendEmail' => 'Надіслати масові повідомлення електронною поштою',
    'MassMailPage.selectAtLeastOneTemplate' => 'Виберіть щонайменше один шаблон',
    'MassMailPage.confirmRemoval' => 'Ви впевнені, що хочете видалити {count, select, 1 {вибраний шаблон} other {вибрані шаблони}}?',
    'MassMailPage.remove' => 'Видалити',
    'MassMailPage.filters' => 'Фільтри',
    'MassMailPage.name' => 'Ім\'я шаблону',
    'MassMailPage.sender' => 'Відправник',
    'MassMailPage.recipients' => 'Одержувачі',
    'MassMailPage.subject' => 'Тема',
    'MassMailPage.created' => 'Дата створення',
    'MassMailPage.send' => 'Надіслати',
    'MassMailPage.recipientsNone' => 'Відсутня',
    'MassMailPage.recipientsAdmins' => 'Адміністратор',
    'MassMailPage.recipientsResellers' => 'Всі посередники',
    'MassMailPage.recipientsResellersSelected' => 'Вибрані посередники',
    'MassMailPage.recipientsResellersExcept' => 'Всі посередники, крім вибраних',
    'MassMailPage.recipientsClients' => 'Всі замовники',
    'MassMailPage.recipientsClientsSelected' => 'Вибрані замовники',
    'MassMailPage.recipientsClientsExcept' => 'Всі замовники, крім вибраних',
    'MassMailPage.templatesRemoved' => 'Видалено {count, select, 1 {шаблон} other {шаблони}}.',
    'MassMailPage.emptyViewTitle' => 'Відсутні шаблони масової розсилки електронної пошти',
    'MassMailPage.addNew' => 'Створіть шаблон',
    'CreateMassMailTemplatePage.templateCreated' => 'Шаблон створено.',
    'EditMassMailTemplatePage.templateUpdated' => 'Шаблон оновлено.',
    'SendMassMailPage.emailSent' => 'Електронний лист надіслано.',
    'SendMassMailPage.fieldIsRequired' => 'Поле не може бути порожнім',
    'SendMassMailPage.saveAsTemplate' => 'Зберегти створене повідомлення у новому шаблоні',
    'SendMassMailPage.newTemplateName' => 'Ім\'я нового шаблону',
    'SendMassMailPage.selectedTemplate' => 'Вибраний шаблон',
    'SendMassMailPage.send' => 'Надіслати',
    'VirtualHostTemplatePage.name' => 'Ім’я',
    'VirtualHostTemplatePage.sizeInBytes' => 'Розмір',
    'VirtualHostTemplatePage.modified' => 'Дата модифікації',
    'VirtualHostTemplatePage.permissions' => 'Права доступу',
    'VirtualHostTemplatePage.user' => 'Користувач',
    'VirtualHostTemplatePage.group' => 'Група',
    'VirtualHostTemplatePage.uploadTemplate' => 'Вивантажити',
    'VirtualHostTemplatePage.succesfullyUploaded' => 'Шаблон завантажено.',
    'VirtualHostTemplatePage.root' => 'Віртуальний шаблон',
    'VirtualHostTemplatePage.emptyViewTitle' => 'У шаблоні немає файлів',
    'VirtualHostTemplatePage.total' => 'Загалом елементів у каталозі {breadcrumbs}: {total}',
    'VirtualHostTemplatePage.resetTemplate' => 'Встановити за замовчуванням',
    'VirtualHostTemplatePage.successfullyReset' => 'Шаблон змінено на шаблон за замовчуванням.',

    'TrafficUsageByDomains.Viewer.List.domainName' => 'Ім\'я домену',
    'TrafficUsageByDomains.Viewer.List.clientName' => "Ім’я власника",
    'TrafficUsageByDomains.Viewer.List.totalUsage' => 'Використано',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimit' => 'Обмеження',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimitRemaining' => 'Доступний',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimitUsagePercent' => 'Використано (у %)',
    'TrafficUsageByDomains.Viewer.Filters.ownOnly' => 'Тільки мої домени',
    'TrafficUsageByDomains.Viewer.Filters.clientName' => 'Ім’я власника',
];