<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'cgroups.size' => 'Неверное значение: "%value%". Значение должно быть больше или равно %unitMin%, меньше или равно %unitMax% и не может быть равно 0.',
    'cgroups.unlimited' => 'Без ограничений',
    'cgroups.period' => 'Неверное значение: "%value%". Допустимые значения: 5 минут, час или день, указанные в секундах (300, 3600 или 86400).',

    'file.fileIsImageFalseType' => 'Загружаемый файл не является изображением.',
    'file.fileUploadErrorIniSize' => 'Размер загружаемого файла превышает ограничение, установленное в файле ini.',
    'file.fileUploadErrorFormSize' => 'Размер загружаемого файла превышает допустимый размер формы.',
    'file.fileUploadErrorPartial' => 'Файл загружен только частично.',
    'file.fileUploadErrorNoFile' => 'Не удалось загрузить файл.',
    'file.fileUploadErrorNoTmpDir' => 'Не найдена временная папка для загружаемого файла.',
    'file.fileUploadErrorCantWrite' => 'Загружаемый файл недоступен для записи.',
    'file.fileUploadErrorExtension' => 'При загрузке файла произошла ошибка расширения.',
    'file.fileUploadErrorAttack' => 'Файл был загружен незаконно; это может быть попыткой вторжения.',
    'file.fileUploadErrorFileNotFound' => 'Файл, который вы пытаетесь загрузить, не найден.',
    'file.fileUploadErrorUnknown' => 'При загрузке файла произошла неизвестная ошибка.',
    'file.fileExtensionFalse' => 'Загружаемый файл имеет неподдерживаемое расширение.',
    'file.fileExistsDoesNotExist' => 'Указанный файл или папка не существует.',

    'hostname.hostnameIpAddressNotAllowed' => "'%value%' является IP-адресом, но в качестве этого значения запрещено использовать IP-адреса",
    'hostname.hostnameUnknownTld' => "'%value%' является DNS-именем, но не входит в список известных доменов верхнего уровня",
    'hostname.hostnameDashCharacter' => "'%value%' является DNS-именем, но содержит дефис (-) в неположенном месте",
    'hostname.hostnameInvalidHostnameSchema' => "'%value%' является DNS-именем, но не соответствует формату домена верхнего уровня — '%tld%'",
    'hostname.hostnameUndecipherableTld' => "'%value%' является DNS-именем, но не верхнего уровня",
    'hostname.hostnameInvalidHostname' => "'%value%' не соответствует формату DNS-имени",
    'hostname.hostnameInvalidLocalName' => "'%value%' не является действительным локальным сетевым именем",
    'hostname.hostnameLocalNameNotAllowed' => "'%value%' является локальным сетевым именем, но в качестве этого значения запрещено использовать локальные сетевые имена",

    'port.notBetween' => 'Недопустимый номер порта. Он должен быть в диапазоне от 1 до 65535 включительно.',

    'dns.invalidSoaValue' => 'Недопустимое значение. Значение должно быть от 1 секунды до 68 лет.',

    'isEmpty' => 'Это обязательное поле. Пожалуйста, заполните его.',
    'stringLengthTooShort' => "'%value%' меньше, чем %min% символов.",
    'stringLengthTooLong' => "'%value%' превышает %max% символов.",
    'regexNotMatch' => "'%value%' не соответствует схеме '%pattern%'.",
    'notAlnum' => "'%value%' содержит недопустимые символы. Пожалуйста, используйте только буквенно-цифровые символы.",
    'alnumStringEmpty' => "Значение пусто.",
    'stringEmpty' => "Необходимо указать '%value%'.",
    'loginSyntax' => 'Имя пользователя может содержать буквы, цифры, дефисы (-), точки (.), одинарные кавычки (\'), знаки процента (%) и подчеркивания (_). Имя пользователя должно начинаться с буквы или цифры.',
    'loginExists' => 'Учетная запись пользователя %value% уже существует.',
    'cu_admin_alias__login_exists' => 'Учетная запись пользователя уже существует.',
    'loginPassword' => 'Пароль не должен содержать имя пользователя.',
    'passwordSyntax' => 'Пароль содержит недопустимые символы.',
    'passwordLength' => 'Длина пароля должна быть от %minLength% до %maxLength% символов.',
    'domain_invalid_name' => 'Неверно указано имя домена. Имя домена должно иметь вид domain.com',
    'dns_domain_invalid_name' => 'Указано недопустимое имя домена.',
    'dns_domain_template_invalid_name' => 'Указан недопустимый шаблон имени домена.',
    'not_ascii_string' => 'Это значение не является действительной строкой ASCII.',
    'virtual_directory_name_invalid' => 'В именах папок можно использовать только буквы, цифры, подчеркивания и тире.',
    'virtual_directory_name_reserved' => 'Это имя зарезервировано.',
    'virtualDirectoryAlreadyExists' => 'Папка с таким именем уже существует.',
    'virtualDirectoryPathIsInvalid' => 'Физический путь неверен или не существует.',
    'virtualDirectoryErrorDocFileLocation' => 'Неправильный путь к файлу.',
    'virtualDirectoryErrorDocAbsoluteUrl' => 'Неправильный формат URL-адреса. Пожалуйста, введите абсолютный URL-адрес на виртуальном сервере (сайте).',
    'invalid_city_name' => 'Город указан неверно',
    'invalid_country_code' => 'Недействительный код страны',
    'not_specified_country_code' => '"Страна" — это обязательное поле для заполнения, в нем нужно указать точную информацию.',
    'invalid_system_user_login' => 'Имя системного пользователя указано неверно',
    'invalid_rfc_domain_name' => 'Указанное имя домена не соответствует стандарту RFC',
    'idn_name_conversion' => 'Не удалось сконвертировать имя домена из IDN в Punycode',
    'domain_label_too_long' => 'Ни одна часть имени домена не может быть длиннее 63 символов.',
    'domain_label_too_long_idn' => 'На этом домене используется международное имя домена. Ни одна часть этого имени не может быть длиннее 63 символов после конвертации в Punycode.',
    'domain_starts_with_www' => 'Пожалуйста, введите имя домена без префикса \'www\'. Префикс www для домена будет автоматически добавлен к конфигурации веб-сервера.',
    'domain_already_exists' => 'Такой домен уже существует.',
    'domain_without_www_already_exists' => 'Этот домен уже существует без префикса \'www\'.',
    'domain_with_www_already_exists' => 'Этот домен уже существует с префиксом \'www\'.',
    'subdomain_conflicts_with_existing_domain' => 'Существует домен с таким же именем как поддомен \'%value%\'.',
    'restrict_domain_creation' => 'Указанное имя домена запрещено политикой сервера. Если этот домен принадлежит вам, пожалуйста, обратитесь к своему хостинг-провайдеру.',
    'dns_record_already_exists' => 'Такая DNS-запись уже существует.',
    'domain_like_hostname' => 'Это имя домена совпадает с именем хоста сервера.',
    'passwordsNotMatch' => 'Введенные пароли не совпадают.',
    'stringsNotEqual' => 'Значения не идентичны.',
    'equalMailAliases' => 'Указанный почтовый псевдоним уже существует.',
    'mailAliasExist' => 'Указанный почтовый псевдоним уже существует.',
    'mailNameExist' => 'Указанный адрес электронной почты уже существует.',
    'mailListExist' => 'Указанный адрес уже закреплен за почтовой рассылкой.',
    'mailAutoReplyHeadersSpaceError' => "Заголовки автоответчика не должны содержать пробелов",
    'mailAutoReplyHeadersInvalidValueError' => 'Некоторые поля пусты или содержат недопустимые значения.',
    'sysUserExist' => 'Указанное имя пользователя уже используется другим системным пользователем. Пожалуйста, укажите другое имя пользователя.',
    'emailAddressInvalid' => 'Вы указали недействительный адрес электронной почты. Укажите действительный адрес, который соответствует следующему шаблону: johndoe@example.com.',
    'emailAddressInvalidLocal' => 'Недопустимый адрес электронной почты. Этот почтовый адрес должен принадлежать выбранному домену. В данном случае внешние почтовые адреса может указывать только администратор.',
    'emailAddressSpecialNames' => 'Недопустимый адрес электронной почты. Та часть адреса, которая отвечает за имя пользователя, не должна начинаться с зарезервированного системного имени (например, con, lpt1, prn), отделенного от остального имени пользователя символом точки (.).',
    'dkimSelectorInvalid' => 'Указан недопустимый селектор DKIM: %value%',
    'longAddress' => 'Слишком длинный адрес электронной почты.',
    'longMailboxAddressMailServer' => 'Имя пользователя, используемое в этом почтовом адресе, слишком длинное для этого почтового сервера. Пожалуйста, укажите имя пользователя не длиннее %%max%% символов.',
    'longFullAddressMailServer' => 'Адрес электронной почты слишком длинный для этого почтового сервера. Пожалуйста, укажите адрес не длиннее %%max%% символов.',
    'dir_invalid_name' => 'Недопустимая конечная папка.',
    'directoryHidesDomain' => 'Эта папка не может быть использована, так как она пересекается с сайтом, расположенным в %path%. Такое пересечение сделает сайт недоступным.',
    'directoryHidesAnotherApplication' => 'Эта папка не может быть использована, так как она пересекается с другим приложением, установленным в папке %path%. Такое пересечение сделает установленное приложение недоступным.',
    'directoryIsBehindAnotherApplication' => 'Эта папка не может быть использована, так как это приведет к пересечению с другим приложением, установленным в папке %path%. Такое пересечение сделает приложение недоступным.',
    'domainLoginSyntaxWindows' => 'Имя пользователя должно начинаться с буквы и не может быть длиннее %%maxlength%% символов. Все символы, кроме первого, должны быть цифрами или буквами в нижнем регистре, символами подчеркивания, точками или тире. Имя пользователя не может оканчиваться точкой.',
    'domainLoginSyntaxUnix' => 'Имя пользователя не может быть длиннее %%maxlength%% символов и может содержать только цифры или буквы в нижнем регистре, символы подчеркивания и тире. Имя пользователя должно начинаться с буквы в нижнем регистре',
    'notLocalMssqlHost' => 'Имя хоста MSSQL не является локальным',
    'invalidMailTo' => 'Неверное значение ссылки mailto:',
    'passwordsNotEqual' => 'Введенные пароли не совпадают.',
    'passwordPolicy' => '%policyError%',
    'fileImageSizeWidthTooBig' => "Ширина загружаемого изображения '%value%' слишком велика ('%width%'). Она не должна превышать '%maxwidth%'.",
    'fileImageSizeWidthTooSmall' => "Ширина загружаемого изображения '%value%' слишком мала ('%width%'). Она должна составлять не менее '%minwidth%'.",
    'fileImageSizeHeightTooBig' => "Высота загружаемого изображения '%value%' слишком велика ('%height%'). Она не должна превышать '%maxheight%'.",
    'fileImageSizeHeightTooSmall' => "Высота загружаемого изображения '%value%' слишком мала ('%height%'). Она должна составлять не менее '%minheight%'.",
    'fileImageSizeNotDetected' => "Не удалось определить размер загружаемого изображения '%value%'.",
    'fileImageSizeNotReadable' => "Не удалось распознать загружаемое изображение '%value%'.",
    'passwordConfirmation' => 'Подтверждение пароля',
    'databaseUserNameExists' => 'Пользователь базы данных с именем %value% уже существует.',
    'invalidUserName' => 'Имя пользователя базы данных содержит недопустимые символы.',
    'longUserName' => 'Имя пользователя базы данных содержит более %%max%% символов.',
    'forbiddenName' => 'Не разрешено использовать имя пользователя базы данных "%value%".',
    'invalidAdminLogin' => 'Выбранные учетные данные не могут быть использованы для администраторского доступа. Некорректное имя пользователя: %%cause%%',
    'invalidAdminPassword' => 'Выбранные учетные данные не могут быть использованы для администраторского доступа. Некорректный пароль: %%cause%%',
    'passwordLengthTooShort' => "длина пароля меньше %min% символов.",
    'passwordLengthTooLong' => "длина пароля больше %max% символов.",
    'passwordRegexNotMatch' => "пароль не соответствует схеме '%pattern%'.",
    'fileSharingEmptyFolderName' => "Укажите имя папки.",
    'fileSharingInvalidFolderName' => "Указано недопустимое имя папки. Оно не должно содержать символы \\ / : * ? \" < > |",
    'fileSharingFolderExists' => "Невозможно создать папку с указанным именем, потому что папка с таким именем уже существует.",
    'invalidUrl' => 'Неверный адрес. Адрес должен быть указан в формате http://domain.com.',
    'domainVirtualdirectoryReservedName' => 'Это имя папки зарезервировано. Укажите другое имя.',
    'domainVirtualdirectoryInvalidName' => 'Имя папки может содержать только буквы, цифры, подчеркивания и тире.',
    'filesharingPathUnavailable' => 'На указанном домене уже существует папка с таким именем. Пожалуйста, укажите другое имя.',
    'filesharingSslNotAvailableOnDomain' => 'Вы выбрали использовать защищенные ссылки, но на домене не включен SSL/TLS. Пожалуйста, или выберите домен с поддержкой SSL/TLS, или уберите галочку Создать защищенные ссылки.',
    'filesharingSslRedirectOnDomain' => 'На выбранном домене включена опция "Постоянное перенаправление с HTTP на HTTPS с кодом 301 без ущерба для поисковой оптимизации". Чтобы настроить общий доступ к файлам, либо выберите домен, на котором эта опция отключена, либо установите флажок "Создавать защищенные ссылки на файлы и папки".',
    'filesharingSslNotAvailableOnDefaultDomain' => 'Вы выбрали использовать защищенные ссылки на IP-адресе или имени хоста сервера, но такие ссылки могут быть созданы только на сайтах с поддержкой SSL/TLS. Пожалуйста, или создайте сайт с поддержкой SSL/TLS, или уберите галочку Создать защищенные ссылки.',
    'filesharingDefaultDomainSelectedOnServerIp' => 'Вы выбрали IP-адрес, присвоенный домену по умолчанию. Пожалуйста, выберите корневой URL сайта вместо IP-адреса.',
    'physicalPathOnDomainAlreadyExists' => 'Папка с таким именем уже существует.',
    'virtualPathOnDomainAlreadyExists' => 'Виртуальная папка с таким именем уже существует.',
    'sysUserLoginSyntaxWindows' => 'Имя пользователя может содержать буквенно-цифровые символы, тире (-), точки (.) и нижние подчеркивания (_). Имя пользователя должно начинаться с буквы или цифры.',
    'sysUserLoginSyntaxUnix' => 'Имя пользователя может содержать буквенно-цифровые символы в нижнем регистре, тире (-), точки (.) и нижние подчеркивания (_). Имя пользователя должно начинаться с буквы или цифры.',
    'docrootNotInWebspaceRoot' => 'Указанная папка не входит в корневую папку подписки.',
    'docrootContainsSpecialCharacters' => 'Указанное имя папки содержит недопустимые символы.',
    'docrootWithinProhibitedDirectory' => 'Указанная папка содержит служебную папку.',
    'docrootWithinInstalledApplication' => 'Указанная папка пересекается веб-приложением, которое установлено в %path%.',
    'docrootIsNotDirectory' => 'Указанный путь не может быть использован, так как его часть ссылается на файл.',
    'docrootTooLongPart' => 'Указанное имя папки слишком длинное.',
    'subdomainWrongName' => '%errorDescription%',
    'subdomainWrongDomain' => 'Выбран неверный домен.',
    'domainAliasWrongName' => '%errorDescription%',
    'phoneRegexNotMatch' => 'Указанный номер телефона содержит недопустимые символы.',
    'stateInvalid' => 'Неверно указан штат или провинция.',
    'zipRegexNotMatch' => 'Указан неверный почтовый индекс.',
    'limitValueInvalid' => 'Недопустимое ограничение.',
    'softLimitValueInvalid' => 'Значение должно находиться в диапазоне %%MIN%%..%%MAX%%.',
    'outgoingMessagesLimitValueInvalid' => 'Значение должно находиться в диапазоне %%MIN%%..%%MAX%%. Этот параметр может изменить только администратор Plesk.',
    'limitMssqlDatabaseFileSizeValueInvalid' => 'Ограничение на объем базы данных MS SQL должно быть целым числом в промежутке от 0 до 16 Tб.',
    'limitMssqlDatabaseLogFileSizeValueInvalid' => 'Ограничение на объем журнала базы данных MS SQL должно быть целым числом в промежутке от 0 до 2 Tб.',
    'limitDiskspaceValueInvalid' => 'Ограничение на объем дискового пространства должно быть целым числом в промежутке от 0 до 4095 Tб.',
    'limitTrafficValueInvalid' => 'Ограничение на объем трафика должно быть целым числом в промежутке от 0 до 4095 Tб/мес.',
    'limitMboxQuotaValueInvalid' => 'Ограничение на объем почтового ящика должно быть целым числом в промежутке от 0 до 4095 Tб.',
    'limitRetainPeriodValueInvalid' => 'Значение поля "Хранить веб-статистику и статистику трафика в течение" в тарифных планах не может быть меньше аналогичного значения на странице "Инструменты и настройки > Настройки сервера". Укажите целое число больше или равное %%MIN%% и меньше %%MAX%%.',
    'limitValueOverused' => 'Указанное ограничение меньше, чем текущий объем используемых ресурсов. Пожалуйста, укажите значение не менее %%used%%',
    'limitValueOverselled' => 'Ограничение расхода ресурсов %%reserved%% уже присвоено подпискам. Вы не можете указать значение, меньше чем %%reserved%%',
    'lessThan' => "'%value%' меньше, чем '%min%'",
    'greaterThan' => "'%value%' больше, чем '%max%'",
    'greaterThanDiskQuota' => "%value% больше дискового пространства (%max%)",
    'notDigits' => 'Это значение должно быть целым числом.',
    'digitsInvalid' => 'Это значение должно быть целым числом.',
    'digitsStringEmpty' => 'Это значение должно быть целым числом.',
    'isEqual' => "Это значение не может быть равно '%invalidValue%'.",
    'notInt' => 'Это значение должно быть целым числом.',
    'maillistNameInvalid' => 'Недопустимый адрес почтовой рассылки.',
    'maillistReservedNameAlreadyExists' => 'Указанный адрес уже занят.',
    'maillistAlreadyExists' => 'Указанный адрес уже используется в рассылке.',
    'maillistAlreadyExistsOnServer' => 'Указанное название рассылки уже используется другой подпиской',
    'mailnameAlreadyExists' => 'Указанный адрес электронной почты уже существует.',
    'mailaliasAlreadyExists' => 'Указанный адрес уже используется почтовым псевдонимом.',
    'autoresponderEndDateIsInvalid' => 'Указанная дата должна быть в будущем.',
    'mailPostboxLimit' => '%message%',
    'userEmailLimitExceeded' => '%limitManagerMessage%',

    'zxcvbnEstimator.passwordStrength' => 'Ваш пароль недостаточно сложный. Текущая политика сервера требует, чтобы надежность пароля была как минимум %strength%.',
    'zxcvbnEstimator.passwordStrengthVeryWeak' => 'Очень ненадежный (не рекомендуется)',
    'zxcvbnEstimator.passwordStrengthWeak' => 'Ненадежный (не рекомендуется)',
    'zxcvbnEstimator.passwordStrengthMediocre' => 'Средний',
    'zxcvbnEstimator.passwordStrengthStrong' => 'Надежный (рекомендуется)',
    'zxcvbnEstimator.passwordStrengthStronger' => 'Очень надежный',
    'zxcvbnEstimator.passwordStrengthVeryWeakHint' => 'Может быть легко взломан методом полного перебора. Уязвим к атакам методом подстановки учетных данных и перебора по словарю.',
    'zxcvbnEstimator.passwordStrengthWeakHint' => 'Может быть легко взломан методом полного перебора. Менее уязвим к атакам методом подстановки учетных данных и перебора по словарю.',
    'zxcvbnEstimator.passwordStrengthMediocreHint' => 'Может быть взломан методом полного перебора.',
    'zxcvbnEstimator.passwordStrengthStrongHint' => 'Сложно взломать методом полного перебора. Некоторая защита от оффлайн-атак.',
    'zxcvbnEstimator.passwordStrengthStrongerHint' => 'Практически неуязвим для атак методом полного перебора. Приемлемый уровень защиты от оффлайн-атак.',

    'emailCantBeRenamed' => "Сервер не поддерживает изменение почтовых имен",
    'emailOwnedByAnotherUser' => "Этот адрес электронной почты принадлежит другому пользователю.",
    'maillistAdminEmailShouldExistsOnDomain' => 'Адрес электронной почты администратора почтовой рассылки должен быть зарегистрирован на том же домене, что и рассылка.',
    'webmailExists' => "Услуга веб-службы '%value%' уже существует.",
    'invalidDbName' => 'Имя базы данных может содержать только буквы, цифры, точки, подчеркивания и тире.',
    'longDbName' => 'Имя базы данных слишком длинное.',
    'dbNameClash' => 'Имя базы данных и имя пользователя базы данных не должны совпадать.',
    'dbConnectFailed' => 'Невозможно подключиться к серверу баз данных. Пожалуйста, проверьте учетные данные и ограничения доступа пользователя базы данных.',
    'databaseNameAlreadyExists' => 'База данных с именем %value% уже существует.',
    'wrongUrlSyntax' => 'Указан недопустимый адрес. Адрес должен быть указан в формате http://domain.com, relative/path или mailto:address',
    'connectionRefused' => 'Подключение отклонено.',
    'loginIncorrect' => 'Неверное имя пользователя',
    'failedToChangeDirectory' => 'Папка не существует',
    'failedToChangeMode' => 'Не удалось изменить режим',
    'failedToCreateDirectory' => 'Создание файлов запрещено',
    'failedToRenameDirectory' => 'Переименование файлов запрещено',
    'failedToDeleteDirectory' => 'Удаление файлов запрещено',
    'ipInvalid' => "'%value%' не является действительным IP-адресом или принадлежит к другому типу.",
    'ipv6IsNotGlobal' => "'%value%' не является публичным IP-адресом.",
    'ipMaskInvalid' => "'%value%' не является действительной маской IP-адреса.",
    'ipInvalidForInterface' => 'Указанный IP-адрес не может быть использован в сетевом интерфейсе. Вам нужно указать действительный IP-адрес с префиксом или маской подсети.',
    'ipInvalidForInterfaceIpv6NotAvailable' => 'Указанный IP-адрес не может использоваться в выбранном сетевом интерфейсе, так как для этого интерфейса отключена поддержка IPv6.',
    'ipAlreadyExists' => 'IP-адрес %value% уже существует.',
    'notInArray' => 'Эта опция не поддерживается.',
    'ipAddressIsNotSelected' => 'Выберите хотя бы один IP-адрес.',
    'noServiceNodeSpecified' => 'Внутренняя ошибка: не указан узел обслуживания.',
    'serviceNodeInvalidName' => 'Неверное имя узла обслуживания "%value%".',
    'serviceNodeNameAlreadyExists' => 'Узел обслуживания с именем "%value%" уже существует.',
    'serviceNodeIpUsed' => "Невозможно удалить узел обслуживания: этот IP-адрес зарегистрирован.",
    'serviceNodeIpAddressAlreadyExists' => 'Узел обслуживания с IP-адресом "%value%" уже существует.',
    'serviceNodeInvalidTransport' => 'Неверное значение "%value%".',
    'app_non_unique_setting_value' => 'Это значение уже используется другим объектом. Оно должно быть уникальным для этого объекта.',
    'wrongLocalUrlSyntax' => 'Недопустимый адрес. Пожалуйста, укажите действительный локальный адрес, например: /smb/web/view.',
    'phpIsapiHandlerTypeNotSupported' => 'Этот тип обработчика ISAPI не поддерживается текущей версией PHP.',
    'dbNameNotExist' => 'Указанная база данных не существует.',
    'invalidBooleanValue' => 'Допустимые значения: "true" или "false".',
    'invalidMimeType' => 'Указанный тип MIME недействителен: "%value%".',
    'invalidHeaders' => 'Недопустимый заголовок: "%value%".',
    'invalidHandler' => 'Указанный обработчик событий недействителен: "%value%".',
    'invalidAllowDeny' => 'Указанная директива Allow/Deny недействительна: "%value%".',
    'nonUniqueAllowDeny' => 'Указанное значение директивы Allow/Deny уже существует: "%value%".',
    'maxItemsCountExeededAllowDeny' => 'Количество IP-адресов в этом списке должно быть меньше или равно %value%.',
    'invalidDirectoryIndex' => 'Указанный файл стартовой страницы для корневой папки недействителен.',
    'invalidNginxProxyMode' => 'Недопустимое значение свойства nginxProxyMode. Допустимые значения — "true" или "false".',
    'invalidNginxTransparentMode' => 'Недопустимое значение свойства nginxTransparentMode. Допустимые значения — "true" или "false".',
    'invalidNginxServeStatic' => 'Недопустимое значение свойства nginxServeStatic. Допустимые значения — "true" или "false".',
    'invalidStaticFilesExtensions' => 'Указанные расширения статических файлов недействительны: "%value%".',
    'invalidNginxServePhp' => 'Недопустимое значение свойства nginxServePhp. Допустимые значения — "true" или "false".',
    'invalidDocuments' => 'Имя документа не должно содержать запятые (",").',
    'duplicateDocuments' => 'Следующие документы уже есть в списке документов по умолчанию: "%value%"',
    'protected_directory_invalid_name' => 'Недопустимое имя защищенной папки.',
    'protected_directory_invalid_login' => 'Логин пользователя запароленной папки должен быть не более 20 буквенно-цифровых символов в длину. Также он может содержать дефисы ("-"), но не в качестве первого символа.',
    'notARelativePath' => 'Путь должен быть относительным',
    'cannotUseJunctions' => 'Точки соединения вне веб-пространства не могут использоваться в качестве временных папок для компиляции',
    'notBetween' => 'Значение "%value%" должно быть в диапазоне от "%min%" до "%max%" включительно',
    'notBetweenStrict' => 'Значение "%value%" должно быть строго в диапазоне от "%min%" до "%max%"',
    'redirectToMyself' => 'Сайт не может быть перенаправлен сам на себя. Введите адрес, отличный от основного URL-адреса сайта.',
    'redirectToAlias' => 'Сайт не может быть перенаправлен на собственный псевдоним. Введите адрес, отличный от псевдонима основного адреса сайта.',
    'relativePathInvalid' => 'Указан недопустимый путь.',
    'aspDotNetSettingsInvalid' => 'Некоторые из указанных настроек ASP.NET имеют недопустимые значения.',
    'mboxOutgoingMessagesLimitValueInvalid' => 'Ограничение на исходящие сообщения для почтового ящика должно быть больше %%MIN%%.',
    'domainOutgoingMessagesLimitValueInvalid' => 'Ограничение на исходящие сообщения для домена должно быть больше %%MIN%%.',
    'subscriptionOutgoingMessagesLimitValueInvalid' => 'Ограничение на исходящие сообщения для подписки должно быть больше %%MIN%%.',
    'iisAuthNotEnabled' => 'В настройках веб-сервера данного домена должен быть включен анонимный доступ или аутентификация Windows.',
    'mboxOutgoingMessagesLimitValueInvalidDigit' => 'Ограничение на исходящие сообщения для почтового ящика может иметь следующие значения: положительное целое число, \'default\' (по умолчанию) или \'-1\' (без ограничений).',
    'domainOutgoingMessagesLimitValueInvalidDigit' => 'Ограничение на исходящие сообщения для домена может иметь следующие значения: положительное целое число, \'default\' (по умолчанию) или \'-1\' (без ограничений).',
    'subscriptionOutgoingMessagesLimitValueInvalidDigit' => 'Ограничение на исходящие сообщения для подписки может иметь следующие значения: положительное целое число, \'default\' (по умолчанию) или \'-1\' (без ограничений).',
    'outgoingMessagesReportPeriodValueInvalid' => 'Указанный период создания отчета не поддерживается.',
    'outgoingMessagesNotificationPeriodValueInvalid' => 'Указанный период уведомления не поддерживается.',
    'textItemsListInvalid' => 'Указан недопустимый элемент: "%value%".',
    'textItemsListInvalidMulti' => 'Указаны недопустимые значения: "%value%".',
    'textItemsListNonUnique' => 'Указанное значение уже существует: "%value%".',
    'textItemsListMaxItemsCountExeeded' => 'Количество элементов не должно превышать %value%.',
    'invalidAcl' => 'Указано недопустимое имя компьютера: "%value%".',
    'nonUniqueAcl' => 'Указанное имя компьютера уже существует: "%value%".',
    'httpInvalidStatusFormat' => 'Коды состояний должны быть числами в форме 400 или 400.1',
    'httpInvalidStatusCode' => 'Коды состояний должны быть от %%minCode%% до %%maxCode%%',
    'httpInvalidStatusSubCode' => 'Коды подсостояний должны быть от %%minSubCode%% до %%maxSubCode%%',
    'httpInvalidStatusRange' => 'Диапазоны состояний должны указывать диапазон от минимального до максимального значения',
    'phpSettingValueByteRegexNotMatch' => 'Указано неверное значение. Введите целочисленное значение и краткое обозначение (К для килобайтов, М для мегабайтов, Г для гигабайтов, например, 128М) ',
    'phpFpmServersAmountNotPositive' => "Значение должно быть положительным числом",
    'phpFpmServersAmountLessThan' => "'%value%' меньше, чем '%%min%%' (%%field%%)",
    'phpFpmServersAmountGreaterThan' => "'%value%' больше, чем '%%max%%' (%%field%%)",
    'phpInvalidIniSyntax' => "Недопустимый синтаксис INI в строке %%line%%: '%%text%%'",
    'portRangeInvalid' => 'Недопустимый диапазон номеров портов. Номер слева должен быть меньше номера справа.',
    'portRangeValueInvalid' => 'Значение %value% в диапазоне портов недопустимо. Оно должно быть от %min% до %max%.',
    'domainResolvesToAnotherIp' => 'Домен преобразуется в недопустимый IP-адрес (%value%). Чтобы разместить сайт в сети, исправьте %%dnsSettingsLink%%.',
    'domainNotResolved' => 'Домен не может быть разрешен. Чтобы разместить сайт в сети, исправьте %%dnsSettingsLink%%.',
    'dnsSettingsLink' => 'Настройки DNS',
    'backupRotationSingleValueInvalid' => 'Ограничение превышено.',
    'backupRotationMultipleValueInvalid' => 'Количество резервных копий, запланированных для локального хранилища, превышает ограничение: %%details%%.',
    'backupRotationDetail' => '{count, plural, one {# резервная копия {type}} few {# резервные копии {type}} many {# резервных копий {type}} other {# резервной копии {type}}}',
    'backupRotationTypeHourly' => 'по часам',
    'backupRotationTypeDaily' => 'ежедневно',
    'backupRotationTypeWeekly' => 'еженедельно',
    'backupRotationTypeMonthly' => 'ежемесячно',

    'backupPathInvalidCharacters' => '"%value%" содержит недопустимые символы.',
    'backupPathInvalidDot' => '"%value%" содержит недопустимый путь "." или "..".',
    'networkAccessAlreadyExists' => 'Сеть уже присутствует в списке ограничения доступа.',
    'codeRegexNotMatch' => 'Этот код активации недействителен.',
    'nameUsedForPlesk' => 'Не удалось создать домен, потому что его имя входит в URL-адрес, который вы использовали для входа в Plesk. Чтобы создать домен, войдите в Plesk по ссылке https://%value%:8443 или https://plesk.%value%.',
    'invalidNameDirectory' => 'Недопустимое имя.',
    'invalidPasswordCharacters' => 'Пароль не может содержать кавычки, пробелы или национальные символы.',
    'invalidPasswordLength' => 'Пароль должен быть длиной от %%min%% до %%max%% символов.',
    'passwordContainsLogin' => 'Пароль не может содержать имя пользователя.',

    'invalidPhpExtensionName' => 'Недопустимое имя расширения.',
    'hexStringNotMatch' => 'Указанное значение не является допустимой шестнадцатеричной строкой.',
    'invalidCertificateData' => 'Указанное значение не является допустимыми данными сертификата.',
    'invalidSha256Hash' => 'Указанное значение не является допустимым хэшем SHA-256.',
    'invalidSha512Hash' => 'Указанное значение не является допустимым хэшем SHA-512.',
    'invalidTlsaMatchingType' => 'Указан недопустимый совпадающий тип TLSA.',

    'invalidHttpsIpv4hint' => 'Значение должно быть пустым или содержать разделенный запятыми список IPv4-адресов.',
    'invalidHttpsIpv6hint' => 'Значение должно быть пустым или содержать разделенный запятыми список IPv6-адресов.',
    'invalidHttpsProtocols' => 'Значение не должно содержать пробелов и символов \'=\', \'\\\', а его длина не должна превышать 255 байт.',
    'invalidHttpsVal' => 'Значение записи DNS HTTPS должно соответствовать стандарту RFC 9460.',
    'invalidHttpsValHost' => 'Значение параметра целевого компьютера должно быть действительным именем домена или пустым.',
    'invalidHttpsValPort' => 'Значение параметра "Порт" должно быть в диапазоне от 0 до 65535 включительно.',
    'invalidHttpsValProtocols' => 'Значение параметра "alpn" не должно содержать пробелов и символов \'=\', \'\\\', а его длина не должна превышать 255 байт.',
    'invalidHttpsValIpv4hint' => 'Значение параметра "ipv4hint" должно быть пустым или содержать разделенный запятыми список IPv4-адресов.',
    'invalidHttpsValIpv6hint' => 'Значение параметра "ipv6hint" должно быть пустым или содержать разделенный запятыми список IPv6-адресов.',

    'fail2ban.invalidIpsWithJailsList' => 'Список IP-адресов и имен джейлов должен быть указан в формате "IP,JAIL[;IP,JAIL...]".',
    'fail2ban.invalidIp' => 'IP-адреса в списке должны быть действительным IP-адресом или маской CIDR.',
    'fail2ban.invalidJail' => 'Джейлы в списке должны существовать и быть активными на сервере.',
    'fail2ban.ipTooLong' => 'IP-адреса в списке не должны быть длиннее {max, plural, one {# символа} other {# символов}}.',
    'fail2ban.ipTrusted' => 'IP-адреса в списке не должны быть надежными IP-адресами.',
    'fail2ban.banTrustedIp' => 'IP-адрес помечен как надежный и не может быть заблокирован.',

    'notifyInvalid' => 'Ожидаются следующие значения: %value%.',

    'cronStyleError' => 'Неверные синтаксис crontab.',
    'cronStyleErrorWin' => 'Косую черту (/) и дефис (-) использовать нельзя.',

    'scheduler.sysUserLoginInvalid' => 'Системный пользователь с именем %value% не разрешен или не существует.',

    'smarthost.invalidHostname' => 'Указанное значение должно быть действительным именем домена или IP-адресом.',
    'smarthost.invalidUsernameCharacters' => 'Имя пользователя может содержать только буквы, цифры и специальные символы, кроме %%invalid%%.',
    'smarthost.invalidUsernameLength' => 'Длина имени пользователя должна быть от %%minLength%% до %%maxLength%% символов.',
    'smarthost.invalidEncryption' => 'Эта опция не поддерживается.',
];