<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'anonymous-ftp.description' => 'Se il tuo sito è ospitato su un indirizzo IP dedicato (non condiviso con altri utenti o siti), puoi configurare una directory all\'interno del sito, dove altri utenti potranno caricare o scaricare file tramite FTP. Una volta FTP anonimo sarà attivato, gli utenti potranno accedere alla directory presso un indirizzo del tipo: ftp://ftp.your-domain.com con nome utente e password "anonimo".',
    'anonymous-ftp.displayLogin' => 'Mostra messaggio di login',
    'anonymous-ftp.loginText' => 'Testo del messaggio',
    'anonymous-ftp.incomingDir' => 'Consenti il caricamento nella directory in arrivo',
    'anonymous-ftp.incomingSubDir' => 'Permetti la creazione di directory nella directory in arrivo',
    'anonymous-ftp.incomingReadable' => 'Permetti il download dalla directory in arrivo',
    'anonymous-ftp.quota' => 'Limita lo spazio su disco nella directory in arrivo',
    'anonymous-ftp.maxConnections' => 'Limita il numero di connessioni simultanee',
    'anonymous-ftp.bandwidth' => 'Limita la larghezza di banda di download per questo dominio FTP virtuale',
    'anonymous-ftp.unlimited' => 'Illimitato',

    'aps.catalog.loading' => 'Caricamento in corso...',
    'aps.catalog.searchName' => 'Applicazione',
    'aps.catalog.searchVendor' => 'Fabbricante',
    'aps.catalog.searchPackager' => 'Packager',
    'aps.catalog.searchLicenseType' => 'Tipo di licenza',
    'aps.catalog.searchLicenseTypeAny' => 'Qualsiasi',
    'aps.catalog.searchLicenseTypeFreeware' => 'Gratis',
    'aps.catalog.searchLicenseTypeCommercial' => 'Commerciale',
    'aps.catalog.showSearch' => 'Visualizza Ricerca',
    'aps.catalog.hideSearch' => 'Nascondi Ricerca',
    'aps.catalog.buttonSearch' => 'Cerca',
    'aps.catalog.buttonResetSearch' => 'Reimposta Ricerca',
    'aps.catalog.showCategories' => 'Seleziona una categoria sotto oppure cerca app che usino la casella di ricerca',
    'aps.catalog.searchResults' => 'Risultati della ricerca',
    'aps.catalog.buttonInstall' => 'Installare',
    'aps.catalog.buttonInstallTooltip' => 'Installa rapidamente l\'ultima versione dell\'app con i parametri predefiniti ottimali.',
    'aps.catalog.buttonAdvancedInstall' => 'Installazione (personalizzata)',
    'aps.catalog.buttonAdvancedInstallTooltip' => 'Installa la versione più recente dell\'app, personalizzando tutti i parametri.',
    'aps.catalog.buttonInstallOldVersion' => 'Installa versione',
    'aps.catalog.buttonInstallOldVersionTooltip' => 'Installa la versione selezionata dell\'app, personalizzando tutti i parametri.',
    'aps.catalog.buttonInstallDescription' => 'Installare l\'applicazione su un sito se già avete un codice di attivazione o se solamente desiderate provarla.',
    'aps.catalog.buttonInstallDescriptionFree' => 'Installare questa applicazione gratuita su un sito.',
    'aps.catalog.version' => 'Versione',
    'aps.catalog.moreVersions' => 'Altre versioni',
    'aps.catalog.release' => 'Release',
    'aps.catalog.overview' => 'Panoramica',
    'aps.catalog.noApplicationsInCategory' => 'Nessun\'applicazione disponibile in questa categoria. Selezionare una categoria diversa.',
    'aps.catalog.noCategoriesSelected' => 'Selezionare una categoria per trovare le applicazioni disponibili in questa categoria.',
    'aps.catalog.noSearchResults' => 'La ricerca non ha individuato alcuna applicazione.',
    'aps.catalog.connectionFailed' => 'La connessione al Catalogo di Applicazioni non è riuscita. %%retryLink%%.',
    'aps.catalog.retry' => 'Riprovare',
    'aps.catalog.categoriesError' => 'Impossibile caricare la lista di categorie in questo momento.',
    'aps.catalog.applicationsError' => 'Impossibile caricare la lista di applicazioni in questo momento.',
    'aps.catalog.detailsError' => 'Non è stato possibile caricare i dettagli dell\'applicazione in questo momento.',
    'aps.catalog.searchError' => 'Impossibile caricare il risultato della ricerca in questo momento.',
    'aps.catalog.changelogEntry' => 'v%%version%% (Release %%release%%) - %%description%%',
    'aps.catalog.changelog' => 'Cronologia delle modifiche',
    'aps.catalog.officialApplicationSite' => 'Info sul Fabbricante',
    'aps.catalog.returnToCategories' => '< Ritorna alla lista di applicazioni',
    'aps.catalog.buttonUninstall' => 'Rimuovi',
    'aps.catalog.gotoHome' => 'Home',
    'aps.catalog.all' => 'Tutte',
    'aps.catalog.buttonDetails' => 'Per saperne di più',
    'aps.catalog.buttonBuy' => 'Acquistare subito',
    'aps.catalog.buttonBuyTooltip' => 'Acquista l\'app',
    'aps.catalog.buttonBuyDescription' => 'Visitare il nostro store per acquistare un codice di attivazione per l\'applicazione.',
    'aps.catalog.buttonDownload' => 'Scaricare',
    'aps.catalog.buttonDownloadDescription' => 'Scaricare l\'app se già si dispone di un codice di attivazione o si desidera solo provarlo.',
    'aps.catalog.marketplaceMoreInfo' => 'Per maggiori informazioni, visitare %%link%%.',
    'aps.catalog.marketplaceMoreInfoLink' => 'il sito web del fabbricante',

    'aps.configure.installedAt' => "Installata su",
    'aps.configure.otherSettings' => "Altro",
    'aps.configure.globalSettings' => 'Impostazioni del pacchetto',
    'aps.configure.passwordConfirmation' => 'Confermare password',
    'aps.configure.databaseParams' => 'Parametri del database',
    'aps.configure.noInstallationUrlAvailable' => 'Nessuna (App esterna)',
    'aps.configure.updateSettingsSection' => 'Impostazioni di aggiornamento',
    'aps.configure.forceUpdates' => 'Aggiorna automaticamente questa app quando ci saranno aggiornamenti',
    'aps.configure.forceUpdatesHint' => 'L\'app riceverà aggiornamenti automatici alle versioni più recenti. Attenzione: Usa questa opzione con cautela perché gli aggiornamenti possono incidere significativamente sulla funzionalità dell\'app. Ad esempio, le estensioni dell\'app potrebbero non funzionare con un\'altra versione dell\'app.',

    'aps.install.showAllSettings' => 'Visualizzare Tutte le Impostazioni',
    'aps.install.showLessSettings' => 'Visualizzare le Impostazioni Minime',
    'aps.install.install' => 'Installare',
    'aps.install.otherSettings' => 'Altre impostazioni',
    'aps.install.globalSettings' => 'Impostazioni del pacchetto',
    'aps.install.passwordConfirmation' => 'Conferma la password',
    'aps.install.provisionsSectionLabel' => 'Percorso all\'installazione',
    'aps.install.context' => 'Indica il percorso dove installare questa applicazione web',
    'aps.install.registerAsWebmailSection' => 'Registrazione Webmail',
    'aps.install.registerAsWebmailDescription' => "Seleziona questa opzione se l'applicazione è un client webmail. In questo modo, l'applicazione comparirà fra i servizi webmail disponibili nelle impostazioni Posta degli abbonamenti e piani di hosting. L'amministratore può configurare l'URL di accesso pubblico del webmail in Gestione del Server > Impostazioni > Webmail.",
    'aps.install.registerAsWebmailLabel' => 'Registrati come un servizio webmail',
    'aps.install.addItem' => 'Aggiungi',
    'aps.install.removeItem' => 'Rimuovi',
    'aps.install.updateSettingsSection' => 'Impostazioni di aggiornamento',
    'aps.install.forceUpdates' => 'Aggiorna automaticamente questa app quando ci saranno aggiornamenti',
    'aps.install.forceUpdatesHint' => 'L\'app riceverà aggiornamenti automatici alle versioni più recenti. Attenzione: Usa questa opzione con cautela perché gli aggiornamenti possono incidere significativamente sulla funzionalità dell\'app. Ad esempio, le estensioni dell\'app potrebbero non funzionare con un\'altra versione dell\'app.',

    'aps.invalid-requirements.requirementsLegend' => 'Requisiti',
    'aps.invalid-requirements.domainLegend' => 'Sito web',
    'aps.invalid-requirements.context' => 'Scegliere un altro sito web',
    'aps.invalid-requirements.backToApplicationList' => 'Ritorna alla lista di applicazioni',

    'aps.license.title' => 'Installazione di %%packageName%%',
    'aps.license.doYouAcceptLicense' => 'Per installare questa applicazione, è necessario leggere e accettare i termini del contratto di licenza per l\'utente finale.',
    'aps.license.licenseAgree' => 'Accetto i termini del Contratto di Licenza',

    'aps.services-list-customization.settings' => 'Impostazioni',

    'asp-dot-net.change-version.title' => 'Selezione della versione ASP.NET',
    'asp-dot-net.change-version.frameworkVersion' => 'La versione ASP.NET Framework',
    'asp-dot-net.change-version.success' => 'La versione di ASP.NET è stata modificata.',

    'asp-dot-net.settings.casSettingsSection' => "Sicurezza dall'accesso di codice",
    'asp-dot-net.settings.clientScriptsSection' => "Impostazioni libreria di script",
    'asp-dot-net.settings.connStringsSection' => "Manager di stringhe di connessione",
    'asp-dot-net.settings.customErrorsSection' => "Impostazioni errore personalizzato",
    'asp-dot-net.settings.frameworkVersionSection' => "Versione Framework",
    'asp-dot-net.settings.globalizationSection' => "Impostazioni globalizzazione",
    'asp-dot-net.settings.otherSection' => "Impostazioni della sessione",
    'asp-dot-net.settings.pageAndRuntimeSection' => "Compilazione e debugging",
    'asp-dot-net.settings.authMode' => "Modalità di autenticazione",
    'asp-dot-net.settings.connStrings' => "Stringhe di connessione",
    'asp-dot-net.settings.connStringsInvalid' => "Alcuni campi sono vuoti o contengono dati non validi.",
    'asp-dot-net.settings.connStringName' => "Nome",
    'asp-dot-net.settings.connStringValue' => "Parametri di connessione",
    'asp-dot-net.settings.connStringsDescription' => "Nome/Parametri di connessione",
    'asp-dot-net.settings.culture' => "Lingua",
    'asp-dot-net.settings.customErrMode' => "Modalità di errore personalizzata",
    'asp-dot-net.settings.customErrorRedirect' => "URL reindirizzamento",
    'asp-dot-net.settings.customErrorStatus' => "Codice di stato",
    'asp-dot-net.settings.customErrorStatusInvalid' => "Il codice dello stato deve essere un numero intero.",
    'asp-dot-net.settings.customErrors' => "Errori personalizzati",
    'asp-dot-net.settings.customErrorsDescription' => "Codice di stato/URL reindirizzamento",
    'asp-dot-net.settings.customErrorsInvalid' => "Alcuni campi sono vuoti o contengono dati non validi.",
    'asp-dot-net.settings.debugMode' => "Attiva il debugging",
    'asp-dot-net.settings.defLanguage' => "Lingua della pagina web predefinita",
    'asp-dot-net.settings.tempDirectory' => "Directory temporanea",
    'asp-dot-net.settings.fileEnc' => "Codifica file",
    'asp-dot-net.settings.fileEncInvalid' => "Il valore specificato per il parametro di Codifica del file non è valido.",
    'asp-dot-net.settings.pathToLib' => "Percorso alla libreria di script Microsoft",
    'asp-dot-net.settings.pathToLibInstall' => "Installazione",
    'asp-dot-net.settings.reqEnc' => "Codifica richiesta",
    'asp-dot-net.settings.reqEncInvalid' => "Il valore indicato per il parametro Codifica richiesta non è valido.",
    'asp-dot-net.settings.resEnc' => "Codifica risposta",
    'asp-dot-net.settings.resEncInvalid' => "Il valore indicato per il parametro Codifica risposta non è valido.",
    'asp-dot-net.settings.sessTimeout' => "Scadenza sessione (minuti)",
    'asp-dot-net.settings.sessTimeoutInvalid' => "Il valore specificato per il parametro Timeout della sessione non è valido. Inserisci un numero intero positivo inferiore di o uguale a %%max%%.",
    'asp-dot-net.settings.connStringDuplicate' => "Il nome della stringa di connessione è già in uso.",
    'asp-dot-net.settings.customErrorInvalidCode' => "Il codice di stato dev'essere compreso tra 100 e 999",
    'asp-dot-net.settings.customErrorDuplicate' => "Il codice di stato è già in uso.",
    'asp-dot-net.settings.trustLevel' => "Livello di attendibilità",
    'asp-dot-net.settings.uiCulture' => "Lingua UI",
    'asp-dot-net.settings.version' => "Versione",
    'asp-dot-net.settings.trustLevelAllowOverride' => 'Consenti sovrascrittura del livello attendibilità CAS sul sito',
    'asp-dot-net.settings.updateSuccess' => 'Aggiornamento completato',

    'database.clone.formDescription' => 'Copia il contenuto dei database in un database nuovo o esistente. Quando viene copiato in un database esistente, le tabelle del database di origine sono aggiunte alla lista di tabelle nel database di destinazione. Attenzione: Se i nomi di tabella coincidono, la tabella della sorgente sostituirà quella nella destinazione.',
    'database.clone.copyData' => 'Crea una copia completa',
    'database.clone.copyDataHint' => 'Se selezionato, l\'intero database (includendo la struttura e i dati) sarà copiato. Se deselezionato, soltanto la struttura delle tabelle sarà copiata.',
    'database.clone.server' => 'Server del database di destinazione',
    'database.clone.versionCut' => 'v%%version%%',
    'database.clone.externalServer' => 'Altro...',
    'database.clone.database' => 'Database di destinazione',
    'database.clone.newDatabase' => 'Crea database con nome',
    'database.clone.existingDatabase' => 'Copia in un database esistente',
    'database.clone.externalDbHost' => 'Nome host o indirizzo IP',
    'database.clone.externalDbLogin' => 'Nome utente',
    'database.clone.externalDbPassword' => 'Password',
    'database.clone.subscription' => 'Abbonamento di destinazione',
    'database.clone.subscription_powerUser' => 'Spazio web di destinazione',
    'database.clone.cloneInProgress' => 'Clonazione del database %%source%% al database %%destination%%. Verrai informato sull\'avanzamento della procedura per posta elettronica (%%email%%).',
    'database.clone.unableToClone' => 'Impossibile copiare il database "%%source%%".',
    'database.clone.unableToCreateExternalDatabase' => 'Impossibile creare un database "%%destination%%" nel server specificato.',
    'database.clone.databaseCloned' => 'Il database "%%source%%" è stato copiato.',
    'database.clone.emailSubjSuccess' => 'Il database "%%sourceDatabase%%" è stato copiato.',
    'database.clone.emailSubjFailure' => 'La copia del database "%%sourceDatabase%%" non è riuscita.',
    'database.clone.emailBodySuccess' => 'Il database "%%sourceDatabase%%" (%%sourceHost%%) è stato copiato nel database "%%destDatabase%%" (%%destHost%%).',
    'database.clone.emailBodyFailure' => 'Impossibile copiare il database "%%sourceDatabase%%" (%%sourceHost%%) nel database "%%destDatabase%%" (%%destHost%%). La procedura di copia non è riuscita.',
    'database.clone.localServer' => 'server locale',

    'database.repair-orphaned.formDescription' => 'Questo utente è diventato orfano dopo la procedura di ripristino. Per risolvere questo problema, fornire una password per l\'utente. Se l\'utente viene considerato utente di sistema senza una password, eseguire l\'utility di riparazione con il campo della password vuoto.',
    'database.repair-orphaned.login' => 'Nome utente del database',
    'database.repair-orphaned.pass' => 'Password',
    'database.repair-orphaned.pass2' => 'Conferma la password',
    'database.repair-orphaned.users' => 'Alcuni utenti richiedono la vostra attenzione. Ci sono diversi utenti orfani che dovrebbero essere riparati per funzionare correttamente.',
    'database.repair-orphaned.orphaned' => 'Utente orfano. %%gui begin:link%%Ripara ora%%gui end:link%%.',
    'database.repair-orphaned.repair' => 'Ripara',

    'database.repair.fixSelected' => 'Ripara selezionati',
    'database.repair.fix' => 'Ripara',

    'database.user.password' => 'Password',
    'database.user.passwordConfirmation' => 'Conferma Password',
    'database.user.server' => 'Server database',
    'database.user.versionCut' => 'v%%version%%',
    'database.user.database' => 'Database',
    'database.user.anyDatabase' => 'Qualsiasi',
    'database.user.dataAccess' => 'Accesso dati',
    'database.user.structureAccess' => 'Accesso a struttura',
    'database.user.globalAccess' => 'Privilegi globali',
    'database.user.globalAccessHint' => 'I privilegi globali funzionano per tutti i database all\'interno di questo account di hosting.',
    'database.user.aclRadio' => 'Controllo di accesso',
    'database.user.aclLocalhost' => 'Consenti unicamente le connessioni locali',
    'database.user.aclAny' => 'Consenti connessioni remote da qualunque host',
    'database.user.aclCustom' => 'Consenti connessioni remote da',
    'database.user.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nGli host indicati possono accedere al database per conto di questo utente.",
    'database.user.remoteAccess' => 'Accesso remoto',
    'database.user.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nGli indirizzi IP specificati possono accedere al database tramite un ruolo di firewall. Le modifiche effettuate in questo elenco saranno pre-moderate dal tuo fornitore di servizi di hosting.",
    'database.user.example' => "Ad esempio:\n%%example%%",
    'database.user.denied' => 'Usa regole di firewall di sistema',
    'database.user.allowed' => 'Consenti connessioni remote da',
    'database.user.default' => 'Usa le credenziali di questo utente in modo predefinito per accedere a %%webadmin%%',
    'database.user.remoteAccessHint' => 'Contatta il tuo fornitore di servizi di hosting e accertati che l\'opzione specificata sopra rispetterà le regole del firewall correnti per l\'accesso in entrata a MariaDB/MySQL.',
    'database.user.phpMyAdmin' => 'PhpMyAdmin',
    'database.user.webAdmin' => 'Ammin web',
    'database.user.role' => 'Ruolo',
    'database.user.roleReadWrite' => 'Lettura e scrittura',
    'database.user.roleWriteOnly' => 'Solo Lettura',
    'database.user.roleReadOnly' => 'Solo Lettura',
    'database.user.roleCustom' => 'Personalizza',

    'database.generalSection' => 'Generale',
    'database.name' => 'Nome del database',
    'database.server' => 'Server del database',
    'database.versionCut' => 'v%%version%%',
    'database.relatedDomain' => 'Sito correlato',
    'database.noDomainRelations' => 'Nessun sito correlato',
    'database.userSection' => 'Utenti',
    'database.userSectionDescription' => 'Crea un utente del database predefinito. Plesk accederà al database per conto di questo utente. Se al database non è stato assegnato alcun utente, allora non è accessibile.',
    'database.createUser' => 'Crea un utente del database',
    'database.username' => 'Nome utente del database',
    'database.password' => 'Password',
    'database.passwordConfirmation' => 'Conferma password',
    'database.allDbAccess' => 'L\'utente ha accesso a tutti i database nell\'abbonamento selezionato',
    'database.aclRadio' => 'Controllo di accesso',
    'database.aclLocalhost' => 'Consenti unicamente le connessioni locali',
    'database.aclAny' => 'Consenti connessioni remote da qualunque host',
    'database.aclCustom' => 'Consenti connessioni remote da',
    'database.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nGli host indicati possono accedere al database per conto di questo utente.",
    'database.remoteAccess' => 'Accesso remoto',
    'database.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nGli indirizzi IP specificati possono accedere al database tramite un ruolo di firewall. Le modifiche effettuate in questo elenco saranno pre-moderate dal tuo fornitore di servizi di hosting.",
    'database.example' => "Ad esempio:\n%%example%%",
    'database.denied' => 'Usa regole di firewall di sistema',
    'database.allowed' => 'Consenti connessioni remote da',

    'deployment-section.deploymentDisabledHint' => 'Carica file da un archivio Git',
    'deployment-section.deploymentEnabledHint' => 'Abilita assistenza Git',
    'deployment-section.deploymentSectionLegend' => 'I tuoi file da copiare nell\'hosting',
    'deployment-section.deploymentSectionDescriptionHint' => 'Se lasci il supporto Git disattivato, le directory radice (radice sito web/applicazione e radice documento) saranno create vuote, e il sito visualizzerà la pagina predefinita nel browser. Dovrai caricare i file del tuo sito sulla radice del documento utilizzando FTP o il File Manager. In alternativa, abilita Git ora o più tardi (in Siti web e domini) e carica i file da un archivio Git.',

    'dns-zone.add-acl-record.description' => 'Aggiungi un indirizzo IP di un server DNS autorizzato a ricevere una copia della zona DNS.',
    'dns-zone.add-acl-record.ipAddress' => 'Indirizzo IP',
    'dns-zone.add-acl-record.ipAddressWithMask' => 'Indirizzo/maschera IP',

    'dns-zone.record.add-title' => "Aggiungi un record di risorsa al modello della zona",
    'dns-zone.record.add-ns-title' => "Aggiungi un nameserver",
    'dns-zone.record.edit-title' => "Modifica record di risorsa",
    'dns-zone.record.edit-success' => "Record DNS aggiornato.",
    'dns-zone.record.add-success' => "Record DNS creato.",
    'dns-zone.record.type' => "Tipo di record",
    'dns-zone.record.domainName' => "Nome di Dominio",
    'dns-zone.record.domainNamePostfix' => ".<domain>",
    'dns-zone.record.nameServer' => "Server di nomi",
    'dns-zone.record.protocol' => "Protocollo",
    'dns-zone.record.priority' => "Priorità",
    'dns-zone.record.priorityLow' => "bassa (%%priority%%)",
    'dns-zone.record.priorityHigh' => "molto alta (%%priority%%)",
    'dns-zone.record.weightLow' => "basso (%%weight%%)",
    'dns-zone.record.weightHigh' => "molto elevato (%%weight%%)",
    'dns-zone.record.ipAddress' => "Indirizzo IP",
    'dns-zone.record.ipAddressDescription' => "Per esempio, 123.123.123.123",
    'dns-zone.record.ipAddressDescriptionExt' => "Per esempio, <ip>, 123.123.123.123",
    'dns-zone.record.ipAddressV6' => "Indirizzo IPv6",
    'dns-zone.record.ipAddressV6Description' => "Per esempio, 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressV6DescriptionExt' => "Per esempio, <ipv6>, 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressWithMaskDescription' => "Per esempio, 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.ipAddressWithMaskDescriptionExt' => "Per esempio, <ipv6>, <ip>, 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.masterIpAddressDescription' => "Per esempio, 2002:7b7b:7b7b::1, 123.123.123.123",
    'dns-zone.record.canonicalName' => "Nome canonico",
    'dns-zone.record.mailDomain' => "Dominio di posta",
    'dns-zone.record.mxServer' => "Server exchange di posta",
    'dns-zone.record.mxServerPriority' => "Specifica la priorità del server di gestione della posta",
    'dns-zone.record.txtRecord' => "Registro TXT",
    'dns-zone.record.txtRecordString' => "Inserisci record SPF",
    'dns-zone.record.txtSpfSyntax' => "Record SPF",
    'dns-zone.record.txtRecordDescription' => "",
    'dns-zone.record.invalidTxtRecord' => "Sono stati specificati valori errati per il record TXT.",
    'dns-zone.record.quotedTxtRecord' => "Il valore del registro TXT deve essere un'unica stringa priva di virgolette.",
    'dns-zone.record.dsRecord' => "Record DS",
    'dns-zone.record.dsRecordDescription' => "Ad esempio, 60485 5 1 2BB183AF5F22588179A53B0A98631FAD1A292118",
    'dns-zone.record.invalidDsRecord' => "È stato specificato un valore errato per il record DS.",
    'dns-zone.record.serviceName' => "Nome di servizio",
    'dns-zone.record.serviceNameDescription' => 'Esempio: SIP (senza il trattino basso).',
    'dns-zone.record.protocolNameDescription' => 'Esempio: tcp (senza il trattino basso).',
    'dns-zone.record.portDescription' => 'Esempio: 25 (senza il trattino basso).',
    'dns-zone.record.srvWeight' => "Peso relativo per i record con la stessa priorità",
    'dns-zone.record.targetHost' => "Host obiettivo",
    'dns-zone.record.targetHostDescription' => "Per esempio, example.com",
    'dns-zone.record.targetPort' => "Porta obiettivo",
    'dns-zone.record.targetPortDescription' => 'Per esempio, 8443.',
    'dns-zone.record.retrieveDataError' => "Dati record non trovati.",
    'dns-zone.record.unknownTypeError' => "Tipo di record DNS sconosciuto.",
    'dns-zone.record.nullMxRecordMustBeTheOnly' => 'Impossibile impostare il record MX NULL mentre è presente un altro record MX.',
    'dns-zone.record.cannotHaveMxNullRecordAndMxRecord' => 'Impossibile impostare il record MX non-NULL mentre è presente il record MX NULL',
    'dns-zone.record.masterShouldBeRemote' => "È necessario disporre di due distinti server di nomi autorevoli su host separati.",
    'dns-zone.record.caaTag' => "Etichetta",
    'dns-zone.record.caaRecord' => "Valore",
    'dns-zone.record.caaRecordDescription' => "",
    'dns-zone.record.tlsaPort' => 'Porta',
    'dns-zone.record.tlsaProtocol' => 'Protocollo',
    'dns-zone.record.tlsaUsage' => 'Utilizzo',
    'dns-zone.record.tlsaSelector' => 'Selettore',
    'dns-zone.record.tlsaMatching' => 'Tipo di corrispondenza',
    'dns-zone.record.tlsaCertData' => 'Dati associazione certificato',
    'dns-zone.record.tlsaSeeLinkForDetails' => 'Vedi %%link%% per i dettagli',
    'dns-zone.record.tlsaRfc6698Section211' => 'RFC6698, sezione 2.1.1',
    'dns-zone.record.tlsaRfc6698Section212' => 'RFC6698, sezione 2.1.2',
    'dns-zone.record.tlsaRfc6698Section213' => 'RFC6698, sezione 2.1.3',
    'dns-zone.record.tlsaRfc6698Section214' => 'RFC6698, sezione 2.1.4',

    'dns-zone.record.httpsPriorityAlias' => "alias (%%priority%%)",
    'dns-zone.record.httpsTargetHostDescription' => 'Per esempio, esempio.com. Se il valore è vuoto, significa che l\'host corrisponde al nome del dominio.',
    'dns-zone.record.httpsProtocols' => 'Protocolli',
    'dns-zone.record.httpsProtocolsDescription' => 'Una lista di protocolli supportati dall\'hosting bersaglio separati da una virgola. Per esempio, h3,h3-29,h2,http/1.1.',
    'dns-zone.record.httpsForceProtocols' => 'Forza usando solo i protocolli specificati. La lista dei protocolli in alto non deve essere vuota.',
    'dns-zone.record.httpsIpv4hint' => 'Suggerimento indirizzi IPv4',
    'dns-zone.record.httpsIpv4hintDescription' => 'Una lista di indirizzi IPv4 separati da una virgola che possono essere usati da un cliente per raggiungere il servizio.',
    'dns-zone.record.httpsIpv6hint' => 'Suggerimento indirizzi IPv6',
    'dns-zone.record.httpsIpv6hintDescription' => 'Una lista di indirizzi IPv6 separati da una virgola che possono essere usati da un cliente per raggiungere il servizio.',

    'dns-zone.record.ttl' => "TTL",
    'dns-zone.record.ttl-seconds' => "Secondi",
    'dns-zone.record.invalidValue' => 'Valore non valido. Può essere da 1 a 2147483647 secondi.',
    'dns-zone.record.ttlDefaultValue' => 'Valore predefinito: %%value%% secondi',
    'dns-zone.record.invalidTTL' => 'Il valore TTL specificato non è valido.',
    'dns-zone.record.invalidIpAddress' => 'L\'indirizzo IP specificato non è valido.',
    'dns-zone.record.invalidIpMaskPair' => 'L\'abbinamento indirizzo IP/maschera di rete specificato non è valido.',
    'dns-zone.record.invalidCName' => 'Il nome canonico specificato non è valido.',
    'dns-zone.record.invalidPort' => 'La porta specificata non è valida.',
    'dns-zone.record.invalidTLSACertData' => 'I dati di associazione del certificato non sono validi.',
    'dns-zone.record.invalidTLSAProtocol' => 'Il protocollo specificato non è valido.',
    'dns-zone.record.invalidTLSAUsage' => 'L\'uso specificato non è valido.',
    'dns-zone.record.invalidTLSASelector' => 'Il selettore specificato non è valido.',
    'dns-zone.record.invalidTLSAMatching' => 'Il tipo di corrispondenza non è valido.',

    'dns-zone.restore-default.formHint' => "In questa sezione è possibile ripristinare la configurazione della zona originale secondo le impostazioni del modello DNS predefinito usato nel server: Seleziona gli indirizzi IP da usare per ripristinare la zona e specifica se un alias www è richiesto per il dominio.",
    'dns-zone.restore-default.ipv4' => "Indirizzo IPv4",
    'dns-zone.restore-default.ipv4Hint' => "Per esempio, 123.123.123.123",
    'dns-zone.restore-default.ipv6' => "Indirizzo IPv6",
    'dns-zone.restore-default.ipv6Hint' => "Per esempio, 2002:7b7b:7b7b::1",
    'dns-zone.restore-default.invalidIpAddress' => 'L\'indirizzo IP specificato non è valido.',
    'dns-zone.restore-default.customIpHint' => "I registri con questo indirizzo IP saranno considerati modificati dall'utente e non verranno sincronizzati con il modello DNS del server.",
    'dns-zone.restore-default.wwwPrefix' => "Prefisso WWW",
    'dns-zone.restore-default.previewRecords' => "Ripristina i registri usati per l'anteprima del sito",

    'dns-zone.soa-record.soaMnameSection' => 'Server di nomi primario',
    'dns-zone.soa-record.soaMname' => 'Server di nomi',
    'dns-zone.soa-record.soaMnameAutoselect' => '(Selezione automatica)',
    'dns-zone.soa-record.soaRecordSection' => 'Record SOA',
    'dns-zone.soa-record.ttl' => 'TTL',
    'dns-zone.soa-record.refresh' => 'Aggiorna',
    'dns-zone.soa-record.retry' => 'Riprovare',
    'dns-zone.soa-record.expire' => 'Scadenza',
    'dns-zone.soa-record.minimum' => 'Minimo',
    'dns-zone.soa-record.rnameType' => 'Email (RNAME)',
    'dns-zone.soa-record.rnameTypeHint' => 'L’indirizzo e-mail della persona responsabile per la zona DNS del dominio. Restituito dal server DNS in risposta a query SOA.',
    'dns-zone.soa-record.rnameTypeOwner' => 'Indirizzo e-mail del proprietario del sito Web',
    'dns-zone.soa-record.rnameTypeDomain' => 'Indirizzo e-mail non valido',
    'dns-zone.soa-record.rnameTypeDomainHint' => 'Inserisci solo la parte locale (prima di @<dominio>)',
    'dns-zone.soa-record.rnameTypeExternal' => 'Indirizzo esterno non valido',
    'dns-zone.soa-record.rnameEnforceEmail' => 'Vieta di modificare l’indirizzo e-mail RNAME dominio per dominio',
    'dns-zone.soa-record.invalidValue' => 'Valore non valido. Può essere da 1 secondo a 68 anni.',
    'dns-zone.soa-record.advancedSection' => 'Funzionalità di DNS avanzate',
    'dns-zone.soa-record.serialNumberFormat' => 'Usa il formato del numero di serie consigliato da IETF e RIPE',
    'dns-zone.soa-record.serialNumberFormatHint' => 'Seleziona questa opzione se il tuo dominio non riesce a superare la verifica SOA del registrar. Molti registrar accettano solo numeri di serie aventi questo formato.',
    'dns-zone.soa-record.restoreDefaultButton' => 'Usa impostazioni predefinite',
    'dns-zone.soa-record.zoneDefaultsSection' => 'Valori predefiniti di zona',
    'dns-zone.soa-record.unitSeconds' => 'secondi',
    'dns-zone.soa-record.unitMinutes' => 'minuti',
    'dns-zone.soa-record.unitHours' => 'ore',
    'dns-zone.soa-record.unitDays' => 'giorni',
    'dns-zone.soa-record.unitWeeks' => 'settimane',
    'dns-zone.soa-record.refreshValueIsSmallWarning' => 'Il valore per l\'intervallo di aggiornamento è minore di un\'ora, ciò può incrementare sensibilmente il traffico del server e l\'uso di risorse.',
    'dns-zone.soa-record.minimumValueIsBigWarning' => 'L\'impostazione del valore del TTL minimo superiore a 3 ore puo\' rendere i tuoi domini inaccessibili per alcuni degli amministratori di dominio. E\' raccomandato impostare tale valore solo se il restrar dei tuoi nomi a dominio lo richiede espressamente.',
    'dns-zone.soa-record.success' => 'Le proprietà del record SOA sono state aggiornate.',
    'dns-zone.soa-record.restoreDefaultSuccess' => 'Il record SOA di default è stato ripristinato.',

    'domain-info-section.domainName' => 'Nome dominio',
    'domain-info-section.emptyDomainName' => 'Fornire un nome di dominio.',
    'domain-info-section.ipAddress' => 'Indirizzo IP',
    'domain-info-section.shared' => 'condiviso',
    'domain-info-section.exclusive' => 'dedicato',
    'domain-info-section.ipAddressHint' => "L'indirizzo IP su cui è ospitato il sito web è un indirizzo di rete dell'host virtuale del sito web. Questo indirizzo IP viene utilizzato per tutti i siti web creati all'interno dell'abbonamento.",
    'domain-info-section.ipAddressHint_powerUser' => "L'indirizzo IP su cui è ospitato il sito web è un indirizzo di rete dell'host virtuale del sito web. Questo indirizzo IP verrà usato per tutti i siti web creati nello spazio web",
    'domain-info-section.userName' => 'Nome utente',
    'domain-info-section.userNameHint' => 'L\'account dell\'utente di sistema associato allo spazio web, utilizzato per accedere ai file ospitati su FTP e SSH.',
    'domain-info-section.emptyLogin' => 'Fornire un nome utente.',
    'domain-info-section.password' => 'Password',
    'domain-info-section.emptyPassword' => 'Fornire una password.',
    'domain-info-section.passwordConfirmation' => 'Ripetere la password',

    'email-address.generalTab' => 'Generale',
    'email-address.generalHint' => 'Se questo account di posta elettronica è associato a un utente aggiuntivo (accesso al pannello cliente abilitato), le modifiche apportate a questa pagina avranno effetto sulle impostazioni di questo utente. In particolare, se si modifica l\'indirizzo e-mail e la password, il login e la password dell\'utente aggiuntivo saranno anch\'essi modificati in base ai nuovi valori.',
    'email-address.redirectTab' => 'Inoltro',
    'email-address.redirectHint' => 'Imposta l\'inoltro di messaggi e-mail a uno o più indirizzi e-mail.',
    'email-address.aliasesTab' => 'Alias e-mail',
    'email-address.autoResponderTab' => 'Risposta automatica',
    'email-address.antispamTab' => 'Filtro antispam',
    'email-address.autoResponderHint' => 'Configura una risposta automatica per ogni messaggio di posta inviato al tuo indirizzo e-mail. La risposta automatica è un metodo standard per comunicare ai corrispondenti che si è fuori sede o in vacanza.',
    'email-address.antivirusTab' => 'Antivirus',
    'email-address.name' => 'Indirizzo e-mail',
    'email-address.externalEmail' => 'Indirizzo esterno non valido',
    'email-address.externalEmailHint' => 'Consentirà di reimpostare la password in caso di perdita dell’accesso all’indirizzo e-mail primario.',
    'email-address.user' => 'Assegnato a',
    'email-address.password' => 'Password',
    'email-address.passwordConfirmation' => 'Confermare la password',
    'email-address.responderEnable' => 'Attiva la risposta automatica',
    'email-address.responderSubject' => 'Oggetto del messaggio di risposta automatica',
    'email-address.responderContentType' => 'Formato del messaggio',
    'email-address.responderContentTypeHint' => 'Il formato testo normale è supportato da tutti i programmi client di posta, quindi tutti i destinatari  visualizzano il messaggio nello stesso modo in cui è visualizzato all\'utente. I messaggi HTML sono esteticamente migliori perché consentono di inserire il testo formattato con stili diversi. Tuttavia, alcuni client di posta non supportano i messaggi HTML e alcuni destinatari non riescono a visualizzare il testo formattato.',
    'email-address.responderContentTypeTextPlain' => 'Testo normale',
    'email-address.responderContentTypeTextHtml' => 'Modalità HTML',
    'email-address.responderCodepage' => 'Codifica',
    'email-address.responderCodepageHint' => 'La codifica definisce come i caratteri di testo vengono visualizzati. La codifica consigliata è UTF-8.',
    'email-address.responderReplyTo' => 'Inoltro a',
    'email-address.responderReplyToHint' => 'Quando la risposta automatica viene inviata, il messaggio originale viene inoltrato all\'indirizzo e-mail specificato.',
    'email-address.responderForwardAddress' => 'Inoltro a',
    'email-address.responderForwardAddressHint' => 'Quando la risposta automatica viene inviata, il messaggio originale viene inoltrato all\'indirizzo e-mail specificato.',
    'email-address.responderMessage' => 'Testo del messaggio di risposta automatica',
    'email-address.responderReplyToEqualsEmail' => 'L\'indirizzo specificato per l\'inoltro coincide con questo indirizzo e-mail.',
    'email-address.responderForwardAddressEqualsEmail' => 'L\'indirizzo specificato per l\'inoltro coincide con questo indirizzo e-mail.',
    'email-address.responderReplyLimit' => 'Invia una risposta automatica a un indirizzo e-mail unico non più di (volte al giorno)',
    'email-address.buttonAddResponderAttachment' => 'Aggiungi un allegato',
    'email-address.buttonRemoveResponderAttachment' => 'Rimuovi',
    'email-address.responderAttachment' => 'Allega un file',
    'email-address.redirectEnable' => 'Attiva l\'inoltro della posta',
    'email-address.redirectRemoveEnable' => 'Non inviare copie delle e-mail inoltrate alla casella di posta di Plesk',
    'email-address.redirectAddress' => 'Inoltra i messaggi in arrivo al seguente indirizzo e-mail',
    'email-address.redirectAddressHint' => 'Indicare gli indirizzi email. È possibile digitare ogni indirizzo su una riga oppure dividere gli indirizzi con spazi, virgole o punti e virgola.',
    'email-address.role' => 'Ruolo utente',
    'email-address.roleHint' => 'I ruoli utente garantiscono agli utenti i privilegi amministrativi e l\'accesso alle applicazioni selezionate per il ruolo.',
    'email-address.errorRedirectAddress' => 'Hai specificato un indirizzo e-mail non valido: %value%.',
    'email-address.errorRedirectAddressMultiple' => 'Hai specificato indirizzi e-mail non validi: %value%.',
    'email-address.mailAlias' => "Alias e-mail",
    'email-address.mailAliasNone' => 'Nessuno',
    'email-address.mailAliasHint' => "Gli alias della posta elettronica sono indirizzi e-mail alternativi associati a un indirizzo e-mail principale. Tutti i messaggi elettronici inviati all'alias e-mail saranno ricevuti dall'indirizzo e-mail principale.",
    'email-address.buttonAddMailAlias' => 'Aggiungi alias e-mail',
    'email-address.buttonRemoveMailAlias' => 'Rimuovere',
    'email-address.emptyEmail' => 'Indica un indirizzo e-mail al quale verranno inoltrati tutti i messaggi in arrivo.',
    'email-address.emailsIsEqual' => 'L’indirizzo e-mail esterno corrisponde a quello primario. Specifica un indirizzo e-mail esterno diverso.',
    'email-address.emptyPassword' => 'È necessario fornire una password.',
    'email-address.emptyPasswordConfirmation' => 'È necessario confermare la password.',
    'email-address.emptyAlias' => "Indica un alias e-mail per questo indirizzo di posta elettronica.",
    'email-address.aliasEqualsEmail' => 'L\'alias di posta specificato coincide con l\'indirizzo e-mail.',
    'email-address.passwordHint' => 'Consentirà di accedere alla casella postale e a Plesk (se l’opzione corrispondente è attiva).',
    'email-address.cyclicRedirect' => 'L\'indirizzo e-mail non può essere configurato per inoltrare messaggi e-mail a sé stesso.',
    'email-address.errorMailnameReserved' => 'L\'indirizzo e-mail specificato è già in uso.',
    'email-address.antivirusEnable' => 'Attiva protezione antivirus per questo indirizzo e-mail',
    'email-address.antivirusHint' => 'Il servizio antivirus blocca i messaggi e-mail che contengono virus e lo comunica sia al mittente sia al destinatario.',
    'email-address.antivirusSettings' => 'Controllare se sono presenti virus',
    'email-address.antivirusSettingOnlyIncomingMail' => 'solo la posta in arrivo',
    'email-address.antivirusSettingOnlyOutgoingMail' => 'solo la posta in uscita',
    'email-address.antivirusSettingOnlyIncomingAndOutgoingMail' => 'posta in arrivo ed in uscita',
    'email-address.antispamHint' => 'Il servizio di filtraggio dello spam rileva i messaggi spam inviati all\'indirizzo e-mail. È possibile impostare il filtro antispam per eliminare i messaggi spam, contrassegnarli come spam modificando l\'oggetto o spostarli nella cartella spam speciale accessibile dai client di posta su IMAP. Il filtro antispam utilizza una vasta gamma di test di rete e locali per individuare le firme spam.',
    'email-address.antispamEnable' => 'Attiva il filtro antispam per questo indirizzo e-mail',
    'email-address.antispamSettings' => 'Cosa fare con i messaggi classificati come spam',
    'email-address.antispamSettingsMark' => 'Contrassegnare i messaggi spam aggiungendo il testo seguente all\'oggetto del messaggio',
    'email-address.antispamSettingsMarkHint' => 'Lascia questo campo vuoto se non vuoi aggiungere alcun testo.Digita _SCORE_ se vuoi includere il punteggio nell\'oggetto del messaggio.',
    'email-address.antispamReportTextHint' => 'Digita il testo che desideri aggiungere al corpo dei messaggi email spam.',
    'email-address.antispamSettingsDelete' => 'Elimina tutti i messaggi spam',
    'email-address.antispamSettingsDeleteHint' => 'I messaggi spam verranno eliminati dalla casella postale.',
    'email-address.antispamSettingsMove' => 'Sposta lo spam nella cartella Spam',
    'email-address.antispamSettingsMoveHint' => 'Sposta tutti i messaggi spam nella cartella chiamata Spam. Questa cartella è accessibile dal programma client di posta o dalla webmail. Se si utilizza un account di posta IMAP, è possibile utilizzare la cartella Spam per l\'addestramento del filtro antispam.',
    'email-address.antispamSettingsMoveWarning' => '"Sposta lo spam nella cartella Spam" non funziona a meno che non disabiliti l\'opzione "Non inviare copie delle e-mail inoltrate" nella scheda "Inoltro".',
    'email-address.antispamSettingsMoveJunk' => 'Sposta lo spam nella cartella “Posta indesiderata”',
    'email-address.antispamSettingsMoveJunkHint' => 'Sposta tutti i messaggi spam nella cartella denominata “Posta indesiderata”. Questa cartella è accessibile dal programma client di posta o dalla webmail. Se si utilizza un account di posta IMAP, è possibile utilizzare la cartella "Posta Indesiderata" per l\'addestramento del filtro antispam.',
    'email-address.antispamShowAdvancedSection' => 'Mostra impostazioni avanzate',
    'email-address.antispamHideAdvancedSection' => 'Nascondi impostazioni avanzate',
    'email-address.antispamLearnMore' => 'Ulteriori informazioni su come addestrare il filtro antispam.',
    'email-address.antispamFilterScoreTitle' => 'Sensibilità del filtro',
    'email-address.antispamFilterScoreHint' => 'Il filtro antispam esegue una serie di test diversi sul contenuto e sull\'oggetto di ogni messaggio. Di conseguenza, ogni messaggio accumula un certo numero di punti. Più alto è il numero, più probabilità ci sono che un messaggio sia spam. Per impostazione predefinita, la sensibilità del filtro è impostata in modo che tutti i messaggi con un punteggio pari o superiore a 7 punti siano classificati come spam. Se si ricevono molti messaggi spam con le impostazioni attuali, per rendere più sensibile il filtro, si consiglia di provare a impostare un valore inferiore, ad esempio 6. Se non si ricevono determinati messaggi perché il filtro antispam li considera posta indesiderata, si consiglia di provare a ridurre la sensibilità del filtro impostando un valore superiore, ad esempio 8.',
    'email-address.antispamFilterScore' => 'Sensibilità del filtro antispam',
    'email-address.antispamWhiteListTitle' => 'Lista Bianca',
    'email-address.antispamWhiteListHint' => 'Le e-mail inviate da mittenti presenti nella white list non vengono controllate dal filtro antispam.',
    'email-address.antispamWhiteListField' => 'Lista bianca',
    'email-address.antispamWhiteListFieldHint' => 'Digitare i nomi di dominio, un nome di dominio per riga. Gli indirizzi possono contenere i caratteri jolly "*" e "?", ad esempio *@domain.com, user?@*.com.',
    'email-address.antispamBlackListTitle' => 'Lista Nera',
    'email-address.antispamBlackListHint' => 'Le e-mail inviate da mittenti presenti nella black list sono classificate come spam.',
    'email-address.antispamBlackListField' => 'Lista nera',
    'email-address.antispamBlackListFieldHint' => 'Digitare i nomi di dominio, un dominio per riga. Gli indirizzi possono contenere i caratteri jolly "*" e "?", ad esempio *@domain.com, user?@*.com.',
    'email-address.antispamTrustedLanguagesTitle' => 'Lingue attendibili',
    'email-address.antispamTrustedLanguagesHint' => 'I messaggi e-mail scritti in queste lingue passeranno sempre il filtro.',
    'email-address.antispamTrustedLocalesTitle' => 'Traduzioni attendibili',
    'email-address.antispamTrustedLocalesHint' => 'I messaggi e-mail che usano i gruppi di impostazioni internazionali specificate passeranno sempre il filtro. Le localizzazioni comprendono i set di caratteri più comunemente utilizzati. Ad esempio, il set di caratteri occidentali include le codifiche per le lettere utilizzate in inglese e nelle lingue dell\'Europa occidentale.',
    'email-address.antispamTrustedNetworksTitle' => 'Reti attendibili',
    'email-address.antispamTrustedNetworksHint' => 'Gli host di relay sulle reti autorizzate non sono considerati potenzialmente gestiti dagli spammer e non sono relay o proxy aperti.',
    'email-address.antispamIpAddressesField' => 'Indirizzi IP',
    'email-address.antispamIpAddressesFieldHint' => 'Specifica la maschera e l\'indirizzo IP di rete.',
    'email-address.mailBoxQuotaDomainDefault' => 'Dimensioni predefinite (%%domainMboxQuota%%)',
    'email-address.mailBoxQuotaDomainDefaultNew' => 'Dimensioni predefinite',
    'email-address.mailBoxOutgoingMessages' => 'Il numero massimo di messaggi email in uscita',
    'email-address.mailBoxOutgoingMessagesDomainDefault' => 'Predefinito (%%domainOutgoingMessages%% messaggi l\'ora)',
    'email-address.mailBoxOutgoingMessagesDomainSpecific' => 'Valore predefinito per la casella postale',
    'email-address.mailBoxOutgoingMessagesDomainSpecificHint' => 'messaggi',
    'email-address.mailBoxOutgoingMessagesDomainDefaultNew' => 'Predefinito',
    'email-address.mailBoxQuotaDomainDefaultReadonly' => 'Dimensioni predefinite',
    'email-address.mailBoxQuotaDomainSpecific' => 'Un\'altra dimensione',
    'email-address.mailBoxQuotaDomainSpecificReadonly' => 'Dimensione della casella postale',
    'email-address.mailBoxQuotaUnlimited' => 'Illimitato',
    'email-address.mailBoxLimitReached' => 'È stato raggiunto il limite di caselle postali consentite.',
    'email-address.postboxEnabled' => 'Casella postale',
    'email-address.postboxEnabledYes' => 'Attivato',
    'email-address.postboxEnabledNo' => 'Disattivato',
    'email-address.description' => 'Descrizione in Plesk',
    'email-address.descriptionHint' => 'La descrizione è visibile a chiunque abbia accesso a questo account email.',
    'email-address.longDescription' => 'La descrizione specificata è troppo lunga. Non può contenere più di %%max%% simboli.',
    'email-address.loginAsUser' => 'È utilizzabile per accedere a Plesk',
    'email-address.loginAsUserDescription' => '(nome utente: %%username%%)',
    'email-address.maxCustomSizeDesc' => 'Le dimensioni della casella postale non possono superare quelle predefinite.',
    'email-address.endDateEnable' => 'Disattiva risposta automatica',

    'failed-request.enable-tracing.description' => 'Il rintracciamento delle richieste non riuscite è un\'operazione ad alto utilizzo di risorse. Il rintracciamento verrà automaticamente arrestato entro %%days%% giorni. È possibile fermarlo manualmente in qualsiasi momento.',
    'failed-request.enable-tracing.statusCodes' => 'Codici dello stato',
    'failed-request.enable-tracing.statusCodesDescription' => 'Esempio: 401.3-999, 405',
    'failed-request.enable-tracing.provider' => 'Fornitore',

    'file-manager.show.buttonReload' => 'Ricarica',
    'file-manager.show.buttonSave' => 'Salva',
    'file-manager.show.buttonSaveAs' => 'Salva con nome',
    'file-manager.show.buttonReset' => 'Reimposta',
    'file-manager.show.buttonTextCodeEditor' => 'Modifica in editor di codice',
    'file-manager.show.buttonTextEdit' => 'Modifica nell\'editor di testo',
    'file-manager.show.buttonWysiwygEdit' => 'Modifica in Editor HTML',
    'file-manager.show.eolLabel' => 'Tipo di interruzione di linea:',
    'file-manager.show.saveAs' => 'Salva come:',
    'file-manager.show.saveCodepage' => 'Salva con la seguente codifica:',
    'file-manager.show.loadCodepage' => 'Mostra il file originale con la codifica seguente:',
    'file-manager.show.loadCodepageHint' => 'Avviso: le modifiche non salvate si perderanno quando il file verrà ricaricato.',
    'file-manager.show.fileExists' => "Il file o cartella %%fileName%% esiste già. Non è possibile usare una cartella e un file con lo stesso nome.",
    'file-manager.show.popupTitle' => 'Salva come',
    'file-manager.show.popupFilename' => 'Nome di file:',

    'file-manager.permissions.filePermissions' => 'Permessi per i file',
    'file-manager.permissions.directoryPermissions' => 'Permessi per la directory',
    'file-manager.permissions.buttonSubmit' => 'Salva',
    'file-manager.permissions.buttonApply' => 'Salva e riprendi',
    'file-manager.permissions.buttonCancel' => 'Annulla',
    'file-manager.permissions.buttonAdvanced' => 'Avanzato',

    'file-manager.unix-file-permissions.group' => 'Gruppo',
    'file-manager.unix-file-permissions.owner' => 'Proprietario',
    'file-manager.unix-file-permissions.others' => 'Altri',
    'file-manager.unix-file-permissions.readMode' => 'Lettura',
    'file-manager.unix-file-permissions.writeMode' => 'Scrittura',
    'file-manager.unix-file-permissions.execMode' => 'Esegui/cerca',
    'file-manager.unix-file-permissions.changeRecursive' => 'Modifica permessi in modo ricorsivo',

    'file-manager.windows-permissions.allow' => 'Consenti',
    'file-manager.windows-permissions.deny' => 'Nega',
    'file-manager.windows-permissions.inheritFromParent' => 'Consenti autorizzazioni ereditabili dall\'oggetto principale di propagarsi a questo oggetto e a tutti gli oggetti secondari. Includile con le voci esplicitamente qui specificate',
    'file-manager.windows-permissions.replaceOnChildren' => 'Sostituisci le voci del permesso di tutti gli oggetti secondari con le voci qui mostrate.',
    'file-manager.windows-permissions.buttonAdvanced' => 'Avanzato',
    'file-manager.windows-permissions.applyTo' => 'Applica a:',
    'file-manager.windows-permissions.folderOnly' => 'Solo la cartella selezionata',
    'file-manager.windows-permissions.subfolderOnly' => 'Solo sottocartelle',
    'file-manager.windows-permissions.filesOnly' => 'Solo file',
    'file-manager.windows-permissions.permissionsFor' => 'Permessi per',
    'file-manager.windows-permissions.applyOnto1' => 'Solo la cartella selezionata',
    'file-manager.windows-permissions.applyOnto2' => 'Solo sottocartelle',
    'file-manager.windows-permissions.applyOnto3' => 'La cartella selezionata e le sottocartelle',
    'file-manager.windows-permissions.applyOnto4' => 'Solo file',
    'file-manager.windows-permissions.applyOnto5' => 'Questa cartella e file',
    'file-manager.windows-permissions.applyOnto6' => 'Solo sottocartelle e file',
    'file-manager.windows-permissions.applyOnto7' => 'La cartella selezionata, le sottocartelle e i file',
    'file-manager.windows-permissions.notInherited' => '<non ereditato>',

    'file-manager.editor.titleTextEditor' => 'Editor di testo',
    'file-manager.editor.titleCodeEditor' => 'Editor di codice',
    'file-manager.editor.titleCodeViewer' => 'Mostra',
    'file-manager.editor.buttonSubmit' => 'Salva',
    'file-manager.editor.buttonApply' => 'Salva e riprendi',
    'file-manager.editor.buttonSaveAs' => 'Salva come...',
    'file-manager.editor.buttonCancel' => 'Annulla',
    'file-manager.editor.exitConfirmationYes' => 'Sì',
    'file-manager.editor.exitConfirmationNo' => 'Nessuno',
    'file-manager.editor.fileOverwrite' => 'Il file esiste già.',
    'file-manager.editor.fileOverwriteDescription' => 'Esiste già un file con lo stesso nome. Vuoi sovrascriverlo/a?',
    'file-manager.editor.exitConfirmation' => 'Sei sicuro di voler chiudere il file ed escludere le modifiche non salvate?',
    'file-manager.editor.buttonCodeEditor' => 'Modifica nell\'editor di codice',
    'file-manager.editor.buttonTextEditor' => 'Modifica nell\'editor di testo',
    'file-manager.editor.buttonHtmlEditor' => 'Modifica in Editor HTML',

    'file-manager.import-file.buttonSubmit' => 'Importa',
    'file-manager.import-file.fieldUrl' => 'URL per il file',
    'file-manager.import-file.fieldUrlDescription' => 'Specifica l\'URL sorgente. Per esempio, "https://esempio.com/esempio.tgz".',
    'file-manager.import-file.fieldUrlFullDescription' => 'Il modello dell\'URL completo è il seguente: "https://utente:password@esempio.com/esempio.tgz". Il nome utente e la password sono opzionali. I protocolli supportati sono http, https, ftp, ftps. Usa il meccanismo URL-encoding per le parti dell\'URL che contengono caratteri speciali o spazi.',
    'file-manager.import-file.failure' => 'Impossibile importare il file.',

    'file-manager.rotation-settings.title' => 'Impostazioni rotazione cestino',
    'file-manager.rotation-settings.rotationBySize' => 'Rotazione per dimensione',
    'file-manager.rotation-settings.rotationBySizeUnits' => 'MB',
    'file-manager.rotation-settings.rotationBySizeHint' => 'L\'opzione cancella i file nuovi fintantoché viene superato il limite specificato per il cestino.',
    'file-manager.rotation-settings.rotationByDate' => 'Rotazione per data',
    'file-manager.rotation-settings.rotationByDateUnits' => 'Giorni',
    'file-manager.rotation-settings.rotationByDateHint' => 'L\'opzione cancella i file che sono conservati nel cestino da più di un determinato numero di giorni.',
    'file-manager.rotation-settings.save' => 'Salva',
    'file-manager.rotation-settings.cancel' => 'Annulla',

    'ftp-user.description' => 'Se si utilizza il proprio sito web insieme a qualcun altro o su sottodomini host per altri utenti, potrebbe essere necessario creare account FTP separati per loro.',
    'ftp-user.generalSection' => 'Generale',
    'ftp-user.login' => 'Nome account FTP',
    'ftp-user.home' => 'Directory principale',
    'ftp-user.systemArea' => 'Crea un account FTP con accesso ai file fuori dalla directory principale',
    'ftp-user.password' => 'Password',
    'ftp-user.passwordConfirmation' => 'Conferma la password',
    'ftp-user.hardQuotaSection' => 'Quota rigida del disco',
    'ftp-user.hardQuota' => 'Quota rigida del disco',
    'ftp-user.hardQuotaUnlimited' => 'Illimitato',
    'ftp-user.permissionsSection' => 'Permessi',
    'ftp-user.permissionRead' => 'Permesso di lettura',
    'ftp-user.permissionWrite' => 'Permesso di scrittura',
    'ftp-user.popupTitle' => 'Scegli Directory',

    'mail-list.listName' => 'Indirizzo della lista di posta',
    'mail-list.enabled' => 'Attivato',
    'mail-list.administratorEmail' => 'E-mail dell\'amministratore della lista di posta',
    'mail-list.password' => 'Password',
    'mail-list.passwordConfirmation' => 'Conferma la password',
    'mail-list.subscribers' => 'Abbonati',
    'mail-list.subscribersHint' => 'Indicare gli indirizzi email. È possibile digitare ogni indirizzo su una riga oppure dividere gli indirizzi con simboli di spaziatura, virgole o punti e virgola.',
    'mail-list.notify' => 'Informare l\'amministratore della creazione della mailing list',
    'mail-list.emptyPassword' => 'Fornisci una password.',
    'mail-list.emptyPasswordConfirmation' => 'Confermare la password.',
    'mail-list.errorSubscribers' => 'Indirizzi e-mail non validi: %value%.',
    'mail-list.errorMaillistReserved' => 'L\'indirizzo della mailing list specificato è già in uso.',

    'mail-settings.hint' => 'In questa sezione si possono modificare le impostazioni del servizio di posta per questo dominio.',
    'mail-settings.service' => 'Servizio di posta su questo dominio',
    'mail-settings.nonExist' => 'Cosa fare con la posta per utenti inesistenti',
    'mail-settings.nonExistBounceWithMessage' => 'Rimbalzo con messaggio',
    'mail-settings.nonExistBounce' => 'Respingere',
    'mail-settings.nonExistCatch' => 'Inoltra a indirizzo',
    'mail-settings.nonExistCatchDescription' => 'L\'indirizzo deve appartenere al dominio selezionato. Soltanto l\'amministratore può indicare un indirizzo esterno o un indirizzo per diversi domini.',
    'mail-settings.nonExistExternal' => 'Reindirizza a server di posta esterno con l\'indirizzo IP',
    'mail-settings.nonExistReject' => 'Rifiuta',
    'mail-settings.nonExistDiscard' => 'Rifiuta',
    'mail-settings.webmail' => 'WebMail',
    'mail-settings.webmailNone' => 'Nessuno',
    'mail-settings.webmailComponentNotInstalled' => 'Il componente di webmail non è stato installato.',
    'mail-settings.webmailSubdomainAlreadyExists' => 'Esiste un dominio con il nome %%subdomain%%.',
    'mail-settings.webmailCertificate' => 'Certificato SSL/TLS per webmail',
    'mail-settings.webmailCertificateNone' => 'Non selezionato',
    'mail-settings.mailCertificate' => 'Certificato SSL/TLS per posta',
    'mail-settings.mailCertificateNone' => 'Non selezionati',
    'mail-settings.serverCertificateNotSelected' => 'Il certificato è stato assegnato, ma la posta per il dominio non era protetta.Per completare la protezione della posta per il dominio, %%certLink%%.',
    'mail-settings.serverCertificatesList' => 'proteggi il server di posta',
    'mail-settings.mailLists' => 'Abilita le liste di posta',
    'mail-settings.mailAutodiscovery' => 'Abilita rilevamento automatico della posta',
    'mail-settings.mailAutodiscoveryDescription' => 'Scopri come funziona, visita: %%link%%',
    'mail-settings.mailAutodiscoveryDescriptionLink' => 'base di conoscenza',
    'mail-settings.domainKeys' => 'Usa il sistema di protezione spam DKIM per firmare i messaggi di posta elettronica in uscita',
    'mail-settings.activeDkimSelector' => 'Selettore DKIM attivo',
    'mail-settings.defaultDkimSelector' => ' (predefinito di Plesk)',
    'mail-settings.dkimSelectorName' => 'Nome selettore',
    'mail-settings.buttonCreateSelector' => 'Crea nuovo selettore DKIM',
    'mail-settings.createSelectorDialogTitle' => 'Crea selettore DKIM',
    'mail-settings.removeSelectorDialogTitle' => 'Rimuovi selettore DKIM',
    'mail-settings.removeSelectorConfirmation' => "Vuoi rimuovere il selettore \"%%selector%%\" insieme alle chiavi e ai record DNS a esso associati?",
    'mail-settings.buttonConfirm' => 'OK',
    'mail-settings.buttonCreate' => 'Crea',
    'mail-settings.buttonCancel' => 'Annulla',
    'mail-settings.labelRemoveSelector' => 'Rimuovi',
    'mail-settings.labelActiveSelector' => 'Attivo',
    'mail-settings.greyListing' => 'Attivare la protezione spam di greylisting per tutti gli account di posta sotto questo dominio',
    'mail-settings.howToConfigureExternalDns' => 'Configurare un DNS esterno',
    'mail-settings.howToConfigureExternalDnsAlways' => 'Se usi un server DNS esterno e desideri abilitare l\'autenticazione tramite DKIM, configura i record DNS DKIM sul server DNS.',
    'mail-settings.howToConfigureExternalDnsEnabled' => 'Per farlo, usa i seguenti record DNS DKIM:',
    'mail-settings.howToConfigureExternalDnsEnabledAliases' => 'Aggiungi record DNS DKIM anche per i tuoi alias di dominio, se ne possiedi. Utilizza gli stessi record del dominio principale ma con il nome dell\'alias di dominio.',
    'mail-settings.howToConfigureExternalDnsDisabled' => 'Per visualizzare i record DNS DKIM da configurare, seleziona la casella di spunta %%option%%, applica la scelta e apri nuovamente questo pop-up.',
    'mail-settings.mailServiceDisabled' => 'Disabilitato',
    'mail-settings.mailServiceDisabledIncoming' => 'Disattivato per la posta in arrivo',
    'mail-settings.mailServiceDisabledHint' => 'Plesk non fornisce servizi di posta per questo dominio.',
    'mail-settings.mailServiceDisabledIncomingHint' => 'Questo dominio può solo inviare posta tramite Sendmail.',
    'mail-settings.mailServiceEnabled' => 'Abilitato',
    'mail-settings.mailServiceEnabledHint' => 'Questo dominio può sia inviare che ricevere posta.',
    'mail-settings.mailServiceNotConfigured' => 'Non configurato',
    'mail-settings.mailServiceNotConfiguredHint' => 'Plesk non fornisce servizi di posta per questo dominio.',
    'mail-settings.warning' => 'Questa azione rimuoverà in maniera permanente le caselle di posta e i relativi messaggi ricevuti.',
    'mail-settings.show.title' => 'Rimuovi tutte le caselle di posta ed e-mail di %%domain%%',
    'mail-settings.show.checkbox' => 'Rimuovi in maniera permanente tutte le caselle di posta di <b>%%domain%%</b>, incluse le e-mail inviate e ricevute.',

    'role.roleSection' => 'Generale',
    'role.name' => 'Nome del ruolo utente',
    'role.description' => 'Descrizione',
    'role.generalPermissionsSection' => 'Accesso ai servizi Plesk',
    'role.applicationsAccessSection' => 'Accesso alle applicazioni',
    'role.permissionAllow' => 'Concesso',
    'role.permissionDeny' => 'Negato',
    'role.emptyRoleName' => 'Fornire un nome di ruolo.',
    'role.installedAt' => 'Installato su',
    'role.noInstallationUrlAvailable' => 'Applicazione esterna',
    'role.invalidRoleName' => 'Il nome del ruolo utente specificato non è valido. Punti di domanda e virgolette non possono essere utilizzati nel nome del ruolo.',
    'role.longRoleName' => 'Il nome del ruolo utente specificato è troppo lungo',
    'role.somePermissionsAreNotAllowedForSomeSubscriptions' => 'Alcune operazioni potrebbero non essere disponibili per i seguenti motivi: non è concesso un permesso per l\'operazione per l\'abbonamento attualmente selezionato oppure la quantità delle risorse assegnate non è sufficiente per eseguire un\'operazione.',
    'role.servicesPermissionsDescription' => 'Definisci l\'accesso alle applicazioni installate o ai servizi di Plesk per tutti gli utenti con questo ruolo.Se concedi l\'accesso utente ad un\'applicazione, essa diventerà disponibile a tutti gli utenti nel Pannello del Cliente.',
    'role.emailActivation' => 'Attiva gli account di questo ruolo via e-mail',

    'service.admin-access.adminAccess' => 'Accesso amministrativo',
    'service.admin-access.customCredentialsDescriptionNoEntryPoints' => 'Queste credenziali saranno usate per l\'accesso amministrativo all\'applicazione.',
    'service.admin-access.login' => 'Nome utente amministrativo',
    'service.admin-access.password' => 'Password amministrativa',
    'service.admin-access.passwordConfirmation' => 'Confermare la password',

    'service.info.service-entry-point.availableAt' => 'Disponibile su',
    'service.info.service-entry-point.customize' => 'Personalizzare collegamento',
    'service.info.service-entry-point.displayNameLabel' => 'Nome del collegamento',
    'service.info.service-entry-point.displayNameDescription' => 'Fornire un nome per questo collegamento. Il nome viene mostrato sottto l\'icona del collegamento. I collegamenti sono posizionati sulle pagine Miei Servizi degli utenti a cui è stato concesso l\'accesso a quest\'applicazione.',
    'service.info.service-entry-point.descriptionLabel' => 'Descrizione del collegamento',
    'service.info.service-entry-point.descriptionDescription' => 'Fornire una descrizione per questo collegamento. La descrizione verrà mostrata come suggerimento al passaggio del mouse sul collegamento.',
    'service.info.service-entry-point.iconLabel' => 'Cliccare per selezionare l\'icona del collegamento',
    'service.info.service-entry-point.iconCurrent' => 'Icona attuale',
    'service.info.service-entry-point.errorEmptyName' => 'È necessario fornire un nome di collegamento',
    'service.info.service-entry-point.errorLongName' => 'Il nome del collegamento deve avere una lunghezza compresa tra 1 e 255 caratteri.',
    'service.info.service-entry-point.errorLongDescription' => 'La descrizione del collegamento deve avere una lunghezza tra 0 e 255 caratteri.',
    'service.info.service-entry-point.hiddenLabel' => 'Nascondi collegamento',
    'service.info.service-entry-point.hiddenDescription' => 'Non mostrare questo collegamento agli utenti.',

    'service.info.service-permission.assignedUser' => "Concedere l'accesso amministratore a questo utente",
    'service.info.service-permission.assignedUserNone' => 'Nessun utente assegnato',

    'shared-ssl.master-ssl.switchedOn' => 'Attiva SSL/TLS condiviso',
    'shared-ssl.master-ssl.domainName' => 'Il nome di dominio di un sito, il cui certificato SSL/TLS verrà condiviso con altri siti',
    'shared-ssl.master-ssl.none' => 'Nessuno',
    'shared-ssl.master-ssl.noDomainsWithSslWarning' => 'Il SSL/TLS condiviso non può essere attivato perché non vi sono domini con supporto SSL/TLS abilitato.',

    'user.email.email' => 'Indirizzo e-mail',
    'user.email.emptyEmail' => 'È necessario fornire un indirizzo e-mail.',
    'user.email.internalEmailHint' => 'Crea un nuovo indirizzo e-mail in Plesk o utilizza un indirizzo e-mail esterno.',
    'user.email.longInternalEmail' => 'L\'indirizzo email è troppo lungo.',
    'user.email.longInternalEmailMailboxAddressMailServer' => 'La parte del nome utente dell\'indirizzo email è troppo lunga per questo server di posta. Indica un nome utente non più lungo di %%max%% simboli.',
    'user.email.longInternalEmailFullAddressMailServer' => 'L\'indirizzo email è troppo lungo per questo server di posta. Indica un indirizzo non più lungo di %%max%% simboli.',
    'user.email.externalEmail' => 'Indirizzo esterno non valido',
    'user.email.externalEmailHint' => 'Consentirà di reimpostare la password in caso di perdita dell’accesso all’indirizzo e-mail primario.',
    'user.email.emailsIsEqual' => 'L’indirizzo e-mail esterno corrisponde a quello primario. Specifica un indirizzo e-mail esterno diverso.',
    'user.email.atLeastOneEmailShouldBeSet' => 'Inserisci un indirizzo e-mail interno o esterno.',

    'user.profileSection' => 'Informazioni generali',
    'user.contactName' => 'Nome del contatto',
    'user.email' => 'Indirizzo e-mail',
    'user.role' => 'Ruolo utente',
    'user.accountSection' => 'Preferenze Plesk',
    'user.login' => 'Nome utente',
    'user.password' => 'Password',
    'user.oldPassword' => 'Vecchia password',
    'user.buttonBack' => 'Indietro',
    'user.generalTab' => 'Generale',
    'user.applicationsAccessSection' => 'Servizi',
    'user.generalPermissionsSection' => 'Privilegi',
    'user.contactsTab' => 'Dettagli del Contatto',
    'user.passwordConfirmation' => 'Confermare la password',
    'user.internalEmailPasswordChanged' => 'Modificando la password verrà modificata anche la password dell\'indirizzo e-mail interno.',
    'user.emailName' => 'Indirizzo e-mail',
    'user.emailType' => 'Tipo di e-mail',
    'user.companyName' => 'Nome della società',
    'user.phone' => 'Telefono',
    'user.imNumber' => 'Messaggistica immediata',
    'user.fax' => 'Numero di fax',
    'user.address' => 'Indirizzo',
    'user.city' => 'Città',
    'user.state' => 'Stato o provincia',
    'user.zip' => 'Codice di Avviamento Postale',
    'user.country' => 'Paese',
    'user.additionalInfo' => 'Informazioni aggiuntive',
    'user.additionalInfoHint' => 'Solo testo semplice: Tutti i tag HTML saranno ignorati.',
    'user.language' => 'Lingua di Plesk',
    'user.buttonChangePassword' => 'Cambiare Password',
    'user.permissionAllow' => 'Concesso',
    'user.permissionDeny' => 'Negato',
    'user.permissionInherited' => 'Definito da ruolo',
    'user.emptyContactName' => 'È necessario fornire un nome di contatto.',
    'user.emptyLogin' => 'È necessario fornire un nome utente.',
    'user.emptyPassword' => 'È necessario fornire una password.',
    'user.emptyPasswordConfirmation' => 'È necessario confermare la password.',
    'user.oldPasswordIsIncorrect' => 'La vecchia password non è corretta. Riprovare.',
    'user.chooseDomainBoxTitle' => 'Selezionare un altro dominio:',
    'user.userIsActive' => 'Utente attivo',
    'user.userIsActiveHint' => 'Gli utenti attivi possono accedere a Plesk.',
    'user.emailActivation' => 'Attiva account via e-mail',
    'user.emailHint' => 'Per offrire all\'utente un indirizzo e-mail ospitato su questo server, vai alla scheda Posta, crea l\'indirizzo e-mail specificato e associalo a questo utente.',
    'user.emailContactHint' => 'Contatta il tuo service provider se desideri usare un indirizzo e-mail ospitato in questo server.',
    'user.personalEmailHint' => "È possibile modificare l'indirizzo e-mail di questo utente presso la scheda Posta.",
    'user.externalMailRedirectHint' => 'È possibile attivare l\'inoltro solo per gli indirizzi e-mail ospitati in questo server. Per creare un indirizzo e-mail, accedere alla scheda Posta.',
    'user.externalMailRedirectHint2' => 'È possibile attivare l\'inoltro solo per gli indirizzi e-mail ospitati in questo server.',
    'user.externalMailAutoResponderHint' => 'È possibile attivare la risposta automatica solo per gli indirizzi e-mail ospitati in questo server. Per creare un indirizzo e-mail, accedere alla scheda Posta.',
    'user.externalMailAutoResponderHint2' => 'È possibile attivare la risposta automatica solo per gli indirizzi e-mail ospitati in questo server.',
    'user.roleHint' => 'I ruoli utente garantiscono agli utenti i privilegi amministrativi e l\'accesso alle applicazioni selezionate per il ruolo.',
    'user.cannotManageMail' => "Non si dispone del permesso di gestire le impostazioni di posta e i servizi.",
    'user.longCompanyName' => 'Il nome dell\'azienda specificato è troppo lungo.',
    'user.longPhone' => 'Il numero di telefono specificato è troppo lungo.',
    'user.longFax' => 'Il numero di fax specificato è troppo lungo.',
    'user.longAddress' => 'L\'indirizzo specificato è troppo lungo.',
    'user.longCity' => 'Il nome della città specificato è troppo lungo.',
    'user.phoneRegexNotMatch' => 'Il numero di telefono specificato non è valido.',
    'user.faxRegexNotMatch' => 'Il numero di fax specificato non è valido.',
    'user.shortCity' => 'Il nome della città specificato è troppo breve.',
    'user.limitSubscription' => 'Accesso agli abbonamenti',
    'user.limitSubscriptionHint' => 'Consenti agli utenti di accedere soltanto a un determinato abbonamento.Il valore "Tutti" consente agli utenti di accedere a tutti gli abbonamenti del tuo account di hosting.',
    'user.limitSubscriptionAll' => 'Tutti',
    'user.deletedSubscription' => 'Abbonamento rimosso',

    'web.add-domain-alias.title' => 'Aggiungi un alias di dominio',
    'web.add-domain-alias.createdSuccessfully' => "L'alias di dominio %%name%% è stato creato\n.",
    'web.add-domain-alias.domainAliasName' => 'Nome dell\'alias di dominio',
    'web.add-domain-alias.domainAliasNameHint' => 'Per esempio, example.net',
    'web.add-domain-alias.forDomain' => 'per il dominio',
    'web.add-domain-alias.settingsSectionLegend' => 'Impostazioni',
    'web.add-domain-alias.settingsDns' => 'Sincronizza la zona DNS con il dominio primario',
    'web.add-domain-alias.settingsMail' => 'Servizio di posta',
    'web.add-domain-alias.settingsWeb' => 'Servizio Web',
    'web.add-domain-alias.settingsSeoRedirect' => 'Reindirizzamento con il codice HTTP 301',
    'web.add-domain-alias.settingsSeoRedirectHint' => 'Quando i visitatori apriranno l\'URL dell\'alias, saranno reindirizzati verso l\'URL del dominio principale. Plesk usa il motore di ricerca compatibile con il reindirizzamento HTTP 301, il che significa che il ranking del motore di ricerca non sarà diviso tra gli URL.',
    'web.add-domain-alias.settingsTomcat' => 'Applicazioni web Java',
    'web.add-domain-alias.invalidDomainGuid' => 'Dominio non valido',

    'web.add-domain.formTitle' => 'Aggiunta del nuovo dominio',
    'web.add-domain.portalLink' => 'Portale dei servizi',
    'web.add-domain.domainName' => 'Nome del dominio',
    'web.add-domain.domainNameHint' => "Per esempio, example.com",
    'web.add-domain.assignToCustomer' => 'Assegna questo dominio a un cliente',
    'web.add-domain.customer' => 'Seleziona un cliente',
    'web.add-domain.createNewCustomer' => 'Crea un nuovo cliente',
    'web.add-domain.selectExistingCustomer' => 'Seleziona un cliente esistente:',
    'web.add-domain.customerContactInfoHint' => 'Inserisce l\'informazione di contatto del cliente. Altri dati, quale numero di telefono e indirizzo, si possono specificare più tardi.',
    'web.add-domain.customerLoginInfoHint' => 'Credenziali del pannello del cliente',
    'web.add-domain.target' => 'Spazio web',
    'web.add-domain.createNewTarget' => 'Crea un nuovo abbonamento',
    'web.add-domain.createNewTarget_powerUser' => 'Crea un nuovo spazio web',
    'web.add-domain.selectExistingTarget' => 'Seleziona un abbonamento esistente:',
    'web.add-domain.selectExistingTarget_powerUser' => 'Seleziona uno spazio web esistente:',
    'web.add-domain.dns' => 'Attiva il servizio DNS',
    'web.add-domain.dnsHint' => '',
    'web.add-domain.mail' => 'Attiva il servizio della posta',
    'web.add-domain.mailHint' => '',
    'web.add-domain.mailHintNoPermission' => 'Funziona se le impostazioni dell\'abbonamento consentono di gestire il permesso di posta per dominio. Se non lo consentono, lo stato effettivo del servizio di posta sarà prelevato dall\'abbonamento.',
    'web.add-domain.hostingManagementOptions' => 'Tipologia di hosting',
    'web.add-domain.websiteHosting' => 'Hosting di siti web',
    'web.add-domain.websiteForwarding' => 'Inoltro',
    'web.add-domain.websiteNoHosting' => 'Nessun hosting',
    'web.add-domain.hostingSettingsSectionLegend' => 'Impostazioni di hosting',
    'web.add-domain.domainCreatedSuccessfully' => 'Il dominio %%domainName%% è stato correttamente creato.',
    'web.add-domain.webspaceLegend' => 'Impostazioni webspace',
    'web.add-domain.addWhmWebsiteTitle' => 'Aggiunta di nuovo sito web',
    'web.add-domain.addWhmWebsiteHint' => "Se scegli di ospitare un sito web sul server.",
    'web.add-domain.selectWhmDomain' => 'Selezionare dominio',
    'web.add-domain.customerLegend' => 'Info del cliente',
    'web.add-domain.credentials' => 'Credenziali dell\'utente di sistema',
    'web.add-domain.credentialsHint' => 'per accedere ai file ospitati tramite FTP e SSH',
    'web.add-domain.credentialsHintWin' => 'per accedere ai file ospitati tramite FTP e RDP',
    'web.add-domain.buttonAddDomain' => 'Aggiungi Dominio',

    'web.add-subdomain.formTitle' => 'Aggiungi un sottodominio',
    'web.add-subdomain.formGeneralHint' => 'I sottodomini sono indirizzi Internet per le differenti sezioni del tuo sito web. Usano il tuo nome di dominio principale ed un prefisso. Ad esempio, se il tuo dominio è domain.com, un sottodominio potrebbe essere store.domain.com.',
    'web.add-subdomain.formGeneralHintAdditional' => 'È possibile anche creare un sottodominio wildcard inserendo il simbolo * invece del nome. I visitatori del sito verranno reindirizzati a questo sottodominio, indipendentemente dal nome di sottodominio che inseriranno sul browser.',
    'web.add-subdomain.subdomainName' => 'Nome del sottodominio',
    'web.add-subdomain.subdomainNameHint' => 'Inserisci * per creare un sottodominio wildcard.',
    'web.add-subdomain.forDomain' => 'Dominio principale',
    'web.add-subdomain.subdomainCreatedSuccessfully' => 'Il sottodominio è stato creato.',
    'web.add-subdomain.hostingSettingsSectionLegend' => 'Impostazioni di hosting',

    'web.change-hosting.formGeneralHint' => 'È possibile scegliere di ospitare il sito web sul server (Hosting di siti web), configurare l\'inoltro web verso un altro sito web (Inoltro) o usare la zona DNS del dominio per avere le caselle postali sotto questo nome di dominio (Nessun hosting).',
    'web.change-hosting.changed' => 'Il tipo di hosting per %%domainName%% è stato correttamente modificato.',
    'web.change-hosting.hostingManagementOptions' => 'Tipologia di hosting',
    'web.change-hosting.websiteHosting' => 'Hosting di siti web',
    'web.change-hosting.websiteForwarding' => 'Inoltro',
    'web.change-hosting.websiteNoHosting' => 'Nessun hosting web',
    'web.change-hosting.hostingSettingsSectionLegend' => 'Impostazioni di hosting',
    'web.change-hosting.userName' => 'Nome utente',
    'web.change-hosting.userNameHint' => 'Utente di sistema per gestire file e cartelle all\'interno dell\'abbonamento.',
    'web.change-hosting.userNameHint_powerUser' => 'Utente di sistema per gestire file e cartelle all\'interno dello spazio web.',
    'web.change-hosting.emptyLogin' => 'È necessario specificare un nome utente.',
    'web.change-hosting.password' => 'Password',
    'web.change-hosting.emptyPassword' => 'È necessario specificare una password.',
    'web.change-hosting.passwordConfirmation' => 'Conferma la password',
    'web.change-hosting.warningInstalledApplications' => 'Sono presenti applicazioni web installate nel sito. Se si modifica il tipo di hosting, non saranno più accessibili.',
    'web.change-hosting.removeWebsiteHostingTitle' => 'Avvertenza: il contenuto del sito web sarà eliminato.',
    'web.change-hosting.removeWebsiteHostingDescription' => 'Vuoi cambiare il tipo di hosting del tuo sito web?',
    'web.change-hosting.removeWebsiteHostingDescriptionFolders' => 'Le seguenti cartelle e i relativi contenuti saranno eliminati:',
    'web.change-hosting.removeWebsiteHostingDescriptionAllFolders' => 'Tutti i contenuti della cartella principale dello spazio web saranno eliminati.',

    'web.change-status.changed' => 'Lo stato del sito web per %%domainName%% è stato correttamente modificato.',
    'web.change-status.statusManagementOptions' => 'Stato del sito web',
    'web.change-status.statusDisabled' => 'Disabilitato (in passato, Sospeso)',
    'web.change-status.statusSuspended' => 'Sospeso',
    'web.change-status.statusActive' => 'Attivo',
    'web.change-status.statusDisabledHint' => 'Il sito web non sarà più ospitato sul server e non sarà disponibile tranne dai client FTP e File Manager. I visitatori visualizzeranno la pagina predefinita del server web. Il servizio di posta non sarà disponibile.',
    'web.change-status.statusSuspendedHint' => 'Il sito web resterà ospitato sul server, ma i visitatori saranno reindirizzati con il codice HTTP 503 verso la pagina del documento di errore personalizzato. Il servizio di posta resterà disponibile. Qui è possibile %%link%%.',
    'web.change-status.statusSuspendedHintNoLink' => 'I visitatori saranno reindirizzati con il codice HTTP 503 adatto dei motori di ricerca verso la pagina del documento di errore, anche se il sito web resterà ospitato sul server. Il servizio di posta resterà disponibile.',
    'web.change-status.error503PageLink' => 'modificare documento di errore personalizzato',
    'web.change-status.statusActiveHint' => 'Il sito Web funzionerà come al solito.',
    'web.change-status.notActivatedSuspended' => 'Il dominio o sito web %%domainName%% non può essere attivato perché è stato sospeso dal vostro provider di hosting.',
    'web.change-status.notActivatedDisabled' => 'Il dominio o sito web %%domainName%% non può essere attivato perché è stato disabilitato dal vostro provider di hosting.',

    'web.edit.formTitle' => 'Accesso Hosting Web per %%name%%',
    'web.edit.formGeneralHint' => 'In questa sezione puoi visualizzare gli indirizzi IP associati al tuo abbonamento e cambiare il nome utente e la password del tuo utente di sistema.',
    'web.edit.formGeneralHint_powerUser' => 'In questa sezione è possibile visualizzare gli indirizzi IP associati al tuo spazio web e cambiare il nome utente e la password del tuo utente di sistema.',
    'web.edit.ipAddressesLegend' => 'Indirizzi IP',
    'web.edit.ipAddresses' => 'Indirizzo IP',
    'web.edit.certificateLegend' => 'Certificato',
    'web.edit.certificateFromDomainRepository' => '%%name%% (%%repositoryName%%)',
    'web.edit.certificateFromOtherRepository' => '%%name%% (di proprietà di un altro utente)',
    'web.edit.userAccountLegend' => 'Utente di sistema',
    'web.edit.systemUserHint' => 'In questa sezione è possibile specificare un utente del sistema operativo per gestire file e cartelle all\'interno dell\'abbonamento da FTP o con File Manager. L\'utente di sistema è anche usato per accedere a Plesk su SSH (su Linux) o RDP (su Windows) se sono concessi i corrispondenti permessi.',
    'web.edit.systemUserHint_powerUser' => 'In questa sezione è possibile specificare un utente del sistema operativo per gestire file e cartelle all\'interno dello spazio web da FTP o con File Manager. L\'utente di sistema è anche usato per accedere a Plesk su SSH (su Linux) o RDP (su Windows) se sono concessi i corrispondenti permessi.',
    'web.edit.login' => 'Nome utente',
    'web.edit.emptyLogin' => 'Specificare un nome utente.',
    'web.edit.password' => 'Password',
    'web.edit.passwordConfirmation' => 'Conferma la password',
    'web.edit.emptyPassword' => 'Specificare una password.',
    'web.edit.emptyPasswordConfirmation' => 'Confermare la password.',
    'web.edit.shellUnix' => "Accesso al server tramite SSH",
    'web.edit.shellHintUnix' => "Accedere al server tramite SSH con le credenziali dell'utente di sistema.",
    'web.edit.shellWin' => 'Accesso al server tramite desktop remoto',
    'web.edit.shellHintWin' => "Accedere al server tramite desktop remoto con le credenziali dell'utente di sistema.",
    'web.edit.diskQuotaLegend' => 'Quota rigida dello spazio su disco',
    'web.edit.diskQuotaHint' => 'La quota fisica di spazio su disco è il limite della quantità di spazio su disco che può essere utilizzato. Se la quota fisica è impostata e viene utilizzato tutto lo spazio su disco assegnato, non è possibile eseguire ulteriori operazioni sui file.',
    'web.edit.diskQuota' => 'Quota fisica di spazio su disco',
    'web.edit.diskQuotaUnlimited' => 'Illimitato',
    'web.edit.diskQuotaLimited' => 'MB %%limit%%',
    'web.edit.diskQuotaNotSupported' => 'Illimitato. La quota fisica non è supportata a causa della configurazione del file system del server.',
    'web.edit.limitMbUnits' => 'MB',
    'web.edit.successfullyUpdated' => 'Le impostazioni di hosting sono state aggiornate.',
    'web.edit.affectedDomainsLegend' => 'Siti web a cui vengono applicate queste modifiche',
    'web.edit.affectedDomainsHint' => 'I seguenti spazi web sono associate con il corrente utente di sistema. Le modifiche nelle impostazioni di accesso all\'hosting web effettuate su questa pagina verranno applicate a tutti questi siti web.',

    'web.mobile.create.formTitle' => 'Crea sito mobile',
    'web.mobile.create.formGeneralHint' => 'Specificare il nome del sito mobile - un URL tramite il quale il sito mobile è accessibile. Di solito vengono utilizzati i prefissi quali "m", "mob", "mobi", "mobile" e così via, ad esempio: mobile.example.com. È possibile utilizzare questo URL in un collegamento come "versione mobile" nel sito regolare, in modo che i visitatori del sito possono passare tra le versioni mobile e regolare.',
    'web.mobile.create.prefix' => 'Nome sito',
    'web.mobile.create.emptySiteName' => 'Il nome del sito mobile non può essere vuoto, sarebbe in conflitto con il sito web regolare.',

    'web.security-section.securitySectionLegend' => 'Sicurezza',
    'web.security-section.securitySectionHint' => 'Per proteggere le transazioni con il sito, si consiglia l\'utilizzo del protocollo SSL/TLS, il quale esegue la crittografia di tutti i dati e li trasferisce su una connessione sicura. Per utilizzare SSL/TLS, sposta questo sito verso un indirizzo IP dedicato, installa un certificato SSL/TLS sul sito e quindi selezionalo in basso.',
    'web.security-section.securitySectionSniHint' => 'Per proteggere le transazioni con il sito, si consiglia l\'utilizzo del protocollo SSL/TLS, il quale esegue la crittografia di tutti i dati e li trasferisce su una connessione sicura. Per utilizzare SSL/TLS, installa un certificato SSL/TLS sul sito e quindi selezionalo in basso.',
    'web.security-section.enableSslSupport' => 'Supporto SSL/TLS',
    'web.security-section.enableSslRedirect' => 'Reindirizzamento SEO-safe 301 permanente da HTTP a HTTPS',

    'web.seo-settings.seoRedirectDirection' => 'Dominio preferito',
    'web.seo-settings.seoRedirectDirectionHint' => 'Seleziona l\'URL (sia con o senza il prefisso www.) per cui i visitatori del sito verranno reindirizzati tramite un reindirizzamento HTTP 301 compatibile con le regole SEO.',
    'web.seo-settings.seoRedirectDirectionNone' => 'Nessuno',

    'web.settings.formGeneralHint' => 'In questa sezione puoi configurare le impostazioni di hosting del sito web e selezionare le caratteristiche disponibili per il tuo sito.',
    'web.settings.hostingType' => 'Tipologia di hosting',
    'web.settings.websiteHosting' => 'Sito Web',
    'web.settings.forwardingHosting' => 'Inoltro',
    'web.settings.noHosting' => 'Nessun hosting',
    'web.settings.changeHosting' => 'Cambia',
    'web.settings.websiteStatus' => 'Stato del sito web',
    'web.settings.changeStatus' => 'Cambia',
    'web.settings.active' => 'Attivo',
    'web.settings.suspended' => 'Sospeso',
    'web.settings.disabled' => 'Disabilitato',
    'web.settings.webScriptingSectionLegend' => 'Statistiche e Scripting Web',
    'web.settings.webScriptingSectionHint' => 'Specifica quale dei seguenti linguaggi di programmazione e di scripting devono essere interpretati, eseguiti o altrimenti elaborati dal server web.',
    'web.settings.__asp_win_support' => 'Supporto di Microsoft ASP',
    'web.settings.__asp_dot_net_support' => 'Supporto di Microsoft ASP.NET',
    'web.settings.__asp_dot_net_version' => 'Versione',
    'web.settings.__asp_dot_net_version_readonly' => 'versione %%value%%',
    'web.settings.__ssi_support' => 'Supporto di SSI',
    'web.settings.__ssi_with_html' => 'usa SSI per i file *.htm, *.html',
    'web.settings.__php_support' => 'Supporto PHP',
    'web.settings.__php_run_as' => 'eseguire PHP come',
    'web.settings.__php_served_by_apache' => 'servito da Apache',
    'web.settings.__php_served_by_nginx' => 'servito da nginx',
    'web.settings.__cgi_support' => 'Supporto di CGI',
    'web.settings.__cgi_bin_mode' => 'la directory cgi-bin si trova in',
    'web.settings.__cgi_bin_mode_webspace' => 'la directory principale dello spazio web',
    'web.settings.__cgi_bin_mode_www_root' => 'la directory principale di questo dominio',
    'web.settings.__cgi_bin_mode_old_style' => 'la radice precedente di questo dominio',
    'web.settings.__cgi_bin_mode_readonly' => 'la directory cig-bin si trova in %%value%%',
    'web.settings.__perl_unix_support' => 'Supporto di Perl',
    'web.settings.__perl_win_support' => 'Supporto di Perl',
    'web.settings.__python_unix_support' => 'Supporto di Python',
    'web.settings.__python_win_support' => 'Supporto di Python',
    'web.settings.__fastcgi_unix_support' => 'Supporto FastCGI',
    'web.settings.__webstat_support' => 'Statistiche web',
    'web.settings.__plesk_stat_protect' => 'Proteggi l\'accesso alle statistiche web con il proprio nome utente e password FTP',
    'web.settings.__plesk_stat_protected' => 'L’accesso alle tue statistiche Web è protetto con il tuo nome utente e la password FTP.',
    'web.settings.__apache_errdocs' => 'Documenti di errore personalizzati',
    'web.settings.__php_module_handler' => 'mod_php',
    'web.settings.__php_fastcgi_handler' => 'Applicazione FastCGI',
    'web.settings.__php_cgi_handler' => 'Applicazione CGI',
    'web.settings.__php_isapi_handler' => 'Estensione ISAPI',
    'web.settings.__php_version' => 'Versione PHP',
    'web.settings.__hosting_write_modify' => 'Permessi aggiuntivi di scrittura/modifica',
    'web.settings.__hosting_webdeploy' => 'Pubblicazione implementazione web',
    'web.settings.awstats' => 'AWstats',
    'web.settings.webalizer' => 'Webalizer',
    'web.settings.smarterstats' => 'SmarterStats',
    'web.settings.__none' => 'Nessuno',
    'web.settings.activate' => 'Attiva',
    'web.settings.deactivate' => 'Sospendi',
    'web.settings.__php_support_readonly' => 'versione: %%version%%; gestore: %%handler%%',
    'web.settings.__php_support_readonly_not_registered' => 'non registrato',
    'web.settings.domainName' => 'Nome dominio',
    'web.settings.domainNameHint' => "Per esempio, example.com",
    'web.settings.sameSslCompatibilitySectionLegend' => 'Modalità di compatibilità per l\'opzione precedente "Dividi contenuti SSL/TLS e non SSL/TLS"',
    'web.settings.sameSslCompatibilityModeCheckbox' => 'Eseguire il sito web in modalità di compatibilità per l\'opzione precedente "Dividi contenuti SSL/TLS e non SSL/TLS"',
    'web.settings.sameSslCompatibilityHint' => 'Questo sito web è in modalità di compatibilità e non può essere gestito usando l\'interfaccia di Plesk. Ciò è dovuto al fatto che hai usato l\'opzione obsoleta "Dividi contenuti SSL/TLS e non SSL/TLS" prima dell\'aggiornamento. A partire da Plesk 11, ogni sito web conserva nella medesima cartella i contenuti disponibili sia tramite HTTP sia tramite HTTPS. Ti consigliamo di spostare tutti i dati dalla cartella \'httpsdocs/\' alla cartella \'httpdocs/\' e dunque disattivare la modalità di compatibilità. Questo permetterà anche di accedere via Internet alle app installate nella cartella \'httpsdocs/\'. Nota bene: la modalità di compatibilità non potrà più essere riattivata.',
    'web.settings.willBeAppliedAfterApacheRestartInterval' => 'Le impostazioni del sito web saranno applicate entro %%restartInterval%% minuti.',
    'web.settings.phpSettingsDescription' => 'Questa pagina mostra la configurazione PHP per il sito web. Queste impostazioni sono specifiche per il sito web e non incidono su altri siti web sull\'abbonamento. È possibile cambiare la configurazione PHP se il provider di hosting concede il relativo permesso.La configurazione PHP può essere usata, per esempio, per limitare l\'utilizzo delle risorse di sistema da script PHP o soddisfare i requisiti di una determinata app web. Quando un parametro viene impostato al parametro predefinito, PHP utilizza il valore del parametro dalla configurazione PHP del server.',
    'web.settings.phpSettingsAvailableVariables' => 'È possibile utilizzare i seguenti segnaposti nei valori del parametro:',
    'web.settings.phpSettingsVariableDocroot' => '{DOCROOT} per la directory radice dei documenti del sito web. Il valore corrente è %%DOCROOT%%. %%HTTPS_DOCROOT%%',
    'web.settings.phpSettingsVariableDocrootHttpsSame' => 'La directory root del documento HTTPS è lo stesso che per http.',
    'web.settings.phpSettingsVariableDocrootHttpsDifferent' => 'La directory root del documento HTTPS è %%DOCROOT%%.',
    'web.settings.phpSettingsVariableWebspaceRoot' => '{WEBSPACEROOT} per la directory radice dei documenti del sito web principale dell\'abbonamento.',
    'web.settings.phpSettingsVariableTmp' => '{TMP} per la directory che memorizza i file temporanei.',
    'web.settings.phpSettingsPhpVersion' => 'La tua versione PHP è %%version%%.',
    'web.settings.phpSettingsPhpDisabled' => 'PHP è disattivato.',
    'web.settings.phpHandlerTypeHint' => 'Tieni presente che cambiare il tipo di gestore PHP potrebbe interrompere il corretto funzionamento degli script PHP esistenti su questo sito web.',
    'web.settings.fpmDedicatedHandlerHint' => 'L\'uso di questo gestore aumenta la stabilità di un sito, ma causa anche un ulteriore consumo di memoria.',
    'web.settings.phpHandlerChangeHint' => 'Hai modificato le impostazioni del gestore PHP. Salvando queste modifiche, gli script PHP sul tuo sito web potrebbero interrompersi per %%interval%% secondi a causa della configurazione del server.',
    'web.settings.phpHandlerTypeHelpLink' => 'Scopri come scegliere le impostazioni PHP più adatte',
    'web.settings.phpHandlerTypeNotAvailableHint' => 'Non è possibile abilitare il supporto di PHP poiché l’attuale configurazione di hosting non include versioni PHP per questo dominio.',
    'web.settings.phpHandlerTypeNotAvailableHelpLink' => 'Scopri come abilitare altre versioni PHP.',
    'web.settings.phpHandlerBroken' => 'Il gestore PHP al momento selezionato è danneggiato. Seleziona un gestore diverso.',
    'web.settings.phpHandlerOutdated' => '(Obsoleto)',
    'web.settings.phpHandlerDeprecated' => '(Deprecato)',

    'web.setupService.formTitle' => 'Configura servizio: %%serviceReference%%',
    'web.setupService.successfullyUpdated' => 'Il servizio \'%%serviceReference%%\' è stato correttamente aggiornato.',

    'web.site-copy.subdomainsGroup' => 'Sottodomini di %%siteName%%:',
    'web.site-copy.destinationTypeSection' => 'Copia destinazione',
    'web.site-copy.destinationType' => 'Seleziona dove devono essere copiati i file del sito',
    'web.site-copy.destinationTypeSite' => 'Sito web in Plesk',
    'web.site-copy.destinationTypeSiteDescription' => 'Copia i file del sito in un tuo sito ospitato sotto questo account. Se hai accesso FTP ad un altro account su questo server, usa l\'opzione Storage FTP.',
    'web.site-copy.destinationTypeSiteDescription_powerUser' => 'Copia i file del sito in un altro sito ospitato su questo server.',
    'web.site-copy.destinationTypeSiteSelect' => 'Nome del sito',
    'web.site-copy.destinationSiteRootIsSubDirOfSourceRoot' => "I file del sito %%source%% non possono essere copiati in %%destination%% perché %%destination%% fa anche parte di quei file -- la radice del documento è una sottocartella della radice del documento %%source%%.",
    'web.site-copy.unableToDeleteSourceRootIsSubdirOfDestinationRoot' => "I file del sito %%destination%% non possono essere rimossi perché i file di %%source%% fanno parte di essi -- la radice del documento di %%source%% è una sottocartella di %%destination%%.",
    'web.site-copy.destinationTypeFtp' => 'Storage FTP',
    'web.site-copy.destinationTypeFtpDescription' => 'Copia i file del sito web in un account FTP in questo o un server esterno.',
    'web.site-copy.destinationTypeFtpDescription_powerUser' => 'Copia i file del sito web in un account FTP su un server esterno.',
    'web.site-copy.destinationTypeFtpHost' => "Nome host del server",
    'web.site-copy.destinationTypeFtpPort' => "Porta",
    'web.site-copy.destinationTypeFtpFolder' => 'Directory',
    'web.site-copy.destinationTypeFtpUser' => 'Nome utente',
    'web.site-copy.destinationTypeFtpPassword' => 'Password',
    'web.site-copy.destinationTypeFtpMode' => 'Metodo di connessione FTP',
    'web.site-copy.destinationTypeFtpModeActive' => 'Modalità attiva',
    'web.site-copy.destinationTypeFtpModeActiveDescription' => 'Nella modalità attiva, Plesk invia il suo indirizzo IP e il numero di porta in cui ascolterà un server esterno e il server avvierà la connessione TCP. Questa modalità è consigliata quando il server gestito da Plesk non è protetto da un firewall.',
    'web.site-copy.destinationTypeFtpModePassive' => 'Modalità passiva',
    'web.site-copy.destinationTypeFtpModePassiveDescription' => 'La modalità passiva può essere usata quando il server gestito da Plesk è dietro un firewall e non può accettare le connessioni TCP in arrivo.',
    'web.site-copy.existingFiles' => 'Cosa fare con i file esistenti',
    'web.site-copy.existingFilesKeep' => 'Conserva i file esistenti nel sito di destinazione',
    'web.site-copy.existingFilesKeepDescription' => 'Sovrascrivi i file esistenti con i nomi di file coincidenti nel sito di destinazione.',
    'web.site-copy.existingFilesDelete' => 'Elimina tutti i file esistenti',
    'web.site-copy.existingFilesDeleteDescription' => 'Elimina tutti i file nel sito di destinazione prima della copia.',
    'web.site-copy.emptyLogin' => 'Indicare un nome utente dell\'account FTP.',
    'web.site-copy.emptyHost' => 'Indicare un nome host del server.',
    'web.site-copy.emptyPort' => 'Specifica una porta host del server.',
    'web.site-copy.copyInProgress' => 'Copia del sito web %%sourceName%% in %%destinationName%%. Verrai informato sull\'avanzamento della procedura per posta elettronica (%%email%%).',
    'web.site-copy.unableToCopy' => 'La copia dei file del sito web non è riuscita.',
    'web.site-copy.siteCopied' => 'I file del sito web sono stati copiati.',
    'web.site-copy.emailSubjSuccess' => 'I file del sito web "%%source%%" sono stati copiati.',
    'web.site-copy.emailSubjFailure' => 'La copia dei file del sito web "%%source%%" non è riuscita.',
    'web.site-copy.emailBodySuccess' => 'I file del sito web "%%source%%" sono stati copiati in "%%destination%%".',
    'web.site-copy.emailBodyFailure' => 'La copia dei file del sito web "%%source%%" in "%%destination%%" non è riuscita: %%message%%',

    'web._shared.forwardingSettingsSectionLegend' => 'Impostazioni d\'inoltro',
    'web._shared.forwardDestination' => 'Indirizzo di destinazione',
    'web._shared.forwardDestinationHint' => 'URL del sito web di destinazione.',
    'web._shared.forwardingTypeOptions' => 'Tipologia d\'inoltro',
    'web._shared.forwardingFrame' => 'Inoltro frame',
    'web._shared.forwardingFrameHint' => 'Reindirizza i visitatori del sito web verso un altro sito, senza mostrare l\'indirizzo di destinazione, in modo che non siano al corrente del reindirizzamento.',
    'web._shared.forwardingHttpCode301' => 'Spostato permanentemente (codice 301)',
    'web._shared.forwardingHttpCode301Hint' => 'Reindirizza i visitatori del sito web verso un altro sito e mostra loro l\'indirizzo di destinazione. Tale reindirizzamento conserverà i ranking dei motori di ricerca del sito.',
    'web._shared.forwardingHttpCode302' => 'Spostato temporaneamente (codice 302)',
    'web._shared.forwardingHttpCode302Hint' => 'Reindirizza i visitatori del sito web verso una copia del sito temporanea quando non vorrai che i motori di ricerca indicizzino il sito temporaneo.',
    'web._shared.documentRoot' => 'Root del documento',
    'web._shared.documentRootHint' => 'Il percorso alla home directory del sito web.',
    'web._shared.documentRootHintDisabledDueApplications' => 'È impossibile modificare la directory principale perché non sono presenti applicazioni web installate su questo sito web.',
    'web._shared.ipAddress' => 'Indirizzo IP',
    'web._shared.shared' => 'condiviso',
    'web._shared.exclusive' => 'dedicato',
    'web._shared.ipAddressHint' => "L'indirizzo IP sul quale è ospitato il sito web è un indirizzo di rete dell'host virtuale del sito web.",
    'web._shared.certificateFromDomainRepository' => '%%name%% (%%repositoryName%%)',
    'web._shared.certificateFromOtherRepository' => '%%name%% (altro archivio)',
    'web._shared.certificate' => 'Certificato',
    'web._shared.sameCertificatesHint' => 'Il certificato selezionato verrà utilizzato per tutti i siti ospitati nello stesso indirizzo IP dedicato.',
    'web._shared.differentCertificatesHint' => 'Questo abbonamento è associato a due indirizzi IP dedicati con due certificati diversi. Il certificato selezionato sostituirà qualsiasi certificato installato sui siti ospitati in questi due indirizzi IP.',
    'web._shared.differentIpTypesCertificateHint' => 'Questo abbonamento è associato ad un indirizzo IP condiviso e un indirizzo IP dedicato. Il certificato selezionato verrà anche utilizzato per tutti gli altri siti ospitati sull\'indirizzo IP dedicato.',
    'web._shared.certificateNotSelected' => 'Non selezionato',
    'web._shared.sslCertificatesRepositoryIsEmptyHint' => 'Non ci sono certificati SSL/TLS nel tuo archivio. Per aggiungere un certificato, vai a %%link%%.',
    'web._shared.sslCertificatesRepositoryLink' => 'questa pagina',

    'web-user.settings.allowScripts' => 'Consenti agli utenti web di usare script',

    'web-user.name' => 'Nome utente per connettere al server su FTP',
    'web-user.longName' => 'Questo nome utente è troppo lungo (massimo consentito: %max% simboli).',
    'web-user.password' => 'Password',
    'web-user.passwordConfirmation' => 'Conferma la password',
    'web-user.hardDiskQuota' => 'Quota del disco rigido',
    'web-user.hardDiskQuotaUnlimited' => 'Illimitato',
    'web-user.hardDiskQuotaIsNotSupported' => '(la quota del disco rigido non è supportata a causa della configurazione del file system del server)',
    'web-user.megabytes' => 'MB',

    'requiredFields' => 'Campi obbligatori',
];