<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'anonymous-ftp.description' => 'Si su sitio se aloja en una dirección IP dedicada (no compartida por otros usuarios o sitios), puede configurar un directorio en el sitio donde los demás usuarios podrán cargar y descargar archivos de forma anónima mediante FTP. Una vez activado el FTP anónimo, los usuarios podrán acceder al directorio a través de una dirección como ftp://ftp.your-domain.com usando el nombre de usuario "anonymous" y cualquier contraseña.',
    'anonymous-ftp.displayLogin' => 'Mostrar mensaje de bienvenida',
    'anonymous-ftp.loginText' => 'Texto del mensaje',
    'anonymous-ftp.incomingDir' => 'Permitir cargas al directorio entrante',
    'anonymous-ftp.incomingSubDir' => 'Permitir la creación de directorios en el directorio entrante',
    'anonymous-ftp.incomingReadable' => 'Permitir descargas desde el directorio entrante',
    'anonymous-ftp.quota' => 'Limitar el espacio en disco en el directorio entrante',
    'anonymous-ftp.maxConnections' => 'Limitar el número de conexiones simultáneas',
    'anonymous-ftp.bandwidth' => 'Limitar el ancho de banda de descarga para este dominio FTP virtual',
    'anonymous-ftp.unlimited' => 'Ilimitado',

    'aps.catalog.loading' => 'Cargando...',
    'aps.catalog.searchName' => 'Aplicación',
    'aps.catalog.searchVendor' => 'Fabricante',
    'aps.catalog.searchPackager' => 'Empaquetador',
    'aps.catalog.searchLicenseType' => 'Tipo de licencia',
    'aps.catalog.searchLicenseTypeAny' => 'Cualquiera',
    'aps.catalog.searchLicenseTypeFreeware' => 'Gratis',
    'aps.catalog.searchLicenseTypeCommercial' => 'Comercial',
    'aps.catalog.showSearch' => 'Mostrar búsqueda',
    'aps.catalog.hideSearch' => 'Ocultar búsqueda',
    'aps.catalog.buttonSearch' => 'Buscar',
    'aps.catalog.buttonResetSearch' => 'Restablecer búsqueda',
    'aps.catalog.showCategories' => 'Seleccione una categoría a continuación o busque aplicaciones mediante la casilla de búsqueda',
    'aps.catalog.searchResults' => 'Resultados de la búsqueda',
    'aps.catalog.buttonInstall' => 'Instalar',
    'aps.catalog.buttonInstallTooltip' => 'Instale rápidamente la versión más reciente de la aplicación con la configuración óptima predeterminada.',
    'aps.catalog.buttonAdvancedInstall' => 'Instalación personalizada',
    'aps.catalog.buttonAdvancedInstallTooltip' => 'Instale la versión más reciente de la aplicación y personalice todos los parámetros.',
    'aps.catalog.buttonInstallOldVersion' => 'Versión a instalar',
    'aps.catalog.buttonInstallOldVersionTooltip' => 'Instale la versión seleccionada de la aplicación y personalice todos los parámetros.',
    'aps.catalog.buttonInstallDescription' => 'Si ya dispone de un código de activación para la aplicación o simplemente desea probarla, instálela en un sitio.',
    'aps.catalog.buttonInstallDescriptionFree' => 'Instale esta apl gratuita en un sitio.',
    'aps.catalog.version' => 'Versión',
    'aps.catalog.moreVersions' => 'Otras versiones',
    'aps.catalog.release' => 'Versión',
    'aps.catalog.overview' => 'Descripción',
    'aps.catalog.noApplicationsInCategory' => 'No hay ninguna aplicación disponible en esta categoría. Seleccione otra categoría.',
    'aps.catalog.noCategoriesSelected' => 'Seleccione una categoría para ver todas las aplicaciones disponibles en esta categoría.',
    'aps.catalog.noSearchResults' => 'No se ha encontrado ninguna aplicación.',
    'aps.catalog.connectionFailed' => 'Error al conectarse al catálogo de aplicaciones. %%retryLink%%.',
    'aps.catalog.retry' => 'Reintentar',
    'aps.catalog.categoriesError' => 'La lista de categorías no se ha podido cargar en este momento.',
    'aps.catalog.applicationsError' => 'La lista de aplicaciones no se ha podido cargar en este momento.',
    'aps.catalog.detailsError' => 'Los detalles de la aplicación no han podido cargarse en este momento.',
    'aps.catalog.searchError' => 'Los resultados de la búsqueda no han podido cargarse en este momento.',
    'aps.catalog.changelogEntry' => 'v%%version%% (Versión %%release%%) - %%description%%',
    'aps.catalog.changelog' => 'Historial de cambios',
    'aps.catalog.officialApplicationSite' => 'Info del fabricante',
    'aps.catalog.returnToCategories' => '<< Volver a la lista de aplicaciones',
    'aps.catalog.buttonUninstall' => 'Eliminar',
    'aps.catalog.gotoHome' => 'Inicio',
    'aps.catalog.all' => 'Todos',
    'aps.catalog.buttonDetails' => 'Más info',
    'aps.catalog.buttonBuy' => 'Comprar',
    'aps.catalog.buttonBuyTooltip' => 'Comprar la aplicación',
    'aps.catalog.buttonBuyDescription' => 'Visite nuestra tienda para adquirir un código de activación para la aplicación.',
    'aps.catalog.buttonDownload' => 'Descargar',
    'aps.catalog.buttonDownloadDescription' => 'Descargue la aplicación si ya dispone de un código de activación o si simplemente desea probarla.',
    'aps.catalog.marketplaceMoreInfo' => 'Para más información, visite %%link%%.',
    'aps.catalog.marketplaceMoreInfoLink' => 'sitio web del fabricante de la aplicación',

    'aps.configure.installedAt' => "Instalado en",
    'aps.configure.otherSettings' => "Otros",
    'aps.configure.globalSettings' => 'Configuración del paquete',
    'aps.configure.passwordConfirmation' => 'Confirmar contraseña',
    'aps.configure.databaseParams' => 'Parámetros de base de datos',
    'aps.configure.noInstallationUrlAvailable' => 'Ninguna (app externa)',
    'aps.configure.updateSettingsSection' => 'Configuración de actualización',
    'aps.configure.forceUpdates' => 'Actualizar esta aplicación automáticamente cuando existan actualizaciones disponibles',
    'aps.configure.forceUpdatesHint' => 'La aplicación recibirá actualizaciones automáticas a versiones más recientes. Importante: tenga precaución al utilizar esta opción, ya que las actualizaciones pueden afectar al funcionamiento de las aplicaciones de forma significativa. Por ejemplo, las extensiones de las aplicaciones pueden dejar de funcionar con otra versión de estas.',

    'aps.install.showAllSettings' => 'Mostrar todas las opciones',
    'aps.install.showLessSettings' => 'Mostrar configuración mínima',
    'aps.install.install' => 'Instalar',
    'aps.install.otherSettings' => 'Otras opciones',
    'aps.install.globalSettings' => 'Configuración del paquete',
    'aps.install.passwordConfirmation' => 'Confirme la contraseña',
    'aps.install.provisionsSectionLabel' => 'Ruta de instalación',
    'aps.install.context' => 'Especifique la ubicación donde debe instalarse esta aplicación web',
    'aps.install.registerAsWebmailSection' => 'Registro de webmail',
    'aps.install.registerAsWebmailDescription' => "Seleccione esta opción si la aplicación es un cliente webmail. Esto hará que la aplicación aparezca entre los servicios de webmail disponibles en la configuración de correo de suscripciones y planes de servicio. El administrador puede configurar la URL de acceso público del webmail en Administración del servidor > Configuración > Webmail.",
    'aps.install.registerAsWebmailLabel' => 'Registrar como un servicio de webmail',
    'aps.install.addItem' => 'Añadir',
    'aps.install.removeItem' => 'Eliminar',
    'aps.install.updateSettingsSection' => 'Configuración de actualización',
    'aps.install.forceUpdates' => 'Actualizar esta aplicación automáticamente cuando existan actualizaciones disponibles',
    'aps.install.forceUpdatesHint' => 'La aplicación recibirá actualizaciones automáticas a versiones más recientes. Importante: tenga precaución al utilizar esta opción, ya que las actualizaciones pueden afectar al funcionamiento de las aplicaciones de forma significativa. Por ejemplo, las extensiones de las aplicaciones pueden dejar de funcionar con otra versión de estas.',

    'aps.invalid-requirements.requirementsLegend' => 'Requisitos',
    'aps.invalid-requirements.domainLegend' => 'Sitio web',
    'aps.invalid-requirements.context' => 'Seleccione otro sitio web',
    'aps.invalid-requirements.backToApplicationList' => 'Volver a la lista de aplicaciones',

    'aps.license.title' => 'Instalación de %%packageName%%',
    'aps.license.doYouAcceptLicense' => 'Para instalar esta aplicación, lea el contrato de licencia de usuario final y acepte sus términos.',
    'aps.license.licenseAgree' => 'Acepto las condiciones del Contrato de Licencia',

    'aps.services-list-customization.settings' => 'Configuración',

    'asp-dot-net.change-version.title' => 'Selección de la versión de ASP.NET',
    'asp-dot-net.change-version.frameworkVersion' => 'La versión del framework ASP.NET',
    'asp-dot-net.change-version.success' => 'La versión de ASP.NET se ha modificado.',

    'asp-dot-net.settings.casSettingsSection' => "Seguridad de acceso del código (CAS)",
    'asp-dot-net.settings.clientScriptsSection' => "Configuración de la librería de scripts",
    'asp-dot-net.settings.connStringsSection' => "Administrador de cadenas de conexión",
    'asp-dot-net.settings.customErrorsSection' => "Configuración de errores personalizados",
    'asp-dot-net.settings.frameworkVersionSection' => "Versión del framework",
    'asp-dot-net.settings.globalizationSection' => "Configuración de globalización",
    'asp-dot-net.settings.otherSection' => "Configuración de la sesión",
    'asp-dot-net.settings.pageAndRuntimeSection' => "Compilación y depuración",
    'asp-dot-net.settings.authMode' => "Modo de autenticación",
    'asp-dot-net.settings.connStrings' => "Cadenas de conexión",
    'asp-dot-net.settings.connStringsInvalid' => "Algunos campos están vacíos o contienen un valor incorrecto.",
    'asp-dot-net.settings.connStringName' => "Nombre",
    'asp-dot-net.settings.connStringValue' => "Parámetros de conexión",
    'asp-dot-net.settings.connStringsDescription' => "Nombre / Parámetros de conexión",
    'asp-dot-net.settings.culture' => "Cultura",
    'asp-dot-net.settings.customErrMode' => "Modo de error personalizado",
    'asp-dot-net.settings.customErrorRedirect' => "URL de redireccionamiento",
    'asp-dot-net.settings.customErrorStatus' => "Código de estado",
    'asp-dot-net.settings.customErrorStatusInvalid' => "El código de estado debe ser un número entero.",
    'asp-dot-net.settings.customErrors' => "Errores personalizados",
    'asp-dot-net.settings.customErrorsDescription' => "Código de estado / URL de redireccionamiento",
    'asp-dot-net.settings.customErrorsInvalid' => "Algunos campos están vacíos o contienen un valor incorrecto.",
    'asp-dot-net.settings.debugMode' => "Activar depuración",
    'asp-dot-net.settings.defLanguage' => "Idioma predeterminado de la página web",
    'asp-dot-net.settings.tempDirectory' => "Directorio temporal",
    'asp-dot-net.settings.fileEnc' => "Codific. archivos",
    'asp-dot-net.settings.fileEncInvalid' => "El valor especificado para el parámetro de codificación de los archivos no es válido.",
    'asp-dot-net.settings.pathToLib' => "Ruta a la librería de scripts de Microsoft",
    'asp-dot-net.settings.pathToLibInstall' => "Instalar",
    'asp-dot-net.settings.reqEnc' => "Codific. solicitud",
    'asp-dot-net.settings.reqEncInvalid' => "El valor especificado para el parámetro de codificación de las solicitudes no es válido.",
    'asp-dot-net.settings.resEnc' => "Codific. respuesta",
    'asp-dot-net.settings.resEncInvalid' => "El valor especificado para el parámetro de codificación de las respuestas no es válido.",
    'asp-dot-net.settings.sessTimeout' => "Tiempo de espera de la sesión (minutos)",
    'asp-dot-net.settings.sessTimeoutInvalid' => "El valor especificado para el parámetro de Tiempo de espera de la sesión no es válido. Introduzca un valor entero positivo inferior o igual a %%max%%.",
    'asp-dot-net.settings.connStringDuplicate' => "El nombre de la cadena de conexión ya está siendo usado.",
    'asp-dot-net.settings.customErrorInvalidCode' => "El código de estado debe estar entre 100 y 999",
    'asp-dot-net.settings.customErrorDuplicate' => "El código de estado ya está siendo usado.",
    'asp-dot-net.settings.trustLevel' => "Nivel de seguridad CAS",
    'asp-dot-net.settings.uiCulture' => "Cultura IU",
    'asp-dot-net.settings.version' => "Versión",
    'asp-dot-net.settings.trustLevelAllowOverride' => 'Permitir sobrescritura del nivel de seguridad de CAS en el sitio web',
    'asp-dot-net.settings.updateSuccess' => 'Actualización efectuada correctamente',

    'database.clone.formDescription' => 'Copie el contenido de la base de datos a una nueva base de datos o a una base de datos existente. De copiarse a una base de datos existente, las tablas de la base de datos de origen se añadirán a la lista de tablas en la base de datos de destino. ¡Importante! Si los nombres de las tablas coinciden, la tabla de la base de datos de origen reemplazará la tabla presente en la base de datos de destino.',
    'database.clone.copyData' => 'Crear una copia completa',
    'database.clone.copyDataHint' => 'De seleccionarse esta opción, se copiará toda la base de datos, incluyendo su estructura y sus datos. De no seleccionarse, solo se copiará la estructura de tablas.',
    'database.clone.server' => 'Servidor de bases de datos de destino',
    'database.clone.versionCut' => 'v%%version%%',
    'database.clone.externalServer' => 'Otro...',
    'database.clone.database' => 'Base de datos de destino',
    'database.clone.newDatabase' => 'Crear base de datos con nombre',
    'database.clone.existingDatabase' => 'Copiar en base de datos existente',
    'database.clone.externalDbHost' => 'Dirección IP o nombre de host',
    'database.clone.externalDbLogin' => 'Nombre de usuario',
    'database.clone.externalDbPassword' => 'Contraseña',
    'database.clone.subscription' => 'Suscripción de destino',
    'database.clone.subscription_powerUser' => 'Espacio web de destino',
    'database.clone.cloneInProgress' => 'Clonando la base de datos %%source%% a la base de datos %%destination%%. Le notificaremos por email acerca del progreso (%%email%%).',
    'database.clone.unableToClone' => 'No se ha podido copiar la base de datos "%%source%%".',
    'database.clone.unableToCreateExternalDatabase' => 'No se ha podido crear una base de datos "%%destination%%" en el servidor especificado.',
    'database.clone.databaseCloned' => 'La base de datos "%%source%%" ha sido copiada.',
    'database.clone.emailSubjSuccess' => 'La base de datos "%%sourceDatabase%%" ha sido copiada.',
    'database.clone.emailSubjFailure' => 'Error al copiar la base de datos "%%sourceDatabase%%".',
    'database.clone.emailBodySuccess' => 'La base de datos "%%sourceDatabase%%" (%%sourceHost%%) se ha copiado a la base de datos "%%destDatabase%%" (%%destHost%%).',
    'database.clone.emailBodyFailure' => 'La base de datos "%%sourceDatabase%%" (%%sourceHost%%) no se ha podido copiar a la base de datos "%%destDatabase%%" (%%destHost%%). Error en el procedimiento de copiado.',
    'database.clone.localServer' => 'servidor local',

    'database.repair-orphaned.formDescription' => 'Este usuario se ha convertido en huérfano una vez finalizado el proceso de restauración. Indique una contraseña para este usuario para solucionar esta incidencia. Si se supone que este usuario es un usuario del sistema sin contraseña, ejecute la utilidad de reparación sin indicar ninguna contraseña.',
    'database.repair-orphaned.login' => 'Nombre de usuario de la base de datos',
    'database.repair-orphaned.pass' => 'Contraseña',
    'database.repair-orphaned.pass2' => 'Confirme la contraseña',
    'database.repair-orphaned.users' => 'Algunos usuarios requieren su atención. Existen algunos usuarios huérfanos que deben repararse para funcionar correctamente.',
    'database.repair-orphaned.orphaned' => 'Usuario huérfano. %%gui begin:link%%Reparar%%gui end:link%%.',
    'database.repair-orphaned.repair' => 'Reparar',

    'database.repair.fixSelected' => 'Reparación seleccionada',
    'database.repair.fix' => 'Reparar',

    'database.user.password' => 'Contraseña',
    'database.user.passwordConfirmation' => 'Confirme la contraseña',
    'database.user.server' => 'Servidor de bases de datos',
    'database.user.versionCut' => 'v%%version%%',
    'database.user.database' => 'Base de datos',
    'database.user.anyDatabase' => 'Cualquiera',
    'database.user.dataAccess' => 'Acceso a datos',
    'database.user.structureAccess' => 'Acceso a estructura',
    'database.user.globalAccess' => 'Privilegios globales',
    'database.user.globalAccessHint' => 'Los privilegios globales funcionan para todas las bases de datos de esta cuenta de hosting.',
    'database.user.aclRadio' => 'Control de acceso',
    'database.user.aclLocalhost' => 'Solo permitir conexiones locales',
    'database.user.aclAny' => 'Permitir conexiones remotas desde cualquier host',
    'database.user.aclCustom' => 'Permitir conexiones remotas desde',
    'database.user.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nLos hosts especificados pueden acceder a la base de datos en nombre de este usuario.",
    'database.user.remoteAccess' => 'Acceso remoto',
    'database.user.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nLas direcciones IP especificadas pueden acceder al servidor de base de datos mediante una regla de firewall. Los cambios que lleve a cabo en esta lista serán moderados previamente por su proveedor de hosting.",
    'database.user.example' => "Por ejemplo:\n%%example%%",
    'database.user.denied' => 'Usar las reglas de firewall del sistema',
    'database.user.allowed' => 'Permitir conexiones remotas desde',
    'database.user.default' => 'Por omisión, usar las credenciales de este usuario para acceder a %%webadmin%%',
    'database.user.remoteAccessHint' => 'Contacte con su proveedor de hosting y compruebe que la opción especificada arriba cumplirá con las reglas actuales del firewall para el acceso entrante a MariaDB/MySQL.',
    'database.user.phpMyAdmin' => 'phpMyAdmin',
    'database.user.webAdmin' => 'Web Admin',
    'database.user.role' => 'Rol',
    'database.user.roleReadWrite' => 'Lectura y escritura',
    'database.user.roleWriteOnly' => 'Solo escritura',
    'database.user.roleReadOnly' => 'Solo lectura',
    'database.user.roleCustom' => 'Personalizado',

    'database.generalSection' => 'General',
    'database.name' => 'Nombre de la base de datos',
    'database.server' => 'Servidor de bases de datos',
    'database.versionCut' => 'v%%version%%',
    'database.relatedDomain' => 'Sitio relacionado',
    'database.noDomainRelations' => 'Ningún sitio relacionado',
    'database.userSection' => 'Usuarios',
    'database.userSectionDescription' => 'Cree un usuario predeterminado para la base de datos. Plesk accederá a la base de datos en nombre de este usuario. Si no se asigna ningún usuario de base de datos a la base de datos, no podrá accederse a la misma.',
    'database.createUser' => 'Crear un usuario de la base de datos',
    'database.username' => 'Nombre de usuario de la base de datos',
    'database.password' => 'Contraseña',
    'database.passwordConfirmation' => 'Confirme la contraseña',
    'database.allDbAccess' => 'El usuario tiene acceso a todas las bases de datos de la suscripción seleccionada',
    'database.aclRadio' => 'Control de acceso',
    'database.aclLocalhost' => 'Solo permitir conexiones locales',
    'database.aclAny' => 'Permitir conexiones remotas desde cualquier host',
    'database.aclCustom' => 'Permitir conexiones remotas desde',
    'database.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nLos hosts especificados pueden acceder a la base de datos en nombre de este usuario.",
    'database.remoteAccess' => 'Acceso remoto',
    'database.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nLas direcciones IP especificadas pueden acceder al servidor de base de datos mediante una regla de firewall. Los cambios que lleve a cabo en esta lista serán moderados previamente por su proveedor de hosting.",
    'database.example' => "Por ejemplo:\n%%example%%",
    'database.denied' => 'Usar las reglas de firewall del sistema',
    'database.allowed' => 'Permitir conexiones remotas desde',

    'deployment-section.deploymentDisabledHint' => 'Cargar archivos desde un repositorio Git',
    'deployment-section.deploymentEnabledHint' => 'Habilitar soporte para Git',
    'deployment-section.deploymentSectionLegend' => 'Sus archivos a copiar al hosting',
    'deployment-section.deploymentSectionDescriptionHint' => 'Si deja el soporte de Git desactivado, los directorios raíz (raíz de documentos y raíz de aplicaciones/sitios web) se crearán vacíos y el sitio mostrará la página predeterminada en el navegador. En este caso, deberá cargar los archivos de su sitio a la raíz de documentos mediante FTP o el administrador de archivos. Active Git ahora o más adelante (en Sitios web y dominios) y cargue los archivos desde un repositorio Git.',

    'dns-zone.add-acl-record.description' => 'Añada una dirección IP de un servidor DNS que pueda recibir una copia de la zona DNS.',
    'dns-zone.add-acl-record.ipAddress' => 'Dirección IP',
    'dns-zone.add-acl-record.ipAddressWithMask' => 'Máscara/dirección IP',

    'dns-zone.record.add-title' => "Añadir registro de recurso a la plantilla de zona",
    'dns-zone.record.add-ns-title' => "Añadir servidor de nombres",
    'dns-zone.record.edit-title' => "Editar registro de recurso",
    'dns-zone.record.edit-success' => "El registro DNS fue actualizado.",
    'dns-zone.record.add-success' => "El registro DNS fue creado.",
    'dns-zone.record.type' => "Tipo de registro",
    'dns-zone.record.domainName' => "Nombre de dominio",
    'dns-zone.record.domainNamePostfix' => ".<domain>",
    'dns-zone.record.nameServer' => "Servidor de nombres",
    'dns-zone.record.protocol' => "Protocolo",
    'dns-zone.record.priority' => "Prioridad",
    'dns-zone.record.priorityLow' => "baja (%%priority%%)",
    'dns-zone.record.priorityHigh' => "muy alta (%%priority%%)",
    'dns-zone.record.weightLow' => "bajo (%%weight%%)",
    'dns-zone.record.weightHigh' => "muy elevado (%%weight%%)",
    'dns-zone.record.ipAddress' => "Dirección IP",
    'dns-zone.record.ipAddressDescription' => "Por ejemplo, 123.123.123.123",
    'dns-zone.record.ipAddressDescriptionExt' => "Por ejemplo, <ip>, 123.123.123.123",
    'dns-zone.record.ipAddressV6' => "Dirección IPv6",
    'dns-zone.record.ipAddressV6Description' => "Por ejemplo, 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressV6DescriptionExt' => "Por ejemplo, <ipv6>, 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressWithMaskDescription' => "Por ejemplo, 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.ipAddressWithMaskDescriptionExt' => "Por ejemplo, <ipv6>, <ip>, 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.masterIpAddressDescription' => "Por ejemplo, 2002:7b7b:7b7b::1, 123.123.123.123",
    'dns-zone.record.canonicalName' => "Nombre canónico",
    'dns-zone.record.mailDomain' => "Dominio de correo",
    'dns-zone.record.mxServer' => "Servidor de intercambio de correo",
    'dns-zone.record.mxServerPriority' => "Especificar la prioridad del servidor de intercambio de correo",
    'dns-zone.record.txtRecord' => "Registro TXT",
    'dns-zone.record.txtRecordString' => "Introducir cadena de registro",
    'dns-zone.record.txtSpfSyntax' => "Registro SPF",
    'dns-zone.record.txtRecordDescription' => "",
    'dns-zone.record.invalidTxtRecord' => "Los valores especificados para el registro TXT no son correctos.",
    'dns-zone.record.quotedTxtRecord' => "El valor del registro TXT debe constar de una sola cadena y no puede contener comillas.",
    'dns-zone.record.dsRecord' => "Registro DS",
    'dns-zone.record.dsRecordDescription' => "Por ejemplo, 60485 5 1 2BB183AF5F22588179A53B0A98631FAD1A292118",
    'dns-zone.record.invalidDsRecord' => "Se ha especificado un valor incorrecto para el registro DS.",
    'dns-zone.record.serviceName' => "Nombre del servicio",
    'dns-zone.record.serviceNameDescription' => 'Por ejemplo, SIP (sin el carácter de guion bajo).',
    'dns-zone.record.protocolNameDescription' => 'Por ejemplo, tcp (sin el carácter de guion bajo).',
    'dns-zone.record.portDescription' => 'Por ejemplo, 25 (sin el carácter de guion bajo).',
    'dns-zone.record.srvWeight' => "Peso relativo para los registros con la misma prioridad",
    'dns-zone.record.targetHost' => "Host de destino",
    'dns-zone.record.targetHostDescription' => "Por ejemplo, example.com",
    'dns-zone.record.targetPort' => "Puerto de destino",
    'dns-zone.record.targetPortDescription' => 'Por ejemplo, 8443.',
    'dns-zone.record.retrieveDataError' => "No se han podido encontrar los datos del registro.",
    'dns-zone.record.unknownTypeError' => "Tipo de registro DNS desconocido.",
    'dns-zone.record.nullMxRecordMustBeTheOnly' => 'No es posible configurar un registro MX NULL si existe algún otro registro MX.',
    'dns-zone.record.cannotHaveMxNullRecordAndMxRecord' => 'No es posible configurar un registro que MX que no sea NULL si existe algún otro registro MX NULL.',
    'dns-zone.record.masterShouldBeRemote' => "Debería tener dos servidores de nombres autoritativos distintos en distintos hosts.",
    'dns-zone.record.caaTag' => "Etiqueta",
    'dns-zone.record.caaRecord' => "Valor",
    'dns-zone.record.caaRecordDescription' => "",
    'dns-zone.record.tlsaPort' => 'Puerto',
    'dns-zone.record.tlsaProtocol' => 'Protocolo',
    'dns-zone.record.tlsaUsage' => 'Uso',
    'dns-zone.record.tlsaSelector' => 'Selector',
    'dns-zone.record.tlsaMatching' => 'Tipo de coincidencia',
    'dns-zone.record.tlsaCertData' => 'Datos de asociación del certificado',
    'dns-zone.record.tlsaSeeLinkForDetails' => 'Para más información, visite %%link%%',
    'dns-zone.record.tlsaRfc6698Section211' => 'RFC6698, sección 2.1.1',
    'dns-zone.record.tlsaRfc6698Section212' => 'RFC6698, sección 2.1.2',
    'dns-zone.record.tlsaRfc6698Section213' => 'RFC6698, sección 2.1.3',
    'dns-zone.record.tlsaRfc6698Section214' => 'RFC6698, sección 2.1.4',

    'dns-zone.record.httpsPriorityAlias' => "alias (%%priority%%)",
    'dns-zone.record.httpsTargetHostDescription' => 'Por ejemplo, example.com. Un valor en blanco significa que el host es el mismo que el nombre de dominio.',
    'dns-zone.record.httpsProtocols' => 'Protocolos',
    'dns-zone.record.httpsProtocolsDescription' => 'Lista separada por comas de los protocolos soportados por el destino. Por ejemplo, h3,h3-29,h2,http/1.1.',
    'dns-zone.record.httpsForceProtocols' => 'Forzar el uso de únicamente los protocolos especificados. La lista de protocolos anterior no puede estar vacía.',
    'dns-zone.record.httpsIpv4hint' => 'Sugerencia de direcciones IPv4',
    'dns-zone.record.httpsIpv4hintDescription' => 'Lista de direcciones IPv4 separadas por comas que puede utilizar un cliente para acceder al servicio.',
    'dns-zone.record.httpsIpv6hint' => 'Sugerencia de direcciones IPv6',
    'dns-zone.record.httpsIpv6hintDescription' => 'Lista de direcciones IPv6 separadas por comas que puede utilizar un cliente para acceder al servicio.',

    'dns-zone.record.ttl' => "TTL",
    'dns-zone.record.ttl-seconds' => "Segundos",
    'dns-zone.record.invalidValue' => 'El valor no es válido. Este puede ser entre 1 segundo y 2147483647 segundos.',
    'dns-zone.record.ttlDefaultValue' => 'Valor predeterminado: %%value%% segundos',
    'dns-zone.record.invalidTTL' => 'El valor TTL indicado no es válido.',
    'dns-zone.record.invalidIpAddress' => 'La dirección IP especificada no es válida.',
    'dns-zone.record.invalidIpMaskPair' => 'El par de máscara de red/IP indicado no es válido.',
    'dns-zone.record.invalidCName' => 'El nombre canónico indicado no es válido.',
    'dns-zone.record.invalidPort' => 'El puerto indicado no es válido.',
    'dns-zone.record.invalidTLSACertData' => 'Los datos de asociación del certificado especificados no son válidos.',
    'dns-zone.record.invalidTLSAProtocol' => 'El protocolo especificado no es válido.',
    'dns-zone.record.invalidTLSAUsage' => 'El uso especificado no es válido.',
    'dns-zone.record.invalidTLSASelector' => 'El selector especificado no es válido.',
    'dns-zone.record.invalidTLSAMatching' => 'El tipo de coincidencia especificado no es válido.',

    'dns-zone.restore-default.formHint' => "Aquí puede restaurar la configuración original de la zona de acuerdo con la configuración predeterminada de la plantilla DNS usada en el servidor. Seleccione las direcciones IP que deben usarse para restaurar la zona y especifique si se requiere el alias www para el dominio.",
    'dns-zone.restore-default.ipv4' => "Dirección IPv4",
    'dns-zone.restore-default.ipv4Hint' => "Por ejemplo, 123.123.123.123",
    'dns-zone.restore-default.ipv6' => "Dirección IPv6",
    'dns-zone.restore-default.ipv6Hint' => "Por ejemplo, 2002:7b7b:7b7b::1",
    'dns-zone.restore-default.invalidIpAddress' => 'La dirección IP especificada no es válida.',
    'dns-zone.restore-default.customIpHint' => "Los registros con esta dirección IP se considerarán como modificados por el usuario y no se sincronizarán con la plantilla DNS a nivel del servidor.",
    'dns-zone.restore-default.wwwPrefix' => "Prefijo www",
    'dns-zone.restore-default.previewRecords' => "Restaurar los registros usados para la previsualización del sitio",

    'dns-zone.soa-record.soaMnameSection' => 'Servidor de nombres principal',
    'dns-zone.soa-record.soaMname' => 'Servidor de Nombres',
    'dns-zone.soa-record.soaMnameAutoselect' => '(Selección automática)',
    'dns-zone.soa-record.soaRecordSection' => 'Registro SOA',
    'dns-zone.soa-record.ttl' => 'TTL',
    'dns-zone.soa-record.refresh' => 'Actualizar',
    'dns-zone.soa-record.retry' => 'Reintentar',
    'dns-zone.soa-record.expire' => 'Expiración',
    'dns-zone.soa-record.minimum' => 'Mínimo',
    'dns-zone.soa-record.rnameType' => 'Email (RNAME)',
    'dns-zone.soa-record.rnameTypeHint' => 'La dirección de email de la persona responsable de la zona DNS del dominio. Devuelta por el servidor DNS en respuesta a consultas SOA.',
    'dns-zone.soa-record.rnameTypeOwner' => 'Dirección de email del propietario del sitio web',
    'dns-zone.soa-record.rnameTypeDomain' => 'Dirección de email del dominio',
    'dns-zone.soa-record.rnameTypeDomainHint' => 'Introduzca solo la parte local (antes de @<domain>)',
    'dns-zone.soa-record.rnameTypeExternal' => 'Dirección de email externa',
    'dns-zone.soa-record.rnameEnforceEmail' => 'Prohibir el cambio de la dirección de email RNAME de forma individualizada para cada dominio',
    'dns-zone.soa-record.invalidValue' => 'El valor no es válido. Este debe estar entre 1 segundo y 68 años.',
    'dns-zone.soa-record.advancedSection' => 'Prestaciones DNS avanzadas',
    'dns-zone.soa-record.serialNumberFormat' => 'Usar el formato de número de serie recomendado por IETF y RIPE',
    'dns-zone.soa-record.serialNumberFormatHint' => 'Seleccione esta opción si su dominio presenta incidencias al pasar la comprobación SOA del registrador. Muchos registradores de dominio requieren este formato de número de serie.',
    'dns-zone.soa-record.restoreDefaultButton' => 'Usar la configuración predeterminada',
    'dns-zone.soa-record.zoneDefaultsSection' => 'Valores predeterminados de zona',
    'dns-zone.soa-record.unitSeconds' => 'segundos',
    'dns-zone.soa-record.unitMinutes' => 'minutos',
    'dns-zone.soa-record.unitHours' => 'horas',
    'dns-zone.soa-record.unitDays' => 'días',
    'dns-zone.soa-record.unitWeeks' => 'semanas',
    'dns-zone.soa-record.refreshValueIsSmallWarning' => 'Intervalo de actualización inferior a una hora, lo que incrementará de forma crítica el tráfico y el consumo de recursos en el servidor.',
    'dns-zone.soa-record.minimumValueIsBigWarning' => 'Establecer el TTL mínimo a más de 3 horas puede hacer que sus dominios no sean accesibles para algunos administradores de dominio. Le recomendamos configurar este valor únicamente si le insiste su registrador de nombres de dominio.',
    'dns-zone.soa-record.success' => 'Las propiedades del registro SOA han sido actualizadas.',
    'dns-zone.soa-record.restoreDefaultSuccess' => 'El registro SOA predeterminado ha sido restaurado.',

    'domain-info-section.domainName' => 'Nombre del dominio',
    'domain-info-section.emptyDomainName' => 'Indique un nombre de dominio.',
    'domain-info-section.ipAddress' => 'Dirección IP',
    'domain-info-section.shared' => 'compartido',
    'domain-info-section.exclusive' => 'dedicada',
    'domain-info-section.ipAddressHint' => "La dirección IP donde se aloja el sitio web es una dirección de red del host virtual del sitio web. Esta dirección IP se usará para todos los sitios web creados dentro de la suscripción.",
    'domain-info-section.ipAddressHint_powerUser' => "La dirección IP donde se aloja el sitio web es una dirección de red del host virtual del sitio web. Esta dirección IP se usará para todos los sitios web creados dentro del espacio web.",
    'domain-info-section.userName' => 'Nombre de usuario',
    'domain-info-section.userNameHint' => 'Cuenta de usuario del sistema asociada con el espacio web, utilizada para acceder a los archivos alojados mediante FTP y SSH.',
    'domain-info-section.emptyLogin' => 'Indique un nombre de usuario.',
    'domain-info-section.password' => 'Contraseña',
    'domain-info-section.emptyPassword' => 'Indique una contraseña.',
    'domain-info-section.passwordConfirmation' => 'Confirme la contraseña',

    'email-address.generalTab' => 'General',
    'email-address.generalHint' => 'Si esta cuenta de correo está asociada a un usuario adicional (el acceso al panel del cliente está habilitado), los cambios que efectúe en esta página afectarán a la configuración de este usuario. Concretamente, si cambia la dirección de email y la contraseña, las credenciales de acceso del usuario adicional también se cambiarán a los nuevos valores.',
    'email-address.redirectTab' => 'Reenvío',
    'email-address.redirectHint' => 'Configure el reenvío de mensajes de email a una o más direcciones de email.',
    'email-address.aliasesTab' => 'Alias de correo',
    'email-address.autoResponderTab' => 'Respuesta automática',
    'email-address.antispamTab' => 'Filtro antispam',
    'email-address.autoResponderHint' => 'Configure una respuesta automática para cualquier email recibido en su buzón de correo. Una respuesta automática es una forma estándar de notificar a aquellos que le escriben de que no se encuentra en la oficina o de que está de vacaciones.',
    'email-address.antivirusTab' => 'Antivirus',
    'email-address.name' => 'Dirección de email',
    'email-address.externalEmail' => 'Dirección de email externa',
    'email-address.externalEmailHint' => 'Se usará para restablecer su contraseña en caso de que no pueda acceder a su dirección de email principal.',
    'email-address.user' => 'Asignada a',
    'email-address.password' => 'Contraseña',
    'email-address.passwordConfirmation' => 'Confirmar contraseña',
    'email-address.responderEnable' => 'Activar respuesta automática',
    'email-address.responderSubject' => 'Asunto del mensaje de respuesta automática',
    'email-address.responderContentType' => 'Formato del mensaje',
    'email-address.responderContentTypeHint' => 'El texto sin formato es soportado por todos los clientes de correo, por lo que todos los destinatarios verán el mensaje de la misma forma que lo ve usted. Los mensajes HTML tienen una apariencia mejor, ya que le permiten introducir texto con formato con distintos estilos de fuente. De todas formas, algunos clientes de correo no soportan mensajes HTML y algunos destinatarios puede que experimenten problemas para visualizar texto con formato.',
    'email-address.responderContentTypeTextPlain' => 'Texto sin formato',
    'email-address.responderContentTypeTextHtml' => 'HTML',
    'email-address.responderCodepage' => 'Codificación',
    'email-address.responderCodepageHint' => 'La codificación define la forma en la que se muestran los caracteres de texto. La codificación recomendada es UTF-8.',
    'email-address.responderReplyTo' => 'Redireccionar a',
    'email-address.responderReplyToHint' => 'Cuando se envíe la respuesta automática, el mensaje original será reenviado a la dirección de email especificada.',
    'email-address.responderForwardAddress' => 'Redireccionar a',
    'email-address.responderForwardAddressHint' => 'Cuando se envíe la respuesta automática, el mensaje original será reenviado a la dirección de email especificada.',
    'email-address.responderMessage' => 'Texto del mensaje de la respuesta automática',
    'email-address.responderReplyToEqualsEmail' => 'La dirección de reenvío especificada es la misma que esta dirección de email.',
    'email-address.responderForwardAddressEqualsEmail' => 'La dirección de reenvío especificada es la misma que esta dirección de email.',
    'email-address.responderReplyLimit' => 'Enviar una respuesta automática a una dirección de email única no más de (veces al día)',
    'email-address.buttonAddResponderAttachment' => 'Añadir un adjunto',
    'email-address.buttonRemoveResponderAttachment' => 'Eliminar',
    'email-address.responderAttachment' => 'Adjuntar un archivo',
    'email-address.redirectEnable' => 'Activar reenvío de correo',
    'email-address.redirectRemoveEnable' => 'No entregar copias de emails reenviados al buzón de correo Plesk',
    'email-address.redirectAddress' => 'Reenviar mensajes entrantes a la siguiente dirección de email',
    'email-address.redirectAddressHint' => 'Especifique las direcciones de email. Puede introducir una dirección por línea o bien separar las direcciones con espacios, comas o punto y coma.',
    'email-address.role' => 'Rol de usuario',
    'email-address.roleHint' => 'Los roles de usuario conceden a los usuarios privilegios administrativos y acceso a las aplicaciones que usted haya seleccionado para el rol.',
    'email-address.errorRedirectAddress' => 'Ha indicado una dirección de email que no es válida: %value%.',
    'email-address.errorRedirectAddressMultiple' => 'Ha indicado unas direcciones de email que no son válidas: %value%.',
    'email-address.mailAlias' => "Alias de correo",
    'email-address.mailAliasNone' => 'Ninguna',
    'email-address.mailAliasHint' => "Los alias de correo son direcciones de email alternativas asociadas con una dirección de email principal. Todos los correos enviados a los alias de correo se recibirán en la dirección de email principal.",
    'email-address.buttonAddMailAlias' => 'Añadir alias de correo',
    'email-address.buttonRemoveMailAlias' => 'Eliminar',
    'email-address.emptyEmail' => 'Especifique la dirección de email a la que deben reenviarse todos los mensajes entrantes.',
    'email-address.emailsIsEqual' => 'La dirección de email externa coincide con la principal. Indique otra dirección de email externa.',
    'email-address.emptyPassword' => 'Indique una contraseña.',
    'email-address.emptyPasswordConfirmation' => 'Confirme la contraseña.',
    'email-address.emptyAlias' => "Especifique un alias de correo para esta dirección de email.",
    'email-address.aliasEqualsEmail' => 'El alias de correo especificado es el mismo que la dirección de email.',
    'email-address.passwordHint' => 'Se usará para acceder al buzón y a Plesk (si se ha activado la opción correspondiente).',
    'email-address.cyclicRedirect' => 'La dirección de email no puede configurarse para que los corres se reenvíen a sí misma.',
    'email-address.errorMailnameReserved' => 'La dirección de email indicada ya está siendo usada.',
    'email-address.antivirusEnable' => 'Activar protección antivirus para esta dirección de email',
    'email-address.antivirusHint' => 'El servicio de antivirus bloquea aquellos emails que contienen virus y envía una notificación del incidente tanto al remitente como al destinatario.',
    'email-address.antivirusSettings' => 'Buscar viruses',
    'email-address.antivirusSettingOnlyIncomingMail' => 'solo correo entrante',
    'email-address.antivirusSettingOnlyOutgoingMail' => 'solo correo saliente',
    'email-address.antivirusSettingOnlyIncomingAndOutgoingMail' => 'Correo entrante y saliente',
    'email-address.antispamHint' => 'El servicio de filtración de spam detecta los mensajes spam enviados a la dirección de email. Puede configurar el filtro antispam para que elimine los mensajes spam, los marque como spam cambiando su asunto o los mueva a una carpeta determinada a la que los clientes de correo puedan acceder a través de IMAP. El filtro antispam usa una amplia variedad de pruebas locales y de red para la identificación de firmas de correo no deseado.',
    'email-address.antispamEnable' => 'Activar la filtración de spam para esta dirección de email',
    'email-address.antispamSettings' => 'Qué hacer con los mensajes clasificados como spam',
    'email-address.antispamSettingsMark' => 'Marcarlos como spam añadiendo el siguiente texto al asunto del mensaje',
    'email-address.antispamSettingsMarkHint' => 'Deje este campo en blanco si no desea añadir ningún texto. Introduzca _SCORE_ si desea incluir la puntuación en el asunto del mensaje.',
    'email-address.antispamReportTextHint' => 'Introduzca el texto que desea añadir a los cuerpos de los mensajes spam.',
    'email-address.antispamSettingsDelete' => 'Eliminar todos los mensajes spam',
    'email-address.antispamSettingsDeleteHint' => 'Los mensajes spam se eliminarán de su buzón de correo.',
    'email-address.antispamSettingsMove' => 'Mover spam a la carpeta Spam',
    'email-address.antispamSettingsMoveHint' => 'Mueva todos los mensajes spam a la carpeta denominada Spam. Puede acceder a esta carpeta desde su cliente de correo o webmail. Si está usando una cuenta de correo IMAP, puede utilizar la carpeta Spam para entrenar al filtro antispam.',
    'email-address.antispamSettingsMoveWarning' => '"Mover spam a la carpeta Spam" no funciona a menos que desactive la opción "No entregar copias de emails reenviados" en la pestaña "Redireccionamiento".',
    'email-address.antispamSettingsMoveJunk' => 'Mover spam a la carpeta "Correo electrónico no deseado"',
    'email-address.antispamSettingsMoveJunkHint' => 'Mueva todos los mensajes spam a la carpeta denominada "Correo electrónico no deseado". Puede acceder a esta carpeta desde su cliente de correo o webmail. Si está usando una cuenta de correo IMAP, puede utilizar la carpeta "Correo electrónico no deseado" para entrenar al filtro antispam.',
    'email-address.antispamShowAdvancedSection' => 'Mostrar configuración avanzada',
    'email-address.antispamHideAdvancedSection' => 'Ocultar configuración avanzada',
    'email-address.antispamLearnMore' => 'Descubra cómo entrenar el filtro antispam.',
    'email-address.antispamFilterScoreTitle' => 'Sensibilidad del filtro',
    'email-address.antispamFilterScoreHint' => 'El filtro antispam realiza distintos análisis en el contenido y en la línea de asunto de los mensajes. Como resultado, cada mensaje obtiene una puntuación. Cuanta más elevada sea esta puntuación, más probable será que el mensaje sea spam. Por omisión, la sensibilidad del filtro se establece de tal forma que todos los mensajes que obtienen una puntuación de 7 o más puntos, se clasifican como spam. Si con la configuración actual recibe muchos mensajes spam, intente establecer un valor inferior, como por ejemplo 6. Si no recibe determinados emails porque el filtro antispam los considera correo no deseado, intente reducir la sensibilidad del filtro estableciendo un valor más elevado, como por ejemplo 8.',
    'email-address.antispamFilterScore' => 'Sensibilidad del filtro antispam',
    'email-address.antispamWhiteListTitle' => 'Lista blanca',
    'email-address.antispamWhiteListHint' => 'Los emails procedentes de remitentes presentes en la lista blanca no serán analizados por el filtro antispam.',
    'email-address.antispamWhiteListField' => 'Lista blanca',
    'email-address.antispamWhiteListFieldHint' => 'Introduzca los nombres de dominio, un nombre de dominio por línea. Las direcciones pueden incluir los caracteres wildcard "*" y "?", por ejemplo *@domain.com, user?@*.com.',
    'email-address.antispamBlackListTitle' => 'Lista negra',
    'email-address.antispamBlackListHint' => 'Los emails procedentes de remitentes presentes en la lista negra son clasificados como spam.',
    'email-address.antispamBlackListField' => 'Lista negra',
    'email-address.antispamBlackListFieldHint' => 'Introduzca los nombres de dominio, un dominio por línea. Las direcciones pueden incluir los caracteres wildcard "*" y "?", por ejemplo *@domain.com, user?@*.com.',
    'email-address.antispamTrustedLanguagesTitle' => 'Idiomas de confianza',
    'email-address.antispamTrustedLanguagesHint' => 'Los emails escritos en estos idiomas siempre pasarán el filtro.',
    'email-address.antispamTrustedLocalesTitle' => 'Idiomas de confianza',
    'email-address.antispamTrustedLocalesHint' => 'Los emails que usen los grupos de idiomas especificados siempre pasarán el filtro. Los grupos de idioma incluyen los conjuntos de caracteres más usados. Por ejemplo, el conjunto de caracteres occidental incluye codificaciones para letras usadas en inglés y en idiomas de la Europa occidental.',
    'email-address.antispamTrustedNetworksTitle' => 'Redes de confianza',
    'email-address.antispamTrustedNetworksHint' => 'Los hosts de retransmisión en redes de confianza se consideran que no son potencialmente operados por spammers y no son retransmisiones abiertas ni proxys abiertos.',
    'email-address.antispamIpAddressesField' => 'Direcciones IP',
    'email-address.antispamIpAddressesFieldHint' => 'Especifique la máscara y dirección IP de red.',
    'email-address.mailBoxQuotaDomainDefault' => 'Tamaño predeterminado (%%domainMboxQuota%%)',
    'email-address.mailBoxQuotaDomainDefaultNew' => 'Tamaño predeterminado',
    'email-address.mailBoxOutgoingMessages' => 'El número máximo de emails salientes',
    'email-address.mailBoxOutgoingMessagesDomainDefault' => 'Predeterminado (%%domainOutgoingMessages%% mensajes por hora)',
    'email-address.mailBoxOutgoingMessagesDomainSpecific' => 'Valor personalizado para el buzón de correo',
    'email-address.mailBoxOutgoingMessagesDomainSpecificHint' => 'mensajes',
    'email-address.mailBoxOutgoingMessagesDomainDefaultNew' => 'Predeterminado',
    'email-address.mailBoxQuotaDomainDefaultReadonly' => 'Tamaño predeterminado',
    'email-address.mailBoxQuotaDomainSpecific' => 'Otro tamaño',
    'email-address.mailBoxQuotaDomainSpecificReadonly' => 'Tamaño del buzón de correo',
    'email-address.mailBoxQuotaUnlimited' => 'Ilimitado',
    'email-address.mailBoxLimitReached' => 'Se ha alcanzado el límite de buzones de correo.',
    'email-address.postboxEnabled' => 'Buzón de correo',
    'email-address.postboxEnabledYes' => 'Activado',
    'email-address.postboxEnabledNo' => 'Desactivado',
    'email-address.description' => 'Descripción en Plesk',
    'email-address.descriptionHint' => 'La descripción es visible para todos aquellos que dispongan de acceso a esta cuenta de correo.',
    'email-address.longDescription' => 'La descripción introducida es demasiado larga. Esta no puede tener más de %%max%% símbolos.',
    'email-address.loginAsUser' => 'Puede usarse para acceder a Plesk',
    'email-address.loginAsUserDescription' => '(nombre de usuario: %%username%%)',
    'email-address.maxCustomSizeDesc' => 'El tamaño del buzón de correo no puede ser superior al tamaño predeterminado.',
    'email-address.endDateEnable' => 'Desactivar la respuesta automática el día',

    'failed-request.enable-tracing.description' => 'El seguimiento de las peticiones fallidas es una operación que consume un gran número de recursos. Dicho seguimiento se detendrá de forma automática en %%days%% días. Puede detenerlo de forma manual en cualquier momento.',
    'failed-request.enable-tracing.statusCodes' => 'Códigos de estado',
    'failed-request.enable-tracing.statusCodesDescription' => 'Ejemplo: 401.3-999, 405',
    'failed-request.enable-tracing.provider' => 'Proveedor',

    'file-manager.show.buttonReload' => 'Volver a cargar',
    'file-manager.show.buttonSave' => 'Guardar',
    'file-manager.show.buttonSaveAs' => 'Guardar como',
    'file-manager.show.buttonReset' => 'Restablecer',
    'file-manager.show.buttonTextCodeEditor' => 'Editar en un editor de código',
    'file-manager.show.buttonTextEdit' => 'Editar en un editor de texto',
    'file-manager.show.buttonWysiwygEdit' => 'Editar en un editor HTML',
    'file-manager.show.eolLabel' => 'Tipo de salto de línea:',
    'file-manager.show.saveAs' => 'Guardar como:',
    'file-manager.show.saveCodepage' => 'Guardar en la siguiente codificación:',
    'file-manager.show.loadCodepage' => 'Ver el archivo original en la siguiente codificación:',
    'file-manager.show.loadCodepageHint' => '¡Importante! Cuando se vuelva a cargar el archivo se perderá cualquier cambio que no haya sido guardado previamente.',
    'file-manager.show.fileExists' => "El archivo o la carpeta %%fileName%% ya existe. No puede tener una carpeta o un archivo con el mismo nombre.",
    'file-manager.show.popupTitle' => 'Guardar como',
    'file-manager.show.popupFilename' => 'Nombre del archivo:',

    'file-manager.permissions.filePermissions' => 'Permisos de archivo',
    'file-manager.permissions.directoryPermissions' => 'Permisos de directorio',
    'file-manager.permissions.buttonSubmit' => 'Guardar',
    'file-manager.permissions.buttonApply' => 'Guardar y reanudar',
    'file-manager.permissions.buttonCancel' => 'Cancelar',
    'file-manager.permissions.buttonAdvanced' => 'Avanzado',

    'file-manager.unix-file-permissions.group' => 'Grupo',
    'file-manager.unix-file-permissions.owner' => 'Propietario',
    'file-manager.unix-file-permissions.others' => 'Otros',
    'file-manager.unix-file-permissions.readMode' => 'Lectura',
    'file-manager.unix-file-permissions.writeMode' => 'Escritura',
    'file-manager.unix-file-permissions.execMode' => 'Ejecución/búsqueda',
    'file-manager.unix-file-permissions.changeRecursive' => 'Cambiar permisos de forma recursiva',

    'file-manager.windows-permissions.allow' => 'Permitir',
    'file-manager.windows-permissions.deny' => 'Denegar',
    'file-manager.windows-permissions.inheritFromParent' => 'Permitir que los permisos heredables del objeto principal se propaguen a este objeto y a todos los objetos secundarios. Incluirlos con las entradas definidas aquí de forma explícita',
    'file-manager.windows-permissions.replaceOnChildren' => 'Reemplazar las entradas de permisos en todos los objetos secundarios por las entradas aquí mostradas',
    'file-manager.windows-permissions.buttonAdvanced' => 'Avanzado',
    'file-manager.windows-permissions.applyTo' => 'Aplicar a:',
    'file-manager.windows-permissions.folderOnly' => 'Solo esta carpeta',
    'file-manager.windows-permissions.subfolderOnly' => 'Solo subcarpetas',
    'file-manager.windows-permissions.filesOnly' => 'Solo archivos',
    'file-manager.windows-permissions.permissionsFor' => 'Permisos para',
    'file-manager.windows-permissions.applyOnto1' => 'Solo esta carpeta',
    'file-manager.windows-permissions.applyOnto2' => 'Solo subcarpetas',
    'file-manager.windows-permissions.applyOnto3' => 'A esta carpeta y subdirectorios',
    'file-manager.windows-permissions.applyOnto4' => 'Solo archivos',
    'file-manager.windows-permissions.applyOnto5' => 'Esta carpeta y archivos',
    'file-manager.windows-permissions.applyOnto6' => 'Solo subcarpetas y archivos',
    'file-manager.windows-permissions.applyOnto7' => 'Esta carpeta, subcarpetas y archivos',
    'file-manager.windows-permissions.notInherited' => '<no heredado>',

    'file-manager.editor.titleTextEditor' => 'Editor de texto',
    'file-manager.editor.titleCodeEditor' => 'Editor de código',
    'file-manager.editor.titleCodeViewer' => 'Ver',
    'file-manager.editor.buttonSubmit' => 'Guardar',
    'file-manager.editor.buttonApply' => 'Guardar y reanudar',
    'file-manager.editor.buttonSaveAs' => 'Guardar como ...',
    'file-manager.editor.buttonCancel' => 'Cancelar',
    'file-manager.editor.exitConfirmationYes' => 'Sí',
    'file-manager.editor.exitConfirmationNo' => 'No',
    'file-manager.editor.fileOverwrite' => 'El archivo ya existe.',
    'file-manager.editor.fileOverwriteDescription' => 'Ya existe un archivo con el mismo nombre. ¿Desea sobreescribirlo?',
    'file-manager.editor.exitConfirmation' => '¿Está seguro de que desea cerrar el archivo y descartar los cambios no guardados?',
    'file-manager.editor.buttonCodeEditor' => 'Editar en un editor de código',
    'file-manager.editor.buttonTextEditor' => 'Editar en un editor de texto',
    'file-manager.editor.buttonHtmlEditor' => 'Editar en un editor HTML',

    'file-manager.import-file.buttonSubmit' => 'Importar',
    'file-manager.import-file.fieldUrl' => 'URL para el archivo',
    'file-manager.import-file.fieldUrlDescription' => 'Indique la URL de origen. Por ejemplo, \'https://example.com/example.tgz\'.',
    'file-manager.import-file.fieldUrlFullDescription' => 'El patrón de URL completa es el siguiente: \'https://user:password@example.com/example.tgz\'. El nombre de usuario y la contraseña son opcionales. Se soportan los siguientes protocolos: http, https, ftp y ftps. Use la codificación de URL para aquellas partes de la URL que incluyan caracteres especiales o espacios.',
    'file-manager.import-file.failure' => 'No se pudo importar el archivo.',

    'file-manager.rotation-settings.title' => 'Configuración de rotación de la papelera de reciclaje',
    'file-manager.rotation-settings.rotationBySize' => 'Rotación por tamaño',
    'file-manager.rotation-settings.rotationBySizeUnits' => 'MB',
    'file-manager.rotation-settings.rotationBySizeHint' => 'La opción elimina los archivos nuevos siempre que se exceda el límite indicado para la papelera de reciclaje.',
    'file-manager.rotation-settings.rotationByDate' => 'Rotación por fecha',
    'file-manager.rotation-settings.rotationByDateUnits' => 'Días',
    'file-manager.rotation-settings.rotationByDateHint' => 'La opción elimina los archivos presentes en la papelera de reciclaje que haga más días que están ahí que el número de días indicado.',
    'file-manager.rotation-settings.save' => 'Guardar',
    'file-manager.rotation-settings.cancel' => 'Cancelar',

    'ftp-user.description' => 'Si no es el único que administra su sitio web o aloja subdominios para otros usuarios, puede que desee crear cuentas FTP adicionales para estos usuarios.',
    'ftp-user.generalSection' => 'General',
    'ftp-user.login' => 'Nombre de la cuenta FTP',
    'ftp-user.home' => 'Directorio principal',
    'ftp-user.systemArea' => 'Crear una cuenta FTP con acceso a archivos que no estén presentes en el directorio principal',
    'ftp-user.password' => 'Contraseña',
    'ftp-user.passwordConfirmation' => 'Confirme la contraseña',
    'ftp-user.hardQuotaSection' => 'Cuota de disco duro',
    'ftp-user.hardQuota' => 'Cuota de disco duro',
    'ftp-user.hardQuotaUnlimited' => 'Ilimitado',
    'ftp-user.permissionsSection' => 'Permisos',
    'ftp-user.permissionRead' => 'Permiso de lectura',
    'ftp-user.permissionWrite' => 'Permiso de escritura',
    'ftp-user.popupTitle' => 'Seleccione directorio',

    'mail-list.listName' => 'Dirección de la lista de correo',
    'mail-list.enabled' => 'Activado',
    'mail-list.administratorEmail' => 'Email del administrador de la lista de correo',
    'mail-list.password' => 'Contraseña',
    'mail-list.passwordConfirmation' => 'Confirme la contraseña',
    'mail-list.subscribers' => 'Suscriptores',
    'mail-list.subscribersHint' => 'Especifique las direcciones de email. Puede introducir una dirección por línea o bien separar las direcciones con espacios, comas o punto y coma.',
    'mail-list.notify' => 'Notificar al administrador cuando se creen listas de correo',
    'mail-list.emptyPassword' => 'Proporcione una contraseña.',
    'mail-list.emptyPasswordConfirmation' => 'Confirme la contraseña.',
    'mail-list.errorSubscribers' => 'Direcciones de email que no son válidas: %value%.',
    'mail-list.errorMaillistReserved' => 'La dirección de la lista de correo especificada ya está en uso.',

    'mail-settings.hint' => 'Aquí puede cambiar la configuración del servicio de correo para este dominio.',
    'mail-settings.service' => 'Servicio de correo en este dominio',
    'mail-settings.nonExist' => 'Gestión de los correos para usuarios inexistentes',
    'mail-settings.nonExistBounceWithMessage' => 'Devolver con un mensaje',
    'mail-settings.nonExistBounce' => 'Devolver',
    'mail-settings.nonExistCatch' => 'Reenviar a la dirección',
    'mail-settings.nonExistCatchDescription' => 'La dirección debería pertenecer al dominio seleccionado. El administrador es la única persona que puede especificar una dirección externa o una dirección para varios dominios.',
    'mail-settings.nonExistExternal' => 'Redireccionar a un servidor de correo externo con la dirección IP',
    'mail-settings.nonExistReject' => 'Rechazar',
    'mail-settings.nonExistDiscard' => 'Rechazar',
    'mail-settings.webmail' => 'Webmail',
    'mail-settings.webmailNone' => 'Ninguno',
    'mail-settings.webmailComponentNotInstalled' => 'El componente de webmail no ha sido instalado.',
    'mail-settings.webmailSubdomainAlreadyExists' => 'Existe un subdominio denominado %%subdomain%%.',
    'mail-settings.webmailCertificate' => 'Certificado SSL/TLS para webmail',
    'mail-settings.webmailCertificateNone' => 'No seleccionado',
    'mail-settings.mailCertificate' => 'Certificado SSL/TLS para el correo',
    'mail-settings.mailCertificateNone' => 'No seleccionado',
    'mail-settings.serverCertificateNotSelected' => 'El certificado ha sido asignado, si bien no se ha protegido el correo para el dominio. Para completar la protección del correo para el dominio, %%certLink%%.',
    'mail-settings.serverCertificatesList' => 'proteja el servidor de correo',
    'mail-settings.mailLists' => 'Habilitar listas de correo',
    'mail-settings.mailAutodiscovery' => 'Activar detección automática de correo',
    'mail-settings.mailAutodiscoveryDescription' => 'Descubra cómo funciona en la %%link%%',
    'mail-settings.mailAutodiscoveryDescriptionLink' => 'base de conocimiento',
    'mail-settings.domainKeys' => 'Usar el sistema de protección antispam DKIM para la firma de mensajes de email salientes',
    'mail-settings.activeDkimSelector' => 'Selector DKIM activo',
    'mail-settings.defaultDkimSelector' => ' (Plesk predeterminado)',
    'mail-settings.dkimSelectorName' => 'Nombre del selector',
    'mail-settings.buttonCreateSelector' => 'Crear nuevo selector DKIM',
    'mail-settings.createSelectorDialogTitle' => 'Crear selector DKIM',
    'mail-settings.removeSelectorDialogTitle' => 'Eliminar selector DKIM',
    'mail-settings.removeSelectorConfirmation' => "¿Quieres eliminar el selector '%%selector%%' así como sus registros DNS y claves asociadas?",
    'mail-settings.buttonConfirm' => 'ACEPTAR',
    'mail-settings.buttonCreate' => 'Crear',
    'mail-settings.buttonCancel' => 'Cancelar',
    'mail-settings.labelRemoveSelector' => 'Eliminar',
    'mail-settings.labelActiveSelector' => 'Activo',
    'mail-settings.greyListing' => 'Activar la protección antispam greylisting para todas las cuentas de correo bajo este dominio',
    'mail-settings.howToConfigureExternalDns' => 'Cómo configurar un DNS externo',
    'mail-settings.howToConfigureExternalDnsAlways' => 'Para activar la firma DKIM si usa un servidor DNS externo, es necesario que configure registros DNS DKIM en el servidor DNS.',
    'mail-settings.howToConfigureExternalDnsEnabled' => 'Para ello, use los registros DNS DKIM que se muestran a continuación:',
    'mail-settings.howToConfigureExternalDnsEnabledAliases' => 'Si dispone de alias de dominio usados para el envío de correo, añada también los registros DNS DKIM para estos. Use los mismos registros que para el dominio principal pero con el nombre del alias de dominio.',
    'mail-settings.howToConfigureExternalDnsDisabled' => 'Para ver los registros DNS DKIM que necesita configurar, seleccione la casilla "%%option%%", aplíquelo y vuelva a abrir este pop-up.',
    'mail-settings.mailServiceDisabled' => 'Desactivada',
    'mail-settings.mailServiceDisabledIncoming' => 'Desactivado para el correo entrante',
    'mail-settings.mailServiceDisabledHint' => 'Plesk no proporcionará ningún servicio de correo en este dominio.',
    'mail-settings.mailServiceDisabledIncomingHint' => 'Este dominio solo puede enviar correo y únicamente mediante sendmail.',
    'mail-settings.mailServiceEnabled' => 'Activado',
    'mail-settings.mailServiceEnabledHint' => 'Este dominio puede enviar y recibir correo.',
    'mail-settings.mailServiceNotConfigured' => 'No configurado',
    'mail-settings.mailServiceNotConfiguredHint' => 'Plesk no proporcionará ningún servicio de correo en este dominio.',
    'mail-settings.warning' => 'Esto eliminará los buzones de correo del dominio de forma permanente con todos los correos enviados y recibidos.',
    'mail-settings.show.title' => 'Elimine todos los buzones de correo y emails de %%domain%%',
    'mail-settings.show.checkbox' => 'Eliminar todos los buzones de correo de <b>%%domain%%</b> de forma permanente, incluyendo los emails enviados y recibidos.',

    'role.roleSection' => 'General',
    'role.name' => 'Nombre del rol de usuario',
    'role.description' => 'Descripción',
    'role.generalPermissionsSection' => 'Acceso a los servicios de Plesk',
    'role.applicationsAccessSection' => 'Acceso a apps',
    'role.permissionAllow' => 'Concedido',
    'role.permissionDeny' => 'Denegado',
    'role.emptyRoleName' => 'Indique un nombre de rol.',
    'role.installedAt' => 'Instalado en',
    'role.noInstallationUrlAvailable' => 'App externa',
    'role.invalidRoleName' => 'El nombre del rol de usuario especificado no es válido. En el nombre de un rol no pueden usarse signos de exclamación o interrogación.',
    'role.longRoleName' => 'El nombre de rol de usuario especificado es demasiado largo.',
    'role.somePermissionsAreNotAllowedForSomeSubscriptions' => 'Algunas operaciones pueden no estar disponibles por los siguientes motivos: con la suscripción seleccionada no se concede ningún permiso para la operación o la cantidad de recursos asignados no es suficiente para realizar una operación.',
    'role.servicesPermissionsDescription' => 'Defina el acceso a las aplicaciones instaladas o a los servicios de Plesk para todos los usuarios a los que se les haya otorgado este rol. Si concede a un usuario acceso a una aplicación, esta aplicación pasará a estar disponible para el usuario en el panel del cliente.',
    'role.emailActivation' => 'Activar cuentas de este rol por email',

    'service.admin-access.adminAccess' => 'Acceso administrativo',
    'service.admin-access.customCredentialsDescriptionNoEntryPoints' => 'Estas credenciales se usarán para el acceso administrativo a esta aplicación.',
    'service.admin-access.login' => 'Nombre de usuario administrativo',
    'service.admin-access.password' => 'Contraseña administrativa',
    'service.admin-access.passwordConfirmation' => 'Confirmar contraseña',

    'service.info.service-entry-point.availableAt' => 'Disponible en',
    'service.info.service-entry-point.customize' => 'Personalizar acceso directo',
    'service.info.service-entry-point.displayNameLabel' => 'Nombre del acceso directo',
    'service.info.service-entry-point.displayNameDescription' => 'Proporcione un nombre para este acceso directo. El nombre aparecerá debajo del icono del acceso directo. Los accesos directos se crean en las páginas Mis Servicios de los usuarios a quienes se ha concedido acceso a esta aplicación.',
    'service.info.service-entry-point.descriptionLabel' => 'Descripción del acceso directo',
    'service.info.service-entry-point.descriptionDescription' => 'Proporcione una descripción para este acceso directo. La descripción aparecerá como información rápida cuando se desplace el cursor del ratón por encima del acceso directo.',
    'service.info.service-entry-point.iconLabel' => 'Haga clic para seleccionar el icono del acceso directo',
    'service.info.service-entry-point.iconCurrent' => 'Icono actual',
    'service.info.service-entry-point.errorEmptyName' => 'Indique un nombre para el acceso directo',
    'service.info.service-entry-point.errorLongName' => 'El nombre del acceso directo debe tener entre 1 y 255 caracteres.',
    'service.info.service-entry-point.errorLongDescription' => 'La descripción del acceso directo debe tener entre 0 y 255 caracteres.',
    'service.info.service-entry-point.hiddenLabel' => 'Ocultar acceso directo',
    'service.info.service-entry-point.hiddenDescription' => 'No muestre este acceso directo a los usuarios.',

    'service.info.service-permission.assignedUser' => "Conceder acceso de administrador a este usuario",
    'service.info.service-permission.assignedUserNone' => 'Ningún usuario asignado',

    'shared-ssl.master-ssl.switchedOn' => 'Activar SSL/TLS compartido',
    'shared-ssl.master-ssl.domainName' => 'Nombre de dominio de un sitio cuyo certificado SSL/TLS se compartirá con otros sitios',
    'shared-ssl.master-ssl.none' => 'Ninguno',
    'shared-ssl.master-ssl.noDomainsWithSslWarning' => 'El SSL/TLS compartido no puede activarse porque no existe ningún dominio que tenga habilitado el soporte para SSL/TLS.',

    'user.email.email' => 'Dirección de email',
    'user.email.emptyEmail' => 'Indique una dirección de email.',
    'user.email.internalEmailHint' => 'Cree una dirección de email nueva en Plesk o use una dirección de email externa.',
    'user.email.longInternalEmail' => 'La dirección de email es demasiado larga.',
    'user.email.longInternalEmailMailboxAddressMailServer' => 'El nombre de usuario y la dirección de email es demasiado larga para este servidor de correo. Especifique un nombre de usuario de menos de %%max%% símbolos.',
    'user.email.longInternalEmailFullAddressMailServer' => 'La dirección de email es demasiado larga para este servidor de correo. Indique una dirección de menos de %%max%% símbolos.',
    'user.email.externalEmail' => 'Dirección de email externa',
    'user.email.externalEmailHint' => 'Se usará para restablecer su contraseña en caso de que no pueda acceder a su dirección de email principal.',
    'user.email.emailsIsEqual' => 'La dirección de email externa coincide con la principal. Indique otra dirección de email externa.',
    'user.email.atLeastOneEmailShouldBeSet' => 'Indique una dirección de email interna o externa.',

    'user.profileSection' => 'Información general',
    'user.contactName' => 'Nombre del contacto',
    'user.email' => 'Dirección de email',
    'user.role' => 'Rol de usuario',
    'user.accountSection' => 'Preferencias de Plesk',
    'user.login' => 'Nombre de usuario',
    'user.password' => 'Contraseña',
    'user.oldPassword' => 'Contraseña anterior',
    'user.buttonBack' => 'Atrás',
    'user.generalTab' => 'General',
    'user.applicationsAccessSection' => 'Servicios',
    'user.generalPermissionsSection' => 'Privilegios',
    'user.contactsTab' => 'Detalles de contacto',
    'user.passwordConfirmation' => 'Confirmar contraseña',
    'user.internalEmailPasswordChanged' => 'Si cambia la contraseña también se cambiará la contraseña de la dirección de email interna.',
    'user.emailName' => 'Dirección de email',
    'user.emailType' => 'Tipo de email',
    'user.companyName' => 'Nombre de la empresa',
    'user.phone' => 'Nº teléfono',
    'user.imNumber' => 'Mensajería instantánea',
    'user.fax' => 'Nº de fax',
    'user.address' => 'Dirección',
    'user.city' => 'Ciudad',
    'user.state' => 'Estado o provincia',
    'user.zip' => 'Código postal',
    'user.country' => 'País',
    'user.additionalInfo' => 'Información adicional',
    'user.additionalInfoHint' => 'Solo texto sin formato − Se ignorarán todas las etiquetas HTML.',
    'user.language' => 'Idioma de Plesk',
    'user.buttonChangePassword' => 'Cambiar la contraseña',
    'user.permissionAllow' => 'Concedido',
    'user.permissionDeny' => 'Denegado',
    'user.permissionInherited' => 'Definido por rol',
    'user.emptyContactName' => 'Indique un nombre de contacto.',
    'user.emptyLogin' => 'Indique un nombre de usuario.',
    'user.emptyPassword' => 'Indique una contraseña.',
    'user.emptyPasswordConfirmation' => 'Confirme la contraseña.',
    'user.oldPasswordIsIncorrect' => 'La contraseña anterior no es correcta. Inténtelo de nuevo.',
    'user.chooseDomainBoxTitle' => 'Seleccionar otro dominio:',
    'user.userIsActive' => 'Usuario activo',
    'user.userIsActiveHint' => 'Los usuarios activos pueden acceder a Plesk.',
    'user.emailActivation' => 'Activar cuenta por email',
    'user.emailHint' => 'Para proporcionar al usuario una dirección de email alojada en este servidor, vaya a la pestaña Correo, cree la dirección de email especificada y asóciela con este usuario.',
    'user.emailContactHint' => 'Si desea usar una dirección de email alojada en este servidor, póngase en contacto con su proveedor de servicios.',
    'user.personalEmailHint' => "La dirección de email de este usuario puede editarse en la pestaña Correo.",
    'user.externalMailRedirectHint' => 'El redireccionamiento solo puede activarse para direcciones de email alojadas en este servidor. Si desea crear una dirección de email, vaya a la pestaña Correo.',
    'user.externalMailRedirectHint2' => 'El redireccionamiento solo puede activarse para direcciones de email alojadas en este servidor.',
    'user.externalMailAutoResponderHint' => 'Las respuestas automáticas solo pueden activarse para direcciones de email alojadas en este servidor. Si desea crear una dirección de email, vaya a la pestaña Correo.',
    'user.externalMailAutoResponderHint2' => 'Las respuestas automáticas solo pueden activarse para direcciones de email alojadas en este servidor.',
    'user.roleHint' => 'Los roles de usuario conceden a los usuarios privilegios administrativos y acceso a las aplicaciones que usted haya seleccionado para el rol.',
    'user.cannotManageMail' => "No dispone del permiso necesario para administrar servicios y configuración de correo.",
    'user.longCompanyName' => 'El nombre de empresa especificado es demasiado largo.',
    'user.longPhone' => 'El número de teléfono especificado es demasiado largo.',
    'user.longFax' => 'El número de fax especificado es demasiado largo.',
    'user.longAddress' => 'La dirección especificada es demasiado larga.',
    'user.longCity' => 'El nombre de ciudad especificado es demasiado largo.',
    'user.phoneRegexNotMatch' => 'El número de teléfono especificado no es válido.',
    'user.faxRegexNotMatch' => 'El número de fax especificado no es válido.',
    'user.shortCity' => 'El nombre de ciudad especificado es demasiado corto.',
    'user.limitSubscription' => 'Acceso a suscripciones',
    'user.limitSubscriptionHint' => 'Permita a los usuarios acceder únicamente a una suscripción especificada. El valor "Todo" les concede acceso a todas las suscripciones de su cuenta de hosting.',
    'user.limitSubscriptionAll' => 'Todo',
    'user.deletedSubscription' => 'Suscripción eliminada',

    'web.add-domain-alias.title' => 'Adición de un alias de dominio',
    'web.add-domain-alias.createdSuccessfully' => "El alias de dominio %%name%% ha sido creado.",
    'web.add-domain-alias.domainAliasName' => 'Nombre del alias de dominio',
    'web.add-domain-alias.domainAliasNameHint' => 'Por ejemplo, example.net',
    'web.add-domain-alias.forDomain' => 'para el dominio',
    'web.add-domain-alias.settingsSectionLegend' => 'Configuración',
    'web.add-domain-alias.settingsDns' => 'Sincronizar la zona DNS con el dominio principal',
    'web.add-domain-alias.settingsMail' => 'Servicio de correo',
    'web.add-domain-alias.settingsWeb' => 'Servicio web',
    'web.add-domain-alias.settingsSeoRedirect' => 'Redireccionar con el código HTTP 301',
    'web.add-domain-alias.settingsSeoRedirectHint' => 'Cuando los visitantes abran la URL del alias, estos serán redireccionados a la URL del dominio principal. Plesk utiliza el redireccionamiento HTTP 301 compatible con motores de búsqueda, lo que significa que el posicionamiento de los motores de búsqueda no se dividirá entre las URLs.',
    'web.add-domain-alias.settingsTomcat' => 'Aplicaciones web Java',
    'web.add-domain-alias.invalidDomainGuid' => 'Dominio no válido',

    'web.add-domain.formTitle' => 'Añadiendo dominio nuevo',
    'web.add-domain.portalLink' => 'Portal de servicios',
    'web.add-domain.domainName' => 'Nombre del dominio',
    'web.add-domain.domainNameHint' => "Por ejemplo, example.com",
    'web.add-domain.assignToCustomer' => 'Asignar este dominio a un cliente',
    'web.add-domain.customer' => 'Seleccione un cliente',
    'web.add-domain.createNewCustomer' => 'Crear un cliente nuevo',
    'web.add-domain.selectExistingCustomer' => 'Seleccione un cliente existente:',
    'web.add-domain.customerContactInfoHint' => 'Introduzca la información de contacto del cliente. Más adelante puede añadir otros datos, como por ejemplo la dirección o el número de teléfono del cliente.',
    'web.add-domain.customerLoginInfoHint' => 'Credenciales para el panel del cliente',
    'web.add-domain.target' => 'Espacio web',
    'web.add-domain.createNewTarget' => 'Crear una suscripción nueva',
    'web.add-domain.createNewTarget_powerUser' => 'Crear un espacio web nuevo',
    'web.add-domain.selectExistingTarget' => 'Seleccione una suscripción existente:',
    'web.add-domain.selectExistingTarget_powerUser' => 'Seleccione un espacio web existente:',
    'web.add-domain.dns' => 'Activar el servicio DNS',
    'web.add-domain.dnsHint' => '',
    'web.add-domain.mail' => 'Activar el servicio de correo',
    'web.add-domain.mailHint' => '',
    'web.add-domain.mailHintNoPermission' => 'Funciona si la configuración de la suscripción permite gestionar el permiso de correo por dominio. Si no lo permite, el estado actual del servicio de correo se obtendrá de la suscripción.',
    'web.add-domain.hostingManagementOptions' => 'Tipo de hosting',
    'web.add-domain.websiteHosting' => 'Hosting de sitios web',
    'web.add-domain.websiteForwarding' => 'Redireccionamiento',
    'web.add-domain.websiteNoHosting' => 'Sin hosting',
    'web.add-domain.hostingSettingsSectionLegend' => 'Configuración de hosting',
    'web.add-domain.domainCreatedSuccessfully' => 'El dominio %%domainName%% ha sido creado correctamente.',
    'web.add-domain.webspaceLegend' => 'Configuración del espacio web',
    'web.add-domain.addWhmWebsiteTitle' => 'Adición de un sitio web nuevo',
    'web.add-domain.addWhmWebsiteHint' => "Puede alojar un sitio web en el servidor.",
    'web.add-domain.selectWhmDomain' => 'Seleccione un dominio',
    'web.add-domain.customerLegend' => 'Info del cliente',
    'web.add-domain.credentials' => 'Credenciales del usuario del sistema',
    'web.add-domain.credentialsHint' => 'para acceder a los archivos alojados mediante FTP y SSH',
    'web.add-domain.credentialsHintWin' => 'para acceder a los archivos alojados mediante FTP y RDP',
    'web.add-domain.buttonAddDomain' => 'Añadir dominio',

    'web.add-subdomain.formTitle' => 'Añadir un subdominio',
    'web.add-subdomain.formGeneralHint' => 'Los subdominios son direcciones de Internet para las distintas secciones de su sitio web. Estos utilizan su nombre de dominio principal y un prefijo. Por ejemplo, si su dominio es domain.com, un subdominio podría ser store.domain.com.',
    'web.add-subdomain.formGeneralHintAdditional' => 'También puede crear un subdominio wildcard introduciendo el símbolo * en vez del nombre. En este caso, los visitantes del sitio serán redireccionados a este subdominio sin tener en cuenta el nombre de subdominio que hayan introducido en su navegador.',
    'web.add-subdomain.subdomainName' => 'Nombre del subdominio',
    'web.add-subdomain.subdomainNameHint' => 'Introduzca * para crear un subdominio wildcard.',
    'web.add-subdomain.forDomain' => 'Dominio principal',
    'web.add-subdomain.subdomainCreatedSuccessfully' => 'El subdominio ha sido creado.',
    'web.add-subdomain.hostingSettingsSectionLegend' => 'Configuración de hosting',

    'web.change-hosting.formGeneralHint' => 'Puede elegir entre alojar el sitio web en el servidor (Hosting de sitios web) para configurar el redireccionamiento a otro sitio web (Redireccionamiento) o bien utilizar la zona DNS del dominio de modo que los buzones de correo estén bajo el nombre de dicho dominio (Sin hosting).',
    'web.change-hosting.changed' => 'El tipo de hosting para %%domainName%% ha sido modificado correctamente.',
    'web.change-hosting.hostingManagementOptions' => 'Tipo de hosting',
    'web.change-hosting.websiteHosting' => 'Hosting de sitios web',
    'web.change-hosting.websiteForwarding' => 'Redireccionamiento',
    'web.change-hosting.websiteNoHosting' => 'Sin hosting web',
    'web.change-hosting.hostingSettingsSectionLegend' => 'Configuración de hosting',
    'web.change-hosting.userName' => 'Nombre de usuario',
    'web.change-hosting.userNameHint' => 'Usuario del sistema para la administración de los archivos y las carpetas de la suscripción.',
    'web.change-hosting.userNameHint_powerUser' => 'Usuario del sistema para la administración de los archivos y las carpetas del espacio web.',
    'web.change-hosting.emptyLogin' => 'Debe especificar un nombre de usuario.',
    'web.change-hosting.password' => 'Contraseña',
    'web.change-hosting.emptyPassword' => 'Debe especificar una contraseña.',
    'web.change-hosting.passwordConfirmation' => 'Confirme la contraseña',
    'web.change-hosting.warningInstalledApplications' => 'En el sitio hay instaladas aplicaciones web. Si cambia el tipo de hosting, ya no se podrá acceder a estas.',
    'web.change-hosting.removeWebsiteHostingTitle' => '¡Importante! El contenido del sitio web será eliminado.',
    'web.change-hosting.removeWebsiteHostingDescription' => '¿Desea cambiar el tipo de hosting para su sitio web?',
    'web.change-hosting.removeWebsiteHostingDescriptionFolders' => 'Se eliminarán las siguientes carpetas y todo su contenido:',
    'web.change-hosting.removeWebsiteHostingDescriptionAllFolders' => 'Se eliminará todo el contenido de la carpeta raíz del espacio web.',

    'web.change-status.changed' => 'El estado del sitio web para %%domainName%% ha sido modificado correctamente.',
    'web.change-status.statusManagementOptions' => 'Estado del sitio web',
    'web.change-status.statusDisabled' => 'Deshabilitado (anteriormente, \'Suspendido\')',
    'web.change-status.statusSuspended' => 'Suspendido',
    'web.change-status.statusActive' => 'Activo',
    'web.change-status.statusDisabledHint' => 'El sitio web ya no se alojará en el servidor y no estará disponible a excepción de si se accede al mismo a través de clientes FTP o del administrador de archivos. Los visitantes verán la página predeterminada del servidor web. El servicio de correo no estará disponible.',
    'web.change-status.statusSuspendedHint' => 'Aunque el sitio web seguirá alojándose en el servidor, sus visitantes serán redireccionados a la página de documentos de error personalizados con el código HTTP 503 del navegador. El servicio de correo seguirá estando disponible. Aquí puede %%link%%.',
    'web.change-status.statusSuspendedHintNoLink' => 'Aunque el sitio web seguirá alojándose en el servidor, sus visitantes serán redireccionados a la página de documentos de error personalizados con el código HTTP 503 del motor de búsqueda. El servicio de correo seguirá estando disponible.',
    'web.change-status.error503PageLink' => 'edite el documento de error personalizado',
    'web.change-status.statusActiveHint' => 'El sitio web operará como de costumbre.',
    'web.change-status.notActivatedSuspended' => 'El dominio o el sitio web %%domainName%% no puede activarse porque fue suspendido por su proveedor de hosting.',
    'web.change-status.notActivatedDisabled' => 'El dominio o el sitio web %%domainName%% no puede activarse porque fue deshabilitado por su proveedor de hosting.',

    'web.edit.formTitle' => 'Acceso a hosting web para %%name%%',
    'web.edit.formGeneralHint' => 'Aquí puede ver las direcciones IP asociadas con su suscripción y editar el nombre de usuario y la contraseña de su usuario del sistema.',
    'web.edit.formGeneralHint_powerUser' => 'Aquí puede ver las direcciones IP asociadas con este espacio web y editar el nombre de usuario y la contraseña de su usuario del sistema.',
    'web.edit.ipAddressesLegend' => 'Direcciones IP',
    'web.edit.ipAddresses' => 'Direcciones IP',
    'web.edit.certificateLegend' => 'Certificado',
    'web.edit.certificateFromDomainRepository' => '%%name%% (%%repositoryName%%)',
    'web.edit.certificateFromOtherRepository' => '%%name%% (propiedad de otro usuario)',
    'web.edit.userAccountLegend' => 'Usuario del sistema',
    'web.edit.systemUserHint' => 'Aquí puede especificar un usuario del sistema operativo para la gestión de los archivos y carpetas de la suscripción mediante FTP o a través del administrador de archivos. El usuario del sistema también se utiliza para acceder a Plesk mediante SSH (en Linux) o RDP (en Windows) si se conceden los permisos correspondientes.',
    'web.edit.systemUserHint_powerUser' => 'Aquí puede especificar un usuario del sistema operativo para la gestión de los archivos y carpetas del espacio web mediante FTP o a través del administrador de archivos. El usuario del sistema también se utiliza para acceder a Plesk mediante SSH (en Linux) o RDP (en Windows) si se conceden los permisos correspondientes.',
    'web.edit.login' => 'Nombre de usuario',
    'web.edit.emptyLogin' => 'Especifique un nombre de usuario.',
    'web.edit.password' => 'Contraseña',
    'web.edit.passwordConfirmation' => 'Confirmar contraseña',
    'web.edit.emptyPassword' => 'Especifique una contraseña.',
    'web.edit.emptyPasswordConfirmation' => 'Confirme la contraseña.',
    'web.edit.shellUnix' => "Acceder al servidor vía SSH",
    'web.edit.shellHintUnix' => "Acceda al servidor a través de SSH usando las credenciales del usuario del sistema.",
    'web.edit.shellWin' => 'Acceder al servidor mediante escritorio remoto',
    'web.edit.shellHintWin' => "Acceda al servidor a través de escritorio remoto usando las credenciales del usuario del sistema.",
    'web.edit.diskQuotaLegend' => 'Cuota máxima de espacio en disco',
    'web.edit.diskQuotaHint' => 'La cuota máxima de espacio en disco es la cantidad máxima de espacio en disco que puede usarse. Si establece la cuota máxima y se usa todo el espacio en disco asignado, no se podrán realizar más acciones en archivos.',
    'web.edit.diskQuota' => 'Cuota máxima de espacio en disco',
    'web.edit.diskQuotaUnlimited' => 'Ilimitada',
    'web.edit.diskQuotaLimited' => '%%limit%% MB',
    'web.edit.diskQuotaNotSupported' => 'Ilimitada. La cuota de disco duro no se soporta debido a la configuración del sistema de archivos del servidor.',
    'web.edit.limitMbUnits' => 'MB',
    'web.edit.successfullyUpdated' => 'La configuración de hosting se ha actualizado correctamente.',
    'web.edit.affectedDomainsLegend' => 'Sitios web a los que se aplicará esta configuración',
    'web.edit.affectedDomainsHint' => 'Los sitios web detallados a continuación están asociados con el usuario del sistema actual. Los cambios que realice en la configuración de acceso a hosting web en esta página se aplicarán a todos estos sitios web.',

    'web.mobile.create.formTitle' => 'Crear sitio móvil',
    'web.mobile.create.formGeneralHint' => 'Especifique un nombre para el sitio móvil — una URL a través de la cual pueda accederse al sitio móvil. Generalmente se usan prefijos como "m", "mob", "mobi", "mobile", por ejemplo: mobile.example.com. Puede usar esta URL en una vínculo como "Versión móvil" en su sitio estándar, para que así los visitantes de su sitio puedan pasar de la versión estándar a la móvil y viceversa.',
    'web.mobile.create.prefix' => 'Nombre del sitio',
    'web.mobile.create.emptySiteName' => 'El nombre del sitio web móvil no puede estar vacío, ya que entraría en conflicto con su sitio web estándar.',

    'web.security-section.securitySectionLegend' => 'Seguridad',
    'web.security-section.securitySectionHint' => 'Para proteger las transacciones con su sitio, use SSL/TLS, que cifra todos los datos y los transfiere a través de una conexión segura. Para emplear SSL/TLS, mueva el sitio a una dirección IP dedicada, instale un certificado SSL/TLS y a continuación selecciónelo en la parte de abajo.',
    'web.security-section.securitySectionSniHint' => 'Para proteger las transacciones con su sitio, use SSL/TLS, que cifra todos los datos y los transfiere a través de una conexión segura. Para emplear SSL/TLS, instale un certificado SSL/TLS y a continuación selecciónelo en la parte de abajo.',
    'web.security-section.enableSslSupport' => 'Soporte para SSL/TLS',
    'web.security-section.enableSslRedirect' => 'Redireccionamiento 301 permanente de HTTP a HTTPS preservando SEO',

    'web.seo-settings.seoRedirectDirection' => 'Dominio preferido',
    'web.seo-settings.seoRedirectDirectionHint' => 'Seleccione la URL (con o sin el prefijo www.) a la que se redireccionará a los visitantes del sitio mediante un redireccionamiento HTTP 301 que no alterará el posicionamiento del sitio en los resultados de los buscadores.',
    'web.seo-settings.seoRedirectDirectionNone' => 'Ninguno',

    'web.settings.formGeneralHint' => 'Aquí puede configurar la opciones de hosting de sitios web y seleccionar las prestaciones disponibles para su sitio.',
    'web.settings.hostingType' => 'Tipo de hosting',
    'web.settings.websiteHosting' => 'Sitio web',
    'web.settings.forwardingHosting' => 'Redireccionamiento',
    'web.settings.noHosting' => 'Sin hosting',
    'web.settings.changeHosting' => 'Cambiar',
    'web.settings.websiteStatus' => 'Estado del sitio web',
    'web.settings.changeStatus' => 'Cambiar',
    'web.settings.active' => 'Activo',
    'web.settings.suspended' => 'Suspendida',
    'web.settings.disabled' => 'Desactivado',
    'web.settings.webScriptingSectionLegend' => 'Estadísticas y scripting web',
    'web.settings.webScriptingSectionHint' => 'Especifique cuáles de los lenguajes de scripting y programación que aparecen a continuación deben ser interpretados, ejecutados o procesados por el servidor web.',
    'web.settings.__asp_win_support' => 'Soporte para Microsoft ASP',
    'web.settings.__asp_dot_net_support' => 'Soporte para Microsoft ASP.NET',
    'web.settings.__asp_dot_net_version' => 'Versión',
    'web.settings.__asp_dot_net_version_readonly' => 'versión %%value%%',
    'web.settings.__ssi_support' => 'Soporte para SSI',
    'web.settings.__ssi_with_html' => 'usar SSI para archivos *.htm, *.html',
    'web.settings.__php_support' => 'Soporte para PHP',
    'web.settings.__php_run_as' => 'ejecutar PHP como',
    'web.settings.__php_served_by_apache' => 'servido por Apache',
    'web.settings.__php_served_by_nginx' => 'servido por nginx',
    'web.settings.__cgi_support' => 'Soporte para CGI',
    'web.settings.__cgi_bin_mode' => 'el directorio cgi-bin se encuentra en',
    'web.settings.__cgi_bin_mode_webspace' => 'el directorio raíz de espacio web',
    'web.settings.__cgi_bin_mode_www_root' => 'la raíz de documento de este dominio',
    'web.settings.__cgi_bin_mode_old_style' => 'la raíz de este dominio en el estilo anterior',
    'web.settings.__cgi_bin_mode_readonly' => 'el directorio cgi-bin se encuentra en %%value%%',
    'web.settings.__perl_unix_support' => 'Soporte para Perl',
    'web.settings.__perl_win_support' => 'Soporte para Perl',
    'web.settings.__python_unix_support' => 'Soporte para Python',
    'web.settings.__python_win_support' => 'Soporte para Python',
    'web.settings.__fastcgi_unix_support' => 'Soporte para FastCGI',
    'web.settings.__webstat_support' => 'Estadísticas web',
    'web.settings.__plesk_stat_protect' => 'Proteger el acceso a sus estadísticas web con sus credenciales FTP',
    'web.settings.__plesk_stat_protected' => 'El acceso a sus estadísticas web está protegido con sus credenciales FTP',
    'web.settings.__apache_errdocs' => 'Documentos de error personalizados',
    'web.settings.__php_module_handler' => 'mod_php',
    'web.settings.__php_fastcgi_handler' => 'Aplicación FastCGI',
    'web.settings.__php_cgi_handler' => 'Aplicación CGI',
    'web.settings.__php_isapi_handler' => 'Extensión ISAPI',
    'web.settings.__php_version' => 'Versión de PHP',
    'web.settings.__hosting_write_modify' => 'Permisos adicionales de escritura/modificación',
    'web.settings.__hosting_webdeploy' => 'Publicación de despliegue web',
    'web.settings.awstats' => 'AWStats',
    'web.settings.webalizer' => 'Webalizer',
    'web.settings.smarterstats' => 'SmarterStats',
    'web.settings.__none' => 'Ninguno',
    'web.settings.activate' => 'Activar',
    'web.settings.deactivate' => 'Suspender',
    'web.settings.__php_support_readonly' => 'versión: %%version%%; controlador: %%handler%%',
    'web.settings.__php_support_readonly_not_registered' => 'no está registrado',
    'web.settings.domainName' => 'Nombre del dominio',
    'web.settings.domainNameHint' => "Por ejemplo, example.com",
    'web.settings.sameSslCompatibilitySectionLegend' => 'Modo de compatibilidad para la opción legacy "Separar contenido SSL/TLS y no SSL/TLS"',
    'web.settings.sameSslCompatibilityModeCheckbox' => 'Ejecutar el sitio web en modo de compatibilidad para la opción legacy "Separar contenido SSL/TLS y no SSL/TLS"',
    'web.settings.sameSslCompatibilityHint' => 'Este sitio web opera en modo de compatibilidad y no puedes gestionarlo con la interfaz de Plesk. Esto ha sucedido porque has utilizado la opción obsoleta "SSL/TLS separados y contenido no SSL/TLS" antes de la actualización. Desde Plesk 11, los sitios web almacenan en el mismo directorio todo su contenido disponible por conexiones HTTP y HTTPS. Te recomendamos que traslades todos los datos del directorio \'httpsdocs/\' a \'httpdocs\' y, después, desactives el modo de compatibilidad. Al hacerlo, todas las aplicaciones instaladas en el directorio \'httpsdocs/\' también serán accesibles por internet. Ten en cuenta que no podrás volver a activar el modo de compatibilidad.',
    'web.settings.willBeAppliedAfterApacheRestartInterval' => 'La configuración del sitio web se aplicará en %%restartInterval%% minutos.',
    'web.settings.phpSettingsDescription' => 'En esta página puede ver la configuración PHP para el sitio web. Estos parámetros de configuración son específicos para el sitio web y no afectan a los demás sitios web presentes en la suscripción. Es posible modificar la configuración PHP siempre que el proveedor de hosting le conceda el permiso correspondiente. Asimismo, puede personalizar dicha configuración por ejemplo para limitar el consumo de los recursos del sistema por parte de los scripts PHP o para cumplir los requisitos de una determinada aplicación web. Si define el valor predeterminado para un determinado parámetro, PHP utilizará el valor usado en la configuración PHP a nivel del servidor.',
    'web.settings.phpSettingsAvailableVariables' => 'Usted puede usar los siguientes marcadores en los valores del parámetro:',
    'web.settings.phpSettingsVariableDocroot' => '{DOCROOT} para el directorio raíz de documentos de este sitio web. El valor actual es %%DOCROOT%%. %%HTTPS_DOCROOT%%',
    'web.settings.phpSettingsVariableDocrootHttpsSame' => 'El directorio de la raíz de documentos HTTPS es el mismo que el de http.',
    'web.settings.phpSettingsVariableDocrootHttpsDifferent' => 'El directorio de la raíz de documentos HTTPS es %%DOCROOT%%.',
    'web.settings.phpSettingsVariableWebspaceRoot' => '{WEBSPACEROOT} para el directorio raíz de documentos del sitio web principal de la suscripción.',
    'web.settings.phpSettingsVariableTmp' => '{TMP} para el directorio que almacena archivos temporales.',
    'web.settings.phpSettingsPhpVersion' => 'Su versión de PHP es %%version%%.',
    'web.settings.phpSettingsPhpDisabled' => 'PHP está desactivado.',
    'web.settings.phpHandlerTypeHint' => 'Tenga en cuenta que el cambio del tipo de controlador PHP puede interrumpir el funcionamiento de los scripts PHP existentes en este sitio web.',
    'web.settings.fpmDedicatedHandlerHint' => 'El uso de este controlador aumenta la estabilidad de un sitio web, si bien consume más memoria.',
    'web.settings.phpHandlerChangeHint' => 'Ha modificado la configuración de controlador de PHP. Si guarda los cambios, es posible que los scripts PHP presentes en su sitio web se detengan durante %%interval%% segundos debido a la configuración de su servidor.',
    'web.settings.phpHandlerTypeHelpLink' => 'Descubra cómo escoger la configuración PHP más adecuada',
    'web.settings.phpHandlerTypeNotAvailableHint' => 'El soporte de PHP no puede activarse porque la configuración de hosting actual no incluye ninguna versión de PHP disponible para este dominio.',
    'web.settings.phpHandlerTypeNotAvailableHelpLink' => 'Descubra cómo activar otras versiones de PHP.',
    'web.settings.phpHandlerBroken' => 'El controlador PHP seleccionado está dañado. Seleccione otro controlador.',
    'web.settings.phpHandlerOutdated' => '(Obsoleto)',
    'web.settings.phpHandlerDeprecated' => '(En desuso)',

    'web.setupService.formTitle' => 'Servicio de configuración: %%serviceReference%%',
    'web.setupService.successfullyUpdated' => 'El servicio \'%%serviceReference%%\' se actualizó correctamente.',

    'web.site-copy.subdomainsGroup' => 'Subdominios de %%siteName%%:',
    'web.site-copy.destinationTypeSection' => 'Destino de la copia',
    'web.site-copy.destinationType' => 'Seleccione dónde deberían copiarse los archivos del sitio',
    'web.site-copy.destinationTypeSite' => 'Sitio web en Plesk',
    'web.site-copy.destinationTypeSiteDescription' => 'Copie los archivos del sitio a otro de sus sitios alojados bajo esta cuenta. Si dispone de acceso FTP a otra cuenta presente en este servidor, use la opción Almacenamiento FTP.',
    'web.site-copy.destinationTypeSiteDescription_powerUser' => 'Copie los archivos del sitio a otro sitio alojado en este servidor.',
    'web.site-copy.destinationTypeSiteSelect' => 'Nombre del sitio',
    'web.site-copy.destinationSiteRootIsSubDirOfSourceRoot' => "Los archivos del sitio %%source%% no pueden copiarse a %%destination%% porque %%destination%% también es parte de estos archivos − su raíz del documento es un subdirectorio de la raíz del documento %%source%%.",
    'web.site-copy.unableToDeleteSourceRootIsSubdirOfDestinationRoot' => "Los archivos del sitio %%destination%% no pueden eliminarse porque los archivos de %%source%% son partes de ellos − la raíz del documento %%source%% es un subdirectorio de %%destination%%.",
    'web.site-copy.destinationTypeFtp' => 'Almacenamiento FTP',
    'web.site-copy.destinationTypeFtpDescription' => 'Copie los archivos de un sitio web a una cuenta FTP presente en este servidor o un servidor externo.',
    'web.site-copy.destinationTypeFtpDescription_powerUser' => 'Copie los archivos de un sitio web a una cuenta FTP presente en un servidor externo.',
    'web.site-copy.destinationTypeFtpHost' => "Nombre de host del servidor",
    'web.site-copy.destinationTypeFtpPort' => "Puerto",
    'web.site-copy.destinationTypeFtpFolder' => 'Directorio',
    'web.site-copy.destinationTypeFtpUser' => 'Nombre de usuario',
    'web.site-copy.destinationTypeFtpPassword' => 'Contraseña',
    'web.site-copy.destinationTypeFtpMode' => 'Método de conexión FTP',
    'web.site-copy.destinationTypeFtpModeActive' => 'Modo activo',
    'web.site-copy.destinationTypeFtpModeActiveDescription' => 'En modo activo, Plesk envía su dirección IP y el número de puerto en el que este escuchará a un servidor externo y el servidor inicia la conexión TCP. Este es el modo recomendado en el caso de que el servidor gestionado por Plesk no esté protegido por un firewall.',
    'web.site-copy.destinationTypeFtpModePassive' => 'Modo pasivo',
    'web.site-copy.destinationTypeFtpModePassiveDescription' => 'El modo pasivo puede utilizarse cuando el servidor gestionado por Plesk se encuentra detrás de un firewall y no puede aceptar conexiones TCP entrantes.',
    'web.site-copy.existingFiles' => 'Qué hacer con los archivos existentes',
    'web.site-copy.existingFilesKeep' => 'Conservar los archivos existentes en el sitio de destino',
    'web.site-copy.existingFilesKeepDescription' => 'Reemplazar los archivos existentes con nombres de archivo coincidentes en el sitio de destino.',
    'web.site-copy.existingFilesDelete' => 'Eliminar todos los archivos existentes',
    'web.site-copy.existingFilesDeleteDescription' => 'Eliminar todos los archivos presentes en el sitio de destino antes de copiar.',
    'web.site-copy.emptyLogin' => 'Especifique el nombre de usuario de una cuenta FTP.',
    'web.site-copy.emptyHost' => 'Especifique el nombre de host de un servidor.',
    'web.site-copy.emptyPort' => 'Especifique un puerto de host de servidor.',
    'web.site-copy.copyInProgress' => 'Copiando el sitio web %%sourceName%% a %%destinationName%%. Le notificaremos por email acerca del progreso (%%email%%).',
    'web.site-copy.unableToCopy' => 'Error al copiar los archivos del sitio web.',
    'web.site-copy.siteCopied' => 'Los archivos del sitio web han sido copiados.',
    'web.site-copy.emailSubjSuccess' => 'Los archivos del sitio web "%%source%%" han sido copiados.',
    'web.site-copy.emailSubjFailure' => 'Error al copiar los archivos del sitio web "%%source%%".',
    'web.site-copy.emailBodySuccess' => 'Los archivos del sitio web"%%source%%" han sido copiados a "%%destination%%".',
    'web.site-copy.emailBodyFailure' => 'Error al copiar los archivos del sitio web "%%source%%" a "%%destination%%": %%message%%.',

    'web._shared.forwardingSettingsSectionLegend' => 'Configuración de redireccionamiento',
    'web._shared.forwardDestination' => 'Dirección de destino',
    'web._shared.forwardDestinationHint' => 'URL del sitio web objetivo.',
    'web._shared.forwardingTypeOptions' => 'Tipo de redireccionamiento',
    'web._shared.forwardingFrame' => 'Redireccionamiento por marcos',
    'web._shared.forwardingFrameHint' => 'Redireccione los visitantes del sitio web a otro sitio, pero no mostrarles la dirección de destino, por lo que estos no serán conscientes de esta redirección.',
    'web._shared.forwardingHttpCode301' => 'Movido permanentemente (código 301)',
    'web._shared.forwardingHttpCode301Hint' => 'Redireccione los visitantes del sitio web a otro sitio y muéstreles la dirección de destino. Dicho redireccionamiento no alterará en modo alguno al ranking del sitio en los motores de búsqueda.',
    'web._shared.forwardingHttpCode302' => 'Movido temporalmente (código 302)',
    'web._shared.forwardingHttpCode302Hint' => 'Redireccione los visitantes del sitio web a una copia temporal del sitio cuando no desee que los buscadores indicen este sitio temporal.',
    'web._shared.documentRoot' => 'Raíz del documento',
    'web._shared.documentRootHint' => 'Ruta al directorio principal del sitio web.',
    'web._shared.documentRootHintDisabledDueApplications' => 'No se puede cambiar la raíz de documento porque en este sitio se han instalado aplicaciones web.',
    'web._shared.ipAddress' => 'Dirección IP',
    'web._shared.shared' => 'compartido',
    'web._shared.exclusive' => 'dedicada',
    'web._shared.ipAddressHint' => "La dirección IP donde se aloja el sitio web es una dirección de red del host virtual del sitio web.",
    'web._shared.certificateFromDomainRepository' => '%%name%% (%%repositoryName%%)',
    'web._shared.certificateFromOtherRepository' => '%%name%% (otro repositorio)',
    'web._shared.certificate' => 'Certificado',
    'web._shared.sameCertificatesHint' => 'El certificado seleccionado se usará para todos los demás sitios alojados en la misma dirección IP dedicada.',
    'web._shared.differentCertificatesHint' => 'Esta suscripción está asociada con dos direcciones IP dedicadas con dos certificados distintos. El certificado seleccionado reemplazará cualquier certificado instalado en los sitios alojados en estas dos direcciones IP.',
    'web._shared.differentIpTypesCertificateHint' => 'Esta suscripción está asociada con una dirección IP dedicada y una compartida. El certificado seleccionado también se usará para todos los demás sitios alojados en la dirección IP dedicada.',
    'web._shared.certificateNotSelected' => 'No seleccionado',
    'web._shared.sslCertificatesRepositoryIsEmptyHint' => 'En su repositorio no dispone de ningún certificado SSL/TLS. Si desea añadir un certificado, visite %%link%%.',
    'web._shared.sslCertificatesRepositoryLink' => 'esta página',

    'web-user.settings.allowScripts' => 'Permitir a los usuarios web el uso de scripts',

    'web-user.name' => 'Nombre de usuario para conectarse al servidor vía FTP',
    'web-user.longName' => 'Este nombre de usuario es demasiado largo (se permite un máximo de %max% símbolos).',
    'web-user.password' => 'Contraseña',
    'web-user.passwordConfirmation' => 'Confirmar contraseña',
    'web-user.hardDiskQuota' => 'Cuota de disco duro',
    'web-user.hardDiskQuotaUnlimited' => 'Ilimitada',
    'web-user.hardDiskQuotaIsNotSupported' => '(la cuota de disco duro no se soporta debido a la configuración del sistema de archivos del servidor)',
    'web-user.megabytes' => 'MB',

    'requiredFields' => 'Campos obligatorios',
];