<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.

$messages = [
    'additional-key-info.title' => '其他金鑰屬性',
    'additional-key-info.update' => '檢索其它的金鑰',
    'additional-key-info.updateDescription' => '檢索並安裝其他許可證金鑰。',
    'additional-key-info.download' => '下載許可證',
    'additional-key-info.downloadDescription' => '下載當前許可證金鑰。',
    'additional-key-info.install' => '安裝許可證',
    'additional-key-info.installDescription' => '安裝當前的許可證金鑰。',
    'additional-key-info.revert' => '恢復許可證',
    'additional-key-info.revertDescription' => '恢復到之前安裝的許可證金鑰。',
    'additional-key-info.revertNotAvailableDescription' => '尚未安裝金鑰。',
    'additional-key-info.installSuccess' => '許可證安裝進程已開始。',

    'additional-key-revert.title' => '其他金鑰回滾',
    'additional-key-revert.success' => '其他金鑰已回滾。',

    'additional-key-upload.title' => '安裝許可證金鑰',
    'additional-key-upload.success' => '新附加金鑰已上傳。',

    'additional-keys.title' => '其他許可證金鑰',

    'change-owner.title' => '正在重新分配選定的訂閱',

    'customers.hint' => '您可在此管理主機服務客戶的帳戶，包括創建帳戶和服務訂閱，管理現有客戶，以及移除帳戶。若要管理客戶的網站、郵件或任何其它服務，請點按清單右邊的連結進入 客戶面板 進行操作。',

    'customer-domains.hint' => '在此處您可以創建並管理網站。',

    'customer-subscriptions.hint' => '在此處您可以管理客戶的訂閱。',

    'domains.hint' => '您可在此查看系統中註冊的所有域名資訊，以及管理主機服務。若要為自己或主機客戶添加域名，請點按“添加域名”。創建域名時會提示您創建新客戶和訂閱，也可以選擇現有的客戶和訂閱。',

    'database-servers.title' => '資料庫伺服器',

    'database-server-create.title' => '新建資料庫伺服器',

    'database-server-properties.title' => '資料庫伺服器',

    'database-server-upgrade.drawerTitle' => 'MariaDB 升級',
    'database-server-upgrade.drawerTitle.completed' => '升級完成',
    'database-server-upgrade.drawerSubTitle.line1' => '在執行升級時無法關閉 Drawer。',
    'database-server-upgrade.drawerSubTitle.line2' => '如果問題在升級過程中發生，請參考 %%troubleshootingArticle%%。',
    'database-server-upgrade.drawerSubTitle.completed' => 'MariaDB 資料庫伺服器已升級至版本 %%releaseVersion%%。如果你遇到任何問題，請依循 %%troubleshootingArticle%% 的指示操作。',
    'database-server-upgrade.upToDate' => '你已經安裝 LTS 版本。',
    'database-server-upgrade.troubleshootingArticle' => '該 KB 文章',
    'database-server-upgrade.troubleshootingArticleDescription' => '使用 %%troubleshootingArticle%% 針對 MariaDB 升級問題進行疑難排解。',

    'database-server-upgrade.chooseReleaseStep.infoBlock.par1' => '將你的本地 MariaDB 資料庫伺服器升級至目前的長期支援 (LTS) 版本。',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par2' => '我們強烈建議你備份你的伺服器然後再進行升級，並且避開網頁的尖峰時段進行升級。',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par3' => '在 MariaDB 升級過程中，Plesk 伺服器及主機網站都將無法使用。MariaDB 升級通常不會發生錯誤，過程需要大約 10 分鐘，但這仍有可能影響到整個伺服器。',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par4' => '備註：如果你正在執行 MariaDB 5.5，Plesk 會先將其升級至 MariaDB 10.5。在升級完成後，再次啟動這個精靈，即可升級至目前的 LTS 版本 MariaDB。',
    'database-server-upgrade.chooseReleaseStep.currentVersionTitle' => '當前版本',
    'database-server-upgrade.chooseReleaseStep.currentMariaDBVersion' => 'MariaDB %%version%%',
    'database-server-upgrade.chooseReleaseStep.selectVersion' => '選擇要升級成什麼樣的版本',
    'database-server-upgrade.chooseReleaseStep.noMajorReleases' => '沒有重大更新',
    'database-server-upgrade.chooseReleaseStep.releaseNotes' => '發行說明',
    'database-server-upgrade.chooseReleaseStep.releaseDate' => '發布日期：%%date%%',
    'database-server-upgrade.chooseReleaseStep.endOfLifeDate' => '產品壽命結束：%%date%%',
    'database-server-upgrade.chooseReleaseStep.notDetected' => '只有作業系統廠商或 MariaDB 廠商提供的 Maria DB 叉路可以升級。',

    'database-server-upgrade.preUpgradeCheckProgressStep.title' => '升級前檢查',
    'database-server-upgrade.preUpgradeCheckProgressStep.configChecker' => '分析 MariaDB 配置檔案',
    'database-server-upgrade.preUpgradeCheckProgressStep.mysqlChecker' => '正在使用 mysqlcheck 分析資料庫',
    'database-server-upgrade.preUpgradeCheckProgressStep.webSocketChecker' => '正在檢查 WebSocket',

    'database-server-upgrade.preUpgradeCheckStep.shouldBeConfirmed' => '如果要繼續進行升級，請勾選所有的方格。如果有需要，請確認你同意升級所將帶來的配置變更，並確認你有恢復選項的存取權限。',
    'database-server-upgrade.preUpgradeCheckStep.removedSystemVariables' => '下列變數將基於新版本的相容問題予以移除：',
    'database-server-upgrade.preUpgradeCheckStep.fromFiles' => '來自 {count, plural, other {個#檔案：{files}}}的{variable}',
    'database-server-upgrade.preUpgradeCheckStep.accessToolsSection' => '存取恢復選項（伺服器指令行控制台與 Repair Kit）',
    'database-server-upgrade.preUpgradeCheckStep.sshAccess' => '我確認我有這個伺服器的 SSH 權限',
    'database-server-upgrade.preUpgradeCheckStep.sshAccessDescription' => '使用 SSH 客戶端或在新的瀏覽器頁面開啟 %%sshTerminalExtension%%（在升級完成前，請勿關閉 SSH Terminal 擴充功能視窗）。如果升級失敗，擁有 SSH 訪問權限可協助後續復原作業。',
    'database-server-upgrade.preUpgradeCheckStep.sshTerminalExtension' => 'SSH 終端擴展',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccess' => '我確認我有 Repair Kit 權限',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccessDescription' => '在新的瀏覽器分頁開啟 %%repairKit%%，並使用管理員憑證登入。在升級完成前，請勿關閉 Repair Kit 擴充功能視窗。',
    'database-server-upgrade.preUpgradeCheckStep.repairKit' => 'Repair Kit',
    'database-server-upgrade.preUpgradeCheckStep.dumpSection' => '備份資料庫',
    'database-server-upgrade.preUpgradeCheckStep.withDump' => '在更新前備份主機為這個伺服器的所有資料庫',
    'database-server-upgrade.preUpgradeCheckStep.withDumpDescription' => 'Plesk 會把資料庫的備份檔案儲存在 %%path%% 目錄。',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailable' => 'Plesk 的 WebSocket 無法使用',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailableDescription' => '沒有 WebSocket 的話，您將無法查看升級流程的即時輸出。',

    'database-server-upgrade.submitPopover.title' => '為了避免資料遺失的狀況發生，我們強烈建議你先建立主機資料庫的轉儲內容。是否不建立轉儲就繼續？',

    'database-server-databases.title' => '資料庫',

    'database-server-change-password.title' => '管理員密碼',

    'home.title' => '首頁',

    'license.title' => '許可證資訊',

    'primary-key-info.title' => 'Plesk 許可證金鑰',
    'primary-key-info.update' => '檢索金鑰',
    'primary-key-info.updateDescription' => '檢索訂購的許可證金鑰並進行安裝。',
    'primary-key-info.upload' => '安裝許可證',
    'primary-key-info.uploadDescription' => '上傳並安裝新的許可證。',
    'primary-key-info.revert' => '恢復許可證',
    'primary-key-info.revertDescription' => '恢復到之前安裝的許可證金鑰。',

    'primary-key-revert.title' => '許可證金鑰回滾',
    'primary-key-revert.success' => 'Plesk 金鑰已回滾。',

    'primary-key-upload.title' => '安裝許可證金鑰',
    'primary-key-upload.success' => '新的 Plesk 金鑰已被上傳。',

    'resellers.hint' => '您可在此管理代理商，即代理主機服務以及託管自己的網站的客戶。您可創建帳戶及其服務訂閱，管理現有代理商，以及移除帳戶。',

    'reseller-customers.hint' => '在此處您可以設定並管理客戶。',

    'reseller-domains.hint' => '在此處您可以創建並管理網站。',

    'reseller-subscriptions.hint' => '您可在此管理代理商的訂閱。',

    'subscriptions.hint' => '客戶可通過訂閱主機方案獲取主機服務。您可在此管理此類訂閱以及您自行創建用於託管自己網站的訂閱。若要管理訂閱的網站、郵件或任何其它服務，請點按清單右邊的連結進入訂閱者的“客戶面板”進行操作。',

    'server-mail-settings.title' => '設定',
    'server-mail-spam-filter.title' => '垃圾郵件過濾',
    'server-mail-antivirus.title' => '防病毒程式',
    'server-mail-black-list.title' => '黑名單',
    'server-mail-white-list.title' => '白名單',
    'server-mail-queue.title' => '郵件佇列',
    'server-mail-statistics.title' => '統計',

    'server-spam-filter.title' => '垃圾郵件篩檢程式設定',
    'server-spam-filter.settings' => '設定',
    'server-spam-filter.black-list' => '黑名單',
    'server-spam-filter.white-list' => '白名單',

    'firewall.title' => '防火牆管理',
    'firewall-general.title' => '常用',
    'firewall-general.toggleStatus' => '防火牆保護',
    'firewall-general.buttonDefault' => '重設為預設值',
    'firewall-general.buttonPanic' => '應急模式',
    'firewall-general.confirmationDefault' => '將防火牆設定重置為默認的設定？',
    'firewall-general.confirmationPanic' => '打開恐慌模式？使用者將無法存取他們的域名，一些網路服務可能會停止工作。',
    'firewall-general.successDefault' => '防火牆設定已被重置為預設值。',
    'firewall-general.successPanic' => '恐慌模式已啟用。',
    'firewall-general.info' => '出於安全原因，防火牆阻止了除明確允許的之外所有連接。您可以通過創建某個規則來允許某個連接。更多資訊，請參閱相關文檔。',
    'firewall-general.interfaces' => '網路介面',
    'firewall-icmp.title' => 'ICMP 協議',
    'firewall-rules.title' => '防火牆規則',

    'dns.title' => 'DNS設定',
    'dns-records.title' => '區域記錄範本',
    'dns-soa-record.title' => '區域設定範本',

    'php-handler.title' => ' %%name%% 的設定',
    'php-handler.extensions.title' => '擴展',
    'php-handler.extensions.description' => '這些 PHP 擴展設定僅針對該處理常式。',
    'php-handler.extensions.descriptionShared' => '這些設定通用於以下 PHP 處理常式：%%handlers%%。該設定應用到使用這些處理常式的所有網站。',
    'php-handler.extensions.buttonManage' => '管理 PECL 套裝程式',
    'php-handler.extensions.manage.title' => '管理 PECL 套裝程式',
    'php-handler.extensions.manage.risks' => 'PHP擴展由協力廠商PECL套裝程式提供。您安裝它們的風險將自行承擔。',
    'php-handler.extensions.manage.description' => '安裝、升級和解除安裝 PECL 套裝程式。這些更改將應用於在%%handlers%%上運行的所有網站。',
    'php-handler.extensions.manage.notFound' => '為什麼所需的套裝程式不在列表上？',
    'php-handler.extensions.manage.limitations' => '由控制台提供商和作業系統供應商提供的PHP擴展沒有在清單中顯示。',
    'php-handler.php-ini.title' => 'php.ini',


    'ServerInformation.title' => "伺服器資訊",
    'ServerInformation.refresh' => "刷新",
    'ServerInformation.sectionGeneral' => "常用",
    'ServerInformation.cpu' => "CPU",
    'ServerInformation.version' => "版本",
    'ServerInformation.os' => "作業系統",
    'ServerInformation.key' => "Plesk 許可證金鑰",
    'ServerInformation.uptime' => "正常執行時間",
    'ServerInformation.uptimeValue' => "{days, plural, =0 {} other {# 天}} {hours, plural, other {# 小時}} {minutes, plural, other {# 分鐘}}",
    'ServerInformation.sectionCpu' => "CPU 使用率",
    'ServerInformation.la1min' => "過去 1 分鐘",
    'ServerInformation.la5min' => "過去 5 分鐘",
    'ServerInformation.la15min' => "過去 15 分鐘",
    'ServerInformation.sectionMemory' => "記憶體使用量",
    'ServerInformation.memoryTotal' => "共計",
    'ServerInformation.memoryUsed' => "已使用",
    'ServerInformation.memoryFree' => "免費",
    'ServerInformation.memoryShared' => "共用",
    'ServerInformation.memoryBuffer' => "緩衝區",
    'ServerInformation.memoryCached' => "已緩存",
    'ServerInformation.memoryAvailable' => "可用",
    'ServerInformation.memoryUsage' => "使用",
    'ServerInformation.sectionSwap' => "交換空間使用情況",
    'ServerInformation.sectionVirtualMemory' => "虛擬記憶體使用量",
    'ServerInformation.swapTotal' => "共計",
    'ServerInformation.swapUsed' => "已使用",
    'ServerInformation.swapFree' => "免費",
    'ServerInformation.swapUsage' => "使用",
    'ServerInformation.sectionHarddisk' => "硬碟使用",
    'ServerInformation.harddiskDirectory' => "檔案系統",
    'ServerInformation.harddiskProtectedDir' => "受保護目錄",
    'ServerInformation.harddiskTotal' => "共計",
    'ServerInformation.harddiskUsed' => "已使用",
    'ServerInformation.harddiskAvailable' => "可用",
    'ServerInformation.harddiskCapacity' => "使用",
    'ServerInformation.sectionDomains' => "域名",
    'ServerInformation.activeDomains' => "活動",
    'ServerInformation.inactiveDomains' => "停用",
    'ServerInformation.problemDomains' => "問題",
    'ServerInformation.refreshed' => "資訊已更新。",

    'ServerAbout.title' => '關於 Plesk',
    'ServerAbout.copyright' => '© 2024 WebPros International GmbH。保留所有權利。',
    'ServerAbout.linkLicenseManagement' => '轉到許可證資訊',
    'ServerAbout.panelVersion' => '版本',
    'ServerAbout.installedPatchVersion' => '更新 #%%patch%%',
    'ServerAbout.licenseKey' => '許可證金鑰',
    'ServerAbout.productDescription' => 'Plesk 是實現應用、網站和主機業務的運行、自動化和增長的領導 WebOps 平臺。',
    'ServerAbout.readEula' => '閱讀 %%link%%。',
    'ServerAbout.linkEula' => '使用者授權合約',
    'ServerAbout.visitForum' => '連接 %%link%%',
    'ServerAbout.linkForum' => 'Plesk 論壇',
    'ServerAbout.followUs' => '關注我們',
    'ServerAbout.visitSite' => '可連接 %%link%% 瞭解更多',
    'ServerAbout.linkSite' => 'plesk.com',
    'ServerAbout.visitBlog' => '在 %%link%% 中找到靈感',
    'ServerAbout.linkBlog' => 'Plesk 部落格',

    'ServerAbout.darkThemePromoTitle' => '恭喜您！',
    'ServerAbout.darkThemePromoDescription' => '您找到了一隻加至 Plesk Obsidian 18.0.50 版本的魔法小貓。',
    'ServerAbout.darkThemePromoButton' => '哇賽！來到黑暗面了',
    'ServerAbout.darkThemeTourDescription' => '切換此選項，以啟用或停用您介面上的深色模式主題。',
    'ServerAbout.darkThemeTourButton' => '明白了',

    'ts-sessions.title' => '終端伺服器會話',
    'ts-sessions-properties.title' => '會話屬性',

    'BandwidthLimiting.title' => '%%domainName%% 的頻寬限制',
    'BandwidthLimiting.bandwidthThrottling' => '您不能控制頻寬節流，因為 QoS 尚未安裝。',
    'BandwidthLimiting.virtualHostingRequired' => '頻寬限制僅適用於具有 web 主機的域名。',
    'BandwidthLimiting.bandwidthLabel' => '頻寬最大使用量',
    'BandwidthLimiting.bandwidthHint' => '頻寬使用限制僅適用於通過HTTP協定傳輸的資料。',
    'BandwidthLimiting.maxConnectionLabel' => '最大連接數',
    'BandwidthLimiting.maxConnectionHint' => '如果您限制頻寬，則建議您也限制此網站的同時連接數。如果網站請求頻率較高，則Web伺服器進程會增加伺服器負載。',
    'BandwidthLimiting.kbps' => 'KB/s',
    'BandwidthLimiting.success' => '頻寬限制設定已被更改。',
    'BandwidthLimiting.unlimited' => '無限',

    'ip-address-domains.title' => '使用%%type%% IP位址%%ipAddress%%的網站',
    'ip-address-domains.site' => '網站',
    'ip-address-domains.setAsDefault' => '設為預設值',
    'ip-address-domains.type-SHARED' => '共用',
    'ip-address-domains.type-EXCLUSIVE' => '獨立',

    'HotlinkProtection.title' => '%%domainName%% 的盜鏈防護',
    'HotlinkProtection.virtualHostingRequired' => '盜鏈防護只能用於帶有 web 主機的域名。',
    'HotlinkProtection.enabledLabel' => '啟用盜鏈防護',
    'HotlinkProtection.extensionsLabel' => '受保護的檔副檔名',
    'HotlinkProtection.friendsLabel' => '友好網站地址',
    'HotlinkProtection.success' => '盜鏈防護設定已更改。',

    'Odbc.serverTitle' => 'ODBC DSN 連接',
    'Odbc.domainTitle' => '%%domainName%% 的 ODBC DSN 連線',
    'Odbc.add' => '添加 ODBC DSN',
    'Odbc.resourceUsage' => '允許創建 %%allowed%%，已創建 %%used%%。',
    'Odbc.limitExceeded' => '超過 ODBC DSN 的連線上限。',
    'Odbc.unlimited' => '無限',
    'Odbc.addTooltip' => '添加ODBC資料來源。',
    'Odbc.status' => '狀態',
    'Odbc.name' => '連接名',
    'Odbc.driver' => '驅動程式',
    'Odbc.description' => '連接描述',
    'Odbc.hostname' => '主機名稱',
    'Odbc.statusSystem' => '這是系統 DSN。',
    'Odbc.statusConfigured' => 'DSN 已配置。',
    'Odbc.statusNotConfigured' => 'DSN 尚未配置。',
    'Odbc.noSelectionText' => '選擇要移除的一個或多個項目。',
    'Odbc.removeConfirmation' => '是否移除其他 {count, plural, =1 {the {name} connection} other {# 個選定連線}}？',
    'Odbc.removeSuccess' => '已移除選定連線。',

    'DomainAliasSettings.title' => '網域別名設定',
    'DomainAliasSettings.updateSuccess' => '網域別名%%name%%的屬性經過變更。%%apacheRestartInterval%%',
    'DomainAliasSettings.apacheRestartInterval' => '網站設定將在%%restartInterval%% 分鐘後被應用。',

    'Home.Backup.title' => '最後伺服器備份',
    'Home.Backup.offStatus' => '這不是有效備份，資料無法透過這個檔案恢復。',
    'Home.Backup.task-failedStatus' => '備份任務失敗。',
    'Home.Backup.activeSchedule' => '計畫：%%schedule%%',
    'Home.Backup.activeSchedules' => '計畫：%%schedules%%',
    'Home.Backup.noSchedule' => "備份計畫尚未設定",
    'Home.Backup.period_hourly' => '每小時%%schedule%%',
    'Home.Backup.period_daily' => '每日%%schedule%%',
    'Home.Backup.period_weekly' => '每週%%schedule%%',
    'Home.Backup.period_monthly' => '每月%%schedule%%',
    'Home.Backup.create' => '建立備份',
    'Home.Backup.schedule' => '計畫',
    'Home.IpBan.title' => 'IP 地址禁止',
    'Home.IpBan.banned' => '被停權',
    'Home.IpBan.trusted' => '信任中',
    'Home.IpBan.more' => '查看更多',
    'Home.OverusedSubscriptions.title' => 'Overuse訂閱資格',
    'Home.OverusedSubscriptions.empty' => '沒有找到Overuse訂閱資格',
    'Home.OverusedSubscriptions.usage' => '%%formattedUsed%%/%%formattedValue%%',
    'Home.OverusedSubscriptions.more' => '查看Overuse全部內容：[%%total%%]',
    'Home.OverusedSubscriptions.list' => '在清單中開啟',
    'Home.ServerInfo.title' => '伺服器資訊',
    'Home.ServerInfo.hostname' => '主機名稱',
    'Home.ServerInfo.ipAddress' => 'IP 地址',
    'Home.ServerInfo.publicIpAddress' => '公共 IP 地址',
    'Home.ServerInfo.os' => '作業系統',
    'Home.ServerInfo.uptime' => '正常執行時間',
    'Home.ServerInfo.uptimeValue' => "{days, plural, =0 {} other {# 天}} {hours, plural, other {# 小時}} {minutes, plural, other {# 分鐘}}",
    'Home.ServerInfo.more' => '查看更多',
    'Home.Subscriptions.title' => '我的訂閱',
    'Home.Subscriptions.add' => '新增',
    'Home.Subscriptions.empty' => '建立訂閱資格，在伺服器的獨立空間成為多個網站的主機。%%link%%',
    'Home.Subscriptions.help' => '瞭解更多',
    'Home.Updates.version' => '%%editionName%% %%version%%',
    'Home.Updates.patch' => '%%version%%更新#%%patch%%',
    'Home.Updates.manageComponents' => '添加或移除組件',
    'Home.Updates.lastUpdated' => '上次更新時間：%%lastUpdateDate%%',
    'Home.Updates.checkUpdates' => '檢查更新',
    'Home.Updates.enableAutoupdate' => '允許自動更新',
    'Home.Updates.lastChecked' => '上次檢查時間：%%lastCheckDate%%',
    'Home.Updates.newVersionAvailable' => '%%availableVersion%%可使用',
    'Home.Updates.installNewVersion' => '現在安裝',
    'Home.Updates.patchAvailable' => '有小型更新可以使用',
    'Home.Updates.patchAvailableVersion' => '有%%currentVersion%%的小型更新可以使用',
    'Home.Updates.installPatch' => '現在更新',
    'Home.Updates.pumUpdates' => '{total, plural, =1 {有{package}的更新} other {有{package}的更新}}可以使用',
    'Home.Updates.pumPackages' => '{total, plural, =1 {{name} {availableVersion}} other {#個套裝程式}}',
    'Home.Updates.installUpdates' => '{total, plural, =1 {立即} other {全部}}更新',

    'HostingSettings.title' => '主機設定',
    'HostingSettings.updateSuccess' => '設定已更新。',
    'HostingSettings.emptyLogin' => '請指定用戶名。',
    'HostingSettings.emptyPassword' => '請指定密碼。',
    'HostingSettings.ipV6OnlyNotSupported' => 'FTP 伺服器不支援 IPv6。至少分配一個 IPv4 位址，不然用戶將無法通過 FTP 上傳檔到伺服器。',
    'HostingSettings.domainSettingsSection.sectionTitle' => '網域設定',
    'HostingSettings.domainSettingsSection.domainName' => '域名',
    'HostingSettings.domainSettingsSection.description' => '例如，example.com ',

    'HostingSettings.submitPopover.title' => '移除 %%website%% 的內容',
    'HostingSettings.submitPopover.descriptionMainDomain' => '將「網站」主機類型切換為「%%type%%」，將永久性地移除全部的網站內容，包括下列目錄：',
    'HostingSettings.submitPopover.descriptionSubDomain' => '您要更改網站的主機類型嗎？',

    'HostingSettings.domainSettingsSection.creatingWebspaceAlert' => '若想存取更多設定，請輸入系統使用者驗證憑據，接著點擊「建立網頁空間」。',
    'HostingSettings.domainSettingsSection.creatingHostingAlert' => '若想存取更多設定，請點擊「下一個」以建立主機。',
    'HostingSettings.domainSettingsSection.hostingTypeTitle' => '主機類型',
    'HostingSettings.domainSettingsSection.hostingType.title' => '類型',
    'HostingSettings.domainSettingsSection.hostingType.website' => '網站',
    'HostingSettings.domainSettingsSection.hostingType.forwarding' => '轉發',
    'HostingSettings.domainSettingsSection.hostingType.noHosting' => '無虛擬主機',
    'HostingSettings.domainSettingsSection.hostingType.noHostingHint' => '使用網域 DNS 區域可在這個網域名稱下擁有信箱',
    'HostingSettings.domainSettingsSection.hostingType.pathToTheWebsite' => '進入網站主目錄的路徑',
    'HostingSettings.domainSettingsSection.preferredDomainTitle' => '偏好域名',
    'HostingSettings.domainSettingsSection.preferredDomainDescription' => '訪客會透過 SEO 友善 HTTP 301 重新導向機制，被重新導向到此處。',
    'HostingSettings.domainSettingsSection.forwardVisitorsTo' => '將訪客轉移至',
    'HostingSettings.domainSettingsSection.forwardingType.title' => '轉發類型',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanently' => '永久移動（代碼 301）',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanentlyDescription' => '重定向網站訪客到其他網站並向他們顯示目的位址。此類重定向會保持網站搜尋的排名',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarily' => '暫時移動（代碼 302）',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarilyDescription' => '當您不想讓搜尋引擎索引此預備網站時，可重定向存取者到預備網站副本。',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwarding' => '幀轉發',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwardingDescription' => '重定向網站訪客到另一網站，但不向訪客顯示目標位址，讓訪客不知道被重定向。',
    'HostingSettings.domainSettingsSection.preferredDomain.title' => '偏好域名',
    'HostingSettings.domainSettingsSection.preferredDomain.none' => '無',
    'HostingSettings.domainSettingsSection.preferredDomain.www' => 'www.%%domainName%%',
    'HostingSettings.domainSettingsSection.documentRootTitle' => '文檔根目錄',
    'HostingSettings.domainSettingsSection.documentRootHint' => '因web應用程式安裝到此網站上，無法更改文檔根目錄。',
    'HostingSettings.domainSettingsSection.save' => '保存',
    'HostingSettings.domainSettingsSection.sameSsl.title' => '相容性模式',
    'HostingSettings.domainSettingsSection.sameSsl.enabled' => '在繼承選項 “分離 SSL/TLS 與非 SSL/TLS 內容”的相容模式下運行網站',
    'HostingSettings.domainSettingsSection.sameSsl.hint' => '這個網站處於相容性模式，你無法使用Plesk介面進行管理。這是因為你在升級前使用了棄用的「分離SSL/TLS與非SSL/TLS內容」選項。從Plesk 11開始，網站使用相同的目錄儲存在HTTP與HTTPS連線可用的內容。我們建議你將全部的資料從「httpsdocs/」目錄轉移至「httpdocs/」目錄，並關閉相容性模式。這樣一來，你就可以透過網際網路使用安裝在「httpsdocs/」目錄的應用程式。請注意，你後續將無法再次啟用相容性模式。',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogTitle' => '是否變更此設定？',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogDescription' => '變更此設定將與伺服器的安全政策發生衝突，可能會影響效能或導致伺服器變得容易受到攻擊。',
    'HostingSettings.domainSettingsSection.security.buttonChange' => '更改',
    'HostingSettings.domainSettingsSection.security.buttonRevert' => '還原',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetApplied' => '已套用安全設定預設',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetMessage' => '如果要改良安全性，請套用安全的預設設定。請注意：部分許可能夠讓訂閱者變更這些設定。',
    'HostingSettings.domainSettingsSection.security.applySecureSettingsPreset' => '套用安全預設',
    'HostingSettings.domainSettingsSection.security.exploreSecureSettings' => '瞭解安全主機設定',
    'HostingSettings.domainSettingsSection.security.sslTlsSupport' => 'SSL/TLS 支援',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportEnabled' => '已啟用',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportDescription' => '網站與訪客瀏覽器之間的加密連線。',
    'HostingSettings.domainSettingsSection.security.certificate' => '證書',
    'HostingSettings.domainSettingsSection.security.certificateDescription' => '如果要啟用 HTTPS，請上傳 SSL/TLS 證書至網域 Repository，然後在此選擇。',
    'HostingSettings.domainSettingsSection.security.permanentRedirect' => '透過 SEO 友善 301 重新導向機制，從 HTTP 將訪客重新導向至 HTTPS',
    'HostingSettings.domainSettingsSection.security.noCertificates' => '在您的 repository 中沒有 SSL/TLS 證書。要添加證書請進入 %%link%%。',
    'HostingSettings.domainSettingsSection.security.noCertificatesLink' => '此頁面',
    'HostingSettings.domainSettingsSection.security.certificateFromDomainRepository' => '%%name%% (%%repository%%)',
    'HostingSettings.domainSettingsSection.security.certificateFromOtherRepository' => '%%name%%（其他庫）',
    'HostingSettings.domainSettingsSection.security.certificateNotSelected' => '未選定',
    'HostingSettings.domainSettingsSection.webScripting.title' => 'Web 腳本',
    'HostingSettings.domainSettingsSection.webScripting.description' => '選擇哪些程式編碼與腳本語言必須要透過網頁伺服器解讀。',
    'HostingSettings.domainSettingsSection.webScripting.fastCgi' => 'FastCGI',
    'HostingSettings.domainSettingsSection.webScripting.cgi' => 'CGI',
    'HostingSettings.domainSettingsSection.webScripting.cgiReadonly' => 'cgi-bin目錄位於%%value%%',
    'HostingSettings.domainSettingsSection.webScripting.ssi' => 'SSI',
    'HostingSettings.domainSettingsSection.webScripting.ssiHtml' => '在 htm 和 html 檔中使用 SSI',
    'HostingSettings.domainSettingsSection.webScripting.asp' => 'Microsoft ASP',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNet' => 'Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNetVersion' => 'Microsoft ASP.NET 版本',
    'HostingSettings.domainSettingsSection.webScripting.perl' => 'Perl',
    'HostingSettings.domainSettingsSection.webScripting.python' => 'Python',
    'HostingSettings.domainSettingsSection.webScripting.customErrorDocuments' => '自訂錯誤文檔',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.title' => 'cgi-bin目錄位於',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.wwwRoot' => '此域名的文檔根',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.webspace' => '主機空間的根目錄',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.oldStyle' => '該域名舊式的根目錄',
    'HostingSettings.domainSettingsSection.webScripting.errorDocs' => '自訂錯誤文檔',
    'HostingSettings.domainSettingsSection.webScripting.writeModify' => '其他寫入/修改許可權',
    'HostingSettings.domainSettingsSection.webScripting.webDeploy' => 'Web Deploy 發佈',
    'HostingSettings.domainSettingsSection.webStatistics.title' => '網站統計',
    'HostingSettings.domainSettingsSection.webStatistics.tool' => '工具',
    'HostingSettings.domainSettingsSection.webStatistics.webstatProtected' => '使用您的 FTP 用戶名和密碼對您的網站統計存取權限加以保護',
    'HostingSettings.domainSettingsSection.webStatistics.disabled' => '禁用',

    'HostingSettings.webspaceSettingsSection.sectionTitle' => '主機空間設定',
    'HostingSettings.webspaceSettingsSection.ipAddresses' => 'IP 地址',
    'HostingSettings.webspaceSettingsSection.quota.title' => '磁碟空間配額',
    'HostingSettings.webspaceSettingsSection.quota.enabled' => '已啟用',
    'HostingSettings.webspaceSettingsSection.quota.description' => '如果超過訂閱設定中的磁碟空間配額（若有），則禁止網站檔案執行。',
    'HostingSettings.webspaceSettingsSection.quota.unlimitedDesc' => '伺服器檔案系統配置不支援硬碟空間配額。',
    'HostingSettings.webspaceSettingsSection.quota.mbUnits' => 'MB',
    'HostingSettings.webspaceSettingsSection.quota.readonly' => '%%quota%% MB',
    'HostingSettings.webspaceSettingsSection.systemUser' => '系統使用者驗證憑據',
    'HostingSettings.webspaceSettingsSection.systemUserUnixDesc' => '透過 FTP 或檔案管理員管理網站的檔案與資料夾。如果允許，則透過 SSH 存取伺服器。',
    'HostingSettings.webspaceSettingsSection.systemUserWinDesc' => '透過 FTP 或檔案管理員管理網站的檔案與資料夾。如果允許，則透過遠程桌面存取伺服器。',
    'HostingSettings.webspaceSettingsSection.systemUserLogin' => '用戶名',
    'HostingSettings.webspaceSettingsSection.systemUserPasswd' => '密碼',
    'HostingSettings.webspaceSettingsSection.systemUserPasswdDesc' => '在此指定一組新的密碼，以變更伺服器使用者的密碼。',
    'HostingSettings.webspaceSettingsSection.shell.unixTitle' => 'SSH 存取',
    'HostingSettings.webspaceSettingsSection.shell.winTitle' => '遠端桌面存取',
    'HostingSettings.webspaceSettingsSection.shell.enabled' => '已啟用',
    'HostingSettings.webspaceSettingsSection.shell.description' => "存取有系統使用者憑證的伺服器。",
    'HostingSettings.webspaceSettingsSection.shell.type' => '類型',
    'HostingSettings.webspaceSettingsSection.shell.disabled' => '禁用',
    'HostingSettings.webspaceSettingsSection.affectedDomainsLabel' => '適用：{count, plural, other {#網域}}',
    'HostingSettings.webspaceSettingsSection.affectedDomainsDescription' => '下列設定雙向適用於所有的{count, plural, other {#{name}網頁空間的網域}}：',

    'OdbcAdd.title' => '添加 ODBC DSN',
    'OdbcAdd.nameLabel' => '連接名',
    'OdbcAdd.descriptionLabel' => '連接描述',
    'OdbcAdd.driver' => '驅動程式',
    'OdbcAdd.submit' => '建立 ODBC DSN',

    'OdbcEdit.title' => 'ODBC連接配置',
    'OdbcEdit.saveSuccess' => '連線設定儲存成功。',
    'OdbcEdit.test' => '測試連線',
    'OdbcEdit.connectSuccess' => '連接成功。',

    'OdbcEdit.excel.driver.label' => '驅動程式',
    'OdbcEdit.excel.dbq.label' => '資料庫檔路徑',
    'OdbcEdit.excel.defaultdir.label' => '預設資料路徑',
    'OdbcEdit.excel.fil.label' => '資料庫版本',
    'OdbcEdit.excel.maxbuffersize.label' => '緩衝區最大值',
    'OdbcEdit.excel.pagetimeout.label' => '頁面超時',

    'OdbcEdit.access.driver.label' => '驅動程式',
    'OdbcEdit.access.dbq.label' => '資料庫檔路徑',
    'OdbcEdit.access.uid.label' => '登入 ID',
    'OdbcEdit.access.pwd.label' => '密碼',
    'OdbcEdit.access.pagetimeout.label' => '頁面超時',
    'OdbcEdit.access.pagetimeout.description' => '未使用頁面在緩存中保留的時段以 0.1 秒計。該選項適用於所有使用 Microsoft Access 驅動程式的資料來源。',
    'OdbcEdit.access.maxbuffersize.label' => '緩衝區最大值',
    'OdbcEdit.access.maxbuffersize.description' => '內部緩衝區的大小，以 KB 計，按 256 KB 的單位排列。',
    'OdbcEdit.access.readonly.label' => '唯讀',
    'OdbcEdit.access.readonly.description' => '將資料庫指定為唯讀狀態以禁止任何升級。',
    'OdbcEdit.access.exclusive.label' => '專屬',
    'OdbcEdit.access.exclusive.description' => '將資料庫指定為獨佔狀態以禁止共用更新。',
    'OdbcEdit.access.safetransactions.label' => '安全交易',
    'OdbcEdit.access.safetransactions.description' => '如果是預設值 0，所有的事務會立即 commit。如果是 1，所有的事務會通過一次 commit 操作保存到硬碟，但是性能將會略微下降。',
    'OdbcEdit.access.threads.label' => '執行緒',
    'OdbcEdit.access.threads.description' => '引擎要使用的後臺執行緒數量。',
    'OdbcEdit.access.maxscanrows.label' => '最大掃描行數',
    'OdbcEdit.access.maxscanrows.description' => '根據現有資料設定列的資料類型時，要掃描的行數。',
    'OdbcEdit.access.implicitcommitsync.label' => 'ImplicitCommitSync',
    'OdbcEdit.access.implicitcommitsync.description' => '指定事務外部更改如何寫入資料庫中。',
    'OdbcEdit.access.usercommitsync.label' => 'UserCommitSync',
    'OdbcEdit.access.usercommitsync.description' => '指定 MS Access 驅動程式是否顯式同步執行使用者定義的事務。',

    'OdbcEdit.mssql.driver.label' => '驅動程式',
    'OdbcEdit.mssql.server.label' => '伺服器',
    'OdbcEdit.mssql.uid.label' => '登入 ID',
    'OdbcEdit.mssql.pwd.label' => '密碼',
    'OdbcEdit.mssql.database.label' => '預設資料庫',
    'OdbcEdit.mssql.app.label' => '應用程式名稱',
    'OdbcEdit.mssql.wsid.label' => '工作站ID',
    'OdbcEdit.mssql.language.label' => '預設語言',
    'OdbcEdit.mssql.oemtoansi.label' => '此參數指定了是否將擴充字元轉換為OEM值',

    'OdbcEdit.mysql.driver.label' => 'MySQL ODBC驅動程式',
    'OdbcEdit.mysql.server.label' => '伺服器',
    'OdbcEdit.mysql.server.description' => 'MySQL伺服器的主機名稱',
    'OdbcEdit.mysql.database.label' => '預設資料庫',
    'OdbcEdit.mysql.user.label' => '用戶名',
    'OdbcEdit.mysql.user.description' => '用於連接到MySQL的用戶名',
    'OdbcEdit.mysql.password.label' => '密碼',
    'OdbcEdit.mysql.password.description' => '伺服器上的使用者帳戶密碼',
    'OdbcEdit.mysql.port.label' => '埠',
    'OdbcEdit.mysql.port.description' => '如果伺服器不是本地主機，則使用TCP/IP埠',
    'OdbcEdit.mysql.socket.label' => '通訊端',
    'OdbcEdit.mysql.socket.description' => '如果伺服器是本地主機，Windows將使用具名管道來連接',
    'OdbcEdit.mysql.option.label' => '選項',
    'OdbcEdit.mysql.option.description' => '這些選項可設定 MyODBC 的運作方式，請見<a target="_blank" href="https://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">文件</a>',

    'ProtectedDirectoryList.title' => '%%domainName%% 的受保護的目錄',
    'ProtectedDirectoryList.add' => '添加受保護目錄',
    'ProtectedDirectoryList.addTooltip' => '創建受保護目錄。',
    'ProtectedDirectoryList.name' => '名稱',
    'ProtectedDirectoryList.realmTitle' => '受保護區的標題',
    'ProtectedDirectoryList.noSelectionText' => '選擇要移除的一個或多個項目。',
    'ProtectedDirectoryList.edit' => '編輯',
    'ProtectedDirectoryList.remove' => '移除受保護內容',
    'ProtectedDirectoryList.removeTooltip' => '移除所選目錄的保護機制。',
    'ProtectedDirectoryList.removeConfirmation' => '此操作將導致 {count, plural, =1 {{name} 個所選目錄} other {# 個所選目錄}}不受保護。網路使用者將能自由存取{count, plural, =1 {此目錄} other {這些目錄}}。',
    'ProtectedDirectoryList.removeSuccess' => '所選目錄已遭移除。',

    'ProtectedDirectoryAdd.title' => '創建受保護目錄',
    'ProtectedDirectoryAdd.submit' => '創建',
    'ProtectedDirectoryAdd.success' => '成功創建受保護目錄%%path%%',

    'ProtectedDirectoryEdit.title' => '受保護的目錄設定',
    'ProtectedDirectoryEdit.success' => '已更改受保護目錄設定',

    'ProtectedDirectoryUserList.title' => '%%directory%% 使用者受保護的目錄',
    'ProtectedDirectoryUserList.add' => '添加用戶',
    'ProtectedDirectoryUserList.addTooltip' => '建立能夠存取受保護的目錄（%%directory%%）的使用者帳戶',
    'ProtectedDirectoryUserList.login' => '名稱',
    'ProtectedDirectoryUserList.changePassword' => '更改密碼',
    'ProtectedDirectoryUserList.noSelectionText' => '選擇要移除的一個或多個使用者。',
    'ProtectedDirectoryUserList.remove' => '移除',
    'ProtectedDirectoryUserList.removeTooltip' => '刪除所選使用者。',
    'ProtectedDirectoryUserList.removeConfirmation' => '是否移除其他 {count, plural, =1 {the {login} 個使用者} other {# 個使用者}}？',
    'ProtectedDirectoryUserList.removeSuccess' => '使用者已被移除。',

    'ProtectedDirectoryUserAdd.title' => '創建受保護目錄使用者',
    'ProtectedDirectoryUserAdd.subtitle' => '目錄%%directory%%',
    'ProtectedDirectoryUserAdd.loginLabel' => '用戶名',
    'ProtectedDirectoryUserAdd.passwordLabel' => '密碼',
    'ProtectedDirectoryUserAdd.submit' => '創建',
    'ProtectedDirectoryUserAdd.success' => '受保護的目錄使用者 %%login%% 建立成功。',

    'ProtectedDirectoryUserPassword.title' => '受保護的目錄使用者的密碼',
    'ProtectedDirectoryUserPassword.subtitle' => '使用者 %%login%%',
    'ProtectedDirectoryUserPassword.passwordLabel' => '密碼',
    'ProtectedDirectoryUserPassword.submit' => '保存',
    'ProtectedDirectoryUserPassword.success' => '已保存用戶憑證。',

    'SummaryReport.Layout.title' => '報告佈局屬性',
    'SummaryReport.Layout.success' => '報告佈局%%name%%已更新。',
    'SummaryReport.Layouts.title' => '報告佈局',

    'SummaryReport.Layout.Add.title' => '創建報告佈局',
    'SummaryReport.Layout.Add.success' => '報告佈局%%name%%已更新。',

    'SummaryReport.Report.title' => '概要報告',
    'SummaryReport.Report.buttonLayouts' => '配置',
    'SummaryReport.Report.buttonSchedule' => '計畫',
    'SummaryReport.Report.buttonProperties' => '屬性',
    'SummaryReport.Report.buttonTrafficHistory' => '流量歷史',
    'SummaryReport.Report.buttonPrint' => '列印',
    'SummaryReport.Report.buttonSend' => '通過電子郵件發送',
    'SummaryReport.Report.successSent' => '報告已發送給%%email%%',

    'SummaryReport.Schedule.title' => '%%name%% 的發送計畫',
    'SummaryReport.Schedule.Properties.title' => '%%name%% 的發送計畫',
    'SummaryReport.Schedule.Properties.success' => '報告發送計畫已更新。',

    'SummaryReport.Schedule.Add.title' => '建立 %%name%% 的發送計畫',
    'SummaryReport.Schedule.Add.success' => '已創建報告發送計畫。',

    'SummaryReport.TrafficHistory.title' => '流量歷史',

    'VirtualDirectory.title' => '虛擬目錄：%%path%%/%%domainName%%',
    'VirtualDirectory.errNotExist' => '該虛擬目錄連結到不存在的物理資料夾。',
    'VirtualDirectory.errNoPermissions' => '您不具有流覽此目錄內容的許可權。',
    'VirtualDirectory.buttonProperties' => '目錄屬性',
    'VirtualDirectory.buttonPropertiesHint' => '查看和更改虛擬目錄屬性。',
    'VirtualDirectory.buttonPermissions' => '目錄存取權限',
    'VirtualDirectory.buttonPermissionsHint' => '設定目錄存取權限。',
    'VirtualDirectory.buttonAspDotNet' => 'ASP.NET',
    'VirtualDirectory.buttonAspDotNetHint' => '配置 ASP.NET 設定。',
    'VirtualDirectory.buttonPhp' => 'PHP',
    'VirtualDirectory.buttonPhpHint' => '配置 PHP 設定。',
    'VirtualDirectory.buttonMimeTypes' => 'MIME類型',
    'VirtualDirectory.buttonMimeTypesHint' => '管理已註冊的 MIME 類型。',
    'VirtualDirectory.buttonErrorDocs' => '錯誤文檔',
    'VirtualDirectory.buttonErrorDocsHint' => '管理錯誤檔案。',
    'VirtualDirectory.buttonProtection' => '保護',
    'VirtualDirectory.buttonProtectionHint' => '使用密碼限制存取目錄。',

    'VirtualDirectory.CreateDirectory.title' => '創建目錄',
    'VirtualDirectory.CreateDirectory.name' => '目錄名稱',
    'VirtualDirectory.CreateDirectory.success' => '目錄 %%name%% 建立成功。',
    'VirtualDirectory.CreateDirectory.errExists' => '目錄 %%name%% 已存在。',

    'VirtualDirectory.AspDotNet.title' => '配置 ASP.NET 設定',

    'VirtualDirectory.Php.title' => 'PHP 版本',
    'VirtualDirectory.Php.version' => '版本',
    'VirtualDirectory.Php.success' => 'PHP 版本已更新。',
];