<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.

$messages = [
    'additional-key-info.title' => 'Свойства дополнительного ключа',
    'additional-key-info.update' => 'Получить дополнительный ключ',
    'additional-key-info.updateDescription' => 'Получить дополнительный ключ и установить его.',
    'additional-key-info.download' => 'Скачать ключ',
    'additional-key-info.downloadDescription' => 'Загрузить текущий ключ лицензии.',
    'additional-key-info.install' => 'Установить ключ',
    'additional-key-info.installDescription' => 'Установить текущий ключ лицензии.',
    'additional-key-info.revert' => 'Откат ключа',
    'additional-key-info.revertDescription' => 'Вернуться к предыдущему ключу лицензии.',
    'additional-key-info.revertNotAvailableDescription' => 'Ключ не установлен',
    'additional-key-info.installSuccess' => 'Процедура установки лицензионного ключа запущена.',

    'additional-key-revert.title' => 'Возврат к предыдущему дополнительному ключу',
    'additional-key-revert.success' => 'Вы вернулись к предыдущему дополнительному ключу.',

    'additional-key-upload.title' => 'Установить ключ лицензии',
    'additional-key-upload.success' => 'Новый дополнительный ключ был загружен',

    'additional-keys.title' => 'Дополнительные лицензионные ключи',

    'change-owner.title' => 'Назначить нового владельца для выбранных подписок',

    'customers.hint' => 'На этой странице вы можете управлять учетными записями своих хостинг-клиентов: создавать новые учетные записи с подписками, управлять существующими клиентами и удалять учетные записи. Для управления сайтами, почтой и другими услугами того или иного клиента перейдите в его Панель клиента, нажав на соответствующую ссылку в колонке справа.',

    'customer-domains.hint' => 'Здесь вы можете создавать сайты и управлять ими.',

    'customer-subscriptions.hint' => 'Здесь вы можете управлять подписками данного клиента.',

    'domains.hint' => 'Здесь вы можете просматривать информацию обо всех доменах, зарегистрированных в системе, и можете перейти к управлению услугами хостинга. Чтобы добавить домен для себя или обслуживаемых клиентов, нажмите "Добавить домен". При создании домена вам будет предложено создать нового клиента или подписку или выбрать из существующих.',

    'database-servers.title' => 'Серверы баз данных',

    'database-server-create.title' => 'Новый сервер баз данных',

    'database-server-properties.title' => 'Сервер баз данных',

    'database-server-upgrade.drawerTitle' => 'Обновление MariaDB',
    'database-server-upgrade.drawerTitle.completed' => 'Обновление завершено',
    'database-server-upgrade.drawerSubTitle.line1' => 'Боковое меню нельзя закрыть, когда выполняется обновление.',
    'database-server-upgrade.drawerSubTitle.line2' => 'Если во время обновления возникнут проблемы, см. %%troubleshootingArticle%%.',
    'database-server-upgrade.drawerSubTitle.completed' => 'Сервер баз данных MariaDB был обновлен до версии %%releaseVersion%%. Если у вас возникнут проблемы, см. %%troubleshootingArticle%%.',
    'database-server-upgrade.upToDate' => 'У вас уже установлена версия LTS.',
    'database-server-upgrade.troubleshootingArticle' => 'эту статью базы знаний',
    'database-server-upgrade.troubleshootingArticleDescription' => 'Для устранения проблем, связанных с обновлением MariaDB, см. %%troubleshootingArticle%%.',

    'database-server-upgrade.chooseReleaseStep.infoBlock.par1' => 'Обновите свой локальный сервер баз данных MariaDB до текущей версии с долгосрочной поддержкой (LTS).',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par2' => 'Мы настоятельно рекомендуем перед обновлением создать резервную копию сервера и начать обновление в непиковые часы работы сервера.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par3' => 'Во время обновления MariaDB сервер Plesk и размещенные на нем сайты будут недоступны. Обновление MariaDB обычно выполняется без ошибок и занимает около 10 минут, однако может повлиять на работу всего сервера.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par4' => 'Примечание. Если у вас установлена версия MariaDB 5.5, Plesk сначала обновит ее до MariaDB 10.5. После завершения обновления снова запустите этот мастер, чтобы выполнить обновление до текущей LTS-версии MariaDB.',
    'database-server-upgrade.chooseReleaseStep.currentVersionTitle' => 'Текущая версия',
    'database-server-upgrade.chooseReleaseStep.currentMariaDBVersion' => 'MariaDB %%version%%',
    'database-server-upgrade.chooseReleaseStep.selectVersion' => 'Выберите версию, до которой требуется обновить',
    'database-server-upgrade.chooseReleaseStep.noMajorReleases' => 'Нет основных версий',
    'database-server-upgrade.chooseReleaseStep.releaseNotes' => 'Заметки о выпуске',
    'database-server-upgrade.chooseReleaseStep.releaseDate' => 'Дата выпуска: %%date%%',
    'database-server-upgrade.chooseReleaseStep.endOfLifeDate' => 'Дата окончания поддержки: %%date%%',
    'database-server-upgrade.chooseReleaseStep.notDetected' => 'Обновить можно только ветки MariaDB, предоставленные поставщиками ОС или разработчиком MariaDB.',

    'database-server-upgrade.preUpgradeCheckProgressStep.title' => 'Предварительные проверки',
    'database-server-upgrade.preUpgradeCheckProgressStep.configChecker' => 'Разбор конфигурационных файлов MariaDB',
    'database-server-upgrade.preUpgradeCheckProgressStep.mysqlChecker' => 'Анализ баз данных с помощью mysqlcheck',
    'database-server-upgrade.preUpgradeCheckProgressStep.webSocketChecker' => 'Проверка WebSocket',

    'database-server-upgrade.preUpgradeCheckStep.shouldBeConfirmed' => 'Поставьте все флажки, чтобы продолжить обновление. Так вы подтвердите, что принимаете все изменения конфигурации, которые будут сделаны во время обновления, и у вас имеется доступ к средствам восстановления.',
    'database-server-upgrade.preUpgradeCheckStep.removedSystemVariables' => 'Для обеспечения совместимости с новой версией будут удалены следующие переменные:',
    'database-server-upgrade.preUpgradeCheckStep.fromFiles' => '{variable} из {count, plural, one {# файла: {files}} few {# файлов: {files}} many {# файлов: {files}} other {# файла: {files}}}',
    'database-server-upgrade.preUpgradeCheckStep.accessToolsSection' => 'Доступ к средствам восстановления (консоль командной строки сервера и Repair Kit)',
    'database-server-upgrade.preUpgradeCheckStep.sshAccess' => 'Я подтверждаю, что у меня имеется доступ к серверу по SSH',
    'database-server-upgrade.preUpgradeCheckStep.sshAccessDescription' => 'Используйте SSH-клиент или откройте %%sshTerminalExtension%% в новой вкладке браузера (не закрывайте окно с расширением SSH Terminal до завершения обновления). В случае проблем с обновлением открытый сеанс SSH поможет выполнить восстановление.',
    'database-server-upgrade.preUpgradeCheckStep.sshTerminalExtension' => 'Расширение SSH Terminal',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccess' => 'Я подтверждаю, что у меня имеется доступ к Repair Kit',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccessDescription' => 'Откройте %%repairKit%% в новой вкладке браузера и войдите под учетной записью администратора. Не закрывайте окно с расширением Repair Kit до завершения обновления.',
    'database-server-upgrade.preUpgradeCheckStep.repairKit' => 'Repair Kit',
    'database-server-upgrade.preUpgradeCheckStep.dumpSection' => 'Создать резервную копию баз данных',
    'database-server-upgrade.preUpgradeCheckStep.withDump' => 'Перед обновлением создайте резервные копии всех баз данных, размещенных на сервере',
    'database-server-upgrade.preUpgradeCheckStep.withDumpDescription' => 'Plesk хранит резервные копии баз данных в папке %%path%%.',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailable' => 'WebSocket в Plesk недоступен',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailableDescription' => 'Без WebSocket вы не сможете видеть в режиме реального времени вывод процесса обновления.',

    'database-server-upgrade.submitPopover.title' => 'В целях предотвращения потери данных мы настоятельно рекомендуем перед продолжением создать дамп размещенных на сервере баз данных. Продолжить без создания дампа?',

    'database-server-databases.title' => 'Базы данных',

    'database-server-change-password.title' => 'Пароль администратора',

    'home.title' => 'Главная',

    'license.title' => 'Информация о лицензии',

    'primary-key-info.title' => 'Ключ лицензии Plesk',
    'primary-key-info.update' => 'Получить ключи',
    'primary-key-info.updateDescription' => 'Получить заказанные лицензионные ключи и установить их.',
    'primary-key-info.upload' => 'Установить ключ',
    'primary-key-info.uploadDescription' => 'Загрузить и установить новый ключ лицензии.',
    'primary-key-info.revert' => 'Откат ключа',
    'primary-key-info.revertDescription' => 'Вернуться к предыдущему ключу лицензии.',

    'primary-key-revert.title' => 'Возврат к предыдущему лицензионному ключу',
    'primary-key-revert.success' => 'Вы вернулись к предыдущему ключу Plesk.',

    'primary-key-upload.title' => 'Установить ключ лицензии',
    'primary-key-upload.success' => 'Новый ключ Plesk загружен.',

    'resellers.hint' => 'Здесь вы можете управлять учетными записями реселлеров — ваших клиентов, которые перепродают услуги хостинга и размещают собственные сайты. Здесь вы можете создавать учетные записи с подписками, управлять существующими реселлерами и удалять учетные записи.',

    'reseller-customers.hint' => 'Здесь вы можете создавать учетные записи клиентов и управлять ими.',

    'reseller-domains.hint' => 'Здесь вы можете создавать сайты и управлять ими.',

    'reseller-subscriptions.hint' => 'Здесь вы можете управлять подписками данного реселлера.',

    'subscriptions.hint' => 'Для того чтобы воспользоваться вашими услугами хостинга, клиентам необходимо подписаться на один из ваших хостинг-планов. На этой странице вы можете управлять такими подписками, а также подписками, которые вы создали для хостинга собственных сайтов. Для управления сайтами, почтой и другими услугами в рамках той или иной подписки перейдите в Панель клиента конкретного подписчика, нажав на соответствующую ссылку в колонке справа.',

    'server-mail-settings.title' => 'Настройки',
    'server-mail-spam-filter.title' => 'Антиспам',
    'server-mail-antivirus.title' => 'Антивирус',
    'server-mail-black-list.title' => 'Черный список',
    'server-mail-white-list.title' => 'Белый список',
    'server-mail-queue.title' => 'Очередь почтовых сообщений',
    'server-mail-statistics.title' => 'Статистика',

    'server-spam-filter.title' => 'Настройки антиспама',
    'server-spam-filter.settings' => 'Настройки',
    'server-spam-filter.black-list' => 'Черный список',
    'server-spam-filter.white-list' => 'Белый список',

    'firewall.title' => 'Управление брандмауэром',
    'firewall-general.title' => 'Общие',
    'firewall-general.toggleStatus' => 'Защита брандмауэра',
    'firewall-general.buttonDefault' => 'Вернуться к значениям по умолчанию',
    'firewall-general.buttonPanic' => 'Панический режим',
    'firewall-general.confirmationDefault' => 'Сбросить настройки брандмауэра на значения по умолчанию?',
    'firewall-general.confirmationPanic' => 'Включить режим максимальной защиты? Пользователи не смогут получить доступ к своим доменам, а некоторые сетевые службы могут перестать работать.',
    'firewall-general.successDefault' => 'Настройки брандмауэра были сброшены на значения по умолчанию.',
    'firewall-general.successPanic' => 'Режим максимальной защиты включен.',
    'firewall-general.info' => 'В целях безопасности брандмауэр блокирует все подключения, кроме специально разрешенных. Вы можете разрешить подключение, создав правило. Более подробную информацию смотрите в документации.',
    'firewall-general.interfaces' => 'сетевых интерфейсов',
    'firewall-icmp.title' => 'Протокол ICMP',
    'firewall-rules.title' => 'Правила брандмауэра',

    'dns.title' => 'Настройки DNS',
    'dns-records.title' => 'Шаблон записей зоны',
    'dns-soa-record.title' => 'Шаблон настроек зоны',

    'php-handler.title' => 'Настройки для %%name%%',
    'php-handler.extensions.title' => 'Расширения',
    'php-handler.extensions.description' => 'Эти настройки библиотек PHP действуют только для этого обработчика.',
    'php-handler.extensions.descriptionShared' => 'Эти настройки являются общими для следующих обработчиков PHP: %%handlers%%. Настройки действуют для всех сайтов, использующих эти обработчики.',
    'php-handler.extensions.buttonManage' => 'Управление пакетами PECL',
    'php-handler.extensions.manage.title' => 'Управление пакетами PECL',
    'php-handler.extensions.manage.risks' => 'Расширения PHP представлены в сторонних пакетах PECL. Вы устанавливаете их под свою ответственность.',
    'php-handler.extensions.manage.description' => 'Устанавливайте, улучшайте и удаляйте пакеты PECL. Изменения будут применены для всех сайтов, работающих на %%handlers%%.',
    'php-handler.extensions.manage.notFound' => 'Почему желаемого пакета нет в списке?',
    'php-handler.extensions.manage.limitations' => 'В списке не отражены расширения PHP, предоставленные провайдером панели управления и поставщиками ОС.',
    'php-handler.php-ini.title' => 'php.ini',


    'ServerInformation.title' => "Сведения о сервере",
    'ServerInformation.refresh' => "Обновить",
    'ServerInformation.sectionGeneral' => "Общие",
    'ServerInformation.cpu' => "Процессор",
    'ServerInformation.version' => "Версия",
    'ServerInformation.os' => "Операционная система",
    'ServerInformation.key' => "Ключ лицензии Plesk",
    'ServerInformation.uptime' => "Время непрерывной работы",
    'ServerInformation.uptimeValue' => "{days, plural, =0 {} one {# день} few {# дня} many {# дней} other {# день}} {hours, plural, one {# час} few {# часа} many {# часов} other {# час}} {minutes, plural, one {# минута} few {# минуты} many {# минут} other {# минута}}",
    'ServerInformation.sectionCpu' => "Загрузка процессора",
    'ServerInformation.la1min' => "За последнюю минуту",
    'ServerInformation.la5min' => "За последние 5 минут",
    'ServerInformation.la15min' => "За последние 15 минут",
    'ServerInformation.sectionMemory' => "Использование памяти",
    'ServerInformation.memoryTotal' => "Всего",
    'ServerInformation.memoryUsed' => "Используется",
    'ServerInformation.memoryFree' => "Бесплатная",
    'ServerInformation.memoryShared' => "Общие",
    'ServerInformation.memoryBuffer' => "Буфер",
    'ServerInformation.memoryCached' => "Кэш",
    'ServerInformation.memoryAvailable' => "Доступна",
    'ServerInformation.memoryUsage' => "Использование",
    'ServerInformation.sectionSwap' => "Использование подкачки",
    'ServerInformation.sectionVirtualMemory' => "Использование виртуальной памяти",
    'ServerInformation.swapTotal' => "Всего",
    'ServerInformation.swapUsed' => "Используется",
    'ServerInformation.swapFree' => "Бесплатная",
    'ServerInformation.swapUsage' => "Использование",
    'ServerInformation.sectionHarddisk' => "Использование места на жестком диске",
    'ServerInformation.harddiskDirectory' => "Файловая система",
    'ServerInformation.harddiskProtectedDir' => "Защищенные папки",
    'ServerInformation.harddiskTotal' => "Всего",
    'ServerInformation.harddiskUsed' => "Используется",
    'ServerInformation.harddiskAvailable' => "Доступна",
    'ServerInformation.harddiskCapacity' => "Объем",
    'ServerInformation.sectionDomains' => "Домены",
    'ServerInformation.activeDomains' => "Активные",
    'ServerInformation.inactiveDomains' => "Неактивные",
    'ServerInformation.problemDomains' => "Проблемы",
    'ServerInformation.refreshed' => "Информация обновлена.",

    'ServerAbout.title' => 'О Plesk',
    'ServerAbout.copyright' => '© 2024 WebPros International GmbH. Все права защищены.',
    'ServerAbout.linkLicenseManagement' => 'Перейти к информации о лицензии',
    'ServerAbout.panelVersion' => 'Версия',
    'ServerAbout.installedPatchVersion' => 'Обновление #%%patch%%',
    'ServerAbout.licenseKey' => 'Ключ лицензии',
    'ServerAbout.productDescription' => 'Plesk - ведущая платформа WebOps для запуска, автоматизации и масштабирования приложений, сайтов и хостингового бизнеса.',
    'ServerAbout.readEula' => 'Читать %%link%%.',
    'ServerAbout.linkEula' => 'Лицензионное соглашение с конечным пользователем',
    'ServerAbout.visitForum' => 'Посмотреть %%link%%',
    'ServerAbout.linkForum' => 'Форум Plesk',
    'ServerAbout.followUs' => 'Следите за нами',
    'ServerAbout.visitSite' => 'Узнать больше на %%link%%',
    'ServerAbout.linkSite' => 'plesk.com',
    'ServerAbout.visitBlog' => 'Искать вдохновения на %%link%%',
    'ServerAbout.linkBlog' => 'Блог Plesk',

    'ServerAbout.darkThemePromoTitle' => 'Поздравляем!',
    'ServerAbout.darkThemePromoDescription' => 'Вы нашли волшебного кисулькена в юбилейной версии Plesk Obsidian 18.0.50.',
    'ServerAbout.darkThemePromoButton' => 'Вжух! Переходи на темную сторону',
    'ServerAbout.darkThemeTourDescription' => 'С помощью этой опции можно включить или отключить темную тему интерфейса.',
    'ServerAbout.darkThemeTourButton' => 'Понятно',

    'ts-sessions.title' => 'Удаленные сеансы',
    'ts-sessions-properties.title' => 'Свойства сеанса',

    'BandwidthLimiting.title' => 'Пропускной лимит для %%domainName%%',
    'BandwidthLimiting.bandwidthThrottling' => 'Вы не можете управлять пропускной способностью, потому что не установлено QoS.',
    'BandwidthLimiting.virtualHostingRequired' => 'Пропускная способность доступна только для доменов с веб-хостингом.',
    'BandwidthLimiting.bandwidthLabel' => 'Максимальный объем трафика',
    'BandwidthLimiting.bandwidthHint' => 'Ограничение трафика распространяется только на данные, передаваемые по протоколу HTTP.',
    'BandwidthLimiting.maxConnectionLabel' => 'Количество соединений',
    'BandwidthLimiting.maxConnectionHint' => 'Если вы ограничиваете трафик, мы рекомендуем также ограничить число одновременных подключений к сайту. Иначе в случае частых обращений к сайту процессы веб-сервера увеличат нагрузку на сервер.',
    'BandwidthLimiting.kbps' => 'Кб/с',
    'BandwidthLimiting.success' => 'Изменены настройки пропускного лимита.',
    'BandwidthLimiting.unlimited' => 'Без ограничений',

    'ip-address-domains.title' => 'Сайты, использующие %%type%% IP-адрес %%ipAddress%%',
    'ip-address-domains.site' => 'Сайт',
    'ip-address-domains.setAsDefault' => 'Установить по умолчанию',
    'ip-address-domains.type-SHARED' => 'общий',
    'ip-address-domains.type-EXCLUSIVE' => 'выделенный',

    'HotlinkProtection.title' => 'Защита от хотлинкинга для %%domainName%%',
    'HotlinkProtection.virtualHostingRequired' => 'Защита от хотлинкинга доступна только для доменов с веб-хостингом.',
    'HotlinkProtection.enabledLabel' => 'Включить защиту от хотлинкинга',
    'HotlinkProtection.extensionsLabel' => 'Расширения защищенных файлов',
    'HotlinkProtection.friendsLabel' => 'Адреса надежных сайтов',
    'HotlinkProtection.success' => 'Настройки защиты от хотлинкинга были изменены.',

    'Odbc.serverTitle' => 'Соединения ODBC DSN',
    'Odbc.domainTitle' => 'Соединения ODBC DSN для %%domainName%%',
    'Odbc.add' => 'Добавить ODBC DSN',
    'Odbc.resourceUsage' => '%%used%% создано / %%allowed%% разрешено.',
    'Odbc.limitExceeded' => 'Превышен лимит соединений ODBC DSN.',
    'Odbc.unlimited' => 'Без ограничений',
    'Odbc.addTooltip' => 'Добавить источник данных в ODBC.',
    'Odbc.status' => 'Статус',
    'Odbc.name' => 'Имя соединения',
    'Odbc.driver' => 'Драйвер',
    'Odbc.description' => 'Описание соединения',
    'Odbc.hostname' => 'Имя хоста',
    'Odbc.statusSystem' => 'Это системный источник данных.',
    'Odbc.statusConfigured' => 'Источник данных настроен.',
    'Odbc.statusNotConfigured' => 'Источник данных не настроен.',
    'Odbc.noSelectionText' => 'Выберите один или несколько элементов для удаления.',
    'Odbc.removeConfirmation' => 'Удалить {count, plural, =1 {соединение {name} } one {# выбранное соединение} few {# выбранных соединения} other {# выбранных соединений}}?',
    'Odbc.removeSuccess' => 'Выбранные соединения удалены.',

    'DomainAliasSettings.title' => 'Настройки псевдонима домена',
    'DomainAliasSettings.updateSuccess' => 'Настройки псевдонима домена %%name%% изменены. %%apacheRestartInterval%%',
    'DomainAliasSettings.apacheRestartInterval' => 'Настройки сайта будут применены через %%restartInterval%% минут.',

    'Home.Backup.title' => 'Последняя резервная копия сервера',
    'Home.Backup.offStatus' => 'Некорректная резервная копия. Входящие в нее данные не подлежат восстановлению.',
    'Home.Backup.task-failedStatus' => 'Не выполнена задача резервного копирования.',
    'Home.Backup.activeSchedule' => 'Расписание: %%schedule%%',
    'Home.Backup.activeSchedules' => 'Расписания: %%schedules%%',
    'Home.Backup.noSchedule' => "Расписание резервного копирования не настроено",
    'Home.Backup.period_hourly' => 'По часам %%schedule%%',
    'Home.Backup.period_daily' => 'Ежедневно %%schedule%%',
    'Home.Backup.period_weekly' => 'Еженедельно %%schedule%%',
    'Home.Backup.period_monthly' => 'Ежемесячно %%schedule%%',
    'Home.Backup.create' => 'Создать резервную копию',
    'Home.Backup.schedule' => 'Расписание',
    'Home.IpBan.title' => 'Блокировка IP-адресов',
    'Home.IpBan.banned' => 'Заблокированные',
    'Home.IpBan.trusted' => 'Надежные',
    'Home.IpBan.more' => 'Подробнее',
    'Home.OverusedSubscriptions.title' => 'Подписки с перерасходом',
    'Home.OverusedSubscriptions.empty' => 'Подписки с перерасходом не найдены',
    'Home.OverusedSubscriptions.usage' => '%%formattedUsed%% из %%formattedValue%%',
    'Home.OverusedSubscriptions.more' => 'Просмотреть все с перерасходом: [%%total%%]',
    'Home.OverusedSubscriptions.list' => 'Открыть в списке',
    'Home.ServerInfo.title' => 'Информация о сервере',
    'Home.ServerInfo.hostname' => 'Имя хоста',
    'Home.ServerInfo.ipAddress' => 'IP-адрес',
    'Home.ServerInfo.publicIpAddress' => 'Внешний IP-адрес',
    'Home.ServerInfo.os' => 'ОС',
    'Home.ServerInfo.uptime' => 'Время непрерывной работы',
    'Home.ServerInfo.uptimeValue' => "{days, plural, =0 {} one {# день} few {# дня} many {# дней} other {# день}} {hours, plural, one {# час} few {# часа} many {# часов} other {# час}} {minutes, plural, one {# минута} few {# минуты} many {# минут} other {# минута}}",
    'Home.ServerInfo.more' => 'Подробнее',
    'Home.Subscriptions.title' => 'Мои подписки',
    'Home.Subscriptions.add' => 'Добавить',
    'Home.Subscriptions.empty' => 'Создайте подписки для хостинга нескольких сайтов в рамках изолированного пространства на сервере. %%link%%',
    'Home.Subscriptions.help' => 'Подробнее',
    'Home.Updates.version' => '%%editionName%% %%version%%',
    'Home.Updates.patch' => '%%version%% с обновлением № %%patch%%',
    'Home.Updates.manageComponents' => 'Добавить или удалить компоненты',
    'Home.Updates.lastUpdated' => 'Последнее обновление: %%lastUpdateDate%%',
    'Home.Updates.checkUpdates' => 'Проверить наличие обновлений',
    'Home.Updates.enableAutoupdate' => 'Разрешить автоматические обновления',
    'Home.Updates.lastChecked' => 'Последняя проверка: %%lastCheckDate%%',
    'Home.Updates.newVersionAvailable' => 'Версия %%availableVersion%% доступна',
    'Home.Updates.installNewVersion' => 'Установить',
    'Home.Updates.patchAvailable' => 'Доступны промежуточные обновления',
    'Home.Updates.patchAvailableVersion' => 'Доступны промежуточные обновления для %%currentVersion%%',
    'Home.Updates.installPatch' => 'Обновить сейчас',
    'Home.Updates.pumUpdates' => '{total, plural, =1 {Доступно обновление для {package}} other {Доступны обновления для {package}}}',
    'Home.Updates.pumPackages' => '{total, plural, =1 {{name} {availableVersion}} one {# пакет} few {# пакета} many {# пакетов} other {# пакета}}',
    'Home.Updates.installUpdates' => 'Обновить {total, plural, =1 {сейчас} other {все}}',

    'HostingSettings.title' => 'Настройки хостинга',
    'HostingSettings.updateSuccess' => 'Настройки обновлены.',
    'HostingSettings.emptyLogin' => 'Вам нужно указать имя пользователя.',
    'HostingSettings.emptyPassword' => 'Вам нужно указать пароль.',
    'HostingSettings.ipV6OnlyNotSupported' => 'FTP-сервер не поддерживает IPv6. Предоставьте хотя бы один IPv4-адрес, иначе пользователь не сможет загружать файлы на сервер по FTP.',
    'HostingSettings.domainSettingsSection.sectionTitle' => 'Настройки домена',
    'HostingSettings.domainSettingsSection.domainName' => 'Имя домена',
    'HostingSettings.domainSettingsSection.description' => 'Например, example.com ',

    'HostingSettings.submitPopover.title' => 'Удалить содержимое из %%website%%',
    'HostingSettings.submitPopover.descriptionMainDomain' => 'Переключение типа хостинга «Сайт» на «%%type%%» навсегда удалит все содержимое сайта, включая следующие папки:',
    'HostingSettings.submitPopover.descriptionSubDomain' => 'Вы хотите изменить тип хостинга для своего сайта?',

    'HostingSettings.domainSettingsSection.creatingWebspaceAlert' => 'Чтобы получить доступ к другим настройкам, введите учетные данные системного пользователя и нажмите "Создать веб-пространство".',
    'HostingSettings.domainSettingsSection.creatingHostingAlert' => 'Чтобы получить доступ к другим настройкам, нажмите "Далее" для создания хостинга.',
    'HostingSettings.domainSettingsSection.hostingTypeTitle' => 'Тип хостинга',
    'HostingSettings.domainSettingsSection.hostingType.title' => 'Тип',
    'HostingSettings.domainSettingsSection.hostingType.website' => 'Сайт',
    'HostingSettings.domainSettingsSection.hostingType.forwarding' => 'Перенаправление',
    'HostingSettings.domainSettingsSection.hostingType.noHosting' => 'Нет веб-хостинга',
    'HostingSettings.domainSettingsSection.hostingType.noHostingHint' => 'Используйте зону DNS домена, чтобы пользоваться почтовыми ящиками с этим именем домена',
    'HostingSettings.domainSettingsSection.hostingType.pathToTheWebsite' => 'Путь к домашней папке этого сайта',
    'HostingSettings.domainSettingsSection.preferredDomainTitle' => 'Предпочтительный домен',
    'HostingSettings.domainSettingsSection.preferredDomainDescription' => 'Посетители будут перенаправлены сюда через перенаправление HTTP 301 для SEO.',
    'HostingSettings.domainSettingsSection.forwardVisitorsTo' => 'Перенаправлять посетителей на',
    'HostingSettings.domainSettingsSection.forwardingType.title' => 'Тип перенаправления',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanently' => 'Окончательно перенесен (код 301)',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanentlyDescription' => 'Перенаправлять посетителей на другой сайт и показывать им его адрес. Это позволит сохранить поисковый рейтинг сайта',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarily' => 'Временно перенесен (код 302)',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarilyDescription' => 'Перенаправлять посетителей на временный экземпляр сайта, если не хотите, чтобы он индексировался поисковыми системами.',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwarding' => 'Перенаправление во фрейме',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwardingDescription' => 'Перенаправлять посетителей веб-сайта на другой сайт, но не показывать им целевой адрес, чтобы они не знали о перенаправлении.',
    'HostingSettings.domainSettingsSection.preferredDomain.title' => 'Предпочтительный домен',
    'HostingSettings.domainSettingsSection.preferredDomain.none' => 'Нет',
    'HostingSettings.domainSettingsSection.preferredDomain.www' => 'www.%%domainName%%',
    'HostingSettings.domainSettingsSection.documentRootTitle' => 'Корневая папка',
    'HostingSettings.domainSettingsSection.documentRootHint' => 'Невозможно изменить корневую папку сайта, так как на сайте установлены веб-приложения.',
    'HostingSettings.domainSettingsSection.save' => 'Сохранить',
    'HostingSettings.domainSettingsSection.sameSsl.title' => 'Режим совместимости',
    'HostingSettings.domainSettingsSection.sameSsl.enabled' => 'Запустить сайт в режиме совместимости для опции "Разделять SSL/TLS и не-SSL/TLS содержимое"',
    'HostingSettings.domainSettingsSection.sameSsl.hint' => 'Этот сайт работает в режиме совместимости, и вы не можете управлять им через интерфейс Plesk. Это связано с тем, что до обновления вы использовали устаревшую опцию "Разделять SSL/TLS и не-SSL/TLS содержимое". Начиная с версии Plesk 11 сайты хранят контент, доступный по HTTP и HTTPS, в одной и той же папке. Мы рекомендуем перенести все ваши данные из папки httpsdocs/ в папку httpdocs/ и затем отключить режим совместимости. В результате этого приложения, установленные в папку httpsdocs/, станут доступными через Интернет. Обратите внимание, что после этого вы больше не сможете включить режим совместимости.',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogTitle' => 'Изменить эти настройки?',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogDescription' => 'Изменение этого параметра противоречит политике безопасности сервера и может снизить производительность или сделать сервер уязвимым для атак.',
    'HostingSettings.domainSettingsSection.security.buttonChange' => 'Изменить',
    'HostingSettings.domainSettingsSection.security.buttonRevert' => 'Отменить',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetApplied' => 'Применен пресет настроек безопасности',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetMessage' => 'Для повышения безопасности примените пресет настроек безопасности. Обратите внимание, что определенные разрешения позволяют подписчикам изменять эти настройки.',
    'HostingSettings.domainSettingsSection.security.applySecureSettingsPreset' => 'Применить пресет безопасности',
    'HostingSettings.domainSettingsSection.security.exploreSecureSettings' => 'Подробнее о настройках безопасности хостинга',
    'HostingSettings.domainSettingsSection.security.sslTlsSupport' => 'Поддержка SSL/TLS',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportEnabled' => 'Включено',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportDescription' => 'Зашифруйте соединения между сайтом и браузером посетителя.',
    'HostingSettings.domainSettingsSection.security.certificate' => 'Сертификат',
    'HostingSettings.domainSettingsSection.security.certificateDescription' => 'Чтобы включить HTTPS, загрузите сертификат SSL/TLS в репозиторий домена, а затем выберите его здесь.',
    'HostingSettings.domainSettingsSection.security.permanentRedirect' => 'Перенаправляйте посетителей с HTTP на HTTPS через переадресацию 301 для SEO',
    'HostingSettings.domainSettingsSection.security.noCertificates' => 'В вашем хранилище нет ни одного SSL/TLS-сертификата. Чтобы добавить сертификат, откройте %%link%%.',
    'HostingSettings.domainSettingsSection.security.noCertificatesLink' => 'эту страницу',
    'HostingSettings.domainSettingsSection.security.certificateFromDomainRepository' => '%%name%% (%%repository%%)',
    'HostingSettings.domainSettingsSection.security.certificateFromOtherRepository' => '%%name%% (другое хранилище)',
    'HostingSettings.domainSettingsSection.security.certificateNotSelected' => 'Не выбран',
    'HostingSettings.domainSettingsSection.webScripting.title' => 'Веб-скрипты',
    'HostingSettings.domainSettingsSection.webScripting.description' => 'Выберите, какие языки программирования и скриптов должны интерпретироваться веб-сервером.',
    'HostingSettings.domainSettingsSection.webScripting.fastCgi' => 'FastCGI',
    'HostingSettings.domainSettingsSection.webScripting.cgi' => 'CGI',
    'HostingSettings.domainSettingsSection.webScripting.cgiReadonly' => 'папка cgi-bin расположена в %%value%%',
    'HostingSettings.domainSettingsSection.webScripting.ssi' => 'SSI',
    'HostingSettings.domainSettingsSection.webScripting.ssiHtml' => 'Использовать SSI для файлов с расширениями *.htm, *.html',
    'HostingSettings.domainSettingsSection.webScripting.asp' => 'Microsoft ASP',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNet' => 'Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNetVersion' => 'Версия Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.perl' => 'Perl',
    'HostingSettings.domainSettingsSection.webScripting.python' => 'Python',
    'HostingSettings.domainSettingsSection.webScripting.customErrorDocuments' => 'Пользовательские страницы ошибок',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.title' => 'папка cgi-bin расположена в',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.wwwRoot' => 'корневая папка этого домена',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.webspace' => 'корневая папка веб-пространства',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.oldStyle' => 'корневая папка этого домена в устаревшем формате',
    'HostingSettings.domainSettingsSection.webScripting.errorDocs' => 'Пользовательские страницы ошибок',
    'HostingSettings.domainSettingsSection.webScripting.writeModify' => 'Дополнительные права на запись/редактирование',
    'HostingSettings.domainSettingsSection.webScripting.webDeploy' => 'Публикация с помощью инструмента веб-развертывания',
    'HostingSettings.domainSettingsSection.webStatistics.title' => 'Веб-статистика',
    'HostingSettings.domainSettingsSection.webStatistics.tool' => 'Инструмент',
    'HostingSettings.domainSettingsSection.webStatistics.webstatProtected' => 'Защитить доступ к веб-статистике именем пользователя и паролем FTP',
    'HostingSettings.domainSettingsSection.webStatistics.disabled' => 'Отключено',

    'HostingSettings.webspaceSettingsSection.sectionTitle' => 'Настройки веб-пространства',
    'HostingSettings.webspaceSettingsSection.ipAddresses' => 'IP-адреса',
    'HostingSettings.webspaceSettingsSection.quota.title' => 'Квота места на диске',
    'HostingSettings.webspaceSettingsSection.quota.enabled' => 'Включено',
    'HostingSettings.webspaceSettingsSection.quota.description' => 'Запретить операции с файлами сайта, если превышена квота дискового пространства, установленная в настройках подписки (если она есть).',
    'HostingSettings.webspaceSettingsSection.quota.unlimitedDesc' => 'Квота места на диске не поддерживается из-за настроек файловой системы сервера.',
    'HostingSettings.webspaceSettingsSection.quota.mbUnits' => 'Mб',
    'HostingSettings.webspaceSettingsSection.quota.readonly' => '%%quota%% Mб',
    'HostingSettings.webspaceSettingsSection.systemUser' => 'Учетные данные системного пользователя',
    'HostingSettings.webspaceSettingsSection.systemUserUnixDesc' => 'Управляйте файлами и папками сайта через FTP или менеджер файлов. Доступ к серверу через SSH, если он разрешен.',
    'HostingSettings.webspaceSettingsSection.systemUserWinDesc' => 'Управляйте файлами и папками сайта через FTP или менеджер файлов. Доступ к серверу через удаленный рабочий стол, если он разрешен.',
    'HostingSettings.webspaceSettingsSection.systemUserLogin' => 'Имя пользователя',
    'HostingSettings.webspaceSettingsSection.systemUserPasswd' => 'Пароль',
    'HostingSettings.webspaceSettingsSection.systemUserPasswdDesc' => 'Укажите здесь новый пароль, чтобы изменить пароль системного пользователя.',
    'HostingSettings.webspaceSettingsSection.shell.unixTitle' => 'Доступ по SSH',
    'HostingSettings.webspaceSettingsSection.shell.winTitle' => 'Доступ к удаленному рабочему столу',
    'HostingSettings.webspaceSettingsSection.shell.enabled' => 'Включено',
    'HostingSettings.webspaceSettingsSection.shell.description' => "Доступ к серверу с учетными данными системного пользователя.",
    'HostingSettings.webspaceSettingsSection.shell.type' => 'Тип',
    'HostingSettings.webspaceSettingsSection.shell.disabled' => 'Отключено',
    'HostingSettings.webspaceSettingsSection.affectedDomainsLabel' => 'Для {count, plural, one {# домена} few {# доменов} many {# доменов} other {# домена}}',
    'HostingSettings.webspaceSettingsSection.affectedDomainsDescription' => 'Следующие настройки распространяются на {count, plural, one {# домен в веб-пространстве {name}} few {# домена в веб-пространстве {name}} many {# доменов в веб-пространстве {name}} other {# домена в веб-пространстве {name}}}:',

    'OdbcAdd.title' => 'Добавить ODBC DSN',
    'OdbcAdd.nameLabel' => 'Имя соединения',
    'OdbcAdd.descriptionLabel' => 'Описание соединения',
    'OdbcAdd.driver' => 'Драйвер',
    'OdbcAdd.submit' => 'Создать ODBC DSN',

    'OdbcEdit.title' => 'Настроить ODBC-подключение',
    'OdbcEdit.saveSuccess' => 'Настройки соединения сохранены.',
    'OdbcEdit.test' => 'Проверить соединение',
    'OdbcEdit.connectSuccess' => 'Соединение выполнено успешно.',

    'OdbcEdit.excel.driver.label' => 'Драйвер',
    'OdbcEdit.excel.dbq.label' => 'Путь к файлу базы данных',
    'OdbcEdit.excel.defaultdir.label' => 'Папка с данными по умолчанию',
    'OdbcEdit.excel.fil.label' => 'Версия базы данных',
    'OdbcEdit.excel.maxbuffersize.label' => 'Макс. размер буфера',
    'OdbcEdit.excel.pagetimeout.label' => 'Время ожидания загрузки страницы',

    'OdbcEdit.access.driver.label' => 'Драйвер',
    'OdbcEdit.access.dbq.label' => 'Путь к файлу базы данных',
    'OdbcEdit.access.uid.label' => 'Идентификатор входа в систему',
    'OdbcEdit.access.pwd.label' => 'Пароль',
    'OdbcEdit.access.pagetimeout.label' => 'Время ожидания загрузки страницы',
    'OdbcEdit.access.pagetimeout.description' => 'Период времени в десятках секунд, в течение которого неиспользуемая страница оставалась в буфере. Эту опцию можно применить ко всем источникам данных, которые используют драйвер Microsoft Access.',
    'OdbcEdit.access.maxbuffersize.label' => 'Макс. размер буфера',
    'OdbcEdit.access.maxbuffersize.description' => 'Размер внутреннего буфера в килобайтах, скорректированный для границы 256 Кб',
    'OdbcEdit.access.readonly.label' => 'Только чтение',
    'OdbcEdit.access.readonly.description' => 'Назначает базу данных доступной только для чтения, чтобы запретить выполнение любых обновлений.',
    'OdbcEdit.access.exclusive.label' => 'Эксклюзивный',
    'OdbcEdit.access.exclusive.description' => 'Назначает базу данных эксклюзивной, чтобы запретить общий доступ к обновлению.',
    'OdbcEdit.access.safetransactions.label' => 'Безопасные транзакции',
    'OdbcEdit.access.safetransactions.description' => 'При значении, равном 0 (значение по умолчанию), все транзакции выполняются незамедлительно. При значении, равном 1, все транзакции сохраняются на диск только после выполнения операции, однако при этом немного снижается производительность.',
    'OdbcEdit.access.threads.label' => 'Потоки',
    'OdbcEdit.access.threads.description' => 'Количество фоновых потоков, которые могут быть созданы подсистемой.',
    'OdbcEdit.access.maxscanrows.label' => 'Макс. сканируемых строк',
    'OdbcEdit.access.maxscanrows.description' => 'Количество строк, для которых следует выполнить сканирование при установке типа данных в столбце на основании существующих данных.',
    'OdbcEdit.access.implicitcommitsync.label' => 'ImplicitCommitSync',
    'OdbcEdit.access.implicitcommitsync.description' => 'Указывает, каким образом изменения, сделанные без помощи транзакций, записаны в базу данных.',
    'OdbcEdit.access.usercommitsync.label' => 'UserCommitSync',
    'OdbcEdit.access.usercommitsync.description' => 'Указывает, будет ли драйвер MS Access выполнять асинхронно явным образом определенные пользователем транзакции.',

    'OdbcEdit.mssql.driver.label' => 'Драйвер',
    'OdbcEdit.mssql.server.label' => 'Сервер',
    'OdbcEdit.mssql.uid.label' => 'Идентификатор входа в систему',
    'OdbcEdit.mssql.pwd.label' => 'Пароль',
    'OdbcEdit.mssql.database.label' => 'База данных по умолчанию',
    'OdbcEdit.mssql.app.label' => 'Название приложения',
    'OdbcEdit.mssql.wsid.label' => 'ID рабочей станции',
    'OdbcEdit.mssql.language.label' => 'Язык по умолчанию',
    'OdbcEdit.mssql.oemtoansi.label' => 'Преобразование расширенных символов в OEM-значения',

    'OdbcEdit.mysql.driver.label' => 'Драйвер MySQL ODBC',
    'OdbcEdit.mysql.server.label' => 'Сервер',
    'OdbcEdit.mysql.server.description' => 'Имя хоста сервера MySQL',
    'OdbcEdit.mysql.database.label' => 'База данных по умолчанию',
    'OdbcEdit.mysql.user.label' => 'Имя пользователя',
    'OdbcEdit.mysql.user.description' => 'Имя пользователя для подключения к MySQL',
    'OdbcEdit.mysql.password.label' => 'Пароль',
    'OdbcEdit.mysql.password.description' => 'Пароль для учетной записи пользователя на сервере',
    'OdbcEdit.mysql.port.label' => 'Порт',
    'OdbcEdit.mysql.port.description' => 'Порт TCP/IP, который следует использовать, если сервер не является локальным хостом',
    'OdbcEdit.mysql.socket.label' => 'Сокет',
    'OdbcEdit.mysql.socket.description' => 'Канал с именем Windows для подключения в случае, если сервер не является локальным хостом',
    'OdbcEdit.mysql.option.label' => 'Опция',
    'OdbcEdit.mysql.option.description' => 'Опции, определяющие, как должен работать MyODBC. Ознакомьтесь с <a target="_blank" href="https://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">документацией</a>.',

    'ProtectedDirectoryList.title' => 'Защищенные папки из: %%domainName%%',
    'ProtectedDirectoryList.add' => 'Добавить защищенную папку',
    'ProtectedDirectoryList.addTooltip' => 'Создать защищенную папку.',
    'ProtectedDirectoryList.name' => 'Имя',
    'ProtectedDirectoryList.realmTitle' => 'Название защищенного раздела',
    'ProtectedDirectoryList.noSelectionText' => 'Выберите один или несколько элементов для удаления.',
    'ProtectedDirectoryList.edit' => 'Изменить',
    'ProtectedDirectoryList.remove' => 'Снять защиту',
    'ProtectedDirectoryList.removeTooltip' => 'Снять защиту с выбранных папок.',
    'ProtectedDirectoryList.removeConfirmation' => 'Эта операция приведет к снятию защиты {count, plural, =1 {с папки {name}} few {с # выбранных папок} many {с # выбранных папок} other {с # выбранной папки}}. {count, plural, =1 {Эта папка станет доступна} other {Эти папки станут доступны}} всем пользователям Интернета.',
    'ProtectedDirectoryList.removeSuccess' => 'Выбранные папки удалены.',

    'ProtectedDirectoryAdd.title' => 'Создать защищенную папку',
    'ProtectedDirectoryAdd.submit' => 'Создать',
    'ProtectedDirectoryAdd.success' => 'Защищенная папка %%path%% была успешно создана',

    'ProtectedDirectoryEdit.title' => 'Настройки защищенной папки',
    'ProtectedDirectoryEdit.success' => 'Настройки защищенной папки были изменены',

    'ProtectedDirectoryUserList.title' => 'Пользователи защищенной папки %%directory%%',
    'ProtectedDirectoryUserList.add' => 'Добавить пользователя',
    'ProtectedDirectoryUserList.addTooltip' => 'Создайте учетные записи пользователей для получения доступа к защищенной папке %%directory%%',
    'ProtectedDirectoryUserList.login' => 'Имя',
    'ProtectedDirectoryUserList.changePassword' => 'Изменить пароль',
    'ProtectedDirectoryUserList.noSelectionText' => 'Выберите одного или нескольких пользователей для удаления.',
    'ProtectedDirectoryUserList.remove' => 'Удалить',
    'ProtectedDirectoryUserList.removeTooltip' => 'Удалить выбранных пользователей.',
    'ProtectedDirectoryUserList.removeConfirmation' => 'Удалить {count, plural, =1 {пользователя {login}} few {# выбранных пользователей} many {# выбранных пользователей} other {# выбранного пользователя}}?',
    'ProtectedDirectoryUserList.removeSuccess' => 'Выбранные пользователи были удалены.',

    'ProtectedDirectoryUserAdd.title' => 'Создать пользователя защищенной папки',
    'ProtectedDirectoryUserAdd.subtitle' => 'Папка %%directory%%',
    'ProtectedDirectoryUserAdd.loginLabel' => 'Имя пользователя',
    'ProtectedDirectoryUserAdd.passwordLabel' => 'Пароль',
    'ProtectedDirectoryUserAdd.submit' => 'Создать',
    'ProtectedDirectoryUserAdd.success' => 'Пользователь защищенной папки %%login%% создан.',

    'ProtectedDirectoryUserPassword.title' => 'Пароль пользователя защищенной папки',
    'ProtectedDirectoryUserPassword.subtitle' => 'Пользователь %%login%%',
    'ProtectedDirectoryUserPassword.passwordLabel' => 'Пароль',
    'ProtectedDirectoryUserPassword.submit' => 'Сохранить',
    'ProtectedDirectoryUserPassword.success' => 'Учетные данные пользователя сохранены.',

    'SummaryReport.Layout.title' => 'Свойства шаблона отчета',
    'SummaryReport.Layout.success' => 'Шаблон отчета %%name%% был обновлен.',
    'SummaryReport.Layouts.title' => 'Шаблоны отчетов',

    'SummaryReport.Layout.Add.title' => 'Создать шаблон отчета',
    'SummaryReport.Layout.Add.success' => 'Шаблон отчета %%name%% был создан.',

    'SummaryReport.Report.title' => 'Сводный отчет',
    'SummaryReport.Report.buttonLayouts' => 'Шаблоны',
    'SummaryReport.Report.buttonSchedule' => 'Расписание',
    'SummaryReport.Report.buttonProperties' => 'Свойства',
    'SummaryReport.Report.buttonTrafficHistory' => 'Статистика по трафику',
    'SummaryReport.Report.buttonPrint' => 'Печатать',
    'SummaryReport.Report.buttonSend' => 'Отправить по почте',
    'SummaryReport.Report.successSent' => 'Отчет отправлен по адресу %%email%%',

    'SummaryReport.Schedule.title' => 'Расписания доставки для %%name%%',
    'SummaryReport.Schedule.Properties.title' => 'Расписание доставки на %%name%%',
    'SummaryReport.Schedule.Properties.success' => 'Расписание доставки отчетов было обновлено.',

    'SummaryReport.Schedule.Add.title' => 'Создать расписания доставки для %%name%%',
    'SummaryReport.Schedule.Add.success' => 'Расписание доставки отчетов было создано.',

    'SummaryReport.TrafficHistory.title' => 'Статистика по трафику',

    'VirtualDirectory.title' => 'Виртуальная папка %%path%% домена %%domainName%%',
    'VirtualDirectory.errNotExist' => 'Эта виртуальная папка привязана к несуществующей физической папке.',
    'VirtualDirectory.errNoPermissions' => 'Вам запрещено просматривать содержимое этой папки.',
    'VirtualDirectory.buttonProperties' => 'Свойства папки',
    'VirtualDirectory.buttonPropertiesHint' => 'Просмотреть и изменить свойства виртуальной папки.',
    'VirtualDirectory.buttonPermissions' => 'Права доступа к папке',
    'VirtualDirectory.buttonPermissionsHint' => 'Настроить права доступа к папке.',
    'VirtualDirectory.buttonAspDotNet' => 'ASP.NET',
    'VirtualDirectory.buttonAspDotNetHint' => 'Измените настройки ASP.NET.',
    'VirtualDirectory.buttonPhp' => 'PHP',
    'VirtualDirectory.buttonPhpHint' => 'Измените настройки PHP.',
    'VirtualDirectory.buttonMimeTypes' => 'Типы MIME',
    'VirtualDirectory.buttonMimeTypesHint' => 'Управление зарегистрированными типами MIME.',
    'VirtualDirectory.buttonErrorDocs' => 'Страницы ошибок',
    'VirtualDirectory.buttonErrorDocsHint' => 'Управление страницами ошибок.',
    'VirtualDirectory.buttonProtection' => 'Защита',
    'VirtualDirectory.buttonProtectionHint' => 'Ограничить доступ к папке с помощью пароля.',

    'VirtualDirectory.CreateDirectory.title' => 'Создать папку',
    'VirtualDirectory.CreateDirectory.name' => 'Имя папки',
    'VirtualDirectory.CreateDirectory.success' => 'Папка %%name%% создана.',
    'VirtualDirectory.CreateDirectory.errExists' => 'Папка %%name%% уже существует.',

    'VirtualDirectory.AspDotNet.title' => 'Изменить настройки ASP.NET',

    'VirtualDirectory.Php.title' => 'Версия PHP',
    'VirtualDirectory.Php.version' => 'Версия',
    'VirtualDirectory.Php.success' => 'Версия PHP обновлена.',
];