<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'aps-install.queue' => 'Installerer %%name%% at %%path%%...',
    'aps-install.queueNoPath' => 'Installerer %%name%%...',
    'aps-install.done' => '%%name%% blev korrekt installeret på %%path%%. Du kan se akkreditiver for logning i nedenstående applikation. %%additionalMessage%%',
    'aps-install.doneNoPath' => '%%name%% blev korrekt installeret. Du kan se akkreditiver for logning i nedenstående applikation. %%additionalMessage%%',
    'aps-install.doneAdvanced' => '%%name%% blev korrekt installeret på %%path%%. %%additionalMessage%%',
    'aps-install.doneAdvancedNoPath' => '%%name%% blev korrekt installeret. %%additionalMessage%%',
    'aps-install.error' => 'Installation of %%name%% på %%path%% mislykkedes. %%errorMessage%%',
    'aps-install.errorNoPath' => 'Installation of %%name%% mislykkedes. %%errorMessage%%',

    'aps-update.queueDownload' => 'Downloader %%packageName%%...',
    'aps-update.errorDownload' => 'Download af %%packageName%% mislykkedes:',
    'aps-update.queueInstall' => 'Opdatering af en installation af %%name%% for %%domainName%% ….',
    'aps-update.doneInstall' => 'Installationen af %%name%% til %%domainName%% blev korrekt opdateret.',
    'aps-update.errorInstall' => 'Opdatering af en installation af %%name%% for %%domainName%% mislykkedes:',
    'aps-update.queueInstallMulti' => 'Opdaterer %%instances%% installationer af %%name%%….',
    'aps-update.doneInstallMulti' => '%%successes%% installationer af %%name%% blev korrekt opdaterede.',
    'aps-update.errorInstallMulti' => 'Opdatering af %%failures%% installationer af %%name%% mislykkedes:',
    'aps-update.incorrectUpdateInformation' => 'Opdateringsinformationen er forkert.',

    'common.hideCompletedTasks' => 'Skjul færdige',
    'common.progressBarHide' => 'Skjul',
    'common.progressBarShow' => 'Vis',
    'common.close' => 'Luk',
    'common.refresh' => 'Opdatér side',
    'common.taskInProgress' => 'i%%count%% igangværende opgaver...',
    'common.percentCompleted' => '%%percent%%% færdig',
    'common.allTasksCompleted' => 'Alle %%num%% opgaver blev gennemført.',
    'common.minimize' => 'Minimer',
    'common.statusDone' => 'Færdig',
    'common.statusError' => 'Mislykkedes',
    'common.statusNotStarted' => 'I kø',
    'common.statusCanceled' => 'Annulleret',
    'common.progressDialogLink' => 'detaljeret forløb',

    'database-check.queue' => 'Kontrollerer %%database%% databasetabeller….',
    'database-check.done' => '%%database%% databasen har ingen problemer.',
    'database-check.error' => 'Kan ikke kontrollere %%database%% databasen for fejl.',
    'database-check.done-with-errors' => "%%database%% databasen har %%number%% problemer. \n %%link%%",
    'database-check.info-link-title' => 'Se detaljerede oplysninger og løs',

    'database-download.queue' => 'Forbereder et dump af %%database%% til eksport…',
    'database-download.done' => 'Dump af %%database%% er klar. Du kan%%downloadLink%% den.',
    'database-download.downloadLink' => 'download',
    'database-download.error' => 'Kan ikke eksportere et %%database%%:',

    'database-repair.queue' => 'Reparerer %%database%% databasetabeller….',
    'database-repair.done' => '%%database%% databasen har ingen problemer.',
    'database-repair.error' => 'Kan ikke reparere databasen %%database%%.',
    'database-repair.done-with-errors' => "%%database%% databasen har %%number%% problemer. \n %%link%%",
    'database-repair.info-link-title' => 'Se Detaljer',

    'database-upload.queue' => 'Importerer et dump af %%database%%….',
    'database-upload.done' => 'Dump af %%database%% blev importeret.',
    'database-upload.error' => 'Kan ikke importere %%database%% dump:',
    'database-upload.done-with-errors' => "Dump af %%database%% blev importeret med fejl.",
    'database-upload.orphanedUsersSuccess' => 'Databasen %%database%% blev korrekt importeret. Imidlertid blev nogle brugere forældreløse (dvs. har ingen tilknyttede logins på database-serveren). For at kunne tilgå databaserne, skal du knytte logins til disse brugere. %%viewUsersLink%%.',
    'database-upload.orphanedUsersError' => 'Følgende brugere blev forældreløse (dvs. de har ingen logins på databaseserveren): %%orphanedUsers%%.',
    'database-upload.orphanedUsersLink' => 'Vis brugere',

    'domain-app-scan.queue' => 'Scanner efter programmer...',
    'domain-app-scan.done' => 'Scanning efter programmer blev afsluttet.',
    'domain-app-scan.error' => 'Scanning efter for programmer blev afsluttet med fejl.',

    'domain-move.queue' => 'Flytter %%domainName%% til %%webspaceName%%',
    'domain-move.done' => '%%domainName%% blev flyttet til %%webspaceName%%',
    'domain-move.error' => '%%domainName%% blev ikke flyttet til %%webspaceName%%',

    'domain-split.queue' => 'Flytter %%domainName%% til et nyt abonnement',
    'domain-split.done' => '%%domainName%% blev flyttet til et nyt abonnement',
    'domain-split.error' => '%%domainName%% blev ikke flyttet til et nyt abonnement',

    'file-manager-import-file.done' => 'Filen %%fileName%% er blevet importeret til <a href="%%listUrl%%">mappen %%fileDir%% </a>.',
    'file-manager-import-file.error' => 'Kan ikke importere %%fileName%% filen: %%errorMessage%%.<br><a href="%%url%%">Download til min computer</a>',
    'file-manager-import-file.queue' => 'Importerer filen %%fileName%% fra %%host%%.',
    'file-manager-import-file.progress' => 'Importerer filen %%fileName%% fra %%host%% (%%value%% MB).',
    'file-manager-import-file.errors.auth' => 'Der opstod en godkendelsesfejl. Sørg for, at du har angivet korrekt login og adgangskode',
    'file-manager-import-file.errors.resolve' => 'Kunne ikke opløse %%host%% hostnavnet. Sørg for, at du angiver det korrekte URL',
    'file-manager-import-file.errors.connect' => 'Kunne ikke forbinde til serveren %%host%%. Sørg for at angive korrekt URL',
    'file-manager-import-file.errors.notFound' => 'Den eksterne fil blev ikke fundet eller er ikke tilgængelig. Sørg for, at du angiver korrekt URL og at filen er tilgængelig',
    'file-manager-import-file.errors.maxSize' => 'Diskpladsgrænsen ellere den ledige plads %%diskSpaceLimit%% er overskredet',
    'file-manager-import-file.errors.lowSpeedTime' => 'Kunne ikke importere filen, da overførselshastigheden var for langsom: mindre end %%lowSpeedLimit%% bytes blev overført i løbet af de seneste %%lowSpeedTime%% sekunder. Det websted, filen ligger på kan have megen trafik i øjeblikket. Prøv at  importere filen senere',
    'file-manager-import-file.errors.certificate' => 'Kunne ikke importere filen fordi der ikke er tillid til SSL/TLS-certifikatet for %%host%% serveren. Sørg for, at filen ligger på en server med et godkendt certifikat',
    'file-manager-import-file.errors.redirects' => 'Det maksimale omdirigeringer (%%maxRedirects%%) er overskredet. Sørg for, at serveren  %%host%% fungerer korrekt',

    'force-log-rotation.queue' => 'Anvender globale logrotationsindstillinger.',
    'force-log-rotation.done' => 'Globale logrotationsindstillinger blev anvendt.',
    'force-log-rotation.error' => 'Anvendelse af globale logrotationer færdig med fejl',
    'force-log-rotation.systemLogRotationError' => 'Systemlogge: %%error%%',
    'force-log-rotation.planLogRotationError' => 'Serviceplan %%name%%: %%error%%',
    'force-log-rotation.domainLogRotationError' => 'Domæne %%name%%: %%error%%',

    'initial-setup.queue' => 'Initialiserer Plesk...',
    'initial-setup.done' => 'Plesk er blevet initialiseret.',
    'initial-setup.doneWithErrors' => 'Der opstod en fejl under indlæsning af Plesk.',
    'initial-setup.error' => 'Initialisering af Plesk mislykkedes.',
    'initial-setup.step.setupPanel' => 'Opsætning af Plesk Panel',
    'initial-setup.step.requestLicense' => 'Anmoder om licens',
    'initial-setup.step.configureServer' => 'Konfigurerer webserver',
    'initial-setup.step.secureServer' => 'Sikrer serveren',

    'ip-update.queue' => 'Opdaterer -IP-adresse',
    'ip-update.done' => 'IP-adresse opdateret.',
    'ip-update.error' => 'IP-adresse opdatering færdig med fejl.',
    'ip-update.updating' => 'Opdaterer -IP-adresse',
    'ip-update.updatingWebServer' => 'Opdaterer IP-adresse: opdaterer webserver',
    'ip-update.updatingFtpServer' => 'Opdaterer IP-adresser: opdaterer FTP-server',
    'ip-update.updatingDnsZones' => 'Opdaterer IP-adresse: opdaterer DNS-server',
    'ip-update.restartingDnsService' => 'Opdaterer IP-adresse: genstarter DNS-server',

    'ip-reload-public.queue' => 'Opdaterer offentlige IP-adresser ved hjælp af cloud-metadata',
    'ip-reload-public.done' => 'Offentlige IP-adresser blev opdateret',

    'logrotate_anonymize_ips.queue' => 'Anonymiser IP-adresser i logge',
    'logrotate_anonymize_ips.queueRevert' => 'Af-anonymiser IP-adresser i logge',
    'logrotate_anonymize_ips.done' => 'IP-adresser blev anonymiserede.',
    'logrotate_anonymize_ips.doneRevert' => 'IP-adresser blev af-anonymiserede.',
    'logrotate_anonymize_ips.error' => 'IP-adresse anonymisering afsluttet med fejl.',
    'logrotate_anonymize_ips.errorRevert' => 'IP-adresse af-anonymisering afsluttet med fejl.',

    'panel-components-install.queue' => 'Installerer de valgte komponenter.',
    'panel-components-install.done' => 'De valgte komponenter blev korrekt installeret:',
    'panel-components-install.error' => 'Kunne ikke installere komponenterne. Adviseringen med fejlbeskrivelsen blev sendt til din e-mailadresse.',

    'panel-update.queue' => 'Plesk installerer opdateringer. Dette kan vare nogen tid. %%warning%%',
    'panel-update.warning' => 'Udfør venligst ikke administrationshandlinger i Plesk før opdateringen er færdig.',
    'panel-update.done' => 'Plesk blev opdateret. Se yderligere information i %%changelog%%.',
    'panel-update.changelog' => 'Plesk ændringslog',
    'panel-update.error' => 'Kunne ikke opdatere Plesk. %%errorDetails%%',
    'panel-update.support' => 'For at løse dette problem, kan du sende opdateringsloggen til Plesk support. %%failedLog%% Kopier loggen til din computer, inden du lukker denne besked.',
    'panel-update.failedLog' => 'Vis opdateringslog fra %%date%%.',

    'pum-update-packages.queue' => 'Opdaterer %%count%% pakke(r)...',
    'pum-update-packages.done' => '%%count%% pakker blev korrekt opdaterede.',
    'pum-update-packages.error' => 'Opdatering mislykkedes.',

    'scheduler-run-task.queue' => 'Kører opgaven "%%task%%"...',
    'scheduler-run-task.done' => 'Opgaven "%%task%%" afsluttet korrekt på %%seconds%% sekunder.',
    'scheduler-run-task.error' => 'Opgaven "%%task%%" afsluttet med fejl på %%seconds%% sekunder.',
    'scheduler-run-task.popupSeeDetails' => 'Se Detaljer',
    'scheduler-run-task.popupTitle' => 'Kør planlagt opgave',
    'scheduler-run-task.popupDone' => 'Opgaven "%%task%%" afsluttet korrekt på %%seconds%% sekunder, output:',
    'scheduler-run-task.popupError' => 'Opgaven "%%task%%" afsluttet med fejl på %%seconds%% sekunder, output:',
    'scheduler-run-task.popupClose' => 'Luk',

    'sdk.queue' => 'Opgaven "%%name%%" er i gang ...',
    'sdk.error' => 'Opgaven "%%name%%" er milykkedes.',
    'sdk.done' => 'Opgaven "%%name%%" er afsluttet.',
    'sdk.canceled' => 'Opgaven "%%name%%" er annulleret.',

    'sync-php-settings.queue' => 'Overfører globale PHP %%version%%-indstillinger til domæner',
    'sync-php-settings.done' => 'Globale PHP %%version%%-indstillinger blev overført til domæner',
    'sync-php-settings.error' => 'Fejl opstod under overførsel af globale PHP %%version%%-indstillinger til domæner',

    'sync-service-plan.queue' => 'Synkroniserer serviceplanen %%name%% med abonnementer',
    'sync-service-plan.done' => 'Serviceplanen %%name%% blev synkroniseret med abonnementer',
    'sync-service-plan.doneWithErrors' => 'Synkroniseringen af serviceplanen %%name%% blev fuldført. Nogle abonnementer blev ikke synkroniseret med planen',
    'sync-service-plan.error' => 'Der opstod en fejl under synkronisering af serviceplanen %%name%% med abonnementer',

    'domain-create.queue' => 'Opretter domænet %%domainName%%',
    'domain-create.done' => 'Domænet %%domainName%% er oprettet',
    'domain-create.error' => 'Oprettelse af domænet %%domainName%% mislykkedes',
    'domain-create.warning' => 'Domænet %%domainName%% blev oprettet med nogle få problemer:<br> %%problems%%',
    'domain-create.refreshUrl' => 'Vis',
    'domain-create.steps.createCustomer' => 'Opretter kunde',
    'domain-create.steps.createSubscription' => 'Opretter et abonnement',
    'domain-create.steps.createDomain' => 'Tilføjer et domæne',
    'domain-create.steps.configureDns' => 'Konfigurerer DNS-zonen',
    'domain-create.steps.createHosting' => 'Opretter fysisk hosting',
    'domain-create.steps.configurePhp' => 'Konfigurerer PHP',
    'domain-create.steps.configureMail' => 'Konfiguration af e-mail',

    'domain-delete.queue' => 'Sletning af domæner behandles',
    'domain-delete.done' => 'Domæner slettet',
    'domain-delete.error' => 'Sletning af domæner mislykkedes',
    'domain-delete.step.domains' => 'Sletter domæner...',

    'domain-resolve-checking.warning' => 'Domænet %%domainName%% løser problemer, der blev fundet: <br> %%errors%%',

    'customer-create.queue' => 'Oprettelse af kunden %%customerName%% behandles',
    'customer-create.done' => 'Kunden %%customerName%% er oprettet',
    'customer-create.error' => 'Oprettelse af kunden %%customerName%% mislykkedes',
    'customer-create.warning' => 'Kuden %%customerName%% blev oprettet med nogle få problemer:<br> %%problems%%',
    'customer-create.warnings.notSynchronizedLink' => 'Du kan prøve at synkronisere manuelt.',

    'customer-delete.queue' => 'Sletning af kunder behandles',
    'customer-delete.done' => 'Kunder slettet',
    'customer-delete.error' => 'Sletning af kunder mislykkedes',

    'reseller-delete.queue' => 'Sletning af forhandlere behandles',
    'reseller-delete.done' => 'Forhandlere slettet',
    'reseller-delete.error' => 'Sletning af forhandlere mislykkedes',

    'subscription-create.queue' => 'Oprettelse af abonnementet %%subscriptionName%% behandles',
    'subscription-create.done' => 'Abonnementet %%subscriptionName%% er oprettet',
    'subscription-create.error' => 'Oprettelse af abonnementet %%subscriptionName%% mislykkedes',
    'subscription-create.warning' => 'Abonnementet %%subscriptionName%% oprettet med nogle få problemer:<br> %%problems%%',
    'subscription-create.warnings.notSynchronizedLink' => 'Du kan prøve at synkronisere det manuelt.',

    'subscription-delete.queue' => 'Sletning af abonnementer behandles',
    'subscription-delete.done' => 'Abonnementer slettet',
    'subscription-delete.error' => 'Sletning af abonnementer mislykkedes',

    'websites-diagnostic.queue' => 'Kører diagnosticering af websteder',
    'websites-diagnostic.done' => 'Diagnosticering af websteder er afsluttet',
    'websites-diagnostic.error' => 'Diagnosticering af websteder er afsluttet med fejl',

    'install-php-extension.queue' => 'Afinstallerer %%extensionName%%-pakken fra PHP-handleren %%phpHandlerName%%',
    'install-php-extension.done' => '%%extensionName%%-pakken blev installeret på PHP-handleren %%phpHandlerName%%',
    'install-php-extension.error' => 'Kunne ikke installere %%extensionName%%-pakken på PHP-handleren %%phpHandlerName%%',
    'install-php-extension.step.validate' => 'Kontrollerer krav',
    'install-php-extension.step.dependencies' => 'Løser afhængigheder',
    'install-php-extension.step.process' => 'Installerer pakke',
    'install-php-extension.step.enable' => 'Aktiverer udvidelse',
    'install-php-extension.step.sync' => 'Synkroniserer websteder',
    'install-php-extension.errorReason' => 'Listen over tilgængelige pakker leveres af PECL. De mest almindelige årsager til en mislykket installation er følgende:',
    'install-php-extension.errorReasonDependencies' => '- Pakken har eksterne afhængigheder på andre biblioteker.',
    'install-php-extension.errorReasonRequirements' => '- Pakken opfylder ikke installationskravene (OS, PHP-version osv.).',
    'install-php-extension.errorReasonOutdated' => '- Pakken er forældet.',
    'install-php-extension.errorOutput' => 'For at identificere årsagen til den mislykkede installation skal du undersøge hjælpeprogrammets output.',

    'uninstall-php-extension.queue' => 'Afinstallerer %%extensionName%%-pakken fra PHP-handleren %%phpHandlerName%%',
    'uninstall-php-extension.done' => '%%extensionName%%-pakken blev afinstalleret fra PHP-handleren %%phpHandlerName%%',
    'uninstall-php-extension.error' => 'Kunne ikke afinstallere %%extensionName%%-pakken fra PHP-handleren %%phpHandlerName%%',
    'uninstall-php-extension.step.validate' => 'Kontrollerer krav',
    'uninstall-php-extension.step.process' => 'Afinstallerer pakke',
    'uninstall-php-extension.step.sync' => 'Synkroniserer websteder',

    'upgrade-database-server.queue' => 'Opgraderer databaseserveren',
    'upgrade-database-server.error' => 'Databaseserveren kunne ikke opgraderes',
    'upgrade-database-server.done' => 'Databaseserveren blev opgraderet',
    'upgrade-database-server.step.validate' => 'Kontrollerer systemet',
    'upgrade-database-server.step.dump' => 'Sikkerhedskopiering af databaser',
    'upgrade-database-server.step.disableService' => 'Deaktiver gammel systemtjeneste',
    'upgrade-database-server.step.configureRepo' => 'Konfigurerer et nyt lager',
    'upgrade-database-server.step.upgradePackages' => 'Opgraderer databaseserveren',
    'upgrade-database-server.step.updateConfiguration' => 'Opdaterer serverkonfiguration',
    'upgrade-database-server.step.startService' => 'Starter ny systemtjeneste',
    'upgrade-database-server.step.upgradeTablesStructure' => 'Opgrader alle tabellers struktur',
    'upgrade-database-server.step.sync' => 'Synkroniserer systemkomponenter',

    'update-spam-filter-individual-settings.queue' => 'Opdatering af indstillinger for spamfilter',
    'update-spam-filter-individual-settings.done' => 'Indstillinger for spamfilter blev opdateret',
    'update-spam-filter-individual-settings.error' => 'Kunne ikke opdatere indstillingerne for spamfilter',
    'update-spam-filter-individual-settings.mailNameError' => 'E-mailadresse %%name%%: %%error%%',

    'update-default-cert.queue' => 'Opdaterer standardcertifikatet',
    'update-default-cert.done' => 'Standardcertifikatet blev opdateret.',
    'update-default-cert.error' => 'Opdateringen af standardcertifikatet blev afsluttet med fejl.',
    'update-default-cert.step.updating' => 'Opdaterer standardcertifikatet…',
];