<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "502 Bad Gateway: upstream sent too big header while reading response header"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => 'まもなく準備が整います。',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.title' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.text' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache "500 Internal Server Error: Option FollowSymLinks not allowed here"',
    'problem-detail.apache-followsymlinks-not-allowed.description' => 'まもなく準備が整います。',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "server reached max_children setting"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>症状</h4><ul><li><p><strong>［ドメイン］</strong> &gt; <strong>example.com</strong> &gt; <strong>［PHP 設定］</strong>でPHP ハンドラが「<strong>Apache で処理される FPM アプリケーション</strong>」または「<strong>nginx で処理される FPM アプリケーション</strong>」に設定されたウェブサイトで、以下のいずれかの問題が発生しています。</p><ul><li><p>読み込みが遅い</p></li><li><p>ウェブブラウザに 50x エラーが表示され利用できない（永久的または一時的）：</p><pre>502 Bad Gateway</pre><hr><pre>503 Service Temporarily Unavailable</pre><hr><pre>504 Gateway Time-out</pre></li></ul></li><li><p> PHP-FPM エラーログファイルに以下のメッセージが表示されます<code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code>（ここで <em>XX</em> はウェブサイトで使用されている PHP のバージョン）：</p><pre>WARNING: [pool example.com] server reached max_children setting (*), consider raising it</pre><ul><li><p>上記のメッセージは通常、こちらのエラーとともに表示されます： </p><pre>unable to read what child say: Bad file descriptor (9)</pre></li></ul></li><li><p>サーバで nginx が有効になっている場合、以下のいずれかのエラーメッセージがドメインのエラーログファイル<code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code> に表示される場合があります。</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 connect() to unix:///var/www/vhosts/system/example.com/php-fpm.sock failed (11: Resource temporarily unavailable) while connecting to upstream, client: 203.0.113.2, server: example.com, request: "GET / HTTP/1.1", upstream: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", host: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 upstream prematurely closed connection while reading response header from upstream, client: 203.0.113.2, server: example.com, request: "POST /path/to/some/file HTTP/2.0", upstream:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' ウェブサイトが <p>PHP-FPM <code>pm.max_children</code> に達しました。</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1.title' => 'pm.max_children の上限を増やす',
    'problem-detail.phpfpm-server-reached-max-children.solution1.text' => '<p>影響を受けたドメインに対して <code>pm.max_children</code> の上限値を増やします。</p><ol><li><p>Plesk に <a href="https://support.plesk.com/hc/en-us/articles/12377512781975" target="_blank" rel="noopener">SSH</a> 経由で接続します。</p></li><li><p>以下のコマンドを使用して、影響を受けたドメインを探します。</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>注：</strong> 左側の数字は、このウェブサイトが<code>pm.max_children</code> の上限に達した回数を示します。</div><pre style="white-space: pre-wrap;"># grep -r "server reached max_children setting" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377667582743" target="_blank" rel="noopener">Plesk にログインします</a>。</p></li><li><p><strong>［ドメイン］</strong> &gt; <strong>example.com</strong> &gt; <strong>［PHP 設定］</strong> &gt; <strong>［PHP-FPM 設定］</strong>の順に選択します。</p></li><li><p>このドメインに対して <code>pm.max_children</code> の値を増やし、変更を適用します。手順 2 で挙げられたすべてのドメインに対してこの値を増やします。</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "Too many open files"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx が Plesk サーバで起動/リロードに失敗する：Too many open files</p><h4>症状</h4><ul><li><p> nginx サービスが起動/リロードに失敗し、<code>/var/log/nginx/error.log</code> ファイルに以下のエラーが表示されます。</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" failed (24: Too many open files)</pre></li><li><p>一部またはすべてのウェブサイトが利用できません。</p></li><li><p><strong>［ツールと設定］&gt; ［診断して修復］</strong>に警告が表示されます。</p><pre style="white-space: pre-wrap;">nginx 値のチェックにより、サーバで N 個のドメインが見つかりました。nginx のデフォルトのファイルオープン上限の問題が考えられます。</pre></li><li><p>NodeJS および Ruby ウェブアプリケーションで、ドメインや契約の作成、Apache または Nginx での変更などの Plesk 関連タスクを実行すると、502 Bad Gateway エラーが表示されます。</p><pre style="white-space: pre-wrap;">Server Error<br>502 Bad Gateway <br>Web server received an invalid response while acting as a gateway or proxy server.</pre></li><li><p> <a href="https://support.plesk.com/hc/en-us/articles/12377676289815-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">ドメイン用に新しい証明書をインストール</a>した後で、<strong>［ドメイン］&gt; example.com &gt;［ホスティング設定］</strong>で正しい証明書が選択されているにも関わらず、古い証明書が引き続きウェブブラウザに表示されます。</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>Nginx の仮想ホストは、物理ホスティングの各仮想ホストに対して 4 つのログファイルを開きます。</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>この結果、ドメインが大量にあることにより（通常は 100 以上）、nginx サーバでファイルオープン数の上限を超過します。</p>',
    'problem-detail.nginx-too-many-open-files.solution1.title' => 'ファイルオープンの上限を増やす',
    'problem-detail.nginx-too-many-open-files.solution1.text' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>警告：</strong> <code>websrv_ulimits</code> ユーティリティを <strong>--no-restart</strong> オプションなしで実行すると、すべてのドメインに対してウェブ構成ファイルの再構築が開始され、ホストされているウェブサイトが多い場合はダウンタイムが長期化する可能性があります。<br><br>コマンドは、メンテナンス期間中に実行してください。</div><p>ファイルオープン数の上限は、<strong>Plesk 上のドメイン数 * 16</strong> 以上に設定することをお勧めします。以下の例では、上限を4096 に設定する方法を説明します。</p><ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377512781975" target="_blank" rel="noopener noreferrer">SSH</a> 経由でサーバに接続します。</p></li><li><p>Apache と Nginx の両方に対し、ファイルオープン数の上限を 4096 に設定します。</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p><strong><a href="https://support.plesk.com/hc/en-us/articles/12377667582743" target="_blank" rel="noopener noreferrer">［Plesk］</a> &gt;</strong> <strong>［ツールと設定］&gt; ［サービス管理］</strong>で Apache および nginx サービスを再起動し、変更を適用します。</p></li><li><p>ウェブサービスの再起動後に、\'Max open files limit\' が適切に適用されていることを確認します。</p><pre># grep \'Max open files\' /proc/$(cat /var/run/nginx.pid)/limits<br>Max open files 4096 4096 file</pre></li><li><p>上記の方法で解決しなかった場合は、<code>ulimit</code> ユーティリティを使用して上限を設定します。</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "Response body too large"',
    'problem-detail.apache-modsec-response-body-too-large.description' => 'まもなく準備が整います。',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "Access denied with code 403"',
    'problem-detail.modsec-access-denied.description' => '<h4>症状</h4><ul><li><p><strong>ModSecurity がインストールされ、［ツールと設定］>［ウェブアプリケーションファイアウォール（ModSecurity）］>［ウェブアプリケーションファイアウォールのモード］ウェブアプリケーションファイアウォールのモード >［オン］</strong>で有効になっています。</p></li><li>Plesk でホストされている特定のウェブサイトの読み込みが失敗します。WordPress の管理、ウェブメールへのアクセス、<code>robots.txt</code> ファイルへのアクセスなどの処理をこのウェブサイトで実行できません。ブラウザに、次のいずれかのエラーが表示される場合があります： <pre>ERR_CONNECTION_REFUSED</pre><hr><pre>403 Forbidden</pre><hr><pre>500 Internal Server Error</pre><hr><pre>ERR_CONNECTION_TIMED_OUT</pre></li><li>以下のような ModSecurity エラーメッセージが <code>/var/log/modsec_audit.log</code> ログファイルまたは Plesk の［ログ］ページに表示されます（<strong>［ドメイン］</strong> &gt; <strong>example.com</strong> &gt; <strong>［ログ］</strong>）：<pre>ModSecurity: Access denied with code 403 (phase 2). Operator GE matched 5 at TX:anomaly_score. [file "/etc/apache2/modsecurity.d/rules/owasp_modsecurity_crs_3-plesk/REQUEST-949-BLOCKING-EVALUATION.conf"] [line "57"] [id "949110"] [msg "Inbound Anomaly Score Exceeded (Total Score: 5)"] [severity "CRITICAL"] [tag "application-multi"] [tag "language-multi"] [tag "platform-multi"] [tag "attack-generic"] [hostname "example.com"] [uri "/robots.txt"] [unique_id "XPsROH8AAQEAABEiZFcAAABC"]</pre></li>',
    'problem-detail.modsec-access-denied.cause' => '<p>ModSecurity Web Application Firewall は、OWASP、Comodo、またはカスタムのルールセット（Imunify360 など）などの非常に制限的なルールセットによって機能しています。制限的なルールセットにより、ウェブサイトの一部の処理がブロックされることがあります。</p><p><Strong>注：</strong> ModSecurity のエラーは、サーバへの攻撃を示す場合もあります。ModSecurity がウェブサイトの有効な使用をブロックしていることが確実である場合に限り、以下の解決策に従ってください。</p>',
    'problem-detail.modsec-access-denied.solution1.title' => 'ID またはタグで ModSecurity ルールセットを無効にする',
    'problem-detail.modsec-access-denied.solution1.text' => '<ol><li><p>ウェブサイトの正当な使用をブロックしているルールの ID を確認します。ID は、<code>/var/log/modsec_audit.log</code> ログファイルのエラーメッセージ内に記載されています。ID は、角括弧内の <code>id</code> というプレフィックスに続く引用符に囲まれた整数で、たとえば <strong>[id "210831"]</strong> です。</p></li><li><a href="https://support.plesk.com/hc/en-us/articles/12377453278871" target="_blank" rel="noopener">Plesk で特定のルールセットを無効にします</a>。</li></ol>',
    'problem-detail.modsec-access-denied.solution2.title' => '別の ModSecurity ルールセットに切り替える',
    'problem-detail.modsec-access-denied.solution2.text' => '<ol><li><p>より制限的ではない ModSecurity ルールセット（たとえば "Atomic ModSecurity Ruleset"）に切り替えます。それには、<strong>［ツールと設定］</strong> > <strong>［ウェブアプリケーションファイアウォール（ModSecurity）］</strong> > <strong>［設定］</strong>の順に移動し、<strong>［Atomic Standard］</strong>を選択してから、<strong>［OK］</strong>をクリックして変更を適用します。</p></li></ol>',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "Internal Server error 500: Allowed memory size of XXX exhausted"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '<h4>症状</h4><ul><li><p>Plesk でホストされているウェブサイトにアクセスできません：</p><pre>500 Internal Server Error</pre></li><li><p>ウェブサイトのログに、以下のエラーが表示されます：</p><pre>Got error "PHP message: PHP Fatal error: Allowed memory size of 4194304 bytes exhausted (tried to allocate 4000032 bytes) in /var/www/vhosts/example.com/httpdocs/somethingBig.php on line 3"</pre></li> </ul>',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '<p>ウェブサイトの処理に十分なメモリが割り当てられていません。</p>',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.title' => 'ウェブサイトの memory_limit を増やす',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377510316183" target="_blank" rel="noopener">KB 記事を読み、その指示に従ってください</a>。</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "open_basedir restriction in effect"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '<h4>症状</h4><ul><li><p>ウェブサイトにアクセスできず、ウェブブラウザに次のいずれかのエラーが表示されます：</p><pre>404 file not found</pre><hr><pre>500 Internal Server Error</pre><hr><pre>Error 500 move_uploaded_file(): open_basedir restriction in effect. File(/path/to/the/directory) is not within the allowed path(s): (/var/www/vhosts/example.com/:/tmp/)</pre></li><li><p>ドメインのログページ（<strong>ドメイン</strong> > <strong>example.com</strong> > <strong>ログ</strong>）に次のいずれかのエラーが表示されます：</p><pre><...> open_basedir restriction in effect. File(/path/to/the/directory) is not within the allowed path(s) <...></pre><hr><pre>Uncaught Exception: Session: Configured save path "/path/to/the/directory" is not a directory, doesn\'t exist or cannot be created.</pre></li></ul>',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => 'PHP スクリプトが、アクセスの許可されていないディレクトリへのアクセスを試みています。この制約事項は PHP <code>open_basedir</code> ディレクティブで各ドメインに対して個別に定義されています。デフォルトで、<code>open_basedir</code> は <code>tmp</code> およびドメインのドキュメントルートディレクトリ、システムのデフォルトセッションパスへのアクセスを許可します。',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.title' => 'open_basedir ディレクティブへのパスを追加する',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377510714135" target="_blank" rel="noopener">KB 記事を読み、その指示に従ってください</a>。</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.title' => 'open_basedir ディレクティブを無効にする',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.text' => '<ol><li><p><strong>［ドメイン］&gt example.com &gt ［PHP 設定］</strong>ページに移動して、<code>open_basedir</code> ディレクティブを "none" に設定します。</p></li></ol>',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 Forbidden AH01797: client denied by server configuration"',
    'problem-detail.apache-client-denied-by-server.description' => '<h4>症状</h4><ul><li><p>ウェブサイトに、以下のものと類似するエラーが表示されます：</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>The <code>/var/www/vhosts/system/example.com/logs/error_log</code> log file contains errors like the following one:</p><pre>AH01797: client denied by server configuration: /var/www/vhosts/example.com/index.php</pre></li></ul>',
    'problem-detail.apache-client-denied-by-server.cause' => '<p>現在の Apache の構成では、ウェブサイトにアクセスできません。</p><p>.htaccess や .htpasswd などのファイルではこれが必要です。これは、これらのファイルが、ウェブサーバ経由でアクセスすべきではないためです。</p>',
    'problem-detail.apache-client-denied-by-server.solution1.title' => 'サーバの構成および .htaccess ファイルをチェックする',
    'problem-detail.apache-client-denied-by-server.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">KB 記事を読み、その指示に従ってください</a>。</p></li></ol>',
    'problem-detail.apache-no-directory-index.name' => 'Apache "Cannot access a website directory in Plesk: 403 Forbidden"',
    'problem-detail.apache-no-directory-index.description' => '<h4>症状</h4><ul><li><p>ウェブサイトの特定の場所にアクセスできません（たとえば <code>http://example.com/some_folder</code>）。以下のエラーが発生します：</p><pre>Server Error 403<br>Forbidden</pre></li><li><p><code>/var/www/vhosts/example.com/logs/error_log<code/> ファイルに以下のエラーが表示されます：</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Cannot serve directory /var/www/vhosts/example.com/httpdocs/some_folder/: No matching DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) found, and server-generated directory index forbidden by Options directive</pre></li></ul>',
    'problem-detail.apache-no-directory-index.cause' => '<p>リクエストされたディレクトリにインデックスファイルが含まれていないか、ディレクトリブラウジングが有効ではありません。</p>',
    'problem-detail.apache-no-directory-index.solution1.title' => 'ディレクトリにインデックスファイルを追加する',
    'problem-detail.apache-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">KB 記事を読み、その指示に従ってください</a>。</p></li></ol>',
    'problem-detail.apache-no-directory-index.solution2.title' => 'ディレクトリブラウジングを有効にする',
    'problem-detail.apache-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377172809495" target="_blank" rel="noopener">KB 記事を読み、その指示に従ってください</a>。</p></li></ol>',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "Cannot access a website directory in Plesk: 403 Forbidden"',
    'problem-detail.nginx-no-directory-index.description' => '<h4>症状</h4><ul><li><p>ウェブサイトの特定の場所にアクセスできません（たとえば <code>http://example.com/some_folder</code>）。以下のエラーが発生します：</p><pre>Server Error 403<br>Forbidden</pre></li><li><p><code>/var/www/vhosts/example.com/logs/error_log</code> ファイルに以下のエラーが表示されます：</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Cannot serve directory /var/www/vhosts/example.com/httpdocs/some_folder/: No matching DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) found, and server-generated directory index forbidden by Options directive</pre></li></ul>',
    'problem-detail.nginx-no-directory-index.cause' => '<p>リクエストされたディレクトリにインデックスファイルが含まれていないか、ディレクトリブラウジングが有効ではありません。</p>',
    'problem-detail.nginx-no-directory-index.solution1.title' => 'ディレクトリにインデックスファイルを追加する',
    'problem-detail.nginx-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">KB 記事を読み、その指示に従ってください</a>。</p></li></ol>',
    'problem-detail.nginx-no-directory-index.solution2.title' => 'ディレクトリブラウジングを有効にする',
    'problem-detail.nginx-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377172809495" target="_blank" rel="noopener">KB 記事を読み、その指示に従ってください</a>。</p></li></ol>',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "server reached MaxRequestWorkers setting"',
    'problem-detail.apache-reached-max-request-workers.description' => 'まもなく準備が整います。',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'PHP リクエストボディ上限 "client intended to send too large body"',
    'problem-detail.php-post-content-length-exceeds-limit.description' => 'まもなく準備が整います。',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'PHP リクエストボディ上限 "client intended to send too large body"',
    'problem-detail.nginx-client-sent-too-large-body.description' => 'まもなく準備が整います。',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'PHP セッション "503 Internal Server Error" or "Failed to read session data"',
    'problem-detail.php-failed-to-read-session-data.description' => 'まもなく準備が整います。',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Forbidden: pcfg_openfile: unable to check htaccess file, ensure it is readable"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '<h4>症状</h4><ul><li><p>Plesk でホストされているウェブサイトが機能していません。</p><pre>このサーバで / にアクセスする権限がありません。<br> さらに、リクエストを処理するために ErrorDocument を使用しようとして、403 Forbidden エラーが発生しました。</pre><p>上記のエラーの代わりに、空白のページが表示される場合もあります。</p></li><li><p><strong>［ドメイン］&gt example.com &gt ［ログ］</strong>にあるドメインエラーログに、以下の内容が含まれています：</p><pre>(13)Permission denied: [client 203.0.113.2:39024] AH00529: /var/www/vhosts/example.com/httpdocs/.htaccess pcfg_openfile: unable to check htaccess file, ensure it is readable and that "/var/www/vhosts/example.com/httpdocs/" is executable</pre></li></ul>',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => 'ドメインのファイルまたはフォルダのパーミッションが正しくありません。',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.title' => 'ウェブサイトコンテンツのパーミッションを修正する',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377773681815" target="_blank" rel="noopener">KB 記事を読み、その指示に従ってください</a>。</p></li></ol>',
];