<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
// This file contains structured and commented locale keys for Plesk 9.x

global $PROD_NAME;

$GLOBALS['lmsg_arr'] += [
    ////
    //// LOGIN SCREEN
    ////

    'login_up__access_denied_account_disabled' => "액세스가 거부됨. 계정이 일시 중단되었습니다.",
    'login_up__login_has_been_locked' => "잘못된 암호로 로그인 시도를 너무 많이 했습니다. 보안상의 이유로 인해 한동안 이 사용자 이름으로 로그인할 수 없습니다.",
    'login_up__unable_to_check_pass' => "암호를 확인할 수 없음: %1",
    'login_up__warning_limits_licence_key' => "다음 항목 중 하나가 라이센스 키에 정의된 제한을 초과함: 서버에 호스팅된 웹 사용자, 메일 계정, 도메인 또는 사용자 계정의 수.\nPlesk 판매 부서에 문의하여 원하는 사용자 및 도메인 수를 호스팅할 수 있는 키를 구입하십시오. 실수로 이 메시지를 받은 경우 Plesk 기술 지원 부서에 문의하십시오.\n사용자 계정/도메인/메일 계정/웹 사용자/언어 팩의 라이센스 제한: %2.\n현재 호스팅된 사용자 계정/도메인/메일 계정/웹 사용자/언어 팩의 수: %3.", // PFW
    'login_up__short_warning_limits_licence_key' => "사용 중인 리소스 양이 현재 제품 라이센스에 정의된 제한을 초과했습니다. Plesk 판매 부서에 문의하여 새 라이센스 키를 구입하십시오.",
    'login_up__grace_period' => '현재 제품 라이센스의 유예 기간 내에서 작동 중입니다. 제품 라이센스를 업데이트하려면 %1라이센스 정보 페이지%2에서 ‘키 검색’ 옵션을 선택합니다.',
    'login_up__partner_license_message' => '등록을 해야 전체 기능 세트를 활성화할 수 있는 제한된 제품 라이센스를 사용하여 현재 작동 중입니다. 제품 라이센스를 업데이트하려면 %1라이센스 정보 페이지%2에서 ‘키 검색’ 옵션을 선택합니다.',
    'login_up__system_admin_disabled' => '고급 사용자(루트 또는 관리자 계정)는 보안상 이유로 인해 Plesk에 로그인할 수 없습니다.',

    ///
    /// Online help keys:
    ///

    'plesk_guide' => "Plesk 관리자 가이드",
    'plesk_guide_reseller' => "Plesk 리셀러 가이드",
    'plesk_guide_client' => "Plesk 고객 가이드",
    'plesk_guide_domain_admin' => "Plesk 도메인 관리자 가이드",
    'plesk_guide_mailuser' => "Plesk 이메일 사용자 가이드",

    ////
    //// COMMON KEYS FOR NAVIGATION THROUGHOUT PANEL
    ////

    ///
    /// NAVIGATION PANE
    ///

    'bt_search' => '검색', // multiple usage: TBI
    'ui__client_unknown__quick-search' => '고객',
    'ui__reseller_unknown__quick-search' => '리셀러',
    'ui__client/domain_unknown__quick-search' => '도메인',
    'nav__general' => '주 메뉴',
    '__home' => '홈',
    '__resellers' => '리셀러',
    '__clients' => '고객',
    '__domains' => '도메인',
    '__applications' => '응용 프로그램',
    '__settings' => '설정',
    'nav__system' => '시스템',
    '__master' => '마스터',

    ///
    /// END OF NAVIGATION PANE
    ///

    ///
    /// NAVIGATION KEYS
    ///

    // up level
    'bt_up_level' => '상위 레벨',

    // object switcher

    ///
    /// END OF NAVIGATION KEYS
    ///

    ///
    /// LISTS
    ///

    // common operations on list objects
    'bt_remove_selected' => '제거',
    'bt_make_default' => '기본값 만들기',

    // common list object operation errors
    'class_cList__empty_selection' => '개체를 선택하지 않았습니다.',

    // common list object search keys
    'clist__search_show' => '검색 표시',
    'clist__search_hide' => '검색 숨기기',

    'bt_show_all' => "검색 재설정",

    // common object list info keys
    'clist__first' => '첫 번째',
    'clist__last' => '마지막',
    'clist__prev' => '<<',
    'clist__next' => '>>',
    'clist__page' => '페이지',
    'clist__page_size' => '페이지당 항목 수',
    'clist__info' => '총 %1: %4',
    'clist__info_empty' => '아니요 %1',
    'clist__info_filter' => '%5 %1개 발견됨(총 %4개)',
    'clist__info_paging' => '총 %4개 중 %1 %2~%3개',
    'clist__info_paging_filter' => '%5개 중 %1 %2~%3개 발견됨(총 %4개)',

    ///
    /// END OF LISTS
    ///

    ////
    //// KEYS FOR USER HOME PAGES
    ////

    ///
    /// COMMON HOME PAGE KEYS
    ///

    // business object controls
    '__object_on' => '활성',
    '__object_off' => '일시 중단됨',

    '__home_description' => '홈 페이지로 돌아갑니다.',
    'indicator_title' => '%1% 사용 중, %2% 사용 가능', // tooltip for visual stats area

    ///
    /// END OF COMMON HOME PAGE KEYS
    ///

    ///
    /// SERVER ADMINISTRATOR
    ///

    '__invalid_url_requested' => '유효하지 않은 URL이 요청되었습니다.',

    // accounts
    // icons
    'ui__reseller_unknown__short-title' => "리셀러 계정",
    'ui__reseller_unknown__title' => "리셀러 계정",
    'ui__reseller_unknown__description' => "리셀러 계정을 관리합니다.",
    'ui__reseller/client_unknown__short-title' => '고객 계정',
    'ui__reseller/client_unknown__title' => '고객 계정',
    'ui__reseller/client_unknown__description' => '고객 계정을 관리합니다.',
    // dropdowns
    'ui__admin-alias_unknown__title' => "추가 관리자 계정", // PFW
    'ui__admin-alias_unknown__short-title' => "추가 관리자 계정", // PFW
    'ui__admin-alias_unknown__description' => "추가 관리자 계정을 보고 관리합니다.", // PFW

    // server
    // icons
    'ui__server/mail__short-title' => "서버 전체 메일 설정",
    'ui__server/mail__title' => "서버 전체 메일 설정",
    'ui__server/mail__description' => "메일 서버를 설정하고 서버 전체의 메일 설정을 구성합니다.",
    'ui__server/dns__short-title' => 'DNS 설정',
    'ui__server/dns__title' => 'DNS 설정',
    'ui__server/dns__description' => '서버 전체의 DNS 설정을 검토하고 업데이트합니다.',
    'ui__server/services__title' => '서비스 관리',
    'ui__server/services__description' => 'Plesk 서비스를 시작, 중지 또는 다시 시작합니다.',
    'ui__server/crontab/task_unknown__short-title' => '예약된 작업',
    'ui__server/crontab/task_unknown__title' => '예약된 작업',
    'ui__server/crontab/task_unknown__description' => '서버 전체의 예약된 작업을 추가하고 제거합니다.',
    'ui__server/ip-address_unknown__short-title' => 'IP 주소',
    'ui__server/ip-address_unknown__title' => 'IP 주소',
    'ui__server/ip-address_unknown__description' => 'IP 주소를 보고 추가하고 제거하고 IP 주소를 리셀러에 할당합니다.',
    // dropdowns
    'ui__server/time__title' => '시스템 시간',
    'ui__server/time__short-title' => '시스템 시간',
    'ui__server/time__description' => '날짜와 시간을 변경하고 NTP 서버와의 동기화를 설정합니다.',
    'ui__server/maillists__title' => '메일링 리스트 서버 설정', // PFU
    'ui__server/maillists__short-title' => '메일링 리스트 서버 설정', // PFU
    'ui__server/maillists__description' => '메일맨 메일링 리스트 서버를 설정합니다.', // PFU
    'ui__mass-email__short-title' => "대량 이메일 메시지", // PFW
    'ui__mass-email__title' => "대량 이메일 메시지", // PFW
    'ui__mass-email__description' => "여러 명의 사용자에게 동시에 이메일 메시지를 보냅니다.", // PFW
    'ui__mass-mail__title' => '대량 이메일 메시지', // PFU
    'ui__mass-mail__short-title' => '대량 이메일 메시지', // PFU
    'ui__mass-mail__description' => '여러 명의 사용자에게 동시에 이메일 메시지를 보냅니다.', // PFU
    'ui__server/spam-filter__title' => '스팸 필터 설정',
    'ui__server/spam-filter__short-title' => '스팸 필터 설정',
    'ui__server/spam-filter__description' => '서버 전체 스팸 필터를 설정합니다.',
    'ui__server/preferences__title' => "서버 설정",
    'ui__server/preferences__short-title' => "서버 설정",
    'ui__server/preferences__description' => "서버 전체의 통계 계산을 설정하고 서버의 호스트 이름을 변경하고 기타 서버 설정을 변경합니다.",

    // help & support
    // icons
    'ui__support__short-title' => '지원',
    'ui__support__title' => '지원',
    'ui__support__description' => '기술 지원 요청을 제출하거나 고객의 지원 티켓을 검토합니다.',
    'ui__license__short-title' => '라이선스 정보',
    'ui__license__title' => 'Plesk 라이선스 정보',
    'ui__license__description' => 'Plesk 라이센스 정보를 보고 새 라이센스 키를 주문합니다.',
    'ui__help__short-title' => '도움말',
    'ui__help__title' => '온라인 도움말',
    'ui__help__description' => '온라인 도움말을 봅니다.',
    'ui__news__short-title' => "새로운 내용",
    'ui__news__title' => "새로운 내용",
    'ui__news__description' => "이 Plesk 버전의 변경 사항 목록을 확인합니다.",
    'ui__server/autoinstaller__short-title' => '업데이트',
    'ui__server/autoinstaller__title' => '업데이트',
    'ui__server/autoinstaller__description' => 'Plesk와 그 구성 요소를 업데이트합니다.',
    // dropdowns

    // domains
    // icons
    'ui__client/domain_unknown__short-title' => '도메인',
    'ui__client/domain_unknown__title' => '도메인',
    'ui__client/domain_unknown__description' => '도메인을 관리합니다.',
    'ui__server/skeleton__short-title' => '가상 호스트 템플릿',
    'ui__server/skeleton__title' => '가상 호스트 템플릿',
    'ui__server/skeleton__description' => '새롭게 만들어진 도메인의 디렉터리에 배치해야 하는 파일과 폴더를 지정합니다.',
    // dropdowns
    'ui__client/domain/chowner_multi-select__title' => '구독에 새 소유자 할당',
    'ui__client/domain/chowner_multi-select__short-title' => '새 구독 소유자 할당',
    'ui__client/domain/chowner_multi-select__description' => '선택한 구독에 새 소유자 할당',
    'ui__client/domain/disable_multi__title' => '도메인 일시 중단',
    'ui__client/domain/disable_multi__short-title' => '도메인 일시 중단',
    'ui__client/domain/disable_multi__description' => '선택한 도메인 일시 중단',
    'ui__client/domain/enable_multi__title' => '도메인 활성화',
    'ui__client/domain/enable_multi__short-title' => '도메인 활성화',
    'ui__client/domain/enable_multi__description' => '선택한 도메인 활성화',

    // icons
    'ui__admin/extras-domain__short-title' => 'MyPlesk.com의 도구',
    'ui__admin/extras-domain__title' => 'MyPlesk.com의 도구',
    'ui__admin/extras-domain__description' => 'MyPlesk.com에서 추가 도구 및 서비스를 얻으십시오.',
    'ui__server/aspdotnet__short-title' => 'ASP.NET 설정', // PFW
    'ui__server/aspdotnet__title' => 'ASP.NET 설정', // PFW
    'ui__server/aspdotnet__description' => '서버 전체의 ASP.NET 설정을 구성합니다.', // PFW
    'ui__server/sitebuilder__short-title' => 'Presence Builder 설정', // PFU
    'ui__server/sitebuilder__title' => 'Presence Builder 설정', // PFU
    'ui__server/sitebuilder__description' => '이 서버에 호스팅된 웹 사이트의 편집을 위해 Presence Builder를 설정합니다.', // PFU
    // dropdowns
    'ui__admin/register-domain__title' => '도메인 등록',
    'ui__admin/register-domain__short-title' => '도메인 등록',
    'ui__admin/register-domain__description' => 'MyPlesk.com을 통해 도메인 이름을 등록합니다.',
    'ui__admin/manage-domain__title' => '도메인 관리',
    'ui__admin/manage-domain__short-title' => '도메인 관리',
    'ui__admin/manage-domain__description' => 'MyPlesk.com을 통해 등록된 도메인 이름을 관리합니다.',
    'ui__server/register__title' => '서버 등록',
    'ui__server/register__short-title' => '서버 등록',
    'ui__server/register__description' => '서버를 등록하여 제휴 프로그램에 가입',

    // logs & statistics
    // icons
    'ui__actionlog__short-title' => '작업 로그',
    'ui__actionlog__title' => '작업 로그',
    'ui__actionlog__description' => '동작 로그를 다운로드하고 동작 로그 설정을 관리합니다.',
    // dropdowns
    'ui__server/statistics__short-title' => '서버 정보',
    'ui__server/statistics__title' => '서버 정보',
    'ui__server/statistics__description' => 'Plesk에서 관리하는 서비스의 통계.',
    'ui__admin/report__title' => '요약 보고서',
    'ui__admin/report__short-title' => '요약 보고서',
    'ui__admin/report__description' => '리셀러, 고객 및 도메인의 트래픽 및 리소스 사용량에 대한 보고서를 봅니다.',

    // security
    // icons
    'ui__sessions/properties__short-title' => '세션 유휴 시간',
    'ui__sessions/properties__title' => '세션 유휴 시간',
    'ui__sessions/properties__description' => 'Plesk 세션의 세션 유휴 시간을 설정합니다.',
    'ui__cp-access__short-title' => 'Plesk에 액세스',
    'ui__cp-access__title' => 'Plesk에 액세스',
    'ui__cp-access__description' => 'Plesk에 대한 액세스를 제한합니다.',
    'ui__sessions__short-title' => '활성 세션',
    'ui__sessions__title' => '활성 세션',
    'ui__sessions__description' => '활성 Plesk 세션을 봅니다.',
    // dropdowns
    'ui__server/certificate_unknown__title' => 'SSL/TLS 인증서',
    'ui__server/certificate_unknown__short-title' => 'SSL/TLS 인증서',
    'ui__server/certificate_unknown__description' => 'SSL/TLS 인증서 목록.',

    // account
    // icons
    'ui__admin-info__short-title' => '개인 데이터',
    'ui__admin-info__title' => '개인 데이터',
    'ui__admin-info__description' => '계정의 개인 데이터를 변경합니다.',
    'ui__admin-password__short-title' => '암호 변경',
    'ui__admin-password__title' => '암호 변경',
    'ui__admin-password__description' => '계정의 암호를 변경합니다.',
    // dropdowns

    ///
    /// END OF SERVER ADMINISTRATOR
    ///

    ///
    /// RESELLER
    ///

    // business objects

    // files
    // icons
    'ui__client/domain/hosting/protected-directories_unknown__short-title' => '암호로 보호된 디렉터리',
    'ui__client/domain/hosting/protected-directories_unknown__title' => '암호로 보호된 디렉터리',
    'ui__client/domain/hosting/protected-directories_unknown__description' => '선택한 웹 사이트 영역에 대한 액세스를 보호합니다.',
    'ui__client/domain/hosting/web-directories_unknown__title' => '가상 디렉터리', // PFW
    'ui__client/domain/hosting/web-directories_unknown__short-title' => '가상 디렉터리', // PFW
    'ui__client/domain/hosting/web-directories_unknown__description' => '웹 사이트 아래의 실제/가상 파일 및 디렉터리에 작업합니다.', // PFW

    // statistics
    // icons
    'ui__reseller/limits__short-title' => '리소스 사용량',
    'ui__reseller/limits__title' => '리소스 사용량',
    'ui__reseller/limits__description' => '리셀러 %1의 리소스 사용량을 보고 관리합니다.',
    'ui__reseller/limits_unknown__short-title' => '리소스 사용량',
    'ui__reseller/limits_unknown__title' => '리소스 사용량',
    'ui__reseller/limits_unknown__description' => '리셀러의 리소스 사용량을 보고 관리합니다.',
    'ui__reseller/limits_self__short-title' => '리소스 사용량',
    'ui__reseller/limits_self__title' => '리소스 사용량',
    'ui__reseller/limits_self__description' => "리소스 사용량을 보고 관리합니다.",
    'ui__reseller/limits_readonly-self__short-title' => '리소스 사용량',
    'ui__reseller/limits_readonly-self__title' => '리소스 사용량',
    'ui__reseller/limits_readonly-self__description' => "리소스 사용량을 봅니다.",
    'ui__reseller/client/traffic_unknown__short-title' => '고객별 트래픽 사용량',
    'ui__reseller/client/traffic_unknown__title' => '고객별 트래픽 사용량 보기',
    'ui__reseller/client/traffic_unknown__description' => '고객 계정에 대한 트래픽 사용량 보고서를 봅니다.',
    'ui__client/traffic_unknown__short-title' => "고객별 트래픽 사용량", // temporary for presets
    'ui__client/traffic_unknown__title' => "고객별 트래픽 사용량 보기", // temporary for presets
    'ui__client/traffic_unknown__description' => "고객 계정에 대한 트래픽 사용량 보고서를 봅니다.", //  temporary for presets
    'ui__client/domain/hosting/logs_unknown__short-title' => '로그 관리자',
    'ui__client/domain/hosting/logs_unknown__title' => '로그 관리자',
    'ui__client/domain/hosting/logs_unknown__description' => '로그를 보고 로그 순환을 구성합니다.',
    // dropdowns
    'ui__reseller/report__title' => '요약 보고서',
    'ui__reseller/report__short-title' => '요약 보고서',
    'ui__reseller/report__description' => '이 리셀러에 대한 트래픽 및 리소스 사용량 보고서를 봅니다.',
    'ui__reseller/report_unknown__title' => '요약 보고서',
    'ui__reseller/report_unknown__short-title' => '요약 보고서',
    'ui__reseller/report_unknown__description' => '리셀러에 대한 트래픽 및 리소스 사용량 보고서를 봅니다.',
    'ui__reseller/report_self__title' => '요약 보고서',
    'ui__reseller/report_self__short-title' => '요약 보고서',
    'ui__reseller/report_self__description' => '트래픽 및 리소스 사용량 보고서를 봅니다.',

    // account
    // icons
    'ui__client/logo_reseller__title' => 'Plesk 브랜딩',
    'ui__client/logo_reseller__short-title' => 'Plesk 브랜딩',
    'ui__client/logo_reseller__description' => '리셀러 %1의 Plesk를 다시 브랜딩합니다.',
    'ui__client/logo_unknown__title' => 'Plesk 브랜딩', // temporary for presets
    'ui__client/logo_unknown__short-title' => 'Plesk 브랜딩', // temporary for presets
    'ui__client/logo_unknown__description' => 'Plesk를 다시 브랜딩합니다.', // temporary for presets
    'ui__client/logo_self-reseller__title' => 'Plesk 브랜딩',
    'ui__client/logo_self-reseller__short-title' => 'Plesk 브랜딩',
    'ui__client/logo_self-reseller__description' => 'Plesk를 다시 브랜딩합니다.',
    'ui__reseller/permissions__title' => '권한',
    'ui__reseller/permissions__short-title' => '권한',
    'ui__reseller/permissions__description' => "리셀러 %1이(가) Plesk에서 수행할 수 있는 동작을 보거나 변경합니다.",
    'ui__reseller/permissions_unknown__short-title' => '권한',
    'ui__reseller/permissions_unknown__title' => '권한',
    'ui__reseller/permissions_unknown__description' => "리셀러가 Plesk에서 수행할 수 있는 동작을 보거나 변경합니다.",
    'ui__reseller/permissions_self__title' => '권한',
    'ui__reseller/permissions_self__short-title' => '권한',
    'ui__reseller/permissions_self__description' => 'Plesk에서 수행할 수 있는 작업 목록을 봅니다.',
    'ui__reseller/permissions_readonly-self__title' => '권한',
    'ui__reseller/permissions_readonly-self__short-title' => '권한',
    'ui__reseller/permissions_readonly-self__description' => 'Plesk에서 수행할 수 있는 작업 목록을 봅니다.',

    // domains
    // icons
    // Domains - see SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - see SERVER ADMINISTRATOR/DOMAINS
    'ui__client/skeleton__title' => '가상 호스트 템플릿',
    'ui__client/skeleton__short-title' => '가상 호스트 템플릿',
    'ui__client/skeleton__description' => '새롭게 만들어진 도메인의 디렉터리에 배치해야 하는 파일과 폴더를 지정합니다.',
    'ui__client/skeleton_unknown__short-title' => '가상 호스트 템플릿',
    'ui__client/skeleton_unknown__title' => '가상 호스트 템플릿',
    'ui__client/skeleton_unknown__description' => '새롭게 만들어진 도메인의 디렉터리에 배치해야 하는 파일과 폴더를 지정합니다.',

    // website
    // icons
    'ui__client/domain/domain-alias_unknown__short-title' => '도메인 별칭',
    'ui__client/domain/domain-alias_unknown__title' => '도메인 별칭',
    'ui__client/domain/domain-alias_unknown__description' => '도메인에 대한 대체 이름 목록을 봅니다.',
    //dropdowns
    'ui__client/domain/dns_unknown__title' => 'DNS 설정',
    'ui__client/domain/dns_unknown__short-title' => 'DNS 설정',
    'ui__client/domain/dns_unknown__description' => '도메인의 DNS 영역 설정을 관리합니다.',
    'ui__client/domain/dns_readonly-unknown__title' => 'DNS 설정',
    'ui__client/domain/dns_readonly-unknown__short-title' => 'DNS 설정',
    'ui__client/domain/dns_readonly-unknown__description' => '도메인의 DNS 영역 설정을 봅니다.',

    // applications & services
    // icons
    'ui__reseller/extras-domain__short-title' => 'MyPlesk.com의 도구',
    'ui__reseller/extras-domain__title' => 'MyPlesk.com의 도구',
    'ui__reseller/extras-domain__description' => 'MyPlesk.com에서 추가 도구 및 서비스를 얻으십시오.',
    'ui__reseller/extras-domain_unknown__short-title' => 'MyPlesk.com의 도구',
    'ui__reseller/extras-domain_unknown__title' => 'MyPlesk.com의 도구',
    'ui__reseller/extras-domain_unknown__description' => 'MyPlesk.com에서 추가 도구 및 서비스를 얻으십시오.',
    'ui__reseller/extras-domain_self__short-title' => 'MyPlesk.com의 도구',
    'ui__reseller/extras-domain_self__title' => 'MyPlesk.com의 도구',
    'ui__reseller/extras-domain_self__description' => 'MyPlesk.com에서 추가 도구 및 서비스를 얻으십시오.',
    'ui__reseller/register-domain__short-title' => '도메인 등록',
    'ui__reseller/register-domain__title' => '도메인 등록',
    'ui__reseller/register-domain__description' => 'MyPlesk.com을 통해 도메인 이름을 등록합니다.',
    'ui__reseller/register-domain_unknown__short-title' => '도메인 등록',
    'ui__reseller/register-domain_unknown__title' => '도메인 등록',
    'ui__reseller/register-domain_unknown__description' => 'MyPlesk.com을 통해 도메인 이름을 등록합니다.',
    'ui__reseller/register-domain_self__short-title' => '도메인 등록',
    'ui__reseller/register-domain_self__title' => '도메인 등록',
    'ui__reseller/register-domain_self__description' => 'MyPlesk.com을 통해 도메인 이름을 등록합니다.',
    // dropdowns
    'ui__reseller/manage-domain__title' => '도메인 관리',
    'ui__reseller/manage-domain__short-title' => '도메인 관리',
    'ui__reseller/manage-domain__description' => 'MyPlesk.com을 통해 등록된 도메인 이름을 관리합니다.',
    'ui__reseller/manage-domain_unknown__title' => '도메인 관리',
    'ui__reseller/manage-domain_unknown__short-title' => '도메인 관리',
    'ui__reseller/manage-domain_unknown__description' => 'MyPlesk.com을 통해 등록된 도메인 이름을 관리합니다.',
    'ui__reseller/manage-domain_self__title' => '도메인 관리',
    'ui__reseller/manage-domain_self__short-title' => '도메인 관리',
    'ui__reseller/manage-domain_self__description' => 'MyPlesk.com을 통해 등록된 도메인 이름을 관리합니다.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown-reseller__title' => 'IP 주소',
    'ui__client/ipaddress_unknown-reseller__short-title' => 'IP 주소',
    'ui__client/ipaddress_unknown-reseller__description' => 'IP 주소를 관리합니다.',
    'ui__client/domain/certificate_unknown__short-title' => 'SSL/TLS 인증서',
    'ui__client/domain/certificate_unknown__title' => 'SSL/TLS 인증서',
    'ui__client/domain/certificate_unknown__description' => 'SSL/TLS 인증서를 설치하고 관리합니다.',
    'ui__reseller/sessions__short-title' => '활성 세션',
    'ui__reseller/sessions__title' => '활성 세션',
    'ui__reseller/sessions__description' => '활성 Plesk 세션을 봅니다.',
    'ui__reseller/sessions_unknown__short-title' => '활성 세션',
    'ui__reseller/sessions_unknown__title' => '활성 세션',
    'ui__reseller/sessions_unknown__description' => '활성 Plesk 세션을 봅니다.',
    'ui__reseller/sessions_self__short-title' => '활성 세션',
    'ui__reseller/sessions_self__title' => '활성 세션',
    'ui__reseller/sessions_self__description' => '활성 Plesk 세션을 봅니다.',

    ///
    /// END OF RESELLER
    ///

    ///
    /// CLIENT
    ///

    // business objects
    'mn_list__mail_names_for_client' => '사용자 계정의 메일 계정 %1',

    // domains
    // icons
    // Domains - SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - SERVER ADMINISTRATOR/DOMAINS
    // Virtual host template - RESELLER/DOMAINS
    'ui__client/skeleton_self__short-title' => '가상 호스트 템플릿',
    'ui__client/skeleton_self__title' => '가상 호스트 템플릿',
    'ui__client/skeleton_self__description' => '새롭게 만들어진 도메인의 디렉터리에 배치해야 하는 파일과 폴더를 지정합니다.',
    // dropdowns
    // Create domain - see RESELLER/DOMAINS
    // Create domain template - see RESELLER/DOMAINS
    // Assign new owner for domains - see SERVER ADMINISTRATOR/DOMAINS
    // Convert Domain Administrator Accounts to Client Accounts - see SERVER ADMINISTRATOR/DOMAINS
    // Update Properties of Multiple Domains - see SERVER ADMINISTRATOR/DOMAINS

    // Suspend domains - see SERVER ADMINISTRATOR/DOMAINS
    // Activate domains - see SERVER ADMINISTRATOR/DOMAINS

    // mail
    // icons
    // Mail accounts - RESELLER/MAIL
    // Create mail account - RESELLER/MAIL
    // Create forwarder - RESELLER/MAIL
    // Create autoresponder - RESELLER/MAIL
    // Mailing lists - RESELLER/MAIL
    // Virus protection - RESELLER/MAIL
    // Spam filtering - RESELLER/MAIL
    // Open Webmail - RESELLER/MAIL
    // dropdowns
    // Mail settings - RESELLER/MAIL
    //Create mailing list - RESELLER/MAIL

    // files
    // icons
    // File manager - RESELLER/FILES
    // Anonymous FTP - RESELLER/FILES
    // FTP accounts - RESELLER/FILES    // PFW
    // SSH terminal - RESELLER/FILES    // PFU
    // Password protected directories - RESELLER/FILES
    // Virtual directories - RESELLER/FILES    // PFW
    // Web directories - RESELLER/FILES    // PFW

    // statistics
    // icons
    // Web statistics - RESELLER/STATISTICS
    'ui__client/limits__short-title' => '리소스 사용량',
    'ui__client/limits__title' => '리소스 사용량',
    'ui__client/limits__description' => "고객 %1의 리소스 사용량을 보고 관리합니다.",
    'ui__client/limits_unknown__short-title' => '리소스 사용량',
    'ui__client/limits_unknown__title' => '리소스 사용량',
    'ui__client/limits_unknown__description' => '고객의 리소스 사용량을 보고 관리합니다.',
    'ui__client/limits_readonly__short-title' => '리소스 사용량',
    'ui__client/limits_readonly__title' => '리소스 사용량',
    'ui__client/limits_readonly__description' => '고객 %1의 리소스 사용량을 봅니다.',
    'ui__client/limits_self__short-title' => '리소스 사용량',
    'ui__client/limits_self__title' => '리소스 사용량',
    'ui__client/limits_self__description' => "리소스 사용량을 보고 관리합니다.",
    'ui__client/limits_readonly-self__short-title' => '리소스 사용량',
    'ui__client/limits_readonly-self__title' => '리소스 사용량',
    'ui__client/limits_readonly-self__description' => "리소스 사용량을 봅니다.",
    'ui__client/domain/traffic_unknown__short-title' => "도메인별 트래픽 사용량 %1",
    'ui__client/domain/traffic_unknown__title' => "도메인별 트래픽 사용량 보기",
    'ui__client/domain/traffic_unknown__description' => "도메인에 대한 트래픽 사용량 보고서를 봅니다.",
    // Log manager - RESELLER/STATISTICS
    // dropdowns
    'ui__client/report__title' => '요약 보고서',
    'ui__client/report__short-title' => '요약 보고서',
    'ui__client/report__description' => '이 고객에 대한 트래픽 및 리소스 사용량 보고서를 봅니다.',
    'ui__client/report_unknown__short-title' => '요약 보고서',
    'ui__client/report_unknown__title' => '요약 보고서',
    'ui__client/report_unknown__description' => '고객에 대한 트래픽 및 리소스 사용량 보고서를 봅니다.',
    'ui__client/report_self__short-title' => '요약 보고서',
    'ui__client/report_self__title' => '요약 보고서',
    'ui__client/report_self__description' => '트래픽 및 리소스 사용에 대한 보고서를 봅니다.',

    // account
    // icons
    'ui__client/preferences__short-title' => '인터페이스 기본 설정',
    'ui__client/preferences__title' => '인터페이스 기본 설정',
    'ui__client/preferences__description' => '고객 %1의 Plesk 인터페이스 기본 설정을 구성합니다.',
    'ui__client/preferences_unknown__short-title' => '인터페이스 기본 설정',
    'ui__client/preferences_unknown__title' => '인터페이스 기본 설정',
    'ui__client/preferences_unknown__description' => "고객의 Plesk에 대한 인터페이스 기본 설정을 지정합니다.",
    'ui__client/preferences_self__short-title' => '인터페이스 기본 설정',
    'ui__client/preferences_self__title' => '인터페이스 기본 설정',
    'ui__client/preferences_self__description' => 'Plesk에 대한 인터페이스 기본 설정을 지정합니다.',
    'ui__client/logo__title' => 'Plesk 브랜딩',
    'ui__client/logo__short-title' => 'Plesk 브랜딩',
    'ui__client/logo__description' => "고객 %1의 Plesk를 다시 브랜딩합니다.",
    'ui__client/logo_self__title' => 'Plesk 브랜딩',
    'ui__client/logo_self__short-title' => 'Plesk 브랜딩',
    'ui__client/logo_self__description' => 'Plesk 브랜딩을 바꾸어 로고 이미지와 브라우저 제목 표시줄을 변경하십시오.',
    'ui__client/permissions__title' => '권한',
    'ui__client/permissions__short-title' => '권한',
    'ui__client/permissions__description' => "고객 %1이(가) Plesk에서 수행할 수 있는 동작을 보거나 변경합니다.",
    'ui__client/permissions_unknown__short-title' => '권한',
    'ui__client/permissions_unknown__title' => '권한',
    'ui__client/permissions_unknown__description' => "고객이 Plesk에서 수행할 수 있는 동작을 보거나 변경합니다.",
    'ui__client/permissions_self__title' => '권한',
    'ui__client/permissions_self__short-title' => '권한',
    'ui__client/permissions_self__description' => "Plesk에서 수행할 수 있는 작업 목록을 봅니다.",
    'ui__client/permissions_readonly-self__title' => '권한',
    'ui__client/permissions_readonly-self__short-title' => '권한',
    'ui__client/permissions_readonly-self__description' => "Plesk에서 수행할 수 있는 작업 목록을 봅니다.",

    // website
    // icons
    // Edit in SiteBuilder - RESELLER/WEBSITE
    // Web hosting settings - RESELLER/WEBSITE
    // Subdomains - RESELLER/WEBSITE
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Frontpage Webadmin - RESELLER/WEBSITE
    // Frontpage SSL/TLS Webadmin - RESELLER/WEBSITE
    // Web users - RESELLER/WEBSITE
    // Site preview - RESELLER/WEBSITE
    // dropdowns
    // DNS settings - RESELLER/WEBSITE
    // Change hosting type - RESELLER/WEBSITE
    // FrontPage management - RESELLER/WEBSITE    // PFW
    // Create subdomain - RESELLER/WEBSITE

    // applications & services
    // icons
    // Web applications - RESELLER/APPLICATIONS & SERVICES
    'ui__client/extras-domain__short-title' => 'MyPlesk.com의 도구',
    'ui__client/extras-domain__title' => 'MyPlesk.com의 도구',
    'ui__client/extras-domain__description' => 'MyPlesk.com에서 추가 도구 및 서비스를 얻으십시오.',
    'ui__client/extras-domain_unknown__short-title' => 'MyPlesk.com의 도구',
    'ui__client/extras-domain_unknown__title' => 'MyPlesk.com의 도구',
    'ui__client/extras-domain_unknown__description' => 'MyPlesk.com에서 추가 도구 및 서비스를 얻으십시오.',
    'ui__client/extras-domain_self__short-title' => 'MyPlesk.com의 도구',
    'ui__client/extras-domain_self__title' => 'MyPlesk.com의 도구',
    'ui__client/extras-domain_self__description' => 'MyPlesk.com에서 추가 도구 및 서비스를 얻으십시오.',
    // Databases - RESELLER/APPLICATIONS & SERVICES
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/register-domain__title' => '도메인 등록',
    'ui__client/register-domain__short-title' => '도메인 등록',
    'ui__client/register-domain__description' => 'MyPlesk.com을 통해 도메인 이름을 등록합니다.',
    'ui__client/register-domain_unknown__title' => '도메인 등록',
    'ui__client/register-domain_unknown__short-title' => '도메인 등록',
    'ui__client/register-domain_unknown__description' => 'MyPlesk.com을 통해 도메인 이름을 등록합니다.',
    'ui__client/register-domain_self__title' => '도메인 등록',
    'ui__client/register-domain_self__short-title' => '도메인 등록',
    'ui__client/register-domain_self__description' => 'MyPlesk.com을 통해 도메인 이름을 등록합니다.',
    // dropdowns
    // Install web application - RESELLER/APPLICATIONS & SERVICES
    // Create database - RESELLER/APPLICATIONS & SERVICES
    // Create database user - RESELLER/APPLICATIONS & SERVICES
    // Install Java application - RESELLER/APPLICATIONS & SERVICES
    'ui__client/manage-domain__title' => '도메인 관리',
    'ui__client/manage-domain__short-title' => '도메인 관리',
    'ui__client/manage-domain__description' => 'MyPlesk.com을 통해 등록된 도메인 이름을 관리합니다.',
    'ui__client/manage-domain_unknown__title' => '도메인 관리',
    'ui__client/manage-domain_unknown__short-title' => '도메인 관리',
    'ui__client/manage-domain_unknown__description' => 'MyPlesk.com을 통해 등록된 도메인 이름을 관리합니다.',
    'ui__client/manage-domain_self__title' => '도메인 관리',
    'ui__client/manage-domain_self__short-title' => '도메인 관리',
    'ui__client/manage-domain_self__description' => 'MyPlesk.com을 통해 등록된 도메인 이름을 관리합니다.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown__title' => 'IP 주소',
    'ui__client/ipaddress_unknown__short-title' => "IP 주소",
    'ui__client/ipaddress_unknown__description' => "IP 주소를 관리합니다.",
    'ui__client/domain/domain-alias_readonly-unknown__short-title' => '도메인 별칭',
    'ui__client/domain/domain-alias_readonly-unknown__title' => '도메인 별칭',
    'ui__client/domain/domain-alias_readonly-unknown__description' => '도메인에 대한 대체 이름 목록을 봅니다.',
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    'ui__client/sessions__short-title' => '활성 세션',
    'ui__client/sessions__title' => '활성 세션',
    'ui__client/sessions__description' => '활성 Plesk 세션을 봅니다.',
    'ui__client/sessions_unknown__short-title' => '활성 세션',
    'ui__client/sessions_unknown__title' => '활성 세션',
    'ui__client/sessions_unknown__description' => '활성 Plesk 세션을 봅니다.',
    'ui__client/sessions_self__short-title' => '활성 세션',
    'ui__client/sessions_self__title' => '활성 세션',
    'ui__client/sessions_self__description' => '활성 Plesk 세션을 봅니다.',
    // Shared SSL/TLS - RESELLER/ADDITIONAL TOOLS    // PFW
    // ASP.NET settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // PHP settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // dropdowns
    //Schedule new task - RESELLER/ADDITIONAL TOOLS

    ///
    /// END OF CLIENT
    ///

    ///
    /// DOMAIN / DOMAIN ADMINISTRATOR
    ///

    // files
    // icons
    'ui__client/domain/hosting/protected-directories__short-title' => '암호로 보호된 디렉터리',
    'ui__client/domain/hosting/protected-directories__title' => '암호로 보호된 디렉터리',
    'ui__client/domain/hosting/protected-directories__description' => '선택한 웹 사이트 영역에 대한 액세스를 보호합니다.',
    'ui__client/domain/hosting/protected-directories_self__short-title' => '암호로 보호된 디렉터리',
    'ui__client/domain/hosting/protected-directories_self__title' => '암호로 보호된 디렉터리',
    'ui__client/domain/hosting/protected-directories_self__description' => '선택한 웹 사이트 영역에 대한 액세스를 보호합니다.',
    'ui__client/domain/hosting/web-directories__title' => '가상 디렉터리', // PFW
    'ui__client/domain/hosting/web-directories__short-title' => '가상 디렉터리', // PFW
    'ui__client/domain/hosting/web-directories__description' => '사이트 %1 아래의 실제/가상 파일 및 디렉터리에 작업합니다.', // PFW
    'ui__client/domain/hosting/web-directories_self__title' => '가상 디렉터리', // PFW
    'ui__client/domain/hosting/web-directories_self__short-title' => '가상 디렉터리', // PFW
    'ui__client/domain/hosting/web-directories_self__description' => '웹 사이트 아래의 실제/가상 파일 및 디렉터리에 작업합니다.', // PFW

    // statistics
    // icons
    'ui__client/domain/traffic__short-title' => '%1 트래픽 사용량',
    'ui__client/domain/traffic__title' => '<b>%1</b>의 데이터 전송 통계',
    'ui__client/domain/traffic__description' => '도메인 %1의 데이터 전송 통계를 봅니다.',
    'ui__client/domain/traffic_self__short-title' => '트래픽 사용량',
    'ui__client/domain/traffic_self__title' => '도메인의 트래픽 사용량을 봅니다.',
    'ui__client/domain/traffic_self__description' => '도메인에 대한 트래픽 사용량 보고서를 봅니다.',
    'ui__client/domain/hosting/logs__short-title' => '로그 관리자',
    'ui__client/domain/hosting/logs__title' => '로그 관리자',
    'ui__client/domain/hosting/logs__description' => '로그를 보고 로그 순환을 구성합니다.',
    'ui__client/domain/hosting/logs_self__short-title' => '로그 관리자',
    'ui__client/domain/hosting/logs_self__title' => '로그 관리자',
    'ui__client/domain/hosting/logs_self__description' => '로그를 보고 로그 순환을 구성합니다.',

    // domain administration
    // dropdowns
    'ui__client/domain/rename__title' => '도메인 이름 바꾸기',
    'ui__client/domain/rename__short-title' => '도메인 이름 바꾸기',
    'ui__client/domain/rename__description' => '도메인 %1 이름을 바꿉니다.',
    'ui__client/domain/rename_unknown__short-title' => '도메인 이름 바꾸기',
    'ui__client/domain/rename_unknown__title' => '도메인 이름 바꾸기',
    'ui__client/domain/rename_unknown__description' => '도메인 이름 바꾸기',
    'ui__client/domain/chowner_select__title' => '도메인에 새 소유자 할당',
    'ui__client/domain/chowner_select__short-title' => '구독에 새 소유자 할당',
    'ui__client/domain/chowner_select__description' => '구독에 새 소유자 할당',
    'ui__client/domain/chowner_unknown-select__short-title' => '구독에 대한 새 소유자 할당',
    'ui__client/domain/chowner_unknown-select__title' => '구독에 대한 새 소유자 할당',
    'ui__client/domain/chowner_unknown-select__description' => '구독에 새 소유자를 할당합니다.',
    'ui__client/domain/toggle__title' => '도메인 일시 중단 또는 활성화', // for HP customization
    'ui__client/domain/toggle__short-title' => '도메인 일시 중단 또는 활성화', // for HP customization
    'ui__client/domain/toggle__description' => '도메인 %1을(를) 일시 중단하거나 활성화합니다.', // for HP customization
    'ui__client/domain/toggle_unknown__title' => '도메인 일시 중단 또는 활성화', // for HP customization
    'ui__client/domain/toggle_unknown__short-title' => '도메인 일시 중단 또는 활성화', // for HP customization
    'ui__client/domain/toggle_unknown__description' => '도메인을 일시 중단하거나 활성화합니다.', // for HP customization
    'ui__client/domain/toggle_enable__title' => '도메인 활성화',
    'ui__client/domain/toggle_enable__short-title' => '도메인 활성화',
    'ui__client/domain/toggle_enable__description' => '도메인 %1을(를) 활성화합니다.',
    'ui__client/domain/toggle_disable__title' => '도메인 일시 중단',
    'ui__client/domain/toggle_disable__short-title' => '도메인 일시 중단',
    'ui__client/domain/toggle_disable__description' => '도메인 %1을(를) 일시 중단합니다.',

    // website
    // icons
    // dropdowns
    'ui__client/domain/dns__title' => 'DNS 설정',
    'ui__client/domain/dns__short-title' => 'DNS 설정',
    'ui__client/domain/dns__description' => '%1 도메인에 대한 DNS 영역 설정을 관리합니다.',
    'ui__client/domain/dns_self__title' => 'DNS 설정',
    'ui__client/domain/dns_self__short-title' => 'DNS 설정',
    'ui__client/domain/dns_self__description' => '도메인에 대한 DNS 영역 설정을 관리합니다.',
    'ui__client/domain/dns_disabled__title' => 'DNS 설정',
    'ui__client/domain/dns_disabled__short-title' => 'DNS 설정',
    'ui__client/domain/dns_disabled__description' => '%1 도메인에 대한 DNS 영역 설정을 관리합니다.',
    'ui__client/domain/dns_self-disabled__title' => 'DNS 설정',
    'ui__client/domain/dns_self-disabled__short-title' => 'DNS 설정',
    'ui__client/domain/dns_self-disabled__description' => '도메인에 대한 DNS 영역 설정을 관리합니다.',
    'ui__client/domain/dns_readonly__title' => 'DNS 설정',
    'ui__client/domain/dns_readonly__short-title' => 'DNS 설정',
    'ui__client/domain/dns_readonly__description' => '도메인 %1의 DNS 영역 설정을 봅니다.',
    'ui__client/domain/dns_readonly-self__title' => 'DNS 설정',
    'ui__client/domain/dns_readonly-self__short-title' => 'DNS 설정',
    'ui__client/domain/dns_readonly-self__description' => '도메인에 대한 DNS 영역 설정을 봅니다.',
    'ui__client/domain/dns_readonly-self-disabled__title' => 'DNS 설정',
    'ui__client/domain/dns_readonly-self-disabled__short-title' => 'DNS 설정',
    'ui__client/domain/dns_readonly-self-disabled__description' => '도메인에 대한 DNS 영역 설정을 봅니다.',
    'ui__client/domain/dns_readonly-self-slave__title' => 'DNS 설정',
    'ui__client/domain/dns_readonly-self-slave__short-title' => 'DNS 설정',
    'ui__client/domain/dns_readonly-self-slave__description' => '도메인에 대한 DNS 영역 설정을 봅니다.',
    'ui__client/domain/dns_slave__title' => 'DNS 설정',
    'ui__client/domain/dns_slave__short-title' => 'DNS 설정',
    'ui__client/domain/dns_slave__description' => '%1 도메인에 대한 DNS 영역 설정을 관리합니다.',
    'ui__client/domain/dns_self-slave__title' => 'DNS 설정',
    'ui__client/domain/dns_self-slave__short-title' => 'DNS 설정',
    'ui__client/domain/dns_self-slave__description' => '도메인에 대한 DNS 영역 설정을 관리합니다.',
    // FrontPage management - RESELLER/WEBSITE    // PFW

    // applications & services
    // icons
    'ui__client/domain/extras__short-title' => 'MyPlesk.com의 도구',
    'ui__client/domain/extras__title' => 'MyPlesk.com의 도구',
    'ui__client/domain/extras__description' => 'MyPlesk.com에서 추가 도구 및 서비스를 얻으십시오.',
    'ui__client/domain/extras_unknown__short-title' => 'MyPlesk.com의 도구',
    'ui__client/domain/extras_unknown__title' => 'MyPlesk.com의 도구',
    'ui__client/domain/extras_unknown__description' => 'MyPlesk.com에서 추가 도구 및 서비스를 얻으십시오.',
    'ui__client/domain/extras_self__short-title' => 'MyPlesk.com의 도구',
    'ui__client/domain/extras_self__title' => 'MyPlesk.com의 도구',
    'ui__client/domain/extras_self__description' => 'MyPlesk.com에서 추가 도구 및 서비스를 얻으십시오.',
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/domain/register__short-title' => '도메인 등록',
    'ui__client/domain/register__title' => '도메인 등록',
    'ui__client/domain/register__description' => 'MyPlesk.com을 통해 도메인 이름을 등록합니다.',
    'ui__client/domain/register_unknown__short-title' => '도메인 등록',
    'ui__client/domain/register_unknown__title' => '도메인 등록',
    'ui__client/domain/register_unknown__description' => 'MyPlesk.com을 통해 도메인 이름을 등록합니다.',
    'ui__client/domain/register_self__short-title' => '도메인 등록',
    'ui__client/domain/register_self__title' => '도메인 등록',
    'ui__client/domain/register_self__description' => 'MyPlesk.com을 통해 도메인 이름을 등록합니다.',
    // dropdowns
    // Create database user - RESELLER/APPLICATIONS & SERVICES

    // additional tools
    // icons
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS    // PFU
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    // dropdowns


    ///
    /// END OF DOMAIN / DOMAIN ADMINISTRATOR
    ///

    ////
    //// KEYS FOR BUSINESS OBJECT LISTS/PAGES (RESELLERS, CLIENTS, DOMAINS)
    ////

    ///
    /// DOMAINS
    ///

    // Domains list page title - ui__client/domain_unknown__short-title (HOME)

    // tools
    'ui__client/domain#tools__title' => "도구",
    // Below: TBD
    'ui__client/domain-summary-report_unknown__short-title' => '통계 보기',
    'ui__client/domain-summary-report_unknown__title' => '통계 보기',
    'ui__client/domain-summary-report_unknown__description' => '도메인을 기준으로 리소스 사용량 정보를 봅니다.',
    'ui__client/domain-summary-report__short-title' => "통계 보기",
    'ui__client/domain-summary-report__title' => "통계 보기",
    'ui__client/domain-summary-report__description' => "도메인을 기준으로 리소스 사용량 정보를 봅니다.",
    'ui__client/domain-summary-report_self__short-title' => "통계 보기",
    'ui__client/domain-summary-report_self__title' => "통계 보기",
    'ui__client/domain-summary-report_self__description' => "도메인을 기준으로 리소스 사용량 정보를 봅니다.",
    // Traffic usage - ui__client/domain/traffic_unknown__short-title

    'ui__client/domain#list__title' => "도메인", // DOMAINS

    // list object operation errors
    'ui__client/domain/delete__empty_selection' => '제거하려는 도메인을 선택해야 합니다.',
    'ui__client/domain/chowner__empty_selection' => '새 소유자에 할당할 도메인을 선택해야 합니다.',

    // list objects filtering
    'domains_list__name__filter_title' => '이름',
    'domains_list__state__filter_title' => '리소스 사용량',
    'domains_list__filter_state_any' => '모두',
    'domains_list__filter_state_overuse' => '초과 사용',
    'domains_list__filter_state_normal' => '제한 이내',
    'domains_list__status__filter_title' => '상태',
    'domains_list__filter_status_any' => '모두',
    'domains_list__filter_status_blocked' => '일시 중단됨',
    'domains_list__filter_status_active' => '활성',
    'domains_list__ownership__filter_title' => '소유권',
    'domains_list__filter_ownership_all' => '모든 도메인',
    'domains_list__filter_ownership_personal' => '내 도메인만',
    'domains_list__filter_owner_pname__filter_title' => '소유자 이름',
    'domains_list__subrows__filter_title' => '표시',
    'domains_list__subrows_off' => '도메인만',
    'domains_list__subrows_subdomain_domainaliases' => '하위 도메인과 별칭 포함',
    'domains_list__subrows_subdomain' => '하위 도메인 포함',
    'domains_list__subrows_domainaliases' => '별칭 포함',

    // objects list
    'domains_list__owner__title' => '소유자',

    ///
    /// END OF DOMAINS
    ///

    ////
    //// KEYS FOR APPLICATION VAULT AND WEB APPLICATION MANAGEMENT
    ////

    ///
    /// APPLICATION VAULT / APS CATALOG
    ///

    // Application Vault / APS Catalog promotional block
    'site_apps__promo_browse_for_applications' => "응용 프로그램 찾아보기",
    'site_apps__promo_main_text' => "APS(Application Packaging Standard) 카탈로그에는 도메인이나 웹 공간에 프로비저닝 가능한 응용 프로그램 목록이 포함되어 있습니다. 현재 카탈로그에 없는 응용 프로그램을 프로비저닝하려면 www.apsstandard.com의 APS 패키징 지침에 따라 간편하게 프로비저닝할 수 있습니다.",
    'site_apps__promo_download_now' => "응용 프로그램 다운로드:",
    'site_apps__promo_close' => "이 블록 닫기",
    'site_apps__promo_preset__mostused' => '%1 자주 사용되는 항목',
    'site_apps__promo_preset__lessused' => '다음 %1 자주 사용되는 항목',
    'site_apps__promo_preset__all' => "모두",
    'site_apps__promo_disclaimer_note' => 'APS 카탈로그에서 설치된 응용 프로그램은 타사 제공이며 Plesk에서 지원되지 않습니다.',
    'site_apps__promo_preset__page_title' => '%1 APS 응용 프로그램',

    // Progress bar
    'site_apps__progress_initialization_message' => '응용 프로그램 추가 중...',

    // Errors
    'site_apps__no_applications_for_update' => '응용 프로그램 저장소에 설치된 응용 프로그램이 없습니다.',
    'site_apps__incorrect_download_preset_configuration' => 'APS 카탈로그 다운로드 사전 설정의 구성에서 오류가 발견되었습니다.',
    'site_apps__aps_catalog_url_is_invalid' => '잘못된 URL을 지정했습니다.',
    'site_apps__no_updates_at_the_moment' => '현재 사용 가능한 응용 프로그램 업데이트가 없습니다.',
    'site_apps__incorrect_content_returned_by_catalog' => 'APS 응용 프로그램 카탈로그에서 잘못된 정보를 받았습니다. 나중에 다시 시도하십시오.',
    'site_apps__entered_aps_catalog_url_is_not_valid' => 'APS 카탈로그 설정이 저장되었지만, Plesk가 APS 카탈로그 설정에 지정된 APS 카탈로그에 연결을 설정할 수 없습니다(%1). APS 카탈로그 주소가 올바르고 이 주소의 APS 카탈로그가 활성 상태인지 확인합니다.',
    'site_apps__cannot_retrieve_updates' => '현재 응용 프로그램 업데이트를 다운로드할 수 없음: APS 카탈로그에 연결을 설정할 수 없습니다(%1). APS 카탈로그 주소가 올바르고 이 주소의 APS 카탈로그가 활성 상태인지 확인합니다.',
    'site_apps__no_site_applications_in_client_pool_to_install' => '설치할 웹 응용 프로그램이 없습니다.',
    'site_apps__site_applications_already_installed_in_root' => '이러한 가상 호스트의 루트 디렉터리에 다른 웹 응용 프로그램이 이미 설치되어 있습니다.',
    'site_apps__dot_net_packages_not_supported_on_unix_platform' => "Unix/Linux 플랫폼에서는 .NET 웹 응용 프로그램이 지원되지 않습니다.",
    'site_apps__server_wide_packages_not_supported' => '서버 전체의 웹 응용 프로그램은 지원되지 않습니다.',
    'site_apps__applications_added_to_queue_for_adding_to_application_vault' => "%1 더 많은 웹 응용 프로그램을 응용 프로그램 저장소에 추가하도록 예약되었습니다.",
    'site_apps__applications_all_in_vault' => "선택한 웹 응용 프로그램이 응용 프로그램 저장소에 이미 있습니다.",
    'site_apps__applications_already_in_download_queue' => "%1 선택한 웹 응용 프로그램을 현재 응용 프로그램 저장소에 추가하는 중입니다.",
    'site_apps__applications_already_in_valut' => "%1 선택한 웹 응용 프로그램이 응용 프로그램 저장소에 이미 있습니다.",

    // UI errors

    ///
    /// END OF APPLICATION VAULT / APS CATALOG
    ///

    ///
    /// APS CATEGORIES
    ///

    // General
    'site_apps__not_categorized' => '기타(분류 안 됨)',

    // Errors
    'site_apps__no_applications_in_category' => '이 범주의 응용 프로그램이 없습니다. 다른 범주를 선택하십시오.',
    'site_apps__no_category_selected__please_specify' => '왼쪽 메뉴에서 범주를 선택합니다. 선택한 범주의 모든 응용 프로그램이 이 창에 나열됩니다.',

    // Category: Back office
    // Category: Collaboration
    // Category: Front Office
    // Category: Infrastructure
    // Category: Personal
    // Category: Web

    ///
    /// END OF APS CATEGORIES
    ///

    ///
    /// APPLICATION VAULT
    ///

    //removal


    ///
    /// END OF APPLICATION VAULT
    ///

    ////
    //// KEYS FOR SETTINGS PAGE
    ////

    ///
    /// SERVER ADMINISTRATOR SETTINGS
    ///

    'administrator_account' => '관리자 계정',
    // Personal data - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Change password - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Interface preferences - HOME/SERVER ADMINISTRATOR/ACCOUNT

    'general' => '일반',
    // Server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_change_hostname' => '호스트 이름 변경',
    // System time - HOME/SERVER ADMINISTRATOR/SERVER
    // IP addresses - HOME/SERVER ADMINISTRATOR/SERVER
    // Scheduled tasks - HOME/SERVER ADMINISTRATOR/SERVER
    // FTP settings - HOME/SERVER ADMINISTRATOR/SERVER    // PFW

    'security' => '보안',
    'bt_setup_firewall' => '방화벽 설정',
    'bt_manage_firewall_rules' => '방화벽 규칙 관리',
    'cu_firewall__rule' => '방화벽 규칙 만들기',
    'cu_firewall__protocol' => '규칙에 대한 프로토콜 설정(\'tcp\' 또는 \'udp\')',
    'cu_firewall__name' => "규칙 이름 설정",
    'cu_firewall__disabled' => '\'true\'인 경우 규칙을 만든 후 규칙이 비활성화됩니다.',
    // Session idle time - HOME/SERVER ADMINISTRATOR/SECURITY
    // SSL/TLS certificates - HOME/SERVER ADMINISTRATOR/SECURITY
    // Shared SSL/TLS - HOME/SERVER ADMINISTRATOR/SECURITY    // PFW

    'dns' => 'DNS',
    'bt_select_dns_server' => 'DNS 서버 선택', // PFW
    'bt_soa_records_template' => 'SOA 레코드 템플릿',
    'bt_restrict_creation_of_subzones' => '하위 영역 만들기 제한',

    'databases' => '데이터베이스',
    // Database hosting preferences - HOME/SERVER ADMINISTRATOR/SERVER

    'applications' => '응용 프로그램',
    // ASP.NET settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // IIS application pool - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // SiteBuilder settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES

    'mail' => '메일',
    'bt_select_mailserver' => '메일 서버 선택', // PFW
    // Mail server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_antivirus' => '안티 바이러스 선택', // PFW
    'bt_virus_protection_settings' => '바이러스 보호 설정',
    'bt_select_spamfilter' => '스팸 필터 선택', // PFW
    // Spam filter settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_webmail' => '웹 메일 선택',
    // Set up mailing lists server - HOME/SERVER ADMINISTRATOR/SERVER    // PFU

    'logs_and_statistics' => '로그 및 통계',
    'bt_server_statistics_settings' => '서버 통계 설정',
    'bt_select_web_statistics' => '사용 가능한 웹 통계 소프트웨어', // PFW
    // Action log - HOME/SERVER ADMINISTRATOR/LOGS & STATISTICS

    'control_panel_interface' => 'Plesk 인터페이스',

    'components_and_modules' => '구성 요소 및 모듈',
    // Server components - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_setup_watchdog' => 'Watchdog 설정', // PFU
    'bt_setup_vpn' => 'VPN 설정', // PFU
    'bt_setup_samba' => 'Samba 설정',    // PFU

    ///
    /// END OF SERVER ADMINISTRATOR SETTINGS
    ///

    ///
    /// DOMAIN SETTINGS
    ///

    'ui__client/domain/settings_self__title' => '설정',
    'ui__client/domain/settings_self__short-title' => '설정',
    'ui__client/domain/settings_self__description' => '도메인 설정을 보고 변경합니다.',

    'domain_administrator_account' => '도메인 관리자 계정',
    // Interface preferences - HOME/DOMAIN ADMINISTRATOR/DOMAIN
    'bt_account_settings' => '계정 설정',

    'domain' => '도메인',
    'bt_dns_soa_records' => 'DNS SOA 레코드',
    // Mail settings - HOME/DOMAIN ADMINISTRATOR/MAIL
    'bt_task_scheduler_settings' => '작업 스케줄러 설정',

    'website' => '웹 사이트',
    // Web hosting settings - HOME/DOMAIN ADMINISTRATOR/WEBSITE
    // Bandwidth limiting - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS
    'bt_web_users_scripting' => '웹 사용자용 스크립팅',
    // Anonymous FTP - HOME/DOMAIN ADMINISTRATOR/FILES

    // Applications - SETTINGS/SERVER/APPLICATIONS    // PFW
    // ASP.NET settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // PHP settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // IIS application pool - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Security - SETTINGS/SERVER/SECURITY
    // Password protected directories - HOME/DOMAIN ADMINISTRATOR/FILES
    'bt_select_ssl_certificate' => 'SSL/TLS 인증서 선택',
    // Shared SSL/TLS - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Logs & statistics - SETTINGS/SERVER/LOGS & STATISTICS
    'bt_web_statistics' => '웹 통계',
    'bt_log_rotation_settings' => '로그 순환 설정',

    ///
    /// END OF DOMAIN SETTINGS
    ///

    ////
    //// KEYS FOR LIMITS AND PERMISSIONS
    ////

    ///
    /// LIMITS
    ///

    '__limits' => "제한", // template

    // overuse & oversell
    'limits__overuse_oversell_policy_legend' => "초과 사용 및 초과 판매 정책",
    'limits__overuse_policy_legend' => "초과 사용",
    'limits__oversell_policy_legend' => "초과 판매",
    'limits__reseller_overuse_description' => "Plesk는 초과 사용 정책에 따라 리소스가 초과 사용되었을 때의 조치를 결정합니다.",
    'limits__overuse_text' => "초과 사용 정책",

    // limit names
    'limit_group__disk_space_and_traffic' => '디스크 공간 및 트래픽',
    'limit__disk_space' => '디스크 공간',
    'limit__max_traffic' => '트래픽',
    'limit_group__client' => '고객',
    'limit__max_cl' => '고객',
    'limit_group__domain' => '도메인',
    'limit__max_dom' => '도메인',
    'limit__max_dom_powerUser' => '구독',
    'limit__max_subdom' => '하위 도메인',
    'limit__max_dom_aliases' => '도메인 별칭',
    'limit__max_wu' => '웹 사용자',
    'limit__max_subftp_users' => '추가 FTP 계정', // PFW
    'limit_group__mail' => '메일',
    'limit__max_box' => '사서함',
    'limit__mbox_quota' => '사서함 크기',
    'limit__total_mboxes_quota' => '총 사서함 할당량', // PFW
    'limit__max_maillists' => '메일링 리스트',
    'limit_group__database' => '데이터베이스',
    'limit__max_mssql_db' => 'Microsoft SQL Server 데이터베이스', // PFW
    'limit__mssql_dbase_space' => '총 MS SQL 데이터베이스 할당량', // PFW
    'limit__max_odbc' => 'ODBC 연결', // PFW
    // limit__max_db - CONFLICTED
    'limit__mysql_dbase_space' => 'MySQL 데이터베이스 할당량', // PFW?
    'limit_group__application' => '응용 프로그램',
    'limit__max_iis_app_pools' => 'IIS 응용 프로그램 풀', // PFW
    'limit_group__security' => '보안',
    'limit_group__validity' => '만료 날짜',
    'limit__expiration' => '만료 날짜',
    'limit__validity' => '유효 기간',
    'limit__max_site_builder' => 'Presence Builder를 사용하여 게시된 사이트',
    'limit__max_site' => '도메인',
    'limit__mssql_dbase_filesize' => 'MS SQL 데이터베이스 파일 크기',
    'limit__mssql_dbase_log_filesize' => 'MS SQL 데이터베이스 로그 파일 크기',
    'limit__mssql_dbase_filesize_hint' => 'Microsoft SQL 데이터베이스 파일의 최대 크기.',
    'limit__mssql_dbase_log_filesize_hint' => 'Microsoft SQL 데이터베이스 로그 파일의 최대 크기.',
    'limit__units_mssql_dbase_filesize' => "MB",
    'limit__units_mssql_dbase_log_filesize' => "MB",

    'dom_pref__invalid_max_site_limit' => '잘못된 트래픽 제한. 최소값이 1입니다.',

    'property__has_wrong_value' => '%1 속성에 잘못된 값이 있습니다.',
    'property__name_outgoing_messages_domain_limit' => '도메인으로부터 나가는 메시지에 적용되는 제한을 설정합니다(시간당). 무제한 값을 설정하려면 "-1"을 지정합니다. "default"을 지정하여 전체 서버 설정에 지정된 값을 설정합니다.',
    'property__name_outgoing_messages_mbox_limit' => '사서함으로부터 나가는 메시지에 적용되는 제한을 설정합니다(시간당). 무제한 값을 설정하려면 "-1"을 지정합니다. "default"을 지정하여 전체 서버 설정에 지정된 값을 설정합니다.',
    'property__name_outgoing_messages_subscription_limit' => '구독으로부터 나가는 메시지에 적용되는 제한을 설정합니다(시간당). 무제한 값을 설정하려면 "-1"을 지정합니다. "default"을 지정하여 전체 서버 설정에 지정된 값을 설정합니다.',

    // for CLI report & email notifications
    '__resource_notify' => '알림',
    '__general' => '일반',
    '__template_shared' => '공유 템플릿',
    'limit__overuse' => '초과 사용 정책',
    'limit__max_traffic_soft' => '트래픽 사용량 도달 시 알림',
    'limit__disk_space_soft' => '디스크 공간 사용량 도달 시 알림',
    '__overuse' => '초과 사용 정책',
    'performance__title' => '성능',
    'performance__bandwidth' => '최대 대역폭 사용량(KB/s)',
    'performance__max_connections' => '연결 제한',

    'gch__hosting_php_isapi' => 'PHP를 ISAPI 확장자로 실행',
    'gch__hosting_ssi_html' => '*.htm, *.html 파일에 SSI 사용',
    'gch__hosting_php_handler_type' => 'PHP를 다음으로 실행',
    'gch__hosting_php_handler_id' => 'PHP를 다음으로 실행',
    'gch__hosting_php_served_by_nginx' => 'nginx에 의해 서비스되는 PHP',
    'gch__hosting_unpaid_website_status' => '웹 사이트가 일시 중단된 구독 상태임',
    'gch__mn_no_autoresponder' => '메일 계정에 자동 회신이 설정되지 않았습니다.',
    'gch__no_clients_selected' => "고객 계정을 선택하지 않았습니다.",
    'gch__no_domains_selected' => "도메인을 선택하지 않습니다.",

    // limit units
    'limit__units_disk_space' => "MB",
    'limit__units_max_traffic' => "MB/월",
    'limit__units_mbox_quota' => "KB",
    'limit__units_mysql_dbase_space' => "MB", // PFW
    'limit__units_mssql_dbase_space' => "MB", // PFW
    'limit__units_total_mboxes_quota' => "MB", // PFW

    // manipulations and statuses of limits
    '__resource_name' => '리소스 이름',
    '__resource_usage' => '사용 중',
    '__resource_limit' => '제한',

    '__used' => '사용 중',
    '__limit' => '제한',

    '__never_expires' => '만료 안 함',
    '__resource_free' => '%1 사용 가능 %2',
    '__resource_unlimited' => '%1 무제한 사용 중',

    '__unlimited' => '제한 없음',
    '__increment' => "늘림(+)",
    '__decrement' => "줄임(-)",
    '__pt' => '단위',
    '__procent' => '%',
    '__overused' => '초과 사용함',
    '__left' => '남음',
    '__available' => '사용 가능',
    '__not_available' => '미포함',

    ///
    /// END OF LIMITS
    ///

    ///
    /// PERMISSIONS
    ///

    //permissions hints

    ///
    /// END OF PERMISSIONS
    ///

    ////
    //// KEYS FOR STATISTICS AND REPORTS
    ////

    ///
    /// REPORT
    ///

    // administrator

    'ui__admin/report/layout/auto_unknown__short-title' => '배달 일정',
    'ui__admin/report/layout/auto_unknown__title' => '보고서 배달 일정',
    'ui__admin/report/layout/auto_unknown__description' => '보고서 레이아웃에 대한 보고서 배달 일정을 선택합니다.',
    'ui__admin/report/layout/auto/properties_new__short-title' => '보고서 배달 일정 추가',
    'ui__admin/report/layout/auto/properties_new__title' => '보고서 배달 일정 추가',
    'ui__admin/report/layout/auto/properties_new__description' => '%1 보고서에 대한 보고서 전달 일정 추가',
    'ui__admin/report/layout/auto/properties__short-title' => '보고서 배달 일정',
    'ui__admin/report/layout/auto/properties__title' => '보고서 배달 일정',
    'ui__admin/report/layout/auto/properties__description' => '보고서 배달 일정의 속성을 보고 수정합니다.',
    'ui__admin/report/layout/auto/delete_multi__short-title' => '보고서 배달 일정 제거',
    'ui__admin/report/layout/auto/delete_multi__title' => '보고서 배달 일정 제거',
    'ui__admin/report/layout/auto/delete_multi__description' => '선택한 보고서 배달 일정을 제거합니다.',

    'ui__admin/report/layout_unknown__short-title' => '보고서 레이아웃',

    // reselle
    'ui__reseller/traffic__short-title' => '%1',
    'ui__reseller/traffic__title' => '<b>%1</b>의 트래픽 사용량 보기',
    'ui__reseller/traffic__description' => '리셀러 계정 %1에 대한 트래픽 사용량 보고서를 봅니다.',
    'ui__reseller/traffic_self__short-title' => '내',
    'ui__reseller/traffic_self__title' => '고객별 트래픽 사용량 보기',
    'ui__reseller/traffic_self__description' => '고객 계정에 대한 트래픽 사용량 보고서를 봅니다.',

       ///
    /// END OF REPORT
    ///

    ///
    /// SUMMARY / FULL REPORT
    ///

    // common full report
    'report__full_p' => 'P',
    'report__full_s' => 'S',
    'report__full_h' => 'H',
    'report__full_reseller_name' => '리셀러 이름', // reseller report
    'report__full_client_name' => '고객 이름', // customer report
    'report__full_domain_name' => '도메인 이름', // domain report
    'report__full_owner' => '소유자', // customer & domain reports
    'report__full_creation_date' => '만든 날짜',
    'report__full_size' => '크기',
    'report__full_traffic' => '트래픽',
    'report__full_active_clients' => '활성 고객', // reseller report
    'report__full_clients' => '고객', // reseller report
    'report__full_active_domains' => '활성 도메인', // reseller & customer reports
    'report__full_domains' => '도메인', // reseller & customer reports
    'report__full_subdomains' => 'Subdom',
    'report__full_mboxes' => 'Mboxes',
    'report__full_disk_space' => '디스크 공간',
    'report__full_mail_groups' => 'MForw',
    'report__full_mail_autoresp' => 'Resp',
    'report__full_mail_antispam' => 'ASpam',
    'report__full_mail_antivirus' => 'AVir',
    'report__full_mail_lists' => 'MailList',
    'report__full_web_users' => 'WebUsr',
    'report__full_mysql_databases' => 'MySQL DB',
    'report__full_mssql_databases' => 'MSSQL DB',

    // common summary report
    'report__section_general' => '일반',
    'report__version' => '제품 버전',
    'report__build' => '제품 빌드',
    'report__status' => '상태',
    'report__company_name' => '회사 이름',
    'report__personal_name' => '개인 이름',
    'report__login' => '사용자 이름',
    'report__phone' => '전화번호',
    'report__fax' => '팩스',
    'report__email' => '이메일',
    'report__address' => '주소',
    'report__city' => '도시',
    'report__state' => '시/도',
    'report__zip_code' => '우편 번호',
    'report__country' => '국가',
    'report__creation_date' => '만든 날짜',
    'report__expiration_date' => '만료 날짜',
    'report__dumps_total_size' => '백업 파일 총 크기',
    'report__section_resellers' => '리셀러',
    'report__active_resellers' => '활성 구독이 있는 리셀러',
    'report__resellers' => '리셀러',
    'report__section_full_resellers' => '리셀러',
    'report__section_clients' => '고객',
    'report__active_clients' => '활성 구독이 있는 고객',
    'report__clients' => '고객',
    'report__section_full_clients' => '고객',
    'report__section_personal_clients' => '자체 고객',
    'report__active_personal_clients' => '활성 구독이 있는 고객',
    'report__personal_clients' => '자체 고객',
    'report__section_full_personal_clients' => '자체 고객',
    'report__section_domains' => '도메인',
    'report__disk_usage' => '디스크 사용량',
    'report__traffic' => '트래픽',
    'report__active_domains' => '활성 도메인',
    'report__domains' => '도메인',
    'report__subdomains' => '하위 도메인',
    'report__mboxes' => '사서함',
    'report__mail_groups' => '메일 전달',
    'report__mail_autoresp' => '자동 회신',
    'report__mail_lists' => '메일링 리스트',
    'report__web_users' => '웹 사용자',
    'report__mysql_databases' => 'MySQL 데이터베이스',
    'report__mssql_databases' => 'MSSQL 데이터베이스',
    'report__section_full_domains' => '도메인',
    'report__section_personal_domains' => '개인 도메인',
    // keys here are the same as in report__section_domains section
    'report__section_full_personal_domains' => '개인 도메인',

    //New for Plesk 10
    'report__sitebuilder_sites' => 'Presence Builder를 사용하여 게시된 사이트',
    'report__invalid_email' => '올바른 이메일 주소를 지정하십시오.',


    // CLI-specific sections
    'report__section_hosting' => '호스팅',
    'report__section_webusers' => '웹 사용자',
    'report__section_mailnames' => '메일 계정',
    'report__section_maillists' => '메일링 리스트',
    'report__section_databases' => '데이터베이스',
    'report__section_siteapps' => '웹 응용 프로그램',
    'report__section_aspnetapps' => 'ASP.NET 응용 프로그램', // PFW
    'report__owner_pname' => "공급자의 개인 이름",
    'report__owner_login' => "공급자의 사용자 이름",

    ///
    /// END OF SUMMARY / FULL REPORT
    ///

    'ui__reseller/report/layout/auto_unknown__short-title' => '배달 일정',
    'ui__reseller/report/layout/auto_unknown__title' => '보고서 배달 일정',
    'ui__reseller/report/layout/auto_unknown__description' => '보고서 레이아웃에 대한 보고서 배달 일정을 선택합니다.',
    'ui__reseller/report/layout/auto/properties_new__short-title' => '보고서 배달 일정 추가',
    'ui__reseller/report/layout/auto/properties_new__title' => '보고서 배달 일정 추가',
    'ui__reseller/report/layout/auto/properties_new__description' => '%1 보고서에 대한 보고서 전달 일정을 추가합니다.',
    'ui__reseller/report/layout/auto/properties__short-title' => '보고서 배달 일정',
    'ui__reseller/report/layout/auto/properties__title' => '보고서 배달 일정',
    'ui__reseller/report/layout/auto/properties__description' => '보고서 배달 일정의 속성을 보고 수정합니다.',
    'ui__reseller/report/layout/auto/delete_multi__short-title' => '보고서 배달 일정 제거',
    'ui__reseller/report/layout/auto/delete_multi__title' => '보고서 배달 일정 제거',
    'ui__reseller/report/layout/auto/delete_multi__description' => '선택한 보고서 배달 일정을 제거합니다.',

    'ui__reseller/report/layout_unknown__short-title' => '보고서 레이아웃',

    // customer
    'ui__client/traffic__short-title' => '%1',
    'ui__client/traffic__title' => '<b>%1</b>의 트래픽 사용량 보기',
    'ui__client/traffic__description' => '고객 계정 %1에 대한 트래픽 사용량 보고서를 봅니다.',
    'ui__client/traffic_self__short-title' => '트래픽 사용량',
    'ui__client/traffic_self__title' => '도메인별 트래픽 사용량',
    'ui__client/traffic_self__description' => '도메인에 대한 트래픽 사용량 보고서를 봅니다.',

    ////
    //// KEYS FOR VARIOUS FEATURES
    ////

    ///
    /// SERVER INTERFACE
    ///

    // Locales
    // errors
    'locales__not_allowed' => '지정된 언어 팩이 설치되어 있지만 시스템에서 활성화되지 않았습니다.',

    ///
    /// END OF SERVER INTERFACE
    ///

    ///
    /// HOME PAGE CUSTOMIZATION
    ///

    ///
    /// SESSIONS
    ///

    // Entry keys are under respective HP/ADDITIONAL TOOLS/ACTIVE SESSIONS

    // administrator
    'ui__sessions/delete__short-title' => '세션 삭제',
    'ui__sessions/delete__title' => '세션 삭제',
    'ui__sessions/delete__description' => '선택한 세션을 삭제합니다.',
    'ui__ftp-sessions__short-title' => 'FTP 세션',
    'ui__ftp-sessions__title' => 'FTP 세션',
    'ui__ftp-sessions__description' => 'FTP 세션을 봅니다.',
    'ui__ftp-sessions/delete__short-title' => 'FTP 세션 삭제',
    'ui__ftp-sessions/delete__title' => 'FTP 세션 삭제',
    'ui__ftp-sessions/delete__description' => '선택한 FTP 세션을 삭제합니다.',

    // reseller
    'ui__reseller/sessions/delete__short-title' => '세션 삭제',
    'ui__reseller/sessions/delete__title' => '세션 삭제',
    'ui__reseller/sessions/delete__description' => '선택한 세션을 삭제합니다.',
    'ui__reseller/sessions/delete_self__short-title' => '세션 삭제',
    'ui__reseller/sessions/delete_self__title' => '세션 삭제',
    'ui__reseller/sessions/delete_self__description' => '선택한 세션을 삭제합니다.',
    'ui__reseller/ftp-sessions__short-title' => 'FTP 세션',
    'ui__reseller/ftp-sessions__title' => 'FTP 세션',
    'ui__reseller/ftp-sessions__description' => 'FTP 세션을 봅니다.',
    'ui__reseller/ftp-sessions_self__short-title' => 'FTP 세션',
    'ui__reseller/ftp-sessions_self__title' => 'FTP 세션',
    'ui__reseller/ftp-sessions_self__description' => 'FTP 세션을 봅니다.',
    'ui__reseller/ftp-sessions/delete__short-title' => 'FTP 세션 삭제',
    'ui__reseller/ftp-sessions/delete__title' => 'FTP 세션 삭제',
    'ui__reseller/ftp-sessions/delete__description' => '선택한 FTP 세션을 삭제합니다.',
    'ui__reseller/ftp-sessions/delete_self__short-title' => 'FTP 세션 삭제',
    'ui__reseller/ftp-sessions/delete_self__title' => 'FTP 세션 삭제',
    'ui__reseller/ftp-sessions/delete_self__description' => '선택한 FTP 세션을 삭제합니다.',

    // customer
    'ui__client/sessions/delete__short-title' => '세션 삭제',
    'ui__client/sessions/delete__title' => '세션 삭제',
    'ui__client/sessions/delete__description' => '선택한 세션을 삭제합니다.',
    'ui__client/sessions/delete_self__short-title' => '세션 삭제',
    'ui__client/sessions/delete_self__title' => '세션 삭제',
    'ui__client/sessions/delete_self__description' => '선택한 세션을 삭제합니다.',

    // domain administrator

    'forgery_token_expired' => '세션 토큰이 만료되었습니다.',

    ///
    /// END OF SESSIONS
    ///

    ///
    /// USER ACCOUNT CONVERSION
    ///

    //
    // USER ACCOUNT TYPE CHANGES
    //

    // resellers > customers
    'downgradeResellers__downgrade_resellers' => '다음 리셀러 계정이 고객 계정으로 변환됩니다.',
    'downgradeResellers__downgrade' => '변환할 리셀러 계정',
    // controls
    'downgradeResellers__submit_downgrade' => '계정 변환을 수행합니다.',
    'downgradeResellers__cancel_downgrade' => '계정 변환을 취소합니다.',
    'downgradeResellers__confirm' => '변환 확인',
    'downgradeResellers__confirm_message' => '진행할 계정 변환 확인',
    // errors

    // customers > resellers
    'picker_client_multi__title' => '고객 계정 선택',
    'upgradeClients__upgrade_clients' => '다음 고객 계정이 리셀러 계정으로 변환됩니다.',
    'upgradeClients__upgrade' => '변환할 고객 계정',
    // controls
    'upgradeClients__submit_upgrade' => '계정 변환을 수행합니다.',
    'upgradeClients__cancel_upgrade' => '계정 변환을 취소합니다.',
    'upgradeClients__confirm' => '변환 확인',
    'upgradeClients__confirm_message' => '진행할 계정 변환 확인',
    // errors
    'upgradeClient__user_is_already_reseller' => '\'%1\' 계정을 리셀러 계정으로 변환할 수 없음: \'%1\'은(는) 이미 리셀러입니다.',

    // domain administrators > customers
    'upgradeDomainUser__upgrade_domain_users' => '다음 도메인 관리자 계정이 고객 계정으로 변환됩니다.',
    'upgradeDomainUser__upgrade' => '변환할 도메인 관리자 계정',
    // controls
    'upgradeDomainUser__submit_upgrade' => '계정 변환을 수행합니다.',
    'upgradeDomainUser__cancel_upgrade' => '계정 변환을 취소합니다.',
    'upgradeDomainUser__confirm' => '변환 확인',
    'upgradeDomainUser__confirm_message' => '진행할 계정 변환 확인',
    // errors
    'upgradeDomainUser__non_upgradeable' => '변환할 수 없는 도메인 관리자 계정',
    'upgradeDomainUser__non_upgradeable_domain_users' => '다음 도메인 관리자 계정을 고객 계정으로 변환할 수 없음:',
    'upgradeDomainUser__some_domains_were_not_converted' => '여러 개의 도메인 관리자 계정을 고객 계정으로 변환할 수 없습니다. %%domainsList%%',
    'upgradeDomainUser__domain_user_does_not_exist' => '도메인 관리자 계정이 없습니다.',
    'upgradeDomainUser__domain_owner_must_be_a_reseller' => "도메인은 서버 관리자나 리셀러에 직접 속해야 합니다.",
    'upgradeDomainUser__all_logins_already_used' => '결과 고객에 대한 계정을 만들 수 없습니다.',
    // notifications
    'upgradeDomainUser__upgrade_notification_subject' => '도메인 관리자 계정이 변환되었습니다.',
    'upgradeDomainUser__upgrade_notification_body' => '도메인 관리자 계정이 사용자 이름이 \'%%login%%\'이고 암호가 \'%%password%%\'인 고객 계정으로 변환되었습니다.',

    //
    // USER ACCOUNT OWNER CHANGES
    //

    // Customer owner change
    // customers selection - reseller & admin home
    'picker_client__title' => '고객 계정 선택',
    // errors
    'clientOwnerChanger__owner_has_no_permission' => '선택된 리셀러에게 \'%1\' 권한이 없지만, 일부 고객에게는 이 권한이 있습니다.',
    'clientOwnerChanger__application_not_allowed' => '\'%1\' 응용 프로그램은 선택된 리셀러가 사용할 수 없지만 일부 고객은 사용할 수 있습니다.',

    // Domain owner change
    'ui__client/domain/chowner_multi-select__wizard-title' => '선택한 구독을 다시 할당하는 중',
    // errors
    'domain_chown__empty_selection' => '선택한 도메인의 새 소유자를 선택해야 합니다.',



    //
    // USER ACCOUNT STATE CHANGES
    //


    ///
    /// END OF USER ACCOUNT CONVERSION
    ///

    ///
    /// BANDWIDTH LIMITING
    ///

    'hosting_performance__traffic_bandwidth_label' => '최대 대역폭 사용량(%1)',
    'hosting_performance__max_connection_label' => '연결 제한',
    'performance__invalid_value' => "값이 잘못되었습니다. 값은 %1에서 %2 사이여야 합니다.",

    ///
    /// END OF BANDWIDTH LIMITING
    ///

    ///
    /// WEBMAIL SELECTION (these keys are currently PfU-only)
    ///

    'webmail__server_legend' => '웹 메일',
    'webmail__server_text' => '사용 가능한 웹 메일 클라이언트',
    'webmail__none' => '없음',

    ///
    /// END OF WEBMAIL SELECTION
    ///


    ////
    //// BACKUP/RESTORATION
    ////

    // random common keys:
    'backup__ip_mapping__server_ip' => '서버 IP 풀',

    ///
    /// END OF BACKUP MANAGER ACTIONS
    ///

    ///
    /// LISTS
    ///


    // Common info/errors:
    'migration_db_server_not_find' => '데이터베이스가 복원되지 않음: 해당 데이터베이스 서버가 없습니다.',

    ///
    /// END OF LISTS
    ///

    ///
    /// COMMON SCREENS
    ///

    // Back Up
    // Comments - __comments
    '__default_backup_comment_server' => "서버 백업.",
    '__default_backup_comment_reseller' => "%1에 의해 리셀러 계정 백업이 생성되었습니다.",
    '__default_backup_comment_client' => "%1에 의해 고객 계정 백업이 생성되었습니다.",
    '__default_backup_comment_domain' => "%1에 의해 구독 백업이 생성되었습니다.",

    // Restoration & backup information

    // IP mapping
    'backup__ip_mapping__title' => 'IP 주소 매핑 정의',
    'backup__ip_mapping__download' => '현재 IP 매핑을 파일로 저장',
    'b_backup__ip_mapping__download' => 'IP 매핑 구성을 다운로드하려면 클릭합니다.',
    'b_backup__ip_mapping__download_is_empty' => 'IP 매핑 구성이 비어 있습니다.',
    'backup__ip_mapping_upload__title' => 'IP 매핑 파일 업로드',
    'backup__ip_mapping__upload' => 'IP 매핑 파일 업로드',
    'b_backup__ip_mapping__upload' => 'IP 매핑 구성을 업로드하려면 클릭합니다.',
    'backup__ip_mapping__list__header' => 'IP 매핑',
    'backup__ip_mapping__list__adddress' => '이전 IP 주소',
    'backup__ip_mapping__list__select_ip' => '새 IP 주소',
    'backup__ip_mapping__clients_ip' => "고객 %1의 IP 풀",
    'backup__ip_mapping__resellers_ip' => "리셀러 %1의 IP 풀",
    'backup__ip_mapping__exclusive_ip_must_be_unique' => '전용 IP 주소를 고유한 IP 주소로 매핑해야 합니다. 목록의 전용 IP 주소 각각에 대해 고유한 IP 주소를 선택합니다.',
    'backup__ip_mapping__legend' => 'IP 매핑',
    'backup__ip_mapping__upload_legend' => '업로드',
    'backup__ip_mapping__upload_file_text' => 'IP 매핑 파일',
    'backup__ip_mapping__upload_file_hint' => 'IP 매핑 파일은 일반 텍스트 파일입니다. 이 파일의 각 라인에는 다음 형식의 IP 매핑이 포함됩니다. <old IP address> <new IP address>',
    'backup__ip_mapping__ip_address_not_found' => '이 유형의 IP 주소는 남아 있지 않습니다.',
    'backup__ip_mapping__ip_address_not_found_hint' => '데이터 전송을 수행할 수 없음: 대상 서버의 풀에 여유 IP 주소가 없어 IP 주소가 완전하게 매핑되지 않습니다.',
    'backup__ip_mapping__ftp_will_be_disabled' => '이 IP 주소가 있는 도메인에 대해 비보안 FTP 연결이 금지됩니다.',
    'backup__ip_mapping__ftps_will_be_disabled' => '이 IP 주소가 있는 도메인에 대해 보안 FTPS 연결이 금지됩니다.',

    // Conflicts occured
    'legend_conflicts_occured' => '충돌',
    'backup__restore__object_vhost' => '가상 호스트',
    'backup__restore__object_plesk_admin' => 'Plesk 관리자',
    'backup__restore__object_ftpuser' => 'FTP 계정',
    'backup__restore__object_frontpageuser' => 'Frontpage 계정',
    'backup__restore__object_webuser' => '웹 사용자',
    'backup__restore__object_domain' => '도메인',
    'backup__restore__object_subdomain' => '하위 도메인',
    'backup__restore__object_domainalias' => '도메인 별칭',
    'backup__restore__object_client' => '고객',
    'backup__restore__object_reseller' => '리셀러',
    'backup__restore__object_autoresponder' => '자동 회신',
    'backup__restore__object_mailalias' => '메일 별칭',
    'backup__restore__object_database' => '데이터베이스',
    'backup__restore__object_mailname' => '메일 계정',
    'backup__restore__object_db_user' => '데이터베이스 사용자',
    'backup__restore__object_ssl_certificate' => 'SSL/TLS 인증서',
    'backup__restore__resellers_cannot_restore_converted_to_customers' => '다음 리셀러는 고객으로 변환되었기 때문에 복원할 수 없습니다. \'%1\'.',
    'backup__restore__customers_cannot_restore_converted_to_resellers' => '다음 고객은 리셀러로 변환되었기 때문에 복원할 수 없습니다. \'%1\'.',
    'backup__restore__customers_cannot_restore_moved_to_another_owners' => '다음 고객은 다른 소유자로 이동되었기 때문에 복원할 수 없습니다: \'%1\'.',

    // Before migration starts
    'backup__restore__capability_not_enough_disk_text' => '선택한 구독을 전부 전송하기에  대상 서버의 디스크 공간이 부족합니다. 사용 가능한 공간: %1 MB. 필요한 공간: %2 MB. 필요한 공간은 웹, 메일 및 도메인의 데이터베이스 내용의 합계로 계산됩니다. 필요한 공간은 하루에 한 번 계산되며 캐시에 저장되므로 도메인의 실제 크기는 계산된 크기와 다를 수 있습니다. 선택한 도메인이 사용 가능한 공간보다 더 많은 공간을 차지하지 않는지 확인하면 전송을 계속할 수 있습니다.',
    'backup__restore__capability_not_enough_disk_resolution' => '대상 서버에서 디스크 공간을 비우십시오.',
    'backup__restore__capability_source_not_enough_disk_text' => '전송을 위한 임시 파일을 저장하기에 소스 서버에 남아 있는 디스크 공간이 부족합니다. 남아 있는 공간: %1 MB. 필요한 공간: %2 MB.',
    'backup__restore__capability_source_not_enough_disk_resolution' => '소스 서버에서 디스크 공간을 비우십시오.',
    'backup__restore__capability_not_enough_disk_resolution_url_text' => '서버 정보',

    'backup__restore__capability_not_installed_component_text' => '대상 서버에서 %1 구성 요소가 설치되어 있지 않습니다. 모든 복원된 개체에 대해 %1을(를) 사용할 수 없게 됩니다.',
    'backup__restore__capability_not_installed_component_resolution' => '%1을(를) 설치하십시오. 이 작업은 몇 분 정도 걸릴 수 있습니다.',
    'backup__restore__capability_existing_sys_user_text' => '%1 이름의 시스템 사용자가 이미 대상 서버에 있습니다.',
    'backup__restore__capability_existing_sys_user_resolution' => '대상 서버에서 기존 시스템 사용자 이름을 변경하십시오.',
    'backup__restore__capability_license_usage_text' => '데이터 전송 후 대상 서버에서 다음 리소스 제한(라이센스 키별로 정의됨)이 초과됩니다.',
    'backup__restore__capability_license_usage_resolution' => '대상 서버에 필요한 양의 리소스를 제공하는 다른 라이센스 키를 설치하십시오.',
    'backup__restore__capability_max_allowed_packet_text' => "소스 데이터베이스 서버에서 'max_allowed_packet' 매개 변수는 %1이며, 이는 대상 서버의 %2보다 큽니다. 아래 지정된 도메인에 대한 일부 데이터베이스 개체가 복원되지 않을 수도 있습니다.",
    'backup__restore__capability_max_allowed_packet_resolution' => "대상 데이터베이스 서버에서 'max_allowed_packet' 값을 증가시키십시오.",

    'backup__restore__capability_postgres_to_lower_version_text' => '대상 서버의 PostgreSQL 버전이 소스 서버보다 오래되었기 때문에 PostgreSQL 데이터베이스를 전송할 수 없습니다. 현재 버전은 %1이고 필요한 버전은 %2입니다.',
    'backup__restore__capability_postgres_to_lower_version_text_resolution' => '대상 서버에 필요한 버전의 PostgreSQL을 설치하십시오.',
    'backup__restore__capability_db_server_connection_problems' => '대상 PostgreSQL 데이터베이스 서버에 연결할 수 없습니다. 연결을 복원하지 않으면 데이터베이스가 전송되지 않습니다.',
    'backup__restore__capability_db_server_connection_problems_resolution' => '대상 데이터베이스 서버에서 연결 설정을 확인하십시오.',
    'backup__restore__capability_component_not_enabled_server_wide_text' => '대상 서버에서 %1 구성 요소가 해제됩니다.',
    'backup__restore__capability_component_not_enabled_server_wide_resolution' => '대상 서버에서 %1 사용을 설정하십시오.',
    'backup__restore__capability_not_configured_component_text' => '대상 서버에서 %1 구성 요소가 구성되어 있지 않습니다.',
    'backup__restore__capability_not_configured_component_resolution' => '도구 및 설정 페이지에서 %1을(를) 구성하십시오.',

    'backup__restore__capability_webmail_is_not_available' => '대상 서버에서 %1 웹 메일 서비스를 사용할 수 없습니다. 대신, Plesk가 다음 웹 메일 서비스를 사용합니다. %2.',
    'backup__restore__capability_webmail_is_not_available_resolution' => '소스 서버와 같은 웹 메일을 사용하려면 이 서버에 설치해야 합니다.',
    'backup__restore__capability_webmail_is_not_installed_resolution' => '소스 서버에서와 같은 웹 메일을 사용하려면 대상 서버에 이를 설치해야 합니다.',
    'backup__restore__capability_webmail_is_not_available_changed_on_subscriptions' => "대상 서버에서 '%1' 웹 메일을 사용할 수 없습니다. 대신 다음 구독: %3에서 Plesk가 다음 웹 메일 서비스를 사용합니다. %2.",
    'backup__restore__capability_webmail_is_not_installed_custom_resolution' => '필요한 웹메일을 대상 서버에 설치하십시오.',
    'backup__restore__capability_webmail_is_not_available_url_text' => '웹 메일 설정',

    'backup__restore__capability_shell_is_not_available' => '셸 %1은(는) 대상 서버에서 사용할 수 없습니다. 대신 사용 가능한 셸 중 하나가 사용됩니다.',
    'backup__restore__capability_shell_is_not_available_resolution' => '소스 서버에서와 동일한 셸을 사용하려면 대상 서버에서 이 셸의 사용을 설정하거나(/기타/셸에서) 셸을 설치해야 합니다.',

    'backup__restore__capability_acl_network_not_allowed_dns_template' => '대상 DNS 서버가 전송 제한 템플릿의 네트워크를 지원하지 않습니다. 네트워크 IP 주소가 DNS 전송 제한에 있는 레코드는 복원되지 않습니다.',
    'backup__restore__capability_acl_network_not_allowed_dns_zone' => '대상 DNS 서버가 전송 제한 템플릿의 네트워크를 지원하지 않지만 일부 구독에 DNS 전송 제한의 네트워크가 있습니다. 네트워크 IP 주소가 DNS 전송 제한에 있는 레코드는 복원되지 않습니다.',

    'backup__restore__capability_wrong_php_handler_text' => '대상 서버에서 PHP 처리기 %1을(를) 사용할 수 없습니다. 대신, Plesk가 다음 PHP 처리기를 사용합니다. %2.',
    'backup__restore__capability_wrong_php_handler_resolution' => '소스 서버에서와 동일한 PHP 처리기를 사용하려면 대상 서버에서 이를 사용 설정하거나 설치해야 합니다.',
    'bu_conflict_resolver_php_handler_replaced_in_plans' => 'PHP 처리기 %1을(를) 사용할 수 없습니다. 대신 Plesk는 다음 서비스 플랜에 대해 %2을(를) 사용합니다. {{objects}}',
    'bu_conflict_resolver_php_handler_replaced_in_sites' => 'PHP 처리기 %1을(를) 사용할 수 없습니다. 대신 Plesk는 다음 웹 사이트에 대해 %2을(를) 사용합니다. {{objects}}',
    'bu_conflict_resolver_php_handler_not_allowed_in_sites' => '%1 PHP 처리기를 사용할 수 없습니다. 다음 웹 사이트는 사용할 수 없습니다.: {{objects}}',

    'backup__restore__capability_wrong_component_version_text' => '%1 %2은(는) 대상 서버에서 사용할 수 없습니다. 대신 기본 버전이 사용됩니다.',
    'backup__restore__capability_wrong_component_version_resolution' => '소스 서버에서와 동일한 %1을(를) 사용하려면 대상 서버에서 이를 사용 설정하거나 설치해야 합니다.',

    'backup__restore__capability_antivirus_not_allowed_outgoing_text' => '대상 서버에 적용되는 바이러스 백신 사용 정책에 따라 나가는 메일에 대한 개별적(이메일 주소별) 바이러스 백신 설정은 허용되지 않습니다. 이러한 설정은 전송되지 않습니다.',
    'backup__restore__capability_antivirus_not_allowed_incoming_text' => '대상 서버에 적용되는 바이러스 백신 사용 정책에 따라 들어오는 메일에 대한 개별적(이메일 주소별) 바이러스 백신 설정은 허용되지 않습니다. 이러한 설정은 전송되지 않습니다.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_text' => '대상 서버에 적용되는 바이러스 백신 사용 정책에 따라 개별적(이메일 주소별) 바이러스 백신 설정은 허용되지 않습니다. 이러한 설정은 전송되지 않습니다.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_resolution' => "개별(이메일 주소별) 바이러스 백신 설정을 전송하려면 도구 및 설정 > 바이러스 보호 설정에서 해당 옵션을 선택하십시오.",
    'backup__restore__capability_antivirus_not_active_text' => '사용 설정된 바이러스 백신 소프트웨어가 없습니다. 대상 서버에서 바이러스 백신 소프트웨어를 선택할 때까지 소스 서버의 모든 바이러스 백신 설정은 적용되지 않습니다.',
    'backup__restore__capability_antivirus_not_active_resolution' => '도구 및 설정 > 바이러스 보호 설정 > 바이러스 백신 설정 부분에서 바이러스 백신 소프트웨어를 선택하십시오.',

    'backup__restore__capability_antivirus_another_active_text' => '바이러스 백신 소프트웨어 %2은(는) 대상 서버에서 사용할 수 없습니다. 대신 %1이(가) 사용됩니다.',
    'backup__restore__capability_antivirus_another_active_resolution' => '소스 서버에서와 같은 바이러스 백신을 사용하려면 이 바이러스 백신을 설치하고 도구 및 설정 > 바이러스 보호 설정 > 바이러스 백신 설정 부분에서 이를 선택하십시오.',
    'backup__restore__capability_not_available_sni_text' => '대상 서버에서 SNI를 사용할 수 없습니다. 동일 IP 주소를 가진 웹 사이트는 개별 SSL/TLS 인증서를 사용할 수 없습니다.',
    'backup__restore__capability_not_available_sni_resolution' => "대상 서버의 운영 체제가 SNI를 지원하고 Plesk에서 SNI에 대한 지원이 설정되어 있는지 확인하십시오(도구 및 설정> 서버 설정의 \\'동일 IP 주소를 가진 웹 사이트에서 개별 SSL/TLS 인증서 사용을 허용하는 SNI 지원 설정\\' 확인란).",
    'backup__restore__capability_not_available_sni_resolution_url_text' => '서버 설정',

    'backup__restore__capability_vhost_already_exists_text' => '웹 사이트 %1을(를) 전송할 수 없습니다. 대상 서버에 동일한 이름을 가진 웹 사이트가 이미 있습니다.',
    'backup__restore__capability_vhost_already_exists_resolution' => '서버에서 동일한 이름을 가진 웹 사이트를 이름 변경하거나 제거하십시오.',
    'backup__restore__capability_removed_vhosts' => '다음 구독은 이미 대상 서버에 있는 도메인 이름을 포함하고 있어 복원되지 않습니다. %1',
    'backup__restore__capability_duplicate_php_handler_text' => '소스 서버에 유형 %1 및 버전 %2의 %3가지 PHP 처리기가 있습니다. 이러한 처리기 대신 적합한 유형과 버전의 처리기 하나가 대상 서버에서 사용됩니다. 소스와 대상 서버에서 PHP 설정이 다를 수도 있습니다.',

    'backup__restore__capability_not_installed_frontpage_resolution' => 'Plesk 설치 프로그램은 Microsoft Frontpage를 지원하지 않습니다.',
    'backup__restore__capability_not_installed_python_resolution' => 'Plesk 설치 프로그램은 Python을 지원하지 않습니다. Python을 수동으로 설치하십시오.',

    'backup__restore__capability_mail_spamfilter_domain_keys_resolution_url_text' => '메일 서버 설정',

    'backup__restore__capability_ftps_disabled' => '소스 서버에서는 보안 FTPS 사용이 허용되지만 대상에서는 금지됩니다. FTP를 사용하는 사용자의 앱이 올바로 작동하지 않을 수도 있습니다.',
    'backup__restore__capability_ftps_required' => '소스 서버에서는 비보안 FTP 사용이 허용되지만 대상에서는 금지됩니다. FTP를 사용하는 사용자의 앱이 올바로 작동하지 않을 수도 있습니다.',
    'backup__restore__capability_ftps_policy_resolution' => '도구 및 설정 > 보안 정책에서 보안 FTP 정책을 변경합니다.',

    'backup__restore__capability_too_much_download_time_text' => '%1 MB의 데이터가 %2시간 후에 소스 서버에서 대상으로 이동합니다.',
    'backup__restore__capability_too_much_download_time_resolution' => '빠른 전송을 위해 소스와 대상 서버의 네트워크 연결 상태를 확인하고 문제가 있으면 해결하기 바랍니다.',
    'backup__restore__too_low_download_speed' => "0.01 미만",
    'backup__restore__capability_too_slow_download_speed_resolution' => '빠른 전송을 위해 소스와 대상 서버의 네트워크 연결 상태를 확인하고 문제가 있으면 해결하기 바랍니다.',
    'backup__restore__capability_zero_download_speed_text' => '허용되는 최소 다운로드 속도는 %1 MBps입니다. 소스 및 대상 서버 간의 다운로드 속도는 0 MBps입니다. 네트워크 연결 문제로 인해 발생한 것일 수 있습니다. 전송이 불가능합니다.',
    'backup__restore__capability_zero_download_speed_resolution' => '소스 및 대상 서버 간의 네트워크 연결을 확인하고 문제를 해결하십시오.',
    'backup__restore__capability_too_slow_download_speed_text' => '허용되는 최소 다운로드 속도는 %2 MBps입니다. 소스와 대상 서버 사이의 다운로드 속도는 %1 MBps입니다. 이로 인해 전송 시간이 늘어날 수 있습니다. 현재 환경에서, %3 MB를 마이그레이션하는 데에는  %4시간이 소요됩니다.',
    'backup__restore__capability_too_slow_download_speed_text_without_diskusage' => '허용되는 최소 다운로드 속도는 %2 MBps입니다. 소스 및 대상 서버 간 다운로드 속도는 %1 MBps입니다. 이 때문에 전송 시간이 증가할 수 있습니다.',

    'backup__restore__capability_remote_database_migration' => "다음 도메인은 원격 데이터베이스를 사용합니다: %1",
    'backup__restore__capability_remote_database_migration_resolution' => "소스 서버에서 Plesk가 11.5 이전 버전인 경우 전송 후 소스 서버로부터 이러한 도메인을 제거하지 마십시오! 그 대신 일시 중단하면 됩니다. 도메인을 제거하면 원격 서버로부터 데이터베이스가 제거됩니다. 참고: 원격 데이터베이스의 덤프 파일은 소스 서버의 %1 디렉터리에 저장됩니다.",

    'backup__restore__capability_mysql_50_to_51_migration' => 'MySQL 5.1.x는 Unicode 문자를 다르게 처리하므로 5.1(%1) 이하 MySQL 데이터베이스 서버의 백업 파일은 MySQL 5.1.x에서 복원되지 않을 수 있습니다.',
    'backup__restore__capability_mysql_50_to_51_migration_resolution' => '',
    'backup__restore__capability_mysql_50_to_51_migration_kb_link_title' => '관련 기술 자료 문서 #136850을 참조하십시오',

    'backup__restore__capability_courier_not_installed_text' => '대상 서버에 Courier-IMAP이 설치되어 있지 않습니다.',
    'backup__restore__capability_courier_not_installed_resolution' => 'Plesk 설치 프로그램을 이용하여 Courier-IMAP을 설치하십시오.',
    'backup__restore__capability_dovecot_not_installed_text' => '대상 서버에 Dovecot가 설치되어 있지 않습니다.',
    'backup__restore__capability_dovecot_not_installed_resolution' => 'Plesk 설치 프로그램을 이용하여 Dovecot를 설치하십시오.',

    'backup__restore__wrong_stat_ttl_value_text' => '다음 개체의 구성에서 트래픽 통계 보존 시간은 대상 서버에서의 서버 단위 값보다 작습니다.',
    'backup__restore__wrong_stat_ttl_value_resolution' => '대상 서버에서 통계 유지 시간에 대한 서버 전체 값을 변경하십시오. 이 시간은 도메인\\ 구성의 최소값 이하로 설정하십시오.',
    'bu_conflict_resolver_wrong_stat_ttl_value' => '동일 도메인에 대한 트래픽 통계 보존 시간은 서버 단위 값(%1)보다 작습니다. 이러한 도메인의 경우 값이 %1(으)로 변경됩니다.',
    'bu_conflict_resolver_wrong_stat_ttl_template_value' => '일부 서비스 플랜의 트래픽 통계 유지 시간이 서버 전체 값(%1)보다 작습니다. 이 서비스 플랜의 값이 %1(으)로 변경됩니다.',

    'backup__ip_mapping__map_dedicated_to_shared_ip' => '공유 주소로 배타적 IP 주소를 매핑하면 익명 FTP 및 HTTPS가 비활성화됩니다(SNI 지원 기능이 켜져 있는 경우는 제외).',

    'backup__restore__no_postgresql_commands_text' => '구독은 원격 PostgreSQL 데이터베이스를 사용하며, 해당 임시 백업 파일을 생성하려면 패널은 소스 서버에 pg_dump 및 psql 명령을 필요로 합니다.',
    'backup__restore__no_postgresql_commands_resolution' => '이러한 명령을 지원하는 PostgreSQL 클라이언트 패키지를 설치하십시오.',
    'backup__restore__capability_apache_modules_disabled_text' => '다음 Apache 모듈은 대상 서버에서 비활성화됩니다: %1.',
    'backup__restore__capability_apache_modules_disabled_resolution' => '가능한 문제를 예방하려면 이 모듈을 활성화하십시오.',
    'backup__restore__capability_apache_modules_not_installed_text' => '다음 Apache 모듈은 대상 서버에 설치되지 않습니다: %1.',
    'backup__restore__capability_apache_modules_not_installed_resolution' => '가능한 문제를 예방하려면 이 모듈을 설치하고 활성화하십시오.',

    'backup__restore__capability_license_not_supported_outgoing_antispam' => '해당 라이센스는 나가는 메시지 제한을 지원하지 않습니다. 해당 구성 설정이 전송되지 않습니다.',
    'backup__restore__capability_license_not_supported_outgoing_antispam_resolution' => '대상 서버에 필요한 기능을 제공하는 다른 라이센스 키를 설치하십시오.',
    'backup__restore__capability_disabled_outgoing_antispam' => '대상 서버에서 나가는 메시지 제한이 해제되어 있습니다. 해당 구성 설정이 전송되지 않습니다.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution' => '대상 서버에서 나가는 메시지 제한이 사용되도록 설정하십시오.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution_url_text' => '서버 전체 메일 설정',

    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported' => '대상 서버에서 사용 중인 메일 서버는 사서함으로부터 나가는 메시지 제한을 지원하지 않습니다. 이 제한 값은 전송되지 않습니다.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution' => '소스 서버에서 사용하는 것과 동일하게 메일 서버를 변경하십시오.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution_url_text' => '서버 전체 메일 설정',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported' => '대상 서버에서 사용 중인 메일 서버는 도메인으로부터 나가는 메시지 제한을 지원하지 않습니다. 이 제한 값은 전송되지 않습니다.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution' => '소스 서버에서 사용하는 것과 동일하게 메일 서버를 변경하십시오.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution_url_text' => '서버 전체 메일 설정',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported' => '대상 서버에서 사용 중인 메일 서버는 구독으로부터 나가는 메시지 제한을 지원하지 않습니다. 이 제한 값은 전송되지 않습니다.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution' => '소스 서버에서 사용하는 것과 동일하게 메일 서버를 변경하십시오.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution_url_text' => '서버 전체 메일 설정',

    'bu_conflict_resolver_absent_phosting' => '복원을 위한 물리적 호스팅이 존재하지 않기 때문에 지정된 파일을 복원할 수 없습니다. 우선 물리적 호스팅을 포함한 도메인을 생성한 다음 백업 복원을 다시 시작하십시오.',
    'bu_conflict_resolver_resellers_management_is_not_supported' => '리셀러 데이터는 리셀러 관리가 지원되지 않기 때문에 복원되지 않습니다.',

    'backup__restore__capability_modsecurity_not_installed_text' => '대상 서버에서 ModSecurity 구성 요소가 설치되어 있지 않습니다.',
    'backup__restore__capability_modsecurity_not_installed_resolution' => '전송된 사이트에 대해 웹 응용 프로그램 방화벽이 계속 작동하도록 하려면 ModSecurity를 설치하십시오. 설치에 몇 분 정도 걸릴 수 있습니다.',
    'backup__restore__capability_modsecurity_not_installed_resolution_for_server' => '웹 응용 프로그램 방화벽의 설정을 전송하려면 ModSecurity를 설치하십시오. 설치에 몇 분 정도 걸릴 수 있습니다.',
    'backup__restore__capability_modsecurity_not_configured_text' => '대상 서버에서 ModSecurity 구성 요소가 구성되어 있지 않습니다.',
    'backup__restore__capability_modsecurity_not_configured_resolution' => '전송된 사이트에 대해 웹 응용 프로그램 방화벽이 계속 작동하도록 하려면 ModSecurity를 구성하십시오.',
    'backup__restore__capability_modsecurity_not_configured_resolution_url_text' => '웹 응용 프로그램 방화벽(ModSecurity)',
    'backup__restore__capability_modsecurity_not_active_text' => '대상 서버에서 ModSecurity가 해제되어 있습니다.',
    'backup__restore__capability_modsecurity_not_active_resolution' => '전송된 사이트에 대해 웹 응용 프로그램 방화벽이 계속 작동하도록 하려면 ModSecurity를 활성화하십시오.',
    'backup__restore__capability_modsecurity_not_active_resolution_url_text' => '웹 응용 프로그램 방화벽(ModSecurity)',
    'bu_conflict_resolver_modsecurity_not_installed' => 'ModSecurity 구성 요소가 설치되지 않았습니다. 다음 개체에 대해 웹 응용 프로그램 방화벽 설정이 복원되지 않습니다. {{개체}}',
    'bu_conflict_resolver_absent_websites_subscription' => "Plesk에서 찾지 못한 구독 %1에 속하기 때문에 웹 사이트를 복원할 수 없습니다.",
    'backup__restore__capability_not_installed_dns_text' => '대상 서버에서 %1 구성 요소가 설치되어 있지 않습니다. DNS 서비스를 사용할 수 없으며 DNS 설정을 잃게 됩니다. 모든 고객 웹 사이트가 다운됩니다.',
    'bu_conflict_resolver_dns_not_installed' => 'DNS 서비스가 설치되지 않았습니다. 다음 개체에 대한 DNS 설정은 복원되지 않습니다. {{objects}}',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_owners' => '다음 구독은 다른 소유자로 이동했기 때문에 복원할 수 없습니다. \'%1\'',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_vendors' => '다음 구독은 다른 공급자로 이동했기 때문에 복원할 수 없습니다. \'%1\'',
    'bu_conflict_resolver_sitebuilder_restore_util_is_not_installed' => 'Web Presence Builder 데이터를 복구할 Web Presence Builder 복원 유틸리티를 찾을 수 없습니다. Web Presence Builder가 설치되어 있지 않을 수 있습니다.',
    'backup__restore__capability_renamed_db' => '데이터베이스 이름 "%1"은(는) 다른 구독에 의해 이미 사용 중입니다. 복원된 데이터베이스 이름이 "%2"(으)로 변경됩니다.',
    'backup__restore__capability_renamed_db_user' => '데이터베이스 사용자 이름 "%1"은(는) 다른 구독에 의해 이미 사용 중입니다. 복원된 데이터베이스 사용자 이름이 "%2"(으)로 변경됩니다.',
    'backup__restore__capability_not_installed_perl_resolution' => 'Plesk 설치 프로그램은 Perl을 지원하지 않습니다. ActiveState Perl을 수동으로 설치하십시오.',
    'backup__restore__capability_php_handler' => '%%version%% %%type%% (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_apache' => '%%version%% %%type%%Apache에 의해 서비스됨(id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_nginx' => '%%version%% %%type%%nginx에 의해 서비스됨(id=%%id%%)',


    '__sni' => 'SNI',
    '__kav' => 'Kaspersky Antivirus',
    '__drweb' => 'Odin Premium Antivirus',

    // Timing conflicts
    'backup__restore__timing_conflicts' => '타이밍 충돌',
    'backup__restore__hint_timing_conflicts' => '복원된 개체가 최근 날짜에 수정된 시스템에 이미 있거나 시스템에 현재 없는 경우 타이밍 충돌이 발생합니다.',
    'backup__restore__text_timing_resolution_policy_overwrite' => '백업의 구성 및 데이터 사용',
    'backup__restore__hint_timing_resolution_policy_overwrite' => '시스템에 현재 있는 개체 구성 및 데이터를 백업 파일의 구성 및 데이터로 완전히 덮어씁니다. 복원된 개체가 현재 다른 소유자에 속하는 경우 이전 소유자 아래로 개체가 복원됩니다.',
    'backup__restore__text_timing_resolution_policy_proceed' =>  '현재 시스템의 구성과 백업 데이터 사용',
    'backup__restore__hint_timing_resolution_policy_proceed' => '현재 개체 데이터를 백업 파일의 데이터로 덮어쓰지만 시스템에 현재 있는 개체 구성을 유지합니다. 복원된 개체가 현재 다른 소유자에 속하는 경우 현재 소유자 아래로 개체가 복원됩니다.',
    'backup__restore__text_timing_resolution_policy_do_not_restore' => '복원하지 않음',
    'backup__restore__hint_timing_resolution_policy_do_not_restore' => '타이밍이 충돌하는 개체를 복원하지 않습니다.',
    // Resource usage conflicts
    'backup__restore__resource_useage_conflicts' => '리소스 사용량 충돌',
    'backup__restore__hint_resource_usage_conflicts' => '복원 시 복원된 개체의 리소스 사용량 제한을 초과하면 리소스 사용량 충돌이 발생합니다.',
    'backup__restore__text_resource_usage_resolution_policy_overusage' => '초과 사용 허용',
    'backup__restore__hint_resource_usage_resolution_policy_overusage' => '개체를 복원하고 처음 제공된 것보다 많은 리소스를 사용하도록 허용합니다.',
    'backup__restore__text_resource_usage_resolution_policy_do_not_restore' => '복원하지 않음',
    'backup__restore__hint_resource_usage_resolution_policy_do_not_restore' => '리소스 사용량이 충돌하는 개체를 복원하지 않습니다.',
    // Configuration conflicts
    'backup__restore__configuration_conflicts' => '구성 충돌',
    'backup__restore__hint_configuration_conflicts' => '현재 서버나 개체 소유자 정책에 의해 금지되거나 사용할 수 없는 웹 응용 프로그램과 설정이 복원된 개체에 있는 경우 구성 충돌이 발생합니다. 예를 들어 서버 전체에 적용되는 현재 정책이 메일 계정의 개별 스팸 필터링 설정을 금지하는 데 복원된 메일 계정에 이러한 설정이 있으면 구성 충돌이 발생합니다.',
    'backup__restore__text_configuration_resolution_policy_automatic' => '자동',
    'backup__restore__hint_configuration_resolution_policy_automatic' => '개체를 복원하고 관리 권한이 있는 모든 충돌하는 구성 옵션을 자동으로 설정합니다.',
    'backup__restore__text_configuration_resolution_policy_do_not_restore' => '복원하지 않음',
    'backup__restore__hint_configuration_resolution_policy_do_not_restore' => '구성이 충돌하는 개체를 복원하지 않습니다.',

    'backup__restore__dedicated_app_pool_restore_to_shared_text' => 'IIS 응용 프로그램 풀 설정에서 전용 IIS 응용 프로그램 풀은 허용되지 않습니다.',
    'backup__restore__dedicated_app_pool_restore_to_shared_resolution' => '도구 및 설정 > IIS 응용 프로그램 풀 > 글로벌 설정에서 IIS 응용 프로그램 풀 설정을 변경하십시오.',
    'backup__restore__shared_app_pool_restore_to_dedicated_text' => 'IIS 응용 프로그램 풀 설정에서 공유 IIS 응용 프로그램 풀은 허용되지 않습니다.',
    'backup__restore__shared_app_pool_restore_to_dedicated_resolution' => '도구 및 설정 > IIS 응용 프로그램 풀 > 글로벌 설정에서 IIS 응용 프로그램 풀 설정을 변경하십시오.',

    'backup__restore__unable_allow_short_pop3 _names_text' => '짧은 POP3/IMAP 메일 계정 이름은 대상 서버에서 허용되지 않습니다.',
    'backup__restore__unable_allow_short_pop3 _names_resolution' => '데이터를 복원하면 메일 계정에 대한 짧은 이름을 사용할 수 없게 됩니다.',

    // Restore status messages & errors:
    'backup__unable_to_open_log_file' => '로그 파일을 열 수 없습니다.',
    'backup__restore__customer_cannot_restore_nonexistent_subscription' => '구독 %1을(를) 복원할 수 없음: 이 구독은 계정에서 제거되었으며 새 구독을 만들 권한이 없습니다. 이 구독을 복원하려면 서비스 공급자에게 연락하십시오.',

    'backup__error11' => '백업하기에 디스크 공간이 부족합니다.',
    'backup__error3011' => '연결이 거부되었습니다. 지정된 주소 및 포트에 수신 대기 중인 프로그램이 없습니다.',
    'backup__error3012' => '연결 시간 초과.',
    'backup__error3013' => '네트워크에 연결할 수 없습니다.',
    'backup__error3014' => '호스팅할 경로 없음.',
    'backup__error3015' => '연결 실패.',
    'backup__error3016' => '호스트 이름을 확인할 수 없습니다.',
    'backup__error3017' => '잘못된 사용자 이름 또는 암호.',
    'backup__error3018' => 'SSH 연결 실패.',

    'backup__error3110' => '원격 마이그레이션 에이전트에 연결할 수 없음: 호스트에 연결할 수 없습니다.',
    'backup__error3111' => '마이그레이션 에이전트가 실패한 마이그레이션 작업에 의해 잠겼거나 다른 마이그레이션 프로세스에 의해 사용 중입니다. 소스 서버에서 마이그레이션 에이전트를 다시 시작하십시오.',
    'backup__error3112' => '호스트에 대한 연결을 사용할 수 없거나 소스 호스트에서 마이그레이션 에이전트가 실행 중이 아닙니다.',
    'backup__error3113' => 'Linux 호스트에 마이그레이션 에이전트를 배포할 수 없습니다. 소스 호스트와의 SSH 연결을 확인하십시오.',
    'backup__error3114' => 'Linux 호스트에 마이그레이션 에이전트를 배포할 수 없음: SSH 연결 실패.',
    'backup__error3115' => '잘못된 사용자 이름 또는 암호.',
    'backup__error3116' => '지정된 사용자에게 관리자 권한이 없습니다.',

    'backup__scheduled_backup_settings__backup_of_domain_all_at_domain' => '모든 구성 및 내용',
    'backup__scheduled_backup_settings__backup_of_domain_vhost_only' => '메일 외의 모든 구성 및 내용',
    'backup__scheduled_backup_settings__backup_of_domain_mail_only' => '메일 구성 및 내용만',

    'dns_t__unable_to_remove_ns_record' => 'DNS 템플릿에서 NS 레코드를 제거할 수 없음: 각 DNS 영역에는 하나 이상의 NS 레코드가 있어야 합니다.',
    'dns__unsupported_server_zone_transfer' => '서버 전체 DNS 구성 때문에 전송 제한 템플릿을 전송할 수 없음: 소스 서버에서 영역 전송에 다음 네트워크 주소가 허용되지만 이러한 주소는 Microsoft DNS 서버에서 금지되어 있습니다. %1',
    'dns__unsupported_domain_zone_transfer' => '도메인\' DNS 구성 때문에 전송 제한 템플릿을 전송할 수 없음: 일부 도메인에서 영역 전송에 다음 네트워크 주소가 허용되지만 이러한 주소는 Microsoft DNS 서버에서 금지되어 있습니다. %1',
    ///
    /// END OF COMMON SCREENS
    ///

    ///
    /// DATABASE BACKUP - PFW // TBD
    ///

    // Actions

    'backup__db_mapping__title' => '데이터베이스 서버 매핑 정의',
    'dbbackup__check_network_settings_failed' => '백업 파일에 대한 공유 임시 네트워크 디렉터리에 액세스할 수 없습니다. 네트워크 디렉터리, 사용자 이름 및 암호 설정을 확인하십시오. 오류: %1',

    'migration_select_exist_db_server' => '대상 데이터베이스 서버 선택',

    'dbbackup__temp_dir_wrong_value' => '임시 디렉터리에 대해 유효하지 않은 값이 지정되었습니다.',
    'dbbackup__network_temp_dir_wrong_value' => '임시 네트워크 디렉터리에 대해 유효하지 않은 값이 지정되었습니다.',
    'dbbackup__server_backup_not_configured' => '서버에서 데이터베이스 백업 설정이 구성되지 않았습니다.',
    'dbbackup__temp_dir' => '임시 디렉터리',
    'dbbackup__temp_dir_hint' => 'MS SQL 서버가 위치하는 원격 서버상의 실제 폴더에 대한 경로. 임시 백업 파일을 읽고 쓰려면 MS SQL 서버가 이 폴더에 액세스할 수 있어야 합니다. 예: C:\\DirectoryPath',
    'dbbackup__network_temp_dir_hint' => '위에 지정된 실제 폴더로 네트워크 공유 경로가 매핑되었습니다. Plesk는 백업 파일을 다운로드 및 업로드할 때 공유 폴더에 액세스합니다. 예: \\\\ServerName\\DirectoryPath',
    'dbbackup__network_user_hint' => '원격 서버에서 생성된 네트워크 사용자의 사용자 이름. 예: ServerName\\UserName. 사용자는 위에 지정된 공유 폴더에 액세스할 수 있어야 합니다.',
    'dbbackup__network_password_hint' => '네트워크 사용자 암호',

    'dbbackup__success_import_without_dublicate_users' => '다음 사용자를 가져오지 못했음: %1. 데이터베이스 서버에 이미 존재합니다.',

    ///
    /// END OF DATABASE BACKUP
    ///

    ///
    /// LOGS & LOG ROTATION
    ///

    'log_rot__compress' => "로그 파일 압축",
    'log_rot__log_rot_status' => "로그 순환 상태",
    'log_rot__log_rot_period' => "로그 순환 조건",
    'log_rot__log_rot_size' => "크기 기준",
    'log_rot__log_rot_time' => "시간 기준",
    'log_rot__logrotation_enable' => "로그 순환 설정",
    'log_rot__mail' => "처리된 로그 파일을 이메일로 보내기",
    'log_rot__max_number_of_logfiles' => "로그 파일 최대 수",
    'log_rot__time_period' => "기간",
    'log_rot__unable_turn_off' => '서버 수준에서 강제로 적용되기 때문에 로그 순환을 끌 수 없습니다.',
    'log_rot__unable_set_period' => '서버 수준에서 강제로 적용되기 때문에 \'일일\'과 다른 로그 순환 기간을 설정할 수 없습니다.',
    'log_rot__unable_set_max_log_files' => '서버 전체의 제한값보다 큰 로그 파일의 최대 개수를 설정할 수 없습니다. %1',

    /// action log
    // common/various
    'actionlog__digit_expected' => "숫자 입력 필요: %1",
    'actionlog__incorrect_rotation' => "잘못된 로그 순환 매개 변수가 지정됨: %1",
    'actionlog__unknown_rot_period' => "알 수 없는 순환 기간: %1",
    'actionlog__unknown_rot_type' => "알 수 없는 순환 유형: %1",
    'actionlog__session_preferences' => '세션 설정',
    // items (PFU schema)
    'actionlog__admin_info' => '관리자 정보',
    'actionlog__admin_preferences' => "관리자 기본 설정",
    'actionlog__service' => '서비스',
    'actionlog__ip_addr' => 'IP 주소',
    'actionlog__client' => '고객 계정',
    'actionlog__client_status' => '고객 계정 상태',
    'actionlog__client_preferences' => "고객의 인터페이스 기본 설정",
    'actionlog__client_ip_pool' => "고객의 IP 풀",
    'actionlog__client_siteapp' => "고객의 웹 응용 프로그램 풀",
    'actionlog__client_guid' => "고객 GUID",
    'actionlog__domain' => '기본 도메인(구독에 추가된 첫 번째 도메인)',
    'actionlog__domain_owner' => '구독 소유자',
    'actionlog__domain_plan' => '구독 서비스 플랜',
    'actionlog__domain_status' => '기본 도메인, 상태',
    'actionlog__domain_dns' => '기본 도메인, DNS 영역',
    'actionlog__subdomain' => '기본 도메인의 하위 도메인',
    'actionlog__domain_alias' => '기본 도메인, 별칭',
    'actionlog__domain_alias_dns' => '기본 도메인, 별칭 DNS 영역',
    'actionlog__site' => '도메인',
    'actionlog__site_status' => '도메인 상태',
    'actionlog__site_dns' => '도메인 DNS 영역',
    'actionlog__site_guid' => '도메인 GUID',
    'actionlog__site_subdomain' => '하위 도메인',
    'actionlog__site_alias' => '도메인 별칭',
    'actionlog__site_alias_dns' => '도메인 별칭 DNS 영역',
    'actionlog__domain_limits' => '구독 제한',
    'actionlog__domain_limit_size' => '구독의 디스크 공간 제한',
    'actionlog__domain_limit_traffic' => '구독의 트래픽 제한',
    'actionlog__domain_limits_powerUser' => '구독 제한',
    'actionlog__domain_limit_size_powerUser' => '구독의 디스크 공간 제한',
    'actionlog__domain_limit_traffic_powerUser' => '구독의 트래픽 제한',
    'actionlog__domain_guid' => "기본 도메인, GUID",
    'actionlog__cp_user' => 'Plesk 사용자',
    'actionlog__mailname' => '메일 계정',
    'actionlog__maillist' => '메일링 리스트',
    'actionlog__phosting' => '호스팅 설정',
    'actionlog__forwarding' => '표준 또는 프레임 전달 호스팅',
    'actionlog__webuser' => '웹 사용자 계정',
    'actionlog__site_application' => '웹 응용 프로그램',
    'actionlog__license' => '라이센스 키',
    'actionlog__additional_license' => '추가 라이센스 키',
    'actionlog__template_domain' => "리셀러의 서비스 플랜",
    'actionlog__template_admin' => "관리자의 서비스 플랜",
    'actionlog__template_reseller' => '리셀러 플랜',
    'actionlog__admin_alias' => '추가 관리자 계정', // PFW
    'actionlog__ftpuser' => '추가 FTP 계정', // PFW
    'actionlog__db_server' => '데이터베이스 서버',
    'actionlog__db' => '데이터베이스',
    'actionlog__db_user' => '데이터베이스 사용자 계정',
    'actionlog__client_sapppkg_pool' => "사용자의 웹 응용 프로그램", // PFW, not used?
    'actionlog__remote_dns' => '원격 DNS 서버 상태', // PFW
    'actionlog__reseller' => '리셀러 계정',
    'actionlog__reseller_guid' => '리셀러 GUID',
    'actionlog__reseller_ip_pool' => "리셀러의 IP 풀",
    'actionlog__reseller_limit_size' => '리셀러 계정의 디스크 공간 제한',
    'actionlog__reseller_limit_traffic' => '리셀러 계정의 트래픽 제한',
    'actionlog__reseller_limits' => '리셀러 계정 제한',
    'actionlog__reseller_permissions' => '리셀러 권한',
    'actionlog__reseller_preferences' => "리셀러의 인터페이스 기본 설정",
    'actionlog__reseller_siteapp' => "리셀러 풀의 웹 응용 프로그램",
    'actionlog__reseller_status' => '리셀러 계정 상태',
    'actionlog__health_status' => '서버 상태',
    // actions (PFU schema)
    'actionlog__limit_reached' => '도달함',
    'actionlog__added' => '추가됨',
    'actionlog__removed' => '제거됨',
    'actionlog__change' => '변경됨',
    'actionlog__update' => '업데이트됨',
    'actionlog__move' => '이동함',
    'actionlog__upgrade' => '업그레이드됨', // PFU?
    'actionlog__update_or_add' => '업데이트 또는 추가됨',
    'actionlog__expired' => '만료됨',
    'actionlog__create' => '만들어짐',
    'actionlog__delete' => '삭제됨',
    'actionlog__service_stop' => '중지됨',
    'actionlog__service_restart' => '다시 시작됨',
    'actionlog__service_start' => '시작됨',
    'actionlog__login' => '로그인됨',
    'actionlog__logout' => '로그아웃됨',
    'actionlog__install' => '설치됨',
    'actionlog__uninstall' => '제거됨',
    'actionlog__reconfigure' => '다시 구성됨',
    // events (PFW schema)
    'actionlog__event_pw_reset' => '암호 재설정 요청',
    'actionlog__event_admin_update' => '관리자 정보가 업데이트됨',
    'actionlog__event_admin_preferences_update' => "관리자 기본 설정 업데이트됨",
    'actionlog__event_service_restart' => '서비스가 다시 시작됨',
    'actionlog__event_service_start' => '서비스가 시작됨',
    'actionlog__event_service_stop' => '서비스가 중지됨',
    'actionlog__event_ip_address_create' => 'IP 주소가 만들어짐',
    'actionlog__event_ip_address_delete' => 'IP 주소가 삭제됨',
    'actionlog__event_ip_address_update' => 'IP 주소가 업데이트됨',
    'actionlog__event_client_create' => '고객 계정이 만들어짐',
    'actionlog__event_client_delete' => '고객 계정이 삭제됨',
    'actionlog__event_client_update' => '고객 계정이 업데이트됨',
    'actionlog__event_client_status_update' => '고객 계정 상태가 업데이트됨',
    'actionlog__event_client_preferences_update' => "고객의 인터페이스 기본 설정이 업데이트됨",
    'actionlog__event_client_siteapp_added' => "웹 응용 프로그램이 고객 계정의 응용 프로그램 풀에 추가됨",
    'actionlog__event_client_siteapp_removed' => "웹 응용 프로그램이 고객 계정의 응용 프로그램 풀에서 제거됨",
    'actionlog__event_domain_limit_size_reached' => '구독의 디스크 공간 제한에 도달함',
    'actionlog__event_domain_limit_traffic_reached' => '구독의 트래픽 제한에 도달함',
    'actionlog__event_domain_limit_size_reached_powerUser' => '구독의 디스크 공간 제한에 도달함',
    'actionlog__event_domain_limit_traffic_reached_powerUser' => '구독의 트래픽 제한에 도달함',

    'actionlog__domain_limit_database' => '구독에 대한 데이터베이스 할당량',
    'actionlog__event_domain_limit_mysql_quota_reached' => '구독에 대한  MySQL 데이터베이스 할당량에 도달했습니다',
    'actionlog__event_domain_limit_mysql_soft_quota_reached' => '구독에 대한  MySQL 데이터베이스 소프트 할당량에 도달했습니다',
    'actionlog__event_domain_limit_mssql_quota_reached' => '구독에 대한  Microsoft SQL 서버 데이터베이스 할당량에 도달했습니다',
    'actionlog__event_domain_limit_mssql_soft_quota_reached' => '구독에 대한 Microsoft SQL 서버 데이터베이스 소프트 할당량에 도달했습니다',
    'actionlog__event_plesk_component_upgrade' => 'Plesk 구성 요소 업데이트됨',
    'actionlog__event_plesk_component_install' => 'Plesk 구성 요소 설치됨',
    'actionlog__event_plesk_component_uninstall' => 'Plesk 구성 요소 제거됨',
    'actionlog__event_domain_create' => '기본 도메인(구독에 추가된 첫 번째 도메인) 생성됨',
    'actionlog__event_domain_delete' => '기본 도메인(구독에 추가된 첫 번째 도메인) 삭제됨',
    'actionlog__event_domain_update' => '기본 도메인(구독에 추가된 첫 번째 도메인) 업데이트됨',
    'actionlog__event_domain_owner_change' => '구독 소유자가 변경됨',
    'actionlog__event_domain_plan_change' => '변경된 구독 서비스 플랜',
    'actionlog__event_domain_status_update' => '기본 도메인, 상태가 업데이트됨',
    'actionlog__event_domain_dns_update' => '기본 도메인, DNS 영역이 업데이트됨',
    'actionlog__event_subdomain_create' => '기본 도메인의 하위 도메인이 만들어짐',
    'actionlog__event_subdomain_delete' => '기본 도메인의 하위 도메인이 삭제됨',
    'actionlog__event_subdomain_update' => '기본 도메인의 하위 도메인이 업데이트됨',
    'actionlog__event_domain_alias_create' => '기본 도메인, 도메인 별칭이 만들어짐',
    'actionlog__event_domain_alias_delete' => '기본 도메인, 도메인 별칭이 삭제됨',
    'actionlog__event_domain_alias_update' => '기본 도메인, 도메인 별칭이 업데이트됨',
    'actionlog__event_domain_limits_update' => '구독 제한이 업데이트됨',
    'actionlog__event_cp_user_login' => '로그인한 Plesk 사용자',
    'actionlog__event_cp_user_logout' => '로그아웃한 Plesk 사용자',
    'actionlog__event_mailname_create' => '메일 계정이 만들어짐',
    'actionlog__event_mailname_delete' => '메일 계정이 삭제됨',
    'actionlog__event_mailname_update' => '메일 계정이 업데이트됨',
    'actionlog__event_maillist_create' => '메일링 리스트가 만들어짐',
    'actionlog__event_maillist_delete' => '메일링 리스트가 삭제됨',
    'actionlog__event_maillist_update' => '메일링 리스트가 업데이트됨',
    'actionlog__event_phys_hosting_create' => '실제 호스팅이 만들어짐',
    'actionlog__event_phys_hosting_delete' => '실제 호스팅이 삭제됨',
    'actionlog__event_phys_hosting_update' => '실제 호스팅이 업데이트됨',
    'actionlog__event_forwarding_create' => '표준 또는 프레임 전달 호스팅이 만들어짐',
    'actionlog__event_forwarding_delete' => '표준 또는 프레임 전달 호스팅이 삭제됨',
    'actionlog__event_forwarding_update' => '표준 또는 프레임 전달 호스팅이 업데이트됨',
    'actionlog__event_webuser_create' => '웹 사용자 계정이 만들어짐',
    'actionlog__event_webuser_delete' => '웹 사용자 계정이 삭제됨',
    'actionlog__event_webuser_update' => '웹 사용자 계정이 업데이트됨',
    'actionlog__event_siteapp_install' => '웹 응용 프로그램이 설치됨',
    'actionlog__event_siteapp_reconfigure' => '웹 응용 프로그램이 다시 구성됨',
    'actionlog__event_siteapp_uninstall' => '웹 응용 프로그램이 제거됨',
    'actionlog__event_license_update' => '라이센스 키가 업데이트됨',
    'actionlog__event_admin_alias_create' => '추가 관리자 계정이 만들어짐',
    'actionlog__event_admin_alias_delete' => '추가 관리자 계정이 삭제됨',
    'actionlog__event_admin_alias_update' => '추가 관리자 계정이 업데이트됨',
    'actionlog__event_ftpuser_create' => '추가 FTP 계정이 만들어짐',
    'actionlog__event_ftpuser_update' => '추가 FTP 계정이 업데이트됨',
    'actionlog__event_ftpuser_delete' => '추가 FTP 계정이 삭제됨',
    'actionlog__event_template_domain_create' => "리셀러의 서비스 플랜이 만들어짐",
    'actionlog__event_template_domain_update' => "리셀러의 서비스 플랜이 업데이트됨",
    'actionlog__event_template_domain_delete' => "리셀러의 서비스 플랜이 삭제됨",
    'actionlog__event_template_admin_create' => "관리자의 서비스 플랜이 만들어짐",
    'actionlog__event_template_admin_update' => "관리자의 서비스 플랜이 업데이트됨",
    'actionlog__event_template_admin_delete' => "관리자의 서비스 플랜이 삭제됨",
    'actionlog__event_database_server_create' => '데이터베이스 서버가 만들어짐',
    'actionlog__event_database_server_update' => '데이터베이스 서버가 업데이트됨',
    'actionlog__event_database_server_delete' => '데이터베이스 서버가 삭제됨',
    'actionlog__event_remote_dns_status_update' => '원격 DNS 서버 상태가 업데이트됨',
    'actionlog__event_session_preferences_update' => '세션 설정이 업데이트됨',
    'actionlog__event_domain_alias_dns_update' => '기본 도메인, 도메인 별칭의 DNS 영역이 업데이트됨',
    'actionlog__event_domain_move' => '기본 도메인이 새 구독으로 이동함',
    'actionlog__event_site_move' => '도메인이 새 구독으로 이동함',
    'actionlog__event_site_subdomain_move' => '하위 도메인이 새 구독으로 이동함',
    'actionlog__event_subdomain_move' => '기본 도메인의 하위 도메인이 새 구독으로 이동함',
    'actionlog__event_license_expired' => 'Plesk 라이센스가 만료됨',
    'actionlog__event_database_create' => '데이터베이스가 만들어짐',
    'actionlog__event_database_delete' => '데이터베이스가 제거됨',
    'actionlog__event_database_user_create' => '데이터베이스 사용자 계정이 만들어짐',
    'actionlog__event_database_user_update' => '데이터베이스 사용자 계정 설정이 업데이트됨',
    'actionlog__event_database_user_delete' => '데이터베이스 사용자 계정이 제거됨',
    'actionlog__event_client_guid_update' => "고객 GUID가 업데이트됨",
    'actionlog__event_domain_guid_update' => '기본 도메인, GUID가 업데이트됨',
    'actionlog__event_reseller_create' => '리셀러 계정이 만들어짐',
    'actionlog__event_reseller_delete' => '리셀러 계정이 삭제됨',
    'actionlog__event_reseller_update' => '리셀러 계정이 업데이트됨',
    'actionlog__event_reseller_guid_update' => '리셀러 GUID가 업데이트됨',
    'actionlog__event_reseller_ip_pool_update' => "리셀러의 IP 풀이 업데이트됨",
    'actionlog__event_reseller_limit_size_reached' => '리셀러 계정의 디스크 공간 제한에 도달함',
    'actionlog__event_reseller_limit_traffic_reached' => '리셀러 계정의 트래픽 제한에 도달함',
    'actionlog__event_reseller_limits_update' => '리셀러 계정 제한이 업데이트됨',
    'actionlog__event_reseller_permissions_update' => '리셀러 계정 권한이 업데이트됨',
    'actionlog__event_reseller_preferences_update' => "리셀러의 인터페이스 기본 설정이 업데이트됨",
    'actionlog__event_reseller_siteapp_added' => "응용 프로그램이 리셀러 계정의 응용 프로그램 풀에 추가됨",
    'actionlog__event_reseller_siteapp_removed' => "응용 프로그램이 리셀러 계정의 응용 프로그램 풀에서 제거됨",
    'actionlog__event_reseller_status_update' => '리셀러 계정 상태가 업데이트됨',
    'actionlog__event_template_reseller_create' => '리셀러 플랜이 만들어짐',
    'actionlog__event_template_reseller_delete' => '리셀러 플랜이 삭제됨',
    'actionlog__event_template_reseller_update' => '리셀러 플랜이 업데이트됨',
    'actionlog__event_health_status_change' => '서버 상태가 변경됨',
    'actionlog__event_siteapp_upgrade' => '웹 응용 프로그램이 업그레이드됨',
    'actionlog__event_extension_install' => '확장 프로그램 설치됨',
    'actionlog__event_extension_uninstall' => '확장 프로그램 제거',
    'actionlog__event_extension_upgrade' => '확장 프로그램 업그레이드',
    'actionlog__event_extension_status_update' => '확장 프로그램 상태 업데이트',
    'actionlog__event_additional_license_expired' => '추가 라이센스가 만료됨',
    'actionlog__event_hostname_changed' => '서버 호스트 이름이 변경됨',
    'actionlog__event_smb_user_create' => '추가 사용자 생성됨',
    'actionlog__event_smb_user_delete' => '추가 사용자 삭제됨',
    'actionlog__event_smb_user_update' => '추가 사용자 업데이트됨',

    // REMOTE SESSION
    'rsession_no_api_rpc_errmsg' => "원격 호스트에 Plesk API RPC가 설치되지 않았습니다. 서비스 공급자에게 문의하여 도움을 요청하십시오.",
    'rsession_no_account_errmsg' => "계정에서 원격 서비스에 액세스할 수 없습니다. 계정 서비스가 아직 활성화되지 않았을 가능성이 높습니다. 몇 분 정도 기다렸다가 다시 시도하십시오. 이 오류가 다시 발생하면 시스템 관리자에게 연락하십시오.",
    'rsession_no_domain_errmsg' => "이 도메인에 대한 원격 서비스에 액세스할 수 없습니다. 이 도메인에 대한 서비스가 아직 활성화되지 않았을 가능성이 높습니다. 몇 분 정도 기다렸다가 다시 시도하십시오. 이 오류가 다시 발생하면 시스템 관리자에게 연락하십시오.",
    'rsession_unknown_errmsg' => "원격 서버가 세션 설정 시도를 거부했습니다. 시스템 관리자에게 연락하여 지원을 요청하십시오. 오류: %1",
    'rsession_unknown2_errmsg' => "원격 세션을 설정하는 동안 알 수 없는 오류가 발생했습니다. 원격 서버가 제대로 또는 전혀 응답하지 않을 가능성이 높습니다. 웹 서버 오류 로그에서 오류 세부 정보를 확인하도록 시스템 관리자에게 요청하십시오.",
    'rsession_no_connect_errmsg' => "원격 서비스에 액세스할 수 없음: 원격 세션 연결에 실패했습니다. 시스템 관리자에게 연락하여 지원을 요청하십시오.",

    // ANONYMOUS FTP
    'anonftp__allow_upload_incoming' => "수신 디렉터리에 업로드 허용",
    'anonftp__allow_create_dirs' => '수신 디렉터리에 디렉터리의 만들기 허용',
    'anonftp__allow_download_incoming' => '수신 디렉터리에서 다운로드 허용',
    'anonftp__display_login' => '로그인 메시지 표시',
    'anonftp__login_text' => '메시지 텍스트',
    'anonftp__limit_incoming_disk_space' => "수신 디렉터리의 디스크 공간 제한",
    'anonftp__limit_maximum_bandwidth' => "이 가상 FTP 도메인의 다운로드 대역폭 제한",
    'anonftp__limit_maximum_connections' => "동시 연결 수 제한",
    'anonftp__unable_init' => "익명 FTP 계정을 초기화할 수 없음: %1",
    'anonftp__unable_set_quota' => "수신 디렉터리 디스크 공간 제한을 설정할 수 없음: %1",
    'anonftp__unable_update' => "익명 FTP 계정 속성을 업데이트할 수 없음: %1",

    ///
    /// SSL/TLS CERTIFICATES
    ///

    // common keys
    '__certificates' => 'SSL/TLS 인증서', // page title
    // errors
    'class_sslcertificate__ca_not_signs' => "CA 인증서가 인증서에 서명하지 않습니다.",
    'class_sslcertificate__incompatible_pvt_key_cert' => "호환되지 않는 개인 키/인증서 쌍.",
    'class_sslcertificate__invalid_cert_format' => "잘못된 인증서 형식.",
    'class_sslcertificate__invalid_private_key_format' => "잘못된 개인 키 형식.",
    'class_sslcertificate__prob_invalid_priv_key' => "개인 키 형식이 잘못된 것일 수 있습니다.",

    ///
    ///END OF SSL/TLS CERTIFICATES
    ///

    ///
    /// WEB DIRECTORIES (PFW)
    ///

    //
    // DOMAIN
    //

    // Web Directories tab
    // Web Directories - ui__client/domain/hosting/web-directories__title (HOME/DOMAIN)
    'ui__client/domain/hosting/web-directories/create-virtual-dir__short-title' => '가상 디렉터리 만들기',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__title' => '가상 디렉터리를 만듭니다.',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__description' => '가상 디렉터리를 만듭니다.',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__short-title' => '가상 디렉터리 만들기',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__title' => '가상 디렉터리를 만듭니다.',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__description' => '가상 디렉터리를 만듭니다.',
    'ui__client/domain/hosting/web-directories/create-dir__short-title' => '디렉터리 만들기',
    'ui__client/domain/hosting/web-directories/create-dir__title' => '디렉터리 만들기',
    'ui__client/domain/hosting/web-directories/create-dir__description' => '디렉터리를 생성합니다.',
    'ui__client/domain/hosting/web-directories/create-dir_self__short-title' => '디렉터리 만들기',
    'ui__client/domain/hosting/web-directories/create-dir_self__title' => '디렉터리 만들기',
    'ui__client/domain/hosting/web-directories/create-dir_self__description' => '디렉터리를 생성합니다.',
    'ui__client/domain/hosting/web-directories/properties__short-title' => '디렉터리 속성',
    'ui__client/domain/hosting/web-directories/properties__title' => '가상 디렉터리 속성',
    'ui__client/domain/hosting/web-directories/properties__description' => '가상 디렉터리 속성을 보고 변경합니다.',
    'ui__client/domain/hosting/web-directories/properties_self__short-title' => '디렉터리 속성',
    'ui__client/domain/hosting/web-directories/properties_self__title' => '가상 디렉터리 속성',
    'ui__client/domain/hosting/web-directories/properties_self__description' => '가상 디렉터리 속성을 보고 변경합니다.',
    'ui__client/domain/hosting/web-directories/permissions__short-title' => '디렉터리 액세스 권한',
    'ui__client/domain/hosting/web-directories/permissions__title' => '디렉터리 액세스 권한',
    'ui__client/domain/hosting/web-directories/permissions__description' => '디렉터리 액세스 권한을 설정합니다.',
    'ui__client/domain/hosting/web-directories/permissions_self__short-title' => '디렉터리 액세스 권한',
    'ui__client/domain/hosting/web-directories/permissions_self__title' => '디렉터리 액세스 권한',
    'ui__client/domain/hosting/web-directories/permissions_self__description' => '디렉터리 액세스 권한을 설정합니다.',
    'ui__client/domain/hosting/web-directories/aspdotnet__short-title' => 'ASP.NET 설정',
    'ui__client/domain/hosting/web-directories/aspdotnet__title' => '다음에 대한 ASP.NET 설정 %1',
    'ui__client/domain/hosting/web-directories/aspdotnet__description' => '%1의 가상 디렉터리에 대한 ASP.NET 설정을 구성합니다.',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__short-title' => 'ASP.NET 설정',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__title' => '다음에 대한 ASP.NET 설정 %1',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__description' => '가상 디렉터리 %1의 ASP.NET 설정을 구성합니다.',
    'ui__client/domain/hosting/web-directories/php__short-title' => 'PHP 설정',
    'ui__client/domain/hosting/web-directories/php__title' => '다음에 대한 PHP 설정 %1',
    'ui__client/domain/hosting/web-directories/php__description' => '%1의 가상 디렉터리에 대한 PHP 설정을 구성합니다.',
    'ui__client/domain/hosting/web-directories/php_self__short-title' => 'PHP 설정',
    'ui__client/domain/hosting/web-directories/php_self__title' => '다음에 대한 PHP 설정 %1',
    'ui__client/domain/hosting/web-directories/php_self__description' => '%1의 가상 디렉터리에 대한 PHP 설정을 구성합니다.',

    // list object operations
    'ui__client/domain/hosting/web-directories/delete__short-title' => '제거',
    'ui__client/domain/hosting/web-directories/delete__title' => '원격 가상 디렉터리',
    'ui__client/domain/hosting/web-directories/delete__description' => '선택한 가상 디렉터리를 제거합니다.',
    'ui__client/domain/hosting/web-directories/delete_self__short-title' => '제거',
    'ui__client/domain/hosting/web-directories/delete_self__title' => '원격 가상 디렉터리',
    'ui__client/domain/hosting/web-directories/delete_self__description' => '선택한 가상 디렉터리를 제거합니다.',
    'ui__client/domain/hosting/web-directories/delete#legend__description' => '다음 가상 디렉터리가 제거됨:',
    'ui__client/domain/hosting/web-directories/delete__empty_selection' => '제거하려는 디렉터리를 선택해야 합니다.',

    // MIME Types tab
    'ui__client/domain/hosting/web-directories/mime-type_unknown__short-title' => 'MIME 유형',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__title' => 'MIME 유형',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__description' => '등록된 MIME 유형 목록을 봅니다.',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__short-title' => 'MIME 유형 추가',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__title' => 'MIME 유형 추가',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__description' => '새 MIME 유형을 등록합니다.',

    // Error documents tab
    'ui__client/domain/hosting/web-directories/error-doc_unknown__short-title' => '오류 문서',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__title' => '오류 문서',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__description' => '오류 문서를 보고 변경합니다.',

    // Protection tab
    'ui__client/domain/hosting/web-directories/protection__short-title' => '보호',
    'ui__client/domain/hosting/web-directories/protection__title' => '디렉터리 보호',
    'ui__client/domain/hosting/web-directories/protection__description' => '암호 보호를 이용하여 디렉터리에 대한 액세스를 제한합니다.',
    'ui__client/domain/hosting/web-directories/protection_self__short-title' => '보호',
    'ui__client/domain/hosting/web-directories/protection_self__title' => '디렉터리 보호',
    'ui__client/domain/hosting/web-directories/protection_self__description' => '암호 보호를 이용하여 디렉터리에 대한 액세스를 제한합니다.',
    'ui__client/domain/hosting/web-directories/protection/properties__short-title' => '설정',
    'ui__client/domain/hosting/web-directories/protection/properties__description' => '디렉터리 위치를 보고 보호된 영역에 대한 제목을 지정합니다.',
    'ui__client/domain/hosting/web-directories/protection/user/properties__title' => '사용자 설정',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__title' => '사용자 추가',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__short-title' => '사용자 추가',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__description' => '보호된 디렉터리에 대한 액세스를 허용할 사용자 계정을 추가합니다.',
    'ui__client/domain/hosting/web-directories/protection/properties__done' => '새 설정이 적용되었습니다.',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__done' => '사용자 계정이 추가되었습니다.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__short-title' => '제거',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__description' => '보호된 디렉터리 사용자를 제거합니다.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__title' => '사용자 계정 제거',
    'ui__client/domain/hosting/web-directories/protection/user/delete#legend__description' => '사용자 계정의 제거를 확인합니다.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__done' => '사용자 계정이 제거되었습니다.',

    //
    // SUBDOMAIN
    //

    // Web Directories tab

    // list object operations

    // MIME Types tab

    // Protection tab
    // Error documents tab

    ///
    /// END OF WEB DIRECTORIES
    ///

    ///
    /// SUBDOMAIN PAGE
    ///


    ///
    /// END OF SUBDOMAIN PAGE
    ///

    ///
    /// DONE MESSAGES
    ///

    // UI
    'ui____done' => '작업이 완료되었습니다.',
    'ui__admin/extras-domain__done' => 'MyPlesk.com 페이지가 열렸습니다.',
    'ui__admin/report/layout/delete_multi__done' => '선택한 보고서 레이아웃이 제거되었습니다.',
    'ui__admin/report/traffic-history__done' => '작업이 완료되었습니다.',
    'ui__admin/report__done' => '작업이 완료되었습니다.',
    'ui__admin-alias/delete_multi__done' => "선택한 추가 관리자 계정이 제거되었습니다.",
    'ui__admin-alias/properties__done' => "추가 관리자 계정 속성이 업데이트되었습니다.",
    'ui__admin-alias/properties_new__done' => "추가 관리자 계정이 만들어졌습니다.",
    'ui__admin-alias/properties_unknown__done' => "추가 관리자 계정 속성이 업데이트되었습니다.",
    'ui__admin-alias__done' => "추가 관리자 계정 정보가 업데이트되었습니다.",
    'ui__admin/manage-domain__done' => 'MyPlesk.com 페이지가 열렸습니다.',
    'ui__admin/register-domain__done' => 'MyPlesk.com 페이지가 열렸습니다.',
    'ui__admin/report/layout/auto/delete_multi__done' => '선택한 보고서 배달 일정이 제거되었습니다.',
    'ui__admin/report/layout/auto/properties__done' => '보고서 배달 일정이 업데이트되었습니다.',
    'ui__admin/report/layout/auto/properties_new__done' => '보고서 배달 일정이 만들어졌습니다.',
    'ui__client/domain/certificate/properties__done' => 'SSL/TLS 인증서 속성이 업데이트되었습니다.',
    'ui__client/domain/certificate/properties_new__done' => '새 SSL/TLS 인증서가 추가되었습니다. 새 SSL/TLS 인증서를 사용하려면 웹 사이트 호스팅 설정 (웹 사이트 및 도메인 탭 > 도메인 이름)에서 이를 선택해야 합니다.',
    'ui__client/domain/certificate__done' => '작업이 완료되었습니다.',
    'ui__client/domain/certificate_self__done' => '작업이 완료되었습니다.',
    'ui__client/domain/chowner__done' => '구독 %1이(가) 이제 다른 사용자에 속합니다.',
    'ui__client/domain/chowner_multi__done' => '구독 소유권이 변경되었습니다.',
    'ui__client/domain/chowner_multi-select__done' => '작업이 완료되었습니다.',
    'ui__client/domain/chowner_select__done' => '작업이 완료되었습니다.',
    'ui__client/domain/dbbackup/create__done' => "데이터베이스가 백업되었습니다.", // PFW
    'ui__client/domain/dbbackup/get__done' => "데이터베이스가 백업되었습니다.", // PFW
    'ui__client/domain/dbbackup/orphaned__done' => "분리된 사용자가 복구되었습니다.", // PFW
    'ui__client/domain/dbbackup/remove__done' => "백업 파일이 제거되었습니다.", // PFW
    'ui__client/domain/dbbackup/restore__done' => "데이터베이스 내용이 복원되었습니다.", // PFW
    'ui__client/domain/dbbackup/upload__done' => "작업이 완료되었습니다.", // PFW
    'ui__client/domain/dbbackup__done' => "작업이 완료되었습니다.", // PFW
    'ui__client/domain/dbbackup_self__done' => "작업이 완료되었습니다.", // PFW
    'ui__client/domain/dbbackup_unknown__done' => "작업이 완료되었습니다.", // PFW
    'ui__client/domain/delete__done' => "도메인 %1이(가) 제거되었습니다.",
    'ui__client/domain/delete_multi__done' => "도메인이 제거되었습니다.",
    'ui__client/domain/disable__done' => '도메인 %1이(가) 일시 중단되었습니다.',
    'ui__client/domain/disable_multi__done' => '선택한 도메인이 일시 중단되었습니다.',
    'ui__client/domain/enable__done' => '웹 사이트 %1이(가) 활성화되었습니다.',
    'ui__client/domain/enable_multi__done' => '선택한 웹 사이트가 활성화되었습니다.',
    'ui__client/domain/extras__done' => 'MyPlesk.com 페이지가 열렸습니다.',
    'ui__client/domain/extras_self__done' => 'MyPlesk.com 페이지가 열렸습니다.',
    'ui__client/domain/hosting/logs/rotation__done' => '로그 순환 설정이 변경되었습니다.',
    'ui__client/domain/hosting/logs/rotation_self__done' => '로그 순환 설정이 변경되었습니다.',
    'ui__client/domain/hosting/logs__done' => '작업이 완료되었습니다.',
    'ui__client/domain/hosting/logs_self__done' => '작업이 완료되었습니다.',
    'ui__client/domain/hosting/protected-directories__done' => '작업이 완료되었습니다.',
    'ui__client/domain/hosting/protected-directories_self__done' => '작업이 완료되었습니다.',
    'ui__client/domain/hosting/setup__done' => '%1에 대한 호스팅이 구성되었습니다.',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__done' => 'ASP.NET 버전이 변경되었습니다.', // PFW
    'ui__client/domain/hosting/ssh-terminal__done' => '작업이 완료되었습니다.', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__done' => '작업이 완료되었습니다.', // PFU
    'ui__client/domain/hosting/web-directories/aspdotnet__done' => '%1에 대한 ASP.NET 설정이 변경되었습니다.', // PFW
    'ui__client/domain/hosting/web-directories/create-dir__done' => '웹 사이트 %1 아래에 가상 디렉터리가 만들어졌습니다.', // PFW
    'ui__client/domain/hosting/web-directories/create-virtual-dir__done' => '가상 디렉터리가 만들어졌습니다.', // PFW
    'ui__client/domain/hosting/web-directories/delete__done' => '선택한 디렉터리가 제거되었습니다.', // PFW
    'ui__client/domain/hosting/web-directories/delete_self__done' => '선택한 디렉터리가 제거되었습니다.', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__done' => '사용자 지정 오류 문서가 업데이트되었습니다.', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__done' => '선택한 MIME 유형이 제거되었습니다.', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__done' => '새 MIME 유형이 등록되었습니다.', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__done' => '작업이 완료되었습니다.', // PFW
    'ui__client/domain/hosting/web-directories/permissions__done' => '디렉터리 액세스 권한이 업데이트되었습니다.', // PFW
    'ui__client/domain/hosting/web-directories/permissions_self__done' => '디렉터리 액세스 권한이 업데이트되었습니다.', // PFW
    'ui__client/domain/hosting/web-directories/php__done' => '%1에 대한 PHP 설정이 업데이트되었습니다.', // PFW
    'ui__client/domain/hosting/web-directories/php_self__done' => '%1에 대한 PHP 설정이 업데이트되었습니다.', // PFW
    'ui__client/domain/hosting/web-directories/properties__done' => '디렉터리 속성이 업데이트되었습니다.', // PFW
    'ui__client/domain/hosting/web-directories/properties_self__done' => '디렉터리 속성이 업데이트되었습니다.', // PFW
    'ui__client/domain/hosting/web-directories/protection__done' => '디렉터리 보호 설정이 업데이트되었습니다.', // PFW
    'ui__client/domain/hosting/web-directories/protection_self__done' => '디렉터리 보호 설정이 업데이트되었습니다.', // PFW
    'ui__client/domain/hosting/web-directories__done' => '작업이 완료되었습니다.', // PFW
    'ui__client/domain/hosting/web-directories_self__done' => "작업이 완료되었습니다.", // PFW
    'ui__client/domain/mpc-certificates__done' => '온라인 스토어에서 얻을 수 있는 SSL/TLS 인증서',
    'ui__client/domain/mpc-certificates_self__done' => '온라인 스토어에서 얻을 수 있는 SSL/TLS 인증서',
    'ui__client/domain/register__done' => 'MyPlesk.com 페이지가 열렸습니다.',
    'ui__client/domain/register_self__done' => 'MyPlesk.com 페이지가 열렸습니다.',
    'ui__client/domain/rename__done' => '도메인 이름이 변경되었습니다.',
    'ui__client/domain/rename_self__done' => "도메인 이름이 변경되었습니다.",
    'ui__client/domain/settings_self__done' => '작업이 완료되었습니다.',
    'ui__client/domain/toggle_disable__done' => "도메인 %1이(가) 일시 중단되었습니다.",
    'ui__client/domain/toggle_enable__done' => "%1의 고객 계정이 활성화되었습니다.",
    'ui__client/domain/traffic__done' => '작업이 완료되었습니다.',
    'ui__client/domain/traffic_self__done' => '작업이 완료되었습니다.',
    'ui__client/domain/traffic_unknown__done' => '작업이 완료되었습니다.',
    'ui__client/domain-summary-report__done' => '작업이 완료되었습니다.',
    'ui__client/domain-summary-report_self__done' => '작업이 완료되었습니다.',
    'ui__client/domain-summary-report_unknown__done' => '작업이 완료되었습니다.',
    'ui__client/extras-domain__done' => 'MyPlesk.com 페이지가 열렸습니다.',
    'ui__client/extras-domain_self__done' => 'MyPlesk.com 페이지가 열렸습니다.',
    'ui__client/ipaddress/delete_multi__done' => '작업이 완료되었습니다.',
    'ui__client/ipaddress/properties__done' => '작업이 완료되었습니다.',
    'ui__client/ipaddress/properties_new__done' => '작업이 완료되었습니다.',
    'ui__client/ip-pool/properties__done' => "고객 %1의 IP 풀이 업데이트되었습니다.",
    'ui__client/ip-pool/properties_self__done' => '작업이 완료되었습니다.',
    'ui__client/limits__done' => "고객 %1의 리소스 제한이 변경되었습니다.",
    'ui__client/limits_self__done' => '작업이 완료되었습니다.',
    'ui__client/logo__done' => '고객 %1의 새 브랜딩 설정이 적용되었습니다.',
    'ui__client/logo_reseller__done' => '새 패널 브랜딩 설정이 적용되었습니다.',
    'ui__client/logo_self__done' => '브랜딩 설정이 적용되었습니다.',
    'ui__client/logo_self-reseller__done' => '패널 브랜딩 설정이 적용되었습니다.',
    'ui__client/manage-domain__done' => 'MyPlesk.com 페이지가 열렸습니다.',
    'ui__client/manage-domain_self__done' => 'MyPlesk.com 페이지가 열렸습니다.',
    'ui__client/permissions__done' => "고객 %1의 권한이 변경되었습니다.",
    'ui__client/permissions_self__done' => '작업이 완료되었습니다.',
    'ui__client/preferences__done' => "고객 %1의 기본 설정이 변경되었습니다.",
    'ui__client/preferences_self__done' => "기본 설정이 변경되었습니다.",
    'ui__client/register-domain__done' => 'MyPlesk.com 페이지가 열렸습니다.',
    'ui__client/register-domain_self__done' => 'MyPlesk.com 페이지가 열렸습니다.',
    'ui__client/report/traffic-history__done' => '작업이 완료되었습니다.',
    'ui__client/report/traffic-history_self__done' => '작업이 완료되었습니다.',
    'ui__client/report__done' => '작업이 완료되었습니다.',
    'ui__client/report_self__done' => '작업이 완료되었습니다.',
    'ui__client/sessions/delete__done' => '작업이 완료되었습니다.',
    'ui__client/sessions/delete_self__done' => '작업이 완료되었습니다.',
    'ui__client/sessions__done' => '작업이 완료되었습니다.',
    'ui__client/sessions_self__done' => '작업이 완료되었습니다.',
    'ui__client/skeleton__done' => '작업이 완료되었습니다.',
    'ui__client/skeleton_self__done' => '작업이 완료되었습니다.',
    'ui__client/traffic__done' => "작업이 완료되었습니다.",
    'ui__client/traffic_unknown__done' => '작업이 완료되었습니다.',
    'ui__cp-access__done' => '작업이 완료되었습니다.',
    'ui__cp-session/properties__done' => '작업이 완료되었습니다.',
    'ui__cp-session__done' => '작업이 완료되었습니다.',
    'ui__ftp-sessions__done' => '작업이 완료되었습니다.',
    'ui__license__done' => '작업이 완료되었습니다.',
    'ui__logo__done' => "Plesk 브랜딩 속성이 변경되었습니다.",
    'ui__longtasks/longtask/properties__done' => "백그라운드 작업 설정이 변경되었습니다.",
    'ui__mass-email/delete__done' => "메시지 템플릿%1이 제거되었습니다.", // PFW
    'ui__mass-email/delete_multi__done' => "메시지 템플릿이 제거되었습니다.",  // PFW
    'ui__mass-email/send_main__done' => "작업이 완료되었습니다.",  // PFW
    'ui__mass-email/send_selectclients__done' => "고객 계정이 선택되었습니다.",  // PFW
    'ui__mass-email/send_selectdomainusers__done' => "도메인 관리자 계정이 선택되었습니다.",  // PFW
    'ui__mass-email/send_selectresellers__done' => '리셀러 계정이 선택되었습니다.',  // PFW
    'ui__mass-email/template/properties_main__done' => '대량 이메일 메시지 템플릿의 변경 사항이 저장되었습니다.', // PFW
    'ui__mass-email/template/properties_new-main__done' => '대량 이메일 메시지 템플릿이 만들어졌습니다.', // PFW
    'ui__mass-email/template/properties_new-selectclients__done' => '대량 이메일 메시지 템플릿에 대한 고객 계정이 선택되었습니다.',  // PFW
    'ui__mass-email/template/properties_new-selectdomainusers__done' => '대량 이메일 메시지 템플릿에 대한 도메인 관리자 계정이 선택되었습니다.', // PFW
    'ui__mass-email/template/properties_new-selectresellers__done' => '대량 이메일 메시지 템플릿에 대한 리셀러 계정이 선택되었습니다.',  // PFW
    'ui__mass-email/template/properties_unknown__done' => "대량 이메일 메시지 템플릿이 변경되었습니다.",  // PFW
    'ui__mass-email/template/properties__invalid_values' => '잘못된 값을 지정했습니다.', // PFW
    'ui__mass-email__done' => "작업이 완료되었습니다.", // PFW
    'ui__mass-mail__done' => "작업이 완료되었습니다.", // PFU
    'ui__mass-mail/delete__done' => '메시지 템플릿%1이 제거되었습니다.', // PFU
    'ui__mass-mail/delete_multi__done' => '메시지 템플릿이 제거되었습니다.', // PFU
    'ui__mass-mail/properties__done' => '템플릿 %1이(가) 변경되었습니다.', // PFU
    'ui__mass-mail/properties_new__done' => '템플릿 %1이(가) 만들어졌습니다.', // PFU
    'ui__mass-mail/send__done' => '메시지가 발송되었습니다.', // PFU
    'ui__mass-mail/send_new__done' => '메시지가 발송되었습니다.', // PFU
    'ui__mass-mail/send_unknown__done' => '메시지가 발송되었습니다.',  // PFU
    'ui__mass-mail/send_unknown-new__done' => '메시지가 발송되었습니다.', // PFU
    'ui__mass-mail/template/properties_new__done' => '새 메시지 템플릿이 만들어졌습니다.', // PFU
    'ui__mass-mail/template/properties__done' => '메시지 템플릿이 변경되었습니다.', // PFU
    'ui__modules/watchdog/disk/properties__done' => '새 디스크 모니터링 설정이 적용되었습니다.', // PFU
    'ui__modules__done' => '작업이 완료되었습니다.',
    'ui__modules__short-title' => '모듈',
    'ui__modules__title' => '모듈',
    'ui__reseller/client/traffic_unknown__done' => '작업이 완료되었습니다.',
    'ui__reseller/extras-domain__done' => 'MyPlesk.com 페이지가 열렸습니다.',
    'ui__reseller/extras-domain_self__done' => 'MyPlesk.com 페이지가 열렸습니다.',
    'ui__reseller/ftp-sessions_self__done' => '작업이 완료되었습니다.',
    'ui__reseller/limits__done' => "리셀러의 리소스 제한 및 리소스 사용량 정책이 변경되었습니다.",
    'ui__reseller/limits_readonly-self__done' => '작업이 완료되었습니다.',
    'ui__reseller/limits_self__done' => '리소스 제한 및 리소스 사용량 정책이 변경되었습니다.',
    'ui__reseller/manage-domain__done' => 'MyPlesk.com 페이지가 열렸습니다.',
    'ui__reseller/manage-domain_self__done' => 'MyPlesk.com 페이지가 열렸습니다.',
    'ui__reseller/permissions__done' => '리셀러 %1의 권한이 변경되었습니다.',
    'ui__reseller/permissions_readonly-self__done' => '',
    'ui__reseller/permissions_self__done' => '작업이 완료되었습니다.',
    'ui__reseller/register-domain__done' => 'MyPlesk.com 페이지가 열렸습니다.',
    'ui__reseller/register-domain_self__done' => 'MyPlesk.com 페이지가 열렸습니다.',
    'ui__reseller/report/layout/auto/delete_multi__done' => '선택한 보고서 배달 일정이 제거되었습니다.',
    'ui__reseller/report/layout/auto/properties__done' => '보고서 배달 일정이 업데이트되었습니다.',
    'ui__reseller/report/layout/auto/properties_new__done' => '보고서 배달 일정이 추가되었습니다.',
    'ui__reseller/report/traffic-history__done' => '작업이 완료되었습니다.',
    'ui__reseller/report/traffic-history_self__done' => '작업이 완료되었습니다.',
    'ui__reseller/report__done' => '작업이 완료되었습니다.',
    'ui__reseller/report_self__done' => '작업이 완료되었습니다.',
    'ui__reseller/sessions/delete__done' => '작업이 완료됨',
    'ui__reseller/sessions/delete_self__done' => '작업이 완료됨',
    'ui__reseller/sessions__done' => '작업이 완료되었습니다.',
    'ui__reseller/sessions_self__done' => '작업이 완료되었습니다.',
    'ui__reseller/traffic__done' => '작업이 완료되었습니다.',
    'ui__reseller/traffic_self__done' => '작업이 완료되었습니다.',
    'ui__reseller/traffic_unknown__done' => '작업이 완료되었습니다.',
    'ui__reseller/logo_self__title' => 'Plesk 브랜딩',
    'ui__reseller/logo_self__done' => 'Plesk 브랜딩 설정이 적용되었습니다.',
    'ui__server/aspdotnet__done' => '서버 전체의 ASP.NET 설정이 변경되었습니다.', // PFW
    'ui__server/certificate/default_multi__done' => '새로 호스팅된 웹 사이트에 대한 보안 연결을 위해 선택한 SSL/TLS 인증서를 사용하도록 설정되었습니다.',
    'ui__server/certificate/delete_multi__done' => '선택한 SSL/TLS 인증서가 제거되었습니다.',
    'ui__server/certificate/download__done' => 'SSL/TLS 인증서가 다운로드되었습니다.',
    'ui__server/certificate/properties__done' => 'SSL/TLS 인증서 속성이 업데이트되었습니다.',
    'ui__server/certificate/properties_new__done' => 'SSL/TLS 인증서 %1이(가) 생성되었습니다.',
    'ui__server/certificate/setup_multi__done' => 'Plesk에 대한 보안 연결을 위해 선택한 SSL/TLS 인증서를 사용하도록 설정되었습니다.',
    'ui__server/certificate__done' => '작업이 완료되었습니다.',
    'ui__server/cp-certificate-download__done' => "Plesk의 SSL/TLS 인증서가 다운로드되었습니다.",
    'ui__server/crontab/properties__done' => '%1의 예약된 작업이 변경되었습니다.',
    'ui__server/crontab/task/delete__done' => '작업이 제거되었습니다.',
    'ui__server/crontab/task/delete_multi__done' => '작업이 제거되었습니다.',
    'ui__server/crontab/task/properties__done' => '예약된 작업이 업데이트되었습니다.',
    'ui__server/crontab/task/properties_new__done' => '새 작업이 예약되었습니다.',
    'ui__server/crontab/task/toggle_disable__done' => '예약된 작업 %1이(가) 비활성화되었습니다.',
    'ui__server/crontab/task/toggle_enable__done' => '예약된 작업 %1이(가) 활성화되었습니다.',
    'ui__server/crontab__done' => '작업이 완료되었습니다.',
    'ui__server/dns__done' => '작업이 완료되었습니다.',
    'ui__server/ip-address/client/delete__done' => "IP 주소가 사용자의 IP 풀에서 제거되었습니다.",
    'ui__server/ip-address/client/delete_multi__done' => "IP 주소가 사용자의 IP 풀에서 제거되었습니다.",
    'ui__server/ip-address/client/properties_new__done' => 'IP 주소가 사용자에 할당되었습니다.',
    'ui__server/ip-address/ip-address/add-to-clients_add-target__done' => 'IP 주소 %1이(가) 선택한 고객에게 할당되었습니다.',
    'ui__server/ip-addresses__done' => "작업이 완료되었습니다.",
    'ui__server/mail/statistics/spam/recipients__done' => "작업이 완료되었습니다.",
    'ui__server/mail/statistics/spam/summary__done' => "작업이 완료되었습니다.",
    'ui__server/mail/statistics/spam__done' => "작업이 완료되었습니다.",
    'ui__server/mail/statistics/virus/recipients__done' => "작업이 완료되었습니다.",
    'ui__server/mail/statistics/virus/summary__done' => "작업이 완료되었습니다.",
    'ui__server/mail/statistics/virus/viruses__done' => "작업이 완료되었습니다.",
    'ui__server/mail/statistics/virus__done' => "작업이 완료되었습니다.",
    'ui__server/mail/statistics__done' => "작업이 완료되었습니다.",
    'ui__server/mail__done' => '메일 서버 설정이 변경되었습니다.',
    'ui__server/maillists__done' => '작업이 완료되었습니다.',
    'ui__server/mpc-certificates__done' => '사용 가능한 SSL/TLS 인증서가 나열된 온라인 스토어 페이지가 열렸습니다.',
    'ui__server/pmm__done' => '작업이 완료되었습니다.',
    'ui__server/preferences__done' => "서버 설정이 변경되었습니다.",
    'ui__server/register__done' => 'MyPlesk.com 페이지가 열렸습니다.',
    'ui__server/services__done' => '작업이 완료되었습니다.',
    'ui__server/sitebuilder__done' => '작업이 완료되었습니다.',
    'ui__server/skeleton__done' => '작업이 완료되었습니다.',
    'ui__server/spam-filter/black-list/address/delete__done' => '주소 %1이(가) 서버 전체 차단 목록에서 제거되었습니다.',
    'ui__server/spam-filter/black-list/address/delete_multi__done' => '서버 전체 차단 목록에서 주소가 제거되었습니다.',
    'ui__server/spam-filter/black-list/address/properties_new__done' => '주소가 차단 목록에 추가되었습니다.',
    'ui__server/spam-filter/black-list/address__done' => '주소가 차단 목록에 추가되었습니다.',
    'ui__server/spam-filter/black-list__done' => '작업이 완료되었습니다.', // PFU
    'ui__server/spam-filter/properties__done' => '스팸 필터 설정이 변경되었습니다.',
    'ui__server/spam-filter/toggle_disable__done' => '시스템 전체에 걸쳐 스팸 필터링이 비활성화되었습니다.',
    'ui__server/spam-filter/toggle_enable__done' => '시스템 전체에 걸쳐 스팸 필터링이 활성화되었습니다.',
    'ui__server/spam-filter/white-list/address/delete__done' => '주소 %1이(가) 서버 전체 허용 목록에서 제거되었습니다.',
    'ui__server/spam-filter/white-list/address/delete_multi__done' => '서버 전체 허용 목록에서 주소가 제거되었습니다.',
    'ui__server/spam-filter/white-list/address/properties_new__done' => '주소가 허용 목록에 추가되었습니다.',
    'ui__server/spam-filter/white-list/address__done' => '주소가 허용 목록에 추가되었습니다.',
    'ui__server/spam-filter/white-list__done' => '작업이 완료되었습니다.', // PFU
    'ui__server/spam-filter__done' => '작업이 완료되었습니다.',
    'ui__server/statistics__done' => '작업이 완료되었습니다.',
    'ui__server/time__done' => "시스템 날짜 및 시간이 변경되었습니다.",
    'ui__server__done' => "작업이 완료되었습니다.",
    'ui__sessions/properties__done' => '작업이 완료되었습니다.',
    'ui__sessions__done' => '작업이 완료되었습니다.',
    'ui__sessions/delete__done' => '선택한 세션이 삭제되었습니다.',
    'ui__start-page__done' => '작업이 완료되었습니다.',
    'ui__support__done' => '지원 요청 양식이 새 브라우저 창 또는 탭에 열렸습니다.',

    ///
    /// END OF DONE MESSAGES
    ///

    ///
    /// ASSORTED COMMON KEYS / TBI
    ///

    // non-UI
    '__no_files_to_upload' => '업로드할 파일이 없습니다.',
    'login_up__access_denied_no_permission' => "액세스가 거부됨. 로그인할 권한이 없습니다.",
    'mail__unable_remove_pattern' => "서버 차단 목록에서 주소를 제거할 수 없음: %1", // PFW
    'mail__incorrect_network_format' => '잘못된 네트워크 형식: %1', // PFW
    'initconf__unable_change_passwd' => "관리자의 암호를 변경할 수 없음: %1",
    'initconf__unable_get_passwd' => '현재 관리자의 암호를 가져올 수 없음: %1 실패: %2',
    'initconf__invalid_hostname' => '"%1" 호스트 이름에 오류',
    'initconf__unable_reconfig' => 'Plesk를 구성할 수 없음: reconfig 실패: %1',
    'initconf__unable_update_admin' => '관리자 연락처 정보를 업데이트할 수 없음: %1',
    '__refresh' => '새로 고침',
    '__dalias_not_exist' => '도메인 별칭이 없습니다.',
    '__bug146523_explanation' => '이전 버전의 Plesk에서는 FTP 사용자 이름에 최대 16자까지 허용되었습니다. 현재 버전의 Plesk는 FTP 사용자 이름의 최대 허용 문자 수를 15자로 제한합니다. 이 문제를 해결하려면 해당 FTP 사용자 이름의 FTP 사용자 이름 길이를 15자로 줄이고 해당 FTP 사용자 이름의 문자 하나 이상을 변경하여 사용자 이름 충돌 문제를 방지하십시오. 이러한 변경으로 인해 불편을 드려 죄송합니다.',
    'domain__cannot_change_webmail' => '도메인의 웹 메일을 변경할 수 없음: %1',
    'sb_publish_disable_warning' => 'Presence Builder를 통한 웹 사이트 만들기 기능을 해제하면 Presence Builder로 이전에 만든 웹 사이트와 모든 웹 사이트 데이터를 잃게 됩니다. 계속하려면 확인을 클릭합니다.',
    '__sbnet_client_use_sbnet' => "Presence Builder에서 해당 사용자 계정 만들기",
    'mail_resp_activate' => '자동 회신 활성화',
    'limitsManger__limit_available_error' => '필요한 양의 리소스를 할당할 수 없음("%%limitName%%"): %%available%%만 계정에 사용할 수 있습니다.',
    'limitsManger__limit_reserved_error' => '이미 사용 중인 것보다 적은 양의 리소스("%%limitName%%")를 할당할 수 없습니다.',
    'domain__unable_to_rename_vhost_dir_already_exists' => '도메인 이름을 바꿀 수 없음: 지정한 이름을 갖는 가상 디렉터리가 이미 있습니다.',
    'domain_unable_to_rename' => '도메인 이름을 바꿀 수 없습니다.',

    // Greylisting
    'spamfilter__general_settings_legend' => '일반',
    'spamfilter__spamassassin_status_legend' => 'SpamAssassin 스팸 필터링',
    'spamfilter__spamassassin_settings_legend' => 'SpamAssassin 설정',
    'spamfilter__spamassassin_server_status_legend' =>  "서버 전체에 걸쳐 SpamAssassin 스팸 필터링 기능 설정",
    'spamfilter__spamassassin_user_status_legend' => 'SpamAssassin 스팸 필터링 설정',
    'spamfilter__greylisting_status_legend' => '서버 전체에 걸쳐 의심되는 스팸 차단 기능 설정',
    'spamfilter__personal_settings_not_allowed' => '개별 스팸 필터링 설정 사용은 시스템 정책에서 허용하지 않습니다.',
    'spamfilter__required_score' => '스팸으로 지정되기 전에 메시지가 받아야 하는 점수',
    'spamfilter__rewrite_header_subject' => '스팸으로 인식된 각 메시지의 제목 시작 부분에 다음 텍스트 추가',
    'spamfilter__use_mailuser_prefs' => '스팸 필터링에 개별 설정 적용',
    'spamfilter_addresses__text_hint' => '여러 개의 주소는 새 라인, 공백, 탭, 쉼표 또는 세미콜론으로 구분합니다. @ 기호 왼쪽에는 ASCII가 아닌 문자가 올 수 없습니다. 주소에 *" 및 ?의 와일드카드를 포함할 수 있습니다(예: *@domain.com, user?@*.com). 도메인 이름 중 ASCII가 아닌 부분은 와일드카드를 포함할 수 없습니다.',
    'spamfilter__score_error' => '소스는 음수가 아니어야 하고, 소수점 앞 부분은 100 미만이어야 하며, 소수점 뒤 숫자가 세 자릿수 이상이면 안 됩니다.',
    'spamfilter__rewrite_header_error' => '메시지 제목은 우물정자 기호(#)를 제외하고 인쇄 가능 문자를 포함할 수 있습니다.',

    // template conflict keys
    'nonexistent_mail__mode_bounce' => '바운스',
    'nonexistent_mail__mode_discard' => '취소',
    'nonexistent_mail__mode_catch_addr' => '이메일 주소로 전달',
    'nonexistent_mail__mode_catch_ip' => 'IP로 전달',
    'nonexistent_mail__bounce_not_supported' => '바운스 모드가 지원되지 않음',
    'nonexistent_mail__discard_not_supported' => '취소 모드가 지원되지 않음',
    'nonexistent_mail__catch_not_supported' => '이메일 주소로 전달이 지원되지 않음',
    'nonexistent_mail__redirect_not_supported' => 'IP로 전달이 지원되지 않음',
    'nonexistent_mail__ip_used_on_this_host' => 'IP 주소가 로컬 호스트로 확인됨',
    'nonexistent_mail_address_should_be_local_domain' => '발신 메일 제어 기능이 켜져 있는 경우 존재하지 않는 수신자에 대한 이메일 주소 %1이(가) 선택한 도메인에 속해야 합니다. 그렇지 않으면 전달 대신 "Reject" 정책이 적용됩니다.',
    'nonexistent_mail_address_should_be_local_domain_not_restricted' => '발신 메일 제어가 활성화되어 있어, 메일 전달에 지정된 이메일 주소(%1)가 선택한 도메인에 귀속됩니다. 그렇지 않은 경우, 이 주소로 수신된 메시지는 발신 메일 제어에 산정되지 않습니다.',
    // mail acc extras
    '__antivirus' => "안티 바이러스",

    // web apps

    // none available
    'ui__admin-alias__none-available' => '추가 관리자 계정이 없습니다.', // PFW
    'ui__client/domain/certificate__none-available' => '고객에게 SSL/TLS 인증서가 없습니다.',
    'ui__client/domain/certificate__none-available__1' => '고객에게 SSL/TLS 인증서가 있는 도메인이 없습니다.',
    'ui__client/domain/certificate__none-available__2' => '도메인에 SSL/TLS 인증서가 없습니다.',
    'ui__reseller/client__none-available' => '고객에게 리셀러가 없습니다.',

    // empty selection for lists
    'ui__client/ipaddress/delete__empty_selection' => 'IP 풀에서 제거하려는 IP 주소를 선택해야 합니다.',
    'ui__server/ip-address/client/delete__empty_selection' => 'IP 풀에서 IP 주소를 취소할 리셀러 계정을 선택해야 합니다.',
    'ui__server/crontab/task/delete__empty_selection' => '취소하려는 작업을 선택해야 합니다.',

    // scripting languages errors
    'phosting__php_not_enabled' => '이 웹 사이트에 대한 PHP 지원이 해제되었습니다.',
    'phosting__aspdotnet_not_enabled' => '이 웹 사이트에 대한 ASP.NET 지원이 해제되었습니다.',
    'phosting__php_forced_by_site_isolation' => 'PHP 설정을 변경할 수 없음: 서버 단위 보안 정책을 재정의하는 권한은 허가되지 않았습니다.',
    'phosting__option_forced_by_site_isolation' => '%1 설정을 변경할 수 없음: 서버 단위 보안 정책을 재정의하는 권한은 허가되지 않았습니다.',
    'phosting__php_handler_id_not_registered' => 'PHP 처리기는 사이트 격리 설정에서 허용되지 않습니다. 기본 PHP 처리기가 사용됩니다.',
    'phosting__php_served_by_nginx_is_not_available' => 'PHP 처리기(nginx에서 서비스된 FPM 응용 프로그램)는 사이트 격리 설정에서 허용되지 않습니다. 기본 PHP 처리기가 사용됩니다.',

    // various UI
    'ui__client/ipaddress/properties_readonly__short-title' => 'IP 주소 목록 보기',
    'ui__client/ipaddress/properties_readonly__title' => 'IP 주소 목록 보기',
    'ui__client/ipaddress/properties_readonly__description' => '이 사용자의 IP 주소 목록을 봅니다.',
    'ui__server/certificate__short-title' => 'SSL/TLS 인증서',
    'ui__server/certificate__title' => 'SSL/TLS 인증서',
    'ui__server/certificate__description' => 'SSL/TLS 인증서를 보고 관리합니다.',

    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__short-title' => 'MIME 유형 제거',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__title' => 'MIME 유형 제거',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__description' => '선택한 MIME 유형을 제거합니다.',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__short-title' => 'MIME 유형 추가',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__title' => 'MIME 유형 추가',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__description' => 'MIME 유형을 등록합니다.',

    'ui__client/ipaddress/delete_multi__wizard-title' => 'IP 주소 제거',
    'ui__client/ipaddress/delete_multi__wizard__2_multi' => '고객의 IP 풀에서 제거하려는 IP 주소 선택 %1',

    // mail

    'ui__client/ipaddress__short-title' => 'IP 주소',
    'ui__client/ipaddress__title' => 'IP 주소',
    'ui__client/ipaddress__description' => 'IP 주소 정보를 봅니다.',
    'ui__server/ip-address__short-title' => 'IP 주소',
    'ui__server/ip-address__title' => 'IP 주소',
    'ui__server/ip-address__description' => 'IP 주소 정보를 봅니다.',
    'ui__client/domain/hosting/setup__short-title' => '웹 호스팅 설정',
    'ui__client/domain/hosting/setup__title' => '웹 호스팅 설정',
    'ui__client/domain/hosting/setup__description' => '웹 사이트 %1에 대한 웹 호스팅 설정을 구성합니다.',
    'ui__client/domain/hosting/web-directories/mime-type/properties__short-title' => 'MIME 유형', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__title' => 'MIME 유형 속성', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__description' => 'MIME 유형 속성을 봅니다.', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__short-title' => '오류 문서', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__title' => '오류 문서', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__description' => '오류 문서 속성.', // PFW

    // tooltips

    'b_get_password_cancel' => '이메일을 보내지 않고 이전 화면으로 돌아갑니다.',
    'b_get_password_send' => '시스템에 등록된 이메일 주소로 암호 복구 메시지를 보내려면 확인을 클릭합니다.',



    'b_personaltrafficlist_search' => '검색 패턴을 입력하고 클릭하여 도메인을 찾습니다.',
    'b_personaltrafficlist_show_all' => '모든 도메인을 표시합니다.',

    'b_back' => '이전 페이지로 돌아갑니다.',
    'b_next' => '다음 페이지로 이동합니다.',

    'b_dnsnstemplatelist_remove' => '선택한 이름 서버를 삭제합니다.',
    'b_dnsnstemplatelist_search' => '검색 패턴을 입력하고 클릭하여 이름 서버를 찾습니다.',
    'b_dnsnstemplatelist_show_all' => '모든 이름 서버를 표시합니다.',

    'l_dnsnstemplatelist_ns' => '이름 서버를 기준으로 DNS 템플릿 레코드를 정렬합니다.',

    // filesharing management tool
    'cu__serverfilesharing_fsLinksAsHttps' => '파일 및 폴더에 대한 보안 링크 생성',
    'cu__serverfilesharing_fsPublicFolderEnabled' => '공용 파일 사용',
    'cu__serverfilesharing_fsPublicFolder' => '공용 파일 저장을 위한 폴더',
    'cu__serverfilesharing_fsPublicUrl' => '공용 파일에 대한 방문자 액세스를 위한 URL',
    'cu__serverfilesharing_fsPartnerFolderEnabled' => '공용 파일의 암호 보호 사용',
    'cu__serverfilesharing_fsPartnerFolder' => '암호로 보호된 파일 저장을 위한 폴더',
    'cu__serverfilesharing_fsPartnersLogin' => '파일 액세스를 위한 사용자 이름',
    'cu__serverfilesharing_fsPartnersPassword' => '파일 액세스를 위한 암호',
    'cu__serverfilesharing_fsDomain' => '웹 폴더 루트 URL. 도메인 이름',
    'cu__serverfilesharing_fsPrefix' => '웹 폴더 루트 URL. 접두어',
    'cu__serverfilesharing_commandUpdate' => '파일 공유 설정 업데이트',
    'cu__serverfilesharing_commandInfo' => '현재 파일 공유 설정 표시',
    'subscription_rename_is_forbidden' => '구독의 이름 변경은 서버 전체 정책에 의해 금지됩니다.',
    ///
    /// END OF RANDOM COMMON KEYS
    ///

    ////
    //// CRONTAB - temporary
    ////

    // wizard:

    'ui__server/crontab/task_unknown__wizard-title' => '서버의 예약된 작업 관리',
    'ui__server/crontab/task_unknown__wizard__2_unknown' => '예약된 작업을 관리하려는 시스템 사용자를 선택합니다.',

    'ui__server/crontab/task__short-title' => '%1',
    'ui__server/crontab/task__title' => '예약된 작업 %1',
    'ui__server/crontab/task__description' => '예약된 작업 %1의 속성을 봅니다.',

    ///
    /// SERVER
    ///

    'ui__server/crontab_unknown__short-title' => '시스템 사용자',
    'ui__server/crontab_unknown__title' => '시스템 사용자',
    'ui__server/crontab_unknown__description' => '예약된 작업의 소유자일 수 있는 시스템 사용자.',


    'ui__server/crontab__none-available' => '시스템 사용자 계정이 없습니다.',
    'ui__server/crontab_readonly-unknown__description' => '예약된 작업을 봅니다.',
    'ui__server/crontab_readonly-unknown__short-title' => '예약된 작업',
    'ui__server/crontab_readonly-unknown__title' => '예약된 작업 보기',
    'ui__server/crontab_readonly-unknown__wizard-title' => '예약된 작업을 봅니다.',
    'ui__server/crontab_readonly__description' => '%1의 예약 작업을 봅니다.',
    'ui__server/crontab_readonly__short-title' => '다음의 예약된 작업 %1',
    'ui__server/crontab_readonly__title' => '다음의 예약 작업 보기 %1',
    'ui__server/crontab_unknown__wizard-title' => '예약된 작업을 관리합니다.',

    'ui__server/crontab/properties__description' => '%1의 예약 작업을 편집합니다.',

    'ui__server/crontab/properties__short-title' => '설정',
    'ui__server/crontab/properties__title' => '다음의 예약 작업 편집 %1',
    'ui__server/crontab/properties_readonly-unknown__description' => '예약된 작업을 봅니다.',
    'ui__server/crontab/properties_readonly-unknown__short-title' => '설정',
    'ui__server/crontab/properties_readonly-unknown__title' => '예약된 작업 보기',
    'ui__server/crontab/properties_readonly-unknown__wizard-title' => '예약된 작업을 봅니다.',
    'ui__server/crontab/properties_readonly__description' => '%1의 예약 작업을 봅니다.',
    'ui__server/crontab/properties_readonly__short-title' => '설정',
    'ui__server/crontab/properties_readonly__title' => '다음의 예약 작업 보기 %1',
    'ui__server/crontab/properties_unknown__description' => '예약된 작업을 편집합니다.',
    'ui__server/crontab/properties_unknown__short-title' => '속성',
    'ui__server/crontab/properties_unknown__title' => '예약된 작업 편집',
    'ui__server/crontab/properties_unknown__wizard-title' => '예약된 작업을 편집합니다.',
    'ui__server/crontab/properties_unknown__wizard__2_readonly-unknown' => '작업을 보려는 시스템 사용자를 선택합니다.',
    'ui__server/crontab/properties_unknown__wizard__2_unknown' => '작업을 변경하려는 시스템 사용자를 선택합니다.',
    'ui__server/crontab/properties_unknown__wizard__3' => '‘마침’을 클릭하여 변경 내용을 적용하고 마법사를 종료합니다.',
    'ui__server/crontab/properties_unknown__wizard__3_readonly' => '‘마침’을 클릭하여 마법사를 종료합니다.',

    'ui__server/crontab/task__none-available' => '예약된 작업이 없습니다.',
    'ui__server/crontab/task__none-available__2' => '시스템 사용자 %1에게 예약된 작업이 없습니다.',
    'ui__server/crontab/task_readonly-unknown__description' => '예약된 작업.',
    'ui__server/crontab/task_readonly-unknown__short-title' => '작업',
    'ui__server/crontab/task_readonly-unknown__title' => '예약된 작업',

    'ui__server/crontab/task/delete__description' => '예약된 작업 제거 %1',

    'ui__server/crontab/task/delete__short-title' => '제거',
    'ui__server/crontab/task/delete__title' => '예약된 작업 제거 %1',
    'ui__server/crontab/task/delete_multi__description' => '예약된 작업을 제거합니다.',

    'ui__server/crontab/task/delete_multi__short-title' => '제거',
    'ui__server/crontab/task/delete_multi__title' => '예약된 작업 제거',
    'ui__server/crontab/task/delete_multi__wizard-title' => '예약된 작업을 제거합니다.',
    'ui__server/crontab/task/delete_multi__wizard__2_unknown' => '작업을 제거하려는 시스템 사용자를 선택합니다.',
    'ui__server/crontab/task/delete_multi__wizard__3_multi' => '제거하려는 작업을 선택합니다.',
    'ui__server/crontab/task/delete_multi__wizard__4_multi' => '확인란을 선택하여 작업의 제거를 확인하고 ‘마침’을 클릭하여 마법사를 완료합니다.',
    'ui__server/crontab/task/delete_unknown__description' => '예약된 작업을 제거합니다.',
    'ui__server/crontab/task/delete_unknown__short-title' => '제거',
    'ui__server/crontab/task/delete_unknown__title' => '예약된 작업 제거',
    'ui__server/crontab/task/delete_unknown__wizard-title' => '예약된 작업을 제거합니다.',
    'ui__server/crontab/task/delete_unknown__wizard__2_unknown' => '작업을 제거하려는 시스템 사용자를 선택합니다.',
    'ui__server/crontab/task/delete_unknown__wizard__3_unknown' => '제거하려는 작업을 선택합니다.',
    'ui__server/crontab/task/delete_unknown__wizard__4' => '확인란을 선택하여 작업의 제거를 확인하고 ‘마침’을 클릭하여 마법사를 완료합니다.',

    'ui__server/crontab/task/properties__description' => '예약된 작업을 편집합니다.',

    'ui__server/crontab/task/properties__short-title' => '작업 편집 %1',
    'ui__server/crontab/task/properties__title' => '예약된 작업 편집',
    'ui__server/crontab/task/properties_new__description' => '%1에 대한 예약된 작업을 만듭니다.',

    'ui__server/crontab/task/properties_new__short-title' => '작업 추가',
    'ui__server/crontab/task/properties_new__title' => '%1에 대한 예약된 작업 만들기',
    'ui__server/crontab/task/properties_new__wizard-title' => '예약된 작업을 만듭니다.',
    'ui__server/crontab/task/properties_new__wizard__2_unknown' => '예약된 작업을 만들려는 시스템 사용자를 선택합니다.',
    'ui__server/crontab/task/properties_new__wizard__4_new' => '‘마침’을 클릭하여 변경 내용을 적용하고 마법사를 종료합니다.',
    'ui__server/crontab/task/properties_readonly-unknown__description' => '예약된 작업을 봅니다.',
    'ui__server/crontab/task/properties_readonly-unknown__short-title' => '속성',
    'ui__server/crontab/task/properties_readonly-unknown__title' => '예약된 작업 보기',
    'ui__server/crontab/task/properties_readonly-unknown__wizard-title' => '예약된 작업을 봅니다.',
    'ui__server/crontab/task/properties_readonly__description' => '예약된 작업을 봅니다.',
    'ui__server/crontab/task/properties_readonly__short-title' => '작업 보기 %1',
    'ui__server/crontab/task/properties_readonly__title' => '예약된 작업 보기',
    'ui__server/crontab/task/properties_unknown-new__description' => '예약된 작업을 만듭니다.',
    'ui__server/crontab/task/properties_unknown-new__short-title' => '새 작업 추가',
    'ui__server/crontab/task/properties_unknown-new__title' => '예약된 작업 만들기',
    'ui__server/crontab/task/properties_unknown__description' => '예약된 작업을 편집합니다.',
    'ui__server/crontab/task/properties_unknown__short-title' => '속성',
    'ui__server/crontab/task/properties_unknown__title' => '예약된 작업 편집',
    'ui__server/crontab/task/properties_unknown__wizard-title' => '예약된 작업을 편집합니다.',
    'ui__server/crontab/task/properties_unknown__wizard__2_readonly-unknown' => '작업을 보려는 시스템 사용자를 선택합니다.',
    'ui__server/crontab/task/properties_unknown__wizard__2_unknown' => '작업을 변경하려는 시스템 사용자를 선택합니다.',
    'ui__server/crontab/task/properties_unknown__wizard__3_readonly-unknown' => '예약된 작업을 선택합니다.',
    'ui__server/crontab/task/properties_unknown__wizard__3_unknown' => '변경하려는 예약된 작업을 선택합니다.',
    'ui__server/crontab/task/properties_unknown__wizard__4' => '‘마침’을 클릭하여 변경 내용을 적용하고 마법사를 종료합니다.',
    'ui__server/crontab/task/properties_unknown__wizard__4_readonly' => '‘마침’을 클릭하여 마법사를 종료합니다.',

    'ui__server/crontab/task/toggle_disable__description' => '예약된 작업 %1을(를) 비활성화합니다.',

    'ui__server/crontab/task/toggle_disable__short-title' => '비활성화',
    'ui__server/crontab/task/toggle_disable__title' => '예약된 작업 비활성화 %1',
    'ui__server/crontab/task/toggle_enable__description' => '예약된 작업 %1을(를) 활성화합니다.',

    'ui__server/crontab/task/toggle_enable__short-title' => '활성화',
    'ui__server/crontab/task/toggle_enable__title' => '예약된 작업 활성화 %1',
    'ui__server/crontab/task/toggle_unknown__description' => '예약된 작업을 활성화 또는 비활성화합니다.',
    'ui__server/crontab/task/toggle_unknown__short-title' => '사용 또는 사용 안 함',
    'ui__server/crontab/task/toggle_unknown__title' => '예약된 작업 활성화 또는 비활성화',
    'ui__server/crontab/task/toggle_unknown__wizard-title' => '예약된 작업 활성화 또는 비활성화',
    'ui__server/crontab/task/toggle_unknown__wizard__2_unknown' => '작업을 활성화/비활성화하려는 시스템 사용자 계정을 선택합니다.',
    'ui__server/crontab/task/toggle_unknown__wizard__3_unknown' => '활성화/비활성화하려는 작업을 선택합니다.',


    /// not used on HP:

    'ui__client_unknown__short-title' => '고객 계정', // not used on HP?
    'ui__client_unknown__title' => '고객 계정', // not used on HP?
    'ui__client_unknown__description' => '고객 계정을 관리합니다.', // not used on HP?
    'ui__client/domain/disable_unknown__title' => '도메인 일시 중단', // not used on HP
    'ui__client/domain/disable_unknown__short-title' => '도메인 일시 중단', // not used on HP,
    'ui__client/domain/disable_unknown__description' => '도메인을 일시 중단합니다.', // not used on HP
    'ui__client/domain/enable_unknown__title' => '도메인 활성화', // not used on HP
    'ui__client/domain/enable_unknown__short-title' => '도메인 활성화', // not used on HP
    'ui__client/domain/enable_unknown__description' => '도메인을 활성화합니다.', // not used on HP

    //Additional FTP Accounts
    'ftp__management_domain' => "도메인 %1의 FTP 계정", // for Additional FTP Accounts
    '__ftp_users_list' => "FTP 계정",
    'ftp__user_name' => "FTP 계정 이름",
    'ftp__user_home' => "홈 디렉터리",
    'ftp__invalid_path' => "잘못된 경로가 지정됨",
    'i_ftp_ses_sub_user' => 'FTP 계정 세션.',
    '__new_passwd' => "새 %1 암호",

    ////
    //// Errors with custom template of Apache configuration
    ////

    'apacheConfigurationFailedMessageSubject' => '웹 서버를 호스트 <%%host%%>에 구성하지 못했습니다.',
    'apacheConfigurationFailedMessageBody' => "다음 오류가 발생하여 호스트 <%%host%%>에 웹 서버 구성 파일을 만들 수 없음:\n\n%%error%%\n\n웹 서버 구성 템플릿에서 오류를 해결하고 파일을 다시 생성하십시오.",

    'apacheConfigurationMessageAdminTitle' => '웹 서버 구성을 생성하지 못했습니다.',
    'apacheConfigurationMessageClientTitle' => '경고',

    'apacheConfigurationFailedAdminHomeMessage' => '구성 템플릿 오류로 인해 새 구성 파일이 생성되지 않았습니다. 귀하의 이메일로 자세한 오류 메시지를 보냈습니다. 이메일을 확인하여 오류를 해결한 다음 %1을(를) 클릭하여 구성을 다시 생성하십시오.',
    'apacheConfigurationFailedAdminHomeMessageLink' => '여기', //used on linked text in apacheConfigurationFailedAdminHomeMessage
    'apacheConfigurationFailedAdminDomainMessage' =>  '구성 템플릿 오류로 인해 도메인 %1의 새 구성이 생성되지 않았습니다. 귀하의 이메일로 자세한 오류 메시지를 보냈습니다. 이메일을 확인하여 오류를 해결한 다음 %2을(를) 클릭하여 구성을 다시 생성하십시오.',
    'apacheConfigurationFailedAdminDomainMessageLink' => '여기', //used on linked text in apacheConfigurationFailedAdminDomainMessage

    'apacheConfigurationFailedUserDomainMessage' => '도메인 %1의 웹 서버 구성에 일관성이 없을 수 있습니다. 서버 관리자에게 문의하여 문제를 해결하십시오.',

    'apacheConfigurationFailedAdminDomainsMessage' => '구성 템플릿 오류로 인해 도메인의 새 구성 일부가 생성되지 않았습니다. 귀하의 이메일로 자세한 오류 메시지를 보냈습니다. 이메일을 확인하여 오류를 해결한 다음 %1을(를) 클릭하여 구성을 다시 생성하십시오.',
    'apacheConfigurationFailedAdminDomainsMessageLink' => '여기', //used on linked text in apacheConfigurationFailedAdminDomainsMessage

    'apacheConfigurationFailedUserDomainsMessage' => '일부 도메인에 대한 웹 서버 구성이 일관되지 않을 수 있습니다. 서버 관리자에게 연락하여 문제를 해결하십시오.',



    ///HOSTING PARAMETERS
    '__apache_errdocs' => "사용자 지정 오류 문서",
    'dom_pref__webusers_script' => "웹 사용자가 스크립트를 사용하도록 허용",
    '__seoRedirect' => '기본 도메인을 다음으로 구성',
    '__seoRedirectToLanding' => 'domain.tld',
    '__seoRedirectToWww' => 'www.domain.tld',
    '__seoRedirectNone' => '없음',

    '__sites' => '도메인',
    'domain_plan__perm_denied_manage_phosting' => '호스팅 설정을 관리할 권한이 없습니다.',
    '__owned_by_client' => '고객이 소유함',
    'ui__client/permissions_readonly__description' => "고객 %1이(가) Plesk에서 수행할 수 있는 동작을 봅니다.",
    'backup__restore__object_client_template' => '고객 템플릿',
    '__template_name' => '서비스 플랜 이름',
    'template__not_exists' => '그러한 서비스 플랜이 없습니다.',
    'template__exists' => '%1 이름의 플랜이 이미 있습니다.',
    'clientOwnerChanger__ip_not_in_pool' => '지정된 IP 주소가 리셀러 풀에 없습니다.',

    //// Change owner of subscription
    'chown__select_title' => "새 구독자 선택",
    'ui__client/domain/chowner_multi__wizard__3_multi-select' => '선택한 구독의 새 소유자를 선택하고 다음을 클릭하십시오.',
    'domains__client_info' => "%1 구독, %2 활성 구독, %3 사용 중인 디스크 공간, %4 사용 중인 트래픽",
    '__possible_owners' => '가능한 새 구독 소유자',

    'clients_list__filter_owner__filter_title' => '공급자',
    'clients_list__filter_owner_any' => '모든 사용자',
    'clients_list__filter_owner_my' => '내 구독자만',
    'clients_list__filter_owner_name__filter_title' => '공급자 이름',

    '__owner' => "공급자",
    'l_clientslist_owner' => '공급자를 기준으로 사용자 계정을 정렬합니다.',
    'l_clientslist_date' => '만든 날짜를 기준으로 사용자 계정을 정렬합니다.',
    'l_clientslist_name' => '이름을 기준으로 사용자 계정을 정렬합니다.',
    'l_clientslist_domains' => '도메인을 기준으로 사용자 계정을 정렬합니다.',
    'l_clientslist_cname' => '회사 이름을 기준으로 사용자 계정을 정렬합니다.',

    'ui__client/domain/chowner_multi__wizard-title' => '선택한 구독을 다시 할당하는 중',
    'chown__check_title' => '구독자 변경',

    'ui__client/domain/chowner_multi__wizard__3_multi' => "다시 할당을 완료하려면 '마침'을 클릭합니다. 작업을 마치면 선택한 구독이 새 소유자에게 할당되고 공급자가 새 소유자의 제공업체로 변경되며 서비스 플랫에서 언바운드되고 '사용자 지정'이 됩니다.",

    'chown__error_check' => '구독 일부를 새 소유자에게 할당하려고 할 때 문제가 발생했습니다.',
    'domain_chown_subscription_will_be_anonymous' => "구독이 현재 서비스 플랜에서 언바운드되고 '사용자 지정'이 됩니다.",
    'chown__error_domains_exclude' => "구독 일부를 새 소유자에게 할당하려고 할 때 문제가 발생했습니다. 이러한 구독이 강조 표시됩니다.",
    'chown__ip_not_in_client_pool' => "이 구독과 연관된 IP 주소가 새 소유자의 IP 풀에 추가되지 않았습니다.",
    'chown__already_owned_by_client' => "이 구독은 이 사용자에게 이미 속해 있습니다.",

    /// Protected directories

    'ui__client/domain/hosting/protected-directories/path__short-title' => '/%1',
    'ui__client/domain/hosting/protected-directories/path__title' => '보호된 디렉터리 /%1',
    'ui__client/domain/hosting/protected-directories/path__description' => '보호된 디렉터리 /%1 관리',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__title' => '사용자 추가',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__short-title' => '사용자 추가',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__description' => '보호된 디렉터리에 액세스하도록 사용자 계정 설정 %1',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__done' => '보호된 디렉터리에 액세스하기 위한 사용자 계정이 만들어졌습니다.',
    'ui__client/domain/hosting/protected-directories/path/user/properties__done' => "사용자의 자격 증명이 저장되었습니다.",
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__title' => '보호된 디렉터리 사용자 제거',
    'ui__client/domain/hosting/protected-directories/path/user/delete__empty_selection' => '제거하려는 사용자를 선택합니다.',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__short-title' => '제거',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__description' => '디렉터리 사용자를 제거합니다.',
    'ui__client/domain/hosting/protected-directories/path/user/delete#legend__description' => '다음 보호된 디렉터리 사용자가 제거됨:',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__done' => '선택한 사용자 계정이 제거되었습니다.',

    '__redirect_hint' => '15초 내에 새 주소로 리디렉션됩니다... 새 위치로 자동으로 이동하지 않으면 javascript를 활성화하거나 하이퍼링크를 클릭하십시오. %%link%%.',

    'backup__restore__object_maillist' => '메일링 리스트',
    'backup__restore__object_site' => '사이트',
    'backup__restore__object_user' => '사용자',
    'backup__restore__object_role' => '역할',

    'limit__name_max_site' => '사이트',

    'iis_pool__unable_rename_client' => "IIS 응용 프로그램 풀 이름을 변경할 수 없음: %1.",

    'anonftp__is_not_supported_for_addon_domains' => '익명 FTP 서비스는 구독의 주 도메인에만 지원됩니다.',
    'anonftp__is_not_supported_for_addon_domains_powerUser' => '익명 FTP 서비스는 구독의 주 도메인에만 지원됩니다.',

    '__gb' => 'GB',
    '__tb' => 'TB',
    '__gb_month' => 'GB/월',
    '__tb_month' => 'TB/월',

    '__customers' => '고객',
    '__customer_name' => '고객 이름',
    '__customer_total' => '고객 합계',
    '__site' => '사이트',
    '__def_site' => '기본 사이트',
    '__subscription_name' => '구독 이름',
    '__subscription_name_powerUser' => '구독 이름',

    'limit__units_max_traffic_suffix' => '/월',

    'dom_pref__discard' => "거부",

    'mail__pattern_already_exists' => '패턴 "%1"은(는) 차단 목록에 이미 있습니다.',

    '__not_supported' => '지원되지 않음',

    'plesk_key__sitebuilder' => 'Presence Builder를 사용하여 게시된 사이트',
    'limit__name_max_site_builder' => 'Presence Builder를 사용하여 게시된 사이트',
    'plesk_key__wpb-multi-language-sites-support' => 'Presence Builder에서 다국어 사이트를 지원합니다.',

    'ui__client/domain/traffic-hosting__title' => '<b>%1</b>의 데이터 전송 통계',
    'ui__client/domain/traffic-hosting__title_powerUser' => '<b>%1</b>의 데이터 전송 통계',
    'ui__client/domain/traffic-hosting#list__title' => "서비스에 의한 데이터 전송",

    'login_up__access_denied_no_subscriptions' => "액세스가 거부됨. 이 계정에 사용 가능한 구독이 없습니다.",

    'interval__day' => '%1 일',
    'interval__hour' => '%1 시간',
    'interval__minute' => '%1 분',
    'interval__second' => '%1 초',

    ///License options
    'plesk_key__backward_incompatibility' => '다른 Plesk 버전에 대해 만들어진 라이센스 키를 사용하려고 합니다. Plesk 영업 담당자에게 문의하여 적합한 라이센스 키를 얻으십시오.',
    //Standalone or virtualization
    'virtualization_any' => "실제 서버 또는 가상화 솔루션",
    'virtualization_pvc' => "Virtuozzo 컨테이너",
    'virtualization_vmware' => "VMWare",
    'virtualization_hyperv' => "Microsoft Hyper-V",
    'virtualization_xen' => "Xen",
    'virtualization_kvm' => "KVM",
    'virtualization_parallels_server' => "Virtuozzo 서버",
    'plesk_key__virtualization' => "다음 환경에 대해 유효합니다.",
    'plesk_key__virtualization_only_key' => '라이센스 키는 %1 가상 환경에서 작동 중인 Plesk에만 사용할 수 있습니다.',
    'plesk_key__virtualizations_only_key' => '라이센스 키는 다음 가상 환경에서 작동 중인 Plesk에만 사용할 수 있습니다. %1.',
    //Language options
    'plesk_key__invalid_locale_signature' => '사용자 지정 언어 팩 사용은 금지되어 있습니다.',
    'plesk_key__allowed-locales' => '사용 가능한 언어',
    'plesk_key__allowed-locales-any' => '모든 언어',

    /// Web hosting settings on domain/subdomain

    '__cgi_bin_mode' => 'cgi-bin 디렉터리의 위치',
    '_cgi_bin_mode_webspace' => '구독의 루트 디렉터리',
    '_cgi_bin_mode_www_root' => '이 도메인의 문서 루트',

    /// Custom buttons
    'custom_button__sort_key' => '우선 순위',
    'custom_button__place' => '위치',
    'custom_button__place_navigation' => '일반 액세스',
    'custom_button__place_admin' => '관리자 홈 페이지',
    'custom_button__place_admin-settings' => '관리자 도구 및 설정 페이지',
    'custom_button__place_reseller' => "리셀러 홈 페이지",
    'custom_button__place_reseller-settings' => '리셀러 도구 및 유틸리티 페이지',
    'custom_button__place_client' => '고객 홈 페이지',
    'custom_button__place_domain' => "구독 웹 사이트 및 도메인 페이지",
    'custom_button__place_domain_powerUser' => "구독 웹 사이트 및 도메인 페이지",
    'custom_button__place_domain-properties' => '웹 사이트 도구',
    'custom_button__private' => '나에게만 표시',
    'custom_button__image' => '백그라운드 이미지',
    'custom_button__conhelp' => "도구 설명 텍스트",
    'custom_button__edit' => "추가 서비스 링크 설정",
    'custom_button__include_client_cname' => "고객 회사명 포함",
    'custom_button__include_client_email' => "고객 이메일 포함",
    'custom_button__include_client_id' => "고객 ID 포함",
    'custom_button__include_client_pname' => "고객 연락처 이름 포함",
    'custom_button__include_domain_id' => "구독 ID, 도메인 ID 및 도메인 별칭 ID를 포함합니다.",
    'custom_button__include_domain_id_powerUser' => "구독 ID, 도메인 ID 및 도메인 별칭 ID를 포함합니다.",

    'custom_button__include_domain_name' => "기본 도메인 이름 포함",
    'custom_button__include_ftp_user' => "FTP 사용자 이름 포함",
    'custom_button__include_ftp_pass' => "FTP 암호 포함",
    'custom_button__internal_open' => "Plesk에서 URL 열기",
    'custom_button__text' => "버튼 레이블",
    'custom_button__url' => "URL",

    'custom_button__not_image' => '파일이 이미지 파일이 아닙니다.',
    'custom_button__big_image' => '파일 크기는 100 KB 미만이어야 합니다.',
    'custom_button__failed_copy_image' => '파일을 복사할 수 없음: %1',


    'backup__restore__cannot_restore_non_power_user_dump_in_power_user_mode' => '고급 사용자 보기에서 고급 사용자가 아닌 백업을 복원할 수 없습니다.',
    '__unknown_network_interface' => '알 수 없는 네트워크 인터페이스',

    'init_conf__ip_address' => 'IP 주소',

    //Confirmation page
    'bt_confirm' => '확인',
    'b_confirm' => '사이트의 소유권을 확인합니다.',

    'performance__iss_app_pool_forced_by_site_isolation' => '전용 IIS 응용 프로그램 풀의 설정은 서버 전체의 보안 정책에 따라 구성됩니다(사이트 격리 구성).',
    'performance__iss_app_pool_forced_by_server_wide_settings' => '전용 IIS 응용 프로그램 풀의 설정은 서버 전체의 성능 설정에 따라 구성됩니다.',

    '__current' => '현재',
    'ui__client/domain/hosting/web-directories/protection/user/properties__done' => '사용자 속성이 업데이트되었습니다.',



    //// New Promos Block

    'promo__you_are_about_to_exceed_license_limit_max_dom' => 'Plesk 라이센스에 제공된 도메인을 거의 모두(90% 이상) 사용했습니다.',
    'promo__you_are_about_to_exceed_license_limit_max_dom_title' => '도메인을 거의 모두 사용했습니다.',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder' => 'Plesk 라이센스에 제공된 Presence Builder 사이트를 거의 모두(90% 이상) 사용했습니다.',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder_title' => 'Presence Builder 사이트를 거의 모두 사용했습니다.',
    'promo__button_hide' => '숨기기',
    'promo__button_next' => '다음 >>',
    'promo__button_prev' => '<< 이전',
    'promo__button_license' => '라이센스 업데이트',

    'promo__google_integration_title' => 'Google 서비스와 통합',
    'promo__google_integration' => 'AdSense, Google Apps, 웹 마스터 도구 등 Google 서비스와의 통합을 구성합니다.',
    'promo__google_integration_button' => '구성',

    'promo__button_learn_more' => '자세히 알아보기',

    //// Plesk Branding in 10.1
    'panel_branding__description' => '사용자 지정 테마를 통해 인터페이스 모양 및 브랜딩 설정을 사용자 지정할 수 있습니다. Plesk 테마를 사용자 지정하는 방법은 %1을(를) 참조하십시오.',
    'panel_branding__description_link' => '다음 문서',

    ///// File Manager new buttons
    'bt_extract_archive' => '파일 압축 풀기',
    'b_filemanager__extract' => '현재 디렉터리에 선택한 아카이브 파일의 압축을 풉니다. 파일 이름에 자국 문자가 포함된 경우 압축을 푼 후 파일 이름이 잘못 표시될 수 있습니다.',
    'filemanager_error_extracting_files' => '아카이브 파일의 압축을 풀 때 오류가 발생함: %1',
    'filemanager_no_archive_files_specified' => '압축을 풀려는 아카이브를 지정합니다.',
    'filemanager_not_zip_archive_specified' => '%1 ZIP 아카이브가 아니므로 압축을 풀 수 없습니다.',
    'filemanager_files_successfully_extracted' => '아카이브 파일의 압축을 풀었습니다.',
    'filemanager_error_file_download' => '파일을 다운로드하지 못했습니다: %1',
    'filemanager__user_poolgrp' => '응용 프로그램 풀 그룹',

    'loading' => '로딩 중…',
    'bt_create_archive' => '아카이브에 추가',
    'filemanager__pack' => "아카이브 경로: %1",
    'filemanager__archive_name' => '아카이브 파일 이름',
    'filemanager__empty_filename' => '아카이브 파일 이름을 입력하십시오.',
    'filemanager_archive_created' => '아카이브가 만들어졌습니다.',
    'filemanager_error_creating_archive' => '아카이브를 만들 수 없음: %1',

    'cmd_dns__aaaa_dns_record_already_exist' => "영역에 대한 AAA 레코드와 이 레코드가 충돌할 것입니다.",
    'defaultcomponents__ftp_ipv6_hosting_not_supported' => "(FTP 서버는 IPv6 주소를 지원하지 않습니다.)",
    'cmd_dns__glue_dns_record_conflict' => '이 레코드는 영역 \'%1\'의 글루 레코드와 충돌합니다.',
    '__ftp_ipv6_not_supported' => "(FTP 서버는 IPv6 주소를 지원하지 않습니다.)",
    '__ipv6_not_supported' => 'IPv6은 지원되지 않습니다.',
    'mail__ipv6_not_supported' => 'IPv6은 메일 서버에서 지원되지 않습니다.',
    'mail__relay_while_list_ipv6_not_supported' => 'IPv6 릴레이 허용 목록은 메일 서버에서 지원되지 않습니다.',
    'mail__relay_while_list_ipv6_mask_mul_16' => '마스크 값은 16의 배수여야 합니다.',
    'mail__ip_or_mask_is_invalid' => 'IP 주소 또는 마스크가 잘못되었습니다.',
    'nonexistent_mail__redirect_ipv6_not_supported' => 'IPv6 IP 주소로 전달이 지원되지 않습니다.',
    'sa__invalid_trusted_networks' => '잘못 지정된 신뢰할 수 있는 네트워크: %1',
    'dns_add__enter_ipv6_address' => "IPv6 주소",
    'license_trial_days_left' => 'Plesk가 평가판 라이센스로 작동 중이며 %1일 후에 만료됩니다.',
    'excl_ipv6_num' => '전용 IPv6 주소',
    '__ip_mask' => "서브넷 마스크",
    '__ipv4_addr' => 'IPv4 주소',
    '__ipv6_addr' => 'IPv6 주소',
    'template__num_excl_ipv6s' => '리셀러에게 전용 IPv6 주소 할당',
    'anonftp__exclusive_ipv4_required' => '익명 FTP 서비스를 설정하고 사용하려면 전용 IPv4 주소가 필요합니다.',
    'anonftp__ipv4_already_used' => '다른 도메인에 동일한 IPv4 주소로 이미 구성되어 있으므로 이 사이트에 대한 익명 FTP 서비스를 설정할 수 없습니다.',


    'restart__kav' => "Kaspersky Antivirus",
    '__view_migration_log_detailed_info' => '로그 보기',

    'chown__ip_address_warn' => '구독을 새 소유자에게 이동하기 전에 먼저 해당 구독에 대한 새 IP 주소를 선택해야 합니다.',
    'chown__no_ip_address' => '없음',
    'chown__no_ipv4_address' => 'IPv4 주소 없음',
    'chown__no_ipv6_address' => 'IPv6 주소 없음',
    'chown__domain_exclude_already_owned_by_client' => '구독 %1은(는) 해당 사용자에게 이미 속해 있습니다.',
    'chown__error_ip_absent_in_ip_pool' => 'IP 주소 %1은(는) 대상 사용자의 IP 풀에 없습니다.',
    'chown__error_ip_not_exist' => 'ID가 \'%1\'인 IP 주소가 없습니다.',
    'chown__error_domain_ip_not_selected' => '도메인 %1에 대한 IP 주소를 하나 이상 선택해야 합니다. IP 매핑에 대해 선택한 값을 확인합니다.',

    '__new_passwd_single' => "암호",
    '__confirm_passwd_single' => "암호 확인",

    'mail__ip_or_mask_is_invalid_ipv6' => 'IPv6 주소 또는 마스크가 잘못됨: IP 주소는 유효한 유니캐스트 주소여야 합니다.',

    '__subscriptions' => '구독',

    '__owned_by_reseller' => '리셀러가 소유함',
    '__owned_by_provider' => '제공업체가 소유함',

    'service_plan__anonymous' => '사용자 지정',
    'subscription_not_locked__change_limits_warning' => '이 구독은 잠기지 않음: 서비스 플랜과 동기화하는 중 리소스 사용량 제한이 변경됩니다.',
    'subscription_not_locked__change_permissions_warning' => '이 구독은 잠기지 않음: 서비스 플랜과 동기화하는 중 권한이 변경됩니다.',

    'subscription__conflict_resolution_policy' => '충돌 해결 정책',
    'subscription__conflict_resolution_policy_lock' => "구독 잠금",

    'backup__list__backup_warnings' => '경고',
    'backup__list__backup_info' => '정보',
    'backup__restore__object_reseller_template' => '리셀러 템플릿',
    'backup__restore__object_domain_template' => '도메인 템플릿',

    'ui__client/permissions_readonly__title' => '권한',
    'ui__client/permissions_readonly__short-title' => '권한',

    'subscription__unable_lock_anonymous' => '이 구독은 서비스 플랜과 묶여 있지 않아 잠금 해제할 수 없습니다.',
    'subscription__unable_sync_anonymous' => '이 구독은 서비스 플랜과 묶여 있지 않아 동기화할 수 없습니다.',
    'subscription__unable_sync_locked' => '이 구독은 잠겨 있어 동기화할 수 없습니다.',
    'subscription__locked' => '구독이 잠겼습니다.',
    'component_name__urlrewrite' => "URL 다시 쓰기",
    '__quantity' => '수량',
    'hst__www_root_dir_absent' =>  '경고: 문서 루트로 지정한 디렉터리가 없습니다.',
    'object_creation__domain_is_not_a_webspace' => '이 개체는 구독에서만 만들 수 있습니다.',
    'phosting__webspace_hosting_with_sites_cannot_be_deleted' => '구독에는 사이트가 포함되므로 호스팅 유형을 변경하거나 삭제할 수 없습니다.',
    'phosting__addon_domain_ip_must_match_webspace' => '오류: IP 주소를 업데이트하지 못했습니다. 추가 도메인은 구독의 주 도메인에 할당되지 않은 IP 주소를 할당할 수 없습니다.',
    'domain_plan__unable_change' => '서비스 플랜을 변경할 수 없음: %1.',
    'domain_plan__different_hosting_type' => '현재 호스팅 유형이 서비스 플랜에 지정된 유형과 다릅니다.',
    'domain_plan__addon_text' => '추가 기능 플랜',
    'domain_plan__addon_description' => '추가 기능 플랜을 사용하여 호스팅 계획을 보충합니다.',
    'asp_net__managed_runtime_version' => 'ASP.NET 관리 런타임 버전',
    'plan__can_not_change_hosting_type' => '플랜을 편집할 때 호스팅 유형을 변경할 수 없습니다.',
    'plan__apply_problems' => '다음 기능의 문제로 인해 플랜이 적용되지 않았습니다: %1',
    'plan_save__subscription_update_problem' => '플랜 변경 사항을 %1에 적용할 수 없습니다.',
    '__perm_denied_subscription_suspended_by_backuprestore' => "백업 또는 복원 프로세스가 완료될 때까지 구독이 일시 중단됩니다. 나중에 다시 이용하십시오.",
    '__login_incorrect_plain_shadow_password' => '관리자 계정의 암호를 잘못 지정했습니다. 시스템 관리자(루트) 자격 증명을 사용하거나 올바른 암호를 얻으십시오. 암호를 얻는 방법은 /etc/psa/README.psa.shadow 파일을 읽어 보십시오.',

    '__perm_denied_ip' => '보유하고 있지 않은 IP 주소는 전송할 수 없습니다.',

    'dns__dns_zone_not_synchronized' => 'DNS 영역이 수정되었습니다. DNS 템플릿 변경을 이 영역에 적용하려면 이 페이지에서 \'DNS 템플릿 변경 적용하기\' 버튼을 누르거나 서버 관리자 패널>도구 및 설정> DNS 템플릿 설정> DNS 템플릿 변경에서 \'모든 영역에서 변경 적용하기\'룰 선택하십시오.',
    'dns__dns_zone_synchronize_link' => '클릭',
    'dns__dns_zone_synchronize_done' => 'DNS 영역이 동기화되었습니다.',

    'dns__dns_zone_template_error' => 'DNS 영역을 DNS 영역 템플릿과 동기화하는 데 문제가 있습니다.%1',

    'dns__soa_rname_type_owner' => '웹 사이트 소유자의 이메일 주소',
    'dns__soa_rname_type_domain' => '도메인 이메일 주소',
    'dns__soa_rname_type_external' => '외부 이메일 주소',
    'dns__soa_rname_enforce_email' => '도메인별로 RNAME 이메일 주소를 변경하는 것 금지',
    'dns__soa_rname_label' => '이메일(RNAME)',
    'dns__soa_rname_hint' => '도메인의 DNS 영역을 책임지는 사람의 이메일 주소. SOA 쿼리에 응답할 때 DNS 서버에서 반환되었습니다.',

    'dns__dns_zone_soa_sync_title' => '기존의 모든 도메인에 대해 SOA 설정 재정의',
    'dns__dns_zone_soa_sync_legend' => '확인 필요',
    'dns__dns_zone_soa_sync_text' => 'SOA 템플릿의 변경 사항을 적용하여 호스팅된 모든 도메인의 SOA 레코드를 업데이트하시겠습니까?',

    'cu_db__repair_mysql_dbus' => "MySQL 사용자 암호를 복구합니다. 이 작업은 이전 버전에서 Plesk 11로 업그레이드한 경우에 필요합니다.",

    'scheduled_backup_settings__start_at_hint' => '예약된 백업 작업의 확인 간격이 15분입니다. Plesk에서 특정 시간에 백업 프로세스를 시작하도록 하려면 원하는 시간의 최소 15분 전에 작업을 예약합니다.',
    'cu_scheduled_backup_comment' => '예약 백업',
    'cu_scheduled_backup_error' => '백업 프로세스 중 오류가 발생했습니다. %1',
    'cu_scheduled_backup_mail_subject' => '<%1> 예약 백업 중 오류가 발생했습니다.',
    'cu_scheduled_backup_mail_message' => "%1\nPlesk 진입점: %2\n\n예약된 백업 중 다음 오류가 발생했습니다:\n\n%3",

    'cu_scheduled_backup_hourly' => '일정 시간별 백업',
    'cu_scheduled_backup_daily' => '일일 백업',
    'cu_scheduled_backup_weekly' => '주간 백업',
    'cu_scheduled_backup_monthly' => '월간 백업',
    'cu_scheduled_backup_comment_backup_all' => '%1. 모든 구성 및 콘텐츠',
    'cu_scheduled_backup_comment_backup_vhost' => '%1. 메일 메시지 외의 모든 구성 및 콘텐츠.',
    'cu_scheduled_backup_comment_backup_mail' => '%1. 구성 및 메일 메시지만.',
    'cu_scheduled_backup_comment_backup_mail_file' => '%1. 사용자 데이터베이스 외의 모든 구성 및 콘텐츠.',
    'cu_scheduled_backup_comment_backup_mail_database' => '%1. 사용자 파일 외의 모든 구성 및 콘텐츠.',
    'cu_scheduled_backup_comment_backup_database' => '%1. 구성 및 사용자 데이터베이스만.',
    'cu_scheduled_backup_comment_backup_file' => '%1. 구성 및 사용자 파일만.',
    'cu_scheduled_backup_comment_backup_domain' => '%1. 도메인 구성.',

    'cu_scheduled_backup_to_cloud_not_allowed' => '원격 클라우드 스토리지에 예약된 백업을 저장하는 것은 프리미엄 기능입니다. 잠금을 해제하려면 호스팅 제공 업체에 문의하세요.',

    'i_backup_invalid_file' => '올바른 백업이 아닙니다. 이 파일에서 데이터를 복원할 수 없습니다. 자세한 내용은 백업 이름을 클릭합니다.',

    'ui__server/migration/download-agent__short-title' => 'Migration & Transfer Agent 다운로드',
    'ui__server/migration/download-agent__title' => 'Migration & Transfer Agent 다운로드',
    'ui__server/migration/download-agent__description' => 'Plesk 웹 사이트에서 사용 가능한 최신 버전의 마이그레이션 및 전송 에이전트를 다운로드합니다.',

    'filemanager_resulting_archive_exists' => '파일 %1이(가) 대상 디렉터리에 이미 있습니다.',

    'agent_unable_to_connect' => '\'%2\'의 에이전트에 연결할 수 없습니다. 에이전트가 설치되어 실행 중이고 호스트 \'%2\'과(와) 연결 문제가 없는지 확인하십시오.',
    'agent_test_connection_failed' => '\'%2\'의 에이전트에 연결하지 못했습니다.',

    'agent_unable_to_resolve_host' => '원격 호스트 \'%1\'을(를) 찾을 수 없습니다. 호스트와 연결 문제가 없는지 확인하십시오.',
    'agent_unknown_curl_error' => '\'%2\'의 에이전트에 연결하는 중 오류 \'%1\'이(가) 발생했습니다.',
    'agent_unexpected_htp_code' => '\'%2\'의 에이전트에 대한 HTTP 요청에 대해 예상치 못한 HTTP 코드 \'%1\'을(를) 수신했습니다.',
    'agent_unable_to_auth' => '호스트 \'%1\'에서 인증할 수 없습니다. 이 문제를 해결하려면 http://kb.plesk.com/116606의 지침을 따르십시오.',
    'agent_internal_server_error' => '원격 호스트 \'%1\'에서 명령 실행 중 내부 서버 오류가 발생했습니다.',
    'agent_response_is_empty' => '\'%1\'의 에이전트에 대한 HTTP 요청에 대해 빈 응답을 수신했습니다.',

    'migration__disabled_due_to_local_file_does_not_exist' => '로컬 캐시에서 Migration & Transfer Agent를 찾을 수 없습니다. Migration &Transfer Manager를 다시 열어 문제를 해결하십시오.',

    '__hosting_webdeploy' => "웹 배포 게시",
    'cu_domain__webdeploy' => "웹 배포 게시(기본값: %1)",
    'cu_dom_tpl__webdeploy' => "웹 배포 게시(기본값: %1)",
    'cu_subdomain__webdeploy' => "웹 배포 게시(기본값: %1)",
    'webdeploy__not_installed' => "Microsoft Web Deploy가 서버에 설치되지 않았습니다.",
    'webdeploy__forced_by_site_isolation' => "웹 배포 게시 설정을 변경할 수 없음: 서버 전체 보안 정책을 무시할 권한이 없습니다. 자세한 내용은 공급자에게 문의하십시오.",



    'backup__restore_options__admin__server_configuration_license' => '라이센스 키',
    'migration_start_migrate_server_license' => '라이센스 키 이전',

    'defaultcomponents__delegation_rule_not_exist' => '(필수 위임 규칙 \'appPoolPipeline, appPoolNetFx\'이(가) 존재하지 않음)',

    '__o' => 'O',

    'i_backup_created_by_admin' => '백업이 관리자에 의해 만들어졌습니다.',
    'i_backup_created_by_reseller' => '백업이 리셀러에 의해 만들어졌습니다.',
    'i_backup_created_by_client' => '백업이 고객에 의해 만들어졌습니다.',

    'migration__object_exists_on_target_host' => '(대상 호스트에 이미 있음)',

    '__customers_total' => '고객별 합계',
    '__resellers_total' => '리셀러별 합계',
    '__reseller_total' => '리셀러 합계',


    'cu_cl_pref__manage_website_maintenance' => '고급 작업에 액세스: 웹 사이트 복사',
    'cu_cl_pref__manage_protected_dirs' => '암호로 보호된 디렉터리 관리',
    'cu_cl_pref__manage_mail_settings' => '메일 설정 변경 기능',


    'cu__command_update_php_settings' => 'PHP 설정을 업데이트합니다.',
    'cu__php_settings_option' => 'PHP 설정이 포함된 파일의 경로를 설정합니다.',

    'cu__additional_php_settings_option' => '추가 PHP 지시문이 포함된 파일의 경로를 설정합니다.',
    'cu__command_show_php_settings' => '현재 PHP 설정을 표시합니다.',
    'cu__general_settings' => '일반 설정:',
    'cu__performance_settings' => '성능 설정:',
    'cu__php_fpm_settings' => 'PHP-FPM 설정:',
    'cu__additional_directives' => '추가 지시문:',

    'php_settings_permission_required' => '공통 PHP 설정 관리',
    'php_settings_performance_permission_required' => '호스팅 성능 설정 관리',
    'php_settings_customized' => 'PHP 설정이 사용자 지정되었습니다.',
    'php_settings_synchronized_with_plan' => 'PHP 설정과 플랜을 동기화해야 합니다.',
    'phosting__unknown_shell_type' => '사용할 수 없는 셸',

    'login_up__access_denied_subscription_deleted' => '액세스 거부됨: 구독이 제거되었습니다.',

    'role_restricted_to_subscription' => '(구독과 함께 전송됨: %1)',

    'filemanager__extract' => "다음 위치에 파일 압축 풀기: %1",

    'cu__license_command_check_installed_license' => '설치된 라이센스 키의 유효성 검사(키가 유효한 경우 종료 코드 0을 반환하고, 그렇지 않은 경우 1을 반환함)',

    'promo__mobile_manager_title' => 'Plesk 서버 모바일 관리자',
    'promo__mobile_manager' => "모바일 장치(BlackBerry, iPhone 및 Android)에서 서버를 제어하고 모니터링할 수 있도록 Plesk 기능을 확장합니다.",
    'promo__mobile_monitor_title' => 'Plesk 서버 모바일 모니터',
    'promo__mobile_monitor' => '언제 어디서나 모바일 장치(BlackBerry, iPhone 및 Android)에서 Plesk 서버의 중요 정보를 얻습니다.',
    'promo__mobile_button' => '자세히 알아보기',

    'ui__server/migration/video__short-title' => '비디오 튜토리얼',
    'ui__server/migration/video__title' => '비디오 튜토리얼 보기',
    'ui__server/migration/video__description' => '비디오 튜토리얼을 봅니다.',

    'subDomainNameHint' => '와일드카드 하위 도메인을 만들려면 *를 하위 도메인 이름으로 입력합니다. 브라우저에 입력하는 하위 도메인 이름에 관계없이 사이트 방문자가 이 하위 도메인으로 리디렉션됩니다.',
    'subdomains__wildcard_name_invalid' => "하위 도메인 이름이 잘못되었습니다. 와일드카드 하위 도메인 이름에는 영숫자,  하이픈(-)  및 별표(*)만 사용할 수 있습니다.",
    'subdomains__name_invalid' => "하위 도메인 이름이 잘못되었습니다. 하위 도메인 이름에는 영숫자와 하이픈(-)만 사용할 수 있습니다.",

    'domain__wildcard_no_www_prefix' => '와일드카드 하위 도메인에 www 접두어를 사용할 수 없습니다.',

    '__service_title__milter' => "Plesk Postfix milter",
    '__service_description__milter' => "Plesk Postfix 메일 필터",
    '__milter' => "Postfix milter",
    'restart__milter' => "Plesk milter(%1)",
    'restart__pop3' => "Courier POP3 서버",
    'restart__pop3s' => "SSL/TLS를 지원하는 Courier POP3 서버",
    'restart__imap' => "Courier IMAP 서버",
    'restart__imaps' => "SSL/TLS를 지원하는 Courier IMAP 서버",
    'restart__authdaemon' => "Courier IMAP 인증 데몬",
    'restart__imap-pop3' => "Dovecot IMAP 및 POP3 서버",


    'addon_packages_not_supported' => 'APS 패키지 웹 응용 프로그램의 추가 기능은 지원되지 않습니다.',
    'cu_domain__unable_to_automaticaly_select_ip' => 'IP 주소를 도메인에 자동으로 할당할 수 없습니다. -ip 옵션을 사용하여 IP 주소를 지정하십시오.',

    'plesk_key__mb_accounts' => 'Customer and Business Manager의 사용자 계정(리셀러 및 고객)',

    'actionlog__subdomain_dns' => '하위 도메인 DNS 영역',
    'actionlog__site_subdomain_dns' => '추가 도메인 아래 하위 도메인의 DNS 영역',

    // PfW only
    'actionlog__event_site_create' => '도메인이 만들어짐',
    'actionlog__event_site_delete' => '도메인이 삭제됨',
    'actionlog__event_site_update' => '도메인이 업데이트됨',

    'actionlog__event_site_status_update' => '도메인 상태가 업데이트됨',
    'actionlog__event_site_dns_update' => '도메인 DNS 영역이 업데이트됨',
    'actionlog__event_site_guid_update' => '도메인 GUID가 업데이트됨',

    'actionlog__event_site_subdomain_create' => '하위 도메인이 만들어짐',
    'actionlog__event_site_subdomain_delete' => '하위 도메인이 삭제됨',
    'actionlog__event_site_subdomain_update' => '하위 도메인이 업데이트됨',

    'actionlog__event_site_alias_create' => '도메인 별칭이 만들어짐',
    'actionlog__event_site_alias_delete' => '도메인 별칭이 삭제됨',
    'actionlog__event_site_alias_update' => '도메인 별칭이 업데이트됨',

    'actionlog__event_site_alias_dns_update' => '도메인 별칭의 DNS 영역이 업데이트됨',
    'actionlog__event_subdomain_dns_update' => '기본 도메인 아래 하위 도메인의 DNS 영역이 업데이트됨',
    'actionlog__event_site_subdomain_dns_update' => '하위 도메인의 DNS 영역이 업데이트됨',
    // End of PfW only

    'win_policy__bad_password' => '유효성 검사 실패. 암호가 잘못되었습니다.',
    'win_policy__password_too_short' => '유효성 검사 실패. 암호가 너무 짧아서 암호 정책 요구 사항을 충족하지 못합니다.',
    'win_policy__password_too_long' => '유효성 검사 실패. 암호가 너무 길어서 암호 정책 요구 사항을 충족하지 못합니다.',
    'win_policy__password_not_complex_enough' => '검증에 실패했습니다. 암호가 충분히 복잡하지 않고, 암호 정책 요구 사항을 충족하지 않습니다. 강력한 암호는 최소한 다음을 모두 포함해야 합니다. 8자, 하나의 대문자 또는 소문자, 3개의 숫자와 1개의 특수 문자(!, @, #, $, %, ^, &, *, ?, _, ~) 또는 1개의 숫자와 2개의 특수 문자.',

    //// Activation Code feature
    'plesk_key__license_update_failed' => '제품 라이선스를 업데이트할 수 없습니다.',


    'filemanager__error_path_is_not_allowed' => '허용되지 않는 경로',
    'filemanager__error_path_is_invalid' => '경로가 잘못됨',
    'filemanager__error_path_not_found' => '경로를 찾을 수 없음',
    'filemanager__error_path_already_exists' => '경로가 이미 있음',
    'filemanager__error_access_is_denied' => '액세스가 거부됨',
    'filemanager__error_directory_not_empty' => '폴더가 비어 있지 않음',
    'filemanager__error_sharing_violation' => '공유 위반',
    'filemanager__error_not_same_device' => '대상 경로가 동일한 장치에 있지 않음',
    'filemanager__binary_data_access' => '이 파일은 이진 파일일 수 있습니다. 이 파일을 여시겠습니까?',
    'filemanager__unable_to_resolve_realpath' => "지정한 위치에서 파일 %1을(를) 찾을 수 없습니다.",
    'filemanager__access_to_realpath_denied' => "실제 경로에 대한 액세스 거부됨: %1에서 %2.",
    'bt_exit' => '종료',

    'filemanager__chdir_error__' => "디렉터리를 %1(으)로 변경할 수 없음: %2",
    'filemanager__chmod_dir' => "디렉터리에 대한 권한 변경 %1",
    'filemanager__chmod_error__' => "%1 파일에 대한 권한을 변경할 수 없음: %2",
    'filemanager__chmod_file' => "파일에 대한 권한 변경 %1",
    'filemanager__copy_error__' => "%1%2(으)로 복사할 수 없음: %3",
    'filemanager__copy_move' => "다음 위치에서 파일 복사(이동) %1",
    'filemanager__count_size__' => '선택 크기: %1',
    'filemanager__count_size_error__' => '%1에 대한 크기를 계산할 수 없음: %2',
    'filemanager__create_dir' => "디렉터리 만들기",
    'filemanager__create_dir_error__' => "%1 디렉터리를 만들 수 없음: %2",
    'filemanager__dir_not_exists' => "디렉터리 %1이(가) 없습니다.",
    'filemanager__dirname' => "디렉터리 이름",
    'filemanager__filename' => "파일 이름",
    'filemanager__is_no_such' => "다음 이름의 파일 또는 디렉터리가 없음 %1",
    'filemanager__empty_selection' => "선택 파일이 없음.",
    'filemanager__file_exists' => "%1 파일이 이미 있습니다.",
    'filemanager__move_error__' => "%1을(를) %2(으)로 이동할 수 없음: %3",
    'filemanager__new_dir' => "디렉터리 이름",
    'filemanager__not_allowed' => "귀하는 이 파일에 대한 권한을 변경할 수 없습니다.",
    'filemanager__r_perm_dir' => "디렉터리 나열",
    'filemanager__r_perm_file' => "데이터 읽기",
    'filemanager__remove' => "다음 위치에서 파일 제거 %1",
    'filemanager__remove_error__' => "%1 파일을 제거할 수 없음: %2",
    'filemanager__rename_dir' => "디렉터리 이름 바꾸기 %1",
    'filemanager__rename_error__' => "%1 이름을 %2(으)로 바꿀 수 없음: %3",
    'filemanager__rename_file' => "파일 이름 바꾸기 %1",
    'filemanager__set_win_permissions_dir' => "%1 폴더에 대한 권한 설정",
    'filemanager__set_win_permissions_file' => "%1 파일에 대한 권한 설정",
    'filemanager__touch_confirm' => "선택한 파일의 타임스탬프를 변경하시겠습니까?",
    'filemanager__no_perms_or_unsupported_file_type' => '파일을 읽을 수 없거나 파일 형식이 지원되지 않습니다.',
    'filemanager__upload_error__' => "%1을(를) %2(으)로 업로드할 수 없음: %3",
    'filemanager__upload_file' => "파일 업로드",
    'filemanager__upload_file_src' => "파일 경로",
    'filemanager__username' => "사용자",
    'filemanager__w_perm_dir' => "파일 만들기",
    'filemanager__w_perm_file' => "데이터 쓰기",
    'filemanager__x_perm_dir' => "디렉터리 트래버스",
    'filemanager__x_perm_file' => "파일 실행",
    'filemanager__max_image_size_exceeded' => '이미지를 표시할 수 없습니다. 이미지 크기는 %2바이트보다 클 수 없습니다.',

    '__fastcgi_unix_support' => 'FastCGI 지원',

    'dns__subdomain_dns_zone_parent' => '이 하위 도메인의 DNS 레코드가 상위 DNS 영역에 저장되었습니다. 상위 영역 %1을(를) 수정하거나 하위 도메인의 개별 영역을 만들 수 있습니다.',
    'dns__subdomain_dns_zone_parent_link' => '여기',
    'dns__no_dns_zone' => '도메인에서 어떤 DNS 영역도 할당되지 않았습니다. 해당 도메인에 대한 DNS 영역을 관리하려면 \'기본값 복원\' 버튼을 눌러야 합니다.',
    'dns__unable_turn_on_subdomain_zone' => '상위 도메인 영역에 이 하위 도메인에 대한 CNAME 레코드가 있으므로 하위 도메인 영역을 활성화할 수 없습니다.',

    '__hosting_write_modify' => '추가 쓰기/수정 권한',

    'aspdotnet__group_framework_version' => "프레임워크 버전",
    'aspdotnet__param_version' => "버전",

    'bt_restore_default' => "기본값으로 설정",
    'b_aspdotnet' => 'ASP.NET 구성 설정을 편집합니다.',
    'b_aspdotnet__restore_default' => '기본 ASP.NET 설정을 복원합니다.',
    'b_aspdotnet__restore_wdir_default' => "이 가상 디렉터리의 상위 디렉터리 ASP.NET 설정을 복원합니다.",
    'b_aspdotnet__restore_default_disabled' => '기본 ASP.NET 구성 복원을 수행할 수 없습니다. 서버 또는 상위 디렉터리 수준의 ASP.NET 구성이 손상되었습니다.',
    'b_autoinstaller' => 'Plesk 또는 그 구성요소를 업데이트합니다.',
    'b_autoinstaller_configure' => '업데이트 설정.',
    'b_autoinstaller_install' => '선택한 구성 요소를 설치합니다.',

    '__iis_app_pool__use_dedicated' => '전용 IIS 응용 프로그램 풀',
    '__iis_app_pool__use_dedicated_addons' => '각 웹 사이트의 전용 IIS 응용 프로그램 풀',
    '__iis_app_pool__enable_32bit_app_on_win64' => '32비트 애플리케이션 활성화',
    '__iis_app_pool__load_user_profile' => '사용자 프로필 로드',
    'bt_iis_app_pool' => "IIS 응용 프로그램 풀",

    'performance__cpu_usage' => '최대 CPU 사용률(%)',
    'performance__cpu_usage_action' => '제한 작업',
    'performance__cpu_usage_interval' => '제한 기간(분)',
    'performance__cpu_usage_action_not_supported' => '지정된 동작은 웹 서버에서 지원하지 않습니다.',

    'performance__idle_timeout_action_not_supported' => '지정된 유휴 시간 초과 동작은 웹 서버에서 지원하지 않습니다.',
    'performance__max_worker_processes' => '최대 작업자 프로세스 수',
    'performance__idle_timeout' => '유휴 시간 초과(분)',
    'performance__idle_timeout_action' => '유휴 시간 초과 동작',
    'performance__recycling_by_time' => '정기적 간격으로 재사용(분)',
    'performance__recycling_by_requests' => '최대 수의 요청에 도달한 경우 재사용',
    'performance__recycling_by_virtual_memory' => '가상 메모리의 최대 양이 사용된 경우 재사용',
    'performance__recycling_by_private_memory' => '사설 메모리의 최대 양이 사용된 경우 재사용',
    'performance__managed_pipeline_mode' => '관리되는 파이프라인 모드',
    'performance__managed_pipeline_mode_not_supported' => '웹 서버가 지정한 모드를 지원하지 않습니다.',

    'iis_app_pool' => 'IIS 응용 프로그램 풀 관리.',
    'b_iis_app_pool' => 'IIS 응용 프로그램 풀을 관리합니다.',
    'iis_app_pool_cl_dom' => 'IIS 응용 프로그램 풀 관리.',

    'i_webdirs_not_protected' => '이 디렉터리는 보호되지 않습니다.',
    'i_webdirs_protected' => '이 디렉터리는 보호됩니다.',
    'i_webdirs_manage_protection' => '보호 관리.',
    'i_webdirs_open' => '브라우저에서 디렉터리/파일을 엽니다.',
    'i_webdirs_preferences_disabled' => '이 디렉터리는 가상 디렉터리가 아닙니다.',
    'i_webdirs_permissions' => '권한을 관리합니다.',
    'i_webdirs_permissions_disabled' => '디렉터리 권한 관리를 사용할 수 없습니다.',
    'i_webdirs_type_dir' => '실제 디렉터리',
    'i_webdirs_type_vdir' => '가상 디렉터리',
    'i_webdirs_browse' => '디렉터리 내용을 찾아봅니다.',
    'i_webdirs_preferences' => '웹 디렉터리 설정 관리.',

    'l_webdirslist_type' => '유형을 기준으로 디렉터리를 정렬합니다.',
    'l_webdirslist_protected' => '보호 상태를 기준으로 디렉터리를 정렬합니다.',
    'l_webdirslist_name' => '이름을 기준으로 디렉터리를 정렬합니다.',

    'b_webdirslist_remove' => '선택한 가상 디렉터리를 삭제합니다.',
    'b_webdirslist_search' => '검색 패턴을 입력하고 클릭하여 가상 디렉터리를 찾습니다.',
    'b_webdirslist_show_all' => '모든 디렉터리를 표시합니다.',

    'l_webdirerrordocslist_code' => '오류 코드 번호를 기준으로 오류 문서를 정렬합니다.',
    'l_webdirerrordocslist_name' => '오류 설명을 기준으로 오류 문서를 정렬합니다.',
    'l_webdirerrordocslist_type' => '오류 문서 유형을 기준으로 오류 문서를 정렬합니다.',
    'l_webdirerrordocslist_location' => '오류 문서 위치를 기준으로 오류 문서를 정렬합니다.',

    'b_webdirerrordocslist_search' => '검색 패턴을 입력하고 클릭하여 오류 문서를 찾습니다.',
    'b_webdirerrordocslist_remove' => '선택한 오류 문서를 삭제합니다.',
    'b_webdirerrordocslist_show_all' => '모든 오류 문서를 표시합니다.',

    'l_webdirmimetypeslist_name' => '확장자를 기준으로 MIME 유형을 정렬합니다.',
    'l_webdirmimetypeslist_content' => '콘텐츠를 기준으로 MIME 유형을 정렬합니다.',

    'b_webdirmimetypeslist_remove' => '선택한 MIME 유형을 삭제합니다.',
    'b_webdirmimetypeslist_search' => '검색 패턴을 입력하고 클릭하여 MIME 유형을 찾습니다.',
    'b_webdirmimetypeslist_show_all' => '모든 MIME 유형을 표시합니다.',

    'b_webdir_preferences' => "가상 디렉터리 설정.",
    'b_webdir_permissions' => "가상 디렉터리 권한.",
    'b_webdir_permissions_disabled' => "디렉터리 권한 관리를 사용할 수 없습니다.",
    'b_to_webdirs' => '디렉터리 관리로 돌아갑니다.',
    'b_to_webdir_mime_types' => 'MIME 유형 관리로 돌아갑니다.',
    'b_to_webdir_error_docs' => '오류 문서 관리로 돌아갑니다.',
    'b_to_webdir_protection' => '가상 디렉터리 보호 관리로 돌아갑니다.',

    'webdirs__title' => '가상 디렉터리 %1',
    'webdirs__preferences_title' => '가상 디렉터리 설정',
    'webdirs__list_legend' => '가상 디렉터리',
    'webdirs__list_type' => 'T',
    'webdirs__list_protected' => 'P',
    'webdirs__list_name' => '이름',
    'webdirs__list_header' => '%1 항목',
    'webdirs__tabs_general' => '일반',
    'webdirs__tabs_mime_types' => 'MIME 유형',
    'webdirs__tabs_error_docs' => '오류 문서',

    'webdirs__tabs_permissions' => '권한',
    'webdir__remove_vdirs' => '다음 가상 디렉터리가 삭제됨:',
    'webdir__remove_mime_types' => '다음 MIME 유형이 삭제됨:',
    'webdir__mime_types_title' => 'MIME 유형',
    'webdir__protection_disable_confirm' => '디렉터리에서 보호 기능을 제거하시겠습니까?',
    'webdir__protect_title' => '보호된 URL 사용자',
    'webdirs__permissions_title' => '가상 디렉터리 권한',
    'webdirs__browse_content_permission_denied' => '이 디렉터리의 내용을 볼 수 있는 권한이 없습니다.',
    'error_doc__list_code' => '오류',
    'error_doc__list_code_description' => '설명',
    'error_doc__list_type' => '유형',
    'error_doc__list_location' => '위치',
    'error_doc__code' => '오류',
    'error_doc__type' => '유형',
    'error_doc__type_file' => '파일',
    'error_doc__type_url' => 'URL',
    'error_doc__location' => '위치',
    'error_doc__legend' => '오류 문서',
    'error_doc__edit_title' => '오류 문서 편집',
    'error_doc_erorr_invalid_url_location' => 'URL이 잘못되었습니다. 올바른 URL을 지정하십시오.',
    'error_doc_erorr_invalid_file_location' => '파일 경로가 잘못되었습니다. 올바른 파일 경로를 지정하십시오.',
    'error_doc__type_default' => '기본값',

    'webdirs__tabs_protection' => '보호',
    'pb_webdirs' => '가상 디렉터리',

    'webdirs_remove_title' => '다음 가상 디렉터리가 제거됨:',
    'webdirs_mime_types_remove_title' => '다음 MIME 유형이 제거됨:',
    'webdirs_preferences_title' => '가상 디렉터리 설정',
    'webdirs_permissions_title' => '파일 및 폴더에 대한 특별 권한',
    'webdi_protection_disable_confirm' => '가상 디렉터리에서 보호 기능을 제거하시겠습니까? 보호 기능을 제거하면 보호된 디렉터리 사용자 및 디렉터리 보호 설정이 모두 제거됩니다.',
    'bt_protect' => '보호',
    'bt_unprotect' => '보호 제거',
    'bt_show_additional_users' => '사용자 자세히 표시',
    'bt_hide_additional_users' => '사용자 간단히 표시',
    'error_doc__list_title' => '오류 문서',
    'error_doc__list_header' => '오류 문서',
    'error_doc__code_400' => '잘못된 요청',
    'error_doc__code_401' => '권한 없음',
    'error_doc__code_401.1' => '권한 없음 - 로그인 실패',
    'error_doc__code_401.2' => '권한 없음 - 서버 구성으로 인해 로그인 실패',
    'error_doc__code_401.3' => '권한 없음 - 리소스의 ACL로 인해 권한 없음',
    'error_doc__code_401.4' => '권한 없음 - 필터로 인해 인증 실패',
    'error_doc__code_401.5' => '권한 없음 - ISAPI/CGI 응용 프로그램으로 인해 인증 실패',
    'error_doc__code_401.7' => '권한 없음 - URL 인증 정책으로 인해 거부됨',
    'error_doc__code_403' => '금지됨',
    'error_doc__code_403.1' => '금지됨 - 액세스 실행이 거부됨',
    'error_doc__code_403.2' => '금지됨 - 읽기 액세스가 거부됨',
    'error_doc__code_403.3' => '금지됨 - 쓰기 액세스가 거부됨',
    'error_doc__code_403.4' => '금지됨 - SSL 필요',
    'error_doc__code_403.5' => '금지됨 - SSL 128 필요',
    'error_doc__code_403.6' => '금지됨 - IP 암호가 거부됨',
    'error_doc__code_403.7' => '금지됨 - 클라이언트 인증서 필요',
    'error_doc__code_403.8' => '금지됨 - 사이트 액세스가 거부됨',
    'error_doc__code_403.9' => '금지됨 - 사용자가 너무 많음',
    'error_doc__code_403.10' => '금지됨 - 잘못된 구성',
    'error_doc__code_403.11' => '금지됨 - 암호 변경',
    'error_doc__code_403.12' => '금지됨 - 매퍼가 액세스를 거부함',
    'error_doc__code_403.13' => '금지됨 - 클라이언트 인증서가 취소됨',
    'error_doc__code_403.14' => '금지됨 - 디렉터리 나열이 거부됨',
    'error_doc__code_403.15' => '금지됨 - 클라이언트 액세스 라이센스를 초과함',
    'error_doc__code_403.16' => '금지됨 - 클라이언트 인증서를 신뢰할 수 없거나 형식이 잘못됨',
    'error_doc__code_403.17' => '금지됨 - 클라이언트 인증서가 만료되었거나 아직 유효하지 않음',
    'error_doc__code_403.18' => '금지됨 - 이 응용 프로그램 풀에서 요청을 실행할 수 없음',
    'error_doc__code_403.19' => '금지됨 - CGI 액세스가 거부됨',
    'error_doc__code_403.20' => '권한 없음 - 패스포트 로그인 실패',
    'error_doc__code_404' => '찾을 수 없음',
    'error_doc__code_404.2' => '찾을 수 없음 - 잠금 정책으로 인해 거부됨',
    'error_doc__code_404.3' => '찾을 수 없음 - MIMEMAP 정책으로 인해 거부됨',
    'error_doc__code_405' => '허용되지 않는 메서드',
    'error_doc__code_406' => '허용되지 않음',
    'error_doc__code_407' => '프록시 인증 필요',
    'error_doc__code_412' => '사전 조건 실패',
    'error_doc__code_414' => '요청-URI가 너무 김',
    'error_doc__code_415' => '지원되지 않는 미디어 유형',
    'error_doc__code_500' => '내부 서버 오류',
    'error_doc__code_500.12' => '내부 서버 오류 - 응용 프로그램이 다시 시작함',
    'error_doc__code_500.13' => '내부 서버 오류 - 서버가 사용 중임',
    'error_doc__code_500.15' => '내부 서버 오류 - 금지된 GLOBAL.ASA에 대한 직접 요청',
    'error_doc__code_500.16' => '내부 서버 오류 - UNC 액세스 오류',
    'error_doc__code_500.17' => '내부 서버 오류 - URL 인증 저장소를 찾을 수 없음',
    'error_doc__code_500.18' => '내부 서버 오류 - URL 인증 저장소를 열 수 없음',
    'error_doc__code_500.19' => '내부 서버 오류 - 잘못된 파일 메타데이터',
    'error_doc__code_500.100' => '내부 서버 오류 - ASP 오류',
    'error_doc__code_501' => '구현되지 않음',
    'error_doc__code_502' => '잘못된 게이트웨이',
    'error_doc__code_503' => '서비스를 일시적으로 이용할 수 없음',

    'mimetype__extension' => '확장명',
    'mimetype__content' => '내용',
    'mimetypeslist__title' => 'MIME 유형',
    'mimetypes__title' => 'MIME 유형',
    'mimetypes__select_to_remove' => '제거할 MIME 유형을 선택합니다.',
    'mimetypes__select_for_remove' => "제거할 MIME 유형을 선택합니다.",
    'mimetypes_remove__title' => 'MIME 유형 제거',
    'mimetype__legend' => 'MIME 유형',
    'mimetype_edit__title' => 'MIME 유형 편집',
    'mimetype_edit__already_exists' => '이 확장명에 대한 MIME 유형이 이미 정의되었습니다.',
    'mimetype_edit__not_exists' => 'MIME 유형이 존재하지 않습니다.',
    'mimetype__content_type_other' => '사용자 지정...',

    'b_webdir_protection_enable' => '암호로 보호된 디렉터리에 해당하는 URL을 지정합니다.',
    'b_webdir_protection_disable' => '모두가 액세스 가능한 디렉터리에 해당하는 URL을 지정합니다.',
    'b_webdir_protection_disabled' => '가상 디렉터리 보호가 비활성화되었습니다.',

    'b_pd_usr_create' => '이 보호된 URL 사용자를 만들려면 클릭합니다.',
    'php__changeversion_title' => "PHP 버전 선택",
    'php__group_php_version' => "PHP 버전",

    'virtualdir__name' => '이름',
    'virtualdir__path' => '경로',
    'virtualdir__read' => '읽기 권한',
    'virtualdir__read_short' => 'R',
    'virtualdir__write' => '쓰기 권한',
    'virtualdir__write_short' => 'W',
    'virtualdir__source' => '스크립트 소스 액세스',
    'virtualdir__source_short' => 'S',
    'virtualdir__browse' => '디렉터리 탐색',
    'virtualdir__browse_short' => 'B',
    'virtualdir__script_execute' => '권한 실행',
    'virtualdir__script_execute_short' => 'E',
    'virtualdir__log_visits' => '방문 기록',
    'virtualdir__app_create' => '응용 프로그램 생성',
    'virtualdir__app_create_short' => 'A',
    'virtualdir__auth_anon' => '익명 인증을 활성화합니다.',
    'virtualdir__auth_windows' => 'Windows 인증을 활성화합니다.',
    'virtualdir__auth_not_enabled' => '익명 또는 Windows 인증을 활성화해야 합니다.',
    'virtualdir__require_ssl' => 'SSL/TLS 필요',
    'virtualdir__enable_default_doc' => '기본 문서 사용',
    'virtualdir__default_doc' => '기본 문서 검색 순서',
    'virtualdir__enable_parent_paths' => '상위 경로를 사용하도록 허용',
    'virtualdir__execute_in_mta' => 'MTA(Multi-Threaded Apartment) 모드로 응용 프로그램 실행 허용',
    'virtualdir_create__title' => '다음 위치에 가상 디렉터리 생성 %1',
    'virtualdir_edit__title' => '가상 디렉터리 속성 %1',
    'virtualdir_edit__legend' => '가상 디렉터리',
    'virtualdir_edit__application_legend' => '응용 프로그램 설정',
    'virtualdir_edit__security_legend' => '디렉터리 보안',
    'virtualdir_edit__documents_legend' => '문서',
    'virtualdir_edit__list_legend' => '중첩된 가상 디렉터리',
    'virtualdir_error__path_not_in__' => '유효하지 않은 경로가 지정됨',
    'virtualdir_error__already_exists' => '해당 이름의 디렉터리가 이미 있습니다.',
    'virtualdir_root' => '가상 디렉터리',
    'virtualdir_root__title' => '가상 디렉터리',
    'virtualdir_root__list_legend' => '가상 디렉터리',
    'virtualdir_se__none' => '없음',
    'virtualdir_se__script' => '스크립트만',
    'virtualdir_se__script_execute' => '스크립트와 실행 파일',
    'virtualdirs__title' => '가상 디렉터리',
    'virtualdirs__path_not_exists' => '잘못된 경로.',
    'virtualdirs__select_for_remove' => "제거할 가상 디렉터리를 선택합니다.",
    'virtualdirs_remove__title' => '가상 디렉터리 제거',
    'virtualdirs_phys_dir_exist' => '이미 같은 이름을 가진 물리 디렉터리가 존재합니다. 계속할 경우, 액세스하지 못하게 됩니다.  계속 하시겠습니까?',
    'virtualdir_auto_create_dir' => "가상 디렉터리와 이름이 같은 실제 디렉터리 생성",

    'asp_max_default_text' => '상위 디렉터리에 의해 정의됨(%1KB)',
    'asp_max_default_text_site' => 'IIS에 의해 정의됨(%1KB)',
    'asp_max_buffer_text' =>'ASP 버퍼의 최대 크기(KB)',
    'asp_max_body_text' => 'ASP 요청의 엔터티 본문 최대 크기(KB)',
    'asp_buffers_legend' =>'ASP 설정',

    'asp_debug_default_text' =>'상위 디렉터리에 의해 정의됨',
    'asp_debug_default_text_site' =>'IIS에 의해 정의됨',
    'asp_client_debug_text' =>'ASP 클라이언트측 스크립트 디버깅 활성화',
    'asp_server_debug_text' =>'ASP 서버측 스크립트 디버깅 활성화',

    'webdirs__list_with_broken_dirs' => "존재하지 않는 실제 폴더에 연결된 가상 디렉터리가 있습니다.",
    'webdirs__vdir_physical_path_not_exist' => "가상 디렉터리가 존재하지 않는 실제 폴더에 연결되어 있습니다.",
    'webdirs__physical_path_not_exist' => "지정한 경로가 없습니다.",

    'filemanager__new_dir_title' => '디렉토리 만들기',
    'php__configuration_title' => "PHP 구성",

    'permissions__title' => '액세스 권한 설정',
    'permissions__title_advanced' => '고급 액세스 권한 설정',
    'permissions__inherit_from_parent' => '상위 개체의 상속 가능한 권한이 이 개체와 모든 하위 개체에 전파되도록 허용합니다. 여기에 명시적으로 정의된 항목을 함께 포함합니다.',
    'permissions__replace_on_children' => '모든 하위 개체에 대한 권한 항목을 여기에 표시된 항목으로 대체합니다.',
    'permissions__group_or_user_name' => '그룹 또는 사용자 이름',
    'permissions__Permissions_for' => '다음에 대한 권한',
    'permissions__allow' => '허용',
    'permissions__deny' => '거부',
    'permissions__FullControl' => '전체 제어',
    'permissions__Modify' => '수정',
    'permissions__ReadAndExecute' => '읽기 및 실행',
    'permissions__ListFolderContents' => '폴더 내용 나열',
    'permissions__Read' => '읽기',
    'permissions__Write' => '쓰기',
    'permissions__ReadControl' => '읽기 제어',
    'permissions__WriteControl' => '쓰기 제어',
    'permissions__ExecuteControl' => '실행 제어',
    'permissions__TraverseFolderOrExecuteFile' => '폴더 통과/파일 실행',
    'permissions__ListFolderOrRead' => '폴더 나열/데이터 읽기',
    'permissions__CreateFilesOrWrite' => '파일 생성/데이터 쓰기',
    'permissions__CreateFoldersOrAppend' => '폴더 생성/데이터 추가',
    'permissions__DeleteSubfoldersandFiles' => '하위 폴더 및 파일 삭제',
    'permissions__Delete' => '삭제',
    'permissions__ChangePermissions' => '권한 변경',
    'permissions__TakeOwnership' => '소유권 가져오기',
    'permissions__inherited_from' => '다음에서 상속됨',
    'permissions__not_inherited' => '<not inherited>',
    'permissions__apply_to' => '적용 대상',
    'permissions__apply_onto' => '적용 대상:',
    'permissions__apply_onto1' => '이 폴더만',
    'permissions__apply_onto2' => '하위 폴더만',
    'permissions__apply_onto3' => '이 폴더와 하위 폴더',
    'permissions__apply_onto4' => '파일만',
    'permissions__apply_onto5' => '이 폴더와 파일',
    'permissions__apply_onto6' => '하위 폴더와 파일만',
    'permissions__apply_onto7' => '이 폴더, 하위 폴더 및 파일',

    'filemanager__not_allowed_dir' => "이 폴더에 대한 권한을 변경할 수 없습니다.",

    'filemanager__allow' => "허용",
    'filemanager__deny' => "거부",
    'filemanager__user_domusr' => '웹 사이트 관리자',
    'filemanager__user_webusr' => '웹 사용자',
    'filemanager__user_admins' => '관리자',
    'filemanager__user_system' => '시스템',
    'filemanager__user_aspnet' => 'ASP.NET 사용자',
    'filemanager__user_poolusr' => '응용 프로그램 풀 사용자',
    'filemanager__user_sysaccount' => '추가 시스템 사용자',

    'bt_permissions_advanced' => '고급',
    'b_permissions_advanced' => '특별 권한을 보고 설정하려면 클릭합니다.',

    'hotlink-protection_invalid_friend_domain' => '안전한 도메인의 이름이 잘못됨.',
    'hotlink-protection_duplicate_friend_domain' => '안전한 도메인의 이름이 중복됨.',
    'hotlink-protection_invalid_extensions' => '파일 확장명에 잘못된 문자가 있습니다.',

    'i_domain_alias_status_on' => '도메인 별칭이 활성화되었습니다.',
    'i_domain_alias_status_off' => '도메인 별칭이 비활성화되었습니다.',
    'i_domain_alias_status_with_parent' => '도메인이 해제되어서 도메인 별칭이 비활성화되었습니다.',
    'i_domain_alias_turn_off' => '비활성화하려면 클릭합니다.',
    'i_domain_alias_turn_on' => '활성화하려면 클릭합니다.',
    'i_domain_alias_mail_on' => '이 도메인 별칭에 대한 메일 서비스가 활성화되었습니다.',
    'i_domain_alias_mail_off' => '이 도메인 별칭에 대한 메일 서비스가 비활성화되었습니다.',
    'i_domain_alias_mail_with_parent' => '도메인 별칭이 해제되어서 메일 서비스가 비활성화되었습니다.',
    'i_domain_alias_web_on' => '이 도메인 별칭에 대한 웹 서비스가 활성화되었습니다.',
    'i_domain_alias_web_off' => '이 도메인 별칭에 대한 웹 서비스가 비활성화되었습니다.',
    'i_domain_alias_web_with_parent' => '도메인 별칭이 해제되어서 웹 서비스가 비활성화되었습니다.',
    'i_domain_alias_dns_on' => 'DNS 별칭 서비스가 이 도메인 별칭에 켜져 있습니다.',
    'i_domain_alias_dns_off' => 'DNS 별칭 서비스가 이 도메인 별칭에 꺼져 있습니다.',
    'i_domain_alias_dns_with_parent' => '도메인 별칭이 해제되어서 상위 도메인과의 DNS 동기화가 비활성화되었습니다.',
    'i_domain_alias_seoRedirect_on' => '이 도메인에 대해 HTTP 301 코드로 리디렉션이 켜졌습니다.',
    'i_domain_alias_seoRedirect_off' => '이 도메인에 대해 HTTP 301 코드로 리디렉션이 꺼졌습니다.',
    'i_domain_alias_seoRedirect_with_parent' => '도메인 별칭이 꺼졌기 땨문에 HTTP 301 코드로 리디렉션이 꺼졌습니다.',

    'domain_alias__control_title' => '도메인 별칭 %1',
    'domain_alias__control_info_legend' => '정보',
    'domain_alias__control_status_title' => 'S',
    'domain_alias__control_name_title' => '서비스 이름',
    'domain_alias__control_details_title' => '세부 정보',

    'domain_alias__invalid_values' => '잘못된 도메인 이름을 지정했습니다. 도메인 이름은 문자, 숫자 및 하이픈으로 구성할 수 있습니다. 점 사이에 있는 도메인 이름의 각 부분은 63개 기호보다 길 수 없습니다.',
    'domain_alias__domain_already_exists' => "도메인 별칭 %1의 이름이 올바르지 않습니다. 도메인 %1이(가) 이미 있습니다.",
    'domain_alias__www_prefix_domain_already_exists' => "도메인 별칭 www.%1의 이름이 올바르지 않습니다. 이 별칭은 도메인 %1에 대해 이미 생성되었습니다.",
    'domain_alias__webmail_enabled_domain_already_exists' => '도메인 별칭 웹메일의 이름이 올바르지 않습니다.%1. 이 별칭은 도메인 %1용으로 이미 생성되었습니다.',
    'domain_alias__lists_enabled_domain_already_exists' => '도메인 별칭 목록의 이름이 올바르지 않습니다.%1. 이 별칭은 도메인 %1용으로 이미 생성되었습니다.',
    'domain_alias__dns_record_already_exists' => '도메인 별칭 %1을(를) 설정할 수 없습니다. 호스트 %1을(를) 가리키는 DNS 레코드가 이미 있기 때문입니다.',
    'domain_alias__domain_alias_already_exists' => "이러한 이름을 갖는 도메인 별칭이 이미 있습니다.",
    'domain_aliases__mail_server_not_support_aliases' => '메일 서버가 도메인 별칭 기능을 지원하지 않습니다. 도메인 별칭이 올바르게 작동하지 않을 수 있습니다.',
    'domain_alias__restrict_domain_creation' => '도메인 별칭에 대해 지정된 이름은 서버 전체 정책에 의해 금지되어 있습니다. 이 도메인 별칭 이름이 자신에게 속해 있는 경우, 호스팅 공급자에게 연락하십시오.',
    'domain_alias__restrict_creation_with_www' => '\'www\' 접두사 없이 도메인 이름을 입력하십시오. 도메인에 대한 www 접두사는 웹 서버 구성에 자동으로 추가됩니다.',
    'domain_unable_to_set_name' => '이름 %1이(가) 잘못됨.',

    'domain_alias__domain_service_dns_disabled' => '이 도메인은 다른 DNS 서버에 의해 서비스됩니다.',
    'domain_alias__domain_service_dns_enabled_master' => '이 DNS 서버가 이 DNS 영역의 기본 이름 서버로 작동합니다.',
    'domain_alias__domain_service_dns_enabled_slave' => '이 DNS 서버가 이 DNS 영역의 보조 이름 서버로 작동합니다.',
    'domain_alias__domain_service_mail_enabled' => '도메인에 대한 메일 서비스가 설정되었습니다.',
    'domain_alias__domain_service_mail_disabled' => '도메인에 대한 메일 서비스가 해제되었습니다.',
    'domain_alias__domain_service_mail_mx' => '%1은(는) 메일 서버로 사용됩니다.',

    'domain_alias__service_seoRedirect_hint' => '방문자가 별칭의 URL을 열면 기본 도메인의 URL로 리디렉션됩니다. Plesk는 검색 엔진에 친화적인 HTTP 301 리디렉션을 사용하므로 URL 사이에서 검색 엔진 순위가 분할되지 않습니다.',

    'bt_task_run_now' => '지금 실행',
    'ftp__read_perm' => "읽기 권한",
    'ftp__write_perm' => "쓰기 권한",

    'filemanager__upload_backup_file_hint' => '여기서는 백업 파일을 Plesk 스토리지에 업로드할 수 있습니다. 최대 파일 크기가 2 GB로 제한됩니다.',

    '__default_for_mssql' => 'MS SQL에 대한 기본값',

    '__login_does_not_pass_validation' => "사용자 이름이 유효하지 않습니다. 사용자 이름은 다음 요구 사항을 충족해야 합니다: %1",
    '__login_allowed_symbols' => '점, 대시 및 밑줄을 포함한 영숫자 문자만 허용됩니다. 첫 문자는 영숫자여야 합니다.',

    'restart__nginx' => '리버스 프록시 서버(nginx)',
    'restart__php-fpm' => 'PHP-FPM %1',

    'admin_ed__i_would_like_recieve_announce' => "Plesk에서 일반 제품 정보와 알림을 받고 싶습니다.",
    'admin_ed__i_would_like_recieve_tech_announce' => "Plesk에서 보안 관련 정보와 기타 기술 알림을 받고 싶습니다.",

    '__login_status_inactive' => '계정이 비활성화되었습니다. Plesk 관리자에게 연락하십시오.',

    'migration__task_keep_in_process' => '확인',
    'migration__task_keep_in_process_conhelp' => '도구 및 설정 페이지로 돌아갑니다. 백그라운드에서 마이그레이션이 계속됩니다.',

    'ui__admin-alias-info__description' => "추가 관리자 계정의 연락처 정보를 편집합니다.",
    'ui__admin-alias-info__short-title' => "연락처 정보",
    'ui__admin-alias-info__title' => "추가 관리자 계정 정보",
    'ui__admin-alias-password__description' => "추가 관리자의 암호를 변경합니다.",

    'ui__admin-alias-password__short-title' => "암호 변경",
    'ui__admin-alias-password__title' => "추가 관리자의 암호",
    'ui__admin-alias__description' => "추가 관리자 계정 정보를 보고 변경합니다.",

    'chk_js__warning_about_login_syntax' => "사용자 이름에 소문자 영숫자, 대시 및 밑줄 기호를 사용할 수 있습니다. 사용자 이름은 영문자 기호로 시작해야 합니다. 암호에는 사용자 이름과 따옴표가 포함될 수 없습니다.",
    'chk_js__warning_about_ftp_login_syntax' => "사용자 이름에 영숫자, 대시 및 밑줄 기호를 사용할 수 있습니다.",
    'chk_js__warning_about_login_syntax_win' => "사용자 이름에 소문자 영숫자, 대시, 도트 및 밑줄 기호를 사용할 수 있습니다. 사용자 이름은 영문자 기호나 숫자로 시작해야 합니다. 암호에는 사용자 이름과 따옴표가 포함될 수 없습니다.",
    'chk_js__warning_about_passwd_syntax' => "암호에 인용 부호, 공백 및 자국 문자를 사용하지 마십시오.\n암호는 길이가 %1에서 %2자 사이여야 하며 사용자 이름을 포함할 수 없습니다.",
    'chk_js__warning_about_plesk_login_syntax' => "사용자 이름에 소문자 영숫자, 점, 대시 및 밑줄 기호를 사용할 수 있습니다.",
    'chk_js__warning_about_plesk_login_syntax_win' => "사용자 이름에 소문자 영숫자, 대시 및 밑줄 기호를 사용할 수 있습니다. 사용자 이름은 영문자 기호로 시작해야 합니다.",
    'chk_js__warning_about_plesk_passwd_syntax' => "암호에 인용 부호, 공백 및 자국 문자를 사용하지 마십시오.\n암호는 길이가 %1~%2자여야 하며 사용자 이름을 포함할 수 없습니다.",
    'chk_js__warning_about_pam_passwd_error' => "잘못된 시스템 사용자 계정이 지정됨: %1",

    'cmd_server__admin_alias_not_found' => "추가 관리자 계정을 찾을 수 없습니다.",

    'panel_branding__skins_already_exists' => "참고: 테마 '%1'이(가) 이미 있습니다. 현재 설치 중인 테마로 대체됩니다.",
    'panel_branding__skins_file_exists' => "테마 '%1'에 대한 디렉터리를 생성할 수 없습니다. 해당 이름의 파일이 이미 있습니다.",

    'actionlog__login_failed' => '로그인하지 못했습니다.',
    'actionlog__event_cp_user_login_failed' => 'Plesk 사용자가 로그인하지 못했습니다.',
    'actionlog__api_login_failed' => 'API을 통해 로그인하지 못했습니다.',
    'actionlog__event_cp_user_api_login_failed' => 'Plesk 사용자가 API을 통해 로그인하지 못했습니다.',
    'actionlog__pw_reset' => '요청된 비밀번호 재설정',

    'ch_pass_admin__email_subject' => "Plesk 암호 미리 알림",
    'ch_pass_admin__email_body' => "안녕하세요, %1 님.\n\n보안상의 이유로 관리자 암호는 이메일로 보낼 수 없습니다.\n\n'admin'로 로그인하려면, 'plesk login' 명령을 사용하십시오.\n\n새로운 'admin' 암호를 설정하려면 'plesk bin admin --set-password -passwd <new_password>' 명령을 사용하십시오.\n\n",
    'ch_pass_admin__message_send_error' => '이메일을 보낼 수 없음: %1',

    'ch_pass_by_secret__email_subject' => "Plesk 암호 미리 알림",
    'ch_pass_by_secret__email_body' => "안녕하세요, %2 님\n\n새 암호를 설정하려면 링크를 따라 가십시오. %1\n\n로그인: %3",
    'ch_pass_by_secret__message_send_error' => '비밀 코드를 보낼 수 없음: %1',
    'ch_pass_by_secret__title' => '암호 변경',
    'ch_pass_by_secret__secret' => '비밀 코드',

    'custom_button__noframe' => "프레임을 사용하지 않음",

    'custom_button__internal_hint' => 'Plesk 페이지와 새 브라우저 창 중 어디서 URL을 열지 지정합니다.',
    'custom_button__noframe_hint' => '고객 패널의 Plesk 확장 또는 응용 프로그램으로 이어지는 사용자 지정 버튼을 추가하는 경우, 이 확장/응용 프로그램이 표시되는 방식을 지정할 수 있습니다. 즉, 프레임으로 표시하거나 Plesk GUI의 일부로 표시합니다.',


    'actionlog__patch' => '업데이트',
    'actionlog__patch_available' => '사용 가능',
    'actionlog__event_patch_available' => '업데이트가 있습니다.',
    'actionlog__patch_installed' => '설치됨',
    'actionlog__event_patch_installed' => '업데이트가 설치됨',

    'actionlog__extension' => '확장 프로그램',
    'actionlog__extension_status' => '확장 프로그램 상태',
    'actionlog__cloning' => '서버 클로닝',
    'actionlog__cloning_complete' => '완료',
    'actionlog__event_cloning_complete' => '서버 클로닝 완료',

    'actionlog__ssl_web_binding' => '도메인의 SSL/TLS 인증서',
    'actionlog__ssl_web_binding_update' => '할당됨/할당되지 않음',
    'actionlog__event_ssl_web_binding_update' => '도메인의 SSL/TLS 인증서가 할당됨/할당되지 않음',

    'actionlog__ssl_web_mail_binding' => '웹 메일의 SSL/TLS 인증서',
    'actionlog__ssl_web_mail_binding_update' => '할당됨/할당되지 않음',
    'actionlog__event_ssl_web_mail_binding_update' => '웹 메일의 SSL/TLS 인증서가 할당됨/할당되지 않음',

    'actionlog__ssl_mail_binding' => '메일 서버의 SSL/TLS 인증서',
    'actionlog__ssl_mail_binding_update' => '할당됨/할당되지 않음',
    'actionlog__event_ssl_mail_binding_update' => '메일 서버의 SSL/TLS 인증서가 할당됨/할당되지 않음',

    'actionlog__ssl_panel_binding' => 'Plesk의 SSL/TLS 인증서',
    'actionlog__ssl_panel_binding_update' => '할당됨/할당되지 않음',
    'actionlog__event_ssl_panel_binding_update' => 'Plesk의 SSL/TLS 인증서가 할당됨/할당되지 않음',

    'actionlog__hostname' => '서버 호스트 이름',
    'actionlog__hostname_changed' => '변경됨',

    'actionlog__smb_user' => '추가 사용자',
    'actionlog__smb_user_create' => '추가 사용자 생성됨',
    'actionlog__smb_user_delete' => '추가 사용자 삭제됨',
    'actionlog__smb_user_update' => '추가 사용자 업데이트됨',

    'actionlog__event_mail_management_status_update' => '메일 관리 상태 업데이트',
    'actionlog__mail_management' => '메일 관리 상태',
    'actionlog__mail_management_status_update' => '업데이트됨',

    'virtualization_openvz' => 'OpenVZ',

    '__domains_total' => '총 도메인 수',

    'chk_js__warning_about_admin_passwd_syntax' => "암호에 인용 부호, 공백, 세미콜론 및 자국 문자를 사용하지 마십시오.\n암호는 길이가 %1~%2자여야 하며 사용자 이름을 포함할 수 없습니다.",

    'passwordSecurityLevelCheckFailed' => '암호가 충분히 복잡하지 않습니다. 서버 정책에 따른 최소 암호 길이는 %1입니다. 숫자, 대문자 및 소문자, 특수 문자( !,@,#,$,%,^,&,*,?,_,~)를 사용하여 암호 수준을 강화하십시오.',
    'passwordSecurityLevelCheckFailedVeryWeak' => '매우 약함',
    'passwordSecurityLevelCheckFailedWeak' => '약함',
    'passwordSecurityLevelCheckFailedMediocre' => '중간',
    'passwordSecurityLevelCheckFailedStrong' => '강함',
    'passwordSecurityLevelCheckFailedStronger' => '매우 강함',

    'filemanager__invalid_path' => "잘못된 경로가 지정됨",

    'ui__client/domain/dns/sync__description' => '서버 전체 DNS 템플릿의 변경 사항을 영역에 적용합니다.',
    'ui__client/domain/dns/sync__disabled-warning' => '다른 DNS 서버가 영역을 사용하기 때문에 DNS 템플릿의 변경 사항을 적용할 수 없습니다.',
    'ui__client/domain/dns/sync__short-title' => 'DNS 템플릿의 변경 사항을 적용합니다.',
    'ui__client/domain/dns/sync__done' => 'DNS 템플릿의 변경 사항이 영역에 성공적으로 적용되었습니다.',
    'ui__client/domain/domain-alias/dns/sync__description' => '서버 전체 DNS 템플릿의 변경 사항을 영역에 적용합니다.',
    'ui__client/domain/domain-alias/dns/sync__disabled-warning' => '다른 DNS 서버가 영역을 사용하기 때문에 DNS 템플릿의 변경 사항을 적용할 수 없습니다.',
    'ui__client/domain/domain-alias/dns/sync__short-title' => 'DNS 템플릿의 변경 사항을 적용합니다.',
    'ui__client/domain/domain-alias/dns/sync__done' => 'DNS 템플릿의 변경 사항이 영역에 성공적으로 적용되었습니다.',
    'dns__dns_default_ipv4_modified' => '이 IP 주소의 레코드는 사용자가 수정한 것으로 간주되며 서버 전체 DNS 템플릿과 동기화되지 않습니다.',
    'dns__dns_default_ipv6_modified' => '이 IP 주소의 레코드는 사용자가 수정한 것으로 간주되며 서버 전체 DNS 템플릿과 동기화되지 않습니다.',

    'dns__view_dns_record_master_title' => '리소스 레코드 보기',
    'dns__view_dns_record_off_title' => '이름 서버 레코드 보기',
    'dns__view_dns_record_slave_title' => '기본 DNS 서버 레코드 보기',

    'dns_unable_to_resolve_hostname' => "호스트 이름 \\\"%1\\\"을(를) 확인할 수 없음: %2운영 체제의 DNS 확인자가 올바르게 설치되어 있고 작동되고 있는지 확인하십시오.",

    'no_database_server_available' => '이 구독에 사용 가능한 데이터베이스 서버가 없습니다.',

    'database_used_by_application_can_not_be_moved' => '데이터베이스를 이동시킬 수 없습니다: 웹 사이트 응용 프로그램이 이 데이터베이스를 사용합니다.',
    'database_user_update_orphaned_is_restricted' => '분리된 데이터베이스 사용자 계정 업데이트는 금지됩니다. 삭제 또는 복원만 가능합니다.',

    'database_unable_to_get_max_filesize_default_message' => '데이터베이스의 최대 파일 크기를 확인할 수 없음: \'%1\'',
    'database_unable_to_set_max_filesize_default_message' => '데이터베이스의 최대 파일 크기를 설정할 수 없음: \'%1\'',
    'database_unable_to_get_max_log_filesize_default_message' => '데이터베이스의 최대 로그 파일 크기를 확인할 수 없음: \'%1\'',
    'database_unable_to_set_max_log_filesize_default_message' => '데이터베이스의 최대 로그 파일 크기를 설정할 수 없음: \'%1\'',

    'database_unable_to_get_max_filesize' => 'Microsoft SQL 데이터베이스 파일 크기(\'%1\')에 대한 현재 제한을 확인할 수 없습니다. 새 제한을 설정할 수 없습니다.',
    'database_unable_to_set_max_filesize' => 'Microsoft SQL 데이터베이스 파일 크기(\'%1\')에 대한 제한을 설정할 수 없음:',
    'database_unable_to_get_max_log_filesize' => 'Microsoft SQL 데이터베이스 로그 파일 크기(\'%1\')에 대한 현재 제한을 확인할 수 없습니다. 새 제한을 설정할 수 없습니다.',
    'database_unable_to_set_max_log_filesize' => 'Microsoft SQL 데이터베이스 파일 크기(\'%1\')에 대한 제한을 설정할 수 없음:',

    'database_unable_to_create_because_max_filesize' => 'Microsoft SQL 데이터베이스 \'%1\'을(를) 생성할 수 없음: 파일 크기가 최대 허용 크기보다 큽니다.',
    'database_unable_to_move_because_max_filesize' => 'Microsoft SQL 데이터베이스 \'%1\'을(를) 이동할 수 없음: 파일 크기가 최대 허용 크기보다 큼: %2.',
    'database_unable_to_create_because_max_log_filesize' => 'Microsoft SQL 데이터베이스 \'%1\'을(를) 생성할 수 없음: 로그 파일 크기가 최대 허용 크기보다 큽니다.',
    'database_unable_to_move_because_max_log_filesize' => 'Microsoft SQL 데이터베이스 \'%1\'을(를) 이동할 수 없음: 로그 파일 크기가 최대 허용 크기보다 큼: %2.',
    'database_unable_to_restore_because_max_filesize' => 'Microsoft SQL 데이터베이스 \'%1\'을(를) 복원할 수 없음: 파일 크기가 최대 허용 크기보다 큽니다.',

    'sandbox_mssql_server_registered_as_usual_db_server' => '동일한 MS SQL 서버가 Plesk에 이미 등록되어 있습니다. 다른 MS SQL 서버를 샌드박스로 지정하십시오.',
    'database_server__mssql_server_registered_as_sandbox' => '동일한 샌드박스 MS SQL 서버가 Plesk에 이미 등록되어 있습니다. 다른 MS SQL 서버를 샌드박스로 지정하십시오.',

    'database_server_mysql_unable_to_connect_via_cli' => '\'%1\'을/를 통해서 서버에 연결할 수 없습니다: %2',

    'bu_conflict_resolver_feature_not_available' => '기능 %1은(는) 다음 서비스 노드에서 지원하지 않습니다: %2. 이러한 노드에서 생성된 모든 개체에 대해 이 기능이 비활성화됩니다.',
    'bu_conflict_resolver_feature_not_available_single_server' => '기능 %1은(는) 이 서버에서 지원하지 않습니다: 복원된 모든 개체에 대해 이 기능이 비활성화됩니다.',
    'bu_conflict_resolver_component_unavailable_in_sites' => '%1 구성 요소가 설치되지 않았습니다. 다음 개체에 대해 복원이 해제됩니다. {{objects}}',
    'bu_conflict_resolver_component_replaced_in_sites' => '%1 구성 요소가 설치되지 않았습니다. 다음 웹 사이트에서 %2(으)로 대체됩니다: {{objects}}',

    'bu_conflict_resolver_restoration_of_object_end_to_dot_not_supported' => '현재 Plesk 버전은 점(.) 문자가 있는 사용자 이름을 지원하지 않습니다. 그러한 사용자 이름을 갖는 고객과 리셀러는 복원되지 않습니다.',
    'bu_conflict_resolver_unable_to_find_backup_part' => '%1 %2에 대한 데이터가 포함된 백업 파일을 찾을 수 없습니다. %1 %2에 대한 데이터가 복원되지 않습니다.',

    'bu_conflict_resolver_zone_master_removed' => "기본 DNS 레코드를 복원할 수 없음: 보조 영역의 레코드가 기존 IP 주소 %1을(를) 가리킵니다. 보조 영역에서 기본 DNS 레코드가 제거됩니다.",

    'bu_conflict_resolver_not_available_scripting' => '%1은(는) 지원되지 않습니다.',
    'bu_conflict_resolver_not_available_scripting_in_sites' => '%1은(는) 지원되지 않습니다. 다음 개체에 대해 복원이 해제됩니다. {{objects}}',
    'bu_conflict_resolver_not_available_component' => '%1 구성 요소가 설치되지 않았습니다.',
    'bu_conflict_resolver_disabled_in_multi_server' => '다음 서비스 노드에 대해 복원이 해제됩니다. {{objects}}',
    'bu_conflict_resolver_disabled_in_single_server' => '다음 개체에 대해 복원이 해제됩니다. {{objects}}',
    'bu_conflict_resolver_not_available_db' => '이 서버에서 다음 데이터베이스 서버를 사용할 수 없습니다. %1.',

    'bu_conflict_resolver_mssql_native_dump_restore_not_available' => 'MS SQL 데이터베이스 백업 파일은 완전히 구성된 백업 설정을 가진 로컬 MS SQL 서버 또는 원격 MS SQL 서버로만 복원할 수 있는 MS SQL 기본 형식으로 저장됩니다. 적절한 MS SQL 서버가 Plesk에 등록되어 있지 않아 일부 데이터베이스가 복원되지 않았습니다. 영향을 받은 도메인: {{objects}}. 호스팅 제공업체에 문의하십시오.',

    'bu_conflict_resolver_not_available_webmail' => '웹메일 서비스 %1을(를) 사용할 수 없습니다. 이 서비스는 다음 개체에 대해 %2(으)로 대체됩니다: {{objects}}',
    'bu_conflict_resolver_not_available_webmail_plan' => '웹메일 서비스 %1을(를) 사용할 수 없습니다. 이 서비스는 다음 서비스 플랜에 대해 %2(으)로 대체됩니다: {{objects}}',
    'bu_conflict_resolver_not_available_rename_db_user' => "유형이 '%1'인 데이터베이스는 데이터베이스 이름과 일치하는 사용자 이름을 지원하지 않습니다. 데이터베이스 '%4'에 대해 사용자 '%2'의 이름이 '%3'(으)로 바뀝니다.",

    'bu_conflict_resolver_wrong_hard_quota_value' => '대상 서버 구성에서 디스크 공간 사용량 제한이 설정되지 않았습니다. 이 설정의 값이 "무제한"으로 변경됩니다.',
    'bu_conflict_resolver_wrong_max_connections_value' => '대상 서버 구성에서 연결 수 제한이 설정되지 않았습니다. 이 설정의 값이 "무제한"으로 변경됩니다.',
    'bu_conflict_resolver_wrong_traffic_bandwidth_value' => '대상 서버 구성에서 트래픽 사용량 제한이 설정되지 않았습니다. 이 설정의 값이 "무제한"으로 변경됩니다.',
    'cu__pleskrestore_backup_file_extracted' => '백업 파일이 "%1"(으)로 추출되었습니다.',
    '__mod_bw_not_supported' => '파일 시스템 구성으로 인해 Apache 웹 서버에 대한 모듈 mod_bw가 지원되지 않습니다. 트래픽 사용량 및 최대 연결 수 제한이 동작하지 않습니다.',
    'bu_conflict_resolver_pop3_only_relay_auth_not_supported' => '메일 릴레이에 대한 POP3 인증이 지원되지 않습니다. SMTP 인증 전의 POP3이 대신 사용됩니다. ({{개체}})',
    'bu_conflict_resolver_service_plan_name' => '서비스 플랜 \'%1\'',
    'bu_conflict_resolver_replaced_in_plans' => '%1은(는) 지원되지 않습니다. 이 서비스는 다음 서비스 플랜에 대해 %2(으)로 대체됩니다: {{개체}}',
    'bu_conflict_resolver_replaced_in_sites' => '%1은(는)  지원되지 않습니다. 다음 웹 사이트에서 %2(으)로 대체됩니다: {{개체}}',
    'bu_conflict_resolver_absent_objects_in_dump' => '백업 파일에서 다음 개체를 찾지 못했습니다. %1',
    'bu_conflict_resolver_absent_domains' => '일부 개체는 Plesk에서 찾지 못하는 다음 도메인에 속하기 때문에 복원할 수 없습니다. %1',
    'bu_conflict_resolver_absent_parent_domains' => "일부 웹 사이트는 Plesk에서 찾지 못한 다음 상위 도메인에 속하기 때문에 복원할 수 없습니다. \n%1",
    'bu_conflict_resolver_dns_not_supported' => 'DNS 영역을 복원할 수 없음: 서버 구성에서 DNS 서비스 사용이 해제되어 있습니다.',
    'bu_conflict_resolver_mail_not_supported' => '사서함을 복원할 수 없음: 서버 구성에서 메일 서비스 사용이 해제되어 있습니다.',
    'bu_conflict_resolver__idle_timeout_action_not_supported' => 'IIS 웹 서버에서 지정된 유휴 시간 초과를 지원하지 않습니다. 값이 %1(으)로 재설정됩니다.',
    'bu_conflict_resolver__cpu_limit_action_not_supported' => 'IIS 웹 서버에서 지정된 CPU 제한 작업을 지원하지 않습니다. 값이 %1(으)로 재설정됩니다.',
    'bu_conflict_detector_server_ssl_cert_name' => '서버 SSL/TLS 인증서 %1',
    'bu_conflict_detector_domain_ssl_cert_name' => '도메인 %1의 SSL/TLS 인증서 %2',
    'bu_conflict_detector_ssl_cert_name' => 'SSL/TLS 인증서 %1',
    'bu_conflict_resolver_absent_objects' => 'Plesk에서 개체를 찾지 못하였기 때문에 다음 개체의 내용을 복원할 수 없습니다: %1',
    'bu_conflict_resolver_absent_objects_mailuser' => 'Plesk에서 사서함을 찾지 못하였기 때문에 다음 사서함의 내용을 복원할 수 없습니다. %1',
    'bu_conflict_resolver_absent_objects_maillist' => 'Plesk에서 메일링 리스트를 찾지 못하였기 때문에 다음 메일링 리스트의 내용을 복원할 수 없습니다. %1',
    'bu_conflict_resolver_absent_objects_database' => 'Plesk에서 데이터베이스를 찾지 못하였기 때문에 다음 데이터베이스의 내용을 복원할 수 없습니다: %1',
    'bu_conflict_resolver__remove_conflicted_aps_app' => '다른 응용 프로그램이 "%3"에 이미 설치되어 있기 때문에 "%2"의 "%1" 응용 프로그램을 복원하지 못했습니다. 설치된 응용 프로그램을 제거한 후 다시 시도할 수 있습니다.',
    'bu_conflict_resolver_not_available_mail_autoresponders' => '메일 자동 회신 기능은 지원되지 않습니다.',
    'bu_conflict_resolver_not_available_mail_content' => '메일 콘텐츠 복원은 지원되지 않습니다.',
    'bu_conflict_resolver_invalid_mail_name' => '이메일 하위 주소 지정이 활성화되어 있고 특정 이메일 주소에 "%1": %2 기호가 포함되어 있어 다음 사서함이 복원되지 않았습니다.',
    'bu_conflict_resolver_invalid_user_name' => '이메일 하위 주소 지정이 활성화되어 있고 특정 이메일 주소에 "%1": %2 기호가 포함되어 있어 다음 사용자가 복원되지 않았습니다.',
    'bu_conflict_resolver_licenses_expired' => '다음 라이센스가 만료되었으며 복원되지 않습니다. {{objects}}',
    'bu_conflict_resolver_licenses_invalid' => '다음 라이센스가 유효하지 않거나 만료되었으며 복원되지 않습니다. {{objects}}',
    'expiration_unsupported' => "제한 '만료'는 지원되지 않습니다.",

    'component_name__dbconnector' => "데이터베이스 커넥터",
    'component_name__mysqlserver' => 'MySQL 서버',
    'component_name__troubleshooting' => '문제 해결',
    'component_name__savi' => 'Sophos Anti-Virus Interface',

    '__subscription_has_no_license_key' => '관련 라이센스 키가 없는 서비스 노드 #%1에서 구독 리소스가 제공되었습니다.',
    '__subscription_has_expired_license_key' => '라이센스 키 %2가 만료된 서비스 노드 #%1에서 구독 리소스가 제공되었습니다.',

    '__cfgmonConfigurationFileSaveErrorSubject' => '<%%host%%> 구성 파일을 저장할 수 없음',
    '__cfgmonConfigurationFileSaveErrorBody' => "호스트 <%%host%%>에서 일부 구성 파일을 저장할 수 없음: 다음 오류 발생:\n%%errors%%",

    'mail__enable_email_subaddressing_cli_desc' => '이 옵션을 사용하면 메일 목록에 대해 VERP 스타일 이메일 주소를 구성할 수 있습니다.',
    'mail__enter_right_ip_mask' => "1 ~ 32 범위로 IP 마스크 입력",
    'mail__enter_right_ip_mask_24' => "24 ~ 32 범위로 IP 마스크 입력",
    'mail__invalid_dom_name' => "도메인 이름 %1이(가) 유효하지 않습니다.",
    'mail__invalid_pop_lock_time' => "POP3 잠금 시간이 유효하지 않습니다.",
    'mail__invalid_rbl_server' => "DNS 영역 이름이 유효하지 않습니다.",
    'mail__total_files_size' => "총 리포지토리 크기: %1",
    'mail__filename_already_in_repository' => "이름이 같은 파일이 리포지토리에 이미 있습니다.",
    'mail__no_white_list_mask_feature_24' => "24 이상의 마스크 값을 사용합니다.\n메일 서버에서 설정 마스크를 지원하지 않습니다. 24보다 적은 값만 설정 마스크를 에뮬레이션할 수 있습니다.",
    'mail__unable_add_new_mail_name' => "메일 계정을 추가할 수 없습니다. %1",
    'mail_server_is_not_installed' => '메일 서버(Postfix 또는 Qmail)가 설치되지 않았습니다. 계속 작업하려면 설치하십시오.',
    'mail_server_not_available' => '서비스 노드에서 사용 가능한 지원 메일 서버가 없습니다.',
    '__not_installed' => '(설치되지 않음)',
    'mail__service_node_outgoing_messages_is_disabled' => '나가는 이메일 메시지에 대한 스팸 필터링이 비활성화되어 있습니다.',
    'mail__service_node_does_not_support_outgoing_messages_domain_limit' => '서비스 노드가 도메인 %1에 대해 도메인으로부터 나가는 이메일 메시지의 수 제한을 지원하지 않습니다.',
    'mail__service_node_does_not_support_outgoing_messages_mbox_limit' => '서비스 노드가 도메인 %1에 대해 사서함으로부터 나가는 이메일 메시지의 수 제한을 지원하지 않습니다.',

    'mail__outgoing_email_mode_explicit_ip_unspecified' => '한 가지 이상 유형의 주소를 지정합니다(IPv4 또는 IPv6).',

    'mail__outgoing_email_mode_invalid' => '잘못된 나가는 메일 모드가 지정되었습니다.',
    'mail__outgoing_email_mode_explicit_ip_v4_invalid' => '잘못된 IPv4 주소가 지정되었습니다.',
    'mail__outgoing_email_mode_explicit_ip_v6_invalid' => '잘못된 IPv6 주소가 지정되었습니다.',
    'mail__outgoing_email_mode_unavailable' => '발신 메일 모드의 변경은 지원되지 않습니다. 이 서버에 Postfix 메일 서버가 설치되지 않았기 때문입니다.',

    'mail__autoresponder_attachment_not_supported' => '현재 사용되는 메일 서버가 자동 응답자 첨부 파일 관리를 지원하지 않습니다.',

    'mail__smtp_white_list_not_supported' => '현재 사용되는 메일 서버는 IP 주소 허용 목록을 지원하지 않습니다.',
    'mail__smtp_whitelist_cidr_not_supported' => 'CIDR 마스크는 현재 선택한 메일 서버에서 지원되지 않습니다. \'192.*.0.*\' 형식으로 IP 주소를 지정합니다.',
    'mail__smtp_whitelist_mask_not_supported' => '와일드카드 IP 패턴은 현재 선택한 메일 서버에서 지원되지 않습니다. \'192.0.0.0/8\' 형식으로 IP 주소를 지정합니다.',

    'sfdk_server_wide_verify_failed' => 'DKIM 확인 서비스 설정을 변경할 수 없습니다.',

    'sfdk_domain__serverwide_disabled' => '서버 정책에 따라 해제 중',
    'feature__domainkeys__serverwide_disabled' => '서버 전체의 DKIM 스팸 차단이 해제되었습니다.',

    'defaultcomponents__error_set_default' => '%1을(를) 기본값 %2(으)로 설정할 수 없음: %3',
    'defaultcomponents__error_set_default_none' => '%1의 기본 구성 요소를 지정할 수 없음: %2',
    'defaultcomponents__required_package_not_default' => '해당 작업에 필요한 구성 요소 %1이(가) 기본값이 아닙니다.',

    '__percentage' => '%',
    '__seconds' => '초',
    '__resource_remain' => '잔여',

    '__not_registered' => '(등록되지 않음)',
    '__php_handler_id' => 'PHP 버전',
    '__php_handler_id_string' => 'PHP %1 (%2)',
    '__php_handler_not_registered' => 'PHP 처리기 "%1"이(가) 등록되지 않았습니다. 서버에서 삭제된 것 같습니다. 동일한 속성으로 처리기를 등록하고 다시 시도하십시오.',
    '__php_handler_not_registered_on_domain' => '도메인 "%1": PHP 처리기 "%2"이(가) 등록되지 않았습니다. 서버에서 삭제된 것 같습니다. 동일한 속성으로 처리기를 등록하고 다시 시도하십시오.',
    '__php_fpm_handler' => 'FPM 응용 프로그램',
    '__php_fpm-dedicated_handler' => '전용 FPM 응용 프로그램',

    'mailname_create_assigned_user_dublicate_error' => '사서함에 대한 사용자를 생성할 수 없습니다. %1 사용자 이름의 사용자가 이미 있으며 다른 사서함을 가지고 있습니다.',
    'mailname_create_assigned_user_role_absent_error' => '사서함에 대한 사용자를 생성할 수 없습니다. 사용자의 기본 역할 %1이(가) 없습니다.',

    'gphd__mime_types' => 'MIME 유형',
    'gphd__handlers' => 'Apache 처리기',
    'gphd__ip_restrictions_allow' => '지정된 호스트 및 네트워크에 대해 사이트 액세스 허용(거부된 호스트와 네트워크는 제외)',
    'gphd__ip_restrictions_deny' => '지정된 호스트 및 네트워크에 대해 사이트 액세스 거부',
    'gphd__directory_index' => '인덱스 파일',
    'gphd__nginx_transparent_mode' => 'nginx가 수정 없이 HTTP 요청과 응답을 전달만 하고 Apache가 정적 및 동적 컨텐츠를 처리할 때의 모드.',
    'gphd__nginx_serve_static' => 'nginx가 직접 정적 파일 제공',
    'gphd__nginx_static_extensions' => 'nginx로 처리되어야 하는 정적 파일 확장자',
    'gphd__nginx_serve_php' => 'nginx로 PHP 파일 처리',
    'gphd__www_root' => 'WWW 루트 디렉터리',

    'eol__none' => '수정 안 함',
    'eol__lf' => 'Unix 스타일로 변환',
    'eol__cr' => 'MacOS 스타일로 변환',
    'eol__crlf' => 'Windows 스타일로 변환',

    'ui__dns_bad_zone' => '일관되지 않은 영역 "%1":',
    'ui__dns_ns_has_no_address_records' => 'NS 레코드 "%1"에 주소 레코드가 없습니다(A 또는 AAAA).',
    '__dns_bad_zone' => '일관되지 않은 영역 "%1":',
    '__dns_ns_has_no_address_records' => 'NS 레코드 "%1"에 주소 레코드가 없습니다(A 또는 AAAA).',
    '__dns_ptr_is_wildcard' => 'PTR 레코드 "%1"이(가) 잘못됨: 레코드가 와일드카드 도메인을 가리킵니다.',

    'firewall_database_user_remote_access_rule_name' => '[%1][%2] 고객 \'%4\'의 데이터베이스 사용자 \'%3\'에 대한 원격 액세스를 허용합니다.',
    'firewall_database_user_remote_access_rule_name_removed' => '[%1][%2] %3',
    'firewall_database_user_remote_access_mssql_server_port_undefined' => '데이터베이스 사용자 \'%1\'에 대해 원격 연결을 허용할 수 없음: Microsoft SQL 서버 \'%2\'에서 사용하는 TCP 포트 번호를 확인할 수 없음: 가능한 이유: 서버 네트워크 구성에서 TCP/IP 프로토콜이 활성화되지 않았거나 서버가 동적 TCP 포트를 사용하도록 구성되었습니다. 특정한 고정 TCP 포트에 수신 대기하도록 서버를 구성하고 원격 연결을 다시 허용해보십시오.',

    'command__convertResellerHasCustomer' => '리셀러 계정 \'%1\'에 고객 계정이 하나 또는 여러 개 있습니다. 이 리셀러 계정을 고객 계정으로 변환하려면 먼저 이러한 고객 계정을 새 소유자에게 이전하거나 리셀러 계정으로 변환합니다.',
    'command__convertResellerNotReseller' => '리셀러 계정만 고객 계정으로 변환할 수 있습니다. \'%1\'은(는) 리셀러가 아닙니다.',
    'command__convertResellerToCustomerSubscriptionNotSynchronized' => '구독을 서비스 플랜과 동기화할 수 없습니다. 다음 구독 설정이 서비스 플랜과 충돌합니다. %%problems%%.',

    'moveCustomer__wrong_customer_type' => '\'%1\' 계정은 리셀러 계정입니다. 리셀러 계정은 서버 관리자가 소유하기 때문에 새 소유자로 이동시킬 수 없습니다.',
    'moveCustomer__wrong_owner_type' => "고객 계정 '%1'은(는) 다른 고객이 아닌 리셀러나 관리자로만 이동시킬 수 있습니다.",
    'moveCustomer__customer_already_belongs_to_owner' => '고객 계정 \'%1\'은(는) 이미 선택된 소유자에게 속합니다.',
    'upgradeClient__user_is_admin' => '\'%1\' 계정은 관리자 계정이기 때문에 리셀러 계정으로 변환할 수 없습니다.',

    'mail__error_setting_max_connections_courier' => '최대 연결 수를 설정할 수 없음(IMAP, POP3, IMAP over SSL/TLS 또는 POP3 over SSL/TLS): %1',
    'mail__error_setting_max_connections_dovecot' => '최대 연결 수를 설정할 수 없음(IMAP, POP3, IMAP over SSL/TLS 또는 POP3 over SSL/TLS): %1',
    'mail__error_setting_max_connections_per_ip_courier' => 'IP 주소당 최대 연결 수를 설정할 수 없음(IMAP, POP3, IMAP over SSL/TLS 또는 POP3 over SSL/TLS): %1',
    'mail__error_setting_max_connections_per_ip_dovecot' => '특정 메일 사용자에 대한 IP 주소당 최대 연결 수를 설정할 수 없음(IMAP, POP3, IMAP over SSL/TLS 또는 POP3 over SSL/TLS): %1',
    'outgoing_messages_limit_value_invalid' => '값의 범위는 %%MIN%%..%%MAX%%여야 합니다. Plesk 관리자만 이 설정을 조정할 수 있습니다.',
    'outgoing_messages_server_settings_catch_address_are_not_local' => "다음 도메인은 존재하지 않는 메일에 보내는 메일 전달을 위해 외부 이메일 주소를 사용합니다. 이러한 주소로 보내는 메시지는 발신 메일 제어에서 계산되지 않습니다.\n %1",
    'outgoing_messages_white_list_not_empty' => 'IP 주소가 메일 서버의 수신 허용 목록에 있는 메일 발신자에게는 발신 메일에 대한 제한이 적용되지 않습니다. 예를 들어 수신 허용 목록에 로컬 호스트(127.0.0.0 / 8, ::1 / 128)가 있는 경우에는 제한에 관계 없이 로컬 서버의 모든 메일을 보낼 수 있습니다. 메일 발신자는 로컬 IP 주소(로컬 서버에 호스팅된 웹 사이트와 사용자 지정 스크립트) 또는 외부 주소(자신의 컴퓨터 또는 모바일 장치에 설치된 메일 클라이언트에서 메일을 보내는 고객)를 사용할 수 있습니다. 모든 메일 발신자(로컬 및 외부)에게 제한을 적용하려면 수신 허용 목록에서 모든 IP 주소와 네트워크를 제거하십시오. 수신 허용 목록에서 로컬 호스트(127.0.0.0 / 8, ::1 / 128)를 제거하면 해당 서버에서 메일을 보내는 웹 사이트와 스크립트의 작동이 중단될 수 있습니다. 발신 메일 제한에 대한 자세한 내용은 관리자 안내서의 "아웃바운드 스팸으로부터 보호"를 참조하십시오.',
    'outgoing_messages_relay_open' => '메일 릴레이가 열려 있습니다. 발신 메일 제한이 적용되지 않습니다.',

    'notification_aps_app_updates_available' => '다음 응용 프로그램에 대한 업데이트가 있음:',
    'notification_aps_app_updates_installed' => '다음 응용 프로그램에 대해 업데이트가 자동으로 설치되었습니다.',
    'notification_aps_app_updates_requirements' => '다음 응용 프로그램에 대해 업데이트를 사용할 수 있지만 해당 웹 사이트의 호스팅 설정이 설치 요구 사항을 충족하지 않기 때문에 설치할 수 없습니다.',
    'notification_admin_aps_app_updates_available_item' => '%%name%% (%%url%%). 설치된 버전: %%from%%. 사용 가능한 버전: %%to%%.',
    'notification_admin_aps_app_updates_available_plugin_item' => '%%parentName%%의 플러그인 "%%name%%"(%%url%%). 설치된 버전: %%from%%. 사용 가능한 버전: %%to%%.',
    'notification_admin_aps_app_updates_available_theme_item' => '%%parentName%%의 테마 "%%name%%"(%%url%%). 설치된 버전: %%from%%. 사용 가능한 버전: %%to%%.',
    'notification_reseller_aps_app_updates_available_item' => '%%name%% (%%url%%). 설치된 버전: %%from%%. 사용 가능한 버전: %%to%%.',
    'notification_reseller_aps_app_updates_available_plugin_item' => '%%parentName%%의 플러그인 "%%name%%"(%%url%%). 설치된 버전: %%from%%. 사용 가능한 버전: %%to%%.',
    'notification_reseller_aps_app_updates_available_theme_item' => '%%parentName%%의 테마 "%%name%%"(%%url%%). 설치된 버전: %%from%%. 사용 가능한 버전: %%to%%.',
    'notification_client_aps_app_updates_available_item' => '%%name%% (%%url%%). 사용 중인 버전: %%from%%. 사용 가능한 버전: %%to%%.',
    'notification_client_aps_app_updates_available_plugin_item' => '%%parentName%%의 플러그인 "%%name%%"(%%url%%). 사용 중인 버전: %%from%%. 사용 가능한 버전: %%to%%.',
    'notification_client_aps_app_updates_available_theme_item' => '%%parentName%%의 테마 "%%name%%"(%%url%%). 사용 중인 버전: %%from%%. 사용 가능한 버전: %%to%%.',
    'notification_admin_aps_app_updates_installed_item' => '%%name%% (%%url%%). 새 버전: %%to%%. 이전 버전: %%from%%.',
    'notification_reseller_aps_app_updates_installed_item' => '%%name%% (%%url%%). 새 버전: %%to%%. 이전 버전: %%from%%.',
    'notification_client_aps_app_updates_installed_item' => '%%name%% (%%url%%). 새 버전: %%to%%. 이전 버전: %%from%%.',
    'notification_admin_aps_app_updates_requirements_item' => '%%name%% (%%url%%). 설치된 버전: %%from%%. 사용 가능한 버전: %%to%%.',
    'notification_reseller_aps_app_updates_requirements_item' => '%%name%% (%%url%%). 설치된 버전: %%from%%. 사용 가능한 버전: %%to%%.',
    'notification_client_aps_app_updates_requirements_item' => '%%name%% (%%url%%). 사용 중인 버전: %%from%%. 사용 가능한 버전: %%to%%.',
    'notification_aps_app_updates_no_installation_url' => '외부 응용 프로그램',

    'notification_outgoing_mail_exceeded_limits_domains' => '도메인',
    'notification_outgoing_mail_exceeded_limits_mails' => '이메일 주소',
    'notification_outgoing_mail_exceeded_limits_subscriptions' => '구독',
    'notification_outgoing_mail_exceeded_limits_limit_value' => '%1 시간당 메시지 수',
    'notification_outgoing_mail_exceeded_limits_limit_value_unlimited' => '제한 없음',
    'notification_outgoing_mail_exceeded_limits_object' => '%1, 제한: %2',
    'notification_outgoing_mail_exceeded_limits_attempt' => '%1 시도가 %2부터 %3까지 기간에 제한 초과',
    'notification_outgoing_mail_exceeded_limits_attempt_still_exceeding' => '%1 시도가 %2부터 현재까지 기간에 제한 초과',

    'restart__docker' => "도커",
    'restart__fail2ban' => "IP 주소 금지(Fail2ban)",

    'backup__restore__capability_fail2ban_not_installed_text' => '대상 서버에서 Fail2ban 구성 요소가 설치되어 있지 않습니다.',
    'backup__restore__capability_fail2ban_not_installed_resolution' => 'Fail2ban을 설치합니다. 이 작업은 몇 분 정도 걸릴 수 있습니다.',

    'plesk_key__no_reseller_support' => '라이센스 제한으로 인해 리셀러를 관리할 수 없습니다.',
    'plesk_key__no_customers_support' => '라이센스 제한으로 인해 고객을 관리할 수 없습니다.',
    'panel_interface_uimodes__service_provider_view_not_allowed' => '라이센스 제한으로 인해 서비스 공급자 보기로 전환할 수 없습니다.',
    'plesk_key__no_security_core_support' => '라이센스 제한으로 인해 보안 코어 기능(ModSecurity 및 Fail2Ban)을 사용할 수 없습니다.',
    'plesk_key__outgoing-antispam' => '나가는 메일 제어',
    'plesk_key__security-core' => '보안 코어(ModSecurity 및 Fail2Ban)',
    'plesk_key__can-manage-accounts' => '계정 관리',
    'plesk_key__can-manage-subscriptions' => '구독 관리',
    'plesk_key__can-manage-customers' => '고객 관리',
    'plesk_key__can-manage-resellers' => '리셀러 관리',
    'plesk_key__can-manage-custom-view' => '제한 모드 사용 여부',
    'plesk_key__limits_exceeded_no_subscriptions_management' => '구독 관리가 해제되어 있지만 여러 구독이 있습니다(%1).',
    'plesk_key__limits_exceeded_no_resellers_management' => '리셀러 관리가 해제되어 있지만 여러 리셀러가 있습니다(%1).',
    'plesk_key__limits_exceeded_no_customers_management' => '고객 관리가 해제되어 있지만 여러 고객이 있습니다(%1).',
    'plesk_key__limits_unlimited_subscriptions' => '더는 Plesk 인터페이스에서 관리할 수 없는 특정 구독 리소스(사서함 및 도메인 디스크 공간 한도 등)가 이제 무제한으로 설정되었습니다.',
    'plesk_key__no_subscriptions_support' => '라이센스 제한으로 인해 구독을 관리할 수 없습니다.',
    'plesk_key__no_custom_view_support' => '라이선스 제한으로 인해 제한 모드를 사용할 수 없습니다.',
    'plesk_key__trial_forbidden_region' => '죄송합니다. 귀하의 지역에서는 현재 Plesk를 사용할 수 없습니다.',
    'additional_key__main_key' => '키가 메인 키입니다. 메인 키를 추가 키로 업로드할 수 없습니다.',

    'gch__hosting_waf_rule_engine' => '웹 응용 프로그램 방화벽 모드',

    'backup__fieldset__restoration_options' => '복원 옵션',
    'backup__restore_options__restore' => '복원',
    'backup__restore_options__domain__domain_configuration' => '도메인 구성',
    'backup__restore_options__domain__virtual_host_content' => '가상 호스트 내용',
    'backup__restore_options__domain__mail' => '메일',
    'backup__restore_options__domain__databases' => '데이터베이스',
    'backup__restore_options__client__client_configuration' => '고객 계정 구성',
    'backup__restore_options__client__domains' => "고객 도메인",
    'backup__restore_options__reseller__reseller_configuration' => '리셀러 계정 구성',
    'backup__restore_options__reseller__personal_domains' => "리셀러 도메인",
    'backup__restore_options__reseller__clients' => "리셀러의 고객",
    'backup__restore_options__admin__server_configuration' => '서버 설정',
    'backup__restore_options__admin__administrator_configuration' => '관리자 계정 구성',
    'backup__restore_options__admin__personal_domains' => "관리자의 도메인",
    'backup__restore_options__admin__personal_clients' => "관리자의 고객",
    'backup__restore_options__admin__resellers' => '리셀러',

    'badge_new' => '새로 생성',
    'upgrade_php_on_subscription' => '가입의 PHP를 버전 5.3.0 이상으로 업그레이드하십시오.',

    'pkey_notify__body_expiration_notification' => '라이센스 키가 만료되었습니다. 일부 기능이 지원되지 않습니다. 호스팅 제공자에게 문의하십시오.',

    'crontab__crontab_entry_exists' => "예약된 작업이 이미 있습니다.",
    'crontab__crontab_entry_not_exists' => "예약된 작업이 없습니다.",
    'crontab__invalid_values_found' => "잘못된 매개 변수 값.",
    'crontab__cmd_max_len' => "명령은 %1자를 초과할 수 없습니다.",

    'domain__domain_exists' => "접두사가 'www'이고 동일한 이름인 도메인이 존재함: %1.%2.",
    'domain__subdomain_exists' => "접두사가 'www'이고 동일한 이름인 하위 도메인이 존재함: %1.%2.",
    'domain__dalias_exists' => "접두사가 'www'이고 동일한 이름인 도메인 별칭이 존재함: %1.%2.",
    'domain__record_exists' => "호스트 %1.%2을(를) 가리키는 DNS 레코드가 있습니다.",

    'ip_addr__cannot_assign_certificate' => "인증서 '%1'를 기본 인증서로 설정할 수 없음: 개인 키가 누락되었습니다.",
    'ip_addr__update_dns_error' => 'DNS 구역에 IP 주소를 업데이트하는 중에 문제가 발생했습니다. %1',
    'ip_addr__cannot_add_dhcp_enabled' => 'IP 주소를 추가할 수 없습니다. 이 네트워크 인터페이스는 자동으로 IP 주소를 가져옵니다.',
    'ip_addr__cannot_remove_dhcp_enabled' => '%1 IP 주소를 제거할 수 없습니다. 이 네트워크 인터페이스는 자동으로 IP 주소를 가져옵니다.',
    'ip_addr__cannot_repair_dhcp_enabled' => '%1 IP 주소를 복구할 수 없습니다. 이 네트워크 인터페이스는 자동으로 IP 주소를 가져옵니다.',
    'ip_addr__cannot_change_interface_dhcp_enabled' => '%2 네트워크 인터페이스에서 자동으로 IP 주소를 가져오기 때문에 %1 IP 주소의 인터페이스를 변경할 수 없습니다.',

    'shm_lmsg__limit_for_resource_exceeded' => '%%type%% 번호에 대한 구독 제한이 초과되었습니다. 현재 제한은 %%limit%%이며 %%usage%%이(가) 사용되고 있습니다.',
    'shm_lmsg__resource_is_forbidden_for_creation' => '이 구독에서는 %%type%% 생성이 허용되지 않습니다.',
    'shm_lmsg__resource_title__db-mysql' => 'MySQL 데이터베이스',
    'shm_lmsg__resource_title__db-mssql' => 'MS SQL 데이터베이스',
    'shm_lmsg__resource_title__db-postgresql' => 'PostgreSQL 데이터베이스',
    'shm_lmsg__resource_title__db-user' => '데이터베이스 사용자',
    'shm_lmsg__resource_title__iis-application-pool' => 'IIS 응용 프로그램 풀',
    'shm_lmsg__resource_title__additional-ftp-account' => '추가 FTP 계정',

    'db_user_unable_remove_mysql_global_privileges' => '데이터베이스 사용자 %1의 MySQL 전역 권한을 제거할 수 없습니다. 이유: %2',
    'report__client_description' => '설명',

    'db__user_role_error' => '잘못된 데이터베이스 사용자 역할이 지정되었습니다: %1 %1. 다음 중 한 가지 선택: %2 %2.',

    'subscription_unable_to_set_max_filesize_warning' => '파일 크기가 커서 다음 Microsoft SQL Server 데이터베이스에 대한 파일 크기 한계를 설정할 수 없음: %1.',
    'subscription_unable_to_set_max_log_filesize_warning' => '로그 파일 크기가 커서 다음 Microsoft SQL Server 데이터베이스에 대한 로그 파일 크기 한계를 설정할 수 없음: %1.',
    'ipaddress__cannot_set_up_public_ip_need_ipaddress' => '공용 IP 주소를 설정할 수 없음: 개인 IP 주소가 존재해야 합니다.',
    'ipaddress__cannot_set_up_public_ip_need_ipv6' => 'IPv6 주소에 대한 공용 IPv4 주소를 설정할 수 없습니다.',
    'ipaddress__cannot_set_up_public_ip_need_ipv4' => 'IPv4 주소에 대한 공용 IPv6 주소를 설정할 수 없습니다.',
    'ipaddress__cannot_set_up_public_ip_invalid' => '공용 IP 주소를 설정할 수 없음: 잘못된 IP 주소',

    '__user_already_exists' => "%1 사용자가 이미 있습니다.",
    '__user_name_is_empty' => "사용자 이름을 지정하십시오.",

    'upgrade_php_on_domain' => 'WordPress 도메인에서 PHP 버전 5.3.0 이상을 찾을 수 없습니다. PHP를 업그레이드하십시오.',

    'component_name__waf' => '웹 응용 프로그램 방화벽',
    'component_name__vcs' => '버전 컨트롤 시스템',

    'virtualization_lxc' => 'LXC',
    'virtualization_docker' => '도커',
    'possibleSpoofingDetected' => '스푸핑 시도가 탐지되었습니다. 링크가 관련 없는 내용을 표시하려고 합니다.',
    'forceResetPasswordUpdated' => '암호가 변경되었습니다. 새 암호를 사용하여 Plesk에 로그인하십시오.',

    'php_handlers_error_no_available_instance' => '도메인을 생성할 수 없음: 사용 가능한 PHP 핸들러가 없습니다.',
    'domain_error_unable_to_apply_hosting_settings' => '호스팅 설정을 적용할 수 없음: %1',

    'plesk_not_configured' => 'Plesk가 구성되지 않았습니다. 설치 후 구성을 실행하려면 제어 패널로 이동하십시오.',
    'cmd_mail__mail_password_duplicated' => '지정된 이메일 주소와 암호 쌍이 이미 메일 서버에 존재합니다. 다른 이메일 주소 또는 암호를 지정하십시오.',

    'extensionRequirementOs' => '패키지가 운영 체제(%1)를 지원하지 않습니다.',
    'extensionRequirementPleskMinVersion' => '패키지가 지원하는 가장 빠른 버전은 Plesk %1입니다.',
    'extensionRequirementPleskMaxVersion' => '패키지가 Plesk %1(으)로 시작하는 버전을 지원하지 않습니다.',
    'extensionBlacklisted' => '확장 %1은(는) 설치에 허용되지 않습니다.',
    'extensionDisabled' => '확장이 비활성화되었습니다.',


    'optimization_settings__unable_set_mpm_event' => 'mpm_event 모드를 설정할 수 없음: Apache PHP5 모듈을 꺼야 하지만 이 모듈은 도메인에 의해 사용되고 있습니다.',
    'optimization_settings__unable_turn_off_php' => 'Apache PHP5 모듈을 끌 수 없음: 이 모듈은 도메인에 의해 사용되고 있습니다.',

    'hst_def__fp_admin_login' =>  'FTP 사용자 이름',
    'hst_def__fp_admin_passwd' =>  'FTP 암호',

    'database_user_orphaned_old_password_wrong' => "분리된 사용자 '%1'을(를) 복구할 수 없음: 암호가 잘못되었습니다.",
    'cannot_load_partner_central_property_key_no_exist' => "사용자 지정 속성을 검색할 수 없음: 라이센스 키가 존재하지 않습니다.",
    'extensionScriptFailure' => "다음 메시지와 함께 %1의 실행에 실패했습니다.\n%3",
    '__ssl_redirect' => "영구 SEO 안전 301이 HTTP에서 HTTPS로 리디렉션됨",
    'component_name__dotnetcore' => '.NET Core',
    'mail__dkim_not_supported' => 'DKIM 관리가 지원되지 않습니다.',
    'mail__dmarc_not_supported' => 'DMARC 관리는 지원되지 않습니다.',
    'mail__relay_white_list_not_supported' => '릴레이 화이트리스트 관리가 지원되지 않습니다.',
    'mail__black_list_not_supported' => '블랙리스트 관리가 지원되지 않습니다.',
    'mail__autoresponder_not_supported' => '자동 응답기 관리가 지원되지 않습니다.',
    'defaultcomponents__not_supported_version' => '(지원되지 않는 버전)',
    'component_name__nodejs' => 'Node.js',

    'certificate__not_found' => '인증서 \'%1\'을(를) 찾을 수 없습니다.',
    'certificate__unable_setup_certificate' => '인증서를 설치할 수 없음: 개인 키와 인증서 내용이 없습니다.',
    'certificate__used_by_panel' => '삭제하려는 인증서 중 하나가 Plesk 보안에 사용 중입니다.',
    'certificate__used_by_mail_server' => '삭제하려는 인증서 중 하나가 메일 서버 보안에 사용 중입니다.',
    'certificate__used_by_domain_service' => '삭제하려는 인증서 중 하나가 도메인 서비스에서 사용 중입니다.',
    'mail_server__not_installed' => '메일 서버가 설치되지 않아 메일 서버에 대한 인증서를 설치할 수 없습니다.',

    'email_activation_mail_subject' => 'Plesk에서 계정을 활성화하십시오.',
    'email_activation_mail_body' => "계정이 Plesk 서버에서 생성되었습니다. %1\n\n계정 세부 정보:\n이름: %2\n이메일 주소: %3\n\n이 정보가 정확하고 본인의 계정이 생성되었다면 다음 링크에서 계정을 활성화하십시오.\n\n%4\n\n계정을 활성화함으로써 귀하는 서버 보유업체에서 계약의 일환으로 현재 적용되는 데이터 보호법에 따라 계정을 생성하고 지원할 수 있도록 사용자의 개인 데이터(이름 및 이메일)를 수집하고, 저장하고, 처리하고, 이용하는 데 동의합니다.",

    'backup_transport_permission_name' => '%1 관리',
    'backup_transport_permission_description' => '백업 저장에 %1을(를) 사용하도록 허용합니다.',

    'domain_move_err_target_no_hosting' => '호스팅 없이 도메인을 구독으로 이동할 수 없습니다.',
    'domain_move_err_already_in_target' => '도메인이 대상 구독에 이미 속해 있습니다.',
    'domain_move_err_main_domain' => '도메인을 이동할 수 없습니다.',
    'domain_move_err_subdomain_without_parent' => '부모 도메인 %2 없이 하위 도메인 %1을(를) 이동할 수 없습니다.',
    'domain_move_err_root_exists' => 'www_root %1의 대상 경로가 이미 있습니다.',
    'domain_move_err_nested_roots' => '도메인이 %1 도메인과 문서 루트를 공유하고 있기 때문에 이동할 수 없습니다.',
    'domain_move_err_no_mail_service' => '메일 서비스가 대상 구독에서 비활성화되어 있기 때문에 도메인을 이동할 수 없습니다.',
    'domain_move_err_app' => "%1에 설치된 애플리케이션이 '%2': %3 구독으로 이동하지 않았습니다.",
    'domain_move_database_used_by_app' => "%2의 '%1' 데이터베이스가 이동한 애플리케이션에서 사용 중입니다. 데이터베이스를 '%3'에 다시 할당하려면 `plesk bin database --assign-to-subscription`을 실행합니다.",
    'domain_move_target_locked' => "'%1' 대상 구독이 동기화에 잠겨 있습니다.",
    'domain_move_filesharing_disabled' => '파일 공유가 비활성화되었습니다.',
    'domain_move_website_preview_disabled' => '웹 사이트 미리 보기가 비활성화되었습니다.',
    'domain_move_additional_webserver_settings' => "도메인의 추가 웹 서버 지침을 확인하여 구성이 손상되지 않도록 하십시오.",
    'domain_move_no_permission' => "'%2' 구독에는 %1이(가) 허용되지 않습니다.",
    'domain_move_no_access' => "'%1' 구독에 액세스할 수 없습니다.",
    'domain_split_no_create_permission' => "도메인을 생성할 수 없습니다.",
    'domain_split_empty_login' => '시스템 사용자 로그인이 필요합니다.',
    'domain_split_empty_password' => '시스템 사용자 암호가 필요합니다.',
    'domain_split_err_home_exists' => '대상 홈 경로가 %2에 이미 있기 때문에 %1 도메인을 이동할 수 없습니다. 도메인 이름을 변경하여 새 구독으로 이동하십시오.',
    'domain_split_err_no_hosting_subdomains' => '도메인에 호스팅이 없지만 하위 도메인은 있기 때문에 도메인을 새 구독으로 이동할 수 없습니다. 도메인을 이동하려면 "호스팅 유형" 값을 "웹 사이트 호스팅"으로 변경합니다(호스팅 설정에서).',
    'domain_split_target_locked' => "'%1' 대상 구독이 동기화에 잠겨 있습니다.",
    'domain_split_target_unsynced' => "'%1' 대상 구독이 다음으로 인해 플랜과 동기화되지 않았습니다. %2 도메인과 문서 루트를 공유하고 있기 때문에 이동할 수 없습니다.",
    'domain_merge_scheduled_backup_deactivated' => "예약 백업이 '%1'에서 비활성화되었습니다.",
    'domain_merge_database_error' => "%2의 '%1' 데이터베이스가 '%3' 구독으로 이동하지 않았습니다. %4 구독으로 이동하지 않았습니다.",
    'domain_merge_anon_ftp_deactivated' => "'%1'의 익명 FTP가 꺼졌습니다.",
    'domain_merge_smb_user_access' => "'%1' 추가 사용자가 '%2' 구독으로 이동했지만 사용자의 구독 액세스가 취소되었습니다.",
    'domain_merge_scheduled_tasks' => "예약 작업이 대상 구독으로 이동했습니다. 작업 구성을 검토하십시오.",
    'domain_merge_scheduled_tasks_deactivated' => "예약 작업이 대상 구독으로 이동했으며 비활성화되었습니다. 작업 구성을 검토하십시오.",
    'domain_merge_no_remove_permission' => "구독은 제거할 수 없습니다.",
    'domain_merge_err_has_addons' => '추가 도메인과 함께 메인 도메인을 이동할 수 없습니다. 먼저 %1 도메인을 이동하십시오.',
    'domain_merge_err_has_webusers' => '웹 사용자와 함께 메인 도메인을 이동할 수 없습니다.',
    'domain_merge_err_root_exists' => '%1 대상 경로가 이미 있습니다.',

    'database_server_edit_used_for_psa' => '로컬 MySQL 데이터베이스 서버 업데이트가 허용되지 않습니다.',
    'suggest_repair_main_suggestion_ui' => '<b>\'Plesk 복구\' 유틸리티로</b> 이 오류를 수정할 수 있습니다.',
    'suggest_repair_main_suggestion_cli' =>  '\'Plesk 복구\' 유틸리티로 이 오류를 수정할 수 있습니다.',
    'suggest_repair_repair_kit_link_title' => '진단 및 복구로 이동',
    'suggest_repair_using_cli_and_ui' => '복구하려면 CLI 또는 %2(을)를 통해 \'Plesk 복구 %1\' 명령을 실행하거나, "Plesk 데이터베이스" 옆의 복구를 클릭하십시오.',
    'suggest_repair_using_cli' => '복구하려면 CLI를 통해 \'Plesk 복구 %1\' 명령을 실행하십시오.',

    'backup__restore__capability_duplicate_php_handler_resolution' => '',
    'bu_conflict_resolver_dns_not_available' => '백업 생성 중에는 DNS 서비스를 사용할 수 없습니다. 그러나 백업에 활성 DNS 영역이 있으며 다음 개체가 활성화됩니다: {{objects}}',
    'plesk_key__system-resources-limits-enabled' => '리소스 컨트롤러(Cgroups)',
    'plesk_key__remote-smartermail-enabled' => 'SmarterMail 원격 지원',
    'plesk_key__complete-backup-solution' => 'Backup to Cloud Pro',
    'defaultcomponents__no_license' => '(라이선스 키에 허용되지 않음)',
    'plesk_key__validation_failed' => '%1 (오류 코드: %2)',
    'promo__button_details' => '세부 정보',
    'promo__extension_catalog_title' => '확장 프로그램 카탈로그',
    'promo__extension_catalog_description' => '새 확장 프로그램 카탈로그를 확인하고 강력한 확장 프로그램으로 Plesk의 성능을 높이십시오.',
    'promo__button_open_catalog' => '카탈로그 열기',

    'backup__repository_check_login' => "스토리지에 액세스할 수 없습니다: %1 올바른 스토리지 자격 증명을 입력했는지 확인하십시오.",
    'backup__repository_check_error_list' => "스토리지에 액세스할 수 없습니다: %1 올바른 스토리지 설정을 입력했는지 확인하십시오.",
    'backup__repository_check_error_mkdir' => "디렉터리를 생성할 수 없습니다: %1 스토리지에 폴더 생성 권한이 있는지 확인하십시오.",
    'backup__repository_check_error_upload' => "스토리지에 파일을 업로드할 수 없습니다: %1 스토리지에 파일을 업로드 할 수 있는 권한이 있는지 확인하십시오.",
    'backup__repository_check_error_download' => "스토리지에서 파일을 다운로드할 수 없습니다: %1 스토리지에서 파일을 업로드 및 다운로드할 수 있는 권한이 있는지 확인하십시오.",
    'backup__repository_check_error_resume-upload' => "스토리지로 파일 업로드를 재개할 수 없습니다: %1 스토리지로 업로드를 재개할 권한이 있는지 확인하십시오.",
    'backup__repository_check_error_resume-download' => "스토리지에서 파일 다운로드를 재개할 수 없습니다: %1 스토리지에서 다운로드를 재개할 권한이 있는지 확인하십시오.",
    'backup__repository_check_error_enable-utf8' => "스토리지를 작동할 수 없습니다: %1 스토리지가 UTF8 인코딩을 지원하는지 확인하십시오.",
    'backup__repository_check_error_rm' => "스토리지를 작동할 수 없습니다: %1 스토리지에서 파일을 삭제할 수 있는 권한이 있는지 확인하십시오.",
    'backup__repository_check_error_rmdir' => "스토리지를 작동할 수 없습니다: %1 스토리지에서 폴더를 삭제할 수 있는 권한이 있는지 확인하십시오.",

    'backup__ftp_repository_check_login' => "%1 다음 명령을 사용하여 개별적으로 확인할 수 있습니다: %2",
    'backup__ftp_repository_check_error_list' => "%1 다음 명령을 사용하여 개별적으로 확인할 수 있습니다: %2",
    'backup__ftp_repository_check_error_mkdir' => "%1 다음 명령을 사용하여 개별적으로 확인할 수 있습니다: %2",
    'backup__ftp_repository_check_error_upload' => "%1 다음 명령을 사용하여 개별적으로 확인할 수 있습니다: %2 %3",
    'backup__ftp_repository_check_error_download' => "%1 다음 명령을 사용하여 개별적으로 확인할 수 있습니다: %2 %3",
    'backup__ftp_repository_check_error_resume-upload' => "%1 다음 명령을 사용하여 개별적으로 확인할 수 있습니다: %2 %3 %4",
    'backup__ftp_repository_check_error_resume-download' => "%1 다음 명령을 사용하여 개별적으로 확인할 수 있습니다: %2 %3",
    'backup__ftp_repository_check_error_enable-utf8' => "%1 다음 명령을 사용하여 개별적으로 확인할 수 있습니다: %2",
    'backup__ftp_repository_check_error_rm' => "%1 다음 명령을 사용하여 개별적으로 확인할 수 있습니다: %2 %3",
    'backup__ftp_repository_check_error_rmdir' => "%1 다음 명령을 사용하여 개별적으로 확인할 수 있습니다: %2 %3",

    'sfdmarc_server_wide_enable_failed' => 'DMARC 설정을 변경할 수 없습니다. 이 옵션을 활성화하려면 DKIM 및 SPF 스팸 차단을 설정하십시오.',
    'spf_server_wide_disable_failed' => 'SPF 스팸 차단 설정을 변경할 수 없습니다. SPF을 비활성화하려면 수신 메일의 DMARC를 해제하십시오.',
    'sfdk_server_wide_verify_disable_failed' => 'DKIM 스팸 차단 설정을 변경할 수 없습니다. DKIM을 비활성화하려면 수신 메일의 DMARC를 해제하십시오.',

    'ccs_not_supported' => '시스템에서 IIS 중앙 인증서 저장소가 구성되지 않았습니다.',
    'ccs_not_enabled' => 'Plesk에서 IIS 중앙 인증서 저장소 관리가 비활성화되었습니다.',
    'ad_not_supported' => '서버가 도메인에 가입되어 있지 않습니다.',

    'component_name__appinit' => "응용 프로그램 초기화",
    'component_name__httpcompression' => 'HTTP 콘텐츠 압축',
    'common_feature_is_not_supported' => '이 기능은 더 이상 지원되지 않습니다.',
    'common_feature_is_not_supported_in_proto' => '이 기능은 프로토콜 버전에서 지원되지 않습니다 %1.',
    'autoinstaller__plesk_component' => 'Plesk 구성 요소',
    'plesk_key__key_expired' => '라이선스 키가 만료되었습니다. Plesk를 계속 사용하려면 만료되지 않는 상업용 라이선스 %1를 구입하십시오.',
    'plesk_key__key_purchase' => '라이선스 키',

    'sa_action_move' => '스팸을 "정크 이메일" 폴더로 이동',

    'bu_conflict_resolver_tomcat_not_supported' => 'Java 응용 프로그램은 더 이상 지원되지 않습니다. 다음 웹 사이트는 사용할 수 없습니다: {{objects}}',
    'bu_conflict_resolver_unity_mobile_not_supported' => 'UNITY Mobile로 호스팅 되는 웹 사이트의 모바일 버전은 더 이상 진행되지 않습니다. 다음 웹 사이트는 사용할 수 없습니다: {{objects}}',
    'bu_conflict_resolver_antivirus_personal_management_not_allowed' => '서버 전체 사용 정책은 개인용 안티 바이러스 설정을 허용하지 않습니다. 다음 도메인의 이메일 계정은 불완전하게 복원됩니다: {{objects}}',

    'module__not_installed' => "%1 확장 프로그램이 설치되지 않았습니다.",

    'mail__mail_autodiscovery_server_error' => '메일 자동 검색을 위한 사용자 지정 도메인 이름 지정',
    'mail__error_mail_autodiscovery_enable' => '메일 자동 검색을 설정할 수 없음: %1',
    'mail__error_mail_autodiscovery_server' => '메일 자동 검색을 위한 사용자 지정 도메인 이름을 설정할 수 없음: %1',
    'mail__error_mail_autodiscovery_reconfigure_dns' => '도메인 자동 검색 DNS 레코드를 구성할 수 없음: %1',

    '__invalid_url' => '"%1" URL이 유효하지 않음',
    'actionlog__cloning_start' => '시작',
    'actionlog__event_cloning_start' => '서버 복제 시작',

    '__UPLOAD_ERR_FORM_SIZE' => "업로드된 파일이 허용 크기를 초과함",
    '__UPLOAD_ERR_INI_SIZE' => "업로드된 파일이 허용 크기를 초과함",
    '__UPLOAD_ERR_NO_FILE' => "수신된 파일 없음",
    '__UPLOAD_ERR_OK' => "파일이 업로드됨",
    '__UPLOAD_ERR_PARTIAL' => "파일이 일부만 업로드됨. 다시 시도하십시오.",
    '__UPLOAD_ERR_NO_TMP_DIR' => '임시 폴더가 없음',
    '__UPLOAD_ERR_CANT_WRITE' => '파일을 디스크에 쓰지 못했습니다.',
    '__UPLOAD_ERR_UNKNOWN' => '알 수 없는 파일 업로드 오류가 발생했습니다.',
    '__accounts' => "계정",
    '__access' => "액세스",
    '__address' => "주소",
    '__addresses' => "주소",
    '__acl_records' => 'ACL 레코드',
    '__admin_repository' => "관리자 리포지토리",
    '__all' => '모두',
    '__allowed' => "허용됨",
    '__anonftp_status' => "익명 FTP",
    '__antispam' => "스팸 방지",
    '__apache_restart' => "...%1 웹 서버를 다시 시작하는 중입니다. 잠시 기다려 주십시오...",
    '__asp' => "Microsoft ASP",
    '__asp_dot_net' => "Microsoft ASP.NET",
    '__asp_dot_net_support' => "Microsoft ASP.NET 지원",
    '__asp_win_support' => "Microsoft ASP 지원",
    '__attachments' => "첨부 파일",
    '__attachments_list' => "첨부 파일",
    '__author' => '저자',
    '__autoresp_name_already_exists' => "이름이 %1인 자동 회신이 이미 있습니다.",
    '__autoresponder' => "자동 회신",
    '__autoresponders' => "자동 회신",
    '__autoresponders_list' => "자동 회신",
    '__autoresponder_attachment_files' => "자동 회신 첨부 파일",
    '__auto_updates_list' => '사용 가능한 업데이트',
    '__avail' => "사용 가능함",
    '__backup_utilites' => "백업 유틸리티",
    '__bind_status' => "DNS 서버 상태",
    '__bu_is_not_installed' => "백업 유틸리티가 설치되지 않았기 때문에 이 서비스는 현재 사용할 수 없습니다.",
    '__bu_not_support_in_key' => "라이센스 키가 백업 기능을 지원하지 않습니다.",
    '__notifications_not_support_in_key' => '라이센스 키가 알림을 지원하지 않습니다.',
    'disabled_by_key' => '라이센스 키에 의해 지원되지 않음',
    '__bytes' => "바이트",
    '__can_not_use_reserved_words' => "예약된 단어는 사용할 수 없습니다.",
    '__certificate' => "인증서",
    '__cgi_support' => "CGI 지원",
    '__change_date' => "수정 날짜",
    '__city' => "도시",
    '__cl_not_exist' => "고객 계정이 없습니다.",
    '__client' => '고객',
    '__client_card' => "고객 카드",
    '__client_contact_name' => "고객 담당자 이름",
    '__client_form' => "개인 정보",
    '__client_ip_pool' => "고객의 IP 풀",
    '__client_limits' => "고객 계정 제한",
    '__client_permissions' => "고객 권한",
    '__client_preferences' => "고객 기본 설정",
    '__client_status' => "고객 상태",
    '__client_name' => "고객 이름",
    '__client_total' => "고객 합계",
    '__client_with_login_name_already_exists' => "사용자 이름이 \"%1\"인 사용자가 이미 있습니다.",
    '__client_domuser_with_login_already_exists' => "사용자 이름 '%1'은 도메인 '%1'의 관리자가 이미 사용 중입니다.",
    '__clients_global_changes' => "선택한 고객 계정 수정",
    '__clients_list' => "고객",
    '__cmd_not_found' => "알 수 없는 명령: %1",
    '__comments' => "주석",
    '__company_name' => "회사 이름",
    '__component_version' => "구성 요소 버전",
    '__component_not_installed' => "%1 구성 요소가 설치되지 않았습니다.",
    '__confirm_del' => "삭제를 확인해야 합니다.",
    '__confirm_overwrite' => "덮어쓰기를 확인합니다.",
    '__confirm_stop' => "프로세스 중지를 확인해야 합니다.",
    '__confirm_passwd' => "%1 암호 확인",
    '__confirm_removal' => "제거 확인",
    '__conhelp' => "설명",
    '__contact_name' => "연락처 이름",
    '__country' => "국가",
    '__countries' => '국가',
    '__country_unknown' => '국가 하위 코드를 인식할 수 없음.',
    '__courier-imap' => 'Courier 서버',
    '__create_domain' => '도메인 생성',
    '__crypted' => '암호화됨',
    '__cp_access' => "Plesk에 액세스",
    '__cp_user' => "Plesk 사용자",
    '__create' => "생성",
    '__create_client_template_without_template' => "템플릿 없이 사용자 계정 만들기",
    '__create_domain_for' => "<b>%1</b>에 대한 도메인 만들기",
    '__create_domain_template_without_template' => "템플릿 없이 도메인 만들기",
    '__creation_date' => "만든 날짜",
    '__crontab_unix' => "스케줄러",
    '__crontab_win' => "스케줄러",
    '__ct_month_jan' => '1월',
    '__ct_month_feb' => '2월',
    '__ct_month_mar' => '3월',
    '__ct_month_apr' => '4월',
    '__ct_month_may' => '5월',
    '__ct_month_jun' => '6월',
    '__ct_month_jul' => '7월',
    '__ct_month_aug' => '8월',
    '__ct_month_sep' => '9월',
    '__ct_month_oct' => '10월',
    '__ct_month_nov' => '11월',
    '__ct_month_dec' => '12월',
    '__custom_button' => "사용자 지정 버튼",
    '__custom_buttons_list' => "추가 서비스 링크",
    '__daily' => "매일",
    '__database_not_activated' => "%1 은(는) 서버 관리 페이지에서 활성화되지 않았습니다.",
    '__database_not_installed' => "%1 데이터베이스가 설치되지 않았습니다.",
    '__database_not_run' => "%1 데이터베이스가 실행 중이 아닙니다.",
    '__database_is_corrupt' => "Plesk의 데이터베이스가 손상되었습니다. 재구성 유틸리티를 시작하여 수정하십시오.",
    '__databases' => "데이터베이스",
    '__databases_list' => "데이터베이스",
    '__database_type_not_supported_by_key' => '%1 서버를 사용하려면 이 라이센스 키의 지원이 필요합니다. Plesk 영업 담당자에게 문의하십시오.',
    '__date_immediately' => "오늘",
    '__date_never' => "없음",
    '__day(s)' => "일",
    '__day0' => "일",
    '__day1' => "월",
    '__day2' => "화",
    '__day3' => "수",
    '__day4' => "목",
    '__day5' => "금",
    '__day6' => "토",
    '__days' => "%1 일",
    '__db_admin_login_empty' => "빈 사용자 이름을 입력하여 인터페이스에서 %1에 대한 제어가 해제되었습니다. 계속 하시겠습니까?",
    '__db_unable_to_unregister' => '데이터베이스 연결 매개 변수를 제거할 수 없습니다.',
    '__db_db_exists' => '서버에 데이터베이스가 하나 이상 있습니다.',
    '__db_unable_to_change_server_name' => '서버 이름을 변경할 수 없습니다.',
    '__db_unable_to_change_port' => '서버 포트를 변경할 수 없습니다.',
    '__db_already_exist' => "%1 데이터베이스가 이미 있습니다.",
    '__db_credentials_invalid' => "데이터베이스 자격 증명이 잘못되었습니다.",
    '__db_invalid_password_characters' => '암호에 잘못된 문자가 포함되어 있습니다',
    '__db_engine' => "데이터베이스 엔진", // indirect
    '__db_type' => "데이터베이스 유형",
    '__db_user' => "데이터베이스 사용자",
    '__db_server' => '데이터베이스 서버',
    '__def_domain' => "기본 도메인",
    '__default_for_mysql' => 'MySQL에 대한 기본값',
    '__default_for_mariadb' => 'MariaDB의 기본값',
    '__default_for_percona' => 'Percona의 기본값',
    '__default_for_postgresql' => 'PostgreSQL에 대한 기본값',
    '__delete' => "삭제",
    '__demo' => "이 기능은 데모 버전에서 사용할 수 없습니다.",
    '__directory' => "디렉터리",
    '__disable_lock_screen' => '인터페이스 화면이 완전히 표시될때까지, 사용자가 Plesk에서 작업할 수 없도록 합니다.',
    '__dismiss_news?' => "뉴스 블록을 완전히 닫으시겠습니까?\n\n추가 뉴스가 제공될 때까지 뉴스 블록을 볼 수 없게 됩니다.",
    '__description' => "설명",
    '__disabled' => "꺼짐",
    '__disk_space_limit' => "디스크 공간 제한",
    '__cgroups_cpu_usage_limit' => 'CPU 사용률 제한',
    '__cgroups_ram_usage_limit' => 'RAM 사용량 제한',
    '__cgroups_disk_read_usage_limit' => '디스크 읽기 대역폭 제한',
    '__cgroups_disk_write_usage_limit' => '디스크 쓰기 대역폭 제한',
    '__disk_usage_by' => "다음에 의해 사용된 디스크 공간 %1",
    '__dns' => "DNS",
    '__dns_record_already_exist' => "'%1' DNS 레코드가 이미 있습니다.",
    '__dns_master_should_be_remote' => "개별 호스트에 두 개의 신뢰할 수 있는 이름 서버가 있어야 합니다.",
    '__dns_record_not_exist' => "DNS 레코드가 없습니다.",
    '__dns_server' => "DNS 서버", // indirect
    '__dom_id_is_undefined' => "도메인 ID가 정의되지 않았습니다.",
    '__dom_name' => "도메인 이름",
    '__dom_name_is_invalid' => "도메인 이름이 유효하지 않습니다. 도메인 이름에 영숫자, 도트 및 하이픈 기호만 있고 길이가 255자를 초과하지 않는 것을 확인하십시오. 도트 사이에 도메인 이름의 각 부분은 63자를 초과하지 않아야 합니다.",
    '__dom_not_exist' => "도메인이 없습니다.",
    '__domain' => "도메인",
    '__domain_' => '도메인 %1',
    '__domain_form' => "도메인 폼",
    '__domain_id' => "도메인 ID",
    '__domain_is_turned_off_for_backup' => "웹 사이트 %1은(는) 백업 또는 복원을 위해 일시적으로 해제되었으므로 현재 사용할 수 없습니다.",
    '__domain_limits' => "도메인 제한",
    '__domain_name' => "도메인 이름",
    '__mail_name_in_ASCII_form' => "ASCII 형식의 메일 계정 이름",
    '__message_error' => '오류',
    '__message_warning' => '경고',
    '__message_info' => '정보',
    '__domain_name_in_ASCII_form' => "ASCII 형식의 도메인 이름",
    '__domain_repository' => "도메인의 리포지토리 %1",
    '__domain_status' => "도메인 상태",
    '__domain_found_tech' => "도메인에서 발견된 기술",
    '__domain_dns' => '도메인 DNS 영역',
    '__domain_total' => "구독 총합",
    '__domain_total_powerUser' => "구독 총합",
    '__domain_user' => "도메인 관리자",
    '__domains_global_changes' => "선택한 도메인 수정",
    '__mailnames_global_changes' => "선택한 메일 계정 수정",
    '__backup_manager' => '백업 관리자',
    '__domains_list' => "도메인",
    'domains_list__list_header' => "도메인",
    //this is a part of phrases like No domains (and others), so it should not be capitalized
    '__double_www_warning' => "WWW의 접두사가 사용되더라도 도메인 이름은 www로 시작해야 합니다.\n그래도 진행하겠습니까?",
    '__dovecot' => 'Dovecot IMAP 및 POP3 서버',
    '__dsmail' => "메일 서비스",
    '__dsmaillist' => "메일링 리스트 서비스",
    '__dsr_db' => "DB",
    '__dsr_dname' => "도메인 이름",
    '__dsr_du' => "DU",
    '__dsr_ma' => "MA",
    '__dsr_mg' => "MF",
    '__dsr_ml' => "ML",
    '__dsr_mn' => "MBox",
    '__dsr_pname' => "고객 이름",
    '__dsr_sd' => "SD",
    '__dsr_tr' => "TR",
    '__dsr_wu' => "WU",
    '__dumps_tot_size' => "로컬 스토리지에 있는 백업 파일의 전체 크기",
    '__email' => "이메일",
    '__email_addr_is_invalid' => "이메일 주소가 유효하지 않습니다.",
    '__enabled' => "켜짐",
    '__enter_cert_text' => "인증서 텍스트 입력",
    '__enter_size' => "크기 입력",
    '__exclusive' => "전용",
    '__expiration_date' => "만료 날짜",
    '__fax' => "팩스",
    '__file' => "파일",
    '__file_is_empty' => "파일이 비어 있습니다.",
    '__file_name' => "파일 이름",
    '__file_type' => '파일 유형',
    '__filemanager' => "파일 관리자",
    '__filepath_is_empty' => "파일 경로가 비어 있음",
    '__files_list' => "파일",
    '__frontpage' => "Microsoft FrontPage",
    '__ftp' => "FTP", // +indirect
    '__ftp_settings' => "FTP 설정",
    '__ftp_serv' => "FTP 서버", // indirect
    '__ftp_server_parameters_are_empty' => "먼저 FTP 계정 속성을 설정해야 합니다!",
    '__ftp_status' => "FTP 서버 상태",
    '__full_day0' => "일요일",
    '__full_day1' => "월요일",
    '__full_day2' => "화요일",
    '__full_day3' => "수요일",
    '__full_day4' => "목요일",
    '__full_day5' => "금요일",
    '__full_day6' => "토요일",
    '__full_month1' => "1월",
    '__full_month10' => "10월",
    '__full_month11' => "11월",
    '__full_month12' => "12월",
    '__full_month2' => "2월",
    '__full_month3' => "3월",
    '__full_month4' => "4월",
    '__full_month5' => "5월",
    '__full_month6' => "6월",
    '__full_month7' => "7월",
    '__full_month8' => "8월",
    '__full_month9' => "9월",
    '__giga' => "G",
    '__group' => "그룹",
    '__h' => "H",
    '__hard_disk_quota' => "하드 디스크 할당량",
    '__hard_disk_quota_not_supported' => '서버 파일 시스템의 구성으로 인해 하드 디스크 할당량이 지원되지 않습니다.',
    '__header_text_is_invalid' => "보호된 영역의 제목이 잘못되었습니다.",
    '__help_topic_not_found' => '요청한 도움말 항목(%1)이 존재하지 않습니다.',
    '__hosting_ip_dns_ip_not_equiv' => "A DNS 레코드에 지정된 어떤 IP 주소도 호스팅에 사용된 IP 주소와 일치하지 않습니다.",
    '__hosting_scripting' => "호스팅 스크립트 사용 지원",
    '__hosting_setup_page_title' => "도메인에 대한 웹 호스팅 설정 %1",
    '__hosting_title' => "호스팅(%1)",
    '__hosting_type' => "호스팅 유형",
    '__hostname_is_empty' => "호스트 이름이 비어 있습니다.",
    '__hour(s)' => '시간',
    '__hst_type_incorrect' => "호스팅 유형이 잘못되었습니다.",
    '__http' => "HTTP", //indirect
    '__htype' => "H",
    '__idle_time' => "유휴 시간",
    '__iface' => "인터페이스",
    '__image' => "이미지",
    '__imap_status' => "IMAP 서버 상태",
    '__in' => "위치",
    '__in_%' => "% 단위",
    '__incorrect_databases_login_pass' => "PostgreSQL 액세스를 위해 지정한 자격 증명이 올바르지 않습니다.",
    '__incorrect_ip_or_network_address' => '잘못된 IP 주소 또는 네트워크.',
    '__info' => '정보',
    '__install' => "설치",
    '__install_prefix' => "설치 접두사",
    '__invalid_cert_id' => "유효하지 않은 인증서 ID",
    '__invalid_context' => "유효하지 않은 컨텍스트: %1",
    '__invalid_db_usr_name' => "데이터베이스 사용자 이름이 잘못되었습니다.",
    '__invalid_dir_name' => "디렉터리 이름이 잘못되었습니다.",
    '__invalid_dom_name' => "도메인 이름이 유효하지 않습니다.",
    '__invalid_filename' => "유효하지 않은 파일 이름. 인용 부호 및/또는 \"../\" 조합을 사용하지 마십시오.",
    '__invalid_id' => "유효하지 않은 식별자.",
    '__invalid_lines_num' => "라인 수 값이 잘못됨, 숫자만 허용됩니다.",
    '__invalid_max_letter_size' => "최대 메시지 크기가 유효하지 않습니다.",
    '__invalid_pdir_name' => "보호된 디렉터리 이름이 유효하지 않습니다.",
    '__invalid_restart_apache_interval' => "Apache 재시작 간격이 유효하지 않습니다.",
    '__invalid_tmpl_name' => "템플릿 이름이 유효하지 않습니다.",
    '__invalid_value' => "부적합한 값.",
    '__ip_addr' => "IP 주소",
    '__ip_address_and_mask' => "IP 주소 및 서브넷 마스크",
    '__ip_alias__mask' => "IP 주소 및 서브넷 마스크",
    '__ip_addr_is_invalid' => "IP 주소가 유효하지 않습니다.",
    '__ip_addr_list' => "IP 주소",
    '__ip_address_and_mask_hint' => '예를 들어, %1',
    '__is_owner' => "O",
    '__java_engine' => "Java", // indirect
    '__jdk' => "JDK",
    '__kb' => "KB",
    '__kbps' => "KB/초",
    '__kbytes' => "KB",
    '__key_for_virtuozzo_only' => "이 라이센스 키는 Virtuozzo 컨테이너에만 사용할 수 있습니다.",
    '__key_limits_exceeding' => "이 작업은 소프트웨어 라이센스로 정의된 제한을 초과합니다. 이 메시지가 나타나면 공급자나 제조업체에 연락하여 이 라이센스의 제한을 확인하거나 확장할 수 있습니다.",
    '__kilo' => "K",
    '__keywords' => '키워드',
    '__lang_unknown' => '언어를 인식할 수 없습니다.',
    '__languages' => '언어',
    '__learn_more' => '자세히 알아보기',
    '__loading' => '로딩 중…',
    '__locales' => "언어 팩",
    '__lists' => "메일링 리스트",
    '__literal_bytes' => "B",
    '__processing' => "기다려 주십시오.<br>로드 중...",
    '__locale' => "인터페이스 언어",
    '__locale_is_not_defined' => "인터페이스 언어가 정의되지 않았습니다.",
    '__local_server_mysql' => '로컬 MySQL 서버',
    '__local_server_postgresql' => '로컬 PostgreSQL 서버',
    '__local_server_mssql' => '로컬 MS SQL 서버',
    '__log_and_statistics_files' => '로그 파일 및 통계 보고서',
    '__config_files' => '구성 파일',
    '__chroot_files' => 'Chrooted 환경',
    '__login' => "%1 로그인",
    '__login1' => "로그인",
    '__login_disabled' => "로그인이 금지됨",
    '__login_enabled' => "로그인이 허용됨",
    '__login_incorrect' => "잘못된 사용자 이름 또는 암호를 입력했습니다.",
    '__login_name' => "%1 사용자 이름",
    '__login_name_is_invalid' => "%1 사용자 이름이 유효하지 않습니다.",
    '__logon_time' => "로그온 시간",
    '__ma' => "메일 별칭",
    '__mail' => "메일",
    '__mail_alias_name' => "메일 별칭 이름",
    '__mail_autodiscovery' => '메일 자동 검색',
    '__mail_exchanger_name_is_invalid' => "메일 Exchanger 이름이 유효하지 않습니다.",
    '__mail_groups' => "메일 그룹",
    '__mail_list_engine' => "메일링 리스트 소프트웨어",
    '__mail_name' => "메일 계정",
    '__mail_name_form' => "메일 계정 속성",
    '__mail_names' => "메일 계정",
    '__mail_serv' => "메일 서버",
    '__mail_user' => '메일 서버',
    '__mailgroup' => "메일 그룹",
    '__maillist' => "메일링 리스트",
    '__maillists' => "메일링 리스트",
    '__maillist_member' => '메일링 리스트 구성원',
    '__mailname' => "메일 계정",
    '__mailname_redir_self' => "메일 계정이 자신에게 메일을 전달할 수 없습니다.",
    '__max_dom_num_reached_for_cl' => "이 고객 계정에 대한 도메인 수 제한에 도달했습니다.",
    '__max_file_size_available' => "허용된 최대 파일 크기 %1",
    '__max_subdom_num_reached_for_cl' => "이 고객 계정에 대한 하위 도메인 수 제한에 도달했습니다.",
    '__max_subdom_num_reached_for_dom' => "도메인에 대한 하위 도메인 수 제한에 도달했습니다.",
    '__max_subdom_num_reached_for_key' => "라이센스 키로 허용된 하위 도메인 수 제한에 도달했습니다.",
    '__max_traffic_limit' => "트래픽 제한",
    '__maximum_excl_ip_num' => "메일 계정",
    '__mb' => "MB",
    '__mbytes' => "MB",
    '__mb_month' => "MB/월",
    '__mb_sec' => "MB/초",
    '__gb_sec' => "GB/초",
    '__tb_sec' => "TB/초",
    '__mega' => "M",
    '__minute(s)' => '분',
    '__mls_not_in_key' => "라이센스 키가 다중 인터페이스를 지원하지 않습니다.",
    '__modification_date' => "수정 날짜",
    '__module' => "확장명",
    '__month' => "월",
    '__month(s)' => "월",
    '__month1' => "1월",
    '__month10' => "10월",
    '__month11' => "11월",
    '__month12' => "12월",
    '__month2' => "2월",
    '__month3' => "3월",
    '__month4' => "4월",
    '__month5' => "5월",
    '__month6' => "6월",
    '__month7' => "7월",
    '__month8' => "8월",
    '__month9' => "9월",
    '__monthly' => "매월",
    '__months' => "월",
    '__moved_permanently' => '영구적으로 이동됨',
    '__mssql' => "Microsoft SQL Server",
    '__mssql__server' => "서버",
    'mssql__server' => "Microsoft SQL Server 이름",
    'mssql__unable_to_change_server_name_db_exists' => "서버 이름을 변경할 수 없음: 서버에 데이터베이스가 하나 이상 있습니다.",
    '__mssql_status' => "Microsoft SQL Server 상태",
    '__multiply_login_deny' => "로그인 할 수 없습니다. 다른 사용자가 동일한 로그인명 (%1)으로 Plesk에 로그인하고 있습니다.",
    '__mysql' => "MySQL",
    '__mysql_status' => "MySQL Server 상태",
    '__mysql_version' => "Mysql 버전",
    '__mariadb' => "MariaDB",
    '__mariadb_status' => "MariaDB 서버 상태",
    '__mariadb_version' => "MariaDB 버전",
    '__percona' => "Percona",
    '__percona_status' => "Percona 서버 상태",
    '__percona_version' => "Percona 버전",
    '__name' => "이름",
    '__name_invalid' => "이름이 유효하지 않습니다.",
    '__nameserver' => "이름 서버",
    '__network' => "네트워크",
    '__networks' => "네트워크",
    '__no' => "아니오",
    '__no_ip_address_with_properly_type_available' => "복원에 필요한 적합한 IP 주소가 없기 때문에 백업 데이터를 복원할 수 없습니다.",
    '__no_clients_specified' => "고객 계정이 지정되지 않음.",
    '__no_comments' => "주석 없음.",
    '__nologin' => "금지됨",
    '__none' => "없음",
    '__not_configured' => "구성되지 않음",
    '__not_implemented_yet' => "아직 구현되지 않음",
    '__not_supported_by_ftp' => "(FTP 서버에서 지원하지 않음)",
    '__notification' => "알림",
    '__num_displayed' => "%1 / %2 표시함",
    '__num_is_invalid' => "숫자가 유효하지 않습니다.",
    '__object_not_found' => '개체를 찾을 수 없음: %1',
    '__of_all' => "전체의 %",
    '__off' => "끄기",
    '__ok' => "확인",
    '__old_passwd' => "이전 %1 암호",
    '__on' => "켜기",
    '__others' => "기타",
    '__other_ip__will_be_added' => '사용 가능한 다른 IP 주소(고객의 IP 풀에 추가됨)',
    '__out' => "출력",
    '__p' => "P",
    '__passwd' => "%1 암호",
    '__passwd_is_invalid' => "%1 암호가 유효하지 않습니다.",
    '__passwd_not_match' => "암호 불일치!",
    '__path' => "경로",
    '__perl_unix_support' => "Perl 지원",
    '__perl_win_support' => "Perl 지원",
    '__perm_denied' => "권한이 거부됨.",
    '__permissions' => "권한",
    '__personal_name' => "개인 이름",
    '__pg_admin_not_activated' => "PostgreSQL이 서버 관리 페이지에서 활성화되지 않았습니다.",
    '__pg_not_inst' => "PostgreSQL이 설치되지 않았습니다.",
    '__pg_not_run_or_inst' => "PostgreSQL이 설치되지 않았거나 실행 중이 아닙니다.",
    '__pg_not_support_in_key' => "라이센스 키가 PostgreSQL을 지원하지 않습니다.",
    '__phone' => "전화번호",
    '__phosting' => "실제 호스팅",
    '__php_support' => "PHP 지원",
    '__php_run_as_isapi' => "ISAPI 확장으로 실행",
    '__php_safe_mode' => "다음의 PHP 'safe_mode'",
    '__php_version' => "PHP 버전",
    '__physical' => "실제 호스팅",
    '__plesk_stat_pdir' => "디렉터리 '/plesk-stat/webstat/' 보호",
    '__plesk_stat_dir_name' => "도메인 통계",
    '__plesk_stat_protect' => "사용자의 FTP 사용자 이름과 암호로 웹 통계에 대한 액세스 보호",
    '__plesk_stat_protect_install' => "암호로 보호된 디렉터리인 '/plesk-stat/webstat/'를 통해 액세스 가능",
    '__pop3_imap' => "POP3/IMAP", // indirect
    '__pop3_status' => "POP3 서버 상태",
    '__popen_error' => "popen 함수를 호출하는 중 오류 발생.",
    '__port' => '포트',
    '__postgres' => "PostgreSQL",
    '__postgresql' => "PostgreSQL",
    '__postgresql_status' => "PostgreSQL 상태",
    '__preferences' => "설정",
    '__account_preferences' => "계정 설정",
    '__interface_preferences_general' => '일반',
    '__interface_preferences_default' => '기본 인터페이스 기본 설정',
    '__interface_preferences_admin' => "관리자 인터페이스 기본 설정",
    '__interface_template' => '인터페이스 사용자 지정 템플릿',
    '__interface_preferences' => "인터페이스 기본 설정",
    '__proceed?' => "계속 하시겠습니까?",
    '__protect_dir_user' => "보호된 디렉터리 사용자",
    '__protect_dir_users' => "보호된 디렉터리 사용자",
    '__provider_contact_name' => "소유자의 담당자 이름",
    '__python_unix_support' => "Python 지원",
    '__python_win_support' => "Python 지원",
    '__quota' => "할당량",
    '__r' => "R",
    '__reconfigure' => "재구성",
    '__record_type' => "레코드 유형",
    '__release' => "릴리스",
    '__remote_db_not_supported_by_key' => '현재 라이센스 키가 원격 데이터베이스 호스팅을 지원하지 않습니다.',
    '__remove' => "제거",
    '__remove_confirmation' => "제거 확인",
    '__remove_protection' => '보호 제거',
    '__report' => "보고서",
    '__report_auto' => '배달 일정',
    '__report_size_na' => "서비스를 사용할 수 없습니다.",
    '__reports_list' => "보고서",
    '__requested' => "요청",
    '__required_fields' => "필수 필드",
    '__resp_name_invalid' => "자동 회신 이름이 잘못되었습니다. 영숫자, 도트, 밑줄 및 공백 기호만 사용하십시오.",
    '__c' => "A", // Access to panel
    '__s' => "S",
    '__server_name_is_invalid' => "서버 이름이 유효하지 않습니다.",
    '__screenshots' => '스크린샷',
    '__script_warning' => "이 도메인에서 스크립팅 기능을 제거하면 브라우저에서 호출 시 해당하는 모든 스크립트가 일반 텍스트로 표시됩니다.  관리자가 주어진 도메인에서 종속된 모든 스크립트를 제거하는 것이 바람직합니다.",
    '__sec' => "초",
    '__second(s)' => "초",
    '__see_list_of_logged_in' => "현재 로그인한 사용자 목록을 표시합니다.",
    '__select_certs_to_remove' => "제거할 인증서를 선택합니다.",
    '__select_domains_to_default_host' => "기본값으로 설정할 도메인을 선택합니다.",
    '__select_files_to_remove' => "제거할 파일을 선택합니다.",
    '__select_ip' => "IP 주소 할당",
    '__select_ip_to_remove' => "제거할 IP 주소를 선택합니다.",
    '__select_domain_template' => "도메인 템플릿 설정 사용",
    '__select_templates_to_remove' => "제거할 템플릿을 선택합니다.",
    '__server' => "서버",
    '__server_total' => "서버 총합",
    '__service' => "서비스",
    '__service_title__plesk' => "Plesk",
    '__service_description__plesk' => "Plesk",
    '__service_title__mysql' => "MySQL 데이터베이스 서버",
    '__service_description__mysql' => "MySQL 데이터베이스 서버",
    '__service_title__web' => "웹 서버",
    '__service_description__web' => "웹 서버",
    '__service_title__smtp' => "SMTP 서버",
    '__service_description__smtp' => "SMTP 서버",
    '__service_title__mail' => "IMAP/POP3 서버",
    '__service_description__mail' => "IMAP/POP3 서버",
    '__service_title__dns' => "DNS 서버",
    '__service_description__dns' => "DNS 서버",
    '__service_title__postgresq' => "PostgreSQL 데이터베이스 서버",
    '__service_description__postgresq' => "PostgreSQL 데이터베이스 서버",
    '__service_title__spamassassin' => "SpamAssassin 스팸 필터링 서비스",
    '__service_description__spamassassin' => "SpamAssassin 스팸 필터링 서비스",
    '__services' => "서비스",
    '__all_services' => "모든 서비스",
    '__sessions' => "세션",
    'sessions__feature_ftp_session_manager_not_supported' => "현재 FTP 서버가 FTP 세션 기능을 지원하지 않습니다.",
    '__sessions_list' => "세션",
    '__set' => "켜기",
    '__shared' => "공유",
    '__shell_access_warning' => "시스템에 대한 셸 액세스를 허용하면 시스템 보안이 매우 취약해집니다. 수행하는 작업 내용을 완전히 이해하는 경우에 신뢰할 수 있는 사용자에게만 시스템 액세스를 허용하십시오. 정말로 액세스를 허용하시겠습니까?",
    '__siteapp_not_support_in_key' => "라이센스 키가 웹 응용 프로그램을 지원하지 않음",
    '__siteapp_cannot_reconfigure_with_remote_database' => '이 웹 응용 프로그램의 구성이 수동으로 변경되었습니다. 수동 수정 사항을 보호하기 위해, Plesk를 통한 재구성을 수행할 수 없습니다.',
    '__site_management' => "웹 게시", // indirect
    '__size' => "크기",
    '__skeleton' => '가상 호스트 템플릿',
    '__skins' => '스킨',
    '__smtp' => "SMTP", // indirect
    '__smtp_status' => "SMTP 서버 상태",
    '__some_fields_are_empty_or_invalid' => "일부 필드가 비어 있거나 부적합한 값이 입력되었습니다.",
    '__unable_to_set_parameters' => "구성 요소의 매개 변수를 지정할 수 없습니다.",
    '__spamassassin' => "스팸 필터",
    '__spamassassin_status' => "SpamAssassin 상태",
    '__spamd_status' => '스팸 필터 상태',
    '__splited_backup' => "(다중 볼륨 백업)",
    '__split_backup_file' => "다중 볼륨 백업 생성",
    '__split_backup_size' => "볼륨 크기",
    '__split_backup_less_than_500' => "500MB 미만의 볼륨 크기는 지원되지 않습니다.",
    '__ssi' => "SSI",
    '__ssi_support' => "SSI 지원",
    '__ssi_with_html' => "*.htm, *.html 파일에 SSI 사용",
    '__ssl' => 'SSL/TLS',
    '__ssl_support' => "SSL/TLS 지원",
    '__same_ssl' => "SSL/TLS 콘텐츠와 SSL/TLS가 아닌 콘텐츠 하우징을 위해 단일 디렉터리 사용",
    '__same_ssl_cu' => "일반 SSL/TLS 콘텐츠 및 SSL/TLS가 아닌 콘텐츠",
    '__state' => "시/도",

    '__status__Active' => '활성',
    '__status__active' => '활성',
    '__status__Passive' => '꺼짐',
    '__status__passive' => '꺼짐',
    '__status__off' => '꺼짐',
    '__status__with_parent' => '꺼짐',
    '__status__backup_restore' => '백업 또는 복원을 위해 일시 중단됨',
    '__status__admin' => '서버 관리자에 의해 일시 중단됨',
    '__status__resseler' => '리셀러에 의해 일시 중단됨',
    '__status__client' => '고객에 의해 일시 중단됨',
    '__status__unknown' => '상태를 알 수 없습니다.',

    '__status_of' => "%1 상태",
    // end of akss part

    // shramko part

    '__stunnel' => "Stunnel",
    '__stunnel_server' => "Stunnel 서버", // indirect
    '__subdomain' => "하위 도메인",
    '__subdomain_name' => "하위 도메인 이름",
    '__subdomain_name_in_ASCII_form' => "ASCII 형식의 하위 도메인 이름",
    '__subdomains' => "하위 도메인",
    '__domainaliases' => "도메인 별칭",
    '__subdomains_list' => "하위 도메인",
    '__subdomains_not_support_in_key' => "라이센스 키가 하위 도메인 작업을 지원하지 않음",
    '__sys_user_type' => "FTP 사용자",
    '__sys_user_type_main' => "주 도메인의 FTP 사용자 계정 사용",
    '__sys_user_type_native' => "이 하위 도메인에 대한 별도 FTP 사용자 계정 만들기",
    '__t' => "T",
    '__target_domain' => "대상 도메인",
    '__template' => "템플릿",
    '__template_not_accepted' => "템플릿을 수락할 수 없음: 다음 제한이 초과되었습니다.",
    '__templates' => "템플릿",
    '__templates_list' => "템플릿",
    '__tera' => "T",
    '__title' => "제목",
    '__tools' => "도구",
    '__total' => "전체 %1",
    '__total_size' => "총 크기",
    '__total_used' => "총 사용량",
    '__traffic' => "트래픽",
    '__traffic_by_client' => "고객별 트래픽",
    '__traffic_by_domain' => "도메인별 트래픽",
    '__traffic_by_service' => "서비스별 트래픽",
    '__traffic_history' => "트래픽 기록",
    '__unable_change_locale' => "인터페이스 언어를 변경할 수 없음: %1",
    '__unable_create_new_dom' => "도메인을 만들 수 없음: %1",
    '__unable_define_dom_name' => "도메인 이름을 정의할 수 없음: %1",
    '__unable_define_necessary_properties' => "모든 필수 속성을 정의할 수 없음.",
    '__unable_define_properties' => "속성을 정의할 수 없음: %1",
    '__unable_exec_util' => "유틸리티를 실행할 수 없음: %1",
    '__unable_get_dns_a_recs' => "이 호스팅 계정에 대한 A DNS 레코드의 IP 주소를 검색할 수 없음: %1",
    '__unable_get_mbox_quota' => "사서함 크기 제한 정보를 검색할 수 없습니다.",
    '__unable_redirect_to_myself' => "동일한 계정으로 전달할 수 없습니다.",
    '__unable_redirect_to_my_alias' => "메일 별칭에 메일을 전달할 수 없습니다.",
    '__default_domain_redirect_to_myself' => "도메인을 IP 주소에 대한 기본값으로 설정할 수 없음:\n 자신으로의 리디렉션이 탐지되었습니다.",
    '__unable_remove_client' => "고객을 제거할 수 없음: %1",
    '__unable_set_up_mbox_quota' => "도메인에 대한 사서함 크기 제한을 설정할 수 없음: %1",
    '__unable_setup_pass' => "암호를 설정할 수 없음: %1",
    '__unable_to_create_new_account' => "계정을 만들 수 없음: %1",
    '__unable_to_define_db_size' => "데이터베이스 크기를 정의할 수 없음.",
    '__unable_to_enable_short_names' => "POP3/IMAP 계정에 축약 메일 계정 이름 사용을 허용할 수 없음.",
    '__unable_to_fetch_data_from_submit' => "제출된 데이터를 가져올 수 없음: %1",
    '__unable_to_open_file' => "%1 파일을 열 수 없음: %2",
    '__unable_to_update_subdomain' => "하위 도메인을 변경할 수 없음: %1",
    '__unable_update_cl_data' => "사용자 계정에 대한 변경 내용을 저장할 수 없음: %1",
    '__unable_update_db_params' => "데이터베이스 매개 변수를 업데이트할 수 없음: %1",
    '__unable_update_dom_data' => "도메인 데이터를 업데이트할 수 없음: %1",
    '__undefined' => "정의되지 않음",
    '__uninstall' => "설치 제거",
    '__unknown_error' => "알 수 없는 오류",
    '__unlimited_lower' => "제한 없음",
    '__unset' => "끄기",
    '__update' => "업데이트",
    '__uploaded_file_is_invalid' => "업로드된 파일이 유효하지 않음: %1",
    '__url' => "URL",
    '__usage' => "디스크 사용량",
    '__user' => '사용자',
    '__user_already_logged' => "같은 사용자 이름 (%1)으로 다른 사용자가 이미 컨트롤 Plesk에 로그인하고 있습니다.",
    '__version' => "버전",
    '__aps_license' => "라이센스 키",
    '__vh_type' => "가상 호스트 유형",
    '__vhosts_apache_status' => "웹 서버 상태",
    '__wrong_charset_conversion' => '잘못된 charset, %1에서 %2(으)로 변환할 수 없습니다.',
    '__warning_' => "경고!",
    '__warning_excl_ip_num' => "전용 IP 주소",
    '__warning_expiration' => "만료 날짜",
    '__web_scripting' => "웹 스크립팅", // indirect
    '__web_serv' => "웹 서버", // indirect
    '__web_statistic' => "웹 통계", // indirect
    '__webmail' => "웹 메일", // +indirect
    '__webstat_not_installed' => "Webalizer가 서버에 설치되지 않았습니다. 서비스 공급자에게 연락하여 Webalizer 설치를 위한 도움을 요청하십시오.",
    '__webstat_support' => "웹 통계",
    '__webstat_awstats_support' => "AWStats",
    '__webstat_webalizer_support' => "Webalizer",
    '__webstat_awstats' => "AWStats",
    '__webstat_webalizer' => "Webalizer",
    '__webstat_type_change_warning' => "한 통계 프로그램에서 다른 통계 프로그램으로 전환하면 이전에 사용한 통계 프로그램에서 만들어진 모든 보고서가 삭제되고 서버에 보관된 로그 파일에서 읽은 정보에 따라 새 보고서가 만들어집니다. 즉, 지난 달에 대한 로그 파일만 보관하도록 (도메인 > 도메인 이름 > 로그 관리자 > 로그 순환에서) 시스템을 구성했으면 지난 달의 통계만 사용 가능합니다. 다른 통계 패키지로 전환하시겠습니까?",
    '__webstat_perm_denied' => '웹 통계를 관리할 권한이 없습니다.',
    '__webuser' => "웹 사용자",
    '__sysusers_list' => "시스템 사용자",
    '__sysuser' => "시스템 사용자",
    '__weekly' => "주간",
    '__whats_new_in_version' => "Plesk %1의 새로운 기능",
    '__wrong_hosting_type__virtual_required' => "이 작업은 웹 호스팅이 지원되는 도메인에서만 수행할 수 있습니다.",
    '__wrong_hosting_type__none' => '도메인 %1에 웹 호스팅이 구성되어 있지 않습니다.',
    '__wrong_hosting_type__std_fwd' => '도메인 %1에 표준 전달이 구성되어 있습니다. 이 작업은 웹 호스팅이 있는 도메인에만 사용할 수 있습니다.',
    '__wrong_hosting_type__frm_fwd' => '도메인 %1에 프레임 전달이 구성되어 있습니다. 이 작업은 웹 호스팅이 있는 도메인에만 사용할 수 있습니다.',
    '__wu' => "웹 사용자",
    '__www' => "WWW",
    '__www_prefix_was_changed' => "WWW 접두어가 변경되었습니다. SSL/TLS 인증서를 올바르게 수정하십시오.",
    '__year' => "연도",
    '__year(s)' => "연",
    '__yes' => "예",
    '__you' => "귀하",
    '__zip_code' => "우편 번호",
    '__form_normal' => "보통",
    '__form_advanced' => "고급",

    'admin_ed__edit_administrator_info' => "관리자 프로필 편집",
    'admin_ed__create_default_client' => "기본 고객 계정을 만들겠습니다.",
    'admin_ed__unable_update' => "관리자 정보를 업데이트할 수 없음: %1",

    'auth__update_admin_info' => "관리자 정보를 입력하십시오. %1을(를) 작동시키려면 이 정보가 필요합니다.",
    'auth__you_not_have_perm' => "이 도메인을 관리하기 위한 권한이 없습니다.",
    'auth__key_expired_admin' => 'Plesk 라이선스가 만료되었습니다. Plesk를 계속 사용하려면 라이선스를 갱신하거나 새 라이선스를 구입하십시오.',
    'auth__key_expired_admin_restricted' => 'Plesk 라이선스가 만료되었습니다. Plesk를 계속 사용하려면 서버 제공업체에 연락하십시오.',
    'auth__key_expired_client' => 'Plesk 라이선스가 만료되었습니다. 호스팅 업체에 연락하십시오.',
    'autoinstaller__not_installed' => '자동 설치 프로그램 구성 요소가 설치되지 않았습니다.',
    'autoinstaller__release_action' => '사용 가능한 작업',
    'autoinstaller__release_action_icon' => 'S',
    'autoinstaller__release_action_upgrade' => '새로운 컨트롤 Plesk 버전으로 업그레이드 합니다.',
    'autoinstaller__release_action_update' => '새 구성 요소 업데이트 또는 추가',
    'autoinstaller__release_action_up2date' => '최신 버전을 사용 중입니다.',
    'autoinstaller__component_action' => '상태',
    'autoinstaller__component_action_icon' => 'S',
    'autoinstaller__component_action_install' => '설치되지 않음',
    'autoinstaller__component_action_update' => '업데이트가 있습니다.',
    'autoinstaller__component_action_upgrade' => '업데이트를 사용할 수 있습니다.',
    'autoinstaller__component_action_up2date' => '최신 버전을 사용 중입니다.',
    'autoinstaller__component_action_error' => '업데이트가 없음',
    'autoinstaller__component_serverbuildtime' => '최신 릴리스',
    'autoinstaller__component_localbuildtime' => '현재 릴리스',
    'autoinstaller__component_installed_version' => '현재 버전',
    'autoinstaller__component_available_version' => '최신 버전',
    'autoinstaller__component' => '구성 요소',
    'autoinstaller__components' => '구성 요소',
    'autoinstaller__components_title' => '%1 구성 요소',
    'autoinstaller__component_dependency_note' => '선택한 구성 요소를 설치하기 위해 필요합니다.',
    'autoinstaller__install_confirm' => '예, 이 구성 요소를 설치하겠습니다.',
    'autoinstaller__install_confirm_request' => '확인란을 선택하여 확인해 주십시오.',
    'autoinstaller__install_title' => '선택한 구성 요소의 설치 확인',
    'autoinstaller__key_update_confirm' => '키 업데이트를 건너뛰고 기본 키 설치 확인',
    'autoinstaller__key_update_confirm_request' => '확인란을 선택하여 확인해 주십시오.',
    'autoinstaller__key_update_failed' => '<p>Plesk가 제품 라이센스를 업데이트할 수 없습니다.</p><p>%1</p><p>적절한 제품 라이센스 없이 업그레이드를 계속하면 기능이 제한된 기본 라이센스가 설치됩니다. 제품 업그레이드를 계속하기 전에 먼저 올바른 라이센스 키를 얻는 것이 좋습니다.</p>',
    'autoinstaller__email' => '알림을 보낸 대상',
    'autoinstaller__email_admin' => "관리자 이메일",
    'autoinstaller__email_email' => '사용자 지정 이메일 주소...',
    'autoinstaller__release' => '릴리스 이름',
    'autoinstaller__releases' => '사용 가능한 릴리스',
    'autoinstaller__releases_title' => 'Plesk 업데이트 프로그램',
    'autoinstaller__select_components_to_install' => '설치할 구성 요소 선택',
    'autoinstaller__status_error' => '오류: %1',
    'autoinstaller__status_install_error' => '설치를 시작할 수 없음: %1',
    'autoinstaller__status_install_busy' => '설치를 시작할 수 없음: 다른 설치 절차가 현재 실행 중입니다.',
    'autoinstaller__status_install_ok' => '설치가 시작됨. 이메일로 설치 진행 결과가 통보됩니다(%1).',
    'autoinstaller__status_query_busy' => '설치가 진행 중입니다.',
    'autoinstaller__status_query_error' => '설치 상태를 가져올 수 없음: %1',
    'autoinstaller__status_unknown' => '자동 설치 프로그램 상태를 검색할 수 없습니다.',
    'autoinstaller__status_busy' => '자동 설치 프로그램이 사용 중입니다. 기다려 주십시오.',
    'autoinstaller__configure_title' => '업데이트 프로그램 설정',
    'autoinstaller__preferences_legend' => '설정',
    'autoinstaller__target' => '임시 다운로드 디렉터리',
    'autoinstaller__target_invalid' => "절대 경로 지정",
    'autoinstaller__check_updates' => '관리자 권한으로 Plesk 로그인시 업데이트를 체크 합니다.',
    'autoinstaller__check_updates_warning' => '%2에 대한 새 <a href=%1>업데이트</a>가 있음',
    'autoinstaller__source_type' => '소스 유형',
    'autoinstaller__source' => '소스 URL',
    'autoinstaller_source__preferences_legend' => '설정',
    'autoinstaller_source__type' => '소스 유형',
    'autoinstaller_source__url_invalid' => '잘못된 소스',
    'autoinstaller_source__url_invalid_network' => '잘못된 소스 URL(예: http://source, ftp://source)',
    'autoinstaller_source__url' => '소스 URL',
    'autoinstaller__source_invalid_network' => '잘못된 네트워크 주소를 지정했습니다.',
    'backup__repository' => '백업 파일 스토리지 위치',
    'backup__error_notify_email' => '백업 중 오류가 발생하는 경우 알림 이메일을 보냄',
    'backup__dump_info' => "백업 정보",
    'backup__dump_file_name_not_defined' => "백업 파일 이름이 지정되지 않았습니다.",
    'backup__local_file' => '로컬 백업 파일',
    'backup__domain_ftp' => '원격 FTP 서버',
    'backup__wrong_path' => "잘못된 백업 파일 스토리지 경로: 문자 시퀀스 ../../를 사용하지 마십시오.",
    'backup__unable_to_connect_to_ftp_server' => "FTP 서버에 연결할 수 없음: %1",
    'backup__unable_to_read_file' => '백업 파일을 읽을 수 없습니다.',
    'backup__backup_task_does_not_exist' => "백업 작업이 존재하지 않으며 우선 작업을 만든 후에 설정해야 합니다.",
    'backup__restore_params' => "복원 매개 변수",
    'backup__confirmation' => "경고: 백업/복원 중 도메인을 사용할 수 없습니다.",
    'backup__backup_method' => '백업 방법',
    'backup__dumpfile_name' => "백업 파일 이름",
    'backup__dumpfile_name_is_invalid' => "백업 파일 이름이 유효하지 않음: 백업 파일 이름으로 영숫자, 대시, 도트 및 밑줄 기호만 사용하고 description.* 등의 이름을 사용하지 마십시오.",
    'backup__email_required' => "백업 및 복원 진행률 정보를 제공하기 위해 이메일 주소가 필요합니다. 계정 정보에서 이메일을 지정해 주십시오.",
    'backup__error_during_backup' => "백업 파일을 만들 수 없음: %1",
    'backup__input_email_warning' => "알림을 위한 이메일을 지정하거나 확인란을 선택 취소해야 합니다.",
    'backup__make_download' => "백업 파일을 스토리지에 저장하지 말고 다운로드만 하십시오.",
    'backup__make_dump' => '백업 파일을 만들고 로컬 스토리지에 저장합니다.',
    'backup__makedump_to_ftp' => '백업 파일을 만들고 원격 FTP 서버에 저장합니다.',
    'backup__restore_ip' => "복원을 위한 IP 주소",
    'backup__select_dumpfile' => "백업 파일을 선택합니다.",
    'backup__time' => "백업 시간",
    'backup__day' => '백업 일',
    'backup__view_dump_info' => "도메인에 대한 백업 정보를 표시합니다. %1",
    'backup__wrong_domain_name' => "백업 파일에 도메인 데이터가 있으며,%1 따라서 도메인에 복원할 수 없습니다.%2",
    'backup__incorrect_ftp_user_or_passwd' => "잘못된 FTP 사용자 또는 암호. FTP 계정 속성을 수정하십시오.",
    'backup__access_denied' => "액세스가 거부됨. FTP 계정 속성을 수정하십시오.",
    'backup__restore_from' => "복원 %1",
    'backup__domain_session_failed' => '도메인 %1이(가) 백업되지 않았습니다.',
    'backup__client_session_failed' => '고객 %1이(가) 백업되지 않았습니다.',
    'backup__domain_session_restore_failed' => '도메인 %1이(가) 복원되지 않았습니다.',
    'backup__client_session_restore_failed' => '고객 계정 %1이(가) 복원되지 않았습니다.',
    'backup__domain_session_complete' => '도메인 %1이(가) 백업되었습니다.',
    'backup__domain_session_backup' => '도메인 백업 %1',
    'backup__client_session_backup' => '고객 백업 %1',
    'backup__domain_stop_title' => '도메인 백업 취소 %1',
    'backup__client_stop_title' => '고객 계정 백업 취소 %1',
    'backup__domain_restore_stop_title' => '도메인 복원 취소 %1',
    'backup__client_restore_stop_title' => '고객 계정 복원 취소 %1',
    'backup__domain_session_backup_stop' => '활성 백업 프로세스를 취소합니다. 백업 파일이 만들어지지 않았습니다.',
    'backup__backup_stop_confirm' => '예, 백업 프로세스를 중지합니다.',
    'backup__restore_stop_confirm' => '예, 복원 프로세스를 중지합니다.',
    'backup__domain_session_restore' => '도메인 복원 %1',
    'backup__domain_session_restore_stop' => '활성 복원 프로세스를 취소합니다.',
    'backup__domain_backup_file_info' => '도메인 백업 파일 정보',
    'backup__domain_backup_file_list' => '기존 백업 파일',
    'backup__domain_backup_progress' => '웹 사이트 백업 진행률 %1',
    'backup__domain_restore_progress' => '웹 사이트 복원 진행률 %1',
    'backup__domain_backup_progress_elapsed_time' => '경과 시간: %1',
    'backup__domain_restore_progress_elapsed_time' => '경과 시간: %1',
    'backup__ip_map_legend' => 'IP 매핑',
    'backup__ip_map_list_count' => 'IP 주소',
    'backup__domain_restore_session_complete' => '도메인 %1이(가) 복원되었습니다.',
    'backup__domain_restore_session_complete_message' => '도메인 %1이(가) 복원되었습니다.',
    'backup__domain_backup_file_delete' => '다음 백업 파일이 제거됨:',
    'backup__domain_backup_file_for_remove' => '제거할 백업 파일 선택',
    'backup__backup_overwrite_file_confirm' => '대체 확인',
    'backup__backup_overwrite_file_confirm_text' => '이름이 %1인 백업 파일이 이미 있습니다. 이 파일을 대체하시겠습니까?',
    'backup__backup_confirm_overwrite' => '파일 대체 확인',
    'backup__backup_overwrite_legeng' => '대체',
    'backup__backup_not_contain_domain' => '백업 파일에 도메인 정보가 없습니다. %1',
    'backup__backup_not_contain_client' => '백업 파일에 고객 계정 정보가 없습니다. %1',
    'backup__backup_client_info' => "고객의 설정 및 계정 세부 정보 백업",
    'backup__client_backup_progress' => '고객 계정 백업 진행률 %1',
    'backup__client_session_complete' => '고객 계정 %1이(가) 백업되었습니다.',
    'backup__client_backup_file_info' => '고객 백업 파일 정보',
    'backup__restore_client_info' => "고객의 설정 및 계정 세부 정보 복원",
    'backup__client_session_restore' => '고객 계정 복원 %1',
    'backup__client_db_server_map' => '데이터베이스 서버 매핑',
    'backup__domain_db_server_map' => '데이터베이스 서버 매핑',
    'backup__client_restore_session_complete_message' => '%1의 고객 계정이 복원되었습니다.',
    'backup__client_restore_session_complete' => '%1의 고객 계정이 복원되었습니다.',
    'backup__restore_select_some' => '복원할 개체를 선택하십시오.',
    'backup__client_restore_progress' => '고객 계정 복원 진행률 %1',
    'backup__new_backup' => '새 백업 만들기',
    'backup__done' => '완료:',
    'backup__done_domains' => '%1 개 도메인/ %2',
    'backup__done_clients' => '%1 명 고객/ %2',
    'backup__remaining' => '남은 시간:',
    'backup__remaining_domains' => '%1 도메인',
    'backup__remaining_clients' => '%1 고객',
    'backup__overall_backup_progress' => '전체 백업 진행률',
    'backup__comment_n_a' => '해당 없음',
    'backup__command_ignore' => '명령 %1이(가) 무시되었습니다.',
    'backup__no_objects' => '백업할 개체가 없음',
    'backup__cli_warning_not_enough_ip' => '경고: 기본 IP 매핑을 수행할 IP 주소가 부족함:',
    'backup__local_repository' => "Plesk 스토리지",
    'backup__ftp_repository' => 'FTP 저장소',
    'backup__ftp_login' => '사용자 이름',
    'backup__ftp_password' => '암호',
    'backup__ftp_directory_hint' => '예: /myfolder/mybackups',
    'backup__ftp_account_settings' => 'FTP 계정 설정',
    'backup__ftp_account_preferences' => 'FTP 계정 설정',
    'backup__repository_not_exist' => '디렉터리가 존재하지 않습니다.',
    'backup__repository_not_readable' => '지정한 디렉터리를 읽을 수 없습니다.',
    'backup__ftp_repository_not_configure' => 'FTP 백업 스토리지를 사용하려면,<a href=\'%1\'> 먼저 FTP 계정을</a> 지정하십시오.',
    'backup__ftp_repository_list_not_configure' => '계정 설정을 지정하지 않았습니다.',
    'backup__repository_list_unable_listing' => '파일 목록을 검색할 수 없습니다.',
    'backup__ftp_repository_unable_listing' => '디렉터리 %1의 목록을 검색할 수 없음:',
    'backup__repository_legend' => '백업 파일 스토리지',
    'backup__store_in_repository' => '다음 위치에 파일 저장',
    'backup__local_repository_lable' => '로컬 스토리지',
    'backup__ftp_repository_lable' => 'FTP 저장소',
    'backup__ftp_repository_not_configure_hint' => '(계정 설정이 지정되지 않음)',
    'backup__ftp_repository_not_configure_or_forbidden_hint' => '(FTP 계정이 지정되지 않았거나 지원되지 않음)',
    'backup__ftp_directory_not_exist' => '지정한 디렉터리가 존재하지 않습니다.',
    'backup__other_user_process_modified' => '다른 사용자가 백업 또는 마이그레이션 프로세스를 중지했습니다.',
    'backup__another_user_exist' => '실행중인 조작이 다른 Plesk 사용자에 의해서 초기화되었습니다. 해당 사용자는 Plesk에 로그인 중입니다.',
    'backup__ftp_repository_wait' => 'FTP 스토리지 정보를 검색하는 동안 기다려 주십시오.',
    'backup__ftp_write_test_failed' => '테스트 데이터를 FTP 계정 %1에 기록할 수 없음:',
    'backup__ftp_storage' => 'FTP 스토리지',
    'bt_upload_to_repository' => '로컬 스토리지에 파일 업로드',
    'bt_new_restore' => "복원",
    'bt_backup_schedule' => "백업 예약",
    'backup_exist_backups' => "기존 백업 파일",
    'backup_dialog__page_title' => "백업 파일 만들기",
    'backup_dialog__please_wait' => "백업 프로세스를 시작하려고 합니다. 이 작업은 시간이 약간 걸릴 수 있습니다. 기다려 주십시오...",
    'backup_conf__page_title' => '백업 구성',
    'bt_accept' => "수락",
    'bt_access' => "액세스",
    'bt_action_log' => "작업 로그",
    'bt_add' => "추가",
    'bt_add_client' => "사용자에게 할당",
    'bt_database_server_add' => '데이터베이스 서버 추가',
    'bt_add_services' => "서비스 추가",
    'bt_anonftp_stats' => "Anon.FTP 통계",
    'bt_anonymous_ftp' => "익명 FTP",
    'bt_aspdotnet' => "ASP.NET",
    'bt_attach' => "첨부",
    'bt_autoinstaller' => '업데이트 프로그램',
    'bt_auto-updates' => '업데이트 프로그램',
    'bt_back' => "<< 뒤로",
    'bt_backup' => "백업",
    'bt_backup_configure' => "백업 설정",
    'bt_buy_certs' => "인증서 구입",
    'bt_card' => "카드",
    'bt_cert' => "인증서",
    'bt_certificates' => "인증서",
    'bt_change_passwd' => "암호 변경",
    'bt_clear' => "지우기",
    'bt_client_templates' => "고객 템플릿",
    'bt_clients' => "고객",
    'bt_codepage_change' => '인코딩 변경',
    'bt_comp_info' => "구성 요소 관리",
    'bt_configure_maillists' => "Mailman 설정",
    'bt_configure' => '구성',
    'bt_copy' => "복사",
    'bt_copy_move' => "복사/이동",
    'bt_create' => "생성",
    'bt_create_account' => "계정 만들기",
    'bt_create_dir' => "디렉터리 추가",
    'bt_create_file' => "파일 추가",
    'bt_count_size' => "크기 계산",
    'bt_crontab_unix' => "Crontab",
    'bt_crontab_win' => "작업 스케줄러",
    'bt_custom_button_new' => "버튼 추가",
    'bt_custom_buttons' => "사용자 지정 버튼",
    'bt_customize' => "사용자 지정",
    'bt_databases' => "데이터베이스",
    'bt_database_servers' => '데이터베이스 서버',
    'bt_sqlservers' => "데이터베이스 서버",
    'bt_db_usr_new' => "데이트베이스 사용자 추가",
    'bt_db_new' => "데이터베이스 추가",
    'bt_db_phpmyadmin' => "MySQL 관리자",
    'bt_dbuser_default' => "DB Webadmin에 대한 기본값 만들기",
    'bt_decline' => "거절",
    'bt_default' => "기본값",
    'bt_defaultcomponents' => "타사 서비스",
    'bt_defaults' => "기본값",
    'bt_delete' => "삭제",
    'bt_directories' => "보호된 디렉터리",
    'bt_disable' => "끄기",
    'bt_dns_zone_sync' => 'DNS 템플릿의 변경 사항이 적용됩니다.',
    'bt_dnsrecord_add' => '레코드 추가',
    'bt_do_backup' => "백업",
    'bt_do_restore' => "복원",
    'bt_do_upload' => "업로드",
    'bt_domain_aliases' => "도메인 별칭",
    'bt_domain_templates' => "도메인 템플릿",
    'bt_domain_user' => "도메인 관리자",
    'bt_domain_user_passwd' => "도메인 관리자 암호",
    'bt_domains' => "도메인",
    'bt_domain_alias_add' => '도메인 별칭 추가',
    'bt_download' => "다운로드",
    'bt_edit' => "편집",
    'bt_enable' => "켜기",
    'bt_export' => '내보내기',
    'bt_extras' => "추가 항목",
    'bt_finish' => "마침",
    'bt_ftp_account' => "FTP 계정 속성",
    'bt_forget_password' => "암호를 잊으셨습니까?",
    'bt_fp_ssl_webadmin' => "FP-SSL/TLS Webadmin",
    'bt_fp_webadmin' => "FP Webadmin",
    'bt_ftp_stats' => "FTP 통계",
    'bt_get_password' => "암호 가져오기",
    'bt_global_changes' => "수정",
    'bt_help' => "도움말",
    'bt_hide_aliases' => "별칭 숨기기",
    'bt_hide_toolbar' => '도구 모음 숨기기',
    'bt_hide_subdomains' => "하위 도메인 숨기기",
    'bt_hide_domainaliases' => "도메인 별칭 숨기기",
    'bt_home' => "홈",
    'bt_hosting' => "호스팅",
    'bt_icf' => '방화벽',
    'bt_install' => "설치",
    'bt_ip_aliasing' => "IP 주소",
    'bt_ip_add' => "IP 주소 추가",
    'bt_ip_pool' => "IP 풀",
    'bt_key_info' => "라이선스 정보",
    'bt_key_buyonline_addons' => 'Plesk 추가 기능 주문',
    'bt_key_buyonline_upgrades' => 'Plesk 업그레이드 주문',
    'bt_key_buyonline_new' => '새 키 주문',
    'bt_limits' => "제한",
    'bt_locale_add' => '로켈 추가',
    'bt_locales' => '로켈',
    'bt_log_manager' => "로그 관리자",
    'bt_login' => "로그인",
    'bt_logo' => "브랜딩",
    'bt_logo_send_link' => "링크 첨부",
    'bt_logo_send_logo' => "로고 첨부",
    'bt_logout' => "로그아웃",
    'bt_logrotation' => "로그 순환",
    'bt_mail' => "메일",
    'bt_mail_alias_add' => "메일 별칭 추가",
    'bt_mail_aliases' => "메일 별칭",
    'bt_mail_group_add' => "구성원 추가",
    'bt_mail_groups' => "그룹",
    'bt_mail_name_add' => "메일 계정 추가",
    'bt_mail_preferences' => "설정",
    'bt_mail_group' => "메일 그룹",
    'bt_mail_mailbox' => "사서함",
    'bt_mail_redirect' => "전달자",
    'bt_mail_resp_add' => "자동응답 추가",
    'bt_mail_resp_attach_add' => "첨부 파일 추가",
    'bt_mail_resp_files' => "첨부 파일",
    'bt_mail_responders' => "자동 회신",
    'bt_mail_spamfilter' => "스팸 필터",
    'bt_mail_webmail' => "웹 메일",
    'bt_maillist_new' => "메일링 리스트 추가",
    'bt_maillists' => "메일링 리스트",
    'bt_mailman' => "Mailman",
    'bt_make_dump' => "백업 만들기",
    'bt_manage' => "관리",
    'bt_master' => "마스터",
    'bt_migrate' => '마이그레이션',
    'bt_modules_add' => '확장 프로그램 추가',
    'bt_modules_manage' => '확장 프로그램 관리',
    'bt_move' => "이동",
    'bt_mimetypes' => 'MIME 유형',
    'bt_mimetype_new' => 'MIME 유형 추가',
    'bt_new_client' => "고객 계정 추가",
    'bt_new_domain' => "도메인 추가",
    'bt_next' => "다음 >>",
    'bt_next_page' => "다음",
    'bt_network_add' => "네트워크 추가",
    'bt_notifications' => "알림",
    'bt_off' => "끄기",
    'bt_on' => "켜기",
    'bt_on_off' => "켜기/끄기",
    'bt_pd_new' => "보호된 디렉터리 추가",
    'bt_pd_user_new' => "사용자 추가",
    'bt_performance' => '성능',
    'bt_permissions' => "권한",
    'bt_phpmyadmin' => "PhpMyAdmin",
    'bt_postgre_sql' => "PostgreSQL",
    'bt_preferences' => "설정",
    'bt_prev_page' => "이전",
    'bt_preview' => '사이트 미리 보기',
    'bt_print' => "인쇄",
    'bt_reboot' => "재부팅",
    'bt_reload' => "재로드",
    'bt_refresh' => "새로 고침",
    'bt_register' => "등록",
    'bt_remove' => "제거",
    'bt_enable_selected' => '켜기',
    'bt_disable_selected' => '끄기',
    'bt_repair_ip' => "IP 복구",
    'bt_report' => "보고서",
    'bt_report_auto' => '보고서 배달',
    'bt_report_auto_new' => '배달 일정 추가',
    'bt_report_new' => "레이아웃 추가",
    'bt_reset' => "재설정",
    'bt_restart_services' => "서비스 관리",
    'bt_save' => "저장",
    'bt_send_by_email' => "이메일로 보내기",
    'bt_send_file' => "파일 보내기",
    'bt_send_mail' => "메일 보내기",
    'bt_send_passwd' => "암호 보내기",
    'bt_send_text' => "텍스트 보내기",
    'bt_server' => "서버",
    'bt_server_add' => "서버 추가",
    'bt_server_preferences' => "서버 설정",
    'bt_servers_list' => "서버",
    'bt_sessions' => "세션",
    'bt_set' => "설정",
    'bt_set_as_default' => "기본값으로 설정",
    'bt_setup' => '설정',
    'bt_show_aliases' => "별칭 표시",
    'bt_show_subdomains' => "하위 도메인 표시",
    'bt_show_domainaliases' => "도메인 별칭 표시",
    'bt_shutdown' => "종료",
    'bt_site_apppkgs' => "응용 프로그램 저장소",
    'bt_site_apppool' => "응용 프로그램 풀",
    'bt_application-pool' => "웹 응용 프로그램",
    'bt_site_apps' => "웹 응용 프로그램",
    'bt_site_app_add' => "응용 프로그램 설치",
    'bt_site_builder' => "Presence Builder 지원",
    'bt_skeleton' => '가상 호스트 템플릿',
    'bt_skins' => '스킨',
    'bt_skin_add' => '스킨 추가',
    'bt_skin_manual' => '사용자 지정 Plesk 스킨 참조', // not used
    'bt_skin_download' => '스킨 다운로드',
    'bt_skin_replace' => '스킨 업데이트',
    'bt_skip' => '건너뛰기',
    'bt_spamassassin' => "스팸 필터",
    'bt_spamassassin_train' => "교육",
    'bt_spamfilter' => "스팸 필터",
    'bt_start' => "시작",
    'bt_stop' => "중지",
    'bt_recycle' => "재활용",
    'bt_statistics' => "통계",
    'bt_subdomain_new' => "하위 도메인 추가",
    'bt_subdomains' => "하위 도메인",
    'bt_submit' => "제출",
    'bt_summary_report' => "요약 보고서",
    'bt_support' => "지원",
    'bt_switch' => "전환",
    'bt_system_time' => "시스템 시간",
    'bt_task_new' => "작업 추가",
    'bt_dom_tmpl_add' => '도메인 템플릿 추가',
    'bt_cl_tmpl_add' => '고객 템플릿 추가',
    'bt_cron_backup' => '예약된 백업 설정',
    'bt_test' => "테스트 연결",
    'bt_text' => "텍스트",
    'bt_touch' => "타임스탬프 변경",
    'bt_traffic' => "트래픽",
    'bt_traffic_history' => "트래픽 기록",
    'bt_update' => "업데이트",
    'bt_upload' => "업로드",
    'bt_upload_from_ftp' => "FTP 업로드",
    'bt_virtualdirs' => '가상 디렉터리',
    'bt_virtualdir_new' => '가상 디렉터리 추가',
    'bt_virtualdir_add' => '가상 디렉터리 추가',
    'bt_web_app_new' => "Java 응용 프로그램 설치",
    'bt_web_stats' => "웹 통계",
    'bt_web_stats_ssl' => "웹 통계 SSL/TLS",
    'bt_web_user_add' => "웹 사용자 추가",
    'bt_web_users' => "웹 사용자",
    'bt_webadmin' => "Webadmin",
    'bt_webalizer' => "Webalizer",
    'bt_whats_new_full' => "전체 변경 목록 보기",
    'cert_add__unable_set_ca_cert' => "CA 인증서를 설정할 수 없습니다. %1",
    'cert_add__unable_set_cert' => "인증서를 설정할 수 없습니다. %1",
    'cert_add__unable_set_private_key' => "개인 키를 설정할 수 없습니다. %1",
    'certificates_list__certificate_used_as_default' => "삭제하려는 인증서 중 하나가 기본 인증서로 사용 중입니다.",
    'certificates_list__certificates_assigned_on_ip' => "하나 또는 여러 개의 인증서가 IP 주소/도메인에 할당되었습니다.",
    'ch_pass__admin_pass' => "관리자의 암호 변경",
    'ch_pass__old_pass' => "이전 암호",
    'ch_pass__pass_confirm' => "확인",
    'ch_pass__unable_change_admin_pass' => "관리자의 암호를 변경할 수 없음: %1",
    'check_mail_cycle__aliases' => "메일 순환이 탐지되었습니다. \"%1\" 주소는 이 메일 계정의 별칭에 포함되어 있습니다.",
    'check_mail_cycle__autoresponders' => "메일 순환이 탐지되었습니다. 주소 \"%1\"이(가) 이 메일 계정의 자동 회신에 포함되어 있습니다.",
    'check_mail_cycle__mail_groups' => "메일 순환이 탐지되었습니다. \"%1\" 주소는 이 메일 계정의 메일 그룹에 포함되어 있습니다.",
    'check_mail_cycle__mail_name' => "메일 순환이 탐지되었습니다. \"%1\" 주소가 이 메일 계정과 일치합니다.",
    'check_mail_cycle__redirect' => "메일 순환이 탐지되었습니다. 주소 \"%1\"이(가) 이 메일 계정의 전달자와 일치합니다.",
    'check_mail_dup__redirect' => "중복 전달이 탐지되었습니다. 주소 \"%1\"이(가) 이 메일 계정의 전달 주소와 일치합니다.",
    'check_mail_dup__mail_groups' => "중복 전달이 탐지되었습니다. 주소 \"%1\"이(가) 이 메일 계정의 메일 그룹에 포함되어 있습니다.",
    'check_maillist_cycle__admin' => "메일 순환이 탐지되었습니다. 관리자 이메일 \"%1\"이(가) 메일링 리스트의 주소와 일치합니다.",
    'check_maillist_cycle__member' => "메일 순환이 탐지되었습니다. 주소 \"%1\"이(가) 메일링 리스트의 주소와 일치합니다.",
    'chk_js__enter_login_and_passwd' => "사용자 이름 및 암호를 입력합니다.",
    'chk_js__enter_login_name' => "사용자 이름을 입력합니다.",
    'chk_js__enter_passwd' => "암호를 입력합니다.",

    // end of shramko part

    // serge part
    'cl_ed__edit_cl' => "%1계정 정보",
    'cl_limits__cl' => "고객 %1제한",
    'cl_logo__setup_logo_pref' => "고객에 대한 로고 속성 설정 %1",
    'cl_new__enter_new_cl_data' => "새 고객에 관한 정보 입력",
    'cl_new__unable_to_sent_notification' => '사용자 계정이 만들어졌지만 고객에게 알림을 보낼 수 없음: %1',
    'cl_perm__all_ip' => "사용 가능한 모든 IP",
    'cl_perm__all_ip_based_hst_will_be_nb' => "고객에 대한 모든 IP 기반 호스팅 계정이 이름 기반으로 전송됩니다.",
    'cl_perm__allow_client_create_domain' => "선택하려는 필드는 도메인 만들기가 허용된 고객에게만 적용할 수 있습니다.",
    'cl_perm__allow_create_nb_w_ip' => "고객은 다음을 사용하여 이름 기반 호스팅을 만들 수 있습니다. %1",
    'cl_perm__allow_creation_ip_based_hosting' => "IP 기반 호스팅 계정 만들기 허용",
    'cl_perm__available_ips' => "사용 가능한 IP",
    'cl_perm__change_limits' => "제한 조정",
    'cl_perm__cl_disk_space' => "사용 가능한 총 디스크 공간",
    'cl_perm__cl_expiration' => "고객 계정 유효 기간",
    'cl_perm__cl_max_box' => "사서함",
    'cl_perm__cl_max_db' => "데이터베이스",
    'cl_perm__cl_max_dom' => "도메인",
    'cl_perm__cl_max_maillists' => "메일링 리스트",
    'cl_perm__cl_max_subdom' => "하위 도메인",
    'cl_perm__cl_max_traffic' => "사용 가능한 총 트래픽의 양",
    'cl_perm__cl_max_wu' => "웹 사용자",
    'cl_perm__cl_mbox_quota' => "이 사용자 계정에 대한 사서함 크기 제한",
    'cl_perm__current_maximum_exp_date' => "requested %2.\";\"도메인 유효 기간의 현재 최대 값%1",
    'cl_perm__current_maximum_mailbox_quota' => "이 사용자 계정의 하우징 사서함에 할당된 디스크 공간에 대해 현재 정의된 제한은 %1이며, %2을(를) 요청함",
    'cl_perm__current_total_requested' => "requested %3.\";\"%1에 대한 현재 총 도메인 제한 값%2",
    'cl_perm__current_total_requested_dom' => "이 고객이 속한 %1의 현재 수는 %2이며, %3을(를) 요청함.",
    'cl_perm__disk_space' => "최대 디스크 공간",
    'cl_perm__dashboard_stdgui' => '사용자 인터페이스',
    'cl_perm__dashboard' => '홈 페이지 보기',
    'cl_perm__stdgui' => '표준 보기',
    'cl_perm__manage_dashboard' => '홈 페이지 관리',
    'cl_perm__dashboard_and_stdgui' => '홈 페이지 보기 및 표준 보기가 허용됨',
    'cl_perm__dashboard_only' => '홈 페이지 보기만 허용됨',
    'cl_perm__stdgui_only' => '표준 보기만 허용됨',
    'cl_perm__edit_cl' => "고객 %1권한",
    'cl_perm__exp_date_exceeded' => "설정하려는 유효 기간이 이 고객과 관련된 개별 도메인 내에 지정된 제한을 초과합니다.",
    'cl_perm__invalid_value' => "유효하지 않은 값. 숫자만 가능합니다.",
    'cl_perm__limit_disk_space' => "총 디스크 공간 제한 %1",
    'cl_perm__limit_expiration' => "%1 고객 계정의 유효 기간 제한",
    'cl_perm__limit_max_box' => "%1 사서함의 최대 수 제한",
    'cl_perm__limit_max_db' => "%1 데이터베이스의 최대 수 제한",
    'cl_perm__limit_max_dom' => "%1 도메인의 최대 수 제한",
    'cl_perm__limit_max_maillists' => "%1 메일링 리스트의 최대 수 제한",
    'cl_perm__limit_max_subdom' => "%1 하위 도메인의 최대 수 제한",
    'cl_perm__limit_max_traffic' => "%1 총 트래픽의 양 제한",
    'cl_perm__limit_max_wu' => "%1 웹 사용자의 최대 수 제한",
    'cl_perm__limit_mbox_quota' => "%1 사서함 할당량 설정",
    'cl_perm__limits_exceeded' => "설정하려고 하는 하나 또는 여러 개의 제한이 이 고객에게 속한 개별 도메인 내에 정의된 제한을 이미 초과했습니다.\n고객에 대한 총 제한은 이 고객 계정에 대해 정의된 도메인 제한의 총 합계와 같거나 더 커야 합니다.",
    'cl_perm__mailbox_quota_exceeded' => "설정하려고 하는 사서함에 할당된 디스크 공간 제한이 이 고객 계정과 관련된 개별 도메인 내에 정의된 제한을 초과합니다.",
    'cl_perm__mailbox_quota_exceeds_server_limit' => "설정하려고 하는 사서함에 할당된 디스크 공간 제한이 서버 레벨에서 적용된 제한을 초과합니다.",
    'cl_perm__make_dumps' => "데이터 백업 및 복원",

    'cl_perm__max_box' => "사서함 최대 수",
    'cl_perm__max_db' => "데이터베이스 최대 수",
    'cl_perm__max_dom' => "도메인",
    'cl_perm__max_maillists' => "메일링 리스트 최대 수",
    'cl_perm__max_subdom' => "하위 도메인",
    'cl_perm__max_traffic' => "트래픽의 최대량",
    'cl_perm__max_wu' => "웹 사용자 최대 수",
    'cl_perm__max_dom_aliases' => "도메인 별칭",
    'cl_perm__mbox_quota' => "사서함 할당량",
    'cl_perm__not_allow_create_nb_hst' => "고객은 이름 기반 호스팅을 만들 수 없습니다.",
    'cl_perm__this_ip_used_vrt_hst' => "이 IP 주소는 가상 호스팅에서 사용되고 있습니다.\n이 IP 주소를 삭제하려면 호스팅 서비스를 제거하거나 그 유형을 이름 기반으로 변경하십시오.",
    'cl_perm__unable_off_ipb_creating' => "고객의 IP 기반 호스팅 서비스가 이미 설정되었습니다. 고객에 대해 이 기능을 비활성화하려면 \"도메인 생성\" 확인란의 선택을 취소하거나 모든 IP 기반 호스팅 계정을 제거하십시오.",
    'cl_perm__unable_off_nb_creating' => "고객의 이름 기반 호스팅 서비스가 이미 설정되었습니다. 고객에 대해 이 기능을 비활성화하려면 \"Domain creation\" 확인란의 선택을 취소하거나 모든 이름 기반 호스팅 계정을 제거하십시오.",
    'cl_perm__unable_set_domain_limit' => "최대 도메인 수를 제한할 수 없음: 고객에게 이미 %1 도메인이 있습니다.",
    'cl_perm__unable_update_client_limitations' => "고객 계정 제한을 수정할 수 없음: %1",
    'cl_pref__edit_cl' => "고객 %1의 기본 설정",
    'class_anonftp__create_ftp_domain' => "이 dom_id에 대한 가상 FTP 도메인이 없음. 우선 이 도메인을 만드십시오.",
    'class_anonftp__incoming_disk_space_should_be_lower' => "설정하려는 디스크 공간 제한(%1)은 도메인 레벨에서 정의된 총 디스크 공간 제한을 초과하지 않아야 합니다(%2).",
    'class_anonftp__invalid_input_only_digits' => "유효하지 않은 값이 지정됨. 숫자만 가능합니다.",
    'class_anonftp__unable_change_ownerships' => "할당량 파일에 대한 소유권 또는 권한을 변경할 수 없음: %1",
    'class_anonftp__unable_copy_quota_file' => "할당량 파일을 복사할 수 없음: %1",
    'class_anonftp__unable_get_disk_usage' => "들어오는 디렉터리에서 디스크 사용량 정보를 검색할 수 없음: %1",
    'class_anonftp__unable_parse_quota_file' => "할당량 파일을 구문 분석할 수 없음.",
    'class_anonftp__unable_read_quota_file' => "할당량 파일을 읽을 수 없음: %1",
    'class_anonftp__unable_update_quota' => "할당량을 업데이트할 수 없음: 들어오는 디렉터리의 파일이%1 KB의 디스크 공간을 사용하며 이는 새 할당량 값을 초과합니다.",
    'class_anonftp__unable_write_temp_file' => "임시 파일에 쓸 수 없음: %1",
    'class_bsdomain__warn_max_date__' => "설정된 만료 날짜: %1",
    'class_cList__empty' => "항목 없음.",
    'class_cList__header' => "%1 (%2)",
    'class_cList__not_found' => "%2에 <b>\"%1\"</b>과(와) 일치하는 항목이 없습니다(%3/%4).",
    'class_cList__search_result' => "%2에서 <b>\"%1\"</b>에 대한 검색 결과(%3/%4 ).",
    'class_client__client_creation_notification' => "고객 만들기 알림.",
    'class_client__client_with_contact_name_already_exists' => "%1 이름을 가진 고객이 이미 있습니다.",
    'class_client__disk_space' => "디스크 공간",
    'class_client__invalid_max_dom' => "유효하지 않은 도메인 값 숫자. 숫자만 가능합니다.",
    'class_client__limit_exceed' => "%2 고객 계정의 할당량(%3)을 초과하므로 요청한 양 %1을(를) 할당할 수 없습니다. 추가 리소스를 할당하려면 고객 > 고객 이름 > 제한으로 이동한 후 필요에 따라 할당량을 변경합니다. 그런 다음 이 화면으로 돌아가 할당을 다시 조정하십시오.",
    'class_client__limit_exceed_unlimited' => "리소스(%1)를 무제한으로 할당하려면 먼저 고객 > 고객 이름 > 제한으로 이동한 후 필요한 리소스 유형에 해당하는 무제한 확인란을 선택합니다. 그런 다음 이 화면으로 돌아가 할당을 다시 조정하십시오.",
    'class_client__max_box' => "사서함",
    'class_client__max_db' => "데이터베이스",
    'class_client__max_maillists' => "메일링 리스트",
    'class_client__max_subdom' => "하위 도메인",
    'class_client__max_traffic' => "최대 트래픽",
    'class_client__max_wu' => "웹 사용자",
    'class_client__max_dom_aliases' => "도메인 별칭",
    'class_client__mbox_quota' => "사서함 할당량",
    'class_client__unable_define_cl_status' => "고객 계정의 상태를 정의할 수 없음: %1",
    'class_client__unable_define_inactive_dom' => "%1의 비활성 도메인을 정의할 수 없습니다.",
    'class_client__unable_del_ip' => "IP를 제거할 수 없음: %1",
    'class_db__db_name_not_set' => "데이터베이스 이름이 정의되지 않았습니다.",
    'class_db__db_not_exist_for_curr_dom' => "이 도메인에 대한 데이터베이스가 없습니다.",
    'class_db__invalid_db_or_dom_name' => "도메인 또는 데이터베이스 ID가 유효하지 않거나 데이터베이스 이름이 정의되지 않았습니다.",
    'class_db__invalid_pass' => "암호가 유효하지 않습니다.",
    'class_db__mailgrp_member_exist' => "메일 그룹 구성원이 이미 있습니다.",
    'class_db__access_hosts_notsupport' => '이 데이터베이스 유형에 대한 액세스 호스트 설정이 지원되지 않습니다.',
    'class_db__unable_add' => '액세스 호스트 레코드를 추가할 수 없음: %1',
    'class_db__unable_del' => '액세스 호스트 레코드를 삭제할 수 없음: %1',
    'class_db__inc_user_not_exist' => '데이터베이스 사용자 %1이(가) 없습니다.',
    'class_db__inc_access_record_exist' => '이 액세스 레코드가 이미 있습니다.',
    'class_db__inc_access_record_not_exist' => '주어진 액세스 레코드가 없습니다.',
    'class_db__inc_unable_del_last_record' => '마지막 액세스 호스트 레코드를 삭제할 수 없습니다.',
    'class_domtmpleditform__dns_master' => "기본",
    'class_domtmpleditform__dns_slave' => "보조",
    'class_domtmpleditform__dns_type' => "도메인 DNS 영역의 유형",
    'clienttrafficlist_header' => "도메인의 트래픽",
    'clienttrafficlist_header_of_client__' => "고객 도메인의 트래픽 %1",
    'cmd_dns__a_dns_record_already_exist' => "이 레코드는 영역의 A 레코드와 충돌할 것입니다.",
    'cmd_dns__domain_last_ns' => '도메인의 마지막 NS DNS 기록을 삭제할 수 없습니다.',
    'cmd_dns__canonical_dom_name_is_invalid' => "정식 도메인 이름은 유효하지 않습니다.",
    'cmd_dns__cname_dns_record_already_exist' => "이 레코드는 영역의 CNAME 레코드와 충돌할 것입니다.",
    'cmd_dns__cname_in_rr_combination' => 'DNS 영역에 잘못된 DNS 레코드 조합이 있습니다.',
    'cmd_dns__cname_coexist_with_data' => 'CNAME DNS 영역 레코드는 동일 영역의 다른 DNS 레코드와 함께 있을 수 없습니다.',
    'cmd_dns__dns_record_type_is_invalid' => "DNS 레코드 유형이 유효하지 않습니다.",
    'cmd_dns__ext_host_is_not_resolved' => "정식 이름 %1은(는) A 또는 AAAA 레코드로 해석되지 않습니다.",
    'cmd_dns__domain_restore_dns_zone_failed_add_record' => '%1 기록을 영역 %2에 추가할 수 없습니다. %3',
    'cmd_dns__mail_dom_name_is_invalid' => "메일 Exchanger 이름이 유효하지 않습니다.",
    'cmd_dns__mx_priority_is_invalid' => "MX 우선 순위가 유효하지 않습니다.",
    'cmd_dns__name_server_is_invalid' => "이름 서버가 유효하지 않습니다.",
    'cmd_dns__network_mask_should_be_24_16_or_8' => "네트워크 마스크 값은 24, 16 또는 8이어야 합니다.",
    'cmd_dns__this_dns_record_already_exists' => "이러한 DNS 레코드가 이미 있습니다.",
    'cmd_dns__unable_add_record' => "'%1' 레코드를 추가할 수 없음: %2",
    'cmd_dns__unable_add_a_record' => "A 레코드를 추가할 수 없음: %1",
    'cmd_dns__unable_add_cname_record' => "CNAME 레코드를 추가할 수 없음: %1",
    'cmd_dns__unable_add_dns_record' => "DNS 레코드를 추가할 수 없음: %1.",
    'cmd_dns__unable_add_ext_ns_record' => "EXT_NS 레코드를 추가할 수 없음: %1",
    'cmd_dns__unable_add_ns_record' => "NS 레코드를 추가할 수 없음: %1",
    'cmd_dns__unable_add_ptr_record' => "PTR 레코드를 추가할 수 없음: %1",
    'cmd_dns__unable_add_txt_record' => "TXT 레코드를 추가할 수 없음: %1",
    'cmd_dns__unable_create_dns_zone' => "DNS 영역을 만들 수 없음 %1",
    'cmd_dns__unable_define_dns_record' => "%1의 DNS 레코드를 정의할 수 없습니다.",
    'cmd_dns__unable_get_default_dns_zone_status_set_true' => "기본 DNS 영역 상태를 검색할 수 없음: %1",
    'cmd_dns__unable_insert_a_record' => "A 레코드를 삽입할 수 없음: %1",
    'cmd_dns__unable_insert_mx_record' => "MX 레코드를 삽입할 수 없음: %1",
    'cmd_dns__unable_insert_ns_record' => "NS 레코드를 삽입할 수 없음: %1",
    'cmd_dns__unable_set_dns_zone_status' => "DNS 영역 상태를 설정할 수 없음: %1",
    'cmd_domains__dom_already_exists' => "%1 도메인이 이미 있습니다.",
    'cmd_domains__dns_record_already_exists' => "호스트 %1을(를) 가리키는 DNS 레코드가 이미 있으므로 도메인 %1을(를) 만들 수 없습니다.",
    'cmd_domains__dom_already_exists1' => "이 도메인에 %2개의 하위 도메인이 있습니다. %1 도메인이 이미 있습니다.",
    'cmd_domains__dom_already_exists2' => "하위 도메인 %1이(가) 이미 있습니다.",
    'cmd_domains__dalias_already_exists' => "이 별칭이 이미 있습니다.",
    'cmd_domains__domain_alias_already_exists' => '이러한 이름을 갖는 도메인 별칭이 이미 있습니다.',
    'cmd_domains__unable_del_mail_for_dom' => "도메인의 메일 서비스를 삭제할 수 없음: %1",
    'cmd_domains__unable_delete_anonymous_ftp' => "도메인의 익명 FTP 계정을 삭제할 수 없음: %1",
    'cmd_domains__unable_update_dom_param' => "도메인 매개 변수를 업데이트할 수 없음: %1.",
    'cmd_domains__unable_rename_client_exist' => "도메인 관리자의 사용자 이름이 이미 사용 중입니다.",
    'cmd_hosting__hst_type_is_not_physical_hst' => "호스팅 유형이 실제가 아닙니다.",
    'cmd_hosting__unable_create_user' => "%2 사용자를 만들 수 없음: %1",
    'cmd_hosting__unable_define_ip_addr_for_name_based_virtual_hosts' => "이름 기반 가상 호스트의 IP 주소를 정의할 수 없음: %1",
    'cmd_hosting__unable_del_old_hst' => "이전에 설정한 호스팅을 삭제할 수 없음: %1",
    'cmd_hosting__unable_del_protected_directory' => "보호된 디렉터리를 삭제할 수 없음: %1.",
    'cmd_hosting__unable_del_web_user' => "웹 사용자를 삭제할 수 없음: %1",
    'cmd_hosting__unable_make/update_virtual_host' => "가상 호스트를 만들거나 업데이트할 수 없음: %1",
    'cmd_hosting__unable_make_frame_forward_hst' => "프레임 전달 호스팅을 설정할 수 없음.",
    'cmd_hosting__unable_rebuild_ftp_config' => "proftpd 구성 파일을 다시 빌드할 수 없음: %1.",
    'cmd_hosting__unable_set_up_ssl' => "SSL/TLS를 설정할 수 없음: %1.",
    'cmd_hosting__unable_unprotect_ssl_directory' => "SSL/TLS 디렉터리에서 보호를 제거할 수 없음: %1",
    'cmd_hosting__unable_update_dest_url' => "대상 URL %1을(를) 업데이트할 수 없음",
    'cmd_hosting__unable_update_dns_zone_for_dom_unable_exec_util' => "도메인에 대한 DNS 영역을 업데이트할 수 없음: 유틸리티 실행 실패.",
    'cmd_hosting__unable_update_ftp_passwd' => "%1의 FTP 암호를 업데이트할 수 없습니다.",
    'cmd_hosting__unable_update_user' => "%2사용자를 업데이트할 수 없음: %1",
    'cmd_hosting__unknown_hst_type' => "알 수 없는 호스팅 유형.",
    'cmd_hosting__you_not_have_permission_del_hst' => "호스팅 서비스를 중단할 권한이 없습니다.",
    'cmd_mail__autoresponder__not_configured' => "이 메일 계정에 대한 자동 회신이 구성되지 않았습니다.",
    'cmd_mail__addr_already_used_in_mail_redirect' => "메일 전달에 %1 주소가 이미 사용 중입니다.",
    'cmd_mail__alias_already_exists' => "별칭이 이미 있습니다.",
    'cmd_mail__autoresp_id_and_mailname_id_not_match' => "자동 회신 ID와 메일 계정 ID가 일치하지 않습니다.",
    'cmd_mail__autoresp_id_is_undefined' => "자동 회신 ID가 정의되지 않았습니다.",
    'cmd_mail__mail_alias_already_exists_in_mail_name' => "%1 메일 계정에 대해 이러한 이름을 가진 메일 별칭이 이미 있습니다.",
    'cmd_mail__mail_name_already_exists_in_maillists' => "이 메일링 리스트에 %1 메일 계정이 이미 구독되어 있습니다.",
    'cmd_mail__mail_name_alredy_exist_in_dom' => "이 도메인에 %1 메일 계정이 이미 있습니다.",
    'cmd_mail__mail_name_not_exist' => "메일 계정이 없습니다.",
    'cmd_mail__mail_name_passwd_part' => "암호의 일부로 메일 계정 이름이 포함될 수 없습니다.",
    'cmd_mail__maillist_already_exist_in_this_dom' => "이 도메인에 %1 메일링 리스트가 이미 있습니다.",
    'cmd_mail__mailname_already_exist_in_mg' => "메일 그룹에 %1 메일 계정이 이미 있습니다.",
    'cmd_mail__mailname_already_exist_in_this_dom' => "이 도메인에 %1 메일 계정이 이미 있습니다.",
    'cmd_mail__mailname_already_exists' => "메일 계정이 이미 있습니다.",
    'cmd_mail__mailname_is_invalid' => "%1의 메일 계정 이름이 유효하지 않습니다.",
    'cmd_mail__mailname_unable_update' => "메일 계정 속성을 업데이트할 수 없음:",
    'cmd_mail__max_autoresp_reached_for_this_dom' => "이 도메인의 최대 자동 회신 수에 도달했습니다.",
    'cmd_mail__max_mail_groups_num_has_been_reached_for_this_dom' => "이 도메인의 최대 메일 그룹 수에 도달했습니다.",
    'cmd_mail__max_num_of_redirects_has_been_reached_for_this_dom' => "이 도메인의 최대 전달자 수에 도달했습니다.",
    'cmd_mail__max_postboxes_num_has_been_reached' => "최대 사서함 수에 도달했습니다.",
    'cmd_mail__no_members_specified' => "지정된 구성원이 없음.",
    'cmd_mail__the_passwd_is_too_simple_choose_another' => "암호가 너무 단순합니다. 다른 암호를 선택하십시오.",
    'cmd_mail__this_addr_already_exist_in_mg_or_mn' => "이 이메일 주소는 이미 사용 중입니다.",
    'cmd_mail__unable_define_autoresp_id' => "%1의 자동 회신 ID를 정의할 수 없음.",
    'cmd_mail__unable_update_mail_for_dom' => "도메인의 메일 서비스 설정을 변경하지 못했습니다. %1",
    'cmd_mail__unable_del_mail_for_dom' => "%1 도메인에서 메일 서비스를 제거할 수 없음.",
    'cmd_mail__unable_del_mail_redirection' => "메일 전달 서비스 %1을(를) 제거할 수 없습니다.",
    'cmd_mail__unable_remove_autoresp' => "자동 회신을 제거할 수 없음: %1",
    'cmd_mail__unable_remove_mail_group_members' => "메일 그룹 구성원을 제거할 수 없음: %1",
    'cmd_mail__unable_turn_off_mail_group' => "메일 그룹의 사용을 해제할 수 없음: %1",
    'cmd_mail__unable_update_mail_redirect' => "메일 전달 서비스 %1을(를) 다시 구성할 수 없습니다.",
    'cmd_mail__uploaded_file_is_too_big' => "업로드된 파일 크기가 너무 큽니다.",
    'cmd_mail__additionally' => "추가 사항:",
    'cmd_pd__invalid_login' => "잘못된 사용자 이름.",
    'cmd_pd__this_user_already_exist' => "이러한 사용자가 이미 있습니다.",
    'cmd_pd__unable_define_hst_type' => "호스팅 유형을 정의할 수 없음.",
    'cmd_pd__unable_upd_pd_usr' => "보호된 디렉터리 사용자 속성을 업데이트할 수 없음: %1.",
    'cmd_pd__user_is_undefined' => "사용자가 정의되지 않았습니다.",
    'cmd_server__no_enough_free_disk_space' => "디스크 공간 부족.",
    'cmd_server__old_passwd_is_incorrect_please_try_again' => "이전 암호가 틀립니다. 다시 시도하십시오.",
    'cmd_web_usr__max_web_users_reached_for_this_dom' => "이 도메인의 최대 웹 사용자 제한에 도달했습니다.",
    'cmd_web_usr__unable_create_user' => "시스템 사용자를 만들 수 없음: %1",
    'cmd_web_usr__unable_define_max_web_users_limit' => "최대 웹 사용자 제한을 정의할 수 없음: %1",
    'cmd_web_usr__user_already_exists' => "사용자가 이미 있습니다.",
    'cmd_web_usr__web_user_name_is_invalid' => "%1의 웹 사용자 이름은 유효하지 않습니다.",
    'cmd_web_usr__web_user_not_exist' => "웹 사용자가 없습니다.",
    'common_func__exec_bad_argument' => "exec 인수에는 인용 기호가 포함될 수 없습니다.",
    '__eol' => '줄 바꿈',
    'eol__binary_file' => '이진 파일의 줄 바꿈 스타일을 변경할 수 없습니다.',
    'comp_info__header' => '구성 요소',
    'comp_info__comp_name' => "구성 요소 이름",
    'comp_info__comp_disabled' => '꺼짐',
    'comp_info__comp_active' => '활성',
    'comp_info__comp_not_configured' => '구성되지 않음',
    'comp_info__comp_not_started' => '시작되지 않음. 구성 요소 설정을 확인하십시오.',
    'comp_info__comp_version' => "구성 요소 버전",
    'comp_info__integration_error' => "통합 오류",
    'comp_info__title' => "Plesk 구성 요소",
    'comp_info__service_name' => "서비스",
    'comp_info__last_updated' => '(마지막 업데이트 날짜: %1)',
    'cp_access_admin_deny' => "주소 '%1'의 관리자 액세스는 현재 적용된 IP 액세스 제한 정책에 따라 제한됩니다.",
    'create_domain_warn__' => "도메인 만들기 중 다음 예외가 발생했습니다.",
    'create_domain__client_select' => '다음에 대한 도메인을 만들 고객 선택',

    'dashboard__nav_button_name' => "홈",
    'dalias__list_title' => '도메인의 도메인 별칭 %1',
    'dalias__list_legend' => '도메인 별칭',
    'dalias__list_header' => '도메인 별칭',
    'dalias__list_status' => 'S',
    'dalias__list_name' => '도메인 별칭 이름',
    'dalias__list_ascii_name' => 'ASCII 형식',
    'dalias__remove_title' => '도메인 %1의 다음 도메인 별칭이 제거됨:',
    'dalias__select_domain_aliases_to_remove' => '제거할 도메인 별칭을 선택합니다.',
    'dalias__mail_turn_on_failed' => '메일 서비스를 설정할 수 없음: %1',
    'dalias__web_turn_on_failed' => '웹 서비스를 설정할 수 없음: %1',
    'db_usr_edit__db_usr_name_old' => "이전 데이터베이스 사용자 이름",
    'database_server_edit_form__cannot_infer_type' => '제공된 데이터로 연결 수단을 유추할 수 없습니다. 데이터베이스 서버 호스트 이름을 "127.0.0.1"로 지정하여 제공된 포트로 TCP/IP를 통해 연결하거나, 포트 필드를 비워두어 Unix 소켓 "%1"을 사용하십시오.',
    'database_server_edit_form__duplicate' => '이 호스트 주소와 포트 번호 조합을 가진 데이터베이스 서버가 이미 등록되어 있습니다.',
    'database_server_edit_form__host_is_invalid' => '지정한 호스트 이름이 유효하지 않습니다.',
    'database_server_edit_form__port_is_invalid' => '지정한 포트 번호가 유효하지 않습니다.',
    'database_server_error__consult_admin' => '서버 관리자에게 연락하십시오.',
    'database_server_error__last__connection_failed' => '네트워크 문제로 인해 이 데이터베이스 서버를 제어하려는 마지막 시도가 실패했습니다.',
    'database_server_error__last__permission_denied' => '제공된 계정에 관리 권한이 없기 때문에 이 데이터베이스 서버를 제어하려는 마지막 시도가 실패했습니다.',
    'database_server_error__last__credentials_not_set' => "유효한 관리자의 사용자 이름과 암호를 지정하지 않았기 때문에 이 서버에 연결하려는 직전 시도가 실패했습니다.",
    'database_server_error__last__other_error' => '이 데이터베이스 서버를 제어하려는 마지막 시도에 실패했습니다.',
    'database_server_error__real__connection_failed' => '네트워크 문제로 인해 데이터베이스 서버에 대한 연결에 실패함:',
    'database_server_error__real__permission_denied' => '제공한 계정에 관리 권한이 없기 때문에 데이터베이스 서버에 대한 연결에 실패함:',
    'database_server_error__real__duplicate_object' => '이름 충돌로 인해 데이터베이스 서버에 대한 연결에 실패함:',
    'database_server_error__real__unacceptable_name' => '유효하지 않은 개체 이름으로 인해 데이터베이스 서버에 대한 연결에 실패함:',
    'database_server_error__real__unacceptable_password' => '허용되지 않는 암호로 인해 데이터베이스 서버에 대한 연결에 실패함:',
    'database_server_error__real__credentials_not_set' => "유효한 관리자의 사용자 이름과 암호를 지정하지 않았기 때문에 Plesk가 데이터베이스 서버에 연결할 수 없습니다.",
    'database_server_error__real__other_error' => '데이터베이스 서버 연결 실패:',
    'database_server_error__test__connection_failed' => '네트워크 문제로 인해 데이터베이스 서버에 대한 테스트 연결에 실패함:',
    'database_server_error__test__permission_denied' => '제공한 계정에 관리 권한이 없기 때문에 데이터베이스 서버에 대한 테스트 연결에 실패함:',
    'database_server_error__test__duplicate_object' => '이름 충돌로 인해 데이터베이스 서버에 대한 테스트 연결에 실패함:',
    'database_server_error__test__unacceptable_name' => '유효하지 않은 개체 이름으로 인해 데이터베이스 서버에 대한 테스트 연결에 실패함:',
    'database_server_error__test__unacceptable_password' => '허용되지 않는 암호로 인해 데이터베이스 서버에 대한 테스트 연결에 실패함:',
    'database_server_error__test__credentials_not_set' => "유효한 관리자의 사용자 이름과 암호를 지정하지 않았기 때문에 이 서버에 대한 테스트 연결이 실패했습니다.",
    'database_server_error__test__other_error' => '데이터베이스 서버에 대한 테스트 연결에 실패함:',

    'db__create_new_db' => "새 데이터베이스 추가",
    'db__db_add' => "데이터베이스 추가",
    'db__db_for_dom' => "웹 사이트의 데이터베이스 %1",
    'db__db_id_undefined' => "데이터베이스 ID가 정의되지 않았습니다.",
    'db__db_name' => "데이터베이스 이름",
    'db__db_not_exist' => "데이터베이스가 없습니다.",
    'db__db_type' => "유형",
    'db__db_server' => "데이터베이스 서버",
    'db_server_not_exist' => "데이터베이스 서버가 없습니다.",
    'db__db_user_not_exist' => "데이터베이스 사용자가 없습니다.",
    'db__domain_not_exist' => "도메인이 없습니다.",
    'db__enter_db_name' => "새 데이터베이스 이름을 입력합니다.",
    'db__invalid_db_id' => "데이터베이스 식별자가 유효하지 않습니다.",
    'db__invalid_db_name' => "데이터베이스 이름이 유효하지 않습니다. 데이터베이스 이름에는 라틴 알파벳 기호, 숫자, 밑줄 또는 대시만 포함될 수 있습니다. 길이는 63자를 초과할 수 없습니다.",
    'db__max_db_reached_for_dom' => "이 도메인의 데이터베이스 수 제한에 도달했습니다.",
    'db__max_mssql_db_reached_for_dom' => "이 도메인의 Microsoft SQL Server 데이터베이스 수 제한에 도달했습니다.",
    'db__postgres_not_connect_for_admin' => "PostgreSQL에 연결할 수 없음. 서버 관리 페이지에서 PostgreSQL 지원을 설정합니다.",
    'db__postgres_not_connect_for_client' => "PostgreSQL에 연결할 수 없음. 시스템 관리자에게 도움을 요청하십시오.",
    'db__remove_db_on_domain' => "웹 사이트 %2(%1 고객이 소유)의 다음 데이터베이스가 제거됨:",
    'db__remove_db_on_domain_of_cl' => "도메인 %2(%1 고객이 소유)의 다음 데이터베이스가 제거됨:",
    'db__remove_db_linked_resource' => '이 데이터베이스는 웹 응용 프로그램이 사용 중입니다. 이 웹 응용 프로그램을 제거한 후에만 데이터베이스를 제거할 수 있습니다.',
    'db__remove_db_users' => "다음 사용자(데이터베이스: %3, 웹 사이트:%2, 소유 고객:%1)가 제거됨:",
    'db__remove_db_users_of_cl' => "다음 사용자(데이터베이스: %3, 웹 사이트:%2, 소유 고객:%1)가 제거됨:",
    'db__select_db_for_remove' => "제거할 데이터베이스를 선택합니다.",
    'db__select_db_users_for_remove' => "제거할 데이터베이스 사용자를 선택합니다.",
    'db__unable_create_db_user' => "데이터베이스 사용자를 만들 수 없음: %1",
    'db__unable_define_db_name' => "데이터베이스 이름을 정의할 수 없음: %1",
    'db__unable_define_db_user' => "데이터베이스 사용자를 정의할 수 없음: %1",
    'db__unable_define_db_users' => "데이터베이스 사용자를 정의할 수 없음: %1",
    'db__unable_select_dom_name' => "도메인 이름을 선택할 수 없음: %1",
    'db_edit__db_for_dom' => "다음 도메인의 %1 데이터베이스 사용자: %2",
    'db_edit__invalid_db_name' => "데이터베이스 이름이 유효하지 않습니다.",
    'db_edit__no_users' => "이 데이터베이스에 대한 자격 증명을 가진 사용자가 없습니다.",
    'db_edit__unable_define_db_usrs' => "데이터베이스 사용자를 정의할 수 없음: %1",
    'db_edit__unable_select_db_usr' => "데이터베이스 사용자를 선택할 수 없음.",
    'db_edit__db_user_password_for_' => "데이터베이스 사용자로 로그인할 암호를 입력하십시오. %1",
    'db_list__tab_title_db_type' => "T",
    'db_usr_edit__add_db_usr' => "데이터베이스 사용자 추가",
    'db_usr_edit__db_usr_name' => "데이터베이스 사용자 이름",
    'db_usr_edit__edit_db_usr' => "데이터베이스 사용자 계정의 자격 증명 설정",
    'db_usr_edit__for_db' => "%1 데이터베이스에서",
    'db_usr_edit__not_create_pass' => "이 작업으로 인해 암호가 없는 데이터베이스 사용자 계정이 만들어집니다.\n암호를 할당하지 않고 사용자를 만드시겠습니까?",
    'dbuser__only_one_user_can_be_default' => "한 명의 사용자만 기본값으로 설정할 수 있습니다.",
    'db_server__cannot_delete_default' => "기본 데이터베이스 서버를 삭제할 수 없습니다.",
    'db_server__cannot_delete_local' => "로컬 데이터베이스 서버를 삭제할 수 없습니다.",
    'db_server__cannot_delete_used' => '데이터베이스 또는 데이터베이스 사용자가 호스팅되고 있는 데이터베이스 서버는 삭제할 수 없습니다.',
    'demo__disabled_in_demo' => "이 작업은 데모 버전에서 지원되지 않습니다.",
    'defaultcomponents__title' => "기본 구성 요소 선택",
    'defaultcomponents__select_default' => "기본 %1 구성 요소 선택",//to check
    'defaultcomponents__not_installed' => "(설치되지 않음)",
    'defaultcomponents__not_configured' => "(구성되지 않음)", // to check
    'defaultcomponents__not_opted_to_install_support_files' => "일부 서비스 범주에 잘못된 선택 내용이 포함되어 있거나 선택된 항목이 없습니다.",
    'defaultcomponents__depends_on' => "(%1 필요)",
    'defaultcomponents__parameters' => "다음의 매개 변수 %1",
    'component_name__antivirus' => "안티 바이러스",
    'component_name__database' => "SQL Server",
    'component_name__sqladmin' => "MySQL Webadmin",
    'component_name__sqladminmysql' => "MySQL Webadmin",
    'component_name__dnsserver' => "DNS 서버",
    'component_name__firewall' => "방화벽",
    'component_name__ftpserver' => "FTP 서버",
    'component_name__java' => "Java",
    'component_name__mailserver' => "메일 서버",
    'component_name__local_mailserver' => "로컬 메일 서버",
    'component_name__psa' => "Plesk",
    'component_name__script' => "웹 스크립팅",
    'component_name__spamfilter' => "스팸 필터",
    'component_name__stats' => "웹 통계",
    'component_name__stunnel' => "SSL/TLS 래퍼",
    'component_name__webmail' => "웹 메일",
    'component_name__webpublish' => "웹 게시",
    'component_name__webserver' => "웹 서버",
    'dns__dns_record_invalid_values' => '잘못된 DNS 레코드 값을 지정했습니다. %1: %2',
    'dns__dns_record_not_found' => 'DNS 레코드 찾을 수 없음',
    'dns__dns_zone_invalid_values' => '잘못된 DNS 영역 매개 변수가 지정되었습니다.',

    'dns__soa_mname_title' => '기본 이름 서버',
    'dns__soa_mname_legend' => '이름 서버',
    'dns__soa_mname_autoselect' => '(자동 선택)',

    'dns__dns_zone_off_remove_title' => "다음 리소스 레코드가 %1 영역에서 제거됨:",
    'dns__dns_zone_master_remove_title' => "DNS 영역에서 리소스 레코드를 제거하는 중 %1",
    'dns__dns_zone_slave_remove_title' => "%1에 대한 다음 기본 이름 서버 레코드가 제거됨:",
    'dns_add__param_ttl' => "TTL",
    'dns_add__enter_spf' => '레코드 문자열 입력',
    'dns_add__is_spf_syntax' => 'SPF 레코드',
    'dns_add__spf_value_is_invalid' => "SPF 레코드 값이 잘못되었습니다. 값이 'v=spf'로 시작해야 합니다.",
    'dns__dns_zone_status' => "DNS 영역 상태.",
    'dns__dns_zone_template' => 'DNS 설정',
    'dns__invalid_ip_address' => "새 기본 DNS 서버의 IP 주소가 유효하지 않거나 비어 있습니다.",
    'dns__ip_address' => "IP 주소",
    'dns__master_dns_type' => "은(는) 기본 DNS 서버입니다.",
    'dns__masters' => "기본 DNS 서버",
    'dns__soa_minimum_too_large' => '부정적인 응답을 3시간 이상 캐싱하는 것은 권장되지 않습니다.',
    'dns__select_masters_to_remove' => "제거할 기본 DNS 서버를 선택합니다.",
    'dns__select_template_record_to_remove' => '제거할 DNS 템플릿 레코드를 선택합니다.',
    'dns__nameservers_for_domain' => "도메인의 이름 서버",
    'dns__remove_dns_zone_of_domain__' => "도메인에서 DNS 레코드 제거 %1",
    'dns__remove_dns_zone_template__' => "템플릿에서 다음 DNS 레코드가 제거됨:",
    'dns__remove_this_dns_record?' => "이 DNS 레코드를 제거하시겠습니까?",
    'dns__restore_default' => "템플릿을 기준으로 DNS 영역을 복원하는 중",
    'dns__restore_default_confirm' => "DNS 영역을 복원하면 현재 DNS 영역 구성이 취소됩니다. 그래도 진행할까요?",
    'dns__restore_default_error' => "DNS 영역 복원 중 오류:",
    'dns__slave_dns_type' => "은(는) 보조 DNS 서버입니다.",
    'dns__subdomain_dns_rec_removed' => "A 레코드가 하위 도메인 영역 %1에서 제거되었습니다.",
    'dns__zone_switched_off_no_ns' => "영역에 있어야 하는 NS 레코드 %1이(가) 없으므로 영역이 해제되었습니다. 영역에 레코드를 추가하려면 ‘레코드 추가’ 버튼을 클릭하십시오.",
    'dns__cant_switch_on_no_ns' => "영역에 있어야 하는 NS 레코드 %1이(가) 없으므로 영역을 설정할 수 없습니다. 영역에 레코드를 추가하려면 ‘레코드 추가’ 버튼을 클릭하십시오.",
    'dns__unable_activate/deactivate_dns' => "DNS를 활성화/비활성화할 수 없음: %1",
    'dns__unable_add_dns_master_duplicate_entry' => "기본 DNS 서버를 추가할 수 없음: 중복 항목.",
    'dns__unable_add_dns_master_local_ip' => "기본 DNS 서버에 IP 주소를 추가할 수 없음: 원격 서버에 이 레코드를 생성해야 합니다.",
    'dns__unable_define_dns_record' => "DNS 레코드를 정의할 수 없음: %1",
    'dns__unable_get_dns_template_status' => "DNS 템플릿 상태를 검색할 수 없음.",
    'dns__unable_remove_dns_rec' => "DNS 레코드를 제거할 수 없음: %1",
    'dns__warnings__' => "DNS 영역 수정의 결과:",
    'dns__you_not_have_perm_manage_dns' => "이 도메인에 대한 DNS 영역을 관리하기 위한 권한이 없습니다.",
    'dns__cant_create_record_with_server_ip' => "이 Plesk 관리 서버의 IP 주소와 일치하므로 이 IP를 추가할 수 없습니다.",

    'dns__tabs_acl' => "영역 전송",
    'dns__acl_add_network_legend' => "네트워크 추가",
    'dns__acl_add_ip_legend' => "IP 주소 추가",
    'dns__acl_network_not_allowed' => "이 네트워크 주소는 Windows의 DNS에 허용하지 않았습니다.",
    'dns__acl_enter_ip_address_with_mask' => "IP 주소/마스크",
    'dns__acl_enter_ip_address' => "IP 주소",
    'dns__acl_list_network_legend' => "DNS 영역의 사본을 가져오도록 허용된 네트워크",
    'dns__acl_list_ip_legend' => "DNS 영역의 사본을 가져오도록 허용된 IP 주소",
    'bt_dns_acl_add_network' => "네트워크 추가",
    'bt_dns_acl_add_ip' => "IP 주소 추가",

    'dns_add__add_rec_for_zone' => "다음 영역에 대한 %1 추가:%2",
    'dns_add__canonical_dom_name_is_invalid' => "정식 도메인 이름은 유효하지 않습니다.",
    'dns_add__enter_canonical_name' => "정식 이름",
    'dns_add__enter_dom_name' => "도메인 이름",
    'dns_add__enter_ip_address' => "IP 주소",
    'dns_add__enter_ip_mask' => "IP 주소 및 네트워크 마스크",
    'dns_add__enter_mail_domain' => "메일 도메인",
    'dns_add__enter_mail_exchanger' => "메일 Exchange Server",
    'dns_add__enter_nameserver' => "이름 서버",
    'dns_add__enter_txt_record' => "TXT 레코드",
    'dns_add__enter_service_name' => "서비스 이름",
    'dns_add__hint_service_name' => "예시: SIP (밑줄 문자 없이)",
    'dns_add__enter_protocol' => "프로토콜",
    'dns_add__hint_protocol_name' => "예시: TCP (밑줄 문자 없이)",
    'dns_add__protocol_tcp' => "TCP",
    'dns_add__protocol_udp' => "UDP",
    'dns_add__enter_srv_priority' => "우선 순위",
    'dns_add__specify_weight_of_service' => "우선 순위가 같은 레코드의 상대 가중치",
    'dns_add__enter_target_host' => "대상 호스트",
    'dns_add__hint_target_host' => "예: example.com",
    'dns_add__enter_target_port' => "대상 포트",
    'dns_add__caa_tag' => "태그",
    'dns_add__caa_value' => "값",
    'dns_add-invalid-A_ip' => "IP 주소가 유효하지 않습니다.",
    'dns_add-invalid-AAAA_ip' => "IP 주소가 유효하지 않습니다.",
    'dns_add-invalid-PTR_ip_mask' => "유효하지 않은 IP 주소/넷마스크 쌍.",
    'dns_add-invalid-SRV_service_name' => "잘못된 서비스 이름",
    'dns_add-invalid-SRV_protocol_name' => "잘못된 프로토콜",
    'dns_add-invalid-SRV_target_port' => "잘못된 대상 포트",

    'dns_add__invalid_ip' => "IP 주소가 유효하지 않습니다.",
    'dns_add__low' => "낮음",
    'dns_add__mail_dom_name_is_invalid' => "메일 도메인 이름이 유효하지 않습니다.",
    'dns_add__nameserver_is_invalid' => "이름 서버가 유효하지 않습니다.",
    'dns_add__record' => "%1 레코드",
    'dns_add__select_prefer_for_mail_exchange_server' => "메일 Exchange Server에 대한 우선 순위 지정",
    'dns_add__unable_insert_new_dns_rec' => "새 DNS 레코드를 삽입할 수 없음: %1",
    'dns_add__very_high' => "매우 높음",
    'dom_ctrl__allowed' => "허용됨",
    'dom_ctrl__db' => "MySQL 데이터베이스",
    'dom_ctrl__mssql_db' => "MS SQL 데이터베이스",
    'dom_ctrl__disk_space' => "디스크 공간",
    'dom_ctrl__dom_adm' => "%1 도메인 소속: %2",
    'dom_ctrl__dom_cl' => "도메인 %1",
    'dom_ctrl__domain_has_forwarding_with_undefined_fwd_url' => "정의되지 않은 전달 URL을 사용하여 도메인의 전달이 설정되었습니다.",
    'dom_ctrl__domain_has_frame_forwarding' => "도메인에 URL로의 프레임 전달이 있습니다. %1",
    'dom_ctrl__domain_has_no_hosting' => "도메인의 호스팅이 구성되지 않았습니다.",
    'dom_ctrl__domain_has_physical_hosting' => "이 도메인에 대해 웹 호스팅이 IP 주소에 구성되어 있습니다. %1",
    'dom_ctrl__domain_has_standard_forwarding' => "도메인에 URL로의 표준 전달이 있습니다. %1",
    'dom_ctrl__maillists' => "메일링 리스트",
    'dom_ctrl__mboxes' => "사서함",
    'dom_ctrl__mg' => "메일 전달",
    'dom_ctrl__resource_name' => "리소스",
    'dom_ctrl__resp' => "자동 회신",
    'dom_ctrl__subdom' => "하위 도메인",
    'dom_ctrl__dom_aliases' => "도메인 별칭",
    'dom_ctrl__traffic' => "트래픽",
    'dom_ctrl__unable_activate/deactivate_dom' => "도메인을 활성화/비활성화할 수 없음: %1",
    'dom_ctrl__used' => "사용 중",
    // end of serge part

    // maverick part
    'dom_ctrl__wu' => "웹 사용자",
    'dom_pref__bounce_with_phrase' => "메시지를 포함하여 바운스",
    'dom_pref__bounce' => "바운스",
    'dom_pref__catch_addr' => "주소로 전달",
    'dom_pref__reject' => '거부',
    'dom_pref__confirm_domain_removing' => "도메인 방문자에게 도메인 이름 변경 사항을 알려주십시오. 도메인의 이름을 바꾸시겠습니까?",
    'dom_pref__db_inconsystency' => "데이터베이스 일관성 없음.",
    'dom_pref__dbs' => "데이터베이스",
    'dom_pref__delete_traffic_stat' => "웹 및 트래픽 통계 유지",
    'dom_pref__delete_traffic_stat_older' => "웹 및 트래픽 통계 유지",
    'dom_pref__dom_level_name_conflict' => "도메인 관리자의 사용자 이름이 고객 중 한 명의 사용자 이름과 충돌합니다.",
    'dom_pref__invalid_disk_space_limit' => "유효하지 않은 디스크 공간 제한. 최대 값: %1",
    'dom_pref__invalid_expiration_date_limit' => "유효하지 않은 유효 기간.",
    'dom_pref__invalid_max_traffic_limit' => "잘못된 트래픽 제한. 최대 값: %1",
    'dom_pref__limits_of_dom' => "도메인 제한 %1",
    'dom_pref__mail_grps' => "메일 그룹",
    'dom_pref__mail_nonexistent_user' => "존재하지 않는 사용자에의 메일",
    'dom_pref__mail_redirs' => "메일 전달자",
    'dom_pref__mail_resps' => "메일 자동 회신",
    'dom_pref__max_limit_is_invalid' => "%1 은(는) 유효하지 않습니다.",
    'dom_pref__max_num_of_%objects_is_invalid' => "%1의 최대 수가 유효하지 않습니다.",
    'dom_pref__new_limit_less_currently_used' => "%1: 요청됨 - %2, 현재 사용 중 - %3",
    'dom_pref__older_that' => "대상",
    'dom_pref__postboxes' => "사서함",
    'dom_pref__preferences_of_dom' => "도메인 설정 %1",
    'dom_pref__redirect_to_itself' => "도메인 자체에 전달이 설정됩니다.",
    'dom_pref__traffic_logging_period_couldnt_be_lower' => "도메인 트래픽 통계 유지 시간을 서버에 정의된 전체 값보다 적게 지정했습니다(%1개월). 통계 유지 기간이 서버에 대한 기본값과 동일하게 설정되었습니다(%1개월).",
    'dom_pref__unable_add_www_prefix_in_dom' => "도메인에 www 접두사를 추가할 수 없음: %1",
    'dom_pref__unable_define_physical_hst_param' => "실제 호스팅 매개 변수를 정의할 수 없음: %1",
    'dom_pref__unable_rename_domain' => "%1 도메인 이름을 바꿀 수 없습니다: %2",
    'dom_pref__unable_set_up_mbox_quota' => "이 도메인에 대한 사서함 할당량을 설정할 수 없음: %1",
    'dom_pref__unable_set_up_web_user_script' => "웹 사용자에 대한 스크립트를 설정할 수 없음: %1",
    'dom_pref__unlimited' => "제한 없음",
    'dom_pref__web_usrs' => "웹 사용자",
    'dom_pref__you_already_have_%object' => "이미 다음이 포함되어 있음: %1",
    'cu_domain__error_unable_update_ftp_users' => '도메인 FTP 사용자를 업데이트할 수 없습니다: %1',
    'dom_cli__warning_ignore_quota' => '경고: 옵션 -hard_quota가 무시됨: 하드 디스크 할당량이 지원되지 않습니다.',
    'dom_user_client_login_exist' => "도메인 %1 에 대해 도메인 관리자 Plesk의 접속을 허가할 수 없습니다: 로그인명이 이미 사용되고 있습니다.",
    'domain__unable_to_turn_on_service' => "%1 서비스가 사용되도록 설정할 수 없음.",
    'domains__change_the_status_of_domain?' => "%1 도메인의 상태를 변경하시겠습니까?",
    'domains__client_info_hiding_traffic' => "도메인 %1, 활성 도메인 %2, 사용 중인 디스크 공간 %3",
    'domains__unable_to_change_client_status' => "고객 계정 상태를 변경할 수 없음: %1",
    'domains__unable_update_apache_settings' => "Apache 설정을 업데이트할 수 없음.",
    'domains__you_do_not_have_permissions_to_delete_domains' => "도메인을 삭제할 권한이 없습니다.",
    'domains__you_want_change_the_status_of_the_cl??' => "고객 계정의 상태를 변경하시겠습니까?",
    'domains__you_want_change_the_cp_access_of_the_cl??' => "이 작업을 수행하시겠습니까?",
    'domains_list__unable_remove_doms' => "도메인을 제거할 수 없음: %1",
    'domaintrafficlist_header_of_domain__' => "도메인의 트래픽 %1",

    'domain_aliases_remove__select_domain_aliases_for_remove' => '제거할 도메인 별칭을 선택합니다.',
    'domain_aliases_remove__title' => '도메인 별칭 제거',
    'domain_aliases__max_aliases_reached_for_dom' => "이 도메인의 별칭 수 제한에 도달했습니다.",
    'domain_edit__edit_title' => '도메인 별칭 이름 편집',
    'domain_alias_edit__type' => '도메인 별칭 유형',
    'domain_aliases__list_header' => '도메인 별칭',
    'domain_aliases__name' => '이름',
    'domain_aliases__type' => '유형',
    'domain_aliases__type_full' => 'Web+FTP+메일',
    'domain_aliases__type_web_ftp' => 'Web+FTP',
    'domain_aliases__page_title' => '도메인 별칭',
    'domain_aliases__legend' => '도메인 별칭',
    'domain_alias__domain_exists' => '이러한 이름을 가진 도메인이 이미 있음',
    'domain_alias__subdomain_exists' => '이러한 이름을 가진 하위 도메인이 이미 있음',
    'domain_alias__dns_record_exists' => '입력한 도메인 별칭 이름을 가진 DNS 레코드가 이미 있음',
    'domain_alias__domain_alias_exists' => "이러한 이름을 가진 도메인 별칭이 이미 있음",
    'domain_alias__invalid_type_full' => '메일 서버가 도메인 별칭을 지원하지 않습니다.',
    'domain_alias__redirect_exists' => '자신으로의 리디렉션이 탐지되었습니다.',

    'ds__anonymous_ftp' => "익명 FTP",
    'drweb__pagetitle' => '안티 바이러스 설정',
    'drweb__drweb' => '안티 바이러스 메일 검사',
    'drweb__drweb_direction' => '메일에서 바이러스 검사 중',
    'drweb__drweb_direction_off' => '바이러스 검사 안 함',
    'drweb__drweb_direction_any' => '수신 메일 및 발신 메일',
    'drweb__drweb_direction_from' => '발신 메일만',
    'drweb__drweb_direction_to' => '수신 메일만',
    'drweb__disable_reason_key' => '라이센스 키가 안티 바이러스를 지원하지 않습니다.',
    'drweb__disable_reason_perm' => '안티 바이러스를 관리할 권한이 없습니다.',
    'drweb__disable_reason_install' => '안티 바이러스가 설치되지 않았습니다.',
    'drweb__filters' => '안티 바이러스 필터',
    'ds__dns' => "DNS 영역",
    'ds__mail' => "메일",
    'dsr__of_client_title' => "다음에 대한 도메인 요약 보고서 %1",
    'dsr__report_has_been_sent_email' => "보고서가 다음 이메일로 발송됨: %1",
    'dsr__title' => "도메인 요약 보고서",
    'dumps_list__deletion_page_title' => "%1 도메인의 다음 백업 파일이 제거됨:",
    'dumps_list__dumpfile_is_invalid' => "파일 %1은(는) 올바른 도메인 백업 파일이 아닙니다.",
    'dumps_list__page_title' => "백업 파일 스토리지",
    'dumps_upload__page_title' => "스토리지에 백업 파일 업로드 중",
    'dumps_list__repository_is_not_exist' => "백업 파일 스토리지가 없습니다.",
    'dumps_list__unable_to_remove' => "백업 파일을 제거할 수 없음: %1",
    'dumps_list__dumpfile_can_conflict' => "지정한 파일 이름이 %1과(와) 충돌합니다. 다른 파일 이름을 지정하십시오.",
    'dusr_ed__allow_dl_usr_access' => "도메인 관리자가 다음에 액세스하도록 허용",
    'dusr_ed__information' => "도메인 %1의 관리자 속성",
    'dusr_ed__locale' => "도메인 관리자 언어",
    'dusr_ed__skin' => "도메인 관리자의 인터페이스 스킨",
    'dusr_ed__personal_information' => '개인 정보',
    'ess__error' => "오류",
    'example__' => "예: %1",
    'extras__allow_certificate_purchasing' => "인증서 구입 허용",
    'extras__allow_domain_registration' => "도메인 등록 허용",
    'extras__allow_extras' => "추가 서비스 허용",
    'extras__buy_new_key' => "현재 라이센스로는 이 개체를 수정할 수 없습니다.",
    'extras__setup_services' => "추가 서비스 설정",

    'ruleeditform__error' => '방화벽 규칙을 업데이트할 수 없습니다.',
    'ruleeditform__name_is_required' => '규칙 이름을 지정합니다.',
    'ruleeditform__profiles_is_required' => '하나 이상의 프로필을 선택합니다.',
    'ruleeditform__invalid_ip' => '잘못된 IP 주소 또는 네트워크를 지정했습니다.',
    'ruleeditform__invalid_port' => '지정된 포트가 잘못되었습니다. 가능한 값은 1000 또는 1000-1051입니다.',

    'filemanager__items' => '%1 디렉터리의 항목',
    'filemanager__items_paging' => '%1 디렉터리의 항목',

    'get_password__encrypted_password' => "암호 정보를 보낼 수 없음: 암호가 암호화된 형태로 저장되었습니다.",
    'get_password__mail_error' => "%1 이메일로 암호를 보내려는 중에 오류 발생: %2",
    'get_password__mail_ok' => "암호가 이메일로 발송됨: %1",
    'get_password__message' => "시스템 액세스를 위한 사용자 이름: %1\n암호: %2",
    'get_password__subject' => "시스템 액세스를 위한 암호",
    'groups__available' => "사용 가능한 메일 그룹",
    'groups__groups_for_mailname' => "%1의 메일 계정이 구독된 메일 그룹",
    'groups__member_of' => "다음 메일 그룹의 구성원",
    'help__help_area' => "도움말 영역.",
    'hst_def__auth_disabled' => "금지됨",
    'hst_def__auth_enabled' => "허용됨",
    'hst_def__change_curr_dns_ip' => "A DNS 레코드의 현재 IP 주소가 변경됩니다.",
    'hst_def__cr_hosting_ip_dns_ip_not_equiv' => "A DNS 레코드의 어떤 IP 주소도 생성 중인 호스팅 계정에 할당된 IP 주소와 일치하지 않습니다.",
    'hst_def__dest_url' => "대상 URL",
    'hst_def__disk_quota' => "디스크 할당량",
    'hst_def__disk_space_limit_exceed_incoming_quota' => "설정하려고 하는 디스크 공간 제한이 익명 FTP의 들어오는 디렉터리의 디스크 공간 제한에 의해 초과됩니다. 익명 FTP의 들어오는 디렉터리의 디스크 공간 제한은 도메인 디스크 공간 제한을 초과하지 않아야 합니다.",
    'hst_def__frame_forwarding_definition' => "도메인에 대한 프레임 전달 할당 %1",
    'hst_def__ftpuser_for_hst_not_exist_in_system' => "경고: FTP 사용자 %1이(가) 호스팅 계정 설정에 사용되지만 시스템에 없습니다.",
    'hst_def__hst_type_is_not_defined' => "호스팅 유형이 정의되지 않음",
    'hst_def__ip_based' => "IP 기반",
    'hst_def__name_based_power_anonymous_ftp_down' => "이 호스팅 계정을 공유 IP 주소로 전송하면 이 도메인에서 익명 FTP 서비스를 사용할 수 없게 됩니다. 그래도 진행할까요?",
    'hst_def__password_is_invalid_password_syntax' => "암호가 유효하지 않습니다.\n암호에 작은따옴표 및 자국 문자를 사용하지 마십시오.\n암호 길이는 5 ~ 14자여야 합니다. 암호에는 사용자 이름이 포함되지 않아야 합니다.",
    'hst_def__shell' => "구독 시스템 사용자로 서버 셸에 SSH 액세스",
    'hst_def__shell_windows' => "구독 시스템 사용자로 서버에 원격 데스크톱 액세스",
    'hst_def__standard_forwarding_definition' => "도메인에 대한 표준 전달 할당 %1",
    'hst_def__title_name_based' => "이름 기반",
    'hst_def__unable_create/update_physic_hst' => "실제 호스팅을 만들기/업데이트할 수 없음: %1",
    'hst_def__unable_create/update_std_fwd' => "표준 전달을 만들기/업데이트할 수 없음: %1",
    'hst_def__unable_create_forwarding_myself' => "도메인 자체로의 전달을 만들 수 없음.",
    'hst_def__unable_turn_same_ssl_while_ssl_off' => "SSL/TLS 콘텐츠와 SSL/TLS가 아닌 콘텐츠 저장을 위해 단일 디렉터리 사용을 허용할 수 없음: SSL/TLS 지원이 해제되었습니다.",
    'hst_def__unable_turn_on_ssl_cert_not_defined' => "SSL/TLS 지원을 사용할 수 없음: 설치된 SSL/TLS 인증서가 없습니다.",
    'hst_def__url_is_invalid' => "URL이 유효하지 않습니다.",
    'hst_def__virtual_host_access' => "도메인에 대한 가상 호스트 액세스 %1",
    'hst_def__virtual_host_uses_non_existed_ip_address' => "경고. 이 가상 호스트는 호스팅을 위해 존재하지 않는 IP 주소를 사용 중입니다.",
    'hst_def__you_have_no_ips' => "사용 가능한 IP 주소가 없으며 이름 기반 호스팅 만들기가 허용되지 않습니다.",
    'hst_sel__header' => "이 서버에서 웹 사이트를 호스팅하려면 실제 호스팅 옵션을 선택하십시오.\n 다른 컴퓨터에서 사이트로의 도메인 전달을 설정하려면 프레임 전달 또는 표준 전달 옵션을 선택하십시오.\n 표준 전달의 경우, 사용자가 사이트로 리디렉션되고 사용자의 브라우저에 실제 사이트의 URL이 표시되므로 사용자가 리디렉션되었다는 사실을 알 수 있습니다. 프레임 전달의 경우, 사용자가 사이트로 리디렉션되지만 사이트가 실제로 다른 위치에 있다는 사실을 알지 못합니다.",
    'hst_sel__physical_hst' => "실제 호스팅",
    'hst_sel__select_hst_type' => "도메인에 대한 호스팅 유형 선택",
    'hst_sel__select_hst_type_warning' => "도메인에 대한 호스팅 유형 선택",
    'hst_sel__hosting_exists' => "이 도메인에 대해 이미 구성되었기 때문에 호스팅을 만들 수 없음. 호스팅 관리 페이지로 리디렉션됩니다.",
    'hst_sel__standard_frw' => "표준 전달",
    'hst_sel__frame_frw' => "프레임 전달",
    '__frame_frw' => "프레임 전달",
    '__hosting_exists' => "이 도메인에 대해 이미 구성되었기 때문에 호스팅을 만들 수 없음. 호스팅 관리 페이지로 리디렉션됩니다.",
    '__choose_hst_type' => "필요한 호스팅 유형을 선택합니다.",
    '__no_hst_conf' => "도메인에 대해 구성된 호스팅이 없습니다.",
    '__physical_hst' => "실제 호스팅",
    '__select_hst_type' => "도메인에 대한 호스팅 유형 선택",
    '__standard_frw' => "표준 전달",
    '__warning' => "경고! 이전에 설정한 모든 매개 변수가 취소됩니다. 호스팅 유형을 변경하시겠습니까?",
    'i_cl_off' => "고객이 비활성 상태입니다.",
    'i_cl_off_by_admin' => "고객 계정이 서버 관리자에 의해 일시 중단되었습니다.",
    'i_cl_off_expired' => "고객 계정이 만료되었습니다.",
    'i_cl_on' => "고객이 활성 상태입니다.",

    'icf__title' => '인터넷 연결 방화벽',
    'icf__if_legend' => '인터페이스',
    'icf__mode' => '모드',

    'invalid_value' => '값이 잘못됨',

    'ip_addr__already_exists' => "%1의 IP 주소는 이미 있습니다.",
    'ip_addr__cant_add' => "%1의 IP는 존재하지 않거나 다른 고객의 IP 풀에 포함되어 있습니다.",
    'ip_alias__interface' => "인터페이스",
    'ip_alias__invalid_ip_nm_bsd_vrt_hsts' => "%1 이름 기반 가상 호스팅에 대한 IP 주소가 유효하지 않습니다.",
    'ip_alias__invalid_ip_or_netmask' => "유효하지 않은 IP 주소/넷마스크 쌍.",
    'ip_alias__orig_ip_can_not_be_deleted' => "IP 주소 %1은(는) 원래 서버 IP이므로 제거할 수 없습니다.",
    'ip_alias__ip_is_invalid' => "%1 IP 주소가 유효하지 않습니다.",
    'ip_alias__ip_mask_is_invalid' => "%1 IP 마스크가 유효하지 않습니다.",
    'ip_alias__ip_not_exist' => "%1의 IP 주소가 존재하지 않습니다.",
    'ip_alias__ip_address_and_mask' => 'IP 주소 및 서브넷 마스크',
    'ip_alias__mask' => "서브넷 마스크",
    'ip_alias__remove_selected_ip_aliases?' => "선택한 IP 주소를 제거하시겠습니까?",
    'ip_alias__select_ip' => "목록에서 제거할 하나 이상의 IP 주소를 선택합니다.",
    'ip_alias__this_ip_used_for_domain' => "(%1) 이 IP 주소는 %2 도메인에 사용 중입니다.",
    'ip_alias__this_ip_used_for_nm_bsd_vrt_hsts' => "(%1) 이 IP 주소는 이름 기반 가상 호스트에 사용 중입니다.",
    'ip_alias__unable_add_ip' => "IP를 추가할 수 없음: %1",
    'ip_alias__unable_remove_ip' => "IP를 제거할 수 없음: %1",
    'ip_ctrl__anonymous_ftp_exists_in_domain' => "도메인 '%1'의 익명 FTP를 사용하지 못하게 되므로 IP 주소 유형을 공유로 변경할 수 없습니다.",
    'ip_ctrl__ip_addr' => "%2 인터페이스의 IP 주소 %1",
    'ip_ctrl__ip_exists_many_pools' => "IP 유형을 변경할 수 없습니다. 이 IP 주소는 동시에 여러 사용자의 풀에 속합니다.",
    'ip_ctrl__ssl_cert' => "SSL/TLS 인증서",
    'limit__date_in_past' => "유효 기간이 유효하지 않습니다. %1은(는) 과거입니다.",
    'limit__enter_date' => "날짜 입력",
    'limit__max_db' => "데이터베이스",
    'limit__name_disk_space' => "디스크 공간",
    'limit__name_max_box' => "사서함",
    'limit__name_max_db' => "MySQL 데이터베이스",
    'limit__name_max_dom' => "도메인",
    'limit__name_max_maillists' => "메일링 리스트",
    'limit__name_max_subdom' => "하위 도메인",
    'limit__name_max_traffic' => "트래픽",
    'limit__name_max_wu' => "웹 사용자",
    'limit__name_mbox_quota' => "사서함 할당량",
    'limit__name_max_mn' => "메일 계정",
    'limit__name_max_cl' => '클라이언트',
    'limit__name_total_mboxes_quota' => "총 사서함 할당량",
    'limit__name_mysql_dbase_space' => "MySQL 데이터베이스 공간",
    'limit__name_mssql_dbase_space' => "MSSQL 데이터베이스 공간",
    'limit__name_expiration' => '만료 날짜',

    'locale_upload__unable_to_install' => '언어 팩 파일을 설치할 수 없습니다.',
    'locale_upload__wrong_package' => '업로드한 파일에 이 Plesk 버전에 적합한 언어 팩이 없습니다.',
    'locale_upload__wrong_locale' => '업로드한 파일에 올바른 언어 팩이 없습니다.',

    'ma__create_title' => '다음에 대한 메일 별칭 만들기 %1',
    'ma__edit_title' => "메일 별칭 편집 %1",
    'ma__enter_new_alias' => "새 별칭을 입력합니다.",
    'ma__invalid_alias' => "유효하지 않은 메일 별칭.",
    'ma__mail_aliases_mailname' => "메일 계정에 대한 메일 별칭 %1",
    'ma__mailname_does_not_exist' => "메일 계정이 없습니다.",
    'ma__select_ma_for_remove' => "제거할 메일 별칭을 선택합니다.",
    'ma__unable_to_add_new_ma' => "메일 별칭을 추가할 수 없음: %1",

    'mail_queue__not_allowed_by_license_key' => '라이센스 키에서 메일 대기열 관리를 허용하지 않습니다.',
    'maillist__' => "메일링 리스트 %1",
    'maillist__already_exists' => "메일링 리스트가 이미 있습니다.",
    'maillist__mail_alias_already_exists_in_this_domain' => "이 도메인에 %1의 메일 별칭이 이미 있습니다.",
    'maillists__' => "메일링 리스트 %1",
    'maillists__limit_cl_max_maillists' => "고객에 대한 메일링 리스트 수 제한에 도달했습니다(제한: %1, 사용: %2)",
    'maillists__limit_dom_max_maillists' => "도메인에 대한 메일링 리스트 수 제한에 도달했습니다.",
    'maillists__list' => "메일링 리스트",
    'maillists__mailman_not_installed_or_conf' => "\nMailman Server 확장 프로그램이 현재 서버에 설치되거나 구성되지\n않았습니다. 서버 관리자에게 연락하여 Mailman Server 확장 프로그램을 설치하거나 구성하도록 요청하십시오.",
    'maillists__status' => "메일링 리스트 서비스가 사용 중입니다.",
    'maillists__unable_to_delete__' => "메일링 리스트를 삭제할 수 없음: %1",
    'maillists__disabled_text' => 'Mailman 메일링 리스트 서버 구성 요소가 설치되지 않았거나 구성되지 않아서 메일링 리스를 관리할 수 없습니다.',
    'maillist_member__already_exists' => '메일링 리스트 구독자가 이미 있습니다.',
    'maillist_member__not_exists' => '메일링 리스트에 이러한 사용자가 없습니다.',
    'mailserver_switching_warning' => "경고!\n\n메일 서버 변경은 초기 설정할 때만 가능하며, 서버가 이미 사용 중인 경우 설정 및 사서함 내용 손실 등 문제가 발생하고, 전환할 대상 서버가 이미 구성된 경우 다양한 충돌이 발생합니다.\n이 서버가 현재 사용 중이고 다른 서버로 전환하려는 경우, 고객이 메일을 다운로드하고 저장할 수 있도록 고객에게 작업 내용을 알려줄 수 있습니다.",
    'manager__access_denied' => "액세스 거부됨: %1",
    'manager__admin' => "관리자",
    'manager__client' => '고객',
    'manager__domain' => "도메인",
    'manager__domain_cl_limit_exceeding' => "이 고객 계정에 대한 도메인 수 제한에 도달했습니다.",
    'manager__domain_is_not_yours' => "%1 도메인은 귀하에게 속하지 않습니다.",
    'manager__domain_key_limit_exceeding' => "라이센스 키에 의해 정의된 도메인 만들기 제한에 도달했습니다.",
    'manager__no_perm_to_call' => "%1에게 전화할 권한이 없습니다.",
    'manager__no_perm_to_create_domains' => "도메인을 만들 권한이 없습니다.",
    'manager__no_perm_to_modify_domain' => "%1 도메인을 수정할 권한이 없습니다.",
    'manager__no_perm_to_modify_domains' => "도메인을 수정할 권한이 없습니다.",
    'manager__no_perm_to_remove_domain' => "%1 도메인을 제거할 권한이 없습니다.",
    'manager__no_perm_to_remove_domains' => "도메인을 제거할 권한이 없습니다.",
    'manager__node_doesnt_exist' => "%1 존재하지 않습니다.",
    'manager__user_disabled' => "계정이 일시 중단되었습니다. 시스템을 작동시킬 수 없습니다.",
    'mail_quota_unsupported' => "메일 서버에서 지원되지 않음",
    'mbox_quota_unsupported' => "메일 서버에서 지원되지 않음",
    'mn__create_title' => "메일 계정 만들기",
    'mn__edit_title' => "설정",
    'mn__files_list_title' => "첨부 파일",
    'mn__files_remove' => "첨부 파일 리포지토리에서 파일을 제거합니다. 이 파일을 자동 회신에서 사용 중일 수 있습니다. 파일이 이를 사용하는 리포지토리와 자동 회신 모두에서 제거됩니다.",
    'mn__files_select_for_remove' => "제거할 파일을 선택합니다.",
    'mn__mail_alias_form' => "메일 별칭 폼",
    'mn__mail_aliases_list' => "메일 별칭",
    'mn__mailbox' => "사서함 관리",
    'mn__unable_define_mn' => "메일 계정을 설정할 수 없음: %1",
    'mn__unable_remove_mbox_quota' => "사서함 할당량을 제거할 수 없음: %1",
    'mn__upload_file' => "파일 업로드",
    'mn_edit__attach_filename_changed' => '이름에 ASCII가 아닌 문자가 포함되어 있어서 업로드된 파일 %1이(가) %2(으)로 이름이 변경되었습니다.',
    'mn_edit__add_mail_group_members_or_turn_off_box' => "메일 그룹을 사용하기 전에 메일 그룹 구성원을 추가해야 합니다.",
    'mn_edit__add_resp_or_turn_off_box' => "자동 회신을 추가하거나 자동 회신 확인란의 선택을 취소해야 합니다.",
    'mn_edit__attachments' => "첨부 파일",
    'mn_edit__dom_quota_less_then_quota' => "이 사서함의 크기는 이 도메인에서 사서함에 할당된 디스크 공간 제한을 초과하지 않아야 합니다.",
    'mn_edit__enter_external_rcpnt_email' => "외부 메일 그룹 구성원의 이메일을 입력합니다.",
    'mn_edit__enter_mail_redir_or_turn_off_box' => "메일을 전달할 주소를 입력하거나 확인란을 선택 해제하십시오.",
    'mn_edit__ext_rcpnt_email_invalid' => "외부 수신자의 이메일 주소가 유효하지 않습니다.",
    'mn_edit__file_exists' => "파일이 있습니다. 덮어쓸까요?",
    'mn_edit__files_deld_from_repository' => "이 파일들은 리포지토리와 이를 포함한 자동 회신에서 삭제됩니다. 계속 하시겠습니까?",
    'mn_edit__mail_name' => "메일 계정",
    'mn_edit__mail_name_invalid' => "메일 계정 이름이 유효하지 않습니다.",
    'mn_edit__mail_redir' => "메일 전달자",
    'mn_edit__mail_redir_add' => "메일 그룹 구성원 추가",
    'mn_edit__mail_resps' => "메일 자동 회신",
    'mn_edit__mailbox' => "사서함",
    'mn_edit__enable_mailbox' => "사서함",
    'mn_edit__mailgroup' => "메일 그룹",
    'mn_edit__mailgroup_addresses' => "메일 그룹 구성원",
    'mn_edit__mailgroup_disabled' => "메일 계정이 이미 추가된 경우에만 사용 가능합니다.",
    'mn_edit__max_dom_quota' => "도메인에 대한 기본값(%1)",
    'mn_edit__mbox_quota_invalid' => "잘못된 사서함 크기를 지정함.",
    'mn_edit__new_resp_name' => "새 자동 회신 이름",
    'mn_edit__no_autoresponders' => "자동 회신 서비스를 설정/해제하기 전에 하나 이상의 자동 회신을 추가해야 합니다.",
    'mn_edit__no_file_sel' => "선택한 파일 없음.",
    'mn_edit__no_mail_addresses' => "이메일 주소를 지정하거나 선택하지 않았습니다.",
    'mn_edit__none' => "없음",
    'mn_edit__not_create_pass' => "이로 인해 이 계정에 대한 암호가 생성되지 않습니다.\n암호가 없으면 사용자가 메일을 보고 보낼 수 없습니다.",
    'mn_edit__redir_email_invalid' => "전달 주소가 유효하지 않습니다.",
    'mn_edit__redirect_addr' => "전달 주소",
    'mn_edit__remove_autoresp?' => "자동 회신을 제거하시겠습니까?",
    'mn_edit__remove_rcpnts?' => "이들 수신자를 제거하시겠습니까?",
    'mn_edit__repository' => "리포지토리",
    'mn_edit__resps_attach' => "자동 회신 첨부 파일",
    'mn_edit__select_rcpnt_from_list' => "목록에서 제거할 하나 이상의 수신자를 선택합니다.",
    'mn_edit__select_registered_users' => "등록된 사용자 선택",
    'mn_edit__selected_postbox_have_not_setup_passwd' => "사서함이 있는 것으로 선택했지만 그에 대한 암호를 설정하지 않았습니다.",
    'mn_edit__unable_act_deact_mail_group' => "메일 그룹을 활성화 또는 비활성화할 수 없음: %1",
    'mn_edit__unable_act_deact_mail_redir' => "메일 전달을 활성화 또는 비활성화할 수 없음: %1",
    'mn_edit__unable_act_deact_postbox' => "사서함을 활성화 또는 비활성화할 수 없음: %1",
    'mn_edit__unable_act_deact_resp' => "자동 회신을 활성화 또는 비활성화할 수 없음: %1",
    'mn_edit__unable_add_attach' => "첨부 파일을 추가할 수 없음: %1",
    'mn_edit__unable_add_mail_group_member' => "메일 그룹 구성원을 추가할 수 없음: %1",
    'mn_edit__unable_add_resp' => "자동 회신을 추가할 수 없음: %1",
    'mn_edit__unable_change_mail_name' => "메일 계정 이름을 변경할 수 없음: %1",
    'mn_edit__unable_deactivate_mail_group' => "메일 그룹을 비활성화할 수 없음: %1",
    'mn_edit__unable_deactivate_resp' => "메일 자동 회신을 비활성화할 수 없음: %1",
    'mn_edit__unable_define_resp_id' => "자동 회신 ID를 정의할 수 없음: %1",
    'mn_edit__unable_remove_attach' => "첨부 파일을 제거할 수 없음: %1",
    'mn_edit__unable_remove_autoresp' => "자동 회신을 제거할 수 없음: %1",
    'mn_edit__unable_remove_mail_group_member' => "메일 그룹 구성원을 제거할 수 없음: %1",
    'mn_edit__wrong_way' => '이 메일 계정에는 사서함이 없거나 메일 전달자의 사용이 설정되지 않았기 때문에 %1(으)로 주소 지정된 메시지는 배달되지 않습니다.',
    'mn_edit__mailbox_is_disabled_mail_not_removed' => '주소 %1의 사서함이 해제되었습니다. 사서함에 있는 메시지는 제거되지 않았지만 IMAP 또는 POP3 프로토콜을 통해 메시지를 검색할 수 없습니다.',
    'mn_list__mail_names_for_domain' => "도메인 아래의 메일 계정 %1",
    'mn_list__sa_cannot_unable' => "스팸 필터링을 설정할 수 없습니다.",
    'mn_list__tab_cp_access' => "L",
    'mn_list__tab_title_client' => '고객',
    'mn_list__tab_title_domain' => '도메인',
    'mn_list__tab_title_autoresp' => "A",
    'mn_list__tab_title_box' => "B",
    'mn_list__tab_title_group' => "G",
    'mn_list__tab_title_name' => "이름",
    'mn_list__tab_title_redirect' => "F",
    'mn_list__tab_title_spamfilter' => "S",
    'mn_list__tab_title_virusfilter' => 'AV',
    'mn_list__tab_title_drweb' => 'AV',
    'mn_list__unable_remove_mns' => "메일 계정을 제거할 수 없음: %1",
    'module_upload__module_was_installed' => '이 모듈은 이미 설치되어 있습니다. 이 모듈의 새로운 버전을 설치하려면 우선, Plesk에서 해당 모듈을 삭제한 후, 새로운 버전으로 다시 인스톨을 실행해 주세요.',
    'module_upload__unable_to_install' => '모듈 패키지 파일을 설치할 수 없습니다.',
    'module_upload__wrong_package' => '업로드된 파일이 지원되는 모듈 패키지가 아닙니다.',
    'module_upload__wrong_module' => '업로드된 파일에 모듈 패키지가 없습니다.',

    'news_articles_title' => 'Plesk 뉴스',
    'notification_text__invalid_subject_length' => "유효하지 않은 알림 제목 길이. 1 ~ 255자여야 합니다.",
    'notification_text__invalid_text_length' => "유효하지 않은 알림 텍스트 길이. 1 ~ 65533문자 범위여야 합니다.",
    'notification_text__subject' => "알림 제목",
    'notification_text__text' => "알림 텍스트",
    'notification_text__title' => "알림 편집",
    'notification_text__unable_set_text' => "알림 텍스트를 수정할 수 없음:",

    'odbc__cant_add_dsn' => "DSN %1을(를) 추가할 수 없음: %2",
    'odbc__cant_connect' => "정의된 설정을 사용하여 데이터 소스에 연결할 수 없음. 서버가 다음을 반환함: %1",
    'odbc__cant_delete_dsn' => "DSN %1을(를) 삭제할 수 없음: %2",
    'odbc__cant_get_drivers_info' => "드라이버 정보를 가져올 수 없습니다.",
    'odbc__cant_get_drivers' => "ODBC 드라이버 목록을 검색할 수 없음: %1",
    'odbc__cant_open_info_file' => "ODBC 드라이버 정보가 있는 파일을 열 수 없습니다.",
    'odbc__cant_parse_string' => "연결 문자열을 구문 분석할 수 없음.",
    'odbc__driver_not_set' => "드라이버가 설정되지 않았습니다.",
    'odbc__driver_or_name_not_set' => "ODBC 연결 이름 또는 드라이버가 설정되지 않았습니다.",
    'odbc__dsn_already_exists' => "이 이름(%1)을 가진 DSN이 시스템에 이미 있습니다.",
    'odbc__dsn_not_exists' => "이 DSN이 존재하지 않습니다.",
    'odbc__enter_dsn_name' => "DSN 이름 입력",
    'odbc__invalid_dsn_name' => "ODBC 연결 이름에 잘못된 구문(%1): 영숫자 기호만 사용하십시오.",
    'odbc__no_such_driver' => "이러한 이름을 가진 ODBC 드라이버(%1)는 지원되지 않습니다.",
    'odbc__unknown_driver' => "알 수 없는 드라이버 이름(%1).",
    'odbc_dsn_system' => "시스템 DSN",

    'pb__aliases' => "별칭",
    'pb__anonftp' => "익명 FTP",
    'pb__autoinstaller_releases' => '업데이트 프로그램',
    'pb__cert' => "인증서",
    'pb__cl_pool' => "IP 주소",
    'pb__cl_pool_ctrl' => "%1",
    'pb__cl_pref' => "설정",
    'pb__cl_rpt' => "보고서",
    'pb__cl_rpt_list' => "사용자 지정",
    'pb__cl_templates' => "고객 템플릿",
    'pb__cl_traffic' => "트래픽",
    'pb__cl_traffic_history' => "트래픽 기록",
    'pb__cl_traffic_of' => "트래픽 %1",
    'pb__client' => "%1",
    'pb__clients' => "고객",
    'pb__comp_info' => "서버 구성 요소",
    'pb__common_acl' => 'ACL 전송 허용',
    'pb__cp_access' => "액세스",
    'pb__crontab' => "스케줄러",
    'pb__scheduler' => "스케줄러",
    'pb__custom_buttons' => "사용자 지정 버튼",
    'pb__databases_db' => '데이터베이스',
    'pb__sqlservers_db' => 'SQL Server',//to check
    'pb__db' => "데이터베이스",
    'pb__db_edit' => "%1",
    'pb__db_server_edit' => '%1',
    'pb__db_servers' => '데이터베이스 서버',
    'pb__dl_usr_ed' => "도메인 관리자",
    'pb__dns' => "DNS",
    'pb__dns_template' => "DNS",
    'pb__dns_t' => "DNS",
    'pb__dom_ctrl' => "%1",
    'pb__dom_lim' => "도메인 제한",
    'pb__dom_pref' => "설정",
    'pb__dom_sum_report' => "도메인 요약 보고서",
    'pb__dom_templates' => "도메인 템플릿",
    'pb__dom_traffic' => "트래픽 %1",
    'pb__domains' => "도메인",
    'pb__domain_aliases' => '도메인 별칭',
    'pb__dumps_list' => "백업 파일 스토리지",
    'pb__forwarding_setup' => "전달 설정",
    'pb__filemanager' => "파일 관리자",
    'pb__ip_aliasing' => "IP 주소",
    'pb__ip_clients' => "IP 주소 제거",
    'pb__license_management' => '라이선스 정보',
    'pb__locales' => '로켈',
    'pb__log_files' => "로그 파일",
    'pb__mail' => '메일',
    'pb__mail_name_files' => "첨부 파일",
    'pb__mail_name_redirects' => "메일 전달자",
    'pb__mail_name_resp_attach_add' => "새 첨부 파일",
    'pb__mail_name_resp_edit' => "%1",
    'pb__mail_name_responders' => "메일 자동 회신",
    'pb__mail_names' => "메일",
    'pb__maillists' => "메일링 리스트",
    'pb__mimetypes' => 'MIME 유형',
    'pb__modules' => '모듈',
    'pb__modules_management' => '모듈 관리',
    'pb__notifications' => "알림",
    'pb__odbc' => "ODBC",
    'pb__phosting_setup' => "실제 호스팅 설정",
    'pb__prtd_dirs' => "보호된 디렉터리",
    'pb__prtdir_edit' => "%1",
    'pb__report' => "보고서",
    'pb__report_auto' => "다음의 배달 일정 %1",
    'pb__report_list' => "사용자 지정",
    'pb__server' => "서버",
    'pb__sessions' => "세션",
    'pb__sapp_pool' => "웹 응용 프로그램 풀",
    'pb__siteapp_install' => '웹 응용 프로그램 설치',
    'pb__site_app_pkgs' => '웹 응용 프로그램',
    'pb__site_apps' => "웹 응용 프로그램",
    'pb__additional_key_info' => '키 속성',
    'pb__additional_key_properties' => '키 속성',
    'pb__skeleton' => '가상 호스트 템플릿',
    'pb__skins' => '스킨',
    'pb__skin_info' => '%1',
    'pb__spamassassin' => "스팸 필터",
    'pb__statistics' => "통계",
    'pb__subdom_ctrl' => "%1",
    'pb__subdomains' => "하위 도메인",
    'pb__templates' => "템플릿",
    'pb__virtualdirs' => '가상 디렉터리',
    'pb__web_users' => "웹 사용자",
    'pdir__enter_dir_name' => "디렉터리 이름을 입력합니다.",
    'pdir__invalid_hst' => "호스팅 유형이 유효하지 않습니다. 호스팅 유형은 실제여야 합니다.",
    'pdir__pd_id_is_undefined' => "보호된 디렉터리 ID가 정의되지 않았습니다.",
    'pdir__pdir_exist' => "이 이름을 가진 디렉터리가 이미 보호되었습니다.",
    'pdir__pdir_not_exist' => "보호된 디렉터리가 없습니다.",
    'pdir__pdir_usr_not_exist' => "보호된 디렉터리 사용자가 없습니다.",
    'pdir__remove_pdir_usrs' => "웹 사이트 %1 아래 보호된 디렉터리 %2의 다음 사용자가 제거됨:",
    'pdir__remove_pdir_usrs_on_subdom' => "하위 도메인 %1 아래 보호된 디렉터리 %2의 다음 사용자가 제거됨:",
    'pdir__select_pdir_usrs_for_remove' => "제거할 보호된 디렉터리 사용자를 선택합니다.",
    'pdir__select_pdirs_to_remove' => "보호를 제거할 디렉터리를 선택합니다.",
    'pdir__unable_define_pdir_users' => "보호된 디렉터리 사용자를 정의할 수 없음.",
    'pdir__unable_define_pdirs_properties' => "보호된 디렉터리 속성을 설정할 수 없음: %1",
    'pdir__unable_select_dom_param' => "도메인 매개 변수를 선택할 수 없음: %1",
    'pdir_ed__create_pdir_for_domain' => "%1에 따라 보호된 디렉터리 만들기",
    'pdir_ed__create_pdir_for_subdomain' => "하위 도메인 %1 아래에 보호된 디렉터리를 만듭니다.",
    'pdir_ed__dir_already_protect' => "이 디렉터리는 이미 보호되어 있습니다.",
    'pdir_ed__head_txt' => "보호된 영역의 제목",
    'pdir_ed__invalid_login' => "잘못된 사용자 이름을 지정했습니다.",
    'pdir_ed__login_exists' => "이 사용자가 이미 있습니다. 다른 사용자 이름을 지정하십시오.",
    'pdir_ed__new_usr' => "사용자 이름",
    'pdir_ed__non_ssl' => "SSL/TLS가 아님",
    'pdir_ed__cgi_bin' => "cgi-bin",
    'pdir_ed__path' => "디렉터리 이름",
    'pdir_ed__pdir_for_domain' => "도메인 %2의 보호된 디렉터리 %1",
    'pdir_ed__pdir_for_subdomain' => "하위 도메인 %2 아래의 보호된 디렉터리 %1",
    'pdir_ed__pdir_location' => "디렉터리 위치",
    'pdir_ed__pdir_users' => "보호된 디렉터리 사용자",
    'pdir_ed__ssl' => "SSL/TLS",
    'pdir_ed__ssl_or_nonssl_should_be_checked' => "SSL/TLS 확인란과 SSL/TLS가 아닌 확인란을 하나 이상 선택해야 합니다.",
    'pdir_ed__unable_cr_pdir_usr' => "보호된 디렉터리 사용자를 만들 수 없음: %1",
    'pdir_ed__unable_create_pdir' => "보호된 디렉터리를 만들 수 없음: %1",
    'pdir_ed__unable_define_hst_type' => "호스팅 유형을 정의할 수 없음.",
    'pdir_ed__unable_update_pdir' => "보호된 디렉터리의 설정을 저장할 수 없음: %1",
    'pdir_ed__wrong_symbol_in_header' => "디렉터리 제목에 %1 문자를 사용하지 마십시오.",
    'pdir_usr_ed__create_pdir_usr_for_pd' => "보호된 디렉터리에 대한 사용자 만들기 %1",
    'pdir_usr_ed__not_create_pass' => "이로 인해 보호된 새 디렉터리 사용자에 대한 암호가 만들어지지 않습니다.\n암호가 없으면 사용자가 로그인할 수 없습니다.",
    'pdir_usr_ed__pass_for_pdir_usr' => "보호된 디렉터리 사용자 %1에 대한 암호",
    'pdir_usr_ed__unable_select_pdir_usr' => "보호된 디렉터리 사용자를 선택할 수 없음: %1",
    'pdir_usrs_list__unable_define_pdir_usrs' => "보호된 디렉터리 사용자를 정의할 수 없음: %1",
    'pdir_usrs_list__unable_remove_pd_usrs' => "보호된 디렉터리 사용자를 제거할 수 없음: %1",
    'phosting__anonftp_encrypt' => 'FTP 사용자의 암호가 암호되어서 디렉터리 /plesk-stat/webstat/를 보호하는 데 사용할 수 없습니다. FTP 암호를 다시 입력하거나 암호로 보호된 디렉터리 "\'/plesk-stat/webstat/\'를 통해 액세스 가능 옵션을 선택 해제하십시오.',
    'phosting__hosting_and_dns_ip_difference_warning' => "도메인 이름 %%domain_name%%이(가) IP 주소 %%dns_ip_address%%(으)로 확인됩니다. 웹 사이트에 IP 주소 %%hosting_ip_address%%가 할당되었습니다. 웹 브라우저에서 도메인 이름으로 참조할 때 웹 사이트가 열리지 않으면 DNS 관리 화면(도메인 > 도메인 이름 > DNS)으로 이동한 후 A 리소스 레코드 속성을 변경하십시오: IP 주소 %%hosting_ip_address%%을(를) 도메인 이름 %%domain_name%%(으)로 할당하십시오.",
    'phosting__ip_change_warning' => "IP 주소가 변경됨. 해당 변경 사항이 도메인의 DNS 영역에 이미 적용되었습니다.",
    'phosting__other_hosting_exists_on_ip' => "이 IP 주소가 하나 또는 여러 개의 호스팅 계정에서 사용 중이기 때문에 인증서를 변경할 수 없습니다.",
    'phosting__unable_to_change_certificate' => "인증서를 설치할 수 없음: %1",
    'phosting__unable_to_change_ip_address' => "IP 주소를 변경할 수 없음: %1",
    'phosting__unable_to_set_cert' => "SSL/TLS 인증서를 설정할 수 없습니다. %1",
    'phosting__unable_update' => "호스팅 설정을 업데이트할 수 없음: %1",
    'phosting__unable_manage' => "호스팅을 관리할 수 없음: %1",
    'phosting__failed_to_add_logs_fail2ban' => "도메인의 로그를 추적하도록 fail2ban을 구성할 수 없습니다. 다음에 fail2ban 서비스가 다시 시작되면 로그가 자동으로 추적됩니다.\n%1",

    'picker_acl_record__tittle' => 'ACL 레코드 선택',
    'picker_autoresponder__title' => '자동 회신 선택',
    'picker_black_list__domain_name' => '도메인 이름 선택',
    'picker_certificate' => 'SSL/TLS 인증서 선택',

    'picker_dns_zone_template__title' => '리소스 레코드 선택',
    'picker_domain__title' => '웹 사이트 선택',
    'picker_domain_alias__title' => '도메인 별칭 선택',
    'picker_resource_record__title' => '리소스 레코드 선택',
    'picker_disabled_resource_record__title' => '이름 서버 선택',
    'picker_ip_address__title' => 'IP 주소 선택',
    'picker_ip_address_clients__title' => '이 IP 주소를 사용하는 고객 선택',
    'picker_mail_queue' => '이메일 메시지 선택',
    'picker_site_application__title' => '웹 응용 프로그램 선택',
    'picker_subdomain__title' => '하위 도메인 선택',
    'picker_web_user__title' => '웹 사용자 선택',
    'picker_custom_button__title' => '사용자 지정 버튼 선택',
    'picker_license_key__title' => "라이센스 키 선택",
    'picker_spamfilter_address__title' => '스팸 필터 주소 선택',
    'picker_white_list__networks' => '네트워크 선택',

    'plesk_key__action_logs' => "Plesk 사용자로 실행된 액션 로그",
    'plesk_key__app_vault' => "응용 프로그램 저장소",
    'plesk_key__backup' => "백업 및 복원 기능",
    'plesk_key__client_templs' => "서비스 플랜 관리",
    'plesk_key__clients' => "사용자 계정(리셀러 및 고객)",
    'plesk_key__resellers_only' => "사용자 계정(대리점)",
    'plesk_key__customers_only' => "사용자 계정(고객)",
    'plesk_key__domains' => "도메인",
    'plesk_key__domain_aliases' => "도메인 별칭",
    'plesk_key__manage_dashboard' => '홈 페이지 사용자 지정',
    'plesk_key__drweb' => "안티 바이러스 관리",
    'plesk_key__event_manager' => "이벤트 관리자",
    'plesk_key__expirations' => "계정 만료 날짜 관리",
    'plesk_key__group_ops' => "다수의 개체를 한꺼번에 수정",
    'plesk_key__expiration' => "키 만료 날짜",
    'plesk_key__edition_name' => "Plesk 버전",
    'plesk_key__key_number' => "키 번호",
    'plesk_key__languages' => "언어 팩",
    'plesk_key__mailnames' => "메일 계정",
    'plesk_key__migration_manager' => "Migration & Transfer Manager",
    'plesk_key__mssql' => "Microsoft SQL Server 지원",
    'plesk_key__myplesk_func' => "SSL/TLS 인증서 및 도메인 등록 서비스 구입을 위한 링크",
    'plesk_key__myplesk_server_id' => "MPC 슬레이브 서버 식별자",
    'plesk_key__notifications' => "알림 관리",
    'plesk_key__postgresql' => "PostgreSQL 데이터베이스 서버 지원",
    'plesk_key__qmail_queue' => '메일 대기열 관리',
    'plesk_key__remote_db' => '원격 데이터베이스 호스팅',
    'plesk_key__slave_servers' => "슬레이브 서버",
    'plesk_key__spamassassin' => "스팸 필터 관리",
    'plesk_key__subdomains' => "하위 도메인 관리",
    'plesk_key__sys_access' => "서버 액세스 관리",
    'plesk_key__traffic_reports' => "트래픽 사용 보고서",
    'plesk_key__tts' => "지원 센터",
    'plesk_key__virtuozzo' => "Virtuozzo 컨테이너에만 유효",
    'plesk_key__webusers' => "웹 사용자",
    'plesk_key__license_update_date' => '다음 라이센스 키 업데이트',
    'plesk_key__autoinstaller_config' => '업데이트 프로그램 설정 관리',
    'plesk_key__check_wrong' => "라이센스 키가 유효하지 않습니다. Plesk를 사용하려면 올바른 새 라이센스 키를 얻어 설치하십시오.",
    'plesk_key__upload_check_wrong' => '업로드된 라이센스 키가 유효하지 않습니다.',
    'plesk_key__revert_check_wrong' => '이전에 설치된 라이센스 키가 유효하지 않습니다.',
    'plesk_key__update_check_wrong' => '업데이트된 라이센스 키가 유효하지 않습니다.',
    'plesk_key__viruozzo_only_key' => '이 라이센스 키는 Virtuozzo 컨테이너에서 작동 중인 Plesk에만 사용할 수 있습니다.',
    'plesk_key__ip_ranges_exceeded' => '라이센스가 부여된 이 Plesk 사본을 사용할 수 있는 IP 주소: %2. 다음 IP 주소는 라이센스가 허용하지 않음: %1.', //%1 not allowed addresses list separated by comma, %2 allowed IP addresses list separated by comma
    'plesk_key__limits_exceeded' => '현재 사용 중인 리소스의 양이 라이센스에 정의된 제한을 초과합니다.',
    'plesk_key__wp-toolkit-deluxe' => 'WP Toolkit Deluxe',
    // For the keys below: %1 limit value, %2 used value, %3 delta value
    'plesk_key__limits_exceeded_lim_dom' => '서버에서 호스팅하는 웹 사이트의 수가 라이센스에 정의된 제한을 초과합니다. 현재 %2개의 사이트 호스팅 중; 지금 라이센스로는 %1개의 사이트만 호스팅할 수 있습니다.',
    'plesk_key__limits_exceeded_lim_domain_aliases' => '서버의 도메인 별칭 수가 라이센스에 정의된 제한을 초과합니다. 도메인 별칭이 %2개 있습니다. 라이센스에서 %1개 도메인 별칭의 호스팅만 허용합니다.',
    'plesk_key__limits_exceeded_lim_cl' => 'your license allows serving only %1 customer accounts.";"서비스되는 고객 계정 수가 라이센스에 정의된 제한을 초과합니다. 현재 %2개의 고객 계정을 서비스하고 있음',
    'plesk_key__limits_exceeded_lim_mn' => 'your license allows serving only %1 e-mail accounts.";"서비스되는 이메일 계정 수가 라이센스에 정의된 제한을 초과합니다. 현재 %2개의 이메일 계정을 서비스하고 있음',
    'plesk_key__limits_exceeded_lim_wu' => '서비스되는 웹 사용자 계정 수가 라이센스에 정의된 제한을 초과합니다. 현재 %2개의 웹 사용자 계정을 서비스하고 있음; 지금 라이센스로는 %1개의 웹 사용자 계정만 서비스할 수 있습니다.',
    'plesk_key__limits_exceeded_MLS' => '현재 설치된 언어 팩 수가 라이센스에 정의된 제한을 초과합니다. 현재 %2개의 언어 팩이 설치되어 있음; 지금 라이센스로는 %1개의 언어 팩만 설치할 수 있습니다.',
    'plesk_key__wrong_version' => '다른 Plesk 버전에 대해 만들어진 라이센스 키를 사용하려고 합니다. Plesk 영업 담당자에게 문의하여 적합한 라이센스 키를 얻으십시오.',
    'plesk_key__other_product' => '다른 제품에 대해 만들어진 라이센스 키를 사용하려고 합니다. Plesk 영업 담당자에게 문의하여 적합한 라이센스 키를 얻으십시오.',
    'plesk_key__invalid_machine_id_trial' => '현재 라이센스는 이미 다른 Plesk 서버에 활성화되어 있어 유효하지 않습니다. 계속 Plesk를 사용하려면 신규 라이선스를 설치하거나 보유한 활성화 코드를 입력하여 현재 라이선스를 다시 설치하십시오.',
    'plesk_key__invalid_machine_id_retail' => '귀하의 현재 라이센스는 이미 다른 Plesk 서버에서 활성화되어 유효하지 않습니다. Plesk EULA(https://www.plesk.com/legal/)는 하나의 라이센스를 두 개 이상의 서버에서 동시에 사용하는 것을 금합니다. 계속 Plesk를 사용하려면 새로운 라이센스를 설치하거나 현재 라이선스의 활성화 코드를 입력하여 현재 라이선스를 다시 설치하십시오. 활성화 코드는 라이센스 구매 시 이메일로 발송되었습니다. <br>활성화 코드를 찾을 수 없다면 Plesk 360을 사용하여 되찾을 수 있습니다. 라이센스 구매 시 사용한 이메일 주소로 https://platform360.io/에 로그인한 후, "Licenses" 탭으로 이동하면 본인 라이선스의 활성화 코드를 확인할 수 있습니다. 또는 온라인 양식(https://www.plesk.com/licensing-and-purchase-support/)을 사용하여 Plesk 라이센스 및 구매 지원팀에 문의할 수 있습니다. 양식의 "How can we help you?" 섹션에 반드시 본인의 라이선스 번호를 언급하여 주십시오.',
    'plesk_key__limits_exceeded_error' => '라이센스 키를 설치할 수 없음: 현재 리소스 사용량이 업로드된 라이센스 키에 정의된 제한을 초과합니다.',
    'plesk_key__limits_exceeded_note' => '현재 리소스 사용량이 업로드된 라이센스 키에 정의된 제한을 초과합니다.',
    'plesk_key__key_file_invalid' => '업로드된 키 파일이 유효하지 않거나 라이센스 키를 포함하고 있지 않습니다.',
    'plesk_key__server_request_error' => '라이선스를 업데이트할 수 없습니다. TCP 포트 %1에서 라이선스 서버 ka.plesk.com으로의 연결이 차단되지 않았는지 확인하십시오. <a href="https://support.plesk.com/hc/en-us/articles/12388137260695" target="_blank">방법 보기</a>.',
    'key__no_key_file_in_zip' => '업로드된 .zip 파일에 키 파일이 포함되지 않았습니다.',
    'key__key_upload' => '라이센스 키 설치',
    'additional_key__prop_name' => '속성',
    'additional_key__prop_value' => '값',
    'additional_key__descr_name' => '키 이름',
    'additional_key__descr_key_number' => '키 번호',
    'additional_key__descr_key_vz' => "이 라이센스 키는 Virtuozzo 컨테이너에만 사용할 수 있습니다.",
    'additional_key__descr_key_mailboxes' => '사서함',
    'additional_key__descr_lim_date' => '만료 날짜',
    'additional_key__descr_license_update_date' => '다음 라이센스 키 업데이트',
    'additional_key__file_invalid' => '업로드된 키 파일이 유효하지 않거나 라이센스 키를 포함하고 있지 않습니다.',
    'additional_key__file_incompatible' => '업로드된 키 파일이 이 응용 프로그램에 대해 유효하지 않습니다.',
    'additional_key__expired' => '이 추가 키는 만료되었습니다.',
    'additional_key__not_exists' => '설치된 라이센스 키 없음.',
    'additional_key__viruozzo_only_key' => '이 라이센스 키는 Virtuozzo 컨테이너에 설치된 Plesk에만 사용할 수 있습니다.',
    'additional_key_update__result_response' => '라이센스 서버 응답: %1',
    'additional_key_update__result_network' => '라이센스 서버에 연결할 수 없습니다. 네트워크에서 %1에 대한 통신을 허용하는지 확인하십시오: %2.',
    'additional_key_update__result_lock' => '키 업데이트가 이미 진행 중입니다.',
    'additional_key_update__result_internal_error' => '라이센스 키를 업데이트하는 중 오류가 발생함: %1',

    'proceed_to_cl_pool' => "고객 IP 풀 구성으로 진행",
    'proceed_to_hosting_setup' => "호스팅 설정으로 진행",
    'removeCerts__remove_certificates_cp' => "다음 인증서가 제거됨:",
    'removeCerts__remove_certificates_domain' => "%1이(가) 소유한 다음 인증서가 제거됨:",
    'removeClientsIP_remove_clients_ip' => "다음 고객 풀에서 이 IP 주소가 제거됨:",
    'removeMailAliases__remove_mail_aliases' => "%1 메일 계정에 대한 다음 메일 별칭이 제거됨:",
    'removeMailNames__remove_mailnames' => "다음 메일 계정과 별칭이 도메인 %1에서 제거됨:",
    'removeMailNames__remove_mailnames_of_cl' => "다음 메일 계정과 별칭이 고객 %1이(가) 소유한 도메인 %2에서 제거됨:",
    'removeMailNames__these_mailnames_will_not_delete' => "이 메일 계정은 삭제되지 않습니다.",
    'removeFtpSessions__remove_title' => "다음 FTP 세션이 종료됨:",
    'removeTemplates__remove_templates' => "다음 템플릿이 제거됨:",
    'report_auto__list_auto' => '빈도',
    'report_auto__list_last' => '마지막 배달 날짜',
    'report_auto__list_recipient' => '배달 대상',
    'report_auto__list_select' => '보고서',
    'report_auto__title' => '다음에 대한 배달 일정 %1',
    'report_auto__recipient_email' => '사용자가 지정하는 이메일 주소',
    'report_auto__recipient_admin' => '서버 관리자',
    'report_auto__recipient_client' => '고객',
    'report_auto__recipient_domain' => '도메인 관리자',
    'report_auto_edit__select' => '보고서',
    'report_auto__select_client_report_all' => '모든 고객',
    'report_auto__select_client_report_current' => '이 고객',
    'report_auto__select_client_report_other_client' => '%1',
    'report_auto__select_domain_report_all' => '모든 도메인',
    'report_auto__select_domain_report_other_client' => '다음의 모든 도메인 %1',
    'report_auto__select_domain_report_client' => '이 고객의 모든 도메인',
    'report_auto__select_domain_report_reseller' => '이 리셀러의 모든 도메인',
    'report_auto__select_domain_report_current' => '이 도메인',
    'report_auto__select_domain_report_other_domain' => '%1',
    'report_auto__legend' => '배달 일정',
    'report_auto__select_for_remove' => "제거할 배달 일정을 선택합니다.",
    'report_auto_remove__title' => "다음 보고서 배달 일정이 제거됨:",
    'report_auto_edit__title' => '배달 일정 속성',
    'report_auto_edit__recipient' => '배달 대상',
    'report_auto_edit__target' => '보고서',
    'report_auto_edit__auto' => '배달 빈도',
    'resp_edit__always_respond' => "항상 응답",
    'resp_edit__reply_subject' => "회신 제목",
    'resp_edit__answer_subject' => "제목과 함께 응답",
    'resp_edit__answer_txt' => "텍스트로 회신",
    'resp_edit__attach' => "파일 첨부",
    'resp_edit__default_subject' => "Re: %1",
    'resp_edit__for' => "대상",
    'resp_edit__frw_rqst_email' => "자동 응답 시, 원래 메시지를 지정된 이메일로 전달",
    'resp_edit__fwd_email_invalid' => "대상 이메일 주소가 유효하지 않습니다.",
    'resp_edit__in_body' => "메시지 본문에서 지정된 단어가 발견되는 경우",
    'resp_edit__in_subject' => "메시지 제목에서 지정된 단어가 발견되는 경우",
    'resp_edit__invalid_resp_freq' => "응답 빈도가 유효하지 않습니다.",
    'resp_edit__invalid_rqst_txt' => "유효하지 않은 요청 텍스트.",
    'resp_edit__invalid_store_lim_num' => "제한 값이 유효하지 않습니다.",
    'resp_edit__limits_title' => "제한",
    'resp_edit__maximum_allowed_resp_freq_reached' => "하루 최대 응답 수가 정의된 수를 초과합니다. 허용: %1, 요청: %2",
    'resp_edit__no_files_sel' => "선택한 파일 없음.",
    'resp_edit__no_txt_supplied' => "제공된 텍스트 없음.",
    'resp_edit__reply_title' => "회신",
    'resp_edit__reply_to_address' => "반송 주소",
    'resp_edit__reply_to_invalid' => "반송 주소가 유효하지 않습니다.",
    'resp_edit__reply_uniq_email' => "다음을 초과하지 않는 고유한 이메일 주소에 회신",
    'resp_edit__conditions_title' => "조건",
    'resp_edit__request_title' => "요청",
    'resp_edit__resp' => "자동 회신",
    'resp_edit__resp_name' => "자동 회신 이름",
    'resp_edit__resp_not_exist' => "자동 회신이 없습니다.",
    'resp_edit__resp_status' => "자동 회신 상태",
    'resp_edit__rqst_txt' => '이 자동 회신에 대한 조건 지정',
    'resp_edit__select_files_on_server_for_attach' => "첨부하려는 파일 선택",
    'resp_edit__store_up_to' => "최대 저장 수",
    'resp_edit__subj_line_invalid' => "제목줄이 올바르지 않습니다.",
    'resp_edit__text_too_big' => "이 회신 메시지 텍스트는 너무 큽니다.",
    'resp_edit__times_in_a_day' => "하루당 횟수.",
    'resp_edit__unable_define_resp_cond' => "자동 회신 조건을 정의할 수 없음: %1",
    'resp_edit__unable_define_resp_status' => "자동 회신 상태를 정의할 수 없음: %1",
    'resp_edit__unable_turn_on_resp' => "자동 회신이 사용되도록 설정할 수 없음: %1",
    'resp_edit__uniq_email' => "고유 이메일 주소",
    'resp_edit__content_type' => '메일 전송 형식',
    'resp_edit__content_type_text' => '일반 텍스트',
    'resp_edit__content_type_html' => 'HTML',
    'resp_edit__charset' => '인코딩',
    'restart__dns' => 'DNS 서버(%1)',
    'restart__drweb' => 'Plesk Premium Antivirus',
    'restart__mail' => "IMAP/POP3 서버(%1)",
    'restart__mssql' => "%1",
    'restart__mysql' => "MySQL 서버",
    'restart__postgresql' => "PostgreSQL",
    'restart__psa' => "서비스",
    'restart__smtp' => "SMTP 서버(%1)",
    'restart__spamd' => "스팸 필터",
    'restart__spamassassin' => "SpamAssassin",
    'restart__stunnel' => "Stunnel",
    'restart__web' => "웹 서버(%1)",
    'restart__ftp' => "FTP 서버(%1)",
    'restart__service_start' => '서비스가 시작하는 데 시간이 약간 걸립니다.',
    'restart__service_stop' => '서비스가 중지하는 데 시간이 약간 걸립니다.',
    'restart__service_restart' => '서비스가 다시 시작하는 데 시간이 약간 걸립니다.',
    'rm_domains__some_domains_are_not_exist' => "지정한 도메인 중 일부가 없습니다. 다른 사용자에 의해 제거되었을 수 있습니다.",
    'rpt_cl_dom_data_bases' => "DBMySQL",
    'rpt_cl_dom_mssql_data_bases' => "DBMSSQL",
    'rpt_cl_dom_mail_groups' => "MGroup",
    'rpt_cl_dom_mail_lists' => "MList",
    'rpt_cl_dom_mail_resps' => "AResp.",
    'rpt_cl_dom_mail_antispam' => "스팸 방지",
    'rpt_cl_dom_mail_antivirus' => "안티 바이러스",
    'rpt_cl_dom_postboxes' => "MBox",
    'rpt_cl_dom_redirects' => "전달자",
    'rpt_cl_dom_subdomains' => "Subdom",
    'rpt_cl_dom_domain_aliases' => "DAliase",
    'rpt_cl_dom_web_users' => "WUser",
    'rpt_cl_report_for_admin__' => "관리자 보고서 %1",
    'rpt_cl_report_for_reseller__' => "리셀러 보고서 %1",
    'rpt_cl_report_for_cl__' => "고객 보고서 %1",
    'rpt_cl_section_domains' => "도메인",
    'rpt_cl_section_full_domains' => "도메인",
    'rpt_cl_section_general' => "일반",
    'rpt_create' => "보고서 만들기",
    'rpt_empty' => "보고서에 하나 이상의 섹션이 있어야 합니다.",
    'rpt_dom_report_for_dom__' => "다음에 대한 도메인 보고서 %1",
    'rpt_dom_section_databases' => "데이터베이스",
    'rpt_dom_section_full_databases' => "데이터베이스",
    'rpt_dom_section_full_maillists' => "메일링 리스트",
    'rpt_dom_section_full_mailnames' => "메일 계정",
    'rpt_dom_section_full_webusers' => "웹 사용자",
    'rpt_dom_section_full_siteapps' => '웹 응용 프로그램',
    'rpt_dom_section_full_aspnetapps' => 'ASP.NET 웹 응용 프로그램',
    'rpt_dom_section_general' => "일반",
    'rpt_dom_section_hosting' => "호스팅",
    'rpt_dom_section_maillists' => "메일링 리스트",
    'rpt_dom_section_mailnames' => "메일 계정",
    'rpt_dom_section_siteapps' => '웹 응용 프로그램',
    'rpt_dom_section_aspnetapps' => 'ASP.NET 웹 응용 프로그램',
    'rpt_dom_section_webusers' => "웹 사용자",
    'rpt_dom_title_wa_status' => "S",
    'rpt_edit__' => "보고서 편집 %1",
    'rpt_enter_email_address' => "보고서를 배달할 대상의 이메일 주소를 입력합니다.",
    'rpt_list' => "사용자 지정 보고서 레이아웃",
    'rpt_section_full' => "전체",
    'rpt_section_none' => "없음",
    'rpt_section_summary' => "요약",
    'rpt_default_full' => '전체 보고서',
    'rpt_default_summary' => '요약 보고서',

    // end of kooper part

    // pit part

    'rpt_send_report_by_email_error__' => "보고서 보내기 오류: %1",
    'rpt_send_report_by_email_ok__' => "보고서가 다음에게 발송됨 %1",
    'sa_action' => "동작",
    'sa_action_del' => "삭제",
    'sa_action_desc' => "스팸 메일 처리 방법",
    'sa_action_save' => "스팸으로 표시한 후 사서함에 저장",
    'sa_admin_blacklist' => "관리자의 차단 목록",
    'sa_admin_whitelist' => "관리자의 허용 목록",
    'sa_db_del_confirm' => "스팸 필터 데이터베이스를 삭제하시겠습니까?",
    'sa_eml_in_ignorelist' => "이메일이 무시 목록에 있음",
    'sa_empty_email' => "빈 이메일 패턴을 추가할 수 없습니다.",
    'sa_exists_email' => "해당 이메일 패턴이 이미 있습니다.",
    'sa_disabled__mailname_not_filtering' => "현재 서버 설정으로는 이 메일 계정에 메일 필터를 사용할 수 없습니다.",
    'sa_disabled__filtering_is_disabled' => '서버 관리자에 의해 스팸 필터 사용이 해제되었습니다.',
    'sa_disabled__hasnt_mailbox' => "사서함 없이 스팸 필터링을 설정할 수 없습니다.",
    'sa_enable_filter' => "스팸 필터 켜기",
    'sa_forget' => "무시",
    'sa_from' => "시작",
    'sa_ham' => "햄",
    'sa_pattern_is_invalid' => "패턴이 잘못되었습니다.",
    'sa_spam' => "스팸",
    'sa_trainer__page_title' => '스팸 필터 교육',
    'sa_trainer__tools_legend' => '도구',
    'sa_trainer__info_legend' => '정보',
    'sa_trainer__messages_list_legend' => '사서함에 있는 메시지',
    'sa_trainer__c' => 'T',
    'sa_trainer__l' => 'L',
    'sa_trainer__subject' => '제목',
    'sa_trainer__from' => '시작',
    'sa_trainer__date' => '날짜',
    'sa_trainer__info_text' => '학습된 메시지: %1 스팸, %2 스팸 아님, %3 총합.',
    'sa_trainer__messages' => '메시지',
    'sa_trainer__select__all' => '모두',
    'sa_trainer__select__spam_only' => '스팸',
    'sa_trainer__select__ham_only' => '스팸 아님',
    'sa_trainer__select__unknown_only' => '알 수 없음',
    'sa_trainer__cannot_remove_messages' => '사서함에서 선택한 메시지를 제거할 수 없습니다.',
    'sa_trainer__remove_messages_confirm' => '사서함에서 선택한 메시지를 제거하시겠습니까?',
    'sa_subj' => "제목",
    'sa_training' => "스팸 필터 교육",
    'sa_training_legend' => "Bayesian 필터 교육",
    'sa_use_srv_settings' => "서버 전체 설정 사용",
    'sa_user_blacklist' => "사용자의 차단 목록",
    'sa_user_whitelist' => "사용자의 허용 목록",
    'sa_usr_disabled_by_srv' => "서버 관리자가 개별 스팸 필터 설정을 허용하지 않았습니다.",
    'sa_usr_no_postbox' => "우편함이 이 메일 계정에 꺼져 있기 때문에 스팸 필터링을 활성화할 수 없습니다.",
    'sa_filters' => '스팸 필터',
    'spamfilter__tools_legend' => '도구',
    'spamfilter__prefs_legend' => '설정',
    'spamfilter__max_children' => '실행할 작업자 spamd 프로세스의 최대 수',
    'spamfilter__rewrite_header_subject_hint' => '어떤 텍스트도 추가하지 않으려면 이 필드를 비워두십시오. 메시지 제목에 점수를 포함시키려는 경우 Type _SCORE_.',
    'spamfilter__reject_spam' => '사서함에 배달되는 스팸 메일 삭제',
    'spamfilter__enabled' => '켜짐',
    'spamfilter_addresses_list__tools_legend' => '도구',
    'spamfilter_addresses_list__list_legend' => '주소',
    'spamfilter_addresses_list__items' => '주소',
    'spamfilter_addresses_list__status' => 'S',
    'spamfilter_addresses_list__level' => 'L',
    'spamfilter_addresses_list__address' => '주소',
    'spamfilter_addresses__file_legend' => '파일에서',
    'spamfilter_addresses__file_label' => '파일 이름',
    'spamfilter_addresses__file_hint' => '파일을 UTF-8 인코딩으로 업로드합니다.',
    'spamfilter_addresses__text_legend' => '목록에서',
    'spamfilter_addresses__text_label' => '이메일 주소',
    'spamfilter_addresses__remove_title' => '다음 주소가 목록에서 제거됨:',
    'spamfilter_addresses__empty_selection' => '선택한 주소가 없음.',
    'server__admin_info' => "관리자 정보",
    'server__ctrl_panel' => "Plesk",
    'server__enter_bug_essence_below' => "아래에 버그 설명 입력",
    'server__power_management' => "전원 관리",
    'server__services' => "서비스",
    'server__system' => "시스템",
    'server__title' => "서버 관리",
    'server_preferences__admin_skin' => "관리자의 인터페이스 스킨",
    'server_preferences__default_language' => "기본 언어",
    'server_preferences__default_skin' => "기본 스킨",
    'server_preferences__restart_apache_interval' => "Apache 재시작 간격",
    'server_preferences__system' => '시스템 설정',
    'mail__tabs_preferences' => "설정",
    'mail__tabs_white_list' => "허용 목록",
    'server_preferences__use_vocabulary' => "사전에서 사서함 암호 확인",
    'sessions__agreement' => "예, 이 세션을 끝내겠습니다.",
    'sessions__select_sessions_for_remove' => "끝낼 세션을 선택합니다.",
    'sessions__tabs_cp_sessions' => 'Plesk세션',
    'sessions__tabs_ftp_sessions' => 'FTP 세션',
    'sessions__ftp_sessions_login' => 'FTP 계정 사용자 이름',
    'sessions__ftp_sessions_domain' => '도메인 이름',
    'sessions__ftp_sessions_path' => '현재 위치',
    'sessions__ftp_sessions_file' => '파일 이름',
    'sessions__ftp_sessions_action' => '상태',
    'sessions__ftp_sessions_speed' => '속도, KB/S',
    'sessions__ftp_sessions_comp' => '진행률, %',

    'site_apps__access_level' => '액세스 레벨',
    'site_apps__access_level_commercial' => '상용',
    'site_apps__access_level_free' => '무료',
    'site_apps__action_installer' => "웹 응용 프로그램 설치",
    'site_apps__action_reconfigure' => "웹 응용 프로그램 재구성.",
    'site_apps__custom_button_level' => '이 응용 프로그램에 액세스하기 위한 새 사용자 지정 버튼을 만드시겠습니까?',
    'site_apps__custom_button_level_false_domain_user_only' => '아니오',
    'site_apps__custom_button_level_domain_user_only' => '예',
    'site_apps__custom_button_level_false' => '아니오',
    'site_apps__custom_button_level_domain' => '예, 현재 도메인에만 사용할 수 있게 합니다.',
    'site_apps__custom_button_level_client' => '예, 고객의 모든 도메인에 사용할 수 있게 합니다.',
    'site_apps__custom_button_level_admin' => '예, 모든 도메인에서 사용할 수 있게 합니다.',
    'site_apps__description' => "설명",
    'site_apps__dir_used_by_sapp__' => "\"%1\" 디렉터리는 다른 웹 응용 프로그램에서 사용 중입니다.",
    'site_apps__dir_used_by_unknown__' => "\"%1\" 디렉터리는 이미 있습니다. 계속 진행하는 경우 내용이 덮어써집니다.",
    'site_apps__dir_invalid_name__' => "디렉터리 이름 %1은(는) 잘못되었습니다.",
    'site_apps__file_name' => '웹 응용 프로그램 파일 이름',
    'site_apps__invalid_install_prefix' => "유효하지 않은 설치 접두사",
    'site_apps__invalid_package' => "웹 응용 프로그램이 유효하지 않음",
    'site_apps__key_status' => '라이센싱',
    'site_apps__key_status_free' => '자유롭게 배포. 라이센스 키 필요 없음',
    'site_apps__key_status_ok' => '필수 라이센스 키가 설치되었습니다.',
    'site_apps__key_status_problem' => '필수 라이센스 키가 설치되지 않았습니다.',
    'site_apps__name' => "이름",
    'site_apps__no_domains' => '웹 응용 프로그램을 설치할 수 없습니다. 이 도메인의 루트 디렉터리에 다른 웹 응용 프로그램이 이미 설치되어 있습니다. 웹 응용 프로그램에 대한 하위 도메인을 만들어 보십시오.',
    'site_apps__package_info_' => "웹 응용 프로그램 정보",
    'site_apps__package_integrated' => "내장 응용 프로그램, 제거할 수 없음",
    'site_apps__pool_select_packages_to_add' => '풀에 추가할 웹 응용 프로그램 선택',
    'site_apps__release' => "릴리스",
    'site_apps__resource_used_by_sapp' => "이 리소스는 설치된 웹 응용 프로그램에 사용됩니다.",
    'site_apps__root_used_by_sapp' => "이 리소스는 설치된 웹 응용 프로그램에서 사용 중입니다.",
    'site_apps__these_domains_will_not_delete' => '이들 (하위) 도메인은 삭제되지 않습니다.',
    'site_apps__upload_site_app_pkg_title' => '새 웹 응용 프로그램 업로드',
    'site_apps__version' => "버전",
    'site_apps__access_to' => "다음에 액세스 %1",
    'site_builder_requires' => '%1 - %3',
    'skeleton__admin_label' => "가상 호스트 템플릿",
    'skeleton__client_label' => "%1 가상 호스트 템플릿",
    'skeleton__admin_page' => "가상 호스트 템플릿 관리",
    'skeleton__files_list' => "파일 및 디렉터리",
    'skeleton__archiver_not_installed' => "압축 파일의 압축을 풀 수 없음. 보관기가 서버에 설치되어 있지 않은 것 같습니다. {$PROD_NAME} 관리자에게 연락하여 보관기 소프트웨어의 설치를 요청하십시오.",
    'skeleton__client_page' => "가상 호스트 템플릿 관리",
    'skeleton__archive_corrupted' => "압축 파일 검사 결과 압축 파일이 손상되었거나 이 압축 파일 유형이 지원되지 않는 것으로 나타났습니다.",
    'skeleton__archive_too_large' => "압축 파일 검사 결과 압축 파일이 너무 큰 것으로 나타났습니다.",
    'skeleton__not_supported_archive_type' => "이 유형의 압축 파일(파일 %1)은 지원되지 않습니다.",
    'skeleton__upload_archive_file' => "압축 파일 업로드",
    'skin_download__title' => '스킨 다운로드',
    'skin_download_now__title' => '스킨 다운로드 진행 중',
    'skin_download_now__text' => '스킨 패키지 작성처리를 실행중입니다.<br>이 처리를 하는데 다소 시간이 걸리는 경우가 있습니다.<br>다이얼로그 창이 표시되면 Plesk의 구성을 계속하실 수 있습니다.',
    'skin_file__help_for_using_types' => "다음 중 한 형식의 스킨 압축 파일을 사용해 주십시오.",
    'skin_info__title' => '스킨 속성',
    'skin_mng_err__rpm_not_skin' => '이 RPM은 Plesk 스킨 패키지가 아닙니다.',
    'skin_mng_err__psa_install_noreloc' => '지정한 위치에 rpm 기반 스킨을 설치하지 못했습니다.',
    'skin_mng_err__already_exists' => '스킨 설치 디렉터리가 이미 있고 스킨 패키지가 배포되었습니다.',
    'skin_mng_err__rpm_upgrade_nonrpm' => '업로드된 파일이 올바른 RPM 스킨 패키지가 아닙니다.',
    'skin_mng_err__rpm_upgrade_noskin' => '업로드된 파일이 올바른 스킨 패키지가 아닙니다.',
    'skin_mng_err__rpm_upgrade_base' => "업로드된 파일이 유효한 {$PROD_NAME} 스킨 패키지가 아닙니다.",
    'skin_mng_err__rpm_upgrade_other' => '스킨을 설치할 수 없음: 잘못된 스킨 형식.',
    'skin_mng_err__no_a_skin' => "업로드된 파일이 유효한 {$PROD_NAME} 스킨 패키지가 아닙니다.",
    'skin_upload__title' => '새 스킨 업로드',
    'skin_upload__already_exists' => "스킨 '%1'은(는) 이미 있습니다.",
    'skin_upload__unable_to_apply' => "업로드된 파일에 Plesk 스킨이 포함되지 않았거나 압축 파일 형식이 지원되지 않습니다.",
    'skin_upload__unable_to_rename__' => "스킨 이름을 %2에서 %1(으)로 변경할 수 없음: %3.",
    'skin_upload__file_name' => '스킨 패키지 파일 경로',
    'skins_list__title' => '스킨 리포지토리',
    'skins_remove__title' => '스킨 제거',
    'skins_remove__select_skins_for_remove' => '제거할 스킨 선택',

    'spf__unable_update' => 'SPF 매개 변수를 업데이트할 수 없습니다.',
    'statistics__active_domains' => "활성 도메인",
    'statistics__clients' => "고객",
    'statistics__subdomains' => "하위 도메인",
    'statistics__cpu' => "CPU",
    'statistics__databases' => "데이터베이스",
    'statistics__db_users' => "데이터베이스 사용자",
    'statistics__dirs' => "보호된 디렉터리",
    'statistics__dom_active' => "활성",
    'statistics__dom_passive' => "수동",
    'statistics__dom_problem' => "문제",
    'statistics__domains' => "도메인",
    'statistics__domains_with_host' => "호스팅을 포함한 도메인",
    'statistics__doms' => "도메인",
    'statistics__filesystem' => "파일 시스템",
    'statistics__general' => "일반",
    'statistics__hdd_available' => "사용 가능함",
    'statistics__hdd_capacity' => "용량",
    'statistics__hdd_total' => "전체",
    'statistics__hdd_usage' => "하드 디스크 사용량",
    'statistics__hdd_used' => "사용 중",
    'statistics__ip' => "IP 주소",
    'statistics__key_number' => "키 번호",
    'statistics__l1' => "마지막 1분",
    'statistics__l15' => "마지막 15분",
    'statistics__l5' => "마지막 5분",
    'statistics__la' => "CPU 사용률",
    'statistics__mail_autoresponders' => "자동 회신",
    'statistics__mail_boxes' => "사서함",
    'statistics__mail_groups' => "메일 그룹",
    'statistics__mail_lists' => "메일링 리스트",
    'statistics__mail_redirects' => "메일 전달자",
    'statistics__mem' => "메모리 사용량",
    'statistics__mem_usage' => "사용",
    'statistics__memory_available' => "사용 가능함",
    'statistics__memory_buffer' => "버퍼",
    'statistics__memory_cached' => "캐시됨",
    'statistics__memory_free' => "무료",
    'statistics__memory_shared' => "공유",
    'statistics__memory_total' => "전체",
    'statistics__memory_used' => "사용 중",
    'statistics__os' => "OS",
    'statistics__problem_clients' => "문제 고객",
    'statistics__problem_domains' => "문제 도메인",
    'statistics__swap' => "스왑 사용량",
    'statistics__swap_free' => "무료",
    'statistics__swap_total' => "전체",
    'statistics__swap_usage' => "사용",
    'statistics__swap_used' => "사용 중",
    'statistics__system_stat' => "서버 정보",
    'statistics__unable_define_active_doms' => "활성 도메인의 수를 확인할 수 없음: %1",
    'statistics__unable_define_inactive_doms' => "비활성 도메인의 수를 확인할 수 없음: %1",
    'statistics__failed_define_swap_usage' => '스왑 사용량 정의 실패',
    'statistics__failed_define_load_averages' => '부하 평균 정의 실패',
    'statistics__up_time' => "시스템 작동 시간:",
    'statistics__ver' => "버전",
    'statistics__web_users' => "웹 사용자",
    'statistics__mem_win' => "실제 메모리 사용량",
    'statistics__memory_total_win' => "전체",
    'statistics__memory_used_win' => "사용 중",
    'statistics__memory_free_win' => "사용 가능함",
    'statistics__swap_win' => "가상 메모리 사용량",
    'statistics__swap_total_win' => "전체",
    'statistics__swap_used_win' => "사용 중",
    'statistics__swap_free_win' => "사용 가능함",
    'status__domain_has_reasons_to_be_off' => "다음 이유로 도메인이 아직 일시 중단되어 있음: %1",
    'subdomain__create__' => "도메인에 하위 도메인 만들기 %1",
    'subdomain__edit__' => "하위 도메인 관리 %1",
    'subdomain__invalid_name' => "유효하지 않은 하위 도메인 이름: 영숫자 및 대시 기호만 사용하십시오.",
    'subdomain__incorrect_name' => "잘못된 하위 도메인 이름:",
    'subdomains__maillists_enabled_in_domain' => "잘못된 하위 도메인 이름 목록.%1: 이 도메인 이름은 %1 도메인 아래의 메일링 리스트에 아직 사용 중입니다.",
    'subdomains__dalias_exists' => '이러한 이름을 갖는 도메인 별칭이 이미 있습니다.',
    'subdomains__name_exists' => "이러한 이름의 하위 도메인이 이미 있습니다.",
    'subdomains__regular_domain_exists' => "이러한 이름의 도메인이 이미 있습니다.",
    'subdomains__domain_alias_exists' => '이러한 이름을 갖는 도메인 별칭이 이미 있습니다.',
    'subdomains__remove_subdomains_on_domain' => "%1 도메인의 다음 하위 도메인이 제거됨:",
    'subdomains__select_subdomains_for_remove' => "제거할 하위 도메인을 선택합니다.",
    'subdomains__webmail_enabled_in_domain' => "잘못된 하위 도메인 이름 웹 메일.%1: 이 도메인 이름은 도메인 %1의 웹 메일에 액세스하는 데 사용됩니다.",
    'subdomains__dns_record_already_exists' => '호스트 %1을(를) 가리키는 DNS 레코드가 이미 있으므로 하위 도메인 %1을(를) 만들 수 없습니다.',
    'subdomains__www_prefix_in_domain' => "잘못된 하위 도메인 이름 www.%1: %1 도메인에 이미 WWW 접두사가 있습니다.",
    'subdomains__user_type_quota_exceeds' => '할당된 디스크 공간을 초과하게 되므로 사용자 계정을 변경할 수 없습니다.',
    'subdomains__creation_in_dns_slave' => "Plesk의 이름 서버가 이 도메인에 대한 보조 이름 서버로 작동합니다. 하위 도메인이 올바르게 확인되도록 기본 서버의 영역 파일에 %1 레코드가 포함되어 있는지 확인하십시오.",
    'sys_user__attributes_not_changed' => "\n다음 시스템 사용자 특성이 변경되지 않음: %1",
    'sys_user__no_access_without_password' => "암호를 설정하지 않았습니다. 시스템 사용자가 만들어졌지만 암호가 제공될 때까지 시스템에 로그인하지 못합니다. 계속 진행하시겠습니까?",
    'sys_user__no_hard_quota' => "지원되지 않음",
    'sysuser__zero_quota_is_unlimited' => "무제한의 경우 0",
    'template__num_excl_ips' => "고객에게 전용 IP 주소 할당",
    'template__sel_sh_ips' => "선택한 공유 IP 주소",
    'template__av_sh_ips' => "사용 가능한 공유 IP 주소",
    'template__up_to_excl_ip' => "최대 %1개의 IP 주소",
    'templates__all_clients' => "모든 고객",
    'templates__cl_domain_templates' => "다음에 대한 템플릿 %1",
    'templates__cl_templates' => "고객 템플릿",
    'time__invalid_ip' => "유효하지 않은 IP 주소 또는 도메인 이름.",
    '__please_select_country' => '국가를 선택하십시오.',
    'time__unable_set_time' => "시스템 시간을 설정할 수 없음: %1",
    'time__sinchronization_setup_error' => '시간 동기화를 설정할 수 없습니다: timemng 실패: %1',
    'time__sinchronization_disable_error' => '시간 동기화를 비활성화할 수 없습니다: timemng 실패: %1',
    'tmpl__create' => "템플릿 만들기",
    'tmpl__edit__' => '템플릿 %1',
    'tmpl__logrotation_warn' => "이 템플릿으로 만들어진 도메인에서 로그 순환은 이에 대한 실제 호스팅 계정이 이후 만들어진 경우에만 수행됩니다.",
    'tmpl__name' => "템플릿 이름",
    'tmpl__dom_exist' => "같은 명칭을 가진 도메인 템플릿이 관리자 또는 고객 템플릿 풀 내에 존재합니다.",
    'tmpl__name_invalid' => "템플릿 이름이 잘못되었거나 비어 있습니다.",
    'tmpl__use_next_ip_addr' => "다음 빈 IP 주소가 사용됩니다.",
    'tmpl_name_already_exists' => "이름이 '%1'인 템플릿이 이미 있습니다.",
    'traffic__no_periods_found' => "웹 및 트래픽 통계를 표시할 수 없습니다. 이 기능은 다음 통계 계산 이후에만 사용할 수 있습니다.",

    'vh_based__no_free_ip_for_vh' => "IP 기반 가상 호스팅에 사용할 빈 IP 주소가 없습니다. IP 주소를 추가하십시오.",

    'wu__at_domains_text' => "webuser@%1 액세스 형식 허용",
    'wu__unable_create' => "웹 사용자를 만들 수 없음: %1",
    'wu_edit__disk_quota' => "디스크 할당량",
    'wu_edit__invalid_pass' => "암호가 유효하지 않습니다.",
    'wu_edit__invalid_quota' => "지정한 디스크 공간 할당량 값이 유효하지 않습니다. 양의 정수를 입력하십시오.",
    'wu_edit__invalid_quota_value' => "지정한 디스크 공간 할당량이 현재 사용량(%1MB)보다 작습니다. 일부 기능을 사용하지 못하게 될 수 있습니다. 계속하시겠습니까?",
    'wu_edit__not_create_pass' => "이 작업으로 새 웹 사용자에 대한 암호가 만들어지지 않습니다.\n암호가 없으면 사용자가 로그인할 수 없습니다.",
    'wu_edit__unable_update' => "웹 사용자 속성을 업데이트할 수 없음: %1",

    'bt_webdirs' => '가상 디렉터리',

    'dns__tabs_general' => '영역 설정',
    'dns__tabs_zone_settings' => 'SOA 레코드',
    'soa__seconds' => '초',
    'soa__minutes' => '분',
    'soa__hours' => '시간',
    'soa__days' => '일',

    'DomainSubdirectory' => '대상 하위 디렉터리',

    'filemanager__select_codepage' => '코드 페이지 선택:',

    'bt_server_app_add' => '서버 응용 프로그램 추가',
    'packages_list' => '서버 응용 프로그램',

    'bt_packages_management' => '패키지 관리',
    'pb__packages_management' => '응용 프로그램 관리',
    'bt_package_new' => '응용 프로그램 추가',
    '__packages' => '서버 응용 프로그램',

    'dom_ctrl__mysql_dbase_space' => '총 MySQL 데이터베이스 할당량',
    'dom_ctrl__mssql_dbase_space' => '총 MS SQL 데이터베이스 할당량',

    'dns_add__enter_ixfr_path' => 'IXFR 경로 입력',

    'cmd_dns__txt_dns_record_already_exist' => 'SPF TXT 레코드가 이미 있습니다. 하나의 SPF 레코드만 존재할 수 있습니다. 레코드를 추가하려면 먼저 기존 레코드를 삭제하십시오.',

    'component_name__network' => '네트워킹',
    'component_name__sitebuilder' => 'Presence Builder',

    'bt_skin_set' => '스킨 설정',
    'bt_set_skin' => '스킨 설정',
    'firewall__rule_already_exists' => '해당 규칙 "%1"이(가) 이미 있음',
    'firewall__rule_readonly' => '규칙 "%1"은 읽기 전용입니다',
    'pb__firewall' => '방화벽',

    '__webstat_smarterstats' => 'SmarterStats',

    'error_doc__erorr_invalid_file_location' => '파일 위치가 잘못되었습니다.',

    'error_doc__erorr_invalid_url_location' =>  '잘못된 URL 형식. 가상 호스트(사이트) 내 절대 URL을 입력하십시오.',

    'mn_list__tab_title_antivirus' => 'AV',

    'bt_antivirus' => '안티 바이러스',
    'antivirus__antivirus' => '안티 바이러스 보호',
    'antivirus__antivirus_direction_off' => '꺼짐',
    'antivirus__antivirus_direction_any' => '수신 메일 및 발신 메일',
    'antivirus__antivirus_direction_from' => '발신 메일만',
    'antivirus__antivirus_direction_to' => '수신 메일만',
    'antivirus__unable_to_update_settings' => '안티 바이러스 설정을 변경할 수 없음: %1',




    '__normal' => '보통',
    '__low' => '낮음',
    '__high' => '높음',

    'mail__antivirus' => "내부 메일 서버의 안티 바이러스",
    'mail__use_internal_antivirus' => '내부 안티 바이러스 사용',

    'sa__tabs_blacklist' => '차단 목록',

    '__mysql_databases' => 'MySQL 데이터베이스',

    'cl_perm__mysql_dbase_space' => '총 MySQL 데이터베이스 할당량',
    'cl_perm__mssql_dbase_space' => '총 MS SQL 데이터베이스 할당량',
    'cl_perm__max_mssql_db' => 'Microsoft SQL Server 데이터베이스 최대 수',
    'cl_perm__total_mboxes_quota' => '총 사서함 할당량',

    'i_i_cl_on' => '고객 계정이 활성 상태입니다.',
    'i_i_cl_off_by_admin' => '관리자에 의해 고객 계정이 일시 중단되었습니다.',

    'sa_exists_tn' => '네트워크가 이미 목록에 있습니다.',

    'webdir__select_vdirs_to_remove' => '삭제할 디렉터리 선택',
    'webdir__select_mime_types_to_remove' => '삭제할 MIME 유형 선택',

    'defaultcomponents__not_activated' => '활성화되지 않음',

    'bt_traffic_at_domains' => '트래픽',

    '__awstats_perl_warning' => 'Perl이 설치되지 않으면 AWStats에서 사용자가 이전 연도의 통계를 확인할 수 없습니다.',

    'class_client__mysql_dbase_space' => '값이 고객 제한을 초과함.',
    'class_client__mssql_dbase_space' => '값이 고객 제한을 초과함.',
    'class_client__max_mssql_db' => '값이 고객 제한을 초과함.',

    'dns__remove_transfer_restrictions_list_items' => '다음 네트워크가 액세스 제어 목록에서 제거됨:',

    'bt_up' => "위쪽",
    'bt_down' => "아래쪽",
    'virtualdir__type_default_doc_name_to_add' => '목록에 추가할 파일 이름 입력',
    'virtualdir__select_default_doc_to_remove' => '목록에서 제거할 파일 선택',
    'virtualdir__select_directory' => '디렉터리 선택',

    'bt_install_selected' => '선택한 라이센스 키 설치', // SELECTED


    'dom_pref__the_domain_resolves_to_another_ip_address' => '도메인이 다른 IP 주소로 확인됨: (%1). DNS 설정을 수정하십시오.',

    'mn_edit__mailbox_enable_if_mailgroup_enabled' => '현재 사용 중인 메일 서버가 동시에 설정된 사서함과 메일 그룹을 모두 지원하지 않습니다. 메일 그룹이 해제되더라도 사서함을 설정하려면 확인을 누르십시오. 모두 그대로 유지하려면 ‘취소’를 누르십시오.',

    'mn_edit__mailgroup_enable_if_mailbox_enabled' => '현재 사용 중인 메일 서버가 동시에 설정된 사서함과 메일 그룹을 모두 지원하지 않습니다. 사서함이 해제되더라도 메일 그룹을 설정하려면 확인을 누르십시오. 모두 그대로 유지하려면 ‘취소’를 누르십시오.',

    'mysql_dbase_space_limit' => 'MySQL 데이터베이스 공간 제한',
    'mysql_dbase_usage' => 'MySQL 데이터베이스 공간 사용량',
    'mssql_dbase_space_limit' => 'Microsoft SQL 서버 데이터베이스 공간 제한',
    'mssql_dbase_usage' => 'Microsoft SQL 서버 데이터베이스 공간 사용량',

    '__statistics' => "통계", //indirect

    'dns__soa_minimum_value_is_big' => '3시간을 초과하는 최소 TTL 값을 설정하면 일부 도메인 관리자가 도메인에 액세스하지 못할 수 있습니다. 도메인 이름 등록자가 요구하는 경우에만 이러한 값을 설정하는 것이 좋습니다.',

    'virusfilter__interface_not_available' => '바이러스 필터가 없습니다.',
    'virusfilter__none_virus_filter' => '없음',
    'virusfilter__mailname_status_text' => '안티 바이러스(%1)',
    'virusfilter__status_none' => '꺼짐',
    'virusfilter__status_any' => '수신 메일 및 발신 메일',
    'virusfilter__status_outgoing' => '발신 메일만',
    'virusfilter__status_incoming' => '수신 메일만',

    'visibility__root_override_parse_error' => '%1 파일의 %2 라인에 구문 오류가 있습니다.',

    'sb__not_support_publishing_api' => "이 구성 요소는 게시 자동화를 지원하지 않습니다.",

    'component_name__cphosting' => "Plesk 호스팅",

    'dom_pref__unable_set_up_total_mboxes_quota' => '사서함 할당량 설정은 현재 메일 서버에서 지원하지 않습니다.',
    '__unable_get_total_mboxes_quota' => '사서함 할당량 설정은 현재 메일 서버에서 지원하지 않습니다.',

    'install_prefix__parent_not_exists' => "상위 디렉터리가 없습니다.",

    'bt_change_version' => '버전 변경',
    'aspdotnet__changeversion_title' => 'ASP.NET 버전 선택',
    'pb__aspdotnet' => 'ASP.NET',

    '__check_all' => "모두 선택",
    '__uncheck_all' => "모두 지우기",

    'dns__editing_domain_controller_zone' => "도메인 컨트롤러의 DNS 영역 레코드를 편집하면 도메인 작동에 문제가 발생할 수 있습니다.",

    'pb__interface_management' => "인터페이스 관리",
    'interface_management__tabs_skins' => "스킨",
    'interface_management__tabs_interface_templates' => "인터페이스 템플릿",
    'interface_management__tabs_locales' => "로켈",
    'locales_list__title' => "언어 팩 리포지토리",
    'locales_list__legend' => "사용 가능한 언어",
    'locales_list__active_title' => "S",
    'locales_list__locale_title' => "언어 팩",
    'locales_list__lang_title' => "언어",
    'locales_list__country_title' => "국가",
    'locales_list__used_title' => "사용 중",

    'backup__suspend_warning_during_backup' => "백업 프로세스 중에는 도메인을 사용할 수 없습니다.",
    'backup__suspend_warning_during_restore' => "복원 프로세스 중에는 도메인을 사용할 수 없습니다.",
    'backup__suspend_domain' => "도메인 일시 중단",

    'locales_list__mls_limit' => "현재  Plesk 라이센스는 %2개 언어를 사용하여 허용합니다. 라이센스와 함께 제공된 언어 세트의 최대허용치를 초과했고 유효한 언어는 %1 입니다.  필요한 %2개 언어를 선택하고 'S' 열의 아이콘을 클릭합니다.",

    'bt_change_owner' => '새 소유자 할당',
    'chown__new_owner' => '새 소유자',
    'chown__selected_domains' => '선택한 구독',
    'chown__limits_legend' => '리소스',
    'chown__limit_name' => '리소스 이름',
    'chown__limit_value' => '할당된 리소스',
    'chown__limit_assigned_before' => '이전 전',
    'chown__limit_assigned_after' => '이전 후',
    'chown__error_limits' => "구독 이전을 계속할 수 없음: 이 구독에는 새 소유자의 공급자가 제공할 수 있는 더 많은 리소스가 필요합니다.",
    'chown__error_no_domains' => '구독 이전을 계속할 수 없음: 구독을 선택하지 않았거나 선택한 구독이 대상 사용자에게 이미 속해 있습니다.',
    'chown__error_empty_ip_pool' => "구독 이전을 계속할 수 없음: 새 소유자의 공급자 IP 풀이 비어 있습니다. 풀에 하나 이상의 공급자용 IP 주소가 있는지 확인해 주십시오.",
    'chown__please_select_new_domain_owner' => '이 구독의 새 소유자를 선택합니다.',
    'chown__old_ip_address' => '현재 IP 주소',
    'chown__new_ip_address' => '새 IP 주소',

    'chown__error_ssl_already_used' => "SSL/TLS 지원이 다음 대상 IP에서 이미 사용 중임: %1 따라서, SSL/TLS 지원이 포함된 다음 도메인을 이전할 수 없음: %2. 문제를 해결한 후 다시 시도하십시오.",
    'chown__sitebuilder_not_installed' => 'Presence Builder가 설치되지 않음',
    'chown__domain_exclude_sitebuilder_not_installed' => 'Presence Builder가 설치되지 않아서 도메인 %1을(를) 다른 소유자에게 이전할 수 없습니다.',

    'backup__backup_time' => '백업 시간',
    'backup__backup_time_hour' => '시간',
    'backup__backup_time_minute' => '분',
    'backup__every' => '반복 단위',
    'backup__day_of_month' => '일',

    'subdomain__select_hst_type' => '하위 도메인에 대한 호스팅 유형 선택',
    'hst_sel__subdom_subfolder_hst' => '하위 폴더의 하위 도메인',
    'subdomain__www_root_folder_not_exists' => '사이트 홈 디렉터리 %1이(가) 존재하지 않습니다.',
    '__site_home_dir' => '사이트 홈 디렉터리',
    'subdomain__aspnet_disabled_domain' => '도메인에 의해 해제됨',

    'domains__remove_description' => '도메인 및 해당 하위 도메인 내용 및 설정, 웹 응용 프로그램 데이터, 사서함 내용, 메일, 안티 바이러스 및 스팸 필터링 설정, 로그 파일, 도메인 백업 리포지토리 데이터 및 SSL/TLS 인증서를 포함한 모든 도메인 데이터가 삭제됩니다. 로컬 컴퓨터에 백업 파일이 없으면 모든 데이터가 영구적으로 손실됩니다.',
    'subdomains__remove_description' => '콘텐츠 및 설정, 웹 응용 프로그램 데이터 및 로그 파일을 포함한 모든 하위 도메인 데이터가 삭제됩니다. 로컬 컴퓨터에 백업 파일이 없으면 모든 데이터가 영구적으로 손실됩니다.',

    'mail__tabs_spam_filtering' => '스팸 필터링',
    'mail__tabs_antivirus' => '안티 바이러스',
    'antivirus__use_server_settings_scan' => '기본 서버 전체 설정 사용(검사)',
    'antivirus__use_server_settings_no_scan' => '기본 서버 전체 설정 사용(검사 안 함)',
    'antivirus__check_for_viruses' => '바이러스 검사',
    'antivirus__dont_check_for_viruses' => '바이러스 검사 안 함',
    'antivirus__incoming_mail' => '수신 메일',
    'antivirus__outgoing_mail' => '송신 메일',

    'domain_alias__CNAME_dns_record_exists' => '해당 이름을 가진 DNS CNAME 레코드가 이미 있음',
    'domain_alias__A_dns_record_exists' => '해당 이름을 가진 DNS A 레코드가 이미 있음',
    'domain_alias__bad_prefix' => '도메인 별칭의 접두사가 잘못됨',
    'domain_alias__domain_doesnt_exist' => "도메인이 없음",

    'dns__zone_ttl_message_info' => 'TTL 값을 지정하지 않으면 SOA 레코드 탬플릿(%1)의 TTL 값이 DNS 레코드에 사용됩니다.',

    '__webalizer_support' => 'Webalizer',
    '__awstats_support' => 'AWStats',
    '__smarterstats_support' => 'SmarterStats',

    'site_apps__make_default_warning_message' => "선택한 웹 응용 프로그램으로 리디렉션을 위해 index.html 파일이 만들어집니다. index.html 파일이 이미 있는 경우, 기존 파일이 index.html.old로 백업되고 새 파일로 대체됩니다. 확인을 눌러 확인하십시오.",

    'bt_ftp_ctrl' => "추가 FTP 계정",
    'ftp_users_no_permission' => "이 도메인의 FTP 계정을 관리할 권한이 없습니다.",
    'ftp_users_limit_reached' => "이 도메인의 FTP 계정 제한에 도달했습니다.",
    'pb__ftp_ctrl' => "FTP 관리",
    'class_client__max_subftp_users' => "추가 FTP 계정",

    '__client_form_settings' => "고객의 설정",
    '__sbnet_client_keep_sbnet' => "Presence Builder에서 해당 사용자 계정 유지",
    '__sbnet_cant_add_more_sites' => "이 고객에 대한 Presence Builder 사용 가능 사이트 수 제한에 도달했습니다.",
    '__sbnet_legend_text' => "Presence Builder 통합",
    '__sbnet_synchronize_user_with_sbnet' => "Presence Builder에서 해당 사용자 계정 만들기",
    '__sbnet_client_warning_delete_sb_user' => "이 고객과 연관된 Presence Builder 사용자 계정을 제거하려고 합니다. 그러면 사용자의 모든 웹 사이트와 Presence Builder 시스템의 다른 모든 관련 설정이 삭제되어 나중에 이 옵션을 다시 설정하더라도 Presence Builder를 통해 기존 웹 사이트를 편집할 수 없게 됩니다. 나중에 Presence Builder 사용자 계정을 다시 만드는 경우, 모든 웹 사이트를 처음부터 다시 만들고 게시해야 합니다. Presence Builder를 통한 웹 사이트 만들기와 게시를 해제하시겠습니까?",
    'sb__build_site_with_subdomains' => "블로그 및 사진 갤러리 하위 도메인 생성",
    '__sbnet_client_dont_have_sbuser' => "Presence Builder를 사용하여 사이트를 만들고 게시할 수 없음: Presence Builder 사용자가 없습니다.",

    '__component_disabled' => "구성 요소 해제됨",

    'subdomains__physical_path_not_exist' => "존재하지 않는 실제 폴더와 연결된 하위 도메인이 있습니다.",

    'dnsserver_bind_to_msdns_switching_warning' => "경고: 액세스 제어 목록에 있는 마스크가 /8과 /16인 서브넷의 처음 254개 IP 주소만 전송됩니다. 개별 IP 주소로 전송됩니다. 계속하시겠습니까?",

    '__sbnet_net_framework_required_for_site' => "Presence Builder 사이트를 사용하려면 도메인에 ASP.NET 2.0 지원이 필요할 수 있습니다. Presence Builder를 사용하는 경우 ASP.NET 2.0 지원을 활성화하는 것이 좋습니다.",

    'subdomain_auto_create_dir' => "하위 도메인의 실제 디렉터리 생성",

    'sa_trainer__unable_to_get_messages_list' => "사서함에 있는 메시지 목록을 가져올 수 없음: %1",
    'sa_trainer__pass_doesnt_exist' => "이 메일 계정에 대한 암호가 없습니다.",

    '__sitebuilder_error' => "Presence Builder에 연결하는 동안 오류가 발생했습니다. 서비스 공급자에게 연락하여 도움을 요청하십시오.",
    'wsb_error_user_not_exist' => "이 Presence Builder 사용자 계정이 존재하지 않습니다.",
    'wsb_error_site_already_exist' => "이 사이트는 Presence Builder에 이미 있습니다.",
    'wsb_error_site_limit_reached' => "Presence Builder 사이트 수 제한에 도달했습니다.",
    'wsb_error_internal_error' => "내부 Presence Builder 오류가 발생함: 서비스 공급자에게 연락하여 도움을 요청하십시오.",
    'wsb_error_user_already_exist' => "해당 이름을 가진 Presence Builder 사용자가 Presence Builder에 이미 있습니다.",
    'sb_error_user_not_exist' => "Presence Builder 사용자가 없습니다.",
    'wsb_error_object_not_found' => "Presence Builder가 올바른 호스트 항목을 찾을 수 없습니다.",

    'mg_no_mail_groups' => "메일 그룹 없음",

    'drweb__drweb_incoming' => '수신 메일의 안티 바이러스 검사',
    'drweb__drweb_outgoing' => '송신 메일의 안티 바이러스 검사',
    'drweb__disable_reason_serv' => '메일 서버가 사서함 수준의 안티 바이러스 필터 설정을 지원하지 않습니다.',

    'vz_sitebuilder3_client_cant_be_created' => "고객 계정을 만들 수 없음: SiteBuilder 버전 3.1 이상이 설치되지 않았습니다.",

    'chown__client_without_sitebuilder_support' => "구독 이전을 계속할 수 없음: Presence Builder 서비스가 새 소유자 또는 공급자의 서비스 플랜에 포함되어 있지 않습니다.",

    // new limits

    'class_client__max_odbc' => "ODBC 연결",
    'cl_perm__max_odbc' => "ODBC 연결 최대 수",

    // domain aliases DNS
    'domain_alias__list_status' => 'S',
    'domain_alias__list_name' => '도메인 별칭 이름',
    'domain_alias__list_ascii_name' => 'ASCII 형식',


    // Interface Customization Templates
    'interface_preferences' => '인터페이스 관리',
    'pb__interface_templates' => '인터페이스 관리',
    'pb__interface_clients' => '다음을 사용하는 고객 %1',

    // service management
    'bt_service_showall' => "모두 표시",
    'bt_service_hideall' => "모두 숨기기",
    'bt_service_start' => "시작",
    'bt_service_stop' => "중지",
    'bt_service_restart' => "다시 시작",
    'bt_service_disable' => "끄기",
    'bt_service_manual' => "수동",
    'bt_service_auto' => "자동",
    'comp_info__statup_type' => '시작 유형',
    'service_startup_auto' => '자동',
    'service_startup_manual' => '수동',
    'service_startup_disabled' => '해제됨',
    'service_action_ok' => "%1 서비스에 대한 작업이 완료되었습니다.",
    'service_action_failed_disabled_service' => "%1 서비스가 해제되어 있어 이 서비스에 대한 작업을 완료할 수 없습니다.",
    'service_action_failed_error' => "작업을 완료할 수 없음: %1",
    'service_group_action_ok' => "다음 서비스에 대한 작업이 완료됨: \n %1",
    'service_group_action_disabled' => "다음 서비스가 해제되어 있기 때문에 이 서비스에 대한 작업을 완료할 수 없음: \n %1",
    'service_group_action_failed' => "다음 서비스에 대한 작업을 완료할 수 없음: \n %1. \n 상세한 오류 정보를 확인하려면 각 서비스에 대한 작업을 개별적으로 수행하십시오.",

    // php 4vs5
    'bt_php' => "PHP 설정",

    // Mass mail

    'massmail__resellers_list_available_for_select' => '사용 가능한 리셀러',
    'massmail__resellers_list_selected' => '선택한 리셀러',
    'massmail__clients_list_available_for_select' => '사용 가능한 고객',
    'massmail__clients_list_selected' => '선택한 고객',
    'massmail__advanced' => '고급',
    'bt_massmail_send' => '보내기',
    'massmail__save_template_name' => '명명된 새 템플릿에 텍스트 저장',
    'massmail__template' => '템플릿',
    'massmail__compose_mail' => '메시지',
    'massmail__from' => '시작',
    'massmail__to' => '받는 사람',
    'massmail__subject' => '제목',
    'massmail__body' => '메시지 텍스트',
    'massmail__body_hint' => '사용자 이름을 메시지에 자동으로 삽입하려면 <name> 변수를 사용합니다.',
    'massmail__send_to_clients' => "고객",
    'massmail__send_to_domainusers' => "도메인 관리자",
    'massmail__send_to_admins' => "Plesk 관리자",
    'massmail_select' => '주소 선택',
    'massmail_showhide_selected' => "선택 항목 표시/숨기기",
    'massmail_send_all' => "모두",
    'massmail_send_selected' => "선택 항목만",
    'massmail_send_except' => "선택 항목을 제외하고 모두",
    'bt_new_mass_mail_template' => "대량 이메일 템플릿 추가",
    '__mass_mail_templates_list' => "대량 이메일 메시지 템플릿 목록",
    'massmail__template_name' => '템플릿 이름',
    'massmail__receivers' => '수신자',
    'massmail__created' => '발신자',
    'massmail__date_created' => '만든 날짜',
    'massmail__compose' => '보내기',
    'mass_mail__resellers_all' => '모든 리셀러',
    'mass_mail__clients_all' => '모든 고객',
    'mass_mail__domainusers_all' => '모든 도메인 관리자',
    'mass_mail__resellers_selected' => '선택한 리셀러',
    'mass_mail__clients_selected' => '선택한 고객',
    'mass_mail__domainusers_selected' => '선택 도메인 관리자',
    'mass_mail__resellers_except' => '선택 리셀러를 제외한 모든 리셀러',
    'mass_mail__clients_except' => '선택 고객을 제외한 모든 고객',
    'mass_mail__domainusers_except' => '선택 도메인 관리자를 제외한 모든 도메인 관리자',
    'mass_mail__admins_all' => '모든 관리자',
    'massmailtemplateslist__title' => '대량 이메일 메시지 템플릿',
    'massmail__insert_from_template' => "템플릿 데이터 삽입",
    'massmail__select_template' => "템플릿 선택",
    'massmail__body_short_hint' => "(일반 텍스트만)",
    'massmail__from_short_hint' => "(이메일 또는 이름)",
    'bt_insert' => "삽입",
    'massmail__mail_send_successfully' => "메시지가 발송되었습니다.",
    'massmail__mail_send_successfully_with_some_errors' => "메시지가 발송되었지만 여러 오류가 발생했습니다. 수신자 중 일부가 메시지를 받지 못할 수 있습니다. 자세한 내용은 다음 로그 파일을 참조하십시오: %plesk_dir%\\admin\\logs\\send_mass_mail.log",
    'massmail__mail_send_failed' => "메시지가 발송되지 않았습니다. 수신자가 한명 이상 선택되었고 Plesk의 메일 서버가 올바르게 작동하는지 확인하십시오. 자세한 내용은 다음 로그 파일을 참조하십시오: %plesk_dir%\\admin\\logs\\send_mass_mail.log",
    'massmail__template_data_inserted' => "템플릿 %1의 데이터가 삽입되었습니다.",
    'massmail__template_added_successfully' => "메시지 템플릿이 이름 %1(으)로 저장되었습니다.",

    // wsb integration
    'wsb_error_sitebuilder_database_error' => "Presence Builder 데이터베이스 오류가 발생함: 서비스 공급자에게 연락하여 도움을 요청하십시오.",
    'wsb_error_sitebuilder_access_denied_error' => "파일에 액세스할 수 없음: Presence Builder에 필요한 파일 또는 폴더에 대한 액세스 권한이 없습니다. 서비스 공급자에게 연락하여 도움을 요청하십시오.",
    'wsb_error_sitebuilder_connection_failed' => "연결이 끊겨서 Presence Builder에 연결할 수 없음: 서비스 공급자에게 연락하여 도움을 요청하십시오.",
    'wsb_error_critical_during_operation' => "중요 Presence Builder 오류가 발생함: \n%1",
    'wsb_error_license_during_operation' => "Presence Builder 라이센스 오류가 발생함: \n%1",
    'wsb_error_during_operation' => "Presence Builder 오류가 발생함: \n%1",
    'wsb_error_license_error' => "Presence Builder 라이센스 제한이 발생했습니다.",

    // Other
    '__confrim_service_stop' => "경고! 서비스 %1을(를) 중지하면 Plesk 작동이 중지될 수 있습니다. 서비스 %1을(를) 중지하시겠습니까?",
    'virtualdir__name_is_reserved' => "예약된 이름입니다.",
    'index_redirect_help_text' => '이제 필요한 웹 사이트로 자동 리디렉션됩니다. 브라우저가 리디렉션을 지원하지 않으면 %1 여기 %2를 클릭하십시오.',
    'bt_default_settings' => "기본값 복원",
    'logfiles__remove_failed' => "%1 파일을 삭제할 수 없음: 이 파일은 다른 응용 프로그램에 의해 잠겨 있습니다. 나중에 다시 시도하십시오.",
    'subdomain__invalid_homedirectory' => "지정한 하위 도메인 홈 디렉터리가 잘못되었습니다.",
    'scheduler_item__empty_filename' => "실행할 실행 파일을 지정하십시오.",
    'subdomains__overlapped_domain_exists' => '하위 도메인이 도메인의 DNS 영역과 중첩됩니다. %1',
    'subdomains__overlapped_domain_alias_exists' => '하위 도메인이 도메인 별칭의 DNS 영역과 중첩됩니다. %1',
    'services_action_none_selected' => '작업을 완료할 수 없음: 필요한 서비스를 선택하십시오.',
    'cl_perm__max_subftp_users' => "추가 FTP 계정 최대 수",
    'login_up__access_denied_no_cp_access' => '접속이 거부되었습니다. Plesk에 접속할 권한이 없습니다.',
    'drweb__disable_reason_admin' => "서버 정책에서 사서함 수준의 안티 바이러스 필터 설정을 허용하지 않습니다.",

    'webdirs__name_is_invalid' => '디렉터리 이름에는 영숫자, 밑줄 및 대시 문자만 사용합니다.',
    'webdirs__physical_path_is_invalid' => '실제 경로가 잘못되었거나 없습니다.',
    '__use_default' => '기본값 사용',

    'webalizer_hidden_referrer__already_exist' => '해당 항목이 이미 있습니다.',
    'webalizer_group_referrer__already_exist' => '해당 이름의 그룹 참조 페이지가 이미 있습니다.',

    'pb__dashboard' => '홈',

    'server_interface__page_title' => '서버 인터페이스 설정',
    'server_interface__tabs_locales' => '로켈',
    'server_interface__tabs_skins' => '스킨',
    'server_interface__tabs_interface_templates' => '인터페이스 템플릿',
    'bt_server_interface' => '인터페이스 기본 설정',
    'pb__server_interface' => '인터페이스 기본 설정',

    'bt_wizard_next' => '다음 >>',
    'bt_wizard_prev' => '<< 뒤로',

    '__limit_exceeded_max_dom_server' => '라이센스 키로 서버에서 허용된 도메인 수 제한이 초과되었기 때문에 이 서버에서 도메인을 추가로 호스팅할 수 없습니다. 서비스 공급자에게 연락하여 이 문제를 해결하십시오.',
    '__limit_exceeded_max_subdom_server' => '이 서버에 하위 도메인을 추가로 호스팅할 수 없습니다. 서비스 공급자에게 연락하십시오.',
    '__limit_exceeded_max_dom_aliases_server' => '이 서버에 도메일 별칭을 추가로 설정할 수 없습니다. 서비스 공급자에게 연락하십시오.',
    '__limit_exceeded_max_wu_server' => '라이센스 키로 서버에서 허용된 웹 사용자 수 제한에 도달했기 때문에 웹 사용자를 추가로 만들 수 없습니다. 서비스 공급자에게 연락하여 이 문제를 해결하십시오.',
    '__limit_exceeded_max_mn_server' => '라이센스 키로 서버에서 허용된 메일 계정 수 제한에 도달했기 때문에 메일 계정을 추가로 만들 수 없습니다. 서비스 공급자에게 연락하여 이 문제를 해결하십시오.',

    '__limit_exceeded_max_cl_useradmin' => '라이센스 키에 정의된 고객 계정 수 제한(%2)에 도달했습니다.',
    '__limit_exceeded_max_dom_useradmin' => '라이센스 키에 정의된 도메인 수 제한(%2)에 도달했습니다.',
    '__limit_exceeded_max_subdom_useradmin' => '라이센스 키에 정의된 하위 도메인 수 제한(%2)에 도달했습니다.',
    '__limit_exceeded_max_dom_aliases_useradmin' => '라이센스 키로 정의된 도메인 별칭 수 제한에 도달했습니다(%2).',
    '__limit_exceeded_disk_space_useradmin' => '사용 가능한 디스크 공간이 없습니다.',
    '__limit_exceeded_max_wu_useradmin' => '라이센스 키에 정의된 웹 사용자 계정 수 제한(%2)에 도달했습니다.',
    '__limit_exceeded_max_db_useradmin' => '라이센스 키에 정의된 데이터베이스 수 제한(%2)에 도달했습니다.',
    '__limit_exceeded_max_box_useradmin' => '라이센스 키(%2)에 정의된 사서함 수 제한에 도달했습니다.',
    '__limit_exceeded_max_mn_useradmin' => '라이센스 키에 정의된 이메일 계정 수 제한(%2)에 도달했습니다.',
    '__limit_exceeded_max_maillists_useradmin' => '라이센스 키에 정의된 메일링 리스트 수 제한(%2)에 도달했습니다.',

    '__limit_exceeded_max_dom_userclient' => '도메인 수 제한(%2)에 도달했습니다.',
    '__limit_exceeded_max_subdom_userclient' => '서비스 공급자가 허용한 하위 도메인 수 제한(%2)에 도달했습니다.',
    '__limit_exceeded_max_dom_aliases_userclient' => '도메인 별칭 수 제한에 도달했습니다(%2).',
    '__limit_exceeded_disk_space_userclient' => '디스크 공간 사용량 제한에 도달했습니다(%2).',
    '__limit_exceeded_max_traffic_userclient' => '월간 대역폭 사용량 제한(%2)에 도달했습니다.',
    '__limit_exceeded_max_wu_userclient' => '서비스 공급자가 허용한 웹 사용자 수 제한(%2)에 도달했습니다.',
    '__limit_exceeded_max_db_userclient' => '데이터베이스 수 제한에 도달했습니다(%2).',
    '__limit_exceeded_max_box_userclient' => '사서함 수 제한에 도달했습니다(%2).',
    '__limit_exceeded_max_maillists_userclient' => '메일링 리스트 수 제한에 도달했습니다(%2).',
    '__limit_exceeded_expiration_userclient' => '계정이 다음 날짜에 만료됨 %2',

    '__limit_exceeded_max_subdom_userdomain' => '서비스 공급자가 허용한 하위 도메인 수 제한(%2)에 도달했습니다.',
    '__limit_exceeded_max_dom_aliases_userdomain' => '도메인 별칭 수 제한에 도달했습니다(%2).',
    '__limit_exceeded_disk_space_userdomain' => '디스크 공간 사용량 제한에 도달했습니다(%2).',
    '__limit_exceeded_max_traffic_userdomain' => '월간 대역폭 사용량 제한(%2)에 도달했습니다.',
    '__limit_exceeded_max_wu_userdomain' => '웹 사용자 계정 수 제한(%2)에 도달했습니다.',
    '__limit_exceeded_max_db_userdomain' => '데이터베이스 수 제한에 도달했습니다(%2).',
    '__limit_exceeded_max_box_userdomain' => '사서함 수 제한에 도달했습니다(%2).',
    '__limit_exceeded_max_maillists_userdomain' => '메일링 리스트 수 제한에 도달했습니다(%2).',
    '__limit_exceeded_expiration_userdomain' => '계정이 다음 날짜에 만료됨 %2',

    'mmt__to_none' => '없음',
    'mmt__to_admin' => '관리자',
    'mmt__to_resellers_all' => '모든 리셀러',
    'mmt__to_resellers_select' => '선택한 리셀러',
    'mmt__to_resellers_select__available' => '사용 가능한 리셀러',
    'mmt__to_resellers_except' => '선택 리셀러를 제외한 모든 리셀러',
    'mmt__to_clients_all' => '모든 고객',
    'mmt__to_clients_select' => '선택한 고객',
    'mmt__to_clients_select__available' => '사용 가능한 고객',
    'mmt__to_clients_except' => '선택 고객을 제외한 모든 고객',

    'mmt__unable_send_empty_selection' => '대량 메일을 보낼 수 없음, 이메일 주소를 선택하지 않았습니다.',
    'mmt__unable_send_to__' => '다음으로 대량 메일을 보낼 수 없음:',
    'mmt__unable_send_to_email' => '%1 <%2>',

    'sapp_error_validation_not_found' => '필수 파일 중 하나(%1)를 찾을 수 없어 웹 응용 프로그램의 유효성을 검사할 수 없습니다. 기술 지원 담당자에게 연락하여 도움을 요청하십시오.',
    'sapp_error_validation_spec_failed' => '업로드된 웹 응용 프로그램이 AppPacks 사양을 충족하지 않음: %1.',
    'sapp_error_validation_register' => '%1 디렉터리에 있는 웹 응용 프로그램을 등록할 수 없음: %2 웹 응용 프로그램이 올바르게 작동하지 않기 때문에 서버에서 제거해야 합니다.',

    'sapp__install_failed' => '웹 응용 프로그램 설치 실패: %1',
    'sapp__install_res_failed' => '요청한 리소스를 만들지 못했습니다.',

    'server_preferences__subdomains_blog_and_photo' => '기본적으로 블로그 및 사진 갤러리 하위 도메인 생성',
    'plesk_key__blog_and_photo' => '블로그 및 사진 갤러리 하위 도메인 생성 확인란의 기본 상태 관리 기능',
    'ip_ctrl__cannot_make_exclusive_ip_with_more_than_one_client' => 'IP 주소가 둘 이상의 사용자에게 할당되어서 IP 주소 유형을 전용으로 변경할 수 없습니다.',

    // 8.1.1

    '__write_modify_warning' => '추가 쓰기/수정 권한을 선택하면 일부 웹 응용 프로그램이 올바르게 작동하게 되지만 보안 위험도 크게 증가합니다.',
    '__write_modify_subdomain_warning' => '추가 쓰기/수정 권한을 선택하면 일부 웹 응용 프로그램이 올바르게 작동하게 되지만 보안 위험도 크게 증가합니다.',

    'phosting__php_incorrect_version_used' => "PHP 버전 문제가 탐지되었습니다. 이 문제를 해결하려면 필요한 PHP 버전 확인란을 선택하고 확인을 클릭하십시오. 이 도메인에서 PHP를 해제하려면 PHP 버전을 선택하지 않고 확인을 클릭하십시오.",
    'fp__mail_preferences' => '메일 설정',

    'mail__invalid_white_pattern' => '유효하지 않은 값이 지정되었습니다. 다음 입력 형식을 사용하십시오. 이메일의 경우, mail@example.com이고 도메인의 경우 example.com이 허용됩니다.',
    'mail__invalid_black_pattern' => '유효하지 않은 값이 지정되었습니다. 다음 입력 형식을 사용하십시오. 이메일의 경우, mail@example.com이고 도메인의 경우 example.com이 허용됩니다.',

    'resp_edit__reply_as_html' => 'HTML로 보내기',
    'exception__path_very_long' => "경로가 너무 깁니다. 경로 길이가 %1자 미만이어야 합니다.",

    // 8.2


    //SAPP
    'sapp_on' => '켜기',
    'sapp_off' => '끄기',
    'sapp_directive_aspect' => '요청',
    'sapp_databases_num' => '데이터베이스',
    'sapp_db_required' => '요청',
    'sapp_Required' => '요청',
    'sapp_Variant' => '변형',
    'sapp_db_id' => '데이터베이스 ID',
    'sapp_db_id_type' => 'DB(ID: %1) 유형',
    'sapp_db_id_min_version' => 'DB(ID: %1) 최소 버전',
    'sapp_db_id_table_prefix' => 'DB(ID: %1) 테이블 접두사',
    'sapp_Default' => '기본값',
    'sapp_apache_mod_req' => 'Apache 모듈',
    'sapp_dbtype_not_installed' => '설치되지 않음',
    'sapp_apache_mod_not_installed' => '설치되지 않음',
    'sapp__value_error_empty' => '빈 값은 허용되지 않습니다.',
    'sapp_error_invalid_type' => '%1 응용 프로그램이 요청된 작업을 지원하지 않습니다.',
    'sapp_error_unknown_app_type' => '지원되지 않는 응용 프로그램 유형: %1.',
    'sapp__ssl_text' => '응용 프로그램을 http:// 또는 https:// 가상 호스트에 설치할까요?',
    'sapp__app_to_upgrade' => '업그레이드할 응용 프로그램',
    'sapp__upgrade_apps_title' => '응용 프로그램 업그레이드',
    'sapp__upgrade_to_ver' => '다음 버전으로 업그레이드',
    'sapp__choose_pkg_ver' => '패키지 선택...',
    'sapp__pkg_cant_upgrade_pkg' => '%1 패키지는 웹 응용 프로그램 %2의 업그레이드에 사용할 수 없습니다.',
    'sapp__app_ugrade_error' => '응용 프로그램을 업그레이드할 수 없음: %1. 시스템 관리자에게 연락하십시오.',
    'sapp__no_suitable_db_found' => '적합한 데이터베이스를 찾을 수 없음.',
    'sapp__upgrade_success' =>  '응용 프로그램이 업그레이드되었습니다.',
    'sapp__pkg_info_changelog' => '변경 내역',
    'sapp_requirement_legend' => '응용 프로그램에서 요청한 호스팅 기능',

    // other
    'bt_apply' => '적용',
    'mn_edit__add_alias_if_mailbox_disabled' => '메일 별칭을 생성하려면 이 메일 계정에 대한 사서함을 설정해야 합니다. 사서함을 설정하시겠습니까?',
    'mn_edit__mailbox_disable_if_has_alias' => '사서함을 해제하면 작동이 중지된 후 메일 별칭이 제거됩니다. 사서함을 해제하시겠습니까?',
    'antivirus__disable_reason_install' => '안티 바이러스가 설치되지 않아서 안티 바이러스를 관리할 수 없습니다.',
    'antivirus__disable_reason_key' => '안티 바이러스가 올바른 라이센스 키로 활성화되지 않아서 안티 바이러스를 관리할 수 없습니다.',
    'antivirus__disable_reason_deny_personal_settings' => '서버 정책에서 개별 안티 바이러스 설정을 금지하므로 안티 바이러스를 관리할 수 없습니다.',
    'change_foreign_user_password' => '암호 변경',
    'change_foreign_user_password_hint' => "사용자가 이 응용 프로그램에 속하지 않습니다. 링크를 클릭하여 다른 응용 프로그램으로 이동한 후 사용자 암호를 변경하십시오. 이를 위해 응용 프로그램에서 적합한 권한이 있어야 합니다.",
    'cf_url_text' => 'JDBC URL',
    'cf_sendStringParametersAsUnicode_text' => '문자열 형식',
    'lang_unknown' => '알 수 없는 언어',
    'pb__cl_ed' => '고객 세부 정보',
    'pb__actionlog' => '작업 로그',
    'pb__cl_limits' => '고객 제한',
    'pb__edit' => '편집',
    'pb__subdom_edit' => '호스팅 설정',

    // NEW 8.3 FEATURES

    'backup_mail_content' => '사서함 내용 백업',

    'maillist_import_result' => "\n파일에 있는 총 이메일 주소 양: %1\n가져온 이메일 주소의 양: %2\n기존 이메일 주소의 양: %3\n지정한 파일에 있는 중복된 이메일 주소의 양: %4\n파일에 있는 잘못된 이메일 주소의 양: %5",
    'maillist_import_error' => '이메일 주소 목록을 가져올 수 없음',

    //  spaw

    'spaw__unable_to_edit_no_body' => "선택한 파일이 비어 있거나 선택한 인코딩에서 유효한 HTML 문서가 아닙니다. 올바른 인코딩을 선택하거나 새 내용을 파일에 추가하십시오.",

    'dom_pref__external_mail_srv' => "IP 주소를 사용하여 외부 메일 서버로 리디렉션:",
    'mn_edit__store_messages' => '사서함',

    // aps

    'sapp__before_upgrade_notice' => '업그레이드 프로세스를 시작하기 전에 응용 프로그램과 사용자 데이터를 백업하는 것이 좋습니다.',
    'sapp__application_properties' => '응용 프로그램 속성',
    'sapp__application_root_descr' => '응용 프로그램의 메인 페이지',

    'sapp__aps_license_invalid_id' => '라이센스 키 ID가 잘못됨: %1.',
    'sapp__aps_lic_key_alredy_exists' => '키 번호가 %1인 라이센스가 데이터베이스에 이미 있습니다',
    'sapp__aps_lic_del_used' => '라이센스 키를 삭제할 수 없습니다. 설치된 응용 프로그램 중 하나가 사용 중입니다.',
    'sapp__aps_lic_del_unknown' => '라이센스 키를 삭제할 수 없음: %1',
    'sapp__aps_cappi_duplicate' => "이 응용 프로그램은 이미 이 고객의 응용 프로그램 풀에 있습니다.",
    'sapp__appi_not_shared_no_install' => "고객의 응용 프로그램 풀에 이러한 응용 프로그램이 없습니다. 사이트에 이 응용 프로그램을 설치하려면 우선 이 응용 프로그램을 고객의 응용 프로그램 풀에 추가해야 합니다.",
    'sapp__appi_shared_not_client' => "고객의 응용 프로그램 풀에 이러한 응용 프로그램이 없습니다. 응용 프로그램을 지정된 버전으로 업그레이드하려면 우선 이 응용 프로그램 버전을 고객의 응용 프로그램 풀에 추가해야 합니다.",
    'sapp__apply_license_script_not_found' => '이 웹 응용 프로그램에 대한 라이센스 적용 스크립트를 찾을 수 없음.',
    'sapp__unable_to_activate_key' => '라이센스 키를 활성화하려는 동안 오류 발생: %1',
    'sapp__unable_to_delete_ai_instances_exists' => '시스템에 이 웹 응용 프로그램이 있어야만 사용할 수 있는 웹 응용 프로그램이 설치되어 있습니다.',
    'sapp__unable_to_delete_ai_in_pool' => '이 응용 프로그램이 아직 고객의 풀에 있습니다. 이 응용 프로그램을 제거하려면 먼저 이 응용 프로그램을 모든 고객의 응용 프로그램 풀에서 제거하거나 무료로 만들어야 합니다.',
    'sapp__unable_to_delete_app_template' => '응용 프로그램 번호 %1을(를) 제거할 수 없음: %2',
    'sapp__limit_exceeded_client' => '이 웹 응용 프로그램(%2)을 설치할 수 있는 횟수 제한에 도달했습니다.',


    // atis module

    '_week_on' => '다음 주',
    '__week_first' => '최초',
    '__week_second' => '초',
    '__week_third' => '3번째',
    '__week_fourth' => '4번째',
    '__week_last' => '마지막',
    '__not_started' => '기다리는 중',
    '__started' => '실행',
    '__cancel_pending' => '취소',
    '__canceled' => '취소됨',
    '__error' => '오류',
    '__done' => '완료',

    '__php_cgi_handler' => 'CGI 응용 프로그램',
    '__php_isapi_handler' => 'ISAPI 확장',
    '__php_fastcgi_handler' => 'FastCGI 응용 프로그램',
    '__php_module_handler' => 'mod_php',
    '__php_run_as' => '다음으로 실행',

    'cf_dbfolder_text' =>'데이터베이스 폴더',
    'cf_isnewdb_text' => '데이터베이스 생성',
    'cf_isnewdb_title' => '데이터베이스를 생성해야 하는 경우 확인란을 선택합니다.',

    'pb__site_apps_upgrade' => '웹 응용 프로그램 업그레이드',

    'detach' => '분리',
    'preferences' => "암호 변경",

    'toolsbar__switch_user?' => "다른 사용자 계정으로 로그인하시겠습니까?",
    '__aps_left' => '남은 설치 수',
    'aps__license_key' => '라이센스 키',
    'aps__download_code' => '라이센스 키 다운로드 및 활성화 코드',
    'aps__license_key_hint' => '활성화 코드를 사용하여 라이센싱 서버에서 검색',
    'aps__database_not_available' => '사용할 수 없음, 도메인 또는 고객 제한을 확인하십시오.',
    'aps__yes' => '예',
    'aps__no' => '아니요',
    '__click_to_enlarge' => '확대하려면 클릭',
    'site_apps__back_to_list' => '목록으로 돌아가기',
    'sapp__pkg_info_installation_requirements' => '설치 요구 사항',
    '__close_window' => '닫기',

    //SAPP END

    'skin_info__already_default' => '스킨이 이미 기본 스킨으로 설정되었습니다.',

    //move this to other file after splitting drweb to module
    'drweb:virus_filter_full_name' => 'Plesk Premium Antivirus',
    'drweb:properties_page_title' => '다음에 대한 Plesk Premium 안티 바이러스 설정 %1',
    'drweb:properties_legend' => '설정',
    'drweb:status' => '메일에서 바이러스 검사 중',

    // sb integration
    'sitebuilder_wizard' => 'Presence Builder 마법사',
    'dom_site_builder' => 'Presence Builder 마법사를 열려면 클릭합니다.',
    'sb_plesk_admin_url' => 'Presence Builder 서버 URL. 이 주소는 DNS에서 올바르게 확인되어야 합니다.',
    'sb_plesk_admin_login' => 'Presence Builder에 대한 서버 관리자 로그인을 위한 사용자 이름',
    'sb_plesk_admin_password' => '관리자의 암호',
    'sb_sitebuilder_preferences' => 'Presence Builder 관리자 자격 증명',
    'sb__server' => 'Presence Builder 시스템 관리자 기본 설정',
    'sb__sitebuilder_support' => 'Presence Builder 지원',
    'sb_keep_sb_user' => 'Presence Builder에서 해당 사용자 계정 유지',
    'sb_create_sb_user' => 'Presence Builder에서 해당 사용자 계정 만들기',
    'sb__build_site_using_sitebuilder' => "Presence Builder를 사용하여 웹 사이트 만들기",
    'sb_no_current_sb_server_set' => 'Presence Builder에 대한 연결이 아직 구성되지 않음: Presence Builder 서버를 가리킬 A 레코드를 DNS 영역 템플릿에 추가해야 합니다.',
    'sb_unable_update_sb_server_sb_return_message' => "Presence Builder 시스템에서 정보를 검색할 수 없음:\n%1",
    'sb_unable_connect_sb_wrong_con_params' => "Presence Builder에 연결할 수 없음: 잘못된 사용자 이름 또는 암호.",
    'sb_init_sb_manager' => "Presence Builder 관리자 초기화: %1",
    'sb_err_couldnt_connect_sb' => "Presence Builder 시스템에 연결하지 못했습니다.",
    'sb_err_client_dont_have_sbuser' => "이 고객은 Presence Builder에 사용자 계정이 없습니다.",
    'sb_err_sitebuilder_not_configured' => "Presence Builder가 구성되지 않았습니다.",
    'sb_err_you_dont_have_sbaccount' => "Presence Builder에서 승인을 받지 못했습니다.",
    'sb_error_critical_during_operation' => "Presence Builder에서 다음 오류가 발생함:\n%1",
    'sb_err_sso_is_not_enabled' => "Plesk에 단일 사인온 지원이 설정되어 있지 않습니다.",

    'warning__super_zone_exist' => "%1 영역이 만들어졌습니다. 그러나 이 영역 이름은 이미 존재하는 다른 영역 %2(이 영역은 다른 사용자 %3에게 속함)의 하위 영역입니다. 가능하기는 하지만 올바른 사용자 계정을 선택했는지 확인하기 바랍니다.",
    'error__super_zone_exist' => "상위 영역이 다른 사용자에게 속하기 때문에 DNS 영역을 만들 수 없음.",

    'locales__files_not_exits' => '로켈을 변경할 수 없음: 시스템에 지정한 인터페이스 언어 팩 파일이 없습니다.',
    'locales__unavailable' => '로켈을 변경할 수 없음: 지정한 인터페이스 언어 팩을 사용할 수 없습니다.',

    // DB BU

    'pb__dbbackup_list' => '데이터베이스 백업 파일',
    // server
    'dbbackup__server_backup_settings' => '백업',
    'dbbackup__network_temp_dir' => '임시 네트워크 디렉터리',
    'dbbackup__network_user' => '사용자 이름',
    'dbbackup__network_pass' => '암호',
    // domain
    'dbbackup__add_database_legend' => '백업된 데이터베이스 복원',
    'dbbackup__add_database_restore' => '백업 파일에서 데이터베이스 복원',
    'dbbackup__add_database_file' => '데이터베이스 백업 파일',
    'dbbackup__add_database_user' => '기본 사용자 이름',
    'dbbackup__add_database_pass' => '기본 사용자 암호',
    'dbbackup__add_database_pass2' => '기본 사용자 암호 확인',

    'bt_dbbackup_now' => '백업',

    'bt_repair' => '복구',

    'dbbackup__mssql_dump_upload_not_allowed' => 'SQL Server 데이터베이스 덤프 업로드가 호스팅 공급자에 의해 금지되었습니다.',

    // APS categories

    'cf_invalid_password' => '암호는 16자를 초과할 수 없습니다.',
    'cf_invalid_description_length' => '설명은 256개 기호를 초과할 수 없습니다.',
    'ip_addr__ip_used_by_external_mail_server' => 'IP 주소 %1은(는) 외부 메일 서버에서 이미 사용 중입니다.',

    // 8.4.1

    '__ftp_login_is_invalid' => 'FTP 계정 사용자 이름 또는 암호가 잘못되었습니다. 올바른 FTP 사용자 자격 증명을 지정하십시오.',

    // 8.6

    'dns__dns_serial_update_limit_warning' => '일련 번호 변경 제한에 도달했습니다. 오늘은 DNS 영역 변경을 더 이상 수행할 수 없습니다.',
    'dns__zone_apply_changes' => 'DNS 레코드에 이루어진 변경 내용이 아직 저장되지 않았습니다. 수행된 변경 내용이 아래에 강조 표시되어 있습니다. DNS 영역에 변경 내용을 적용하려면 ‘업데이트’를 클릭하거나 변경을 취소하려면 ‘되돌리기’를 클릭하십시오.',
    'dns__update_dns_zone' => 'DNS 레코드에 이루어진 변경을 저장하려면 클릭합니다.',
    'dns__revert_dns_zone' => 'DNS 레코드에 이루어진 변경을 취소하려면 클릭합니다.',
    'bt_revert' => '되돌리기',
    'dns__dns_zone_has_beed_updated' => 'DNS 레코드에 이루어진 변경이 저장되었습니다.',
    'dns__dns_zone_has_beed_reverted' => 'DNS 레코드에 이루어진 변경이 취소되었습니다.',
    'db__nondefault_server_not_allowed' => '기본 이외의 데이터베이스 서버 사용이 허용되지 않습니다.',


    //// UI POINTER CAPTIONS START HERE
    ////
    // *** The strings below have been generated automatically from @@CAPTION directives.

    'ui__client__description' => '%1 고객의 계정 및 도메인.',
    'ui__client__disabled-warning' => '%1 고객 계정이 일시 중단되었습니다.',
    'ui__client__none-available' => '구성된 고객 계정이 없습니다.',
    'ui__client__short-title' => '%1',
    'ui__client__title' => '고객 %1',
    'ui__client_self__description' => '내 도메인 목록.',
    'ui__client_self__short-title' => '내 도메인',
    'ui__client_self__title' => '내 도메인',


    'site_apps__non_removable' => '제거할 수 없는 항목',
    'site_apps__non_removable_items' => '다음 웹 응용 프로그램을 제거할 수 없음:',

    'ui__client/custom-buttons/custom-button__none-available' => '사용자 지정 버튼이 없습니다.',
    'ui__client/custom-buttons/custom-button__none-available__1' => '고객 %1의 고객 패널에 사용자 지정 버튼이 없습니다.',

    'ui__client/custom-buttons/custom-button/delete__description' => '버튼 제거 %1.',
    'ui__client/custom-buttons/custom-button/delete__short-title' => '제거',
    'ui__client/custom-buttons/custom-button/delete__title' => '버튼 제거 %1',
    'ui__client/custom-buttons/custom-button/delete_multi__description' => '고객의 고객 패널에서 사용자 지정 버튼 제거',
    'ui__client/custom-buttons/custom-button/delete_multi__short-title' => '제거',
    'ui__client/custom-buttons/custom-button/delete_multi__title' => '사용자 지정 버튼 제거',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard-title' => '버튼 제거',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => '사용자 지정 버튼을 제거하려는 고객을 선택하고 ‘다음 >>’을 클릭합니다.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__3_multi' => '제거하려는 버튼을 선택하고 ‘다음 >>’을 클릭합니다.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__4_multi' => '이 화면에서 확인란을 선택하여 버튼 제거를 확인한 다음 ‘마침’을 클릭합니다.',
    'ui__client/custom-buttons/custom-button/delete_unknown__description' => '고객의 고객 패널에서 사용자 지정 버튼을 제거합니다.',
    'ui__client/custom-buttons/custom-button/delete_unknown__short-title' => '제거',
    'ui__client/custom-buttons/custom-button/delete_unknown__title' => '사용자 지정 버튼 제거',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard-title' => '사용자 지정 버튼 제거',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => '사용자 지정 버튼을 제거하려는 고객을 선택하고 ‘다음 >>’을 클릭합니다.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => '제거하려는 사용자 지정 버튼을 선택하고 ‘다음 >>’을 클릭합니다.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__4' => '이 화면에서 확인란을 선택하여 사용자 지정 버튼 제거를 확인한 다음 ‘마침’을 클릭합니다.',

    'ui__client/custom-buttons/custom-button/properties__description' => '고객 수준 버튼 %1의 속성을 편집합니다.',
    'ui__client/custom-buttons/custom-button/properties__short-title' => '설정',
    'ui__client/custom-buttons/custom-button/properties__title' => '고객의 사용자 지정 버튼 수정 %1',
    'ui__client/custom-buttons/custom-button/properties_new__wizard-title' => '사용자 지정 버튼 추가',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__1_unknown' => '고객 패널에 사용자 지정 버튼을 생성하려는 고객을 선택하고 \'다음 >>\'을 클릭합니다.',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__4_new' => '‘마침’을 클릭하여 버튼을 만듭니다.',
    'ui__client/custom-buttons/custom-button/properties_unknown__description' => '고객의 고객 패널의 버튼 속성을 변경합니다.',
    'ui__client/custom-buttons/custom-button/properties_unknown__short-title' => '속성',
    'ui__client/custom-buttons/custom-button/properties_unknown__title' => '고객의 고객 패널의 버튼 속성 변경합니다',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard-title' => '사용자 지정 버튼 속성 변경',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => '사용자 지정 버튼을 수정하려는 고객을 선택하고 ‘다음 >>’을 클릭합니다.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => '수정하려는 사용자 지정 버튼을 선택하고 ‘다음 >>’을 클릭합니다.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__4' => '버튼의 속성을 모두 편집했으면 ‘마침’을 클릭하여 변경 내용을 적용하고 마법사를 종료합니다.',

    'ui__client/custom-buttons/custom-button/toggle_private__description' => '%1 버튼을 고객이 사용할 수 없도록 합니다.',
    'ui__client/custom-buttons/custom-button/toggle_private__short-title' => '고객이 사용할 수 없도록 함',
    'ui__client/custom-buttons/custom-button/toggle_private__title' => '%1 버튼을 고객이 사용할 수 없도록 함',
    'ui__client/custom-buttons/custom-button/toggle_public__description' => '%1 버튼을 고객의 사용자에게 표시합니다.',
    'ui__client/custom-buttons/custom-button/toggle_public__short-title' => '고객이 사용할 수 있도록 함',
    'ui__client/custom-buttons/custom-button/toggle_public__title' => '%1 버튼을 고객의 사용자에게 표시',
    'ui__client/custom-buttons/custom-button/toggle_unknown__description' => '사용자 지정 버튼을 고객이 사용할 수 있도록/사용할 수 없도록 합니다.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__short-title' => '고객이 사용할 수 있도록/사용할 수 없도록 함',
    'ui__client/custom-buttons/custom-button/toggle_unknown__title' => '사용자 지정 버튼을 고객이 사용할 수 있도록 또는 사용할 수 없도록 함',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard-title' => '사용자 지정 버튼을 고객이 사용할 수 있도록/사용할 수 없도록 합니다.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => '사용자 지정 버튼을 고객의 사용자가 사용할 수 있도록 하려는 고객을 선택하고 ‘다음 >>’을 클릭합니다.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => '고객이 사용할 수 있거나 사용할 수 없도록 하려는 사용자 지정 버튼을 선택하고 ‘다음 >>’을 클릭합니다.',

    'ui__client/domain__description' => '%1 도메인을 관리합니다.',
    'ui__client/domain__disabled-warning' => '%1 도메인이 일시 중단되었습니다.',
    'ui__client/domain__none-available' => '어떤 도메인도 없습니다.',
    'ui__client/domain__none-available__1' => '%1의 계정에 어떤 도메인도 없습니다.',
    'ui__client/domain__none-available__2' => '%1의 계정에 어떤 도메인도 없습니다.',
    'ui__client/domain__short-title' => '%1',
    'ui__client/domain__title' => '도메인 %1',
    'ui__client/domain_self__description' => '도메인을 관리합니다.',
    'ui__client/domain_self__disabled-warning' => '도메인이 일시 중단되었습니다.',
    'ui__client/domain_self__quick-search' => '내 도메인',
    'ui__client/domain_self__short-title' => '내 도메인',
    'ui__client/domain_self__title' => '내 도메인',

    'ui__client/domain/custom-buttons/custom-button__none-available' => '고객의 고객 패널에 배치된 사용자 지정 버튼이 없습니다.',
    'ui__client/domain/custom-buttons/custom-button__none-available__1' => '고객 %1의 고객 패널에 사용자 지정 버튼이 없습니다.',
    'ui__client/domain/custom-buttons/custom-button__none-available__2' => '%1 도메인에 대한 사용자 지정 버튼이 없습니다.',
    'ui__client/domain/custom-buttons/custom-button/delete__description' => '%1의 사용자 지정 버튼을 제거합니다.',
    'ui__client/domain/custom-buttons/custom-button/delete__short-title' => '제거',
    'ui__client/domain/custom-buttons/custom-button/delete__title' => '사용자 지정 버튼 제거 %1',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__description' => '사용자 지정 버튼을 제거합니다.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__short-title' => '제거',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__title' => '사용자 지정 버튼 제거',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard-title' => '사용자 지정 버튼 제거',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => '도메인 관리 패널에서 버튼을 제거하려는 고객을 선택하고 ‘다음 >>’을 클릭합니다.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__2_unknown' => '관리 패널에서 버튼을 제거하려는 도메인을 선택하고 ‘다음 >>’을 클릭합니다.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__4_multi' => '제거하려는 버튼을 선택하고 ‘다음 >>’을 클릭합니다.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__5_multi' => '해당 확인란을 선택하여 버튼 제거를 확인하고 ‘마침’을 클릭하여 버튼을 제거한 후 마법사를 종료합니다.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__description' => '사용자 지정 버튼을 제거합니다.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__short-title' => '제거',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__title' => '사용자 지정 버튼 제거',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard-title' => '사용자 지정 버튼 제거',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => '도메인 관리 패널에서 사용자 지정 버튼을 제거하려는 고객을 선택하고 ‘다음 >>’을 클릭합니다.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => '관리 패널에서 버튼을 제거하려는 도메인을 선택하고 ‘다음 >>’을 클릭합니다.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__4_unknown' => '제거하려는 사용자 지정 버튼을 선택하고 ‘다음 >>’을 클릭합니다.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__5' => '확인란을 선택하여 사용자 지정 버튼 제거를 확인하고 ‘마침’을 클릭하여 버튼을 제거한 후 마법사를 종료합니다.',

    'ui__client/domain/custom-buttons/custom-button/properties__title' => "사용자 지정 버튼의 속성 변경 %1",
    'ui__client/domain/custom-buttons/custom-button/properties__short-title' => "속성",
    'ui__client/domain/custom-buttons/custom-button/properties__description' => "고객 패널에서 사용자 지정 버튼 %1의 속성을 변경합니다.",

    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard-title' => '버튼 추가',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__1_unknown' => '고객 패널에 버튼을 배치하려는 고객을 선택하고 ‘다음 >>’을 클릭합니다.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__2_unknown' => '버튼을 수정하려는 구독을 선택하고 ‘다음 >>’을 클릭합니다.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__5_new' => '‘마침’을 클릭하여 버튼을 만들고 마법사를 종료합니다.',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__description' => "고객 패널의 버튼 속성을 변경합니다.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__short-title' => '속성',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__title' => '고객 패널의 버튼 속성을 변경합니다',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard-title' => '버튼 속성 변경',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__4_unknown' => "설정을 수정하려는 사용자 지정 버튼을 선택하고 ‘다음 >>’을 클릭합니다.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__5' => '버튼의 속성을 모두 변경했으면 ‘마침’을 클릭하여 변경 내용을 적용하고 마법사를 종료합니다.',

    'ui__client/domain/custom-buttons/custom-button/toggle_private__description' => '%1 버튼을 이 도메인 아래의 메일 사용자가 사용할 수 없도록 합니다.',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__short-title' => '메일 사용자가 사용할 수 없음',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__title' => '%1 버튼을 이 도메인 아래의 메일 사용자가 사용할 수 없도록 함',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__description' => '%1 버튼을 도메인 아래의 메일 사용자에게 표시합니다.',

    'ui__client/domain/custom-buttons/custom-button/toggle_public__short-title' => '이 도메인 아래의 메일 사용자에게 액세스 가능',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__title' => '%1의 사용자 지정 버튼을 이 도메인 아래의 메일 사용자에게 표시',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__description' => '사용자 지정 버튼을 다른 사용자가 사용할 수 있도록 또는 사용할 수 없도록 합니다.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__short-title' => '다른 사용자가 사용할 수 있도록/사용할 수 없도록 함',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__title' => '사용자 지정 버튼을 메일 사용자가 사용할 수 있도록 또는 사용할 수 없도록 함',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard-title' => '사용자 지정 버튼을 다른 사용자가 사용할 수 있도록 또는 사용할 수 없도록 함',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => '버튼을 배치할 도메인을 선택하고 ‘다음 >>’을 클릭합니다.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__4_unknown' => '다른 사용자가 사용할 수 있거나 사용할 수 없도록 하려는 버튼을 선택하고 ‘다음 >>’을 클릭합니다.',

    'ui__client/domain/delete__description' => '%1 도메인을 제거합니다.',
    'ui__client/domain/delete__short-title' => '제거',
    'ui__client/domain/delete__title' => '도메인 제거 %1',
    'ui__client/domain/delete_multi__description' => '도메인을 제거합니다.',

    'ui__client/domain/delete_multi__short-title' => '제거',
    'ui__client/domain/delete_multi__title' => '도메인 제거',
    'ui__client/domain/delete_multi__wizard-title' => '도메인 제거',
    'ui__client/domain/delete_multi__wizard__2_multi' => '제거할 도메인을 선택하고 ‘다음 >>’을 클릭합니다.',
    'ui__client/domain/delete_multi__wizard__3_multi' => '확인란을 선택하여 도메인 제거를 확인한 다음 마침을 클릭하여 도메인을 제거하고 마법사를 종료합니다.',
    'ui__client/domain/delete_unknown__description' => '도메인을 제거합니다.',
    'ui__client/domain/delete_unknown__short-title' => '제거',
    'ui__client/domain/delete_unknown__title' => '도메인 제거',
    'ui__client/domain/delete_unknown__wizard-title' => '도메인 제거',
    'ui__client/domain/delete_unknown__wizard__2_unknown' => '제거하려는 도메인을 선택하고 ‘다음 >>’을 클릭합니다.',
    'ui__client/domain/delete_unknown__wizard__3' => '확인란을 선택하여 도메인 제거를 확인한 다음 ‘마침’을 클릭하여 도메인을 제거하고 마법사를 종료합니다.',

    'ui__client/domain/hosting__none-available' => '웹 호스팅이 구성된 도메인이 없습니다. 도메인을 만들고 이 도메인에서 웹 호스팅을 구성하여 이 기능에 액세스합니다.',
    'ui__client/domain/hosting__none-available__1' => '이 사용자 계정에는 웹 호스팅이 구성된 어떤 도메인도 없습니다. 필요한 도메인에서 웹 호스팅을 구성하여 이 기능에 액세스합니다.',
    'ui__client/domain/hosting__none-available__2' => '%1 도메인에 대해 웹 호스팅이 구성되지 않았습니다. %1 도메인에서 웹 호스팅을 구성하여 이 기능에 액세스합니다.',

    'ui__client/domain/hosting/application#list_header__clients_number__title' => "고객",
    'ui__client/domain/hosting/application#list_header__description__title' => "설명",
    'ui__client/domain/hosting/application#list_header__items_number__title' => "항목",
    'ui__client/domain/hosting/application#list_header__name__title' => "이름",
    'ui__client/domain/hosting/application#list_header__release__title' => "릴리스",
    'ui__client/domain/hosting/application#list_header__sort_by_clients_number__title' => "고객 기준으로 정렬",
    'ui__client/domain/hosting/application#list_header__sort_by_description__title' => "설명 기준으로 정렬",
    'ui__client/domain/hosting/application#list_header__sort_by_items_number__title' => "항목 기준으로 정렬",
    'ui__client/domain/hosting/application#list_header__sort_by_name__title' => "이름을 기준으로 정렬",
    'ui__client/domain/hosting/application#list_header__sort_by_release__title' => "릴리스 기준으로 정렬",
    'ui__client/domain/hosting/application#list_header__sort_by_version__title' => "버전 기준으로 정렬",
    'ui__client/domain/hosting/application#list_header__title' => "웹 응용 프로그램",
    'ui__client/domain/hosting/application#list_header__version__title' => "버전",

    'rpt_reseller_section_general' => '일반',
    'rpt_reseller_section_domains' => '도메인',
    'rpt_reseller_section_clients' => '고객',
    'statistics__cl_active_domains' => "활성 도메인",
    'rpt_reseller_cl_domains' => "도메인",
    'rpt_reseller_cl_subdomains' => "하위 도메인",
    'by__cl_domains' => "클라이언트 도메인",
    'dom_ctrl__cl_mboxes' => "사서함",
    'rpt_reseller_cl_redirects' => "전달자",
    'rpt_reseller_cl_mail_groups' => "메일 그룹",
    'rpt_reseller_cl_mail_resps' => "자동 회신",
    'rpt_reseller_cl_mail_lists' => "메일링 리스트",
    'rpt_reseller_cl_web_users' => "웹 사용자",
    'rpt_reseller_cl_data_bases' => "데이터베이스",

    'statistics__active_clients' => '활성 구독이 있는 고객',
    'statistics__clients_active_domains' => '활성 도메인',
    'statistics__clients_doms' => '도메인',
    'statistics__cl_doms' => '도메인',
    '__clients_subdomains' => '하위 도메인',
    '__clients_domains' => '도메인',
    'dom_ctrl__clients_mboxes' => '사서함',
    'dom_ctrl__clients_redir' => '전달자',
    'dom_ctrl__clients_mg' => '메일 그룹',
    'dom_ctrl__clients_resp' => '자동 회신',
    'dom_ctrl__clients_maillists' => '메일링 리스트',
    'dom_ctrl__clients_wu' => '웹 사용자',
    'dom_ctrl__clients_db' => '데이터베이스',

    'dom_ctrl__cl_redir' => '전달자', // to resolve!
    'dom_ctrl__cl_mg' => '메일 그룹', // to resolve!
    'dom_ctrl__cl_resp' => '자동 회신', // to resolve!
    'dom_ctrl__cl_maillists' => '메일링 리스트', // to resolve!
    'dom_ctrl__cl_wu' => '웹 사용자', // to resolve!
    'dom_ctrl__cl_db' => '데이터베이스', // to resolve!

    'rpt_cl_section_clients' => '고객',

    'rpt_admin_section_general' => '일반',
    'rpt_admin_section_resellers' => '리셀러',
    'rpt_admin_section_clients' => '고객',
    'rpt_admin_section_personal_clients' => '자체 고객',
    'rpt_admin_section_domains' => '도메인',
    'rpt_admin_section_personal_domains' => '개인 도메인',

    'rpt_reseller_section_personal_domains' => '개인 도메인',

    'ui__client/domain/toggle_unknown__wizard__2_unknown' => '일시 중단 또는 활성화하려는 도메인을 선택합니다.',
    'ui__client/domain/toggle_unknown__wizard-title' => '도메인 일시 중단 또는 활성화',

    'ui__client/ip-pool__description' => '고객에게 IP 주소와 SSL/TLS 인증서 할당 및 할당 취소%1.',
    'ui__client/ip-pool__short-title' => 'IP 풀',
    'ui__client/ip-pool__title' => '고객 %1IP 풀',
    'ui__client/ip-pool_self__description' => '사용자의 IP 풀을 표시합니다.',
    'ui__client/ip-pool_self__short-title' => 'IP 풀',
    'ui__client/ip-pool_self__title' => '내 IP 풀',
    'ui__client/ip-pool/properties__description' => '%1 고객에 대한 IP 풀을 설정합니다.',

    'ui__client/ip-pool/properties__short-title' => 'IP 풀',
    'ui__client/ip-pool/properties__title' => '고객에 대한 IP 풀 설정 %1',
    'ui__client/ip-pool/properties_self__description' => '사용자의 IP 풀을 표시합니다.',

    'ui__client/ip-pool/properties_self__short-title' => '내 IP 풀',
    'ui__client/ip-pool/properties_self__title' => '내 IP 풀',
    'ui__client/ip-pool/properties_unknown__description' => '고객 IP 주소와 SSL/TLS 인증서의 할당을 지정 또는 취소합니다.',
    'ui__client/ip-pool/properties_unknown__short-title' => 'IP 풀',
    'ui__client/ip-pool/properties_unknown__title' => '고객 IP 풀 설정',
    'ui__client/ip-pool/properties_unknown__wizard-title' => '고객 IP 풀 설정',
    'ui__client/ip-pool/properties_unknown__wizard__1_unknown' => 'IP 풀을 구성하려는 고객을 선택합니다.',
    'ui__client/ip-pool/properties_unknown__wizard__3' => 'IP 풀을 모두 구성했으면 ‘마침’을 클릭하여 변경 내용을 적용하고 마법사를 종료합니다.',


    'ui__client/limits_readonly-unknown__description' => '고객에 대한 리소스 제한을 표시합니다.',
    'ui__client/limits_readonly-unknown__short-title' => '리소스 제한',
    'ui__client/limits_readonly-unknown__title' => '고객 계정에 대한 리소스 제한 표시',
    'ui__client/limits_readonly-unknown__wizard-title' => '고객에 대한 리소스 제한 표시 또는 변경',

    'ui__client/limits_unknown__wizard-title' => '고객에 대한 리소스 제한 표시 또는 변경',
    'ui__client/limits_unknown__wizard__1_readonly-unknown' => '필요한 고객을 선택합니다.',
    'ui__client/limits_unknown__wizard__1_unknown' => '필요한 고객을 선택합니다.',
    'ui__client/limits_unknown__wizard__2' => '변경 내용을 적용하려면 ‘마침’을 클릭합니다.',
    'ui__client/limits_unknown__wizard__2_readonly' => '마법사를 종료하려면 ‘마침’을 클릭합니다.',
    'ui__client/limits_unknown__wizard__2_readonly-self' => '마법사를 종료하려면 ‘마침’을 클릭합니다.',
    'ui__client/limits_unknown__wizard__2_readonly-self-reseller' => '마법사를 종료하려면 ‘마침’을 클릭합니다.',

    'ui__client/permissions_unknown__wizard-title' => '고객에 대한 권한 표시 또는 변경',
    'ui__client/permissions_unknown__wizard__1/properties_self' => '권한을 모두 확인했으면 ‘마침’을 클릭하여 변경 내용을 적용하고 마법사를 종료합니다.',
    'ui__client/permissions_unknown__wizard__1_unknown' => '권한을 보거나 변경하려는 고객을 선택합니다.',
    'ui__client/permissions_unknown__wizard__2' => '고객의 권한을 모두 변경했으면 ‘마침’을 클릭하여 변경 내용을 적용하고 마법사를 종료합니다.',

    'ui__client/preferences_unknown__wizard-title' => '고객 기본 설정 편집',
    'ui__client/preferences_unknown__wizard__1_unknown' => '세션 및 인터페이스 기본 설정을 관리하려는 고객을 선택합니다.',
    'ui__client/preferences_unknown__wizard__2' => '고객 기본 설정 변경이 끝났으면 마침을 클릭합니다.',
    'ui__client/preferences_unknown__wizard__2_self' => '기본 설정 변경이 끝났으면 마침을 클릭합니다.',

    'ui__custom-buttons/custom-button__none-available' => '사용자 지정 버튼이 없습니다.',
    'ui__custom-buttons/custom-button/delete__description' => '%1의 사용자 지정 버튼을 제거합니다.',
    'ui__custom-buttons/custom-button/delete__short-title' => '제거',
    'ui__custom-buttons/custom-button/delete__title' => '사용자 지정 버튼 제거 %1',
    'ui__custom-buttons/custom-button/delete_multi__description' => '사용자 지정 버튼을 제거합니다.',

    'ui__custom-buttons/custom-button/delete_multi__short-title' => '제거',
    'ui__custom-buttons/custom-button/delete_multi__title' => '사용자 지정 버튼 제거',
    'ui__custom-buttons/custom-button/delete_multi__wizard-title' => '사용자 지정 버튼 제거',
    'ui__custom-buttons/custom-button/delete_multi__wizard__2_multi' => '제거할 버튼을 선택합니다.',
    'ui__custom-buttons/custom-button/delete_multi__wizard__3_multi' => '확인란을 선택하여 버튼의 제거를 확인하고 ‘마침’을 클릭하여 마법사를 완료합니다.',
    'ui__custom-buttons/custom-button/delete_unknown__description' => '사용자 지정 버튼을 제거합니다.',
    'ui__custom-buttons/custom-button/delete_unknown__short-title' => '제거',
    'ui__custom-buttons/custom-button/delete_unknown__title' => '사용자 지정 버튼 제거',
    'ui__custom-buttons/custom-button/delete_unknown__wizard-title' => '사용자 지정 버튼 제거',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => '제거할 사용자 지정 버튼을 선택합니다.',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__3' => '확인란을 선택하여 버튼의 제거를 확인하고 ‘마침’을 클릭하여 마법사를 완료합니다.',
    'ui__custom-buttons/custom-button/properties__description' => '%1 버튼의 속성을 변경합니다.',

    'ui__custom-buttons/custom-button/properties__short-title' => '속성',
    'ui__custom-buttons/custom-button/properties__title' => '버튼의 속성 변경 %1',

    'ui__custom-buttons/custom-button/properties_new__wizard-title' => '버튼 만들기',
    'ui__custom-buttons/custom-button/properties_new__wizard__3_new' => '‘마침’을 클릭하여 버튼을 만듭니다.',
    'ui__custom-buttons/custom-button/properties_unknown__description' => '사용자 지정 버튼의 속성을 변경합니다.',
    'ui__custom-buttons/custom-button/properties_unknown__short-title' => '속성',
    'ui__custom-buttons/custom-button/properties_unknown__title' => '사용자 지정 버튼의 속성 변경',
    'ui__custom-buttons/custom-button/properties_unknown__wizard-title' => '사용자 지정 버튼의 속성 변경',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__2_unknown' => '속성을 변경하려는 사용자 지정 버튼을 선택합니다.',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__3' => '변경 내용을 적용하려면 ‘마침’을 클릭합니다.',
    'ui__custom-buttons/custom-button/toggle_private__description' => '%1의 사용자 지정 버튼을 다른 사용자가 사용할 수 없게 합니다.',

    'ui__custom-buttons/custom-button/toggle_private__short-title' => '다른 사용자가 사용할 수 없게 함',
    'ui__custom-buttons/custom-button/toggle_private__title' => '%1의 사용자 지정 버튼을 다른 사용자가 사용할 수 없게 함',
    'ui__custom-buttons/custom-button/toggle_public__description' => '%1의 사용자 지정 버튼을 다른 사용자가 사용할 수 있게 합니다.',

    'ui__custom-buttons/custom-button/toggle_public__short-title' => '다른 사용자가 사용할 수 있게 함',
    'ui__custom-buttons/custom-button/toggle_public__title' => '%1의 사용자 지정 버튼을 다른 사용자가 사용할 수 있게 함',
    'ui__custom-buttons/custom-button/toggle_unknown__description' => '사용자 지정 버튼을 다른 사용자가 사용할 수 있도록 또는 사용할 수 없도록 합니다.',
    'ui__custom-buttons/custom-button/toggle_unknown__short-title' => '다른 사용자가 사용할 수 있도록 또는 사용할 수 없도록 함',
    'ui__custom-buttons/custom-button/toggle_unknown__title' => '사용자 지정 버튼을 다른 사용자가 사용할 수 있도록 또는 사용할 수 없도록 함',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard-title' => '사용자 지정 버튼을 다른 사용자가 사용할 수 있도록 또는 사용할 수 없도록 함',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => '다른 사용자가 사용할 수 있거나 사용할 수 없도록 하려는 사용자 지정 버튼을 선택하고 ‘다음 >>’을 클릭합니다.',

    'ui__longtasks#list_header__name__title' => "이름",
    'ui__longtasks#list_header__owner__title' => "소유자",
    'ui__longtasks#list_header__start_time__title' => "생성 시간",
    'ui__longtasks#list_header__status__title' => "상태",
    'ui__longtasks#list_header__title' => "작업",
    'ui__longtasks#list_header__finish_time__title' => "완료 시간",
    'ui__longtasks#task_list_legend__title' => "작업",
    'ui__longtasks#tools_legend__title' => "도구",
    'ui__longtasks__description' => "백그라운드 작업 관리",
    'ui__longtasks__short-title' => "백그라운드 작업",
    'ui__longtasks__title' => "백그라운드 작업",
    'ui__longtasks/longtask/properties#current_operation__title' => "현재 작업",
    'ui__longtasks/longtask/properties#finish_time__title' => "예상 완료 시간:",
    'ui__longtasks/longtask/properties#general_legend__title' => "일반",
    'ui__longtasks/longtask/properties#owner__title' => "작업을 시작한 사람:",
    'ui__longtasks/longtask/properties#progress__title' => "전체 진행률:",
    'ui__longtasks/longtask/properties#start_time__title' => "시작된 작업:",
    'ui__longtasks/longtask/properties#status_legend__title' => "작업 상태",
    'ui__longtasks/longtask/properties__description' => "백그라운드 작업 상태 및 정보",

    'ui__longtasks/properties__description' => "백그라운드 작업 설정",
    'ui__longtasks/properties__short-title' => "설정",
    'ui__longtasks/properties__title' => "백그라운드 작업",

    // updated
    'ui__mass-mail/template#list_header__title' => '대량 이메일 메시지 템플릿',
    'ui__mass-mail/template#list_header__name__title' => '템플릿 이름',
    'ui__mass-mail/template#list_header__from_email__title' => '발신자',
    'ui__mass-mail/template#list_header__to__title' => '수신자',
    'ui__mass-mail/template#list_header__subject__title' => '제목',
    'ui__mass-mail/template#list_header__cdate__title' => '만든 날짜',
    'ui__mass-mail/template#list_header__send__title' => '보내기',

    'ui__mass-mail/template/properties__short-title' => '%1',
    'ui__mass-mail/template/properties__title' => '대량 이메일 메시지 템플릿 편집',
    'ui__mass-mail/template/properties__description' => '이 대량 이메일 메시지 템플릿을 편집합니다.',

    'ui__mass-mail/template/properties_unknown-new__short-title' => '대량 이메일 템플릿 추가',
    'ui__mass-mail/template/properties_unknown-new__title' => '대량 이메일 템플릿 추가',
    'ui__mass-mail/template/properties_unknown-new__description' => '대량 이메일 메시지 템플릿을 추가합니다.',
    'ui__mass-mail/send__short-title' => '대량 이메일 보내기',
    'ui__mass-mail/send__title' => '대량 이메일 메시지 보내기',
    'ui__mass-mail/send__description' => '선택한 수신자에게 대량 이메일 메시지 보내기',
    'ui__mass-mail/template/delete_multi__short-title' => '대량 이메일 템플릿 제거',
    'ui__mass-mail/template/delete_multi__title' => '다음 대량 이메일 메시지 템플릿 제거:',
    'ui__mass-mail/template/delete_multi__description' => '선택한 대량 이메일 메시지 템플릿을 제거합니다.',
    'ui__mass-mail/template/delete_multi__done' => '선택한 메시지 템플릿이 제거되었습니다.',
    'ui__mass-mail/template/properties__invalid_values' => '잘못된 값이 지정됨',


    // old
    'ui__mass-mail#body_text__description' => '머리글이 아닌 메시지 텍스트에 <name> 변수를 사용할 수 있습니다. 고객의 또는 리셀러의 담당자 이름으로 교체될 것입니다.',
    'ui__mass-mail#body_text__title' => '메시지 텍스트',
    'ui__mass-mail#compose_legend__title' => '메시지',
    'ui__mass-mail#from_email_text__title' => '발신자(이메일 주소)',
    'ui__mass-mail#list_header__cdate__title' => '생성됨',
    'ui__mass-mail#list_header__from_email__title' => '시작',
    'ui__mass-mail#list_header__name__title' => '이름',
    'ui__mass-mail#list_header__send__title' => '메시지 만들기',
    'ui__mass-mail#list_header__subject__title' => '제목',
    'ui__mass-mail#list_header__title' => '대량 이메일 메시지 템플릿',
    'ui__mass-mail#list_header__to__title' => '받는 사람',
    'ui__mass-mail#list_legend__title' => '대량 이메일 메시지 템플릿',
    'ui__mass-mail#load_template_text__title' => '로드',
    'ui__mass-mail#name_text__title' => '템플릿 이름',
    'ui__mass-mail#option_mode_all__title' => '모두',
    'ui__mass-mail#option_mode_except__title' => '선택 항목을 제외하고 모두',
    'ui__mass-mail#option_mode_select__title' => '선택 항목만',
    'ui__mass-mail#option_select_template__title' => '---템플릿 선택---',
    'ui__mass-mail#picker_legend__title' => '이메일 메시지 템플릿',
    'ui__mass-mail#picker_title__title' => '템플릿 선택',
    'ui__mass-mail#save_as_legend__title' => '템플릿으로 저장',
    'ui__mass-mail#save_as_text__title' => '작성된 메시지를 이름이 지정된 새 탬플릿에 저장합니다',
    'ui__mass-mail#subject_text__title' => '제목',
    'ui__mass-mail#template_legend__title' => '템플릿',
    'ui__mass-mail#to_admin_text__title' => 'Plesk 관리자',
    'ui__mass-mail#to_clients_text__title' => '고객',
    'ui__mass-mail#to_domains_text__title' => '도메인 관리자',
    'ui__mass-mail#to_select_text__title' => '주소 선택',
    'ui__mass-mail#to_show_hide_text__title' => '선택 항목 표시/숨기기',
    'ui__mass-mail#to_text__title' => '받는 사람',
    'ui__mass-mail#tools_legend__title' => '도구',
    'ui__mass-mail__already_exists' => '이름이 %1인 템플릿이 이미 있습니다.',
    'ui__mass-mail__none-available' => '메시지 템플릿이 없습니다.',

    'ui__mass-mail/delete__description' => '대량 이메일 메시지 템플릿 제거 %1',

    'ui__mass-mail/delete__empty_selection' => '제거하려는 템플릿을 선택하십시오.',
    'ui__mass-mail/delete__short-title' => '제거 %1',
    'ui__mass-mail/delete__title' => '대량 이메일 메시지 템플릿 제거 %1',
    'ui__mass-mail/delete_multi__description' => '대량 이메일 메시지 템플릿을 제거합니다.',

    'ui__mass-mail/delete_multi__short-title' => '제거',
    'ui__mass-mail/delete_multi__title' => '대량 이메일 메시지 템플릿 제거',
    'ui__mass-mail/delete_multi__wizard-title' => '대량 이메일 메시지 템플릿 제거',
    'ui__mass-mail/delete_multi__wizard__1_multi' => '제거하려는 대량 이메일 메시지 템플릿을 선택합니다.',
    'ui__mass-mail/delete_multi__wizard__2_multi' => '확인란을 선택하여 템플릿의 제거를 확인하고 ‘마침’을 클릭하여 마법사를 완료합니다.',
    'ui__mass-mail/delete_unknown__description' => '대량 이메일 메시지 템플릿을 제거합니다.',
    'ui__mass-mail/delete_unknown__short-title' => '제거',
    'ui__mass-mail/delete_unknown__title' => '대량 이메일 메시지 템플릿 제거',
    'ui__mass-mail/delete_unknown__wizard-title' => '대량 이메일 메시지 템플릿 제거.',
    'ui__mass-mail/delete_unknown__wizard__1_unknown' => '제거하려는 대량 이메일 메시지 템플릿을 선택합니다.',
    'ui__mass-mail/delete_unknown__wizard__2' => '확인란을 선택하여 템플릿의 제거를 확인하고 ‘마침’을 클릭하여 마법사를 완료합니다.',

    'ui__mass-mail/properties__description' => '이메일 메시지 템플릿 %1을(를) 편집합니다.',

    'ui__mass-mail/properties__invalid_values' => '잘못된 값을 지정했습니다.',
    'ui__mass-mail/properties__short-title' => '%1',
    'ui__mass-mail/properties__title' => '이메일 메시지 템플릿 편집 %1',

    'ui__mass-mail/properties_new__wizard-title' => '대량 이메일 메시지 템플릿 만들기',
    'ui__mass-mail/properties_unknown-new__description' => '이메일 메시지 템플릿을 만듭니다.',
    'ui__mass-mail/properties_unknown-new__short-title' => '이메일 메시지 템플릿 추가',
    'ui__mass-mail/properties_unknown-new__title' => '이메일 메시지 템플릿 만들기',
    'ui__mass-mail/properties_unknown__wizard-title' => '대량 이메일 메시지 템플릿 편집',
    'ui__mass-mail/properties_unknown__wizard__1_unknown' => '수정하려는 템플릿을 선택하고 다음 >>을 클릭합니다.',
    'ui__mass-mail/properties_unknown__wizard__2' => '템플릿 편집이 끝났으면 마침을 클릭하여 변경 사항을 적용하고 마법사를 종료합니다.',

    'ui__mass-mail/send__invalid_values' => '잘못된 값을 지정했습니다.',

    'ui__mass-mail/send_new__wizard-title' => '메시지 템플릿을 만들고 이메일 보내기',
    'ui__mass-mail/send_unknown-new__description' => '선택한 수신자에게 이메일 보내기',

    'ui__mass-mail/send_unknown-new__short-title' => '대량 이메일 보내기',
    'ui__mass-mail/send_unknown-new__title' => '대량 이메일 메시지 보내기',
    'ui__mass-mail/send_unknown__description' => '선택한 수신자에게 이메일 보내기',

    'ui__mass-mail/send_unknown__short-title' => '대량 이메일 보내기',
    'ui__mass-mail/send_unknown__title' => '대량 이메일 메시지 보내기',
    'ui__mass-mail/send_unknown__wizard-title' => '대량 이메일 메시지 보내기',
    'ui__mass-mail/send_unknown__wizard__1_unknown' => '필요한 템플릿을 선택하고 다음 >>을 클릭합니다.',
    'ui__mass-mail/send_unknown__wizard__2' => '템플릿 속성 편집이 끝났으면 마침을 클릭하여 메시지를 보내고 마법사를 종료합니다.',

    'ui__mass-email/delete__description' => '선택한 대량 이메일 메시지 템플릿을 제거합니다.',

    'ui__mass-email/delete__empty_selection' => "제거하려는 템플릿을 선택합니다.",
    'ui__mass-email/delete__short-title' => "제거 %1",
    'ui__mass-email/delete__title' => "대량 이메일 메시지 템플릿 제거 %1",
    'ui__mass-email/delete_multi__description' => "대량 이메일 메시지 템플릿을 제거합니다.",

    'ui__mass-email/delete_multi__short-title' => "제거",
    'ui__mass-email/delete_multi__title' => "대량 이메일 메시지 템플릿 제거",
    'ui__mass-email/delete_multi__wizard__mass-mail/delete_multi' => "확인란을 선택하여 템플릿의 제거를 확인하고 ‘마침’을 클릭하여 마법사를 완료합니다.",
    'ui__mass-email/delete_multi__wizard__mass-mail_multi' => "제거하려는 대량 이메일 메시지 템플릿을 선택합니다.",
    'ui__mass-email/delete_multi__wizard-title' => "대량 이메일 메시지 템플릿 제거",
    'ui__mass-email/delete_unknown__description' => "대량 이메일 메시지 템플릿을 제거합니다.",
    'ui__mass-email/delete_unknown__short-title' => "제거",
    'ui__mass-email/delete_unknown__title' => "대량 이메일 메시지 템플릿 제거",
    'ui__mass-email/delete_unknown__wizard__mass-mail/delete' => "확인란을 선택하여 템플릿의 제거를 확인하고 ‘마침’을 클릭하여 마법사를 완료합니다.",
    'ui__mass-email/delete_unknown__wizard__mass-mail_unknown' => "제거하려는 대량 이메일 메시지 템플릿을 선택합니다.",
    'ui__mass-email/delete_unknown__wizard-title' => "대량 이메일 메시지 템플릿 제거.",
    'ui__mass-email/send__description' => "선택한 수신자에게 이메일 보내기",
    'ui__mass-email/send__short-title' => "대량 이메일 보내기",
    'ui__mass-email/send__title' => "대량 이메일 메시지 보내기",
    'ui__mass-email/send_main__description' => "선택한 수신자에게 이메일 보내기",

    'ui__mass-email/send_main__short-title' => "대량 이메일 보내기",
    'ui__mass-email/send_main__title' => "대량 이메일 메시지 보내기",
    'ui__mass-email/send_selectresellers__title' => '리셀러 선택',
    'ui__mass-email/send_selectresellers__short-title' => '리셀러',
    'ui__mass-email/send_selectresellers__description' => '리셀러 계정 선택',

    'ui__mass-email/send_selectclients__description' => "고객 계정 선택",

    'ui__mass-email/send_selectclients__short-title' => "고객",
    'ui__mass-email/send_selectclients__title' => "고객 선택",
    'ui__mass-email/send_selectdomainusers__description' => "도메인 관리자 계정 선택",

    'ui__mass-email/send_selectdomainusers__short-title' => "도메인 관리자",
    'ui__mass-email/send_selectdomainusers__title' => "도메인 관리자 선택",
    'ui__mass-email/template/properties_main__description' => "대량 이메일 메시지 템플릿 만들기",
    'ui__mass-email/template/properties_main__short-title' => "템플릿 편집",
    'ui__mass-email/template/properties_main__title' => "대량 이메일 메시지 템플릿 편집",
    'ui__mass-email/template/properties_new-main__description' => "대량 이메일 메시지 템플릿 생성",
    'ui__mass-email/template/properties_new-main__short-title' => "대량 이메일 메시지 템플릿 만들기",
    'ui__mass-email/template/properties_new-main__title' => "대량 이메일 메시지 템플릿 만들기",
    'ui__mass-email/template/properties_new-selectclients__description' => "이 템플릿을 기반으로 대량 이메일 메시지를 수신해야 하는 고객 선택",
    'ui__mass-email/template/properties_new-selectclients__title' => "이 템플릿을 기반으로 대량 이메일 메시지를 수신해야 하는 고객 선택",
    'ui__mass-email/template/properties_new-selectdomainusers__description' => "이 템플릿을 기반으로 대량 이메일 메시지를 수신해야 하는 도메인 관리자를 선택합니다.",
    'ui__mass-email/template/properties_new-selectdomainusers__title' => "이 템플릿을 기반으로 대량 이메일 메시지를 수신해야 하는 도메인 관리자를 선택합니다.",
    'ui__mass-email/template/properties_selectclients__title' => "이 템플릿을 기반으로 대량 이메일 메시지를 수신해야 하는 고객 선택",
    'ui__mass-email/template/properties_selectdomainusers__title' => "이 템플릿을 기반으로 대량 이메일 메시지를 수신해야 하는 도메인 관리자를 선택합니다.",

    'ui__mass-email/template/properties_unknown-new__description' => "대량 이메일 메시지 템플릿 생성",
    'ui__mass-email/template/properties_unknown-new__short-title' => "템플릿 만들기",
    'ui__mass-email/template/properties_unknown-new__title' => "대량 이메일 메시지 템플릿 생성",
    'ui__news/dismiss__description' => '뉴스 프레임을 닫으려면 클릭합니다. 뉴스 기사가 업데이트될 때까지 Plesk에 이 프레임이 표시되지 않습니다.',

    'ui__news/dismiss__title' => '뉴스 닫기',

    'ui__server__description' => '서버 관리.',
    'ui__server__short-title' => '서버 관리',
    'ui__server__title' => '서버 관리',


    // UNUSED SINCE 9.2



    // END OF UNUSED SINCE 9.2

    'ui__server/ip-address__disabled-warning' => '%1의 IP 주소는 사용할 수 없습니다.',
    'ui__server/ip-address__none-available' => 'IP 주소가 없습니다.',
    'ui__server/ip-addresses/ip-address__title' => "IP 주소",
    'ui__server/ip-address/client/properties_new__description' => "%1의 IP 주소를 리셀러에게 할당합니다.",
    'ui__server/ip-address/client/properties_new__short-title' => '할당',
    'ui__server/ip-address/client/properties_new__title' => "%1의 IP 주소를 리셀러에게 할당",
    'ui__server/ip-address/client__none-available' => '사용자 계정이 없습니다.',
    'ui__server/ip-address/client_unknown__quick_search' => '사용자',
    'ui__server/ip-address/client_unknown__wizard-title' => '이 IP 주소를 사용하는 사용자 목록.',
    'ui__server/ip-address/client_unknown__wizard__3_unknown' => 'IP 주소를 선택합니다.',
    'ui__server/ip-address/client/delete__description' => '리셀러로부터 IP 주소를 할당 취소합니다.',
    'ui__server/ip-address/client/delete__short-title' => '할당 취소',
    'ui__server/ip-address/client/delete__title' => '리셀러로부터 IP 주소 할당 취소',
    'ui__server/ip-address/client/delete_multi__description' => "리셀러 풀에서 IP 주소를 할당 취소합니다.",

    'ui__server/ip-address/client/delete_multi__short-title' => '할당 취소',
    'ui__server/ip-address/client/delete_multi__title' => '리셀러로부터 IP 주소 할당 취소',
    'ui__server/ip-address/client/delete_multi__wizard-title' => "사용자 풀에서 IP 주소를 제거합니다.",
    'ui__server/ip-address/client/delete_multi__wizard__3_unknown' => '사용자로부터 할당 취소하려는 IP 주소를 선택하고 ‘다음 >>’을 클릭합니다.',
    'ui__server/ip-address/client/delete_multi__wizard__3_multi' => 'IP 주소를 할당 취소하려는 사용자를 선택하고 ‘다음 >>’을 클릭합니다.',
    'ui__server/ip-address/client/delete_multi__wizard__4_multi' => '확인란을 선택하여 사용자로부터 IP 주소의 할당 취소를 확인하고 ‘마침’을 클릭하여 마법사를 완료합니다.',
    'ui__server/ip-address/client/delete_unknown__description' => '리셀러로부터 IP 주소를 할당 취소합니다.',
    'ui__server/ip-address/client/delete_unknown__short-title' => '할당 취소',
    'ui__server/ip-address/client/delete_unknown__title' => '리셀러로부터 IP 주소 할당 취소',
    'ui__server/ip-address/client/delete_unknown__wizard-title' => '사용자로부터 IP 주소 할당 취소',
    'ui__server/ip-address/client/delete_unknown__wizard__3_unknown' => '사용자로부터 할당 취소하려는 IP 주소를 선택하고 ‘다음 >>’을 클릭합니다.',
    'ui__server/ip-address/client/delete_unknown__wizard__4_unknown' => 'IP 주소를 할당 취소하려는 사용자를 선택하고 ‘다음 >>’을 클릭합니다.',
    'ui__server/ip-address/client/delete_unknown__wizard__5' => '확인란을 선택하여 사용자로부터 IP 주소의 할당 취소를 확인하고 ‘마침’을 클릭하여 마법사를 완료합니다.',

    'ui__server/ip-address/domain__description' => "%1의 IP 주소에 있는 모든 도메인.",
    'ui__server/ip-address/domain__short-title' => "도메인",
    'ui__server/ip-address/domain__title' => "IP 주소의 도메인 %1",
    'ui__server/ip-address/domain_unknown__description' => "IP 주소의 모든 도메인.",
    'ui__server/ip-address/domain_unknown__short-title' => "도메인",
    'ui__server/ip-address/domain_unknown__title' => "IP 주소의 도메인",
    'ui__server/ip-address/domain_unknown__wizard__3_unknown' => "필요한 IP 주소를 선택하고 ‘다음 >>’을 클릭합니다.",

    'ui__server/ip-address/properties__description' => 'IP 주소 %1의 속성을 변경합니다.',
    'ui__server/ip-address/properties__short-title' => '속성',
    'ui__server/ip-address/properties__title' => 'IP 주소 속성 변경 %1',

    'ui__server/ip-address/properties_new__wizard-title' => 'IP 주소 추가',
    'ui__server/ip-address/properties_new__wizard__4_new' => 'IP 주소 속성을 모두 변경했으면 ‘마침’을 클릭하여 변경 내용을 적용합니다.',
    'ui__server/ip-address/properties_unknown__description' => 'IP 주소 속성을 변경합니다.',
    'ui__server/ip-address/properties_unknown__short-title' => '속성',
    'ui__server/ip-address/properties_unknown__title' => 'IP 주소 속성 변경',
    'ui__server/ip-address/properties_unknown__wizard-title' => 'IP 주소 속성 변경',
    'ui__server/ip-address/properties_unknown__wizard__3_unknown' => '속성을 변경하려는 IP 주소를 선택합니다.',
    'ui__server/ip-address/properties_unknown__wizard__4' => 'IP 주소 속성을 모두 변경했으면 ‘마침’을 클릭하여 변경 내용을 적용합니다.',

    'ui__server/spam-filter/black-list__description' => '서버 전체 스팸 필터의 차단 목록을 설정합니다.',
    'ui__server/spam-filter/black-list__short-title' => '차단 목록',
    'ui__server/spam-filter/black-list__title' => '서버 전체 스팸 필터의 차단 목록',

    'ui__server/spam-filter/black-list/address__addresses_available' => '%1의 첫 고유 이메일 주소만 추가됩니다.',
    'ui__server/spam-filter/black-list/address__description' => '스팸 필터의 차단 목록 주소.',

    'ui__server/spam-filter/black-list/address__empty_content' => '목록에 이메일 주소가 없습니다.',
    'ui__server/spam-filter/black-list/address__file_size' => '업로드된 파일이 비어 있습니다.',
    'ui__server/spam-filter/black-list/address__invalid_addresses' => '다음 이메일 주소가 잘못되었습니다. %1.',
    'ui__server/spam-filter/black-list/address__none-available' => '스팸 필터 차단 목록에 주소가 없습니다.',
    'ui__server/spam-filter/black-list/address__short-title' => '주소',
    'ui__server/spam-filter/black-list/address__title' => '차단 목록 주소 %1',
    'ui__server/spam-filter/black-list/address_unknown__description' => '차단 목록에 주소를 추가합니다.',
    'ui__server/spam-filter/black-list/address_unknown__short-title' => '주소 추가',
    'ui__server/spam-filter/black-list/address_unknown__title' => '차단 목록에 주소 추가',

    'ui__server/spam-filter/black-list/address/delete__description' => '";서버 전체 차단 목록에서 %1 주소를 제거합니다.',

    'ui__server/spam-filter/black-list/address/delete__short-title' => '제거',
    'ui__server/spam-filter/black-list/address/delete__title' => '";서버 전체 차단 목록에서 %1 주소 제거',
    'ui__server/spam-filter/black-list/address/delete_multi__description' => '서버 전체 차단 목록에서 주소를 제거합니다.',

    'ui__server/spam-filter/black-list/address/delete_multi__short-title' => '제거',
    'ui__server/spam-filter/black-list/address/delete_multi__title' => '서버 전체 차단 목록에서 주소 제거',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard-title' => '서버 전체 스팸 필터 차단 목록에서 주소 제거',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__4_multi' => '제거하려는 스팸 필터 주소를 선택하고 ‘다음 >>’을 클릭합니다.',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__5_multi' => '확인란을 선택하여 스팸 필터 주소 제거를 확인하고 ‘마침’을 클릭하여 주소를 완전히 제거한 후 마법사를 종료합니다.',
    'ui__server/spam-filter/black-list/address/delete_unknown__description' => '서버 전체 차단 목록에서 주소를 제거합니다.',
    'ui__server/spam-filter/black-list/address/delete_unknown__short-title' => '제거',
    'ui__server/spam-filter/black-list/address/delete_unknown__title' => '서버 전체 차단 목록에서 주소 제거',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard-title' => '서버 전체 스팸 필터 차단 목록에서 주소 제거',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__4_unknown' => '제거하려는 스팸 필터 주소를 선택하고 ‘다음 >>’을 클릭합니다.',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__5' => '확인란을 선택하여 스팸 필터 주소 제거를 확인하고 ‘마침’을 클릭하여 주소를 완전히 제거한 후 마법사를 종료합니다.',

    'ui__server/spam-filter/black-list/address/properties__addresses_available' => '%1의 첫 고유 이메일 주소만 추가됩니다.',
    'ui__server/spam-filter/black-list/address/properties__empty_content' => '목록에 이메일 주소가 없습니다.',
    'ui__server/spam-filter/black-list/address/properties__file_size' => '파일을 업로드할 수 없습니다. 업로드할 수 있는 파일의 최대 크기는 %1입니다.',
    'ui__server/spam-filter/black-list/address/properties__invalid_addresses' => '다음 이메일 주소가 잘못되었습니다. %1.',

    'ui__server/spam-filter/black-list/address/properties_unknown-new__description' => '차단 목록에 주소를 추가합니다.',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__short-title' => '주소 추가',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__title' => '차단 목록에 주소 추가',

    'ui__server/spam-filter/properties__description' => '서버 전체 스팸 필터를 설정합니다.',

    'ui__server/spam-filter/properties__short-title' => '설정',
    'ui__server/spam-filter/properties__title' => '스팸 필터 설정',

    'ui__server/spam-filter/toggle_disable__description' => '전체 시스템에 스팸 필터링을 비활성화합니다.',

    'ui__server/spam-filter/toggle_disable__short-title' => '비활성화',
    'ui__server/spam-filter/toggle_disable__title' => '스팸 필터링 비활성화',
    'ui__server/spam-filter/toggle_enable__description' => '전체 서버에 스팸 필터링을 활성화합니다.',

    'ui__server/spam-filter/toggle_enable__short-title' => '활성화',
    'ui__server/spam-filter/toggle_enable__title' => '스팸 필터링 활성화',
    'ui__server/spam-filter/toggle_unknown__description' => '전체 서버에 스팸 필터링을 활성화/비활성화합니다.',
    'ui__server/spam-filter/toggle_unknown__short-title' => '사용 또는 사용 안 함',
    'ui__server/spam-filter/toggle_unknown__title' => '스팸 필터링 활성화/비활성화',
    'ui__server/spam-filter/toggle_unknown__wizard-title' => '스팸 필터 활성화/비활성화',

    'ui__server/spam-filter/white-list__description' => '시스템 전체 스팸 필터 허용 목록을 설정합니다.',
    'ui__server/spam-filter/white-list__short-title' => '허용 목록',
    'ui__server/spam-filter/white-list__title' => '시스템 전체 스팸 필터 허용 목록',

    'ui__server/spam-filter/white-list/address__addresses_available' => '%1의 첫 고유 이메일 주소만 추가됩니다.',
    'ui__server/spam-filter/white-list/address__description' => '스팸 필터의 허용 목록 주소.',

    'ui__server/spam-filter/white-list/address__empty_content' => '목록에 이메일 주소가 없습니다.',
    'ui__server/spam-filter/white-list/address__file_size' => '업로드된 파일이 비어 있습니다.',
    'ui__server/spam-filter/white-list/address__invalid_addresses' => '다음 이메일 주소가 잘못되었습니다. %1.',
    'ui__server/spam-filter/white-list/address__none-available' => '스팸 필터의 서버 전체 허용 목록에 주소가 없습니다.',
    'ui__server/spam-filter/white-list/address__short-title' => '주소',
    'ui__server/spam-filter/white-list/address__title' => '허용 목록 주소 %1',
    'ui__server/spam-filter/white-list/address_unknown__description' => '허용 목록에 주소를 추가합니다.',
    'ui__server/spam-filter/white-list/address_unknown__short-title' => '주소 추가',
    'ui__server/spam-filter/white-list/address_unknown__title' => '허용 목록에 주소 추가',

    'ui__server/spam-filter/white-list/address/delete__description' => '";서버 전체 허용 목록에서 %1 주소를 제거합니다.',

    'ui__server/spam-filter/white-list/address/delete__short-title' => '제거',
    'ui__server/spam-filter/white-list/address/delete__title' => '";서버 전체 허용 목록에서 %1 주소 제거',
    'ui__server/spam-filter/white-list/address/delete_multi__description' => '서버 전체 허용 목록에서 주소를 제거합니다.',

    'ui__server/spam-filter/white-list/address/delete_multi__short-title' => '제거',
    'ui__server/spam-filter/white-list/address/delete_multi__title' => '서버 전체 허용 목록에서 주소 제거',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard-title' => '서버 전체 스팸 필터 허용 목록에서 주소 제거',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__4_multi' => '제거하려는 스팸 필터 주소를 선택하고 ‘다음 >>’을 클릭합니다.',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__5_multi' => '확인란을 선택하여 스팸 필터 주소 제거를 확인하고 ‘마침’을 클릭하여 주소를 완전히 제거한 후 마법사를 종료합니다.',
    'ui__server/spam-filter/white-list/address/delete_unknown__description' => '서버 전체 허용 목록에서 주소를 제거합니다.',
    'ui__server/spam-filter/white-list/address/delete_unknown__short-title' => '제거',
    'ui__server/spam-filter/white-list/address/delete_unknown__title' => '서버 전체 허용 목록에서 주소 제거',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard-title' => '서버 전체 스팸 필터 허용 목록에서 주소 제거',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__4_unknown' => '제거하려는 스팸 필터 주소를 선택하고 ‘다음 >>’을 클릭합니다.',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__5' => '확인란을 선택하여 스팸 필터 주소 제거를 확인하고 ‘마침’을 클릭하여 주소를 완전히 제거한 후 마법사를 종료합니다.',

    'ui__server/spam-filter/white-list/address/properties__addresses_available' => '%1의 첫 고유 이메일 주소만 추가됩니다.',
    'ui__server/spam-filter/white-list/address/properties__empty_content' => '목록에 이메일 주소가 없습니다.',
    'ui__server/spam-filter/white-list/address/properties__file_size' => '파일을 업로드할 수 없습니다. 업로드할 수 있는 파일의 최대 크기는 %1입니다.',
    'ui__server/spam-filter/white-list/address/properties__invalid_addresses' => '다음 이메일 주소가 잘못되었습니다. %1.',

    'ui__server/spam-filter/white-list/address/properties_unknown-new__description' => '허용 목록에 주소를 추가합니다.',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__short-title' => '주소 추가',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__title' => '허용 목록에 주소 추가',

    'ui__server/mail/statistics#apply__description' => "필터 적용",
    'ui__server/mail/statistics#apply__title' => "적용",
    'ui__server/mail/statistics#custom_from__title' => "시작",
    'ui__server/mail/statistics#custom_to__title' => "끝",
    'ui__server/mail/statistics#period_all__title' => "모두",
    'ui__server/mail/statistics#period_custom__title' => "사용자 지정",
    'ui__server/mail/statistics#period_month__title' => "현재 월",
    'ui__server/mail/statistics#period_prev_month__title' => "이전 월",
    'ui__server/mail/statistics#period_prev_week__title' => "이전 주",
    'ui__server/mail/statistics#period_today__title' => "오늘",
    'ui__server/mail/statistics#period_week__title' => "현재 주",
    'ui__server/mail/statistics#period_yesterday__title' => "어제",
    'ui__server/mail/statistics#show_for_period__title' => "기간에 대해 표시",
    'ui__server/mail/statistics#tools_legend__title' => "도구",
    'ui__server/mail/statistics__description' => "스팸 및 바이러스 통계 보기",

    'ui__server/mail/statistics__short-title' => "통계",
    'ui__server/mail/statistics__title' => "통계",
    'ui__server/mail/statistics/spam#statistics_legend__title' => "스팸 통계",
    'ui__server/mail/statistics/spam#tools_legend__title' => "도구",
    'ui__server/mail/statistics/spam__description' => "스팸 통계 보기",

    'ui__server/mail/statistics/spam__short-title' => "스팸 통계",
    'ui__server/mail/statistics/spam__title' => "스팸 통계",
    'ui__server/mail/statistics/spam/recipients#list_header__name__title' => "메일 이름",
    'ui__server/mail/statistics/spam/recipients#list_header__ratio__title' => "전체의 %",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_name__title' => "메일 계정 기준으로 정렬",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_ratio__title' => "전체의 % 기준 정렬",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_val__title' => "수신된 스팸 기준으로 정렬",
    'ui__server/mail/statistics/spam/recipients#list_header__title' => "메일 계정",
    'ui__server/mail/statistics/spam/recipients#list_header__val__title' => "수신된 스팸",
    'ui__server/mail/statistics/spam/recipients__description' => "수신자",

    'ui__server/mail/statistics/spam/recipients__short-title' => "수신자",
    'ui__server/mail/statistics/spam/recipients__title' => "수신자",
    'ui__server/mail/statistics/spam/summary#clean__title' => "정리",
    'ui__server/mail/statistics/spam/summary#infected__title' => "감염됨",
    'ui__server/mail/statistics/spam/summary#list_header__name__title' => "상태",
    'ui__server/mail/statistics/spam/summary#list_header__ratio__title' => "전체의 %",
    'ui__server/mail/statistics/spam/summary#list_header__val__title' => "카운트",
    'ui__server/mail/statistics/spam/summary#protected__title' => "보호됨",
    'ui__server/mail/statistics/spam/summary#skipped__title' => "확인되지 않음",
    'ui__server/mail/statistics/spam/summary__description' => "요약",

    'ui__server/mail/statistics/spam/summary__short-title' => "요약",
    'ui__server/mail/statistics/spam/summary__title' => "요약",
    'ui__server/mail/statistics/virus#statistics_legend__title' => "바이러스 통계",
    'ui__server/mail/statistics/virus#tools_legend__title' => "도구",
    'ui__server/mail/statistics/virus__description' => "바이러스 통계 보기",

    'ui__server/mail/statistics/virus__short-title' => "바이러스 통계",
    'ui__server/mail/statistics/virus__title' => "바이러스 통계",
    'ui__server/mail/statistics/virus/recipients#list_header__name__title' => "메일 계정",
    'ui__server/mail/statistics/virus/recipients#list_header__ratio__title' => "전체의 %",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_name__title' => "메일 이름 기준으로 정렬",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_ratio__title' => "전체의 % 기준 정렬",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_val__title' => "수신된 바이러스 기준으로 정렬",
    'ui__server/mail/statistics/virus/recipients#list_header__title' => "메일 계정",
    'ui__server/mail/statistics/virus/recipients#list_header__val__title' => "수신된 바이러스",
    'ui__server/mail/statistics/virus/recipients__description' => "수신자",

    'ui__server/mail/statistics/virus/recipients__short-title' => "수신자",
    'ui__server/mail/statistics/virus/recipients__title' => "수신자",
    'ui__server/mail/statistics/virus/summary#clean__title' => "정리",
    'ui__server/mail/statistics/virus/summary#infected__title' => "감염됨",
    'ui__server/mail/statistics/virus/summary#list_header__name__title' => "상태",
    'ui__server/mail/statistics/virus/summary#list_header__ratio__title' => "전체의 %",
    'ui__server/mail/statistics/virus/summary#list_header__val__title' => "카운트",
    'ui__server/mail/statistics/virus/summary#protected__title' => "보호됨",
    'ui__server/mail/statistics/virus/summary#skipped__title' => "확인되지 않음",
    'ui__server/mail/statistics/virus/summary__description' => "요약",

    'ui__server/mail/statistics/virus/summary__short-title' => "요약",
    'ui__server/mail/statistics/virus/summary__title' => "요약",
    'ui__server/mail/statistics/virus/viruses#list_header__name__title' => "이름",
    'ui__server/mail/statistics/virus/viruses#list_header__ratio__title' => "전체의 %",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_name__title' => "이름을 기준으로 정렬",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_ratio__title' => "전체의 % 기준 정렬",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_val__title' => "감염된 개체 기준으로 정렬",
    'ui__server/mail/statistics/virus/viruses#list_header__title' => "바이러스",
    'ui__server/mail/statistics/virus/viruses#list_header__val__title' => "감염된 개체",
    'ui__server/mail/statistics/virus/viruses__description' => "바이러스",

    'ui__server/mail/statistics/virus/viruses__short-title' => "바이러스",
    'ui__server/mail/statistics/virus/viruses__title' => "바이러스",

    'ui__support#param_company__title' => "회사",
    'ui__support#param_email__title' => "이메일",
    'ui__support#param_firstname__title' => "이름",
    'ui__support#param_keynumber__title' => "제품 키 번호",
    'ui__support#param_operatingsystem__title' => "운영 체제",
    'ui__support#param_phone__title' => "전화번호",
    'ui__support#param_psabuild__title' => "Plesk 빌드",
    'ui__support#param_psainsttype__title' => "Plesk 설치 유형",
    'ui__support#param_psaversion__title' => "Plesk 버전",

    // *** The strings above have been generated automatically from @@CAPTION directives.

    ////
    //// UI POINTER CAPTIONS END HERE


    // RESELLERS

    // Resellers
    'ui__reseller#tools__title' => "도구",

    'ui__reseller/traffic-history_unknown__short-title' => "리셀러를 기준으로 트래픽 보기",
    'ui__reseller/traffic-history_unknown__title' => "리셀러를 기준으로 트래픽 보기",
    'ui__reseller/traffic-history_unknown__description' => "리셀러 계정별로 트래픽을 표시합니다.",
    'ui__reseller#list__title' => "리셀러",
    'accounts_list__name__filter_title' => "이름",
    'accounts_list__resource__filter_title' => "리소스 사용량",
    'resellers_list__filter_resource_usage_any' => "모두",
    'resellers_list__filter_resource_usage_overuse' => "초과 사용",
    'resellers_list__filter_resource_usage_normal' => "제한 이내",
    'accounts_list__status__filter_title' => "상태",
    'resellers_list__filter_status_any' => "모두",
    'resellers_list__filter_status_blocked' => "일시 중단됨",
    'resellers_list__filter_status_active' => "활성",
    'resellers_list__filter_clients__filter_title' => "표시",
    'resellers_list__filter_clients_on' => "해당 고객이 있는 리셀러",
    'resellers_list__filter_clients_off' => "리셀러만",
    '__disk_usage' => "사용된 디스크 공간",
    'ui__reseller/traffic_unknown__short-title' => "리셀러를 기준으로 트래픽 보기",
    'ui__reseller/traffic_unknown__title' => "리셀러를 기준으로 트래픽 보기",
    'ui__reseller/traffic#list__title' => "리셀러별 트래픽",
    'ui__reseller/traffic_unknown__description' => "트래픽 사용량 보고서를 표시합니다.",

    // Resellers > Traffic by resellers
    '__traffic_by_reseller' => "리셀러별 트래픽",

    '__reseller_name' => "리셀러 이름",
    '__reseller' => "리셀러",
    'resellertrafficlist_header' => "리셀러를 기준으로 트래픽 보기",
    '__reseller_personal' => "리셀러 도메인에 사용된 트래픽",
    'ui__reseller/traffic-history__short-title' => "리셀러별 트래픽",
    'ui__reseller/traffic-history__title' => "리셀러별 트래픽",
    'ui__reseller/traffic-history__description' => "트래픽 사용량 보고서를 표시합니다.",

    // Resellers > Create Reseller Account
    'ui__reseller__short-title' => "%1",

    // Resellers > Reseller preferences

    // Resellers > Reseller Account Templates

    // Resellers > Reseller Account Templates > Create Reseller Account Template
    'limits__oversell_text' => "초과 판매 허용",
    'limits__reseller_oversell_description' => "초과 판매를 통해 리셀러는 자신에게 실제 할당된 리소스보다 많은 리소스를 판매할 수 있습니다. 초과 판매가 허용된 경우, 리셀러는 초기 리소스 할당 대신 실제 리소스 사용에 따른 관리를 받습니다.",
    'limits__overuse_block_text' => "초과 사용 정책",
    'limits__overuse_block_true_text' => "초과 사용이 허용되지 않습니다.",
    'limits__reseller_overuse_block_true_description' => "리소스의 초과 사용을 차단합니다. 실제 리소스 사용량은 초기 리소스 할당량을 초과할 수 없습니다.",
    'limits__overuse_block_false_text' => "초과 사용이 허용됩니다.",
    'limits__reseller_overuse_block_false_description' => "리셀러가 처음 제공된 리소스보다 많은 리소스를 사용할 수 있도록 리소스 과도 사용을 차단하지 않습니다. 실제 리소스 사용량이 초기 리소스 할당량을 초과할 수 있습니다.",
    'limits__reseller_overuse_notify_text' => "리셀러에게 리소스 제한 도달 사실을 알림",
    'reseller_perm__manage_sh_access_disabled' => "리셀러는 셸 액세스를 허용 또는 금지할 수 없습니다.",
    'reseller_perm__manage_sh_access_chrooted' => "리셀러는 chrooted 환경에 대해서만 액세스를 허용할 수 있습니다.",
    'reseller_perm__manage_sh_access_any' => "리셀러는 어떤 유형의 셸에 대한 액세스도 허용할 수 있습니다.",
    'template__reseller_num_excl_ips' => "리셀러에게 전용 IP 주소 할당",

    // Reseller's Home page
    'ui__reseller#tools2__title' => "계정",
    'ui__reseller#info__title' => "정보",
    'ui__reseller#clientsTab__title' => "고객",
    'ui__reseller#domainsTab__title' => "도메인",
    'ui__reseller__title' => "%1의 리셀러 계정 관리",
    'domains__reseller_info' => "%1 고객, %2 도메인, %3의 디스크 공간이 사용됨, %4의 데이터 전송됨.",
    'domains__reseller_info_hiding_traffic' => "%1 고객, %2 도메인, %3의 디스크 공간이 사용됨.",
    'ui__reseller__description' => "리셀러 계정을 관리합니다.",

    'ui__reseller/limits_unknown__wizard-title' => '리셀러에 대한 리소스 제한 표시 또는 변경',
    'ui__reseller/limits_unknown__wizard__1_unknown' => '필요한 리셀러를 선택합니다.',
    'ui__reseller/limits_unknown__wizard__2' => '변경 내용을 적용하려면 ‘마침’을 클릭합니다.',

    'ui__client/report_reseller__short-title' => "보고서",
    'ui__client/report_reseller__title' => "계정 보고서 보기",
    'ui__client/report_reseller__description' => "리셀러 계정 보고서를 표시합니다.",
    'ui__client/ip-pool_reseller__short-title' => "IP 풀",
    'ui__client/ip-pool_reseller__description' => "리셀러 계정에 IP 주소와 SSL/TLS 인증서를 할당합니다.",

    //'ui__client/preferences_reseller__short-title' => "Settings",
    //'ui__client/preferences_reseller__description' => "Set Plesk session settings.",

    'ui__reseller/preferences_unknown__wizard__2_self' => "계정 설정을 지정하고 ‘마침’을 클릭합니다.",

    //'ui__client/permissions_reseller__short-title' => "Permissions",
    //'ui__client/permissions_reseller__description' => "View or change permissions for the reseller's account.",

    'ui__reseller/permissions_unknown__wizard-title' => '리셀러에 대한 권한 표시 또는 변경',
    'ui__reseller/permissions_unknown__wizard__1_unknown' => '권한을 보거나 변경하려는 리셀러를 선택합니다.',
    //'ui__reseller/permissions_unknown__wizard__1/properties_self' => 'When done with viewing your permissions, click Finish to to apply the changes and exit the wizard.',
    'ui__reseller/permissions_unknown__wizard__2' => '리셀러의 권한을 모두 변경했으면 ‘마침’을 클릭하여 변경 내용을 적용하고 마법사를 종료합니다.',

    // Customers > create customer account

    '__resellers_list' => '리셀러',
    'picker_reseller__title' => '리셀러 선택',

    // Resellers > reseller name > customer name
    'ui__client#tools1__title' => "도구",
    'ui__client#tools2__title' => "계정",
    'ui__client#info__title' => "정보",
    'ui__client#clientslist__title' => "고객",
    'ui__client#domainslist__title' => "도메인",

    // Reseller's session in the Customer Panel - Home page

    'feature__aps_categories__reseller' => "이제 모든 웹 응용 프로그램이 범주를 기준으로 정렬되어 설치할 올바른 응용 프로그램을 선택하기가 더욱 쉬워집니다.",
    'feature__domainkeys__reseller' => "DKIM 이메일 발신자 인증 메커니즘을 사용하여 스팸 및 피싱 이메일의 양을 줄일 수 있습니다.",

    '__reseller_form' => "리셀러 폼",

    // Reseller's session in the control panel - Home page > Manage Customer Settings
    'ui__client/preferences_unknown__wizard__reseller' => "설정을 변경하려는 고객 계정을 선택합니다.",

    // Reseller's session in the control panel - Home page > Suspend/Activate Customer Account

    // Reseller's session in the control panel - Home page > Change Customer Limits
    'ui__client/limits_unknown__wizard__1' => "리소스 사용량 제한을 변경하려면 ‘리소스 제한’을 클릭합니다.",

    // Reseller's session in the control panel - Home page > Change Customer Permissions
    'ui__client/permissions_unknown__wizard__1' => "고객이 Plesk에서 수행할 수 있는 작업에 대한 권한을 변경하려면 ‘권한’을 클릭합니다.",

    // Reseller's session in the control panel - Home page > Create Customer Template
    'template__shared_text' => "이 템플릿을 다른 사용자가 사용할 수 있게 함",
    'template__shared_description' => "고객이 이 템플릿을 사용할 수 있도록 하려면 이 옵션을 선택하십시오.",

    // CLIENT (updated for reseller feature):

    // Customers
    'ui__client#tools__title' => '도구',

    'ui__client/traffic-history_unknown__short-title' => '고객별 트래픽 보기',
    'ui__client/traffic-history_unknown__title' => '고객별 트래픽',
    'ui__client/traffic-history_unknown__description' => '모든 고객에 대한 트래픽 사용량 보고서 보기',
    'ui__client/traffic-history__short-title' => '고객별 트래픽',
    'ui__client/traffic-history__title' => '고객별 트래픽 보기',
    'ui__client/traffic-history__description' => '모든 고객에 대한 트래픽 사용량 보고서 보기',

    'ui__client/traffic#list__title' => '고객별 트래픽',
    'ui__reseller/client/traffic#list__title' => '고객별 트래픽',

    'clients_list__filter_type__filter_title' => '표시',
    'clients_list__filter_type_any' => '고객 및 리셀러',
    'clients_list__filter_type_clients' => '고객만',
    'clients_list__filter_type_resellers' => '리셀러만',
    'ui__client/domain_unknown-new__short-title' => "도메인 만들기",

    // Customers > View traffic by customers
    '__personal' => "사용자 도메인에 사용된 트래픽",
    'PersonalTrafficList_header_of_client__' => "계정에 대한 사용 보고서 보기",

    // DOMAINS

    // Domain > Domain Admin Permissions

    'domain_perm__manage_sh_access_disabled' => "도메인 관리자는 셸 액세스를 허용하거나 금지시킬 수 없습니다.",
    'domain_perm__manage_sh_access_chrooted' => "도메인 관리자는 chrooted 환경에 대해서만 액세스를 허용할 수 있습니다.",
    'domain_perm__manage_sh_access_any' => "도메인 관리자는 어떤 유형의 셸에 대한 액세스도 허용할 수 있습니다.",

    // APS Catalog
    'bt_add_to_vault' => "저장소에 추가",
    'bt_hide_updates' => "사용 가능한 업데이트 숨기기",
    'bt_show_updates' => "사용 가능한 업데이트 표시",

    '__site_apps__applications' => "응용 프로그램",
    //search elements
    // Application; Vendor; Packager; Certification level;

    '__site_apps__apps_selected_to_add_to_vault' => "저장소에 추가하기 위해 선택한 응용 프로그램",
    'site_apps__application_selected' => "선택",
    'site_apps__currently_in_vault' => "저장소에 이미 있는 다른 버전:",
    'site_apps__new_versions' => "새 버전:",
    'site_apps__patches' => "패치:",
    'site_apps__applications_have_been_scheduled_for_adding_to_application_vault' => "저장소에 추가가 예약된 응용 프로그램 수: %1",
    'site_apps__applications_downloading_now' => "현재 다음 응용 프로그램 다운로드 중: %1", // temporary workaround string, to be removed later

    'site_apps__package_already_exist_in_vault' => "이미 저장소에 있음",

    // Server > Action Log
    'bt_skin_edit' => "스킨 설명 편집",
    'domains__you_want_change_the_status_of_the_reseller??' => "리셀러 계정의 상태를 변경하시겠습니까?",
    'limits__oversell_legend' => "초과 판매",
    'limitsManager__limit_available_error' => "필요한 양의 리소스를 할당할 수 없음(%%quantity%% %%limitName%%). %%available%% %%limitName%%만 사용 가능합니다.",
    'limitsManager__limit_reserved_error' => "새 값이 고객에게 예약되거나 사용자 자신이 사용 중인 리소스의 양보다 적기 때문에 필요한 리소스 사용량 제한(%%quantity%% %%limitName%%)을 설정할 수 없습니다(%%reserved%% %%limitName%%) .",
    'limitsManager__limit_used_error' => "새 값이 사용자의 계정 및 사이트에서 이미 사용 중인 실제 리소스의 양보다 적기 때문에 필요한 리소스 사용량 제한(%%quantity%% %%limitName%%)을 설정할 수 없습니다(%%used%% %%limitName%%).",

    'ui__client/domain/traffic#list__title' => "서비스별 대역폭 사용량",

    'ui__client/domain/traffic_unknown-reseller__short-title' => "트래픽 사용량 보고서 보기",
    'ui__client/domain/traffic_unknown-reseller__title' => "트래픽 사용량 보고서 보기",

    'ui__client/domain_new__short-title' => "도메인 만들기",

    'ui__client_reseller__description' => "%1의 리셀러 계정을 관리합니다.",
    'ui__client_reseller__short-title' => "%1",
    'ui__client_reseller__title' => "리셀러 계정 관리",

    '__owner_name' => "소유자 이름",
    'domains_list__resource__filter_title' => "리소스 사용량",

    // APS CATALOG
    'site_apps__application_catalog_preferences' => "APS 응용 프로그램 카탈로그",
    'site_apps__applications_have_updates' => "다음 응용 프로그램의 업데이트 버전을 이용할 수 있음:\n%1\n업데이트를 보려면 검색 영역이 표시되었는지 확인하고 <b>업데이트만 표시</b> 확인란을 선택한 다음 필요한 응용 프로그램을 검색합니다.",
    'site_apps__progress_adding_to_vault' => "저장소에 추가:",
    'site_apps__progress_done_message' => "진행률:",
    'site_apps__progress_applications_left' => "%1 / %2 응용 프로그램 남음",
    'site_apps__download_item_long_task_title' => "APS 응용 프로그램(%1) 다운로드",
    'site_apps__download_transaction_long_task_title' => "APS 카탈로그에서 APS 응용 프로그램 다운로드",
    'site_apps__last_check_for_updates' => "마지막 업데이트 확인: %1",
    'site_apps__all_sucessfully_added_to_app_vault' => "예약된 모든 응용 프로그램이 응용 프로그램 저장소에 추가되었습니다.",
    'site_apps__number_of_apps_sucessfully_added_to_app_vault' => "%1 예약된 응용 프로그램이 응용 프로그램 저장소에 추가되었습니다.",
    'site_apps__no_search_results' => '응용 프로그램을 찾을 수 없음. 다시 검색하거나 범주를 기준으로 응용 프로그램을 탐색하십시오.',
    'site_apps__search_results_title' => '검색 결과',
    '__site_apps__search_by_application' => '응용 프로그램 이름',
    '__site_apps__search_by_vendor' => '공급업체',
    '__site_apps__search_by_vendor__all' => '모든 공급업체',
    '__site_apps__search_by_packager' => '패키지 생성자',
    '__site_apps__search_by_certification_level' => '인증 레벨',
    '__site_apps__search_by_cert__any' => '모두',
    '__site_apps__search_by_cert__silver_and_higher' => '실버 이상',
    '__site_apps__search_by_cert__gold_and_higher' => '골드 이상',
    '__retry' => '다시 시도',
    'site_apps__application_packager_site' => '패키지 생성자',
    'site_apps__add_to_pool_message' => "\"모두에 사용 가능\"으로 표시된 응용 프로그램은 설치 수에 제한 없이 모든 리셀러와 고객에게 자동으로 배포됩니다. 제한된 응용 프로그램은 사용 가능한 설치 수가 명시적으로 지정되며 모든 리셀러와 고객에게 개별적으로 수동 배포됩니다.",
    'site_apps__make_available_for_all' => "선택한 응용 프로그램을 모든 사용자가 사용할 수 있게 함",

    'site_apps__broadcast_app_text' => "\"모두에 사용 가능\"으로 표시된 응용 프로그램은 설치 수에 제한 없이 모든 리셀러와 고객에게 자동으로 배포됩니다. 제한된 응용 프로그램은 사용 가능한 설치 수가 명시적으로 지정되며 모든 리셀러와 고객에게 개별적으로 수동 배포됩니다.",
    'site_apps__broadcast_app_name' => '모든 사용자가 응용 프로그램을 사용할 수 있게 만들기',

    // User Application Pool per application
    'site_apps__available_clients' => '사용 가능한 사용자',
    'site_apps__no_more_clients_to_add_to_pool' => '이 응용 프로그램에 제공할 수 있는 사용자 계정이 더 이상 없습니다.',

    // Installed application instances
    'site_apps__installations' => '설치',

    // Hosting setup redesign
    '__domain_name_and_ip_address' => "도메인 이름 및 IP 주소",
    '__assign_ip_address' => "IP 주소 할당",
    '__switch_on_service' => "서비스 사용",
    '__hosting_configuration' => "호스팅 구성",
    '__vrt_hst' => "웹 사이트 호스팅",
    '__vrt_hst_hint' => "이 서버에서 웹 사이트를 호스팅합니다.",
    '__fwd' => "전달",
    '__web_hosting_settings' => "호스팅 설정",
    '__fwd_hint' => "방문자를 다른 웹 사이트로 리디렉션합니다.",
    '__none_hint' => "지금은 웹 사이트를 호스팅하지 않습니다.",
    '__login_hint' => "이 사용자 이름은 FTP를 통한 웹 사이트 액세스에 사용됩니다.",
    '__password_hint' => "이 암호는 FTP를 통한 웹 사이트 액세스에 사용됩니다.",
    '__advanced_hosting_setup' => "고급 웹 사이트 호스팅 설정 구성",
    '__domain_creation_successful' => "도메인이 만들어졌습니다.",
    'bt_hosting_settings' => "호스팅 설정",
    '__change_hosting_type' => "도메인의 호스팅 유형 변경 %1",
    '__hosting_type_change_warning' => "호스팅 유형을 전달 또는 호스팅 없음으로 변경하면 해당 사이트에 관련된 모든 파일과 디렉터리가 서버에서 제거됩니다. 반드시 사이트의 로컬 복사본을 저장하십시오.",
    '__current_hosting_type' => "현재 호스팅 유형",
    '__new_hosting_type' => "새 호스팅 유형",
    '__fwd_settings' => "전달 설정",
    '__fwd_settings_legend' => "전달 설정",
    '__fwd_destination_url' => "대상 URL",
    '__fwd_type' => "전달 유형",
    '__fwd_type_standart' => "표준 전달",
    '__fwd_type_standart_hint' => "웹 사이트 방문자를 다른 사이트로 리디렉션하고 방문자가 리디렉션 사실을 알도록 방문자에게 대상 주소를 표시합니다.",
    '__fwd_type_frame' => "프레임 전달",
    '__fwd_type_frame_hint' => "웹 사이트 방문자를 다른 사이트로 리디렉션하지만 방문자가 리디렉션 사실을 알지 못하도록 방문자에게 대상 주소를 표시하지 않습니다.",
    '__hosting_type_template_warning' => "선택한 호스팅 유형이 템플릿에 지정된 유형과 다릅니다. 계속하는 경우, 선택한 템플릿의 웹 호스팅 설정이 무시됩니다. 선택한 호스팅 유형을 설정하시겠습니까?",

    '__no_resellers_selected' => "하나 이상의 리셀러 계정을 선택해야 합니다.",

    'ui__client/logo_unknown__wizard-title' => '로고 설정',
    'ui__client/logo_unknown__wizard__1_unknown' => '로고 속성을 변경하려는 고객을 선택합니다.',
    'ui__client/logo_unknown__wizard__2' => '변경 내용을 적용하려면 ‘마침’을 클릭합니다.',
    'ui__client/logo_unknown__wizard__2_self' => '변경 내용을 적용하려면 ‘마침’을 클릭합니다.',

    'ui__client/ipaddress/properties_new__short-title' => "IP 주소 추가",
    'ui__client/ipaddress/properties_new__title' => 'IP 주소 추가',
    'ui__client/ipaddress/properties_new__description' => "IP 주소를 추가합니다.",
    'ui__client/ipaddress/properties_unknown-new__short-title' => "IP 주소 추가",
    'ui__client/ipaddress/properties_unknown-new__title' => "IP 주소 추가",
    'ui__client/ipaddress/properties_unknown-new__description' => "IP 주소 추가",
    'ui__client/ipaddress/delete_multi__short-title' => "IP 주소 제거",
    'ui__client/ipaddress/delete_multi__description' => "IP 주소를 제거합니다.",
    'ippool_Manager__no_available_ips' => "IP 풀에 빈 IP 주소가 없습니다.",
    'ippool_Manager__ip_shared' => "공유",
    'ippool_Manager__ip_exclusive' => "전용",
    'ui__client/ipaddress/properties__title' => "IP 주소 관리",
    'ui__client/ipaddress/properties__description' => "IP 주소 속성을 표시하거나 변경합니다.",
    'ui__client/ipaddress_unknown-new__title' => "IP 주소 추가",
    'ui__client/ipaddress_unknown-new__short-title' => "IP 주소 추가",
    'ui__client/ipaddress_unknown-new__description' => "IP 주소를 추가합니다.",

    'ui__mass-mail#to_resellers_text__title' => "리셀러",
    'ui__mass-mail#to_domainusers_text__title' => "도메인 관리자",
    'ui__mass-email#tools_legend__title' => "도구",
    'ui__mass-email#list_legend__title' => '대량 이메일 메시지 템플릿',
    'ui__mass-email#template_legend__title' => "템플릿",
    'ui__mass-email#from_email_text__title' => "시작",
    'ui__mass-email#to_text__title' => '받는 사람',
    'ui__mass-email#to_resellers_text__title' => "리셀러",
    'ui__mass-email#to_clients_text__title' => "고객",
    'ui__mass-email#to_domainusers_text__title' => "도메인 관리자",
    'ui__mass-email#to_admin_text__title' => "Plesk 관리자",
    'ui__mass-email#option_mode_all__title' => "모두",
    'ui__mass-email#option_mode_select__title' => "선택 항목만",
    'ui__mass-email#option_mode_except__title' => "선택 항목을 제외하고 모두",
    'ui__mass-email#option_select_template__title' => '---템플릿 선택---',
    'ui__mass-email#subject_text__title' => "제목",
    'ui__mass-email#body_text__title' => "메시지 텍스트",
    'ui__mass-email#save_as_legend__title' => "템플릿으로 저장",
    'ui__mass-email#save_as_text__title' => "작성된 메시지를 이름이 지정된 새 탬플릿에 저장합니다",
    'ui__reseller/preferences_unknown__wizard-title' => "계정 설정 변경",
    'ui__reseller/preferences_unknown__wizard__1_unknown' => "계정 설정을 변경하려는 리셀러를 선택하고 ‘다음’을 클릭합니다.",
    'ui__reseller/preferences_unknown__wizard__2' => "계정 설정을 지정하고 ‘확인’을 클릭합니다.",
    'ippoolManager__ip_shared' => "공유",
    'ippoolManager__ip_exclusive' => "전용",

    '__users_list' => "사용자",
    '__users' => "사용자",
    '__user_name' => "사용자 이름",

    'limit__name_max_dom_aliases' => "도메인 별칭",
    'limit__name_max_subftp_users' => "추가 FTP 계정",
    'limit__name_max_mssql_db' => "Microsoft SQL Server 데이터베이스",
    'limit__name_max_iis_app_pools' => "IIS 응용 프로그램 풀",
    'limit__name_max_odbc' => "ODBC 연결",
    'total_mboxes_quota_unsupported' => '메일 서버에서 지원되지 않음',
    'limit_soft__disk_space' => '디스크 공간 도달 시 알림',
    'limit_soft__max_traffic' => '트래픽 도달 시 알림',
    'dsr__of_reseller_title' => "도메인별 리소스 사용량",
    'limitsManager__commit_failed' => "리소스 제한을 변경할 수 없음.",
    'limitsManager__date_in_past' => "잘못된 만료 날짜 %1.",
    'limitsManager__limit_not_supported' => "%1의 리소스 유형에 대한 제한은 설정할 수 없습니다.",
    'limitsManager__limit_oversell_inconsistency' => "초과 판매가 켜져 있을 때는 지정된 양의 리소스를 할당할 수 없습니다.",
    'limitsManager__limit_overuse_inconsistency' => "리소스 사용량이 정의된 제한을 초과합니다.",
    'limitsManager__no_resource_available' => "이 유형(%%limitName%%)의 사용 가능한 리소스가 남아 있지 않습니다. 요청: %%quantity%% 사용 가능: %%unused%%.",
    'limitsManager__no_total_resource_available' => "서비스 공급자로부터 이 유형(%%limitName%%)의 리소스를 사용할 수 없습니다. 요청: %%quantity%% 사용 가능: %%unused%%.",
    'limitsManager__invalid_expiration_limit' => "만료 날짜는 %1이거나 그 이전이어야 합니다.",
    'limitsManager__invalid_disk_space_limit' => "디스크 공간의 양은 %1 미만이어야 합니다.",
    'limitsManager__invalid_max_traffic_limit' => "트래픽의 양은 %1 미만이어야 합니다.",
    'ippoolManager__ip_has_suballocations' => "이미 사용자에게 할당된 IP 주소의 유형을 변경할 수 없음. %%ip%%의 IP 주소는 이미 %%reserved%% IP 주소로 사용자에게 할당되었습니다.",
    'ippoolManager__ip_is_already_in_pool' => "이 IP 주소는 이미 사용자에게 할당되었습니다.",
    'ippoolManager__ip_is_not_in_pool' => "풀에 %%ip%%의 IP 주소가 없습니다.",
    'ippoolManager__can_not_allocate_ip' => "%%ip%%의 IP 주소는 %%available%%(으)로만 사용 가능합니다.",
    'ippoolManager__unable_to_set_default_type' => "%%ip%%의 IP 주소는 전용으로 할당할 수 없습니다.",
    'ippoolManager__ip_used_by_hst_or_frw' => "%%ip%%의 IP 주소는 이미 호스팅에 사용 중입니다.",
    'ippoolManager__active_anon_ftp_on_ip' => "IP 주소에 대해 익명 FTP 액세스가 이미 사용되고 있습니다. %%ip%%",
    'ippoolManager__no_vacant_ips' => "빈 IP 주소가 없습니다.",
    'ippoolManager__no_available_ips' => "사용할 수 있는 IP 주소가 없습니다.",
    'templates__dublicate_name' => "이러한 이름의 템플릿이 이미 있습니다. 이 템플릿에 다른 이름을 선택하십시오.",
    'cl_perm__client_limits_exceeded' => "지정된 리소스 제한 값이 호스팅 계획에서 허용하는 값을 초과합니다. 또는 이러한 값이 현재 사이트에서 사용하는 것보다 적은 리소스를 제공합니다.",
    'cl_perm__reseller_limits_exceeded' => "지정된 리소스 제한 값이 호스팅 계획에서 허용하는 값을 초과합니다. 또는 이러한 값이 현재 사용자 계정 및 사이트에서 사용하는 것보다 적은 리소스를 제공합니다.",

    'site_apps__preferences_show_all_versions_title' => "카탈로그에서 가져온 모든 응용 프로그램의 전체 버전 목록 표시",
    'site_apps__preferences_show_all_versions_hint' => "이 옵션을 선택하면 카탈로그를 열 때마다 각 응용 프로그램의 모든 버전을 가져오는 데 상당히 긴 시간이 걸릴 수 있습니다. 이 옵션을 선택하지 않으면 최신 버전만 표시됩니다.",
    '__select_user_template' => "템플릿을 기반으로 사용자 계정 만들기",
    'ip_already_added_to_all_clients' => "이 IP 주소는 이미 모든 사용자에게 할당되었습니다.",
    'ui__server/ip-address/client/delete#legend__description' => "다음 IP 주소가 시스템과 사용자의 IP 풀에서 제거됨:",

    'site_apps__cancelled_apps' => "사용자가 다음 응용 프로그램의 추가를 취소함: %2",

    'sb_url_is_not_resolved' => 'URL을 확인할 수 없음: DNS 설정을 확인하십시오. URL %1은(는) Presence Builder가 설치된 서버의 IP 주소로 확인되어야 합니다.',

    'ip_addr__is_last_on_interface' => '%%ip%%의 IP 주소는 네트워크 인터페이스에 있던 마지막 IP 주소이기 때문에 제거할 수 없습니다.',
    'ip_addr__used_for_current_session' => '활성 세션에서 사용 중이기 때문에 %%ip%%의 IP 주소를 제거할 수 없습니다.',
    'ip_addr__used_for_hosting' => '웹 사이트 호스팅에 사용 중이기 때문에 %%ip%%의 IP 주소를 제거할 수 없습니다.',
    'ip_addr__is_main' => '%%ip%%의 IP 주소는 네트워크 인터페이스의 기본 IP 주소이기 때문에 제거할 수 없습니다.',
    'ip_addr__ip_used_by_message_submission' => '메일 메시지에 사용 중이기 때문에 %%ip%%의 IP 주소를 제거할 수 없음',

    // RESELLER ACTION LOG

    '__cl_domains' => '고객 도메인',
    'excl_ip_num' => '전용 IP 주소',

    'sb_err_sitebuilder_not_installed' => 'Presence Builder가 설치되지 않았습니다.',

    '__perm_allow_oversell_can_not_be_revoked' => '사용자가 이미 사용 가능한 리소스보다 많은 리소스를 할당하여 초과 판매 모드로 진행했기 때문에 사용자로부터 초과 판매를 허용할 권한을 취소할 수 없습니다.',
    'limitsManager__invalid_limit_value' => '%%value%%의 잘못된 값이 제한으로 지정됨 %%limit_name%%',
    'confirmationForm_default_agreement_text' => '작업 확인',
    'confirmationForm_default_confirm_message' => '작업을 확인하십시오.',
    'limit__max_mn' => '최대 메일 계정 수',

    'limits__client_overuse_description' => 'Plesk는 초과 사용 정책에 따라 리소스 사용량이 초기 리소스 할당량을 초과했을 때의 조치를 결정합니다.',
    'limits__client_overuse_block_true_description' => '리소스의 초과 사용을 차단합니다. 실제 리소스 사용량은 초기 리소스 할당량을 초과할 수 없습니다.',
    'limits__client_overuse_block_false_description' => '고객이 처음 제공된 리소스보다 많은 리소스를 사용할 수 있도록 리소스의 초과 사용을 차단하지 않습니다. 실제 리소스 사용량이 초기 리소스 할당량을 초과할 수 있습니다.',
    'limits__client_overuse_notify_text' => '고객에게 리소스 제한 도달 사실을 알림',

    'limits__domain_overuse_description' => 'Plesk는 초과 사용 정책에 따라 리소스 사용량이 초기 리소스 할당량을 초과했을 때의 조치를 결정합니다.',
    'limits__domain_overuse_block_true_description' => 'Plesk는 초과 사용 정책에 따라 리소스가 초과 사용되었을 때의 조치를 결정합니다.',
    'limits__domain_overuse_block_false_description' => '도메인이 초기 제공된 리소스보다 많은 리소스를 사용할 수 있도록 리소스 초과 사용을 차단하지 않습니다. 실제 리소스 사용량이 초기 리소스 할당량을 초과할 수 있습니다.',
    'limits__domain_overuse_notify_text' => '도메인 소유자에게 리소스 제한 도달 사실을 알림',


    'cancel_remove' => '모든 변경을 취소하고 이전 페이지로 돌아갑니다.',
    'php_not_installed' => 'PHP가 설치되지 않았습니다.',

    'dns__dns_rr_delete' => '제거될 항목',
    'dns__delete_rr' => 'DNS 영역에서 다음 DNS 레코드가 제거됨:',
    'dns__dns_rr_delete_non_removable' => '제거할 수 없는 항목',
    'dns__non_delete_rr' => '다음 DNS 레코드를 제거할 수 없음:',
    'dns__dns_rr_delete_confirm_message' => 'DNS 레코드의 제거 확인',

    'site_apps__format_is_unsupported_broadcast_not_set' => '알 수 없는 웹 응용 프로그램 형식: 웹 응용 프로그램을 설치 및 사용하지 못할 수도 있습니다.',

    '__php_handler_type_desc' => 'PHP를 다음으로 실행',
    'sfdk_domain_sign__failed' => '도메인에서 DKIM으로 메일 서명을 설정하려고 할 때 알 수 없는 오류가 발생했습니다. 자세한 내용은 서버 오류 로그를 참조하십시오.',

    // key management ported from cpp to php
    'pkey_notify__subj_update_success_notification' => 'Plesk 키 업데이트 성공 알림',
    'pkey_notify__subj_update_deferral_notification' => 'Plesk 키 업데이트 지연 알림',
    'pkey_notify__subj_update_error_notification' => 'Plesk 키 업데이트 오류 알림',
    'pkey_notify__update_successful' => '%1 업데이트가 완료됨.',
    'pkey_notify__update_failed_no_more_try' => '%1을(를) 업데이트할 수 없음. 보내려고 하는 키가 유효하지 않습니다. 이 키의 업데이트를 더 이상 시도할 수 없습니다.',
    'pkey_notify__update_failed_try_later' => '%1을(를) 업데이트할 수 없음. 키를 처리하는 동안 오류 발생했습니다. Plesk(도구 및 설정 > 라이센스 정보)에서 키를 수동으로 받을 수 있거나 Plesk가 다음 24시간 안에 업데이트하도록 합니다. 이 알림을 더 이상 받고싶지 않다면 이러한 키를 Plesk에서 키를 제거하십시오.',

    // spam assassin error messages
    'ui__server/spam-filter/toggle__unable_disable' => '서버 전체 스팸 필터를 해제할 수 없습니다.',
    'ui__server/spam-filter/toggle__unable_enable' => '서버 전체 스팸 필터를 사용할 수 없음',

    // Application vault/ application pool for admin mapping - TEMPORARY

    // report
    'report_auto__recipient_reseller' => '이 리셀러',
    'report_auto__select_reseller_report_all' => '모든 리셀러',
    'report_auto__select_reseller_report_client' => '이 고객의 모든 리셀러',
    'report_auto__select_reseller_report_current' => '이 리셀러',
    'report_auto__select_reseller_report_reseller' => '%1',
    'report_auto__select_client_report_reseller' => '이 리셀러의 모든 고객',
    'report_auto__select_client_report_client' => '이 고객',
    'report_auto__select_client_report_other_reseller' => '%1',
    'report_auto__select_admin_report_all' => '리셀러, 고객 및 도메인',

    'rpt_reseller_section_full_domains' => '도메인',
    'rpt_reseller_dom_subdomains' => 'Subdom',
    'rpt_reseller_dom_domain_aliases' => 'DAliase',
    'rpt_reseller_dom_postboxes' => 'MBox',
    'rpt_reseller_dom_redirects' => '전달자',
    'rpt_reseller_dom_mail_groups' => 'MGroup',
    'rpt_reseller_dom_mail_resps' => 'AResp.',
    'rpt_reseller_dom_mail_antispam' => '스팸 방지',
    'rpt_reseller_dom_mail_antivirus' => '안티 바이러스',
    'rpt_reseller_dom_mail_lists' => 'MList',
    'rpt_reseller_dom_web_users' => 'WUser',
    'rpt_reseller_dom_data_bases' => 'DBMySQL',
    'rpt_reseller_dom_mssql_data_bases' => 'DBMSSQL',

    'rpt_reseller_section_full_clients' => '고객',
    '__cl_name' => '고객 이름',
    '__cl_creation_date' => '만든 날짜',
    '__clients_traffic' => '고객 트래픽',
    'rpt_reseller_cl_mail_antispam' => '스팸 방지',
    'rpt_reseller_cl_mail_antivirus' => '안티 바이러스',

    // CONHELPS FOR HOME PAGE
    // common:
    'sitebuilder_not_installed' => 'Presence Builder가 설치되지 않았습니다.',
    'sitebuilder_disabled' => 'Presence Builder가 꺼져 있습니다.',
    'b_sitebuilder_disabled' => 'Presence Builder가 꺼져 있습니다.',
    'webmail_not_installed' => '웹 메일 소프트웨어가 설치되지 않았습니다.',
    'webmail_disabled' => '웹 메일 서비스가 해제되었습니다.',
    'spamassassin_not_installed' => 'SpamAssassin이 설치되지 않았습니다.',
    // pfu:
    'anonymous_ftp_shared' => '익명 FTP를 설정할 수 없음: 공유 IP 주소 유형.',
    'anonymous_ftp_used' => '익명 FTP를 설정할 수 없음: IP 주소가 다른 도메인에서 익명 FTP 서비스에 사용 중입니다.',
    // pfw:
    'aspdotnet_not_installed' => 'ASP.NET가 설치되었습니다.',
    'site_builder_no_package' => 'Presence Builder를 사용할 수 없습니다. Presence Builder가 설치되어 있고 활성 구성 요소로 선택되어 있는지 확인하십시오.',
    'site_builder_not_configured' => 'Presence Builder가 구성되지 않았습니다.',

    // LIST OF CLIENTS
    // under reseller
    'ui__reseller/client#tools__title' => '도구',
    'ui__reseller/client#clientslist__title' => '고객',

    //reseller accounts removal





    // NEW HOME PAGE WIZARDS

    // PFW-only

    'ui__client/domain/hosting/web-directories_unknown__wizard-title' => '웹 사이트의 가상 디렉터리 관리',
    'ui__client/domain/hosting/web-directories_unknown__wizard__2_unknown' => "디렉터리를 관리하려는 웹 사이트를 선택합니다.",

    // COMMON WIZARDS


    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard-title' => '도메인에서 익명 FTP 설정',
    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard__2_unknown' => '익명 FTP를 설정하려는 도메인을 선택합니다.',

    'ui__client/domain/hosting/protected-directories_unknown__wizard-title' => '도메인의 암호로 보호된 디렉터리 관리',
    'ui__client/domain/hosting/protected-directories_unknown__wizard__2_unknown' => '암호로 보호된 디렉터리를 관리하려는 도메인을 선택합니다.',

    'ui__client/domain/hosting/logs_unknown__wizard-title' => '도메인에 대한 로그 관리자를 설정하고 도메인 로그 파일 표시',
    'ui__client/domain/hosting/logs_unknown__wizard__2_unknown' => '로그 관리자를 설정하고 도메인 및 로그 파일을 보려는 도메인을 선택합니다.',

    'ui__client/domain/certificate_unknown__wizard-title' => '도메인용 SSL/TLS 인증서 관리',
    'ui__client/domain/certificate_unknown__wizard__2_unknown' => 'SSL/TLS 인증서를 관리하려는 도메인을 선택합니다.',

    'ui__client/domain/disable_multi__wizard-title' => '도메인 일시 중단',
    'ui__client/domain/disable_multi__wizard__2_multi' => '일시 중단하려는 도메인을 선택합니다.',

    'ui__client/domain/enable_multi__wizard-title' => '도메인 활성화',
    'ui__client/domain/enable_multi__wizard__2_multi' => '활성화하려는 도메인을 선택합니다.',

    'ui__client/domain_unknown__wizard-title' => '도메인 보기',
    'ui__client/domain_unknown__wizard__1_unknown' => '도메인을 보려는 고객을 선택합니다.',

    'ui__client/domain/register_unknown__wizard-title' => '도메인 등록',
    'ui__client/domain/register_unknown__wizard__2_unknown' => '등록하려는 도메인을 선택합니다.',

    'ui__client/domain/extras_unknown__wizard-title' => 'MyPlesk.com의 도구 사용',
    'ui__client/domain/extras_unknown__wizard__2_unknown' => 'MyPlesk.com의 도구를 사용하여 관리하려는 도메인을 선택합니다.',

    // various

    'ui__server/ip-address/client_unknown__short-title' => 'IP 주소 사용자',
    'ui__server/ip-address/client_unknown__title' => 'IP 주소 사용자',
    'ui__server/ip-address/client_unknown__description' => 'IP 주소 사용자 %1',

    'disabled_by_admin' => '서버 관리자에 의해 사용 해제됨',






    'ui__client/domain/chowner_multi__short-title' => '소유권 변경',
    'ui__client/domain/chowner_multi__title' => '구독 소유권 변경',
    'ui__client/domain/chowner_multi__description' => '구독 소유권을 변경합니다.',

    'ui__client/domain/chowner_multi__wizard__2_multi' => '소유권을 변경하려는 도메인을 선택하고 ‘다음 >>’을 클릭합니다.',
    'ui__client/domain/chowner_unknown__short-title' => '소유권 변경',
    'ui__client/domain/chowner_unknown__title' => '구독 소유권 변경',
    'ui__client/domain/chowner_unknown__description' => '구독 소유권을 변경합니다.',

    'ui__client/domain/chowner_unknown__wizard-title' => '구독 소유권 변경',

    //custom buttons reseller home support
    //ui captions
    'ui__reseller/custom-buttons/custom-button__none-available' => '사용자 지정 버튼이 없습니다.',
    'ui__reseller/custom-buttons/custom-button__none-available__1' => '리셀러 %1의 인터페이스에서 사용자 지정 버튼이 없습니다.',

    'ui__reseller/custom-buttons/custom-button/delete__description' => '버튼 제거 %1.',

    'ui__reseller/custom-buttons/custom-button/delete__short-title' => '제거',
    'ui__reseller/custom-buttons/custom-button/delete__title' => '버튼 제거 %1',
    'ui__reseller/custom-buttons/custom-button/delete_multi__description' => '리셀러에서 사용자 지정 버튼 제거',

    'ui__reseller/custom-buttons/custom-button/delete_multi__short-title' => '제거',
    'ui__reseller/custom-buttons/custom-button/delete_multi__title' => '사용자 지정 버튼 제거',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard-title' => '버튼 제거',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => '사용자 지정 버튼을 제거하려는 리셀러를 선택하고 ‘다음 >>’을 클릭합니다.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__3_multi' => '제거하려는 버튼을 선택하고 ‘다음 >>’을 클릭합니다.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__4_multi' => '이 화면에서 확인란을 선택하여 버튼 제거를 확인한 다음 ‘마침’을 클릭합니다.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__description' => '리셀러에서 사용자 지정 버튼을 제거합니다.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__short-title' => '제거',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__title' => '사용자 지정 버튼 제거',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard-title' => '사용자 지정 버튼 제거',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => '사용자 지정 버튼을 제거하려는 리셀러를 선택하고 ‘다음 >>’을 클릭합니다.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => '제거하려는 사용자 지정 버튼을 선택하고 ‘다음 >>’을 클릭합니다.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__4' => '이 화면에서 확인란을 선택하여 사용자 지정 버튼 제거를 확인한 다음 ‘마침’을 클릭합니다.',

    'ui__reseller/custom-buttons/custom-button/properties__description' => '리셀러 레벨 사용자 지정 버튼인 %1의 속성을 편집합니다.',

    'ui__reseller/custom-buttons/custom-button/properties__short-title' => '설정',
    'ui__reseller/custom-buttons/custom-button/properties__title' => '리셀러의 사용자 지정 버튼 수정 %1',

    'ui__reseller/custom-buttons/custom-button/properties_new__wizard-title' => '사용자 지정 버튼 추가',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__1_unknown' => '인터페이스에서 사용자 지정 버튼을 만들려는 리셀러를 선택하고 ‘다음 >>’을 클릭합니다.',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__4_new' => '‘마침’을 클릭하여 버튼을 만듭니다.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__description' => '리셀러의 인터페이스에서 버튼 속성을 변경합니다.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__short-title' => '속성',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__title' => '리셀러의 인터페이스에서 버튼 속성 변경',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard-title' => '사용자 지정 버튼 속성 변경',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => '사용자 지정 버튼을 수정하려는 리셀러를 선택하고 ‘다음 >>’을 클릭합니다.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => '수정하려는 사용자 지정 버튼을 선택하고 ‘다음 >>’을 클릭합니다.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__4' => '버튼의 속성을 모두 편집했으면 ‘마침’을 클릭하여 변경 내용을 적용하고 마법사를 종료합니다.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__description' => '%1 버튼을 고객이 사용할 수 없도록 합니다.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__short-title' => '고객이 사용할 수 없도록 함',
    'ui__reseller/custom-buttons/custom-button/toggle_private__title' => '%1 버튼을 고객이 사용할 수 없도록 함',
    'ui__reseller/custom-buttons/custom-button/toggle_public__description' => '%1 버튼을 리셀러의 고객에게 표시합니다.',
    'ui__reseller/custom-buttons/custom-button/toggle_public__short-title' => '고객이 사용할 수 있도록 함',
    'ui__reseller/custom-buttons/custom-button/toggle_public__title' => '%1 버튼을 리셀러의 고객에게 표시',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__description' => '사용자 지정 버튼을 고객이 사용할 수 있도록/사용할 수 없도록 합니다.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__short-title' => '고객이 사용할 수 있도록/사용할 수 없도록 함',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__title' => '사용자 지정 버튼을 고객이 사용할 수 있도록 또는 사용할 수 없도록 함',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard-title' => '사용자 지정 버튼을 고객이 사용할 수 있도록/사용할 수 없도록 합니다.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => '사용자 지정 버튼을 리셀러의 고객이 사용할 수 있도록 하려는 리셀러를 선택하고 ‘다음 >>’을 클릭합니다.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => '고객이 사용할 수 있거나 사용할 수 없도록 하려는 사용자 지정 버튼을 선택하고 ‘다음 >>’을 클릭합니다.',

    '__not_allowed' => '허용되지 않음',

    'ui__client/domain/chowner__wizard__3' => '',
    'ui__client/domain/chowner__wizard__3_select' => '도메인의 새 소유자를 선택합니다.',

    '__ip_addr_state_unknown' => "시스템이 아직 사용자의 요청을 처리 중이어서 IP 주소가 정상 작동하지 않습니다. 잠시만 기다려 주십시오.",


    'resellers_list__accounts' => '사용자',

    'ip_addr__repair_is_not_allowed' => 'IP 주소는 Virtuozzo 환경에서 복구할 수 없습니다.',

    'ui__reseller/client__none-available__1' => '%1 리셀러에게는 고객이 없습니다.',

    'ippoolManager__ip_used_by_nohost_domain' => "IP 주소 %%ip%%는 호스팅이 없는 하나 이상의 도메인에서 사용하고 있으므로 제거할 수 없습니다.",
    'ippoolManager__ip_used_for_mail_service' => "%%ip%% IP 주소는 하나 이상의 도메인에서 메일 서비스 IP 주소로 사용되기 때문에 제거할 수 없습니다.",
    'ippoolManager__ip_used_for_send_emails' => "%%ip%% IP 주소는 특정 IP에서 이메일을 보내는 데 사용되기 때문에 제거할 수 없습니다(메일 서버 설정 참조).",
    'ippoolManager__ip_used_in_dns_zone' => '하나 이상의 도메인의 DNS 영역에서 사용 중이기 때문에 %%ip%%의 IP 주소를 제거할 수 없습니다.',
    'ip_ctrl__cannot_manage_on_vz' => '이 Plesk 설치는 Virtuozzo 컨테이너에서 진행되고 있습니다. 새 IP 주소는 Virtuozzo 컨테이너 노드 관리자만 추가시킬 수 있습니다.',

    'client_template__limits_auto_adjusted' => '고객 템플릿 제한이 자동으로 조정되었습니다.',

    '__entries' => '항목',

    '__path_is_not_set' => '경로가 지정되지 않았습니다. 유효한 경로를 지정하십시오.',

    'defaultcomponents__imap_required' => '(현재 메일 서버가 IMAP를 지원하지 않음)',

    '__commercial_web_stats_not_installed' => 'Plesk는 하위 도메인 통계 계산을 위한 상업용 웹 통계 소프트웨어만 지원합니다. 그러한 소프트웨어가 현재 시스템에 설치되어 있지 않습니다.',

    'mail__spamassassin_personal_settings_disallowed' => '개인 스팸 필터링 설정 적용 기능이 서버 관리자에 의해 해제되었습니다. 아래 지정한 스팸 필터링 설정이 적용되지 않습니다.',

    'server_settings_invalid_traffic_statistics' => '잘못된 트래픽 통계 유지 매개 변수입니다.',
    'server_settings_invalid_logrotate_period' => '잘못된 로그 순환 기간 매개 변수입니다.',
];