<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
$messages = [
    'adminaliases.statusActive' => 'A conta está ativa.',
    'adminaliases.statusInactive' => 'A conta foi suspensa: Este administrador não pode efetuar registro no Plesk.',
    'adminaliases.buttonRemoveAdminAlias' => 'Remover',
    'adminaliases.hintRemoveAdminAlias' => 'Remover as contas de administrador selecionadas.',
    'adminaliases.confirmOnRemove' => 'Deseja realmente remover as contas de administrador selecionadas?',
    'adminaliases.buttonAddNewAdminAlias' => 'Adicionar Conta de Administrador',
    'adminaliases.hintAddNewAdminAlias' => 'Criar uma conta de administrador adicional.',
    'adminaliases.buttonMoreActions' => 'Mais',
    'adminaliases.buttonActivateAdminAlias' => 'Ativar',
    'adminaliases.hintActivateAdminAlias' => 'Ativar contas de administrador suspensas.',
    'adminaliases.buttonDeactivateAdminAlias' => 'Suspender',
    'adminaliases.hintDeactivateAdminAlias' => 'Suspender as contas de administradores selecionados. O Plesk negará acesso para esses administradores.',
    'adminaliases.confirmOnDelete' => 'Deseja realmente remover as contas de administrador selecionadas?',
    'adminaliases.login' => 'Nome do usuário',
    'adminaliases.contact' => 'Nome de contato',
    'adminaliases.email' => 'E-mail',
    'adminaliases.comments' => 'Comentários',

    'appinfo.installedAt' => 'Caminho de instalação',
    'appinfo.noInstallationUrlAvailable' => 'Nenhum',
    'appinfo.subscriptionName' => 'Assinatura',
    'appinfo.subscriptionOwner' => 'Proprietário da assinatura',
    'appinfo.buttonLogin' => 'Abrir em Painel do Cliente',
    'appinfo.buttonLoginClassicMode' => 'Gerenciar hospedagem',
    'appinfo.hintLogin' => 'Abrir o Painel do Cliente do assinante.',
    'appinfo.hintAdminLogin' => 'Gerenciar serviços de hospedagem associados com uma determinada conta de hospedagem: Domínios e DNS, aplicativos web e bases de dados, e-mail, etc.',
    'appinfo.hintLoginClassicMode' => 'Gerenciar serviços de hospedagem associados com uma determinada conta de hospedagem: Domínios e DNS, aplicativos web e bases de dados, e-mail, etc.',
    'appinfo.update' => 'As atualizações estão disponíveis.',
    'appinfo.updateFailed' => 'Falha na atualização.',
    'appinfo.noUpdates' => 'Não há atualizações disponíveis.',
    'appinfo.foundUpdates' => 'As atualizações estão disponíveis para os seguintes aplicativos: ',
    'appinfo.buttonCheckForUpdates' => 'Verificar atualizações',
    'appinfo.buttonCheckForUpdatesDescription' => 'Verifica atualizações disponíveis.',
    'appinfo.buttonChangeSettings' => 'Configurações',
    'appinfo.buttonChangeSettingsDescription' => 'Alterar as configurações do aplicativo relacionado ao servidor.',
    'appinfo.appNotConfigured' => 'Não configurado',

    'appuploaded.name' => 'Nome',
    'appuploaded.numberOfInstances' => 'Número de instalações',
    'appuploaded.buttonUploadNewApp' => 'Adicionar aplicativo',
    'appuploaded.buttonUploadNewAppDescription' => 'Adicionar um pacote de aplicativo no servidor.',
    'appuploaded.buttonRemove' => 'Remover',
    'appuploaded.buttonRemoveDescription' => 'Remover os pacotes selecionados.',
    'appuploaded.confirmOnDelete' => 'Deseja realmente remover os pacotes selecionados?',
    'appuploaded.appInvisible' => 'Não disponível para clientes',
    'appuploaded.appGlobalSettingsNotSet' => 'Não configurado',
    'appuploaded.buttonMakeAppVisible' => 'Disponibilizar',
    'appuploaded.buttonMakeAppVisibleDescription' => 'Disponibilizar os aplicativos para instalação pelos clientes.',
    'appuploaded.buttonMakeAppInvisible' => 'Indisponibilizar',
    'appuploaded.buttonMakeAppInvisibleDescription' => 'Indisponibilizar os aplicativos para instalação pelos clientes.',

    'appusage.name' => 'Nome',
    'appusage.numberOfInstances' => 'Número de instalações',
    'appusage.buttonCleanApplicationCache' => 'Limpar Cache',
    'appusage.buttonCleanApplicationCacheDescription' => 'Excluir arquivos temporários transferidos via download durante a instalação dos aplicativos.',
    'appusage.buttonRedirectToMarket' => 'Ir para a Loja On-line',
    'appusage.buttonRedirectToMarketDescription' => 'Adquirir licenças de aplicativos para instalação nos websites.',
    'appusage.updateFailed' => 'Falha na atualização.',
    'appusage.noUpdates' => 'Não há atualizações disponíveis.',
    'appusage.foundUpdates' => 'As atualizações estão disponíveis para os seguintes aplicativos: ',
    'appusage.buttonCheckForUpdates' => 'Verificar atualizações',
    'appusage.buttonCheckForUpdatesDescription' => 'Verificar as atualizações disponíveis no Catálogo de Aplicativos.',
    'appusage.buttonUpdateSettings' => 'Configurações de Atualização',
    'appusage.buttonUpdateSettingsDescription' => 'Configurações de atualização de app amplo para servidor.',

    'controlpanelaccessnetworks.ipAddress' => 'Endereço IP',
    'controlpanelaccessnetworks.subnetMask' => 'Máscara de sub-rede',
    'controlpanelaccessnetworks.buttonAddNewNetwork' => 'Adicionar Rede',
    'controlpanelaccessnetworks.buttonAddNewNetworkDescription' => 'Clique para adicionar a rede à lista de restrição de acesso.',
    'controlpanelaccessnetworks.buttonRemove' => 'Remover',
    'controlpanelaccessnetworks.buttonRemoveDescription' => 'Clique para remover as redes selecionadas da lista.',
    'controlpanelaccessnetworks.confirmOnDelete' => 'Você deseja remover as redes selecionadas?',
    'controlpanelaccessnetworks.buttonSettings' => 'Configurações',
    'controlpanelaccessnetworks.buttonSettingsDescription' => 'Clique para alterar a política de restrição de acesso.',
    'controlpanelaccessnetworks.loadingTitle' => 'Por favor, aguarde. Carregando...',

    'customers.filterCustomerName' => 'Nome do cliente',
    'customers.filterSubscription' => 'Assinatura',
    'customers.filterOptionSubscriptionAny' => 'Qualquer',
    'customers.filterOptionSubscriptionMy' => 'Meus planos',
    'customers.filterOptionSubscriptionReseller' => 'Planos do %%planOwnerContactName%%', // Note for translators: you can use here structure like "Plans of Reseller <name>" or alike if it is more convenient
    'customers.filterOptionSubscriptionCustom' => 'Customizar',
    'customers.filterOwnership' => 'Provedor',
    'customers.filterOptionOwnershipAny' => 'Todos os clientes',
    'customers.filterOptionOwnershipMy' => 'Meus clientes',
    'customers.filterOwnershipReseller' => 'Clientes do %%resellerContactName%%', //Note for translators: see 'filterOptionSubscriptionReseller'
    'customers.filterResourceUsage' => 'Uso de recursos',
    'customers.filterOptionResourceUsageAny' => 'Qualquer',
    'customers.filterOptionResourceUsageOveruse' => 'Recursos com excesso de uso',
    'customers.filterOptionResourceUsageOk' => 'Dentro dos limites',
    'customers.filterStatus' => 'Status',
    'customers.filterOptionStatusAny' => 'Qualquer',
    'customers.filterOptionStatusSuspended' => 'Suspenso',
    'customers.filterOptionStatusActive' => 'Ativo',
    'customers.filterDescription' => 'Descrição',
    'customers.statusOk' => 'A conta de cliente está ativa.',
    'customers.statusInactive' => 'A conta do cliente está inativa: O acesso ao Painel do Cliente é bloqueado para o cliente.',
    'customers.statusSuspended' => 'A conta de cliente está suspensa: O acesso ao Painel do Cliente é bloqueado para o cliente e todos os seus usuários. Os domínios dos clientes são suspensos e sua Web, seu FTP e seus serviços de e-mail não estão mais acessíveis aos usuários da Internet.',
    'customers.customerName' => 'Nome do cliente',
    'customers.subscription' => 'Assinatura',
    'customers.setupDate' => 'Data de configuração',
    'customers.ownerName' => 'Provedor',
    'customers.buttonLogin' => 'Entrar como Cliente',
    'customers.buttonLoginClassicMode' => 'Gerenciar hospedagem',
    'customers.hintLogin' => 'Entrar como o Cliente.',
    'customers.hintLoginClassicMode' => 'Gerenciar serviços de hospedagem associados com a conta de hospedagem do cliente: Domínios e DNS, aplicativos web e bases de dados, e-mail, etc.',
    'customers.buttonRemoveCustomer' => 'Remover',
    'customers.hintRemoveCustomer' => 'Remover clientes selecionados.',
    'customers.confirmOnRemove' => 'Deseja realmente remover as contas de cliente selecionadas?',
    'customers.buttonConvertCustomersToReseller' => 'Converter em revendedores',
    'customers.hintConvertCustomersToReseller' => 'Converter as contas do cliente selecionadas em contas do revendedor.',
    'customers.buttonAddNewCustomer' => 'Adicionar Cliente',
    'customers.hintAddNewCustomer' => 'Criar uma conta de cliente com assinatura.',
    'customers.buttonChangeStatus' => 'Alterar o Status',
    'customers.buttonSuspendCustomers' => 'Suspender',
    'customers.hintSuspendCustomers' => 'Suspender as contas de clientes selecionados. O acesso ao Painel do Cliente será bloqueado para os clientes e todos os seus usuários. Os domínios dos clientes serão suspensos e sua Web, seu FTP e seus serviços de e-mail não estarão mais acessíveis aos usuários da Internet.',
    'customers.buttonActivateCustomers' => 'Ativar',
    'customers.hintActivateCustomers' => 'Ativar as contas de clientes selecionados.',
    'customers.buttonChangeOwner' => 'Mover para',
    'customers.hintChangeOwner' => 'Mova os clientes selecionados para outro revendedor.',
    'customers.customPlanName' => 'Customizar',
    'customers.selectNewIp' => 'Selecionar um endereço IP',
    'customers.selectAnotherOwner' => 'Selecione um proprietário',
    'customers.shared' => 'compartilhado',
    'customers.exclusive' => 'dedicado',
    'customers.confirmOnDelete' => 'Tem certeza que deseja remover {count, plural, =1 {o {name} conta do cliente} one {a # conta do cliente selecionado} other {as # contas dos clientes selecionados}}?',
    'customers.hintInfo' => '(?)',

    'customerserviceplans.planName' => 'Nome do plano',
    'customerserviceplans.planTraffic' => 'Tráfego',
    'customerserviceplans.planDiskSpace' => 'Espaço em disco',
    'customerserviceplans.planSubscriptions' => 'Assinaturas',
    'customerserviceplans.planOwner' => 'Provedor',
    'customerserviceplans.filterPlanItem' => 'Customizar item do plano',
    'customerserviceplans.filterOptionPlanItemAny' => 'Qualquer',
    'customerserviceplans.filterOwnership' => 'Proprietário do plano',
    'customerserviceplans.filterOptionOwnershipAny' => 'Todos os planos',
    'customerserviceplans.filterOptionOwnershipMy' => 'Meus planos',
    'customerserviceplans.filterOwnershipReseller' => 'Planos do %%resellerContactName%%',
    'customerserviceplans.unlimited' => 'Ilimitado',
    'customerserviceplans.addonPlanType' => '(complemento)',
    'customerserviceplans.buttonAddNewPlan' => 'Adicionar um Plano',
    'customerserviceplans.hintAddNewPlan' => 'Criar um plano de hospedagem.',
    'customerserviceplans.buttonDuplicatePlans' => 'Clonar Planos',
    'customerserviceplans.hintDuplicatePlans' => 'Criar cópias dos planos de serviço selecionados.',
    'customerserviceplans.buttonAddNewAddonPlan' => 'Adicionar um Add-on',
    'customerserviceplans.hintAddNewAddonPlan' => 'Criar complemento do plano de hospedagem.',
    'customerserviceplans.buttonRemove' => 'Remover',
    'customerserviceplans.hintRemove' => 'Remover os planos de serviço selecionados.',
    'customerserviceplans.buttonMoreActions' => 'Mais ações',
    'customerserviceplans.confirmOnDelete' => 'Deseja realmente remover os planos de serviço selecionados?',
    'customerserviceplans.disabledSelectHint' => 'O plano de serviço tem, no mínimo, uma assinatura associada e não pode ser removido.',

    'domains.filterDomainName' => 'Nome',
    'domains.filterStatus' => 'Status',
    'domains.filterOptionStatusAny' => 'Qualquer',
    'domains.filterOptionStatusSuspended' => 'Suspenso',
    'domains.filterOptionStatusDisabled' => 'Desabilitado',
    'domains.filterOptionStatusActive' => 'Ativo',
    'domains.filterHostingType' => 'Tipo de Hospedagem',
    'domains.filterPhpHandler' => 'Manipulador PHP',
    'domains.filterOptionPhpHandlerAny' => 'Qualquer',
    'domains.filterOptionHostingTypeAny' => 'Qualquer',
    'domains.filterOptionHostingTypeNone' => 'Sem hospedagem',
    'domains.filterOptionHostingTypeForward' => 'Envio de Domínio',
    'domains.filterOptionHostingTypeAlias' => 'Nome Alternativo do Domínio',
    'domains.filterOptionHostingTypeVirtualHost' => 'Hospedagem de Domínio',
    'domains.filterOptionHostingTypeSubdomain' => 'Hospedagem de Subdomínio',
    'domains.filterSubscriberName' => 'Assinante',
    'domains.filterServiceNode' => 'Nó do serviço',
    'domains.filterServiceNodeOptionAny' => 'Qualquer',
    'domains.filterDescription' => 'Descrição',
    'domains.statusDisabled' => 'O domínio está desabilitado.',
    'domains.statusSuspended' => 'O domínio foi suspenso.',
    'domains.domainName' => 'Nome do domínio',
    'domains.hostingType' => 'Tipo de Hospedagem',
    'domains.ownerName' => 'Assinante',
    'domains.setupDate' => 'Data de configuração',
    'domains.expirationDate' => 'Data de expiração',
    'domains.diskUsage' => 'Uso do Disco',
    'domains.traffic' => 'Tráfego',
    'domains.description' => 'Descrição',
    'domains.resellerDescription' => 'Revendedor',
    'domains.ownerDescription' => 'Cliente',
    'domains.openSite' => 'Abrir',
    'domains.previewSite' => 'Pré-visualização',
    'domains.manageInResellerPanel' => 'Gerenciar no Painel do Revendedor',
    'domains.manageInCustomerPanel' => 'Gerenciar no Painel do Cliente',
    'domains.customPlanName' => 'Customizar',
    'domains.website' => 'Web site',
    'domains.subdomainWebsite' => 'Site na web do subdomínio',
    'domains.noHosting' => 'Sem hospedagem',
    'domains.forwardingTo' => 'Enviar para',
    'domains.aliasFor' => 'Nome alternativo para',
    'domains.add' => 'adicionar',
    'domains.buttonAddDomain' => 'Adicionar Domínio',
    'domains.hintAddDomain' => 'Você pode hospedar um novo site neste servidor, configurar o redirecionamento de internet para outro site ou configurar uma zona de DNS de domínio, se desejar ter apenas endereços de e-mail em um nome de domínio.',
    'domains.buttonAddSubdomain' => 'Adicionar Subdomínio',
    'domains.hintAddSubdomain' => 'Crie um site identificado por um nome de domínio de terceiro nível, por exemplo, shop.example.com.',
    'domains.buttonAddDomainAlias' => 'Adicionar nomes alternativos de domínio',
    'domains.hintAddDomainAlias' => 'Configurar um nome de domínio adicional para seu site.',
    'domains.hintRemove' => 'Remova os sites selecionados e todo o seu conteúdo da web, aplicativos, bases de dados e correio eletrônico.',
    'domains.removeConfirmation' => 'Tem certeza que deseja remover {count, plural, =1 {o {name} domínio} one {o # domínio selecionado} other {os # domínios selecionados}}?',
    'domains.removeConfirmationSubscription' => "Os seguintes domínios também serão removidos: %%domains%%",
    'domains.buttonChangeStatus' => 'Alterar o Status',
    'domains.buttonActivateDomains' => 'Ativar',
    'domains.hintActivateDomains' => 'Ativar os domínios selecionados.',
    'domains.buttonDisableDomains' => 'Desabilitar',
    'domains.hintDisableDomains' => 'Desabilite os domínios selecionados.',
    'domains.buttonSuspendDomains' => 'Suspender',
    'domains.hintSuspendDomains' => 'Suspender os domínios selecionados',

    'dnsaclrecords.value' => 'Endereço IP',
    'dnsaclrecords.add' => 'Adicionar endereço IP',
    'dnsaclrecords.remove' => 'Remover',
    'dnsaclrecords.hintRemove' => 'Remover os endereços de IP selecionados.',
    'dnsaclrecords.confirmOnDelete' => 'Remover os endereços de IP selecionados?',
    'dnsaclrecords.emptyViewTitle' => 'A transferência de zona não é permitida',
    'dnsaclrecords.emptyViewDescription1' => 'Por motivos de segurança, você pode permitir a transferência da zona DNS apenas para servidores especificados nos registros NS da zona.',
    'dnsaclrecords.emptyViewDescription2' => 'Para especificar um ou mais servidores para os quais você permite a transferência, clique em "Adicionar endereço IP".',

    'eventhandlers.event' => 'Evento',
    'eventhandlers.priority' => 'Prioridade',
    'eventhandlers.priorityHighest' => 'mais alto (%%value%%)',
    'eventhandlers.priorityHigh' => 'alto (%%value%%)',
    'eventhandlers.priorityNormal' => 'normal (%%value%%)',
    'eventhandlers.priorityLow' => 'baixo (%%value%%)',
    'eventhandlers.priorityLowest' => 'mais baixo (%%value%%)',
    'eventhandlers.user' => 'Usuário',
    'eventhandlers.command' => 'Comando',
    'eventhandlers.buttonAddNewEventHandler' => 'Adicionar Manipulador do Evento',
    'eventhandlers.buttonAddNewEventHandlerDescription' => 'Definir novo gerenciador de eventos.',
    'eventhandlers.buttonRemove' => 'Remover',
    'eventhandlers.buttonRemoveDescription' => 'Remover os gerenciadores de eventos selecionados.',
    'eventhandlers.confirmOnDelete' => 'Remover os gerenciadores de eventos selecionados?',

    'firewallicmprules.status' => 'Status',
    'firewallicmprules.on' => 'A regra está ativa.',
    'firewallicmprules.off' => 'A regra não está ativa.',
    'firewallicmprules.name' => 'Nome da regra',
    'firewallicmprules.allowinboundrouterrequest' => 'Permitir a solicitação de roteador de entrada',
    'firewallicmprules.allowinboundtimestamprequest' => 'Permitir a solicitação de carimbo de data/hora de entrada',
    'firewallicmprules.allowinboundmaskrequest' => 'Permitir a solicitação de máscara de entrada',
    'firewallicmprules.allowoutboundsourcequench' => 'Permitir um retardamento de origem de saída',
    'firewallicmprules.allowoutboundparameterproblem' => 'Permitir um problema de parâmetro de saída',
    'firewallicmprules.allowredirect' => 'Permitir o redirecionamento',
    'firewallicmprules.allowinboundechorequest' => 'Permitir a solicitação de eco de entrada',
    'firewallicmprules.allowoutboundtimeexceeded' => 'Permitir um tempo de saída excedido',
    'firewallicmprules.allowoutbounddestinationunreachable' => 'Permitir um destino de saída inalcançável',

    'firewallinterfaces.firewall' => 'Status do firewall',
    'firewallinterfaces.firewallOn' => 'O firewall está habilitado na interface de rede. Clicar para desabilitar o firewall nesta interface de rede.',
    'firewallinterfaces.firewallOff' => 'O firewall está desabilitado na interface de rede. Clicar para habilitar o firewall nesta interface de rede.',
    'firewallinterfaces.connection' => 'Status da interface',
    'firewallinterfaces.connectionOn' => 'A conexão da interface de rede está habilitada. Clicar para desabilitar a conexão da interface de rede.',
    'firewallinterfaces.connectionOff' => 'A conexão da interface de rede está desabilitada. Clicar para habilitar a conexão da interface de rede.',
    'firewallinterfaces.name' => 'Nome da interface',
    'firewallinterfaces.type' => 'Tipo de interface',
    'firewallinterfaces.statusOn' => 'Ligar',
    'firewallinterfaces.statusOff' => 'Desligar',

    'firewallrules.status' => 'Status',
    'firewallrules.on' => 'A regra está ativa.',
    'firewallrules.off' => 'A regra não está ativa.',
    'firewallrules.name' => 'Nome da regra',
    'firewallrules.description' => 'Descrição',
    'firewallrules.descriptionText' => '%%action%% conexões de entrada de %%from%% na porta %%port%%, perfis: %%profiles%%',
    'firewallrules.allow' => 'Permitir',
    'firewallrules.block' => 'Negar',
    'firewallrules.fromAll' => 'todos',
    'firewallrules.groupAdd' => 'Adicionar',
    'firewallrules.buttonAdd' => 'Adicionar Regra',
    'firewallrules.buttonAddHint' => 'Adicionar uma regra de firewall',
    'firewallrules.groupActions' => 'Ações',
    'firewallrules.buttonRemove' => 'Remover',
    'firewallrules.removeEmptySelection' => 'Nenhuma regra de firewall selecionada.',
    'firewallrules.removeConfirmation' => 'Remover {count, plural, =1 {a regra de firewall {name}} one {a # regra de firewall selecionada} other {as # regras de firewall selecionadas}}?',
    'firewallrules.removeSuccess' => 'As regras de firewall selecionadas foram removidas.',

    'ftpsessions.buttonRemove' => 'Fechar',
    'ftpsessions.buttonRemoveDescription' => 'Encerrar as sessões FTP selecionadas',
    'ftpsessions.buttonRefresh' => 'Atualizar',
    'ftpsessions.buttonRefreshDescription' => 'Atualizar os dados na tela',
    'ftpsessions.typeColumnName' => 'T',
    'ftpsessions.statusColumnName' => 'S',
    'ftpsessions.loginColumnName' => 'Login',
    'ftpsessions.domainColumnName' => 'Nome do domínio',
    'ftpsessions.currentLocationColumnName' => 'Local atual',
    'ftpsessions.fileNameColumnName' => 'Nome de arquivo',
    'ftpsessions.speedColumnName' => 'Velocidade, KB/S',
    'ftpsessions.progressColumnName' => 'Progresso, %',
    'ftpsessions.ipAddressColumnName' => 'Endereço IP',
    'ftpsessions.logonTimeColumnName' => 'Tempo de login',
    'ftpsessions.idleTimeColumnName' => 'Tempo ocioso',
    'ftpsessions.sessionTypeDomainAdminTooltip' => 'Sessão do administrador do domínio.',
    'ftpsessions.sessionTypeSubDomainAdminTooltip' => 'Sessão do administrador do subdomínio.',
    'ftpsessions.sessionTypeWebUserTooltip' => 'Sessão do usuário da web.',
    'ftpsessions.sessionTypeFtpAccountTooltip' => 'Sessão da conta de FTP.',
    'ftpsessions.sessionTypeAnonymousTooltip' => 'Sessão de usuário FTP anônimo.',
    'ftpsessions.sessionTypeNotPleskUserTooltip' => 'Usuário FTP que não está registrado no Plesk.',
    'ftpsessions.sessionStatusIdle' => 'Ocioso (nenhuma transação).',
    'ftpsessions.sessionStatusUploadInProgress' => 'O upload está em andamento.',
    'ftpsessions.sessionStatusDownloadInProgress' => 'O download está em andamento.',
    'ftpsessions.sessionStatusDownloadingDirsList' => 'Download de uma lista de diretórios.',
    'ftpsessions.sessionStatusLastCmdIsType' => 'O último comando enviado pelo cliente é TYPE.',
    'ftpsessions.sessionStatusLastCmdIsPass' => 'O último comando enviado pelo cliente é PASS.',
    'ftpsessions.sessionStatusLastCmdIsNoop' => 'O último comando enviado pelo cliente é NOOP.',
    'ftpsessions.sessionStatusNotKnown' => 'Atividade FTP não reconhecida.',
    'ftpsessions.confirmOnDelete' => 'Você realmente deseja encerrar as sessões selecionadas?',

    'ipaddresses.buttonAddNewIpAddress' => 'Adicionar endereço IP',
    'ipaddresses.buttonAddNewIpAddressDescription' => 'Adicionar um endereço IP ao pool de servidores de endereços IP.',
    'ipaddresses.buttonRereadConfiguration' => 'Ler IP novamente',
    'ipaddresses.buttonRereadConfigurationDescription' => 'Sincronizar a lista de endereços IP com a configuração dos adaptadores de rede.',
    'ipaddresses.buttonReloadPublic' => 'Atualizar IPs públicos',
    'ipaddresses.buttonReloadPublicDescription' => 'Atualize os endereços IP públicos com base nos metadados da instância do hiperscaler',
    'ipaddresses.buttonFirewall' => 'Firewall',
    'ipaddresses.buttonFirewallDescription' => 'Configurar o firewall',
    'ipaddresses.buttonRemove' => 'Remover',
    'ipaddresses.buttonRemoveDescription' => 'Remover',
    'ipaddresses.confirmOnDelete' => 'Remover endereços IP selecionados?',
    'ipaddresses.address' => 'Endereço IP',
    'ipaddresses.publicAddress' => 'Endereço de IP público',
    'ipaddresses.type' => 'Tipo de IP',
    'ipaddresses.interface' => 'Interface',
    'ipaddresses.resellerCount' => 'Revendedores',
    'ipaddresses.subscriptionCount' => 'Sites',
    'ipaddresses.typeAny' => 'Qualquer',
    'ipaddresses.typeShared' => 'Compartilhado',
    'ipaddresses.typeExclusive' => 'Dedicado',
    'ipaddresses.typeSharedHint' => 'compartilhado',
    'ipaddresses.typeExclusiveHint' => 'dedicado',
    'ipaddresses.ipAddressBroken' => 'Esse endereço IP não está configurado de modo apropriado.',
    'ipaddresses.ipAddressBlacklisted' => 'Este endereço de IP está na lista negra.',
    'ipaddresses.repair' => 'Reparar',
    'ipaddresses.buttonSearch' => 'Buscar',
    'ipaddresses.buttonResetSearch' => 'Reinicializar a busca',
    'ipaddresses.removeConfirmation' => 'Tem certeza de remover {count, plural, =1 {o {name} endereço IP} one {os # endereços IPs} other {os # endereços IPs selecionados}}?',
    'ipaddresses.hint' => 'Visualizar, adicionar, remover endereços IP.',
    'ipaddresses.hintWithResellers' => 'Visualizar, adicionar, remover endereços IP e atribuir endereços IP aos revendedores.',
    'ipaddresses.repairSuccess' => 'O endereço IP %%address%% foi sincronizado com o sistema.',
    'ipaddresses.removeSuccess' => 'Os endereços IP selecionados foram removidos.',

    'languages.headerStatus' => 'S',
    'languages.headerCode' => 'Pacote de idioma',
    'languages.headerLanguage' => 'Idioma',
    'languages.headerCountry' => 'País',
    'languages.headerUsed' => 'Usado',
    'languages.filterCode' => 'Pacote de idioma',
    'languages.buttonDisable' => 'Desativar',
    'languages.buttonDisableDescription' => 'Tornar os idiomas selecionados indisponíveis para os usuários.',
    'languages.disableDone' => 'Os idiomas selecionados não estão mais disponíveis para os usuários.',
    'languages.buttonEnable' => 'Permitir',
    'languages.buttonEnableDescription' => 'Tornar os idiomas selecionados disponíveis para os usuários.',
    'languages.enableDone' => 'Os idiomas selecionados tornaram-se disponíveis para os usuários.',
    'languages.buttonMakeDefault' => 'Tornar padrão',
    'languages.buttonMakeDefaultDescription' => 'Tornar o idioma selecionado padrão para o Plesk.',
    'languages.makeDefaultDone' => 'O idioma selecionado foi estabelecido como padrão para o Plesk.',
    'languages.makeDefaultSelectOne' => 'Selecionar um idioma que deseja tornar padrão para o Plesk.',
    'languages.statusActive' => 'Este idioma está disponível para os usuários do Plesk.',
    'languages.statusActiveUnavailable' => 'Este idioma não está disponível para os usuários porque seu limite de número de idiomas permitidos foi excedido.',
    'languages.buttonHintStatusActive' => 'Clique neste ícone para indisponibilizar o idioma aos usuários.',
    'languages.statusInactive' => 'Este idioma não está disponível para os usuários.',
    'languages.buttonHintStatusInactive' => 'Clique neste ícone para disponibilizar o idioma aos usuários.',
    'languages.buttonHintStatusDefaultLangugage' => 'Este é o idioma padrão: não é possível indisponibilizá-lo aos usuários.',
    'languages.langUnknown' => 'Não é possível reconhecer o idioma.',
    'languages.countryUnknown' => 'Não é possível reconhecer o subcódigo do país.',

    'mailqueue.filterQueue' => 'Filas',
    'mailqueue.filterSubject' => 'Assunto',
    'mailqueue.filterSender' => 'Remetente',
    'mailqueue.filterRecipients' => 'Destinatário',
    'mailqueue.subject' => 'Assunto',
    'mailqueue.sender' => 'Remetente',
    'mailqueue.recipients' => 'Destinatários',
    'mailqueue.date' => 'Data',
    'mailqueue.age' => 'Idade',
    'mailqueue.size' => 'Tamanho',
    'mailqueue.buttonRefresh' => 'Atualizar',
    'mailqueue.buttonRefreshHint' => 'Atualizar os dados na tela.',
    'mailqueue.buttonRemove' => 'Remover',
    'mailqueue.buttonRemoveHint' => 'Remover as mensagens selecionadas da fila de e-mail.',
    'mailqueue.confirmOnDelete' => 'Você realmente deseja remover as mensagens selecionadas da fila de e-mail?',
    'mailqueue.buttonClean' => 'Remover',
    'mailqueue.buttonCleanHint' => 'Limpar a fila de e-mail de todas as mensagens.',
    'mailqueue.confirmOnClean' => 'Deseja realmente limpar a fila de e-mail?',
    'mailqueue.queueAll' => 'Todos',
    'mailqueue.queueTodo' => 'Não pré-processado',
    'mailqueue.queueRemote' => 'Remoto',
    'mailqueue.queueLocal' => 'Local',
    'mailqueue.queueLocalAndRemote' => 'Local e remoto',
    'mailqueue.queueActive' => 'Fila de mensagens ativas',
    'mailqueue.queueCorrupted' => 'Fila de mensagens corrompidas',
    'mailqueue.queueDeferred' => 'Fila de mensagens adiadas',
    'mailqueue.queueHold' => 'Fila de mensagens pendentes',
    'mailqueue.queueIncoming' => 'Fila de mensagens de entrada',
    'mailqueue.postfixHint' => 'Mensagens na fila: %%deferred%% deferidas, %%hold%% presas, %%incoming%% de entrada, %%active%% ativas, %%corrupted%% corrompidas, %%total%% total.',
    'mailqueue.qmailHint' => 'Mensagens na fila: %%todo%% não pré-processada, %%local%% local, %%remote%% remota, %%total%% total.',
    'mailqueue.messagesDeleted' => 'As mensagens selecionadas foram removidas da fila de e-mail.',
    'mailqueue.messagesNotDeleted' => 'Não foi possível remover algumas mensagens da fila de e-mail: %%error%%',
    'mailqueue.queueCleaned' => 'A fila de e-mail foi apagada com sucesso.',
    'mailqueue.queueNotCleaned' => 'Não foi possível limpar a fila de e-mail: %%error%%.',

    'phpextensions.enable' => 'Ativar extensão',
    'phpextensions.disable' => 'Desativar extensão',

    'phpextensions.installable.status' => 'Status',
    'phpextensions.installable.notInstalled' => 'Não instalado',
    'phpextensions.installable.outdated' => 'Desatualizado, a última versão é %%latestVersion%%',
    'phpextensions.installable.latest' => 'Mais recente',
    'phpextensions.installable.name' => 'Pacote',
    'phpextensions.installable.description' => 'Descrição',
    'phpextensions.installable.actionInstall' => 'Instalar',
    'phpextensions.installable.actionUpgrade' => 'Faça upgrade para %%version%%',
    'phpextensions.installable.actionDocs' => 'Documentação',
    'phpextensions.installable.actionUninstall' => 'Desinstalar',
    'phpextensions.installable.uninstallConfirmation' => 'Tem certeza de que deseja desinstalar o pacote %%name%%?',
    'phpextensions.installable.groupInstall' => 'Instalar',
    'phpextensions.installable.groupReload' => 'Recarregar',
    'phpextensions.installable.buttonInstallCustom' => 'Instalar pacote',
    'phpextensions.installable.buttonInstallCustomHint' => 'Instale qualquer pacote PECL',
    'phpextensions.installable.buttonReload' => 'Recarregar',
    'phpextensions.installable.buttonReloadHint' => 'Recarregar pacotes PECL',
    'phpextensions.installable.emptyViewFilteredTitle' => 'Não foi possível encontrar nenhum pacote que corresponda ao filtro',
    'phpextensions.installable.emptyViewFilteredDescription' => 'Tente instalar o pacote que você está procurando.',

    'phphandlers.name' => 'Manipulador',
    'phphandlers.domains' => 'Dominios',
    'phphandlers.statusBroken' => 'Este manipulador está corrompido.',
    'phphandlers.statusDisallowedApacheModule' => 'O manipulador não pode ser habilitado porque o módulo Apache correspondente está desligado.',
    'phphandlers.domainsTitle' => 'Os domínios %%domains%% utilizam PHP %%handler%%',
    'phphandlers.closeTitle' => 'Fechar',
    'phphandlers.handlerOutdated' => '(Desatualizada)',
    'phphandlers.handlerDeprecated' => '(Descontinuada)',
    'phphandlers.handlerOutdatedAndDeprecated' => '(Desatualizada, Descontinuada)',

    'planitems.name' => 'Nome',
    'planitems.numberOfPlans' => 'Planos de serviço',
    'planitems.numberOfSubscriptions' => 'Assinaturas',
    'planitems.itemInvisible' => 'Não disponível para revendedores',
    'planitems.buttonMakeItemVisible' => 'Disponibilizar',
    'planitems.buttonMakeItemVisibleDescription' => 'Permitir que os revendedores forneçam os serviços selecionados com os seus próprios planos de hospedagem. As opções correspondentes a esses serviços serão mostradas nas propriedades do plano de hospedagem, na guia "Serviços Adicionais".',
    'planitems.buttonMakeItemInvisible' => 'Indisponibilizar',
    'planitems.buttonMakeItemInvisibleDescription' => 'Não permitir que os revendedores forneçam os serviços selecionados com os seus planos de hospedagem. As opções correspondentes a esses serviços serão removidas das propriedades do plano de hospedagem.',
    'planitems.buttonAddNewCustomItemButton' => 'Adicionar serviço',
    'planitems.buttonAddNewCustomItemButtonDescription' => 'Adicionar um serviço às opções de planos.',
    'planitems.buttonRemoveCustomItem' => 'Remover serviço',
    'planitems.buttonRemoveCustomItemDescription' => 'Remover as opções correspondentes aos serviços selecionados das propriedades do plano de hospedagem.',
    'planitems.confirmOnDeleteSupportButton' => 'Tem certeza que deseja remover as opções selecionadas?',

    'pumpackages.buttonUpdate' => 'Atualizar',
    'pumpackages.buttonUpdateDescription' => 'Atualizar os pacotes selecionados.',
    'pumpackages.buttonLock' => 'Bloquear',
    'pumpackages.buttonLockDescription' => 'Bloquear os pacotes selecionados para impedir atualizações.',
    'pumpackages.buttonUnlock' => 'Desbloquear',
    'pumpackages.buttonUnlockDescription' => 'Desbloquear os pacotes selecionados para impedir atualizações.',
    'pumpackages.buttonCheckUpdates' => 'Verificar atualizações',
    'pumpackages.buttonCheckUpdatesDescription' => 'Verificar pacotes atualizados.',
    'pumpackages.name' => 'Pacote',
    'pumpackages.summary' => 'Descrição',
    'pumpackages.updates' => 'Atualizações',
    'pumpackages.lockedCut' => 'L',
    'pumpackages.lockedHint' => 'O pacote está bloqueado.',
    'pumpackages.unlockedHint' => 'O pacote está desbloqueado.',
    'pumpackages.updated' => 'Atualizar',
    'pumpackages.update' => 'Atualizar para %%version%%',
    'pumpackages.unknownRepo' => 'desconhecido',
    'pumpackages.allUpToDate' => 'Todos os pacotes estão atualizados',
    'pumpackages.allUpToDateLastChecked' => 'Verificado em %%date%%',
    'pumpackages.recheckUpdates' => 'Verificar Novamente Agora',
    'pumpackages.popupInfoTitle' => 'Os Detalhes do Pacote %%package%%',
    'pumpackages.loading' => 'Aguarde...',
    'pumpackages.error' => 'Não foi possível obter a lista de pacotes: %%message%%',
    'pumpackages.currentVersion' => 'versão atual: %%version%%',
    'pumpackages.notInstalled' => 'não instalado',
    'pumpackages.popupUpdateTitle' => 'Atualizar Pacotes',
    'pumpackages.popupUpdatePackagesListTitle' => 'Instalar as seguintes atualizações:',
    'pumpackages.popupUpdateLockedPackagesListTitle' => 'Os seguintes pacotes necessários estão bloqueados para atualização:',
    'pumpackages.popupUpdateDependencies' => '%%count%% pacotes dependentes',
    'pumpackages.unlockPackagesForUpdateOnly' => 'Desbloqueie os pacotes para permitir somente esta atualização',
    'pumpackages.lockedError' => 'A ferramenta Atualizações do Sistema já está instalando atualizações no modo automático. Tente novamente mais tarde.',
    'pumpackages.duplicatesError' => 'Erro: Não foi possível receber informações de atualização porque alguns pacotes têm duplicatas. Remova as duplicatas dos seguintes pacotes: %%duplicates%%',
    'pumpackages.updateInfoError' => 'Erro: Não foi possível receber informações atualizadas para o(s) pacote(s)',
    'pumpackages.selectedPackagesUpToDate' => 'Todos os pacotes selecionados estão atualizados.',
    'pumpackages.taskUpdatingPackages' => 'Atualizando %%count%% pacote(s)...',
    'pumpackages.popupLockTitle' => 'Bloquear Pacotes',
    'pumpackages.popupLockDescription' => 'Se você bloquear um pacote, ele não será atualizado pela ferramenta de Atualizações do Sistema (a menos que você atualize o Plesk). Se outros pacotes exigem uma versão mais recente deste para suas atualizações, eles não serão atualizados. Note que você ainda pode atualizar um pacote bloqueado por meios nativos no console. Para atualizar um pacote bloqueado da interface do Plesk, desbloqueie-o primeiro.',
    'pumpackages.popupLockPackagesListTitle' => 'Bloquear os seguintes pacotes:',
    'pumpackages.popupUnlockTitle' => 'Desbloquear Pacotes',
    'pumpackages.popupUnlockDescription' => 'Estes pacotes não podem ser atualizados porque foram bloqueados para impedir atualizações. Note que você ainda pode atualizar um pacote bloqueado via meios nativos no console ou enquanto atualiza o Plesk. Para atualizar um pacote bloqueado a partir da interface do Plesk, desbloquei-o primeiro.',
    'pumpackages.popupUnlockPackagesListTitle' => 'Desbloquear os seguintes pacotes:',
    'pumpackages.updatesAvailable' => 'Atualizações para o sistema de pacotes %%count%% estão disponíveis',
    'pumpackages.lastedChecked' => '(verificado em %%date%%)',
    'pumpackages.updateAll' => 'Atualizar Tudo',
    'pumpackages.packageManagerDbInconsistent' => 'A informação em alguns pacotes pode não ser real: inconsistências foram detectadas no banco de dados do gerenciador de pacotes do sistema. Resolva este problema manualmente.',

    'resellers.filterResellerName' => 'Nome do revendedor',
    'resellers.filterSubscription' => 'Assinatura',
    'resellers.filterOptionSubscriptionAny' => 'Qualquer',
    'resellers.filterOptionSubscriptionCustom' => 'Customizar',
    'resellers.filterResourceUsage' => 'Uso de recursos',
    'resellers.filterOptionResourceUsageAny' => 'Qualquer',
    'resellers.filterOptionResourceUsageOveruse' => 'Recursos com abuso na utilização',
    'resellers.filterOptionResourceUsageOk' => 'Dentro dos limites',
    'resellers.filterStatus' => 'Status',
    'resellers.filterOptionStatusAny' => 'Qualquer',
    'resellers.filterOptionStatusSuspended' => 'Suspenso',
    'resellers.filterOptionStatusActive' => 'Ativo',
    'resellers.filterSubscriptionStatus' => 'Estado da assinatura',
    'resellers.filterOptionSubscriptionStatusAny' => 'Qualquer',
    'resellers.filterOptionSubscriptionStatusLocked' => 'Bloqueado',
    'resellers.filterOptionSubscriptionStatusUnsynchronized' => 'Dessincronizado',
    'resellers.filterDescription' => 'Descrição',
    'resellers.buttonAddNewReseller' => 'Adicionar Revendedor',
    'resellers.hintAddNewReseller' => 'Criar uma conta de revendedor.',
    'resellers.buttonRemove' => 'Remover',
    'resellers.hintRemove' => 'Remover os revendedores selecionados e todos os seus planos de serviço, clientes e assinaturas.',
    'resellers.confirmOnDelete' => 'Tem certeza que deseja remover {count, plural, =1 {o {name} conta do revendedor} one {a # conta do revendedor selecionado} other {as # contas dos revendedores selecionados}} e todos {count, plural, one {seus} other {seus}} planos de serviço, clientes e assinaturas?',
    'resellers.buttonConvertToCustomer' => 'Converter para clientes',
    'resellers.hintConvertToCustomer' => 'Converte os revendedores selecionados em clientes.',
    'resellers.buttonChangeStatus' => 'Alterar o Status',
    'resellers.buttonActivateResellers' => 'Ativar',
    'resellers.hintActivateResellers' => 'Ativar as contas de revendedores selecionados.',
    'resellers.buttonSuspendResellers' => 'Suspender',
    'resellers.hintSuspendResellers' => 'Suspender as contas de revendedores selecionados. O acesso ao Painel do Cliente será bloqueado para os revendedores e todos os seus clientes; os domínios dos revendedores e de clientes serão suspensos, sua Web, seu FTP e seus serviços de e-mail não estarão mais acessíveis aos usuários da Internet.',
    'resellers.resellerName' => 'Nome do revendedor',
    'resellers.planName' => 'Plano de serviços',
    'resellers.setupDate' => 'Data de configuração',
    'resellers.customers' => 'Clientes',
    'resellers.customPlanName' => 'Customizar',
    'resellers.buttonLogin' => 'Fazer login como Revendendor',
    'resellers.hintLogin' => 'Gerenciar os serviços de hospedagem associados a conta de hospedagem do revendedor.',
    'resellers.statusOk' => 'Esta conta de revendedor está OK: a conta está ativa, a assinatura está sincronizada com o plano.',
    'resellers.statusSuspended' => 'Esta conta de revendedor foi suspensa: O acesso ao Painel do Cliente será bloqueado para o revendedor e todos os seus clientes; os domínios dos revendedores e de seus clientes estão suspensos, bem como os serviços de Web, FTP e e-mail não estão mais acessíveis aos usuários da Internet.',
    'resellers.statusLocked' => 'A assinatura está bloqueada para sincronização: Ela foi excluída da sincronização com o plano de serviço porque os parâmetros da assinatura foram customizados.',
    'resellers.statusUnsynchronized' => 'A assinatura está dessincronizada com o plano do revendedor: Existem alguns serviços ou recursos que o plano do revendedor oferece, mas que a assinatura não fornece.',

    'resellerserviceplans.planName' => 'Nome do plano',
    'resellerserviceplans.planTraffic' => 'Tráfego',
    'resellerserviceplans.planDiskSpace' => 'Espaço em disco',
    'resellerserviceplans.planSubscriptions' => 'Revendedores',
    'resellerserviceplans.unlimited' => 'Ilimitado',
    'resellerserviceplans.buttonAddNewPlan' => 'Adicionar Plano',
    'resellerserviceplans.hintAddNewPlan' => 'Criar um plano de revendedor.',
    'resellerserviceplans.buttonDuplicatePlans' => 'Clonar Planos',
    'resellerserviceplans.hintDuplicatePlans' => 'Criar cópias dos planos de revendedor selecionados.',
    'resellerserviceplans.buttonRemove' => 'Remover',
    'resellerserviceplans.hintRemove' => 'Remover os planos de revendedores selecionados.',
    'resellerserviceplans.confirmOnDelete' => 'Deseja realmente remover os planos dos revendedores selecionados?',
    'resellerserviceplans.disabledSelectHint' => 'Planos de revendedor com, no mínimo, uma assinatura associada não podem ser removidos.',

    'restricteddomains.name' => 'Nome do domínio',
    'restricteddomains.buttonAddNewDomain' => 'Adicionar nome de domínio',
    'restricteddomains.buttonEnableList' => 'Habilitar',
    'restricteddomains.hintAddNewDomain' => 'Adicionar um nome de domínio proibido.',
    'restricteddomains.hintEnableList' => 'Ativar a verificação de nomes de domínio durante a criação do domínio.',
    'restricteddomains.buttonDisableList' => 'Desabilitar',
    'restricteddomains.hintDisableList' => 'Desativar a verificação de nomes de domínio durante a criação do domínio.',
    'restricteddomains.buttonRemoveDomain' => 'Remover',
    'restricteddomains.hintRemoveDomain' => 'Remover os nomes de domínio selecionados.',
    'restricteddomains.confirmOnRemove' => 'Remover os nomes de domínio selecionados?',
    'restricteddomains.buttonMoreActions' => 'Mais',

    'servermailblacklist.groupAdd' => 'Adicionar',
    'servermailblacklist.buttonAdd' => 'Adicionar Domínio',
    'servermailblacklist.buttonAddHint' => 'Adicionar domínio à lista negra',
    'servermailblacklist.groupActions' => 'Ações',
    'servermailblacklist.buttonRemove' => 'Remover',
    'servermailblacklist.entries' => 'Entradas',
    'servermailblacklist.action' => 'Ação',
    'servermailblacklist.deleteAction' => 'Excluir a partir do servidor',
    'servermailblacklist.spamAction' => 'Marcar como spam',
    'servermailblacklist.spamAssassinDisabled' => 'As entradas não serão marcadas como spam porque o SpamAssassin não está instalado ou está desligado',
    'servermailblacklist.removeEmptySelection' => 'Não há entradas selecionadas.',
    'servermailblacklist.removeConfirmation' => 'Remover {count, plural, =1 {a entrada {name}} one {a # entrada selecionada} other {as # entradas selecionadas}}?',
    'servermailblacklist.removeSuccess' => 'As entradas selecionadas foram removidas.',

    'servermailwhitelist.groupAdd' => 'Adicionar',
    'servermailwhitelist.buttonAdd' => 'Adicionar Rede',
    'servermailwhitelist.buttonAddHint' => 'Adicionar rede à lista branca',
    'servermailwhitelist.groupActions' => 'Ações',
    'servermailwhitelist.buttonRemove' => 'Remover',
    'servermailwhitelist.entries' => 'Entradas',
    'servermailwhitelist.whiteListNotEmpty' => 'Os limites da saída de e-mails não funcionarão para os remetentes cujos endereços de IP estão na lista branca do servidor do e-mail. Por exemplo, se houver localhost (127.0.0.0 / 8, ::1 / 128) na lista branca, todos os e-mails do servidor local serão enviados com sucesso independente das limitações. Os remetentes podem utilizar endereços de IP locais (sites e scripts personalizados hospedados no servidor local) ou externos (clientes que enviam e-mails do e-mail instalado em seus computadores ou dispositivos móveis). Para fazer os limites funcionarem para todos os remetentes (tanto locais quanto externos), remova todos os endereços de IP e redes da lista branca. Observe que ao remover o localhost (127.0.0.0 / 8, ::1 / 128) da lista branca pode romper a operação dos sites e scripts que enviam e-mails deste servidor. Para detalhes sobre as limitações na saída de e-mails, consulte o Guia do Administrador, Proteção do Spam de Saída.',
    'servermailwhitelist.removeEmptySelection' => 'Não há entradas selecionadas.',
    'servermailwhitelist.removeConfirmation' => 'Remover {count, plural, =1 {a entrada {name}} one {a # entrada selecionada} other {as # entradas selecionadas}}?',
    'servermailwhitelist.webmailAffected' => 'Removendo o seguinte {count, plural, =1 {rede} one {network} other {redes}} pode impossibilitar o envio de e-mail do webmail: %%list%%',
    'servermailwhitelist.webmailAffectedSingle' => 'A remoção desta rede pode impossibilitar o envio de e-mail do webmail.',
    'servermailwhitelist.removeSuccess' => 'As entradas selecionadas foram removidas.',

    'serverprotection.bannedips.pageHint' => 'Aqui você pode ver os endereços IP banidos, remover restrição, ou mover para a lista de endereços IP confiáveis.',
    'serverprotection.bannedips.ip' => 'Endereço IP',
    'serverprotection.bannedips.banDate' => 'Banido na',
    'serverprotection.bannedips.jail' => 'Jail utilizado',
    'serverprotection.bannedips.buttonRemoveIp' => 'Remover restrição',
    'serverprotection.bannedips.hintRemoveIp' => 'Remover os endereços IP selecionados da lista de endereços banidos.',
    'serverprotection.bannedips.buttonMoveToTrustedIp' => 'Mudar para IPs confiáveis',
    'serverprotection.bannedips.hintMoveToTrustedIp' => 'Mover os endereços de IP selecionados para a lista de endereços confiáveis.',
    'serverprotection.bannedips.buttonEnable' => 'Ativar o banimento de endereço IP',
    'serverprotection.bannedips.hintEnable' => 'Ativar o banimento automático de endereços IP e redes que gerarem tráfego malicioso para o seu servidor.',
    'serverprotection.bannedips.buttonDisable' => 'Desativar o banimento de endereço IP',
    'serverprotection.bannedips.hintDisable' => 'Desativar o banimento automático de endereços IP e redes que gerarem tráfego malicioso para o seu servidor.',
    'serverprotection.bannedips.errorEnableFailed' => 'Não é possível ativar o banimento de endereço IP: %%error%%.',
    'serverprotection.bannedips.errorDisableFailed' => 'Não é possível desativar o banimento de endereço IP: %%error%%.',

    'serverprotection.filters.pageHint' => 'Aqui você pode gerenciar os filtros dos jails.',
    'serverprotection.filters.buttonAddFilter' => 'Adicionar filtro',
    'serverprotection.filters.hintAddFilter' => 'Adicionar um filtro.',
    'serverprotection.filters.buttonRemoveFilter' => 'Remover',
    'serverprotection.filters.hintRemoveFilter' => 'Remover os filtros selecionados.',
    'serverprotection.filters.name' => 'Nome do filtro',

    'serverprotection.jails.pageHint' => 'Aqui você pode ver a lista de jails utilizados para a detecção de endereços IP abusivos.',
    'serverprotection.jails.buttonAddJail' => 'Adicionar jail',
    'serverprotection.jails.hintAddJail' => 'Adicionar um jail.',
    'serverprotection.jails.buttonDisableJails' => 'Desativar',
    'serverprotection.jails.hintDisableJails' => 'Desativar os jails selecionados.',
    'serverprotection.jails.buttonActivateJails' => 'Ativar',
    'serverprotection.jails.hintActivateJails' => 'Ativar os jails selecionados.',
    'serverprotection.jails.buttonRemoveJail' => 'Remover',
    'serverprotection.jails.hintRemoveJail' => 'Remover os jails selecionados.',
    'serverprotection.jails.buttonManageFilters' => 'Gerenciar filtros',
    'serverprotection.jails.hintManageFilters' => 'Aqui você pode gerenciar os filtros do jail.',
    'serverprotection.jails.name' => 'Nome do jail',
    'serverprotection.jails.disabled' => 'Inativo',
    'serverprotection.jails.active' => 'Ativo',
    'serverprotection.jails.status' => 'Status',
    'serverprotection.jails.confirmOnDelete' => 'Você realmente deseja remover os bloqueios selecionados?',

    'serverprotection.logs.pageHint' => 'Aqui você pode ver os logs do Fail2ban.',
    'serverprotection.logs.name' => 'Arquivo',
    'serverprotection.logs.viewHint' => 'Visualizar o arquivo de log.',
    'serverprotection.logs.buttonDownloadHint' => 'Fazer o download do arquivo de log',

    'serverprotection.trustedips.pageHint' => 'Aqui você pode ver os endereços IP confiáveis, adicionar/remover endereços IP da lista de endereços confiáveis.',
    'serverprotection.trustedips.ip' => 'Endereço IP',
    'serverprotection.trustedips.ipDesc' => 'Descrição',
    'serverprotection.trustedips.addDate' => 'Adicionado à confiável no',
    'serverprotection.trustedips.comment' => 'Commentar',
    'serverprotection.trustedips.buttonRemoveIp' => 'Remover',
    'serverprotection.trustedips.hintRemoveIp' => 'Remover da lista de endereços confiáveis os endereços IP selecionados,.',
    'serverprotection.trustedips.buttonAddTrustedIp' => 'Adicionar IP confiável',
    'serverprotection.trustedips.hintAddTrustedIp' => 'Adicionar um endereço IP à lista de endereços confiáveis.',
    'serverprotection.trustedips.buttonEditTrustedIp' => 'Editar descrição',
    'serverprotection.trustedips.buttonEditHint' => 'Edite a descrição de um endereço IP.',

    'serviceinstances.name' => 'Nome de Serviço',
    'serviceinstances.type' => 'Tipo de Serviço',
    'serviceinstances.requiredServices' => 'Serviços Necessários',
    'serviceinstances.description' => 'Assinatura',
    'serviceinstances.buttonAddServiceToSubscription' => 'Adicionar Serviço',
    'serviceinstances.buttonAddServiceToSubscriptionHint' => 'Adicionar um serviço para a assinatura.',
    'serviceinstances.buttonRemove' => 'Remover',
    'serviceinstances.buttonRemoveHint' => 'Remova os serviços selecionados.',
    'serviceinstances.confirmOnDelete' => 'Deseja realmente remover os serviço selecionados?',
    'serviceinstances.isEnabled' => 'Exemplo de serviço está habilitado',
    'serviceinstances.isDisabled' => 'Exemplo de serviço está desabilitado',

    'servicenodes.buttonAddServiceNode' => 'Adicionar Nó de Serviço',
    'servicenodes.buttonAddServiceNodeDescription' => 'Adicionar Descrição do Nó de Serviço',
    'servicenodes.buttonRemoveServiceNode' => 'Remover Nó de Serviço',
    'servicenodes.buttonRemoveServiceNodeDescription' => 'Remover Descrição do Nó de Serviço',
    'servicenodes.description' => 'Descrição',
    'servicenodes.ipAddress' => 'Endereço IP',
    'servicenodes.confirmOnDelete' => 'Deseja realmente remover os nós de serviço selecionados? ',
    'servicenodes.disabledSelectHint' => 'Impossível remover o nó de serviço: Há endereços IP associados a ele.',

    'services.stateColumnHeader' => 'Status',
    'services.nameColumnHeader' => 'Serviço',
    'services.startupTypeColumnHeader' => 'Tipo de inicialização',
    'services.autoStartupType' => 'Automático',
    'services.manualStartupType' => 'Manual',
    'services.disabledStartupType' => 'Desabilitado',
    'services.changeStartupTypeTooltip' => 'Alterar o tipo de inicialização para o serviço',
    'services.drwebName' => 'Plesk Premium Antivirus',
    'services.postgresqlName' => 'PostgreSQL',
    'services.tomcatName' => 'Tomcat Java',
    'services.imap-pop3Name' => 'Servidor Dovecot IMAP e POP3',
    'services.pop3Name' => 'Servidor Courier POP3',
    'services.pop3sName' => 'Servidor Courier POP3 com suporte SSL/TLS',
    'services.imapName' => 'Servidor Courier IMAP',
    'services.imapsName' => 'Servidor Courier IMAP com suporte SSL/TLS',
    'services.authdaemonName' => 'Autenticação daemon Courier IMAP',
    'services.dnsName' => 'Servidor DNS (%%displayName%%)',
    'services.fail2banName' => 'Proibindo endereço IP (Fail2ban)',
    'services.kavName' => 'Antivírus Kaspersky',
    'services.milterName' => "Plesk milter (%%displayName%%)",
    'services.nginxName' => 'Servidor de Proxy reverso (nginx)',
    'services.smtpName' => 'Servidor SMTP (%%displayName%%)',
    'services.spamassassinName' => "SpamAssassin",
    'services.webName' => "Servidor Web (%%displayName%%)",
    'services.resctrlName' => "Controlador de Recursos (Cgroups)",
    'services.activeState' => 'Ligar',
    'services.inActiveState' => 'Desligar',
    'services.do-restart' => 'Reiniciar',
    'services.do-start' => 'Lançamento',
    'services.do-stop' => 'Desligando',
    'services.do-changeStartup' => 'Processando',
    'services.notConfiguredState' => 'Não configurado',
    'services.notInstalledState' => 'Não instalado',
    'services.running-start' => 'O serviço já foi iniciado.',
    'services.notRunning-start' => 'Iniciar o serviço.',
    'services.running-stop' => 'Interrompa o serviço.',
    'services.notRunning-stop' => 'O serviço já foi interrompido.',
    'services.running-restart' => 'Reiniciar o serviço.',
    'services.notRunning-restart' => 'O serviço foi interrompido.',
    'services.startServiceDrWeb' => 'Para iniciar o serviço de antivírus, é necessário ter, pelo menos, uma caixa postal com a verificação do antivírus habilitada.',
    'services.serviceDisabled' => 'Esse recurso não está disponível ou porque sua chave de licença não o suporta ou o serviço não está instalado ou propriamente configurado.',
    'services.serviceDisabledStartupType' => 'O serviço foi desabilitado.',
    'services.phpHandlerSettingsByOsVendor' => '%%displayName%% pelo SO do fornecedor',
    'services.phpFpm' => 'PHP-FPM %%displayName%%',
    'services.urlrewriteComponentName' => "Reescreva a URL",
    'services.dbconnectorComponentName' => "Conector do Banco de Dados",
    'services.tomcatComponentName' => 'Apache Tomcat',
    'services.mysqlserverComponentName' => 'Servidor MySQL',
    'services.troubleshootingComponentName' => 'Resolução de problemas',
    'services.wafComponentName' => 'Firewall de aplicativo web',
    'services.vcsComponentName' => 'Sistema de Controle de Versão',
    'services.antivirusComponentName' => "Antivírus",
    'services.databaseComponentName' => "Servidor SQL",
    'services.sqladminComponentName' => "MySQL Webadmin",
    'services.sqladminmysqlComponentName' => "MySQL Webadmin",
    'services.dnsserverComponentName' => "Servidor DNS",
    'services.firewallComponentName' => "Firewall",
    'services.ftpserverComponentName' => "Servidor de FTP",
    'services.javaComponentName' => "Java",
    'services.mailserverComponentName' => "Servidor de e-mail",
    'services.pleskagentComponentName' => "Plesk Agent",
    'services.psaComponentName' => "Plesk",
    'services.scriptComponentName' => "Web Scripting",
    'services.spamfilterComponentName' => "Filtro de spam",
    'services.statsComponentName' => "Estatísticas Web",
    'services.stunnelComponentName' => "Invólucro SSL/TLS",
    'services.webmailComponentName' => "WebMail",
    'services.webpublishComponentName' => "Publicação na Web",
    'services.webserverComponentName' => "Servidor Web",
    'services.backupsystemComponentName' => 'Sistema de backup',
    'services.networkComponentName' => 'Rede',
    'services.sitebuilderComponentName' => 'Presence Builder',
    'services.saviComponentName' => 'Interface Antivírus Sophos',
    'services.waitMessage' => 'Aguarde',
    'services.buttonRefreshComponents' => 'Atualizar',
    'services.searchTitle' => 'Encontrar serviços...',
    'services.hintRefreshComponents' => 'Atualizar lista de componentes',

    'sessions.searchTitle' => 'Procurar por sessões ativas',
    'sessions.buttonRefresh' => 'Atualizar',
    'sessions.buttonRefreshDescription' => 'Sincronizar a lista de sessões com as sessões abertas atualmente.',
    'sessions.buttonRemove' => 'Fechar',
    'sessions.buttonRemoveDescription' => 'Fechar as sessões selecionadas.',
    'sessions.removeConfirmMessage' => 'Você deseja fechar as sessões selecionadas?',
    'sessions.buttonSettings' => 'Configurações de sessão',
    'sessions.buttonSettingsDescription' => 'Alterar parâmetros de sessão.',
    'sessions.headerType' => 'T',
    'sessions.headerLogin' => 'Login',
    'sessions.headerIpAddress' => 'Endereço IP',
    'sessions.headerLogonTime' => 'Tempo de login',
    'sessions.headerIdleTime' => 'Tempo ocioso',
    'sessions.typeAdmin' => 'Sessão do administrador.',
    'sessions.typeReseller' => 'Sessão de revendedor.',
    'sessions.typeClient' => 'Sessão do cliente.',
    'sessions.altAdminIcon' => 'Admin',
    'sessions.altResellerIcon' => 'Revendedor',
    'sessions.altClientIcon' => 'Cliente',

    'sslcertificates.name' => 'Nome',
    'sslcertificates.used' => 'Utilizado',
    'sslcertificates.csrHint' => 'O componente do CSR é fornecido.',
    'sslcertificates.noCsrHint' => 'O componente do CSR não é fornecido.',
    'sslcertificates.privateKeyHint' => 'O componente da chave privada é fornecido.',
    'sslcertificates.noPrivateKeyHint' => 'O componente da chave privada não é fornecido.',
    'sslcertificates.certificateHint' => 'O componente do certificado é fornecido.',
    'sslcertificates.noCertificateHint' => 'O componente do certificado não é fornecido.',
    'sslcertificates.caCertificateHint' => 'O componente do certificado CA é fornecido.',
    'sslcertificates.noCaCertificateHint' => 'O componente do certificado CA não é fornecido.',
    'sslcertificates.buttonDownloadHint' => 'Fazer o download de todos os componentes de certificado.',
    'sslcertificates.remove' => 'Remover',
    'sslcertificates.hintRemove' => 'Remover os certificados SSL/TLS selecionados do repositório de domínios.',
    'sslcertificates.confirmOnDelete' => 'Remover os certificados SSL/TLS selecionados?',
    'sslcertificates.addCertificate' => 'Adicionar',
    'sslcertificates.hintAddCertificate' => 'Adicionar um novo certificado SSL/TLS.',
    'sslcertificates.viewCertificates' => 'Visualizar',
    'sslcertificates.hintViewCertificates' => 'Visualizar a lista de certificados SSL/TLS que você comprou de seu fornecedor.',
    'sslcertificates.unableSetupPanelCertificate' => 'Não é possível instalar o certificado no Plesk: o conteúdo do certificado e a chave privada estão faltando.',
    'sslcertificates.makeDefault' => 'Tornar padrão',
    'sslcertificates.hintMakeDefault' => 'Utilizar o certificado SSL/TLS selecionado para proteger as conexões para websites criados recentemente.',
    'sslcertificates.unableMakeDefault' => 'Não é possível instalar o certificado-padrão: nenhum certificado com chave privada selecionada.',
    'sslcertificates.successMakeDefault' => 'O certificado SSL/TLS selecionado foi configurado como padrão. Ele pode ser usado para proteger os websites existentes e recém-criados. Sites que usam o certificado padrão anterior continuarão usando esse certificado.',
    'sslcertificates.selectOne' => 'Selecione um certificado SSL/TLS.',

    'subscriptions.filterDomainName' => 'Nome',
    'subscriptions.filterSubscription' => 'Plano de serviços',
    'subscriptions.filterOptionSubscriptionAny' => 'Qualquer',
    'subscriptions.filterOptionSubscriptionMy' => 'Meus planos',
    'subscriptions.filterOptionSubscriptionReseller' => 'Planos do %%planOwnerContactName%%',
    'subscriptions.filterOptionSubscriptionCustom' => 'Customizar',
    'subscriptions.filterOptionSubscriptionAddonType' => '(complemento)',
    'subscriptions.filterResourceUsage' => 'Uso de recursos',
    'subscriptions.filterOptionResourceUsageAny' => 'Qualquer',
    'subscriptions.filterOptionResourceUsageOveruse' => 'Recursos com abuso na utilização',
    'subscriptions.filterOptionResourceUsageOk' => 'Dentro dos limites',
    'subscriptions.filterPlanItem' => 'Customizar item do plano',
    'subscriptions.filterOptionPlanItemAny' => 'Qualquer',
    'subscriptions.filterProvider' => 'Provedor',
    'subscriptions.filterOptionProviderAny' => 'Todas as assinaturas',
    'subscriptions.filterOptionProviderMy' => 'Minhas assinaturas',
    'subscriptions.filterProviderReseller' => 'Assinaturas do %%resellerContactName%%',
    'subscriptions.filterStatus' => 'Status',
    'subscriptions.filterOptionStatusAny' => 'Qualquer',
    'subscriptions.filterOptionStatusSuspended' => 'Suspenso',
    'subscriptions.filterOptionStatusActive' => 'Ativo',
    'subscriptions.filterSubscriptionStatus' => 'Estado da assinatura',
    'subscriptions.filterOptionSubscriptionStatusAny' => 'Qualquer',
    'subscriptions.filterOptionSubscriptionStatusLocked' => 'Bloqueado',
    'subscriptions.filterOptionSubscriptionStatusUnsynchronized' => 'Dessincronizado',
    'subscriptions.filterSubscriberName' => 'Assinante',
    'subscriptions.filterDescription' => 'Descrição',
    'subscriptions.subscriptionName' => 'Assinatura',
    'subscriptions.subscriberName' => 'Assinante',
    'subscriptions.setupDate' => 'Data de configuração',
    'subscriptions.description' => 'Descrição',
    'subscriptions.resellerDescription' => 'Revendedor',
    'subscriptions.ownerDescription' => 'Cliente',
    'subscriptions.manageInResellerPanel' => 'Gerenciar no Painel do Revendedor',
    'subscriptions.manageInCustomerPanel' => 'Gerenciar no Painel do Cliente',
    'subscriptions.buttonAddNewOwnSubscription' => 'Adicionar a própria assinatura',
    'subscriptions.hintAddNewOwnSubscription' => 'Criar uma assinatura para seu próprio uso.',
    'subscriptions.buttonAddNewSubscription' => 'Adicionar Assinatura',
    'subscriptions.hintAddNewSubscription' => 'Criar uma assinatura.',
    'subscriptions.buttonChangeSubscription' => 'Trocar plano',
    'subscriptions.hintChangeSubscription' => 'Associar as assinaturas selecionadas com outro plano de serviço e adicionar ou remover complementos de planos caso o provedor de assinaturas ofereça-os.',
    'subscriptions.buttonRemove' => 'Remover',
    'subscriptions.hintRemove' => 'Remover assinaturas selecionadas.',
    'subscriptions.confirmOnRemove' => 'Deseja realmente remover as assinaturas selecionadas?',
    'subscriptions.buttonChangeStatus' => 'Alterar o Status',
    'subscriptions.buttonActivateSubscriptions' => 'Ativar',
    'subscriptions.hintActivateSubscriptions' => 'Ativar as assinaturas selecionadas.',
    'subscriptions.buttonSuspendSubscriptions' => 'Suspender',
    'subscriptions.hintSuspendSubscriptions' => 'Suspender assinaturas selecionadas. Todos os serviços fornecidos com as assinaturas serão congelados e não ficarão acessíveis aos usuários da Internet.',
    'subscriptions.buttonChangeOwner' => 'Trocar o assinante',
    'subscriptions.hintChangeOwner' => 'Atribuir novamente as assinaturas selecionadas a outro assinante. Isso também muda o provedor das assinaturas, desconecta as assinaturas de seus planos de serviço e as torna \'Customizadas\'.',
    'subscriptions.customPlanName' => 'Customizar',
    'subscriptions.statusOk' => 'O status da assinatura está OK: a assinatura está ativa e sincronizada com o plano.',
    'subscriptions.statusSuspended' => 'A assinatura está suspensa: Todos os serviços fornecidos com a assinatura são congelados e não ficarão acessíveis aos usuários da Internet.',
    'subscriptions.statusSuspendedReasonExpired' => 'A assinatura está suspensa porque expirou: Todos os serviços fornecidos com a assinatura são congelados e não ficarão acessíveis aos usuários da Internet.',
    'subscriptions.statusLocked' => 'A assinatura está bloqueada para sincronização: Ela foi excluída da sincronização com o plano de serviço porque os parâmetros da assinatura foram customizados.',
    'subscriptions.statusUnsynchronized' => 'A assinatura está dessincronizada com o plano de serviço: Existem alguns serviços ou recursos que o plano oferece, mas que a assinatura não fornece.',
    'subscriptions.confirmOnDelete' => 'Tem certeza que deseja remover {count, plural, =1 {a {name} assinatura} one {a # assinatura selecionada} other {as # assinaturas selecionadas}}?',
    'subscriptions.hintInfo' => '(?)',
    'subscriptions.webserverConfigurationDomainHintAdmin' => "A configuração do servidor web para os domínios da assinatura pode estar inconsistente. Corrija os erros nos modelos da configuração do Apache e tente gerar novamente o arquivo de configuração.",
    'subscriptions.webserverConfigurationDomainHintReseller' => "A configuração do servidor web para os domínios da assinatura pode estar inconsistente. Entre em contato com o administrador do servidor para resolver o problema.",
    'subscriptions.unlinkedDomainHint' => 'Alguns dos endereços IP de domínio estão inoperantes e foram excluídos da configuração do servidor. Verifique as vinculações IP do domínio e atualize, se necessário.',
    'subscriptions.hintTitle' => 'Resumo de assinaturas',
    'subscriptions.hintWaitMessage' => 'Carregando...',
    'subscriptions.removeConfirmationSubscription' => "Os seguintes domínios também serão removidos: %%domains%%",

    'webappfirewalllogfiles.name' => 'Nome',
    'webappfirewalllogfiles.modificationDate' => 'Data de modificação',
    'webappfirewalllogfiles.fileSize' => 'Tamanho',
    'webappfirewalllogfiles.remove' => 'Remover',
    'webappfirewalllogfiles.hintRemove' => 'Excluir os arquivos de log selecionados. Somente os arquivos de log processados podem ser removidos.',
    'webappfirewalllogfiles.confirmOnDelete' => 'Remover os arquivos de log selecionados?',
    'webappfirewalllogfiles.viewHint' => 'Clique para visualizar o arquivo de log.',
    'webappfirewalllogfiles.buttonDownloadHint' => 'Clique para fazer o download do arquivo de log.',

    'webmails.name' => 'Nome',
    'webmails.url' => 'URL',
    'webmails.buttonAddNewWebmail' => 'Registrar webmail',
    'webmails.hintAddNewWebmail' => 'Registrar um serviço de webmail adicional no Plesk.',
    'webmails.buttonEnableWebmail' => 'Habilitar',
    'webmails.hintEnableWebmail' => 'Disponibilizar os serviços de webmail selecionados para os clientes.',
    'webmails.buttonDisableWebmail' => 'Desabilitar',
    'webmails.hintDisableWebmail' => 'Indisponibilizar os serviços de webmail selecionados para os clientes.',
    'webmails.buttonRemoveWebmail' => 'Remover',
    'webmails.hintRemoveWebmail' => 'Remover o registro dos serviços de webmail adicionais selecionados. Observe que um webmail instalado com o Plesk Installer não pode ser removido aqui, em vez disso, utilize Ferramentas> Atualizações.',
    'webmails.confirmOnDelete' => 'Deseja realmente remover os registros do webmail selecionados do Plesk?',
    'webmails.statusSuspended' => 'O webmail não está disponível.',
    'webmails.statusOk' => 'O webmail está disponível.',
];