<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
$messages = [
    'aps-install.queue' => 'Instalando %%name%% en %%path%%...',
    'aps-install.queueNoPath' => 'Instalando %%name%%...',
    'aps-install.done' => '%%name%% se ha instalado correctamente en %%path%%. A continuación puede ver sus credenciales para acceder a la aplicación. %%additionalMessage%%',
    'aps-install.doneNoPath' => '%%name%% se ha instalado correctamente. A continuación puede ver sus credenciales para acceder a la aplicación. %%additionalMessage%%',
    'aps-install.doneAdvanced' => '%%name%% se instaló correctamente en %%path%%. %%additionalMessage%%',
    'aps-install.doneAdvancedNoPath' => '%%name%% se instaló correctamente. %%additionalMessage%%',
    'aps-install.error' => 'Error al instalar %%name%% en %%path%%. %%errorMessage%%',
    'aps-install.errorNoPath' => 'Error al instalar %%name%%. %%errorMessage%%',

    'aps-update.queueDownload' => 'Descargando %%packageName%%...',
    'aps-update.errorDownload' => 'Error al descargar %%packageName%%:',
    'aps-update.queueInstall' => 'Actualizando una instalación de %%name%% para %%domainName%%...',
    'aps-update.doneInstall' => 'La instalación de %%name%% para %%domainName%% se ha actualizado correctamente.',
    'aps-update.errorInstall' => 'Error al actualizar una instalación de %%name%% para %%domainName%%:',
    'aps-update.queueInstallMulti' => 'Actualizando %%instances%% instalaciones de %%name%%...',
    'aps-update.doneInstallMulti' => '%%successes%% instalaciones de %%name%% se actualizaron correctamente.',
    'aps-update.errorInstallMulti' => 'Error al actualizar %%failures%% instalaciones de %%name%%:',
    'aps-update.incorrectUpdateInformation' => 'La información acerca de la actualización no es correcta.',

    'common.hideCompletedTasks' => 'Ocultar completadas',
    'common.progressBarHide' => 'Ocultar',
    'common.progressBarShow' => 'Mostrar',
    'common.close' => 'Cerrar',
    'common.refresh' => 'Actualizar la página',
    'common.taskInProgress' => '%%count%% tarea(s) en curso...',
    'common.percentCompleted' => '%%percent%%% completado',
    'common.allTasksCompleted' => 'Las %%num%% tareas se han completado correctamente.',
    'common.minimize' => 'Minimizar',
    'common.statusDone' => 'Completado',
    'common.statusError' => 'Error',
    'common.statusNotStarted' => 'En cola',
    'common.statusCanceled' => 'Cancelada',
    'common.progressDialogLink' => 'progreso detallado',

    'database-check.queue' => 'Comprobando las tablas de la base de datos %%database%%...',
    'database-check.done' => 'La base de datos %%database%% no presenta ningún error.',
    'database-check.error' => 'No se puedo comprobar la existencia de errores en la base de datos %%database%%.',
    'database-check.done-with-errors' => "La base de datos %%database%% presenta %%number%% problemas. \n %%link%%",
    'database-check.info-link-title' => 'Ver detalles y resolver',

    'database-download.queue' => 'Preparando un volcado de %%database%% para su exportación...',
    'database-download.done' => 'El volcado de %%database%% está listo. Ahora ya puede %%downloadLink%%.',
    'database-download.downloadLink' => 'descargar',
    'database-download.error' => 'No se pudo exportar un volcado de %%database%%:',

    'database-repair.queue' => 'Reparando las tablas de la base de datos %%database%%...',
    'database-repair.done' => 'La base de datos %%database%% no presenta ningún error.',
    'database-repair.error' => 'No se pudo reparar la base de datos %%database%%.',
    'database-repair.done-with-errors' => "La base de datos %%database%% presenta %%number%% problemas. \n %%link%%",
    'database-repair.info-link-title' => 'Ver detalles',

    'database-upload.queue' => 'Importando un volcado de %%database%%...',
    'database-upload.done' => 'El volcado de %%database%% ha sido importado.',
    'database-upload.error' => 'No se pudo importar el volcado de %%database%%:',
    'database-upload.done-with-errors' => "El volcado de %%database%% ha sido importado con errores.",
    'database-upload.orphanedUsersSuccess' => 'La base de datos %%database%% se importó correctamente. De todos modos, algunos usuarios han devenido huérfanos (no tienen asociado ningún inicio de sesión en el servidor de bases de datos). Para poder acceder a sus bases de datos, asígneles inicios de sesión. %%viewUsersLink%%.',
    'database-upload.orphanedUsersError' => 'Los siguientes usuarios han devenido huérfanos (no tienen asociado ningún inicio de sesión en el servidor de bases de datos): %%orphanedUsers%%.',
    'database-upload.orphanedUsersLink' => 'Ver usuarios',

    'domain-app-scan.queue' => 'Buscando aplicaciones...',
    'domain-app-scan.done' => 'La búsqueda de aplicaciones se ha completado.',
    'domain-app-scan.error' => 'La búsqueda de aplicaciones se ha completado con errores.',

    'domain-move.queue' => 'Moviendo %%domainName%% a %%webspaceName%%',
    'domain-move.done' => '%%domainName%% se movió a %%webspaceName%%',
    'domain-move.error' => '%%domainName%% no se movió a %%webspaceName%%',

    'domain-split.queue' => 'Transfiriendo %%domainName%% a la nueva suscripción',
    'domain-split.done' => '%%domainName%% se transfirió a la nueva suscripción',
    'domain-split.error' => '%%domainName%% no se transfirió a la nueva suscripción',

    'file-manager-import-file.done' => 'El archivo %%fileName%% ha sido importado a la carpeta <a href="%%listUrl%%">%%fileDir%%</a>.',
    'file-manager-import-file.error' => 'No ha sido posible importar el archivo %%fileName%%: %%errorMessage%%.<br><a href="%%url%%">Descargar a mi equipo</a>',
    'file-manager-import-file.queue' => 'Importando el archivo %%fileName%% desde %%host%%.',
    'file-manager-import-file.progress' => 'Importando el archivo %%fileName%% desde %%host%% (%%value%% MB).',
    'file-manager-import-file.errors.auth' => 'Se ha producido un error de autenticación. Compruebe que ha indicado las credenciales correctamente',
    'file-manager-import-file.errors.resolve' => 'No pudo resolverse el nombre de host %%host%%. Compruebe que ha indicado la URL correctamente',
    'file-manager-import-file.errors.connect' => 'No pudo conectarse al servidor %%host%%. Compruebe que ha indicado la URL correctamente',
    'file-manager-import-file.errors.notFound' => 'No se ha encontrado el archivo remoto o no es posible acceder al mismo. mpruebe que ha indicado la URL correctamente y que es posible acceder al archivo',
    'file-manager-import-file.errors.maxSize' => 'Se ha excedido el límite de espacio en disco o el espacio libre %%diskSpaceLimit%%',
    'file-manager-import-file.errors.lowSpeedTime' => 'No ha sido posible importar el archivo porque la velocidad de transferencia es demasiado lenta: se transfirieron menos de %%lowSpeedLimit%% bytes durante los últimos %%lowSpeedTime%% segundos. Es posible que el sitio web donde se aloja el archivo esté experimentando mucho tráfico en este momento. Vuelva a importar el archivo en unos minutos',
    'file-manager-import-file.errors.certificate' => 'No pudo importarse el archivo porque el certificado SSL/TLS del servidor %%host%% no es de confianza. Compruebe que el sitio web donde se aloja el archivo está protegido con un certificado de confianza',
    'file-manager-import-file.errors.redirects' => 'Se ha excedido el número máximo de redireccionamientos (%%maxRedirects%%). Compruebe que el servidor %%host%% funciona correctamente',

    'force-log-rotation.queue' => 'Aplicando configuración de rotación global de registros',
    'force-log-rotation.done' => 'La configuración de rotación global de registros ha sido aplicada.',
    'force-log-rotation.error' => 'La aplicación de la rotación global de registros finalizó con errores',
    'force-log-rotation.systemLogRotationError' => 'Registros del sistema: %%error%%',
    'force-log-rotation.planLogRotationError' => 'Plan de servicio %%name%%: %%error%%',
    'force-log-rotation.domainLogRotationError' => 'Dominio %%name%%: %%error%%',

    'initial-setup.queue' => 'Inicializando Plesk...',
    'initial-setup.done' => 'Plesk ha sido inicializado.',
    'initial-setup.doneWithErrors' => 'Se ha producido un error mientras se inicializaba Plesk.',
    'initial-setup.error' => 'Error de inicialización de Plesk.',
    'initial-setup.step.setupPanel' => 'Configurando Plesk Panel',
    'initial-setup.step.requestLicense' => 'Solicitando la licencia',
    'initial-setup.step.configureServer' => 'Configurando el servidor web',
    'initial-setup.step.secureServer' => 'Protegiendo el servidor',

    'ip-update.queue' => 'Actualizando dirección IP',
    'ip-update.done' => 'La dirección IP ha sido actualizada.',
    'ip-update.error' => 'Actualización de la dirección IP finalizada con errores',
    'ip-update.updating' => 'Actualizando dirección IP',
    'ip-update.updatingWebServer' => 'Actualizando dirección IP: actualizando el servidor web',
    'ip-update.updatingFtpServer' => 'Actualizando dirección IP: actualizando el servidor FTP',
    'ip-update.updatingDnsZones' => 'Actualizando dirección IP: actualizando zonas DNS',
    'ip-update.restartingDnsService' => 'Actualizando dirección IP: reiniciando el servidor DNS',

    'ip-reload-public.queue' => 'Actualizando las direcciones IP públicas usando metadatos cloud',
    'ip-reload-public.done' => 'Las direcciones IP públicas han sido actualizadas',

    'logrotate_anonymize_ips.queue' => 'Anonimizar direcciones IP en los registros',
    'logrotate_anonymize_ips.queueRevert' => 'Desanonimizar direcciones IP en los registros',
    'logrotate_anonymize_ips.done' => 'Las direcciones IP han sido anonimizadas.',
    'logrotate_anonymize_ips.doneRevert' => 'Las direcciones IP han sido desanonimizadas.',
    'logrotate_anonymize_ips.error' => 'Anonimización de las direcciones IP finalizada con errores',
    'logrotate_anonymize_ips.errorRevert' => 'Desanonimización de las direcciones IP finalizada con errores',

    'panel-components-install.queue' => 'Instalando los componentes seleccionados',
    'panel-components-install.done' => 'Los componentes seleccionados se han instalado correctamente.',
    'panel-components-install.error' => 'No se han podido instalar los componentes. La notificación con la descripción del error ha sido enviada a su dirección de email.',

    'panel-update.queue' => 'Plesk está instalando actualizaciones. Esta operación puede tardar un poco. %%warning%%',
    'panel-update.warning' => 'No realice ninguna operación de administración en Plesk hasta que se haya completado la actualización.',
    'panel-update.done' => 'Plesk ha sido actualizado. Obtenga más información en %%changelog%%.',
    'panel-update.changelog' => 'Registro de cambios de Plesk',
    'panel-update.error' => 'Plesk no pudo actualizarse. %%errorDetails%%',
    'panel-update.support' => 'Puede enviar el registro de actualización al equipo de soporte de Plesk para que solucionemos esta incidencia. %%failedLog%% Copie el registro a su equipo antes de cerrar este mensaje.',
    'panel-update.failedLog' => 'Vea el registro de actualización del %%date%%.',

    'pum-update-packages.queue' => 'Actualizando %%count%% paquete(s)...',
    'pum-update-packages.done' => '%%count%% paquetes se actualizaron correctamente.',
    'pum-update-packages.error' => 'Error de actualización.',

    'scheduler-run-task.queue' => 'Ejecutando la tarea "%%task%%"...',
    'scheduler-run-task.done' => 'La tarea "%%task%%" se completó correctamente en %%seconds%% segundos.',
    'scheduler-run-task.error' => 'La tarea "%%task%%" se completó con errores en %%seconds%% segundos.',
    'scheduler-run-task.popupSeeDetails' => 'Ver detalles',
    'scheduler-run-task.popupTitle' => 'Ejecutar tarea programada',
    'scheduler-run-task.popupDone' => 'La tarea "%%task%%" se completó correctamente en %%seconds%% segundos. Su salida es:',
    'scheduler-run-task.popupError' => 'La tarea "%%task%%" se completó con errores en %%seconds%% segundos. Su salida es:',
    'scheduler-run-task.popupClose' => 'Cerrar',

    'sdk.queue' => 'Tarea "%%name%%" en curso...',
    'sdk.error' => 'La tarea "%%name%%" ha experimentado errores.',
    'sdk.done' => 'La tarea "%%name%%" ha sido finalizada.',
    'sdk.canceled' => 'La tarea "%%name%%" ha sido cancelada.',

    'sync-php-settings.queue' => 'Aplicando la configuración global de PHP %%version%% a los dominios',
    'sync-php-settings.done' => 'La configuración global de PHP %%version%% se aplicó correctamente a los dominios',
    'sync-php-settings.error' => 'Se produjo un error al aplicar la configuración global de PHP %%version%% a los dominios',

    'sync-service-plan.queue' => 'Sincronizando el plan de servicio %%name%% con las suscripciones',
    'sync-service-plan.done' => 'El plan de servicio %%name%% se sincronizó correctamente con las suscripciones',
    'sync-service-plan.doneWithErrors' => 'La sincronización del plan de servicio %%name%% ha sido completada. Algunas suscripciones no se sincronizaron con el plan',
    'sync-service-plan.error' => 'Se produjo un error mientras se sincronizaba el plan de servicio %%name%% con las suscripciones',

    'domain-create.queue' => 'Creando el dominio %%domainName%%',
    'domain-create.done' => 'Dominio %%domainName%% creado',
    'domain-create.error' => 'Error en la creación del dominio %%domainName%%',
    'domain-create.warning' => 'Dominio %%domainName%% creado con algunos problemas:<br> %%problems%%',
    'domain-create.refreshUrl' => 'Ver',
    'domain-create.steps.createCustomer' => 'Creando el cliente',
    'domain-create.steps.createSubscription' => 'Creando una suscripción',
    'domain-create.steps.createDomain' => 'Añadiendo un dominio',
    'domain-create.steps.configureDns' => 'Configurando la zona DNS',
    'domain-create.steps.createHosting' => 'Creando hosting físico',
    'domain-create.steps.configurePhp' => 'Configurando PHP',
    'domain-create.steps.configureMail' => 'Configurando el correo',

    'domain-delete.queue' => 'Eliminación de procesamiento de dominios',
    'domain-delete.done' => 'Dominios eliminados',
    'domain-delete.error' => 'Error de eliminación de dominios',
    'domain-delete.step.domains' => 'Eliminando dominios…',

    'domain-resolve-checking.warning' => 'El dominio %%domainName%% resuelve problemas detectados: <br> %%errors%%',

    'customer-create.queue' => 'Procesando la creación del cliente %%customerName%%',
    'customer-create.done' => 'Cliente %%customerName%% creado',
    'customer-create.error' => 'Error de creación del cliente %%customerName%%',
    'customer-create.warning' => 'Cliente %%customerName%% se ha creado con algunos problemas:<br> %%problems%%',
    'customer-create.warnings.notSynchronizedLink' => 'Puede probar a sincronizarlo de forma manual.',

    'customer-delete.queue' => 'Eliminación de procesamiento de clientes',
    'customer-delete.done' => 'Clientes eliminados',
    'customer-delete.error' => 'Error de eliminación de clientes',

    'reseller-delete.queue' => 'Eliminación de procesamiento de revendedores',
    'reseller-delete.done' => 'Revendedores eliminados',
    'reseller-delete.error' => 'Error de eliminación de revendedores',

    'subscription-create.queue' => 'Procesando la creación de la suscripción %%subscriptionName%%',
    'subscription-create.done' => 'Suscripción %%subscriptionName%% creada',
    'subscription-create.error' => 'Error de creación de la suscripción %%subscriptionName%%',
    'subscription-create.warning' => 'Suscripción %%subscriptionName%% creada con algunos problemas:<br> %%problems%%',
    'subscription-create.warnings.notSynchronizedLink' => 'Puede probar a sincronizarlo de forma manual.',

    'subscription-delete.queue' => 'Eliminación de procesamiento de suscripciones',
    'subscription-delete.done' => 'Suscripciones eliminadas',
    'subscription-delete.error' => 'Error de eliminación de suscripciones',

    'websites-diagnostic.queue' => 'Diagnóstico de sitios web en curso',
    'websites-diagnostic.done' => 'Diagnóstico de sitios web completado',
    'websites-diagnostic.error' => 'Diagnóstico de sitios web completado con errores',

    'install-php-extension.queue' => 'Instalando el paquete %%extensionName%% en el controlador PHP %%phpHandlerName%%',
    'install-php-extension.done' => 'El paquete %%extensionName%% se instaló en el controlador PHP %%phpHandlerName%%',
    'install-php-extension.error' => 'No fue posible instalar el paquete %%extensionName%% en el controlador PHP %%phpHandlerName%%',
    'install-php-extension.step.validate' => 'Comprobando requisitos',
    'install-php-extension.step.dependencies' => 'Resolviendo dependencias',
    'install-php-extension.step.process' => 'Instalando paquete',
    'install-php-extension.step.enable' => 'Activando extensión',
    'install-php-extension.step.sync' => 'Sincronizando sitios',
    'install-php-extension.errorReason' => 'PECL proporciona la lista de paquetes disponibles. Las causas más comunes de los errores de instalación son los siguientes:',
    'install-php-extension.errorReasonDependencies' => '- El paquete presenta dependencias externas sobre otras librerías.',
    'install-php-extension.errorReasonRequirements' => '- El paquete no cumple con los requisitos de instalación (SO, versión de PHP, etc.).',
    'install-php-extension.errorReasonOutdated' => '- El paquete es obsoleto.',
    'install-php-extension.errorOutput' => 'Para identificar el motivo del error de instalación, examine la salida de la utilidad.',

    'uninstall-php-extension.queue' => 'Desinstalando el paquete %%extensionName%% del controlador PHP %%phpHandlerName%%',
    'uninstall-php-extension.done' => 'El paquete %%extensionName%% se desinstaló del controlador PHP %%phpHandlerName%%',
    'uninstall-php-extension.error' => 'No fue posible desinstalar el paquete %%extensionName%% del controlador PHP %%phpHandlerName%%',
    'uninstall-php-extension.step.validate' => 'Comprobando requisitos',
    'uninstall-php-extension.step.process' => 'Desinstalando paquete',
    'uninstall-php-extension.step.sync' => 'Sincronizando sitios web',
];