<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
$messages = [
    'access-network.subnetOrIpAddressLabel' => '서브넷 또는 IP 주소',
    'access-network.subnetOrIpAddressHint' => '예, 2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'admin.announcement-settings.announcementLegend' => '뉴스레터',
    'admin.announcement-settings.getConsentLoading' => '뉴스레터 정보를 가져오는 중...',
    'admin.announcement-settings.getConsentWarning' => '구독 상태를 가져오지 못했습니다.',
    'admin.announcement-settings.sendAnnounceConsent' => 'Plesk의 뉴스레터를 수신하고 싶습니다. 보안과 관련된 기술적이고 일반적인 제품 정보가 포함될 수 있습니다. 본인은 Plesk가 뉴스레터를 직접 또는 제3자 서비스를 통해 본인에게 전송할 때 적용되는 데이터 보호법에 따라 외국에서의 처리 등 내 개인 데이터(이메일)를 수집하고, 처리하고, 이용하는 데 동의합니다. 이 확인란을 취소하면 동의가 철회되고 Plesk에서 이메일을 나에게 전송하지 않으며, 내 개인 데이터를 시스템에서 영구적으로 제거합니다.',
    'admin.announcement-settings.sendAnnouncePersonalizedConsent' => '예, 본인은 맞춤형 Plesk 뉴스레터를 받아 보고 싶습니다. Plesk International GmbH 및 그 계열사는 본인이 제공하는 정보를 %%privacyPolicy%%에 따라 뉴스레터를 제공하는 목적으로 저장하고 처리할 수 있습니다. Plesk는 메시지와 제품을 본인에게 맞춤형으로 제공하기 위해 이용 및 행동 정보 등 프로파일링을 위한 추가 정보도 이용할 수 있습니다. 본인은 언제든지 메일링 리스트에서 구독을 취소할 수 있습니다.',
    'admin.announcement-settings.privacyPolicy' => 'Plesk 개인정보 보호정책',
    'admin.announcement-settings.noConsent' => 'Plesk 뉴스레터의 구독을 취소합니다.',
    'admin.announcement-settings.reportConsentError' => 'Plesk에서 정보를 가져오는 설정을 저장하지 못했습니다. %%error%%.',
    'admin.announcement-settings.profileUpdateError' => '죄송합니다, 현재 귀하의 프로필을 업데이트할 수 없습니다. 나중에 다시 시도하십시오.',
    'admin.announcement-settings.invalidConsentType' => "알 수 없는 콘텐츠 유형: '%%type%%'",
    'admin.announcement-settings.retry' => '다시 시도',
    'admin.announcement-settings.consentGivenInfo' => '일반 Plesk 뉴스레터가 마음에 드셨기를 바랍니다. 이제 귀하의 니즈에 맞는 유용한 정보와 간편한 팁이 포함된 맞춤형 뉴스레터를 제공할 수 있습니다. 맞춤형 Plesk 뉴스레터를 받아 보시려면 아래의 첫 번째 항목을 선택하고 확인을 클릭하십시오.',
    'admin.announcement-settings.consentNotGivenInfo' => '고객 님은 일반 뉴스레터를 구독하고 있지 않는 것으로 판단됩니다. 귀하의 니즈에 맞는 유용한 정보와 팁이 포함된 맞춤형 뉴스레터를 제공할 수 있습니다.',

    'admin.personal-info.title' => '관리자 프로필 편집',
    'admin.personal-info.pleskSettingsSectionLegend' => 'Plesk 상세정보',
    'admin.personal-info.settingsSectionLegend' => '설정',

    'admin-alias.login' => '사용자 이름',
    'admin-alias.password' => '암호',
    'admin-alias.passwordConfirmation' => '암호 확인',
    'admin-alias.email' => '이메일',
    'admin-alias.contact' => '연락처 이름',
    'admin-alias.comments' => '주석',
    'admin-alias.emptyLogin' => '사용자 이름을 입력하십시오.',
    'admin-alias.loginTooLong' => '사용자 이름 길이가 20자를 초과합니다.',
    'admin-alias.emptyEmail' => '이메일 주소를 입력하십시오.',
    'admin-alias.emptyContactName' => '연락처 이름을 입력하십시오.',
    'admin-alias.contactNameTooLong' => '연락처 이름 길이가 255개 기호를 초과합니다.',
    'admin-alias.emptyPassword' => '암호를 입력하십시오.',
    'admin-alias.commentsTooLong' => '주석 길이가 255개 기호를 초과합니다.',
    'admin-alias.emailActivation' => '이메일로 계정 활성화',
    'admin-alias.simplePanel' => '제한 모드 활성화',
    'admin-alias.simplePanelHint' => '추가 관리자가 Plesk에서 수행할 수 있는 작업 수를 제한하려면 이 옵션을 선택하십시오. 사용할 수 있는 작업을 변경하려면 %%link%%(으)로 이동하십시오.',
    'admin-alias.simplePanelLink' => '도구 & 설정> 제한 모드 설정',
    'admin-alias.lockPowerUser' => '추가 관리자를 위해 고급 사용자 보기로 제한',
    'admin-alias.lockPowerUserHint' => '추가 Plesk 관리자를 위해 보기를 제한하는 기능입니다(고객, 대리점, 서비스 계획에 액세스 없음).',

    'admin-info.plesk-settings.multiplyLogin' => '이 계정 아래 여러 세션 허용',
    'admin-info.plesk-settings.adminLanguage' => '관리자의 인터페이스 언어',
    'admin-info.plesk-settings.password' => '암호',
    'admin-info.plesk-settings.passwordConfirmation' => '암호 확인',

    'admin-panel.form.contact-info.contactName' => '연락처 이름',
    'admin-panel.form.contact-info.emptyContactName' => '연락처 이름을 입력하십시오.',
    'admin-panel.form.contact-info.contactNameTooLong' => '연락처 이름이 너무 깁니다(최대 %max%개 기호가 허용됨).',
    'admin-panel.form.contact-info.email' => '이메일 주소',
    'admin-panel.form.contact-info.emptyEmail' => '이메일 주소를 입력하십시오.',
    'admin-panel.form.contact-info.companyName' => '회사 이름',
    'admin-panel.form.contact-info.longCompanyName' => '이 회사 이름이 너무 깁니다(최대 %max%개 기호가 허용됨).',
    'admin-panel.form.contact-info.phone' => '전화 번호',
    'admin-panel.form.contact-info.longPhone' => '이 전화 번호가 너무 깁니다(최대 %max%개 기호가 허용됨).',
    'admin-panel.form.contact-info.fax' => '팩스 번호',
    'admin-panel.form.contact-info.imNumber' => '인스턴트 메신저',
    'admin-panel.form.contact-info.longFax' => '이 팩스 번호가 너무 깁니다(최대 %max%개 기호가 허용됨).',
    'admin-panel.form.contact-info.phoneRegexNotMatch' => '잘못된 전화 번호를 지정했습니다.',
    'admin-panel.form.contact-info.faxRegexNotMatch' => '잘못된 팩스 번호입니다.',
    'admin-panel.form.contact-info.address' => '주소',
    'admin-panel.form.contact-info.longAddress' => '이 주소가 너무 깁니다(최대 %max%개 기호가 허용됨).',
    'admin-panel.form.contact-info.city' => '도시',
    'admin-panel.form.contact-info.longCity' => '이 도시 이름이 너무 깁니다.',
    'admin-panel.form.contact-info.shortCity' => '이 도시 이름이 너무 짧습니다.',
    'admin-panel.form.contact-info.state' => '시/도',
    'admin-panel.form.contact-info.postalCode' => '우편 번호',
    'admin-panel.form.contact-info.country' => '국가',
    'admin-panel.form.contact-info.additionalInfo' => '추가 정보',
    'admin-panel.form.contact-info.additionalInfoHint' => '일반 텍스트만: 모든 HTML 태그는 무시됩니다.',
    'admin-panel.form.contact-info.duplicateEmail' => '해당 이메일 주소를 가진 사용자가 시스템에 이미 있습니다.',

    'admin-panel.form.domain-info-section.domainInfoSection' => '구독',
    'admin-panel.form.domain-info-section.domainInfoSectionForCustomerHint' => '구독과 함께 제공된 웹 사이트의 속성.',
    'admin-panel.form.domain-info-section.domainInfoSectionForResellerHint' => '구독과 함께 제공된 웹 사이트의 속성.',
    'admin-panel.form.domain-info-section.domainInfoSectionOwnHint' => '구독과 함께 제공된 웹 사이트의 속성.',
    'admin-panel.form.domain-info-section.createSubscription' => '고객에 대한 구독 만들기',
    'admin-panel.form.domain-info-section.createSubscriptionHint' => '지금 호스팅 서비스 구독을 만들거나 고객의 웹 사이트를 설정하지 않으려면 이 확인란을 선택 해제합니다. 구독하지 않은 고객은 고객 패널에 로그인할 수 없습니다.',
    'admin-panel.form.domain-info-section.domainName' => '도메인 이름',
    'admin-panel.form.domain-info-section.emptyDomainName' => '도메인 이름을 입력해야 합니다.',
    'admin-panel.form.domain-info-section.shared' => '공유',
    'admin-panel.form.domain-info-section.exclusive' => '전용',
    'admin-panel.form.domain-info-section.userName' => '사용자 이름',
    'admin-panel.form.domain-info-section.userNameHint' => '구독 내에서 만들어진 웹 사이트의 파일 및 폴더를 관리하는 데 사용되는 시스템 사용자 계정.',
    'admin-panel.form.domain-info-section.emptyLogin' => '사용자 이름을 입력해야 합니다.',
    'admin-panel.form.domain-info-section.password' => '암호',
    'admin-panel.form.domain-info-section.emptyPassword' => '암호를 입력해야 합니다.',
    'admin-panel.form.domain-info-section.passwordConfirmation' => '암호 확인',
    'admin-panel.form.domain-info-section.ipv4AddressHint' => "웹 사이트의 호스팅에 이용된 IP 주소가 웹 사이트 가상 호스트의 네트워크 주소입니다.",
    'admin-panel.form.domain-info-section.ipv4Address' => 'IPv4 주소',
    'admin-panel.form.domain-info-section.ipv6AddressHint' => "웹 사이트의 호스팅에 이용된 IP 주소가 웹 사이트 가상 호스트의 네트워크 주소입니다.",
    'admin-panel.form.domain-info-section.ipv6Address' => 'IPv6 주소',
    'admin-panel.form.domain-info-section.noIpAddressHint' => '없음',
    'admin-panel.form.domain-info-section.subscriptionSettings' => '추가 구독 설정',
    'admin-panel.form.domain-info-section.credentials' => '시스템 사용자 자격 증명',
    'admin-panel.form.domain-info-section.credentialsHint' => 'FTP 및 SSH를 통해 호스팅된 파일에 엑세스하려면',
    'admin-panel.form.domain-info-section.credentialsHintWin' => 'FTP 및 RDP를 통해 호스팅된 파일에 액세스하려면',

    'admin-panel.form.login-info.userName' => '사용자 이름',
    'admin-panel.form.login-info.emptyUserName' => '사용자 이름을 입력하십시오.',
    'admin-panel.form.login-info.password' => '암호',
    'admin-panel.form.login-info.emptyPassword' => '암호를 입력하십시오.',
    'admin-panel.form.login-info.passwordConfirmation' => '암호 반복',
    'admin-panel.form.login-info.internalEmailPasswordChanged' => '비밀번호를 변경하면 내부 이메일 주소 비밀번호도 변경됩니다',
    'admin-panel.form.login-info.emailActivation' => '이메일로 계정 활성화',
    'admin-panel.form.login-info.emailActivationHint' => '생성된 계정은 사용자가 이메일에 포함된 링크로 활성화하거나 관리자가 수동으로 계정을 활성화하기 전까지 비활성 상태로 유지됩니다.',

    'admin-panel.form.subscription-info-section.subscription' => '구독',
    'admin-panel.form.subscription-info-section.servicePlan' => '서비스 플랜',
    'admin-panel.form.subscription-info-section.oldServicePlan' => '현재 서비스 플랜',
    'admin-panel.form.subscription-info-section.newServicePlan' => '새 서비스 플랜',
    'admin-panel.form.subscription-info-section.adminPlan' => '단순 플랜',
    'admin-panel.form.subscription-info-section.none' => '없음',
    'admin-panel.form.subscription-info-section.addonPlans' => '추가 기능',
    'admin-panel.form.subscription-info-section.customizeSubscription' => '플랜 연결이 변경된 후 구독 매개 변수를 사용자 지정하십시오. 이렇게 하면 동기화를 위해 구독이 잠기게 됩니다.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionOnCreateSubscription' => '구독 매개 변수를 만든 후 사용자 지정을 진행합니다.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionForCustomer' => "고객이 생성된 다음 구독 변수 사용자 정의를 진행하십시오.",
    'admin-panel.form.subscription-info-section.customizeSubscriptionForSelf' => '구독 매개 변수가 만들어진 후에 계속해서 이를 사용자 지정하십시오. 이렇게 하면 동기화를 위해 구독이 잠기게 됩니다.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionHint' => '이렇게 하면 동기화를 위해 구독이 잠깁니다.',
    'admin-panel.form.subscription-info-section.buttonOk' => '구독 추가',

    'admin-panel.form.subscription.subscriptionNotSynchronized' => '구독을 서비스 플랜과 동기화할 수 없습니다. 다음 구독 설정이 서비스 플랜과 충돌합니다. %%problems%%.',

    'app.configure.otherSettings' => '기타',
    'app.configure.passwordConfirmation' => '암호 확인',

    'app.update-settings.description' => '',
    'app.update-settings.forceUpdates' => '모든 설치 응용 프로그램에 대한 강제 업데이트',
    'app.update-settings.forceUpdatesHint' => '업데이트가 제공되는 즉시 고객의 모든 응용 프로그램이 자동으로 업데이트됩니다. 고객은 해당 응용 프로그램에 대한 자동 업데이트를 끌 수 없습니다. 경고: 업데이트는 응용 프로그램 기능에 큰 영향을 미칠 수 있으므로 이 옵션을 주의하여 사용하십시오. 예를 들어 응용 프로그램 확장자가 다른 응용 프로그램 버전에서 더 이상 작동하지 않을 수도 있습니다.',
    'app.update-settings.suggestUpdates' => '다음 옵션 "이 응용 프로그램을 자동으로 업데이트"를 기본적으로 선택',
    'app.update-settings.suggestUpdatesHint' => '새로 설치한 응용 프로그램의 경우, 응용 프로그램 설정에서 "이 응용 프로그램을 자동으로 업데이트" 옵션이 켜집니다.',

    'backup.server-settings.rotation' => '저장할 전체 백업 파일의 최대 수(예정된 백업과 수동 백업 모두 포함)',
    'backup.server-settings.rotationDescription' => '사용자는 서버 스토리지에 이 숫자만큼 전체 백업을 저장할 수 있습니다. 스토리지에 이미 있는 전체 백업 수가 제한치를 초과할 경우 가장 최근의 백업만 보관됩니다.  증분 백업은 영향을 받지 않습니다.',
    'backup.server-settings.maxProcesses' => '동시에 실행 가능한 예약된 백업 프로세스의 최대 수',
    'backup.server-settings.niceScheduled' => '우선 순위가 낮은 예약된 백업 프로세스 실행',
    'backup.server-settings.niceScheduledPriority' => '우선 순위',
    'backup.server-settings.niceScheduledPriorityDescription' => '높은 숫자일수록 낮은 우선 순위로 1에서 19 사이의 값을 입력합니다.',
    'backup.server-settings.niceScheduledIoPriority' => 'IO 우선 순위',
    'backup.server-settings.niceScheduledIoPriorityDescription' => '높은 숫자일수록 낮은 우선 순위로 0에서 7 사이의 값을 입력합니다.',
    'backup.server-settings.niceAlways' => '우선 순위가 낮은 모든 백업 프로세스 실행',
    'backup.server-settings.niceAlwaysPriority' => '우선 순위',
    'backup.server-settings.niceAlwaysPriorityDescription' => '높은 숫자일수록 낮은 우선 순위로 1에서 19 사이의 값을 입력합니다.',
    'backup.server-settings.niceAlwaysIoPriority' => 'IO 우선 순위',
    'backup.server-settings.niceAlwaysIoPriorityDescription' => '높은 숫자일수록 낮은 우선 순위로 0에서 7 사이의 값을 입력합니다.',
    'backup.server-settings.compressionLevel' => '압축 수준',
    'backup.server-settings.compressionLevelNoCompression' => '압축 안 함',
    'backup.server-settings.compressionLevelFastest' => '가장 빠름',
    'backup.server-settings.compressionLevelFast' => '고속',
    'backup.server-settings.compressionLevelNormal' => '보통',
    'backup.server-settings.compressionLevelMaximum' => '최대',
    'backup.server-settings.freeSpaceRequired' => '서버에 지정한 양의 사용 가능한 디스크 공간(MB)이 있는 경우에만 백업 시작',
    'backup.server-settings.checkBackupDiskSpace' => '서버에 충분한 여유 디스크 공간이 있는 경우에만 백업 시작',
    'backup.server-settings.mssqlNativeBackupEnabled' => '원시 MS SQL 백업 기능 사용(원격 데이터베이스의 경우, 도구 & 설정> 데이터베이스 서버에서 원격 MS SQL 서버의 백업 설정이 구성되어 있는지 확인하십시오)',
    'backup.server-settings.localFtpRestriction' => '로컬 서버에 개인 FTP 백업 스토리지 설정 허용',
    'backup.server-settings.backupSecuritySettings' => '보안 설정 백업',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailed' => '원격 저장소로 업로드할 수 없는 경우 서버 저장소에 백업 저장',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailedDescription' => '원격 저장소로 업로드할 수 없는 경우 원격 저장소에 대한 수동 및 예약된 백업은 로컬 서버 저장소에 저장됩니다. 사용자는 서버 저장소에 백업을 저장할 수 있는 권한이 있어야 합니다.',
    'backup.server-settings.AllowScheduleHourly' => '고객 및 리셀러 계정의 매시간 백업 예약 허용',

    'change-current-subscription.hint' => '여기서 구독과 서비스 플랜 간 연결을 변경합니다. 새 서비스 플랜으로 \'없음\'을 선택하면 구독과 서비스 플랜 간 연결이 해제되고 구독이 \'사용자 지정\'이 됩니다.',
    'change-current-subscription.subscriptionNotSynchronized' => '구독을 서비스 플랜과 동기화할 수 없습니다. 다음 구독 설정이 서비스 플랜과 충돌합니다. %%problems%%.',

    'change-password.oldPassword' => '이전 암호',
    'change-password.password' => '새 암호',
    'change-password.passwordConfirmation' => '암호 확인',
    'change-password.oldPasswordIsIncorrect' => '이전 암호가 잘못되었습니다. 다시 시도하십시오.',
    'change-password.unableToFindAdditionalAdminAccount' => '추가 관리자 계정을 찾을 수 없습니다.',
    'change-password.warningAboutAdminPasswordSyntax' => "암호는 길이가 %%min%% - %%max%%자여야 하며 사용자 이름을 포함할 수 없습니다.\n암호에 인용 부호, 공백 및 자국 문자를 사용하지 마십시오.",
    'change-password.warningAboutWinAdminPasswordSyntax' => "암호에 인용 부호, 공백, 세미콜론 및 자국 문자를 사용하지 마십시오.\n암호는 길이가 %%min%% - %%max%%자여야 하며 사용자 이름을 포함할 수 없습니다.",

    'change-reseller-oversell-policy.oversellPolicy' => '초과 판매 정책',
    'change-reseller-oversell-policy.oversellPolicyAllowed' => '초과 판매가 허용됩니다.',
    'change-reseller-oversell-policy.oversellPolicyAllowedHint' => '초과 판매를 통해 리셀러는 플랜에 의해 자신에게 할당된 리소스보다 많은 리소스를 판매할 수 있습니다. 초과 판매가 허용된 경우, 리셀러는 초기 리소스 할당 대신 실제 리소스 사용에 따른 관리를 받습니다.',
    'change-reseller-oversell-policy.oversellPolicyNotAllowed' => '초과 판매가 허용되지 않습니다.',
    'change-reseller-oversell-policy.oversellPolicyNotAllowedHint' => '초과 판매가 허용되지 않는 경우, 리셀러는 실제로 이러한 리소스의 사용량에 관계 없이 처음에 플랜에 의해 자신에게 할당된 리소스만큼만 판매할 수 있습니다.',

    'change-reseller-subscription.hint' => '여기서 리셀러 구독과 서비스 플랜 간 연결을 변경합니다. 새 서비스 플랜으로 \'없음\'을 선택하면 구독과 서비스 플랜 간 연결이 해제되고 구독이 \'사용자 지정\'이 됩니다.',
    'change-reseller-subscription.subscriptionNotSynchronized' => '구독을 서비스 플랜과 동기화할 수 없습니다. 다음 구독 설정이 서비스 플랜과 충돌합니다. %%problems%%.',
    'change-reseller-subscription.servicePlan' => '새 플랜',
    'change-reseller-subscription.oldSubscription' => '현재 플랜',
    'change-reseller-subscription.none' => '없음',
    'change-reseller-subscription.infoSubscriptionChanged' => '구독과 서비스 플랜 간 연결이 업데이트되었습니다.',
    'change-reseller-subscription.customizeSubscription' => '서비스 플랜과의 연결이 업데이트된 후 구독 매개 변수를 사용자 지정하십시오. 이렇게 하면 동기화를 위해 구독이 잠기게 됩니다.',

    'change-subscription.hint' => '여기서 선택한 구독과 서비스 플랜 간 연결을 변경합니다.',
    'change-subscription.selectPlanLegend' => '서비스 플랜',
    'change-subscription.selectPlanDescription' => '다른 서비스 플랜으로 전환하려면 목록에서 새 플랜을 선택합니다. \'없음\'을 선택하면 구독과 서비스 플랜 간 연결이 해제되고 구독이 \'사용자 지정\'이 됩니다.',
    'change-subscription.servicePlan' => '새 서비스 플랜',
    'change-subscription.selectAddonPlansLegend' => '추가 기능 플랜',
    'change-subscription.selectAddonPlansDescription' => '추가 기능 플랜을 추가하거나 제거합니다.',
    'change-subscription.noChange' => '변경 사항 없음',
    'change-subscription.none' => '없음',
    'change-subscription.add' => '추가',
    'change-subscription.del' => '제거',
    'change-subscription.separator' => '-------',

    'control-panel-access.network.subnetOrIpAddressLabel' => '서브넷 또는 IP 주소',
    'control-panel-access.network.subnetOrIpAddressHint' => '예, 2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'control-panel-access.settings.accessPolicyLabel' => '관리자 권한으로 Plesk 접속',
    'control-panel-access.settings.policyAllow' => '목록의 네트워크를 제외하고 허용됨.',
    'control-panel-access.settings.policyDeny' => '나열되지 않은 네트워크로부터 거부됨.',

    'create-subscription.title' => '구독 추가',
    'create-subscription.titleOwn' => '자체 구독 추가',
    'create-subscription.poolIsEmpty' => 'Plesk에 공유된 IP 주소와 무료 전용 IP 주소가 없기 때문에 구독을 만들 수 없습니다.',
    'create-subscription.infoNewSubscriptionCreated' => '구독 %%name%%이(가) 만들어졌습니다.',
    'create-subscription.createBeforeAppInstall' => '응용 프로그램을 설치할 구독이 있어야 합니다.',

    'customer.hint' => '여기서 새 고객을 호스팅 서비스에 등록합니다. 이러한 등록을 통해 Plesk에서 고객 계정을 만들고 호스팅 플랜 중 하나와 선택적으로 추가 기능에 대한 구독을 만듭니다. 또한 구독은 어떤 플랜에도 연결되지 않은 리소스 및 서비스의 완벽한 사용자 지정 집합을 제공할 수 있습니다. 이를 위해서는 서비스 플랜 옆의 \'없음\'을 선택합니다.',
    'customer.contactInfoSection' => '연락처 정보',
    'customer.additionalInfoSection' => '추가 고객 정보',
    'customer.accessToPanelSection' => 'Plesk에 액세스',
    'customer.contactInfoSectionHint' => '고객 연락처 정보를 입력하십시오',
    'customer.accessToPanelSectionHint' => '고객이 고객 패널에 액세스하는 데 사용할 자격 증명.',
    'customer.unableCreateSubscription' => '구독을 만들 수 없습니다. %%reason%%',
    'customer.poolIsEmpty' => 'IP 풀이 비어 있습니다.',
    'customer.buttonOk' => '고객 추가',

    'database-settings.dbPrefixRadio' => '데이터베이스 이름 시작 부분에 접두사와 밑줄을 추가합니다.',
    'database-settings.dbPrefixNone' => '없음',
    'database-settings.dbPrefixUsername' => '사용자 이름',
    'database-settings.dbPrefixExternalId' => '구독 외부 ID',
    'database-settings.dbPrefixCustom' => '사용자 지정 접두사',
    'database-settings.dbUserPrefixRadio' => '데이터베이스 사용자 이름 시작 부분에 접두사와 밑줄을 추가합니다.',
    'database-settings.dbUserPrefixHint' => '데이터베이스 사용자 이름은 <prefix>_<database_user_name>과(와) 같은 형태입니다. 사용자 이름 길이에 대한 데이터베이스 제한으로 인해 <prefix>은(는) 축약될 수 있습니다.',
    'database-settings.grantAlterDatabase' => '모든 Microsoft SQL Server 데이터베이스 사용자에게 ALTER DATABASE 권한 부여',
    'database-settings.grantAlterDatabaseHint' => '신규 및 기존 사용자에게 이 권한이 부여됩니다.',
    'database-settings.enableBackupOperator' => '모든 Microsoft SQL Server 데이터베이스 사용자에 대한 db_backupoperator 역할 멤버 자격 활성화',
    'database-settings.enableBackupOperatorHint' => '신규 및 기존 사용자는 이 역할의 구성원이 됩니다.',
    'database-settings.aclRadio' => 'MySQL 데이터베이스 사용자의 원격 액세스에 대한 기본 설정',
    'database-settings.aclLocalhost' => '로컬 연결만 허용',
    'database-settings.aclAny' => '모든 호스트로부터 원격 연결 허용',
    'database-settings.aclCustom' => '다음으로부터 원격 연결 허용',
    'database-settings.aclDescription' => '이 설정은 사용자의 권한만 수정합니다. 로컬 MySQL 서버로의 원격 액세스를 활성화하려면 %%serverLink%%에서 해당 옵션을 선택하십시오',
    'database-settings.aclDescriptionLink' => '로컬 MySQL 설정',
    'database-settings.example' => "예:",
    'database-settings.aclExampleDescription' => "지정된 호스트는 이 사용자를 대신하여 데이터베이스에 액세스가 허용되었습니다.",
    'database-settings.dbPrefixAlphaNumeric' => '접두사 값은 영숫자 및 밑줄 기호만 포함할 수 있습니다.',

    'dns.add-acl-record.description' => 'DNS 영역의 사본을 수신할 수 있도록 DNS 서버의 IP 주소를 추가합니다.',
    'dns.add-acl-record.ipAddress' => 'IP 주소',
    'dns.add-acl-record.ipAddressWithMask' => 'IP 주소/마스크',

    'dns.settings.recursion' => '재귀 DNS 쿼리',
    'dns.settings.recursionOn' => '모든 요청에 대해 허용',
    'dns.settings.recursionLocal' => '로컬 요청에 대해서만 허용',
    'dns.settings.recursionLocalnets' => '로컬 네트워크 요청만 허용',
    'dns.settings.recursionOff' => '모든 요청 거부',
    'dns.settings.customConfiguration' => '추가 DNS 설정',
    'dns.settings.customConfigurationPlaceholder' => '여기에서 지정하는 설정은 서버 전체의 설정보다 우선합니다.',
    'dns.settings.customConfigurationHint' => '특정 설정을 찾을 수 없으면 named.conf. 구문을 사용하여 위의 필드에 추가하십시오.',
    'dns.settings.customConfigurationExample' => '예를 들어 DNS 서버의 호스트 이름을 숨기려면 다음 줄을 추가합니다. ',
    'dns.settings.restoreDefaultButton' => '기본 설정 사용',

    'dns.template.synchronize-done' => 'DNS 영역 템플릿이 적용되었습니다.',
    'dns.template.synchronize-error' => 'DNS 영역 템플릿이 일부 DNS 영역에 적용되지 않았습니다.',
    'dns.template.synchronize-progress' => 'DNS 영역 템플릿을 적용하는 중입니다.',

    'domain-restriction.name' => '도메인 이름',
    'domain-restriction.nameDescription' => '별표 기호(*)를 사용하여 와일드카드 패턴을 지정할 수 있습니다. 예: *.example.com',
    'domain-restriction.domainAlreadyExists' => '지정된 도메인 이름이 이미 목록에 있습니다.',

    'event-handler.eventLabel' => '이벤트',
    'event-handler.priorityLabel' => '우선 순위',
    'event-handler.userLabel' => '사용자',
    'event-handler.commandLabel' => '명령',
    'event-handler.commandHint' => '최고의 결과를 얻으려면 \'command\' 필드에 스크립트 파일의 전체 경로를 입력하십시오. 시스템 명령을 입력하면 작동하지 않을 수 있으므로 권장하지 않습니다. 예를 들어 출력 리디렉션 연산자  /&gt; 또는 &lt;이(가) 포함된 명령은 작동하지 않습니다.',
    'event-handler.priorityHighestText' => '가장 높음',
    'event-handler.priorityHighText' => '높음',
    'event-handler.priorityNormalText' => '보통',
    'event-handler.priorityLowText' => '낮음',
    'event-handler.priorityLowestText' => '가장 낮음',
    'event-handler.priorityCustomText' => '사용자 지정',
    'event-handler.priorityHighestOption' => '가장 높음(%%value%%)',
    'event-handler.priorityHighOption' => '높음(%%value%%)',
    'event-handler.priorityNormalOption' => '보통(%%value%%)',
    'event-handler.priorityLowOption' => '낮음(%%value%%)',
    'event-handler.priorityLowestOption' => '가장 낮음(%%value%%)',

    'extension.upload.fileUpload' => '확장 프로그램에 대한 파일 경로',

    'external-webmail.hint' => 'Plesk에서 추가 웹 메일을 등록하면 고객에게 제공됩니다. 추가된 웹 메일은 호스팅 플랜 및 구독의 \'Mail\' 속성에서 옵션으로 나타납니다. 웹 메일 이름이 웹 메일 옵션 목록에 표시되며, 고객 패널에서 사서함 옆의 웹 메일 아이콘을 클릭하면 URL이 열립니다.',
    'external-webmail.name' => '웹 메일 서비스 이름',
    'external-webmail.url' => '웹 메일 서비스 URL',
    'external-webmail.enabled' => '사용 가능함',

    'ftp-settings.generalSection' => '일반',
    'ftp-settings.portRange' => '수동 FTP 모드 연결을 위한 포트 또는 포트 범위',
    'ftp-settings.hintPortRange' => '(기본값: %%defaultPortRange%%)',

    'health.upload.hint' => '상태 서버 모니터의 구성을 업로드합니다. 이러한 구성은 업로드되는 즉시 적용됩니다.',
    'health.upload.selectFile' => '구성 파일',

    'install-local-package.selectUploadType' => '다음 중 한 가지 선택:',
    'install-local-package.uploadAsFile' => 'APS 패키지 업로드',
    'install-local-package.downloadFromCatalog' => '응용 프로그램 카탈로그에서 응용 프로그램 선택',
    'install-local-package.formInfo' => "새 응용 프로그램을 업로드하여 사용 가능한 응용 프로그램의 목록을 확장하거나, 응용 프로그램 카탈로그에서 추가 구성할 응용 프로그램을 추가합니다.",
    'install-local-package.invalidFileExtension' => '업로드된 응용 프로그램은 .zip 확장명이 있는 ZIP 아카이브여야 합니다.',
    'install-local-package.packagesNotSelected' => '패키지를 선택하지 않았습니다.',
    'install-local-package.visible' => '고객이 사용할 수 있도록 함',
    'install-local-package.isCommercial' => '이 앱은 상업용이며 라이센스 키 구매가 필요합니다.',
    'install-local-package.visibleDescription' => '응용 프로그램을 고객이 설치할 수 있도록 합니다.',

    'ip-address.addTitle' => 'IP 주소 추가',
    'ip-address.editTitle' => '%%interface%% 인터페이스의 IP 주소 %%address%%',
    'ip-address.generalSection' => '일반',
    'ip-address.interface' => '인터페이스',
    'ip-address.addressAndSubnetPrefixLength' => 'IP 주소 및 서브넷 마스크',
    'ip-address.addressHintIPv4' => '예: 123.123.123.123/16, 123.123.123.123/255.255.0.0',
    'ip-address.addressHintIPv6' => '예: 2002:7b7b:7b7b::1/64, 123.123.123.123/16, 123.123.123.123/255.255.0.0',
    'ip-address.publicIp' => '공용 IP 주소',
    'ip-address.hintPublicIp' => 'Plesk 서버가 NAT 뒤에 있다면 공용 IP 주소를 사용할 수 있습니다.',
    'ip-address.distributionType' => 'IP 주소가 다음으로 배포됨',
    'ip-address.distributionTypeShared' => '공유',
    'ip-address.distributionTypeExclusive' => '전용',
    'ip-address.certificate' => 'SSL/TLS 인증서',
    'ip-address.defaultSite' => '기본 사이트',
    'ip-address.ftpOverSslNotSupportedByServer' => '설치된 FTP 서버가 FTPS를 지원하지 않습니다.',
    'ip-address.ftpOverSslIpv6NotSupportedByServer' => '설치된 FTP 서버가 IPv6 주소를 지원하지 않습니다.',
    'ip-address.interfaceDHCPEnabled' => 'IP 주소를 추가할 수 없습니다. 이 네트워크 인터페이스는 자동으로 IP 주소를 가져옵니다.',
    'ip-address.accessDomainOnAnyDomainWinWarning' => '참고: 모든 알 수 없는 도메인에서 사용자 지정 Plesk URL이 활성화됩니다. "https://%%ip%%/"에 기본 사이트 대신 Plesk 인터페이스가 표시됩니다.',
    'ip-address.ipAddressInterfaceNotAvailableWarning' => '네트워크 어댑터 %%interface%%이(가) 존재하지 않습니다. 이 IP 주소를 다른 네트워크 어댑터로 이동하거나 목록에서 제거하십시오.',
    'ip-address.none' => '없음',

    'ip-ban.filter.name' => '이름',
    'ip-ban.filter.content' => '내용',
    'ip-ban.filter.filterExistsError' => '해당 이름의 필터가 이미 있습니다.',

    'ip-ban.jail.name' => '이름',
    'ip-ban.jail.filter' => '필터',
    'ip-ban.jail.filterDescription' => '필터를 선택합니다.',
    'ip-ban.jail.action' => '동작',
    'ip-ban.jail.actionDescription' => '동작을 선택하고 버튼을 클릭하여 해당 동작을 추가합니다.',
    'ip-ban.jail.logPath' => '로그 경로',
    'ip-ban.jail.banTime' => 'IP 주소 금지 기간',
    'ip-ban.jail.maxRetry' => '최대 로그인 시도 실패 횟수',
    'ip-ban.jail.timeUnit' => '초',
    'ip-ban.jail.addAction' => '추가',
    'ip-ban.jail.chooseAction' => '선택:',
    'ip-ban.jail.apache-auth-filter-description' => 'Apache 인증 실패(파일에 로그인할 경우)',
    'ip-ban.jail.apache-auth[logging=all]-filter-description' => 'Apache 인증 실패(로깅할 경우)',
    'ip-ban.jail.apache-auth[logging=syslog]-filter-description' => 'Apache 인증 실패(syslog에 로그인할 경우)',
    'ip-ban.jail.apache-badbots-filter-description' => '스팸 봇 및 악성 웹 크롤러',
    'ip-ban.jail.plesk-courierlogin-filter-description' => 'Courier IMAP 및 POP3 인증 실패',
    'ip-ban.jail.plesk-dovecot-filter-description' => 'Dovecot IMAP, POP3, Sieve 인증 실패',
    'ip-ban.jail.plesk-dovecot[mode=aggressive]-filter-description' => 'Dovecot IMAP, POP3, Sieve 인증 실패(적극적인 모드)',
    'ip-ban.jail.plesk-horde-filter-description' => 'Horde 웹 메일 인증 실패',
    'ip-ban.jail.plesk-modsecurity-filter-description' => '웹 애플리케이션 방화벽(ModSecurity) 보안 및 액세스 제어 위반',
    'ip-ban.jail.plesk-panel-filter-description' => 'Plesk 인증 실패',
    'ip-ban.jail.plesk-qmail-filter-description' => 'QMail SMTP 인증 실패',
    'ip-ban.jail.plesk-roundcube-filter-description' => 'Roundcube 웹 메일 인증 실패',
    'ip-ban.jail.plesk-wordpress-filter-description' => 'WordPress 인증 실패',
    'ip-ban.jail.postfix-filter-description' => 'Postfix SMTP 클라이언트 오류(RBL 포함)',
    'ip-ban.jail.postfix[mode=aggressive]-filter-description' => 'Postfix SMTP 클라이언트 오류, 인증 실패, DDoS 공격',
    'ip-ban.jail.postfix[mode=auth]-filter-description' => 'Postfix SMTP 및 SASL 인증 실패',
    'ip-ban.jail.postfix[mode=ddos]-filter-description' => 'Postfix SMTP DDoS 공격',
    'ip-ban.jail.postfix[mode=extra]-filter-description' => 'Postfix SMTP 클라이언트 오류 및 인증 실패',
    'ip-ban.jail.postfix[mode=normal]-filter-description' => 'Postfix SMTP 클라이언트 오류(RBL 포함)',
    'ip-ban.jail.postfix[mode=rbl]-filter-description' => 'Postfix SMTP 클라이언트 오류(RBL만)',
    'ip-ban.jail.proftpd-filter-description' => 'ProFTPD 로그인 실패',
    'ip-ban.jail.recidive-filter-description' => '호스트가 Fail2Ban에 의해 반복적으로 금지됨',
    'ip-ban.jail.sshd-filter-description' => 'SSH 로그인 실패',
    'ip-ban.jail.sshd[mode=aggressive]-filter-description' => 'SSH 로그인 실패, 협상 실패, DDoS 공격',
    'ip-ban.jail.sshd[mode=ddos]-filter-description' => 'SSH 로그인 실패 및 DDoS 공격',
    'ip-ban.jail.sshd[mode=extra]-filter-description' => 'SSH 로그인 실패 및 협상 실패',
    'ip-ban.jail.firewallcmd-allports-action-description' => 'firewalld 방화벽을 통한 차단, 모든 포트에서',
    'ip-ban.jail.firewallcmd-multiport-action-description' => 'firewalld 방화벽을 통한 차단, 여러 포트에서',
    'ip-ban.jail.firewallcmd-new-action-description' => 'firewalld 방화벽을 통한 차단, 단일 포트에서',
    'ip-ban.jail.iptables-action-description' => '단일 포트에서 iptables 방화벽을 통해 금지',
    'ip-ban.jail.iptables-allports-action-description' => '모든 포트에서 iptables 방화벽을 통해 금지',
    'ip-ban.jail.iptables-multiport-action-description' => '다수의 포트에서 iptables 방화벽을 통해 금지',
    'ip-ban.jail.sendmail-action-description' => 'Sendmail을 통해 이메일 알림 보내기',
    'ip-ban.jail.jailExistsError' => '해당 이름의 jail이 이미 있습니다.',
    'ip-ban.jail.invalidInteger' => '유효하지 않은 값이 지정되었습니다. 정수를 지정하십시오.',

    'ip-ban.settings.pageHint' => '여기서 IP 주소 금지를 설정하여 서버와 호스트된 웹 사이트를 악성 트래픽으로부터 보호할 수 있습니다.',
    'ip-ban.settings.detectionEnabled' => '침입 감지 사용',
    'ip-ban.settings.banPeriod' => 'IP 주소 금지 기간',
    'ip-ban.settings.banTimeWindow' => '이후 공격 감지를 위한 시간 간격',
    'ip-ban.settings.maxRetries' => 'IP 주소가 금지되기 전의 실패 횟수',
    'ip-ban.settings.timeUnit' => '초',
    'ip-ban.settings.invalidInteger' => '잘못된 값을 입력했습니다. 양의 정수를 입력하십시오.',

    'ip-ban.trusted-ip.ipAddress' => 'IP 주소',
    'ip-ban.trusted-ip.hintIpAddress' => 'IP 주소, CIDR 마스크 또는 DNS 호스트 이름.',
    'ip-ban.trusted-ip.specialCharactersInIpAddress' => '제공된 IP 주소, 네트워크 주소 또는 호스트 이름이 잘못되었습니다.',
    'ip-ban.trusted-ip.ipAddressIsTooLong' => 'IP 주소는 %max%자를 초과할 수 없습니다.',
    'ip-ban.trusted-ip.ipAddressDescription' => '설명',
    'ip-ban.trusted-ip.hintIpAddressDescription' => 'IP 주소가 신뢰할 수 있는 목록에 추가된 이유.',
    'ip-ban.trusted-ip.ipAddressDescriptionTooLong' => '설명은 %max%자를 초과할 수 없습니다.',

    'login-info.hint' => '여기서 고객이 고객 패널에 액세스하는 데 사용하는 사용자 이름과 암호를 변경합니다.',
    'login-info.resellerHint' => '여기서 리셀러가 Plesk에 액세스하는 데 사용하는 사용자 이름 및/또는 암호를 변경합니다.',
    'login-info.myProfileHint' => '여기서 Plesk에 액세스하는 데 사용하는 암호를 변경합니다.',

    'firewall-rule.titleEdit' => '기존 규칙 편집',
    'firewall-rule.titleNew' => '규칙 추가',
    'firewall-rule.isEnabled' => '규칙 활성화',
    'firewall-rule.name' => '규칙 이름',
    'firewall-rule.profiles' => '프로필',
    'firewall-rule.profilesHint' => '하나 이상의 프로필을 선택해야 합니다.',
    'firewall-rule.profileDomain' => '도메인',
    'firewall-rule.profilePrivate' => '개인',
    'firewall-rule.profilePublic' => '공용',
    'firewall-rule.action' => '동작',
    'firewall-rule.actionAllow' => '허용',
    'firewall-rule.actionBlock' => '거부',
    'firewall-rule.port' => '다음 포트 또는 포트 범위에 대한 연결 허용',
    'firewall-rule.portHint' => '예: 1000 또는 1000-1051',
    'firewall-rule.protocolTcp' => 'TCP 프로토콜',
    'firewall-rule.protocolUdp' => 'UDP 프로토콜',
    'firewall-rule.remoteAddresses' => '원격 주소',
    'firewall-rule.remoteAddressesHint' => '예: 192.168.0.1 또는 192.168.0.0/16',
    'firewall-rule.newRule' => '새 규칙',
    'firewall-rule.successNew' => '방화벽 규칙이 추가되었습니다.',
    'firewall-rule.successEdit' => '방화벽 규칙이 업데이트되었습니다.',

    'mail.lists-server-settings.email' => "메일링 리스트 관리자의 이메일",
    'mail.lists-server-settings.emptyEmail' => '이메일 주소를 입력하십시오.',
    'mail.lists-server-settings.newPassword' => '새 암호',
    'mail.lists-server-settings.emptyPassword' => '암호를 입력하십시오.',
    'mail.lists-server-settings.passwordConfirmation' => '암호 확인',
    'mail.lists-server-settings.mailingListSoftwareWasConfigured' => '메일링 리스트 소프트웨어가 구성되었습니다.',

    'mail.outgoing-messages.hint' => '여기서 사서함으로부터 나가는 메시지에 제한을 지정할 수 있습니다.',
    'mail.outgoing-messages.mailBoxOutgoingMessages' => '나가는 이메일 메시지의 최대 수',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainDefault' => '기본값(시간당 %%domainOutgoingMessages%% 메시지)',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecific' => '이 사서함에 대한 사용자 지정 값',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecificHint' => '시간당 메시지 수',

    'mail-gate-settings.host' => '호스트 이름 또는 IP 주소',
    'mail-gate-settings.port' => '포트',
    'mail-gate-settings.login' => '사용자 이름',
    'mail-gate-settings.password' => '암호',
    'mail-gate-settings.encryption' => 'SMTP 서버에 암호화된 연결 필요',
    'mail-gate-settings.allowUsers' => '이 SMTP 서버를 통해 메일 전송 허용(지정된 로그인 및 암호 사용)',
    'mail-gate-settings.useDefaultSettings' => 'Plesk와 함께 설치된 메일 서버와 Plesk에 의해 생성된 기본 메일 계정 사용',

    'mail-gate.hint' => '여기서 Plesk 메일 서버가 설치되지 않았거나 나가는 메일 전송이 금지된 경우 사용할 SMTP 서버를 지정할 수 있습니다. 이 서버는 Plesk에 의한 SMTP 릴레이와 이메일 알림과 같은 나가는 메일 전송을 위한 사용자 스크립트로 사용됩니다.',
    'mail-gate.enableMailGate' => '이 SMTP 서버를 통해 Plesk로부터 메일 알림 전송 허용',
    'mail-gate.notifications' => '외부 SMTP 서버에 의한 메일 알림',
    'mail-gate.smtpSettings' => '외부 SMTP 서버 설정',

    'optimization-settings.apacheModulesSection' => 'Apache 모듈',
    'optimization-settings.apacheSettingsSection' => '일반 설정',
    'optimization-settings.additionalPageHint' => '동작 결과를 완전히 이해하는 경우에만 모듈을 설정/해제합니다. 수정 내용에 따라 Apache 성능이 저하되거나 심지어 작동하지 않을 수도 있습니다.',
    'optimization-settings.pageHint' => '여기서 사용하지 않는 Apache 모듈을 해제하여 Plesk를 최적화할 수 있습니다. 이러한 최적화를 통해 메모리 사용률을 향상시키고 더 많은 호스팅 고객을 서비스할 수 있습니다. 일부 모듈은 상호 종속적이어서 종속된 모듈이 켜지거나 꺼지는 경우에만 켜고 끌 수 있습니다.',
    'optimization-settings.advancedUsersOnlyWarning' => '이 기능은 고급 사용자 전용입니다.',
    'optimization-settings.apacheRestartInterval' => 'Apache 재시작 간격(초)',
    'optimization-settings.apacheRestartIntervalHint' => '지정된 간격에 있게 되면 Plesk가 도메인 및 하위 도메인의 변경 내용을 확인합니다. 웹 서버를 재시작해야 하는 변경이 있는 경우 Plesk가 Apache를 다시 시작합니다.',
    'optimization-settings.gracefulRestart' => 'Apache 점잖은 재시작',
    'optimization-settings.gracefulRestartHint' => '서버에 호스팅된 모든 웹 사이트의 작동 중단을 예방하려면 선택, 호스팅 설정을 변경할 때마다.',
    'optimization-settings.pipedLog' => '파이핑된 로그',
    'optimization-settings.mpmMode' => 'MPM 모드',
    'optimization-settings.moduleDeprecated' => '(사용되지 않음)',

    'personal-info.contactInfoSection' => '연락처 정보',
    'personal-info.hint' => '여기서 사용자 연락처 정보를 편집합니다.',
    'personal-info.hintMyProfile' => '여기서 연락처 정보를 편집합니다.',

    'php-handler.extension.title' => 'PECL 패키지 설치',
    'php-handler.extension.description' => "'msgpack-beta' 등 패키지 이름으로 추가 매개 변수를 특정하여 확장 프로그램의 베타 버전을 설치할 수 있습니다.",
    'php-handler.extension.name' => '패키지 이름',

    'php-handler.ini.formHint' => '이 php.ini 파일은 이 처리기에 의해서만 사용됩니다.',
    'php-handler.ini.formHintSharedIni' => '이 php.ini 파일은 다음과 같은 PHP 처리기에 의해서도 사용됩니다: %%handlers%%. 이 처리기를 사용하는 모든 웹 사이트에 설정을 적용합니다.',
    'php-handler.ini.incorrectTextForIniFile' => "지정한 설정은 올바르지 않으며 php.ini 파일로 저장될 수 없습니다. 오류: %%message%%.",

    'plan-item-custom.planItemName' => '서비스 이름',
    'plan-item-custom.buttonLabel' => '이 이름은 사용자 지정 버튼의 레이블로도 사용됩니다.',
    'plan-item-custom.planItemDescription' => '서비스 설명',
    'plan-item-custom.buttonTooltip' => '이 텍스트는 사용자 지정 버튼의 도구 설명으로도 사용됩니다.',
    'plan-item-custom.url' => '사용자 지정 버튼에 연결된 URL',
    'plan-item-custom.backgroundImage' => '사용자 지정 버튼의 배경 이미지',
    'plan-item-custom.emptyItemName' => '서비스 레이블을 입력하십시오.',
    'plan-item-custom.emptyItemDescription' => '서비스 도구 설명 텍스트를 입력하십시오.',
    'plan-item-custom.emptyUrl' => 'URL을 지정하십시오.',
    'plan-item-custom.longItemName' => '이 서비스 레이블이 너무 깁니다. 허용되는 최대 길이는 %max% 기호입니다.',
    'plan-item-custom.longItemDescription' => '이 서비스 텍스트가 너무 깁니다. 허용되는 최대 길이는 %max% 기호입니다.',
    'plan-item-custom.longUrl' => '이 URL이 너무 깁니다. 허용되는 최대 길이는 %max% 기호입니다.',
    'plan-item-custom.useCustomButton' => '서비스에 대한 사용자 지정 버튼 사용',
    'plan-item-custom.useCustomButtonHint' => '사용자 홈 페이지 및 웹 사이트 페이지에 사용자 지정 버튼을 배치합니다.',
    'plan-item-custom.openCustomButtonInSameWindow' => 'Plesk에서 URL 열기',
    'plan-item-custom.openCustomButtonInSameWindowDescription' => 'Plesk 페이지와 새 브라우저 창 중 어디서 URL을 열지 지정합니다.',
    'plan-item-custom.openCustomButtonWithoutFrame' => '프레임을 사용하지 않음',
    'plan-item-custom.openCustomButtonWithoutFrameDescription' => '고객 패널의 Plesk 확장 또는 응용 프로그램으로 이어지는 사용자 지정 버튼을 추가하는 경우, 이 확장/응용 프로그램이 표시되는 방식을 지정할 수 있습니다. 즉, 프레임으로 표시하거나 Plesk GUI의 일부로 표시합니다.',
    'plan-item-custom.includeDomId' => '구독 ID 포함',
    'plan-item-custom.includeDomIdDescription' => '&dom_id=<dom_id>',
    'plan-item-custom.includeDomName' => '주 도메인 이름 포함',
    'plan-item-custom.includeDomNameDescription' => '&dom_name=<dom_name>',
    'plan-item-custom.includeFtpUser' => 'FTP 사용자 이름 포함',
    'plan-item-custom.includeFtpUserDescription' => '&ftp_user=<ftp_user>',
    'plan-item-custom.includeFtpPass' => 'FTP 암호 포함',
    'plan-item-custom.includeFtpPassDescription' => '&ftp_pass=<ftp_pass>',
    'plan-item-custom.includeClId' => '고객 ID 포함',
    'plan-item-custom.includeClIdDescription' => '&cl_id=<cl_id>',
    'plan-item-custom.includeCname' => "고객 회사명 포함",
    'plan-item-custom.includeCnameDescription' => '&cname=<cname>',
    'plan-item-custom.includePname' => "고객 연락처 이름 포함",
    'plan-item-custom.includePnameDescription' => '&pname=<pname>',
    'plan-item-custom.includeEmail' => "고객 이메일 포함",
    'plan-item-custom.includeEmailDescription' => '&email=<email>',

    'preview-domain-settings.previewType' => '웹 사이트 미리 보기 방법 선택',
    'preview-domain-settings.previewQuick' => '제한된 미리 보기',
    'preview-domain-settings.previewDisabled' => '빠른 미리 보기 비활성화',
    'preview-domain-settings.previewQuickDescription' => '제안 옵션은 바로 작동됩니다.',
    'preview-domain-settings.previewZoneTypeInternal' => 'Plesk에서 도메인 이름의 빠른 미리 보기',
    'preview-domain-settings.previewZoneDomainIdDescription' => 'Plesk에서 서비스하는 웹 사이트 중 하나에 미리 보기 기능을 사용합니다.',
    'preview-domain-settings.previewZoneDomainCreate' => '이 기능을 사용하려면 하나 이상의 도메인을 %%link%%합니다.',
    'preview-domain-settings.subscriptionCreateLink' => '만들기',
    'preview-domain-settings.previewZoneTypeExternal' => '외부 도메인 이름의 빠른 미리 보기',
    'preview-domain-settings.previewZoneDomainNameDescription' => '외부 도메인 이름(DNS 영역)을 사용합니다. 이 옵션을 사용하는 경우 다음 DNS 레코드(유형 A)를 외부 도메인 영역에 추가합니다. *.<Plesk_IP>.external.dom. 여기서 <Plesk_IP>은(는) Plesk 서버 IP이며, IPv4용 점(.) 또는 IPv6용 콜론(:)은 대시(-)로 대체됩니다 (예: *.192-0-2-12.external.dom). Plesk에 등록된 IP가 둘 이상 있는 경우 각 주소에 레코드를 추가합니다.',
    'preview-domain-settings.sitePreviewProtection' => '인증 필요',
    'preview-domain-settings.sitePreviewProtectionDescription' => '미리 보기에 액세스하려면 FTP 로그인 및 암호가 필요합니다.',
    'preview-domain-settings.nginxNotInstalled' => 'nginx 웹 서버가 설치되지 않아 Default Quick Preview를 사용할 수 없습니다.',
    'preview-domain-settings.nginxDisabled' => 'nginx 웹 서버가 비활성화되어 Default Quick Preview를 사용할 수 없습니다.',

    'reseller-preferences.settingsSection' => '설정',
    'reseller-preferences.multiLogin' => '다중 세션 허용',
    'reseller-preferences.language' => '인터페이스 언어',
    'reseller-preferences.interfaceView' => '인터페이스 선택',
    'reseller-preferences.serviceProviderView' => '서비스 공급자 보기',
    'reseller-preferences.serviceProviderViewHint' => '이 보기는 서비스 요금제로 고객에게 웹 호스팅 서비스를 제공 또는 판매하는 서버 관리자를 대상으로 합니다.',
    'reseller-preferences.powerUserView' => '고급 사용자 보기',
    'reseller-preferences.powerUserViewHint' => '이 보기는 웹사이트 및 웹사이트의 파일, 데이터페이스, 이메일 계정, 웹 애플리케이션, 기타 서비스를 관리하는 데 적합합니다.',

    'reseller.hint' => '여기서 새 리셀러를 호스팅 서비스에 등록합니다.',
    'reseller.contactInfoSection' => '연락처 정보',
    'reseller.contactInfoSectionHint' => '리셀러 연락처 정보를 입력하십시오.',
    'reseller.accessToPanelSection' => 'Plesk에 액세스',
    'reseller.accessToPanelSectionHint' => '리셀러가 Plesk에 액세스하여 등록된 서비스를 관리하는 데 사용할 자격 증명.',
    'reseller.subscription' => '구독',
    'reseller.subscriptionSectionHint' => '리셀러가 구독할 서비스 플랜을 선택합니다.',
    'reseller.servicePlan' => '서비스 플랜',
    'reseller.none' => '없음',
    'reseller.customizeSubscription' => '리셀러가 만들어진 후 구독 매개 변수를 사용자 지정하십시오. 이렇게 하면 동기화를 위해 구독이 잠기게 됩니다.',
    'reseller.subscriptionNotSynchronized' => '구독을 서비스 플랜과 동기화할 수 없습니다. 다음 구독 설정이 서비스 플랜과 충돌합니다. %%problems%%.',

    'security-policy.encryptionSection' => '향상된 보안 모드',
    'security-policy.encryptionSectionHint' => '향상된 보안 모드는 Plesk에서 민감한 데이터를 더욱 강력하게 보호하는 기능이 적용되었습니다. 이 모드에서 Plesk는 Plesk 사용자에게 완전히 공개된 여러 개의 보안 메커니즘을 사용합니다. Plesk는 보안을 개선하기 위해 이 모드를 사용할 것을 권장합니다.',
    'security-policy.encryptionEnable' => '향상된 보안 모드',
    'security-policy.securePassword' => '향상된 보안 모드',
    'security-policy.strengthSection' => '암호 길이',
    'security-policy.strengthSectionHint' => 'Plesk에서 사용자가 설정하거나 변경할 수 있는 대부분의 암호는 이곳에서 지정한 최소 암호 강도 요구를 충족하는지 검증됩니다. 강력한 암호는 최고 9~12자이며 숫자, 대소문자, 특수 문자를 포함하며, 사전에 나오는 단어를 포함하지 않습니다. 강력한 암호는 추측하기 어렵지만 기억하기도 어렵습니다. <a href="%%link%%" target="_blank">암호 강도에 대해 자세히 알아보십시오</a>.',
    'security-policy.passwordStrength' => '최소 암호 길이',
    'security-policy.secureFtpSection' => '보안 FTP',
    'security-policy.ftpOverSsl' => 'FTPS 사용 정책',
    'security-policy.ftpOverSslHint' => 'FTPS는 SSL/TLS 프로토콜을 사용하여 FTP 서버와 외부 FTP 클라이언트 간 통신을 보호합니다. 여기서 허용되는 통신 종류를 선택할 수 있습니다.',
    'security-policy.ftpOverSslWithCustomOptionHint' => 'FTPS는 SSL/TLS 프로토콜을 사용하여 FTP 서버와 외부 FTP 클라이언트 간 통신을 보호합니다. 여기서 허용되는 통신 종류를 선택할 수 있습니다. 선택한 옵션은 서버의 모든 IP 주소에 적용됩니다. IP 주소별로 사용자 지정 FTPS 설정을 사용하려면 해당 옵션을 선택한 후 도구 & 설정> IP 주소에서 FTPS 정책을 변경합니다.',
    'security-policy.ftpOverSslCustomHint' => 'FTPS는 SSL/TLS 프로토콜을 사용하여 FTP 서버와 외부 FTP 클라이언트 간 통신을 보호합니다.',
    'security-policy.ftpOverSslCustomDisabledHint' => 'FTPS는 SSL/TLS 프로토콜을 사용하여 FTP 서버와 외부 FTP 클라이언트 간 통신을 보호합니다. IP 주소별로 FTPS 설정을 조정하려면 먼저 도구 & 설정 > 보안 정책 > 보안 FTP에서 "IP 주소별로 사용자 지정 FTPS 설정 사용" 옵션을 선택합니다.',
    'security-policy.ftpOverSslOptionRequired' => '보안 FTPS 연결만 허용',
    'security-policy.ftpOverSslOptionEnabled' => '보안 FTPS 및 비보안 FTP 연결 모두 허용',
    'security-policy.ftpOverSslOptionDisabled' => '비보안 FTP 연결만 허용 FTPS 사용 안 함',
    'security-policy.ftpOverSslOptionCustom' => 'IP 주소별로 사용자 지정 FTPS 설정 사용',
    'security-policy.prohibitWebConfigHandlersSection' => '사용자 지정 핸들러 정책',
    'security-policy.prohibitWebConfigHandlersSectionHint' => '고객이 web.config file을 통해 서버 수준에서 정의된 IIS 처리기를 무시하는 것을 방지하려면 이 옵션을 활성화합니다.',
    'security-policy.prohibitWebConfigHandlers' => 'web.config를 통한 핸들러 재정의 기능 금지',

    'server-mail-antivirus.used' => '사용된 안티 바이러스',
    'server-mail-antivirus.policy' => '서버 전체 설정 사용',
    'server-mail-antivirus.policyOff' => '검사 비활성화',
    'server-mail-antivirus.policyAny' => '수신 메일과 발신 메일을 모두 검사',
    'server-mail-antivirus.policyFrom' => '발신 메일만',
    'server-mail-antivirus.policyTo' => '수신 메일만 검사',
    'server-mail-antivirus.allowPersonalSettings' => '개별 설정 허용',
    'server-mail-antivirus.allowPersonalSettingsDesc' => 'Allow override server-wide settings in each email address',
    'server-mail-antivirus.incoming' => '수신 메일',
    'server-mail-antivirus.outgoing' => '발신 메일',
    'server-mail-antivirus.success' => '안티 바이러스 설정이 변경되었습니다.',

    'server-mail-black-list.title' => '블랙 리스트에 도메인 추가',
    'server-mail-black-list.domainName' => '도메인 이름',
    'server-mail-black-list.emailAddress' => '이메일 주소',
    'server-mail-black-list.emailAddressHint' => '@ 기호 왼쪽에는 ASCII가 아닌 문자가 올 수 없습니다. 주소에 "*" 및 "?"의 와일드카드를 포함할 수 있습니다(예: *@domain.com, user?@*.com). 도메인 이름 중 ASCII가 아닌 부분은 와일드카드를 포함할 수 없습니다.',
    'server-mail-black-list.action' => '기준에 맞는 메일에 수행할 작업:',
    'server-mail-black-list.actionDelete' => '서버에서 삭제',
    'server-mail-black-list.actionSpam' => '스팸으로 표시',
    'server-mail-black-list.success' => '도메인을 블랙 리스트에 추가했습니다.',

    'server-mail-white-list.title' => '허용 목록에 네트워크 추가',
    'server-mail-white-list.descEmailAddress' => '여기에 지정된 이메일 주소는 SpamAssassin에서 스팸으로 인식하지 않습니다.',
    'server-mail-white-list.descIpAddress' => '여기에 지정된 IP 항목은 메일 서버의 예외에 추가됩니다.',
    'server-mail-white-list.ipAddress' => 'IP 주소/마스크',
    'server-mail-white-list.ipAddressHint' => 'IP 주소에는 와일드카드 또는 CIDR 마스크가 포함될 수 있습니다.',
    'server-mail-white-list.emailAddress' => '이메일 주소',
    'server-mail-white-list.emailAddressHint' => '@ 기호 왼쪽에는 ASCII가 아닌 문자가 올 수 없습니다. 주소에 "*" 및 "?"의 와일드카드를 포함할 수 있습니다(예: *@domain.com, user?@*.com). 도메인 이름 중 ASCII가 아닌 부분은 와일드카드를 포함할 수 없습니다.',
    'server-mail-white-list.emailAddressOrIp' => '이메일 또는 IP 주소',
    'server-mail-white-list.wildcardPattern' => 'IP 주소에는 와일드카드가 포함될 수 있습니다(예: 123.123.*.123).',
    'server-mail-white-list.cidrPattern' => 'IP 주소에는 와일드카드가 포함될 수 있습니다(예: 10.0.0.0/8).',
    'server-mail-white-list.success' => '네트워크가 허용 목록에 추가되었습니다.',

    'server-mail-settings.general.title' => '일반 옵션',
    'server-mail-settings.general.mailUiEnabled' => 'Plesk에서 메일 관리 기능을 활성화합니다.',
    'server-mail-settings.general.serverName' => '설치된 메일 서버',
    'server-mail-settings.general.changeServerName' => '다른 메일 서버 설치 및 사용',
    'server-mail-settings.general.imapServerName' => 'IMAP/POP3 서버 설치됨',
    'server-mail-settings.general.changeImapServerName' => '다른 IMAP/POP3 서버 설치 및 사용',
    'server-mail-settings.general.changeServerHint' => '%%serverChangeLink%%을(를) 할 수 있습니다.',
    'server-mail-settings.general.maxMessageSize' => '최대 메시지 크기',
    'server-mail-settings.general.kbytes' => 'KB',
    'server-mail-settings.general.maxConnections' => '최대 연결 수(IMAP, POP3, IMAP over SSL/TLS 또는 POP3 over SSL/TLS)',
    'server-mail-settings.general.maxConnectionsHintCourier-IMAP' => '최대 수의 서버(IMAP 또는 POP3)가 시작됨.',
    'server-mail-settings.general.maxConnectionsHintDovecot' => '동시에 로그인할 수 있는 최대 메일 사용자 수.',
    'server-mail-settings.general.maxConnectionsPerIpCourier-IMAP' => 'IP 주소당 최대 연결 수',
    'server-mail-settings.general.maxConnectionsPerIpDovecot' => 'IP 주소당 사용자에 대한 최대 연결 수',
    'server-mail-settings.general.maxConnectionsPerIpHintCourier-IMAP' => '동일 IP 주소로부터 수용되는 최대 연결 수(IMAP, POP3, IMAP over SSL/TLS 또는 POP3 over SSL/TLS).',
    'server-mail-settings.general.maxConnectionsPerIpHintDovecot' => '각 IP 주소로부터 메일 사용자에게 허용된 최대 연결 수(IMAP, POP3, IMAP over SSL/TLS 또는 POP3 over SSL/TLS).',
    'server-mail-settings.general.messageSubmission' => '포트 587에서 SMTP 서비스 활성화',
    'server-mail-settings.general.messageSubmissionOnAllIp' => '모든 IP 주소의 포트 587에서 SMTP 서비스 활성화',
    'server-mail-settings.general.messageSubmissionBindTo' => '켜기',
    'server-mail-settings.general.messageSubmissionAllIpAddresses' => '모든 IP 주소',
    'server-mail-settings.general.outgoingEmailMode' => '나가는 메일 모드',
    'server-mail-settings.general.outgoingEmailModeDomainIp' => '도메인 IP 주소로부터 보내기',
    'server-mail-settings.general.outgoingEmailModeDomainName' => '도메인 IP 주소에서 보내고 SMTP 인사에 도메인 이름을 사용합니다.',
    'server-mail-settings.general.outgoingEmailModeExplicitIp' => '지정된 IP 주소로부터 보내기',
    'server-mail-settings.general.outgoingEmailModeExplicitIpV4' => 'IPv4',
    'server-mail-settings.general.outgoingEmailModeExplicitIpV6' => 'IPv6',
    'server-mail-settings.general.outgoingEmailModeExplicitIpNone' => '없음',
    'server-mail-settings.general.subaddressing' => '이메일 서비스 활성화',
    'server-mail-settings.general.subaddressingHint' => '이 옵션을 사용하면 메일 목록에 대해 %%verpStyleLink%% 이메일 주소를 구성할 수 있습니다.',
    'server-mail-settings.general.verpStyleLink' => 'VERP 스타일',
    'server-mail-settings.general.mboxQuotaWarning' => '사서함 할당량 경고',
    'server-mail-settings.general.mboxQuotaWarningHint' => '사서함 할당량 사용 95% 초과 시 메일 사용자에게 알림 보내기',
    'server-mail-settings.general.mboxQuotaWarningChange' => '기본 사서함 할당량 경고 사용자 지정',
    'server-mail-settings.general.fixSender' => '발신 메일에 잘못 설정된 발신자 수정',
    'server-mail-settings.general.fixSenderHint' => '스팸 처리될 가능성을 줄이기 위해 도메인 발신 메일에 유효한 이메일 헤더 및 발신자 봉투 주소를 자동으로 설정',

    'server-mail-settings.autodiscover.title' => '메일 자동 검색',
    'server-mail-settings.autodiscover.description' => '%%link%%에서 작동하는 방법 확인',
    'server-mail-settings.autodiscover.link' => '기술 자료',
    'server-mail-settings.autodiscover.enabled' => '메일 자동 검색 활성화',
    'server-mail-settings.autodiscover.enabledHint' => '이 기능을 활성화하면 자동 검색이 설정된 모든 도메인이 재구성됩니다.',
    'server-mail-settings.autodiscover.customServer' => '메일 자동 검색을 위한 사용자 지정 도메인 이름 지정',
    'server-mail-settings.autodiscover.customServerHint' => '참고: 도메인 이름은 유효한 SSL/TLS 인증서로 보호되어야 합니다.',
    'server-mail-settings.autodiscover.reconfigureDns' => '자동 검색 DNS 레코드 재구성',
    'server-mail-settings.autodiscover.reconfigureDnsHint' => '이 기능을 활성화하면 자동 검색이 설정된 모든 도메인 자동 검색 DNS 레코드가 재구성됩니다.',

    'server-mail-settings.relay.title' => '릴레이 옵션',
    'server-mail-settings.relay.type' => "릴레이",
    'server-mail-settings.relay.open' => "열기",
    'server-mail-settings.relay.openSpamWarning' => "메일 릴레이를 열면 메일 서버가 스팸에 노출됩니다.",
    'server-mail-settings.relay.openSpamChange' => "임시로 메일 서버를 테스트하거나 Plesk 서버가 인터넷을 통해 액세스할 수 없는 내부 네트워크에 있는 경우에만 설정을 유지합니다.",
    'server-mail-settings.relay.closed' => "닫힘",
    'server-mail-settings.relay.auth' => "인증이 필요함:",
    'server-mail-settings.relay.notSupported' => "메일 서버에서 지원되지 않음",
    'server-mail-settings.relay.change' => '릴레이가 닫힐 때 Plesk에서 알림을 보내도록 하려면 %%changeLink%%을(를) 하면 됩니다.',
    'server-mail-settings.relay.changeLink' => 'SMTP 설정을 변경합니다.',
    'server-mail-settings.relay.pop3' => "SMTP 이전 POP3",
    'server-mail-settings.relay.lockTime' => "잠금 시간",
    'server-mail-settings.relay.min' => "최소",
    'server-mail-settings.relay.smtp' => "SMTP",
    'server-mail-settings.relay.noRelayNetworks' => '다음 네트워크에 대해 릴레이 제한 사용 안 함:',
    'server-mail-settings.relay.noRelayNetworksHint' => "IP 주소/마스크",

    'server-mail-settings.outgoing.title' => '발신 이메일 메시지 제한',
    'server-mail-settings.outgoing.description' => '다음 제한치가 기본값입니다. 각 서비스 플랜과 구독에서 재정의할 수 있습니다. 제한은 전체 서버에 걸쳐 작동하지 않지만 사용자 지정 제한이 지정되지 않은 플랜과 구독에 대한 템플릿 역할을 합니다. 발신 이메일 메시지 제한을 켜면 메일 서버 성능에 영향을 줄 수 있습니다. %%link%%',
    'server-mail-settings.outgoing.learnMore' => '발신 메일 제한에 대해 자세히 알아보기',
    'server-mail-settings.outgoing.enabled' => '발신 이메일 메시지 제한을 켭니다.',
    'server-mail-settings.outgoing.countRecipients' => '메시지 대신에 수신자 수를 계산',
    'server-mail-settings.outgoing.countRecipientsHint' => '발신 메일을 제한하고 통계를 계산할 때 메시지가 아닌 수신자 수를 계산하는 모드를 활성화합니다. 예를 들어 10명의 수신자에게 보낸 하나의 메시지는 10개의 메시지로 계산됩니다.',
    'server-mail-settings.outgoing.mailboxLimit' => '사서함으로부터 나가는 메시지에 적용되는 기본 제한(시간당)',
    'server-mail-settings.outgoing.domainLimit' => '도메인으로부터 나가는 메시지에 적용되는 기본 제한(시간당)',
    'server-mail-settings.outgoing.subscriptionLimit' => '구독으로부터 나가는 메시지에 적용되는 기본 제한(시간당)',
    'server-mail-settings.outgoing.unlimited' => '제한 없음',
    'server-mail-settings.outgoing.sendmail' => '스크립트와 사용자의 Sendmail 사용 허용',
    'server-mail-settings.outgoing.sendmailHint' => '사서함과 도메인에 대한 제한이 초과되더라도 Sendmail을 이용하여 스크립트 및 사용자가 이메일 메시지를 보낼 수 있습니다(구독의 시스템 사용자를 대신하여). Sendmail을 통해 보낼 수 있는 최대 메시지 수는 전체 구독에 대한 제한으로 정의됩니다. 이 설정은 전체 서버에 걸쳐 스크립트의 Sendmail 사용을 허용하지 않지만 서비스 플랜과 구독에 대한 기본 설정 역할을 합니다.',
    'server-mail-settings.outgoing.reportPeriod' => '보고서 표시의 근거 자료가 될 통계 작성을 위한 최근 일 수',
    'server-mail-settings.outgoing.reportPeriodHint' => '보고서가 작성되고 지정된 기간 중 나가는 메일에 대한 제한을 초과한 시도에 관한 경고가 홈 페이지에 표시됩니다.',
    'server-mail-settings.outgoing.notificationPeriod' => '이메일 알림을 보낼 주기',
    'server-mail-settings.outgoing.notificationPeriodHint' => '알림은 지정된 기간 동안 나가는 메일에 대한 제한을 초과한 시도에 관한 통계를 제공합니다.',
    'server-mail-settings.outgoing.periodP1D' => '1일',
    'server-mail-settings.outgoing.periodP1W' => '1주일',
    'server-mail-settings.outgoing.periodP2W' => '2주일',
    'server-mail-settings.outgoing.periodP1M' => '1개월',
    'server-mail-settings.outgoing.periodPT15M' => '15분',
    'server-mail-settings.outgoing.periodPT1H' => '1시간',
    'server-mail-settings.outgoing.periodPT6H' => '6시간',
    'server-mail-settings.outgoing.periodPT12H' => '12시간',
    'server-mail-settings.outgoing.whiteListNotEmpty' => 'IP 주소가 메일 서버의 수신 허용 목록에 있는 메일 발신자에게는 발신 메일에 대한 제한이 적용되지 않습니다. 예를 들어 수신 허용 목록에 로컬 호스트(127.0.0.0 / 8, ::1 / 128)가 있는 경우에는 제한에 관계 없이 로컬 서버의 모든 메일을 보낼 수 있습니다. 메일 발신자는 로컬 IP 주소(로컬 서버에 호스팅된 웹 사이트와 사용자 지정 스크립트) 또는 외부 주소(자신의 컴퓨터 또는 모바일 장치에 설치된 메일 클라이언트에서 메일을 보내는 고객)를 사용할 수 있습니다. 모든 메일 발신자(로컬 및 외부)에게 제한을 적용하려면 수신 허용 목록에서 모든 IP 주소와 네트워크를 제거하십시오. 수신 허용 목록에서 로컬 호스트(127.0.0.0 / 8, ::1 / 128)를 제거하면 해당 서버에서 메일을 보내는 웹 사이트와 스크립트의 작동이 중단될 수 있습니다. 발신 메일 제한에 대한 자세한 내용은 관리자 안내서의 "아웃바운드 스팸으로부터 보호"를 참조하십시오.',
    'server-mail-settings.outgoing.relayIsOpen' => '메일 릴레이가 열려 있습니다. 발신 메일 제한이 적용되지 않습니다.',
    'server-mail-settings.outgoing.domainLimitExceedsSubscriptionLimit' => '도메인의 나가는 메시지에 대한 제한값(%%value%%)은 구독에 대한 제한값(%%highLevelLimitValue%%)보다 클 수 없습니다.',
    'server-mail-settings.outgoing.mailboxLimitExceedsDomainLimit' => '이메일 주소의 나가는 메시지에 대한 제한값(%%value%%)은 도메인에 대한 제한값(%%highLevelLimitValue%%)보다 클 수 없습니다.',
    'server-mail-settings.outgoing.mailboxLimitExceedsSubscriptionLimit' => '이메일 주소의 나가는 메시지에 대한 제한값(%%value%%)은 구독에 대한 제한값(%%highLevelLimitValue%%)보다 클 수 없습니다.',

    'server-mail-settings.mailman.title' => '메일맨 설정',
    'server-mail-settings.mailman.secureLinks' => '메일 목록에 보안 링크 사용',
    'server-mail-settings.mailman.secureLinksHint' => '메일링 리스트에서 보안(HTTPS) 링크 생성을 활성화 또는 비활성화합니다.',
    'server-mail-settings.mailman.noLocalhost' => '메일링 리스트를 사용하려면 메일 서버의 허용 목록에 로컬 호스트(127.0.0.0/8, ::1/128)가 있어야 합니다. 그러나 발신 메일 제어를 사용하려면, 허용 목록에 로컬 호스트가 존재하지 않아야 합니다.발신 메일 제어를 활성화할 경우 메일링 목록 대신 사서함에 메일 전달하기를 사용할 수 있습니다.',
    'server-mail-settings.mailman.noLocalhostIpv4' => '메일링 리스트를 사용하려면 메일 서버의 허용 목록에 로컬 호스트가 존재해야 합니다.  그러나 발신 메일 제어를 사용하려면, 허용 목록에 로컬 호스트가 존재하지 않아야 합니다.발신 메일 제어를 활성화할 경우 메일링 목록 대신 사서함에 메일 전달하기를 사용할 수 있습니다. 현재 허용 목록에 IPv4 로컬 호스트 주소(127.0.0.0/8)가 없어 발신 메일 제어가 IPv4 주소에 대해 실행됩니다.',
    'server-mail-settings.mailman.noLocalhostIpv6' => '메일링 리스트를 사용하려면 메일 서버의 허용 목록에 로컬 호스트가 존재해야 합니다.  그러나 발신 메일 제어를 사용하려면, 허용 목록에 로컬 호스트가 존재하지 않아야 합니다.발신 메일 제어를 활성화할 경우 메일링 목록 대신 사서함에 메일 전달하기를 사용할 수 있습니다. 현재 허용 목록에 IPv6 로컬 호스트 주소(::1/128)가 없어 발신 메일 제어가 IPv6 주소에 대해 실행됩니다.',

    'server-mail-settings.spam-filter.dmarc' => 'DMARC',
    'server-mail-settings.spam-filter.dmarcEnabled' => 'DMARC를 활성화하여 들어오는 메일을 검사합니다.',
    'server-mail-settings.spam-filter.dmarcHint' => '이 옵션은 수신 메일의 DKIM 및 SPF가 설정되어 있을 때 사용 가능합니다.',
    'server-mail-settings.spam-filter.dkim' => 'DKIM 스팸 차단',
    'server-mail-settings.spam-filter.singOutgoing' => '서명이 있는 발신 메일 허용',
    'server-mail-settings.spam-filter.verifyIncoming' => '수신 메일 확인',
    'server-mail-settings.spam-filter.verifyIncomingHint' => '수신 메일의 DMARC가 설정되어 있는 동안에는 이 옵션을 해제할 수 없습니다.',
    'server-mail-settings.spam-filter.spf' => 'SPF 스팸 차단',
    'server-mail-settings.spam-filter.spfEnabled' => 'SPF 스팸 차단을 활성화하여 들어오는 메일을 검사합니다.',
    'server-mail-settings.spam-filter.spfEnabledHint' => '수신 메일의 DMARC가 설정되어 있는 동안에는 이 옵션을 해제할 수 없습니다.',
    'server-mail-settings.spam-filter.ignoreErrors' => 'DNS 조회 문제가 있을 때 SPF 검사를 계속합니다.',
    'server-mail-settings.spam-filter.ignoreErrorsHint' => '우선, SPF가 DNS 조회를 수행합니다. DNS 조회가 실패하는 경우 검사를 계속하려면 이 옵션을 선택합니다. 이 옵션은 현재 검사 모드에 효과가 없는 경우 해제됩니다.',
    'server-mail-settings.spam-filter.behavior' => 'SPF 검사 모드',
    'server-mail-settings.spam-filter.behaviorHint' => '그러면 SPF가 로컬 및 추측 규칙을 적용합니다. 선택된 검사 모드와 검사 결과에 따라 메시지가 거부될 수 있습니다.',
    'server-mail-settings.spam-filter.behaviorCreateHeadersNoBlock' => '수신된-SPF 머리글만 만들고 차단 안 함',
    'server-mail-settings.spam-filter.behaviorUseTmpErrors' => 'DNS 조회 문제가 발생할 때 임시 오류 알림 사용',
    'server-mail-settings.spam-filter.behaviorRejectIfFail' => 'SPF가 실패(거부)로 확인될 때 메일 거부',
    'server-mail-settings.spam-filter.behaviorRejectIfSoftfail' => 'SPF가 소프트 실패로 확인될 때 메일 거부',
    'server-mail-settings.spam-filter.behaviorRejectIfNeutral' => 'SPF가 중립으로 확인될 때 메일 거부',
    'server-mail-settings.spam-filter.behaviorRejectIfNoPass' => 'SPF가 통과로 확인될 때 메일 거부',
    'server-mail-settings.spam-filter.localRules' => 'SPF 로컬 규칙',
    'server-mail-settings.spam-filter.guessRules' => 'SPF 추측 규칙',
    'server-mail-settings.spam-filter.explanationText' => 'SPF 확장 텍스트',
    'server-mail-settings.spam-filter.rbl' => "DNS 블랙홀 목록에 기반한 스팸 보호",
    'server-mail-settings.spam-filter.rblEnabled' => "DNS 블랙홀 목록에 따라 스팸 보호를 켭니다.",
    'server-mail-settings.spam-filter.rblServer' => "DNSBL 서비스에 대한 DNS 영역",
    'server-mail-settings.spam-filter.rblServerHint' => "세미콜론으로 항목 구분, 예: 'zen.spamhaus.org;dnsbl.example.net'",

    'server-mail-settings.auto-reply-headers.title' => '추가 자동 회신 헤더',
    'server-mail-settings.auto-reply-headers.description' => 'Plesk 서버에서 오는 모든 자동 회신 메시지에 대해 추가 헤더를 설정합니다.',
    'server-mail-settings.auto-reply-headers.extra' => '추가 헤더',

    'server-mail-settings.pop3-names.title' => "POP3/IMAP 메일 계정의 이름",
    'server-mail-settings.pop3-names.disabled' => "POP3/IMAP 메일 계정의 전체 이름만 사용할 수 있습니다.",
    'server-mail-settings.pop3-names.enabled' => "POP3/IMAP 메일 계정의 약식(webmaster) 및 전체(webmaster@domain.com) 이름을 사용할 수 있습니다.",

    'server-mail-settings.success' => '메일 서버 설정이 변경되었습니다.',

    'server-mail-spam-filter.general' => '일반',
    'server-mail-spam-filter.isEnabled' => '서버 전체에 걸쳐 SpamAssassin 스팸 필터링 기능 활성화',
    'server-mail-spam-filter.isUserSettingsEnabled' => '스팸 필터링에 개별 설정 적용',
    'server-mail-spam-filter.isUserSettingsEnabledHint' => "스팸 필터가 비활성화됨: 메일 서버가 사서함 수준의 스팸 필터 필터 설정을 지원하지 않습니다.",
    'server-mail-spam-filter.settings' => 'SpamAssassin 설정',
    'server-mail-spam-filter.requiredHits' => '스팸으로 지정되기 전에 메시지가 받아야 하는 점수',
    'server-mail-spam-filter.maxMailLimit' => '메일 크기가 이 값을 초과할 때 필터링 안 함',
    'server-mail-spam-filter.maxMailLimitText' => '크기 제한',
    'server-mail-spam-filter.kbytes' => "KB",
    'server-mail-spam-filter.maxThreadsLimit' => '스팸 필터가 생성할 수 있는 스레드 수',
    'server-mail-spam-filter.tag' => '스팸으로 인식된 각 메시지의 제목 시작 부분에 다음 텍스트 추가',
    'server-mail-spam-filter.byTag' => '태그 기준',
    'server-mail-spam-filter.alarmMessage' => '스팸 탐지 경고 텍스트',
    'server-mail-spam-filter.languages' => '신뢰할 수 있는 언어',
    'server-mail-spam-filter.locales' => '신뢰할 수 있는 로켈',
    'server-mail-spam-filter.success' => '스팸 필터 설정이 변경되었습니다.',

    'service-instance.setup-instance.resourcesSection' => '서비스 리소스',
    'service-instance.setup-instance.requiredServiceAlreadyInstalled' => '이미 설치됨',
    'service-instance.setup-instance.requirementsSection' => '요청된 서비스',
    'service-instance.setup-instance.requiredServiceNotSelected' => '선택되지 않음',

    'service-node.ipAddress' => '서비스 노드 IP 주소',
    'service-node.ipAddressLocal' => '로컬 서비스 노드',
    'service-node.description' => '서비스 노드 설명',
    'service-node.accessKey' => '암호',
    'service-node.useAccessKey' => '인증 사용',
    'service-node.useAccessKeyDescription' => '인증 사용 관련 힌트.',
    'service-node.oldAccessKey' => '이전 암호',
    'service-node.newAccessKey' => '새 암호',
    'service-node.noAccessKeySpecified' => '암호가 지정되지 않았습니다',

    'service-plan.admin-plan.subscription_section' => '일반',
    'service-plan.admin-plan.tools_section' => '도구 및 리소스',
    'service-plan.admin-plan.apps_section' => '응용 프로그램 및 데이터베이스',
    'service-plan.admin-plan.panel_section' => 'Plesk',
    'service-plan.admin-plan.appearance_section' => 'Plesk 모양',
    'service-plan.admin-plan.statistics_section' => '통계',
    'service-plan.admin-plan.general_section' => '일반',
    'service-plan.admin-plan.mail_section' => '메일',
    'service-plan.admin-plan.server_section' => '서버',
    'service-plan.admin-plan.modules_section' => '확장 프로그램',
    'service-plan.admin-plan.troubleshooting_section' => '지원 및 문제 해결',
    'service-plan.admin-plan.simplePanel' => '제한 모드',
    'service-plan.admin-plan.enabled' => '제한 모드 활성화',
    'service-plan.admin-plan.enabledDescription' => '관리자가 Plesk에서 수행할 수 있는 작업 수를 제한하려면 이 옵션을 선택하십시오.',
    'service-plan.admin-plan.aliasEnabledDescription' => '추가 관리자가 Plesk에서 수행할 수 있는 작업 수를 제한하려면 이 옵션을 선택하십시오.',

    'service-plan.applications-subscription.useFilterLabel' => '내가 선택하는 응용 프로그램만 제공',
    'service-plan.applications-subscription.useFilterDescription' => '구독자에게 제공할 응용 프로그램을 선택하려면 이 옵션을 사용합니다.',
    'service-plan.applications-subscription.applications' => '응용 프로그램',
    'service-plan.applications-subscription.isCommercial' => '이 응용 프로그램은 상업용이므로 사용하기 위해 라이센스 키를 구입해야 합니다.',

    'service-plan.applications.useFilterLabel' => '내가 선택하는 응용 프로그램만 제공',
    'service-plan.applications.useFilterDescription' => '구독자에게 제공할 응용 프로그램을 선택하려면 이 옵션을 사용합니다.',
    'service-plan.applications.applications' => '응용 프로그램',
    'service-plan.applications.isCommercial' => '이 응용 프로그램은 상업용이므로 사용하기 위해 라이센스 키를 구입해야 합니다.',

    'service-plan.dns.dnsZoneType' => '도메인 DNS 영역',
    'service-plan.dns.dnsZoneTypeMaster' => '기본',
    'service-plan.dns.dnsZoneTypeSlave' => '보조',

    'service-plan.extras.groupOtherServices' => '기타 서비스',
    'service-plan.extras.none' => '없음',

    'service-plan.hosting.enablePhysicalHosting' => '호스팅 활성화',
    'service-plan.hosting.sectionCoreHosting' => '일반 속성',
    'service-plan.hosting.sectionScripting' => '스크립팅',
    'service-plan.hosting.defaultDatabaseServer' => '기본 데이터베이스 서버',
    'service-plan.hosting.versionCut' => 'v%%version%%',
    'service-plan.hosting.sectionAdvanced' => '고급',
    'service-plan.hosting.phpSettingsHelpLink' => '가장 적합한 PHP 설정 선택 방법 알아보기',
    'service-plan.hosting.unpaidWebsiteStatusLabelSubscription' => '이 구독이 일시 중단되는 경우 웹 사이트의 상태',
    'service-plan.hosting.unpaidWebsiteStatusLabel' => '웹 사이트가 일시 중단된 구독 상태임',
    'service-plan.hosting.unpaidWebsiteStatusDescription' => '구독이 일시 중단되는 경우(예를 들어 만료되거나 유료 기간이 종료됨) 플랜 구독이 적용되는 모든 웹 사이트에 선택 상태가 적용됩니다.',
    'service-plan.hosting.unpaidWebsiteStatusDescriptionSubscription' => '구독이 일시 중단되는 경우(예를 들어 만료되거나 유료 기간이 종료됨) 웹 사이트에 선택 상태가 적용됩니다.',
    'service-plan.hosting.unpaidWebsiteStatusDisabled' => '비활성화됨',
    'service-plan.hosting.unpaidWebsiteStatusDisabledHint' => '웹 사이트 방문자는 웹 서버의 기본 페이지로 리디렉션됩니다.',
    'service-plan.hosting.unpaidWebsiteStatusSuspended' => '일시 중단됨',
    'service-plan.hosting.unpaidWebsiteStatusSuspendedHint' => '웹 사이트 방문자는 검색 엔진에 친화적인 HTTP 301 코드를 통해 사용자 지정 오류 문서 페이지로 리디렉션됩니다.',
    'service-plan.hosting.unpaidWebsiteStatusActive' => '활성',
    'service-plan.hosting.unpaidWebsiteStatusActiveHint' => '인터넷을 통해 웹 사이트에 계속 액세스할 수 있습니다.',

    'service-plan.ip.sharedIpAddresses' => '공유 IP 주소 할당',
    'service-plan.ip.allocateExclusiveIp' => '전용 IP 주소 할당',
    'service-plan.ip.allocateExclusiveIpV4' => '전용 IPv4 주소 할당',
    'service-plan.ip.allocateExclusiveIpV6' => '전용 IPv6 주소 할당',

    'service-plan.mail.mailService' => '메일 서비스',
    'service-plan.mail.mailServiceDisabled' => '비활성화됨',
    'service-plan.mail.mailServiceDisabledIncoming' => '수신 이메일에 비활성화',
    'service-plan.mail.mailServiceDisabledHint' => 'Plesk가 도메인에 메일 서비스를 제공하지 않습니다.',
    'service-plan.mail.mailServiceDisabledIncomingHint' => '도메인이 메일을 발송할 수만 있으며, 발송 시 오직 Sendmail만 사용할 수 있습니다.',
    'service-plan.mail.mailServiceEnabled' => '활성화',
    'service-plan.mail.mailServiceEnabledHint' => '도메인이 메일을 발신 및 수신할 수 있습니다.',
    'service-plan.mail.mailServiceNotConfigured' => '구성되지 않음',
    'service-plan.mail.mailServiceNotConfiguredHint' => 'Plesk가 도메인에 메일 서비스를 제공하지 않습니다.',
    'service-plan.mail.webMail' => '웹 메일',
    'service-plan.mail.mailingLists' => '메일링 리스트 활성화',
    'service-plan.mail.mailToNonExistentUser' => '존재하지 않는 사용자에 대한 메일 정책',
    'service-plan.mail.mailToNonExistentUserBounce' => '메시지를 포함하여 바운스',
    'service-plan.mail.mailToNonExistentUserRedirect' => '주소로 전달',
    'service-plan.mail.mailToNonExistentUserReject' => '거부',
    'service-plan.mail.mailAutodiscovery' => '메일 자동 검색 활성화',
    'service-plan.mail.mailAutodiscoveryDescription' => '기술 자료에서 적용되는 <a href="%%link%%" target="_blank">방법 확인</a>',
    'service-plan.mail.bounceMessage' => '이 주소는 더 이상 메일을 수신하지 않습니다.',
    'service-plan.mail.mailToNonExistentUserexternalMailServer' => 'IP 주소를 사용하여 외부 메일 서버로 리디렉션',
    'service-plan.mail.webmailDisabled' => '%%webmail%% - 사용 안 함',

    'service-plan.misc.retainEnabled' => '다음에 대한 웹 및 트래픽 통계 유지',
    'service-plan.misc.logRotation' => '로그 순환',
    'service-plan.misc.logRotationCondition' => '로그 순환 조건',
    'service-plan.misc.logRotationBySize' => '크기 기준',
    'service-plan.misc.logRotationByTime' => '시간 기준',
    'service-plan.misc.logRotationDaily' => '매일',
    'service-plan.misc.logRotationWeekly' => '주간',
    'service-plan.misc.logRotationMonthly' => '월별',
    'service-plan.misc.logRotationSizeDescription' => '크기 값은 %%min%%~%%max%%KB 사이여야 합니다.',
    'service-plan.misc.maximumNumberOfFiles' => '로그 파일 최대 수',
    'service-plan.misc.compress' => '로그 파일 압축',
    'service-plan.misc.sendLogToEmail' => 'Plesk가 웹 및 FTP 서버의 로그 파일에서 데이터를 검색하면 이 주소에 로그를 이메일로 보내기',
    'service-plan.misc.kb' => 'KB',
    'service-plan.misc.months' => '월',
    'service-plan.misc.logRotationPeriodGreater' => '로그 회전 기간은 서버 전체의 제한값 %%max%%보다 길 수 없습니다.',

    'service-plan.performance.iisAppPoolAddonsHint' => '이 기능을 끄면 구독의 모든 웹 사이트가 구독의 전용 IIS 응용 프로그램 풀을 사용합니다.',

    'service-plan.permissions-subscription.permissionsTabDescription' => '구독에 제공되는 서비스 및 권한을 선택합니다.',
    'service-plan.permissions-subscription.showMorePermissions' => '더 많은 권한 표시',
    'service-plan.permissions-subscription.hideMorePermissions' => '더 적은 권한 표시',
    'service-plan.permissions-subscription.noShellManagement' => '허용되지 않음',
    'service-plan.permissions-subscription.systemAccessLabel' => 'SSH를 통한 서버 액세스 관리',
    'service-plan.permissions-subscription.systemAccessLabel_hint' => '시스템 사용자에 대한 SSH를 고객이 활성화할 수 있도록 허용합니다. 호스팅 매개 변수 "구독\\ 시스템 사용자의 서버 셸에 SSH 액세스"를 사전 설정으로 사용합니다.',

    'service-plan.permissions.permissionsTabDescription' => '계획과 함께 제공된 서비스 및 권한을 선택하십시오.',
    'service-plan.permissions.permissionsAddonTabDescription' => '이 추가 기능 플랜에서 구독에 추가할 서비스 및 권한을 선택합니다. 추가 기능에서 선택하지 않은 권한으로는 구독 매개 변수를 수정할 수 없습니다.',
    'service-plan.permissions.permissionsBehaviorDescription' => '권한을 통해 고객은 구독의 특정 설정을 변경할 수 있습니다. 구독이 생성되면 Plesk는 고객이 변경할 수 있는 설정에 계획의 사전 설정값을 적용합니다. 이후에 계획을 업데이트하거나 추가 계획을 적용해도 고객이 변경한 사항은 무시되지 않습니다.',
    'service-plan.permissions.showMorePermissions' => '더 많은 권한 표시',
    'service-plan.permissions.hideMorePermissions' => '더 적은 권한 표시',
    'service-plan.permissions.noShellManagement' => '허용되지 않음',
    'service-plan.permissions.systemAccessLabel' => 'SSH를 통한 서버 액세스 관리',
    'service-plan.permissions.systemAccessLabel_hint' => '호스팅 매개 변수 "구독 시스템 사용자의 서버 셸에 SSH 액세스"를 사전 설정으로 사용합니다.',

    'service-plan.resources-subscription.overusePolicy' => '초과 사용 정책',
    'service-plan.resources-subscription.overusePolicyNotAllowed' => '초과 사용이 허용되지 않습니다.',
    'service-plan.resources-subscription.overusePolicyNotAllowedHint' => '리소스의 초과 사용을 허용하지 않습니다. 리소스 사용량이 제한 값을 초과하면 구독이 자동으로 일시 중단됩니다.',
    'service-plan.resources-subscription.overusePolicySoftAllowed' => '디스크 공간과 트래픽의 초과 사용이 허용됩니다.',
    'service-plan.resources-subscription.overusePolicySoftAllowedHint' => '디스크 공간과 트래픽의 초과 사용을 허용합니다. 다른 리소스의 초과 사용을 허용하지 않습니다.',
    'service-plan.resources-subscription.overusePolicyAllowed' => '초과 사용이 허용됨(권장하지 않음)',
    'service-plan.resources-subscription.overusePolicyAllowedHint' => '구독자가 구독을 통해 처음에 제공된 것보다 많은 양의 리소스를 사용하도록 허용합니다.',
    'service-plan.resources-subscription.overuseNotify' => '초과 사용 시 이메일로 알림을 받겠습니다.',
    'service-plan.resources-subscription.oversellPolicy' => '초과 판매 정책',
    'service-plan.resources-subscription.oversellPolicyAllowed' => '초과 판매가 허용됩니다.',
    'service-plan.resources-subscription.oversellPolicyAllowedHint' => '초과 판매를 통해 리셀러는 구독을 통해 할당받은 것보다 많은 양의 리소스를 판매할 수 있습니다. 초과 판매가 허용된 경우, 리셀러는 초기 리소스 할당 대신 실제 리소스 사용에 따른 관리를 받습니다.',
    'service-plan.resources-subscription.oversellPolicyNotAllowed' => '초과 판매가 허용되지 않습니다.',
    'service-plan.resources-subscription.oversellPolicyNotAllowedHint' => '초과 판매가 허용되지 않는 경우, 리셀러는 해당 리소스의 실제 사용량에 관계 없이 처음에 구독을 통해 할당받은 양만큼만 리소스를 판매할 수 있습니다.',
    'service-plan.resources-subscription.mainGroupTitle' => '구독에 제공되는 리소스 사용량의 제한을 정의합니다.',
    'service-plan.resources-subscription.additionalGroupTitle' => '더 많은 사용 가능 리소스 표시',
    'service-plan.resources-subscription.hideMoreResources' => '더 적은 리소스 표시',

    'service-plan.resources.overusePolicy' => '초과 사용 정책',
    'service-plan.resources.overusePolicyNotAllowed' => '초과 사용이 허용되지 않습니다.',
    'service-plan.resources.overusePolicyNotAllowedHint' => '리소스의 초과 사용을 허용하지 않습니다. 리소스 사용량이 제한 값을 초과하면 구독이 자동으로 일시 중단됩니다.',
    'service-plan.resources.overusePolicySoftAllowed' => '디스크 공간과 트래픽의 초과 사용이 허용됩니다.',
    'service-plan.resources.overusePolicySoftAllowedHint' => '디스크 공간과 트래픽의 초과 사용을 허용합니다. 다른 리소스의 초과 사용을 허용하지 않습니다.',
    'service-plan.resources.overusePolicyAllowed' => '초과 사용이 허용됨(권장하지 않음)',
    'service-plan.resources.overusePolicyAllowedHint' => '고객이 플랜을 통해 처음에 제공된 것보다 많은 양의 리소스를 사용하도록 허용합니다.',
    'service-plan.resources.overuseNotify' => '초과 사용 시 이메일로 알림을 받겠습니다.',
    'service-plan.resources.oversellPolicy' => '초과 판매 정책',
    'service-plan.resources.oversellPolicyAllowed' => '초과 판매가 허용됩니다.',
    'service-plan.resources.oversellPolicyAllowedHint' => '초과 판매를 통해 리셀러는 플랜에 의해 자신에게 할당된 리소스보다 많은 리소스를 판매할 수 있습니다. 초과 판매가 허용된 경우, 리셀러는 초기 리소스 할당 대신 실제 리소스 사용에 따른 관리를 받습니다.',
    'service-plan.resources.oversellPolicyNotAllowed' => '초과 판매가 허용되지 않습니다.',
    'service-plan.resources.oversellPolicyNotAllowedHint' => '초과 판매가 허용되지 않는 경우, 리셀러는 실제로 이러한 리소스의 사용량에 관계 없이 처음에 플랜에 의해 자신에게 할당된 리소스만큼만 판매할 수 있습니다.',
    'service-plan.resources.mainGroupTitle' => '플랜에 제공되는 리소스를 정의합니다.',
    'service-plan.resources.additionalGroupTitle' => '더 많은 사용 가능 리소스 표시',
    'service-plan.resources.hideMoreResources' => '더 적은 리소스 표시',
    'service-plan.resources.allowSitebuilderUpsell' => '고객이 평가판 Web Presence Builder 웹 사이트를 만들도록 허용합니다.',
    'service-plan.resources.allowSitebuilderUpsellDescription' => '이 설정을 통해 고객이 서비스 플랜에서 제공한 것보다 많은 양의 Presence Builder 웹 사이트를 만들도록 허용합니다. 고객은 이러한 웹 사이트를 게시하려면 웹 사이트를 구입해야 합니다.',

    'service-plan.servicePlanName' => '서비스 플랜 이름',
    'service-plan.resellerPlanName' => '리셀러 플랜 이름',
    'service-plan.addonPlanName' => '추가 기능 플랜 이름',
    'service-plan.adminPlanPermissionsTab' => '관리자 도구',
    'service-plan.adminPlanPermissionsTabDescription' => '제한 모드가 활성화된 경우 관리자가 사용할 수 있는 기능을 선택합니다.',
    'service-plan.hostingPermissionsTab' => '호스팅 도구',
    'service-plan.hostingPermissionsTabDescription' => '제한 모드가 활성화된 경우 관리자가 사용할 수 있는 웹 호스팅 도구 및 설정을 선택합니다.',
    'service-plan.resourcesTab' => '리소스',
    'service-plan.resourcesTabDescription' => '플랜에 제공되는 리소스와 리소스 사용량에 대한 정책을 정의합니다.',
    'service-plan.subscriptionResourcesTabDescription' => '구독에 제공되는 리소스와 리소스 사용량에 대한 정책을 정의합니다.',
    'service-plan.hostingTab' => '호스팅 매개 변수',
    'service-plan.hostingTabDescription' => '플랜에 제공되는 호스팅 서비스의 매개 변수를 지정합니다. 추가 기능 플랜에 지정된 호스팅 설정은 서비스 플랜 또는 추가 기능 플랜에 의해 "호스팅 설정 관리" 권한이 부여된 구독에는 적용되지 않습니다.',
    'service-plan.secureSettingsDescription' => '제공되는 호스팅의 보안을 극대화하려면 %%link%%합니다. 부여된 일부 권한을 통해 구독자가 이러한 설정을 변경할 수 있습니다. %%helpLink%%.',
    'service-plan.secureSettingsLink' => '적용 보안 설정 사전 설정',
    'service-plan.secureSettingsHelpLink' => '보안 호스팅 설정에 대해 알아보기',
    'service-plan.mailTab' => '메일',
    'service-plan.mailTabDescription' => '플랜에 제공되는 메일 서비스의 매개 변수를 지정합니다.',
    'service-plan.dnsTab' => 'DNS',
    'service-plan.dnsTabDescription' => '플랜에 제공되는 DNS 서비스의 매개 변수를 지정합니다.',
    'service-plan.performanceTab' => '성능',
    'service-plan.performanceTabDescription' => '플랜에 제공되는 모든 서비스의 성능에 영향을 미치는 시스템 매개 변수를 지정합니다.',
    'service-plan.permissionsTab' => '권한',
    'service-plan.miscTab' => '로그 및 통계',
    'service-plan.miscTabDescription' => '플랜 구독의 통계 및 로그 저장 방법을 지정합니다. 이러한 설정은 구독에서 동기화되지 않습니다.',
    'service-plan.miscTabAdminPlanDescription' => '구독의 통계 및 로그 저장 방법을 지정합니다.',
    'service-plan.extrasTab' => '추가 서비스',
    'service-plan.extrasTabDescription' => '웹 호스팅, DNS 및 메일 서비스와 함께 플랜에 포함할 서비스를 선택합니다.',
    'service-plan.ipTab' => 'IP 주소',
    'service-plan.ipTabDescription' => '플랜에 제공되는 IP 리소스의 매개 변수를 정의합니다.',
    'service-plan.applicationsTab' => '응용 프로그램',
    'service-plan.applicationsTabDescription' => '플랜에 제공할 응용 프로그램을 선택합니다. 서버에 업로드한 응용 프로그램 외에도 응용 프로그램 카탈로그에 있는 모든 응용 프로그램을 제공할 수 있으며, 응용 프로그램을 수동으로 선택할 수도 있습니다. 사용 가능한 모든 응용 프로그램을 제공하려는 경우, 이 탭에서 아무 작업도 할 필요가 없으며 간단히 ‘권한’ 탭으로 이동하여 ‘응용 프로그램 카탈로그에 액세스’ 옵션을 선택하면 됩니다. 응용 프로그램을 수동으로 선택하려면 이 탭에서 하면 됩니다.',
    'service-plan.applicationsTabDescription-addon' => '추가 기능에서 사용할 응용 프로그램을 선택하십시오.',
    'service-plan.applicationsTabDescription-subscription' => '구독에 제공할 응용 프로그램을 선택합니다. 서버에 업로드한 응용 프로그램 외에도 응용 프로그램 카탈로그에 있는 모든 응용 프로그램을 제공할 수 있으며, 응용 프로그램을 수동으로 선택할 수도 있습니다. 사용 가능한 모든 응용 프로그램을 제공하려는 경우, 이 탭에서 아무 작업도 할 필요가 없으며 간단히 ‘권한’ 탭으로 이동하여 ‘응용 프로그램 카탈로그에 액세스’ 옵션을 선택하면 됩니다. 응용 프로그램을 수동으로 선택하려면 이 탭에서 하면 됩니다.',
    'service-plan.planSyncSubsriptionWarning' => '일부 구독이 플랜과 동기화되지 않았습니다. 해당 구독이 구독 목록에 \'Unsynced\'로 표시됩니다. 동기화를 다시 시도하려면 구독 개요 페이지로 이동한 후 동기화 버튼을 클릭합니다.',
    'service-plan.planSyncResellerWarning' => '일부 리셀러가 플랜과 동기화되지 않았습니다. 해당 리셀러가 리셀러 목록에 \'Unsynced\'로 표시됩니다. 동기화를 다시 시도하려면 리셀러 개요 페이지로 이동한 후 동기화 버튼을 클릭합니다.',
    'service-plan.planSyncAdminWarning' => '이러한 변경 사항에 영향을 받는 서비스 또는 리소스 중 일부를 Plesk에서 제공하지 않기 때문에 변경 사항을 구독에 적용할 수 없습니다. 이유: %%reason%%',
    'service-plan.duplicateName' => '해당 이름을 가진 플랜이 이미 있습니다.',
    'service-plan.phpSettingsTab' => 'PHP 설정',
    'service-plan.phpHandlerNotFound' => '플랜의 PHP 버전에 대한 정보를 가져올 수 없습니다. 다시 설치하거나 서비스 플랜에 사용할 다른 PHP 버전을 선택하십시오.',
    'service-plan.phpHandlerNotRegistered' => "%%fullVersion%% PHP 버전이 설치되지 않았습니다. 해당 서비스 플랜을 사용하는 도메인의 PHP 스크립트를 이용할 수 없습니다. <nobr>%%fullVersion%% PHP 버전</nobr> 또는 서비스 플랜에 사용할 다른 PHP 버전을 선택하십시오.",

    'service-plan.phpSettingsTabDescription' => '여기서 서버 전체 php.ini 파일에 정의된 설정을 무시하는 구독별 PHP 설정을 지정할 수 있습니다. 이는 예를 들어 고객의 PHP 스크립의 시스템 리소스 사용을 제한하려는 경우에 유용할 수 있습니다. 고객(허용된 경우)이 자신의 도메인별 구성으로 이 PHP 구성을 무시할 수 있습니다. 매개 변수를 기본값으로 설정하면 PHP가 서버 전체 PHP 구성의 매개 변수 값을 사용합니다. 다음 자리 표시자가 지원됩니다. {DOCROOT} 및 {WEBSPACEROOT}는 도메인의 문서 루트 디렉터리 및 사용자 지정 PHP 구성을 가져오는 구독의 루트 디렉터리를 의미하고, {TMP}는 임시 파일을 저장하는 디렉터리를 의미합니다.',
    'service-plan.phpSettingsTabDescriptionAddon' => '여기서 주 서비스 플랜에 정의된 설정을 무시하는 구독별 PHP 설정을 지정할 수 있습니다. 이는 예를 들어 주 서비스 플랜에 설정된 일부 PHP 제한을 제거하려는 경우에 유용할 수 있습니다. 매개 변수를 기본값으로 설정하면 PHP가 서비스 플랜 PHP 구성의 매개 변수 값을 사용합니다. 다음 자리 표시자가 지원됩니다. {DOCROOT} 및 {WEBSPACEROOT}는 도메인의 문서 루트 디렉터리 및 사용자 지정 PHP 구성을 가져오는 구독의 루트 디렉터리를 의미하고, {TMP}는 임시 파일을 저장하는 디렉터리를 의미합니다.',
    'service-plan.phpSettingsPhpVersion' => '귀하의 현재 PHP 버전은 %%version%%입니다.',
    'service-plan.phpSettingsTabAdminPlanDescription' => '여기서 서버 전체 php.ini 파일에 정의된 설정을 무시하는 구독별 PHP 설정을 지정할 수 있습니다. 매개 변수를 기본값으로 설정하면 PHP가 서버 전체 PHP 구성의 매개 변수 값을 사용합니다.',
    'service-plan.webServerSettingsTab' => '웹 서버',
    'service-plan.webServerSettingsTabDescription' => '여기서 이 서비스 플랜에 대한 Apache 웹 서버 설정을 지정할 수 있습니다. Apache가 프런트 엔드 서버로 nginx를 이용하여 실행되는 경우, 이 페이지에서 nginx 설정도 지정할 수 있습니다. 새롭게 만들어지는 모든 도메인에 지정된 설정이 보내집니다. 그러나 이러한 설정을 변경하는 경우 기존 도메인에 변경 내용이 보내지지 않습니다.',
    'service-plan.servicesTab' => '서비스',
    'service-plan.servicesTabDescription' => '여기서 서비스 플랜에 할당된 서비스를 지정할 수 있습니다.',
    'service-plan.servicePropertiesTab' => '%%serviceName%% 속성',
    'service-plan.servicePropertiesTabDescription' => '여기서 서비스 플랜에 할당된 %%serviceName%% 서비스의 속성을 지정할 수 있습니다.',
    'service-plan.longTaskWarning' => '이 플랜에 %%subscriptionsCount%% 구독이 존재합니다. 동기화 작업에는 많은 시간이 필요할 수 있으며 배경에서 실행됩니다.',
    'service-plan.hostingParametersTab' => '호스팅 매개 변수',
    'service-plan.adminInfoSection' => '관리자를 위한 정보',
    'service-plan.descriptionInPanel' => '설명',
    'service-plan.longDescription' => '지정한 설명이 너무 깁니다.',
    'service-plan.conflictPermissions' => '리셀러 플랜과 충돌하므로 다음 권한을 부여할 수 없습니다: %%permissions%%.',

    'services.change-startup-type.startupTypeLabel' => '시작 유형',
    'services.change-startup-type.autoStartupTypeLabel' => '자동',
    'services.change-startup-type.manualStartupTypeLabel' => '수동',
    'services.change-startup-type.disabledStartupTypeLabel' => '끄기',
    'services.change-startup-type.autoActionError' => '시작 유형을 \'auto\'로 설정할 수 없음: %%error%%',
    'services.change-startup-type.manualActionError' => '시작 유형을 \'manual\'로 설정할 수 없음: %%error%%',
    'services.change-startup-type.disableActionError' => '시작 유형을 \'disabled\'로 설정할 수 없음: %%error%%',

    'sessions.settings.restoreDefaultButton' => '모두 기본값으로 재설정',
    'sessions.settings.restoreDefaultButtonDescription' => '세션 매개 변수를 기본값으로 복원합니다.',
    'sessions.settings.restoreDefaultButtonDescriptionDisable' => '세션 매개 변수가 기본값입니다.',
    'sessions.settings.idleTime' => '세션 유휴 시간',
    'sessions.settings.disableCheckSessionIp' => '한 세션 중 IP 주소 변경 허용',
    'sessions.settings.minuteShortTitle' => '최소',

    'settings-ui.controls.title' => '제어',

    'settings-ui.interface-views.description' => "다양한 제품 UI 보기가 제공됩니다. 사용 중인 보기에 따라 기능과 설정을 다른 곳에 위치하거나 활성화/비활성화할 수도 있습니다. 다양한 유형의 사용자에 맞도록 서로 다른 보기를 조정할 수 있습니다.",
    'settings-ui.interface-views.panelSimpleLink' => '도구 & 설정> 제한 모드 설정',
    'settings-ui.interface-views.useCustomView' => '제한 모드 활성화',
    'settings-ui.interface-views.useCustomViewHint' => '관리자가 Plesk Panel에서 수행할 수 있는 작업 수를 제한하려면 이 옵션을 선택하십시오. 작업 사용 가능 여부를 변경하려면 %%customViewSettingsLink%%(으)로 이동하십시오.',
    'settings-ui.interface-views.powerUserViewHint' => '이 보기는 웹사이트 및 웹사이트의 파일, 데이터페이스, 이메일 계정, 웹 애플리케이션, 기타 서비스를 관리하는 데 적합합니다.',
    'settings-ui.interface-views.selectUiModeTitle' => "인터페이스 선택",
    'settings-ui.interface-views.uiModeTitlePowerUser' => "고급 사용자 보기(개발자 및 웹 에이전시용)",
    'settings-ui.interface-views.uiModeTitleServiceProvider' => "서비스 제공자 보기(웹 호스팅 제공자용)",
    'settings-ui.interface-views.uiModeHintServiceProvider' => '이 보기는 서비스 요금제로 고객에게 웹 호스팅 서비스를 제공 또는 판매하는 서버 관리자를 대상으로 합니다.',
    'settings-ui.interface-views.visibilityMailBounce' => '바운스 컨트롤 숨기기',
    'settings-ui.interface-views.visibilityMailBounceHint' => '존재하지 않는 이메일 주소로 보내진 메일의 처리 방식을 설정하는 버튼을 숨깁니다',

    'settings-ui.branding.description' => '브라우저의 제목 표시줄에 페이지가 표시되는 방식을 변경하거나 왼쪽 상단 모서리에 Plesk 로고를 대체해서 Plesk 인터페이스를 브랜딩합니다.',
    'settings-ui.branding.buttonDefault' => '기본 로고',
    'settings-ui.branding.sectionTitle' => '사용자 지정 제목',
    'settings-ui.branding.enableCustomTitle' => 'Plesk 페이지에서 사용자 지정 제목 활성화',
    'settings-ui.branding.customTitle' => '제목 텍스트',
    'settings-ui.branding.sectionLogo' => '사용자 지정 로고',
    'settings-ui.branding.enableCustomLogo' => '사용자 지정 패널 로고 활성화',
    'settings-ui.branding.logo' => '로고 파일',
    'settings-ui.branding.logoUrl' => '로고 URL',
    'settings-ui.branding.logoUrlEnabled' => '사용자 지정',
    'settings-ui.branding.logoUrlDisabled' => '기본값',
    'settings-ui.branding.sectionFavicon' => '사용자 지정 favicon',
    'settings-ui.branding.enableCustomFavicon' => '사용자 지정 favicon 활성화',
    'settings-ui.branding.sectionFaviconDesc' => '다양한 브라우저에서 더 원활하게 지원되도록 하려면 같은 favicon을 두 형식으로 모두 업로드해야 합니다.',
    'settings-ui.branding.faviconSvg' => 'Favicon 파일 SVG',
    'settings-ui.branding.faviconSvgHint' => '허용되는 형식: SVG',
    'settings-ui.branding.faviconIco' => 'Favicon 파일 ICO',
    'settings-ui.branding.faviconIcoHint' => '허용되는 형식: ICO',
    'settings-ui.branding.show' => '표시',
    'settings-ui.branding.updateSuccess' => 'Plesk 브랜딩 속성이 변경되었습니다.',

    'sitebuilder.trial.description' => '이 페이지에서 사용 후 구매 모드를 구성할 수 있습니다(이전의 고객 유치 시나리오). 이 모드에서 고객은 포함된 Presence Builder 응용 프로그램에 제공된 모든 기능을 사용하여 웹 사이트를 만들 수 있습니다. 단, 호스팅 서비스 플랜 또는 플랜 추가 기능을 구입할 때까지 고객은 평가판 웹 사이트를 게시할 수 없습니다. 사용 후 구매 모드를 호스팅 플랜 또는 플랜 추가 기능을 통해 기존 고객에게 제공할 수도 있습니다. %%link%%',
    'sitebuilder.trial.descriptionLink' => '자세한 내용은 문서를 참조하십시오.',
    'sitebuilder.trial.lifetimeLabel' => '평가판 웹 사이트 수명',
    'sitebuilder.trial.lifetimeUnits' => '일',
    'sitebuilder.trial.lifetimeDescription' => '이 시간이 지나면 고객이 구입하지 않은 평가판 웹 사이트가 서버에서 제거됩니다.',
    'sitebuilder.trial.signupLabel' => '평가 모드에 대한 공용 액세스 활성화',
    'sitebuilder.trial.signupDescription' => 'Presence Builder를 통한 호스팅을 광고하고 Presence Builder 데모를 고객에게 제공하여 고객을 유치하려면 평가 모드에 대한 공용 액세스를 활성화하고 평가 모드 액세스 URL을 웹 사이트에 게시합니다.',
    'sitebuilder.trial.signupLinkLabel' => '평가 모드 액세스 URL',
    'sitebuilder.trial.signupLinkDescription' => '이 URL을 클릭하면 Presence Builder가 평가 모드로 열립니다. 이 URL을 웹 사이트에 게시하여 Presence Builder를 통한 호스팅을 광고하고 고객을 유치합니다.',
    'sitebuilder.trial.promotionLabel' => 'Presence Builder 편집기에 평가 모드 알림 표시',
    'sitebuilder.trial.promotionDescription' => '평가 모드로 작동 중인 Presence Builder에 대한 추가 알림을 표시하려면 이 옵션을 사용합니다.',

    'update-settings.policyHintForPum' => '여기에서 업데이트 자동 설치를 설정할 수 있습니다. 업데이트의 수동 설치가 가능하거나 자동으로 설치되어 있는 경우 알림 이메일을 전송합니다.',
    'update-settings.policyHint' => '업데이트의 수동 설치가 가능하거나 자동으로 설치되어 있는 경우 알림 이메일을 전송합니다.',
    'update-settings.branchDisabledDescription' => '사용 가능한 업데이트에 대해 알리지 않음',
    'update-settings.automaticPatchesInstallation' => 'Plesk 업데이트 자동 설치(권장)',
    'update-settings.automaticPatchesThirdParty' => 'Plesk가 제공하는 타사 구성 요소에 대한 업데이트 자동 설치',
    'update-settings.automaticSystemPackageUpdates' => '시스템 패키지 업데이트 자동 설치',
    'update-settings.automaticSystemPackageUpdatesHint' => '이 작업을 실행하면 Plesk가 배송하는 타사 구성 요소에 대한 업데이트도 자동으로 설치된다는 점에 주의하십시오.',
    'update-settings.automaticPatchesNotification' => '사용 가능 또는 설치된 시스템 패키지 업데이트 알림',
    'update-settings.systemPackageUpdatesNotificationsEmail' => '이메일 주소',
    'update-settings.systemPackageUpdatesNotificationsPeriod' => '알림 이메일 빈도',
    'update-settings.daily' => '매일',
    'update-settings.weekly' => '매주',
    'update-settings.generalSection' => '일반',
    'update-settings.notificationsSection' => '알림',
    'update-settings.safeUpdatesSection' => '안전 업데이트',
    'update-settings.safeUpdatesSectionHint' => 'Plesk는 시스템 패키지 업데이트는 패키지가 설치된 곳과 동일한 리포지토리에 설치합니다. 이와 같이 설치된 업데이트는 안전하다고 간주됩니다. 안전 업데이트를 비활성화하면 시스템의 모든 리포지토리에서 시스템 패키지 관리자가 업데이트를 설치할 수 있습니다.',
    'update-settings.safeUpdatesSectionWarn' => '고급 사용자인 경우를 제외하고 안전 업데이트의 활성화를 유지하는 것이 좋습니다. 다른 리포지토리를 이용한 무분별한 시스템 패키지 업데이트는 서버 기능에 부정적인 영향을 미칠 수 있습니다.',
    'update-settings.allowSafeUpdates' => '시스템 패키지의 안전 업데이트 활성화',

    'requiredFields' => '필수 필드',
];