<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
$messages = [
    'additional-keys.keyNumber' => 'Nøglenummer',
    'additional-keys.keyName' => 'Nøglenavn',
    'additional-keys.keyApp' => 'Applikation',
    'additional-keys.addGroup' => 'Tilføj',
    'additional-keys.upload' => 'Installer ny nøgle',
    'additional-keys.uploadDescription' => 'Upload og installér en ny licensnøgle.',
    'additional-keys.actionsGroup' => 'Handlinger',
    'additional-keys.install' => 'Installer',
    'additional-keys.installAll' => 'Installér alt',
    'additional-keys.installDescription' => 'Installer valgte licensnøgler.',
    'additional-keys.installNoSelection' => 'Vælg en eller flere licensnøgler, der skal installeres, eller klik på "Installér alle".',
    'additional-keys.installSuccess' => 'Installation af licensnøgle er påbegyndt.',
    'additional-keys.removeGroup' => 'Fjern',
    'additional-keys.remove' => 'Fjern',
    'additional-keys.removeDescription' => 'Fjern de markerede licensnøgler.',
    'additional-keys.removeNoSelection' => 'Vælg en eller flere licensnøgler, der skal fjernes.',
    'additional-keys.removeConfirmation' => 'Fjern {count, plural, =1 {licensnøglen {name}} one {den # markerede licensnøgle} other {de # markerede licensnøgler}}?',
    'additional-keys.removeSuccess' => 'De valgte licensnøgler blev fjernet.',
    'additional-keys.download' => 'Download nøgle',
    'additional-keys.downloadDescription' => 'Download licensnøglen.',
    'additional-keys.emptyViewTitle' => 'Ingen yderligere licensnøgler',

    'backup.tasks.startDate' => 'Startet d.',
    'backup.tasks.targetRepo' => 'Mål-lagringsområde',
    'backup.tasks.progress' => 'Opgavestatus',
    'backup.tasks.repoTypeLocal' => 'Server',
    'backup.tasks.repoTypeFtp' => 'Personlig FTP',
    'backup.tasks.buttonRemoveTask' => 'Fjern',
    'backup.tasks.hintRemoveTask' => 'Fjern de valgte sikkerhedskopiopgaver.',
    'backup.tasks.buttonReload' => 'Indlæs igen',
    'backup.tasks.hintReload' => 'Genindlæs denne opgaveliste for at se den aktuelle status.',
    'backup.tasks.statusTaskWarnings' => 'Advarsler',
    'backup.tasks.statusTaskInfo' => 'Information',
    'backup.tasks.statusTaskFailed' => 'Mislykkedes',

    'backup.disabledSelectHint' => 'Sikkerhedskopien kan ikke fjernes, da den er en del af en server-, forhandler- eller kunde- sikkerhedskopi.',
    'backup.buttonBackup' => 'Sikkerhedskopier',
    'backup.hintBackup' => 'Opret en sikkerhedskopi',
    'backup.buttonSchedule' => 'Planlægning',
    'backup.hintSchedule' => 'Angiv indstillinger for planlagt sikkerhedskopiering.',
    'backup.buttonReload' => 'Indlæs igen',
    'backup.hintReload' => 'Genindlæs sikkerhedskopilisten.',
    'backup.buttonUpload' => 'Overfør',
    'backup.hintUpload' => 'Upload en sikkerhedskopifil fra din computer til serverens sikkerhedskopi-opbevaringsområde.',
    'backup.buttonSettings' => 'Indstillinger',
    'backup.hintSettings' => 'Konfigurér de globale data-sikkerhedskopieringsindstillinger for at reducere serverens CPU-belastning.',
    'backup.buttonRemoteStorages' => 'Eksternt opbevaringsområde indstillinger',
    'backup.hintRemoteStorages' => 'Konfigurer din personlige eksterne lagring til opbevaring af sikkerhedskopifiler.',
    'backup.buttonRemove' => 'Fjern',
    'backup.hintRemove' => 'Fjern de valgte sikkerhedskopifiler fra server-opbevaringsområdet.',
    'backup.systemNotes' => 'Systemnoter',
    'backup.incremental' => 'Stigende.',
    'backup.multiVolume' => 'Multi-volumen.',
    'backup.remoteStorage' => 'I lagringsområdet : %%storage%%.',
    'backup.status' => 'S',
    'backup.statusOff' => 'Dette er ikke en gyldig sikkerhedskopi. Data kan ikke gendannes fra denne fil. Klik på sikkerhedskopiens navn for at få flere oplysninger.',
    'backup.statusWarning' => 'Denne sikkerhedskopi er ikke helt gyldig. Klik på sikkerhedskopiens navn for at få flere oplysninger.',
    'backup.statusInfo' => 'Dette er en gyldig sikkerhedskopi. Data kan gendannes fra denne sikkerhedskopi, men der kan opstå mindre problemer med måden, som dataene er lagret på.',
    'backup.statusOn' => 'Dette er en gyldig sikkerhedskopi. Data kan gendannes fra denne fil.',
    'backup.date' => 'Oprettelsesdato',
    'backup.name' => 'Navn',
    'backup.comment' => 'Kommentarer',
    'backup.size' => 'Størrelse',
    'backup.download' => 'Download sikkerhedskopifilen til din lokale computer.',
    'backup.downloadDisabled' => 'Download af sikkerhedskopifilen er midlertidigt utilgængelig. Forsøg igen, eller kontakt sin serviceudbyder.',
    'backup.total' => 'Totalt antal sikkerhedskopier: %%total%%, størrelse: %%totalSize%%',
    'backup.totalFound' => '%%found%% sikkerhedskopier fundet (%%total%% total), størrelse: %%totalSize%%',
    'backup.confirmOnDelete' => 'Vil du virkelig fjerne de valgte sikkerhedskopier?',
    'backup.incrementsRemovalLoading' => 'Indlæser…',
    'backup.incrementsRemovalConfirmation' => 'Jeg bekræfter, at jeg vil fjerne de valgte sikkerhedskopier.',
    'backup.backupHasIncrements' => 'Sikkerhedskopien %%backupName%% vil blive fjernet sammen med dens stigende versioner: %%backupIncrements%%',
    'backup.ftpStorage' => 'FTP',
    'backup.ftpStorageErrorCredentials' => 'Forkert brugernavn eller adgangskode til FTP-lagring',
    'backup.ftpStorageErrorResolveHost' => "Kan ikke fortolke hostnavnet",
    'backup.ftpStorageErrorConnection' => "Kan ikke oprette forbindelse til den eksterne server",
    'backup.unableToGetFtpDumpList' => 'Kan ikke vise listen med sikkerhedskopier fra FTP Storage%%errorMessage%%. Kontroller <a href="%%ftpSettingsUrl%%">FTP lagringsindstillinger </a>.',
    'backup.unableToGetExtDumpList' => 'Kunne ikke vise listen over backups i lagret %%storageTitle%%: %%errorMessage%%. Kontrollér opbevaringsindstillingerne.',
    'backup.unableToGetLocalDumpList' => 'Kan ikke vise listen med sikkerhedskopier, gemt på serveren: %%errorMessage%%.',
    'backup.skippedFilesAtExtStorage' => 'Nogle af filerne i opbevaringsområdet %%storageTitle%% vises ikke i listen, fordi navnene på disse filer ikke overholder navngivningsstandarderne for sikkerhedskopifiler. Hvis du er sikker på, at disse filer er gyldige sikkerhedskopier, kan du omdøbe dem, så de matcher følgende mønster: "backup_%%objectName%%&lt;YYMMDDHHmm&gt;.%%ext%%"',
    'backup.multiVolumeShow' => 'Vis volumener',
    'backup.multiVolumeHide' => 'Skjul volumener',
    'backup.backEncryptionRequired' => 'Af sikkerhedsgrunde anbefales det, at du beskytter følsomme data i sikkerhedskopier. Gå til to %%link%% og opdatér sikkerhedsindstillingerne for sikkerhedskopier.',
    'backup.backupSettingPage' => 'Indstillinger for sikkerhedskopiering',
    'backup.statusTaskProgress' => 'Sikkerhedskopieringsopgaven er i gang.',
    'backup.statusTaskWarnings' => 'Sikkerhedskopieringsopgaven blev afsluttet med advarsler.',
    'backup.statusTaskInfo' => 'Information.',
    'backup.statusTaskFailed' => 'Sikkerhedskopieringsopgaven mislykkedes.',
    'backup.statusTaskStopping' => 'Sikkerhedskopieringsopgaven standser.',
    'backup.statusTaskStopped' => 'Sikkerhedskopiopgaven blev standset.',

    'backup.schedule.columnSchedule' => 'Planlægning',
    'backup.schedule.columnContent' => 'Indhold',
    'backup.schedule.columnStorage' => 'Lager',
    'backup.schedule.periodHourly' => 'Hver time',
    'backup.schedule.periodHourlySchedule' => '(hver {period, plural, one {# time} other {# timer}})',
    'backup.schedule.periodDaily' => 'Dagligt',
    'backup.schedule.periodDailySchedule' => '(klokken %%hours%%:%%minutes%%)',
    'backup.schedule.periodWeekly' => 'Hver uge',
    'backup.schedule.periodWeeklySchedule' => '(på %%day%% klokken %%hours%%:%%minutes%%)',
    'backup.schedule.periodMonthly' => 'Hver måned',
    'backup.schedule.periodMonthlySchedule' => '(på %%day%% ved dagtid, klokken %%hours%%:%%minutes%%)',
    'backup.schedule.periodCustom' => 'Valgfri',
    'backup.schedule.dayFirst' => 'første',
    'backup.schedule.dayLast' => 'sidste',
    'backup.schedule.day' => '{day, selectordinal, other {#.}}',
    'backup.schedule.storageLocal' => 'Server-opbevaringsområde',
    'backup.schedule.storageBoth' => 'Både serverlagring og %%remoteStorage%%',
    'backup.schedule.deactivateSuccess' => 'Planlagt sikkerhedskopiering blev deaktiveret',

    'custombuttons.buttonAdd' => 'Indsæt link til service',
    'custombuttons.buttonAddDescription' => 'Tilføj et link til en online service og indsæt den i Plesk.',
    'custombuttons.buttonRemove' => 'Fjern',
    'custombuttons.buttonRemoveDescription' => 'Slet de markerede links.',
    'custombuttons.removeConfirmMessage' => 'Vil du fjerne de valgte links?',
    'custombuttons.headerPublic' => 'A',
    'custombuttons.headerLocation' => 'L',
    'custombuttons.headerImage' => 'Billede',
    'custombuttons.headerPriority' => 'Prioritet',
    'custombuttons.headerLabel' => 'Mærke',
    'custombuttons.headerUrl' => 'URL',
    'custombuttons.headerDescription' => 'Beskrivelse',
    'custombuttons.publicEnabledDescription' => 'Linket er synligt for brugerne.',
    'custombuttons.publicDisabledDescription' => 'Linket er ikke synligt for brugerne.',
    'custombuttons.altPublicEnabledIcon' => 'Offentlig',
    'custombuttons.altPublicDisabledIcon' => 'Privat',
    'custombuttons.placeNavigationDescription' => 'Linket er placeret på alle sider.',
    'custombuttons.placeAdminDescription' => 'Linket er placeret på administratorens hjemmeside.',
    'custombuttons.placeAdminSettingsDescription' => 'Linket er placeret på administratorens Funktioner og indstillinger side.',
    'custombuttons.placeResellerDescription' => 'Linket er placeret på forhandlerens hjemmeside.',
    'custombuttons.placeResellerSettingsDescription' => 'Linket er placeret på forhandlerens Funktioner og indstillinger side.',
    'custombuttons.placeClientDescription' => 'Linket er placeret på kundens hjemmeside.',
    'custombuttons.placeDomainDescription' => 'Linket er placeret på abonnementets Websteder og domæner side.',
    'custombuttons.placeDomainPropertiesDescription' => 'Linket er placeret i området med webstedsværktøjer, der åbnes på siden Websteder og domæner, ved at klikke på Vis mere under et domænenavn.',

    'databaseservers.addGroup' => 'Tilføj',
    'databaseservers.addDatabaseServer' => 'Tilføj databaseserver',
    'databaseservers.addDatabaseServerDescription' => 'Tilføj en databaseserver.',
    'databaseservers.addDatabaseServerDescriptionDisabledByKey' => 'Ekstern databasehosting understøttes ikke af licensnøglen.',
    'databaseservers.actionsGroup' => 'Aktioner',
    'databaseservers.hostingSettings' => 'Indstillinger',
    'databaseservers.hostingSettingsDescription' => 'Database-hosting indstillinger',
    'databaseservers.refresh' => 'Opdater',
    'databaseservers.refreshDescription' => 'Genindlæs information om databaseservere.',
    'databaseservers.removeGroup' => 'Fjern',
    'databaseservers.remove' => 'Fjern',
    'databaseservers.removeDescription' => 'Slet markerede databaseservere.',
    'databaseservers.lastError' => 'S',
    'databaseservers.type' => 'Servertype',
    'databaseservers.host' => 'Værtsnavn',
    'databaseservers.hostLink' => 'Vis eller redigér databaseserverens egenskaber.',
    'databaseservers.port' => 'Port',
    'databaseservers.version' => 'Version',
    'databaseservers.databasesCount' => 'Databaser',
    'databaseservers.databasesCountLink' => 'Administrér databaser på denne server.',
    'databaseservers.webadmin' => 'Webadmin',
    'databaseservers.webadminHint' => 'Få adgang til denne server via DB Webadmin.',
    'databaseservers.downloadMsSqlClient' => 'Download en lokal SQL-klient',
    'databaseservers.downloadMsSqlClientHint' => 'Download en lokal SQL-klient',
    'databaseservers.changePassword' => 'Skift administrators adgangskode',
    'databaseservers.changePasswordHint' => 'Redigér adgangskoden for databaseserver-administratoren.',
    'databaseservers.mysql' => 'MySQL',
    'databaseservers.mssql' => 'Microsoft SQL Server',
    'databaseservers.postgresql' => 'PostgreSQL',
    'databaseservers.mariadb' => 'MariaDB',
    'databaseservers.percona' => 'Percona',
    'databaseservers.default_for_mysql' => 'standard for MySQL',
    'databaseservers.default_for_mssql' => 'standard for MS SQL',
    'databaseservers.default_for_postgresql' => 'standard for PostgreSQL',
    'databaseservers.default_for_mariadb' => 'standard for MariaDB',
    'databaseservers.default_for_percona' => 'standard for Percona',
    'databaseservers.status_no_error' => 'Det seneste forsøg på at skabe forbindelse til denne server lykkedes.',
    'databaseservers.status_connection_failed' => 'Det seneste forsøg på at skabe forbindelse til denne server mislykkedes på grund af netværksproblemer.',
    'databaseservers.status_permission_denied' => 'Under det seneste forsøg på at skabe forbindelse til denne server blev adgang nægtet. Kontrollér administrator-akkreditiverne for serveren.',
    'databaseservers.status_other_error' => 'Under det seneste forsøg på at skabe forbindelse til denne server opstod der en fejl.',
    'databaseservers.status_credentials_not_set' => 'Du skal angive et gyldigt administrator-brugernavn og adgangskode inden Plesk kan etablere forbindelse til denne server.',
    'databaseservers.mssqlServerPortUndefined' => 'Kan ikke bestemme det TCP-portnummer, der bruges af Microsoft SQL-serveren \'%%host%%\': TCP/IP-protokollen er ikke aktiveret i servernetværkskonfigurationen, eller serveren er konfigureret til at bruge dynamiske TCP-porte.',
    'databaseservers.mssqlServerPortUndefinedHint' => 'Hvis du vil give dine kunder mulighed for automatisk at konfigurere en firewall til ekstern databaseadgang, skal du manuelt konfigurere SQL-serveren til at lytte på en angiven fast TCP-port.',
    'databaseservers.removeEmptySelection' => 'ingen databaseservere valgt.',
    'databaseservers.removeConfirmation' => 'Er du sikker på, at du vil fjerne {count, plural, =1 {databaseserveren {name}} one {den # markerede databaseserver} other {de # markerede databaseservere}}?',
    'databaseservers.removeSuccess' => 'De valgte databaseservere blev fjernet.',

    'databaseserverdatabases.actionsGroup' => 'Aktioner',
    'databaseserverdatabases.assignToSubscription' => 'Flyt til abonnement',
    'databaseserverdatabases.assignToSubscriptionDescription' => 'Flyt de valgte databaser til et andet abonnement.',
    'databaseserverdatabases.removeGroup' => 'Fjern',
    'databaseserverdatabases.remove' => 'Fjern',
    'databaseserverdatabases.removeDescription' => 'Slet den markerede database.',
    'databaseserverdatabases.name' => 'Navn',
    'databaseserverdatabases.subscription' => 'Abonnement',
    'databaseserverdatabases.client' => 'Abonnent',
    'databaseserverdatabases.manageDatabase' => 'Administrér hosting',
    'databaseserverdatabases.manageDatabaseDescription' => 'Administrer databasen.',
    'databaseserverdatabases.manageDatabaseInResellerPanel' => 'Åbn i forhandlerpanelet',
    'databaseserverdatabases.manageDatabaseInResellerPanelDescription' => 'Administrer database i abonnentens forhandlerpanel.',
    'databaseserverdatabases.manageDatabaseInCustomerPanel' => 'Åbn i Kundepanel',
    'databaseserverdatabases.manageDatabaseInCustomerPanelDescription' => 'Administrer database i abonnentens Kundepanel.',
    'databaseserverdatabases.emptySelection' => 'Ingen databaser valgt.',
    'databaseserverdatabases.removeConfirmation' => 'Er du sikker på, at du vil fjerne {count, plural, =1 {databasen {name}} one {den # markerede database} other {de # markerede databaser}}?',
    'databaseserverdatabases.removeSuccess' => 'De valgte databaseservere blev fjernet.',

    'logbrowser.issuesFoundInTheLogs' => 'Problemer i webstedets logfiler',
    'logbrowser.learnAboutProblemsFaster' => 'Bliv hurtigere opmærksom på webstedsproblemer',
    'logbrowser.noProblemsFound' => 'Der er ingen problemer i webstedets logfiler',
    'logbrowser.lastCheckDetectsProblems' => '%%checkType%%-kontrol af logfilerne har registreret problemer, der kan påvirke driften af dit websted. Klik på "Åbn kontrolrapport" for at se en detaljeret oversigt med mulige løsninger.',
    'logbrowser.lastCheckDetectsNoProblems' => '%%checkType%%-kontrollen af logfilen har ikke registreret nogen problemer, der kan påvirke driften af dit websted.',
    'logbrowser.noChecksResults' => 'Automatisk daglig kontrol er aktiveret, men der blev ikke foretaget nogen kontrol.',
    'logbrowser.manual' => 'En manuel',
    'logbrowser.regular' => 'En automatisk daglig',
    'logbrowser.enableRegularCheck' => 'En daglig kontrol af logfilerne registrerer problemer, der kan påvirke driften af dit websted. Hvis der opstår problemer, vil Plesk give dig besked og foreslå mulige løsninger.',
    'logbrowser.new' => 'NY',
    'logbrowser.openCheckReport' => 'Åbn kontrolrapport',
    'logbrowser.openCheckSettings' => 'Åbn kontrolindstillinger',

    'logbrowser.buttonStartRealtime' => 'Start realtime-opdateringer',
    'logbrowser.buttonStartRealtimeHint' => 'Stop realtime opdatering af logdata.',
    'logbrowser.buttonStopRealtime' => 'Stop realtime-opdateringer',
    'logbrowser.buttonStopRealtimeHint' => 'Stop realtime opdatering af logdata.',
    'logbrowser.buttonRefresh' => 'Opdater',
    'logbrowser.buttonRefreshHint' => 'Genopfrisk logdata.',
    'logbrowser.buttonClear' => 'Ryd',
    'logbrowser.buttonClearHint' => 'Skjul allerede indlæste poster.',
    'logbrowser.buttonAddCustom' => 'Føj til Log Browser som brugerdefineret fil',
    'logbrowser.buttonAddCustomHint' => 'Filen bliver vist i Log Browser sammen med de øvrige logfiler.',
    'logbrowser.date' => 'Dato',
    'logbrowser.dateFilterPlaceholder' => 'Fra',
    'logbrowser.type' => 'Type',
    'logbrowser.ip' => 'IP',
    'logbrowser.ipFilterPlaceholder' => 'IP',
    'logbrowser.code' => 'Kode',
    'logbrowser.codeFilterPlaceholder' => 'Kode',
    'logbrowser.message' => 'Besked',
    'logbrowser.messageFilterPlaceholder' => 'Besked',
    'logbrowser.source' => 'Kilde',
    'logbrowser.sourceFilterFiles' => '%%count%% filer',
    'logbrowser.sourceFilterAllLogs' => 'Alle logge',
    'logbrowser.sourceFilterNoLogs' => 'Ingen logge',
    'logbrowser.manageLogFiles' => 'Administrér logfiler',
    'logbrowser.addCustomLogFile' => 'Tilføj brugerdefineret log',
    'logbrowser.customLogPopupTitle' => 'Tilføj brugerdefineret log',
    'logbrowser.invalidLogFormat' => 'Logfilens format er ikke understøttet.',
    'logbrowser.referer' => 'R',
    'logbrowser.refererHint' => 'Henviser',
    'logbrowser.agent' => 'Agent',
    'logbrowser.agentHint' => 'Brugeragent',
    'logbrowser.size' => 'Størrelse',
    'logbrowser.unknown' => 'Ukendt',
    'logbrowser.more' => 'Mere',
    'logbrowser.less' => 'Mindre',
    'logbrowser.any' => 'Alle',
    'logbrowser.none' => 'Ingen',
    'logbrowser.loadMoreOrUseFilters' => '%%loadMore%% eller brug filtre for at indsnævre antallet af poster.',
    'logbrowser.loadMore' => 'Indlæs tidligere poster',
    'logbrowser.clear' => 'Ryd',
    'logbrowser.hourAgo' => 'Time siden',
    'logbrowser.prevDay' => 'Forr. dag',
    'logbrowser.linkInMessageToViewFile' => 'Klik for at se logfilen.',
    'logbrowser.buttonUnlinkHint' => 'Klik, for at stoppe sporingen af opdateringer af denne fil i Log Browser',
    'logbrowser.buttonUnlinkConfirmationDescription' => 'Er du helt sikker på, at du vil stoppe sporingen af opdateringer af denne fil i Log Browser?',
    'logbrowser.buttonUnlinkConfirmationYes' => 'Ja',
    'logbrowser.buttonUnlinkConfirmationNo' => 'Nej',
    'logbrowser.logRotation' => 'Log-rotation',
    'logbrowser.logRotationHint' => 'Opsæt logrotationsindstillinger for websted.',
    'logbrowser.logRotationTitle' => 'Konfigurér logrotation',

    'notifications.title' => 'Opsætning af afsendelse af e-mail advisering om systemhændelser',
    'notifications.legendNotifications' => 'Notificeringer',
    'notifications.legendSettings' => 'Indstillinger',
    'notifications.headerEvent' => 'Hændelse',
    'notifications.headerSendTo' => 'Send advisering til:',
    'notifications.headerText' => 'Tekst',
    'notifications.headerPreview' => 'Forhåndsvisning',
    'notifications.headerAdmin' => 'Administrator',
    'notifications.headerReseller' => 'Forhandler',
    'notifications.headerClient' => 'Kunder',
    'notifications.headerEmailAddress' => 'E-mailadresse',
    'notifications.expirationTime' => 'Send udløbsadvarsler',
    'notifications.days' => 'dage forud',
    'notifications.smtpSettings' => 'For at aktiveret, at Plesk kan sende adviseringer når relæet er lukket, kan du %%link%%',
    'notifications.smtpSettingsLink' => 'Skift SMTP-indstillinger',
    'notifications.editHint' => 'Rediger adviseringstekst',
    'notifications.previewHint' => 'Se hvordan adviseringen ser ud i emails.',
    'notifications.reseller_creation' => 'Forhandlerkontooprettelse',
    'notifications.reseller_limits_exceed' => 'Ressourceforbrugsgrænser overskredet af forhandlerkonto',
    'notifications.reseller_blocked' => 'Forhandlerkonto suspenderet på grund af overforbrug af ressourcer',
    'notifications.reseller_overuse_block' => 'Forhandlerens ressourceforbrugsgrænser nået af forhandlerens abonnementer på grund af oversalg',
    'notifications.client_creation' => 'Oprettelse af kundekonto',
    'notifications.domain_creation' => 'Oprettelse af websted',
    'notifications.domain_exp_warning' => 'Abonnementsudløbsadvarsel',
    'notifications.domain_expiration' => 'Abonnementsudløb',
    'notifications.domain_limits_exceed' => 'Ressourceforbrugsgrænser overskredet af abonnementet',
    'notifications.domain_blocked' => 'Abonnement suspenderet på grund af overforbrug af ressourcer',
    'notifications.admin_aps_app_updates' => 'APS-programopdateringer (administrator\' nyhedsbrev)',
    'notifications.reseller_aps_app_updates' => 'APS programopdateringer (forhandlerens nyhedsbrev)',
    'notifications.client_aps_app_updates' => 'APS-programopdateringer (kundens nyhedsbrev)',
    'notifications.admin_pum_updates' => 'Systemopdateringer: Adviseringer om nye opdateringer',
    'notifications.admin_outgoing_mail_exceeded_limits' => 'Udgående e-mail har overskredet grænsen',
    'notifications.subscription_cgroups_limits_exceed' => 'RAM, CPU og Disk I/O (Cgroups)',
    'notifications.admin_postponed_feedback' => 'Feedback-påmindelse',
    'notifications.errorInvalidEmail' => 'Forkert e-mailadresse.',
    'notifications.errorInvalidExpTime' => 'Antallet af dage er ugyldigt.',
    'notifications.errorUpdate' => 'Kunne ikke opdatere advisering:%%error%%',
    'notifications.updated' => 'Adviseringsindstillingerne er blevet opdateret',

    'outgoingmail.name' => 'Navn',
    'outgoingmail.maxOutgoingMessages' => 'Grænse pr. time',
    'outgoingmail.numOfExceedingAttempts' => 'Forsøg efter at grænsen er nået',
    'outgoingmail.lastAttemptAt' => 'Sidste forsøg',
    'outgoingmail.mailStatus' => 'E-mail status',
    'outgoingmail.mailStatusSending' => 'Sender',
    'outgoingmail.mailStatusNotSending' => 'Sender ikke',
    'outgoingmail.mailStatusSendingDesc' => 'E-mail bliver sendt.',
    'outgoingmail.mailStatusNotSendingDesc' => 'E-mail bliver ikke sendt.',
    'outgoingmail.limitValueUnlimited' => 'Ubegrænset',

    'scheduler.tasks.headerCommand' => 'Kommando',
    'scheduler.tasks.headerSchedule' => 'Planlægning',
    'scheduler.tasks.headerSubscription' => 'Abonnement',
    'scheduler.tasks.headerSubscription_powerUser' => 'Webspace',
    'scheduler.tasks.buttonToggleHintOn' => 'Opgaven er aktiveret. Klik her for at deaktivere opgaven.',
    'scheduler.tasks.buttonToggleHintOff' => 'Opgaven er deaktiveret. Klik her for at aktivere opgaven.',
    'scheduler.tasks.add' => 'Tilføj opgave',
    'scheduler.tasks.hintAdd' => 'Planlæg en ny opgave.',
    'scheduler.tasks.remove' => 'Fjern',
    'scheduler.tasks.hintRemove' => 'Fjern de valgte opgaver.',
    'scheduler.tasks.confirmOnDelete' => 'Vil du fjerne de planlagte opgaver?',
    'scheduler.tasks.sync' => 'Opdater',
    'scheduler.tasks.hintSync' => 'Genindlæs opgavelisten for at hente aktuelle data.',
    'scheduler.tasks.settings' => 'Indstillinger',
    'scheduler.tasks.hintSettings' => 'Redigér indstillinger for planlagte opgaver.',
    'scheduler.tasks.deleteSuccess' => 'De planlagte opgaver blev fjernet.',
    'scheduler.tasks.serverTask' => 'server (bruger: %%user%%)',
    'scheduler.tasks.unknownUser' => 'ukendt',
    'scheduler.tasks.runTaskNow' => 'Kør nu',
    'scheduler.tasks.runTaskNowHint' => 'Kør opgaven nu.',
    'scheduler.tasks.runningTask' => 'Kører opgaven "%%task%%"...',

    'server-components.bcTitle' => 'Serverkomponenter',
    'server-components.title' => 'Plesk-komponenter',
    'server-components.name' => 'Komponentnavn',
    'server-components.version' => 'Komponentversion',
    'server-components.refresh' => 'Opdater',
    'server-components.componentName' => 'Angiv navn på komponent...',
    'server-components.noComponents' => 'Ingen komponenter fundet',
    'server-components.componentsListUpdated' => 'Listen over komponenter blev opdateret',

    'server-components.componentName.urlrewrite' => 'Omskrivning af URL-adresser',
    'server-components.componentName.dbconnector' => "Databaseforbindelse",
    'server-components.componentName.mysqlserver' => 'MySQL server:',
    'server-components.componentName.troubleshooting' => 'Fejlfinding',
    'server-components.componentName.waf' => 'Webprogram firewall',
    'server-components.componentName.vcs' => 'Versionskontrol system',
    'server-components.componentName.dotnetcore' => '.NET Core',
    'server-components.componentName.nodejs' => 'Node.js',
    'server-components.componentName.appinit' => "Applikationsinitialisering",
    'server-components.componentName.httpcompression' => 'HTTP indholdskompression',
    'server-components.componentName.antivirus' => "Antivirus",
    'server-components.componentName.database' => "SQL Server",
    'server-components.componentName.sqladmin' => "MySQL Webadmin",
    'server-components.componentName.sqladminmysql' => "MySQL Webadmin",
    'server-components.componentName.dnsserver' => "DNS-server",
    'server-components.componentName.firewall' => "Firewall",
    'server-components.componentName.ftpserver' => "FTP-server",
    'server-components.componentName.java' => "Java",
    'server-components.componentName.mailserver' => "Mailserver",
    'server-components.componentName.local_mailserver' => "Lokal mail-server",
    'server-components.componentName.psa' => "Plesk",
    'server-components.componentName.script' => "Webscripting",
    'server-components.componentName.spamfilter' => "Spamfilter",
    'server-components.componentName.stats' => "Webstatistikker",
    'server-components.componentName.stunnel' => "SSL/TLS Wrapper",
    'server-components.componentName.webmail' => "Webmail",
    'server-components.componentName.webpublish' => "Webpublicering",
    'server-components.componentName.webserver' => "Web-server",
    'server-components.componentName.network' => 'Networking',
    'server-components.componentName.sitebuilder' => 'Presence Builder',
    'server-components.componentName.cphosting' => "Plesk Hosting",
    'server-components.componentName.savi' => 'Sophos Antivirus-grænseflade',

    'server-components.tooltip.disabled' => 'Deaktiveret',
    'server-components.tooltip.active' => 'Aktiv',
    'server-components.tooltip.notConfigured' => 'Ikke konfigureret',
    'server-components.tooltip.notStarted' => 'ikke startet, kontrollér komponentindstillingerne',

    'server-components.defaultComponents.circularDependencies' => "Cirkulær afhængighed blev fundet mellem kategorierne %%cat1%% og %%cat2%%",
    'server-components.defaultComponents.not_installed' => "(ikke installeret)",
    'server-components.defaultComponents.not_configured' => "(ikke konfigureret).",
    'server-components.defaultComponents.not_opted_to_install_support_files' => "Nogle servicekategorier indeholdt ugyldige valg, eller der blev ikke foretaget valg.",
    'server-components.defaultComponents.depends_on' => "(kræver %%name%%)",
    'server-components.defaultComponents.not_activated' => 'ikke aktiveret',
    'server-components.defaultComponents.imap_required' => '(Nuværende mailserver understøtter ikke IMAP)',
    'server-components.defaultComponents.ftp_ipv6_hosting_not_supported' => "(FTP-serveren understøtter ikke IPv6-adresser).",
    'server-components.defaultComponents.delegation_rule_not_exist' => '(den nødvendige delegeringsregel \'appPoolPipeline, appPoolNetFx\' findes ikke)',
    'server-components.defaultComponents.not_supported_version' => '(ikke-understøttet version)',
    'server-components.defaultComponents.no_license' => '(ikke tilladt af licensnøgle)',
    'server-components.defaultComponents.license_expired' => '(licensnøglen er udløbet)',
    'server-components.defaultComponents.license_mailboxes_limit_exceeded' => '(grænsen for mailboks-licensnøgler overskredet)',
    'server-components.defaultComponents.title' => 'Vælg standard %%name%% komponent',
    'server-components.defaultComponents.none' => 'Ingen',
    'server-components.defaultComponents.yes' => 'Ja',
    'server-components.defaultComponents.no' => 'Nej',
    'server-components.defaultComponents.warning' => 'Advarsel!',
    'server-components.defaultComponents.parametersOfComponent' => 'Parametre for %%component%%',
    'server-components.defaultComponents.success' => 'Standardkomponenten blev opdateret',

    'server-components.defaultComponents.mailserverSwitchingWarning' => "Ændring af mailserver er udelukkende beregnet til førstegangsopsætningen, og hvis serveren allerede er i brug, vil det kunne medføre følgende problemer: tab af indstillinger om mailboksindhold samt - i tilfælde hvor den server du skifter til allerede er konfigureret - diverse konflikter. \nHvis denne server er i brug nu, og du er sikker på, at du vil skifte til en anden server, bør du advisere dine kunder om handlingen, så de kan downloade og gemme deres e-mails.",
    'server-components.defaultComponents.dnsserverBindToMsdnsSwitchingWarning' => "Kun de første 254 IP-adresser på undernet med /8 og /16 masker, placeret på listen Adgangskontrol vil blive overført. De vil blive overført som separate IP-adresser. Vil du fortsætte?",

    'server-components.componentConf.title' => 'Parametre for %%compDesc%%',
    'server-components.componentConf.parameterIsRequired' => 'Der skal angives et parameter',
    'server-components.componentConf.parameterShouldBeNumber' => 'Parametret skal være et tal',
    'server-components.componentConf.success' => 'Parametre blev opdateret',

    'tasks.pollingOff' => 'Deaktiveret',
    'tasks.pollingDelay' => '%%delay%% sek.',
    'tasks.stopTaskConfirm' => 'Er du sikker på, at du vil stoppe opgaven?',
    'tasks.stopTaskError' => 'Kunne ikke stoppe opgaven',
    'tasks.stopTask' => 'Stop opgave',
    'tasks.processedLoadFailed' => 'Listen over processer kunne ikke indlæses',
    'tasks.retryTask' => 'Prøv opgaven igen',
    'tasks.retryTaskFailed' => 'Opgaven kunne ikke prøves igen',
    'tasks.taskCreated' => 'Ny opgave oprettet',
    'tasks.moreDetails' => 'Se panellogfiler for nærmere oplysninger',
    'tasks.searchTitle' => 'Søg',
    'tasks.searchPlaceholder' => 'Søg streng',
    'tasks.refresh' => 'Opdater',
    'tasks.refreshDescription' => 'Opdater opgaveliste',
    'tasks.createTask' => 'Opret opgave',
    'tasks.openSwagger' => 'Åbn Swagger',
    'tasks.statusTitle' => 'Status',
    'tasks.createdTitle' => 'Oprettet',
    'tasks.descriptionTitle' => 'Beskrivelse',
    'tasks.processes.dataLoadFailed' => 'Kunne ikke hente data fra serveren',
    'tasks.processes.commandLineLoadFailed' => 'Kunne ikke hente kommandolinjen til opgaven',
    'tasks.processes.stopProcess' => 'Stop processen',
    'tasks.processes.stopProcessFailed' => 'Kunne ikke stoppe processen',
    'tasks.processes.stopProcessConfirm' => 'Er du sikker på, at du vil stoppe processen?',
    'tasks.processes.copyToClipboard' => 'Kopiér til udklipsholder',
    'tasks.processes.concurrency' => 'Samtidighed',
    'tasks.processes.taskIdSection' => 'Opgave-ID',
    'tasks.processes.requestorIdSection' => 'Anmoder-ID',
    'tasks.processes.timeoutSection' => 'Timeout',
    'tasks.processes.createdSection' => 'Oprettet',
    'tasks.processes.updatedSection' => 'Opdateret',
    'tasks.processes.environmentSection' => 'Miljø',
    'tasks.processes.idTitle' => 'ID',
    'tasks.processes.statusTitle' => 'Status',
    'tasks.processes.startedTitle' => 'Startet',
    'tasks.processes.completedTitle' => 'Udført',
    'tasks.processes.pidTitle' => 'PID',
    'tasks.processes.exitCodeTitle' => 'Afslut kode',

    'ts-sessions.columnStateTitle' => 'Tilstand',
    'ts-sessions.columnUserTitle' => 'Bruger',
    'ts-sessions.columnNameTitle' => 'Navn',
    'ts-sessions.refresh' => 'Opdater',
    'ts-sessions.logoff' => 'Log af',
    'ts-sessions.logoffConfirmation' => 'Log af %%count%% session(er)?',
    'ts-sessions.logoffConfirmationSingle' => 'Log af %%name%%-sessionen?',
    'ts-sessions.logoffConfirmationButton' => 'Ja, log af',
    'ts-sessions.logoffNoSelection' => 'Vælg en eller flere sessioner, der skal logges af',
    'ts-sessions.logoffSuccess' => 'De valgte sessioner blev logget af.',
    'ts-sessions.disconnect' => 'Afbryd',
    'ts-sessions.disconnectConfirmation' => 'Afbryd %%count%% session(er)?',
    'ts-sessions.disconnectConfirmationSingle' => 'Afbryd %%name%%-sessionen?',
    'ts-sessions.disconnectConfirmationButton' => 'Ja, afbryd',
    'ts-sessions.disconnectSuccess' => 'De valgte sessioner blev afbrudt.',
    'ts-sessions.disconnectNoSelection' => 'Vælg en eller flere sessioner, som du vil afbryde',
    'ts-sessions.disconnectNotAvailable' => 'Du kan kun afbryde aktive eller forbundne sessioner.',

    'client-ip-address.title' => 'IP-adresser',
    'client-ip-address.status' => 'Status',
    'client-ip-address.type' => 'Type',
    'client-ip-address.ipAddress' => 'IP-adresse',
    'client-ip-address.certificate' => 'Certifikat',
    'client-ip-address.hosting' => 'Hosting',
    'client-ip-address.adminCertificateRepository' => "Administrators opbevaringsområde",
    'client-ip-address.domainCertificateRepository' => 'Opbevaringsområde for domænet %%owner%%',
    'client-ip-address.typeShared' => 'Delt',
    'client-ip-address.typeExclusive' => 'Dedikeret',
    'client-ip-address.removeConfirmation' => 'Fjern {count, plural, =1 {IP-adresserne {name}} one {de # markerede IP-adresser} other {de # markerede IP-adresser}} fra brugerens IP-pulje?',
    'client-ip-address.noItemsToRemove' => 'Vælg et eller flere emner, der skal fjernes.',
    'client-ip-address.ftpOverSSL' => 'FTP over SSL/TLS',
    'client-ip-address.ftpOverSSL-yes' => 'Ja',
    'client-ip-address.ftpOverSSL-no' => 'Nej',
    'client-ip-address.ftpOverSSL-allow' => 'Tillad',
    'client-ip-address.ftpOverSSL-notAllowed' => 'Ikke tilladt',
    'client-ip-address.add' => 'Tilføj IP-adresse',
    'client-ip-address.noAvailableIps' => 'Der er ingen IP-adresser til rådighed.',
    'client-ip-address.isOk' => 'IP-adressen fungerer korrekt.',
    'client-ip-address.isBroken' => 'IP-adressen blev ikke fundet i grænsefladen.',
    'client-ip-address.properties.title' => 'IP-adressen %%address%% på grænsefladen %%interface%%',
    'client-ip-address.properties.distributedType' => 'IP-adresse distribueret som',
    'client-ip-address.properties.allocatedType' => 'IP-adresse reserveret som',
    'client-ip-address.properties.none' => 'Ingen',
    'client-ip-address.properties.certificate' => 'SSL/TLS-certifikat',
    'client-ip-address.properties.defaultSite' => 'Standardwebsted',
    'client-ip-address.assign.title' => 'Vælg IP-adresser',
    'client-ip-address.assign.description' => 'Ledige IP\'er',
    'client-ip-address.assign.success' => '{count, plural, =1 {IP-adressen {name}} one {De # markerede IP-adresser} other {De # markerede IP-adresser}} blev føjet til brugerens IP-gruppe',

    'ip-address-reseller-usage.title' => 'Forhandlere der bruger %%type%% IP-adresse %%ipAddress%%',
    'ip-address-reseller-usage.nameColumnHeader' => 'Forhandlere',
    'ip-address-reseller-usage.assignButton' => 'Tildel til forhandler',
    'ip-address-reseller-usage.alreadyAssignedToAllClients' => 'Denne IP-adresse er allerede i knyttet til alle brugerne.',
    'ip-address-reseller-usage.removeButton' => 'Fjern',
    'ip-address-reseller-usage.removeSuccess' => 'IP-adressen blev fjernet fra {count, plural, =1 {{name}-gruppen} one {# markerede forhandlergrupper} other {# markerede IP-forhandlergrupper}}.',
    'ip-address-reseller-usage.removeConfirmation' => 'Fjern IP-adressen fra {count, plural, =1 {IP-{name}-gruppen} one {den # markerede forhandlergruppe} other {de # markerede IP-forhandlergrupper}}?',
    'ip-address-reseller-usage.typeSHARED' => 'Delt',
    'ip-address-reseller-usage.typeEXCLUSIVE' => 'Dedikeret',
    'ip-address-reseller-usage.assign.title' => "Føj %%ipAddress%% til IP-forhandlergruppen",
    'ip-address-reseller-usage.assign.resellersToAdd' => 'Forhandlere, der skal tilføjes',
    'ip-address-reseller-usage.assign.success' => 'IP-adressen blev føjet til {count, plural, =1 {{name} IP-gruppen} one {# markerede IP-forhandlergrupper} other {# markerede IP-forhandlergrupper}}.'
];