<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
$messages = [
    'access-network.subnetOrIpAddressLabel' => '子网或 IP 地址',
    'access-network.subnetOrIpAddressHint' => '例如，2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'admin.announcement-settings.announcementLegend' => '时事通讯',
    'admin.announcement-settings.getConsentLoading' => '正在检索有关时事通讯的信息...',
    'admin.announcement-settings.getConsentWarning' => '无法检索您的订阅状态。',
    'admin.announcement-settings.sendAnnounceConsent' => '我想要接收来自 Plesk 的时事通讯。这些讯息可能包括安全相关的、技术和常规产品方面的信息。我同意并授权 Plesk 根据现行适用的数据保护法收集、处理和使用我的个人数据（邮箱），包括跨境处理，直接或通过第三方服务给我发送时事通讯。取消勾选该复选框则表示撤销同意并令 Plesk 停止向我发送邮件以及从其系统中永久移除我的个人数据。',
    'admin.announcement-settings.sendAnnouncePersonalizedConsent' => '是，我同意接收个性化的 Plesk 通讯。Plesk International GmbH 和其附属公司可以根据 %%privacyPolicy%% 以提供通讯为目的而存储和处理我提供的数据。为了定制其消息和向我提供的帮助提示，Plesk 还可以使用用于分析的其它信息，例如使用和行为数据。我可以随时取消订阅邮件列表。',
    'admin.announcement-settings.privacyPolicy' => 'Plesk 隐私策略',
    'admin.announcement-settings.noConsent' => '取消订阅 Plesk 通讯。',
    'admin.announcement-settings.reportConsentError' => '无法保存您从 Plesk 接收信息的设置：%%error%%。',
    'admin.announcement-settings.profileUpdateError' => '很抱歉，我们目前无法更新您的个人资料。请稍后再试。',
    'admin.announcement-settings.invalidConsentType' => "未知同意类型：'%%type%%'",
    'admin.announcement-settings.retry' => '重新尝试',
    'admin.announcement-settings.consentGivenInfo' => '我们希望您一直喜欢我们的 Plesk 通用通讯。我们现在可以为您提供更为完善的方案，能够根据您的需要来提供有用信息和帮助提示，更具个性化。欲接收个性化的 Plesk 通讯，请选择下面的第一条声明，然后点击“确定”。',
    'admin.announcement-settings.consentNotGivenInfo' => '似乎您尚未订阅我们的通用通讯。我们可以为您提供更为完善的方案，即个性化的通讯，能够根据您的需要来提供有用信息和帮助提示。',

    'admin.personal-info.title' => '编辑管理员信息',
    'admin.personal-info.pleskSettingsSectionLegend' => 'Plesk 设置',
    'admin.personal-info.settingsSectionLegend' => '设置',

    'admin-alias.login' => '用户名',
    'admin-alias.password' => '密码',
    'admin-alias.passwordConfirmation' => '确认密码',
    'admin-alias.email' => '邮件地址',
    'admin-alias.contact' => '联系名称',
    'admin-alias.comments' => '备注',
    'admin-alias.emptyLogin' => '请提供一个用户名。',
    'admin-alias.loginTooLong' => '该用户名的长度超过了 20 个字符。',
    'admin-alias.emptyEmail' => '请提供一个邮件地址。',
    'admin-alias.emptyContactName' => '请提供一个联系名称。',
    'admin-alias.contactNameTooLong' => '此联系名称的长度超过了 255 个字符。',
    'admin-alias.emptyPassword' => '请提供一个密码。',
    'admin-alias.commentsTooLong' => '该备注的长度超过了 255 个字符。',
    'admin-alias.emailActivation' => '通过电子邮件激活账户',
    'admin-alias.simplePanel' => '启用限制模式',
    'admin-alias.simplePanelHint' => '选择此选项来限制其它管理员可以在Plesk中采取操作的次数。若要更改可用的操作，请点击%%link%%。',
    'admin-alias.simplePanelLink' => '工具 & 设置> 限制模式设置',
    'admin-alias.lockPowerUser' => '为其他管理员提供高级用户试图',
    'admin-alias.lockPowerUserHint' => '限制查看其它Plesk管理员的能力（无法访问客户、经销商和服务计划）。',

    'admin-info.plesk-settings.multiplyLogin' => '允许在该帐户下进行多个会话',
    'admin-info.plesk-settings.adminLanguage' => '管理员的界面语言',
    'admin-info.plesk-settings.password' => '密码',
    'admin-info.plesk-settings.passwordConfirmation' => '确认密码',

    'admin-panel.form.contact-info.contactName' => '联系人姓名',
    'admin-panel.form.contact-info.emptyContactName' => '请提供联系人姓名。',
    'admin-panel.form.contact-info.contactNameTooLong' => '联系人姓名太长 (最大允许%max%)。',
    'admin-panel.form.contact-info.email' => '电子邮件地址',
    'admin-panel.form.contact-info.emptyEmail' => '请提供电子邮件地址。',
    'admin-panel.form.contact-info.companyName' => '公司名称',
    'admin-panel.form.contact-info.longCompanyName' => '公司名太长(最长%max%。',
    'admin-panel.form.contact-info.phone' => '电话号码',
    'admin-panel.form.contact-info.longPhone' => '电话号码太长(最长%max%)。',
    'admin-panel.form.contact-info.fax' => '传真号码',
    'admin-panel.form.contact-info.imNumber' => '即时通讯',
    'admin-panel.form.contact-info.longFax' => '传真号太长(最长%max%',
    'admin-panel.form.contact-info.phoneRegexNotMatch' => '指定的电话号码无效。',
    'admin-panel.form.contact-info.faxRegexNotMatch' => '该传真号不正确。',
    'admin-panel.form.contact-info.address' => '地址',
    'admin-panel.form.contact-info.longAddress' => '地址太长(最长%max%)。',
    'admin-panel.form.contact-info.city' => '城市',
    'admin-panel.form.contact-info.longCity' => '城市名太长。',
    'admin-panel.form.contact-info.shortCity' => '此城市名称太短。',
    'admin-panel.form.contact-info.state' => '省/市/自治区',
    'admin-panel.form.contact-info.postalCode' => '邮政编码',
    'admin-panel.form.contact-info.country' => '国家/地区',
    'admin-panel.form.contact-info.additionalInfo' => '其他信息',
    'admin-panel.form.contact-info.additionalInfoHint' => '仅纯文本：将忽略所有 HTML 标记。',
    'admin-panel.form.contact-info.duplicateEmail' => '系统中已存在带有相同电子邮件地址的用户。',

    'admin-panel.form.domain-info-section.domainInfoSection' => '订阅',
    'admin-panel.form.domain-info-section.domainInfoSectionForCustomerHint' => '网站属性',
    'admin-panel.form.domain-info-section.domainInfoSectionForResellerHint' => '网站属性',
    'admin-panel.form.domain-info-section.domainInfoSectionOwnHint' => '网站属性',
    'admin-panel.form.domain-info-section.createSubscription' => '为客户创建订阅',
    'admin-panel.form.domain-info-section.createSubscriptionHint' => '如果您此刻不想为客户创建主机服务订阅或设置网站请清空该复选框。没有订阅，客户将无法登录到客户面板。',
    'admin-panel.form.domain-info-section.domainName' => '域名',
    'admin-panel.form.domain-info-section.emptyDomainName' => '您必须提供一个域名。',
    'admin-panel.form.domain-info-section.shared' => '共享',
    'admin-panel.form.domain-info-section.exclusive' => '独立',
    'admin-panel.form.domain-info-section.userName' => '用户名',
    'admin-panel.form.domain-info-section.userNameHint' => '用于管理在订阅内创建的网站文件和文件夹的系统用户帐户。',
    'admin-panel.form.domain-info-section.emptyLogin' => '您必须提供一个用户名。',
    'admin-panel.form.domain-info-section.password' => '密码',
    'admin-panel.form.domain-info-section.emptyPassword' => '您必须提供一个密码。',
    'admin-panel.form.domain-info-section.passwordConfirmation' => '确认密码',
    'admin-panel.form.domain-info-section.ipv4AddressHint' => "托管网站的 IP 地址是网站的虚拟主机的网络地址。",
    'admin-panel.form.domain-info-section.ipv4Address' => 'IPv4 地址',
    'admin-panel.form.domain-info-section.ipv6AddressHint' => "托管网站的 IP 地址是网站的虚拟主机的网络地址。",
    'admin-panel.form.domain-info-section.ipv6Address' => 'IPv6 地址',
    'admin-panel.form.domain-info-section.noIpAddressHint' => '无',
    'admin-panel.form.domain-info-section.subscriptionSettings' => '其它的订阅设置',
    'admin-panel.form.domain-info-section.credentials' => '系统用户验证凭据',
    'admin-panel.form.domain-info-section.credentialsHint' => '通过 FTP 和 SSH 访问托管的文件',
    'admin-panel.form.domain-info-section.credentialsHintWin' => '以通过 FTP 和 RDP 访问托管的文件',

    'admin-panel.form.login-info.userName' => '用户名',
    'admin-panel.form.login-info.emptyUserName' => '请提供用户名。',
    'admin-panel.form.login-info.password' => '密码',
    'admin-panel.form.login-info.emptyPassword' => '请提供密码。',
    'admin-panel.form.login-info.passwordConfirmation' => '重复密码',
    'admin-panel.form.login-info.internalEmailPasswordChanged' => '更改密码也将更改内部电子邮件地址密码',
    'admin-panel.form.login-info.emailActivation' => '通过电子邮件激活账户',
    'admin-panel.form.login-info.emailActivationHint' => '除非用户通过电子邮件中所发送的链接激活账户，或管理员手动激活该账户，创建的账号便会处于非活动状态。',

    'admin-panel.form.subscription-info-section.subscription' => '订阅',
    'admin-panel.form.subscription-info-section.servicePlan' => '服务方案',
    'admin-panel.form.subscription-info-section.oldServicePlan' => '当前服务方案',
    'admin-panel.form.subscription-info-section.newServicePlan' => '新服务方案',
    'admin-panel.form.subscription-info-section.adminPlan' => '简单方案',
    'admin-panel.form.subscription-info-section.none' => '无',
    'admin-panel.form.subscription-info-section.addonPlans' => '附加方案',
    'admin-panel.form.subscription-info-section.customizeSubscription' => '方案关联性更改后，继续自定义订阅参数。注意，执行此操作会锁定订阅而不能同步。',
    'admin-panel.form.subscription-info-section.customizeSubscriptionOnCreateSubscription' => '创建后继续自定义订阅参数。',
    'admin-panel.form.subscription-info-section.customizeSubscriptionForCustomer' => "创建客户后继续自定义订阅参数。",
    'admin-panel.form.subscription-info-section.customizeSubscriptionForSelf' => '创建后，继续自定义订阅参数。注意，执行此操作会锁定订阅而不能同步。',
    'admin-panel.form.subscription-info-section.customizeSubscriptionHint' => '注意执行此操作将锁定订阅不能同步。',
    'admin-panel.form.subscription-info-section.buttonOk' => '添加订阅',

    'admin-panel.form.subscription.subscriptionNotSynchronized' => '无法将订阅与服务方案同步。订阅的下列设置与服务方案冲突：%%problems%%。',

    'app.configure.otherSettings' => '其他',
    'app.configure.passwordConfirmation' => '确认密码',

    'app.update-settings.description' => '',
    'app.update-settings.forceUpdates' => '强制更新所有安装的应用程序',
    'app.update-settings.forceUpdatesHint' => '允许客户的应用程序在更新发行时自动接收更新。客户将无法关闭应用程序的自动更新。警告：谨慎使用此选项，因为更新对应用程序功能影响很大。例如，应用程序扩展可能无法用于该应用程序的其它版本。',
    'app.update-settings.suggestUpdates' => '默认打开选项“自动更新该应用程序”',
    'app.update-settings.suggestUpdatesHint' => '对于新安装的应用程序，将会打开应用程序设置中的“自动更新该应用程序”选项。',

    'backup.server-settings.rotation' => '可以进行存储的完整备份文件的最大数量（包括计划和手动备份）',
    'backup.server-settings.rotationDescription' => '用户可以在服务器存储中存储这么多完整的备份。如果存储中完整备份的数量已超出限制，仅能保存最近的备份。增量备份不受影响。',
    'backup.server-settings.maxProcesses' => '同时运行计划备份进程的最大数量',
    'backup.server-settings.niceScheduled' => '运行低优先级的计划备份进程',
    'backup.server-settings.niceScheduledPriority' => '优先级',
    'backup.server-settings.niceScheduledPriorityDescription' => '输入 1 到 19 之间的值，数值越高优先级越低。',
    'backup.server-settings.niceScheduledIoPriority' => 'IO 优先级',
    'backup.server-settings.niceScheduledIoPriorityDescription' => '输入 0 到 7 之间的值，数值越高优先级越低。',
    'backup.server-settings.niceAlways' => '运行所有低优先级的备份进程',
    'backup.server-settings.niceAlwaysPriority' => '优先级',
    'backup.server-settings.niceAlwaysPriorityDescription' => '输入 1 到 19 之间的值，数值越高优先级越低。',
    'backup.server-settings.niceAlwaysIoPriority' => 'IO 优先级',
    'backup.server-settings.niceAlwaysIoPriorityDescription' => '输入 0 到 7 之间的值，数值越高优先级越低。',
    'backup.server-settings.compressionLevel' => '压缩级别',
    'backup.server-settings.compressionLevelNoCompression' => '无压缩',
    'backup.server-settings.compressionLevelFastest' => '最快',
    'backup.server-settings.compressionLevelFast' => '快速',
    'backup.server-settings.compressionLevelNormal' => '正常',
    'backup.server-settings.compressionLevelMaximum' => '中等',
    'backup.server-settings.freeSpaceRequired' => '只有您的服务器有指定容量的可用磁盘空间才开始备份（以 MB 为单位）',
    'backup.server-settings.checkBackupDiskSpace' => '仅在您的服务器有足够的可用磁盘空间容量时启动备份',
    'backup.server-settings.mssqlNativeBackupEnabled' => '请使用本地 MS SQL 备份功能（对于远程数据库，请确保您已在 工具与设置> 数据库服务器 中配置了远程 MS SQL 服务器的备份设置）',
    'backup.server-settings.localFtpRestriction' => '允许在本地服务器上设置 FTP 备份存储',
    'backup.server-settings.backupSecuritySettings' => '备份安全设置',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailed' => '如果上传到远程存储失败请把备份保存在服务器存储中',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailedDescription' => '将要进行远程存储的手动和计划备份如果上传到远程存储失败则将被保存在本地服务器存储中。用户必须有在服务器存储中存储备份的权限。',

    'change-current-subscription.hint' => '您可以在此处更改订阅服务方案的关联性。注意，选择"无"作为新服务方案将从服务方案取消绑定订阅，并设置成"自定义"。',
    'change-current-subscription.subscriptionNotSynchronized' => '无法将订阅与服务方案同步。订阅的下列设置与服务方案冲突：%%problems%%。',

    'change-password.oldPassword' => '旧密码',
    'change-password.password' => '新密码',
    'change-password.passwordConfirmation' => '确认密码',
    'change-password.oldPasswordIsIncorrect' => '旧密码不正确。请重试。',
    'change-password.unableToFindAdditionalAdminAccount' => '无法找到其它管理员帐户。',
    'change-password.warningAboutAdminPasswordSyntax' => "该密码应介于 %%min%% - %%max%% 之间且不得包含用户名。密码中不得使用引号、空格以及国家字母字符。",
    'change-password.warningAboutWinAdminPasswordSyntax' => "密码中不得使用引号、空格、分号以及国家字母字符。该密码应介于 %%min%% 和 %%max%% 之间且不得包含用户名。",

    'change-reseller-oversell-policy.oversellPolicy' => '超额销售策略',
    'change-reseller-oversell-policy.oversellPolicyAllowed' => '允许超额销售',
    'change-reseller-oversell-policy.oversellPolicyAllowedHint' => '超额销售允许代理商超额出售通过方案分配给他们的资源。若允许超额销售，代理商则可支配实际使用的资源而不是初始分配的资源。',
    'change-reseller-oversell-policy.oversellPolicyNotAllowed' => '不允许超额销售',
    'change-reseller-oversell-policy.oversellPolicyNotAllowedHint' => '若不允许超额销售，不管实际使用的资源是多少，代理商都只能出售通过方案初始分配给他们的资源。',

    'change-reseller-subscription.hint' => '您可以在此处更改与代理商订阅关联的服务方案。注意，选择"无"作为新服务方案会将订阅从服务方案取消绑定，并设置为"自定义"。',
    'change-reseller-subscription.subscriptionNotSynchronized' => '无法将订阅与服务方案同步。订阅的下列设置与服务方案冲突：%%problems%%。',
    'change-reseller-subscription.servicePlan' => '新方案',
    'change-reseller-subscription.oldSubscription' => '当前方案',
    'change-reseller-subscription.none' => '无',
    'change-reseller-subscription.infoSubscriptionChanged' => '订阅相关服务方案已更新。',
    'change-reseller-subscription.customizeSubscription' => '与服务方案的关联更新后，继续自定义订阅参数。注意，执行此操作会锁定订阅而不能同步。',

    'change-subscription.hint' => '您可在此更改所选订阅与服务方案的相关性。',
    'change-subscription.selectPlanLegend' => '服务方案',
    'change-subscription.selectPlanDescription' => '若要切换到其它服务方案，请从列表中选择新方案。注意，若选择\'无\'则取消订阅和服务方案的绑定，使其成为\'自定义\'订阅。',
    'change-subscription.servicePlan' => '新服务方案',
    'change-subscription.selectAddonPlansLegend' => '附加方案',
    'change-subscription.selectAddonPlansDescription' => '添加或移除附加方案。',
    'change-subscription.noChange' => '无变更',
    'change-subscription.none' => '无',
    'change-subscription.add' => '添加',
    'change-subscription.del' => '移除',
    'change-subscription.separator' => '-------',

    'control-panel-access.network.subnetOrIpAddressLabel' => '子网或 IP 地址',
    'control-panel-access.network.subnetOrIpAddressHint' => '例如，2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'control-panel-access.settings.accessPolicyLabel' => '使用管理员权限访问 Plesk',
    'control-panel-access.settings.policyAllow' => '允许，列表中的网络除外。',
    'control-panel-access.settings.policyDeny' => '拒绝不在列表中的网络。',

    'create-subscription.title' => '添加一个订阅',
    'create-subscription.titleOwn' => '创建自己的订阅',
    'create-subscription.poolIsEmpty' => '无法创建订阅因为没有共享 IP 地址且 Plesk 中没有可用的独立 IP 地址。',
    'create-subscription.infoNewSubscriptionCreated' => '已创建订阅%%name%%。',
    'create-subscription.createBeforeAppInstall' => '您需要有一个订阅来安装应用程序。',

    'customer.hint' => '您可在此新增客户并为其订阅主机服务。首先在 Plesk 中创建客户帐户然后订阅主机方案以及附加方案。订阅也可以不与任何方案绑定，提供自定义的资源和服务 — 具体操作是选择服务方案旁边的\'无\'。',
    'customer.contactInfoSection' => '联系信息',
    'customer.additionalInfoSection' => '其它的客户信息',
    'customer.accessToPanelSection' => '访问 Plesk',
    'customer.contactInfoSectionHint' => '输入客户联系信息。',
    'customer.accessToPanelSectionHint' => '客户将用于访问其客户面板的验证凭据。',
    'customer.unableCreateSubscription' => '无法创建订阅: %%reason%%',
    'customer.poolIsEmpty' => 'IP池为空',
    'customer.buttonOk' => '添加客户',

    'database-settings.dbPrefixRadio' => '添加前缀和下划线到数据库名称的开头',
    'database-settings.dbPrefixNone' => '无',
    'database-settings.dbPrefixUsername' => '用户名',
    'database-settings.dbPrefixExternalId' => '订阅的外部 ID',
    'database-settings.dbPrefixCustom' => '自定义前缀',
    'database-settings.dbUserPrefixRadio' => '添加前缀和下划线到数据库用户名称的开头',
    'database-settings.dbUserPrefixHint' => '数据库用户名称如：<prefix>_<database_user_name>。因数据库用户名长度的限制，<prefix> 可能被缩写。',
    'database-settings.grantAlterDatabase' => '授予所有 Microsoft SQL Server 数据库用户修改数据库的权限',
    'database-settings.grantAlterDatabaseHint' => '新的和现有的用户都将被授予该权限',
    'database-settings.enableBackupOperator' => '使所有 Microsoft SQL 服务器数据库用户拥有 db_backupoperator 角色成员身份。',
    'database-settings.enableBackupOperatorHint' => '新的和现有的用户都将成为该角色的成员。',
    'database-settings.aclRadio' => 'MySQL数据库用户远程访问权限的默认设置',
    'database-settings.aclLocalhost' => '仅允许本地连接',
    'database-settings.aclAny' => '允许来自任何主机的远程连接',
    'database-settings.aclCustom' => '允许远程连接来自',
    'database-settings.aclDescription' => '此设置仅可修改用户的权限。要启用对本地MySQL服务器的远程访问，请在%%serverLink%%中选择相应的选项',
    'database-settings.aclDescriptionLink' => '本地 MySQL 设置',
    'database-settings.example' => "例如：",
    'database-settings.aclExampleDescription' => "所指定的主机可以代表此用户访问该数据库。",
    'database-settings.dbPrefixAlphaNumeric' => '前缀值只能包含字母数字值和下划线。',

    'dns.add-acl-record.description' => '添加允许接收 DNS 区域副本的 DNS 服务器 IP 地址。',
    'dns.add-acl-record.ipAddress' => 'IP 地址',
    'dns.add-acl-record.ipAddressWithMask' => 'IP 地址/掩码',

    'dns.settings.recursion' => '递归DNS查询',
    'dns.settings.recursionOn' => '允许所有请求',
    'dns.settings.recursionLocal' => '仅允许本地请求',
    'dns.settings.recursionLocalnets' => '仅允许执行来自本地网络的请求',
    'dns.settings.recursionOff' => '拒绝所有请求',
    'dns.settings.customConfiguration' => '其它 DNS 设置',
    'dns.settings.customConfigurationPlaceholder' => '您在此处指定的设置将覆盖服务器范围内的设置。',
    'dns.settings.customConfigurationHint' => '如果无法找到指定的设置，请使用 named.conf 的语法将它们添加到上面的字段中。',
    'dns.settings.customConfigurationExample' => '例如，要隐藏 DNS 服务器的主机名，请添加以下行： ',
    'dns.settings.restoreDefaultButton' => '使用默认设置',

    'dns.template.synchronize-done' => '已成功应用该 DNS 区域模板。',
    'dns.template.synchronize-error' => '该 DNS 区域模板未应用至一些 DNS 区域。',
    'dns.template.synchronize-progress' => '应用该 DNS 区域模板。',

    'domain-restriction.name' => '域名',
    'domain-restriction.nameDescription' => '您可以使用星号 (*) 指定一个通配符模式。例如，*.example.com',
    'domain-restriction.domainAlreadyExists' => '列表中已存在指定的域名。',

    'event-handler.eventLabel' => '事件',
    'event-handler.priorityLabel' => '优先级',
    'event-handler.userLabel' => '用户',
    'event-handler.commandLabel' => '命令',
    'event-handler.commandHint' => '为了获取最佳结果，请在 \'命令\' 字段中输入脚本文件的完整路径。不建议输入系统命令，因为可能无效。例如，带有输出重定向操作符 /&gt; or &lt; 的命令可能无效。',
    'event-handler.priorityHighestText' => '低',
    'event-handler.priorityHighText' => '最高',
    'event-handler.priorityNormalText' => '自定义',
    'event-handler.priorityLowText' => '低',
    'event-handler.priorityLowestText' => '正常',
    'event-handler.priorityCustomText' => '自定义',
    'event-handler.priorityHighestOption' => '最高 (%%value%%)',
    'event-handler.priorityHighOption' => '高 (%%value%%)',
    'event-handler.priorityNormalOption' => '正常 (%%value%%)',
    'event-handler.priorityLowOption' => '低 (%%value%%)',
    'event-handler.priorityLowestOption' => '最低 (%%value%%)',

    'extension.upload.fileUpload' => '进入扩展程序包文件的路径',

    'external-webmail.hint' => '您在 Plesk 中注册了其它的 web 邮箱后，该 web 邮箱即会以一个选项的形式在主机方案和订阅的 \'邮件\' 属性中出现，从而供客户使用。该 web 邮箱名称将会在 web 邮箱选项列表中显示，点击 客户面板 中邮箱旁边的 web 邮箱图标即会打开其 URL。',
    'external-webmail.name' => 'web 邮箱服务名称',
    'external-webmail.url' => 'web 邮箱服务URL',
    'external-webmail.enabled' => '可用',

    'ftp-settings.generalSection' => '常规',
    'ftp-settings.portRange' => '适用于被动FTP模式连接的端口或端口范围',
    'ftp-settings.hintPortRange' => '（默认值：%%defaultPortRange%%）',

    'health.upload.hint' => '上传健康服务器监控配置。上传后，即会应用配置。',
    'health.upload.selectFile' => '配置文件',

    'install-local-package.selectUploadType' => '选择下面的一项：',
    'install-local-package.uploadAsFile' => '上传一个 APS 包',
    'install-local-package.downloadFromCatalog' => '从应用程序目录选择应用程序',
    'install-local-package.formInfo' => "通过上传新的应用程序或从应用程序目录添加应用程序以扩展可用应用程序列表。",
    'install-local-package.invalidFileExtension' => '上传的应用程序必须是 ZIP 压缩文件，扩展名为.zip。',
    'install-local-package.packagesNotSelected' => '未选定软件包。',
    'install-local-package.visible' => '设置客户可用',
    'install-local-package.isCommercial' => '该应用程序为商业应用程序需要购买许可证密钥。',
    'install-local-package.visibleDescription' => '设置客户可安装此应用程序。',

    'ip-address.addTitle' => '添加 IP 地址',
    'ip-address.editTitle' => '接口 %%interface%% 上的 IP 地址 %%address%%',
    'ip-address.generalSection' => '通用',
    'ip-address.interface' => '接口',
    'ip-address.addressAndSubnetPrefixLength' => 'IP 地址与子网掩码',
    'ip-address.addressHintIPv4' => '例如：123.123.123.123/16, 123.123.123.123/255.255.0.0',
    'ip-address.addressHintIPv6' => '例如：2002:7b7b:7b7b::1/64, 123.123.123.123/16, 123.123.123.123/255.255.0.0',
    'ip-address.publicIp' => '公共 IP 地址',
    'ip-address.hintPublicIp' => '如果您的 Plesk 服务器部署在 NAT 后则可使用公共 IP 地址',
    'ip-address.distributionType' => '该 IP 地址被分配为',
    'ip-address.distributionTypeShared' => '共享',
    'ip-address.distributionTypeExclusive' => '独立',
    'ip-address.certificate' => 'SSL/TLS 证书',
    'ip-address.defaultSite' => '默认网站',
    'ip-address.ftpOverSslNotSupportedByServer' => '已安装的 FTP 服务器不支持 FTPS。',
    'ip-address.ftpOverSslIpv6NotSupportedByServer' => '安装的 FTP 服务器不支持 IPv6 地址',
    'ip-address.interfaceDHCPEnabled' => '无法添加 IP 地址。该网络接口会自动获取 IP 地址。',
    'ip-address.accessDomainOnAnyDomainWinWarning' => '注意：为所有未知的域名启用了自定义 Plesk URL；将会在 "https://%%ip%%/" 上显示 Plesk 界面而不是默认的站点',
    'ip-address.ipAddressInterfaceNotAvailableWarning' => '网络适配器%%interface%% 不存在。移动此 IP 地址到其他网络适配器或从列表移除该 IP 地址。',
    'ip-address.none' => '无',

    'ip-ban.filter.name' => '名称',
    'ip-ban.filter.content' => '内容',
    'ip-ban.filter.filterExistsError' => '相同名称的过滤器已经存在。',

    'ip-ban.jail.name' => '名称',
    'ip-ban.jail.filter' => '过滤器',
    'ip-ban.jail.filterDescription' => '选择过滤器。',
    'ip-ban.jail.action' => '操作',
    'ip-ban.jail.actionDescription' => '在此处选择一项操作并点击按钮以添加该操作。',
    'ip-ban.jail.logPath' => '日志路径',
    'ip-ban.jail.banTime' => 'IP 地址禁止时段',
    'ip-ban.jail.maxRetry' => '登录尝试失败最多次数。',
    'ip-ban.jail.timeUnit' => '秒',
    'ip-ban.jail.addAction' => '添加',
    'ip-ban.jail.chooseAction' => '选择：',
    'ip-ban.jail.apache-auth-filter-description' => 'Apache 验证失败（当登录到文件时）',
    'ip-ban.jail.apache-auth[logging=all]-filter-description' => 'Apache 验证失败（任何日志记录）',
    'ip-ban.jail.apache-auth[logging=syslog]-filter-description' => 'Apache 验证失败（当登录到系统日志时）',
    'ip-ban.jail.apache-badbots-filter-description' => '垃圾邮件机器人程序和恶劣的网络爬虫',
    'ip-ban.jail.plesk-courierlogin-filter-description' => 'Courier IMAP 和 POP3 验证失败',
    'ip-ban.jail.plesk-dovecot-filter-description' => 'Dovecot IMAP、POP3 和 Sieve 验证失败',
    'ip-ban.jail.plesk-dovecot[mode=aggressive]-filter-description' => 'Dovecot IMAP、POP3 和 Sieve 验证失败（主动模式）',
    'ip-ban.jail.plesk-horde-filter-description' => 'Horde web 邮箱验证失败',
    'ip-ban.jail.plesk-modsecurity-filter-description' => '违反 Web 应用程序防火墙 (ModSecurity) 安全和访问控制',
    'ip-ban.jail.plesk-panel-filter-description' => 'Plesk 验证失败',
    'ip-ban.jail.plesk-qmail-filter-description' => 'QMail SMTP 验证失败',
    'ip-ban.jail.plesk-roundcube-filter-description' => 'Roundcube web 邮箱验证失败',
    'ip-ban.jail.plesk-wordpress-filter-description' => 'WordPress 验证失败',
    'ip-ban.jail.postfix-filter-description' => 'Postfix SMTP 客户端错误（包括 RBL）',
    'ip-ban.jail.postfix[mode=aggressive]-filter-description' => 'Postfix SMTP 客户端错误、验证失败和 DDoS 攻击',
    'ip-ban.jail.postfix[mode=auth]-filter-description' => 'Postfix SMTP 和 SASL 验证失败',
    'ip-ban.jail.postfix[mode=ddos]-filter-description' => 'Postfix SMTP DDoS 攻击',
    'ip-ban.jail.postfix[mode=extra]-filter-description' => 'Postfix SMTP 客户端错误和验证失败',
    'ip-ban.jail.postfix[mode=normal]-filter-description' => 'Postfix SMTP 客户端错误（包括 RBL）',
    'ip-ban.jail.postfix[mode=rbl]-filter-description' => 'Postfix SMTP 客户端错误（仅 RBL）',
    'ip-ban.jail.proftpd-filter-description' => 'ProFTPD 登录失败',
    'ip-ban.jail.recidive-filter-description' => 'Fail2Ban 禁止重复托管',
    'ip-ban.jail.sshd-filter-description' => 'SSH 登录失败',
    'ip-ban.jail.sshd[mode=aggressive]-filter-description' => 'SSH 登录失败、协商失败和 DDoS 攻击',
    'ip-ban.jail.sshd[mode=ddos]-filter-description' => 'SSH 登录失败和 DDoS 攻击',
    'ip-ban.jail.sshd[mode=extra]-filter-description' => 'SSH 登录和协商失败',
    'ip-ban.jail.firewallcmd-allports-action-description' => '通过 firewalld 防火墙禁止，在所有端口上',
    'ip-ban.jail.firewallcmd-multiport-action-description' => '通过 firewalld 防火墙禁止，在多个端口上',
    'ip-ban.jail.firewallcmd-new-action-description' => '通过 firewalld 防火墙禁止，在一个端口上',
    'ip-ban.jail.iptables-action-description' => '通过 iptables 防火墙禁止，在单个端口上',
    'ip-ban.jail.iptables-allports-action-description' => '通过 iptables 防火墙禁止，在所有端口上',
    'ip-ban.jail.iptables-multiport-action-description' => '通过 iptables 防火墙禁止，在多个端口上',
    'ip-ban.jail.sendmail-action-description' => '通过 Sendmail 发送邮件通知',
    'ip-ban.jail.jailExistsError' => '相同名称的 jail 已经存在。',
    'ip-ban.jail.invalidInteger' => '指定的值无效。请指定一个整数。',

    'ip-ban.settings.pageHint' => '您可在此设置禁止 IP 地址以保护您的服务器和托管的网站免受恶意流量的入侵。',
    'ip-ban.settings.detectionEnabled' => '启用入侵检测',
    'ip-ban.settings.banPeriod' => 'IP 地址禁止时段',
    'ip-ban.settings.banTimeWindow' => '检测后续攻击的时间间隔',
    'ip-ban.settings.maxRetries' => '禁止 IP 地址前失败的次数',
    'ip-ban.settings.timeUnit' => '秒',
    'ip-ban.settings.invalidInteger' => '提供的值无效。请提供一个正整数。',

    'ip-ban.trusted-ip.ipAddress' => 'IP 地址',
    'ip-ban.trusted-ip.hintIpAddress' => '一个 IP 地址、一个 CIDR 掩码，或一个 DNS 主机名',
    'ip-ban.trusted-ip.specialCharactersInIpAddress' => '提供的 IP 地址、网络地址或主机名无效。',
    'ip-ban.trusted-ip.ipAddressIsTooLong' => 'IP地址不能超过 %max% 个字符。',
    'ip-ban.trusted-ip.ipAddressDescription' => '描述',
    'ip-ban.trusted-ip.hintIpAddressDescription' => '对 IP 地址被添加到信任列表的解释。',
    'ip-ban.trusted-ip.ipAddressDescriptionTooLong' => '描述不得超过 %max% 个字符。',

    'login-info.hint' => '在此处您可以修改客户用于访问其客户面板的用户名和密码。',
    'login-info.resellerHint' => '在此处您可以修改代理商用于访问其 Plesk 的用户名和/或密码。',
    'login-info.myProfileHint' => '您可在此修改用于访问 Plesk 的密码。',

    'firewall-rule.titleEdit' => '编辑防火墙规则',
    'firewall-rule.titleNew' => '添加规则',
    'firewall-rule.isEnabled' => '启用规则',
    'firewall-rule.name' => '规则名称',
    'firewall-rule.profiles' => '配置文件',
    'firewall-rule.profilesHint' => '您必须至少选择一个配置文件。',
    'firewall-rule.profileDomain' => '域名',
    'firewall-rule.profilePrivate' => '私有',
    'firewall-rule.profilePublic' => '公共',
    'firewall-rule.action' => '操作',
    'firewall-rule.actionAllow' => '允许',
    'firewall-rule.actionBlock' => '拒绝',
    'firewall-rule.port' => '允许连接到下列端口或端口范围',
    'firewall-rule.portHint' => '例如：1000 或 1000-1051',
    'firewall-rule.protocolTcp' => 'TCP 协议',
    'firewall-rule.protocolUdp' => 'UDP 协议',
    'firewall-rule.remoteAddresses' => '远程地址',
    'firewall-rule.remoteAddressesHint' => '例如：192.168.0.1 or 192.168.0.0/16',
    'firewall-rule.newRule' => '新建规则',
    'firewall-rule.successNew' => '已添加了防火墙规则。',
    'firewall-rule.successEdit' => '已更新了防火墙规则。',

    'mail.lists-server-settings.email' => "邮件列表管理员的邮件地址",
    'mail.lists-server-settings.emptyEmail' => '请提供电子邮件地址。',
    'mail.lists-server-settings.newPassword' => '新密码',
    'mail.lists-server-settings.emptyPassword' => '请提供一个密码。',
    'mail.lists-server-settings.passwordConfirmation' => '确认密码',
    'mail.lists-server-settings.mailingListSoftwareWasConfigured' => '已配置邮件列表软件。',

    'mail.outgoing-messages.hint' => '在此处您可以指定一个邮箱的传出信息的限制。',
    'mail.outgoing-messages.mailBoxOutgoingMessages' => '传出邮件信息的最大数量',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainDefault' => '默认（每小时 %%domainOutgoingMessages%% 条信息）',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecific' => '该邮箱的自定义值',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecificHint' => '条信息（每小时）',

    'mail-gate-settings.host' => '主机名称或 IP 地址',
    'mail-gate-settings.port' => '端口',
    'mail-gate-settings.login' => '用户名',
    'mail-gate-settings.password' => '密码',
    'mail-gate-settings.encryption' => 'SMTP 服务器需要加密连接',
    'mail-gate-settings.allowUsers' => '允许用户脚本通过该 SMTP 服务器 （使用指定的用户名和密码）发送邮件。',
    'mail-gate-settings.useDefaultSettings' => '使用与 Plesk 一起安装的邮件服务器和 Plesk 创建的默认邮件帐户',

    'mail-gate.hint' => '您可在此指定当未安装 Plesk 邮件服务器或 Plesk 邮件服务器被禁止外发邮件时该使用的 SMTP 服务器。该服务器将被 Plesk 用作 SMTP 中继以及用于发送如邮件通知之类等外发邮件的用户脚本。',
    'mail-gate.enableMailGate' => '允许 Plesk 通过该 SMTP 服务器发送邮件通知',
    'mail-gate.notifications' => '由外部 SMTP 服务器发送的邮件通知',
    'mail-gate.smtpSettings' => '外部的 SMTP 服务器设置',

    'optimization-settings.apacheModulesSection' => 'Apache 模块',
    'optimization-settings.apacheSettingsSection' => '通用设置',
    'optimization-settings.additionalPageHint' => '只有在您完全了解所做操作带来的后果影响后再切换模块。注意某些修改可能会降低 Apache 的性能或甚至会导致其无法正常运行。',
    'optimization-settings.pageHint' => '在此处您可以通过关闭未使用的 Apache 模块优化 Plesk。该优化会提升内存利用率而能够让您服务更多主机客户。注意，一些模块是相互依附的，只有关闭（启用）其依附的模块才能关闭（启用）该模块。',
    'optimization-settings.advancedUsersOnlyWarning' => '该功能仅适用于高级用户。',
    'optimization-settings.apacheRestartInterval' => 'Apache 重启间隔（秒）',
    'optimization-settings.apacheRestartIntervalHint' => 'Plesk 会对域名和子域名所做的修改在指定的间隔时间内检查一次。如果有些修改需要重启 web 服务器，Plesk 会重启 Apache。',
    'optimization-settings.gracefulRestart' => 'Apache 平滑重启',
    'optimization-settings.gracefulRestartHint' => '选中此复选框以避免每次更改主机设置时服务器上托管的所有网站出现停机情况。',
    'optimization-settings.pipedLog' => '管道日志',
    'optimization-settings.mpmMode' => 'MPM 模式',
    'optimization-settings.moduleDeprecated' => '（已弃用）',

    'personal-info.contactInfoSection' => '联系信息',
    'personal-info.hint' => '您可以在此处编辑用户联系信息。',
    'personal-info.hintMyProfile' => '您可以在此处编辑联系信息。',

    'php-handler.extension.title' => '安装 PECL 程序包',
    'php-handler.extension.description' => "您可以通过使用程序包名指定附加参数来安装扩展的测试版，例如， 'msgpack-beta'。",
    'php-handler.extension.name' => '程序包名',

    'php-handler.ini.formHint' => '该 php.ini 文件仅被该处理程序使用。',
    'php-handler.ini.formHintSharedIni' => '该 php.ini 文件还被以下 PHP 处理程序使用：%%handlers%%。该设置应用到使用这些处理程序的所有网站。',
    'php-handler.ini.incorrectTextForIniFile' => "指定的设置不正确且无法被保存到 php.ini 文件。错误：%%message%%。",

    'plan-item-custom.planItemName' => '服务名称',
    'plan-item-custom.buttonLabel' => '此名称还将用作自定义按钮的标签',
    'plan-item-custom.planItemDescription' => '服务订阅',
    'plan-item-custom.buttonTooltip' => '此文本还将用作自定义按钮的工具提示',
    'plan-item-custom.url' => '连接到自定义按钮的 URL',
    'plan-item-custom.backgroundImage' => '自定义按钮的背景图片',
    'plan-item-custom.emptyItemName' => '请提供服务标签。',
    'plan-item-custom.emptyItemDescription' => '请提供用于服务工具提示的文本。',
    'plan-item-custom.emptyUrl' => '请指定一个URL。',
    'plan-item-custom.longItemName' => '此服务标签太长。允许的最大长度为 %max% 符号。',
    'plan-item-custom.longItemDescription' => '此服务文本太长。允许的最大长度为 %max% 符号。',
    'plan-item-custom.longUrl' => '此 URL 太长。允许的最大长度为 %max% 符号。',
    'plan-item-custom.useCustomButton' => '使用自定义按钮',
    'plan-item-custom.useCustomButtonHint' => '将自定义按钮置于用户的首页与网站页面。',
    'plan-item-custom.openCustomButtonInSameWindow' => '在 Plesk 中打开 URL',
    'plan-item-custom.openCustomButtonInSameWindowDescription' => '指定是否在 Plesk 页面上或新的浏览器窗口中打开 URL。',
    'plan-item-custom.openCustomButtonWithoutFrame' => '不要使用帧',
    'plan-item-custom.openCustomButtonWithoutFrameDescription' => '若您添加一个自定义按钮，通过该按钮能够进入客户面板中的 Plesk 扩展或某个应用程序，则可以指定显示该扩展/应用程序的方式：在帧中或作为 Plesk GUI 的一部分显示。',
    'plan-item-custom.includeDomId' => '包含订阅 ID',
    'plan-item-custom.includeDomIdDescription' => '&dom_id=<dom_id>',
    'plan-item-custom.includeDomName' => '包含主域名',
    'plan-item-custom.includeDomNameDescription' => '&dom_name=<dom_name>',
    'plan-item-custom.includeFtpUser' => '包含 FTP 用户名',
    'plan-item-custom.includeFtpUserDescription' => '&ftp_user=<ftp_user>',
    'plan-item-custom.includeFtpPass' => '包含 FTP 密码',
    'plan-item-custom.includeFtpPassDescription' => '&ftp_pass=<ftp_pass>',
    'plan-item-custom.includeClId' => '包含客户ID',
    'plan-item-custom.includeClIdDescription' => '&cl_id=<cl_id>',
    'plan-item-custom.includeCname' => "包含客户的公司名称",
    'plan-item-custom.includeCnameDescription' => '&cname=<cname>',
    'plan-item-custom.includePname' => "包含客户的联系名称",
    'plan-item-custom.includePnameDescription' => '&pname=<pname>',
    'plan-item-custom.includeEmail' => "包含客户的电子邮箱",
    'plan-item-custom.includeEmailDescription' => '&email=<email>',

    'preview-domain-settings.previewType' => '选择如何预览网站',
    'preview-domain-settings.previewQuick' => '默认的快速预览',
    'preview-domain-settings.previewDisabled' => '禁用快速预览',
    'preview-domain-settings.previewQuickDescription' => '即刻预览，推荐此选项。',
    'preview-domain-settings.previewZoneTypeInternal' => '在 Plesk 中的一个域名上快速预览',
    'preview-domain-settings.previewZoneDomainIdDescription' => '选择一个 Plesk 网站用于预览。',
    'preview-domain-settings.previewZoneDomainCreate' => '若要使用该功能，至少%%link%%一个域名。',
    'preview-domain-settings.subscriptionCreateLink' => '创建',
    'preview-domain-settings.previewZoneTypeExternal' => '在一个外部域名上快速预览',
    'preview-domain-settings.previewZoneDomainNameDescription' => '使用外部域名（DNS 区域）。如果您使用该选项，添加以下 DNS 记录（A 类型）至外部域名区域： *.<Plesk_IP>.external.dom。此处的 <Plesk_IP> 是 Plesk 服务器 IP，其中代表 IPv4 的点号（.）或代表 IPv6 的冒号（:）都由破折号（-）代替。如，*.192-0-2-12.external.dom。如果 Plesk 有多个注册的 IP 地址，请为每一个地址添加一个记录。',
    'preview-domain-settings.sitePreviewProtection' => '需要验证',
    'preview-domain-settings.sitePreviewProtectionDescription' => '需要 FTP 登录名和密码才能预览。',
    'preview-domain-settings.nginxNotInstalled' => '无法进行默认的快速预览因为未安装 nginx web 服务器。',
    'preview-domain-settings.nginxDisabled' => '无法进行默认的快速预览因为 nginx web 服务器已被禁用。',

    'reseller-preferences.settingsSection' => '设置',
    'reseller-preferences.multiLogin' => '允许多个会话',
    'reseller-preferences.language' => '界面语言',
    'reseller-preferences.interfaceView' => '选择界面',
    'reseller-preferences.serviceProviderView' => '服务提供商视图',
    'reseller-preferences.serviceProviderViewHint' => '此视图适用于那些使用服务方案向其客户提供和销售 web 主机服务的服务器管理员。',
    'reseller-preferences.powerUserView' => '高级用户视图',
    'reseller-preferences.powerUserViewHint' => '此视图最适合于管理网站、其文件、数据库、电子邮件帐户、web应用程序和其他服务。',

    'reseller.hint' => '您可在此新增代理商并为其订阅主机服务。',
    'reseller.contactInfoSection' => '联系信息',
    'reseller.contactInfoSectionHint' => '输入代理商联系信息。',
    'reseller.accessToPanelSection' => '访问 Plesk',
    'reseller.accessToPanelSectionHint' => '代理商将用于访问 Plesk 管理其注册的服务的验证凭据。',
    'reseller.subscription' => '订阅',
    'reseller.subscriptionSectionHint' => '选择代理商要订阅的服务方案。',
    'reseller.servicePlan' => '服务方案',
    'reseller.none' => '无',
    'reseller.customizeSubscription' => '创建代理商后，继续自定义订阅参数。注意，执行此操作会锁定订阅而不能同步。',
    'reseller.subscriptionNotSynchronized' => '无法将订阅与服务方案同步。订阅的下列设置与服务方案冲突：%%problems%%。',

    'security-policy.encryptionSection' => '增强安全模式',
    'security-policy.encryptionSectionHint' => '增强安全模式引入了对 Plesk 中敏感数据的增强保护。在这种模式下，Plesk 采用了多个安全机制，这些机制对 Plesk 用户来说是绝对透明的。为了提升 Plesk 的安全度，我们建议您打开该模式。',
    'security-policy.encryptionEnable' => '增强安全模式',
    'security-policy.securePassword' => '增强安全模式',
    'security-policy.strengthSection' => '密码强度',
    'security-policy.strengthSectionHint' => '大多数用户可以在Plesk中设置或更改的密码都要经过验证，以确保它们满足这里设置的最低密码强度要求。强密码至少有9-12个字符长，包括数字、大写字母和小写字母、特殊字符，没有字典单词。这些相对难猜测，但也要记住。<a href="%%link%%" target="_blank">了解更多有关密码强度的信息</a>。',
    'security-policy.passwordStrength' => '最小密码强度',
    'security-policy.secureFtpSection' => '安全 FTP',
    'security-policy.ftpOverSsl' => 'FTPS 使用策略',
    'security-policy.ftpOverSslHint' => 'FTPS 用于使用 SSL/TLS 协议保护 FTP 服务器与外部 FTP 客户端之间的通信安全。您可在此选择允许哪种连接。',
    'security-policy.ftpOverSslWithCustomOptionHint' => 'FTPS 用于使用 SSL/TLS 协议保护 FTP 服务器与外部 FTP 客户端之间的通信安全。您可在此选择允许哪种连接。选定的选项将应用到服务器上所有的 IP 地址。若要按每 IP 地址使用自定义设置，请选择相应的选项，然后在 工具与设置> IP 地址 中更改 FTPS 策略。',
    'security-policy.ftpOverSslCustomHint' => 'FTPS 用于使用 SSL/TLS 协议保护 FTP 服务器与外部 FTP 客户端之间的通信安全。',
    'security-policy.ftpOverSslCustomDisabledHint' => 'FTPS 用于使用 SSL/TLS 协议保护 FTP 服务器与外部 FTP 客户端之间的通信安全。如果要按每 IP 地址调整 FTPS 设置，请首先进入 工具与设置 > 安全策略 > 安全 FTP 中选择选项 "按每 IP 地址使用自定义 FTPS 设置"。',
    'security-policy.ftpOverSslOptionRequired' => '仅允许安全 FTPS 连接',
    'security-policy.ftpOverSslOptionEnabled' => '允许安全 FTPS 和非安全 FTP 连接',
    'security-policy.ftpOverSslOptionDisabled' => '仅允许非安全 FTP 连接。不使用 FTPS',
    'security-policy.ftpOverSslOptionCustom' => '每 IP 地址使用自定义 FTPS 策略',
    'security-policy.prohibitWebConfigHandlersSection' => '自定义处理程序策略',
    'security-policy.prohibitWebConfigHandlersSectionHint' => '启用此选项以禁止客户通过 web.config 文件覆盖在服务器级别定义的 IIS 处理程序。',
    'security-policy.prohibitWebConfigHandlers' => '禁止通过 web.config 覆盖处理程序',

    'server-mail-antivirus.used' => '使用的反病毒软件',
    'server-mail-antivirus.policy' => '使用服务器级设置',
    'server-mail-antivirus.policyOff' => '扫描关闭',
    'server-mail-antivirus.policyAny' => '扫描传入和传出邮件',
    'server-mail-antivirus.policyFrom' => '仅扫描传出邮件',
    'server-mail-antivirus.policyTo' => '仅扫描传入邮件',
    'server-mail-antivirus.allowPersonalSettings' => '允许个人设置',
    'server-mail-antivirus.incoming' => '用于传入邮件',
    'server-mail-antivirus.outgoing' => '用于传出邮件',
    'server-mail-antivirus.success' => '防病毒设置已更改。',

    'server-mail-black-list.title' => '将域名添加到黑名单中',
    'server-mail-black-list.domainName' => '域名',
    'server-mail-black-list.emailAddress' => '电子邮件地址',
    'server-mail-black-list.emailAddressHint' => '“@”符号左边不得含有非 ASCII 字符。地址可以包含“*”和“?”通配符 (如：*@domain.com、user?@*.com)。域名的非 ASCII 部分不得包含通配符。',
    'server-mail-black-list.action' => '对符合标准的邮件执行的操作：',
    'server-mail-black-list.actionDelete' => '从服务器删除',
    'server-mail-black-list.actionSpam' => '标识为垃圾邮件',
    'server-mail-black-list.success' => '域名被添加到黑名单中。',

    'server-mail-white-list.title' => '将网络添加到白名单',
    'server-mail-white-list.descEmailAddress' => '在这里指定的电子邮件地址将不会被SpamAssassin识别为垃圾邮件。',
    'server-mail-white-list.descIpAddress' => '此处指定的IP条目将被添加到邮件服务器的例外项中。',
    'server-mail-white-list.ipAddress' => 'IP 地址/掩码',
    'server-mail-white-list.ipAddressHint' => 'IP 地址可以包含通配符或 CIDR 掩码。',
    'server-mail-white-list.emailAddress' => '电子邮件地址',
    'server-mail-white-list.emailAddressHint' => '“@”符号左边不得含有非 ASCII 字符。地址可以包含“*”和“?”通配符 (如：*@domain.com、user?@*.com)。域名的非 ASCII 部分不得包含通配符。',
    'server-mail-white-list.emailAddressOrIp' => '电子邮件或IP地址',
    'server-mail-white-list.wildcardPattern' => 'IP地址可以包含通配符(例如，123.123.*.123)。',
    'server-mail-white-list.cidrPattern' => 'IP地址可以包含CIDR掩码(例如，10.0.0.0/8)。',
    'server-mail-white-list.success' => '网络被添加到白名单中。',

    'server-mail-settings.general.title' => '常规选项',
    'server-mail-settings.general.mailUiEnabled' => '在 Plesk 里启用邮件管理功能',
    'server-mail-settings.general.serverName' => '安装的邮件服务器',
    'server-mail-settings.general.changeServerName' => '安装并使用其它邮件服务器',
    'server-mail-settings.general.imapServerName' => '已安装 IMAP/POP3 服务器',
    'server-mail-settings.general.changeImapServerName' => '安装和使用其它 IMAP/POP3 服务器',
    'server-mail-settings.general.changeServerHint' => '您可以 %%serverChangeLink%%',
    'server-mail-settings.general.maxMessageSize' => '最大邮件大小',
    'server-mail-settings.general.kbytes' => 'KB',
    'server-mail-settings.general.maxConnections' => '连接（IMAP、POP3、IMAP over SSL/TLS 或 POP3 over SSL/TLS）的最大数量',
    'server-mail-settings.general.maxConnectionsHintCourier-IMAP' => '启动的服务器 (IMAP 或 POP3) 的最大数量。',
    'server-mail-settings.general.maxConnectionsHintDovecot' => '同时可登录的邮件用户的最大数量。',
    'server-mail-settings.general.maxConnectionsPerIpCourier-IMAP' => '每个 IP 地址的连接的最大数量',
    'server-mail-settings.general.maxConnectionsPerIpDovecot' => '每个 IP 地址一个用户可连接的最大数量。',
    'server-mail-settings.general.maxConnectionsPerIpHintCourier-IMAP' => '接受来自同一 IP 地址的连接（IMAP、POP3、IMAP over SSL/TLS 或 POP3 over SSL/TLS）的最大数量。',
    'server-mail-settings.general.maxConnectionsPerIpHintDovecot' => '允许邮件用户接收来自每个 IP 地址的连接（IMAP、POP3、IMAP over SSL/TLS 或 POP3 over SSL/TLS）的最大数量。',
    'server-mail-settings.general.messageSubmission' => '启用端口 587 上的 SMTP 服务',
    'server-mail-settings.general.messageSubmissionOnAllIp' => '在所有 IP 地址上启用端口 587 上的 SMTP 服务',
    'server-mail-settings.general.messageSubmissionBindTo' => '启用',
    'server-mail-settings.general.messageSubmissionAllIpAddresses' => '所有 IP 地址',
    'server-mail-settings.general.outgoingEmailMode' => '传出邮件模式',
    'server-mail-settings.general.outgoingEmailModeDomainIp' => '发自域名的 IP 地址',
    'server-mail-settings.general.outgoingEmailModeDomainName' => '发自域名的 IP 地址并在 SMTP 问候中使用域名',
    'server-mail-settings.general.outgoingEmailModeExplicitIp' => '发自指定的 IP 地址',
    'server-mail-settings.general.outgoingEmailModeExplicitIpV4' => 'IPv4',
    'server-mail-settings.general.outgoingEmailModeExplicitIpV6' => 'IPv6',
    'server-mail-settings.general.outgoingEmailModeExplicitIpNone' => '无',
    'server-mail-settings.general.subaddressing' => '开启电子邮件子寻址',
    'server-mail-settings.general.subaddressingHint' => '此选项会开启为邮件列表配置 %%verpStyleLink%% 电子邮箱地址的功能',
    'server-mail-settings.general.verpStyleLink' => 'VERP 式',
    'server-mail-settings.general.mboxQuotaWarning' => '启用邮箱配额警告',
    'server-mail-settings.general.mboxQuotaWarningHint' => '当邮件用户的邮箱配额使用超过了 95% 时发送通知给邮件用户',
    'server-mail-settings.general.mboxQuotaWarningChange' => '自定义默认的邮箱配额警告',
    'server-mail-settings.general.fixSender' => '修复外发邮件的错误设置的发件人',
    'server-mail-settings.general.fixSenderHint' => '自动为从域名外发邮件设置有效的电子邮件信息头和发件人信封地址以降低被视作垃圾邮件的风险',

    'server-mail-settings.autodiscover.title' => '邮件 autodiscover',
    'server-mail-settings.autodiscover.description' => '查看其在 %%link%% 中是如何工作运行的',
    'server-mail-settings.autodiscover.link' => '知识库',
    'server-mail-settings.autodiscover.enabled' => '启用邮件 autodiscover',
    'server-mail-settings.autodiscover.enabledHint' => '启用此功能会重新配置启用了 autodiscover 的所有域名',
    'server-mail-settings.autodiscover.customServer' => '为邮件 autodiscover 指定一个自定义域名',
    'server-mail-settings.autodiscover.customServerHint' => '注意：域名必须使用有效的 SSL/TLS 证书进行安全保护。',
    'server-mail-settings.autodiscover.reconfigureDns' => '重新配置 autodiscover DNS 记录',
    'server-mail-settings.autodiscover.reconfigureDnsHint' => '启用此功能会重新配置启用了 autodiscover 的所有域名 autodiscover DNS 记录',

    'server-mail-settings.relay.title' => '中继选项',
    'server-mail-settings.relay.type' => "邮件中继",
    'server-mail-settings.relay.open' => "打开",
    'server-mail-settings.relay.openSpamWarning' => "打开邮件中继会使邮件服务器出现垃圾邮件。",
    'server-mail-settings.relay.openSpamChange' => "只有当您想暂时测试邮件服务器或您的Plesk服务器在内部网络中，无法通过互联网访问时，才保留该设置。",
    'server-mail-settings.relay.closed' => "关闭",
    'server-mail-settings.relay.auth' => "需要验证：",
    'server-mail-settings.relay.notSupported' => "邮件服务器不支持",
    'server-mail-settings.relay.change' => '若要实现 Plesk 能够在中继关闭时发送通知，则可以 %%changeLink%%',
    'server-mail-settings.relay.changeLink' => '更改 SMTP 设置',
    'server-mail-settings.relay.pop3' => "POP3优先SMTP",
    'server-mail-settings.relay.lockTime' => "锁定时间",
    'server-mail-settings.relay.min' => "分钟",
    'server-mail-settings.relay.smtp' => "SMTP",
    'server-mail-settings.relay.noRelayNetworks' => '对下面的网络使用无中继限制：',
    'server-mail-settings.relay.noRelayNetworksHint' => "IP 地址/掩码",

    'server-mail-settings.outgoing.title' => '对发送电子邮件信息的限制',
    'server-mail-settings.outgoing.description' => '以下限制是默认的。这些限制可在每个服务方案和订阅中被覆盖。此等限制不是服务器范围的，但是可作为未指定自定义限制的方案和订阅的模板。注意对外发电子邮件信息开启限制可能会影响邮件服务器的性能。%%link%%',
    'server-mail-settings.outgoing.learnMore' => '了解有关限制发送邮件的更多信息',
    'server-mail-settings.outgoing.enabled' => '对外发电子邮件信息开启限制',
    'server-mail-settings.outgoing.countRecipients' => '计算收件人的数量，而不是邮件',
    'server-mail-settings.outgoing.countRecipientsHint' => '在限制发送邮件和计数统计时，启用计算收件人而非邮件数量的模式。例如，发送给10个收件人的一条消息将被计算为10条消息。',
    'server-mail-settings.outgoing.mailboxLimit' => '发自一个邮箱的信息默认限制（每小时）',
    'server-mail-settings.outgoing.domainLimit' => '发自一个域名的信息默认限制（每小时）',
    'server-mail-settings.outgoing.subscriptionLimit' => '发自一个订阅的信息默认限制（每小时）',
    'server-mail-settings.outgoing.unlimited' => '无限',
    'server-mail-settings.outgoing.sendmail' => '允许用户和脚本使用 Sendmail',
    'server-mail-settings.outgoing.sendmailHint' => '即使在超过了邮箱和域名的限制的情况下脚本和用户也将能够使用  Sendmail 发送邮件信息（代表订阅的系统用户）。可通过 Sendmail 发送的信息最大数量将由整个订阅的限制所定义。该设置不允许脚本在整个服务器范围使用 Sendmail，但是作为服务方案和订阅的默认设置。',
    'server-mail-settings.outgoing.reportPeriod' => '显示基于上一次统计的报告',
    'server-mail-settings.outgoing.reportPeriodHint' => '会创建报告，且会在首页显示有关在指定期限内尝试超过邮件传出限制的警告。',
    'server-mail-settings.outgoing.notificationPeriod' => '发送邮件通知，每隔',
    'server-mail-settings.outgoing.notificationPeriodHint' => '该通知会提供有关在指定期限内尝试超过邮件传出限制的统计。',
    'server-mail-settings.outgoing.periodP1D' => '1 日',
    'server-mail-settings.outgoing.periodP1W' => '1 周',
    'server-mail-settings.outgoing.periodP2W' => '2 周',
    'server-mail-settings.outgoing.periodP1M' => '1 个月',
    'server-mail-settings.outgoing.periodPT15M' => '15 分钟',
    'server-mail-settings.outgoing.periodPT1H' => '1 小时',
    'server-mail-settings.outgoing.periodPT6H' => '6 小时',
    'server-mail-settings.outgoing.periodPT12H' => '12 小时',
    'server-mail-settings.outgoing.whiteListNotEmpty' => '对传出邮件的限制将不适用于IP地址来自邮件服务器白名单的发件人。例如，如果在白名单中有 localhost (127.0.0.0 / 8, ::1 / 128)，不管该限制如何，所有本地服务器的邮件将被成功发送。发件人可以使用本地IP地址（在本地服务器上托管的网站和自定义脚本）或外部IP地址（通过安装在电脑或移动设备上的邮件客户端发送邮件的客户）。要实现该限制适用于所有发件人（本地的和外部的），请移除所有来自白名单的IP地址和网络。请注意，移除来自白名单的 localhost (127.0.0.0 / 8, ::1 / 128) 可能干扰该服务器发送邮件网站和脚本的操作。了解有关传出邮件限制的详情，请查看管理员指南，来自 Outbound Spam 的防护。',
    'server-mail-settings.outgoing.relayIsOpen' => '邮件中继已打开：将无法实现对传出邮件的限制。',
    'server-mail-settings.outgoing.domainLimitExceedsSubscriptionLimit' => '一个域名的传出信息限制 (%%value%%) 不得大于一个订阅的传出信息限制 (%%highLevelLimitValue%%)。',
    'server-mail-settings.outgoing.mailboxLimitExceedsDomainLimit' => '一个电子邮件地址的传出信息限制 (%%value%%) 不得大于一个域名的传出信息限制 (%%highLevelLimitValue%%).',
    'server-mail-settings.outgoing.mailboxLimitExceedsSubscriptionLimit' => '一个电子邮件地址的传出信息限制 (%%value%%) 不得大于一个订阅的传出信息限制 (%%highLevelLimitValue%%).',

    'server-mail-settings.mailman.title' => 'Mailman 设置',
    'server-mail-settings.mailman.secureLinks' => '在邮件列表中使用安全链接',
    'server-mail-settings.mailman.secureLinksHint' => '启用或禁用邮件列表中的安全 (HTTPS) 链接生成。',
    'server-mail-settings.mailman.noLocalhost' => '若要使用邮件列表，您需要在邮件服务器的白名单中设置有本地主机 (127.0.0.0/8, ::1/128) 。但是，若要使用传出邮件控制，白名单中则不需要有本地主机。如果您已经激活了传出邮件控制，那么可使用折中方案，即在邮箱上使用邮件转发而非邮件列表。',
    'server-mail-settings.mailman.noLocalhostIpv4' => '若要使用邮件列表，您需要在邮件服务器的白名单中有本地主机。但是，若要使用传出邮件控制，白名单中则不需要有本地主机。如果您已经激活了传出邮件控制，那么可使用折中方案，即在邮箱上使用邮件转发而非邮件列表。注意现在白名单中没有 IPv4 本地主机地址 (127.0.0.0/8)，因此传出邮件控制功能将用于 IPv4 地址。',
    'server-mail-settings.mailman.noLocalhostIpv6' => '若要使用邮件列表，您需要在邮件服务器的白名单中有本地主机。但是，若要使用传出邮件控制，白名单中则不需要有本地主机。如果您已经激活了传出邮件控制，那么可使用折中方案，即在邮箱上使用邮件转发而非邮件列表。注意现在白名单中没有 IPv6 本地主机地址 (::1/128)，因此传出邮件控制功能将用于 IPv6 地址。',

    'server-mail-settings.spam-filter.dmarc' => 'DMARC',
    'server-mail-settings.spam-filter.dmarcEnabled' => '启用 DMARC 以检查传入邮件',
    'server-mail-settings.spam-filter.dmarcHint' => '当为传入邮件启用了 DKIM 和 SPF 时此选项可用。',
    'server-mail-settings.spam-filter.dkim' => 'DKIM 垃圾邮件防护',
    'server-mail-settings.spam-filter.singOutgoing' => '允许给发件签名',
    'server-mail-settings.spam-filter.verifyIncoming' => '验证传入邮件',
    'server-mail-settings.spam-filter.verifyIncomingHint' => '当为传入邮件启用了 DMARC 时，可能无法关闭此选项。',
    'server-mail-settings.spam-filter.spf' => 'SPF 垃圾邮件防护',
    'server-mail-settings.spam-filter.spfEnabled' => '启用 SPF 垃圾邮件防护措施以检查传入邮件',
    'server-mail-settings.spam-filter.spfEnabledHint' => '当为传入邮件启用了 DMARC 时，可能无法关闭此选项。',
    'server-mail-settings.spam-filter.ignoreErrors' => '当有 DNS 查找问题时继续 SPF 检查',
    'server-mail-settings.spam-filter.ignoreErrorsHint' => '首先，SPF 会执行 DNS 查找。若选择该选项，如果 DNS 查找失败则仍会继续检查。如果在当前的检查模式中没有任何效果则取消选定该选项。',
    'server-mail-settings.spam-filter.behavior' => 'SPF检查模式',
    'server-mail-settings.spam-filter.behaviorHint' => '然后，SPF 会应用本地和猜测规则。可能会根据选定的检查模式和检查结果拒绝邮件信息。',
    'server-mail-settings.spam-filter.behaviorCreateHeadersNoBlock' => '只创建 Received-SPF 标头信息，不屏蔽',
    'server-mail-settings.spam-filter.behaviorUseTmpErrors' => 'DNS查找出现问题时，使用临时错误通知',
    'server-mail-settings.spam-filter.behaviorRejectIfFail' => 'SPF解析为“失败”(拒绝)时，退信',
    'server-mail-settings.spam-filter.behaviorRejectIfSoftfail' => 'SPF解析为“软失败”时，退信',
    'server-mail-settings.spam-filter.behaviorRejectIfNeutral' => 'SPF解析为“中性”时，退信',
    'server-mail-settings.spam-filter.behaviorRejectIfNoPass' => 'SPF没有解析为“通过”时，退信',
    'server-mail-settings.spam-filter.localRules' => 'SPF本地规则',
    'server-mail-settings.spam-filter.guessRules' => 'SPF猜测规则',
    'server-mail-settings.spam-filter.explanationText' => 'SPF解释文本',
    'server-mail-settings.spam-filter.rbl' => "基于 DNS blackhole lists 的垃圾邮件防护措施",
    'server-mail-settings.spam-filter.rblEnabled' => "关闭基于 DNS blackhole lists 的垃圾邮件防护措施",
    'server-mail-settings.spam-filter.rblServer' => "DNSBL 服务的 DNS 区域",
    'server-mail-settings.spam-filter.rblServerHint' => "使用分号隔开项目，例如：'zen.spamhaus.org;dnsbl.example.net'",

    'server-mail-settings.auto-reply-headers.title' => '额外的自动回复消息头',
    'server-mail-settings.auto-reply-headers.description' => '为来自Plesk服务器的任何自动回复消息设置额外的消息头。',
    'server-mail-settings.auto-reply-headers.extra' => '额外的消息头',

    'server-mail-settings.pop3-names.title' => "POP3/IMAP 邮件帐户名",
    'server-mail-settings.pop3-names.disabled' => "只能使用 POP3/IMAP 邮件账户的全名",
    'server-mail-settings.pop3-names.enabled' => "可使用 POP3/IMAP 邮件账户的简称 (webmaster) 或全名 (webmaster@domain.com)。",

    'server-mail-settings.success' => '邮件服务器设置已更改。',

    'server-mail-spam-filter.general' => '常用',
    'server-mail-spam-filter.isEnabled' => '启用服务器级SpamAssassin垃圾邮件过滤',
    'server-mail-spam-filter.isUserSettingsEnabled' => '将单个设置应用到垃圾邮件过滤中',
    'server-mail-spam-filter.isUserSettingsEnabledHint' => "垃圾邮件过滤功能已禁用：邮件服务器不支持邮箱级的垃圾邮件过滤功能。",
    'server-mail-spam-filter.settings' => 'SpamAssassin设置',
    'server-mail-spam-filter.requiredHits' => '邮件被标识为垃圾邮件需获得的分值',
    'server-mail-spam-filter.maxMailLimit' => '如果邮件大小超过此值，不要过滤',
    'server-mail-spam-filter.maxMailLimitText' => '大小限制',
    'server-mail-spam-filter.kbytes' => "KB",
    'server-mail-spam-filter.maxThreadsLimit' => '垃圾邮件过滤器可创建的线程数量',
    'server-mail-spam-filter.tag' => '将下列文本添加至被视为垃圾邮件的每封邮件的主题开头',
    'server-mail-spam-filter.byTag' => '按标签',
    'server-mail-spam-filter.alarmMessage' => '垃圾邮件警报文本',
    'server-mail-spam-filter.languages' => '可信的语言',
    'server-mail-spam-filter.locales' => '可信的区域设置',
    'server-mail-spam-filter.success' => '垃圾邮件过滤器配置已更改。',

    'service-instance.setup-instance.resourcesSection' => '服务资源',
    'service-instance.setup-instance.requiredServiceAlreadyInstalled' => '已安装',
    'service-instance.setup-instance.requirementsSection' => '需要的服务',
    'service-instance.setup-instance.requiredServiceNotSelected' => '未选择',

    'service-node.ipAddress' => '服务节点 IP 地址',
    'service-node.ipAddressLocal' => '本地服务节点',
    'service-node.description' => '服务节点描述',
    'service-node.accessKey' => '密码',
    'service-node.useAccessKey' => '使用验证',
    'service-node.useAccessKeyDescription' => '关于使用验证的提示。',
    'service-node.oldAccessKey' => '旧密码',
    'service-node.newAccessKey' => '新密码',
    'service-node.noAccessKeySpecified' => '未指定密码',

    'service-plan.admin-plan.subscription_section' => '通用',
    'service-plan.admin-plan.tools_section' => '工具与资源',
    'service-plan.admin-plan.apps_section' => '应用程序与数据库',
    'service-plan.admin-plan.panel_section' => 'Plesk',
    'service-plan.admin-plan.appearance_section' => 'Plesk 外观',
    'service-plan.admin-plan.statistics_section' => '统计',
    'service-plan.admin-plan.general_section' => '常用',
    'service-plan.admin-plan.mail_section' => '邮件',
    'service-plan.admin-plan.server_section' => '服务器',
    'service-plan.admin-plan.modules_section' => '扩展',
    'service-plan.admin-plan.troubleshooting_section' => '帮助与故障排除',
    'service-plan.admin-plan.simplePanel' => '限制模式',
    'service-plan.admin-plan.enabled' => '启用限制模式',
    'service-plan.admin-plan.enabledDescription' => '选择此选项来限制管理员可以在Plesk中采取操作的次数。',
    'service-plan.admin-plan.aliasEnabledDescription' => '选择此选项来限制其它管理员可以在Plesk中采取操作的次数。',

    'service-plan.applications-subscription.useFilterLabel' => '只提供我选择的应用程序',
    'service-plan.applications-subscription.useFilterDescription' => '使用该选项选择订户可用的应用程序。',
    'service-plan.applications-subscription.applications' => '应用程序',
    'service-plan.applications-subscription.isCommercial' => '该应用程序为商业应用程序需要购买许可证密钥。',

    'service-plan.applications.useFilterLabel' => '只提供我选择的应用程序',
    'service-plan.applications.useFilterDescription' => '使用该选项选择订户可用的应用程序。',
    'service-plan.applications.applications' => '应用程序',
    'service-plan.applications.isCommercial' => '该应用程序为商业应用程序需要购买许可证密钥。',

    'service-plan.dns.dnsZoneType' => '域名 DNS 区域',
    'service-plan.dns.dnsZoneTypeMaster' => '主要',
    'service-plan.dns.dnsZoneTypeSlave' => '辅助',

    'service-plan.extras.groupOtherServices' => '其它服务',
    'service-plan.extras.none' => '无',

    'service-plan.hosting.enablePhysicalHosting' => '启用主机',
    'service-plan.hosting.sectionCoreHosting' => '常规属性',
    'service-plan.hosting.sectionScripting' => '脚本',
    'service-plan.hosting.defaultDatabaseServer' => '默认的数据库服务器',
    'service-plan.hosting.versionCut' => 'v%%version%%',
    'service-plan.hosting.sectionAdvanced' => '高级',
    'service-plan.hosting.phpSettingsHelpLink' => '了解如何选择最适合的PHP设置',
    'service-plan.hosting.unpaidWebsiteStatusLabelSubscription' => '订阅被挂起时网站的状态',
    'service-plan.hosting.unpaidWebsiteStatusLabel' => '已被挂起订阅中的网站状态',
    'service-plan.hosting.unpaidWebsiteStatusDescription' => '当订阅被挂起（例如，订阅到期）时选定的状态将被应用到方案订阅下的所有网站。',
    'service-plan.hosting.unpaidWebsiteStatusDescriptionSubscription' => '当订阅被挂起（例如，订阅到期）时选定的状态将被应用到网站。',
    'service-plan.hosting.unpaidWebsiteStatusDisabled' => '禁用',
    'service-plan.hosting.unpaidWebsiteStatusDisabledHint' => '网站访客将被重定向至 web 服务器的默认页面。',
    'service-plan.hosting.unpaidWebsiteStatusSuspended' => '挂起',
    'service-plan.hosting.unpaidWebsiteStatusSuspendedHint' => '网站访客将会被重定向至自定义的错误文档页面（带有搜索引擎友好 503 HTTP 代码）。',
    'service-plan.hosting.unpaidWebsiteStatusActive' => '活动',
    'service-plan.hosting.unpaidWebsiteStatusActiveHint' => '将继续可以通过互联网访问网站。',

    'service-plan.ip.sharedIpAddresses' => '分配共享 IP 地址',
    'service-plan.ip.allocateExclusiveIp' => '分配独立 IP 地址',
    'service-plan.ip.allocateExclusiveIpV4' => '分配独立 IPv4 地址',
    'service-plan.ip.allocateExclusiveIpV6' => '分配独立 IPv6 地址',

    'service-plan.mail.mailService' => '启用邮件服务',
    'service-plan.mail.mailServiceDisabled' => '禁用',
    'service-plan.mail.mailServiceDisabledIncoming' => '已为接收邮件禁用',
    'service-plan.mail.mailServiceDisabledHint' => 'Plesk不会为此域名提供任何邮件服务。',
    'service-plan.mail.mailServiceDisabledIncomingHint' => 'Plesk将只为发送的电子邮件提供服务。在Plesk中由邮件控件设置的限制范围内，可以使用sendmail发送电子邮件。',
    'service-plan.mail.mailServiceEnabled' => '启用',
    'service-plan.mail.mailServiceEnabledHint' => 'Plesk将同时为接收的和发送的电子邮件提供服务。',
    'service-plan.mail.mailServiceNotConfigured' => '未配置',
    'service-plan.mail.mailServiceNotConfiguredHint' => 'Plesk将不会在此域名上提供任何邮件服务。',
    'service-plan.mail.webMail' => 'Web 邮箱',
    'service-plan.mail.mailingLists' => '启用邮件列表',
    'service-plan.mail.mailToNonExistentUser' => '关于不存在的用户的邮件策略',
    'service-plan.mail.mailToNonExistentUserBounce' => '退信通知',
    'service-plan.mail.mailToNonExistentUserRedirect' => '转发到地址',
    'service-plan.mail.mailToNonExistentUserReject' => '拒绝',
    'service-plan.mail.mailAutodiscovery' => '启用邮件 autodiscover',
    'service-plan.mail.mailAutodiscoveryDescription' => '请在 <a href="%%link%%" target="_blank">knowledge base</a> 中查看该功能是如何运行的',
    'service-plan.mail.bounceMessage' => '此地址不再接收邮件。',
    'service-plan.mail.mailToNonExistentUserexternalMailServer' => '重定向到该 IP 地址的外部邮件服务器：',
    'service-plan.mail.webmailDisabled' => '%%webmail%% - 禁用',

    'service-plan.misc.retainEnabled' => '保留网站和流量统计',
    'service-plan.misc.logRotation' => '日志循环',
    'service-plan.misc.logRotationCondition' => '日志循环条件',
    'service-plan.misc.logRotationBySize' => '按大小',
    'service-plan.misc.logRotationByTime' => '按时间',
    'service-plan.misc.logRotationDaily' => '每日',
    'service-plan.misc.logRotationWeekly' => '每周',
    'service-plan.misc.logRotationMonthly' => '每月',
    'service-plan.misc.logRotationSizeDescription' => '大小值必须在 %%min%% 与 %%max%% kB 之间。',
    'service-plan.misc.maximumNumberOfFiles' => '日志文件最大数量',
    'service-plan.misc.compress' => '压缩日志文件',
    'service-plan.misc.sendLogToEmail' => 'Plesk 从 web 和 FTP 服务器的日志文件检索数据后，会通过邮件发送日志到该地址',
    'service-plan.misc.kb' => 'KB',
    'service-plan.misc.months' => '个月',
    'service-plan.misc.logRotationPeriodGreater' => '日誌輪轉週期不能比伺服器範圍內的限制%%max%%長。',

    'service-plan.performance.iisAppPoolAddonsHint' => '如未启用，订阅的所有网站都会使用专用于该订阅的同一 IIS 应用程序池。',

    'service-plan.permissions-subscription.permissionsTabDescription' => '选择订阅的服务及权限。',
    'service-plan.permissions-subscription.showMorePermissions' => '显示更多可用权限',
    'service-plan.permissions-subscription.hideMorePermissions' => '显示较少权限',
    'service-plan.permissions-subscription.noShellManagement' => '不允许',
    'service-plan.permissions-subscription.systemAccessLabel' => '管理通过SSH访问服务器',
    'service-plan.permissions-subscription.systemAccessLabel_hint' => '允许客户为其系统用户启用 SSH。设置 "通过 SSH 在订阅的系统用户的名下访问服务器 shell" 主机参数作为预设参数。',

    'service-plan.permissions.permissionsTabDescription' => '选择方案提供的服务和权限。',
    'service-plan.permissions.permissionsAddonTabDescription' => '选择将作为附加方案而添加到订阅的服务及权限。注意，在附加方案中未选的权限不会影响到订阅参数。',
    'service-plan.permissions.permissionsBehaviorDescription' => '权限能够让客户更改其订阅的特定设置。当创建了一个订阅时，Plesk 会将方案的预设值应用到客户可以更改的设置。之后，更新方案或应用附加方案不会覆盖客户所做的更改。',
    'service-plan.permissions.showMorePermissions' => '显示更多可用权限',
    'service-plan.permissions.hideMorePermissions' => '显示较少权限',
    'service-plan.permissions.noShellManagement' => '不允许',
    'service-plan.permissions.systemAccessLabel' => '管理通过SSH访问服务器',
    'service-plan.permissions.systemAccessLabel_hint' => '设置主机参数 “通过 SSH 在订阅的系统用户的名下访问服务器 shell” 为预设参数。',

    'service-plan.resources-subscription.overusePolicy' => '超额使用策略',
    'service-plan.resources-subscription.overusePolicyNotAllowed' => '不允许超额使用',
    'service-plan.resources-subscription.overusePolicyNotAllowedHint' => '阻止超额使用资源。如果资源使用超过了上限值，订阅会自动被挂起。',
    'service-plan.resources-subscription.overusePolicySoftAllowed' => '允许超额使用磁盘空间与流量',
    'service-plan.resources-subscription.overusePolicySoftAllowedHint' => '允许超额使用磁盘空间与流量。不允许超额使用其他资源。',
    'service-plan.resources-subscription.overusePolicyAllowed' => '允许超额使用（不建议）',
    'service-plan.resources-subscription.overusePolicyAllowedHint' => '允许订户超额使用订阅资源。',
    'service-plan.resources-subscription.overuseNotify' => '超额使用时通过邮件通知我。',
    'service-plan.resources-subscription.oversellPolicy' => '超额销售策略',
    'service-plan.resources-subscription.oversellPolicyAllowed' => '允许超额销售',
    'service-plan.resources-subscription.oversellPolicyAllowedHint' => '超额销售允许代理商超额出售通过订阅分配给他们的资源。若允许超额销售，代理商则可支配实际使用的资源而不是初始分配的资源。',
    'service-plan.resources-subscription.oversellPolicyNotAllowed' => '不允许超额销售',
    'service-plan.resources-subscription.oversellPolicyNotAllowedHint' => '若不允许超额销售，不管实际使用的资源是多少，代理商都只能出售通过订阅初始分配给他们的资源。',
    'service-plan.resources-subscription.mainGroupTitle' => '定义订阅的资源使用限制。',
    'service-plan.resources-subscription.additionalGroupTitle' => '显示更多可用资源',
    'service-plan.resources-subscription.hideMoreResources' => '显示较少资源',

    'service-plan.resources.overusePolicy' => '超额使用策略',
    'service-plan.resources.overusePolicyNotAllowed' => '不允许超额使用',
    'service-plan.resources.overusePolicyNotAllowedHint' => '阻止超额使用资源。如果资源使用超过上限值，订阅会自动挂起。',
    'service-plan.resources.overusePolicySoftAllowed' => '允许超额使用磁盘空间与流量',
    'service-plan.resources.overusePolicySoftAllowedHint' => '允许超额使用磁盘空间与流量。不允许超额使用其他资源。',
    'service-plan.resources.overusePolicyAllowed' => '允许超额使用（不建议）',
    'service-plan.resources.overusePolicyAllowedHint' => '允许客户使用比初始分配给方案的更多的资源。',
    'service-plan.resources.overuseNotify' => '超额使用时通过邮件通知我。',
    'service-plan.resources.oversellPolicy' => '超额销售策略',
    'service-plan.resources.oversellPolicyAllowed' => '允许超额销售',
    'service-plan.resources.oversellPolicyAllowedHint' => '超额销售允许代理商超额出售通过方案分配给他们的资源。若允许超额销售，代理商则可支配实际使用的资源而不是初始分配的资源。',
    'service-plan.resources.oversellPolicyNotAllowed' => '不允许超额销售',
    'service-plan.resources.oversellPolicyNotAllowedHint' => '若不允许超额销售，不管实际使用的资源是多少，代理商都只能出售通过方案初始分配给他们的资源。',
    'service-plan.resources.mainGroupTitle' => '定义方案的资源。',
    'service-plan.resources.additionalGroupTitle' => '显示更多可用资源',
    'service-plan.resources.hideMoreResources' => '显示较少资源',
    'service-plan.resources.allowSitebuilderUpsell' => '允许客户创建试用的 Presence Builder 网站。',
    'service-plan.resources.allowSitebuilderUpsellDescription' => '此设置允许客户创建比服务方案提供的更多的 Presence Builder 网站。客户需购买这些网站才能发布。',

    'service-plan.servicePlanName' => '服务方案名称',
    'service-plan.resellerPlanName' => '代理商方案名称',
    'service-plan.addonPlanName' => '附加方案名称',
    'service-plan.adminPlanPermissionsTab' => '管理工具',
    'service-plan.adminPlanPermissionsTabDescription' => '选项当启用了限制模式时，管理员可以使用的功能。',
    'service-plan.hostingPermissionsTab' => '主机工具',
    'service-plan.hostingPermissionsTabDescription' => '选择当启用了限制模式时，高级用户视图中的管理员可以使用的web主机工具和设置。',
    'service-plan.resourcesTab' => '资源',
    'service-plan.resourcesTabDescription' => '定义方案资源以及资源使用策略。',
    'service-plan.subscriptionResourcesTabDescription' => '定义订阅资源以及资源使用策略。',
    'service-plan.hostingTab' => '主机参数',
    'service-plan.hostingTabDescription' => '指定主机服务的参数。注意在附加方案中指定的主机设置不会应用到通过服务方案或附加方案授以“主机设置管理”权限的订阅。',
    'service-plan.secureSettingsDescription' => '如果您希望提供的主机是最安全的，请%%link%%。如果订户享有某些权限，则可以更改这些设置。请%%helpLink%%。',
    'service-plan.secureSettingsLink' => '应用预设的安全设置',
    'service-plan.secureSettingsHelpLink' => '了解安全主机设置',
    'service-plan.mailTab' => '邮件',
    'service-plan.mailTabDescription' => '指定方案的邮件服务参数。',
    'service-plan.dnsTab' => 'DNS',
    'service-plan.dnsTabDescription' => '指定方案的 DNS 服务参数。',
    'service-plan.performanceTab' => '性能',
    'service-plan.performanceTabDescription' => '请指定影响方案所有服务性能的系统参数。',
    'service-plan.permissionsTab' => '权限',
    'service-plan.miscTab' => '日志与统计',
    'service-plan.miscTabDescription' => '指定如何存储方案订阅的统计及日志。注意这些设置在订阅中不同步。',
    'service-plan.miscTabAdminPlanDescription' => '请指定如何存储订阅的统计和日志。',
    'service-plan.extrasTab' => '其它服务',
    'service-plan.extrasTabDescription' => '选择除了主机、DNS与邮件服务外的包含在方案里的其它服务。',
    'service-plan.ipTab' => 'IP地址',
    'service-plan.ipTabDescription' => '定义方案的 IP 资源的参数。',
    'service-plan.applicationsTab' => '应用程序',
    'service-plan.applicationsTabDescription' => '为方案选择可供使用的应用程序。您可选择应用程序目录中所有的应用程序，外加您上传到服务器中的应用程序，或者手动选择应用程序。如果您要选择所有可用的应用程序，则不必在此标签上做任何操作，只需进入 权限 标签选择 访问应用程序目录 选项即可。如果您想要手动选择应用程序，您可在此标签上操作。',
    'service-plan.applicationsTabDescription-addon' => '选择可用作附加方案的应用程序',
    'service-plan.applicationsTabDescription-subscription' => '为订阅选择可供使用的应用程序。您可选择应用程序目录中所有的应用程序，外加您上传到服务器中的应用程序，或者手动选择应用程序。如果您要选择所有可用的应用程序，则不必在此标签上做任何操作，只需进入 权限 标签选择 访问应用程序目录 选项即可。如果您想要手动选择应用程序，您可在此标签上操作。',
    'service-plan.planSyncSubsriptionWarning' => '部分订阅未与方案同步。在订阅列表中标志为"未同步"。若要重试同步，转到订阅概要页，并单击同步按钮。',
    'service-plan.planSyncResellerWarning' => '部分代理商未与方案同步。代理商列表中都标记为"未同步"。若要重新尝试同步，转到代理商概要页，并单击同步按钮。',
    'service-plan.planSyncAdminWarning' => '无法应用更改到订阅因为 Plesk 不提供这些更改所影响的某些服务或资源。原因：%%reason%%',
    'service-plan.duplicateName' => '相同名称的方案已经存在。',
    'service-plan.phpSettingsTab' => 'PHP 设置',
    'service-plan.phpHandlerNotFound' => '无法检索有关该方案的PHP版本的信息。将其重新安装或为服务方案选择其它PHP版本。',
    'service-plan.phpHandlerNotRegistered' => "PHP 版本 %%fullVersion%% 未安装。使用该服务方案的域名的 PHP 脚本不可用。安装 PHP <nobr>版本 %%fullVersion%%</nobr> 或为该服务方案选择其它 PHP 版本。",

    'service-plan.phpSettingsTabDescription' => '您可在此为每个订阅指定 PHP 设置，覆盖服务器级的 php.ini 文件定义的设置。例如，当您想要限制客户 PHP 脚本占用的系统资源时，可进行此设置。客户（如果允许）可使用其为每个域名自行调整的配置覆盖此 PHP 配置。当您设置一个参数为默认值时，PHP 将会使用来自服务器级的 PHP 配置的参数值。注意支持使用以下占位符：{DOCROOT} 和 {WEBSPACEROOT} 代表获取自定义 PHP 配置的某个域名的文档根目录和某个订阅的根目录；{TMP} 代表存储临时文件的目录。',
    'service-plan.phpSettingsTabDescriptionAddon' => '您可在此为每个订阅指定 PHP 设置，覆盖主要服务方案定义的设置。例如，当您想要移除在主要服务方案中设置的一些 PHP 限制时，可进行此设置。当您设置一个参数为默认值时，PHP 将会使用来自服务方案 PHP 配置的参数值。注意支持使用以下占位符：{DOCROOT} 和 {WEBSPACEROOT} 代表获取自定义 PHP 配置的某个域名的文档根目录和某个订阅的根目录；{TMP} 代表存储临时文件的目录。',
    'service-plan.phpSettingsPhpVersion' => '您目前 PHP 版本是 %%version%%。',
    'service-plan.phpSettingsTabAdminPlanDescription' => '您可在此为每个订阅指定 PHP 设置，覆盖服务器级的 php.ini 文件定义的设置。当您设置一个参数为默认值时，PHP 将会使用来自服务器级的 PHP 配置的参数值。',
    'service-plan.webServerSettingsTab' => 'Web 服务器',
    'service-plan.webServerSettingsTabDescription' => '在此处您可以指定该服务方案的 Apache web 服务器设置。如果 Apache正在使用 nginx 作为前端服务器。您也可在该页面上指定 nginx 设置。所有新创建的域名将会接收指定的设置。但是，当您更改这些设置时，现有域名将不会接收修改。',
    'service-plan.servicesTab' => '服务',
    'service-plan.servicesTabDescription' => '在此处您可以指定分配给服务方案的服务。',
    'service-plan.servicePropertiesTab' => '%%serviceName%% 属性',
    'service-plan.servicePropertiesTabDescription' => '在此处您可以指定分配给服务方案的 %%serviceName%% 服务的属性。',
    'service-plan.longTaskWarning' => '在该方案上您有 %%subscriptionsCount%% 个订阅。注意同步任务可能需要大量时间而将要在后台执行。',
    'service-plan.hostingParametersTab' => '主机参数',
    'service-plan.adminInfoSection' => '管理员的信息',
    'service-plan.descriptionInPanel' => '描述',
    'service-plan.longDescription' => '指定的描述太长。',
    'service-plan.conflictPermissions' => '无法授予以下权限因为它们与代理商方案相冲突：%%permissions%%.',

    'services.change-startup-type.startupTypeLabel' => '启动类型',
    'services.change-startup-type.autoStartupTypeLabel' => '自动',
    'services.change-startup-type.manualStartupTypeLabel' => '手动',
    'services.change-startup-type.disabledStartupTypeLabel' => '禁用',
    'services.change-startup-type.autoActionError' => '无法设置启动类型为 \'自动\'：%%error%%',
    'services.change-startup-type.manualActionError' => '无法设置启动类型为 \'手动\'：%%error%%',
    'services.change-startup-type.disableActionError' => '无法设置启动类型为 \'禁用\'：%%error%%',

    'sessions.settings.restoreDefaultButton' => '重设为默认值',
    'sessions.settings.restoreDefaultButtonDescription' => '恢复会话参数为默认值。',
    'sessions.settings.restoreDefaultButtonDescriptionDisable' => '会话参数有默认值。',
    'sessions.settings.idleTime' => '会话闲置时间',
    'sessions.settings.disableCheckSessionIp' => '允许在单个会话期间更改 IP 地址',
    'sessions.settings.minuteShortTitle' => '分钟',

    'settings-ui.controls.title' => '控件',

    'settings-ui.interface-views.description' => "有多个产品 UI 视图供您使用。因您使用视图的不同，各个功能与设置所处的位置会不同，甚至启用/禁用的状态也会不同。不同的视图适合不同类型的用户。",
    'settings-ui.interface-views.panelSimpleLink' => '工具 & 设置> 限制模式设置',
    'settings-ui.interface-views.useCustomView' => '启用限制模式',
    'settings-ui.interface-views.useCustomViewHint' => '选择此选项来限制管理员可以在Plesk面板中采取操作的次数。若要更改操作的可用性，请转到%%customViewSettingsLink%%。',
    'settings-ui.interface-views.powerUserViewHint' => '此视图最适合于管理网站、其文件、数据库、电子邮件帐户、web应用程序和其他服务。',
    'settings-ui.interface-views.selectUiModeTitle' => "选择界面",
    'settings-ui.interface-views.uiModeTitlePowerUser' => "高级用户视图（面向开发者和 web 代理）",
    'settings-ui.interface-views.uiModeTitleServiceProvider' => "服务提供商视图（面向 web 主机提供商）",
    'settings-ui.interface-views.uiModeHintServiceProvider' => '此视图适用于那些使用服务方案向其客户提供和销售 web 主机服务的服务器管理员。',
    'settings-ui.interface-views.visibilityMailBounce' => '隐藏弹出控件',
    'settings-ui.interface-views.visibilityMailBounceHint' => '隐藏“允许设置如何处理发送到不存在的电子邮件地址的邮件”的按钮',

    'settings-ui.branding.description' => '可通过更改在浏览器标题栏中显示页面的方式和/或替换左上角的 Plesk 徽标来自定义 Plesk 界面品牌。',
    'settings-ui.branding.buttonDefault' => '默认徽标',
    'settings-ui.branding.sectionTitle' => '自定义标题',
    'settings-ui.branding.enableCustomTitle' => '在Plesk页面上启用自定义标题',
    'settings-ui.branding.customTitle' => '标题文本',
    'settings-ui.branding.sectionLogo' => '自定义徽标',
    'settings-ui.branding.enableCustomLogo' => '启用自定义面板徽标',
    'settings-ui.branding.logo' => '徽标文件',
    'settings-ui.branding.logoUrl' => '徽标 URL',
    'settings-ui.branding.logoUrlEnabled' => '自定义',
    'settings-ui.branding.logoUrlDisabled' => '默认',
    'settings-ui.branding.sectionFavicon' => '自定义网站图标',
    'settings-ui.branding.enableCustomFavicon' => '启用自定义网站图标',
    'settings-ui.branding.sectionFaviconDesc' => '为了在不同的浏览器中提供更好的支持，必须以两种格式上传相同的网站图标。',
    'settings-ui.branding.faviconSvg' => '网站图标文件 SVG',
    'settings-ui.branding.faviconSvgHint' => '允许的格式：SVG',
    'settings-ui.branding.faviconIco' => '网站图标文件 ICO',
    'settings-ui.branding.faviconIcoHint' => '允许的格式：ICO',
    'settings-ui.branding.show' => '显示',
    'settings-ui.branding.updateSuccess' => 'Plesk 品牌自定义属性已更改。',

    'sitebuilder.trial.description' => '您可在此配置 试用后购买 方案。通过此方案客户能够使用 Presence Builder 里所有可用的功能创建网站。但是他们若要发布试用网站，则必须购买主机服务方案或附加方案。现有客户也可通过一个主机方案或一个附加方案享用 试用后购买 模式。%%link%%',
    'sitebuilder.trial.descriptionLink' => '参阅文档了解更多信息。',
    'sitebuilder.trial.lifetimeLabel' => '试用网站期限',
    'sitebuilder.trial.lifetimeUnits' => '天',
    'sitebuilder.trial.lifetimeDescription' => '在这显示这些未购买的试用网站多长时间将从服务器上移除。',
    'sitebuilder.trial.signupLabel' => '启用公共访问试用模式',
    'sitebuilder.trial.signupDescription' => '如果您想要通过推广配置有 Presence Builder 的主机或通过提供 Presence Builder 演示来吸引客户，则可以启用公共访问试用模式，在您的网站上发布访问试用模式的 URL。',
    'sitebuilder.trial.signupLinkLabel' => '访问试用模式的 URL',
    'sitebuilder.trial.signupLinkDescription' => '此 URL 将在试用模式里打开 Presence Builder。在您的网站上发布URL 以吸引客户。',
    'sitebuilder.trial.promotionLabel' => '在 Presence Builder 编辑器里显示试用模式提示',
    'sitebuilder.trial.promotionDescription' => '如果您想要显示有关 Presence Builder 试用模式的其它通知可使用该选项。',

    'update-settings.policyHintForPum' => '您可以在此设置自动安装更新。当有可进行手动安装的更新或更新已被自动安装时发送通知邮件。',
    'update-settings.policyHint' => '当有可进行手动安装的更新或更新已被自动安装时发送通知邮件。',
    'update-settings.branchDisabledDescription' => '不要通知我有关升级版的信息',
    'update-settings.automaticPatchesInstallation' => '自动安装 Plesk 更新（推荐）',
    'update-settings.automaticPatchesThirdParty' => '自动为 Plesk 附带的第三方组件安装更新',
    'update-settings.automaticSystemPackageUpdates' => '自动安装系统程序包更新',
    'update-settings.automaticSystemPackageUpdatesHint' => '注意这将自动为 Plesk 附带的第三方组件安装更新',
    'update-settings.automaticPatchesNotification' => '通知有关可用的和已安装的系统包更新的信息',
    'update-settings.systemPackageUpdatesNotificationsEmail' => '电子邮件地址',
    'update-settings.systemPackageUpdatesNotificationsPeriod' => '通知邮件频率',
    'update-settings.daily' => '每天',
    'update-settings.weekly' => '每周',
    'update-settings.generalSection' => '常规',
    'update-settings.notificationsSection' => '通知',
    'update-settings.safeUpdatesSection' => '安全更新',
    'update-settings.safeUpdatesSectionHint' => 'Plesk 保证了会从初始安装系统包的相同 repository 安装系统包更新。此类更新比较安全。如果您禁用了安全更新，您的系统包管理器可能会从系统中的任一 repository 安装更新。',
    'update-settings.safeUpdatesSectionWarn' => '我们建议您保留启用安全更新，除非您是高级用户。从其它任意 repositories 更新系统包可能会对您的服务器的正常运行产生不利影响。',
    'update-settings.allowSafeUpdates' => '启用安全更新系统包',

    'requiredFields' => '必填字段',
];