<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "502 Bad Gateway: upstream enviou cabeçalho demasiado grande ao ler o cabeçalho de resposta"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => 'A ficar pronto brevemente.',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.title' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.text' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache "500 Internal Server Error: Opção FollowSymLinks não permitida aqui"',
    'problem-detail.apache-followsymlinks-not-allowed.description' => 'A ficar pronto brevemente.',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "servidor atingiu a configuração max_children"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Sintomas</h4><ul><li><p>Nos websites que têm o processador PHP definido como <strong>Aplicação FPM servida por Apache</strong> ou <strong>Aplicação FPM servida por nginx</strong> em <strong>Domínios</strong> &gt; <strong>exemplo.com</strong> &gt; <strong>as Definições PHP</strong> apresentam um dos seguintes problemas:</p><ul><li><p>lento ao carregar</p></li><li><p>não acessível (permanente ou periodicamente) com um erro 50x num browser da web:</p><pre>502 Bad Gateway</pre><hr><pre>503 Service Temporarily Unavailable</pre><hr><pre>504 Gateway Time-out</pre></li></ul></li><li><p>A seguinte mensagem aparece no ficheiro de registo de erros PHP-FPM <code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> (em que <em>XX</em> é uma versão de PHP utilizada pelos websites):</p><pre>AVISO: [pool exemplo.com] servidor atingiu a configuração max_children (*), considere aumentá-la</pre><ul><li><p>A mensagem acima é geralmente acompanhada por este erro:</p><pre>não é possível ler o que diz o subordinado: descritor do ficheiro com erro (9)</pre></li></ul></li><li><p>Se nginx estiver ativado no servidor, pode parecer uma das seguintes mensagens de erro no ficheiro de registo de erros do domínio <code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 ligar() a unix:///var/www/vhosts/system/example.com/php-fpm.sock failed (11: Recurso temporariamente indisponível) ao ligar a upstream, cliente: 203.0.113.2, servidor: exemplo.com, pedido: "GET / HTTP/1.1", upstream: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", anfitrião: "exemplo.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 upstream fechou prematuramente a ligação ao ler o cabeçalho de resposta de upstream, cliente: 203.0.113.2, servidor: exemplo.com, pedido: "POST /path/to/some/file HTTP/2.0", upstream:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>PHP-FPM <code>pm.max_children</code> foi atingido pelo(s) website(s).</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1.title' => 'Aumentar o limite pm.max_children',
    'problem-detail.phpfpm-server-reached-max-children.solution1.text' => '<p>Aumente o limite <code>pm.max_children</code> para os domínios afetados:</p><ol><li><p>Ligue-se ao servidor Plesk através de <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener">SSH</a>.</p></li><li><p>Encontre os domínios afetados utilizando o comando abaixo:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Nota:</strong> o número do lado esquerdo indica quantas vezes o limite <code>pm.max_children</code> foi atingido pelo website.</div><pre style="white-space: pre-wrap;"># grep -r "server reached max_children setting" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 exemplo.com<br>50 exemplo.net<br>25 exemplo.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener">Inicie sessão no Plesk</a>.</p></li><li><p>Aceda a <strong>Domínios</strong> &gt; <strong>exemplo.com</strong> &gt; <strong>Definições PHP</strong> &gt; <strong>Definições PHP-FPM</strong>.</p></li><li><p>Aumente o valor de <code>pm.max_children</code> para o domínio e aplique as alterações. Aumente este valor para todos os domínios enumerados no passo 2.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "Demasiados ficheiros abertos"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx falha ao iniciar/recarregar num servidor Plesk: demasiados ficheiros abertos</p><h4>Sintomas</h4><ul><li><p>O serviço nginx falha ao iniciar/recarregar com o seguinte erro no ficheiro <code>/var/log/nginx/error.log</code>:</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" falhou (24: Demasiados ficheiros abertos)</pre></li><li><p>Alguns ou todos os websites não estão acessíveis</p></li><li><p>O aviso é mostrado em <strong>Ferramentas e Configurações &gt; Diagnóstico e reparação</strong>:</p><pre style="white-space: pre-wrap;">Ao verificar o valor de nginx ULIMIT foram encontrados N domínios no servidor. É possível que haja um problema com o limite predefinido de ficheiros abertos de nginx</pre></li><li><p>As aplicações web NodeJS e Ruby mostram o erro 502 Bad Gateway ao realizar algumas tarefas do Plesk como criar domínios, subscrições, alterações em Apache ou Nginx, etc:</p><pre style="white-space: pre-wrap;">Erro do servidor<br>502 Bad Gateway <br>O servidor web recebeu uma resposta inválida ao atuar como gateway ou servidor proxy.</pre></li><li><p>Após <a href="https://support.plesk.com/hc/en-us/articles/213946825-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">instalar um novo certificado para o domínio</a>, o antigo ainda é mostrado num browser da web, porém o certificado correto está selecionado na página <strong>Domínios &gt; exemplo.com &gt; Definições de alojamento</strong>.</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>O anfitrião virtual de nginx abre 4 ficheiros de registo para cada anfritrião virtual com alojamento físico:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>Consequentemente, o número máximo de ficheiros abertos é ultrapassado pelo servidor nginx devido a um grande número de domínios (geralmente, mais de 100).</p>',
    'problem-detail.nginx-too-many-open-files.solution1.title' => 'Aumentar o limite de ficheiros abertos',
    'problem-detail.nginx-too-many-open-files.solution1.text' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Warning:</strong> A execução do utilitário <code>websrv_ulimits</code> sem a opção <strong>--no-restart</strong> inicia a reconstrução dos ficheiros de configuração web para todos os domínios e pode causar um tempo de inatividade significativo caso haja um grande números de websites alojados.<br><br>Execute o comando durante o período de manutenção.</div><p>É boa prática definir um valor de limite de ficheiros abertos superior ao <strong>número de domínios no Plesk * 16</strong>, pelo menos. No exemplo abaixo, mostra-se como definir o limite para 4096:</p><ol><li><p>Ligue-se ao servidor através de <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener noreferrer">SSH</a></p></li><li><p>Defina o limite de ficheiros abertos para 4096, tanto para Apache como para Nginx:</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>Reinicie os serviços Apache e nginx em <strong><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>Ferramentas e Configurações &gt; Gestão de Serviços</strong> para aplicar as alterações.</p></li><li><p>Verifique se \'Limite máx. de ficheiros aberto\' foi corretamente aplicado, após o reinício dos serviços web:</p><pre># grep \'Max open files\' /proc/$(cat /var/run/nginx.pid)/limits<br>Max open files 4096 4096 file</pre></li><li><p>Se a solução acima não ajudar, defina o limite utilizando o utilitário <code>ulimit</code>:</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "Corpo de resposta muito grande"',
    'problem-detail.apache-modsec-response-body-too-large.description' => 'A ficar pronto brevemente.',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "Acesso negado com código 403"',
    'problem-detail.modsec-access-denied.description' => '<h4>Sintomas</h4><ul><li><p>ModSecurity está instalado e ativado em <strong>Ferramentas e Configurações > Web Application Firewall (ModSecurity) > Modo Firewall para Aplicações Web > On</strong>.</p></li><li>Um website hosted in Plesk não foi carregado. Não é possível executar operações no website tais como gerir WordPress, aceder a webmail, ou aceder ao ficheiro <code>robots.txt</code>. O browser pode apresentar um dos seguintes erros: <pre>ERR_CONNECTION_REFUSED</pre><hr><pre>403 Forbidden</pre><hr><pre>500 Internal Server Error</pre><hr><pre>ERR_CONNECTION_TIMED_OUT</pre></li><li>Aparece uma mensagem de erro ModSecurity tal com a mensagem abaixo no ficheiro de registo <code>/var/log/modsec_audit.log</code> ou na página de Registos do Plesk (<strong>Domínios</strong> &gt; <strong>exemplo.com</strong> &gt; <strong>Registos</strong>): <pre>ModSecurity: Aceso recusado com código 403 (fase 2). Operator GE matched 5 at TX:anomaly_score. [file "/etc/apache2/modsecurity.d/rules/owasp_modsecurity_crs_3-plesk/REQUEST-949-BLOCKING-EVALUATION.conf"] [line "57"] [id "949110"] [msg "Inbound Anomaly Score Exceeded (Total Score: 5)"] [severity "CRITICAL"] [tag "application-multi"] [tag "language-multi"] [tag "platform-multi"] [tag "attack-generic"] [hostname "example.com"] [uri "/robots.txt"] [unique_id "XPsROH8AAQEAABEiZFcAAABC"]</pre></li>',
    'problem-detail.modsec-access-denied.cause' => '<p>ModSecurity Forewall para Aplicações Web está ativa com um conjunto de regras muito limitadoras, tais como OWASP, Comodo, ou um conjunto personalizado de regras como Imunify360. Os conjuntos de regras limitadores podem bloquear algumas operações no website.</p><p><Strong>Atenção:</strong> O erro ModSecurity pode indicar um ataque ao seu servidor. Utilize as soluções abaixo apenas se tiver a certeza de que ModSecurity está a bloquear a utilização válida do seu website.</p>',
    'problem-detail.modsec-access-denied.solution1.title' => 'Desativar o conjunto de regras ModSecurity por ID ou Tag',
    'problem-detail.modsec-access-denied.solution1.text' => '<ol><li><p>Procure a ID da regra que está a bloquear a utilização legítima do seu website. Pode encontrar as IDs dentor das mensagens de erro do ficheiro de registo <code>/var/log/modsec_audit.log</code>. A ID é um número inteiro entre aspas, com o prefixo <code>id</code> entre parêntesis retos, por exemplo, <strong>[id "210831"]</strong>.</p></li><li><a href="https://support.plesk.com/hc/en-us/articles/115002531753" target="_blank" rel="noopener">Desativar conjuntos de regras específicos no Plesk</a>.</li></ol>',
    'problem-detail.modsec-access-denied.solution2.title' => 'Mudar para outro conjunto de regras de ModSecurity',
    'problem-detail.modsec-access-denied.solution2.text' => '<ol><li><p>Mude para um conjunto de regras ModSecurity menos restritivo, por exemplo, "Atomic ModSecurity Ruleset". Para o fazer, vá para <strong>Ferramentas e Configurações</strong> > <strong>Firewall para Aplicações Web (ModSecurity)</strong> > <strong>Definições/3>, selecione <strong>Atomic Standard</strong>, e depois clique em <strong>OK</strong> para aplicar as alterações.</p></li></ol>',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "Erro interno do servidor 500: tamanho de memória permitido de XXX esgotado"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '<h4>Sintomas</h4><ul><li><p>Um website alojado no Plesk não está acessível:</p><pre>500 Erro Interno do Servidor</pre></li><li><p>O seguinte erro é apresentado no registo do website:</p><pre>Recebeu o erro "PHP message: PHP Fatal error: Allowed memory size of 4194304 bytes exhausted (tried to allocate 4000032 bytes) in /var/www/vhosts/example.com/httpdocs/somethingBig.php on line 3"</pre></li> </ul>',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '<p>O website não possui memória atribuída suficiente para ser processado.</p>',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.title' => 'Aumentar memory_limit do website',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/115000304194" target="_blank" rel="noopener">Leia o artigo da KB e siga as instruções</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "restrição open_basedir em vigor"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '<h4>Sintomas</h4><ul><li><p>Um website não está acessível com um dos seguintes erros no web browser:</p><pre>404 file not found</pre><hr><pre>500 Internal Server Error</pre><hr><pre>Error 500 move_uploaded_file(): open_basedir restriction in effect. File(/path/to/the/directory) is not within the allowed path(s): (/var/www/vhosts/example.com/:/tmp/)</pre></li><li><p>A seguinte mensagem de erro aparece na página de Registo do domínio (<strong>Domínios</strong> > <strong>exemplo.com</strong> > <strong>Registos</strong>):</p><pre><...> restrição open_basedir em vigor. Ficheiro(/caminho/para/o/diretório) não se encontra dentro do(s) caminho(s) permitido(s) <...></pre><hr><pre>Exceção não identificada: Sessão: Caminho para guardar definido "/caminho/para/o/diretório" não é um diretório, não existe ou não pode ser criado.</pre></li></ul>',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => 'O script PHP está a tentar aceder ao diretório para o qual não é permitido acesso. Esta restrição é definida pela diretiva PHP <code>open_basedir</code> individualmente para cada domínio. Por predefinição, <code>open_basedir</code> permite o acesso a <code>tmp</code> e aos diretórios de raiz de documento do domínio, bem como ao caminho predefinido das sessões do sistema.',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.title' => 'Adicionar o caminho adicional à diretiva open_basedir',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/115000278993" target="_blank" rel="noopener">Leia o artigo da KB e siga as instruções</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.title' => 'Desativar a diretiva open_basedir',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.text' => '<ol><li><p>Visite a página <strong>Domínios &gt exemplo.com &gt Definições PHP</strong> e defina a diretiva <code>open_basedir</code> para "none".</p></li></ol>',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 Proibido AH01797: cliente negado pela configuração do servidor"',
    'problem-detail.apache-client-denied-by-server.description' => '<h4>Sintomas</h4><ul><li><p>O website apresenta um erro semelhante ao seguinte:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>O ficheiro de registo <code>/var/www/vhosts/system/example.com/logs/error_log</code> contém erros como o seguinte:</p><pre>AH01797: cliente negado pela configuração do servidor: /var/www/vhosts/exemplo.com/index.php</pre></li></ul>',
    'problem-detail.apache-client-denied-by-server.cause' => '<p>A configuração Apache pesonalizada não permite acesso ao website.</p>',
    'problem-detail.apache-client-denied-by-server.solution1.title' => 'Verifique a configuração do servidor e os ficheiros .htaccess',
    'problem-detail.apache-client-denied-by-server.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/214528485" target="_blank" rel="noopener">Leia o artigo da KB e siga as instruções</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.name' => 'Apache "Não é possível aceder a um diretório de websites no Plesk: 403 Proibido"',
    'problem-detail.apache-no-directory-index.description' => '<h4>Sintomas</h4><ul><li><p>Não consegue aceder a um local específico de um website, por exemplo, <code>http://exemplo.com/uma_pasta</code>. Ocorre o seguinte erro:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>O seguinte erro aparece no ficheiro <code>/var/www/vhosts/exemplo.com/logs/error_log<code/>:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Não é possível servir diretório /var/www/vhosts/exemplo.com/httpdocs/uma_pasta/: Nenhum DirectoryIndex correspondente (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) encontrado, e índice de diretórios gerado pelo servidor está proibido pela diretiva Opções</pre></li></ul>',
    'problem-detail.apache-no-directory-index.cause' => '<p>O diretório pedido não contém ficheiros de índice ou a navegação no diretório não está ativa.</p>',
    'problem-detail.apache-no-directory-index.solution1.title' => 'Adicionar um ficheiro de índice ao diretório',
    'problem-detail.apache-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/214528485" target="_blank" rel="noopener">Leia o artigo da KB e siga as instruções</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.solution2.title' => 'Permitir a navegação no diretório',
    'problem-detail.apache-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/360002534354" target="_blank" rel="noopener">Leia o artigo da KB e siga as instruções</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "Não é possível aceder a um diretório de websites no Plesk: 403 Proibido"',
    'problem-detail.nginx-no-directory-index.description' => '<h4>Sintomas</h4><ul><li><p>Não consegue aceder a um local específico de um website, por exemplo, <code>http://exemplo.com/uma_pasta</code>. Ocorre o seguinte erro:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>O seguinte erro aparece no ficheiro <code>/var/www/vhosts/exemplo.com/logs/error_log</code>:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Não é possível servir diretório /var/www/vhosts/exemplo.com/httpdocs/uma_pasta/: Nenhum DirectoryIndex correspondente (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) encontrado, e índice de diretórios gerado pelo servidor está proibido pela diretiva Opções</pre></li></ul>',
    'problem-detail.nginx-no-directory-index.cause' => '<p>O diretório pedido não contém ficheiros de índice ou a navegação no diretório não está ativa.</p>',
    'problem-detail.nginx-no-directory-index.solution1.title' => 'Adicionar um ficheiro de índice ao diretório',
    'problem-detail.nginx-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/214528485" target="_blank" rel="noopener">Leia o artigo da KB e siga as instruções</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.solution2.title' => 'Permitir a navegação no diretório',
    'problem-detail.nginx-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/360002534354" target="_blank" rel="noopener">Leia o artigo da KB e siga as instruções</a>.</p></li></ol>',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "servidor atingiu a definição MaxRequestWorkers"',
    'problem-detail.apache-reached-max-request-workers.description' => 'A ficar pronto brevemente.',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'Limite do corpo do pedido PHP "cliente pretendia enviar corpo demasiado grande"',
    'problem-detail.php-post-content-length-exceeds-limit.description' => 'A ficar pronto brevemente.',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'Limite do corpo do pedido PHP "cliente pretendia enviar corpo demasiado grande"',
    'problem-detail.nginx-client-sent-too-large-body.description' => 'A ficar pronto brevemente.',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'Sessões PHP "503 Erro Interno do Servidor" ou "Falha ao ler os dados da sessão"',
    'problem-detail.php-failed-to-read-session-data.description' => 'A ficar pronto brevemente.',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Forbidden: pcfg_openfile: não foi possível verificar o ficheiro htaccess, certifique-se de que pode ser lido"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '<h4>Sintomas</h4><ul><li><p>Um website alojado no Plesk não está a funcionar:</p><pre>Não possui permissão para aceder a / neste servidor. <br> Além disso, foi encontrado um erro 403 Forbidden ao tentar utilizar um ErrorDocument para lidar com o pedido.</pre><p>Em vez do erro supra, também pode ver uma página em branco.</p></li><li><p>O registo de erros do domínio em <strong>Domínios &gt exemplo.com &gt Registos</strong> contém o seguinte:</p><pre>(13)Permissão recusada: [client 203.0.113.2:39024] AH00529: /var/www/vhosts/exemplo.com/httpdocs/.htaccess pcfg_openfile: não foi possível verificar o ficheiro htaccess, certifique-se de que é legível e de que "/var/www/vhosts/example.com/httpdocs/" é executável</pre></li></ul>',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => 'Permissões incorretas para os ficheiros ou pastas do domínio.',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.title' => 'Permissões para reparação do conteúdo do website',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/213939685" target="_blank" rel="noopener">Leia o artigo da KB e siga as instruções</a>.</p></li></ol>',
];