<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
$messages = [
    'action-log.logFiles' => "Fichiers journaux",
    'action-log.fromDate' => "Du :",
    'action-log.toDate' => "Au :",
    'action-log.clearLog' => "Effacer le journal",
    'action-log.downloadLog' => "Télécharger",
    'action-log.loggedActions' => "Activités consignées",
    'action-log.storeLogsInDb' => "Stocker les enregistrements dans la base de données",
    'action-log.storeNumber' => "Entrées",
    'action-log.dontRemoveRecs' => "Ne pas supprimer ces enregistrements",
    'action-log.confirmCleanLog' => "Êtes-vous sûr de vouloir supprimer les enregistrements des journaux d'actions ?",
    'action-log.incorrectDate' => "Une date incorrecte est indiquée.",
    'action-log.incorrectNumPeriods' => "Une période de rotation incorrecte est indiquée.",
    'action-log.incorrectNumRecords' => "Un nombre d'enregistrements incorrect est indiqué.",
    'action-log.yes' => "Oui",
    'action-log.no' => "Non",
    'action-log.mixed' => "(mélange)",
    'action-log.period' => "Période",
    'action-log.invalidDatePeriod' => "Période (date) non valide",
    'action-log.submitDone' => "Les changements dans les paramètres du journal d'actions ont été enregistrés.",
    'action-log.clearDone' => "Journal d'action effacé.",
    'action-log.periodDay' => "jours",
    'action-log.periodWeek' => "semaines",
    'action-log.periodMonth' => "Mois",

    'admin-info.adminInfoSection' => 'Informations pour l\'administrateur',
    'admin-info.description-admin' => 'Description de l\'administrateur',
    'admin-info.description-reseller' => 'Description du revendeur',
    'admin-info.description-owner' => 'Description du propriétaire',
    'admin-info.description' => 'Description',
    'admin-info.descriptionSuccess' => 'La description a été mise à jour.',
    'admin-info.longDescription' => 'La description indiquée est trop longue. Elle doit être inférieure à %%max%% caractères.',
    'admin-info.add' => 'Ajouter une description',
    'admin-info.edit' => 'Éditer',
    'admin-info.remove' => 'Supprimer',
    'admin-info.confirmOnRemove' => 'Voulez-vous supprimer cette description ?',
    'admin-info.popupTitle-customer' => '%%descriptionType%% du client %%name%%',
    'admin-info.popupTitle-reseller' => '%%descriptionType%% du revendeur %%name%%',
    'admin-info.popupTitle-subscription' => '%%descriptionType%% de l\'abonnement %%name%%',
    'admin-info.popupTitle-site' => '%%descriptionType%% de %%name%%',
    'admin-info.popupHint-admin' => 'Seul l\'administrateur peut voir cette description.',
    'admin-info.popupHint-reseller' => 'Le revendeur et l\'administrateur peuvent voir cette description.',
    'admin-info.popupHint-owner' => 'L\'auteur et son hébergeur peuvent voir cette description.',
    'admin-info.customerDescriptionHint' => 'Les clients ne peuvent pas voir cette description.',
    'admin-info.subscriptionDescriptionHint' => "Seul l'hébergeur (administrateur ou revendeur de Plesk) peut voir cette information.",

    'apache-settings.formGeneralHint' => 'Sur cette page, vous pouvez indiquer les paramètres du serveur Web Apache pour ce site Web. La configuration personnalisée d\'Apache est utile notamment lorsque vous voulez utiliser un nouveau type de fichiers d\'index sur votre site Web ou associer un certain type MIME avec certaines extensions de noms de fichiers. La valeur par défaut signifie qu\'Apache utilisera les directives correspondantes à partir de la configuration de l\'ensemble du serveur. Si Apache est exécuté avec Nginx en tant que serveur frontal, vous pouvez également préciser les paramètres Nginx sur cette page.',
    'apache-settings.general' => 'Paramètres communs Apache',
    'apache-settings.example' => "Par exemple :\n%%example%%",
    'apache-settings.settingOn' => 'Activé',
    'apache-settings.settingOff' => 'Désactivé (par défaut)',
    'apache-settings.settingDefault' => 'Par défaut',
    'apache-settings.settingCustom' => 'Entrer une valeur personnalisée',
    'apache-settings.mimeTypes' => 'Types MIME',
    'apache-settings.mimeTypesExample' => "text/plain .txt\nimage/jpeg .jpeg",
    'apache-settings.mimeTypesFullDescription' => 'Les types MIME associent les extensions de fichiers aux types de fichiers. Généralement, le standard MIME est utilisé pour créer des extensions de fichier personnalisées pour des types de fichiers communs.',
    'apache-settings.handlers' => 'Gestionnaires',
    'apache-settings.handlersExample' => "php-script .php\ncgi-script .cgi",
    'apache-settings.handlersFullDescription' => "Les gestionnaires Apache déterminent comment le serveur Web traite les fichiers avec certaines extensions lorsqu'elles sont demandées. Par exemple, la chaîne \"php-script .script\" signifie qu'Apache traitera les fichiers .script en tant que scripts php.",
    'apache-settings.deny' => 'Refuser l\'accès au site',
    'apache-settings.allow' => 'Sauf',
    'apache-settings.denyExample' => "10.1.0.0/16\n192.168.1.110\n\nLes hôtes et les réseaux indiqués ne sont pas autorisés à accéder au site. Utilisez '*' pour refuser toutes les connexions.",
    'apache-settings.allowExample' => "192.168.0.0/16\n10.1.1.21\n\nLes hôtes et les réseaux indiqués sont autorisés à accéder au site.",
    'apache-settings.directoryIndex' => 'Fichiers Index',
    'apache-settings.directoryIndexExample' => "index.htm index.php index.pl",
    'apache-settings.directoryIndexFullDescription' => "Apache recherchera les fichiers indiqués lorsque la page d'index du site est demandée.",
    'apache-settings.expires' => 'Expire',
    'apache-settings.expiresStaticOnly' => 'réponse avec en-têtes Expire uniquement pour les fichiers statiques',
    'apache-settings.expiresFullDescription' => 'Le serveur Web affichera les en-têtes de réponse "Expire" aux pages Web. L\'horodatage d\'expiration s\'obtient en ajoutant la durée indiquée ci-dessus à la date/heure à laquelle une page Web est requise.',
    'apache-settings.expiresStaticOnlyDescription' => 'L\'en-tête "Expire" sera ajouté uniquement aux fichiers statiques. Les fichiers traités comme des fichiers statiques sont ceux gérés par les options "Traiter intuitivement les fichiers statiques" et "Traiter les fichiers statiques directement avec Nginx".',
    'apache-settings.expiresUnitDays' => 'jours',
    'apache-settings.expiresUnitHours' => 'heures',
    'apache-settings.expiresUnitMinutes' => 'minutes',
    'apache-settings.expiresUnitSeconds' => 'secondes',
    'apache-settings.headers' => 'Autres en-têtes',
    'apache-settings.headersExample' => "Cache-Control: public\nStrict-Transport-Security: max-age=63072000\nX-Frame-Options: DENY",
    'apache-settings.headersFullDescription' => "Le serveur Web ajoutera les entêtes de réponse HTTP spécifiés.",
    'apache-settings.restrictFollowSymLinks' => 'Restreindre le suivi des liens symboliques',
    'apache-settings.restrictFollowSymLinksDescription' => "Sélectionnez cette option si vous voulez interdire aux utilisateurs d'utiliser la directive FollowSymLink dans .htaccess et améliorer la sécurité du serveur.",
    'apache-settings.nginx' => 'Paramètres Nginx',
    'apache-settings.nginxProxyMode' => 'Mode proxy',
    'apache-settings.nginxProxyModeDescription' => 'Nginx envoie des requêtes par proxy à Apache. Désactivez cela pour arrêter d\'utiliser Apache.',
    'apache-settings.nginxTransparentMode' => 'Traiter intuitivement les fichiers statiques',
    'apache-settings.nginxTransparentModeDescription' => 'Si cette option est désactivée, Apache traite toutes les requêtes pour les fichiers statiques. Nginx transfère uniquement les demandes et les réponses sans modifications. Désactivez cette option uniquement pour résoudre les problèmes.',
    'apache-settings.nginxServeStatic' => 'Traiter les fichiers statiques directement avec Nginx',
    'apache-settings.nginxStaticExtensions' => 'Indiquez les extensions de fichiers en les séparant par des espaces ou en utilisant le symbole "|". Les demandes pour ces fichiers seront gérées par Nginx et ne passeront jamais par Apache. Avertissement : les règles de réécriture Apache ne seront pas appliquées.',
    'apache-settings.nginxServePhp' => 'Gérer PHP avec Nginx',
    'apache-settings.nginxServePhpDescription' => 'Fichiers PHP (.php) qui seront gérés par Nginx et PHP-FPM. Si cette option est désactivée, les fichiers PHP seront gérés par Apache.',
    'apache-settings.nginxClientMaxBodySize' => 'Taille maximum autorisée pour le corps de la requête HTTP',
    'apache-settings.nginxClientMaxBodySizeDescription' => 'Les requêtes dont le corps est au-dessus de la limite seront rejetées avec l\'erreur HTTP 413 Payload Too Large (configurer la valeur de la directive nginx "client_max_body_size").',
    'apache-settings.nginxClientMaxBodySizeDisabled' => 'L\'option est désactivée de manière globale via la valeur zéro/vide de la directive "clientMaxBodySize" dans panel.ini.',
    'apache-settings.nginxCacheEnabled' => 'Activer la mise en cache Nginx',
    'apache-settings.nginxCacheEnabledDescription' => 'La mise en cache peut diminuer le temps de réponse du site Web et la charge du serveur, toutefois, elle doit être utilisée avec précaution.',
    'apache-settings.nginxCacheSize' => 'Taille de cache',
    'apache-settings.nginxCacheSizeGb' => 'Go',
    'apache-settings.nginxCacheSizeMb' => 'Mo',
    'apache-settings.nginxCacheSizeKb' => 'Ko',
    'apache-settings.nginxCacheSizeBytes' => 'o',
    'apache-settings.nginxCacheTimeout' => 'Expiration du délai de mise en cache',
    'apache-settings.nginxCacheTimeoutDays' => 'jours',
    'apache-settings.nginxCacheTimeoutHours' => 'heures',
    'apache-settings.nginxCacheTimeoutMinutes' => 'minutes',
    'apache-settings.nginxCacheTimeoutSeconds' => 'secondes',
    'apache-settings.nginxCacheKey' => 'Clé de cache',
    'apache-settings.nginxCacheCookies' => 'Mettre en cache les requêtes avec des cookies',
    'apache-settings.nginxCacheBypassLocations' => 'Désactiver le cache pour les emplacements',
    'apache-settings.nginxCacheBypass' => 'Ignorer le cache si',
    'apache-settings.nginxCacheBypassHeaderNocache' => 'Les en-têtes HTTP no-cache sont reçus dans la requête',
    'apache-settings.nginxCacheBypassHeaderAuth' => 'Les en-têtes d\'autorisation HTTP sont reçus dans la requête',
    'apache-settings.nginxCacheBypassGetNocache' => 'Le paramètre GET nocache est reçu dans la requête',
    'apache-settings.nginxCacheUseStale' => 'Renvoyer les enregistrements mis en cache expirés',
    'apache-settings.nginxCacheUseStale5xx' => 'L\'upstream renvoie l\'erreur serveur 5xx.',
    'apache-settings.nginxCacheUseStale4xx' => 'L\'upstream renvoie l\'erreur client 4xx.',
    'apache-settings.nginxCacheUseStaleUpdating' => 'Cache en cours de mise à jour',
    'apache-settings.additional' => 'Directives supplémentaires Apache',
    'apache-settings.additionalSettingsDescription' => 'Si vous ne trouvez pas de paramètres particuliers, ajoutez-les aux champs ci-dessous. Ces paramètres écraseront les directives Apache sur l\'ensemble du serveur. Les directives du premier champ sont utilisées lorsqu\'un visiteur accède au site via HTTP. Le second champ contient les instructions pour le protocole HTTPS. Généralement, vous devez ajouter vos directives aux deux champs. Utilisez la même syntaxe que pour httpd.include. Par exemple, si vous souhaitez définir une page d\'erreur personnalisée, ajoutez la ligne : ErrorDocument 401 /my_error_page.html',
    'apache-settings.additionalSettings' => 'Directives supplémentaires pour HTTP',
    'apache-settings.additionalSslSettings' => 'Directives supplémentaires pour HTTPS',
    'apache-settings.additionalSettingsError' => 'Configuration Apache invalide : %%error%%',
    'apache-settings.rollbackFailed' => 'Impossible d\'utiliser le fichier de configuration Apache actuel et de revenir à la version précédente du fichier car ils contiennent une configuration invalide.',
    'apache-settings.additionalNginx' => 'Directives supplémentaires Nginx',
    'apache-settings.additionalNginxSettingsDescription' => 'Vous pouvez préciser ici les paramètres pour le serveur de proxy inversé Nginx qui s',
    'apache-settings.additionalNginxSettings' => 'Directives supplémentaires Nginx',
    'apache-settings.additionalNginxSettingsError' => 'Configuration Nginx non valide : %%error%%',
    'apache-settings.nginxRollbackFailed' => 'Impossible d\'utiliser le fichier de configuration Nginx actuel et de revenir à la version précédente du fichier, car les deux contiennent une configuration non valide.',
    'apache-settings.clearCache' => 'Effacer le cache',
    'apache-settings.clearCacheHint' => 'Effacer le cache Nginx pour %%website%%',
    'apache-settings.cacheHasClearedSuccessfuly' => 'Le cache a bien été effacé.',

    'backup.backup-password-protection.securitySettingsSection' => 'Paramètres de sécurité des sauvegardes',
    'backup.backup-password-protection.backupPasswordFromFtpSettings' => 'Obtenir le mot de passe des paramètres de stockage distant',
    'backup.backup-password-protection.backupPasswordManualInput' => 'Entrer manuellement le mot de passe',
    'backup.backup-password-protection.providePasswordCheckbox' => 'Indiquer le mot de passe',
    'backup.backup-password-protection.backupPassword' => 'Mot de passe',
    'backup.backup-password-protection.inputPasswordType' => 'Type de mot de passe',
    'backup.backup-password-protection.confirmBackupPassword' => 'Confirmer le mot de passe',
    'backup.backup-password-protection.backupPasswordHint' => 'Si vous avez oublié votre mot de passe, décochez cette option. Notez que dans ce cas, certaines données confidentielles ne seront pas restaurées correctement. Par exemple, les mots de passe utilisateur seront remplacés par des mots de passe aléatoires, les informations sur les applications APS déjà installées seront perdues, etc.',
    'backup.backup-password-protection.backupPasswordFtpHint' => 'Si vous avez utilisé la protection par mot de passe pour cette sauvegarde, saisissez le mot de passe dans les champs ci-dessous. Notez que si vous indiquez un mot de passe non valide, Plesk ne restaurera pas la sauvegarde. À la place, la sauvegarde sera copiée vers le stockage local.',

    'backup.conflict-database.dbMappingLegend' => 'Mappage des serveurs de bases de données',
    'backup.conflict-database.serverType' => 'Type de serveur',
    'backup.conflict-database.hostName' => 'Nom de l\'hôte',
    'backup.conflict-database.port' => 'Port',
    'backup.conflict-database.destinationDbServer' => 'Serveur de base de données de destination',
    'backup.conflict-database.mysql' => 'MySQL',
    'backup.conflict-database.postgresql' => 'PostgreSQL',
    'backup.conflict-database.mssql' => 'MSSQL',
    'backup.conflict-database.migrationDbServerNotFind' => 'Impossible de restaurer la base de données : il n\'y a pas de serveur de bases de données adéquat.',

    'backup.conflict-ip.buttonUploadMappingFile' => 'Envoyer le fichier de mappage de l\'IP',
    'backup.conflict-ip.ipMappingLegend' => 'Mappage d\'adresses IP',
    'backup.conflict-ip.buttonSaveCurrentMapping' => 'Enregistrer le mappage de l\'IP actuelle dans le fichier',
    'backup.conflict-ip.ipAddressNotFound' => 'Aucune adresse IP de ce type n\'est disponible.',
    'backup.conflict-ip.sharedIp' => 'partagée',
    'backup.conflict-ip.dedicatedIp' => 'dédiée',
    'backup.conflict-ip.fileNotFound' => 'Le fichier ne doit pas être vide.',
    'backup.conflict-ip.invalidIpToMap' => 'Valeur non valide pour une ancienne adresse IP : %%ip%%',
    'backup.conflict-ip.invalidMappingValue' => 'Valeur non valide pour une nouvelle adresse IP : %%ip%%',
    'backup.conflict-ip.ipNotFound' => 'Adresse IP %%ip%% n\'ont trouvée dans la base de données.',
    'backup.conflict-ip.uploadIpMappingFileLegend' => 'Envoyer un fichier de mappage d\'IP',
    'backup.conflict-ip.ipMappingFileHint' => 'Le fichier de mappage de l\'IP est un fichier texte. Chaque ligne de ce fichier contient le mappage de l\'IP sous le format suivant : <ancienne adresse IP> <nouvelle adresse IP>',
    'backup.conflict-ip.oldIp' => 'Anciennes adresses IP',
    'backup.conflict-ip.newIp' => 'Nouvelles adresses IP',

    'backup.copy-to-server.ignoreBackupSign' => 'Envoyer les fichiers de sauvegarde sans signature valide',
    'backup.copy-to-server.wrongPassword' => 'Le mot de passe indiqué n\'est pas valide. Pendant la restauration de la sauvegarde, Plesk vous invitera à entrer de nouveau le mot de passe.',
    'backup.copy-to-server.corruptedSignatureUploaded' => 'Le fichier de sauvegarde %%fileName%% envoyé a été modifié, corrompu, créé sur un autre serveur ou dans une ancienne version de Plesk qui ne prend pas en charge la signature des sauvegardes. Avant de restaurer les données depuis ce fichier de sauvegarde, vérifiez si la source de ce fichier est fiable.',
    'backup.copy-to-server.corruptedSignatureNotUploadedUser' => 'Impossible d\'envoyer le fichier de sauvegarde %%fileName%%. Le fichier contient des données modifiées ou corrompues, a été créé sur un ancien serveur ou dans une version antérieure de Plesk. Pour restaurer les données depuis ce fichier, contactez votre hébergeur.',
    'backup.copy-to-server.corruptedSignatureNotUploadedAdmin' => 'Impossible d\'envoyer le fichier de sauvegarde %%fileName%%. Le fichier a été modifié, corrompu, créé sur un autre serveur ou dans une ancienne version de Plesk qui ne prend pas en charge la signature des sauvegardes. Si cette sauvegarde est fiable, sélectionnez l\'option "Envoyer les fichiers de sauvegarde sans signature valide" et renouvelez l\'envoi.',
    'backup.copy-to-server.unableToMoveToLocalRepository' => "Impossible de migrer la sauvegarde sélectionnée %%fileName%% dans le stockage du serveur. Erreur : %%error%%.",
    'backup.copy-to-server.missedPartsWarning' => "Les éléments suivants de la sauvegarde incrémentale n'ont pas été copiés : %%endl%%%%missedParts%%%%endl%%Veuillez copier les parties manquantes.",

    'backup.ftp-settings.isActive' => 'Utiliser le stockage FTP(S)',
    'backup.ftp-settings.host' => 'Nom d\'hôte ou adresse IP du serveur FTP',
    'backup.ftp-settings.directory' => 'Répertoire pour le stockage des fichiers de sauvegarde',
    'backup.ftp-settings.directoryHint' => 'Par exemple, /myfolder/mybackups/',
    'backup.ftp-settings.ftpLogin' => 'Nom d\'utilisateur FTP',
    'backup.ftp-settings.ftpPassword' => 'Mot de passe FTP',
    'backup.ftp-settings.usePassiveMode' => 'Utiliser le mode passif',
    'backup.ftp-settings.useFtps' => 'Utiliser FTPS',
    'backup.ftp-settings.errorHostIsLocal' => 'Il est interdit d\'utiliser le serveur FTP de Plesk en tant que stockage distant. Veuillez préciser un emplacement à distance.',
    'backup.ftp-settings.warningHostIsLocal' => 'Les paramètres de stockage FTP(S) ont été configurés pour stocker les sauvegardes sur le serveur où se trouvent vos fichiers d\'abonnements. Ce type de configuration n\'est pas recommandé en raison des risques de perte de données et de surutilisation de l\'espace disque.',
    'backup.ftp-settings.enterFtpLogin' => 'Entrez un nom d\'utilisateur valide.',
    'backup.ftp-settings.enterFtpPassword' => 'Entrez un mot de passe valide.',

    'backup.remote-settings.isActive' => 'Utiliser le stockage',
    'backup.remote-settings.initError' => 'Impossible d\'initialiser la page de paramètres %%extName%% : %%error%%',

    'backup.remote-storages.backupSecuritySettings' => 'Paramètres de sécurité des sauvegardes',

    'backup.restore.detailsSection' => 'Détails',
    'backup.restore.contentInfoSection' => 'Contenu de la sauvegarde',
    'backup.restore.restorationOptionsSection' => 'Options de restauration',
    'backup.restore.emailNotification' => 'Une fois la restauration terminée, envoyez la notification par mail à',
    'backup.restore.comments' => 'Commentaires',
    'backup.restore.creationDate' => 'Date de création',
    'backup.restore.systemNotes' => 'Notes du système',
    'backup.restore.ownerAdmin' => 'Créée par l\'administrateur.',
    'backup.restore.ownerReseller' => 'Créée par un revendeur.',
    'backup.restore.ownerCustomer' => 'Créée par un client.',
    'backup.restore.ownerServiceUser' => 'Créée par un utilisateur supplémentaire.',
    'backup.restore.partOfParentBackup' => 'Élément de la sauvegarde %%type%%.',
    'backup.restore.server' => 'serveur',
    'backup.restore.reseller' => 'revendeur',
    'backup.restore.client' => 'client',
    'backup.restore.incremental' => 'Incrémentale.',
    'backup.restore.multiVolume' => 'Multivolume.',
    'backup.restore.backupSize' => 'Taille de la sauvegarde',
    'backup.restore.backupSizeFirstIncremental' => '%%this%% (cet ajout) + %%base%% (sauvegarde d\'origine) = %%total%%',
    'backup.restore.backupSizeIncremental' => '%%this%% (cet ajout) + %%prev%% (ajouts précédents) + %%base%% (sauvegarde d\'origine) = %%total%%',
    'backup.restore.download' => 'Télécharger',
    'backup.restore.downloadHint' => 'Téléchargez le fichier de sauvegarde vers votre ordinateur local.',
    'backup.restore.downloadDisabled' => 'Le téléchargement de fichiers de sauvegarde est momentanément indisponible. Veuillez réessayer ultérieurement ou contacter votre fournisseur de services.',
    'backup.restore.copy' => 'Copier vers le stockage du serveur',
    'backup.restore.copyHint' => 'Copiez les fichiers de sauvegarde sélectionnés vers le stockage du serveur.',
    'backup.restore.contentInfo' => 'Contenus de la sauvegarde',
    'backup.restore.restoreButton' => 'Restaurer',
    'backup.restore.mail' => 'Boîte mail',
    'backup.restore.domainConfiguration' => 'Configuration du domaine',
    'backup.restore.virtualHost' => 'Contenu de l\'hôte virtuel',
    'backup.restore.database' => 'Bases de données',
    'backup.restore.serverConfiguration' => 'Paramètres du serveur',
    'backup.restore.serverConfigurationLicense' => 'Clé de licence',
    'backup.restore.serverPersonalConfiguration' => 'Configuration du compte administrateur',
    'backup.restore.serverPersonalDomains' => 'Domaines de l\'administrateur',
    'backup.restore.serverPersonalClients' => 'Clients de l\'administrateur',
    'backup.restore.resellers' => 'Revendeurs',
    'backup.restore.resellerPersonalConfiguration' => 'Configuration du compte revendeur',
    'backup.restore.resellerPersonalDomains' => 'Domaines du revendeur',
    'backup.restore.resellerPersonalClients' => 'Clients du revendeur',
    'backup.restore.clientPersonalConfiguration' => 'Configuration du compte client',
    'backup.restore.clientPersonalDomains' => 'Domaines du client',
    'backup.restore.restoreModifiedSection' => 'Restaurer le fichier de sauvegarde malgré une signature corrompue',
    'backup.restore.restoreModifiedDump' => 'Restaurer cette sauvegarde même si la signature n\'est pas valide',
    'backup.restore.resolutionPolicy' => 'Politique de résolution',
    'backup.restore.resolutionPolicyDescription' => 'Les conflits temporels se produisent soit lorsque l\'objet restauré existe déjà dans le système avec une date de modification plus récente ou lorsque l\'objet restauré n\'est pas actuellement présent dans le système.',
    'backup.restore.backupRestoreFtpWrongPassword' => 'Le mot de passe indiqué n\'est pas valide. Le fichier de sauvegarde sera copié dans le stockage local du serveur.',
    'backup.restore.backupRestoreLocalWrongPassword' => 'Impossible de restaurer la sauvegarde. Le mot de passe indiqué n\'est pas valide.',
    'backup.restore.serverContentAndConfiguration' => 'Contenu et configuration du serveur',
    'backup.restore.serverConfigurationOnly' => 'Configuration du serveur',
    'backup.restore.resellerContentAndConfiguration' => 'Contenu et configuration du compte revendeur',
    'backup.restore.resellerConfigurationOnly' => 'Configuration du compte revendeur',
    'backup.restore.clientContentAndConfiguration' => 'Contenu et configuration du compte client',
    'backup.restore.clientConfigurationOnly' => 'Configuration du compte client',
    'backup.restore.domainContentAndConfiguration' => 'Configuration et contenu du domaine',
    'backup.restore.domainConfigurationOnly' => 'Configuration du domaine',
    'backup.restore.restoreType' => 'Que voulez-vous restaurer ?',
    'backup.restore.restoreTypeFull' => 'Tous les objets (système complet)',
    'backup.restore.restoreTypeGranular' => 'Objets sélectionnés',
    'backup.restore.restoreObjectType' => 'Type d\'objet à restaurer',
    'backup.restore.restoreObjectTypeSubscriptions' => 'Abonnement',
    'backup.restore.restoreObjectTypeCustomers' => 'Client',
    'backup.restore.restoreObjectTypeResellers' => 'Revendeur',
    'backup.restore.restoreObjectTypeMailUsers' => 'Compte mail',
    'backup.restore.restoreObjectTypeDatabases' => 'Base de données',
    'backup.restore.restoreObjectTypeCertificates' => 'Certificats SSL/TLS',
    'backup.restore.restoreObjectTypeSites' => 'Sites',
    'backup.restore.restoreObjectTypeDnsZones' => 'Zone DNS',
    'backup.restore.restoreObjectTypeMailLists' => 'Listes de diffusion',
    'backup.restore.restoreObjectTypeWebContent' => 'Fichiers de domaines',
    'backup.restore.restoreObjects' => '%%objectType%%',
    'backup.restore.restoreObjectsWebContent' => 'Fichiers sélectionnés',
    'backup.restore.restoreSubscriptionLookup' => 'Abonnement',
    'backup.restore.restoreComponents' => 'Composants à restaurer',
    'backup.restore.errorLog' => 'Journal d\'erreurs',
    'backup.restore.backupDetailsLogDoesntExist' => 'Le journal de sauvegarde n\'est pas disponible.',
    'backup.restore.dumpFailedSection' => 'Journal d\'erreurs',
    'backup.restore.dumpFailed' => 'Impossible de restaurer les données : le fichier de sauvegarde n\'est pas valide.',
    'backup.restore.granularNotSupported' => 'Vous pouvez sélectionner les objets à restaurer uniquement pour les sauvegardes créées avec Plesk 12.0 ou une version ultérieure.',
    'backup.restore.fullNotSupportedInResellerPowerUser' => 'La restauration de toutes les données des sauvegardes n\'est pas prise en charge dans la vue Power User du revendeur. Sélectionnez les objets pour la restauration. Vous pouvez modifier votre interface sous %%interfaceLink%%.',
    'backup.restore.interfaceLink' => 'Préférences de l\'interface',
    'backup.restore.contentRestoreType' => 'Restaurer',
    'backup.restore.contentRestoreTypeSettingsOnly' => 'Configuration des objets sélectionnés uniquement',
    'backup.restore.contentRestoreTypeFull' => 'Configuration et contenu des objets sélectionnés',
    'backup.restore.errorWrongFormat' => 'Impossible de restaurer la sauvegarde : le fichier contient un format incorrect.',
    'backup.restore.errorContentError' => 'Impossible de restaurer toutes les données : la sauvegarde contient des erreurs de contenu.',
    'backup.restore.warningSignError' => 'Impossible de valider la signature de la sauvegarde. Ce fichier de sauvegarde est peut être modifié, corrompu, créé sur un autre serveur ou dans une version antérieure de Plesk.',
    'backup.restore.warningSignErrorNotAdmin' => 'Cette sauvegarde ne peut être restaurée que par l\'administrateur Plesk.',
    'backup.restore.warningPartial' => "Les parties suivantes des sauvegardes incrémentales n'ont pas été trouvées : %%endl%%%%missedParts%%%%endl%%Certains fichiers ne seront peut-être pas restaurés. Chargez les parties manquantes et essayez de relancer la restauration.",
    'backup.restore.warningDeprecatedBackupVersion' => 'La sauvegarde que vous essayez de restaurer a été créée dans une version de Plesk qui n\'est plus prise en charge et ne peut pas être restaurée. Utilisez l\'extension Plesk Migrator pour transférer vos données d\'anciennes versions de Plesk.',
    'backup.restore.encryptionKeyError' => 'Les mots de passe d\'un ou plusieurs comptes dans cette sauvegarde ne peuvent pas être restaurés et seront réinitialisés. Cette sauvegarde a probablement été créée sur un autre serveur Plesk et chiffrée avec sa clé de chiffrement.',
    'backup.restore.errorCorruptedContent' => 'Les fichiers suivants sont introuvables ou corrompus : ',
    'backup.restore.statusSection' => 'Statut de la sauvegarde',
    'backup.restore.statusDetails' => 'Détails du statut',
    'backup.restore.restoreBlocked' => 'Impossible de restaurer la sauvegarde.',
    'backup.restore.restoreBlockedDescription' => 'Impossible de restaurer la sauvegarde du type %%backupType%% maintenant. Pour la restaurer, connectez-vous en tant que propriétaire de la sauvegarde et cliquez sur le nom de cette sauvegarde dans le Gestionnaire de sauvegardes.',

    'backup.schedule.scheduleSection' => 'Planification',
    'backup.schedule.backupEnable' => 'Activer cette tâche de sauvegarde',
    'backup.schedule.backupPeriod' => 'Exécuter la tâche de sauvegarde',
    'backup.schedule.on' => 'le',
    'backup.schedule.at' => 'à',
    'backup.schedule.useIncremental' => 'Utiliser la sauvegarde incrémentale',
    'backup.schedule.fullBackupPeriod' => 'Sauvegarder intégralement',
    'backup.schedule.daily' => 'Ts les jours',
    'backup.schedule.weekly' => 'Ttes les semaines',
    'backup.schedule.monthly' => 'Ts les mois',
    'backup.schedule.yearly' => 'Ts les ans',
    'backup.schedule.days' => 'jours',
    'backup.schedule.weeks' => 'semaines',
    'backup.schedule.months' => 'Mois',
    'backup.schedule.years' => 'années',
    'backup.schedule.backupTimeDescription' => 'Fuseau horaire : %%timezone%%.',
    'backup.schedule.systemTimeZone' => 'Fuseau horaire par défaut du système',
    'backup.schedule.first' => 'premier',
    'backup.schedule.last' => 'dernier',
    'backup.schedule.dayOfMonth' => 'jour',
    'backup.schedule.email' => 'En cas d\'erreur pendant l\'exécution de la tâche de sauvegarde, envoyez une notification par mail à',
    'backup.schedule.invalidFields' => 'Certains champs sont vides ou contiennent une valeur non valide : %%fields%%.',
    'backup.schedule.maxDumpFiles' => 'Nombre maximum de fichiers de sauvegardes intégrales à stocker (y compris les sauvegardes planifiées et manuelles)',
    'backup.schedule.maxDumpFilesUnlimitedDescription' => 'Laissez ce champ vide si vous ne voulez pas supprimer automatiquement les sauvegardes complètes.',
    'backup.schedule.maxDumpFilesLimitedDescription' => 'La limite maximum pour le stockage du serveur indiquée par l\'hébergeur est %%max%%. Cette limite doit être inférieure ou égale à %%max%%.',
    'backup.schedule.backupToCloudIsNotAllowed' => 'Le stockage des sauvegardes planifiées dans un stockage cloud distant est une fonction premium que vous pouvez acheter depuis la boutique en ligne de Plesk.',

    'backup.secure-backup.hint' => 'Vous pouvez utiliser un mot de passe pour chiffrer les mots de passe utilisateurs contenus dans la base de données Plesk dans une sauvegarde. Remarque : si une sauvegarde protégée par mot de passe est restaurée sans fournir ce mot de passe, Plesk génère des mots de passe utilisateurs de manière aléatoire.',
    'backup.secure-backup.hintAdmin' => 'Vous pouvez chiffrer les mots de passe de la base de données Plesk contenus dans les sauvegardes à l\'aide de la clé de chiffrement de Plesk ou d\'un mot de passe. Cette clé est unique pour chaque installation de Plesk. Les sauvegardes chiffrées avec ce type de clé peuvent être restaurées uniquement dans l\'installation de Plesk dans laquelle elles ont été créées. Il est impossible de les restaurer dans une autre installation de Plesk. Remarque : Plesk ne protège pas toutes les données sensibles dans une sauvegarde. Nous vous recommandons de stocker les sauvegardes dans le stockage cloud distant et d\'activer le chiffrement de la sauvegarde du côté du stockage cloud.',
    'backup.secure-backup.usePasswordProtection' => 'Utiliser la protection par mot de passe (recommandé)',
    'backup.secure-backup.backupPasswordSource' => 'Type de mot de passe',
    'backup.secure-backup.pleskKey' => 'Clé de chiffrement de Plesk',
    'backup.secure-backup.userPassword' => 'Mot de passe indiqué',
    'backup.secure-backup.password' => 'Mot de passe',
    'backup.secure-backup.passwordConfirmation' => 'Confirmer le mot de passe',

    'backup.subform.settingsSection' => 'Paramètres de sauvegarde',
    'backup.subform.prefix' => 'Ajouter un préfixe au nom de la sauvegarde',
    'backup.subform.comment' => 'Commentaires',
    'backup.subform.splitSize' => 'Créer une sauvegarde multivolume, taille du volume (Mo)',
    'backup.subform.repository' => 'Stocker sous',
    'backup.subform.repositoryDescription' => 'Les paramètres de stockage FTP(S) ne sont pas indiqués. %%configure%%',
    'backup.subform.localAndSpecialRepositoryBackup' => 'Stockage du serveur et %%name%%',
    'backup.subform.remoteRepository' => 'stockage distant',
    'backup.subform.remoteRepositoryText' => 'Sélectionner le stockage cloud distant',
    'backup.subform.configureRemoteRepositories' => 'Vous pouvez <a href="%%url%%">configurer des stockages distants</a> pour conserver vos sauvegardes dans le Cloud.',
    'backup.subform.configureFtpRepository' => 'Vous pouvez <a href="%%url%%">configurer le stockage FTP</a> pour y conserver vos sauvegardes.',
    'backup.subform.repositoryConfigure' => 'Configuration',
    'backup.subform.email' => 'Une fois la tâche de sauvegarde terminée, envoyer une notification par mail à',
    'backup.subform.contentSection' => 'Contenu de la sauvegarde',
    'backup.subform.domainConfiguration' => 'Configuration',
    'backup.subform.domainConfigurationVhost' => 'Fichiers et bases de données utilisateur',
    'backup.subform.domainConfigurationMail' => 'Messages électroniques',
    'backup.subform.content' => 'Sauvegarder',
    'backup.subform.backupAll' => 'Intégralité de la configuration et du contenu',
    'backup.subform.backupConfiguration' => 'Configuration uniquement',
    'backup.subform.backupVhost' => 'Toutes les configurations et le contenu sauf les messages électroniques',
    'backup.subform.backupMail' => 'Uniquement les configurations et les messages électroniques',
    'backup.subform.mssqlNativeBackup' => 'Utiliser la fonction de sauvegarde native de MS SQL si possible',
    'backup.subform.mssqlNativeBackupAdmin' => 'Utiliser la fonction de sauvegarde native de MS SQL (pour les bases de données distantes, vous devez d\'abord configurer le serveur de sauvegardes sur le serveur MS SQL distant sur la page Outils & Paramètres  >  Serveur de base de données, si vous ne l\'avez pas encore fait)',
    'backup.subform.localRepository' => 'Stockage du serveur',
    'backup.subform.localRepositoryPath' => 'Stockage du serveur sous %%path%%',
    'backup.subform.backupNodeRepository' => '',
    'backup.subform.ftpRepository' => 'Stockage FTP(S) sous %%uri%% <a href="%%link%%">Modifier les paramètres</a>',
    'backup.subform.ftpRepositoryText' => 'Stockage FTP(S) : %%uri%%',
    'backup.subform.type' => 'Type',
    'backup.subform.typeFullBackup' => 'Complète',
    'backup.subform.typeIncremental' => 'Incrémentale',
    'backup.subform.typeIncrementalDescription' => 'Sauvegarder les données d\'hébergement Web et les mails qui ont été modifiés depuis la dernière sauvegarde (les données de la base de données sont toujours sauvegardées intégralement)',
    'backup.subform.incrementalNotAvailable' => 'Pour créer des sauvegardes incrémentales, créez d\'abord une sauvegarde complète.',
    'backup.subform.excludeLogs' => 'Exclure les fichiers journaux',
    'backup.subform.excludeFiles' => 'Exclure des fichiers spécifiques de la sauvegarde',
    'backup.subform.excludeFilesDescription' => 'Vous ne pouvez exclure que des fichiers dans des espaces Web. Indiquez les chemins relatifs vers la racine des espaces Web en séparant chaque fichier par une virgule. Le caractère générique est autorisé, par exemple /répertoire/log*.',

    'backup.upload.uploadHint' => 'Sur cette page, vous pouvez envoyer des fichiers de sauvegarde vers le stockage de Plesk. La taille maximum du fichier est limitée à deux gigaoctets.',
    'backup.upload.backupFile' => 'Fichier de sauvegarde',
    'backup.upload.removeLink' => 'Supprimer',
    'backup.upload.addFileLink' => 'Envoyer plus de fichiers',
    'backup.upload.backupSecuritySettings' => 'Paramètres de sécurité des sauvegardes',
    'backup.upload.signatureHint' => 'Plesk vérifie si les fichiers de sauvegarde ont une structure et une signature valides. Les fichiers modifiés, corrompus ou créés sur un autre serveur sont classés comme douteux. L\'option ci-dessous vous permet de restaurer des données depuis de tels fichiers. Sélectionnez cette option uniquement si la source de la sauvegarde est fiable, car l\'envoi d\'un tel fichier risque de compromettre la sécurité ou d\'interrompre l\'opération sur le serveur. Remarque : les fichiers de sauvegarde créés dans les versions antérieures à Plesk 11.5 sont considérés comme douteux, car ils n\'ont pas de signature. Restaurez ce type de fichier si la source est fiable.',
    'backup.upload.ignoreSign' => 'Envoyer les fichiers de sauvegarde sans signature valide',
    'backup.upload.passwordHint' => 'Si vous avez utilisé la protection par mot de passe pour cette sauvegarde, saisissez le mot de passe dans les champs ci-dessous. Notez que si vous indiquez un mot de passe non valide, Plesk vous le notifiera mais enverra tout de même la sauvegarde vers le serveur. Pendant la restauration de la sauvegarde, vous serez invité à entrer de nouveau le mot de passe.',
    'backup.upload.alreadyExistsWarning' => 'Le fichier de sauvegarde %%fileName%% existe déjà dans le stockage local du serveur.',
    'backup.upload.incorrectPasswordWarning' => 'Le mot de passe indiqué n\'est pas valide. Pendant la restauration de la sauvegarde, Plesk vous invitera à entrer de nouveau le mot de passe.',
    'backup.upload.deprecatedDumpError' => 'La sauvegarde que vous essayez de charger a été créée dans une version de Plesk qui n\'est plus prise en charge et ne peut pas être importée. Utilisez l\'extension Plesk Migrator pour transférer vos données d\'anciennes versions de Plesk.',
    'backup.upload.mailFormatWarning' => 'Le fichier de sauvegarde %%fileName%% a été envoyé vers le stockage. Important : le fichier de sauvegarde %%fileName%% comporte du contenu de mail qui ne sera pas restauré, car son format (Plesk 8.3 - 8.6) n\'est pas pris en charge. Afin de restaurer le contenu de cette messagerie, sauvegardez-le à l\'aide des outils de sauvegarde de Plesk. Sélectionnez l\'option Sauvegarder le contenu des boîtes mail et choisissez l\'option avec dump restauré sur tout serveur de messagerie.',
    'backup.upload.corruptedSignatureAdminWarning' => 'Le fichier de sauvegarde (%%fileName%%) envoyé a été modifié, corrompu, créé sur un autre serveur ou dans une ancienne version de Plesk qui ne prend pas en charge la signature des sauvegardes. Avant de restaurer les données depuis ce fichier de sauvegarde, vérifiez si la source de ce fichier est fiable.',
    'backup.upload.corruptedSignatureAdminError' => 'Impossible d\'envoyer le fichier de sauvegarde (%%fileName%%). Le fichier a été modifié, corrompu, créé sur un autre serveur ou dans une ancienne version de Plesk qui ne prend pas en charge la signature des sauvegardes. Si cette sauvegarde est fiable, sélectionnez l\'option "Envoyer les fichiers de sauvegarde sans signature valide" et renouvelez l\'envoi.',
    'backup.upload.corruptedSignatureUserWarning' => 'Le fichier de sauvegarde envoyé (%%fileName%%) contient des données modifiées ou corrompues, a été créé sur un autre serveur ou dans une version antérieure de Plesk.',
    'backup.upload.corruptedSignatureUserError' => 'Impossible d\'envoyer le fichier de sauvegarde (%%fileName%%). Le fichier contient des données modifiées ou corrompues, a été créé sur un ancien serveur ou dans une version antérieure de Plesk. Pour restaurer les données depuis ce fichier, contactez votre hébergeur.',
    'backup.upload.uploadError' => 'Impossible d\'envoyer %%fileName%% vers le stockage du serveur : %%error%%',
    'backup.upload.fileNotSelected' => 'Aucun fichier sélectionné pour l\'envoi. Sélectionnez au moins un fichier.',
    'backup.upload.missedPartsWarning' => "Les éléments suivants de la sauvegarde incrémentale n'ont pas été chargés : %%endl%%%%missedParts%%%%endl%%Veuillez charger les parties manquantes.",
    'backup.upload.unknownType' => 'Type d\'objet inconnu',
    'backup.upload.storageLink' => 'autre stockage',
    'backup.upload.anotherStorage' => 'Le dump a été envoyé à %%storageLink%%.',
    'backup.upload.resellerNotFound' => 'Revendeur %%name%% non trouvé. Créez le revendeur avant de restaurer le dump envoyé.',
    'backup.upload.clientNotFound' => 'Client %%name%% non trouvé. Créez le client avant de restaurer le dump envoyé.',
    'backup.upload.domainNotFound' => 'Domaine %%name%% non trouvé. Créez le domaine avant de restaurer le dump envoyé.',

    'backup.web-content-dynamic.addButtonTitle' => 'Ajouter des fichiers',
    'backup.web-content-dynamic.noItems' => 'Aucun fichier n\'est sélectionné',
    'backup.web-content-dynamic.hint' => 'Cochez les cases pour sélectionner les fichiers et les dossiers.',
    'backup.web-content-dynamic.title' => 'Sélectionner les fichiers',
    'backup.web-content-dynamic.columnName' => 'Nom',
    'backup.web-content-dynamic.columnChangeDate' => 'Modifié',
    'backup.web-content-dynamic.columnSize' => 'Taille',
    'backup.web-content-dynamic.columnPermissions' => 'Droits',
    'backup.web-content-dynamic.columnUser' => 'Utilisateur',
    'backup.web-content-dynamic.columnGroup' => 'Groupe',
    'backup.web-content-dynamic.waitButtonTitle' => 'Veuillez patienter',
    'backup.web-content-dynamic.loadingTitle' => 'Veuillez patienter. Chargement...',

    'backup.invalidFields' => 'Certains champs sont vides ou contiennent une valeur non valide.',
    'backup.notEnoughDiskSpace' => '%%path%% ne dispose pas de suffisamment d\'espace disque pour créer une sauvegarde. Vous devez disposer d\'au moins %%required%% Go d\'espace libre (%%available%% Go disponibles)',

    'change-subscriptions-owner.infoTitle' => 'Infos',
    'change-subscriptions-owner.infoDescription' => '%%total%% abonnement(s), %%active%% abonnement(s) actif(s), %%diskSpace%% d\'espace disque utilisé, %%traffic%% de trafic utilisé',
    'change-subscriptions-owner.possibleOwnersTitle' => 'Potentiels nouveaux propriétaires d\'abonnements',
    'change-subscriptions-owner.selectedSubscriptions' => 'Abonnements sélectionnés',
    'change-subscriptions-owner.subscriptionName' => 'Nom de l\'abonnement',
    'change-subscriptions-owner.ownerName' => 'Nom du propriétaire',
    'change-subscriptions-owner.currentIpAddress' => 'Adresse IP actuelle',
    'change-subscriptions-owner.newIpAddress' => 'Nouvelle adresse IP',
    'change-subscriptions-owner.submit' => 'Réaffecter',

    'cgroups-settings.cgroupsSettingsTab' => 'RAM, CPU, E/S disque',
    'cgroups-settings.cgroupsSettingsTabDescription' => 'Définissez des limites par abonnement sur la consommation de ressources système. Plesk utilise une fonctionnalité de noyau Linux appelée "groupes de contrôle" (cgroups) assurant le respect des limites.',
    'cgroups-settings.cpuSettings' => 'CPU',
    'cgroups-settings.cpuSettingsDescription' => 'Limitez des abonnements individuels au quota d\'utilisation CPU indiqué.',
    'cgroups-settings.cpuPeriodLimit' => 'Période de contrôle de l\'utilisation du CPU',
    'cgroups-settings.percentUsageDescription' => 'Le total du temps CPU correspond à %%total%%%%units%% pour votre serveur.',
    'cgroups-settings.ramSettings' => 'RAM',
    'cgroups-settings.ramSettingsDescription' => 'Limitez des abonnements individuels au quota d\'utilisation RAM indiqué. Remarque : si un abonnement dépasse cette limite, le processus le plus consommateur sera arrêté.',
    'cgroups-settings.ramPeriodLimit' => 'Période de contrôle de l\'utilisation RAM',
    'cgroups-settings.diskSettings' => 'E/O disque',
    'cgroups-settings.diskReadSettings' => 'Lecture de disque',
    'cgroups-settings.diskReadSettingsDescription' => 'Autorisez certains abonnements individuels à ne lire qu\'une quantité déterminée sur le disque.',
    'cgroups-settings.diskReadPeriodLimit' => 'Période de contrôle de l\'utilisation de la lecture disque',
    'cgroups-settings.diskWriteSettings' => 'Écriture sur le disque',
    'cgroups-settings.diskWriteSettingsDescription' => 'Autorisez certains abonnements individuels à n\'écrire qu\'une quantité déterminée sur le disque.',
    'cgroups-settings.diskWritePeriodLimit' => 'Période de contrôle de l\'utilisation de l\'écriture disque',
    'cgroups-settings.limit' => 'Limite',
    'cgroups-settings.threshold' => 'Notifier en cas de dépassement',
    'cgroups-settings.limitNotificationEnabled' => 'Notifications activées',
    'cgroups-settings.periodFiveMinutes' => '5 minutes',
    'cgroups-settings.periodHour' => '1 heure',
    'cgroups-settings.periodDay' => '1 jour (24 heures)',
    'cgroups-settings.mb' => 'Mo',
    'cgroups-settings.mbs' => 'Mo/sec',

    'custom-button.privateLabel' => 'Visible uniquement pour moi',
    'custom-button.textLabel' => 'Intitulé du bouton',
    'custom-button.tooltipLabel' => 'Texte de l\'infobulle',
    'custom-button.iconLabel' => 'Image du fond d\'écran',
    'custom-button.priorityLabel' => 'Priorité',
    'custom-button.urlLabel' => 'URL',
    'custom-button.urlParamsLabel' => 'Ajouter des paramètres à l\'URL',
    'custom-button.placeLabel' => 'Emplacement',
    'custom-button.internalLabel' => 'Ouvrir l\'URL dans Plesk',
    'custom-button.internalDescription' => 'Indiquez si l\'URL doit être ouverte dans une page de Plesk ou dans une nouvelle fenêtre de navigateur.',
    'custom-button.noFrameLabel' => 'Ne pas utiliser de cadre',
    'custom-button.noFrameDescription' => 'Si vous ajoutez un bouton personnalisé qui mène à une extension ou une application de Plesk dans le Panneau Client, vous pouvez indiquer comment vous souhaitez afficher ce service / cette application : dans un cadre ou intégré à l\'interface de Plesk.',
    'custom-button.urlParamLabel_dom_id' => 'Inclure l\'ID de l\'abonnement, l\'ID du domaine et l\'ID de l\'alias de domaine',
    'custom-button.urlParamLabel_dom_name' => 'Inclure le nom de domaine primaire',
    'custom-button.urlParamLabel_ftp_user' => 'Inclure le nom d\'utilisateur FTP',
    'custom-button.urlParamLabel_ftp_pass' => 'Inclure le mot de passe FTP',
    'custom-button.urlParamLabel_cl_id' => 'Inclure l\'ID du client',
    'custom-button.urlParamLabel_cname' => 'Inclure le nom de la raison sociale du client',
    'custom-button.urlParamLabel_pname' => 'Inclure le nom du contact du client',
    'custom-button.urlParamLabel_email' => 'Inclure l\'adresse mail du client',
    'custom-button.buttonPlace_navigation' => 'Accès commun',
    'custom-button.buttonPlace_admin' => 'Page d\'accueil de l\'administrateur',
    'custom-button.buttonPlace_admin-settings' => 'Page Outils & Paramètres de l\'administrateur',
    'custom-button.buttonPlace_reseller' => "Page d'accueil du revendeur",
    'custom-button.buttonPlace_reseller-settings' => 'Page Outils & Utilitaires du revendeur',
    'custom-button.buttonPlace_client' => 'Page d\'accueil du client',
    'custom-button.buttonPlace_domain' => "Page Sites Web & Domaines de l'abonnement",
    'custom-button.buttonPlace_domain_powerUser' => "Page Sites Web & Domaine de l'espace Web",
    'custom-button.buttonPlace_domain-properties' => 'Outils du site Web',

    'database-server-change-password.adminPassword' => 'Mot de passe de l\'administrateur',
    'database-server-change-password.success' => 'Le mot de passe administrateur a bien été mis à jour.',

    'database-server-create.general' => 'Général',
    'database-server-create.type' => 'Type de serveur de base de données',
    'database-server-create.unixSocket' => '(connexion locale)',
    'database-server-create.host' => 'Nom d\'hôte ou adresse IP',
    'database-server-create.port' => 'Numéro de port',
    'database-server-create.portDescription' => 'Laissez le champ \'Numéro de port par défaut\' vide',
    'database-server-create.version' => 'Version du serveur de base de données',
    'database-server-create.default' => 'Utiliser ce serveur par défaut pour %%type%%',
    'database-server-create.externalConnections' => 'Autoriser le serveur MySQL local à accepter les connexions externes',
    'database-server-create.externalConnectionsDescription' => 'Si ce paramètre est modifié, le serveur MySQL local est redémarré. Pour activer l\'accès distant à d\'autres serveurs MySQL enregistrés sous Plesk, modifiez leur configuration manuellement.',
    'database-server-create.authentication' => 'Authentification',
    'database-server-create.authenticationAddDescription' => 'Indiquez les identifiants d\'accès de l\'administrateur de la base de données que Plesk utilisera pour accéder au serveur de bases de données. Un compte administrateur avec ces identifiants d\'accès doit exister sur le serveur de bases de données.',
    'database-server-create.authenticationEditDescription' => 'Sur cette page, vous pouvez changer les identifiants d\'accès que Plesk utilise pour accéder au serveur de bases de données. Ces identifiants doivent correspondre aux identifiants de l\'administrateur de base de données. Par exemple, une fois que vous avez changé les identifiants de l\'administrateur sur le serveur de bases de données, vous devez également les changer dans Plesk.',
    'database-server-create.authenticationChangeDescription' => 'Sur cette page, vous pouvez changer les identifiants d\'accès que Plesk utilise pour accéder au serveur de bases de données. Si vous changez le nom d\'utilisateur ou le mot de passe ci-dessous, le compte utilisateur de la base de données avec les droits administrateur sera mis à jour sur le serveur de bases de données et dans Plesk.',
    'database-server-create.adminLogin' => 'Nom d\'utilisateur',
    'database-server-create.adminPassword' => 'Mot de passe',
    'database-server-create.createSuccess' => 'Le serveur de base de données a bien été créé.',
    'database-server-create.createError' => 'Le serveur de bases de données a été créé avec l\'erreur : %%error%%',
    'database-server-create.updateSuccess' => 'Le serveur de la base de données a bien été mis à jour.',
    'database-server-create.updateError' => 'Le serveur de bases de données a été mis à jour avec l\'erreur : %%error%%.',
    'database-server-create.backupSettings' => 'Sauvegarde',
    'database-server-create.backupTempDir' => 'Répertoire temporaire',
    'database-server-create.backupTempDirDescription' => 'Chemin d\'accès à un dossier physique sur le serveur distant sur lequel se trouve le serveur MS SQL. Le serveur MS SQL doit être capable d\'accéder à ce dossier pour lire et écrire des fichiers de sauvegarde temporaires. Par exemple, C:\\DirectoryPath.',
    'database-server-create.backupNetworkTempDir' => 'Répertoire réseau temporaire',
    'database-server-create.backupNetworkTempDirDescription' => 'Chemin d\'accès vers le partage réseau mappé au dossier physique indiqué ci-dessus. Plesk accèdera au dossier partagé pour télécharger et envoyer les fichiers de sauvegarde. Par exemple : \\\\ServerName\\DirectoryPath',
    'database-server-create.backupNetworkUser' => 'Nom d\'utilisateur',
    'database-server-create.backupNetworkUserDescription' => 'Le nom d\'utilisateur d\'un utilisateur réseau créé sur un serveur distant. Par exemple, ServerName\\UserName. L\'utilisateur doit avoir l\'accès au dossier partagé indiqué ci-dessus.',
    'database-server-create.backupNetworkPassword' => 'Mot de passe',

    'domain.connection-info.title' => 'Infos de connexion',
    'domain.connection-info.systemUserCredentials' => 'Identifiants d\'accès de l\'utilisateur système',
    'domain.connection-info.systemUserCredentialsHint' => 'L\'accès via FTP est toujours activé. L\'accès via SSH ou Remote Desktop seulement si : %%details%%.',
    'domain.connection-info.systemUserCredentialsHintDetails' => 'le droit est accordé',
    'domain.connection-info.systemUserRemoveAccessEnabled' => 'Votre accès SSH ou Remote Desktop est activé et vous ne pouvez pas gérer son statut.',
    'domain.connection-info.systemUserRemoveAccessDisabled' => 'Votre accès SSH ou Remote Desktop est désactivé et vous ne pouvez pas gérer son statut.',
    'domain.connection-info.ipAddress' => 'Adresse IP',
    'domain.connection-info.copyToClipboard' => 'Copier dans le presse-papiers',
    'domain.connection-info.username' => 'Nom d\'utilisateur',
    'domain.connection-info.password' => 'Mot de passe',
    'domain.connection-info.changeSystemUserPasswordTitle' => 'Modification du mot de passe de l\'utilisateur système',
    'domain.connection-info.changePasswordTooltip' => 'Modifier le mot de passe',
    'domain.connection-info.newPassword' => 'Nouveau mot de passe',
    'domain.connection-info.manageAccess' => 'Gérer l\'accès',
    'domain.connection-info.additionalFtpAccounts' => 'Comptes FTP supplémentaires',
    'domain.connection-info.database' => 'Base de données',
    'domain.connection-info.databaseHint' => '1 base de données sur %%number%% appartient à l\'abonnement.',
    'domain.connection-info.databaseNotCreatedHint' => 'La base données n\'est pas créée.',
    'domain.connection-info.databaseType.mysql' => 'MySQL',
    'domain.connection-info.databaseType.mssql' => 'Serveur MS SQL',
    'domain.connection-info.databaseType.postgresql' => 'PostgreSQL',
    'domain.connection-info.databaseType.mariadb' => 'MariaDB',
    'domain.connection-info.databaseType.percona' => 'Percona',
    'domain.connection-info.databaseHost' => 'Hôte',
    'domain.connection-info.databaseHostValue' => '%%value%% (%%fork%%)',
    'domain.connection-info.databaseName' => 'Nom de la base de données',
    'domain.connection-info.addDatabase' => 'Ajouter une base de données',
    'domain.connection-info.manageDatabases' => 'Gérer les bases de données',
    'domain.connection-info.phpMyAdmin' => 'phpMyAdmin',
    'domain.connection-info.myLittleAdmin' => 'myLittleAdmin',
    'domain.connection-info.changeDatabaseUserPasswordTitle' => 'Modification du mot de passe de l\'utilisateur de la base de données',
    'domain.connection-info.changeDatabaseUserPasswordNotice' => 'N\'oubliez pas de mettre à jour le mot de passe dans les fichiers de configuration de votre application une fois que vous l\'avez modifié ici.',
    'domain.connection-info.buttonSave' => 'Enregistrer',
    'domain.connection-info.buttonSaving' => 'Enregistrement...',
    'domain.connection-info.buttonCancel' => 'Annuler',

    'domain.move.title' => 'Déplacer le domaine %%name%%',
    'domain.move.hint' => 'Le domaine sera déplacé vers un nouvel abonnement, tout comme son contenu, ses fichiers de configuration, fichiers journaux et applications APS.',
    'domain.move.hintMain' => 'Le domaine sera déplacé vers un nouvel abonnement avec son contenu, les fichiers de configuration, les fichiers journaux, les bases de données, les utilisateurs de base de données, les utilisateurs FTP supplémentaires, les tâches planifiées, les utilisateurs smb et les applications APS.',
    'domain.move.hintSubdomains' => 'Les sous-domaine %%subdomains%% seront déplacés avec le sous-domaine parent.',
    'domain.move.hintAliases' => 'Les alias de domaine %%aliases%% seront déplacés avec le domaine parent.',
    'domain.move.hintSubdomainsAndAliases' => 'Les sous-domaine %%subdomains%% et alias de domaine %%aliases%% seront déplacés avec le domaine parent.',
    'domain.move.labelDatabases' => 'Une fois que vous avez déplacé le domaine, ouvrez l\'onglet "Bases de données" pour déplacer les bases de données associées.',
    'domain.move.hintDatabases' => 'Le cas échéant, déplacez séparément les bases de données.',

    'domain.move.Form.submitButton' => 'Déplacer',
    'domain.move.Form.cancelButton' => 'Annuler',

    'domain.move.selectTarget' => 'Abonnements disponibles',
    'domain.move.nothingFound' => 'Aucun élément trouvé',
    'domain.move.targetIsRequred' => 'Sélectionnez l\'abonnement vers lequel déplacer le domaine.',
    'domain.move.selectNewSubscription' => 'Créer un abonnement',
    'domain.move.ipv4Address' => 'Adresse IPv4',
    'domain.move.ipv4AddressHint' => 'L\'adresse IP où le site Web est hébergé est une adresse réseau de l\'hôte virtuel du site Web.',
    'domain.move.ipv6Address' => 'Adresse IPv6',
    'domain.move.ipv6AddressHint' => 'L\'adresse IP où le site Web est hébergé est une adresse réseau de l\'hôte virtuel du site Web.',
    'domain.move.ipAddressIsNotSelected' => 'Au moins une adresse IP doit être sélectionnée.',
    'domain.move.username' => 'Nom d\'utilisateur',
    'domain.move.usernameHint' => 'Compte utilisateur système associé à l\'espace Web. Utilisé pour accéder aux fichiers hébergés via FTP et SSH.',
    'domain.move.usernameIsRequred' => 'Indiquez un nom d\'utilisateur.',
    'domain.move.password' => 'Mot de passe',
    'domain.move.passwordIsRequred' => 'Indiquez un mot de passe.',
    'domain.move.noAvailableSubscriptions' => 'Pas d\'abonnement disponible',
    'domain.move.noWebHosting' => 'Aucun utilisateur du système ne sera créé pour le moment car le domaine n\'a pas d\'hébergement Web.',

    'domain.rename.title' => 'Changer le nom de domaine',
    'domain.rename.titleAlias' => 'Changer le nom de l\'alias de domaine',
    'domain.rename.hint' => 'Vous modifiez actuellement le nom de domaine %%domainName%%',
    'domain.rename.hintAlias' => 'Vous modifiez actuellement le nom de l\'alias de domaine %%domainName%%',
    'domain.rename.name' => 'Nouveau nom de domaine',
    'domain.rename.nameAlias' => 'Nouveau nom de l\'alias de domaine',
    'domain.rename.domainNameIsRequired' => 'Ce champ obligatoire est vide. Vous devez indiquer une valeur.',
    'domain.rename.submitButton' => 'Modifier',
    'domain.rename.submitButtonProgress' => 'Modification...',
    'domain.rename.successMessage' => 'Le nom de domaine %%oldName%% a été remplacé par %%newName%%.',
    'domain.rename.successMessageAlias' => 'Le nom de l\'alias de domaine %%oldName%% a été remplacé par %%newName%%.',

    'domain.rename.Form.cancelButton' => 'Annuler',

    'domain.outgoing-messages.hint' => 'Sur cette page, vous pouvez modifier la limite du nombre de messages sortants pour ce domaine. Il sera impossible d\'envoyer plus de messages que la limite indiquée.',
    'domain.outgoing-messages.domainOutgoingMessagesSubscriptionDefault' => 'Par défaut (%%domainOutgoingMessages%% messages par heure)',
    'domain.outgoing-messages.domainOutgoingMessagesSpecificHint' => 'messages par heure',
    'domain.outgoing-messages.domainOutgoingMessages' => 'Limites des messages sortants',
    'domain.outgoing-messages.domainOutgoingMessagesCustomLimit' => 'Valeur personnalisée pour ce domaine',

    'domain.tech-domain-name.title' => 'Sélectionner votre nom de domaine',
    'domain.tech-domain-name.techDomainTitle' => 'Nom de domaine temporaire',
    'domain.tech-domain-name.customDomainTitle' => 'Nom de domaine enregistré',
    'domain.tech-domain-name.techDomainText' => 'Je n\'ai pas encore de nom de domaine enregistré.',
    'domain.tech-domain-name.customDomainText' => 'J\'ai déjà un nom de domaine enregistré.',
    'domain.tech-domain-name.techDomain' => 'Votre nom de domaine temporaire',
    'domain.tech-domain-name.customDomain' => 'Nom de domaine enregistré',
    'domain.tech-domain-name.domainName' => 'Nom de domaine',
    'domain.tech-domain-name.techDomainDesc' => 'Les noms de domaines temporaires sont utilisés pour accéder à votre site avant le processus d\'enregistrement et d\'achat de votre propre nom de domaine. Ils sont fournis gratuitement aux conditions suivantes :',
    'domain.tech-domain-name.techDomainRandom' => 'Les noms sont générés aléatoirement.',
    'domain.tech-domain-name.techDomainDns' => 'Ils sont hébergés dans la zone DNS ".plesk.page".',
    'domain.tech-domain-name.techDomainSwitch' => 'Vous pouvez passer à un domaine enregistré à tout moment par la suite en renommant votre domaine via les paramètres du domaine.',
    'domain.tech-domain-name.error' => 'Une erreur inattendue s\'est produite.',
    'domain.tech-domain-name.errorNoIpAddress' => 'Vous devez sélectionner l\'adresse IP.',
    'domain.tech-domain-name.generating' => 'Génération...',

    'get-password.label' => 'Réinitialiser le mot de passe',
    'get-password.text' => 'Entrez l\'adresse mail ou le nom d\'utilisateur que vous avez enregistré dans Plesk et nous vous enverrons un message de réinitialisation du mot de passe.',
    'get-password.emailLabel' => 'Adresse mail',
    'get-password.loginLabel' => 'Nom d\'utilisateur',
    'get-password.send' => 'Envoyer',
    'get-password.cancel' => 'Annuler',
    'get-password.errorInvalidEmail' => 'L\'adresse mail n\'est pas reconnue. Vérifiez à nouveau et réessayez.',
    'get-password.messageSend' => "Le message de réinitialisation du mot de passe a été envoyé à l'adresse mail associée.\nSi vous ne recevez pas le mail, veuillez contacter votre administrateur de Plesk.",

    'iis-settings.formGeneralHint' => 'Sur cette page, vous pouvez indiquer les paramètres du serveur Web pour votre site Web en modifiant les valeurs par défaut. La configuration personnalisée d\'IIS est utile notamment lorsque vous voulez utiliser un nouveau type de fichiers d\'index sur votre site Web ou associer un certain type MIME avec certaines extensions de noms de fichiers. Les valeurs par défaut sont définies par votre hébergeur.',
    'iis-settings.formGeneralHint_powerUser' => 'Sur cette page, vous pouvez indiquer les paramètres du serveur Web IIS pour ce site Web. La configuration personnalisée d\'IIS est utile notamment lorsque vous voulez utiliser un nouveau type de fichiers d\'index sur votre site Web ou associer un certain type MIME avec certaines extensions de noms de fichiers. Les valeurs par défaut signifient qu\'IIS utilisera les directives correspondantes à partir de la configuration de l\'ensemble du serveur.',
    'iis-settings.virtualDirectoryLoadError' => 'Impossible d\'obtenir les propriétés du répertoire virtuel indiqué : %%errorMessage%%',
    'iis-settings.general' => 'Paramètres communs',
    'iis-settings.example' => "Par exemple :\n%%example%%",
    'iis-settings.settingOn' => 'Activé',
    'iis-settings.settingOff' => 'Désactivé (par défaut)',
    'iis-settings.settingDefault' => 'Par défaut',
    'iis-settings.settingCustom' => 'Entrer une valeur personnalisée',
    'iis-settings.mimeTypes' => 'Types MIME',
    'iis-settings.mimeTypesExample' => "text/plain .mytxt\nimage/jpeg .myjpeg",
    'iis-settings.mimeTypesFullDescription' => 'Les types MIME associent les extensions de fichiers aux types de fichiers. Généralement, le standard MIME est utilisé pour créer des extensions de fichier personnalisées pour des types de fichiers communs.',
    'iis-settings.documents' => 'Documents par défaut',
    'iis-settings.documentsOff' => 'Désactivé',
    'iis-settings.documentsCustom' => 'Saisir les valeurs',
    'iis-settings.documentsExample' => "Index.html\nIndex.htm\nIndex.cfm",
    'iis-settings.documentsFullDescription' => 'Lorsque les navigateurs ne fournissent pas le nom d\'un document au sein de votre site, IIS recherche les documents par défaut indiqués et fournit le premier trouvé. Si vous ne précisez pas les documents par défaut et si vous activez la recherche dans le répertoire, alors la liste du répertoire s\'affiche dans les navigateurs à la place de la page d\'index.',
    'iis-settings.expires' => 'Expire',
    'iis-settings.expiresFullDescription' => 'Le serveur Web affichera les en-têtes de réponse "Expire" aux pages Web. L\'horodatage d\'expiration s\'obtient en ajoutant la durée indiquée ci-dessus à la date/heure à laquelle une page Web est requise.',
    'iis-settings.expiresUnitDays' => 'jours',
    'iis-settings.expiresUnitHours' => 'heures',
    'iis-settings.expiresUnitMinutes' => 'minutes',
    'iis-settings.expiresUnitSeconds' => 'secondes',
    'iis-settings.headers' => 'Autres en-têtes',
    'iis-settings.headersExample' => "Cache-Control: public\nStrict-Transport-Security: max-age=63072000; includeSubdomains;\nX-Frame-Options: DENY",
    'iis-settings.headersFullDescription' => 'Le serveur Web ajoutera les entêtes de réponse HTTP spécifiés.',
    'iis-settings.directoryBrowsing' => 'Exploration des répertoires',
    'iis-settings.directoryBrowsingDescription' => 'Autorise les utilisateurs à voir la liste des répertoires du site dans les navigateurs Web. Par exemple : lorsque la page d\'index par défaut n\'est pas disponible.',
    'iis-settings.securityTabDirectory' => 'Paramètres de sécurité du répertoire',
    'iis-settings.allowAnonymous' => 'Authentification anonyme',
    'iis-settings.allowAnonymousDescription' => 'L\'authentification anonyme autorise les utilisateurs à accéder au contenu public de votre site. Le contenu de votre site protégé par mot de passe, ainsi que le contenu protégé au niveau du système de fichiers ne sont pas accessibles aux utilisateurs anonymes.',
    'iis-settings.allowWindows' => 'Authentification Windows',
    'iis-settings.allowWindowsDescription' => 'L\'authentification Windows (anciennement NTLM) protège le contenu de votre site au niveau du système de fichiers.',
    'iis-settings.requireSsl' => 'Exiger SSL/TLS',
    'iis-settings.requireSslDescription' => 'Si vous avez activé la prise en charge du protocole SSL/TLS sur votre site, cette option oblige les clients Web (navigateurs) à n\'utiliser que des connexions HTTPS sécurisées.',
    'iis-settings.securityTabIpDeny' => 'Paramètres de restriction d\'accès',
    'iis-settings.deny' => 'Refuser l\'accès au site',
    'iis-settings.denyOff' => 'Par défaut',
    'iis-settings.denyCustom' => 'Entrer une valeur personnalisée',
    'iis-settings.allow' => 'Exclus',
    'iis-settings.denyExample' => "10.1.0.0/16\n192.168.1.110\n\nLes hôtes et les réseaux indiqués ne sont pas autorisés à accéder au site. Utilisez '*' pour refuser toutes les connexions.",
    'iis-settings.allowExample' => "192.168.0.0/16\n10.1.1.21\n\nLes hôtes et les réseaux indiqués sont autorisés à accéder au site.",
    'iis-settings.dynamicIpSecurity' => 'Prévention des attaques DoS via la restriction des IP dynamiques IIS',
    'iis-settings.isDenyByConcurrentRequests' => 'Refuser les adresses IP basées sur le nombre de demandes concurrentes à partir d\'une adresse IP unique',
    'iis-settings.maxConcurrentRequests' => 'Nombre maximum de demandes concurrentes',
    'iis-settings.isDenyByRequestRate' => 'Refuser les adresses IP basées sur le nombre de requêtes pendant un certain temps',
    'iis-settings.maxRequests' => 'Nombre maximum de demandes',
    'iis-settings.requestInterval' => 'Période (en millisecondes)',

    'ip-addresses-selector.ipAddress' => 'Adresse IP',
    'ip-addresses-selector.ipv4Address' => 'Adresse IPv4',
    'ip-addresses-selector.ipv4AddressHint' => "L'adresse IP sur laquelle le site Web est hébergé est une adresse réseau de l'hôte virtuel du site Web.",
    'ip-addresses-selector.ipv6Address' => 'Adresse IPv6',
    'ip-addresses-selector.ipv6AddressHint' => "L'adresse IP sur laquelle le site Web est hébergé est une adresse réseau de l'hôte virtuel du site Web.",
    'ip-addresses-selector.noIpAddressHint' => 'Aucun(e)',
    'ip-addresses-selector.shared' => 'partagée',
    'ip-addresses-selector.exclusive' => 'dédiée',
    'ip-addresses-selector.ipV6OnlyNotSupported' => 'Le serveur FTP ne prend pas en charge d\'adresse IPv6. Allouez au moins une adresse IPv4 sinon l\'utilisateur ne pourra pas envoyer les fichiers au serveur via FTP.',

    'license-key-revert.description' => 'La licence avec les propriétés suivantes sera restaurée :',
    'license-key-revert.submitButton' => 'Revenir en arrière',

    'license-key-upload.description' => 'Installez votre clé de licence en saisissant un code d\'activation.',
    'license-key-upload.descriptionWithFileUpload' => 'Pour installer votre clé de licence, saisissez un code d\'activation ou téléversez un fichier de clé de licence.',
    'license-key-upload.type' => 'Choisissez l\'une des options suivantes :',
    'license-key-upload.code' => 'Entrer un code d\'activation',
    'license-key-upload.codeDescription' => 'Collez le code d\'activation que vous avez reçu.',
    'license-key-upload.file' => 'Envoyer un fichier de clé de licence',
    'license-key-upload.fileDescription' => 'Indiquez le chemin d\'accès vers le fichier contenant la clé de licence.',
    'license-key-upload.submitButton' => 'Installer',

    'log-rotation.customLogsDescription' => 'Remarque : vos journaux personnalisés ne subissent pas de rotation.',
    'log-rotation.logRotation' => 'Rotation des journaux',
    'log-rotation.logRotationCondition' => 'Condition de rotation des journaux',
    'log-rotation.logRotationBySize' => 'Par taille',
    'log-rotation.logRotationByTime' => 'Par date',
    'log-rotation.logRotationDaily' => 'Tous les jours',
    'log-rotation.logRotationWeekly' => 'Toutes les semaines',
    'log-rotation.logRotationMonthly' => 'Tous les mois',
    'log-rotation.logRotationSizeDescription' => 'La valeur du volume doit être comprise entre %%min%% et %%max%% Ko.',
    'log-rotation.maximumNumberOfFiles' => 'Nombre maximum de fichiers journaux',
    'log-rotation.compress' => 'Compresser les fichiers journaux',
    'log-rotation.sendLogToEmail' => 'Une fois que Plesk a récupéré les données à partir des fichiers journaux des serveurs Web et FTP, envoyer les journaux par mail à cette adresse',
    'log-rotation.kb' => 'Ko',
    'log-rotation.logRotationPeriodGreater' => 'La période ne peut pas être supérieure à la limite valable pour l\'ensemble du serveur %%max%%.',

    'login.loginLabel' => 'Nom d\'utilisateur',
    'login.passwdLabel' => 'Mot de passe',
    'login.localeLabel' => 'Langue de l\'interface',
    'login.defaultLocale' => 'Par défaut',
    'login.loginButtonLabel' => 'Se connecter',
    'login.enterUsername' => 'Saisissez votre nom d\'utilisateur.',
    'login.enterPassword' => 'Saisissez votre mot de passe.',
    'login.whatUsernamePassword' => 'Quel nom d\'utilisateur et quel mot de passe utiliser ?',
    'login.forgotPasswordLabel' => 'Mot de passe oublié ?',
    'login.cookies' => 'Politique relative aux cookies dans Plesk',
    'login.avoidSSLWarningsMsg' => 'Pour éviter les avertissements pendant la connexion à Plesk, utilisez %%link%%',
    'login.digitalOceanMsg' => 'Vous utilisez Plesk sur DigitalOcean pour la première fois ? Utilisez "root" et le mot de passe que vous avez saisi lors de la création de ce droplet pour vous connecter. %%link%%',
    'login.amazonLightsailMsg' => 'Vous utilisez Plesk sur Lightsail ? Pour vous connecter à Plesk, accédez au serveur via SSH et utilisez la commande "plesk login". %%link%%',
    'login.readGuide' => 'Lisez le guide complet.',
    'login.mobileApplicationMessage' => 'Pour améliorer votre expérience, nous vous recommandons d\'installer l\'application %%name%%.',
    'login.mobileApplicationInstall' => 'Installer maintenant',
    'login.mobileApplicationHide' => 'Non, merci',

    'force-reset-password.saveButton' => 'Enregistrer',
    'force-reset-password.title' => 'Modifier votre mot de passe',
    'force-reset-password.passwordLabel' => 'Nouveau mot de passe',

    'panel-access.title' => 'Personnaliser l\'URL de Plesk',
    'panel-access.hint' => 'Choisissez les URL personnalisées pour la connexion à Plesk. Cela n\'affectera pas la possibilité de se connecter à Plesk via le port %%httpsPort%%. %%link%%',
    'panel-access.details' => 'Plus de détails',
    'panel-access.proxyEnabled' => 'Tous les domaines ou sous-domaines qui résolvent l\'adresse IP du serveur, mais qui ne sont pas utilisés pour l\'hébergement.',
    'panel-access.proxyDomain' => 'Domaine ou sous-domaine spécifié qui résout l\'adresse IP serveur, mais qui n\'est pas utilisé pour l\'hébergement.',
    'panel-access.proxyDisabled' => 'Pas d\'URL personnalisée. https://<server-IP-or-hostname>:%%httpsPort%% uniquement.',

    'panel-access.Form.submitButton' => 'Enregistrer',
    'panel-access.Form.cancelButton' => 'Annuler',

    'panel-access.domainNameIsRequired' => 'Indiquez un nom de domaine.',
    'panel-access.successMessage' => 'Le type de connexion sélectionné a été appliqué.',
    'panel-access.notSupported' => 'Votre version de Plesk ne prend pas en charge le mode de connexion sélectionné.',
    'panel-access.notViaDomainName' => 'Pour appliquer ce type de connexion, choisissez la première option ("Tous les domaines ou sous-domaines..."). Connectez-vous à Plesk via https://%%domainName%%, puis choisissez la seconde option.',
    'panel-access.notViaPort' => 'Pour appliquer ce type de connexion, connectez-vous à d\'abord Plesk via https://<server-IP-or-hostname>: %%httpsPort%%.',

    'php-settings.performance' => 'Paramètres de performances et de sécurité',
    'php-settings.settings' => 'Paramètres communs',
    'php-settings.fastCgiSettings' => 'Paramètres FastCGI',
    'php-settings.fpmSettings' => 'Paramètres PHP-FPM',
    'php-settings.enableFastcgi' => 'Activer les paramètres FastCGI',
    'php-settings.plainTextEditing' => 'Directives supplémentaires',
    'php-settings.placeAdditionalCustomizationDirectivesHere' => 'Pour définir les paramètres PHP, vous pouvez les saisir dans le champ ci-dessous. Les directives seront incluses dans la configuration PHP. Utilisez la même syntaxe que celle que vous utiliseriez pour php.ini. Par exemple, si vous voulez automatiquement charger l\'extension mSQL, ajoutez la ligne : extension=msql.so.',
    'php-settings.placeAdditionalCustomizationDirectivesHereAddonPlan' => 'Si vous ne pouvez pas trouver de paramètres PHP particuliers, ajoutez-les dans le champ ci-dessous. Ces directives supplémentaires seront fusionnées avec les directives du pack de services principal. Utilisez la même syntaxe que celle utilisée pour php.ini. Par exemple, si vous voulez automatiquement charger l\'extension mSQL, ajoutez la ligne : extension=msql.so.',
    'php-settings.placeFpmAdditionalCustomizationDirectivesHere' => 'Pour définir les paramètres PHP, vous pouvez les saisir dans le champ ci-dessous. Les directives seront incluses dans la configuration PHP. Utilisez la même syntaxe que celle que vous utiliseriez pour php.ini. Par exemple, si vous voulez automatiquement charger l\'extension mSQL, ajoutez la ligne : extension=msql.so. Pour personnaliser les paramètres du pool PHP-FPM, ajoutez le séparateur [php-fpm-pool-settings] et saisissez les paramètres souhaités ci-dessous.',
    'php-settings.additionalConfigurationDirectives' => 'Autres instructions de configuration',
    'php-settings.defaultValue' => 'Par défaut',
    'php-settings.predefinedValue' => 'Sélectionner la valeur',
    'php-settings.customValue' => 'Entrer une valeur personnalisée',
    'php-settings.phpSettingDescription_memory_limit' => 'Volume maximum de mémoire en octets qu\'un script peut allouer.',
    'php-settings.phpSettingDescription_max_execution_time' => 'La durée maximum en secondes pendant laquelle un script peut fonctionner avant d\'être terminé.',
    'php-settings.phpSettingDescription_max_input_time' => 'La durée maximum en secondes pendant laquelle un script peut analyser les données saisies.',
    'php-settings.phpSettingDescription_post_max_size' => 'Volume maximum en octets des données qui peuvent être postées avec la méthode POST. En général, il doit être supérieur à upload_max_filesize et inférieur à memory_limit.',
    'php-settings.phpSettingDescription_upload_max_filesize' => 'Volume maximum en octets d\'un fichier envoyé.',
    'php-settings.phpSettingDescription_safe_mode' => 'Le mode de sécurité PHP place un certain nombre de restrictions sur l\'exécution de scripts, essentiellement pour des raisons de sécurité.',
    'php-settings.phpSettingDescription_safe_mode_include_dir' => 'Des scripts PHP peuvent accéder aux fichiers dans le répertoire spécifié quand safe_mode est activé.Le répertoire doit également être dans include_path.',
    'php-settings.phpSettingDescription_safe_mode_exec_dir' => 'Des scripts PHP peuvent exécuter les programmes dans le répertoire spécifié quand safe_mode est activé.',
    'php-settings.phpSettingDescription_include_path' => 'La liste des répertoires où les scripts recherchent les fichiers (similaires à la variable PATH du système). Pour séparer les répertoires, utilisez les deux-points (:) dans Linux et un point-virgule (;) dans Windows.',
    'php-settings.phpSettingDescription_sessionsave_path' => 'Répertoire pour stocker les fichiers de sessions PHP.',
    'php-settings.phpSettingDescription_mailforce_extra_parameters' => 'Autres paramètres supplémentaires pour la fonction mail().',
    'php-settings.phpSettingDescription_register_globals' => 'Enregistre les contenus des variables EGPCS (Environment, GET, POST, Cookie, Server) en tant que variables globales.',
    'php-settings.phpSettingDescription_open_basedir' => 'Les fichiers indiqués dans les répertoires peuvent être accessibles par les scripts PHP. Pour séparer les répertoires, utilisez les deux-points (:) dans Linux et un point-virgule (;) dans Windows.',
    'php-settings.phpSettingDescription_error_reporting' => 'Le niveau de reporting de l\'erreur.',
    'php-settings.phpSettingDescription_display_errors' => 'Déterminez si les erreurs doivent être affichées en tant qu\'éléments du résultat.',
    'php-settings.phpSettingDescription_log_errors' => 'Autorisez la journalisation des erreurs PHP.',
    'php-settings.phpSettingDescription_allow_url_fopen' => 'Autorise les fonctions du fichier PHP à récupérer les données des emplacements distants via FTP ou HTTP.',
    'php-settings.phpSettingDescription_file_uploads' => 'Autorise l\'envoi des fichiers via HTTP.',
    'php-settings.phpSettingDescription_short_open_tag' => 'Autorise la forme abrégée ( ) de la balise ouvrante de PHP.',
    'php-settings.phpSettingDescription_magic_quotes_gpc' => 'Configure le statut magic_quotes pour les opérations GPC (Get/Post/Cookie). Lorsque magic_quotes est activé, tous les caractères spéciaux \' (guillemet simple), " (guillemet double),  \\ (backslash) et les caractères spéciaux NUL sont automatiquement échappés avec un backslash.',
    'php-settings.phpSettingDescription_disable_functions' => 'Cette directive vous permet de désactiver certaines fonctions. Elle prend une liste de fonctions séparées par des virgules.',
    'php-settings.phpSupport' => 'Prise en charge de PHP',
    'php-settings.phpRunAs' => 'exécuter PHP comme',
    'php-settings.phpVersion' => 'Version de PHP',
    'php-settings.phpHandlerOutdated' => '(Obsolète)',
    'php-settings.phpHandlerDeprecated' => '(Dépréciée)',
    'php-settings.phpServedByApache' => 'servi(e) par Apache',
    'php-settings.phpServedByNginx' => 'servi(e) par Nginx',
    'php-settings.phpSettingsPhpVersion' => 'Votre version de PHP : %%version%%.',
    'php-settings.phpSettingsPhpDisabled' => 'PHP est désactivé.',
    'php-settings.phpHandlerTypeHint' => 'Ci-dessous, vous trouverez des détails sur la configuration PHP du site Web. Vous pouvez modifier la configuration PHP si l\'hébergeur vous accorde les droits correspondants.',
    'php-settings.fpmDedicatedHandlerHint' => 'L\'utilisation de ce gestionnaire augmente la stabilité d\'un site Web, mais augmente également la consommation de la mémoire.',
    'php-settings.phpHandlerChangeHint' => 'Vous avez changé les paramètres du gestionnaire PHP. Si vous sauvegardez ces modifications, les scripts PHP sur votre site Web risquent de s\'arrêter pendant %%interval%% secondes en raison de la configuration de votre serveur.',
    'php-settings.phpHandlerOutdatedHint' => 'Pour vérifier si la nouvelle version de PHP est disponible, %%link%%, puis regardez la catégorie "Hébergement Web" des composants du produit.',
    'php-settings.phpHandlerOutdatedHintLink' => 'ouvrez Plesk Installer',
    'php-settings.phpHandlerTypeHelpLink' => 'Découvrir comment choisir les paramètres PHP les plus appropriés',
    'php-settings.phpHandlerTypeNotAvailableHint' => 'Impossible d\'activer la prise en charge de PHP, car la configuration d\'hébergement actuelle n\'inclut aucune version PHP disponible pour ce domaine.',
    'php-settings.phpHandlersNotAvailableHint' => 'Impossible d\'activer la prise en charge PHP, car la configuration Plesk actuelle n\'inclut aucune version PHP disponible.',
    'php-settings.phpHandlerTypeNotAvailableHelpLink' => 'Découvrez comment activer d\'autres versions de PHP.',
    'php-settings.phpSupportEditable' => '(version de PHP : %%version%% ; exécuter PHP en tant que : %%handler%%) %%link%%',
    'php-settings.phpSupportReadonly' => '(version : %%version%% ; gestionnaire : %%handler%%) %%link%%',
    'php-settings.phpSupportReadonlyNotRegistered' => '(non enregistré) %%link%%',
    'php-settings.showPhpInfo' => 'Voir la page phpinfo()',
    'php-settings.phpSettingsFormError' => 'Impossible de récupérer les paramètres PHP, car les données requises sont absentes.',
    'php-settings.phpSettingsFormBrokenPhpHandler' => 'Impossible de récupérer les paramètres PHP, car cette version de PHP n\'est pas installée. Pour poursuivre, installez la version de PHP sélectionnée ou sélectionnez une autre version pour votre domaine.',
    'php-settings.showPhpInfoTitle' => 'Voir phpinfo()',
    'php-settings.showPhpInfoDescription' => 'Certains de vos paramètres PHP ont été modifiés mais les modifications n\'ont pas encore été enregistrées. Pour afficher les nouvelles valeurs sur la page phpinfo(), appliquez d\'abord les modifications. Sinon, vous verrez les valeurs actuelles.',
    'php-settings.showPhpInfoButton' => 'Voir phpinfo()',
    'php-settings.onState' => 'Activé',
    'php-settings.offState' => 'Désactivé',

    'pmm.agent.sync.check' => 'L\'Agent de transfert & de migration vérifie les mises à jour.',
    'pmm.agent.sync.updating' => 'Synchronisation et téléchargement de l\'Agent de transfert & de migration',
    'pmm.agent.sync.done' => 'L\'Agent de transfert & de migration a bien été synchronisé.',
    'pmm.agent.sync.downloadLink' => 'Cliquez pour télécharger le fichier de l\'Agent de transfert & de migration qui doit être installé sur l\'hôte source avant le début de la migration.',
    'pmm.agent.sync.error' => 'L\'Agent de transfert & de migration n\'a pas réussi à obtenir les mises à jour. Veuillez réessayer ultérieurement.',

    'restore-password.title' => 'Modifier votre mot de passe',
    'restore-password.passwordLabel' => 'Nouveau mot de passe',
    'restore-password.buttonRestore' => 'Enregistrer',
    'restore-password.buttonCancel' => 'Annuler',
    'restore-password.isEmpty' => 'Ce champ obligatoire est vide. Vous devez indiquer une valeur.',
    'restore-password.errorInvalidSecret' => 'Code secret incorrect',
    'restore-password.errorNotFoundSecret' => 'Demander un nouveau code secret',
    'restore-password.restoreSuccess' => 'Votre mot de passe a été mis à jour. Utilisez le nouveau mot de passe pour vous connecter à Plesk ou votre adresse mail.',

    'scheduler.settings.schedulerNotification' => 'Notification du planificateur',
    'scheduler.settings.notificationOff' => "Désactivé",
    'scheduler.settings.notificationDefault' => "Envoyer à l'adresse mail par défaut (%%email%%)",
    'scheduler.settings.notificationCustom' => "Envoyer à l'adresse mail que j'indique",
    'scheduler.settings.crontabSecureShell' => 'Shell crontab',
    'scheduler.settings.schedulerTimezoneSelector' => 'Afficher la planification des tâches à l\'aide du fuseau horaire',
    'scheduler.settings.schedulerTimezoneSelectorDefaultWithLabel' => 'Utiliser le fuseau horaire par défaut (%%timezone%%)',
    'scheduler.settings.schedulerTimezoneSelectorDefault' => 'Utiliser le fuseau horaire par défaut',
    'scheduler.settings.schedulerTimezoneSelectorCustom' => 'Utiliser le fuseau horaire que j\'indique',

    'scheduler.task.active' => 'Actif',
    'scheduler.task.subscription' => 'Abonnement',
    'scheduler.task.subscription_powerUser' => 'Espace Web',
    'scheduler.task.type' => 'Type de tâche',
    'scheduler.task.typeCommand' => 'Exécuter une commande',
    'scheduler.task.typeUrl' => 'Récupérer une URL',
    'scheduler.task.typeScript' => 'Exécuter un script PHP',
    'scheduler.task.command' => 'Commande',
    'scheduler.task.arguments' => 'avec arguments',
    'scheduler.task.url' => 'URL',
    'scheduler.task.urlDescription' => 'Indiquez une URL absolue, par exemple http://exemple.com. Si le code du statut de réponse est 2xx ou 3xx, la tâche est considérée comme bien exécutée.',
    'scheduler.task.script' => 'Chemin d\'accès du script',
    'scheduler.task.scriptRelativePathDescription' => 'Exemple : %%path%%',
    'scheduler.task.scriptAbsolutePathDescription' => 'Indiquez le chemin d\'accès complet au script. Exemple : %%path%%',
    'scheduler.task.scriptPhpVersion' => 'Utiliser la version de PHP',
    'scheduler.task.scriptPathPopupTitle' => 'Chemin d\'accès du script',
    'scheduler.task.run' => 'Exécuter',
    'scheduler.task.on' => 'le',
    'scheduler.task.at' => 'à',
    'scheduler.task.sysUser' => 'Utilisateur système',
    'scheduler.task.hourly' => 'Toutes les heures',
    'scheduler.task.daily' => 'Tous les jours',
    'scheduler.task.weekly' => 'Toutes les semaines',
    'scheduler.task.monthly' => 'Tous les mois',
    'scheduler.task.yearly' => 'Tous les ans',
    'scheduler.task.cronStyle' => 'Style Cron',
    'scheduler.task.cronStyleError' => 'Syntaxe crontab non valide.',
    'scheduler.task.cronStyleErrorWin' => 'Les barres obliques (/) et les tirets (-) ne sont pas autorisés.',
    'scheduler.task.cronStyleHint' => 'Utilisez le format UNIX crontab "minute heure jour-du-mois mois jour-de-la-semaine". Par exemple "0 22 * * 1-5". Plesk utilisera le fuseau horaire par défaut du système pour exécuter la tâche.',
    'scheduler.task.cronStyleWinHint' => 'Utilisez le format "minute heure jour-du-mois mois jour-de-la-semaine", par exemple "0 22 * * 6,7". Plesk utilisera le fuseau horaire par défaut du système pour exécuter la tâche.',
    'scheduler.task.notify' => 'Notifier',
    'scheduler.task.notifyIgnore' => 'Ne pas notifier',
    'scheduler.task.notifyErrors' => 'Erreurs uniquement',
    'scheduler.task.notifyAlways' => 'Toujours',
    'scheduler.task.notifyErrorsHint' => 'Les notifications contiennent uniquement le flux d\'erreur standard de la commande. Si le flux est vide, aucune notification n\'est envoyée.',
    'scheduler.task.notifyErrorsHintWin' => 'Les notifications contiennent le résultat de la commande et sont envoyées uniquement si le code de sortie est différent de zéro.',
    'scheduler.task.notifyAlwaysHint' => 'Les notifications contiennent le résultat de la commande. Si le résultat est vide, aucune notification n\'est envoyée.',
    'scheduler.task.notifyAlwaysHintWin' => 'Les notifications contiennent le résultat de la commande et sont envoyées quel que soit le code de sortie de la commande.',
    'scheduler.task.emailType' => 'Envoyer les notifications à',
    'scheduler.task.emailTypeDefault' => 'Utilisateur système par défaut (%%email%%)',
    'scheduler.task.emailTypeOwner' => 'Propriétaire de l\'abonnement (%%email%%)',
    'scheduler.task.emailTypeOwnerAdmin' => 'Administrateur (%%email%%)',
    'scheduler.task.emailTypeCustom' => 'Autres utilisateurs',
    'scheduler.task.emailTypeCustomDescription' => 'Vous pouvez indiquer plusieurs adresses séparées par des virgules.',
    'scheduler.task.minute' => 'Minute',
    'scheduler.task.shortMinute' => 'min.',
    'scheduler.task.dayOfMonth' => 'jour',
    'scheduler.task.description' => 'Description',
    'scheduler.task.scheduleTimezoneHint' => 'Le fuseau horaire d\'exécution de la tâche est %%timezone%%',
    'scheduler.task.runTaskNow' => 'Exécuter maintenant',
    'scheduler.task.runningTask' => 'Exécution de la tâche "%%task%%"...',

    'server-settings.submitDone' => "Les paramètres du serveur ont été changés.",
    'server-settings.systemSettings' => "Paramètres du système",
    'server-settings.fullHostName' => "Nom d'hôte complet",
    'server-settings.trafficStatisticsPeriod' => "Conserver les statistiques du trafic et du Web pendant",
    'server-settings.trafficStatisticsPeriodUnit' => "Mois",
    'server-settings.diskSpaceUsageCalculation' => "À inclure dans le calcul de l'utilisation de l'espace disque",
    'server-settings.includeLogs' => "Fichiers journaux et rapports statistiques",
    'server-settings.includeMysqlDatabases' => "bases de données MySQL",
    'server-settings.includeMssqlDatabases' => "bases de données Microsoft SQL",
    'server-settings.includeDatabases' => "bases de données",
    'server-settings.includeRemoteDatabases' => "bases de données distantes",
    'server-settings.includeMailboxes' => "boîtes mail",
    'server-settings.includeMailLists' => "listes de diffusion",
    'server-settings.includeDomainDumps' => "Fichiers de sauvegarde de domaines",
    'server-settings.includeAdminDumps' => "Fichiers de sauvegarde créés par l'administrateur",
    'server-settings.calculatingDiskSpaceUsage' => "À compter dans le calcul de l'utilisation de l'espace disque",
    'server-settings.typeByte' => "Taille du fichier",
    'server-settings.typeBlock' => "Volume d'espace disque utilisé",
    'server-settings.trafficCalculation' => "À inclure dans le calcul du trafic",
    'server-settings.inboundAndOutbound' => "Trafic entrant et sortant",
    'server-settings.onlyInbound' => "Seulement le trafic entrant",
    'server-settings.onlyOutbound' => "Seulement le trafic sortant",
    'server-settings.forbidCreateDnsSubZone' => "Interdire aux utilisateurs de créer des sous-zones DNS dans les superzones DNS d'autres utilisateurs",
    'server-settings.webDeployIncludePassword' => "Inclure le mot de passe de l'utilisateur dans le fichier avec les paramètres de publication Web Deploy",
    'server-settings.forbidSysUserRename' => "Autoriser les clients à modifier le nom de leurs utilisateurs système",
    'server-settings.alwaysAllowSysUserRename' => "toujours",
    'server-settings.ifPermissionIsGrantedAllowSysUserRename' => "uniquement si le droit Gestion des paramètres d'hébergement est accordé",
    'server-settings.neverAllowSysUserRename' => "Jamais",
    'server-settings.forbidSubscriptionRename' => "Interdire aux clients et aux revendeurs de modifier le nom de leur domaine principal",
    'server-settings.preferredDomain' => "Domaine préféré pour les sites Web",
    'server-settings.preferredDomainNone' => "Aucun(e)",
    'server-settings.preferredDomainToLanding' => "domain.tld",
    'server-settings.preferredDomainToWww' => "www.domain.tld",
    'server-settings.ipLogging' => "Consignation d'adresses IP",
    'server-settings.disableIpLogging' => "Désactiver la consignation d'adresses IP dans les journaux IIS, FTP et de la messagerie",
    'server-settings.disableIpLoggingDescription' => "Si cette case est cochée, IIS et MailEnable ne consignent plus les adresses IP dans les fichiers journaux.",
    'server-settings.anonymizeIps' => "Rendre les adresses IP anonymes",
    'server-settings.logrotateAnonymizeIps' => "Rendre les adresses IP anonymes pendant la rotation des journaux et la récupération des statistiques Web",
    'server-settings.logrotateAnonymizeIpsDescription' => 'Le script de post-rotation remplace le dernier octet de l\'adresse IPv4 dans les fichiers journaux par un "0" avant l\'archivage. Dans les adresses IPv6, le script remplace la dernière section de l\'adresse (deux octets après le dernier deux points) par "0000" (forme complète) ou par "0" (forme courte).',
    'server-settings.logrotate' => "Rotation des journaux",
    'server-settings.logrotateForce' => "Forcer la rotation des journaux quotidienne pour tous les domaines",
    'server-settings.allowToStoreLogs' => "Autoriser le stockage des journaux du site Web pendant",
    'server-settings.logrotatePeriod' => "jours",
    'server-settings.configureUpdatePolicy' => "Configurer la politique de mise à jour",

    'service-plan.mail.outgoing-messages.outgoingMessagesDefault' => 'Valeur par défaut pour tout le serveur (%%default%% messages par heure)',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificPlan' => 'Valeur personnalisée pour le pack',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificSubscription' => 'Valeur personnalisée pour l\'abonnement',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificHint' => 'messages',
    'service-plan.mail.outgoing-messages.mboxOutgoingMessages' => 'Messages sortants d\'une boîte mail (par heure)',
    'service-plan.mail.outgoing-messages.domainOutgoingMessages' => 'Messages sortants d\'un domaine (par heure)',
    'service-plan.mail.outgoing-messages.subscriptionOutgoingMessages' => 'Messages sortants pour un abonnement (par heure)',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimit' => 'Pourcentage de messages supérieur à la limite par heure devant être envoyé pendant l\'heure suivante',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimitDescription' => 'Si la limite des mails sortants par heure d\'une boîte mail est de 100 et le pourcentage de 10 %, l\'utilisateur est autorisé à envoyer 110 messages par heure. 100 messages sont envoyés au cours d\'une heure et 10 sont placés dans la file d\'attente pour être envoyés pendant l\'heure suivante.',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmail' => 'Politique d\'utilisation de Sendmail',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailDefault' => 'Paramètres par défaut pour tout le serveur (Sendmail autorisé)',
    'service-plan.mail.outgoing-messages.outgoingMessagesNotEnableSendmailDefault' => 'Paramètres par défaut pour tout le serveur (Sendmail non autorisé)',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomPlan' => 'Paramètres personnalisés du pack de services',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomSubscription' => 'Paramètres personnalisés de l\'abonnement',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomLabel' => 'Autoriser l\'utilisation de Sendmail pour les scripts et les utilisateurs de cet abonnement',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomHint' => 'Les scripts et les utilisateurs pourront envoyer des mails (au nom de l\'utilisateur système de l\'abonnement) à l\'aide de Sendmail, même si les limites d\'une boîte mail et d\'un domaine sont dépassées. Le nombre maximum de mails qui peuvent être envoyés via Sendmail sera défini par la limite d\'un abonnement complet.',

    'setup.hint' => 'Bienvenue dans Plesk, le panneau de contrôle qui vous aide à gérer votre serveur. Plesk fournit un environnement prêt à coder ainsi qu\'une suite d\'extensions puissantes pour vous aider à développer vos sites Web et applications. Terminez le processus de configuration pour commencer à utiliser Plesk (environ une minute).',
    'setup.contactInfoSection' => 'Informations sur le contact',
    'setup.contactInfoSectionHint' => 'Saisissez votre nom et votre adresse mail pour vous identifier en tant que propriétaire du serveur et recevoir des notifications importantes concernant le serveur. Si vous êtes l\'administrateur d\'un serveur d\'entreprise, ne saisissez pas votre nom ou votre adresse mail personnelle. Utilisez votre titre et votre adresse professionnelle à la place, afin d\'éviter tout risque de violation de la loi sur la protection des données.',
    'setup.contactName' => 'Votre nom de contact',
    'setup.emptyContactName' => 'Veuillez indiquer un nom de contact.',
    'setup.contactNameTooLong' => 'Le nom du contact est trop long (maximum %max% caractères sont autorisés).',
    'setup.email' => 'Adresse mail',
    'setup.emptyEmail' => 'Veuillez indiquer une adresse mail.',
    'setup.passwordSection' => 'Mot de passe',
    'setup.passwordSectionHint' => 'La prochaine fois que vous vous connecterez à Plesk, utilisez le nom d\'utilisateur \'admin\' et le mot de passe saisi ci-dessous.',
    'setup.password' => 'Mot de passe',
    'setup.licenseSection' => 'Licence',
    'setup.licenseSectionHint' => 'Vous devez installer une licence pour commencer à utiliser Plesk.',
    'setup.licenseType' => 'Sélectionner votre type de licence',
    'setup.licenseTypePaid' => 'Continuer avec une licence payante',
    'setup.onlineStoreLink' => 'Boutique en ligne',
    'setup.licenseTypeTrial' => 'Continuer avec une licence de test complète',
    'setup.activationCodeHint' => 'Si vous avez déjà acheté une licence Plesk, collez ici le code d\'activation que vous avez reçu. Si vous n\'avez pas encore acheté de licence Plesk, achetez-en une nouvelle dans notre %%onlineStoreLink%%.',
    'setup.privacyPolicyLink' => 'Politique de confidentialité de Plesk',
    'setup.trialLicenseAgreement' => 'Pour émettre une licence de test, Plesk International GmbH utilise et traite les informations fournies dans ses systèmes internes, conformément à la %%privacyPolicyLink%%.',
    'setup.eulaAgreementLabel' => 'Je confirme avoir lu et accepter le %%link%%',
    'setup.eula' => 'Contrat de Licence Utilisateur final',
    'setup.invalidEulaAgreementValue' => 'Vous devez accepter le Contrat de Licence Utilisateur final.',
    'setup.sendButton' => 'Entrer dans Plesk >>',
    'setup.resetPasswordOnFirstLogin' => 'Réinitialiser le mot de passe de l\'administrateur lors de la prochaine connexion',

    'ssl-certificate.add.name' => 'Nom du certificat',
    'ssl-certificate.add.longName' => 'Le nom du certificat indiqué est trop long (%max% caractères maximum autorisés).',
    'ssl-certificate.add.certificateNameUsed' => 'Un certificat avec le nom %%name%% existe déjà dans le référentiel.',
    'ssl-certificate.add.certificateAdded' => 'Le certificat SSL/TLS a été ajouté. Pour que cela fonctionne, assignez le certificat afin de sécuriser un domaine, une adresse mail ou une messagerie Web.',
    'ssl-certificate.add.certificateUpdated' => 'Le certificat SSL/TLS a bien été mis à jour.',
    'ssl-certificate.add.settings' => 'Paramètres',
    'ssl-certificate.add.settingsHint' => 'Utilisez ce formulaire pour générer une demande de certificat, acheter un certificat chez votre fournisseur ou générer un certificat auto-signé.',
    'ssl-certificate.add.settingsHint2' => 'Une demande est un fichier CSR qui contient les informations sur votre domaine que vous avez indiquées dans le formulaire. Vous pouvez envoyer votre demande à l\'autorité de certification afin qu\'elle émette un certificat pour vous. Vous l\'enverrez ensuite à l\'aide de l\'un des formulaires d\'envoi ci-dessous.',
    'ssl-certificate.add.settingsHint3' => 'Un certificat auto-signé est un certificat d\'identité signé par son propre créateur. Si vous utilisez ce type de certificat, cela signifie que vous vérifiez vous-même l\'identité de vos sites. Même si les certificats auto-signés permettent d\'utiliser SSL/TLS, ils sont moins réputés et sont considérés comme moins sűrs.',
    'ssl-certificate.add.bits' => 'Bits',
    'ssl-certificate.add.country' => 'Pays',
    'ssl-certificate.add.state' => 'État/Province/Région',
    'ssl-certificate.add.longState' => 'Le nom de la province / de l\'état / de la région indiqué est trop long.',
    'ssl-certificate.add.city' => 'Emplacement (ville)',
    'ssl-certificate.add.longCity' => 'Le nom de la ville indiqué est trop long.',
    'ssl-certificate.add.shortCity' => 'Le nom de la ville indiqué est trop court.',
    'ssl-certificate.add.companyName' => 'Raison sociale',
    'ssl-certificate.add.longCompanyName' => 'La raison sociale indiquée est trop longue.',
    'ssl-certificate.add.companyUnitName' => 'Département de l\'organisation ou nom de la division',
    'ssl-certificate.add.longCompanyUnitName' => 'Le nom du département de l\'organisation indiqué est trop long (%max% caractères maximum autorisés).',
    'ssl-certificate.add.domainName' => 'Nom de domaine',
    'ssl-certificate.add.email' => 'Adresse mail',
    'ssl-certificate.add.request' => 'Demander',
    'ssl-certificate.add.buyCertificate' => 'Acheter un certificat SSL/TLS',
    'ssl-certificate.add.selfSigned' => 'Auto-signer',
    'ssl-certificate.add.invalidCertificateParams' => 'Certains champs sont vides ou contiennent des valeurs non valides. Les valeurs ne doivent pas dépasser 64 caractères. Si vous utilisez un nom de domaine international, vérifiez qu\'aucune partie individuelle du nom de domaine entre les points ne dépasse 63 caractères une fois convertie au format ASCII. Vérifiez les champs :',
    'ssl-certificate.add.unableCreateCsr' => 'Impossible de créer une demande CSR : %%error%%',
    'ssl-certificate.add.unableCreateSelfSigned' => 'Impossible de créer un certificat auto-signé : %%error%%',
    'ssl-certificate.add.unableCreateUpload' => 'Impossible de définir les données du certificat : %%error%%.',
    'ssl-certificate.add.unableSaveCertificate' => 'Impossible de sauvegarder le certificat dans la base de données : %%error%%',
    'ssl-certificate.add.uploadFiles' => 'Envoyer les fichiers du certificat',
    'ssl-certificate.add.uploadFilesHint' => 'Utilisez ce formulaire pour envoyer les composants d\'un certificat (*.key, *.crt, *-ca.crt) que vous possédez en tant que fichiers constitutifs.',
    'ssl-certificate.add.csr' => 'CSR',
    'ssl-certificate.add.privateKey' => "Clé privée (*.key)",
    'ssl-certificate.add.certificate' => "Certificat (*.crt)",
    'ssl-certificate.add.caCertificate' => "Certificat CA (*-ca.crt)",
    'ssl-certificate.add.sendFiles' => "Charger le certificat",
    'ssl-certificate.add.fileNotUploaded' => 'Impossible d\'envoyer le fichier du certificat : %%name%%.',
    'ssl-certificate.add.unableSetPrivateKey' => 'Impossible de définir la clé privée : %%error%%',
    'ssl-certificate.add.unableSetCertificate' => 'Impossible de définir le certificat : %%error%%',
    'ssl-certificate.add.unableSetCaCertificate' => 'Impossible de définir le certificat CA : %%error%%',
    'ssl-certificate.add.unableCheckCaCertificate' => 'Impossible de vérifier si le certificat CA signe le certificat : %%error%%.',
    'ssl-certificate.add.removeCaCertificate' => 'Supprimer',
    'ssl-certificate.add.removeCaCertificateConfirmation' => 'Voulez-vous supprimer le certificat CA ?',
    'ssl-certificate.add.unableRemoveCaCertificate' => 'Impossible d\'effacer le certificat CA : %%error%%',
    'ssl-certificate.add.caCertificateRemoved' => 'Le composant CA du certificat a été supprimé.',
    'ssl-certificate.add.rename' => 'Renommer',
    'ssl-certificate.add.unableRenameCertificate' => 'Impossible de renommer le certificat : %%error%%',
    'ssl-certificate.add.certificateRenamed' => 'Le certificat a été renommé : %%name%%.',
    'ssl-certificate.add.uploadText' => "Envoyer le certificat en mode texte",
    'ssl-certificate.add.uploadTextHint' => 'Utilisez ce formulaire pour envoyer les composants du certificat en tant que texte. Copiez les contenus d\'un fichier et collez-les dans le champ correspondant.',
    'ssl-certificate.add.sendText' => "Charger le certificat",
    'ssl-certificate.add.componentIsMissing' => 'Le composant est absent.',

    'ssl-certificate.find-private-key.findPrivateKey' => 'Envoyer le certificat ici',
    'ssl-certificate.find-private-key.formGeneralHint' => 'Si vous créez une demande de signature de certificat sur ce serveur et si vous recevez le fichier du certificat, chargez-le sur cette page. Si vous voulez charger un certificat et une paire de clés privées générée sur un autre serveur ou générer un certificat auto-signé, cliquez sur <b>Ajouter un certificat SSL/TLS</b>.',
    'ssl-certificate.find-private-key.formCertificateAddingHint' => 'Après ajout d\'un certificat SSL/TLS à un domaine, vous devez activer la prise en charge SSL/TLS et sélectionner ce certificat dans les paramètres d\'hébergement du site Web : <b>Sites Web & Domaines</b>> <b>Paramètres d\'hébergement</b> de ce domaine> <b>Sécurité</b>.',
    'ssl-certificate.find-private-key.uploadCertificate' => 'Certificat (*.crt)',
    'ssl-certificate.find-private-key.sendFile' => 'Charger le certificat',
    'ssl-certificate.find-private-key.fileNotUploaded' => 'Impossible d\'envoyer le fichier du certificat.',
    'ssl-certificate.find-private-key.invalidCertificateFormat' => 'Format du certificat non valide.',
    'ssl-certificate.find-private-key.unableFindPrivateKey' => 'Impossible de trouver la clé privée adéquate pour le certificat.',

    'ssl-certificate.secure.certificate' => 'Sélectionner le certificat',
    'ssl-certificate.secure.serverPool' => 'Pool de serveurs',
    'ssl-certificate.secure.certificateName' => '%%certificateName%% (%%repositoryName%%)',

    'system-time.date' => "Date",
    'system-time.dateAndTime' => "Date et heure",
    'system-time.daylight' => "Régler l'heure automatiquement pour les passages à l'heure d'été / d'hiver",
    'system-time.dayMonthYear' => "Jour-Mois-Année",
    'system-time.domainNameOrIp' => "Nom de domaine ou IP",
    'system-time.hoursMinutesSeconds' => "Heures:Minutes:Secondes",
    'system-time.networkTime' => "Heure réseau",
    'system-time.submitDone' => "Les paramètres de temps du système ont été modifiés.",
    'system-time.synchronizedSystemTime' => "Synchroniser l'heure du système",
    'system-time.title' => "Date et heure du système",
    'system-time.timezone' => "Fuseau horaire",
    'system-time.time' => "Heure",
    'system-time.updateSystemTime' => "Actualiser l'heure du système",
    'system-time.yourTimezone' => "Votre fuseau horaire",

    'web-app-firewall.pageHint' => 'Le pare-feu applicatif protège les applications Web contre les attaques en vérifiant et en filtrant les requêtes HTTP entrantes en fonction de règles définies par les utilisateurs.',
    'web-app-firewall.webSitePageHint' => 'Sur cette page, vous pouvez configurer le pare-feu applicatif (ModSecurity).',
    'web-app-firewall.ruleEngine' => 'Mode du pare-feu applicatif',
    'web-app-firewall.ruleEngineOn' => 'Activé',
    'web-app-firewall.ruleEngineOnDescription' => 'Toutes les requêtes HTTP entrantes et les réponses associées sont vérifiées selon un jeu de règles. Si la vérification réussit, la requête HTTP est transmise au contenu du site Web. Si la vérification échoue, l\'événement est enregistré dans le journal, une notification est envoyée et la réponse HTTP est fournie avec un code d\'erreur.',
    'web-app-firewall.ruleEngineOff' => 'Désactivé',
    'web-app-firewall.ruleEngineOffDescription' => 'Les requêtes HTTP et les réponses associées ne sont pas vérifiées.',
    'web-app-firewall.ruleEngineDetectionOnly' => 'Détection uniquement',
    'web-app-firewall.ruleEngineDetectionOnlyDescription' => 'Toutes les requêtes HTTP entrantes et les réponses associées sont vérifiées selon un jeu de règles. Si la vérification réussit, la requête HTTP est transmise au contenu du site Web. Si la vérification échoue, l\'événement est enregistré dans le journal et ModSecurity ne procède à aucune autre action. D\'autres services (par exemple, Fail2ban) peuvent exécuter leurs propres actions suite à une requête HTTP qui a échoué à la vérification.',
    'web-app-firewall.ruleSetsSection' => 'Jeux de règles',
    'web-app-firewall.ruleSetsSectionHint' => 'Sélectionnez le jeu de règles (pack de fichiers contenant des règles de sécurité) à utiliser pour vérifier les requêtes HTTP entrantes.',
    'web-app-firewall.ruleSet' => 'Jeu de règles',
    'web-app-firewall.ruleSetCrs' => 'OWASP (gratuit)',
    'web-app-firewall.ruleSetCrsDescription' => 'Le jeu de règles OWASP ModSecurity Core est très restrictif et peut bloquer certaines fonctions (par exemple le partage de fichiers ou la messagerie Web) et fonctionnalités d\'applications Web (par exemple les plug-ins WordPress).',
    'web-app-firewall.ruleSetCrsConfirmTitle' => 'Voulez-vous appliquer les changements ?',
    'web-app-firewall.ruleSetCrsConfirmDescription' => 'Les règles OWASP peuvent être trop restrictives et par conséquent bloquer certaines fonctions comme le partage de fichiers, la messagerie Web et certaines applications Web.',
    'web-app-firewall.ruleSetTortix' => 'Atomic Standard (gratuit, possibilité de mise à niveau vers Atomic Advanced)',
    'web-app-firewall.ruleSetTortixDescription' => 'Version de démarrage des règles ModSecurity d\'Atomicorp. Elles offrent une protection basique et sont mises à jour mensuellement.',
    'web-app-firewall.ruleSetTortixHowTo' => 'Pour mettre à niveau ce jeu de règles vers Atomic Advanced :',
    'web-app-firewall.ruleSetTortixBuy' => 'Achetez %%linkPleskStore%% sur le site Web Plesk et %%linkDocumentation%%.',
    'web-app-firewall.ruleSetTortixLinkPleskStoreLabel' => 'Règles avancées ModSecurity d\'Atomicorp',
    'web-app-firewall.ruleSetTortixLinkDocumentationLabel' => 'installer la clé de licence additionnelle achetée',
    'web-app-firewall.ruleSetTortixSelect' => 'Sélectionner ce jeu de règles - son nom deviendra " Atomic Advanced (achat depuis Plesk) "',
    'web-app-firewall.ruleSetTortixPro' => 'Atomic Advanced (achat depuis Plesk)',
    'web-app-firewall.ruleSetTortixProDescription' => 'Les règles Advanced ModSecurity (Atomicorp) incluent les règles Atomic Standard plus des fonctionnalités avancées.',
    'web-app-firewall.ruleSetAtomic' => 'Atomic Advanced (achat depuis Atomicorp)',
    'web-app-firewall.ruleSetAtomicDescription' => 'Les règles Advanced ModSecurity (Atomicorp) incluent les règles Atomic Standard plus des fonctionnalités avancées.',
    'web-app-firewall.ruleSetAtomicInstall' => 'Passez sur un autre compte Atomicorp.',
    'web-app-firewall.ruleSetAtomicInstalled' => 'Le jeu de règles est activé.',
    'web-app-firewall.ruleSetAtomicHowTo' => 'Si vous disposez déjà d\'un compte Atomicorp avec le jeu de règles avancées payant Atomic (Atomic Advanced rules), saisissez vos identifiants ci-dessous afin de l\'activer.',
    'web-app-firewall.ruleSetAtomicSwitchHowTo' => 'Si vous disposez déjà d\'un compte Atomicorp avec le jeu de règles avancées payant Atomic (Atomic Advanced rules), saisissez vos identifiants ci-dessous afin de changer de compte.',
    'web-app-firewall.ruleSetAtomicLogin' => 'Nom d\'utilisateur',
    'web-app-firewall.ruleSetAtomicPassword' => 'Mot de passe',
    'web-app-firewall.ruleSetComodo' => 'Comodo (abonnement gratuit)',
    'web-app-firewall.ruleSetComodoDescription' => 'Règles ModSecurity gratuites (Comodo). Elles offrent une protection basique.',
    'web-app-firewall.ruleSetComodoInstall' => 'Passez sur un autre compte Comodo.',
    'web-app-firewall.ruleSetComodoInstalled' => 'Le jeu de règles est activé.',
    'web-app-firewall.ruleSetComodoHowTo' => 'Pour activer ce jeu de règles :',
    'web-app-firewall.ruleSetComodoSwitchHowTo' => 'Pour passer à un autre compte :',
    'web-app-firewall.ruleSetComodoRegister' => 'Inscrivez-vous sur le site Web Comodo.',
    'web-app-firewall.ruleSetComodoCredentials' => 'Entrez votre nom d\'utilisateur et mot de passe de ce site Web.',
    'web-app-firewall.ruleSetComodoLogin' => 'Nom d\'utilisateur',
    'web-app-firewall.ruleSetComodoPassword' => 'Mot de passe',
    'web-app-firewall.ruleSetComodoFree' => 'Comodo (gratuit)',
    'web-app-firewall.ruleSetComodoFreeDescription' => 'Règles ModSecurity gratuites (Comodo). Elles offrent une protection basique.',
    'web-app-firewall.ruleSetCustom' => 'Jeu de règles personnalisé',
    'web-app-firewall.ruleSetCustomDescription' => 'Cette section vous permet d\'envoyer un jeu de règles personnalisé pour le pare-feu applicatif. Formats pris en charge : zip, tar.gz, tgz, tar.bz2, conf.',
    'web-app-firewall.ruleSetCustomUpload' => 'Sélectionner un autre fichier',
    'web-app-firewall.ruleSetError' => 'Échec de l\'installation du jeu de règles ModSecurity : %%error%%',
    'web-app-firewall.ruleSetOWASPMissingError' => 'Jeu de règles OWASP absent. Réinstallez ModSecurity à l\'aide du Programme d\'installation de Plesk.',
    'web-app-firewall.ruleSetCustomMissingError' => 'Le jeu de règles personnalisé est absent. Réinstallez le jeu de règles.',
    'web-app-firewall.ruleSetAuthError' => 'Le nom d\'utilisateur ou le mot de passe n\'est pas valide.',
    'web-app-firewall.ruleSetInvalid' => 'Le jeu de règles sélectionné ne peut pas être exécuté sur %%webServer%%.',
    'web-app-firewall.ruleSetSelectedInvalid' => 'Le jeu de règles sélectionné ne peut pas être exécuté sur le serveur Web sélectionné.',
    'web-app-firewall.webServer' => 'Exécuter les règles sur',
    'web-app-firewall.webServerHint' => 'Sélectionnez la combinaison souhaitée de serveur Web et de version ModSecurity afin de voir les jeux de règles compatibles.',
    'web-app-firewall.webServerApache' => 'Apache (ModSecurity 2.9)',
    'web-app-firewall.webServerNginx' => 'Nginx (ModSecurity 3.0)',
    'web-app-firewall.webServerIis' => 'IIS (ModSecurity 2.9)',
    'web-app-firewall.nginxNotRunning' => 'Le service Reverse Proxy Server (nginx) est désactivé et ne peut pas être utilisé pour traiter les requêtes. Sélectionnez <a href="%%serverUrl%%">un autre serveur Web</a> ou activez le serveur proxy inverse sur la <a href="%%servicesUrl%%">page Gestion de services</a>.',
    'web-app-firewall.nginxIsIncompatible' => 'Lorsque vous sélectionnez une autre version de ModSecurity, certains paramètres risquent de ne plus être valides (par exemple, vous ne pouvez pas utiliser d\'expressions régulières pour désactiver des règles de sécurité avec ModSecurity 3). Assurez-vous que vos paramètres fonctionnent conformément à vos attentes après avoir appliqué les modifications. Vous pouvez aussi réinitialiser les paramètres qui désactivent les règles de sécurité et remettre les valeurs par défaut.',
    'web-app-firewall.nginxResetCustomizations' => 'Réinitialisez les paramètres du serveur et des domaines qui désactivent les règles de sécurité et retrouvez les valeurs par défaut.',
    'web-app-firewall.ruleSetUpdate' => 'Mettre à jour le jeu de règles',
    'web-app-firewall.ruleSetUpdateDaily' => 'Tous les jours',
    'web-app-firewall.ruleSetUpdateWeekly' => 'Toutes les semaines',
    'web-app-firewall.ruleSetUpdateMonthly' => 'Tous les mois',
    'web-app-firewall.currentRuleSet' => 'Jeu de règles',
    'web-app-firewall.currentRuleSetValue' => '%%ruleSet%% %%changeRuleSetLink%%',
    'web-app-firewall.currentRuleSetRunningOn' => '%%ruleSet%% en cours d\'exécution sur %%webServer%%',
    'web-app-firewall.changeRuleSetLink' => 'Modifier le jeu de règles',
    'web-app-firewall.ruleSetRollbackFailed' => 'Impossible d\'utiliser le jeu de règles ModSecurity actuel et de revenir à la version antérieure, car il contient des règles non valides.',
    'web-app-firewall.configurationSection' => 'Configuration',
    'web-app-firewall.configurationSectionHint' => 'Configurez le pare-feu des applications Web soit à l\'aide d\'un jeu de paramètres prédéfinis soit en utilisant vos directives ModSecurity personnalisées.',
    'web-app-firewall.configPreset' => 'Jeu de valeurs prédéfinies',
    'web-app-firewall.configPresetFast' => 'Rapide',
    'web-app-firewall.configPresetFastDescription' => 'L\'URI de la requête HTTP et des parties de l\'en-tête seront analysés.',
    'web-app-firewall.configPresetTradeOff' => 'Intermédiaire',
    'web-app-firewall.configPresetTradeOffDescription' => 'L\'URI de la requête HTTP, les en-têtes et les données POST de la requête seront analysés.',
    'web-app-firewall.configPresetThrough' => 'Complet',
    'web-app-firewall.configPresetThroughDescription' => 'L\'intégralité des en-têtes de la requête HTTP, les données POST de la requête et le contenu du corps de la réponse seront analysés.',
    'web-app-firewall.configCustom' => 'Directives personnalisées',
    'web-app-firewall.configCustomDescription' => "Saisissez une directive ModSecurity dans ce champ. Celle-ci écrasera les directives précédentes (jeux de règles, règles spécifiques, jeux de valeurs prédéfinies,etc.).\nPar exemple : SecDebugLogLevel 6",
    'web-app-firewall.configCustomError' => 'Configuration ModSecurity non valide : %%error%%',
    'web-app-firewall.configRollbackFailed' => 'Impossible d\'utiliser le fichier de configuration ModSecurity actuel et de revenir à la version précédente du fichier, car les deux contiennent une configuration non valide.',
    'web-app-firewall.rulesSection' => 'Désactiver les règles de sécurité',
    'web-app-firewall.rulesSectionHint' => 'Dans cette section, vous pouvez désactiver les règles de sécurité. Cela s\'avère pratique si une règle de sécurité est trop restrictive pour certains sites Web. Pour désactiver les règles de sécurité, indiquez les ID de la règle (par ex. 340003 ou 340005-340007), la balise (par ex. CVE-2011-4898) ou les expressions régulières utilisées dans les messages de la règle (par ex. XSS).',
    'web-app-firewall.rulesSectionNginxHint' => 'Dans cette section, vous pouvez désactiver les règles de sécurité. Cela s\'avère pratique si une règle de sécurité est trop restrictive pour certains sites Web. Pour désactiver les règles de sécurité, indiquez les ID de la règle (par ex. 340003 ou 340005-340007), la balise (par ex. CVE-2011-4898) ou créez des règles pour les messages (par exemple, User-Agent trouvé associé à analyse de sécurité).',
    'web-app-firewall.filterById' => 'ID de la règle de sécurité',
    'web-app-firewall.filterByIdInvalid' => 'Les valeurs suivantes ne sont pas valides : %%values%%. L\'ID de la règle doit comporter des chiffres ou une série de chiffres telle que 913100, 913105-913107.',
    'web-app-firewall.filterByIdInvalidRanges' => 'Les plages suivantes ne sont pas valides : %%ranges%%.',
    'web-app-firewall.filterByTag' => 'Balises',
    'web-app-firewall.filterByTagActive' => 'Activées :',
    'web-app-firewall.filterByTagDeactivated' => 'Désactivées :',
    'web-app-firewall.filterByTagInvalid' => 'Les valeurs sélectionnées ci-après ne sont pas valides : %%values%%.',
    'web-app-firewall.filterByRegexp' => 'Expressions régulières dans les messages de règles',
    'web-app-firewall.filterByRegexpInvalid' => 'Les valeurs suivantes ne sont pas valides : %%values%%. Elles ne doivent pas contenir les caractères \' et ".',
    'web-app-firewall.filterByRegexpNginx' => 'Messages de règles',
    'web-app-firewall.filterByRegexpNginxHint' => 'Seules les correspondances exactes sont prises en charge.',
    'web-app-firewall.filterByRegexpNginxInvalid' => 'Les valeurs suivantes ne sont pas valides : %%values%%. Le message de la règle doit comporter des lettres, des chiffres, des espaces ou les caractères -:;.,!?#&$%*()/.',
    'web-app-firewall.auditLogSection' => 'Journal d\'audit ModSecurity',
    'web-app-firewall.auditLogHint1' => 'Le fichier journal d\'audit ModSecurity est l\'information la plus utile dans le système. Tout événement détecté par ModSecurity génère une entrée dans le fichier journal d\'audit.',
    'web-app-firewall.auditLogHint2' => 'Lorsque vous passez le mode du pare-feu applicatif de On à Off ou à Détection uniquement, un site Web risque de cesser de fonctionner normalement. Dans ce cas, analysez le journal d\'audit ModSecurity pour découvrir ce qui se passe. Vous pouvez désactiver les règles de sécurité trop restrictives ou ajuster le site Web.',
    'web-app-firewall.auditLogHint3' => 'Afin de déterminer pourquoi une requête HTTP ne peut pas être terminée pour un site Web :',
    'web-app-firewall.auditLogPoint1' => 'Cliquez sur le lien vers le fichier journal ModSecurity ci-dessous. Ouvrez le journal d\'audit dans une nouvelle fenêtre de navigateur.',
    'web-app-firewall.auditLogPoint2' => 'Utilisez la recherche (Ctrl + F dans la plupart des navigateurs) pour trouver les événements du site Web (le nom de domaine) qui rencontre des problèmes. Par exemple : your_domain.tld. Le navigateur mettra en surbrillance des entrées comme HOST: your_domain.tld.',
    'web-app-firewall.auditLogPoint3' => '3 lignes au-dessus de l\'entrée en surbrillance, repérez : --eece5138-B--. Les 8 caractères entre les tirets (ici "eece5138") correspondent à l\'ID de l\'événement déclenché par la requête HTTP.',
    'web-app-firewall.auditLogPoint4' => 'Recherchez d\'autres entrées avec le même ID d\'événement. Repérez une entrée avec la lettre H après l\'ID de l\'événement (ici "eece5138-H--"). Cette entrée contient l\'ID et la description de la règle de sécurité déclenchée lors de la vérification de la requête HTTP. L\'ID de la règle de sécurité est un nombre entier commençant par 3, entre guillemets avec le préfixe "id" entre crochets. Par exemple : [id "340003"].',
    'web-app-firewall.auditLogPoint5' => 'Trouvez un ID de règle de sécurité dans l\'événement avec la sous-chaîne [id "3.',
    'web-app-firewall.auditLogPoint6' => 'Désactivez la règle de sécurité avec cet ID dans la section Règles de sécurité ci-dessous : saisissez l\'ID de la règle de sécurité (chiffres uniquement) dans le champ ID de la règle de sécurité et cliquez sur OK.',
    'web-app-firewall.auditLogViewLink' => 'Fichier journal ModSecurity',
    'web-app-firewall.auditLogListLink' => 'Archive des journaux',
    'web-app-firewall.errorLogSection' => 'Journal d\'erreurs',
    'web-app-firewall.errorLogSectionHint' => 'Lorsque vous passez le mode du pare-feu applicatif de On à Off ou à Détection uniquement, un site Web risque de cesser de fonctionner normalement. Dans ce cas, analysez le journal d\'erreurs pour découvrir ce qui se passe. Vous pouvez désactiver les règles de sécurité trop restrictives ou ajuster le site Web.',
    'web-app-firewall.errorLogViewLink' => 'Fichier du journal d\'erreurs',
    'web-app-firewall.notificationStateEnabled' => 'Les notifications Plesk concernant les mises à jour du jeu de règles sont activées. %%notificationLink%%',
    'web-app-firewall.notificationStateDisabled' => 'Les notifications Plesk concernant les mises à jour du jeu de règles sont désactivées. %%notificationLink%%',
    'web-app-firewall.notificationLink' => 'Gérer les notifications sur la page des notifications',
    'web-app-firewall.tradeoffAndThoroughModeWarning' => 'Les options "Tradeoff" ou "Thorough" risquent d\'entraîner des dysfonctionnements de WordPress ainsi que d\'autres problèmes indésirables, et ce en raison du <a href="https://github.com/SpiderLabs/ModSecurity/issues/562" target="_blank">problème ModSecurity</a> suivant.',
];