<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
$messages = [
    'access-network.subnetOrIpAddressLabel' => 'Subnet veya IP Adresi',
    'access-network.subnetOrIpAddressHint' => 'Örneğin 2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'admin.announcement-settings.announcementLegend' => 'Bültenler',
    'admin.announcement-settings.getConsentLoading' => 'Bültenler hakkında bilgi alınıyor...',
    'admin.announcement-settings.getConsentWarning' => 'Abonelik durumunuz alınamadı.',
    'admin.announcement-settings.sendAnnounceConsent' => 'Plesk\'ten bülten almak istiyorum. Bunlar güvenlikle ilgili, teknik ve genel ürün bilgileri içerebilir. Plesk\'in, bana doğrudan veya bir üçüncü kişi servisi üzerinden bülten göndermesi için, yürürlükteki geçerli veri koruma yasalarına uygun bir şekilde sınırlar arası işleme de dahil, kişiler verilerimi (e-posta) toplamasına, işlemesine ve kullanmasına rıza gösteriyor ve ona bu konuda yetki veriyorum. Bu onay kutusundaki işaretin kaldırılması, bu rızamı geçersiz kılar ve Plesk\'e, bana e-posta göndermeyi bırakmasını ve kişisel verilerimi sisteminden kaldırmasını söyler.',
    'admin.announcement-settings.sendAnnouncePersonalizedConsent' => 'Evet, özelleştirilmiş Plesk Haber Bültenimi almayı kabul ediyorum. Plesk International GmbH ve iştirakleri, verdiğim verileri saklayabilir ve bülteni %%privacyPolicy%% doğrultusunda sunmak amacıyla işleyebilir. Plesk, mesajlarını ve tekliflerini bana göre şekillendirmek için, kullanım ve davranış verileri gibi ek bilgileri de profil oluşturmak için kullanabilir. Postalama listesi aboneliğinden istediğim zaman ayrılabilirim.',
    'admin.announcement-settings.privacyPolicy' => 'Plesk Gizlilik İlkesi',
    'admin.announcement-settings.noConsent' => 'Plesk haber bülteni aboneliğimi kaldır.',
    'admin.announcement-settings.reportConsentError' => 'Plesk\'ten bilgi alma ayarlarınız kaydedilemedi: %%error%%.',
    'admin.announcement-settings.profileUpdateError' => 'Üzgünüz, profilinizi şu an güncelleyemiyoruz. Lütfen daha sonra yeniden deneyin.',
    'admin.announcement-settings.invalidConsentType' => "Bilinmeyen onay türü: '%%type%%'",
    'admin.announcement-settings.retry' => 'Yeniden dene',
    'admin.announcement-settings.consentGivenInfo' => 'Genel Plesk haber bülteninizi beğendiğinizi umarız. Size iyileştirilmiş, yani faydalı bilgiler ve ihtiyaçlarınıza uygun kullanışlı ipuçları içeren özelleştirilmiş bir alternatif sunabiliriz. Özelleştirilmiş Plesk haber bülteninizi almak için lütfen aşağıdaki ilk komutu seçin ve Tamam düğmesine tıklayın.',
    'admin.announcement-settings.consentNotGivenInfo' => 'Genel haber bültenimize abone olmadığınız anlaşıldı. Size daha iyi bir alternatif, yani faydalı bilgiler ve ihtiyaçlarınıza uygun ipuçları içeren özelleştirilmiş bir haber bülteni sunabiliriz.',

    'admin.personal-info.title' => 'Yönetici Profilini Düzenleme',
    'admin.personal-info.pleskSettingsSectionLegend' => 'Plesk Ayarları',
    'admin.personal-info.settingsSectionLegend' => 'Ayarlar',

    'admin-alias.login' => 'Kullanıcıadı',
    'admin-alias.password' => 'Şifre',
    'admin-alias.passwordConfirmation' => 'Şifreyi onayla',
    'admin-alias.email' => 'E-posta',
    'admin-alias.contact' => 'İrtibat adı',
    'admin-alias.comments' => 'Yorumlar',
    'admin-alias.emptyLogin' => 'Lütfen bir kullanıcı adı girin.',
    'admin-alias.loginTooLong' => 'Kullanıcı adı uzunluğu 20 karakterden fazla.',
    'admin-alias.emptyEmail' => 'Lütfen bir e-posta girin.',
    'admin-alias.emptyContactName' => 'Lütfen bir kişi adı girin.',
    'admin-alias.contactNameTooLong' => 'Kişi adı uzunluğu 255 simgeden fazla.',
    'admin-alias.emptyPassword' => 'Lütfen bir şifre verin.',
    'admin-alias.commentsTooLong' => 'Yorumun uzunluğu 255 simgeden fazla.',
    'admin-alias.emailActivation' => 'Hesabı e-postayla etkinleştir',
    'admin-alias.simplePanel' => 'Sınırlı Modu Etkinleştir',
    'admin-alias.simplePanelHint' => 'Ek yöneticinin Plesk\'te yapabileceği eylem sayısını sınırlandırmak için bu seçeneği seçin. Hangi eylemlerin kullanılabileceğini değiştirmek için, %%link%% bağlantısına gidin.',
    'admin-alias.simplePanelLink' => 'Araçlar ve Ayarlar> Sınırlı Mod Ayarları',
    'admin-alias.lockPowerUser' => 'Ek yönetici için zorla İleri Kullanıcı görünümünü uygulayın',
    'admin-alias.lockPowerUserHint' => 'Ek Plesk yöneticisi için görünümü kısıtlama seçeneği (müşteriler, satıcılar ve servis planları için erişim yoktur).',

    'admin-info.plesk-settings.multiplyLogin' => 'Bu hesap altında birden fazla oturuma izin verin',
    'admin-info.plesk-settings.adminLanguage' => 'Yöneticinin arayüz dili',
    'admin-info.plesk-settings.password' => 'Şifre',
    'admin-info.plesk-settings.passwordConfirmation' => 'Şifreyi onayla',

    'admin-panel.form.contact-info.contactName' => 'İrtibat adı',
    'admin-panel.form.contact-info.emptyContactName' => 'Lütfen bir kişi adı girin.',
    'admin-panel.form.contact-info.contactNameTooLong' => 'İrtibat adı çok uzun (maksimum %max% simgeye izin verilir).',
    'admin-panel.form.contact-info.email' => 'E-posta adresi',
    'admin-panel.form.contact-info.emptyEmail' => 'Lütfen bir e-posta adresi verin.',
    'admin-panel.form.contact-info.companyName' => 'Firma adı',
    'admin-panel.form.contact-info.longCompanyName' => 'Bu şirket adı çok uzun (maksimum %max% simgeye izin verilir).',
    'admin-panel.form.contact-info.phone' => 'URL',
    'admin-panel.form.contact-info.longPhone' => 'Bu telefon numarası çok uzun (maksimum %max% simgeye izin verilir).',
    'admin-panel.form.contact-info.fax' => 'Faks numarası',
    'admin-panel.form.contact-info.imNumber' => 'Anlık mesaj programı',
    'admin-panel.form.contact-info.longFax' => 'Bu faks numarası çok uzun (maksimum %max% simgeye izin verilir).',
    'admin-panel.form.contact-info.phoneRegexNotMatch' => 'Belirtilen telefon numarası geçerli değil.',
    'admin-panel.form.contact-info.faxRegexNotMatch' => 'Bu faks numarası yanlış.',
    'admin-panel.form.contact-info.address' => 'Adres',
    'admin-panel.form.contact-info.longAddress' => 'Bu adres çok uzun (maksimum %max% simgeye izin verilir).',
    'admin-panel.form.contact-info.city' => 'Şehir',
    'admin-panel.form.contact-info.longCity' => 'Bu şehir adı çok uzun.',
    'admin-panel.form.contact-info.shortCity' => 'Bu şehir adı çok kısa.',
    'admin-panel.form.contact-info.state' => 'İl/ilçe',
    'admin-panel.form.contact-info.postalCode' => 'Posta Kodu',
    'admin-panel.form.contact-info.country' => 'Ülke',
    'admin-panel.form.contact-info.additionalInfo' => 'Ek bilgiler',
    'admin-panel.form.contact-info.additionalInfoHint' => 'Sadece düz metin: Tüm HTML etiketleri göz ardı edilecek.',
    'admin-panel.form.contact-info.duplicateEmail' => 'Bu e-posta adresine sahip olan bir kullanıcı sistemde zaten var.',

    'admin-panel.form.domain-info-section.domainInfoSection' => 'Abonelik',
    'admin-panel.form.domain-info-section.domainInfoSectionForCustomerHint' => 'Web sitesinin özellikleri, abonelikle birlikte sağlanır.',
    'admin-panel.form.domain-info-section.domainInfoSectionForResellerHint' => 'Web sitesinin özellikleri, abonelikle birlikte sağlanır.',
    'admin-panel.form.domain-info-section.domainInfoSectionOwnHint' => 'Web sitesinin özellikleri, abonelikle birlikte sağlanır.',
    'admin-panel.form.domain-info-section.createSubscription' => 'Müşteri için abonelik oluşturun',
    'admin-panel.form.domain-info-section.createSubscriptionHint' => 'Bir barındırma servis aboneliği oluşturmak veya şu an müşteri için bir web sitesi kurmak istemiyorsanız, bu onay kutusundaki işareti kaldırın. Abonelik olmadığında müşteri, Müşteri Panelinde oturum açamaz.',
    'admin-panel.form.domain-info-section.domainName' => 'Alan adı',
    'admin-panel.form.domain-info-section.emptyDomainName' => 'Bir alan adı belirtmeniz gerekir.',
    'admin-panel.form.domain-info-section.shared' => 'paylaşılan',
    'admin-panel.form.domain-info-section.exclusive' => 'atanmış',
    'admin-panel.form.domain-info-section.userName' => 'Kullanıcıadı',
    'admin-panel.form.domain-info-section.userNameHint' => 'Sistem kullanıcısı hesabı, abonelikle oluşturulan web sitelerinin dosya ve klasörlerini yönetir.',
    'admin-panel.form.domain-info-section.emptyLogin' => 'Bir kullanıcı adı belirtmeniz gerekir.',
    'admin-panel.form.domain-info-section.password' => 'Şifre',
    'admin-panel.form.domain-info-section.emptyPassword' => 'Bir parola belirtmeniz gerekir.',
    'admin-panel.form.domain-info-section.passwordConfirmation' => 'Şifreyi onayla',
    'admin-panel.form.domain-info-section.ipv4AddressHint' => "Web sitesinin üzerinde barındığı IP adresi, web sitesinin sanal ana bilgisayarının bir ağ adresidir.",
    'admin-panel.form.domain-info-section.ipv4Address' => 'IPv4 adresi',
    'admin-panel.form.domain-info-section.ipv6AddressHint' => "Web sitesinin üzerinde barındığı IP adresi, web sitesinin sanal ana bilgisayarının bir ağ adresidir.",
    'admin-panel.form.domain-info-section.ipv6Address' => 'IPv6 adresi',
    'admin-panel.form.domain-info-section.noIpAddressHint' => 'Hiçbiri',
    'admin-panel.form.domain-info-section.subscriptionSettings' => 'Ek abonelik ayarları',
    'admin-panel.form.domain-info-section.credentials' => 'Sistem kullanıcı bilgileri',
    'admin-panel.form.domain-info-section.credentialsHint' => 'FTP ve SSH üzerinde barındırılan dosyalara erişim için',
    'admin-panel.form.domain-info-section.credentialsHintWin' => 'FTP ve RDP üzerinde barındırılan dosyalara erişim için',

    'admin-panel.form.login-info.userName' => 'Kullanıcıadı',
    'admin-panel.form.login-info.emptyUserName' => 'Lütfen bir kullanıcı adı girin.',
    'admin-panel.form.login-info.password' => 'Şifre',
    'admin-panel.form.login-info.emptyPassword' => 'Lütfen bir şifre verin.',
    'admin-panel.form.login-info.passwordConfirmation' => 'Şifreyi tekrarlayın',
    'admin-panel.form.login-info.internalEmailPasswordChanged' => 'Şifreyi değiştirdiğinizde dahili e-posta adresi şifresini de değiştirirsiniz',
    'admin-panel.form.login-info.emailActivation' => 'Hesabı e-postayla etkinleştir',
    'admin-panel.form.login-info.emailActivationHint' => 'Kullanıcı, e-postayla gönderilen bağlantıyla etkinleştirmediği veya yönetici, hesabı manuel olarak etkinleştirmediği sürece, oluşturulan bir hesap etkin değildir.',

    'admin-panel.form.subscription-info-section.subscription' => 'Abonelik',
    'admin-panel.form.subscription-info-section.servicePlan' => 'Servis Planı',
    'admin-panel.form.subscription-info-section.oldServicePlan' => 'Geçerli servis planı',
    'admin-panel.form.subscription-info-section.newServicePlan' => 'Yeni servis planı',
    'admin-panel.form.subscription-info-section.adminPlan' => 'Basit plan',
    'admin-panel.form.subscription-info-section.none' => 'Hiçbiri',
    'admin-panel.form.subscription-info-section.addonPlans' => 'Eklentiler',
    'admin-panel.form.subscription-info-section.customizeSubscription' => 'Plan ilişkilendirmesi değiştirildikten sonra, aboneliğin parametrelerini özelleştirmeye devam edin.  Bunu yaptığınızda aboneliğin senkronizasyon için kilitleneceğini unutmayın.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionOnCreateSubscription' => 'Oluşturulduktan sonra abonelik parametrelerini özelleştirmeye devam et.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionForCustomer' => "Müşteri oluşturulduktan sonra abonelik parametrelerini özelleştirmeye devam et.",
    'admin-panel.form.subscription-info-section.customizeSubscriptionForSelf' => 'Oluşturulduktan sonra, aboneliğin parametrelerini özelleştirmeye devam edin. Bunu yaptığınızda aboneliğin senkronizasyon için kilitleneceğini unutmayın.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionHint' => 'Bunu yapmanın senkronizasyon için aboneliği kilitleyeceğini unutmayın.',
    'admin-panel.form.subscription-info-section.buttonOk' => 'Abonelik Ekle',

    'admin-panel.form.subscription.subscriptionNotSynchronized' => 'Abonelik, servis planıyla senkronize edilemedi. Aboneliğin aşağıdaki ayarları, servis planıyla çakışıyor: %%problems%%.',

    'app.configure.otherSettings' => 'Diğer',
    'app.configure.passwordConfirmation' => 'Şifreyi onayla',

    'app.update-settings.description' => '',
    'app.update-settings.forceUpdates' => 'Tüm yüklü uygulamalar için güç güncellemeleri',
    'app.update-settings.forceUpdatesHint' => 'Güncellemeler kullanılabilir hale gelir gelmez, tüm müşterilerin uygulamaları otomatik olarak güncellenir.  Müşteriler, uygulamaları için otomatik güncellemeleri kapatamayacak.  Dikkat: Güncellemeler, uygulamanın işlevselliğini büyük ölçüde etkileyebileceğinden, bu seçeneği çok dikkatli kullanın.  Örneğin uygulamanın başka bir sürümünde uygulama uzantılarının çalışması durabilir.',
    'app.update-settings.suggestUpdates' => '"Bu uygulamayı otomatik olarak güncelleyin" seçeneğini varsayılan olarak açın',
    'app.update-settings.suggestUpdatesHint' => 'Yeni yüklenen uygulamalar için, uygulamanın ayarlarındaki "Bu uygulamayı otomatik olarak güncelleyin" seçeneği açılır.',

    'backup.server-settings.rotation' => 'Saklanacak maksimum tam yedekleme dosyası sayısı (planlı ve manuel yedeklemeler de dahil)',
    'backup.server-settings.rotationDescription' => 'Kullanıcılar, sunucu deposunda bu sayıda tam yedeklemeyi saklayabilir. Zaten depoda bulunan tam yedekleme sayısı sınırı aşıyorsa, sadece en son yedeklemeler korunur. Artan yedeklemeler etkilenmez.',
    'backup.server-settings.maxProcesses' => 'Maksimum sayıda eşzamanlı çalışması planlanmış yedekleme işlemleri',
    'backup.server-settings.niceScheduled' => 'Düşük öncelikli planlanmış yedekleme işlemlerini çalıştırın',
    'backup.server-settings.niceScheduledPriority' => 'Öncelik',
    'backup.server-settings.niceScheduledPriorityDescription' => '1 ile 19 arasında bir değer girin, yüksek bir sayı daha düşük önceliğe sahiptir.',
    'backup.server-settings.niceScheduledIoPriority' => 'GÇ önceliği',
    'backup.server-settings.niceScheduledIoPriorityDescription' => '0 ile 7 arasında bir değer girin, yüksek bir sayı daha düşük önceliğe sahiptir.',
    'backup.server-settings.niceAlways' => 'Düşük öncelikli tüm yedekleme işlemlerini çalıştırın',
    'backup.server-settings.niceAlwaysPriority' => 'Öncelik',
    'backup.server-settings.niceAlwaysPriorityDescription' => '1 ile 19 arasında bir değer girin, yüksek bir sayı daha düşük önceliğe sahiptir.',
    'backup.server-settings.niceAlwaysIoPriority' => 'GÇ önceliği',
    'backup.server-settings.niceAlwaysIoPriorityDescription' => '0 ile 7 arasında bir değer girin, yüksek bir sayı daha düşük önceliğe sahiptir.',
    'backup.server-settings.compressionLevel' => 'Sıkıştırma seviyesi',
    'backup.server-settings.compressionLevelNoCompression' => 'Sıkıştırma yok',
    'backup.server-settings.compressionLevelFastest' => 'En hızlı',
    'backup.server-settings.compressionLevelFast' => 'Hızlı',
    'backup.server-settings.compressionLevelNormal' => 'Normal',
    'backup.server-settings.compressionLevelMaximum' => 'En fazla',
    'backup.server-settings.freeSpaceRequired' => 'Yedeklemeyi sadece sunucunuz, belirtilen boş disk alanı miktarına (megabayt) sahipse başlatın',
    'backup.server-settings.checkBackupDiskSpace' => 'Yedeklemeyi ancak sunucunuzda yeterli boş alan varsa başlatın',
    'backup.server-settings.mssqlNativeBackupEnabled' => 'Doğal MS SQL yedekleme işlevselliğini kullanın (Uzak veritabanları için, Araçlar ve Ayarlar> Veritabanı Sunucuları altından uzak MS SQL sunucusunun yedekleme ayarlarını yapılandırdığınızdan emin olun)',
    'backup.server-settings.localFtpRestriction' => 'Yerel sunucuda FTP yedekleme depolamasının ayarlanmasına izin verin',
    'backup.server-settings.backupSecuritySettings' => 'Yedekleme güvenlik ayarları',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailed' => 'Uzak depolamaya karşıya yükleme başarısız olduğunda, yedeklemeleri sunucu depolamasına kaydedin',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailedDescription' => 'Uzak depolamaya karşıya yükleme başarısız olduğunda, uzak depolama için manuel ve planlanmış yedeklemeler, yerel sunucu depolamasına kaydedilir. Kullanıcıların yedeklemeleri sunucu depolamasında depolama izni bulunması gerekir.',

    'change-current-subscription.hint' => 'Bu, abonelik için servis planlarıyla olan ilişkilendirmeyi değiştirdiğiniz yerdir.  Yeni bir servis planı olarak \'hiçbiri\' seçmenin, aboneliğin servis planındaki bağlantısını kaldırdığını ve onu \'Özel\' yaptığını unutmayın.',
    'change-current-subscription.subscriptionNotSynchronized' => 'Abonelik, servis planıyla senkronize edilemedi. Aboneliğin aşağıdaki ayarları, servis planıyla çakışıyor: %%problems%%.',

    'change-password.oldPassword' => 'Eski şifre',
    'change-password.password' => 'Yeni şifre',
    'change-password.passwordConfirmation' => 'Şifreyi onayla',
    'change-password.oldPasswordIsIncorrect' => 'Eski parola yanlış. Lütfen yeniden deneyin.',
    'change-password.unableToFindAdditionalAdminAccount' => 'Ek yönetici hesabı bulunamıyor.',
    'change-password.warningAboutAdminPasswordSyntax' => "Parolanın uzunluğunun en %%min%% - %%max%% karakter arasında olması ve kullanıcı adını içermemesi gerekir.\nParolada tırnak işaretleri, boşluk işaretleri ve ulusal alfabe karakterlerini kullanmayın.",
    'change-password.warningAboutWinAdminPasswordSyntax' => "Parolada tırnak işaretleri, boşluk işaretleri, noktalı virgül ve ulusal alfabe karakterlerini kullanmayın.\nParolanın uzunluğunun en %%min%% ile %%max%% karakter arasında olması ve kullanıcı adını içermemesi gerekir.",

    'change-reseller-oversell-policy.oversellPolicy' => 'Fazla satış ilkesi',
    'change-reseller-oversell-policy.oversellPolicyAllowed' => 'Fazla satmaya izin verilir',
    'change-reseller-oversell-policy.oversellPolicyAllowedHint' => 'Fazla satma, bir satıcının bir planla onlara ayrılandan daha fazla kaynak satmasına izin verir.  Fazla satmaya izin verildiğinde, bir satıcı ilk kaynak ayırma yerine geçerli kaynak kullanımıyla yönetilir.',
    'change-reseller-oversell-policy.oversellPolicyNotAllowed' => 'Fazla satmaya izin verilmez',
    'change-reseller-oversell-policy.oversellPolicyNotAllowedHint' => 'Fazla satmaya izin verilmediğinde, bir satıcı sadece onlara ilk başta bir planla ayrıldığı kadar kaynak satabilir ve bunu yaparken bu kaynakların gerçekte ne kadarının kullanıldığını göz ardı eder.',

    'change-reseller-subscription.hint' => 'Bu, satıcı aboneliği için servis planıyla olan ilişkilendirmeyi değiştirdiğiniz yerdir.  Yeni bir servis planı olarak \'hiçbiri\\\' seçmenin, aboneliğin servis planındaki bağlantısını kaldırdığını ve onu \'Özel\' yaptığını unutmayın.',
    'change-reseller-subscription.subscriptionNotSynchronized' => 'Abonelik, servis planıyla senkronize edilemedi. Aboneliğin aşağıdaki ayarları, servis planıyla çakışıyor: %%problems%%.',
    'change-reseller-subscription.servicePlan' => 'Yeni plan',
    'change-reseller-subscription.oldSubscription' => 'Geçerli plan',
    'change-reseller-subscription.none' => 'hiçbiri',
    'change-reseller-subscription.infoSubscriptionChanged' => 'Servis planıyla abonelik ilişkilendirmesi güncellendi.',
    'change-reseller-subscription.customizeSubscription' => 'Servis planıyla ilişkilendirmesi güncellendikten sonra, aboneliğin parametrelerini özelleştirmeye devam edin. Bunu yaptığınızda aboneliğin senkronizasyon için kilitleneceğini unutmayın.',

    'change-subscription.hint' => 'Bu, seçilen abonelikler için servis planlarıyla olan ilişkilendirmeyi değiştirdiğiniz yerdir.',
    'change-subscription.selectPlanLegend' => 'Servis Planı',
    'change-subscription.selectPlanDescription' => 'Başka bir servis planına geçmek için, listeden yeni planı seçin.  Yeni bir servis planı olarak \'hiçbiri\' seçmenin, aboneliklerin servis planındaki bağlantılarını kaldırdığını ve onları \'Özel\' yaptığını unutmayın.',
    'change-subscription.servicePlan' => 'Yeni servis planı',
    'change-subscription.selectAddonPlansLegend' => 'Eklenti planları',
    'change-subscription.selectAddonPlansDescription' => 'Eklenti planlarını ekleyin veya kaldırın.',
    'change-subscription.noChange' => 'değişiklik yok',
    'change-subscription.none' => 'hiçbiri',
    'change-subscription.add' => 'topla',
    'change-subscription.del' => 'Kaldır',
    'change-subscription.separator' => '-------',

    'control-panel-access.network.subnetOrIpAddressLabel' => 'Subnet veya IP Adresi',
    'control-panel-access.network.subnetOrIpAddressHint' => 'Örneğin 2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'control-panel-access.settings.accessPolicyLabel' => 'Yönetici ayrıcalıklarıyla Plesk\'e erişim',
    'control-panel-access.settings.policyAllow' => 'Liste dışındaki netwokler dışında erişim açık.',
    'control-panel-access.settings.policyDeny' => 'Liste dışındaki netwokler dışında erişim kapalı.',

    'create-subscription.title' => 'Bir Abonelik ekleme',
    'create-subscription.titleOwn' => 'Kendi Aboneliğini Ekleme',
    'create-subscription.poolIsEmpty' => 'Paylaşılmış IP adresleri ve Plesk\'te atanmış bedava IP adresleri olmadığından, bir abonelik oluşturulamıyor.',
    'create-subscription.infoNewSubscriptionCreated' => 'Abonelik %%name%% oluşturuldu.',
    'create-subscription.createBeforeAppInstall' => 'Uygulamayı kuracağınız bir aboneliğinizin olması gerekir.',

    'customer.hint' => 'Bu, barındırma servislerinize yeni bir müşteri kaydettiğiniz yerdir. Bu kaydolmayla, Plesk\'te bir müşteri hesabı ve barındırma planlarınızdan birine ve isteğe bağlı olarak eklentilere bir abonelik oluşturursunuz. Abonelik ayrıca hiçbir plana bağlı olmayan komple bir özel kaynak ve servis seti de sunabilir -- bunun için, Servis Planının yanındaki \\Hiçbiri\' seçeneğini seçin.',
    'customer.contactInfoSection' => 'Kişi Bilgileri',
    'customer.additionalInfoSection' => 'Ek müşteri bilgileri',
    'customer.accessToPanelSection' => 'Plesk\'e erişim',
    'customer.contactInfoSectionHint' => 'Müşterinin irtibat bilgilerini girin.',
    'customer.accessToPanelSectionHint' => 'Müşterinin Müşteri Paneline erişmek için kullanacağı kimlik bilgileri.',
    'customer.unableCreateSubscription' => 'Abonelik oluşturulamaz: %%reason%%',
    'customer.poolIsEmpty' => 'IP havuzu boş',
    'customer.buttonOk' => 'Müşteri Ekle',

    'database-settings.dbPrefixRadio' => 'Veritabanı adlarının başına bir ön ek ve alt çizgi ekleyin',
    'database-settings.dbPrefixNone' => 'Hiçbiri',
    'database-settings.dbPrefixUsername' => 'Kullanıcıadı',
    'database-settings.dbPrefixExternalId' => 'Bir aboneliğin harici kimliği',
    'database-settings.dbPrefixCustom' => 'Özel ön ek',
    'database-settings.dbUserPrefixRadio' => 'Veritabanı adlarının başına bir ön ek ve alt çizgi ekleyin',
    'database-settings.dbUserPrefixHint' => 'Veritabanı kullanıcı adları, <prefix>_<database_user_name> şeklinde görünür. Kullanıcı adı uzunluğuyla ilgili veritabanı sınırlamasından dolayı <prefix> kısaltılabilir.',
    'database-settings.grantAlterDatabase' => 'VERİTABANINI DEĞİŞTİR (ALTER DATABASE) iznini tüm Microsoft SQL Sunucusu veritabanı kullanıcılarına verin',
    'database-settings.grantAlterDatabaseHint' => 'Bu izin, yeni ve varolan kullanıcılara verilecektir.',
    'database-settings.enableBackupOperator' => 'Tüm Microsoft SQL Server veritabanı kullanıcıları için db_backupoperator rolü üyeliğini etkinleştirin',
    'database-settings.enableBackupOperatorHint' => 'Yeni ve varolan kullanıcılar, bu rolün bir üyesi olacaktır.',
    'database-settings.aclRadio' => 'MYSQL veritabanı kullanıcılarının uzaktan erişimi için varsayılan ayarlar',
    'database-settings.aclLocalhost' => 'Sadece yerel bağlantılara izin verin',
    'database-settings.aclAny' => 'Herhangi bir ana bilgisayardan uzaktan bağlantılara izin verin',
    'database-settings.aclCustom' => 'Buradan uzaktan bağlantılara izin verin',
    'database-settings.aclDescription' => 'Bu ayar ancak kullanıcıların izinlerini değiştirir. Yerel MySQL sunucusuna uzaktan erişimi etkinleştirmek için, %%serverLink%% bağlantısındaki ilgili seçeneği seçin',
    'database-settings.aclDescriptionLink' => 'Local MySQL Ayarları',
    'database-settings.example' => "Örneğin:",
    'database-settings.aclExampleDescription' => "Belirtilen ana bilgisayarların bu kullanıcının yerine veritabanına erişmesine izin verilir.",
    'database-settings.dbPrefixAlphaNumeric' => 'Ön ek değeri sadece alfasayısal değerler ve alt çizgi içerebilir.',

    'dns.add-acl-record.description' => 'DNS bölgesinin bir kopyasını almasına izin verilen DNS sunucusunun bir IP adresini ekleyin.',
    'dns.add-acl-record.ipAddress' => 'IP Adresi',
    'dns.add-acl-record.ipAddressWithMask' => 'IP Adresi/maske',

    'dns.settings.recursion' => 'Özyinelemeli DNS sorguları',
    'dns.settings.recursionOn' => 'Tüm isteklere izin ver',
    'dns.settings.recursionLocal' => 'Yalnızca yerel isteklere izin ver',
    'dns.settings.recursionLocalnets' => 'Yalnızca yerel bağlantıların taleplerine izin ver',
    'dns.settings.recursionOff' => 'Tüm istekleri reddet',
    'dns.settings.customConfiguration' => 'Ek DNS ayarları',
    'dns.settings.customConfigurationPlaceholder' => 'Burada belirttiğiniz ayarlar, sunucu genelinde geçerli olanları geçersiz kılar.',
    'dns.settings.customConfigurationHint' => 'Belirli ayarları bulamıyorsanız, named.conf söz dizimini kullanarak yukarıdaki alana ekleyin.',
    'dns.settings.customConfigurationExample' => 'Örneğin, bir DNS sunucusunun istemci adını gizlemek için şu satırı girin: ',
    'dns.settings.restoreDefaultButton' => 'Varsayılan Ayarları Kullan',

    'dns.template.synchronize-done' => 'DNS bölgesi şablonu başarıyla uygulandı.',
    'dns.template.synchronize-error' => 'DNS bölgesi şablonu bazı DNS bölgelerine uygulanmadı.',
    'dns.template.synchronize-progress' => 'DNS bölgesi şablonunu uygulama.',

    'domain-restriction.name' => 'Alan adı',
    'domain-restriction.nameDescription' => 'Yıldız işaretini (*) kullanarak bir joker desen belirtebilirsiniz. Örneğin *.example.com',
    'domain-restriction.domainAlreadyExists' => 'Belirtilen alan adı zaten listede.',

    'event-handler.eventLabel' => 'Olay',
    'event-handler.priorityLabel' => 'Öncelik',
    'event-handler.userLabel' => 'Kullanıcı',
    'event-handler.commandLabel' => 'Komut',
    'event-handler.commandHint' => 'En iyi sonuçları elde etmek için, \'komut\' alanına bir komut dosyasının tam yolunu girin. Sistem komutları çalışmayabileceğinden, bunların girilmesi önerilmez. Örneğin çıkışı yeniden yönlendirme operatörü /&gt; veya &lt; olan komutlar çalışmaz.',
    'event-handler.priorityHighestText' => 'En yüksek',
    'event-handler.priorityHighText' => 'Yüksek',
    'event-handler.priorityNormalText' => 'Normal',
    'event-handler.priorityLowText' => 'düşük',
    'event-handler.priorityLowestText' => 'En düşük',
    'event-handler.priorityCustomText' => 'Özel',
    'event-handler.priorityHighestOption' => 'en yüksek (%%value%%)',
    'event-handler.priorityHighOption' => 'yüksek (%%value%%)',
    'event-handler.priorityNormalOption' => 'normal (%%value%%)',
    'event-handler.priorityLowOption' => 'düşük (%%value%%)',
    'event-handler.priorityLowestOption' => 'en düşük (%%value%%)',

    'extension.upload.fileUpload' => 'Uzantı paket dosyası yolu',

    'external-webmail.hint' => 'Plesk\'e ek bir web postası kaydettiğinizde, müşterileriniz için kullanılabilir hale gelir: barındırma planlarının ve aboneliklerin \'Posta\' özelliklerindeki bir seçenek olarak görünür. Web postası seçenekleri listesinde web postası adı görüntülenir ve Müşteri Panelindeki bir posta kutusunun yanındaki web postası simgesi tıklandığında URL açılır.',
    'external-webmail.name' => 'Web postası servis adı',
    'external-webmail.url' => 'Web postası servis URL\'si',
    'external-webmail.enabled' => 'Müsait',

    'ftp-settings.generalSection' => 'Genel',
    'ftp-settings.portRange' => 'Pasif FTP modu bağlantıları için bağlantı noktası veya bağlantı noktası aralığı',
    'ftp-settings.hintPortRange' => '(varsayılan değer: %%defaultPortRange%%)',

    'health.upload.hint' => 'Sağlık sunucusu ekranı yapılandırmanızı yükleyin.  Yapılandırma karşıya yüklenir yüklenmez uygulanır.',
    'health.upload.selectFile' => 'Konfigürasyon dosyası',

    'install-local-package.selectUploadType' => 'Aşağıdakilerden birini seçin:',
    'install-local-package.uploadAsFile' => 'Bir APS paketi yükleyin',
    'install-local-package.downloadFromCatalog' => 'Uygulama Katalogundan bir uygulama seçin',
    'install-local-package.formInfo' => "Kullanılabilir uygulamalar listesini yeni bir uygulamayla genişletin veya diğer yapılandırma için Uygulama Katalogundaki bir uygulamayı ekleyin.",
    'install-local-package.invalidFileExtension' => 'Karşıya yüklenen uygulamanın, .zip uzantılı bir ZIP arşivi olması gerekir.',
    'install-local-package.packagesNotSelected' => 'Paketlerin hiçbiri seçili değil.',
    'install-local-package.visible' => 'Müşteriler için kullanılabilir hale getirin',
    'install-local-package.isCommercial' => 'Bu uygulama paralıdır ve bir lisans anahtarı satın almayı gerektirir.',
    'install-local-package.visibleDescription' => 'Uygulamayı müşterilerin kurulumu için kullanılabilir hale getirin.',

    'ip-address.addTitle' => 'IP adresini ekleyin',
    'ip-address.editTitle' => '%%interface%% arayüzündeki IP adresi %%address%%',
    'ip-address.generalSection' => 'Genel',
    'ip-address.interface' => 'Arayüz',
    'ip-address.addressAndSubnetPrefixLength' => 'IP adresi ve alt ağ maskesi',
    'ip-address.addressHintIPv4' => 'Örneğin: 123.123.123.123/16 veya 123.123.123.123/255.255.0.0',
    'ip-address.addressHintIPv6' => 'Örneğin: 2002:7b7b:7b7b::1/64, 123.123.123.123/16 veya 123.123.123.123/255.255.0.0',
    'ip-address.publicIp' => 'Genel IP adresi',
    'ip-address.hintPublicIp' => 'Plesk sunucunuz bir NAT arkasındaysa, genel bir IP adresini kullanabilirsiniz',
    'ip-address.distributionType' => 'IP adresi farklı dağıtılıyor',
    'ip-address.distributionTypeShared' => 'Paylaşılan',
    'ip-address.distributionTypeExclusive' => 'Ayrılmış',
    'ip-address.certificate' => 'SSL/TLS sertifikası',
    'ip-address.defaultSite' => 'Varsayılan tesis',
    'ip-address.ftpOverSslNotSupportedByServer' => 'Yüklü FTP sunucusu, FTPS\'yi desteklemiyor.',
    'ip-address.ftpOverSslIpv6NotSupportedByServer' => 'Kurulu FTP sunucusu, IPv6 adreslerini desteklemiyor.',
    'ip-address.interfaceDHCPEnabled' => 'IP adresi eklenemiyor. Bu ağ arabirimi, IP adreslerini otomatik olarak alır.',
    'ip-address.accessDomainOnAnyDomainWinWarning' => 'Not: Tüm bilinmeyen alan adları için özel Plesk URL\'si etkinleştirildi; "https://%%ip%%/" adresinde varsayılan site yerine Plesk arayüzü görüntülenecektir.',
    'ip-address.ipAddressInterfaceNotAvailableWarning' => 'Ağ adaptörü %%interface%% yok. Bu IP adresini başka bir ağ adaptörüne taşıyın veya onu listeden kaldırın.',
    'ip-address.none' => 'hiçbiri',

    'ip-ban.filter.name' => 'Adı',
    'ip-ban.filter.content' => 'İçerik',
    'ip-ban.filter.filterExistsError' => 'Bu ada sahip bir filtre zaten var.',

    'ip-ban.jail.name' => 'Adı',
    'ip-ban.jail.filter' => 'Filtre',
    'ip-ban.jail.filterDescription' => 'Filtreyi seçin.',
    'ip-ban.jail.action' => 'İşlem',
    'ip-ban.jail.actionDescription' => 'Bir eylem seçin ve onu eklemek için düğmeyi tıklatın.',
    'ip-ban.jail.logPath' => 'Günlük yolu',
    'ip-ban.jail.banTime' => 'IP adresini yasaklama süresi',
    'ip-ban.jail.maxRetry' => 'Maksimum başarısız oturum açma denemesi sayısı',
    'ip-ban.jail.timeUnit' => 'saniye',
    'ip-ban.jail.addAction' => 'Ekle',
    'ip-ban.jail.chooseAction' => 'Seçim:',
    'ip-ban.jail.apache-auth-filter-description' => 'Apache yetkilendirme hataları (dosyaya kayıt tutarken)',
    'ip-ban.jail.apache-auth[logging=all]-filter-description' => 'Apache yetkilendirme hataları (tüm kayıt tutmalar)',
    'ip-ban.jail.apache-auth[logging=syslog]-filter-description' => 'Apache yetkilendirme hataları (syslog\'a kayıt tutarken)',
    'ip-ban.jail.apache-badbots-filter-description' => 'Gereksiz posta robotları ve zararlı web gezginleri',
    'ip-ban.jail.plesk-courierlogin-filter-description' => 'Courier IMAP ve POP3 doğrulaması hataları',
    'ip-ban.jail.plesk-dovecot-filter-description' => 'Dovecot IMAP, POP3 ve Sieve doğrulaması hataları',
    'ip-ban.jail.plesk-dovecot[mode=aggressive]-filter-description' => 'Dovecot IMAP, POP3 ve Sieve doğrulama hataları (saldırgan mod)',
    'ip-ban.jail.plesk-horde-filter-description' => 'Horde web postası doğrulaması hataları',
    'ip-ban.jail.plesk-modsecurity-filter-description' => 'Web Uygulaması Güvenlik Duvarı (ModSecurity) güvenlik ve erişim kontrolü ihlalleri',
    'ip-ban.jail.plesk-panel-filter-description' => 'Plesk doğrulaması hataları',
    'ip-ban.jail.plesk-qmail-filter-description' => 'QMail SMTP doğrulaması hataları',
    'ip-ban.jail.plesk-roundcube-filter-description' => 'Roundcube web postası doğrulaması hataları',
    'ip-ban.jail.plesk-wordpress-filter-description' => 'WordPress doğrulaması hataları',
    'ip-ban.jail.postfix-filter-description' => 'Postfix SMTP istemci hataları (RBL dahil)',
    'ip-ban.jail.postfix[mode=aggressive]-filter-description' => 'Postfix SMTP istemci hataları, doğrulama hataları ve DDoS saldırıları',
    'ip-ban.jail.postfix[mode=auth]-filter-description' => 'Postfix SMTP ve SASL doğrulaması hataları',
    'ip-ban.jail.postfix[mode=ddos]-filter-description' => 'Postfix SMTP DDoS saldırıları',
    'ip-ban.jail.postfix[mode=extra]-filter-description' => 'Postfix SMTP istemci hataları ve doğrulama hataları',
    'ip-ban.jail.postfix[mode=normal]-filter-description' => 'Postfix SMTP istemci hataları (RBL dahil)',
    'ip-ban.jail.postfix[mode=rbl]-filter-description' => 'Postfix SMTP istemci hataları (sadece RBL)',
    'ip-ban.jail.proftpd-filter-description' => 'ProFTPD oturum açma hataları',
    'ip-ban.jail.recidive-filter-description' => 'Fail2Ban tarafından art arda yasaklanan ana bilgisayarlar',
    'ip-ban.jail.sshd-filter-description' => 'SSH oturum açma hataları',
    'ip-ban.jail.sshd[mode=aggressive]-filter-description' => 'SSH oturum açma hataları, pazarlık hataları ve DDoS saldırıları',
    'ip-ban.jail.sshd[mode=ddos]-filter-description' => 'SSH oturum açma hataları ve DDoS saldırıları',
    'ip-ban.jail.sshd[mode=extra]-filter-description' => 'SSH oturum açma ve pazarlık hataları',
    'ip-ban.jail.firewallcmd-allports-action-description' => 'Tüm bağlantı noktalarında, firewalld güvenlik duvarından yasaklama',
    'ip-ban.jail.firewallcmd-multiport-action-description' => 'Birden fazla bağlantı noktasında, firewalld güvenlik duvarından yasaklama',
    'ip-ban.jail.firewallcmd-new-action-description' => 'Tek bir bağlantı noktasında, firewalld güvenlik duvarından yasaklama',
    'ip-ban.jail.iptables-action-description' => 'Tek bir bağlantı noktasında, iptables güvenlik duvarından yasaklama',
    'ip-ban.jail.iptables-allports-action-description' => 'Tüm bağlantı noktalarında, iptables güvenlik duvarından yasaklama',
    'ip-ban.jail.iptables-multiport-action-description' => 'Birden fazla bağlantı noktasında, iptables güvenlik duvarından yasaklama',
    'ip-ban.jail.sendmail-action-description' => 'E-posta ihbarını sendmail üzerinden gönderin',
    'ip-ban.jail.jailExistsError' => 'Bu ada sahip bir jail zaten var.',
    'ip-ban.jail.invalidInteger' => 'Belirtilen değer geçersiz. Bir tamsayı belirtin.',

    'ip-ban.settings.pageHint' => 'Burada, sunucunuzu ve barındırılan web sitelerinizi kötü amaçlı trafikten korumak için IP adresi yasağını ayarlayabilirsiniz.',
    'ip-ban.settings.detectionEnabled' => 'İhlal saptamayı etkinleştir',
    'ip-ban.settings.banPeriod' => 'IP adresini yasaklama süresi',
    'ip-ban.settings.banTimeWindow' => 'Devamındaki saldırıları saptama zaman aralığı',
    'ip-ban.settings.maxRetries' => 'IP adresi yasaklanmadan önceki arıza sayısı',
    'ip-ban.settings.timeUnit' => 'saniye',
    'ip-ban.settings.invalidInteger' => 'Geçersiz bir değer sağlandı. Bir pozitif tam sayı girin.',

    'ip-ban.trusted-ip.ipAddress' => 'IP Adresi',
    'ip-ban.trusted-ip.hintIpAddress' => 'Bir IP adresi, bir CIDR maskesi veya bir DNS ana bilgisayar adı.',
    'ip-ban.trusted-ip.specialCharactersInIpAddress' => 'Sağlanan IP adresi, ağ adresi veya ana bilgisayar adı geçersiz.',
    'ip-ban.trusted-ip.ipAddressIsTooLong' => 'IP adresi %max% karakterden uzun olamaz.',
    'ip-ban.trusted-ip.ipAddressDescription' => 'Tanım',
    'ip-ban.trusted-ip.hintIpAddressDescription' => 'IP adresinin neden güvenilenler listesine eklendiğinin açıklaması.',
    'ip-ban.trusted-ip.ipAddressDescriptionTooLong' => 'Tanım %max% karakterden uzun olamaz.',

    'login-info.hint' => 'Bu, müşterinin Müşteri Paneline erişmek için kullandığı kullanıcı adını ve şifreyi değiştireceğiniz yerdir.',
    'login-info.resellerHint' => 'Bu, satıcının Plesk\'ine erişmek için kullandığı kullanıcı adını ve/veya şifreyi değiştireceği yerdir.',
    'login-info.myProfileHint' => 'Bu, Plesk\'inize erişmek için kullandığınız şifreyi değiştireceğiniz yerdir.',

    'firewall-rule.titleEdit' => 'Bir Güvenlik Duvarı Kuralını Düzenleme',
    'firewall-rule.titleNew' => 'Kural Ekleme',
    'firewall-rule.isEnabled' => 'Kuralı açın',
    'firewall-rule.name' => 'Kural Adı',
    'firewall-rule.profiles' => 'Profiller',
    'firewall-rule.profilesHint' => 'En az bir profil seçmeniz gerekir.',
    'firewall-rule.profileDomain' => 'Alan Adı',
    'firewall-rule.profilePrivate' => 'Özel',
    'firewall-rule.profilePublic' => 'Ortaklık',
    'firewall-rule.action' => 'İşlem',
    'firewall-rule.actionAllow' => 'İzin verin',
    'firewall-rule.actionBlock' => 'Reddedin',
    'firewall-rule.port' => 'Aşağıdaki bağlantı noktasına veya bağlantı noktası aralığına bağlantılara izin verin',
    'firewall-rule.portHint' => 'Örneğin: 1000 veya 1000-1051',
    'firewall-rule.protocolTcp' => 'TCP protokolü',
    'firewall-rule.protocolUdp' => 'UDP protokolü',
    'firewall-rule.remoteAddresses' => 'Uzak adresler',
    'firewall-rule.remoteAddressesHint' => 'Örneğin: 192.168.0.1 veya 192.168.0.0/16',
    'firewall-rule.newRule' => 'Yeni Kural',
    'firewall-rule.successNew' => 'Güvenlik duvarı kuralı eklendi.',
    'firewall-rule.successEdit' => 'Güvenlik duvarı kuralı güncellendi.',

    'mail.lists-server-settings.email' => "Postalama listesi yöneticisinin e-postası",
    'mail.lists-server-settings.emptyEmail' => 'Lütfen bir e-posta adresi verin.',
    'mail.lists-server-settings.newPassword' => 'Yeni şifre',
    'mail.lists-server-settings.emptyPassword' => 'Lütfen bir şifre verin.',
    'mail.lists-server-settings.passwordConfirmation' => 'Şifreyi onayla',
    'mail.lists-server-settings.mailingListSoftwareWasConfigured' => 'Postalama listesi yazılımı yapılandırılmış.',

    'mail.outgoing-messages.hint' => 'Burada, bir posta kutusundan giden mesajlar için bir sınır belirleyebilirsiniz.',
    'mail.outgoing-messages.mailBoxOutgoingMessages' => 'Maksimum giden e-posta mesajı sayısı',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainDefault' => 'Varsayılan (saatte %%domainOutgoingMessages%% mesaj)',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecific' => 'Bu posta kutusu için özel değer',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecificHint' => 'saatteki mesaj sayısı',

    'mail-gate-settings.host' => 'Host adı ya da IP adresi',
    'mail-gate-settings.port' => 'Port',
    'mail-gate-settings.login' => 'Kullanıcıadı',
    'mail-gate-settings.password' => 'Şifre',
    'mail-gate-settings.encryption' => 'SMTP sunucusu için şifrelenmiş bağlantı gerekir',
    'mail-gate-settings.allowUsers' => 'Kullanıcıların komut dosyalarının (belirtilen kullanıcı adını ve şifreyi kullanarak) bu SMTP sunucusundan posta göndermesine izin verin',
    'mail-gate-settings.useDefaultSettings' => 'Plesk ile birlikte yüklenen posta sunucunu ve Plesk tarafından oluşturulan varsayılan posta hesabını kullanın',

    'mail-gate.hint' => 'Burada, Plesk\'in posta sunucusu kurulmadığında veya giden postaları göndermesi yasaklandığında kullanılacak olan SMTP sunucusunu belirtebilirsiniz. Bu sunucu, örneğin e-posta bildirimleri gibi giden postaları Plesk ve kullanıcı komut dosyalarıyla göndermek için bir SMTP iletmesi olarak kullanılır.',
    'mail-gate.enableMailGate' => 'Plesk\'in bu SMTP sunucusundan e-posta bildirimleri göndermesine izin verin',
    'mail-gate.notifications' => 'Harici SMTP sunucusuyla posta bildirimleri',
    'mail-gate.smtpSettings' => 'Harici SMTP sunucusu ayarları',

    'optimization-settings.apacheModulesSection' => 'Apache modülleri',
    'optimization-settings.apacheSettingsSection' => 'Genel ayarlar',
    'optimization-settings.additionalPageHint' => 'Modülleri sadece eylemlerinizin sonuçları tamamen anladıysanız değiştirin. Bazı değişikliklerin Apache performansını düşürebileceğini veya onu çalışmaz hale getirebileceğini unutmayın.',
    'optimization-settings.pageHint' => 'Burada, kullanılmayan Apache modüllerini kapatarak Plesk\'i iyileştirebilirsiniz. Bu iyileştirme, bellek kullanımını iyileştirir ve daha fazla barındırma müşterisine servis sağlamanıza izin verir. Bazı modüllerin birbirine bağlı olduğunu ve ancak bağlı oldukları modüller kapandığında (açıldığında) kapanabileceğini (açılabileceğini) unutmayın.',
    'optimization-settings.advancedUsersOnlyWarning' => 'Bu özellik sadece gelişmiş kullanıcılar içindir.',
    'optimization-settings.apacheRestartInterval' => 'Apache restart aralığı (saniye)',
    'optimization-settings.apacheRestartIntervalHint' => 'Belirtilen bir aralığa girdikten sonra Plesk, alan adlarında ve alt alan adlarında yapılan değişiklikleri kontrol eder. Web sunucusunun yeniden başlatılmasını gerektiren değişiklikler olduğunda, Plesk Apache\'yi yeniden başlatır.',
    'optimization-settings.gracefulRestart' => 'Apache düzgünce yeniden başlatması',
    'optimization-settings.gracefulRestartHint' => 'Barındırma ayarlarını değiştirdiğiniz her defasında, sunucuda barındırılan tüm web sitelerinin onarım süresini engellemek için seçin.',
    'optimization-settings.pipedLog' => 'Borulu günlükler',
    'optimization-settings.mpmMode' => 'MPM modu',
    'optimization-settings.moduleDeprecated' => '(Kaldırılmış)',

    'personal-info.contactInfoSection' => 'Kişi bilgileri',
    'personal-info.hint' => 'Bu, kullanıcı irtibat bilgilerini düzenlediğiniz yerdir.',
    'personal-info.hintMyProfile' => 'Bu, irtibat bilgilerinizi düzenlediğiniz yerdir.',

    'php-handler.extension.title' => 'PECL paketini kur',
    'php-handler.extension.description' => "Paket adı ile ek parametreler belirterek, örneğin 'msgpack-beta', bir uzantının beta sürümünü kurabilirsiniz.",
    'php-handler.extension.name' => 'Paket adı',

    'php-handler.ini.formHint' => 'Bu php.ini dosyası sadece bu işleyici tarafından kullanılır.',
    'php-handler.ini.formHintSharedIni' => 'Bu php.ini dosyası ayrıca aşağıdaki PHP işleyicileri tarafından da kullanılır: %%handlers%%. Ayarlar, bu işleyicileri kullanan tüm web siteleri için geçerlidir.',
    'php-handler.ini.incorrectTextForIniFile' => "Belirtilen ayarlar yanlış ve php.ini dosyasına kaydedilemiyor. Hata: %%message%%.",

    'plan-item-custom.planItemName' => 'Hizmet adı',
    'plan-item-custom.buttonLabel' => 'Bu ad ayrıca özel düğme için bir etiket olarak da kullanılır.',
    'plan-item-custom.planItemDescription' => 'Servis açıklaması',
    'plan-item-custom.buttonTooltip' => 'Bu metin ayrıca özel düğme için bir araç ipucu olarak da kullanılır',
    'plan-item-custom.url' => 'Özel düğmeye bağlı URL',
    'plan-item-custom.backgroundImage' => 'Özel düğme için arka plan görüntüsü',
    'plan-item-custom.emptyItemName' => 'Lütfen servis için bir etiket girin.',
    'plan-item-custom.emptyItemDescription' => 'Lütfen araç ipucu için bir metin girin.',
    'plan-item-custom.emptyUrl' => 'Lütfen bir URL belirtin.',
    'plan-item-custom.longItemName' => 'Bu servis etiketi çok uzun. İzin verilen maksimum uzunluk, %max% simgedir.',
    'plan-item-custom.longItemDescription' => 'Bu servis metni çok uzun.  İzin verilen maksimum uzunluk, %max% simgedir.',
    'plan-item-custom.longUrl' => 'Bu URL çok uzun. İzin verilen maksimum uzunluk, %max% simgedir.',
    'plan-item-custom.useCustomButton' => 'Servis için özel düğmeyi kullanın',
    'plan-item-custom.useCustomButtonHint' => 'Kullanıcının başlangıç sayfasına ve Web sitesi sayfalarına özel bir düğme yerleştirin.',
    'plan-item-custom.openCustomButtonInSameWindow' => 'URL\'yi Plesk\'te açın',
    'plan-item-custom.openCustomButtonInSameWindowDescription' => 'URL\'yi bir Plesk sayfasında mı, yoksa yeni bir tarayıcı penceresinde mi açacağını belirtin.',
    'plan-item-custom.openCustomButtonWithoutFrame' => 'Çerçeveleri kullanmayın',
    'plan-item-custom.openCustomButtonWithoutFrameDescription' => 'Bir Plesk uzantısına veya Müşteri Paneli bir uygulamaya götüren özel bir düğme eklediğinizde, bu uzantının/uygulamanın nasıl görüntüleneceğini belirtebilirsiniz: bir çerçevede veya Plesk GUI\'sinin bir parçası olarak.',
    'plan-item-custom.includeDomId' => 'Abonelik kimliğini dahil edin',
    'plan-item-custom.includeDomIdDescription' => '&dom_id=<dom_id>',
    'plan-item-custom.includeDomName' => 'Ana alan adını dahil edin',
    'plan-item-custom.includeDomNameDescription' => '&dom_name=<dom_name>',
    'plan-item-custom.includeFtpUser' => 'FTP kullanıcı adını dahil edin',
    'plan-item-custom.includeFtpUserDescription' => '&ftp_user=<ftp_user>',
    'plan-item-custom.includeFtpPass' => 'FTP şifresini dahil edin',
    'plan-item-custom.includeFtpPassDescription' => '&ftp_pass=<ftp_pass>',
    'plan-item-custom.includeClId' => 'Müşteri kimliğini dahil edin',
    'plan-item-custom.includeClIdDescription' => '&cl_id=<cl_id>',
    'plan-item-custom.includeCname' => "Müşterinin şirket adını dahil edin",
    'plan-item-custom.includeCnameDescription' => '&cname=<cname>',
    'plan-item-custom.includePname' => "Müşterinin kişi adını dahil edin",
    'plan-item-custom.includePnameDescription' => '&pname=<pname>',
    'plan-item-custom.includeEmail' => "Müşterinin e-postasını dahil edin",
    'plan-item-custom.includeEmailDescription' => '&email=<email>',

    'preview-domain-settings.previewType' => 'Web sitelerinin ön izlemesinin nasıl yapılacağını seçin',
    'preview-domain-settings.previewQuick' => 'Varsayılan Hızlı Ön İzleme',
    'preview-domain-settings.previewDisabled' => 'Hızlı Ön İzlemeyi Devre Dışı Bırak',
    'preview-domain-settings.previewQuickDescription' => 'Kutudan çıktığı haliyle çalışan bir önerilen seçenek.',
    'preview-domain-settings.previewZoneTypeInternal' => 'Plesk\'teki bir alan adındaki Hızlı Ön İzleme',
    'preview-domain-settings.previewZoneDomainIdDescription' => 'Ön izlemede kullanılması için, Plesk\'in desteklediği web sitelerinizden birini seçin.',
    'preview-domain-settings.previewZoneDomainCreate' => 'Bu özelliği kullanmak için, en az bir alan adında %%link%% bağlantısı oluşturun.',
    'preview-domain-settings.subscriptionCreateLink' => 'oluşturma',
    'preview-domain-settings.previewZoneTypeExternal' => 'Harici bir alan adındaki Hızlı Ön İzleme',
    'preview-domain-settings.previewZoneDomainNameDescription' => 'Harici bir alan adı (DNS bölgesi) kullanın. Bu seçeneği kullanıyorsanız, aşağıdaki DNS kaydını (tip A) harici alan adı bölgesine ekleyin: *.<Plesk_IP>.harici.dom. Burada <Plesk_IP>, Plesk sunucusunun IP\'si olup, noktalar (.) IPv4 veya IPv6 için iki nokta üst üste (:) yerine çizgiler (-) gelir. Örneğin *.192-0-2-12.harici.dom. Plesk\'in birden fazla kayıtlı IP\'si varsa, her adres için bir kayıt ekleyin.',
    'preview-domain-settings.sitePreviewProtection' => 'Kimlik doğrulama gerektir',
    'preview-domain-settings.sitePreviewProtectionDescription' => 'Ön izlemeye erişmek için FTP oturum açması ve şifre isteyin.',
    'preview-domain-settings.nginxNotInstalled' => 'Varsayılan Hızlı Ön İzleme kullanılamaz, çünkü nginx web sunucusu yüklü değil.',
    'preview-domain-settings.nginxDisabled' => 'Varsayılan Hızlı Ön İzleme kullanılamaz, çünkü nginx web sunucusu devre dışı.',

    'reseller-preferences.settingsSection' => 'Ayarlar',
    'reseller-preferences.multiLogin' => 'Çoklu oturumlara müsaade et',
    'reseller-preferences.language' => 'Arayüz dili',
    'reseller-preferences.interfaceView' => 'Arayüzünüzü seçin',
    'reseller-preferences.serviceProviderView' => 'Servis Sağlayıcısı görünümü',
    'reseller-preferences.serviceProviderViewHint' => 'Bu görünüm, servis planlarını kullanan müşterilerine web barındırma servisleri sağlayan ve satan sunucu yöneticileri içindir.',
    'reseller-preferences.powerUserView' => 'Power User görünümü',
    'reseller-preferences.powerUserViewHint' => 'Bu görünüm web sitelerini, dosyalarını, veritabanlarını, e-posta hesaplarını, web uygulamalarını ve diğer servisleri yönetmek için en uygundur.',

    'reseller.hint' => 'Bu, barındırma servislerinize yeni bir satıcı kaydettiğiniz yerdir.',
    'reseller.contactInfoSection' => 'Kişi Bilgileri',
    'reseller.contactInfoSectionHint' => 'Satıcının irtibat bilgilerini girin.',
    'reseller.accessToPanelSection' => 'Plesk\'e erişim',
    'reseller.accessToPanelSectionHint' => 'Satıcının kaydolduğu servisleri yönetmek için Plesk\'e erişmek için kullanacağı kimlik bilgileri.',
    'reseller.subscription' => 'Abonelik',
    'reseller.subscriptionSectionHint' => 'Satıcının abone olacağı bir servis planı seçin.',
    'reseller.servicePlan' => 'Servis Planı',
    'reseller.none' => 'hiçbiri',
    'reseller.customizeSubscription' => 'Satıcı oluşturulduktan sonra, aboneliğin parametrelerini özelleştirmeye devam edin. Bunu yaptığınızda aboneliğin senkronizasyon için kilitleneceğini unutmayın.',
    'reseller.subscriptionNotSynchronized' => 'Abonelik, servis planıyla senkronize edilemedi. Aboneliğin aşağıdaki ayarları, servis planıyla çakışıyor: %%problems%%.',

    'security-policy.encryptionSection' => 'Gelişmiş güvenlik modu',
    'security-policy.encryptionSectionHint' => 'Gelişmiş güvenlik modu, Plesk\'teki hassas verilerinin gelişmiş korumasını tanıtır. Bu modda Plesk, Plesk kullanıcıları için kesinlikle saydam olan birden fazla güvenlik mekanizması kullanır. Plesk güvenliğini artırmak için, modu açmanız önerilir.',
    'security-policy.encryptionEnable' => 'Gelişmiş güvenlik modu',
    'security-policy.securePassword' => 'Gelişmiş güvenlik modu',
    'security-policy.strengthSection' => 'Şifre güvenlik düzeyi',
    'security-policy.strengthSectionHint' => 'Kullanıcıların Plesk\'te ayarlayabileceği veya değiştirebileceği çoğu şifre, burada belirlenen minimum şifre güvenlik düzeyi gereksinimlerini karşıladığından emin olmak için doğrulanır. Güçlü şifreler en az 9-12 karakter uzunluğundadır ve rakamlar, büyük ve küçük harfler, özel karakterler içerir ve anlamlı kelimeler içermez. Bu şifrelerin tahmin edilmesi zordur ama aynı zamanda hatırlanmaları da zordur. <a href="%%link%%" target="_blank"> Şifre güvenlik düzeyi ile ilgili daha fazla bilgi alın</a>.',
    'security-policy.passwordStrength' => 'Minimum şifre güvenlik düzeyi',
    'security-policy.secureFtpSection' => 'Güvenli FTP',
    'security-policy.ftpOverSsl' => 'FTPS kullanım ilkesi',
    'security-policy.ftpOverSslHint' => 'FTPS, SSL/TLS iletişim kurallarını kullanarak FTP sunucusuyla harici FTP istemcileri arasındaki iletişimi korumak için kullanılır. Burada, hangi bağlantı türlerine izin verileceğini seçebilirsiniz.',
    'security-policy.ftpOverSslWithCustomOptionHint' => 'FTPS, SSL/TLS iletişim kurallarını kullanarak FTP sunucusuyla harici FTP istemcileri arasındaki iletişimi korumak için kullanılır. Burada, hangi bağlantı türlerine izin verileceğini seçebilirsiniz. Seçilen seçenek, sunucudaki tüm IP adreslerine uygulanır. IP adresi başına özel ayarlar kullanmak için, ilgili seçeneği seçin ve sonra Araçlar ve Ayarlar> IP Adresleri altında FTPS ilkesini değiştirin.',
    'security-policy.ftpOverSslCustomHint' => 'FTPS, SSL/TLS iletişim kurallarını kullanarak FTP sunucusuyla harici FTP istemcileri arasındaki iletişimi korumak için kullanılır.',
    'security-policy.ftpOverSslCustomDisabledHint' => 'FTPS, SSL/TLS iletişim kurallarını kullanarak FTP sunucusuyla harici FTP istemcileri arasındaki iletişimi korumak için kullanılır. IP adresi başına FTPS ayarlarını ayarlamak istiyorsanız, önce Araçlar ve Ayarlar> Güvenlik İlkesi> Güvenli FTP altından "IP adresi başına özel FTPS ayarlarını kullanın" seçeneğini seçin.',
    'security-policy.ftpOverSslOptionRequired' => 'Sadece güvenli FTPS bağlantılarına izin verin',
    'security-policy.ftpOverSslOptionEnabled' => 'Güvenli FTPS ve güvenli olmayan FTP bağlantılarına izin verin',
    'security-policy.ftpOverSslOptionDisabled' => 'Sadece güvenli olmayan FTP bağlantılarına izin verin. FTPS\'yi kullanmayın',
    'security-policy.ftpOverSslOptionCustom' => 'IP adresi başına özel FTPS ilkesi kullanın',
    'security-policy.prohibitWebConfigHandlersSection' => 'Özel işleyiciler ilkesi',
    'security-policy.prohibitWebConfigHandlersSectionHint' => 'Müşterilerin web.config dosyasıyla sunucu seviyesinde tanımlanan IIS işleyicilerini baypas etmesini önlemek için bu seçeneği etkinleştirin.',
    'security-policy.prohibitWebConfigHandlers' => 'web.config ile işleyicileri geçersiz kılma yeteneğini engelleyin',

    'server-mail-antivirus.used' => 'Kullanılan antivirüs',
    'server-mail-antivirus.policy' => 'Sunucu genel Ayarlarını kullan',
    'server-mail-antivirus.policyOff' => 'Tarama kapatıldı',
    'server-mail-antivirus.policyAny' => 'Hem gelen hem de giden postaları tara',
    'server-mail-antivirus.policyFrom' => 'Yalnızca giden postaları tara',
    'server-mail-antivirus.policyTo' => 'Yalnızca gelen postaları tara',
    'server-mail-antivirus.allowPersonalSettings' => 'Kişisel ayarlara izin verin',
    'server-mail-antivirus.incoming' => 'gelen postalar için',
    'server-mail-antivirus.outgoing' => 'giden postalar için',
    'server-mail-antivirus.success' => 'Antivirüs ayarları değiştirildi.',

    'server-mail-black-list.title' => 'Alan adını Kara Listeye ekleyin',
    'server-mail-black-list.domainName' => 'Alan adı',
    'server-mail-black-list.emailAddress' => 'E-posta adresleri',
    'server-mail-black-list.emailAddressHint' => '@ işaretinin solunda hiçbir ASCII dışı karakter kalmamalıdır. Adresler "*" ve "?" jokerlerini içerebilir (örneğin *@alan adı.com, kullanıcı?@*.com). Alan adlarının ASCII dışı bölümlerinin joker içermemesi gerekir.',
    'server-mail-black-list.action' => 'Kriterlere uygun postayla ne yapılmalı:',
    'server-mail-black-list.actionDelete' => 'Sunucudan silin',
    'server-mail-black-list.actionSpam' => 'İstenmeyen posta olarak işaretle',
    'server-mail-black-list.success' => 'Alan adı kara listeye eklendi.',

    'server-mail-white-list.title' => 'Ağı Beyaz Listeye ekleyin',
    'server-mail-white-list.descEmailAddress' => 'Burada belirtilen e-posta adresleri, SpamAssassin tarafından gereksiz olarak tanınmayacaktır.',
    'server-mail-white-list.descIpAddress' => 'Burada belirtilen IP girdileri posta sunucusu istisnalarına eklenecektir.',
    'server-mail-white-list.ipAddress' => 'IP Adresi/maske',
    'server-mail-white-list.ipAddressHint' => 'IP adresi joker veya CIDR maskesi içerebilir.',
    'server-mail-white-list.emailAddress' => 'E-posta adresleri',
    'server-mail-white-list.emailAddressHint' => '@ işaretinin solunda hiçbir ASCII dışı karakter kalmamalıdır. Adresler "*" ve "?" jokerlerini içerebilir (örneğin *@alan adı.com, kullanıcı?@*.com). Alan adlarının ASCII dışı bölümlerinin joker içermemesi gerekir.',
    'server-mail-white-list.emailAddressOrIp' => 'E-posta veya IP adresleri',
    'server-mail-white-list.wildcardPattern' => 'IP adresleri joker içerebilir (örneğin: 123.123.*.123).',
    'server-mail-white-list.cidrPattern' => 'IP adresleri CIDR maskeleri içerebilir (örneğin: 10.0.0.0/8).',
    'server-mail-white-list.success' => 'Ağ, beyaz listeye eklendi.',

    'server-mail-settings.general.title' => 'Genel seçenekler',
    'server-mail-settings.general.mailUiEnabled' => 'Plesk\'teki posta yönetim işlevlerini etkinleştirin',
    'server-mail-settings.general.serverName' => 'Posta sunucusu kuruldu',
    'server-mail-settings.general.changeServerName' => 'başka bir posta sunucusunu kurun ve yönetin',
    'server-mail-settings.general.imapServerName' => 'Yüklü IMAP/POP3 sunucusu',
    'server-mail-settings.general.changeImapServerName' => 'başka bir IMAP/POP3 sunucusunu kurun ve kullanın',
    'server-mail-settings.general.changeServerHint' => '%%serverChangeLink%% yapabilirsiniz',
    'server-mail-settings.general.maxMessageSize' => 'Maksimum mesaj boyutu',
    'server-mail-settings.general.kbytes' => 'Kilobayt',
    'server-mail-settings.general.maxConnections' => 'Maksimum bağlantı sayısı (IMAP, POP3, SSL/TLS üzerinden IMAP veya SSL/TLS üzerinden POP3)',
    'server-mail-settings.general.maxConnectionsHintCourier-IMAP' => 'Başlatılan maksimum sunucu (IMAP veya POP3) sayısı.',
    'server-mail-settings.general.maxConnectionsHintDovecot' => 'Aynı anda oturum açabilen maksimum posta kullanıcısı sayısı.',
    'server-mail-settings.general.maxConnectionsPerIpCourier-IMAP' => 'IP adresi başına maksimum bağlantı sayısı',
    'server-mail-settings.general.maxConnectionsPerIpDovecot' => 'IP adresi başına kullanıcı için maksimum bağlantı sayısı',
    'server-mail-settings.general.maxConnectionsPerIpHintCourier-IMAP' => 'Aynı IP adresinden kabul edilecek maksimum bağlantı sayısı (IMAP, POP3, SSL/TLS üzerinden IMAP veya SSL/TLS üzerinden POP3).',
    'server-mail-settings.general.maxConnectionsPerIpHintDovecot' => 'Her IP adresinden bir posta kullanıcısı için izin verilen maksimum bağlantı sayısı (IMAP, POP3, SSL/TLS üzerinden IMAP veya SSL/TLS üzerinden POP3).',
    'server-mail-settings.general.messageSubmission' => 'Bağlantı noktası 587 üzerinde SMTP hizmetini etkinleştirin',
    'server-mail-settings.general.messageSubmissionOnAllIp' => 'Tüm IP adreslerindeki bağlantı noktası 587 üzerinde SMTP hizmetini etkinleştirin',
    'server-mail-settings.general.messageSubmissionBindTo' => 'Açık',
    'server-mail-settings.general.messageSubmissionAllIpAddresses' => 'tüm IP adresleri',
    'server-mail-settings.general.outgoingEmailMode' => 'Giden posta modu',
    'server-mail-settings.general.outgoingEmailModeDomainIp' => 'Alan adı IP adreslerinden gönderin',
    'server-mail-settings.general.outgoingEmailModeDomainName' => 'Alan adının IP adreslerinden gönderin ve SMTP selamlamasında alan adlarını kullanın',
    'server-mail-settings.general.outgoingEmailModeExplicitIp' => 'Belirtilen IP adreslerinden gönderin',
    'server-mail-settings.general.outgoingEmailModeExplicitIpV4' => 'IPv4',
    'server-mail-settings.general.outgoingEmailModeExplicitIpV6' => 'IPv6',
    'server-mail-settings.general.outgoingEmailModeExplicitIpNone' => 'Hiçbiri',
    'server-mail-settings.general.subaddressing' => 'E-posta alt adreslemeyi etkinleştir',
    'server-mail-settings.general.subaddressingHint' => 'Bu seçenek, posta listeleri için %%verpStyleLink%% yapılandırma yeteneğini etkinleştirir',
    'server-mail-settings.general.verpStyleLink' => 'VERP tarzı',
    'server-mail-settings.general.mboxQuotaWarning' => 'Posta kutusu kota uyarısını özelleştirin',
    'server-mail-settings.general.mboxQuotaWarningHint' => 'Posta kutusu kotası kullanımı %95\'i aştığında kullanıcılara bir bildirim postası gönderin',
    'server-mail-settings.general.mboxQuotaWarningChange' => 'Varsayılan posta kutusu kota uyarısını özelleştirin',
    'server-mail-settings.general.fixSender' => 'Giden postalar için yanlış ayarlanmış göndereni düzeltin',
    'server-mail-settings.general.fixSenderHint' => 'Gereksiz klasörüne düşme ihtimalini azaltmak için alan adından giden postalara geçerli bir otomatik e-posta başlığı ve gönderici mektup adresi ekleyin.',

    'server-mail-settings.autodiscover.title' => 'Otomatik posta bulma',
    'server-mail-settings.autodiscover.description' => 'Nasıl çalıştığını görmek için bakın %%link%%',
    'server-mail-settings.autodiscover.link' => 'bilgi tabanı',
    'server-mail-settings.autodiscover.enabled' => 'Postayı otomatik olarak bulmayı etkinleştir',
    'server-mail-settings.autodiscover.enabledHint' => 'Bu özelliğin etkinleştirilmesi, otomatik bulma özelliği etkin olan tüm alan adlarını yeniden yapılandırır.',
    'server-mail-settings.autodiscover.customServer' => 'Otomatik posta bulma için özel bir alan adı belirtin',
    'server-mail-settings.autodiscover.customServerHint' => 'Not: Alan adı geçerli bir SSL/TLS sertifikası ile emniyete alınmalıdır.',
    'server-mail-settings.autodiscover.reconfigureDns' => 'Otomatik bulma DNS kayıtlarını yeniden yapılandırın',
    'server-mail-settings.autodiscover.reconfigureDnsHint' => 'Bu özelliğin etkinleştirilmesi, otomatik bulma etkin olan tüm etki alanlarının otomatik bulma DNS kayıtlarını yeniden yapılandırır',

    'server-mail-settings.relay.title' => 'Yedek seçenekler',
    'server-mail-settings.relay.type' => "Relay",
    'server-mail-settings.relay.open' => "açık",
    'server-mail-settings.relay.openSpamWarning' => "Posta rölenizi açmanız, posta sunucunuzu gereksiz e-postalara açık hale getirir.",
    'server-mail-settings.relay.openSpamChange' => "Ayarı yalnızca posta sunucusunu geçici olarak test etmek istiyorsanız veya Plesk sunucunuz İnternet üzerinden erişilemeyen dahili ağ içindeyse koruyun.",
    'server-mail-settings.relay.closed' => "kapalı",
    'server-mail-settings.relay.auth' => "Kimlik doğrulaması gerekiyor:",
    'server-mail-settings.relay.notSupported' => "posta sunucusu tarafından desteklenmiyor",
    'server-mail-settings.relay.change' => 'İletme kapalı olduğunda Plesk\'in bildirim göndermesini sağlamak için bunu yapabilirsiniz: %%changeLink%%',
    'server-mail-settings.relay.changeLink' => 'SMTP ayarlarını değiştir',
    'server-mail-settings.relay.pop3' => "SMTP'den önce POP3",
    'server-mail-settings.relay.lockTime' => "kilit süresi",
    'server-mail-settings.relay.min' => "Min",
    'server-mail-settings.relay.smtp' => "SMTP",
    'server-mail-settings.relay.noRelayNetworks' => 'Aşağıdaki ağlar için yedek kısıtlamalar kullanma:',
    'server-mail-settings.relay.noRelayNetworksHint' => "IP Adresi/maske",

    'server-mail-settings.outgoing.title' => 'Giden e-posta mesajlarındaki sınırlamalar',
    'server-mail-settings.outgoing.description' => 'Aşağıdaki sınırlar varsayılandır. Bunlar her hizmet planında ve abonelikte geçersiz kılınabilir. Sınırlar, sunucu çapında çalışmaz, ancak hiçbir özel sınır belirtilmemiş olan plan ve aboneliklerin bir şablonu olarak çalışır. Giden e-posta mesajı sınırını açmanın posta sunucusunun performansını etkileyebileceğini unutmayın. %%link%%',
    'server-mail-settings.outgoing.learnMore' => 'Giden postaları sınırlama hakkında daha fazla bilgi öğren',
    'server-mail-settings.outgoing.enabled' => 'Giden e-posta mesajlarındaki sınırlamaları açın',
    'server-mail-settings.outgoing.countRecipients' => 'Mesajlar yerine birkaç alıcıyı sayın',
    'server-mail-settings.outgoing.countRecipientsHint' => 'Giden postayı sınırlandırırken ve istatistikleri sayarken iletiler yerine alıcıları sayan modu etkinleştirir. Örneğin, 10 alıcıya gönderilen bir mesaj, on mesaj olarak sayılacaktır.',
    'server-mail-settings.outgoing.mailboxLimit' => 'Bir posta kutusundan giden mesajların varsayılan sınırı (saatte)',
    'server-mail-settings.outgoing.domainLimit' => 'Bir alan adından giden mesajların varsayılan sınırı (saatte)',
    'server-mail-settings.outgoing.subscriptionLimit' => 'Bir abonelikten giden mesajların varsayılan sınırı (saatte)',
    'server-mail-settings.outgoing.unlimited' => 'Sınırsız',
    'server-mail-settings.outgoing.sendmail' => 'Komut dosyalarının ve kullanıcıların Sendmail kullanmasına izin verin',
    'server-mail-settings.outgoing.sendmailHint' => 'Komut dosyaları ve kullanıcılar, Sendmail kullanarak, bir posta kutusu ve alan adı sınırları aşıldığında bile (aboneliğin sistem kullanıcısı adına) Eposta mesajları gönderebilecektir. Sendmail ile gönderilebilecek maksimum mesaj sayısı, bütün bir aboneliğin sınırıyla tanımlanır. Bu ayar, komut dosyalarının Sendmail\'i sunucu çapında kullanmasına izin vermez, ancak servis planları ve abonelikler için varsayılan bir ayar olarak davranır.',
    'server-mail-settings.outgoing.reportPeriod' => 'Aşağıdaki son istatistiklere dayalı olarak raporları gösterin',
    'server-mail-settings.outgoing.reportPeriodHint' => 'Raporlar oluşturulur ve ihbar, belirtilen dönem sırasında giden posta sınırlarını aşma denemeleri hakkındaki Başlangıç sayfasında gösterilir.',
    'server-mail-settings.outgoing.notificationPeriod' => 'Bir e-posta ihbarı gönderme sıklığı',
    'server-mail-settings.outgoing.notificationPeriodHint' => 'İhbarlar, belirtilen dönem sırasında giden posta sınırlarını aşma denemeleri hakkında istatistikler sunar.',
    'server-mail-settings.outgoing.periodP1D' => '1 Gün',
    'server-mail-settings.outgoing.periodP1W' => '1 Hafta',
    'server-mail-settings.outgoing.periodP2W' => '2 hafta',
    'server-mail-settings.outgoing.periodP1M' => '1 ay',
    'server-mail-settings.outgoing.periodPT15M' => '15 dakika',
    'server-mail-settings.outgoing.periodPT1H' => '1 saat',
    'server-mail-settings.outgoing.periodPT6H' => '6 saat',
    'server-mail-settings.outgoing.periodPT12H' => '12 Saat',
    'server-mail-settings.outgoing.whiteListNotEmpty' => 'Giden posta sınırları, IP adresleri posta sunucusunun beyaz listesinde bulunan posta gönderenleri için geçerli olmaz. Örneğin beyaz listede localhost (127.0.0.0 / 8, ::1 / 128) olduğunda, sınırlamalara bakılmaksızın, yerel sunucudaki tüm postalar başarıyla gönderilir. Posta gönderenleri, ya yerel (yerel sunucuda barındırılan web siteleri ve özel komut dosyaları), ya da harici IP adreslerini (bilgisayarlarına veya mobil cihazlarına kurulu posta istemcilerinden posta gönderen müşteriler) kullanabilir. Sınırların (hem yerel, hem de harici) tüm posta gönderenleri için geçerli olması için, beyaz listedeki tüm IP adreslerini ve ağları kaldırın. Beyaz listeden localhost\'un (127.0.0.0 / 8, ::1 / 128) kaldırılmasının, bu sunucudan posta gönderen web sitelerinin ve komut dosyalarının çalışmasını bozabileceğini unutmayın. Giden postadaki sınırlamalar hakkındaki ayrıntılar için, Yönetici Kılavuzunda, Giden Gereksiz Postadan Korunma altına bakın.',
    'server-mail-settings.outgoing.relayIsOpen' => 'Posta iletme açıktır: Giden posta sınırları geçerli olmaz.',
    'server-mail-settings.outgoing.domainLimitExceedsSubscriptionLimit' => 'Bir alan adının giden mesajlarının sınırı (%%value%%), bir abonelik (%%highLevelLimitValue%%) sınırından büyük olamaz.',
    'server-mail-settings.outgoing.mailboxLimitExceedsDomainLimit' => 'Bir Eposta adresinin giden mesajlarının sınırı (%%value%%), bir alan adı (%%highLevelLimitValue%%) sınırından büyük olamaz.',
    'server-mail-settings.outgoing.mailboxLimitExceedsSubscriptionLimit' => 'Bir e-posta adresinin (%%value%%) giden mesajlarının sınırı, bir abonelik (%%highLevelLimitValue%%) sınırından büyük olamaz.',

    'server-mail-settings.mailman.title' => 'Mailman ayarları',
    'server-mail-settings.mailman.secureLinks' => 'Posta listelerinde güvenli bağlantılar kullan',
    'server-mail-settings.mailman.secureLinksHint' => 'Posta listelerinde güvenli (HTTPS) bağlantısı oluşturmayı etkinleştirin ya da devre dışı bırakın.',
    'server-mail-settings.mailman.noLocalhost' => 'Postalama listesini kullanmak için, (127.0.0.0/8, ::1/128) localhost\'unuzun posta sunucusunun beyaz listesinde olması gerekir. Ancak giden posta kontrolünü kullanmak için, localhost\'un beyaz listede olmaması gerekir. Ödün vermek için, giden posta kontrolünü etkinleştirdiğinizde, postalama listesi yerine posta kutusuna posta iletmeyi kullanabilirsiniz.',
    'server-mail-settings.mailman.noLocalhostIpv4' => 'Postalama listesini kullanmak için, localhost\'unuzun posta sunucusunun beyaz listesinde olması gerekir. Ancak giden posta kontrolünü kullanmak için, localhost\'un beyaz listede olmaması gerekir. Ödün vermek için, giden posta kontrolünü etkinleştirdiğinizde, postalama listesi yerine posta kutusuna posta iletmeyi kullanabilirsiniz. Şu an beyaz listede hiçbir (127.0.0.0/8) IPv4 yerel ana bilgisayar adresi olmadığını, dolayısıyla giden posta kontrolünün IPv4 adresleri için çalışmayacağını unutmayın.',
    'server-mail-settings.mailman.noLocalhostIpv6' => 'Postalama listesini kullanmak için, localhost\'unuzun posta sunucusunun beyaz listesinde olması gerekir. Ancak giden posta kontrolünü kullanmak için, localhost\'un beyaz listede olmaması gerekir. Ödün vermek için, giden posta kontrolünü etkinleştirdiğinizde, postalama listesi yerine posta kutusuna posta iletmeyi kullanabilirsiniz. Şu an beyaz listede hiçbir (::1/128) IPv6 yerel ana bilgisayar adresi olmadığını, dolayısıyla giden posta kontrolünün IPv6 adresleri için çalışmayacağını unutmayın.',

    'server-mail-settings.spam-filter.dmarc' => 'DMARC',
    'server-mail-settings.spam-filter.dmarcEnabled' => 'Gelen postayı kontrol etmek için, DMARC\'yi etkinleştirin',
    'server-mail-settings.spam-filter.dmarcHint' => 'Bu seçenek, DKIM ve SPF gelen postalar için açıksa kullanılabilir.',
    'server-mail-settings.spam-filter.dkim' => 'DKIM gereksiz posta koruması',
    'server-mail-settings.spam-filter.singOutgoing' => 'Giden postayı imzalamaya izin verin',
    'server-mail-settings.spam-filter.verifyIncoming' => 'Gelen postayı doğrula',
    'server-mail-settings.spam-filter.verifyIncomingHint' => 'DMARC, gelen posta için açıkken bu seçenek kapatılamaz.',
    'server-mail-settings.spam-filter.spf' => 'SPF gereksiz posta koruması',
    'server-mail-settings.spam-filter.spfEnabled' => 'Gelen postayı kontrol etmek için, SPF gereksiz posta korumasını etkinleştirin',
    'server-mail-settings.spam-filter.spfEnabledHint' => 'DMARC, gelen posta için açıkken bu seçenek kapatılamaz.',
    'server-mail-settings.spam-filter.ignoreErrors' => 'DNS arama sorunları olduğunda SPF kontrolü devam eder',
    'server-mail-settings.spam-filter.ignoreErrorsHint' => 'Önce SPF bir DNS araması gerçekleştirir. DNS araması başarısız olduğunda, kontrol etmeye devam etmek için bu seçeneği seçin. Geçerli kontrol modunda hiçbir etkisi olmadığında, bu seçenekteki seçim silinir.',
    'server-mail-settings.spam-filter.behavior' => 'SPF kontrol modu',
    'server-mail-settings.spam-filter.behaviorHint' => 'Sonra SPF, yerel ve misafir kurallarını uygular. Mesaj, seçilen kontrol moduna ve kontrol sonucuna bağlı olarak reddedilebilir.',
    'server-mail-settings.spam-filter.behaviorCreateHeadersNoBlock' => 'Sadece Alınan SPF başlıkları oluşturun, asla engellemeyin',
    'server-mail-settings.spam-filter.behaviorUseTmpErrors' => 'DNS arama sorunlarınız olduğunda, geçici hata bildirimlerini kullanın',
    'server-mail-settings.spam-filter.behaviorRejectIfFail' => 'SPF "başarısız" (reddet) olarak çözümlendiğinde postayı reddedin',
    'server-mail-settings.spam-filter.behaviorRejectIfSoftfail' => 'SPF "yumuşak başarısız" olarak çözümlendiğinde postayı reddedin',
    'server-mail-settings.spam-filter.behaviorRejectIfNeutral' => 'SPF "tarafsız" olarak çözümlendiğinde postayı reddedin',
    'server-mail-settings.spam-filter.behaviorRejectIfNoPass' => 'SPF "geçti" olarak çözümlenmediğinde postayı reddedin',
    'server-mail-settings.spam-filter.localRules' => 'SPF yerel kuralları',
    'server-mail-settings.spam-filter.guessRules' => 'SPF tahmin kuralları',
    'server-mail-settings.spam-filter.explanationText' => 'SPF açıklama metni',
    'server-mail-settings.spam-filter.rbl' => "DNS kara delik listesine dayalı gereksiz posta koruması",
    'server-mail-settings.spam-filter.rblEnabled' => "DNS kara delik listesine dayalı gereksiz posta korumayı açın",
    'server-mail-settings.spam-filter.rblServer' => "DNSBL servisi için DNS bölgeleri",
    'server-mail-settings.spam-filter.rblServerHint' => "Kayıtları bir noktalı virgülle ayırın, örneğin: 'zen.spamhaus.org;dnsbl.example.net'",

    'server-mail-settings.auto-reply-headers.title' => 'Ekstra otomatik cevap başlıkları',
    'server-mail-settings.auto-reply-headers.description' => 'Plesk sunucusundan gelen otomatik cevap mesajı için ekstra başlıklar ayarlayın.',
    'server-mail-settings.auto-reply-headers.extra' => 'Ekstra başlıklar',

    'server-mail-settings.pop3-names.title' => "POP3/IMAP hesap adları",
    'server-mail-settings.pop3-names.disabled' => "POP3/IMAP posta hesaplarının sadece tam adları kullanılabilir",
    'server-mail-settings.pop3-names.enabled' => "POP3/IMAP posta hesaplarının kısa (webmaster) ve tam (webmaster@alan_adı.com) adları kullanılabilir.",

    'server-mail-settings.success' => 'Posta sunucusu ayarları değiştirildi.',

    'server-mail-spam-filter.general' => 'Genel',
    'server-mail-spam-filter.isEnabled' => 'Sunucu çapında SpamAssassin gereksiz posta filtrelemesini açın',
    'server-mail-spam-filter.isUserSettingsEnabled' => 'Gereksiz posta filtrelemeye bireysel ayarları uygulayın',
    'server-mail-spam-filter.isUserSettingsEnabledHint' => "Gereksiz Posta Filtresi kapalı: posta sunucusu posta kutusu seviyesindeki gereksiz posta filtre ayarlarını desteklemez.",
    'server-mail-spam-filter.settings' => 'SpamAssassin Ayarları',
    'server-mail-spam-filter.requiredHits' => 'Bir mesajın gereksiz posta kabul edilmesi için alması gereken puan',
    'server-mail-spam-filter.maxMailLimit' => 'Posta boyutu bu değeri aşarsa filtreleme',
    'server-mail-spam-filter.maxMailLimitText' => 'boyut sınırı',
    'server-mail-spam-filter.kbytes' => "Kilobayt",
    'server-mail-spam-filter.maxThreadsLimit' => 'İstenmeyen posta filtresinin oluşturabileceği iş parçacıları sayısı',
    'server-mail-spam-filter.tag' => 'Gereksiz mesaj olarak algılanan her mesajın konusunun başına aşağıdaki metni ekleyin',
    'server-mail-spam-filter.byTag' => 'etikete göre',
    'server-mail-spam-filter.alarmMessage' => 'Spam algılama uyarı metni',
    'server-mail-spam-filter.languages' => 'Güvenilir diller',
    'server-mail-spam-filter.locales' => 'Seçili yerel ayarlar',
    'server-mail-spam-filter.success' => 'Gereksiz posta filtresi ayarları değiştirildi.',

    'service-instance.setup-instance.resourcesSection' => 'Servis Kaynakları',
    'service-instance.setup-instance.requiredServiceAlreadyInstalled' => 'Daha önce yüklenenler',
    'service-instance.setup-instance.requirementsSection' => 'Gerekli Hizmetler',
    'service-instance.setup-instance.requiredServiceNotSelected' => 'Seçili değil',

    'service-node.ipAddress' => 'Servis düğümü IP adresi',
    'service-node.ipAddressLocal' => 'Yerel servis düğümü',
    'service-node.description' => 'Servis düğümü açıklaması',
    'service-node.accessKey' => 'Şifre',
    'service-node.useAccessKey' => 'Kimlik doğrulaması kullan',
    'service-node.useAccessKeyDescription' => 'Doğrulamayı kullanma hakkındaki ipucu.',
    'service-node.oldAccessKey' => 'Eski şifre',
    'service-node.newAccessKey' => 'Yeni şifre',
    'service-node.noAccessKeySpecified' => 'Şifre belirtilmemiş',

    'service-plan.admin-plan.subscription_section' => 'Genel',
    'service-plan.admin-plan.tools_section' => 'Araçlar ve Kaynaklar',
    'service-plan.admin-plan.apps_section' => 'Uygulamalar ve Veritabanları',
    'service-plan.admin-plan.panel_section' => 'Plesk',
    'service-plan.admin-plan.appearance_section' => 'Plesk Görünümü',
    'service-plan.admin-plan.statistics_section' => 'İstatistikler',
    'service-plan.admin-plan.general_section' => 'Genel',
    'service-plan.admin-plan.mail_section' => 'Posta',
    'service-plan.admin-plan.server_section' => 'Sunucu',
    'service-plan.admin-plan.modules_section' => 'Uzantılar',
    'service-plan.admin-plan.troubleshooting_section' => 'Destek ve Sorun Giderme',
    'service-plan.admin-plan.simplePanel' => 'Sınırlı Mod',
    'service-plan.admin-plan.enabled' => 'Sınırlı Modu Etkinleştir',
    'service-plan.admin-plan.enabledDescription' => 'Yöneticinin Plesk\'te yapabileceği eylem sayısını sınırlandırmak için bu seçeneği seçin.',
    'service-plan.admin-plan.aliasEnabledDescription' => 'Ek yöneticinin Plesk\'te yapabileceği eylem sayısını sınırlandırmak için bu seçeneği seçin.',

    'service-plan.applications-subscription.useFilterLabel' => 'Sadece seçtiğim uygulamaları sunun',
    'service-plan.applications-subscription.useFilterDescription' => 'Abone tarafından kullanılabilir olmasını istediğiniz uygulamaları seçmek için bu seçeneği kullanın.',
    'service-plan.applications-subscription.applications' => 'Başvurular',
    'service-plan.applications-subscription.isCommercial' => 'Bu uygulama paralıdır ve bir lisans anahtarı satın almayı gerektirir.',

    'service-plan.applications.useFilterLabel' => 'Sadece seçtiğim uygulamaları sunun',
    'service-plan.applications.useFilterDescription' => 'Aboneler tarafından kullanılabilir olmasını istediğiniz uygulamaları seçmek için bu seçeneği kullanın.',
    'service-plan.applications.applications' => 'Başvurular',
    'service-plan.applications.isCommercial' => 'Bu uygulama paralıdır ve bir lisans anahtarı satın almayı gerektirir.',

    'service-plan.dns.dnsZoneType' => 'Alan adı DNS bölgesi',
    'service-plan.dns.dnsZoneTypeMaster' => 'Birincil',
    'service-plan.dns.dnsZoneTypeSlave' => 'İkincil',

    'service-plan.extras.groupOtherServices' => 'Diğer Hizmetler',
    'service-plan.extras.none' => 'Hiçbiri',

    'service-plan.hosting.enablePhysicalHosting' => 'Barındırmayı etkinleştirin',
    'service-plan.hosting.sectionCoreHosting' => 'Genel Özellikler',
    'service-plan.hosting.sectionScripting' => 'Komut Dosyası',
    'service-plan.hosting.defaultDatabaseServer' => 'Varsayılan Veritabanı Sunucusu',
    'service-plan.hosting.versionCut' => 'v%%version%%',
    'service-plan.hosting.sectionAdvanced' => 'Gelişmiş',
    'service-plan.hosting.phpSettingsHelpLink' => 'En uygun PHP ayarlarını nasıl seçebileceğinizi öğrenin',
    'service-plan.hosting.unpaidWebsiteStatusLabelSubscription' => 'Bu abonelik askıya alındığında web sitelerinin durumu',
    'service-plan.hosting.unpaidWebsiteStatusLabel' => 'Askıya alınan aboneliklerdeki web sitelerinin durumu',
    'service-plan.hosting.unpaidWebsiteStatusDescription' => 'Seçilen durum, abonelik askıya alındığında (örneğin sona erdiğinde veya ödenmiş süre sona erdiğinde) planın abonelikleri altındaki tüm web sitelerine uygulanır.',
    'service-plan.hosting.unpaidWebsiteStatusDescriptionSubscription' => 'Seçilen durum, abonelik askıya alındığında (örneğin sona erdiğinde veya ödenmiş süre sona erdiğinde) web sitelerine uygulanır.',
    'service-plan.hosting.unpaidWebsiteStatusDisabled' => 'Devre Dışı Bırakıldı',
    'service-plan.hosting.unpaidWebsiteStatusDisabledHint' => 'Web sitelerinin ziyaretçileri, web sunucusunun varsayılan sayfasına yönlendirilir.',
    'service-plan.hosting.unpaidWebsiteStatusSuspended' => 'Askıya alınmış',
    'service-plan.hosting.unpaidWebsiteStatusSuspendedHint' => 'Web sitelerinin ziyaretçileri, arama motoru için uygun 503 HTTP koduyla özel hata belge sayfasına yönlendirilir.',
    'service-plan.hosting.unpaidWebsiteStatusActive' => 'Etkin',
    'service-plan.hosting.unpaidWebsiteStatusActiveHint' => 'Web siteleri, İnternet\'ten erişilebilir olmaya devam edecektir.',

    'service-plan.ip.sharedIpAddresses' => 'Paylaşılmış IP adreslerini ayırın',
    'service-plan.ip.allocateExclusiveIp' => 'Atanmış IP adreslerini ayırın',
    'service-plan.ip.allocateExclusiveIpV4' => 'Atanmış IPv4 adreslerini ayırın',
    'service-plan.ip.allocateExclusiveIpV6' => 'Atanmış IPv6 adreslerini ayırın',

    'service-plan.mail.mailService' => 'Posta servisini açın',
    'service-plan.mail.mailServiceDisabled' => 'Devre Dışı Bırakıldı',
    'service-plan.mail.mailServiceDisabledIncoming' => 'Gelen postalar için devre dışı bırakıldı',
    'service-plan.mail.mailServiceDisabledHint' => 'Plesk, bu alan adı için herhangi bir posta hizmeti sağlamaz.',
    'service-plan.mail.mailServiceDisabledIncomingHint' => 'Plesk, yalnızca giden e-postalar için hizmet sağlar. Plesk\'te mail kontrolleri ile belirlenen limitler dahilinde sendmail kullanılarak giden e-postaların gönderilmesi mümkündür.',
    'service-plan.mail.mailServiceEnabled' => 'Etkin',
    'service-plan.mail.mailServiceEnabledHint' => 'Plesk, hem gelen hem de giden e-postalar için hizmet sağlayacaktır.',
    'service-plan.mail.mailServiceNotConfigured' => 'Konfigüre edilmemiş',
    'service-plan.mail.mailServiceNotConfiguredHint' => 'Plesk, bu alan adında herhangi bir posta hizmeti sağlamayacaktır.',
    'service-plan.mail.webMail' => 'Webmail',
    'service-plan.mail.mailingLists' => 'Postalama listelerini açın',
    'service-plan.mail.mailToNonExistentUser' => 'Varolmayan kullanıcılar için posta ilkesi',
    'service-plan.mail.mailToNonExistentUserBounce' => 'Mesajla sıçra',
    'service-plan.mail.mailToNonExistentUserRedirect' => 'Adrese ilet',
    'service-plan.mail.mailToNonExistentUserReject' => 'Reddet',
    'service-plan.mail.mailAutodiscovery' => 'Postayı otomatik olarak bulmayı etkinleştir',
    'service-plan.mail.mailAutodiscoveryDescription' => 'Bilgi tabanından nasıl <a href="%%link%%" target="_blank">çalıştığına bakın</a>',
    'service-plan.mail.bounceMessage' => 'Bu adres artık posta kabul etmiyor.',
    'service-plan.mail.mailToNonExistentUserexternalMailServer' => 'IP adresiyle harici bir posta sunucusuna yeniden yönlendirin',
    'service-plan.mail.webmailDisabled' => '%%webmail%% - devre dışı',

    'service-plan.misc.retainEnabled' => 'Bunun web ve trafik istatistiklerini sakla',
    'service-plan.misc.logRotation' => 'Günlük döndürmesi',
    'service-plan.misc.logRotationCondition' => 'log dönüşüm periyodu',
    'service-plan.misc.logRotationBySize' => 'Boyutuna göre',
    'service-plan.misc.logRotationByTime' => 'Zamana göre',
    'service-plan.misc.logRotationDaily' => 'Günlük',
    'service-plan.misc.logRotationWeekly' => 'Haftalık',
    'service-plan.misc.logRotationMonthly' => 'Aylık',
    'service-plan.misc.logRotationSizeDescription' => 'Boyut değerinin %%min%% ile %%max%% kB arasında olması gerekir.',
    'service-plan.misc.maximumNumberOfFiles' => 'Maksimum log dosyası sayısı',
    'service-plan.misc.compress' => 'Log dosyalarını sıkıştır',
    'service-plan.misc.sendLogToEmail' => 'Plesk web ve FTP sunucularının günlük dosyalarından veri aldıktan sonra, günlükleri e-postayla bu adrese gönderin',
    'service-plan.misc.kb' => 'KB',
    'service-plan.misc.months' => 'aylar',
    'service-plan.misc.logRotationPeriodGreater' => 'Günlük dönüş dönemi, sunucu çapında %%max%% sınırını aşamaz.',

    'service-plan.performance.iisAppPoolAddonsHint' => 'Kapandığında, bir aboneliğin tüm web siteleri, abonelik için atanmış olan aynı IIS uygulama havuzunu kullanır.',

    'service-plan.permissions-subscription.permissionsTabDescription' => 'Abonelikle birlikte sağlanan servisleri ve ayrıcalıkları seçin.',
    'service-plan.permissions-subscription.showMorePermissions' => 'Daha fazla kullanılabilir izin gösterin',
    'service-plan.permissions-subscription.hideMorePermissions' => 'Daha az izin gösterin',
    'service-plan.permissions-subscription.noShellManagement' => 'İzin Verilmiyor',
    'service-plan.permissions-subscription.systemAccessLabel' => 'SSH üzerinden sunucuya erişimin yönetimi',
    'service-plan.permissions-subscription.systemAccessLabel_hint' => 'Müşterilerin sistem kullanıcıları için SSH özelliğini açmasına izin verir. "Abonelik sistem kullanıcısının altındaki sunucu kabuğuna SSH erişimi" barındırma parametresinin önceden ayarlanmış gibi davranmasını sağlar.',

    'service-plan.permissions.permissionsTabDescription' => 'Plan ile sağlanan hizmetleri ve izinleri seçin.',
    'service-plan.permissions.permissionsAddonTabDescription' => 'Bu eklenti planıyla aboneliğe eklenecek olan servisleri ve ayrıcalıkları seçin.  Eklentide seçilmeyen izinlerin, abonelik parametrelerini herhangi bir şekilde değiştirmeyeceğini unutmayın.',
    'service-plan.permissions.permissionsBehaviorDescription' => 'İzinler, abonelerin belirli ayarlarını değiştirmelerini mümkün kılar. Bir abonelik oluşturulduğunda Plesk, plandaki önceden belirlenmiş değerleri müşterinin değiştirebileceği ayarlara uygular. Ardından planın güncellenmesi veya plan eklenmesi, müşteri tarafından yapılan değişikliklerin üzerine kaydedilmez.',
    'service-plan.permissions.showMorePermissions' => 'Daha fazla kullanılabilir izin gösterin',
    'service-plan.permissions.hideMorePermissions' => 'Daha az izin gösterin',
    'service-plan.permissions.noShellManagement' => 'İzin Verilmiyor',
    'service-plan.permissions.systemAccessLabel' => 'SSH üzerinden sunucuya erişimin yönetimi',
    'service-plan.permissions.systemAccessLabel_hint' => '"Abonelik sistem kullanıcısının altındaki sunucu kabuğuna SSH erişimi" barındırma parametresinin önceden ayarlanmış gibi davranmasını sağlar.',

    'service-plan.resources-subscription.overusePolicy' => 'Fazla kullanım ilkesi',
    'service-plan.resources-subscription.overusePolicyNotAllowed' => 'Fazla kullanıma izin verilmez',
    'service-plan.resources-subscription.overusePolicyNotAllowedHint' => 'Kaynakların fazla kullanılması iznini kaldır.  Kaynak kullanımı sınır değerlerini aştığında, bir abonelik otomatik olarak askıya alınır.',
    'service-plan.resources-subscription.overusePolicySoftAllowed' => 'Disk alanını ve trafiği fazla kullanıma izin verildi',
    'service-plan.resources-subscription.overusePolicySoftAllowedHint' => 'Disk alanını ve trafiği fazla kullanıma izin verin.  Diğer kaynakların fazla kullanılması iznini kaldır.',
    'service-plan.resources-subscription.overusePolicyAllowed' => 'Fazla kullanıma izin verilir (önerilmez)',
    'service-plan.resources-subscription.overusePolicyAllowedHint' => 'Abonenin ilk başta abonelikle sağlanandan daha fazla kaynak kullanmasına izin verin.',
    'service-plan.resources-subscription.overuseNotify' => 'Fazla kullanım durumlarında beni e-postayla bilgilendirin.',
    'service-plan.resources-subscription.oversellPolicy' => 'Fazla satma ilkesi',
    'service-plan.resources-subscription.oversellPolicyAllowed' => 'Fazla satmaya izin verilir',
    'service-plan.resources-subscription.oversellPolicyAllowedHint' => 'Fazla satma, bir satıcının bir abonelikle onlara ayrılandan daha fazla kaynak satmasına izin verir. Fazla satmaya izin verildiğinde, bir satıcı ilk kaynak ayırma yerine geçerli kaynak kullanımıyla yönetilir.',
    'service-plan.resources-subscription.oversellPolicyNotAllowed' => 'Fazla satmaya izin verilmez',
    'service-plan.resources-subscription.oversellPolicyNotAllowedHint' => 'Fazla satmaya izin verilmediğinde, bir satıcı sadece onlara ilk başta bir abonelikle ayrıldığı kadar kaynak satabilir ve bunu yaparken bu kaynakların gerçekte ne kadarının kullanıldığını göz ardı eder.',
    'service-plan.resources-subscription.mainGroupTitle' => 'Abonelikle sağlanan kaynakların kullanımıyla ilgili sınırları tanımlayın.',
    'service-plan.resources-subscription.additionalGroupTitle' => 'Daha fazla kullanılabilir kaynak gösterin',
    'service-plan.resources-subscription.hideMoreResources' => 'Daha az kaynak gösterin',

    'service-plan.resources.overusePolicy' => 'Fazla kullanım ilkesi',
    'service-plan.resources.overusePolicyNotAllowed' => 'Fazla kullanıma izin verilmez',
    'service-plan.resources.overusePolicyNotAllowedHint' => 'Kaynakların fazla kullanılması iznini kaldır. Kaynak kullanımı sınır değerlerini aştığında, bir abonelik otomatik olarak askıya alınır.',
    'service-plan.resources.overusePolicySoftAllowed' => 'Disk alanını ve trafiği fazla kullanıma izin verildi',
    'service-plan.resources.overusePolicySoftAllowedHint' => 'Disk alanını ve trafiği fazla kullanıma izin verin. Diğer kaynakların fazla kullanılması iznini kaldır.',
    'service-plan.resources.overusePolicyAllowed' => 'Fazla kullanıma izin verilir (önerilmez)',
    'service-plan.resources.overusePolicyAllowedHint' => 'Müşterilerin ilk başta planla sağlanandan daha fazla kaynak kullanmasına izin verin.',
    'service-plan.resources.overuseNotify' => 'Fazla kullanım durumlarında beni e-postayla bilgilendirin.',
    'service-plan.resources.oversellPolicy' => 'Fazla satma ilkesi',
    'service-plan.resources.oversellPolicyAllowed' => 'Fazla satmaya izin verilir',
    'service-plan.resources.oversellPolicyAllowedHint' => 'Fazla satma, bir satıcının bir planla onlara ayrılandan daha fazla kaynak satmasına izin verir.  Fazla satmaya izin verildiğinde, bir satıcı ilk kaynak ayırma yerine geçerli kaynak kullanımıyla yönetilir.',
    'service-plan.resources.oversellPolicyNotAllowed' => 'Fazla satmaya izin verilmez',
    'service-plan.resources.oversellPolicyNotAllowedHint' => 'Fazla satmaya izin verilmediğinde, bir satıcı sadece onlara ilk başta bir planla ayrıldığı kadar kaynak satabilir ve bunu yaparken bu kaynakların gerçekte ne kadarının kullanıldığını göz ardı eder.',
    'service-plan.resources.mainGroupTitle' => 'Planla sağlanan kaynakları tanımlayın.',
    'service-plan.resources.additionalGroupTitle' => 'Daha fazla kullanılabilir kaynak gösterin',
    'service-plan.resources.hideMoreResources' => 'Daha az kaynak gösterin',
    'service-plan.resources.allowSitebuilderUpsell' => 'Müşterinin deneme Presence Builder web siteleri oluşturmasına izin verin.',
    'service-plan.resources.allowSitebuilderUpsellDescription' => 'Bu ayar, müşterinin, servis planıyla sağlanandan daha fazla Presence Builder web sitesi oluşturmasına izin verir.  Müşterinin bu web sitelerini yayınlamak için onları satın alması gerekir.',

    'service-plan.servicePlanName' => 'Servis planı adı',
    'service-plan.resellerPlanName' => 'Satıcı planı adı',
    'service-plan.addonPlanName' => 'Eklenti planı adı',
    'service-plan.adminPlanPermissionsTab' => 'Yönetimsel Araçlar',
    'service-plan.adminPlanPermissionsTabDescription' => 'Sınırlı Mod etkinleştirildiğinde, yöneticinin kullanabileceği özellikleri seçin.',
    'service-plan.hostingPermissionsTab' => 'Barındırma Araçları',
    'service-plan.hostingPermissionsTabDescription' => 'Sınırlı Mod etkinleştirildiğinde, İleri Kullanıcı görünümünde yöneticinin kullanılabildiği web barındırma araç ve ayarlarını seçin.',
    'service-plan.resourcesTab' => 'Kaynaklar',
    'service-plan.resourcesTabDescription' => 'Planla sağlanan kaynakları ve kaynak kullanımı hakkındaki ilkeyi tanımlayın.',
    'service-plan.subscriptionResourcesTabDescription' => 'Abonelikle sağlanan kaynakları ve kaynak kullanımı hakkındaki ilkeyi tanımlayın.',
    'service-plan.hostingTab' => 'Barındırma Parametreleri',
    'service-plan.hostingTabDescription' => 'Planla sağlanan barındırma servisinin parametrelerini belirtin. Eklenti planında belirtilen barındırma ayarlarının, servis planı veya eklenti planı ile "Barındırma ayarları yönetimi" izni verilen aboneliklere uygulanmadığını unutmayın.',
    'service-plan.secureSettingsDescription' => 'Sağlanan barındırmanın en güvenlisi olmasını istiyorsanız, %%link%%.  Verildiğinde izinlerin bazılarının, abonelerin bu ayarları değiştirmesine izin verdiğini unutmayın.  %%helpLink%%.',
    'service-plan.secureSettingsLink' => 'önceden ayarlanan güvenli ayarları uygulayın',
    'service-plan.secureSettingsHelpLink' => 'Güvenli barındırma ayarı hakkında bilgi edin',
    'service-plan.mailTab' => 'Posta',
    'service-plan.mailTabDescription' => 'Planla sağlanan posta servisinin parametrelerini belirtin.',
    'service-plan.dnsTab' => 'DNS',
    'service-plan.dnsTabDescription' => 'Planla sağlanan DNS servisinin parametrelerini belirtin.',
    'service-plan.performanceTab' => 'Performans',
    'service-plan.performanceTabDescription' => 'Planla sağlanan tüm servislerin performansını etkileyen sistem parametrelerini belirtin.',
    'service-plan.permissionsTab' => 'Yetkiler',
    'service-plan.miscTab' => 'Günlükler ve İstatistikler',
    'service-plan.miscTabDescription' => 'Planın aboneliklerinin istatistiklerinin ve günlüklerinin nasıl saklanacağını belirtin.  Bu ayarların aboneliklerde senkronize olmayacağını unutmayın.',
    'service-plan.miscTabAdminPlanDescription' => 'Aboneliklerin istatistiklerinin ve günlüklerinin nasıl saklanacağını belirtin.',
    'service-plan.extrasTab' => 'Ek Servisler',
    'service-plan.extrasTabDescription' => 'Web barındırma, DNS ve posta servislerine ek olarak plana dahil edilmesi gereken servisleri seçin.',
    'service-plan.ipTab' => 'IP Adresleri',
    'service-plan.ipTabDescription' => 'Planla sağlanan IP kaynaklarının parametrelerini tanımlayın.',
    'service-plan.applicationsTab' => 'Başvurular',
    'service-plan.applicationsTabDescription' => 'Planda kullanılabilir olmasını istediğiniz uygulamaları seçin.  Uygulama Katalogundaki kullanılabilir tüm uygulamaları ve ayrıca sunucuya yüklediklerinizi sağlamayı veya uygulamaları manuel olarak belirlemeyi seçebilirsiniz.  Kullanılabilir tüm uygulamaları sunmak istiyorsanız, o zaman bu sekmede herhangi bir şey yapmanız gerekmez; İzinler sekmesine gidin ve Uygulama Kataloguna Erişim seçeneğini seçin.  Uygulamaları manuel olarak seçmek istiyorsanız, onu bu sekmeden yapabilirsiniz.',
    'service-plan.applicationsTabDescription-addon' => 'Eklentide kullanılabilir olmasını istediğiniz uygulamaları seçin.',
    'service-plan.applicationsTabDescription-subscription' => 'Abonelikte kullanılabilir olmasını istediğiniz uygulamaları seçin. Uygulama Katalogundaki kullanılabilir tüm uygulamaları ve ayrıca sunucuya yüklediklerinizi sağlamayı veya uygulamaları manuel olarak belirlemeyi seçebilirsiniz.  Kullanılabilir tüm uygulamaları sunmak istiyorsanız, o zaman bu sekmede herhangi bir şey yapmanız gerekmez; İzinler sekmesine gidin ve Uygulama Kataloguna Erişim seçeneğini seçin. Uygulamaları manuel olarak seçmek istiyorsanız, onu bu sekmeden yapabilirsiniz.',
    'service-plan.planSyncSubsriptionWarning' => 'Aboneliklerin bazıları planla senkronize edilemedi.  Bunlar abonelikler listesinde \'Unsynced\' olarak işaretlenmiştir.  Senkronizasyonu tekrar denemek için, bir aboneliğe genel bakış sayfasına gidin ve Senkronizasyon düğmesini tıklatın.',
    'service-plan.planSyncResellerWarning' => 'Satıcıların bazıları planla senkronize edilemedi.  Bunlar satıcılar listesinde \'Unsynced\' olarak işaretlenmiştir.  Senkronizasyonu tekrar denemek için, bir satıcı genel bakış sayfasına gidin ve Senkronizasyon düğmesini tıklatın.',
    'service-plan.planSyncAdminWarning' => 'Plesk, bu değişikliklerden etkilenen servis veya kaynakların bazılarını sağlamadığından, değişiklikler aboneliklere uygulanamıyor. Nedeni: %%reason%%',
    'service-plan.duplicateName' => 'Adı böyle olan bir plan zaten var.',
    'service-plan.phpSettingsTab' => 'PHP Ayarları',
    'service-plan.phpHandlerNotFound' => 'Planın PHP sürümü hakkında bilgi alınamadı. Tekrar yükleyin veya servis planı için başka bir PHP versiyonu seçin.',
    'service-plan.phpHandlerNotRegistered' => "%%fullVersion%% PHP sürümü kurulu değil. Alan adları için PHP scripting mevcut değil. PHP <nobr>%%fullVersion%% sürümünü</nobr> yükleyin veya servis planı için başka bir PHP sürümü seçin.",

    'service-plan.phpSettingsTabDescription' => 'Burada sunucu çapında php.ini dosyasıyla tanımlanan ayarları geçersiz kılan abonelik başına PHP ayarlarını belirtebilirsiniz. Bu, örneğin müşterilerin PHP komut dosyalarıyla sistem kaynakları tüketimini sınırlamak istediğinizde yararlı olabilir. Müşteriler (izin verilirse) bu PHP yapılandırmasını kendi etki alanı tabanlı yapılandırmasıyla geçersiz kılabilir. Bir parametreyi Varsayılan değere ayarladığınızda PHP, sunucu çapındaki PHP yapılandırmasındaki parametre değerini kullanır. Aşağıdaki yer tutucuların desteklendiğini unutmayın: {DOCROOT} ve {WEBSPACEROOT}, bir alan adının belge kök dizinini ve özel PHP yapılandırması alan bir aboneliğin kök dizinini temsil eder; {TMP}, geçici dosyaları saklayan dizini temsil eder.',
    'service-plan.phpSettingsTabDescriptionAddon' => 'Burada ana servis planı tarafından tanımlanan ayarları geçersiz kılan abonelik başına PHP ayarlarını belirtebilirsiniz. Bu, örneğin ana servis planında ayarlanan PHP sınırlamalarının bazılarını kaldırmak istediğinizde yararlı olabilir. Bir parametreyi Varsayılan değere ayarladığınızda PHP, servis planı PHP yapılandırmasındaki parametre değerini kullanır. Aşağıdaki yer tutucuların desteklendiğini unutmayın: {DOCROOT} ve {WEBSPACEROOT}, bir alan adının belge kök dizinini ve özel PHP yapılandırması alan bir aboneliğin kök dizinini temsil eder; {TMP}, geçici dosyaları saklayan dizini temsil eder.',
    'service-plan.phpSettingsPhpVersion' => 'Geçerli PHP sürümünüz %%version%%.',
    'service-plan.phpSettingsTabAdminPlanDescription' => 'Burada sunucu çapında php.ini dosyasıyla tanımlanan ayarları geçersiz kılan abonelik başına PHP ayarlarını belirtebilirsiniz. Bir parametreyi Varsayılan değere ayarladığınızda PHP, sunucu çapındaki PHP yapılandırmasındaki parametre değerini kullanır.',
    'service-plan.webServerSettingsTab' => 'Web Sunucusu',
    'service-plan.webServerSettingsTabDescription' => 'Burada bu servis planı için Apache web sunucusu ayarlarını belirtebilirsiniz. Apache, bir ön uç sunucusu olarak nginx ile çalışıyorsa, bu sayfadaki nginx ayarlarını da belirtebilirsiniz. Yeni oluşturulan tüm alan adları, belirtilen ayarları alacak. Ancak bu ayarları değiştirdiğinizde, varolan alan adları değişiklikleri almaz.',
    'service-plan.servicesTab' => 'Servisler',
    'service-plan.servicesTabDescription' => 'Burada servis planına atanmış servisleri belirtebilirsiniz.',
    'service-plan.servicePropertiesTab' => '%%serviceName%% Özellikleri',
    'service-plan.servicePropertiesTabDescription' => 'Burada servis planına atanmış %%serviceName%% servisinin özelliklerini belirtebilirsiniz.',
    'service-plan.longTaskWarning' => 'Bu planda %%subscriptionsCount%% aboneliğiniz bulunuyor. Senkronizasyon görevi için önemli bir süre gerekeceğini ve onun arka planda gerçekleştirileceğini unutmayın.',
    'service-plan.hostingParametersTab' => 'Barındırma Parametreleri',
    'service-plan.adminInfoSection' => 'Yönetici için bilgiler',
    'service-plan.descriptionInPanel' => 'Tanım',
    'service-plan.longDescription' => 'Belirtilen açıklama çok uzun.',
    'service-plan.conflictPermissions' => 'Satıcı planıyla çakıştığından, aşağıdaki izinler verilemiyor: %%permissions%%.',

    'services.change-startup-type.startupTypeLabel' => 'Başlangıç türü',
    'services.change-startup-type.autoStartupTypeLabel' => 'Otomatik',
    'services.change-startup-type.manualStartupTypeLabel' => 'Manuel',
    'services.change-startup-type.disabledStartupTypeLabel' => 'Kapat',
    'services.change-startup-type.autoActionError' => 'Başlatma tipi \'otomatik\' olarak ayarlanamıyor: %%error%%',
    'services.change-startup-type.manualActionError' => 'Başlatma tipi \'manuel\' olarak ayarlanamıyor: %%error%%',
    'services.change-startup-type.disableActionError' => 'Başlatma tipi \'devre dışı\' olarak ayarlanamıyor: %%error%%',

    'sessions.settings.restoreDefaultButton' => 'Varsayılana Sıfırla',
    'sessions.settings.restoreDefaultButtonDescription' => 'Oturum parametrelerinin varsayılan değerlerini geri yükleyin.',
    'sessions.settings.restoreDefaultButtonDescriptionDisable' => 'Oturum parametrelerinin varsayılan değerleri var.',
    'sessions.settings.idleTime' => 'İşlemsiz oturum süresi',
    'sessions.settings.disableCheckSessionIp' => 'Tek bir oturum sırasında IP adres değişikliklerine izin verin',
    'sessions.settings.minuteShortTitle' => 'Min',

    'settings-ui.controls.title' => 'Kontroller',

    'settings-ui.interface-views.description' => "Kullanabileceğiniz birden fazla ürün UI görünümü var. Kullandığınız görünüme bağlı olarak, özellikler ve ayarlar farklı yerlerde bulunabilir veya hatta etkinleştirilebilir / devre dışı bırakılabilir. Farklı görünümler farklı kullanıcı tipleri için daha uygun olur.",
    'settings-ui.interface-views.panelSimpleLink' => 'Araçlar ve Ayarlar> Sınırlı Mod Ayarları',
    'settings-ui.interface-views.useCustomView' => 'Sınırlı Modu Etkinleştir',
    'settings-ui.interface-views.useCustomViewHint' => 'Yöneticinin Plesk Panel\'de yapabileceği eylem sayısını sınırlandırmak için bu seçeneği seçin. Eylemlerin kullanılabilirliğini değiştirmek için, %%customViewSettingsLink%% konumuna gidin.',
    'settings-ui.interface-views.powerUserViewHint' => 'Bu görünüm web sitelerini, dosyalarını, veritabanlarını, e-posta hesaplarını, web uygulamalarını ve diğer servisleri yönetmek için en uygundur.',
    'settings-ui.interface-views.selectUiModeTitle' => "Arayüzünüzü seçin",
    'settings-ui.interface-views.uiModeTitlePowerUser' => "Yetkili Kullanıcı görünümü (geliştiriciler ve web firmaları için)",
    'settings-ui.interface-views.uiModeTitleServiceProvider' => "Hizmet Sağlayıcı görünümü (web barındırma sağlayıcıları için)",
    'settings-ui.interface-views.uiModeHintServiceProvider' => 'Bu görünüm, servis planlarını kullanan müşterilerine web barındırma servisleri sağlayan ve satan sunucu yöneticileri içindir.',
    'settings-ui.interface-views.visibilityMailBounce' => 'Geri dönderme kontrollerini gizle',
    'settings-ui.interface-views.visibilityMailBounceHint' => 'Var olmayan e-posta adreslerine gönderilen postaların nasıl işleneceğini ayarlamaya izin veren düğmeyi gizler',

    'settings-ui.branding.description' => 'Plesk arayüzü markasını kullanmak için tarayıcının başlık çubuğunda beliren sayfa başlığını ve/veya sol üst köşedeki Plesk logosunu değiştirin.',
    'settings-ui.branding.buttonDefault' => 'Varsayılan Logo',
    'settings-ui.branding.sectionTitle' => 'Özel başlık',
    'settings-ui.branding.enableCustomTitle' => 'Plesk sayfalarında özel başlığı etkinleştir',
    'settings-ui.branding.customTitle' => 'Başlık metni',
    'settings-ui.branding.sectionLogo' => 'Özel logo',
    'settings-ui.branding.enableCustomLogo' => 'Özel panel logosunu etkinleştir',
    'settings-ui.branding.logo' => 'Logo dosyası',
    'settings-ui.branding.logoUrl' => 'Logo URL\'si',
    'settings-ui.branding.logoUrlEnabled' => 'Özel',
    'settings-ui.branding.logoUrlDisabled' => 'Varsayılan',
    'settings-ui.branding.sectionFavicon' => 'Özel favicon',
    'settings-ui.branding.enableCustomFavicon' => 'Özel favicon\'u etkinleştir',
    'settings-ui.branding.sectionFaviconDesc' => 'Farklı tarayıcılarda daha iyi bir destek almak için aynı favicon\'un her iki biçimde de yüklenmesi gerekir.',
    'settings-ui.branding.faviconSvg' => 'SVG Favicon dosyası',
    'settings-ui.branding.faviconSvgHint' => 'İzin verilen biçim: SVG',
    'settings-ui.branding.faviconIco' => 'ICO Favicon dosyası',
    'settings-ui.branding.faviconIcoHint' => 'İzin verilen biçim: ICO',
    'settings-ui.branding.show' => 'Göster',
    'settings-ui.branding.updateSuccess' => 'Plesk markası özellikleri değiştirildi.',

    'sitebuilder.trial.description' => 'Bu sayfa, Deneyin ve Satın Alın modunu (eski adıyla Müşteri Kazanma Senaryosunu) yapılandırmanıza izin verir.  Bu modda müşteri, ekteki Presence Builder uygulamasında kullanılabilir tüm işlevsellikle bir web sitesi oluşturabilir.  Ancak bir barındırma servis planı veya bir plan eklentisi satın almadan müşteriler, deneme web sitelerini yayınlamadan yararlanamaz.  Deneyin ve Satın Alın modu, bir barındırma planıyla veya bir plan eklentisiyle varolan müşterilerinize de sunulabilir. %%link%%',
    'sitebuilder.trial.descriptionLink' => 'Daha ayrıntılı bilgiler için belgelere bakın.',
    'sitebuilder.trial.lifetimeLabel' => 'Deneme web sitesi ömrü',
    'sitebuilder.trial.lifetimeUnits' => 'gün',
    'sitebuilder.trial.lifetimeDescription' => 'Bu, müşteriler tarafından satın alınmayan deneme web siteleri sunucudan kaldırılmadan önce geçmesi gereken süreyi gösterir.',
    'sitebuilder.trial.signupLabel' => 'Deneme moduna genel erişimi etkinleştirin',
    'sitebuilder.trial.signupDescription' => 'Presence Builder\'la barındırma reklamı yaparak ve onlara Presence Builder demosu sunarak müşterileri çekmek istiyorsanız, deneme moduna genel erişimi etkinleştirin ve deneme modu erişim URL\'sini web sitenizde yayınlayın.',
    'sitebuilder.trial.signupLinkLabel' => 'Deneme modu erişim URL\'si',
    'sitebuilder.trial.signupLinkDescription' => 'Bu URL, Presence Builder\'ı deneme modunda açar.  Presence Builder\'la barındırma reklamı yapmak ve müşterileri çekmek için bu URL\'yi web sitenizde yayınlayın.',
    'sitebuilder.trial.promotionLabel' => 'Presence Builder düzenleyicisinde deneme modu bildirimini görüntüleyin',
    'sitebuilder.trial.promotionDescription' => 'Deneme modunda çalışan Presence Builder hakkında ek bilgilendirmeler görüntülemek istiyorsanız, bu seçeneği kullanın.',

    'update-settings.policyHintForPum' => 'Burada, güncellemelerin otomatik kurulumunu ayarlayabilirsiniz. Güncellemeler manuel kurulum için hazır olduğunda veya otomatik olarak yüklendiğinde, bildirim e-postası gönderilebilir.',
    'update-settings.policyHint' => 'Güncellemeler manuel kurulum için hazır olduğunda veya otomatik olarak yüklendiğinde, bildirim e-postası gönderilebilir.',
    'update-settings.branchDisabledDescription' => 'Bana kullanılabilir yükseltmeleri bildirmeyin',
    'update-settings.automaticPatchesInstallation' => 'Plesk güncellemelerini otomatik olarak kurun (Önerilir)',
    'update-settings.automaticPatchesThirdParty' => 'Plesk tarafından gönderilen üçüncü kişi bileşenleri için güncellemeleri otomatik olarak kurun',
    'update-settings.automaticSystemPackageUpdates' => 'Sistem paketi güncellemelerini otomatik olarak kurun',
    'update-settings.automaticSystemPackageUpdatesHint' => 'Bunun, Plesk tarafından gönderilen üçüncü kişi bileşenleri için güncellemeleri otomatik olarak kuracağını da unutmayın',
    'update-settings.automaticPatchesNotification' => 'Kullanılabilir ve yüklenen sistem paketi güncellemelerini bildirin',
    'update-settings.systemPackageUpdatesNotificationsEmail' => 'E-posta adresi',
    'update-settings.systemPackageUpdatesNotificationsPeriod' => 'Bildirim e-postası sıklığı',
    'update-settings.daily' => 'Günlük',
    'update-settings.weekly' => 'Haftalık',
    'update-settings.generalSection' => 'Genel',
    'update-settings.notificationsSection' => 'Bildiriler',
    'update-settings.safeUpdatesSection' => 'Güvenli Güncellemeler',
    'update-settings.safeUpdatesSectionHint' => 'Plesk, sistem paketi güncellemelerinin, paketlerin ilk yüklendikleri depoyla aynı depodan yüklenmelerini sağlar. Bu tür güncellemeler güvenli sayılıyor. Güvenli güncellemeleri devre dışı bırakırsanız, sistem paketleri yöneticiniz güncellemeleri sistemdeki herhangi bir depodan kurabilir.',
    'update-settings.safeUpdatesSectionWarn' => 'Gelişmiş bir kullanıcı olmadığınız takdirde güvenli güncellemeleri etkin olarak bırakmanız önerilir. Farklı depolardaki sistem paketlerinin rasgele güncellenmesi, sunucunuzun çalışmasını olumsuz olarak etkileyebilir.',
    'update-settings.allowSafeUpdates' => 'Sistem paketleri için güvenli güncellemeleri etkinleştir',

    'requiredFields' => 'Zorunlu alanlar',
];