<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
$messages = [
    'adminaliases.statusActive' => 'Das Konto ist aktiv.',
    'adminaliases.statusInactive' => 'Das Konto ist gesperrt: Dieser Administrator kann sich nicht bei Plesk anmelden.',
    'adminaliases.buttonRemoveAdminAlias' => 'Entfernen',
    'adminaliases.hintRemoveAdminAlias' => 'Entfernen Sie ausgewählte Administratorkonten.',
    'adminaliases.confirmOnRemove' => 'Möchten Sie die ausgewählten Administratorkonten wirklich entfernen?',
    'adminaliases.buttonAddNewAdminAlias' => 'Administratorkonto hinzufügen',
    'adminaliases.hintAddNewAdminAlias' => 'Erstellen Sie ein zusätzliches Administratorkonto.',
    'adminaliases.buttonMoreActions' => 'Mehr',
    'adminaliases.buttonActivateAdminAlias' => 'Aktivieren',
    'adminaliases.hintActivateAdminAlias' => 'Aktivieren Sie gesperrte Administratorkonten.',
    'adminaliases.buttonDeactivateAdminAlias' => 'Sperren',
    'adminaliases.hintDeactivateAdminAlias' => 'Sperren Sie ausgewählte Administratorkonten. Plesk wird den Zugriff für diese Administratoren verweigern.',
    'adminaliases.confirmOnDelete' => 'Möchten Sie die ausgewählten Administratorkonten wirklich entfernen?',
    'adminaliases.login' => 'Nutzername',
    'adminaliases.contact' => 'Name des Kontakts',
    'adminaliases.email' => 'E-Mail',
    'adminaliases.comments' => 'Anmerkungen',

    'appinfo.installedAt' => 'Installationspfad',
    'appinfo.noInstallationUrlAvailable' => 'Keiner',
    'appinfo.subscriptionName' => 'Abonnement',
    'appinfo.subscriptionOwner' => 'Abonnement-Besitzer',
    'appinfo.buttonLogin' => 'Im Kunden-Panel öffnen',
    'appinfo.buttonLoginClassicMode' => 'Hosting verwalten',
    'appinfo.hintLogin' => 'Öffnen Sie das Kunden-Panel des Abonnenten.',
    'appinfo.hintAdminLogin' => 'Verwalten Sie Hosting-Services, die einem bestimmten Hosting-Konto zugeordnet sind: Domains und DNS, Web-Apps und Datenbanken, E-Mail und so weiter.',
    'appinfo.hintLoginClassicMode' => 'Verwalten Sie Hosting-Services, die einem bestimmten Hosting-Konto zugeordnet sind: Domains und DNS, Web-Apps und Datenbanken, E-Mail und so weiter.',
    'appinfo.update' => 'Es sind Updates verfügbar.',
    'appinfo.updateFailed' => 'Die Aktualisierung fehlgeschlagen.',
    'appinfo.noUpdates' => 'Es sind keine Updates verfügbar',
    'appinfo.foundUpdates' => 'Für die folgenden Anwendungen sind Updates verfügbar:',
    'appinfo.buttonCheckForUpdates' => 'Nach Updates suchen',
    'appinfo.buttonCheckForUpdatesDescription' => 'Überprüfen Sie auf verfügbare Updates.',
    'appinfo.buttonChangeSettings' => 'Einstellungen',
    'appinfo.buttonChangeSettingsDescription' => 'Ändern Sie serverweite Einstellungen der Anwendung.',
    'appinfo.appNotConfigured' => 'Nicht konfiguriert',

    'appuploaded.name' => 'Name',
    'appuploaded.numberOfInstances' => 'Anzahl an Installationen',
    'appuploaded.buttonUploadNewApp' => 'Anwendung hinzufügen',
    'appuploaded.buttonUploadNewAppDescription' => 'Laden Sie ein App-Paket auf den Server.',
    'appuploaded.buttonRemove' => 'Entfernen',
    'appuploaded.buttonRemoveDescription' => 'Entfernen Sie ausgewählte Pakete.',
    'appuploaded.confirmOnDelete' => 'Sind Sie sicher, dass Sie die ausgewählten Pakete entfernen möchten?',
    'appuploaded.appInvisible' => 'Nicht verfügbar für Kunden',
    'appuploaded.appGlobalSettingsNotSet' => 'Nicht konfiguriert',
    'appuploaded.buttonMakeAppVisible' => 'Zur Verfügung stellen',
    'appuploaded.buttonMakeAppVisibleDescription' => 'Machen Sie Anwendungen für die Installation durch Kunden verfügbar.',
    'appuploaded.buttonMakeAppInvisible' => 'Verfügbarkeit aufheben',
    'appuploaded.buttonMakeAppInvisibleDescription' => 'Sperren Sie die Anwendungen für die Installation durch Kunden.',

    'appusage.name' => 'Name',
    'appusage.numberOfInstances' => 'Anzahl an Installationen',
    'appusage.buttonCleanApplicationCache' => 'Cache leeren',
    'appusage.buttonCleanApplicationCacheDescription' => 'Temporäre Dateien löschen, die während der Installation von Anwendungen heruntergeladen werden',
    'appusage.buttonRedirectToMarket' => 'Zum Online-Shop gehen',
    'appusage.buttonRedirectToMarketDescription' => 'Anwendungs-Lizenzen zur Installation auf Websites erwerben.',
    'appusage.updateFailed' => 'Die Aktualisierung fehlgeschlagen.',
    'appusage.noUpdates' => 'Es sind keine Updates verfügbar',
    'appusage.foundUpdates' => 'Für die folgenden Anwendungen sind Updates verfügbar:',
    'appusage.buttonCheckForUpdates' => 'Nach Updates suchen',
    'appusage.buttonCheckForUpdatesDescription' => 'Suchen Sie im Anwendungskatalog nach verfügbaren Updates.',
    'appusage.buttonUpdateSettings' => 'Update-Einstellungen',
    'appusage.buttonUpdateSettingsDescription' => 'Serverweite App-Update-Einstellungen.',

    'controlpanelaccessnetworks.ipAddress' => 'IP-Adresse',
    'controlpanelaccessnetworks.subnetMask' => 'Subnetzmaske',
    'controlpanelaccessnetworks.buttonAddNewNetwork' => 'Hinzufügen',
    'controlpanelaccessnetworks.buttonAddNewNetworkDescription' => 'Klicken Sie hier, um das Netzwerk zur Zugriffsliste hinzuzufügen.',
    'controlpanelaccessnetworks.buttonRemove' => 'Entfernen',
    'controlpanelaccessnetworks.buttonRemoveDescription' => 'Klicken Sie hier, um die ausgewählten Netzwerke zu entfernen.',
    'controlpanelaccessnetworks.confirmOnDelete' => 'Möchten Sie die ausgewählten Netzwerke entfernen?',
    'controlpanelaccessnetworks.buttonSettings' => 'Einstellungen',
    'controlpanelaccessnetworks.buttonSettingsDescription' => 'Klicken Sie hier, um die Zugriffsbeschränkungen zu ändern.',
    'controlpanelaccessnetworks.loadingTitle' => 'Bitte warten. Lade...',

    'customers.filterCustomerName' => 'Kundenname',
    'customers.filterSubscription' => 'Abonnement',
    'customers.filterOptionSubscriptionAny' => 'Beliebig',
    'customers.filterOptionSubscriptionMy' => 'Meine Pakete',
    'customers.filterOptionSubscriptionReseller' => 'Pakete von %%planOwnerContactName%%', // Note for translators: you can use here structure like "Plans of Reseller <name>" or alike if it is more convenient
    'customers.filterOptionSubscriptionCustom' => 'Benutzerdefiniert',
    'customers.filterOwnership' => 'Anbieter',
    'customers.filterOptionOwnershipAny' => 'Alle Kunden',
    'customers.filterOptionOwnershipMy' => 'Meine Kunden',
    'customers.filterOwnershipReseller' => 'Kunden von %%resellerContactName%%', //Note for translators: see 'filterOptionSubscriptionReseller'
    'customers.filterResourceUsage' => 'Ressourcenauslastung',
    'customers.filterOptionResourceUsageAny' => 'Beliebig',
    'customers.filterOptionResourceUsageOveruse' => 'Überbeanspruchte Ressourcen',
    'customers.filterOptionResourceUsageOk' => 'Innerhalb der Grenzen',
    'customers.filterStatus' => 'Status',
    'customers.filterOptionStatusAny' => 'Beliebig',
    'customers.filterOptionStatusSuspended' => 'Gesperrt',
    'customers.filterOptionStatusActive' => 'Aktiv',
    'customers.filterDescription' => 'Beschreibung',
    'customers.statusOk' => 'Das Kundenkonto ist aktiv.',
    'customers.statusInactive' => 'Das Kundenkonto ist inaktiv: Der Zugang zum Kunden-Panel ist für den Kunden blockiert.',
    'customers.statusSuspended' => 'Das Kundenkonto ist gesperrt: Der Zugang zum Kunden-Panel ist für den Kunden und alle seine Benutzer blockiert; die Domains des Kunden sind gesperrt, seine Web-, FTP- und E-Mail-Services sind nicht mehr für Internetnutzer zugänglich.',
    'customers.customerName' => 'Kundenname',
    'customers.subscription' => 'Abonnement',
    'customers.setupDate' => 'Einrichtungsdatum',
    'customers.ownerName' => 'Anbieter',
    'customers.buttonLogin' => 'Als Kunde anmelden',
    'customers.buttonLoginClassicMode' => 'Hosting verwalten',
    'customers.hintLogin' => 'Melden Sie sich als dieser Kunde an.',
    'customers.hintLoginClassicMode' => 'Verwalten Sie Hosting-Services, die dem Hosting-Konto des Kunden zugeordnet sind: Domains und DNS, Web-Apps und Datenbanken, E-Mail und so weiter.',
    'customers.buttonRemoveCustomer' => 'Entfernen',
    'customers.hintRemoveCustomer' => 'Entfernen Sie die ausgewählten Kunden.',
    'customers.confirmOnRemove' => 'Möchten Sie die ausgewählten Kundenkonten wirklich entfernen?',
    'customers.buttonConvertCustomersToReseller' => 'In Reseller umwandeln',
    'customers.hintConvertCustomersToReseller' => 'Wandeln Sie die ausgewählten Kundenkonten in Resellerkonten um.',
    'customers.buttonAddNewCustomer' => 'Kunden hinzufügen',
    'customers.hintAddNewCustomer' => 'Erstellen Sie ein Kundenkonto mit Abonnement.',
    'customers.buttonChangeStatus' => 'Status ändern',
    'customers.buttonSuspendCustomers' => 'Sperren',
    'customers.hintSuspendCustomers' => 'Sperren Sie die ausgewählten Kundenkonten. Der Zugang zum Kunden-Panel wird für die Kunden und alle ihre Benutzer gesperrt. Außerdem werden die Domains des Kunden gesperrt und ihre Internet-, FTP- und E-Mail-Services werden nicht mehr für Internetnutzer zugänglich sein.',
    'customers.buttonActivateCustomers' => 'Aktivieren',
    'customers.hintActivateCustomers' => 'Aktivieren Sie die ausgewählten Kundenkonten.',
    'customers.buttonChangeOwner' => 'Verschieben zu',
    'customers.hintChangeOwner' => 'Verschieben Sie die ausgewählten Kunden zu einem anderen Reseller.',
    'customers.customPlanName' => 'Benutzerdefiniert',
    'customers.selectNewIp' => 'IP-Adresse auswählen',
    'customers.selectAnotherOwner' => 'Verantwortlichen auswählen',
    'customers.shared' => 'gemeinsam genutzt',
    'customers.exclusive' => 'dediziert',
    'customers.confirmOnDelete' => 'Möchten Sie {count, plural, =1 {das Kundenkonto {name}} one {das ausgewählte Kundenkonto} other {die # ausgewählten Kundenkonten}} wirklich entfernen?',
    'customers.hintInfo' => '(?)',

    'customerserviceplans.planName' => 'Paket-Name',
    'customerserviceplans.planTraffic' => 'Verkehr',
    'customerserviceplans.planDiskSpace' => 'Speicherplatz',
    'customerserviceplans.planSubscriptions' => 'Abonnements',
    'customerserviceplans.planOwner' => 'Anbieter',
    'customerserviceplans.filterPlanItem' => 'Benutzerdefiniertes Paketobjekt',
    'customerserviceplans.filterOptionPlanItemAny' => 'Beliebig',
    'customerserviceplans.filterOwnership' => 'Paket-Besitzer',
    'customerserviceplans.filterOptionOwnershipAny' => 'Alle Pakete',
    'customerserviceplans.filterOptionOwnershipMy' => 'Meine Pakete',
    'customerserviceplans.filterOwnershipReseller' => 'Pakete von %%resellerContactName%%',
    'customerserviceplans.unlimited' => 'Unbegrenzt',
    'customerserviceplans.addonPlanType' => '(Add-on)',
    'customerserviceplans.buttonAddNewPlan' => 'Paket hinzufügen',
    'customerserviceplans.hintAddNewPlan' => 'Erstellen Sie ein Hosting-Paket.',
    'customerserviceplans.buttonDuplicatePlans' => 'Paket klonen',
    'customerserviceplans.hintDuplicatePlans' => 'Erstellen Sie Kopien der ausgewählten Service-Pakete.',
    'customerserviceplans.buttonAddNewAddonPlan' => 'Add-on hinzufügen',
    'customerserviceplans.hintAddNewAddonPlan' => 'Erstellen Sie ein Add-on für das Hosting-Paket',
    'customerserviceplans.buttonRemove' => 'Entfernen',
    'customerserviceplans.hintRemove' => 'Entfernen Sie die ausgewählten Service-Pakete.',
    'customerserviceplans.buttonMoreActions' => 'Mehr',
    'customerserviceplans.confirmOnDelete' => 'Möchten Sie die ausgewählten Service-Pakete wirklich entfernen?',
    'customerserviceplans.disabledSelectHint' => 'Zu dem Service-Paket gehört mindestens ein Abonnement und kann daher nicht entfernt werden.',

    'domains.filterDomainName' => 'Name',
    'domains.filterStatus' => 'Status',
    'domains.filterOptionStatusAny' => 'Beliebig',
    'domains.filterOptionStatusSuspended' => 'Gesperrt',
    'domains.filterOptionStatusDisabled' => 'Deaktiviert',
    'domains.filterOptionStatusActive' => 'Aktiv',
    'domains.filterHostingType' => 'Hosting-Typ',
    'domains.filterPhpHandler' => 'PHP-Handler',
    'domains.filterOptionPhpHandlerAny' => 'Beliebig',
    'domains.filterOptionHostingTypeAny' => 'Beliebig',
    'domains.filterOptionHostingTypeNone' => 'Kein Hosting',
    'domains.filterOptionHostingTypeForward' => 'Domain-Weiterleitung',
    'domains.filterOptionHostingTypeAlias' => 'Domain-Alias',
    'domains.filterOptionHostingTypeVirtualHost' => 'Domain-Hosting',
    'domains.filterOptionHostingTypeSubdomain' => 'Subdomain-Hosting',
    'domains.filterSubscriberName' => 'Abonnent',
    'domains.filterServiceNode' => 'Service-Node',
    'domains.filterServiceNodeOptionAny' => 'Beliebig',
    'domains.filterDescription' => 'Beschreibung',
    'domains.statusDisabled' => 'Die Domain ist deaktiviert.',
    'domains.statusSuspended' => 'Die Domain ist gesperrt.',
    'domains.domainName' => 'Domainname',
    'domains.hostingType' => 'Hosting-Typ',
    'domains.ownerName' => 'Abonnent',
    'domains.setupDate' => 'Einrichtungsdatum',
    'domains.expirationDate' => 'Ablaufdatum',
    'domains.diskUsage' => 'Speicherplatzverbrauch',
    'domains.traffic' => 'Verkehr',
    'domains.description' => 'Beschreibung',
    'domains.resellerDescription' => 'Reseller',
    'domains.ownerDescription' => 'Kunde',
    'domains.openSite' => 'Öffnen',
    'domains.previewSite' => 'Vorschau',
    'domains.manageInResellerPanel' => 'Im Reseller-Panel verwalten',
    'domains.manageInCustomerPanel' => 'Im Kunden-Panel verwalten',
    'domains.customPlanName' => 'Benutzerdefiniert',
    'domains.website' => 'Webseite',
    'domains.subdomainWebsite' => 'Subdomain-Website',
    'domains.noHosting' => 'Kein Hosting',
    'domains.forwardingTo' => 'Weiterleiten an',
    'domains.aliasFor' => 'Alias für',
    'domains.add' => 'hinzufügen',
    'domains.buttonAddDomain' => 'Domain hinzufügen',
    'domains.hintAddDomain' => 'Sie können eine neue Website auf diesem Server hosten, die Weiterleitung auf eine andere Website einrichten oder eine Domain-DNS-Zone einrichten, wenn Sie nur E-Mail-Adressen unter einem Domainnamen verwenden wollen.',
    'domains.buttonAddSubdomain' => 'Subdomain hinzufügen',
    'domains.hintAddSubdomain' => 'Erstellen Sie eine Website, die über einen Third-Level-Domainnamen adressiert wird, z.B. shop.example.com.',
    'domains.buttonAddDomainAlias' => 'Domain-Alias hinzufügen',
    'domains.hintAddDomainAlias' => 'Richten Sie einen zusätzlichen Domainnamen für Ihre Website ein.',
    'domains.hintRemove' => 'Entfernen Sie die ausgewählten Websites und deren Webcontent, Anwendungen, Datenbanken und E-Mail-Services.',
    'domains.removeConfirmation' => 'Möchten Sie {count, plural, =1 {die Domain {name}} one {die ausgewählte Domain} other {die # ausgewählten Domains}} wirklich entfernen?',
    'domains.removeConfirmationSubscription' => "Die folgenden Domains werden auch entfernt: %%domains%%",
    'domains.buttonChangeStatus' => 'Status ändern',
    'domains.buttonActivateDomains' => 'Aktivieren',
    'domains.hintActivateDomains' => 'Aktivieren Sie die ausgewählten Domains.',
    'domains.buttonDisableDomains' => 'Deaktivieren',
    'domains.hintDisableDomains' => 'Deaktivieren Sie die ausgewählten Domains.',
    'domains.buttonSuspendDomains' => 'Sperren',
    'domains.hintSuspendDomains' => 'Sperren Sie die ausgewählten Domains.',

    'dnsaclrecords.value' => 'IP-Adresse',
    'dnsaclrecords.add' => 'IP-Adresse hinzufügen',
    'dnsaclrecords.remove' => 'Entfernen',
    'dnsaclrecords.hintRemove' => 'Löschen Sie die ausgewählten IP-Adressen.',
    'dnsaclrecords.confirmOnDelete' => 'Ausgewählte IP-Adressen entfernen?',
    'dnsaclrecords.emptyViewTitle' => 'Zonenübertragung ist nicht zulässig',
    'dnsaclrecords.emptyViewDescription1' => 'Aus Sicherheitsgründen können Sie eine Übertragung der DNS-Zone nur an Server zulassen, die in den NS-Einträgen der Zone angegeben sind.',
    'dnsaclrecords.emptyViewDescription2' => 'Um einen oder mehrere Server anzugeben, auf die die Übertragung möglich sein soll, klicken Sie auf "IP-Adresse hinzufügen".',

    'eventhandlers.event' => 'Ereignis',
    'eventhandlers.priority' => 'Priorität',
    'eventhandlers.priorityHighest' => 'am höchsten (%%value%%)',
    'eventhandlers.priorityHigh' => 'hoch (%%value%%)',
    'eventhandlers.priorityNormal' => 'normal (%%value%%)',
    'eventhandlers.priorityLow' => 'niedrig (%%value%%)',
    'eventhandlers.priorityLowest' => 'am niedrigsten (%%value%%)',
    'eventhandlers.user' => 'Benutzer',
    'eventhandlers.command' => 'Befehl',
    'eventhandlers.buttonAddNewEventHandler' => 'Ereignis-Handler hinzufügen',
    'eventhandlers.buttonAddNewEventHandlerDescription' => 'Richten Sie einen neuen Ereignis-Handler ein.',
    'eventhandlers.buttonRemove' => 'Entfernen',
    'eventhandlers.buttonRemoveDescription' => 'Entfernen Sie die ausgewählten Ereignis-Handler.',
    'eventhandlers.confirmOnDelete' => 'Die ausgewählten Ereignis-Handler entfernen?',

    'firewallicmprules.status' => 'Status',
    'firewallicmprules.on' => 'Die Regel ist aktiv.',
    'firewallicmprules.off' => 'Die Regel ist nicht aktiv.',
    'firewallicmprules.name' => 'Regelname',
    'firewallicmprules.allowinboundrouterrequest' => 'Eingehende Routeranfrage zulassen',
    'firewallicmprules.allowinboundtimestamprequest' => 'Eingehende Zeitstempelanfrage zulassen',
    'firewallicmprules.allowinboundmaskrequest' => 'Eingehende Maskenanfrage zulassen',
    'firewallicmprules.allowoutboundsourcequench' => 'Ausgehende Quelldrosselung zulassen',
    'firewallicmprules.allowoutboundparameterproblem' => 'Ausgehendes Parameterproblem zulassen',
    'firewallicmprules.allowredirect' => 'Umleitung zulassen',
    'firewallicmprules.allowinboundechorequest' => 'Eingehende Echoanfrage zulassen',
    'firewallicmprules.allowoutboundtimeexceeded' => 'Ausgehende Zeitüberschreitung zulassen',
    'firewallicmprules.allowoutbounddestinationunreachable' => 'Nicht verfügbares ausgehendes Ziel zulassen',

    'firewallinterfaces.firewall' => 'Firewall-Status',
    'firewallinterfaces.firewallOn' => 'Die Firewall ist für diese Netzwerkschnittstellen aktiviert.',
    'firewallinterfaces.firewallOff' => 'Die Firewall ist für diese Netzwerkschnittstellen deaktiviert.',
    'firewallinterfaces.connection' => 'Status der Schnittstelle',
    'firewallinterfaces.connectionOn' => 'Netzwerkschnittstellenverbindung ist aktiviert.',
    'firewallinterfaces.connectionOff' => 'Netzwerkschnittstellenverbindung ist deaktiviert.',
    'firewallinterfaces.name' => 'Schnittstellenname',
    'firewallinterfaces.type' => 'Schnittstellentyp',
    'firewallinterfaces.statusOn' => 'An',
    'firewallinterfaces.statusOff' => 'Aus',

    'firewallrules.status' => 'Status',
    'firewallrules.on' => 'Die Regel ist aktiv.',
    'firewallrules.off' => 'Die Regel ist nicht aktiv.',
    'firewallrules.name' => 'Regelname',
    'firewallrules.description' => 'Beschreibung',
    'firewallrules.descriptionText' => '%%action%% eingehende Verbindungen von %%from%% auf Port %%port%%, Profile: %%profiles%%',
    'firewallrules.allow' => 'Zulassen',
    'firewallrules.block' => 'Verweigern',
    'firewallrules.fromAll' => 'Alle',
    'firewallrules.groupAdd' => 'Hinzufügen',
    'firewallrules.buttonAdd' => 'Regel hinzufügen',
    'firewallrules.buttonAddHint' => 'Fügen Sie eine Firewallregel hinzu',
    'firewallrules.groupActions' => 'Aktionen',
    'firewallrules.buttonRemove' => 'Entfernen',
    'firewallrules.removeEmptySelection' => 'Keine Firewall-Regeln ausgewählt.',
    'firewallrules.removeConfirmation' => 'Entfernen Sie {count, plural, =1 {die {name} Firewall-Regel} one {die # ausgewählte Firewall-Regel} other {die # ausgewählte Firewall-Regeln}}?',
    'firewallrules.removeSuccess' => 'Die ausgewählten Firewall-Regeln wurden entfernt.',

    'ftpsessions.buttonRemove' => 'Schließen',
    'ftpsessions.buttonRemoveDescription' => 'Ausgewählte FTP-Sitzungen schließen',
    'ftpsessions.buttonRefresh' => 'Aktualisieren',
    'ftpsessions.buttonRefreshDescription' => 'Aktualisieren Sie die Daten auf dieser Seite',
    'ftpsessions.typeColumnName' => 'T',
    'ftpsessions.statusColumnName' => 'S',
    'ftpsessions.loginColumnName' => 'Benutzername',
    'ftpsessions.domainColumnName' => 'Domainname',
    'ftpsessions.currentLocationColumnName' => 'Aktueller Speicherort',
    'ftpsessions.fileNameColumnName' => 'Dateiname',
    'ftpsessions.speedColumnName' => 'Geschwindigkeit (KB/s)',
    'ftpsessions.progressColumnName' => 'Fortschritt (%)',
    'ftpsessions.ipAddressColumnName' => 'IP-Adresse',
    'ftpsessions.logonTimeColumnName' => 'Anmeldezeit',
    'ftpsessions.idleTimeColumnName' => 'Ruhezeit',
    'ftpsessions.sessionTypeDomainAdminTooltip' => 'Domainadministrator-Sitzung.',
    'ftpsessions.sessionTypeSubDomainAdminTooltip' => 'Subdomainadministrator-Sitzung.',
    'ftpsessions.sessionTypeWebUserTooltip' => 'Webbenutzer-Sitzung.',
    'ftpsessions.sessionTypeFtpAccountTooltip' => 'FTP-Konto-Sitzung.',
    'ftpsessions.sessionTypeAnonymousTooltip' => 'Anonymous-FTP-Benutzersitzung.',
    'ftpsessions.sessionTypeNotPleskUserTooltip' => 'FTP-Benutzer, der nicht in Plesk registriert ist.',
    'ftpsessions.sessionStatusIdle' => 'Leerlauf (keine Transaktionen).',
    'ftpsessions.sessionStatusUploadInProgress' => 'Upload läuft.',
    'ftpsessions.sessionStatusDownloadInProgress' => 'Download läuft.',
    'ftpsessions.sessionStatusDownloadingDirsList' => 'Verzeichnisliste wird heruntergeladen.',
    'ftpsessions.sessionStatusLastCmdIsType' => 'Der letzte Befehl, der durch den Kunden gesendet wurde, ist TYPE.',
    'ftpsessions.sessionStatusLastCmdIsPass' => 'Der letzte Befehl, der durch den Kunden gesendet wurde, ist PASS.',
    'ftpsessions.sessionStatusLastCmdIsNoop' => 'Der letzte Befehl, der durch den Kunden gesendet wurde, ist NOOP.',
    'ftpsessions.sessionStatusNotKnown' => 'FTP-Aktivität nicht erkannt.',
    'ftpsessions.confirmOnDelete' => 'Möchten Sie die ausgewählten Sitzungen wirklich beenden?',

    'ipaddresses.buttonAddNewIpAddress' => 'IP-Adresse hinzufügen',
    'ipaddresses.buttonAddNewIpAddressDescription' => 'IP-Adresse zum Serverpool mit den IP-Adressen hinzufügen',
    'ipaddresses.buttonRereadConfiguration' => 'IP neu lesen',
    'ipaddresses.buttonRereadConfigurationDescription' => 'Synchronisieren Sie die Liste mit den IP-Adressen, mit der Konfiguration der Netzwerkadapter.',
    'ipaddresses.buttonReloadPublic' => 'Öffentliche IP-Adressen aktualisieren',
    'ipaddresses.buttonReloadPublicDescription' => 'Öffentliche IP-Adresse basierend auf Metadaten der Hyperscaler-Instanz aktualisieren',
    'ipaddresses.buttonFirewall' => 'Firewall',
    'ipaddresses.buttonFirewallDescription' => 'Firewall einrichten.',
    'ipaddresses.buttonRemove' => 'Entfernen',
    'ipaddresses.buttonRemoveDescription' => 'Entfernen',
    'ipaddresses.confirmOnDelete' => 'Wollen Sie die ausgewählten IP-Adressen entfernen?',
    'ipaddresses.address' => 'IP-Adresse',
    'ipaddresses.publicAddress' => 'Öffentliche IP-Adresse',
    'ipaddresses.type' => 'IP-Typ',
    'ipaddresses.interface' => 'Schnittstelle',
    'ipaddresses.resellerCount' => 'Reseller',
    'ipaddresses.subscriptionCount' => 'Websites',
    'ipaddresses.typeAny' => 'Beliebig',
    'ipaddresses.typeShared' => 'Gemeinsam genutzt',
    'ipaddresses.typeExclusive' => 'Dediziert',
    'ipaddresses.typeSharedHint' => 'gemeinsam genutzt',
    'ipaddresses.typeExclusiveHint' => 'dediziert',
    'ipaddresses.ipAddressBroken' => 'Diese IP-Adresse wurde nicht richtig konfiguriert.',
    'ipaddresses.ipAddressBlacklisted' => 'Diese IP-Adresse befindet sich auf der Blacklist.',
    'ipaddresses.repair' => 'Reparieren',
    'ipaddresses.buttonSearch' => 'Suchen',
    'ipaddresses.buttonResetSearch' => 'Suche zurücksetzen',
    'ipaddresses.removeConfirmation' => 'Sind Sie sicher, dass Sie {count, plural, =1 {die {name} IP-Adresse} one {die # ausgewählte IP-Adresse} other {die # ausgewählten IP-Adressen}} entfernen möchten?',
    'ipaddresses.hint' => 'IP-Adressen anzeigen, hinzufügen und entfernen',
    'ipaddresses.hintWithResellers' => 'IP-Adressen anzeigen, hinzufügen und entfernen; Resellern IP-Adressen zuweisen.',
    'ipaddresses.repairSuccess' => 'Die IP-Adresse %%address%% wurde mit dem System synchronisiert.',
    'ipaddresses.removeSuccess' => 'Die ausgewählten IP-Adressen wurden entfernt.',

    'languages.headerStatus' => 'S',
    'languages.headerCode' => 'Sprachpaket',
    'languages.headerLanguage' => 'Sprache',
    'languages.headerCountry' => 'Land',
    'languages.headerUsed' => 'Verwendet',
    'languages.filterCode' => 'Sprachpaket',
    'languages.buttonDisable' => 'Deaktivieren',
    'languages.buttonDisableDescription' => 'Deaktivieren Sie die ausgewählten Sprachen für Benutzer.',
    'languages.disableDone' => 'Die ausgewählten Sprachen sind nicht mehr für Benutzer verfügbar.',
    'languages.buttonEnable' => 'Aktivieren',
    'languages.buttonEnableDescription' => 'Aktivieren Sie die ausgewählten Sprachen für Benutzer.',
    'languages.enableDone' => 'Die ausgewählten Sprachen sind für Benutzer verfügbar.',
    'languages.buttonMakeDefault' => 'Als Standard verwenden',
    'languages.buttonMakeDefaultDescription' => 'Definieren Sie die ausgewählte Sprache als Standardsprache für Plesk.',
    'languages.makeDefaultDone' => 'Die ausgewählte Sprache wurde als Standard für Plesk festgelegt.',
    'languages.makeDefaultSelectOne' => 'Wählen Sie eine Sprache aus, die Sie als Standardsprache für Plesk definieren möchten.',
    'languages.statusActive' => 'Diese Sprache ist für Plesk Benutzer verfügbar.',
    'languages.statusActiveUnavailable' => 'Diese Sprache ist nicht mehr für Benutzer verfügbar, da Ihr Limit an zulässigen Sprachen überschritten wurde.',
    'languages.buttonHintStatusActive' => 'Klicken Sie auf dieses Symbol, um die Sprache für Benutzer zu deaktivieren.',
    'languages.statusInactive' => 'Diese Sprache ist für die Benutzer nicht verfügbar.',
    'languages.buttonHintStatusInactive' => 'Klicken Sie auf dieses Symbol, um die Sprache für Benutzer bereitzustellen.',
    'languages.buttonHintStatusDefaultLangugage' => 'Dies ist die Standardsprache. Sie muss für die Benutzer verfügbar sein.',
    'languages.langUnknown' => 'Sprache wurde nicht erkannt',
    'languages.countryUnknown' => 'Ländercode für Spracheinstellung wurde nicht erkannt.',

    'mailqueue.filterQueue' => 'Warteschlangen',
    'mailqueue.filterSubject' => 'Betreff',
    'mailqueue.filterSender' => 'Absender',
    'mailqueue.filterRecipients' => 'Empfänger',
    'mailqueue.subject' => 'Betreff',
    'mailqueue.sender' => 'Absender',
    'mailqueue.recipients' => 'Empfänger',
    'mailqueue.date' => 'Datum',
    'mailqueue.age' => 'Alter',
    'mailqueue.size' => 'Größe',
    'mailqueue.buttonRefresh' => 'Aktualisieren',
    'mailqueue.buttonRefreshHint' => 'Aktualisieren Sie die Daten auf der Seite.',
    'mailqueue.buttonRemove' => 'Entfernen',
    'mailqueue.buttonRemoveHint' => 'Entfernen Sie die ausgewählten Nachrichten aus der E-Mail-Warteschlange.',
    'mailqueue.confirmOnDelete' => 'Möchten Sie die ausgewählten Nachrichten wirklich aus der E-Mail-Warteschlange entfernen?',
    'mailqueue.buttonClean' => 'Löschen',
    'mailqueue.buttonCleanHint' => 'Löschen Sie alle Nachrichten aus der Mail-Warteschlange.',
    'mailqueue.confirmOnClean' => 'Möchten Sie die E-Mail-Warteschlange wirklich löschen?',
    'mailqueue.queueAll' => 'Alle',
    'mailqueue.queueTodo' => 'Nicht vorverarbeitet',
    'mailqueue.queueRemote' => 'Remote',
    'mailqueue.queueLocal' => 'Lokal',
    'mailqueue.queueLocalAndRemote' => 'Lokal und Remote',
    'mailqueue.queueActive' => 'Warteschlange aktive Nachrichten',
    'mailqueue.queueCorrupted' => 'Warteschlange fehlerhafte Nachrichten',
    'mailqueue.queueDeferred' => 'Warteschlange zurückgestellte Nachrichten',
    'mailqueue.queueHold' => 'Warteschlange auf Halten gesetzte Nachrichten',
    'mailqueue.queueIncoming' => 'Warteschlange eingehende Nachrichten',
    'mailqueue.postfixHint' => 'Nachrichten in Warteschlange: %%deferred%% zurückgestellt, %%hold%% angehalten, %%incoming%% eingehend, %%active%% aktiv, %%corrupted%% fehlerhaft, %%total%% gesamt.',
    'mailqueue.qmailHint' => 'Nachrichten in Warteschlange: %%todo%% nicht bearbeitet, %%local%% lokal, %%remote%% remote, %%total%% gesamt.',
    'mailqueue.messagesDeleted' => 'Die ausgewählten Nachrichten wurden aus der Mail-Warteschlange entfernt.',
    'mailqueue.messagesNotDeleted' => 'Einige Nachrichten können nicht aus der Mail-Warteschlange entfernt werden: %%error%%',
    'mailqueue.queueCleaned' => 'Die Mail-Warteschlange wurde erfolgreich gelöscht.',
    'mailqueue.queueNotCleaned' => 'Die Mail-Warteschlange kann nicht gelöscht werden: %%error%%.',

    'phpextensions.enable' => 'Erweiterung aktivieren',
    'phpextensions.disable' => 'Erweiterung deaktivieren',

    'phpextensions.installable.status' => 'Status',
    'phpextensions.installable.notInstalled' => 'Nicht installiert',
    'phpextensions.installable.outdated' => 'Veraltet, die neueste Version ist %%latestVersion%%',
    'phpextensions.installable.latest' => 'Neueste',
    'phpextensions.installable.name' => 'Paket',
    'phpextensions.installable.description' => 'Beschreibung',
    'phpextensions.installable.actionInstall' => 'Installieren',
    'phpextensions.installable.actionUpgrade' => 'Auf %%version%% aktualisieren',
    'phpextensions.installable.actionDocs' => 'Dokumentation',
    'phpextensions.installable.actionUninstall' => 'Deinstallieren',
    'phpextensions.installable.uninstallConfirmation' => 'Sind Sie sicher, dass Sie das Paket %%name%% deinstallieren möchten?',
    'phpextensions.installable.groupInstall' => 'Installieren',
    'phpextensions.installable.groupReload' => 'Neu laden',
    'phpextensions.installable.buttonInstallCustom' => 'Paket installieren',
    'phpextensions.installable.buttonInstallCustomHint' => 'Installieren Sie ein beliebiges PECL-Paket',
    'phpextensions.installable.buttonReload' => 'Neu laden',
    'phpextensions.installable.buttonReloadHint' => 'PECL-Pakete neu laden',
    'phpextensions.installable.emptyViewFilteredTitle' => 'Keine mit dem Filter übereinstimmende Pakete gefunden',
    'phpextensions.installable.emptyViewFilteredDescription' => 'Versuchen Sie, das Paket zu installieren, nach dem Sie suchen.',

    'phphandlers.name' => 'Handler',
    'phphandlers.domains' => 'Domains',
    'phphandlers.statusBroken' => 'Dieser Handler ist beschädigt.',
    'phphandlers.statusDisallowedApacheModule' => 'Der Handler kann nicht aktiviert werden, da das zugehörige Apache-Modul ausgeschaltet ist.',
    'phphandlers.domainsTitle' => '%%domains%% Domains verwenden PHP %%handler%%',
    'phphandlers.closeTitle' => 'Schließen',
    'phphandlers.handlerOutdated' => '(Überholt)',
    'phphandlers.handlerDeprecated' => '(Veraltet)',
    'phphandlers.handlerOutdatedAndDeprecated' => '(Überholt, Veraltet)',

    'planitems.name' => 'Name',
    'planitems.numberOfPlans' => 'Service-Pakete',
    'planitems.numberOfSubscriptions' => 'Abonnements',
    'planitems.itemInvisible' => 'Nicht verfügbar für Reseller',
    'planitems.buttonMakeItemVisible' => 'Zur Verfügung stellen',
    'planitems.buttonMakeItemVisibleDescription' => 'Lassen Sie zu, dass Reseller die ausgewählten Services mit ihren eigenen Hosting-Paketen bereitstellen. Die Optionen zu diesen Services werden in den Hosting-Paketeigenschaften auf der Registerkarte "Zusätzliche Services" angezeigt.',
    'planitems.buttonMakeItemInvisible' => 'Verfügbarkeit aufheben',
    'planitems.buttonMakeItemInvisibleDescription' => 'Verhindern Sie, dass Reseller die ausgewählten Services mit ihren Hosting-Paketen bereitstellen. Die Optionen zu diesen Services werden von den Hosting-Paketeigenschaften entfernt.',
    'planitems.buttonAddNewCustomItemButton' => 'Service hinzufügen',
    'planitems.buttonAddNewCustomItemButtonDescription' => 'Fügen Sie einen Service zu den Paketoptionen hinzu.',
    'planitems.buttonRemoveCustomItem' => 'Service entfernen',
    'planitems.buttonRemoveCustomItemDescription' => 'Entfernen Sie die Optionen zu den ausgewählten Services von den Hosting-Paketeigenschaften.',
    'planitems.confirmOnDeleteSupportButton' => 'Sind Sie sicher, dass Sie die ausgewählten Optionen entfernen möchten?',

    'pumpackages.buttonUpdate' => 'Aktualisieren',
    'pumpackages.buttonUpdateDescription' => 'Aktualisieren Sie die ausgewählten Pakete.',
    'pumpackages.buttonLock' => 'Sperren',
    'pumpackages.buttonLockDescription' => 'Sperren Sie die ausgewählten Pakete, um Updates zu verhindern.',
    'pumpackages.buttonUnlock' => 'Entsperren',
    'pumpackages.buttonUnlockDescription' => 'Entsperren Sie die ausgewählten Pakete, um Updates zu ermöglichen.',
    'pumpackages.buttonCheckUpdates' => 'Nach Updates suchen',
    'pumpackages.buttonCheckUpdatesDescription' => 'Suchen Sie nach Paket-Updates.',
    'pumpackages.name' => 'Paket',
    'pumpackages.summary' => 'Beschreibung',
    'pumpackages.updates' => 'Updates',
    'pumpackages.lockedCut' => 'L',
    'pumpackages.lockedHint' => 'Das Paket ist gesperrt.',
    'pumpackages.unlockedHint' => 'Das Paket ist entsperrt.',
    'pumpackages.updated' => 'Auf dem aktuellen Stand',
    'pumpackages.update' => 'Auf %%version%% aktualisieren',
    'pumpackages.unknownRepo' => 'unbekannt',
    'pumpackages.allUpToDate' => 'Alle Pakete sind auf dem neuesten Stand',
    'pumpackages.allUpToDateLastChecked' => 'Überprüft am %%date%%',
    'pumpackages.recheckUpdates' => 'Jetzt erneut überprüfen',
    'pumpackages.popupInfoTitle' => 'Paketdetails zu %%package%%',
    'pumpackages.loading' => 'Bitte warten...',
    'pumpackages.error' => 'Paketliste konnte nicht abgerufen werden: %%message%%',
    'pumpackages.currentVersion' => 'Aktuelle Version: %%version%%',
    'pumpackages.notInstalled' => 'nicht installiert',
    'pumpackages.popupUpdateTitle' => 'Pakete aktualisieren',
    'pumpackages.popupUpdatePackagesListTitle' => 'Folgende Updates installieren:',
    'pumpackages.popupUpdateLockedPackagesListTitle' => 'Für die folgenden erforderlichen Pakete wurden Updates gesperrt:',
    'pumpackages.popupUpdateDependencies' => '%%count%% abhängige Pakete',
    'pumpackages.unlockPackagesForUpdateOnly' => 'Pakete entsperren, um nur dieses Update zu ermöglichen',
    'pumpackages.lockedError' => 'Im Tool für Systemupdates ist die automatische Installation von Updates festgelegt. Versuchen Sie es später erneut.',
    'pumpackages.duplicatesError' => 'Fehler: Informationen zu Updates können nicht empfangen werden, da einige Pakete Duplikate enthalten. Entfernen Sie die Duplikate der folgenden Pakete: %%duplicates%%',
    'pumpackages.updateInfoError' => 'Fehler: Für die Pakete können keine Informationen zu Updates erhalten werden',
    'pumpackages.selectedPackagesUpToDate' => 'Alle ausgewählten Pakete sind auf dem neuesten Stand.',
    'pumpackages.taskUpdatingPackages' => 'Aktualisieren von %%count%% Paket(en)...',
    'pumpackages.popupLockTitle' => 'Pakete sperren',
    'pumpackages.popupLockDescription' => 'Wenn Sie ein Paket sperren, wird es nicht vom Tool für Systemupdates aktualisiert, außer Sie aktualisieren Plesk. Wenn andere Pakete eine neuere Version dieses Pakets benötigen, werden jene nicht aktualisiert. Beachten Sie, dass Sie gesperrte Pakete über systemeigene Funktionen in der Konsole aktualisieren können. Um ein gesperrtes Paket in der Plesk Benutzeroberfläche zu aktualisieren, entsperren Sie es zuerst.',
    'pumpackages.popupLockPackagesListTitle' => 'Folgende Pakete sperren:',
    'pumpackages.popupUnlockTitle' => 'Pakete entsperren',
    'pumpackages.popupUnlockDescription' => 'Diese Pakete können nicht aktualisiert werden. Sie wurden gesperrt, um Updates zu verhindern. Beachten Sie, dass Sie gesperrte Pakete über systemeigene Funktionen in der Konsole oder während eines Updates von Plesk aktualisieren können. Um ein gesperrtes Paket in der Plesk Benutzeroberfläche zu aktualisieren, entsperren Sie es zuerst.',
    'pumpackages.popupUnlockPackagesListTitle' => 'Folgende Pakete entsperren:',
    'pumpackages.updatesAvailable' => 'Updates für %%count%% Systempakete sind verfügbar',
    'pumpackages.lastedChecked' => '(überprüft am %%date%%)',
    'pumpackages.updateAll' => 'Alle aktualisieren',
    'pumpackages.packageManagerDbInconsistent' => 'Die Informationen für einige Pakete sind möglicherweise nicht auf aktuellem Stand: In der Datenbank des Systempaketmanagers wurden Inkonsistenzen gefunden. Beheben Sie dieses Problem manuell.',

    'resellers.filterResellerName' => 'Reseller-Name',
    'resellers.filterSubscription' => 'Abonnement',
    'resellers.filterOptionSubscriptionAny' => 'Beliebig',
    'resellers.filterOptionSubscriptionCustom' => 'Benutzerdefiniert',
    'resellers.filterResourceUsage' => 'Ressourcenauslastung',
    'resellers.filterOptionResourceUsageAny' => 'Beliebig',
    'resellers.filterOptionResourceUsageOveruse' => 'Überbeanspruchte Ressourcen',
    'resellers.filterOptionResourceUsageOk' => 'Innerhalb der Grenzen',
    'resellers.filterStatus' => 'Status',
    'resellers.filterOptionStatusAny' => 'Beliebig',
    'resellers.filterOptionStatusSuspended' => 'Gesperrt',
    'resellers.filterOptionStatusActive' => 'Aktiv',
    'resellers.filterSubscriptionStatus' => 'Abonnementstatus',
    'resellers.filterOptionSubscriptionStatusAny' => 'Beliebig',
    'resellers.filterOptionSubscriptionStatusLocked' => 'Gesperrt',
    'resellers.filterOptionSubscriptionStatusUnsynchronized' => 'Nicht synchronisiert',
    'resellers.filterDescription' => 'Beschreibung',
    'resellers.buttonAddNewReseller' => 'Reseller hinzufügen',
    'resellers.hintAddNewReseller' => 'Erstellen Sie ein Reseller-Konto.',
    'resellers.buttonRemove' => 'Entfernen',
    'resellers.hintRemove' => 'Entfernen Sie die ausgewählten Reseller mitsamt aller ihrer Service-Pakete, Kunden und Abonnements.',
    'resellers.confirmOnDelete' => 'Möchten Sie {count, plural, =1 {das Reseller-Konto {name}} one {das ausgewählte Reseller-Konto} other {die # ausgewählten Reseller-Konten}} und alle {count, plural, one {seine} other {ihre}} Servicepakete, Kunden und Abonnements wirklich entfernen?',
    'resellers.buttonConvertToCustomer' => 'In Kunden umwandeln',
    'resellers.hintConvertToCustomer' => 'Wandeln Sie die ausgewählten Reseller in Kunden um.',
    'resellers.buttonChangeStatus' => 'Status ändern',
    'resellers.buttonActivateResellers' => 'Aktivieren',
    'resellers.hintActivateResellers' => 'Aktivieren Sie die ausgewählten Reseller-Konten.',
    'resellers.buttonSuspendResellers' => 'Sperren',
    'resellers.hintSuspendResellers' => 'Sperren Sie die ausgewählten Reseller-Konten. Der Zugang zum Kunden-Panel wird für die Reseller und alle ihre Kunden blockiert; die Domains der Reseller und ihrer Kunden werden gesperrt, ihre Web-, FTP- und E-Mail-Services werden nicht länger für Internetnutzer zugänglich sein.',
    'resellers.resellerName' => 'Reseller-Name',
    'resellers.planName' => 'Service-Paket',
    'resellers.setupDate' => 'Einrichtungsdatum',
    'resellers.customers' => 'Kunden',
    'resellers.customPlanName' => 'Benutzerdefiniert',
    'resellers.buttonLogin' => 'Als Reseller anmelden',
    'resellers.hintLogin' => 'Verwalten Sie die Hosting-Services, die mit dem Hosting-Konto des Resellers in Verbindung stehen.',
    'resellers.statusOk' => 'Der Status dieses Reseller-Kontos ist OK: Das Konto ist aktiv, das Abonnement wurde mit dem Paket synchronisiert.',
    'resellers.statusSuspended' => 'Dieses Reseller-Konto ist gesperrt: Der Zugang zum Kunden-Panel wurde für den Reseller und alle seine Kunden gesperrt; die Domains des Resellers und seiner Kunden wurden gesperrt, ihre Web-, FTP- und E-Mail-Services sind nicht länger für Internetnutzer zugänglich.',
    'resellers.statusLocked' => 'Das Abonnement wurde für die Synchronisierung gesperrt: Es ist von der Synchronisierung mit dem Service-Paket ausgeschlossen, da Abonnement-Parameter angepasst wurden.',
    'resellers.statusUnsynchronized' => 'Das Abonnement wurde nicht mit dem Reseller-Paket synchronisiert: Es gibt einige Services oder Ressourcen, die das Reseller-Paket anbietet, aber die das Abonnement nicht zur Verfügung stellt.',

    'resellerserviceplans.planName' => 'Paket-Name',
    'resellerserviceplans.planTraffic' => 'Verkehr',
    'resellerserviceplans.planDiskSpace' => 'Speicherplatz',
    'resellerserviceplans.planSubscriptions' => 'Reseller',
    'resellerserviceplans.unlimited' => 'Unbegrenzt',
    'resellerserviceplans.buttonAddNewPlan' => 'Paket hinzufügen',
    'resellerserviceplans.hintAddNewPlan' => 'Erstellen Sie ein Resellerpaket.',
    'resellerserviceplans.buttonDuplicatePlans' => 'Paket klonen',
    'resellerserviceplans.hintDuplicatePlans' => 'Erstellen Sie Kopien der ausgewählten Reseller-Pakete.',
    'resellerserviceplans.buttonRemove' => 'Entfernen',
    'resellerserviceplans.hintRemove' => 'Entfernen Sie die ausgewählten Reseller-Pakete.',
    'resellerserviceplans.confirmOnDelete' => 'Möchten Sie die ausgewählten Reseller-Pakete wirklich entfernen?',
    'resellerserviceplans.disabledSelectHint' => 'Reseller-Pakete mit mindestens einem zugehörigen Abonnement können nicht entfernt werden.',

    'restricteddomains.name' => 'Domainname',
    'restricteddomains.buttonAddNewDomain' => 'Domainnamen hinzufügen',
    'restricteddomains.buttonEnableList' => 'Aktivieren',
    'restricteddomains.hintAddNewDomain' => 'Fügen Sie einen unzulässigen Domainnamen hinzu.',
    'restricteddomains.hintEnableList' => 'Schalten Sie die Überprüfung des Domainnamens während der Domainerstellung ein.',
    'restricteddomains.buttonDisableList' => 'Deaktivieren',
    'restricteddomains.hintDisableList' => 'Schalten Sie die Überprüfung des Domainnamens während der Domainerstellung aus.',
    'restricteddomains.buttonRemoveDomain' => 'Entfernen',
    'restricteddomains.hintRemoveDomain' => 'Entfernen Sie die ausgewählten Domainnamen.',
    'restricteddomains.confirmOnRemove' => 'Entfernen Sie die ausgewählten Domainnamen?',
    'restricteddomains.buttonMoreActions' => 'Mehr',

    'servermailblacklist.groupAdd' => 'Hinzufügen',
    'servermailblacklist.buttonAdd' => 'Domain hinzufügen',
    'servermailblacklist.buttonAddHint' => 'Domains zur Sperrliste hinzufügen',
    'servermailblacklist.groupActions' => 'Aktionen',
    'servermailblacklist.buttonRemove' => 'Entfernen',
    'servermailblacklist.entries' => 'Einträge',
    'servermailblacklist.action' => 'Aktion',
    'servermailblacklist.deleteAction' => 'Vom Server entfernen',
    'servermailblacklist.spamAction' => 'Als Spam kennzeichnen',
    'servermailblacklist.spamAssassinDisabled' => 'Die Einträge werden nicht als Spam gekennzeichnet, da SpamAssassin nicht installiert oder deaktiviert ist',
    'servermailblacklist.removeEmptySelection' => 'Keine Einträge ausgewählt.',
    'servermailblacklist.removeConfirmation' => 'Entfernen Sie {count, plural, =1 {der {name} Eintrag} one {der # ausgewählte Eintrag} other {die # ausgewählten Einträge}}?',
    'servermailblacklist.removeSuccess' => 'Die ausgewählten Einträge wurden entfernt.',

    'servermailwhitelist.groupAdd' => 'Hinzufügen',
    'servermailwhitelist.buttonAdd' => 'Hinzufügen',
    'servermailwhitelist.buttonAddHint' => 'Fügen Sie das Netzwerkl zur Zulassungsliste hinzu',
    'servermailwhitelist.groupActions' => 'Aktionen',
    'servermailwhitelist.buttonRemove' => 'Entfernen',
    'servermailwhitelist.entries' => 'Einträge',
    'servermailwhitelist.whiteListNotEmpty' => 'Die Grenzen für ausgehende E-Mails greifen nicht für E-Mail-Absender, deren IP-Adressen sich in der Whitelist des Mailservers befinden. Wenn sich zum Beispiel localhost (127.0.0.0 / 8, ::1 / 128) in der Whitelist befindet, werden alle E-Mails vom lokalen Server ungeachtet etwaiger Begrenzungen gesendet. E-Mail-Sender können entweder lokale IP-Adressen verwenden (Websites und benutzerdefinierte Skripte, die auf dem lokalen Server gehostet werden) oder externe IP-Adressen (Kunden, die E-Mails von Mailclients senden, die auf ihrem Computer oder Mobilgerät installiert sind). Wenn die Grenzen für alle E-Mail-Sender (sowohl lokal als auch extern) greifen sollen, müssen Sie alle IP-Adressen und Netzwerke aus der Whitelist entfernen. Beachten Sie, dass das Entfernen von localhost (127.0.0.0 / 8, ::1 / 128) aus der Whitelist die Funktion von Websites und Skripten, die E-Mails von diesem Server senden, stören kann. Einzelheiten zu Begrenzungen für ausgehende E-Mails finden Sie im Administrator-Handbuch, Abschnitt "Schutz vor ausgehendem Spam".',
    'servermailwhitelist.removeEmptySelection' => 'Keine Einträge ausgewählt.',
    'servermailwhitelist.removeConfirmation' => 'Entfernen Sie {count, plural, =1 {der {name} Eintrag} one {der # ausgewählte Eintrag} other {die # ausgewählten Einträge}}?',
    'servermailwhitelist.webmailAffected' => 'Das Entfernen der folgenden {count, plural, =1 {Netzwerk} one {Netzwerk} other {Netzwerke}} könnte das Senden von E-Mails aus Webmail unmöglich machen: %%list%%',
    'servermailwhitelist.webmailAffectedSingle' => 'Wird dieses Netzwerk entfernt, kann das Senden von E-Mails aus Webmail unmöglich werden.',
    'servermailwhitelist.removeSuccess' => 'Die ausgewählten Einträge wurden entfernt.',

    'serverprotection.bannedips.pageHint' => 'Hier können Sie die gesperrten IP-Adressen einsehen, sie entsperren oder sie zur Liste der vertrauenswürdigen IP-Adressen hinzufügen.',
    'serverprotection.bannedips.ip' => 'IP-Adresse',
    'serverprotection.bannedips.banDate' => 'Gesperrt am',
    'serverprotection.bannedips.jail' => 'Verwendete Jail',
    'serverprotection.bannedips.buttonRemoveIp' => 'Aktivieren',
    'serverprotection.bannedips.hintRemoveIp' => 'Entfernen Sie die ausgewählten IP-Adressen von der Liste der gesperrten Adressen.',
    'serverprotection.bannedips.buttonMoveToTrustedIp' => 'Zu vertrauenswürdigen IPs',
    'serverprotection.bannedips.hintMoveToTrustedIp' => 'Fügen Sie die ausgewählten IP-Adressen zur Liste der vertrauenswürdigen Adressen hinzu.',
    'serverprotection.bannedips.buttonEnable' => 'Sperren von IP-Adressen einschalten',
    'serverprotection.bannedips.hintEnable' => 'Aktivieren Sie das automatische Sperren von IP-Adressen und Netzwerken, die schadhaften Traffic für Ihren Server generieren.',
    'serverprotection.bannedips.buttonDisable' => 'Sperren von IP-Adressen ausschalten',
    'serverprotection.bannedips.hintDisable' => 'Deaktivieren Sie das automatische Sperren von IP-Adressen und Netzwerken, die schadhaften Traffic für Ihren Server generieren.',
    'serverprotection.bannedips.errorEnableFailed' => 'Das Sperren von IP-Adressen kann nicht eingeschaltet werden: %%error%%.',
    'serverprotection.bannedips.errorDisableFailed' => 'Das Sperren von IP-Adressen kann nicht ausgeschaltet werden: %%error%%.',

    'serverprotection.filters.pageHint' => 'Hier können Sie Jail-Filter verwalten.',
    'serverprotection.filters.buttonAddFilter' => 'Filter hinzufügen',
    'serverprotection.filters.hintAddFilter' => 'Fügen Sie einen Filter hinzu.',
    'serverprotection.filters.buttonRemoveFilter' => 'Entfernen',
    'serverprotection.filters.hintRemoveFilter' => 'Entfernen Sie die ausgewählten Filter.',
    'serverprotection.filters.name' => 'Name des Filters',

    'serverprotection.jails.pageHint' => 'Hier können Sie die Liste der Jails einsehen, die zur Erkennung missbräuchlicher IP-Adressen genutzt werden.',
    'serverprotection.jails.buttonAddJail' => 'Jail hinzufügen',
    'serverprotection.jails.hintAddJail' => 'Fügen Sie eine Jail hinzu.',
    'serverprotection.jails.buttonDisableJails' => 'Deaktivieren',
    'serverprotection.jails.hintDisableJails' => 'Schalten Sie die ausgewählten Jails aus.',
    'serverprotection.jails.buttonActivateJails' => 'Aktivieren',
    'serverprotection.jails.hintActivateJails' => 'Schalten Sie die ausgewählten Jails ein.',
    'serverprotection.jails.buttonRemoveJail' => 'Entfernen',
    'serverprotection.jails.hintRemoveJail' => 'Entfernen Sie die ausgewählten Jails.',
    'serverprotection.jails.buttonManageFilters' => 'Filter verwalten',
    'serverprotection.jails.hintManageFilters' => 'Hier können Sie Jail-Filter verwalten.',
    'serverprotection.jails.name' => 'Name der Jail',
    'serverprotection.jails.disabled' => 'Inaktiv',
    'serverprotection.jails.active' => 'Aktiv',
    'serverprotection.jails.status' => 'Status',
    'serverprotection.jails.confirmOnDelete' => 'Möchten Sie die ausgewählten Jails wirklich entfernen?',

    'serverprotection.logs.pageHint' => 'Hier können Sie Fail2ban-Protokolle einsehen.',
    'serverprotection.logs.name' => 'Datei',
    'serverprotection.logs.viewHint' => 'Sehen Sie sich die Protokolldatei an.',
    'serverprotection.logs.buttonDownloadHint' => 'Protokolldatei herunterladen',

    'serverprotection.trustedips.pageHint' => 'Hier können Sie die vertrauenswürdigen IP-Adressen einsehen, IP-Adressen hinzufügen und Adressen von der Liste der vertrauenswürdigen IP-Adressen entfernen.',
    'serverprotection.trustedips.ip' => 'IP-Adresse',
    'serverprotection.trustedips.ipDesc' => 'Beschreibung',
    'serverprotection.trustedips.addDate' => 'Als vertrauenswürdig hinzugefügt am',
    'serverprotection.trustedips.comment' => 'Anmerkung',
    'serverprotection.trustedips.buttonRemoveIp' => 'Entfernen',
    'serverprotection.trustedips.hintRemoveIp' => 'Entfernen Sie die ausgewählten IP-Adressen von der Liste der vertrauenswürdigen Adressen.',
    'serverprotection.trustedips.buttonAddTrustedIp' => 'IP hinzufügen',
    'serverprotection.trustedips.hintAddTrustedIp' => 'Fügen Sie eine IP-Adresse zur Liste der vertrauenswürdigen IP-Adressen hinzu.',
    'serverprotection.trustedips.buttonEditTrustedIp' => 'Beschreibung bearbeiten',
    'serverprotection.trustedips.buttonEditHint' => 'Beschreibung einer IP-Adresse bearbeiten.',

    'serviceinstances.name' => 'Service-Name',
    'serviceinstances.type' => 'Service-Typ',
    'serviceinstances.requiredServices' => 'Erforderliche Services',
    'serviceinstances.description' => 'Beschreibung',
    'serviceinstances.buttonAddServiceToSubscription' => 'Service hinzufügen',
    'serviceinstances.buttonAddServiceToSubscriptionHint' => 'Fügen Sie einen Service zum Abonnement hinzu.',
    'serviceinstances.buttonRemove' => 'Entfernen',
    'serviceinstances.buttonRemoveHint' => 'Entfernen Sie die ausgewählten Services.',
    'serviceinstances.confirmOnDelete' => 'Möchten Sie die ausgewählten Services wirklich entfernen?',
    'serviceinstances.isEnabled' => 'Service-Instanz ist aktiviert',
    'serviceinstances.isDisabled' => 'Service-Instanz ist deaktiviert',

    'servicenodes.buttonAddServiceNode' => 'Service Node hinzufügen',
    'servicenodes.buttonAddServiceNodeDescription' => 'Beschreibung des Service Node hinzufügen',
    'servicenodes.buttonRemoveServiceNode' => 'Service Node entfernen',
    'servicenodes.buttonRemoveServiceNodeDescription' => 'Beschreibung des Service Node entfernen',
    'servicenodes.description' => 'Beschreibung',
    'servicenodes.ipAddress' => 'IP-Adresse',
    'servicenodes.confirmOnDelete' => 'Möchten Sie die ausgewählten Service Nodes wirklich entfernen?',
    'servicenodes.disabledSelectHint' => 'Der Service Node kann nicht entfernt werden: Es sind IP-Adressen damit verknüpft.',

    'services.stateColumnHeader' => 'Staat',
    'services.nameColumnHeader' => 'Dienst',
    'services.startupTypeColumnHeader' => 'Starttyp',
    'services.autoStartupType' => 'Automatisch',
    'services.manualStartupType' => 'Manuell',
    'services.disabledStartupType' => 'Deaktiviert',
    'services.changeStartupTypeTooltip' => 'Starttyp für Dienst ändern',
    'services.drwebName' => 'Plesk Premium Antivirus',
    'services.postgresqlName' => 'PostgreSQL',
    'services.tomcatName' => 'Tomcat Java',
    'services.imap-pop3Name' => 'Dovecot IMAP- und POP3-Server',
    'services.pop3Name' => 'Courier-POP3-Server',
    'services.pop3sName' => 'Courier-POP3-Server mit Unterstützung von SSL/TLS',
    'services.imapName' => 'Courier-IMAP-Server',
    'services.imapsName' => 'Courier-IMAP-Server mit Unterstützung von SSL/TLS',
    'services.authdaemonName' => 'Courier-IMAP-Authentifizierungsprogramm',
    'services.dnsName' => 'DNS-Server (%%displayName%%)',
    'services.fail2banName' => 'Sperren von IP-Adressen (Fail2ban)',
    'services.kavName' => 'Kaspersky Antivirus',
    'services.milterName' => "Plesk Milter (%%displayName%%)",
    'services.nginxName' => 'Reverse-Proxy-Server (nginx)',
    'services.smtpName' => 'SMTP-Server (%%displayName%%)',
    'services.spamassassinName' => "SpamAssassin",
    'services.webName' => "Webserver (%%displayName%%)",
    'services.resctrlName' => "Ressourcenkontrolle (Cgroups)",
    'services.activeState' => 'An',
    'services.inActiveState' => 'Aus',
    'services.do-restart' => 'Wird neu gestartet',
    'services.do-start' => 'Wird gestartet',
    'services.do-stop' => 'Wird abgeschaltet',
    'services.do-changeStartup' => 'Wird verarbeitet',
    'services.notConfiguredState' => 'Nicht konfiguriert',
    'services.notInstalledState' => 'Nicht installiert',
    'services.running-start' => 'Dienst wurde bereits gestartet.',
    'services.notRunning-start' => 'Dienst starten.',
    'services.running-stop' => 'Dienst anhalten.',
    'services.notRunning-stop' => 'Dienst wurde bereits angehalten.',
    'services.running-restart' => 'Dienst neu starten.',
    'services.notRunning-restart' => 'Dienst wurde angehalten.',
    'services.startServiceDrWeb' => 'Um den Antivirus-Dienst zu starten, muss die Virenüberprüfung für mindestens ein Postfach aktiviert sein.',
    'services.serviceDisabled' => 'Dieses Feature ist nicht verfügbar, da es entweder von Ihrem Lizenzschlüssel nicht unterstützt wird oder der Dienst nicht installiert bzw. nicht richtig konfiguriert ist.',
    'services.serviceDisabledStartupType' => 'Dienst deaktiviert.',
    'services.phpHandlerSettingsByOsVendor' => '%%displayName%% von Betriebssystemanbieter',
    'services.phpFpm' => 'PHP-FPM %%displayName%%',
    'services.urlrewriteComponentName' => "URL neu schreiben",
    'services.dbconnectorComponentName' => "Datenbank-Connector",
    'services.tomcatComponentName' => 'Apache Tomcat',
    'services.mysqlserverComponentName' => 'MySQL-Server',
    'services.troubleshootingComponentName' => 'Problembehandlung',
    'services.wafComponentName' => 'Web Application Firewall',
    'services.vcsComponentName' => 'Versionskontrollsystem',
    'services.antivirusComponentName' => "Virenschutz",
    'services.databaseComponentName' => "SQL-Server",
    'services.sqladminComponentName' => "MySQL-Webadmin",
    'services.sqladminmysqlComponentName' => "MySQL-Webadmin",
    'services.dnsserverComponentName' => "DNS-Server",
    'services.firewallComponentName' => "Firewall",
    'services.ftpserverComponentName' => "FTP-Server",
    'services.javaComponentName' => "Java",
    'services.mailserverComponentName' => "Mailserver",
    'services.pleskagentComponentName' => "Plesk Agent",
    'services.psaComponentName' => "Plesk",
    'services.scriptComponentName' => "Web-Scripting",
    'services.spamfilterComponentName' => "Spamfilter",
    'services.statsComponentName' => "Webstatistiken",
    'services.stunnelComponentName' => "SSL/TLS-Wrapper",
    'services.webmailComponentName' => "WebMail",
    'services.webpublishComponentName' => "Web-Publishing",
    'services.webserverComponentName' => "Webserver",
    'services.backupsystemComponentName' => 'Backup-System',
    'services.networkComponentName' => 'Netzwerkbetrieb',
    'services.sitebuilderComponentName' => 'Presence Builder',
    'services.sqladminmssqlComponentName' => 'Microsoft SQL-Webadmin',
    'services.saviComponentName' => 'Benutzeroberfläche der Antivirensoftware Sophos',
    'services.waitMessage' => 'Bitte warten',
    'services.buttonRefreshComponents' => 'Aktualisieren',
    'services.searchTitle' => 'Services werden gesucht ...',
    'services.hintRefreshComponents' => 'Liste der Komponenten aktualisieren',

    'sessions.searchTitle' => 'Nach aktiven Sitzungen suchen',
    'sessions.buttonRefresh' => 'Aktualisieren',
    'sessions.buttonRefreshDescription' => 'Synchronisieren Sie die Liste der Sitzungen mit den derzeit geöffneten Sitzungen.',
    'sessions.buttonRemove' => 'Schließen',
    'sessions.buttonRemoveDescription' => 'Schließen Sie die ausgewählten Sitzungen.',
    'sessions.removeConfirmMessage' => 'Möchten Sie die ausgewählten Sitzungen schließen?',
    'sessions.buttonSettings' => 'Sitzungseinstellungen',
    'sessions.buttonSettingsDescription' => 'Sitzungsparameter ändern.',
    'sessions.headerType' => 'T',
    'sessions.headerLogin' => 'Benutzername',
    'sessions.headerIpAddress' => 'IP-Adresse',
    'sessions.headerLogonTime' => 'Anmeldezeit',
    'sessions.headerIdleTime' => 'Ruhezeit',
    'sessions.typeAdmin' => 'Admin-Sitzung.',
    'sessions.typeReseller' => 'Reseller-Sitzung.',
    'sessions.typeClient' => 'Kundensitzung.',
    'sessions.altAdminIcon' => 'Admin',
    'sessions.altResellerIcon' => 'Reseller',
    'sessions.altClientIcon' => 'Kunde',

    'sslcertificates.name' => 'Name',
    'sslcertificates.used' => 'Verwendet',
    'sslcertificates.csrHint' => 'Die CSR-Komponente ist bereitgestellt.',
    'sslcertificates.noCsrHint' => 'Die CSR-Komponente ist nicht bereitgestellt.',
    'sslcertificates.privateKeyHint' => 'Die Komponente des privaten Schlüssels ist bereitgestellt.',
    'sslcertificates.noPrivateKeyHint' => 'Die Komponente des privaten Schlüssels ist nicht bereitgestellt.',
    'sslcertificates.certificateHint' => 'Die Zertifikatskomponente ist bereitgestellt.',
    'sslcertificates.noCertificateHint' => 'Die Zertifikatskomponente ist nicht bereitgestellt.',
    'sslcertificates.caCertificateHint' => 'Die CA-Zertifikatskomponente ist bereitgestellt.',
    'sslcertificates.noCaCertificateHint' => 'Die CA-Zertifikatskomponente ist nicht bereitgestellt.',
    'sslcertificates.buttonDownloadHint' => 'Laden Sie alle Zertifikatskomponenten herunter.',
    'sslcertificates.remove' => 'Entfernen',
    'sslcertificates.hintRemove' => 'Entfernen Sie die ausgewählten SSL/TLS-Zertifikate aus dem Domain-Repository.',
    'sslcertificates.confirmOnDelete' => 'Möchten Sie die ausgewählten SSL/TLS-Zertifikate entfernen?',
    'sslcertificates.addCertificate' => 'Hinzufügen',
    'sslcertificates.hintAddCertificate' => 'Fügen Sie ein SSL/TLS-Zertifikat hinzu.',
    'sslcertificates.viewCertificates' => 'Anzeigen',
    'sslcertificates.hintViewCertificates' => 'Rufen Sie die Liste der SSL/TLS-Zertifikate auf, die Sie bei Ihrem Provider erworben haben.',
    'sslcertificates.unableSetupPanelCertificate' => 'Das Zertifikat kann nicht in Plesk installiert werden: Der private Schlüssel und die Zertifikatsinhalte fehlen.',
    'sslcertificates.makeDefault' => 'Als Standard verwenden',
    'sslcertificates.hintMakeDefault' => 'Verwenden Sie das ausgewählte SSL/TLS-Zertifikat zum Sichern der Verbindungen zu neu erstellten Websites.',
    'sslcertificates.unableMakeDefault' => 'Das Standard-Zertifikat kann nicht installiert werden: Es wurde kein Zertifikat mit privatem Schlüssel ausgewählt.',
    'sslcertificates.successMakeDefault' => 'Das ausgewählte SSL/TLS-Zertifikat wurde als Standard festgelegt. Sie können es zum Schutz bestehender und neu erstellter Websites einsetzen. Websites, für die das vorherige Standardzertifikat verwendet wird, sind davon nicht betroffen.',
    'sslcertificates.selectOne' => 'Wählen Sie ein SSL/TLS-Zertifikat aus.',

    'subscriptions.filterDomainName' => 'Name',
    'subscriptions.filterSubscription' => 'Service-Paket',
    'subscriptions.filterOptionSubscriptionAny' => 'Beliebig',
    'subscriptions.filterOptionSubscriptionMy' => 'Meine Pakete',
    'subscriptions.filterOptionSubscriptionReseller' => 'Pakete von %%planOwnerContactName%%',
    'subscriptions.filterOptionSubscriptionCustom' => 'Benutzerdefiniert',
    'subscriptions.filterOptionSubscriptionAddonType' => '(Add-on)',
    'subscriptions.filterResourceUsage' => 'Ressourcenauslastung',
    'subscriptions.filterOptionResourceUsageAny' => 'Beliebig',
    'subscriptions.filterOptionResourceUsageOveruse' => 'Überbeanspruchte Ressourcen',
    'subscriptions.filterOptionResourceUsageOk' => 'Innerhalb der Grenzen',
    'subscriptions.filterPlanItem' => 'Benutzerdefiniertes Paketobjekt',
    'subscriptions.filterOptionPlanItemAny' => 'Beliebig',
    'subscriptions.filterProvider' => 'Anbieter',
    'subscriptions.filterOptionProviderAny' => 'Alle Abonnements',
    'subscriptions.filterOptionProviderMy' => 'Meine Abonnements',
    'subscriptions.filterProviderReseller' => 'Abonnements von %%resellerContactName%%',
    'subscriptions.filterStatus' => 'Status',
    'subscriptions.filterOptionStatusAny' => 'Beliebig',
    'subscriptions.filterOptionStatusSuspended' => 'Gesperrt',
    'subscriptions.filterOptionStatusActive' => 'Aktiv',
    'subscriptions.filterSubscriptionStatus' => 'Abonnementstatus',
    'subscriptions.filterOptionSubscriptionStatusAny' => 'Beliebig',
    'subscriptions.filterOptionSubscriptionStatusLocked' => 'Gesperrt',
    'subscriptions.filterOptionSubscriptionStatusUnsynchronized' => 'Nicht synchronisiert',
    'subscriptions.filterSubscriberName' => 'Abonnent',
    'subscriptions.filterDescription' => 'Beschreibung',
    'subscriptions.subscriptionName' => 'Abonnement',
    'subscriptions.subscriberName' => 'Abonnent',
    'subscriptions.setupDate' => 'Einrichtungsdatum',
    'subscriptions.description' => 'Beschreibung',
    'subscriptions.resellerDescription' => 'Reseller',
    'subscriptions.ownerDescription' => 'Kunde',
    'subscriptions.manageInResellerPanel' => 'Im Reseller-Panel verwalten',
    'subscriptions.manageInCustomerPanel' => 'Im Kunden-Panel verwalten',
    'subscriptions.buttonAddNewOwnSubscription' => 'Eigenes Abonnement hinzufügen',
    'subscriptions.hintAddNewOwnSubscription' => 'Erstellen Sie ein Abonnement zur eigenen Nutzung.',
    'subscriptions.buttonAddNewSubscription' => 'Abonnement hinzufügen',
    'subscriptions.hintAddNewSubscription' => 'Erstellen Sie ein Abonnement.',
    'subscriptions.buttonChangeSubscription' => 'Paket ändern',
    'subscriptions.hintChangeSubscription' => 'Weisen Sie die ausgewählten Abonnements einem anderen Service-Paket zu. Oder fügen Sie Paket-Add-ons hinzu bzw. entfernen Sie sie, sofern der Abonnement-Provider diese anbietet.',
    'subscriptions.buttonRemove' => 'Entfernen',
    'subscriptions.hintRemove' => 'Entfernen Sie die ausgewählten Abonnements.',
    'subscriptions.confirmOnRemove' => 'Wollen Sie die ausgewählten Abonnements wirklich entfernen?',
    'subscriptions.buttonChangeStatus' => 'Status ändern',
    'subscriptions.buttonActivateSubscriptions' => 'Aktivieren',
    'subscriptions.hintActivateSubscriptions' => 'Aktivieren Sie die ausgewählten Abonnements.',
    'subscriptions.buttonSuspendSubscriptions' => 'Sperren',
    'subscriptions.hintSuspendSubscriptions' => 'Sperren Sie die ausgewählten Abonnements. Alle Services, die mit den Abonnements zur Verfügung gestellt werden, werden eingefroren und sind nicht mehr für Internetnutzer verfügbar.',
    'subscriptions.buttonChangeOwner' => 'Abonnent ändern',
    'subscriptions.hintChangeOwner' => 'Weisen Sie die ausgewählten Abonnements einem anderen Abonnenten zu. Dadurch ändert sich auch der Provider des Abonnenten. Entfernen Sie die Abonnements aus den Service-Paketen und definieren Sie sie als \'Benutzerdefiniert\'.',
    'subscriptions.customPlanName' => 'Benutzerdefiniert',
    'subscriptions.statusOk' => 'Abonnementstatus ist OK: das Abonnement ist aktiv und mit dem Paket synchronisiert.',
    'subscriptions.statusSuspended' => 'Das Abonnement ist gesperrt: Alle Services, die zu dem Abonnement gehören, wurden eingefroren und sind nicht für Internetnutzer zugänglich.',
    'subscriptions.statusSuspendedReasonExpired' => 'Das Abonnement ist gesperrt, da es abgelaufen ist: Alle Services, die mit dem Abonnement bereitgestellt werden, sind eingefroren und für Internetnutzer nicht zugänglich.',
    'subscriptions.statusLocked' => 'Das Abonnement wurde für die Synchronisierung gesperrt: Es ist von der Synchronisierung mit dem Service-Paket ausgeschlossen, da Abonnement-Parameter angepasst wurden.',
    'subscriptions.statusUnsynchronized' => 'Das Abonnement wurde nicht mit dem Service-Paket synchronisiert: Es gibt einige Services oder Ressourcen, die das Paket anbietet, die aber das Abonnement nicht zur Verfügung stellt.',
    'subscriptions.confirmOnDelete' => 'Möchten Sie {count, plural, =1 {das Abonnement {name}} one {das ausgewählte Abonnement} other {die # ausgewählten Abonnements}} wirklich entfernen?',
    'subscriptions.hintInfo' => '(?)',
    'subscriptions.webserverConfigurationDomainHintAdmin' => "Die Webserver-Konfiguration für die Domains im Abonnement ist eventuell inkonsistent. Bitte beheben Sie Fehler in den Templates der Apache-Konfiguration und versuchen Sie erneut, die Konfigurationsdatei zu erstellen.",
    'subscriptions.webserverConfigurationDomainHintReseller' => "Die Webserver-Konfiguration für die Domains im Abonnement ist eventuell inkonsistent. Bitte wenden Sie sich an den Server-Administrator, um das Problem zu lösen.",
    'subscriptions.unlinkedDomainHint' => 'Einige der Domain-IP-Adressen funktionieren nicht und wurden aus der Serverkonfiguration ausgeschlossen. Überprüfen Sie die IP-Adressbindungen für die Domain und aktualisieren Sie die Angaben falls nötig.',
    'subscriptions.hintTitle' => 'Abonnementübersicht',
    'subscriptions.hintWaitMessage' => 'Wird geladen...',
    'subscriptions.removeConfirmationSubscription' => "Die folgenden Domains werden auch entfernt: %%domains%%",

    'webappfirewalllogfiles.name' => 'Name',
    'webappfirewalllogfiles.modificationDate' => 'Änderungsdatum',
    'webappfirewalllogfiles.fileSize' => 'Größe',
    'webappfirewalllogfiles.remove' => 'Entfernen',
    'webappfirewalllogfiles.hintRemove' => 'Entfernen Sie die ausgewählten Protokolldateien. Nur verarbeitete Protokolldateien können entfernt werden.',
    'webappfirewalllogfiles.confirmOnDelete' => 'Möchten Sie die ausgewählten Protokolldateien wirklich entfernen?',
    'webappfirewalllogfiles.viewHint' => 'Klicken Sie hier, um die Protokolldatei anzuzeigen.',
    'webappfirewalllogfiles.buttonDownloadHint' => 'Klicken Sie hier, um die Protokolldatei herunterzuladen.',

    'webmails.name' => 'Name',
    'webmails.url' => 'URL',
    'webmails.buttonAddNewWebmail' => 'Webmail registrieren',
    'webmails.hintAddNewWebmail' => 'Registrieren Sie einen zusätzlichen Webmail-Service in Plesk.',
    'webmails.buttonEnableWebmail' => 'Aktivieren',
    'webmails.hintEnableWebmail' => 'Aktivieren Sie die ausgewählten Webmail-Services für Kunden.',
    'webmails.buttonDisableWebmail' => 'Deaktivieren',
    'webmails.hintDisableWebmail' => 'Deaktivieren Sie die ausgewählten Webmail-Services für Kunden.',
    'webmails.buttonRemoveWebmail' => 'Entfernen',
    'webmails.hintRemoveWebmail' => 'Entfernen Sie die Registrierung der ausgewählten zusätzlichen Webmail-Services. Bitte beachten Sie, dass ein Webmail-Programm, das mit dem Plesk Installer installiert wurde, hier nicht entfernt werden kann. Verwenden Sie stattdessen Tools >  Updates.',
    'webmails.confirmOnDelete' => 'Möchten Sie die ausgewählten Webmail-Registrierungen wirklich aus Plesk entfernen?',
    'webmails.statusSuspended' => 'Webmail ist nicht verfügbar.',
    'webmails.statusOk' => 'Webmail ist verfügbar.',
];