<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
// This file contains structured and commented locale keys for Plesk 9.x

global $PROD_NAME;

$GLOBALS['lmsg_arr'] += [
    ////
    //// LOGIN SCREEN
    ////

    'login_up__access_denied_account_disabled' => "拒绝访问。您的帐户已挂起。",
    'login_up__login_has_been_locked' => "您已多次尝试使用错误的密码登录。因安全因素，一段时间内，无法使用此用户名登录。",
    'login_up__unable_to_check_pass' => "无法检查密码：%1。",
    'login_up__warning_limits_licence_key' => "下列项目之一超出您目前许可证密钥所定的限制：用户帐户数、域名数、邮件帐户数或服务器上托管的网站用户数。\n请联系 Plesk 销售部门来购买合适的许可证密钥，允许您托管相应数量的用户、域名等。如果您认为误收到此邮件，请联系 Plesk 技术支持部门。\n您当前许可证允许的用户帐户数/域名数/邮件帐户数/网站用户数/语言包数为: %2.\n您当前托管的用户帐户数/域名数/邮件帐户数/网站用户数/语言包数为: %3.", // PFW
    'login_up__short_warning_limits_licence_key' => "您操作的资源量已超出当前产品许可证所定的限制。请联系 Plesk 销售部门来购买新许可证密钥。",
    'login_up__grace_period' => '您目前使用的产品许可证已处于宽限期。如要更新产品许可证，请在%1许可证信息页面%2中选择 检索密钥 选项。',
    'login_up__partner_license_message' => '您目前使用的产品许可证有一定限制，需要注册才可以启用全部功能。如要更新产品许可证，请在%1许可证信息页面%2中选择 检索密钥 选项。',
    'login_up__system_admin_disabled' => '出于安全原因，高级用户（root 或管理员帐户）被禁止登录到 Plesk。',

    ///
    /// Online help keys:
    ///

    'plesk_guide' => "Plesk 管理员指南",
    'plesk_guide_reseller' => "Plesk 代理商指南",
    'plesk_guide_client' => "Plesk 客户指南",
    'plesk_guide_domain_admin' => "Plesk 域名管理员指南",
    'plesk_guide_mailuser' => "Plesk 邮件用户指南",

    ////
    //// COMMON KEYS FOR NAVIGATION THROUGHOUT PANEL
    ////

    ///
    /// NAVIGATION PANE
    ///

    'bt_search' => '搜索', // multiple usage: TBI
    'ui__client_unknown__quick-search' => '客户',
    'ui__reseller_unknown__quick-search' => '代理商',
    'ui__client/domain_unknown__quick-search' => '域名',
    'nav__general' => '主菜单',
    '__home' => '首页',
    '__resellers' => '代理商',
    '__clients' => '客户',
    '__domains' => '域名',
    '__applications' => '应用程序',
    '__settings' => '设置',
    'nav__system' => '系统',
    '__master' => '主控',

    ///
    /// END OF NAVIGATION PANE
    ///

    ///
    /// NAVIGATION KEYS
    ///

    // up level
    'bt_up_level' => '上一级',

    // object switcher

    ///
    /// END OF NAVIGATION KEYS
    ///

    ///
    /// LISTS
    ///

    // common operations on list objects
    'bt_remove_selected' => '移除',
    'bt_make_default' => '设为默认',

    // common list object operation errors
    'class_cList__empty_selection' => '未选择对象。',

    // common list object search keys
    'clist__search_show' => '显示搜索',
    'clist__search_hide' => '隐藏搜索',

    'bt_show_all' => "重置搜索",

    // common object list info keys
    'clist__first' => '第一页',
    'clist__last' => '最后一页',
    'clist__prev' => '&lt;&lt;',
    'clist__next' => '&gt;&gt;',
    'clist__page' => '页面',
    'clist__page_size' => '每页显示条目',
    'clist__info' => '所有%1：%4',
    'clist__info_empty' => '无%1',
    'clist__info_filter' => '%5 %1查找结果(共%4)',
    'clist__info_paging' => '%2-%3 %1(共计 %4)',
    'clist__info_paging_filter' => '%5 中找到 %2-%3 %1（共 %4）',

    ///
    /// END OF LISTS
    ///

    ////
    //// KEYS FOR USER HOME PAGES
    ////

    ///
    /// COMMON HOME PAGE KEYS
    ///

    // business object controls
    '__object_on' => '活动',
    '__object_off' => '挂起',

    '__home_description' => '返回首页。',
    'indicator_title' => '已使用 %1%, 可用 %2%', // tooltip for visual stats area

    ///
    /// END OF COMMON HOME PAGE KEYS
    ///

    ///
    /// SERVER ADMINISTRATOR
    ///

    '__invalid_url_requested' => '请求的是无效的 URL。',

    // accounts
    // icons
    'ui__reseller_unknown__short-title' => "代理商帐户",
    'ui__reseller_unknown__title' => "代理商帐户",
    'ui__reseller_unknown__description' => "管理代理商帐户。",
    'ui__reseller/client_unknown__short-title' => '客户帐户',
    'ui__reseller/client_unknown__title' => '客户帐户',
    'ui__reseller/client_unknown__description' => '管理客户帐户。',
    // dropdowns
    'ui__admin-alias_unknown__title' => "附加管理员帐户", // PFW
    'ui__admin-alias_unknown__short-title' => "附加管理员帐户", // PFW
    'ui__admin-alias_unknown__description' => "查看并更改附加管理员帐户。", // PFW

    // server
    // icons
    'ui__server/mail__short-title' => "邮件服务器设置",
    'ui__server/mail__title' => "邮件服务器设置",
    'ui__server/mail__description' => "设置邮件服务器和服务器级邮件设置。",
    'ui__server/dns__short-title' => 'DNS设置',
    'ui__server/dns__title' => 'DNS设置',
    'ui__server/dns__description' => '查看和更新服务器级DNS设置。',
    'ui__server/services__title' => '服务管理',
    'ui__server/services__description' => '开始、停止或重启 Plesk 服务。',
    'ui__server/crontab/task_unknown__short-title' => '计划的任务',
    'ui__server/crontab/task_unknown__title' => '计划的任务',
    'ui__server/crontab/task_unknown__description' => '添加和删除服务器级计划的任务。',
    'ui__server/ip-address_unknown__short-title' => 'IP 地址',
    'ui__server/ip-address_unknown__title' => 'IP 地址',
    'ui__server/ip-address_unknown__description' => '查看、添加与移除 IP 地址，分配 IP 地址给代理商。',
    // dropdowns
    'ui__server/time__title' => '系统时间',
    'ui__server/time__short-title' => '系统时间',
    'ui__server/time__description' => '设置系统日期和时间，设置与NTP服务器同步。',
    'ui__server/odbc__title' => 'ODBC 数据源', // PFW
    'ui__server/odbc/dsn/properties__title' => 'ODBC 连接配置',
    'ui__server/odbc/dsn/properties_unknown-new__title' => '添加 ODBC DSN',
    'ui__server/odbc__short-title' => 'ODBC 数据源', // PFW
    'ui__server/odbc__description' => '设置ODBC数据源。', // PFW
    'ui__server/maillists__title' => '设置邮件列表服务器', // PFU
    'ui__server/maillists__short-title' => '设置邮件列表服务器', // PFU
    'ui__server/maillists__description' => '设置Mailman邮件列表服务器。', // PFU
    'ui__mass-email__short-title' => "群发电子邮件", // PFW
    'ui__mass-email__title' => "群发电子邮件", // PFW
    'ui__mass-email__description' => "同时发送邮件给多个用户。", // PFW
    'ui__mass-mail__title' => '群发邮件', // PFU
    'ui__mass-mail__short-title' => '群发邮件', // PFU
    'ui__mass-mail__description' => '一次发送邮件给多个用户。', // PFU
    'ui__server/spam-filter__title' => '垃圾邮件过滤器设置。',
    'ui__server/spam-filter__short-title' => '垃圾邮件过滤器设置。',
    'ui__server/spam-filter__description' => '设置服务器级的垃圾邮件过滤器。',
    'ui__server/preferences__title' => "服务器设置",
    'ui__server/preferences__short-title' => "服务器设置",
    'ui__server/preferences__description' => "配置服务器级统计计算，更改服务器主机名和更改其它服务器设置。",

    // help & support
    // icons
    'ui__support__short-title' => '支持',
    'ui__support__title' => '支持',
    'ui__support__description' => '提交Panel技术支持请求或查看客户提交的技术支持工单。',
    'ui__license__short-title' => '许可证信息',
    'ui__license__title' => 'Plesk许可证信息',
    'ui__license__description' => '查看 Plesk 许可证相关信息，订购新许可证。',
    'ui__help__short-title' => '帮助',
    'ui__help__title' => '在线帮助',
    'ui__help__description' => '查看在线帮助。',
    'ui__news__short-title' => "新功能",
    'ui__news__title' => "新功能",
    'ui__news__description' => "查看此版 Plesk 的变更列表。",
    'ui__server/autoinstaller__short-title' => '更新',
    'ui__server/autoinstaller__title' => '更新',
    'ui__server/autoinstaller__description' => '更新 Plesk 与其组件。',
    // dropdowns

    // domains
    // icons
    'ui__client/domain_unknown__short-title' => '域名',
    'ui__client/domain_unknown__title' => '域名',
    'ui__client/domain_unknown__description' => '管理域名。',
    'ui__server/skeleton__short-title' => '虚拟主机模板',
    'ui__server/skeleton__title' => '虚拟主机模板',
    'ui__server/skeleton__description' => '指定要放置到新近创建的域名目录中的文件和文件夹。',
    // dropdowns
    'ui__client/domain/chowner_multi-select__title' => '给订阅分配新的所有者',
    'ui__client/domain/chowner_multi-select__short-title' => '分配新的订阅所有者',
    'ui__client/domain/chowner_multi-select__description' => '给选定的订阅分配新所有者',
    'ui__client/domain/disable_multi__title' => '挂起域名',
    'ui__client/domain/disable_multi__short-title' => '挂起域名',
    'ui__client/domain/disable_multi__description' => '挂起所选域名',
    'ui__client/domain/enable_multi__title' => '激活域名',
    'ui__client/domain/enable_multi__short-title' => '激活域名',
    'ui__client/domain/enable_multi__description' => '激活所选域名',

    // icons
    'ui__admin/extras-domain__short-title' => '来自MyPlesk.com的工具',
    'ui__admin/extras-domain__title' => '来自MyPlesk.com的工具',
    'ui__admin/extras-domain__description' => '从MyPlesk.com获取其它工具和服务。',
    'ui__server/aspdotnet__short-title' => 'ASP.NET 设置', // PFW
    'ui__server/aspdotnet__title' => 'ASP.NET 设置', // PFW
    'ui__server/aspdotnet__description' => '配置服务器级ASP.NET设置。', // PFW
    'ui__server/sitebuilder__short-title' => 'Presence Builder 设置', // PFU
    'ui__server/sitebuilder__title' => 'Presence Builder  设置', // PFU
    'ui__server/sitebuilder__description' => '设置 Presence Builder 编辑托管于该服务器上的网站。', // PFU
    // dropdowns
    'ui__admin/register-domain__title' => '注册域名',
    'ui__admin/register-domain__short-title' => '注册域名',
    'ui__admin/register-domain__description' => '通过MyPlesk.com注册域名。',
    'ui__admin/manage-domain__title' => '管理域名',
    'ui__admin/manage-domain__short-title' => '管理域名',
    'ui__admin/manage-domain__description' => '通过MyPlesk.com管理域名。',
    'ui__server/register__title' => '注册服务器',
    'ui__server/register__short-title' => '注册服务器',
    'ui__server/register__description' => '加入会员计划注册服务器',

    // logs & statistics
    // icons
    'ui__actionlog__short-title' => '操作日志',
    'ui__actionlog__title' => '操作日志',
    'ui__actionlog__description' => '下载操作日志并管理操作日志设置。',
    // dropdowns
    'ui__server/statistics__short-title' => '服务器信息',
    'ui__server/statistics__title' => '服务器信息',
    'ui__server/statistics__description' => '查看服务器和 Plesk 的多种统计信息。',
    'ui__admin/report__title' => '概要报告',
    'ui__admin/report__short-title' => '概要报告',
    'ui__admin/report__description' => '查看代理商、客户和域名的流量及资源使用报告。',

    // security
    // icons
    'ui__sessions/properties__short-title' => '会话闲置时间',
    'ui__sessions/properties__title' => '会话闲置时间',
    'ui__sessions/properties__description' => '设置 Plesk 会话的闲置时间。',
    'ui__cp-access__short-title' => '访问 Plesk',
    'ui__cp-access__title' => '访问 Plesk',
    'ui__cp-access__description' => '限制访问 Plesk。',
    'ui__sessions__short-title' => '活动会话',
    'ui__sessions__title' => '活动会话',
    'ui__sessions__description' => '查看活动 Plesk 会话。',
    // dropdowns
    'ui__server/certificate_unknown__title' => 'SSL/TLS 证书',
    'ui__server/certificate_unknown__short-title' => 'SSL/TLS 证书',
    'ui__server/certificate_unknown__description' => 'SSL/TLS 证书列表。',

    // account
    // icons
    'ui__admin-info__short-title' => '个人信息',
    'ui__admin-info__title' => '个人信息',
    'ui__admin-info__description' => '更改帐户的个人信息。',
    'ui__admin-password__short-title' => '更改密码',
    'ui__admin-password__title' => '更改密码',
    'ui__admin-password__description' => '更改帐户密码。',
    // dropdowns

    ///
    /// END OF SERVER ADMINISTRATOR
    ///

    ///
    /// RESELLER
    ///

    // business objects

    // files
    // icons
    'ui__client/domain/hosting/file-manager_unknown__short-title' => '文件管理器',
    'ui__client/domain/hosting/file-manager_unknown__title' => '文件管理器',
    'ui__client/domain/hosting/file-manager_unknown__description' => '通过文件管理器来管理文件和目录。',
    'ui__client/domain/hosting/ssh-terminal_unknown__short-title' => 'SSH终端', // PFU
    'ui__client/domain/hosting/ssh-terminal_unknown__title' => 'SSH终端', // PFU
    'ui__client/domain/hosting/ssh-terminal_unknown__description' => '使用SSH终端访问服务器。', // PFU
    'ui__client/domain/hosting/protected-directories_unknown__short-title' => '有密码保护的目录',
    'ui__client/domain/hosting/protected-directories_unknown__title' => '有密码保护的目录',
    'ui__client/domain/hosting/protected-directories_unknown__description' => '限制访问所选网站区。',
    'ui__client/domain/hosting/web-directories_unknown__title' => '虚拟目录', // PFW
    'ui__client/domain/hosting/web-directories_unknown__short-title' => '虚拟目录', // PFW
    'ui__client/domain/hosting/web-directories_unknown__description' => '处理网站上的物理和虚拟文件及目录。', // PFW

    // statistics
    // icons
    'ui__reseller/limits__short-title' => '资源使用量',
    'ui__reseller/limits__title' => '资源使用量',
    'ui__reseller/limits__description' => '查看和管理代理商%1的资源使用。',
    'ui__reseller/limits_unknown__short-title' => '资源使用量',
    'ui__reseller/limits_unknown__title' => '资源使用量',
    'ui__reseller/limits_unknown__description' => '查看和管理代理商所用资源。',
    'ui__reseller/limits_self__short-title' => '资源使用量',
    'ui__reseller/limits_self__title' => '资源使用量',
    'ui__reseller/limits_self__description' => "查看和管理您的资源使用。",
    'ui__reseller/limits_readonly-self__short-title' => '资源使用量',
    'ui__reseller/limits_readonly-self__title' => '资源使用量',
    'ui__reseller/limits_readonly-self__description' => "查看您的资源使用。",
    'ui__reseller/client/traffic_unknown__short-title' => '客户所用的流量',
    'ui__reseller/client/traffic_unknown__title' => '查看客户所用流量',
    'ui__reseller/client/traffic_unknown__description' => '查看客户帐户的流量使用报告。',
    'ui__client/traffic_unknown__short-title' => "客户所用的流量", // temporary for presets
    'ui__client/traffic_unknown__title' => "按客户查看流量使用", // temporary for presets
    'ui__client/traffic_unknown__description' => "查看客户帐户流量使用报告。", //  temporary for presets
    'ui__client/domain/hosting/logs_unknown__short-title' => '日志管理器',
    'ui__client/domain/hosting/logs_unknown__title' => '日志管理器',
    'ui__client/domain/hosting/logs_unknown__description' => '查看日志和配置日志循环。',
    // dropdowns
    'ui__reseller/report__title' => '摘要报告',
    'ui__reseller/report__short-title' => '摘要报告',
    'ui__reseller/report__description' => '查看此代理商帐户的流量和资源使用报告。',
    'ui__reseller/report_unknown__title' => '摘要报告',
    'ui__reseller/report_unknown__short-title' => '摘要报告',
    'ui__reseller/report_unknown__description' => '查看代理商所用流量和资源报告。',
    'ui__reseller/report_self__title' => '摘要报告',
    'ui__reseller/report_self__short-title' => '摘要报告',
    'ui__reseller/report_self__description' => '查看流量和资源使用报告。',

    // account
    // icons
    'ui__client/logo_reseller__title' => 'Plesk 品牌自定义',
    'ui__client/logo_reseller__short-title' => 'Plesk 品牌自定义',
    'ui__client/logo_reseller__description' => '重新定义代理商 %1 的 Plesk 品牌。',
    'ui__client/logo_unknown__title' => 'Plesk 品牌自定义', // temporary for presets
    'ui__client/logo_unknown__short-title' => 'Plesk 品牌自定义', // temporary for presets
    'ui__client/logo_unknown__description' => '重新定义 Plesk 品牌', // temporary for presets
    'ui__client/logo_self-reseller__title' => 'Plesk 品牌自定义',
    'ui__client/logo_self-reseller__short-title' => 'Plesk 品牌自定义',
    'ui__client/logo_self-reseller__description' => '重新定义 Plesk 品牌',
    'ui__reseller/permissions__title' => '权限',
    'ui__reseller/permissions__short-title' => '权限',
    'ui__reseller/permissions__description' => "查看或更改代理商 %1 可以在 Plesk 中执行的操作。",
    'ui__reseller/permissions_unknown__short-title' => '权限',
    'ui__reseller/permissions_unknown__title' => '权限',
    'ui__reseller/permissions_unknown__description' => "查看或更改代理商可以在 Plesk 中执行的操作。",
    'ui__reseller/permissions_self__title' => '权限',
    'ui__reseller/permissions_self__short-title' => '权限',
    'ui__reseller/permissions_self__description' => '查看您可以在 Plesk l中执行的操作列表。',
    'ui__reseller/permissions_readonly-self__title' => '权限',
    'ui__reseller/permissions_readonly-self__short-title' => '权限',
    'ui__reseller/permissions_readonly-self__description' => '查看您可以在 Plesk l中执行的操作列表。',

    // domains
    // icons
    // Domains - see SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - see SERVER ADMINISTRATOR/DOMAINS
    'ui__client/skeleton__title' => '虚拟主机模板',
    'ui__client/skeleton__short-title' => '虚拟主机模板',
    'ui__client/skeleton__description' => '指定放置新创建域名目录中的文件和文件夹。',
    'ui__client/skeleton_unknown__short-title' => '虚拟主机模板',
    'ui__client/skeleton_unknown__title' => '虚拟主机模板',
    'ui__client/skeleton_unknown__description' => '指定新创建域名的文件和文件夹的存放目录。',

    // website
    // icons
    'ui__client/domain/domain-alias_unknown__short-title' => '域名别名',
    'ui__client/domain/domain-alias_unknown__title' => '域名别名',
    'ui__client/domain/domain-alias_unknown__description' => '查看域名的可用名称列表。',
    //dropdowns
    'ui__client/domain/dns_unknown__title' => 'DNS设置',
    'ui__client/domain/dns_unknown__short-title' => 'DNS设置',
    'ui__client/domain/dns_unknown__description' => '管理域名的DNS区域设置。',
    'ui__client/domain/dns_readonly-unknown__title' => 'DNS设置',
    'ui__client/domain/dns_readonly-unknown__short-title' => 'DNS设置',
    'ui__client/domain/dns_readonly-unknown__description' => '查看域名的DNS区域设置。',

    // applications & services
    // icons
    'ui__reseller/extras-domain__short-title' => '来自MyPlesk.com的工具',
    'ui__reseller/extras-domain__title' => '来自MyPlesk.com的工具',
    'ui__reseller/extras-domain__description' => '从MyPlesk.com获取其它工具和服务。',
    'ui__reseller/extras-domain_unknown__short-title' => '来自MyPlesk.com的工具',
    'ui__reseller/extras-domain_unknown__title' => '来自MyPlesk.com的工具',
    'ui__reseller/extras-domain_unknown__description' => '从MyPlesk.com获取其他工具和服务。',
    'ui__reseller/extras-domain_self__short-title' => '来自MyPlesk.com的工具',
    'ui__reseller/extras-domain_self__title' => '来自MyPlesk.com的工具',
    'ui__reseller/extras-domain_self__description' => '从MyPlesk.com获取其它工具和服务。',
    'ui__client/domain/odbc_unknown__short-title' => 'ODBC 数据源', // PFW
    'ui__client/domain/odbc_unknown__title' => 'ODBC 数据源', // PFW
    'ui__client/domain/odbc_unknown__description' => '设置域名的ODBC数据源。', // PFW
    'ui__reseller/register-domain__short-title' => '注册域名',
    'ui__reseller/register-domain__title' => '注册域名',
    'ui__reseller/register-domain__description' => '通过MyPlesk.com注册域名。',
    'ui__reseller/register-domain_unknown__short-title' => '注册域名',
    'ui__reseller/register-domain_unknown__title' => '注册域名',
    'ui__reseller/register-domain_unknown__description' => '通过MyPlesk.com注册域名。',
    'ui__reseller/register-domain_self__short-title' => '注册域名',
    'ui__reseller/register-domain_self__title' => '注册域名',
    'ui__reseller/register-domain_self__description' => '通过MyPlesk.com注册域名。',
    // dropdowns
    'ui__reseller/manage-domain__title' => '管理域名',
    'ui__reseller/manage-domain__short-title' => '管理域名',
    'ui__reseller/manage-domain__description' => '管理通过MyPlesk.com注册的域名。',
    'ui__reseller/manage-domain_unknown__title' => '管理域名',
    'ui__reseller/manage-domain_unknown__short-title' => '管理域名',
    'ui__reseller/manage-domain_unknown__description' => '管理通过MyPlesk.com注册的域名。',
    'ui__reseller/manage-domain_self__title' => '管理域名',
    'ui__reseller/manage-domain_self__short-title' => '管理域名',
    'ui__reseller/manage-domain_self__description' => '管理通过MyPlesk.com注册的域名。',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown-reseller__title' => 'IP 地址',
    'ui__client/ipaddress_unknown-reseller__short-title' => 'IP 地址',
    'ui__client/ipaddress_unknown-reseller__description' => '管理IP地址。',
    'ui__client/domain/certificate_unknown__short-title' => 'SSL/TLS 证书',
    'ui__client/domain/certificate_unknown__title' => 'SSL/TLS 证书',
    'ui__client/domain/certificate_unknown__description' => '安装和管理 SSL/TLS 证书。',
    'ui__client/domain/hosting/hotlink-protection_unknown__short-title' => '盗链防护', // PFW
    'ui__client/domain/hosting/hotlink-protection_unknown__title' => '盗链防护', // PFW
    'ui__client/domain/hosting/hotlink-protection_unknown__description' => '防止文件盗链。', // PFW
    'ui__reseller/sessions__short-title' => '活动会话',
    'ui__reseller/sessions__title' => '活动会话',
    'ui__reseller/sessions__description' => '查看活动 Plesk 会话。',
    'ui__reseller/sessions_unknown__short-title' => '活动会话',
    'ui__reseller/sessions_unknown__title' => '活动会话',
    'ui__reseller/sessions_unknown__description' => '查看活动 Plesk 会话。',
    'ui__reseller/sessions_self__short-title' => '活动会话',
    'ui__reseller/sessions_self__title' => '活动会话',
    'ui__reseller/sessions_self__description' => '查看活动 Plesk 会话。',
    'ui__client/domain/hosting/performance_unknown__short-title' => '带宽限制',
    'ui__client/domain/hosting/performance_unknown__title' => '带宽限制',
    'ui__client/domain/hosting/performance_unknown__description' => '查看和调整网站的带宽使用限制及同时连接数。',
    'ui__client/domain/hosting/performance_readonly-unknown__short-title' => '带宽限制',
    'ui__client/domain/hosting/performance_readonly-unknown__title' => '带宽限制',
    'ui__client/domain/hosting/performance_readonly-unknown__description' => '查看网站的带宽使用限制及同时连接数。',

    ///
    /// END OF RESELLER
    ///

    ///
    /// CLIENT
    ///

    // business objects
    'mn_list__mail_names_for_client' => '用户帐户%1下的邮件帐户',

    // domains
    // icons
    // Domains - SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - SERVER ADMINISTRATOR/DOMAINS
    // Virtual host template - RESELLER/DOMAINS
    'ui__client/skeleton_self__short-title' => '虚拟主机模板',
    'ui__client/skeleton_self__title' => '虚拟主机模板',
    'ui__client/skeleton_self__description' => '指定应放置新建域名的文件和文件夹的目录。',
    // dropdowns
    // Create domain - see RESELLER/DOMAINS
    // Create domain template - see RESELLER/DOMAINS
    // Assign new owner for domains - see SERVER ADMINISTRATOR/DOMAINS
    // Convert Domain Administrator Accounts to Client Accounts - see SERVER ADMINISTRATOR/DOMAINS
    // Update Properties of Multiple Domains - see SERVER ADMINISTRATOR/DOMAINS

    // Suspend domains - see SERVER ADMINISTRATOR/DOMAINS
    // Activate domains - see SERVER ADMINISTRATOR/DOMAINS

    // mail
    // icons
    // Mail accounts - RESELLER/MAIL
    // Create mail account - RESELLER/MAIL
    // Create forwarder - RESELLER/MAIL
    // Create autoresponder - RESELLER/MAIL
    // Mailing lists - RESELLER/MAIL
    // Virus protection - RESELLER/MAIL
    // Spam filtering - RESELLER/MAIL
    // Open Webmail - RESELLER/MAIL
    // dropdowns
    // Mail settings - RESELLER/MAIL
    //Create mailing list - RESELLER/MAIL

    // files
    // icons
    // File manager - RESELLER/FILES
    // Anonymous FTP - RESELLER/FILES
    // FTP accounts - RESELLER/FILES    // PFW
    // SSH terminal - RESELLER/FILES    // PFU
    // Password protected directories - RESELLER/FILES
    // Virtual directories - RESELLER/FILES    // PFW
    // Web directories - RESELLER/FILES    // PFW

    // statistics
    // icons
    // Web statistics - RESELLER/STATISTICS
    'ui__client/limits__short-title' => '资源使用量',
    'ui__client/limits__title' => '资源使用量',
    'ui__client/limits__description' => "查看和管理客户%1的资源使用。",
    'ui__client/limits_unknown__short-title' => '资源使用量',
    'ui__client/limits_unknown__title' => '资源使用量',
    'ui__client/limits_unknown__description' => '查看和更改客户的资源使用。',
    'ui__client/limits_readonly__short-title' => '资源使用量',
    'ui__client/limits_readonly__title' => '资源使用量',
    'ui__client/limits_readonly__description' => '查看客户%1的资源使用。',
    'ui__client/limits_self__short-title' => '资源使用量',
    'ui__client/limits_self__title' => '资源使用量',
    'ui__client/limits_self__description' => "查看和管理资源使用。",
    'ui__client/limits_readonly-self__short-title' => '资源使用量',
    'ui__client/limits_readonly-self__title' => '资源使用量',
    'ui__client/limits_readonly-self__description' => "查看资源使用。",
    'ui__client/domain/traffic_unknown__short-title' => "域名%1所用流量",
    'ui__client/domain/traffic_unknown__title' => "查看域名所用的流量",
    'ui__client/domain/traffic_unknown__description' => "查看域名的流量使用报告。",
    // Log manager - RESELLER/STATISTICS
    // dropdowns
    'ui__client/report__title' => '摘要报告',
    'ui__client/report__short-title' => '摘要报告',
    'ui__client/report__description' => '查看此客户的流量和资源使用报告。',
    'ui__client/report_unknown__short-title' => '摘要报告',
    'ui__client/report_unknown__title' => '摘要报告',
    'ui__client/report_unknown__description' => '查看客户所用流量和资源报告。',
    'ui__client/report_self__short-title' => '摘要报告',
    'ui__client/report_self__title' => '摘要报告',
    'ui__client/report_self__description' => '查看流量和资源使用报告。',

    // account
    // icons
    'ui__client/preferences__short-title' => '界面偏好设置',
    'ui__client/preferences__title' => '界面偏好设置',
    'ui__client/preferences__description' => '为客户 %1 设置 Plesk 界面偏好设置。',
    'ui__client/preferences_unknown__short-title' => '界面偏好设置',
    'ui__client/preferences_unknown__title' => '界面偏好设置',
    'ui__client/preferences_unknown__description' => "编辑 Plesk 客户的会话和界面偏好设置。",
    'ui__client/preferences_self__short-title' => '界面偏好设置',
    'ui__client/preferences_self__title' => '界面偏好设置',
    'ui__client/preferences_self__description' => '设置 %1 界面偏好设置。',
    'ui__client/logo__title' => 'Plesk 品牌自定义',
    'ui__client/logo__short-title' => 'Plesk 品牌自定义',
    'ui__client/logo__description' => "重新定义 客户 %1 的 Plesk 品牌。",
    'ui__client/logo_self__title' => 'Plesk 品牌自定义',
    'ui__client/logo_self__short-title' => 'Plesk 品牌自定义',
    'ui__client/logo_self__description' => '重新定义 Plesk 品牌，请更改徽标图像和浏览器工具栏。',
    'ui__client/permissions__title' => '权限',
    'ui__client/permissions__short-title' => '权限',
    'ui__client/permissions__description' => "查看或更改客户 %1 可以在 Plesk 中执行的操作。",
    'ui__client/permissions_unknown__short-title' => '权限',
    'ui__client/permissions_unknown__title' => '权限',
    'ui__client/permissions_unknown__description' => "查看或更改客户可以在 Plesk 中执行的操作。",
    'ui__client/permissions_self__title' => '权限',
    'ui__client/permissions_self__short-title' => '权限',
    'ui__client/permissions_self__description' => "查看您可以在 Plesk l中执行的操作列表。",
    'ui__client/permissions_readonly-self__title' => '权限',
    'ui__client/permissions_readonly-self__short-title' => '权限',
    'ui__client/permissions_readonly-self__description' => "查看您可以在 Plesk l中执行的操作列表。",

    // website
    // icons
    // Edit in SiteBuilder - RESELLER/WEBSITE
    // Web hosting settings - RESELLER/WEBSITE
    // Subdomains - RESELLER/WEBSITE
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Frontpage Webadmin - RESELLER/WEBSITE
    // Frontpage SSL/TLS Webadmin - RESELLER/WEBSITE
    // Web users - RESELLER/WEBSITE
    // Site preview - RESELLER/WEBSITE
    // dropdowns
    // DNS settings - RESELLER/WEBSITE
    // Change hosting type - RESELLER/WEBSITE
    // FrontPage management - RESELLER/WEBSITE    // PFW
    // Create subdomain - RESELLER/WEBSITE

    // applications & services
    // icons
    // Web applications - RESELLER/APPLICATIONS & SERVICES
    'ui__client/extras-domain__short-title' => '来自MyPlesk.com的工具',
    'ui__client/extras-domain__title' => '来自MyPlesk.com的工具',
    'ui__client/extras-domain__description' => '从MyPlesk.com获取其它工具和服务。',
    'ui__client/extras-domain_unknown__short-title' => '来自MyPlesk.com的工具',
    'ui__client/extras-domain_unknown__title' => '来自MyPlesk.com的工具',
    'ui__client/extras-domain_unknown__description' => '从MyPlesk.com获得其他工具和服务。',
    'ui__client/extras-domain_self__short-title' => '来自MyPlesk.com的工具',
    'ui__client/extras-domain_self__title' => '来自MyPlesk.com的工具',
    'ui__client/extras-domain_self__description' => '从MyPlesk.com获取其它工具和服务。',
    // Databases - RESELLER/APPLICATIONS & SERVICES
    // ODBC data sources - RESELLER/APPLICATIONS & SERVICES    // PFW
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/register-domain__title' => '注册域名',
    'ui__client/register-domain__short-title' => '注册域名',
    'ui__client/register-domain__description' => '通过MyPlesk.com注册域名。',
    'ui__client/register-domain_unknown__title' => '注册域名',
    'ui__client/register-domain_unknown__short-title' => '注册域名',
    'ui__client/register-domain_unknown__description' => '通过MyPlesk.com注册域名。',
    'ui__client/register-domain_self__title' => '注册域名',
    'ui__client/register-domain_self__short-title' => '注册域名',
    'ui__client/register-domain_self__description' => '通过MyPlesk.com注册域名。',
    // dropdowns
    // Install web application - RESELLER/APPLICATIONS & SERVICES
    // Create database - RESELLER/APPLICATIONS & SERVICES
    // Create database user - RESELLER/APPLICATIONS & SERVICES
    // Install Java application - RESELLER/APPLICATIONS & SERVICES
    'ui__client/manage-domain__title' => '管理域名',
    'ui__client/manage-domain__short-title' => '管理域名',
    'ui__client/manage-domain__description' => '通过MyPlesk.com管理注册的域名。',
    'ui__client/manage-domain_unknown__title' => '管理域名',
    'ui__client/manage-domain_unknown__short-title' => '管理域名',
    'ui__client/manage-domain_unknown__description' => '管理通过MyPlesk.com注册的域名。',
    'ui__client/manage-domain_self__title' => '管理域名',
    'ui__client/manage-domain_self__short-title' => '管理域名',
    'ui__client/manage-domain_self__description' => '通过MyPlesk.com管理注册的域名。',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown__title' => 'IP 地址',
    'ui__client/ipaddress_unknown__short-title' => "IP 地址",
    'ui__client/ipaddress_unknown__description' => "管理IP地址。",
    'ui__client/domain/domain-alias_readonly-unknown__short-title' => '域名别名',
    'ui__client/domain/domain-alias_readonly-unknown__title' => '域名别名',
    'ui__client/domain/domain-alias_readonly-unknown__description' => '查看域名的可用名称列表。',
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    // Hotlink protection - RESELLER/ADDITIONAL TOOLS    // PFW
    'ui__client/sessions__short-title' => '活动会话',
    'ui__client/sessions__title' => '活动会话',
    'ui__client/sessions__description' => '查看活动 Plesk 会话。',
    'ui__client/sessions_unknown__short-title' => '活动会话',
    'ui__client/sessions_unknown__title' => '活动会话',
    'ui__client/sessions_unknown__description' => '查看活动 Plesk 会话。',
    'ui__client/sessions_self__short-title' => '活动会话',
    'ui__client/sessions_self__title' => '活动会话',
    'ui__client/sessions_self__description' => '查看活动 Plesk 会话。',
    // Shared SSL/TLS - RESELLER/ADDITIONAL TOOLS    // PFW
    // ASP.NET settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // PHP settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // dropdowns
    //Schedule new task - RESELLER/ADDITIONAL TOOLS

    ///
    /// END OF CLIENT
    ///

    ///
    /// DOMAIN / DOMAIN ADMINISTRATOR
    ///

    // files
    // icons
    'ui__client/domain/hosting/file-manager__short-title' => '文件管理器',
    'ui__client/domain/hosting/file-manager__title' => '管理域名%1上的文件',
    'ui__client/domain/hosting/file-manager__description' => "通过文件管理器处理域名%1上的文件和目录。",
    'ui__client/domain/hosting/file-manager_self__short-title' => '文件管理器',
    'ui__client/domain/hosting/file-manager_self__title' => '文件管理器',
    'ui__client/domain/hosting/file-manager_self__description' => "通过文件管理器来管理您的文件和目录。",
    'ui__client/domain/hosting/ssh-terminal__short-title' => 'SSH终端', // PFU
    'ui__client/domain/hosting/ssh-terminal__title' => 'SSH终端', // PFU
    'ui__client/domain/hosting/ssh-terminal__description' => '使用SSH终端访问服务器。', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__short-title' => 'SSH终端', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__title' => 'SSH终端', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__description' => '使用SSH终端访问服务器。', // PFU
    'ui__client/domain/hosting/protected-directories__short-title' => '有密码保护的目录',
    'ui__client/domain/hosting/protected-directories__title' => '有密码保护的目录',
    'ui__client/domain/hosting/protected-directories__description' => '限制访问所选网站区域。',
    'ui__client/domain/hosting/protected-directories_self__short-title' => '有密码保护的目录',
    'ui__client/domain/hosting/protected-directories_self__title' => '有密码保护的目录',
    'ui__client/domain/hosting/protected-directories_self__description' => '限制访问所选网站区。',
    'ui__client/domain/hosting/web-directories__title' => '虚拟目录', // PFW
    'ui__client/domain/hosting/web-directories__short-title' => '虚拟目录', // PFW
    'ui__client/domain/hosting/web-directories__description' => '处理网站%1上的物理和虚拟文件及目录。', // PFW
    'ui__client/domain/hosting/web-directories_self__title' => '虚拟目录', // PFW
    'ui__client/domain/hosting/web-directories_self__short-title' => '虚拟目录', // PFW
    'ui__client/domain/hosting/web-directories_self__description' => '处理网站的物理和虚拟文件及目录。', // PFW

    // statistics
    // icons
    'ui__client/domain/traffic__short-title' => '%1流量使用',
    'ui__client/domain/traffic__title' => '<b>%1</b> 的数据传输统计',
    'ui__client/domain/traffic__description' => '查看域名 %1 的数据传输统计。',
    'ui__client/domain/traffic_self__short-title' => '流量使用',
    'ui__client/domain/traffic_self__title' => '查看域名的流量使用',
    'ui__client/domain/traffic_self__description' => '查看域名的流量使用报告。',
    'ui__client/domain/hosting/logs__short-title' => '日志管理器',
    'ui__client/domain/hosting/logs__title' => '日志管理器',
    'ui__client/domain/hosting/logs__description' => '查看日志和配置日志循环。',
    'ui__client/domain/hosting/logs_self__short-title' => '日志管理器',
    'ui__client/domain/hosting/logs_self__title' => '日志管理器',
    'ui__client/domain/hosting/logs_self__description' => '查看日志和配置日志循环。',

    // domain administration
    // dropdowns
    'ui__client/domain/rename__title' => '重命名域名',
    'ui__client/domain/rename__short-title' => '重命名域名',
    'ui__client/domain/rename__description' => '重命名域名 %1。',
    'ui__client/domain/rename_unknown__short-title' => '重命名域名',
    'ui__client/domain/rename_unknown__title' => '重命名域名',
    'ui__client/domain/rename_unknown__description' => '重命名域名',
    'ui__client/domain/chowner_select__title' => '分配新所有者给域名',
    'ui__client/domain/chowner_select__short-title' => '给订阅分配新的所有者',
    'ui__client/domain/chowner_select__description' => '给订阅分配新的所有者',
    'ui__client/domain/chowner_unknown-select__short-title' => '给订阅分配新的所有者',
    'ui__client/domain/chowner_unknown-select__title' => '给订阅分配新的所有者',
    'ui__client/domain/chowner_unknown-select__description' => '给订阅分配新的所有者',
    'ui__client/domain/toggle__title' => '挂起或激活域名', // for HP customization
    'ui__client/domain/toggle__short-title' => '挂起或激活域名', // for HP customization
    'ui__client/domain/toggle__description' => '挂起或激活域名%1。', // for HP customization
    'ui__client/domain/toggle_unknown__title' => '挂起或激活域名', // for HP customization
    'ui__client/domain/toggle_unknown__short-title' => '挂起或激活域名', // for HP customization
    'ui__client/domain/toggle_unknown__description' => '挂起或激活域名。', // for HP customization
    'ui__client/domain/toggle_enable__title' => '激活域名',
    'ui__client/domain/toggle_enable__short-title' => '激活域名',
    'ui__client/domain/toggle_enable__description' => '激活域名%1。',
    'ui__client/domain/toggle_disable__title' => '挂起域名',
    'ui__client/domain/toggle_disable__short-title' => '挂起域名',
    'ui__client/domain/toggle_disable__description' => '挂起域名%1。',

    // website
    // icons
    // dropdowns
    'ui__client/domain/dns__title' => 'DNS设置',
    'ui__client/domain/dns__short-title' => 'DNS设置',
    'ui__client/domain/dns__description' => '管理域名%1的DNS区域设置。',
    'ui__client/domain/dns_self__title' => 'DNS设置',
    'ui__client/domain/dns_self__short-title' => 'DNS设置',
    'ui__client/domain/dns_self__description' => '管理域名的DNS区域设置。',
    'ui__client/domain/dns_disabled__title' => 'DNS设置',
    'ui__client/domain/dns_disabled__short-title' => 'DNS设置',
    'ui__client/domain/dns_disabled__description' => '管理域名%1的DNS区域设置。',
    'ui__client/domain/dns_self-disabled__title' => 'DNS设置',
    'ui__client/domain/dns_self-disabled__short-title' => 'DNS设置',
    'ui__client/domain/dns_self-disabled__description' => '管理域名的DNS区域设置。',
    'ui__client/domain/dns_readonly__title' => 'DNS设置',
    'ui__client/domain/dns_readonly__short-title' => 'DNS设置',
    'ui__client/domain/dns_readonly__description' => '查看域名%1的DNS区域设置。',
    'ui__client/domain/dns_readonly-self__title' => 'DNS设置',
    'ui__client/domain/dns_readonly-self__short-title' => 'DNS设置',
    'ui__client/domain/dns_readonly-self__description' => '查看域名的DNS区域设置。',
    'ui__client/domain/dns_readonly-self-disabled__title' => 'DNS设置',
    'ui__client/domain/dns_readonly-self-disabled__short-title' => 'DNS设置',
    'ui__client/domain/dns_readonly-self-disabled__description' => '查看域名的DNS区域设置。',
    'ui__client/domain/dns_readonly-self-slave__title' => 'DNS设置',
    'ui__client/domain/dns_readonly-self-slave__short-title' => 'DNS设置',
    'ui__client/domain/dns_readonly-self-slave__description' => '查看域名的DNS区域设置。',
    'ui__client/domain/dns_slave__title' => 'DNS设置',
    'ui__client/domain/dns_slave__short-title' => 'DNS设置',
    'ui__client/domain/dns_slave__description' => '管理域名%1的DNS区域设置。',
    'ui__client/domain/dns_self-slave__title' => 'DNS设置',
    'ui__client/domain/dns_self-slave__short-title' => 'DNS设置',
    'ui__client/domain/dns_self-slave__description' => '管理域名的DNS区域设置。',
    // FrontPage management - RESELLER/WEBSITE    // PFW

    // applications & services
    // icons
    'ui__client/domain/extras__short-title' => '来自MyPlesk.com的工具',
    'ui__client/domain/extras__title' => '来自MyPlesk.com的工具',
    'ui__client/domain/extras__description' => '从MyPlesk.com获取其它工具和服务。',
    'ui__client/domain/extras_unknown__short-title' => '来自MyPlesk.com的工具',
    'ui__client/domain/extras_unknown__title' => '来自MyPlesk.com的工具',
    'ui__client/domain/extras_unknown__description' => '从MyPlesk.com获取其他工具和服务。',
    'ui__client/domain/extras_self__short-title' => '来自MyPlesk.com的工具',
    'ui__client/domain/extras_self__title' => '来自MyPlesk.com的工具',
    'ui__client/domain/extras_self__description' => '从MyPlesk.com获取其它工具和服务。',
    'ui__client/domain/odbc__short-title' => 'ODBC 数据源', // PFW
    'ui__client/domain/odbc__title' => 'ODBC 数据源', // PFW
    'ui__client/domain/odbc__description' => '设置域名%1的ODBC数据源。', // PFW
    'ui__client/domain/odbc_self__short-title' => 'ODBC 数据源', // PFW
    'ui__client/domain/odbc_self__title' => 'ODBC 数据源', // PFW
    'ui__client/domain/odbc_self__description' => '设置域名的ODBC数据源。', // PFW
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/domain/register__short-title' => '注册域名',
    'ui__client/domain/register__title' => '注册域名',
    'ui__client/domain/register__description' => '通过MyPlesk.com注册域名。',
    'ui__client/domain/register_unknown__short-title' => '注册域名',
    'ui__client/domain/register_unknown__title' => '注册域名',
    'ui__client/domain/register_unknown__description' => '通过MyPlesk.com注册域名。',
    'ui__client/domain/register_self__short-title' => '注册域名',
    'ui__client/domain/register_self__title' => '注册域名',
    'ui__client/domain/register_self__description' => '通过MyPlesk.com注册域名。',
    // dropdowns
    // Create database user - RESELLER/APPLICATIONS & SERVICES

    // additional tools
    // icons
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS    // PFU
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    'ui__client/domain/hosting/hotlink-protection__short-title' => '盗链防护', // PFW
    'ui__client/domain/hosting/hotlink-protection__title' => '盗链防护', // PFW
    'ui__client/domain/hosting/hotlink-protection__description' => '防止域名%1上的文件被盗链。', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__short-title' => '盗链防护', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__title' => '盗链防护', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__description' => '防止文件盗链。', // PFW
    'ui__client/domain/hosting/performance__short-title' => '带宽限制',
    'ui__client/domain/hosting/performance__title' => '带宽使用限制和允许的网站连接数',
    'ui__client/domain/hosting/performance__description' => '查看和调整域名%1的带宽使用限制及同时连接数。',
    'ui__client/domain/hosting/performance_readonly__short-title' => '带宽限制',
    'ui__client/domain/hosting/performance_readonly__title' => '带宽使用限制和允许的网站连接数',
    'ui__client/domain/hosting/performance_readonly__description' => '查看和调整域名%1的带宽使用限制及同时连接数。',
    'ui__client/domain/hosting/performance_self__short-title' => '带宽限制',
    'ui__client/domain/hosting/performance_self__title' => '带宽限制',
    'ui__client/domain/hosting/performance_self__description' => '查看和调整域名的带宽使用限制及同时连接数。',
    'ui__client/domain/hosting/performance_readonly-self__short-title' => '带宽限制',
    'ui__client/domain/hosting/performance_readonly-self__title' => '带宽限制',
    'ui__client/domain/hosting/performance_readonly-self__description' => '查看和调整域名带宽使用限制及同时连接数。',

    // dropdowns


    ///
    /// END OF DOMAIN / DOMAIN ADMINISTRATOR
    ///

    ////
    //// KEYS FOR BUSINESS OBJECT LISTS/PAGES (RESELLERS, CLIENTS, DOMAINS)
    ////

    ///
    /// DOMAINS
    ///

    // Domains list page title - ui__client/domain_unknown__short-title (HOME)

    // tools
    'ui__client/domain#tools__title' => "工具",
    // Below: TBD
    'ui__client/domain-summary-report_unknown__short-title' => '查看统计数据',
    'ui__client/domain-summary-report_unknown__title' => '查看统计数据',
    'ui__client/domain-summary-report_unknown__description' => '查看域名的资源使用相关信息。',
    'ui__client/domain-summary-report__short-title' => "查看统计数据",
    'ui__client/domain-summary-report__title' => "查看统计数据",
    'ui__client/domain-summary-report__description' => "查看域名的资源使用相关信息。",
    'ui__client/domain-summary-report_self__short-title' => "查看统计数据",
    'ui__client/domain-summary-report_self__title' => "查看统计数据",
    'ui__client/domain-summary-report_self__description' => "查看域名所用资源的相关信息。",
    // Traffic usage - ui__client/domain/traffic_unknown__short-title

    'ui__client/domain#list__title' => "域名", // DOMAINS

    // list object operation errors
    'ui__client/domain/delete__empty_selection' => '请选择要删除的域名',
    'ui__client/domain/chowner__empty_selection' => '请选择要分配给新所有者的域名',

    // list objects filtering
    'domains_list__name__filter_title' => '名称',
    'domains_list__state__filter_title' => '资源使用量',
    'domains_list__filter_state_any' => '任何',
    'domains_list__filter_state_overuse' => '超额使用',
    'domains_list__filter_state_normal' => '在限制内',
    'domains_list__status__filter_title' => '状态',
    'domains_list__filter_status_any' => '任何',
    'domains_list__filter_status_blocked' => '挂起',
    'domains_list__filter_status_active' => '活动',
    'domains_list__ownership__filter_title' => '所有权',
    'domains_list__filter_ownership_all' => '所有域名',
    'domains_list__filter_ownership_personal' => '仅限我的域名',
    'domains_list__filter_owner_pname__filter_title' => '所有者名称',
    'domains_list__subrows__filter_title' => '显示',
    'domains_list__subrows_off' => '仅限域名',
    'domains_list__subrows_subdomain_domainaliases' => '附子域名和别名',
    'domains_list__subrows_subdomain' => '附子域名',
    'domains_list__subrows_domainaliases' => '附别名',

    // objects list
    'domains_list__owner__title' => '所有者',

    ///
    /// END OF DOMAINS
    ///

    ////
    //// KEYS FOR APPLICATION VAULT AND WEB APPLICATION MANAGEMENT
    ////

    ///
    /// APPLICATION VAULT / APS CATALOG
    ///

    // Application Vault / APS Catalog promotional block
    'site_apps__promo_browse_for_applications' => "查找应用程序",
    'site_apps__promo_main_text' => "应用程序打包标准(APS)目录包含可部署到域名或网站空间的应用程序列表。如果希望部署当前不在目录中的应用程序，您可以通过 www.apsstandard.com 上的APS打包指南轻松完成。",
    'site_apps__promo_download_now' => "下载应用程序:",
    'site_apps__promo_close' => "关闭此区",
    'site_apps__promo_preset__mostused' => '%1最常用',
    'site_apps__promo_preset__lessused' => '下%1最常用',
    'site_apps__promo_preset__all' => "所有",
    'site_apps__promo_disclaimer_note' => '请注意，从 APS 目录安装的应用程序由第三方提供，Plesk 不提供支持。',
    'site_apps__promo_preset__page_title' => '%1 APS应用程序',

    // Progress bar
    'site_apps__progress_initialization_message' => '添加应用程序...',

    // Errors
    'site_apps__no_applications_for_update' => '您没有在应用百宝箱中安装应用程序。',
    'site_apps__incorrect_download_preset_configuration' => 'APS目录下载预置配置出错。',
    'site_apps__aps_catalog_url_is_invalid' => '指定的URL无效。',
    'site_apps__no_updates_at_the_moment' => '此刻没有可用的应用程序更新。',
    'site_apps__incorrect_content_returned_by_catalog' => '从APS应用程序目录获取的信息错误。请稍后重试。',
    'site_apps__entered_aps_catalog_url_is_not_valid' => 'APS目录设置已保存，Plesk 无法建立到 APS 目录设置(%1)中指定APS目录的连接。请确定APS目录地址正确，且此地址上的APS目录处于活动状态。',
    'site_apps__cannot_retrieve_updates' => '此刻无法下载应用程序更新: 无法建立APS目录(%1)连接。请确定APS目录地址正确，且此地址上的APS目录处于活动状态。',
    'site_apps__no_site_applications_in_client_pool_to_install' => '无可供安装的web应用程序。',
    'site_apps__site_applications_already_installed_in_root' => '其它web应用程序已安装到这些虚拟主机的根目录中',
    'site_apps__dot_net_packages_not_supported_on_unix_platform' => "Unix/Linux平台不支持.NET web应用程序。",
    'site_apps__server_wide_packages_not_supported' => '服务器级web应用程序不受支持',
    'site_apps__applications_added_to_queue_for_adding_to_application_vault' => "%1 多个 web 应用程序已计划添加到应用百宝箱。",
    'site_apps__applications_all_in_vault' => "所选web应用程序已在应用百宝箱中。",
    'site_apps__applications_already_in_download_queue' => "此刻%1个所选web应用程序已添加到应用百宝箱中。",
    'site_apps__applications_already_in_valut' => "%1个所选web应用程序已在应用百宝箱中。",

    // UI errors

    ///
    /// END OF APPLICATION VAULT / APS CATALOG
    ///

    ///
    /// APS CATEGORIES
    ///

    // General
    'site_apps__not_categorized' => '其它(未分类)',

    // Errors
    'site_apps__no_applications_in_category' => '此类别中无可用的应用程序。请选择另一类别。',
    'site_apps__no_category_selected__please_specify' => '选择左侧菜单中的类别。所选类别中所有可用的应用程序将会列出在此窗口中。',

    // Category: Back office
    // Category: Collaboration
    // Category: Front Office
    // Category: Infrastructure
    // Category: Personal
    // Category: Web

    ///
    /// END OF APS CATEGORIES
    ///

    ///
    /// APPLICATION VAULT
    ///

    //removal


    ///
    /// END OF APPLICATION VAULT
    ///

    ////
    //// KEYS FOR SETTINGS PAGE
    ////

    ///
    /// SERVER ADMINISTRATOR SETTINGS
    ///

    'administrator_account' => '管理员帐户',
    // Personal data - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Change password - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Interface preferences - HOME/SERVER ADMINISTRATOR/ACCOUNT

    'general' => '常用',
    // Server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_change_hostname' => '更改主机名',
    // System time - HOME/SERVER ADMINISTRATOR/SERVER
    // IP addresses - HOME/SERVER ADMINISTRATOR/SERVER
    // Scheduled tasks - HOME/SERVER ADMINISTRATOR/SERVER
    // FTP settings - HOME/SERVER ADMINISTRATOR/SERVER    // PFW

    'security' => '安全',
    'bt_setup_firewall' => '设置防火墙',
    'bt_manage_firewall_rules' => '管理防火墙规则',
    'cu_firewall__rule' => '创建防火墙规则',
    'cu_firewall__protocol' => '为该规则设置一个协议（\'tcp\' or \'udp\'）',
    'cu_firewall__name' => "设定一个规则名称",
    'cu_firewall__disabled' => '如果是 \'对\'，创建后此规则将被禁用',
    // Session idle time - HOME/SERVER ADMINISTRATOR/SECURITY
    // SSL/TLS certificates - HOME/SERVER ADMINISTRATOR/SECURITY
    // Shared SSL/TLS - HOME/SERVER ADMINISTRATOR/SECURITY    // PFW

    'dns' => 'DNS',
    'bt_select_dns_server' => '选择DNS服务器', // PFW
    'bt_soa_records_template' => 'SOA记录模板',
    'bt_restrict_creation_of_subzones' => '限制创建子区域',

    'databases' => '数据库',
    'bt_select_mssqlwebadmin' => '选择MS SQL WebAdmin', // PFW
    // Database hosting preferences - HOME/SERVER ADMINISTRATOR/SERVER

    'applications' => '应用程序',
    // ASP.NET settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // IIS application pool - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // SiteBuilder settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES

    'mail' => '邮件',
    'bt_select_mailserver' => '选择邮件服务器', // PFW
    // Mail server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_antivirus' => '选择防病毒程序', // PFW
    'bt_virus_protection_settings' => '病毒防护设置',
    'bt_select_spamfilter' => '选择垃圾邮件过滤器', // PFW
    // Spam filter settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_webmail' => '选择 Web 邮箱',
    // Set up mailing lists server - HOME/SERVER ADMINISTRATOR/SERVER    // PFU

    'logs_and_statistics' => '日志与统计',
    'bt_server_statistics_settings' => '服务器统计设置',
    'bt_select_web_statistics' => '可用的网站统计软件', // PFW
    // Action log - HOME/SERVER ADMINISTRATOR/LOGS & STATISTICS

    'control_panel_interface' => 'Plesk 界面',

    'components_and_modules' => '组件与模块',
    // Server components - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_setup_watchdog' => '设置Watchdog', // PFU
    'bt_setup_vpn' => '设置VPN', // PFU
    'bt_setup_samba' => '设置samba',    // PFU

    ///
    /// END OF SERVER ADMINISTRATOR SETTINGS
    ///

    ///
    /// DOMAIN SETTINGS
    ///

    'ui__client/domain/settings_self__title' => '设置',
    'ui__client/domain/settings_self__short-title' => '设置',
    'ui__client/domain/settings_self__description' => '查看和更改域名设置。',

    'domain_administrator_account' => '域名管理员帐户',
    // Interface preferences - HOME/DOMAIN ADMINISTRATOR/DOMAIN
    'bt_account_settings' => '帐户设置',

    'domain' => '域名',
    'bt_dns_soa_records' => 'DNS SOA记录',
    // Mail settings - HOME/DOMAIN ADMINISTRATOR/MAIL
    'bt_task_scheduler_settings' => '任务计划程序设置',

    'website' => '网站',
    // Web hosting settings - HOME/DOMAIN ADMINISTRATOR/WEBSITE
    // Bandwidth limiting - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS
    'bt_web_users_scripting' => '网站用户脚本',
    // Anonymous FTP - HOME/DOMAIN ADMINISTRATOR/FILES

    // Applications - SETTINGS/SERVER/APPLICATIONS    // PFW
    // ASP.NET settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // PHP settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // IIS application pool - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Security - SETTINGS/SERVER/SECURITY
    // Password protected directories - HOME/DOMAIN ADMINISTRATOR/FILES
    'bt_select_ssl_certificate' => '选择 SSL/TLS 证书',
    // Hotlink protection - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // Shared SSL/TLS - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Logs & statistics - SETTINGS/SERVER/LOGS & STATISTICS
    'bt_web_statistics' => '网站统计',
    'bt_log_rotation_settings' => '日志循环设置',

    ///
    /// END OF DOMAIN SETTINGS
    ///

    ////
    //// KEYS FOR LIMITS AND PERMISSIONS
    ////

    ///
    /// LIMITS
    ///

    '__limits' => "限制", // template

    // overuse & oversell
    'limits__overuse_oversell_policy_legend' => "超额使用与超额销售策略",
    'limits__overuse_policy_legend' => "超额使用",
    'limits__oversell_policy_legend' => "过度销售",
    'limits__reseller_overuse_description' => "超额使用策略会在资源超额使用时指令 Plesk 如何进行操作。",
    'limits__overuse_text' => "超额使用策略",

    // limit names
    'limit_group__disk_space_and_traffic' => '磁盘空间和流量',
    'limit__disk_space' => '磁盘空间',
    'limit__max_traffic' => '流量',
    'limit_group__client' => '客户',
    'limit__max_cl' => '客户',
    'limit_group__domain' => '域名',
    'limit__max_dom' => '域名',
    'limit__max_dom_powerUser' => '订阅',
    'limit__max_subdom' => '子域名',
    'limit__max_dom_aliases' => '域名别名',
    'limit__max_wu' => '网站用户',
    'limit__max_subftp_users' => '其它 FTP 帐户', // PFW
    'limit_group__mail' => '邮件',
    'limit__max_box' => '邮箱',
    'limit__mbox_quota' => '邮箱大小',
    'limit__total_mboxes_quota' => '总邮箱配额', // PFW
    'limit__max_maillists' => '邮件列表',
    'limit_group__database' => '数据库',
    'limit__max_mssql_db' => 'Microsoft SQL Server数据库', // PFW
    'limit__mssql_dbase_space' => '所有的 MS SQL 数据库配额', // PFW
    'limit__max_odbc' => 'ODBC 连接', // PFW
    // limit__max_db - CONFLICTED
    'limit__mysql_dbase_space' => 'MySQL 数据库配额', // PFW?
    'limit_group__application' => '应用程序',
    'limit__max_iis_app_pools' => 'IIS 应用程序池', // PFW
    'limit_group__security' => '安全',
    'limit_group__validity' => '到期日',
    'limit__expiration' => '到期日',
    'limit__validity' => '有效期',
    'limit__max_site_builder' => '通过 Presence Builder 发布网站',
    'limit__max_site' => '域名',
    'limit__mssql_dbase_filesize' => 'MS SQL 数据库文件大小',
    'limit__mssql_dbase_log_filesize' => 'MS SQL 数据库日志文件大小',
    'limit__mssql_dbase_filesize_hint' => 'Microsoft SQL 数据库文件大小的最大值。',
    'limit__mssql_dbase_log_filesize_hint' => 'Microsoft SQL 数据库日志文件大小的最大值。',
    'limit__units_mssql_dbase_filesize' => "MB",
    'limit__units_mssql_dbase_log_filesize' => "MB",

    'dom_pref__invalid_max_site_limit' => '域名限制无效。最小值为1。',

    'property__has_wrong_value' => '属性 %1 有一个错误的值。',
    'property__name_outgoing_messages_domain_limit' => '为发自一个域名的信息（每小时）设定限制。若要设为无限值，请指定 "-1"。指定“默认”则可以设置在服务器级设置中指定的值。',
    'property__name_outgoing_messages_mbox_limit' => '为发自一个邮箱的信息（每小时）设定限制。若要设为无限值，请指定 "-1"。指定“默认”则可以设置在服务器级设置中指定的值。',
    'property__name_outgoing_messages_subscription_limit' => '为发自一个订阅的信息（每小时）设定限制。若要设为无限值，请指定 "-1"。指定“默认”则可以设置在服务器级设置中指定的值。',

    // for CLI report & email notifications
    '__resource_notify' => '通知',
    '__general' => '常用',
    '__template_shared' => '共享模板',
    'limit__overuse' => '超额使用策略',
    'limit__max_traffic_soft' => '达到流量使用限制时则通知',
    'limit__disk_space_soft' => '达到磁盘空间使用限制时则通知',
    '__overuse' => '超额使用策略',
    'performance__title' => '性能',
    'performance__bandwidth' => '带宽最大使用量 (KB/S)',
    'performance__max_connections' => '最大连接数',

    'gch__hosting_php_isapi' => '将 PHP 作为 ISAPI 扩展运行',
    'gch__hosting_ssi_html' => '在 htm 和 html 文件中使用 SSI',
    'gch__hosting_php_handler_type' => '运行 PHP 以',
    'gch__hosting_php_handler_id' => '运行 PHP 以',
    'gch__hosting_php_served_by_nginx' => '由 nginx 服务的 PHP',
    'gch__hosting_unpaid_website_status' => '已被挂起订阅中的网站状态',
    'gch__mn_no_autoresponder' => '尚未对此邮件帐户设置自动回复。',
    'gch__no_clients_selected' => "未选择客户帐户",
    'gch__no_domains_selected' => "尚未选择域名",

    // limit units
    'limit__units_disk_space' => "MB",
    'limit__units_max_traffic' => "MB/月",
    'limit__units_mbox_quota' => "KB",
    'limit__units_mysql_dbase_space' => "MB", // PFW
    'limit__units_mssql_dbase_space' => "MB", // PFW
    'limit__units_total_mboxes_quota' => "MB", // PFW

    // manipulations and statuses of limits
    '__resource_name' => '资源名称',
    '__resource_usage' => '已使用',
    '__resource_limit' => '限制',

    '__used' => '已使用',
    '__limit' => '限制',

    '__never_expires' => '永不过期',
    '__resource_free' => '%1可用，共%2',
    '__resource_unlimited' => '已用 %1（共计无限）',

    '__unlimited' => '无限',
    '__increment' => "增加 (+)",
    '__decrement' => "减小 (-)",
    '__pt' => '单位',
    '__procent' => '%',
    '__overused' => '超额使用',
    '__left' => '左',
    '__available' => '可用',
    '__not_available' => '未包括在内',

    ///
    /// END OF LIMITS
    ///

    ///
    /// PERMISSIONS
    ///

    //permissions hints

    ///
    /// END OF PERMISSIONS
    ///

    ////
    //// KEYS FOR STATISTICS AND REPORTS
    ////

    ///
    /// REPORT
    ///

    // administrator

    'ui__admin/report/traffic-history__short-title' => '查看流量历史',
    'ui__admin/report/traffic-history__title' => '查看流量历史',
    'ui__admin/report/traffic-history__description' => '查看代理商、客户和域名的流量历史。',
    'admin_traffic_history__title' => '流量历史',

    'ui__admin/report/layout/auto_unknown__short-title' => '发送计划',
    'ui__admin/report/layout/auto_unknown__title' => '报告发送计划',
    'ui__admin/report/layout/auto_unknown__description' => '选择报告发送计划。',
    'ui__admin/report/layout/auto/properties_new__short-title' => '添加报告发送计划',
    'ui__admin/report/layout/auto/properties_new__title' => '添加报告发送计划',
    'ui__admin/report/layout/auto/properties_new__description' => '为报告 %1 添加报告发送计划。',
    'ui__admin/report/layout/auto/properties__short-title' => '报告发送计划',
    'ui__admin/report/layout/auto/properties__title' => '报告发送计划',
    'ui__admin/report/layout/auto/properties__description' => '查看和修改报告发送计划属性。',
    'ui__admin/report/layout/auto/delete_multi__short-title' => '删除报告发送计划',
    'ui__admin/report/layout/auto/delete_multi__title' => '删除报告发送计划',
    'ui__admin/report/layout/auto/delete_multi__description' => '删除所选报告发送计划。',

    'ui__admin/report/layout_unknown__short-title' => '报告布局',
    'ui__admin/report/layout_unknown__title' => '报告布局',
    'ui__admin/report/layout_unknown__description' => '查看和管理报告布局。',
    'ui__admin/report/layout/properties_unknown-new__short-title' => '创建报告布局',
    'ui__admin/report/layout/properties_unknown-new__title' => '创建报告布局',
    'ui__admin/report/layout/properties_unknown-new__description' => '创建报告布局。',
    'ui__admin/report/layout/delete_multi__short-title' => '删除报告布局',
    'ui__admin/report/layout/delete_multi__title' => '删除报告布局',
    'ui__admin/report/layout/delete_multi__description' => '删除所选报告布局',
    'ui__admin/report/layout/properties__short-title' => '属性',
    'ui__admin/report/layout/properties__title' => '报告布局属性',
    'ui__admin/report/layout/properties__description' => '编辑报告布局属性。',

    // reseller
    'reseller_traffic_history__title' => "代理商%1流量历史",

    'ui__reseller/traffic__short-title' => '%1',
    'ui__reseller/traffic__title' => '查看 <b>%1</b> 的流量使用情况',
    'ui__reseller/traffic__description' => '查看代理商帐户%1的流量使用报告。',
    'ui__reseller/traffic_self__short-title' => '我的',
    'ui__reseller/traffic_self__title' => '查看客户所用流量',
    'ui__reseller/traffic_self__description' => '查看客户帐户的流量使用报告。',

    'ui__reseller/report/traffic-history__short-title' => '查看流量历史',
    'ui__reseller/report/traffic-history__title' => '查看流量历史',
    'ui__reseller/report/traffic-history__description' => "查看代理商%1的流量历史。",
    'ui__reseller/report/traffic-history_self__short-title' => '查看流量历史',
    'ui__reseller/report/traffic-history_self__title' => '查看流量历史',
    'ui__reseller/report/traffic-history_self__description' => '查看流量历史。',

    'ui__reseller/report/layout/auto_unknown__short-title' => '发送计划',
    'ui__reseller/report/layout/auto_unknown__title' => '报告发送计划',
    'ui__reseller/report/layout/auto_unknown__description' => '选择报告发送计划的布局。',
    'ui__reseller/report/layout/auto/properties_new__short-title' => '添加报告发送计划',
    'ui__reseller/report/layout/auto/properties_new__title' => '添加报告发送计划',
    'ui__reseller/report/layout/auto/properties_new__description' => '为报告 %1 添加报告发送计划。',
    'ui__reseller/report/layout/auto/properties__short-title' => '报告发送计划',
    'ui__reseller/report/layout/auto/properties__title' => '报告发送计划',
    'ui__reseller/report/layout/auto/properties__description' => '查看和修改报告发送计划属性。',
    'ui__reseller/report/layout/auto/delete_multi__short-title' => '删除报告发送计划',
    'ui__reseller/report/layout/auto/delete_multi__title' => '删除报告发送计划',
    'ui__reseller/report/layout/auto/delete_multi__description' => '删除所选报告发送计划',

    'ui__reseller/report/layout_unknown__short-title' => '报告布局',
    'ui__reseller/report/layout_unknown__title' => '报告布局',
    'ui__reseller/report/layout_unknown__description' => '查看和管理报告布局。',
    'ui__reseller/report/layout/properties_unknown-new__short-title' => '创建报告布局',
    'ui__reseller/report/layout/properties_unknown-new__title' => '创建报告布局',
    'ui__reseller/report/layout/properties_unknown-new__description' => '创建报告布局。',
    'ui__reseller/report/layout/properties_new__short-title' => '创建报告布局',
    'ui__reseller/report/layout/properties_new__title' => '创建报告布局',
    'ui__reseller/report/layout/properties_new__description' => '创建报告布局。',
    'ui__reseller/report/layout/delete_multi__short-title' => '删除报告布局',
    'ui__reseller/report/layout/delete_multi__title' => '删除报告布局',
    'ui__reseller/report/layout/delete_multi__description' => '删除所选报告布局',
    'ui__reseller/report/layout/properties__short-title' => '属性',
    'ui__reseller/report/layout/properties__title' => '报告布局属性',
    'ui__reseller/report/layout/properties__description' => '编辑报告布局属性。',

    // customer
    'cl_traffic_history__title' => "客户%1的流量历史",

    'ui__client/traffic__short-title' => '%1',
    'ui__client/traffic__title' => '查看 <b>%1</b> 的流量使用情况',
    'ui__client/traffic__description' => '查看客户帐户%1的流量使用报告。',
    'ui__client/traffic_self__short-title' => '流量使用',
    'ui__client/traffic_self__title' => '域名所用的流量',
    'ui__client/traffic_self__description' => '查看域名所用流量报告。',

    'ui__client/report/traffic-history__short-title' => '查看流量历史',
    'ui__client/report/traffic-history__title' => '查看流量历史',
    'ui__client/report/traffic-history__description' => '查看客户%1的流量历史。',
    'ui__client/report/traffic-history_self__short-title' => '查看流量历史',
    'ui__client/report/traffic-history_self__title' => '查看流量历史',
    'ui__client/report/traffic-history_self__description' => '查看流量历史。',


    ///
    /// END OF REPORT
    ///

    ///
    /// SUMMARY / FULL REPORT
    ///

    // common full report
    'report__full_p' => 'P',
    'report__full_s' => 'S',
    'report__full_h' => 'H',
    'report__full_reseller_name' => '代理商名称', // reseller report
    'report__full_client_name' => '客户名称', // customer report
    'report__full_domain_name' => '域名', // domain report
    'report__full_owner' => '所有者', // customer & domain reports
    'report__full_creation_date' => '创建日',
    'report__full_size' => '大小',
    'report__full_traffic' => '流量',
    'report__full_active_clients' => '活动客户', // reseller report
    'report__full_clients' => '客户', // reseller report
    'report__full_active_domains' => '活动域名', // reseller & customer reports
    'report__full_domains' => '域名', // reseller & customer reports
    'report__full_subdomains' => '子域名',
    'report__full_mboxes' => '邮箱',
    'report__full_disk_space' => '磁盘空间',
    'report__full_mail_groups' => 'MForw',
    'report__full_mail_autoresp' => '回复',
    'report__full_mail_antispam' => '防垃圾邮件',
    'report__full_mail_antivirus' => '防病毒程序',
    'report__full_mail_lists' => '邮件列表',
    'report__full_web_users' => '网站用户',
    'report__full_mysql_databases' => 'MySQL DB',
    'report__full_mssql_databases' => 'MSSQL DB',

    // common summary report
    'report__section_general' => '常用',
    'report__version' => '产品版本',
    'report__build' => '产品小版本号',
    'report__status' => '状态',
    'report__company_name' => '公司名称',
    'report__personal_name' => '个人姓名',
    'report__login' => '用户名',
    'report__phone' => '电话',
    'report__fax' => '传真',
    'report__email' => '电子邮箱',
    'report__address' => '地址',
    'report__city' => '城市',
    'report__state' => '省/市/自治区',
    'report__zip_code' => '邮政编码',
    'report__country' => '国家',
    'report__creation_date' => '创建日',
    'report__expiration_date' => '到期日',
    'report__dumps_total_size' => '备份文件总大小',
    'report__section_resellers' => '代理商',
    'report__active_resellers' => '有活动订阅的代理商',
    'report__resellers' => '代理商',
    'report__section_full_resellers' => '代理商',
    'report__section_clients' => '客户',
    'report__active_clients' => '有活动订阅的客户',
    'report__clients' => '客户',
    'report__section_full_clients' => '客户',
    'report__section_personal_clients' => '个人客户',
    'report__active_personal_clients' => '您自己的有活动订阅的客户',
    'report__personal_clients' => '个人客户',
    'report__section_full_personal_clients' => '个人客户',
    'report__section_domains' => '域名',
    'report__disk_usage' => '磁盘空间',
    'report__traffic' => '流量',
    'report__active_domains' => '活动域名',
    'report__domains' => '域名',
    'report__subdomains' => '子域名',
    'report__mboxes' => '邮箱',
    'report__mail_groups' => '邮件转发',
    'report__mail_autoresp' => '自动回复',
    'report__mail_lists' => '邮件列表',
    'report__web_users' => '网站用户',
    'report__mysql_databases' => 'MySQL 数据库',
    'report__mssql_databases' => 'MySQL数据库',
    'report__section_full_domains' => '域名',
    'report__section_personal_domains' => '个人域名',
    // keys here are the same as in report__section_domains section
    'report__section_full_personal_domains' => '个人域名',

    //New for Plesk 10
    'report__sitebuilder_sites' => '通过 Presence Builder 发布网站',
    'report__invalid_email' => '请指定一个有效的电子邮件地址。',


    // CLI-specific sections
    'report__section_hosting' => '主机',
    'report__section_webusers' => '网站用户',
    'report__section_mailnames' => '邮件帐户',
    'report__section_maillists' => '邮件列表',
    'report__section_databases' => '数据库',
    'report__section_siteapps' => 'Web应用程序',
    'report__section_aspnetapps' => 'ASP.NET应用程序', // PFW
    'report__owner_pname' => "服务商个人姓名",
    'report__owner_login' => "服务商用户名",

    ///
    /// END OF SUMMARY / FULL REPORT
    ///

    ////
    //// KEYS FOR VARIOUS FEATURES
    ////

    ///
    /// SERVER INTERFACE
    ///

    // Locales
    // errors
    'locales__not_allowed' => '已在系统中安装指定的语言包但是未启用。',

    ///
    /// END OF SERVER INTERFACE
    ///

    ///
    /// HOME PAGE CUSTOMIZATION
    ///

    ///
    /// SESSIONS
    ///

    // Entry keys are under respective HP/ADDITIONAL TOOLS/ACTIVE SESSIONS

    // administrator
    'ui__sessions/delete__short-title' => '删除会话',
    'ui__sessions/delete__title' => '删除会话',
    'ui__sessions/delete__description' => '删除所选会话。',
    'ui__ftp-sessions__short-title' => 'FTP 会话',
    'ui__ftp-sessions__title' => 'FTP 会话',
    'ui__ftp-sessions__description' => '查看FTP会话。',
    'ui__ftp-sessions/delete__short-title' => '删除FTP会话',
    'ui__ftp-sessions/delete__title' => '删除FTP会话',
    'ui__ftp-sessions/delete__description' => '删除所选的FTP会话。',
    'ui__ts-sessions__short-title' => 'TS会话',
    'ui__ts-sessions__title' => 'TS会话',
    'ui__ts-sessions__description' => '查看终端服务会话。',
    'ui__ts-sessions/properties__title' => '会话属性',

    // reseller
    'ui__reseller/sessions/delete__short-title' => '删除会话',
    'ui__reseller/sessions/delete__title' => '删除会话',
    'ui__reseller/sessions/delete__description' => '删除所选会话。',
    'ui__reseller/sessions/delete_self__short-title' => '删除会话',
    'ui__reseller/sessions/delete_self__title' => '删除会话',
    'ui__reseller/sessions/delete_self__description' => '删除所选会话。',
    'ui__reseller/ftp-sessions__short-title' => 'FTP 会话',
    'ui__reseller/ftp-sessions__title' => 'FTP 会话',
    'ui__reseller/ftp-sessions__description' => '查看FTP会话。',
    'ui__reseller/ftp-sessions_self__short-title' => 'FTP 会话',
    'ui__reseller/ftp-sessions_self__title' => 'FTP 会话',
    'ui__reseller/ftp-sessions_self__description' => '查看FTP会话。',
    'ui__reseller/ftp-sessions/delete__short-title' => '删除FTP会话',
    'ui__reseller/ftp-sessions/delete__title' => '删除FTP会话',
    'ui__reseller/ftp-sessions/delete__description' => '删除所选的FTP会话。',
    'ui__reseller/ftp-sessions/delete_self__short-title' => '删除FTP会话',
    'ui__reseller/ftp-sessions/delete_self__title' => '删除FTP会话',
    'ui__reseller/ftp-sessions/delete_self__description' => '删除所选的FTP会话。',

    // customer
    'ui__client/sessions/delete__short-title' => '删除会话',
    'ui__client/sessions/delete__title' => '删除会话',
    'ui__client/sessions/delete__description' => '删除所选会话。',
    'ui__client/sessions/delete_self__short-title' => '删除会话',
    'ui__client/sessions/delete_self__title' => '删除会话',
    'ui__client/sessions/delete_self__description' => '删除所选会话。',

    // domain administrator

    'forgery_token_expired' => '会话令牌已过期。',

    ///
    /// END OF SESSIONS
    ///

    ///
    /// USER ACCOUNT CONVERSION
    ///

    //
    // USER ACCOUNT TYPE CHANGES
    //

    // resellers > customers
    'downgradeResellers__downgrade_resellers' => '下列代理商帐户即将转换为客户帐户',
    'downgradeResellers__downgrade' => '待转换的代理商帐户',
    // controls
    'downgradeResellers__submit_downgrade' => '执行帐户转换。',
    'downgradeResellers__cancel_downgrade' => '取消帐户转换。',
    'downgradeResellers__confirm' => '确认转换',
    'downgradeResellers__confirm_message' => '确认进行帐户转换',
    // errors

    // customers > resellers
    'picker_client_multi__title' => '选择客户帐户',
    'upgradeClients__upgrade_clients' => '下列客户帐户将会转换为代理商帐户',
    'upgradeClients__upgrade' => '即将转换的客户帐户',
    // controls
    'upgradeClients__submit_upgrade' => '执行帐户转换。',
    'upgradeClients__cancel_upgrade' => '取消帐户转换。',
    'upgradeClients__confirm' => '确认转换',
    'upgradeClients__confirm_message' => '确认进行帐户转换',
    // errors
    'upgradeClient__user_is_already_reseller' => '无法转换 \'%1\' 为代理商：\'%1\' 已经是代理商。',

    // domain administrators > customers
    'upgradeDomainUser__upgrade_domain_users' => '下列域名管理员帐户即将转换为客户帐户',
    'upgradeDomainUser__upgrade' => '即将转换下列域名管理员帐户',
    // controls
    'upgradeDomainUser__submit_upgrade' => '执行帐户转换。',
    'upgradeDomainUser__cancel_upgrade' => '取消帐户转换。',
    'upgradeDomainUser__confirm' => '确认转换',
    'upgradeDomainUser__confirm_message' => '确认进行帐户转换',
    // errors
    'upgradeDomainUser__non_upgradeable' => '无法转换的域名管理员帐户',
    'upgradeDomainUser__non_upgradeable_domain_users' => '下列域名管理员帐户无法转换为客户帐户:',
    'upgradeDomainUser__some_domains_were_not_converted' => '无法转换为客户帐户的多个域名管理员帐户。%%domainsList%%',
    'upgradeDomainUser__domain_user_does_not_exist' => '域名管理员帐户不存在',
    'upgradeDomainUser__domain_owner_must_be_a_reseller' => "此域名应直接属于服务器管理员或代理商。",
    'upgradeDomainUser__all_logins_already_used' => '无法为最终客户帐户创建帐户。',
    // notifications
    'upgradeDomainUser__upgrade_notification_subject' => '域名管理员帐户已转换',
    'upgradeDomainUser__upgrade_notification_body' => '您的域名管理员帐户已转换为客户帐户，用户名为"%%login%%"，密码为"%%password%%"。',

    //
    // USER ACCOUNT OWNER CHANGES
    //

    // Customer owner change
    // customers selection - reseller & admin home
    'picker_client__title' => '选择客户帐户',
    // errors
    'clientOwnerChanger__owner_has_no_permission' => '选定的代理商没有权限 \\&apos;%1\\&apos;，但是某些客户有该权限。',
    'clientOwnerChanger__application_not_allowed' => '选定代理商无法使用应用程序 \\&apos;%1\\&apos;，但是某些客户可以使用。',

    // Domain owner change
    'ui__client/domain/chowner_multi-select__wizard-title' => '正在重新分配选定的订阅',
    // errors
    'domain_chown__empty_selection' => '请为所选域名选择新所有者',



    //
    // USER ACCOUNT STATE CHANGES
    //


    ///
    /// END OF USER ACCOUNT CONVERSION
    ///

    ///
    /// BANDWIDTH LIMITING
    ///

    'hosting_performance__title' => '性能',
    'hosting_performance__traffic_bandwidth_legend' => '启用带宽限制',
    'hosting_performance__traffic_bandwidth_legend_ro' => '带宽限制',
    'hosting_performance__traffic_bandwidth_label' => '带宽最大使用量 (%1)',
    'hosting_performance__traffic_bandwidth_hint' => '带宽使用限制仅应用到通过HTTP协议传送的数据。',
    'hosting_performance__max_connection_legend' => '启用连接限制',
    'hosting_performance__max_connection_legend_ro' => '连接限制',
    'hosting_performance__max_connection_label' => '连接限制',
    'hosting_performance__max_connection_hint' => '如果您限制带宽使用，则建议您也限制此网站的同时连接数。如果网站请求频率较高，则Web服务器进程会增加服务器负载。',

    // errors:
    'performance__qos_not_installed' => '因尚未安装Qos，从而禁用功能',
    'performance__bandwidth_throttling' => '您不能控制带宽节流，因为 QoS 尚未安装。',
    'performance__invalid_value' => "无效值。范围应该从 %1 到 %2。",

    ///
    /// END OF BANDWIDTH LIMITING
    ///

    ///
    /// WEBMAIL SELECTION (these keys are currently PfU-only)
    ///

    'webmail__server_legend' => 'Web 邮箱',
    'webmail__server_text' => '可用的 web 邮箱客户端',
    'webmail__none' => '无',

    ///
    /// END OF WEBMAIL SELECTION
    ///


    ////
    //// BACKUP/RESTORATION
    ////

    // random common keys:
    'backup__ip_mapping__server_ip' => '服务器IP池',

    ///
    /// END OF BACKUP MANAGER ACTIONS
    ///

    ///
    /// LISTS
    ///


    // Common info/errors:
    'migration_db_server_not_find' => '数据库将不会被恢复：尚无合适的数据库服务器',

    ///
    /// END OF LISTS
    ///

    ///
    /// COMMON SCREENS
    ///

    // Back Up
    // Comments - __comments
    '__default_backup_comment_server' => "服务器备份。",
    '__default_backup_comment_reseller' => "%1 创建的代理商帐户备份。",
    '__default_backup_comment_client' => "%1 创建的客户帐户备份。",
    '__default_backup_comment_domain' => "%1 创建的订阅备份。",

    // Restoration & backup information

    // IP mapping
    'backup__ip_mapping__title' => '定义IP地址映射',
    'backup__ip_mapping__download' => '保存当前IP映射到文件',
    'b_backup__ip_mapping__download' => '单击下载IP映射配置。',
    'b_backup__ip_mapping__download_is_empty' => 'IP映射配置为空。',
    'backup__ip_mapping_upload__title' => '上传 IP 映射文件',
    'backup__ip_mapping__upload' => '上传 IP 映射文件',
    'b_backup__ip_mapping__upload' => '单击上传IP映射配置。',
    'backup__ip_mapping__list__header' => 'IP映射',
    'backup__ip_mapping__list__adddress' => '旧IP地址',
    'backup__ip_mapping__list__select_ip' => '新IP地址',
    'backup__ip_mapping__clients_ip' => "客户 %1 的 IP 池",
    'backup__ip_mapping__resellers_ip' => "代理商 %1 的 IP 池",
    'backup__ip_mapping__exclusive_ip_must_be_unique' => '独立 IP 地址应映射到唯一的IP地址。请为列表中的每个独立 IP 地址选择唯一的 IP 地址。',
    'backup__ip_mapping__legend' => 'IP映射',
    'backup__ip_mapping__upload_legend' => '上传',
    'backup__ip_mapping__upload_file_text' => 'IP映射文件',
    'backup__ip_mapping__upload_file_hint' => 'IP映射文件是纯文本文件。此文件的每行都包含如下格式的IP映射: <old IP address> <new IP address>',
    'backup__ip_mapping__ip_address_not_found' => '无此类可用 IP 地址',
    'backup__ip_mapping__ip_address_not_found_hint' => '无法执行数据迁移： IP 地址映射不完整，因为目标服务器上的 IP 池中没有可用的 IP 地址。',
    'backup__ip_mapping__ftp_will_be_disabled' => '禁止带有该 IP 地址的域名使用非安全 FTP 连接',
    'backup__ip_mapping__ftps_will_be_disabled' => '禁止带有该 IP 地址的域名使用安全 FTPS 连接',

    // Conflicts occured
    'legend_conflicts_occured' => '冲突',
    'backup__restore__object_vhost' => '虚拟主机',
    'backup__restore__object_plesk_admin' => 'Plesk 管理员',
    'backup__restore__object_ftpuser' => 'FTP帐户',
    'backup__restore__object_frontpageuser' => 'Frontpage帐户',
    'backup__restore__object_webuser' => '网站用户',
    'backup__restore__object_domain' => '域名',
    'backup__restore__object_subdomain' => '子域名',
    'backup__restore__object_domainalias' => '域名别名',
    'backup__restore__object_client' => '客户',
    'backup__restore__object_reseller' => '代理商',
    'backup__restore__object_autoresponder' => '自动回复',
    'backup__restore__object_mailalias' => '邮件别名',
    'backup__restore__object_database' => '数据库',
    'backup__restore__object_mailname' => '邮件帐户',
    'backup__restore__object_db_user' => '数据库用户',
    'backup__restore__object_ssl_certificate' => 'SSL/TLS 证书',
    'backup__restore__resellers_cannot_restore_converted_to_customers' => '无法恢复以下代理商，因为他们已被转换为客户：\\&apos;%1\\&apos;.',
    'backup__restore__customers_cannot_restore_converted_to_resellers' => '无法恢复以下客户，因为他们已被转换为代理商：\\&apos;%1\\&apos;.',
    'backup__restore__customers_cannot_restore_moved_to_another_owners' => '无法恢复以下客户，因为他们已被移动给其它所有者：\\&apos;%1\\&apos;.',

    // Before migration starts
    'backup__restore__capability_not_enough_disk_text' => '目标服务器上的磁盘空间不够存储用于传输所有选定的订阅。可用：%1 MB.要求：%2 MB。注意所需空间是网站、邮件和域名数据库内容的总量。所需空间每日计算一次并把结果存储于缓存中，因此域名的实际大小可能跟计算的大小有出入。如果您想要确保选定的域名不会占用比可用空间更大的空间，您可以进行传输。',
    'backup__restore__capability_not_enough_disk_resolution' => '请清空目标服务器上的磁盘空间。',
    'backup__restore__capability_source_not_enough_disk_text' => '源服务器上的磁盘空间不够存储用于迁移的临时文件。 可用： %1 MB. 需要 %2 MB.',
    'backup__restore__capability_source_not_enough_disk_resolution' => '请清空源服务器上的磁盘空间。',
    'backup__restore__capability_not_enough_disk_resolution_url_text' => '服务器信息',

    'backup__restore__capability_not_installed_component_text' => '目标服务器上的未安装组件 %1。%1 将不能用于所有被恢复的对象。',
    'backup__restore__capability_not_installed_component_resolution' => '请安装 %1。',
    'backup__restore__capability_existing_sys_user_text' => '目标服务器上已经存在名为 %1 的系统用户。',
    'backup__restore__capability_existing_sys_user_resolution' => '请重命名目标服务器上的现有系统用户。',
    'backup__restore__capability_license_usage_text' => '数据迁移后，目标服务器上的以下资源上限（许可证密钥定义）将会被超过：',
    'backup__restore__capability_license_usage_resolution' => '请在目标服务器上安装可提供所需资源量的其他许可证密钥。',
    'backup__restore__capability_max_allowed_packet_text' => "源数据库服务器上的 'max_allowed_packet' 参数是 %1，该值大于目标服务器上的值（%2）。以下指定的域名的一些数据库对象可能无法恢复。",
    'backup__restore__capability_max_allowed_packet_resolution' => "请增加目标数据库服务器上的 \\'max_allowed_packet\\' 值。",

    'backup__restore__capability_postgres_to_lower_version_text' => '无法迁移 PostgreSQL 数据库因为目标服务器上的 PostgreSQL 版本早于源服务器上的版本。 当前版本是 %1，所需版本是 %2。',
    'backup__restore__capability_postgres_to_lower_version_text_resolution' => '请在目的服务器上安装所需的 PostgreSQL 版本。',
    'backup__restore__capability_db_server_connection_problems' => '无法连接到目标 PostgreSQL 数据库服务器。 数据库将不被迁移除非您恢复连接。',
    'backup__restore__capability_db_server_connection_problems_resolution' => '请查看目的数据库服务器上的连接设置。',
    'backup__restore__capability_component_not_enabled_server_wide_text' => '目标服务器上的组件 %1 已被关闭。',
    'backup__restore__capability_component_not_enabled_server_wide_resolution' => '请打开目标服务器上的 %1。',
    'backup__restore__capability_not_configured_component_text' => '目标服务器上的组件 %1 未进行配置。',
    'backup__restore__capability_not_configured_component_resolution' => '请在 工具与设置 页面上配置 %1。',

    'backup__restore__capability_webmail_is_not_available' => '目标服务器上没有 %1 web 邮箱服务。Plesk 将会使用以下 web 邮箱服务：%2。%2.',
    'backup__restore__capability_webmail_is_not_available_resolution' => '若要使用与源服务器上相同的 web 邮箱，应在此服务器上将其安装。',
    'backup__restore__capability_webmail_is_not_installed_resolution' => '要使用与源服务器上相同的 web 邮箱，您应在目的服务器上安装它。',
    'backup__restore__capability_webmail_is_not_available_changed_on_subscriptions' => "目标服务器上没有 \\\\&apos;%1\\\\&apos; web 邮箱。而在以下订阅上：%3, Plesk 将会使用以下 web 邮箱服务：%2.",
    'backup__restore__capability_webmail_is_not_installed_custom_resolution' => '请在目的服务器上安装所需的 web 邮箱。',
    'backup__restore__capability_webmail_is_not_available_url_text' => 'Web 邮箱设置',

    'backup__restore__capability_shell_is_not_available' => '目标服务器上没有 shell %1。 将会使用现有的一个 shells。',
    'backup__restore__capability_shell_is_not_available_resolution' => '要使用与源服务器上相同的 shell，您应该在目标服务器上打开 (in /etc/shells) 或安装该 shell。',

    'backup__restore__capability_acl_network_not_allowed_dns_template' => '目标 DNS 服务器不支持传输限制模板中的网络。 将不会恢复 DNS 迁移限制中的网络 IP 地址的记录。',
    'backup__restore__capability_acl_network_not_allowed_dns_zone' => '目标 DNS 服务器不支持传输限制模板中的网络，但是一些订阅有 DNS 迁移限制中的网络。 将不会恢复 DNS 迁移限制中的网络 IP 地址的记录。',

    'backup__restore__capability_wrong_php_handler_text' => '目标服务器上没有 PHP 处理器 %1。而 Plesk 将会使用以下 PHP 处理程序：%2.',
    'backup__restore__capability_wrong_php_handler_resolution' => '要使用与源服务器上相同的 PHP 处理器，您应该在目标服务器上打开或安装该 PHP 处理器。',
    'bu_conflict_resolver_php_handler_replaced_in_plans' => 'PHP 处理程序 %1 不可用。对于以下服务方案，Plesk 将会使用 %2：{{objects}}',
    'bu_conflict_resolver_php_handler_replaced_in_sites' => 'PHP 处理程序 %1 不可用。对于以下网站，Plesk 将会使用 %2：{{objects}}',
    'bu_conflict_resolver_php_handler_not_allowed_in_sites' => 'PHP handler %1 不可用。对以下网站将不可用：{{objects}}',

    'backup__restore__capability_wrong_component_version_text' => '目标服务器上没有 %1 %2 。 将会使用默认的版本。',
    'backup__restore__capability_wrong_component_version_resolution' => '要使用与源服务器上相同的 %1，您应该在目标服务器上打开或安装该 %1。',

    'backup__restore__capability_antivirus_not_allowed_outgoing_text' => '目标服务器上的杀毒软件使用策略不允许为传出邮件配置个人（每电子邮件地址）杀毒软件设置。这些设置将不被迁移。',
    'backup__restore__capability_antivirus_not_allowed_incoming_text' => '目标服务器上的杀毒软件使用策略不允许为传入邮件配置个人（每电子邮件地址）杀毒软件设置。这些设置将不被迁移。',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_text' => '目标服务器上的杀毒软件使用策略不允许为发送邮件配置个人（每电子邮件地址）杀毒软件设置。这些设置将不被迁移。',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_resolution' => "要迁移个人（每电子邮件地址）杀毒软件设置，请进入 工具与设置 > 病毒防护设置 打开相应的选项。",
    'backup__restore__capability_antivirus_not_active_text' => '没有启用杀毒软件。来自源服务器的所有杀毒软件设置只有在您于目的服务器上选定了该软件才能使用。',
    'backup__restore__capability_antivirus_not_active_resolution' => '请进入 工具与设置 > 病毒防护设置 > 杀毒软件设置 选定该杀毒软件。',

    'backup__restore__capability_antivirus_another_active_text' => '目标服务器上没有杀毒软件 %2 。将会使用 %1。',
    'backup__restore__capability_antivirus_another_active_resolution' => '要使用与源服务器上相同杀毒软件，请安装该软件并进入 工具与设置 > 病毒防护设置 > 杀毒软件设置 选定该软件。',
    'backup__restore__capability_not_available_sni_text' => '目标服务器上没有 SNI。共用相同 IP 地址的网站将无法使用单独的 SSL/TLS 证书。',
    'backup__restore__capability_not_available_sni_resolution' => "请查看目的服务器上的操作系统是否支持 SNI 且是否在 Plesk 中启用了 SNI 支持（进入 工具与设置 > 服务器设置 标签勾选复选框 '启用 SNI 支持，允许共用相同 IP 地址的网站使用单独的 SSL/TLS 证书'）。",
    'backup__restore__capability_not_available_sni_resolution_url_text' => '服务器设置',

    'backup__restore__capability_vhost_already_exists_text' => '无法迁移网站 %1：与目的服务器上存在相同名称的网站',
    'backup__restore__capability_vhost_already_exists_resolution' => '请重命名或从服务器上移除具有相同名称的网站。',
    'backup__restore__capability_removed_vhosts' => '将不会恢复以下订阅因为它们包含在目的服务器上已经存在的域名:%1',
    'backup__restore__capability_duplicate_php_handler_text' => '在源服务器上有 %3 个不同的 %1 类型 %2 版本的 PHP 处理器。而将有一个合适类型和版本的处理器用于目的服务器上。注意源服务器和目的服务器上的 PHP 设置可能会不同。',

    'backup__restore__capability_not_installed_frontpage_resolution' => 'Plesk 安装程序不支持 Microsoft Frontpage。',
    'backup__restore__capability_not_installed_python_resolution' => 'Plesk 安装程序不支持 Python。请手动安装 Python。',

    'backup__restore__capability_mail_spamfilter_domain_keys_resolution_url_text' => '邮件服务器设置',

    'backup__restore__capability_ftps_disabled' => '允许在源服务器上使用安全 FTPS 但是禁止在目标服务器上使用。使用 FTP 的用户应用程序可能运行不正常。',
    'backup__restore__capability_ftps_required' => '允许在源服务器上使用非安全 FTP 但是禁止在目标服务器上使用。使用 FTP 的用户应用程序可能运行不正常。',
    'backup__restore__capability_ftps_policy_resolution' => '更改安全 FTP 策略请进入 工具与设置 > 安全策略。',

    'backup__restore__capability_too_much_download_time_text' => '将会在 %2 小时内从源服务器移动 %1 MB 数据到目的服务器。',
    'backup__restore__capability_too_much_download_time_resolution' => '为了更快传输，请查看源服务器和目的服务器之间的网络连接并解决出现的问题。',
    'backup__restore__too_low_download_speed' => "小于 0.01",
    'backup__restore__capability_too_slow_download_speed_resolution' => '为了更快传输，请查看源服务器和目的服务器之间的网络连接并解决出现的问题。',
    'backup__restore__capability_zero_download_speed_text' => '可接受的最慢下载速度是 %1 MBps。源服务器和目的服务器之间的下载速度是 0 MBps。这可能是网络连接问题引起的。无法传输。',
    'backup__restore__capability_zero_download_speed_resolution' => '请查看源服务器和目的服务器之间的网络连接并解决问题。',
    'backup__restore__capability_too_slow_download_speed_text' => '可接受的最慢下载速度是 %2 MBps。源服务器和目的服务器之间的下载速度是 %1 MBps。这可能会增加传输的时间。在您当前的环境中，迁移 %3 MB 将需要 %4 小时。',
    'backup__restore__capability_too_slow_download_speed_text_without_diskusage' => '可接受的最慢下载速度是 %2 MBps。源服务器和目的服务器之间的下载速度是 %1 MBps。这可能会增加传输的时间。',

    'backup__restore__capability_remote_database_migration' => "以下的域名正使用远程数据库：%1",
    'backup__restore__capability_remote_database_migration_resolution' => "如果源服务器上的 Plesk  版本早于 11.5，迁移后不要从源服务器上移除这些域名。请挂起它们。如果您移除域名，数据库将会从远程服务器上被移除。注意：远程数据库的转储文件将会存储于源服务器上的 %1 目录中。",

    'backup__restore__capability_mysql_50_to_51_migration' => '早于 5.1 (%1) 的 MySQL 数据库服务器的备份文件可能不会在 MySQL 5.1.x 上恢复，因为 MySQL 5.1.x 处理 Unicode 字符的方式不同。',
    'backup__restore__capability_mysql_50_to_51_migration_resolution' => '',
    'backup__restore__capability_mysql_50_to_51_migration_kb_link_title' => '请参阅相关的知识库文章 #136850',

    'backup__restore__capability_firewall_not_installed_text' => '目标服务器上的未安装防火墙扩展。如果您建立了访问限制规则，该规则将无法实现。',
    'backup__restore__capability_firewall_not_installed_resolution' => '请使用 Plesk 安装程序安装防火墙扩展。',
    'backup__restore__capability_courier_not_installed_text' => '未在目的服务器上安装 Courier-IMAP。',
    'backup__restore__capability_courier_not_installed_resolution' => '请使用 Plesk 安装程序安装 Courier-IMAP。',
    'backup__restore__capability_dovecot_not_installed_text' => '未在目的服务器上安装 Dovecot。',
    'backup__restore__capability_dovecot_not_installed_resolution' => '请使用 Plesk 安装程序安装 Dovecot。',

    'backup__restore__wrong_stat_ttl_value_text' => '以下对象配置中的流量统计保留时间小于目的服务器上的服务器级的值。',
    'backup__restore__wrong_stat_ttl_value_resolution' => '请在目的服务器上更改服务器级的统计保留时间。设置该时间等于或小于域名配置中的最小值。',
    'bu_conflict_resolver_wrong_stat_ttl_value' => '一些域名的流量统计保留时间的值小于服务器级的值 (%1)。这些域名的此值将会更改为 %1。',
    'bu_conflict_resolver_wrong_stat_ttl_template_value' => '一些服务方案的流量统计保留时间的值小于服务器级的值 (%1)。这些服务方案的此值将会更改为 %1。',

    'backup__ip_mapping__map_dedicated_to_shared_ip' => '映射专用 IP 地址至共享地址将会禁用匿名 FTP 和 HTTPS（除非启用 SNI 支持）。',

    'backup__restore__no_postgresql_commands_text' => '订阅使用了远程 PostgreSQL 数据库，无法生成其临时的备份文件因为源服务器上丢失了 pg_dump 和 psql 命令。',
    'backup__restore__no_postgresql_commands_resolution' => '请安装任何可支持这些命令的 PostgreSQL 客户端程序包。',
    'backup__restore__capability_apache_modules_disabled_text' => '在目的服务器上禁用了以下 Apache 模块：%1.',
    'backup__restore__capability_apache_modules_disabled_resolution' => '请启用这些模块以阻止可能的问题出现。',
    'backup__restore__capability_apache_modules_not_installed_text' => '在目的服务器上未安装以下 Apache 模块：%1.',
    'backup__restore__capability_apache_modules_not_installed_resolution' => '请安装和启用这些模块以阻止可能的问题出现。',

    'backup__restore__capability_license_not_supported_outgoing_antispam' => '您的许可证不支持传出信息限制。将不迁移相应的配置设置。',
    'backup__restore__capability_license_not_supported_outgoing_antispam_resolution' => '请在目标服务器上安装可提供所需功能的其他许可证密钥。',
    'backup__restore__capability_disabled_outgoing_antispam' => '目的服务器上的传出信息限制已被关闭。将不迁移相应的配置设置。',
    'backup__restore__capability_disabled_outgoing_antispam_resolution' => '请打开目标服务器上的传出信息限制。',
    'backup__restore__capability_disabled_outgoing_antispam_resolution_url_text' => '服务器级的邮件设置',

    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported' => '目的服务器上使用的邮件服务器不支持限制从邮箱传出信息。将不迁移该限制的值。',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution' => '请修改邮件服务器与您在源服务器上使用的一致。',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution_url_text' => '服务器级的邮件设置',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported' => '目的服务器上使用的邮件服务器不支持限制从域名传出信息。将不迁移该限制的值。',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution' => '请修改邮件服务器与您在源服务器上使用的一致。',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution_url_text' => '服务器级的邮件设置',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported' => '目的服务器上使用的邮件服务器不支持限制从订阅传出信息。将不迁移该限制的值。',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution' => '请修改邮件服务器与您在源服务器上使用的一致。',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution_url_text' => '服务器级的邮件设置',

    'bu_conflict_resolver_absent_phosting' => '无法恢复指定的文件因为用于存储它们的物理主机不存在。请首先使用物理主机创建一个域名然后再开始恢复备份。',
    'bu_conflict_resolver_resellers_management_is_not_supported' => '由于不支持代理商管理，因此将不恢复代理商数据。',

    'backup__restore__capability_modsecurity_not_installed_text' => '目标服务器上未安装 ModSecurity 组件。',
    'backup__restore__capability_modsecurity_not_installed_resolution' => '如果您希望 web 应用程序防火墙对传输的网站保持有效请安装 ModSecurity。注意安装可能需要几分钟。',
    'backup__restore__capability_modsecurity_not_installed_resolution_for_server' => '如果您想要传输 web 应用程序防火墙的设置请安装 ModSecurity。注意安装可能需要几分钟。',
    'backup__restore__capability_modsecurity_not_configured_text' => '目标服务器上的 ModSecurity 未进行配置。',
    'backup__restore__capability_modsecurity_not_configured_resolution' => '如果您希望 web 应用程序防火墙对传输的网站保持有效请配置 ModSecurity。',
    'backup__restore__capability_modsecurity_not_configured_resolution_url_text' => 'Web 应用程序防火墙 (ModSecurity)',
    'backup__restore__capability_modsecurity_not_active_text' => '目标服务器上的 ModSecurity 已被关闭。',
    'backup__restore__capability_modsecurity_not_active_resolution' => '如果您希望 web 应用程序防火墙对传输的网站保持有效请激活 ModSecurity。',
    'backup__restore__capability_modsecurity_not_active_resolution_url_text' => 'Web 应用程序防火墙 (ModSecurity)',
    'bu_conflict_resolver_modsecurity_not_installed' => '未安装 ModSecurity 组件。将不会恢复以下对象的 web 防火墙设置：{{objects}}',
    'bu_conflict_resolver_absent_websites_subscription' => "无法恢复网站因为它们隶属在 Plesk 中无法找到的订阅  %1：",
    'backup__restore__capability_not_installed_dns_text' => '目标服务器上的未安装组件 %1。DNS 服务将不可用而 DNS 设置将会丢失。所有客户的网站都会停止运行。',
    'bu_conflict_resolver_dns_not_installed' => '未安装 DNS 服务。将不会恢复以下对象的 DNS 设置：{{objects}}',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_owners' => '无法恢复以下订阅，因为它们已被移动给其它所有者：\\&apos;%1\\&apos;',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_vendors' => '无法恢复以下订阅，因为它们已被移动给其它提供商：\\&apos;%1\\&apos;',
    'bu_conflict_resolver_sitebuilder_restore_util_is_not_installed' => '无法找到 Web Presence Builder 恢复工具来恢复 Web Presence Builder 数据。Web Presence Builder 可能还未安装。',
    'backup__restore__capability_renamed_db' => '数据库名称 "%1" 已被其它订阅使用。被恢复的数据库的名称将被更改为 "%2"。',
    'backup__restore__capability_renamed_db_user' => '数据库用户名称 "%1" 已被其它订阅使用。被恢复的数据库用户的名称将被更改为 "%2"。',
    'backup__restore__capability_not_installed_perl_resolution' => 'Plesk 安装程序不支持 Perl。请手动安装 ActiveState Perl。',
    'backup__restore__capability_php_handler' => '%%version%% %%type%% (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_apache' => 'Apache (id=%%id%%) 支持的 %%version%% %%type%%',
    'backup__restore__capability_php_handler_served_by_nginx' => 'nginx (id=%%id%%) 支持的 %%version%% %%type%%',


    '__sni' => 'SNI',
    '__kav' => 'Kaspersky Antivirus',
    '__drweb' => 'Odin Premium Antivirus',

    // Timing conflicts
    'backup__restore__timing_conflicts' => '计时冲突',
    'backup__restore__hint_timing_conflicts' => '计时冲突出现情况: 当恢复对象已在系统中，且新近修改日期更接近，或恢复对象当前没有出现在系统中。',
    'backup__restore__text_timing_resolution_policy_overwrite' => '使用备份配置及数据',
    'backup__restore__hint_timing_resolution_policy_overwrite' => '使用备份文件配置和数据完全覆盖系统中当前出现的对象配置和数据。如果当前恢复的对象属于不同的所有者，则该对象会在前所有者下恢复。',
    'backup__restore__text_timing_resolution_policy_proceed' =>  '使用当前系统配置及来自备份的数据',
    'backup__restore__hint_timing_resolution_policy_proceed' => '使用备份文件数据覆盖当前对象数据，但保留系统中的当前出现的对象配置。如果当前恢复的对象属于不同的所有者，则该对象会在当前所有者下恢复。',
    'backup__restore__text_timing_resolution_policy_do_not_restore' => '请不要恢复',
    'backup__restore__hint_timing_resolution_policy_do_not_restore' => '请不要恢复有计时冲突的对象。',
    // Resource usage conflicts
    'backup__restore__resource_useage_conflicts' => '资源使用冲突',
    'backup__restore__hint_resource_usage_conflicts' => '恢复后，恢复对象所用资源超出限制，则会出现资源使用冲突。',
    'backup__restore__text_resource_usage_resolution_policy_overusage' => '允许超额使用',
    'backup__restore__hint_resource_usage_resolution_policy_overusage' => '恢复对象，并允许它使用多于初始分配的资源量。',
    'backup__restore__text_resource_usage_resolution_policy_do_not_restore' => '请不要恢复',
    'backup__restore__hint_resource_usage_resolution_policy_do_not_restore' => '请不要恢复有资源使用冲突的对象。',
    // Configuration conflicts
    'backup__restore__configuration_conflicts' => '配置冲突',
    'backup__restore__hint_configuration_conflicts' => '配置冲突出现情况: 恢复的对象设置与web应用程序不可用或被当前服务器或对象所有者策略禁止。例如，如果邮件帐户有独立的垃圾邮件过滤设置，但当前服务器级策略不允许邮件帐户有这些设置，则会出现配置冲突。',
    'backup__restore__text_configuration_resolution_policy_automatic' => '自动',
    'backup__restore__hint_configuration_resolution_policy_automatic' => '恢复对象，并自动启用您可以管理的所有冲突配置选项。',
    'backup__restore__text_configuration_resolution_policy_do_not_restore' => '请不要恢复',
    'backup__restore__hint_configuration_resolution_policy_do_not_restore' => '请不要恢复有配置冲突的对象。',

    'backup__restore__dedicated_app_pool_restore_to_shared_text' => 'IIS 应用程序池设置中不允许独立 IIS 应用程序池。',
    'backup__restore__dedicated_app_pool_restore_to_shared_resolution' => '请进入 工具与设置 > IIS 应用程序池 > 全局设置 更改您的 IIS 应用程序池设置。',
    'backup__restore__shared_app_pool_restore_to_dedicated_text' => 'IIS 应用程序池设置中不允许共享 IIS 应用程序池。',
    'backup__restore__shared_app_pool_restore_to_dedicated_resolution' => '请进入 工具与设置 > IIS 应用程序池 > 全局设置 更改您的 IIS 应用程序池设置。',

    'backup__restore__unable_allow_short_pop3 _names_text' => '目的服务器上不允许使用简短的 POP3/IMAP 邮件帐户名称。',
    'backup__restore__unable_allow_short_pop3 _names_resolution' => '恢复数据后邮件帐户无法使用简短名称',

    // Restore status messages & errors:
    'backup__unable_to_open_log_file' => '无法打开日志文件。',
    'backup__restore__customer_cannot_restore_nonexistent_subscription' => '无法恢复订阅 %1： 它已从您的帐户上移除，您没有权限创建订阅。如果您需要恢复，请联系您的服务提供商。',

    'backup__error11' => '用于备份的磁盘空间不够。',
    'backup__error3011' => '连接被拒绝：没有程序正在监听指定的地址和端口。',
    'backup__error3012' => '连接超时。',
    'backup__error3013' => '网络不可到达。',
    'backup__error3014' => '未路由到主机。',
    'backup__error3015' => '连接失败。',
    'backup__error3016' => '无法解析主机名。',
    'backup__error3017' => '用户名或密码不正确。',
    'backup__error3018' => 'SSH 连接失败。',

    'backup__error3110' => '无法连接远程迁移代理：无法连接到主机。',
    'backup__error3111' => '迁移代理已被一项失败的迁移任务锁定或正被其它迁移流程使用。请在源服务器上重新启动迁移代理。',
    'backup__error3112' => '无法连接到主机或源主机上未运行迁移代理。',
    'backup__error3113' => '无法在 Linux 主机上部署迁移代理。请检查到源主机的 SSH 连接。',
    'backup__error3114' => '无法在 Linux 主机上部署迁移代理。SSH 连接失败。',
    'backup__error3115' => '用户名或密码不正确。',
    'backup__error3116' => '指定的用户没有管理权限。',

    'backup__scheduled_backup_settings__backup_of_domain_all_at_domain' => '所有配置及内容',
    'backup__scheduled_backup_settings__backup_of_domain_vhost_only' => '所有配置及内容(邮件除外)',
    'backup__scheduled_backup_settings__backup_of_domain_mail_only' => '仅限邮件配置及内容',

    'dns_t__unable_to_remove_ns_record' => '无法从 DNS 模板中移除 NS 记录： 每个 DNS 区域必须至少有一个 NS 记录。',
    'dns__unsupported_server_zone_transfer' => '因为服务器级别的 DNS 配置导致无法传输 传输限制模板： 在源服务器上，允许以下网络地址进行区域迁移，但是 Microsoft DNS Server 禁止这些地址进行此操作： %1',
    'dns__unsupported_domain_zone_transfer' => '因为域名的 DNS 配置导致无法传输 传输限制模板： 在一些域名上，允许以下网络地址进行区域迁移，但是 Microsoft DNS Server 禁止这些地址进行此操作： %1',
    ///
    /// END OF COMMON SCREENS
    ///

    ///
    /// DATABASE BACKUP - PFW // TBD
    ///

    // Actions

    'backup__db_mapping__title' => '定义数据库服务器映射',
    'dbbackup__check_network_settings_failed' => '无法访问备份文件的共享临时网络目录。请检查网络目录、用户名和密码设置。错误：%1',

    'migration_select_exist_db_server' => '选择目的数据库服务器',

    'dbbackup__temp_dir_wrong_value' => '指定的临时目录的值无效。',
    'dbbackup__network_temp_dir_wrong_value' => '指定的临时网络目录的值无效。',
    'dbbackup__server_backup_not_configured' => '在服务器上未配置数据库备份设置。',
    'dbbackup__temp_dir' => '临时目录',
    'dbbackup__temp_dir_hint' => '进入 MS SQL 服务器所在的远程服务器上的物理文件夹的路径。该 MS SQL 服务器必须能够访问该文件夹以读取和写入临时备份文件。例如，C:\\DirectoryPath',
    'dbbackup__network_temp_dir_hint' => '网络共享的路径被映射到以上指定的物理文件夹。Plesk 将会访问共享文件夹以下载和上传备份文件。例如，\\\\ServerName\\DirectoryPath',
    'dbbackup__network_user_hint' => '在远程服务器上创建的网络用户的用户名。例如，ServerName\\UserName。该用户必须有访问以上指定的共享文件夹的权限。',
    'dbbackup__network_password_hint' => '网络用户的密码',

    'dbbackup__success_import_without_dublicate_users' => '以下用户未被导入：%1。它们已存在于数据库服务器上。',

    ///
    /// END OF DATABASE BACKUP
    ///

    ///
    /// LOGS & LOG ROTATION
    ///

    'log_rot__compress' => "压缩日志文件",
    'log_rot__log_rot_status' => "日志循环状态",
    'log_rot__log_rot_period' => "日志循环条件",
    'log_rot__log_rot_size' => "按大小",
    'log_rot__log_rot_time' => "按时间",
    'log_rot__logrotation_enable' => "启用日志循环",
    'log_rot__mail' => "将已处理的日志文件发送到电子邮件",
    'log_rot__max_number_of_logfiles' => "日志文件的最大数量",
    'log_rot__time_period' => "周期",
    'log_rot__unable_turn_off' => '無法關閉日誌輪轉，因為它是在伺服器級別上強制執行的',
    'log_rot__unable_set_period' => '無法將日誌輪轉週期的形式設定為不同於\'daily\'，因為它是在伺服器級別上強制執行的',
    'log_rot__unable_set_max_log_files' => '無法將日誌檔的最大值設定得比伺服器範圍內的限制%1大',

    /// action log
    // common/various
    'actionlog__digit_expected' => "期望值：%1",
    'actionlog__incorrect_rotation' => "指定了无效的日志循环参数：%1。",
    'actionlog__unknown_rot_period' => "未知的循环周期：%1。",
    'actionlog__unknown_rot_type' => "未知的循环类型：%1。",
    'actionlog__session_preferences' => '会话设置',
    // items (PFU schema)
    'actionlog__admin_info' => '管理员信息',
    'actionlog__admin_preferences' => "管理员的偏好设置",
    'actionlog__service' => '服务',
    'actionlog__ip_addr' => 'IP 地址',
    'actionlog__client' => '客户帐户',
    'actionlog__client_status' => '客户帐户状态',
    'actionlog__client_preferences' => "客户界面偏好设置",
    'actionlog__client_ip_pool' => "客户IP池",
    'actionlog__client_siteapp' => "客户的域名应用程序池",
    'actionlog__client_guid' => "客户GUID",
    'actionlog__domain' => '默认域名（添加到订阅的第一个域名）',
    'actionlog__domain_owner' => '订阅所有者',
    'actionlog__domain_plan' => '订阅的服务方案',
    'actionlog__domain_status' => '默认域名、状态',
    'actionlog__domain_dns' => '默认域名、DNS 区域',
    'actionlog__subdomain' => '默认域名的子域名',
    'actionlog__domain_alias' => '默认域名、别名',
    'actionlog__domain_alias_dns' => '默认域名、别名 DNS 区域',
    'actionlog__site' => '域名',
    'actionlog__site_status' => '域名状态',
    'actionlog__site_dns' => '域名 DNS 区域',
    'actionlog__site_guid' => '域名 GUID',
    'actionlog__site_subdomain' => '子域名',
    'actionlog__site_alias' => '域名别名',
    'actionlog__site_alias_dns' => '域名别名 DNS 区域',
    'actionlog__domain_limits' => '订阅上限',
    'actionlog__domain_limit_size' => '订阅的磁盘空间上限',
    'actionlog__domain_limit_traffic' => '订阅的流量上限',
    'actionlog__domain_limits_powerUser' => '订阅上限',
    'actionlog__domain_limit_size_powerUser' => '订阅的磁盘空间上限',
    'actionlog__domain_limit_traffic_powerUser' => '订阅的流量上限',
    'actionlog__domain_guid' => "默认域名、GUID",
    'actionlog__cp_user' => 'Plesk 用户',
    'actionlog__mailname' => '邮件帐户',
    'actionlog__maillist' => '邮件列表',
    'actionlog__phosting' => '主机设置',
    'actionlog__forwarding' => '标准或帧转发主机',
    'actionlog__webuser' => '网站用户帐户',
    'actionlog__site_application' => 'web应用程序',
    'actionlog__license' => '许可证密钥',
    'actionlog__additional_license' => '额外的许可证密钥',
    'actionlog__template_domain' => "代理商服务方案",
    'actionlog__template_admin' => "管理员域名方案",
    'actionlog__template_reseller' => '代理商方案',
    'actionlog__admin_alias' => '其他管理员帐户', // PFW
    'actionlog__ftpuser' => '其它的 FTP 帐户', // PFW
    'actionlog__db_server' => '数据库服务器',
    'actionlog__db' => '数据库',
    'actionlog__db_user' => '数据库用户帐户',
    'actionlog__client_sapppkg_pool' => "用户web应用程序", // PFW, not used?
    'actionlog__remote_dns' => '远程DNS服务器状态', // PFW
    'actionlog__reseller' => '代理商帐户',
    'actionlog__reseller_guid' => '代理商的GUID',
    'actionlog__reseller_ip_pool' => "代理商的IP池",
    'actionlog__reseller_limit_size' => '代理商帐户磁盘空间限制',
    'actionlog__reseller_limit_traffic' => '代理商帐户流量限制',
    'actionlog__reseller_limits' => '代理商帐户限制',
    'actionlog__reseller_permissions' => '代理商权限',
    'actionlog__reseller_preferences' => "代理商的界面偏好设置",
    'actionlog__reseller_siteapp' => "代理商池中的Web应用程序",
    'actionlog__reseller_status' => '代理商帐户状态',
    'actionlog__health_status' => '服务器健康状态',
    // actions (PFU schema)
    'actionlog__limit_reached' => '达到',
    'actionlog__added' => '添加',
    'actionlog__removed' => '删除',
    'actionlog__change' => '更改',
    'actionlog__update' => '更新',
    'actionlog__move' => '已移动',
    'actionlog__upgrade' => '已升级', // PFU?
    'actionlog__update_or_add' => '更新或添加',
    'actionlog__expired' => '过期',
    'actionlog__create' => '创建',
    'actionlog__delete' => '删除',
    'actionlog__service_stop' => '停止',
    'actionlog__service_restart' => '重启',
    'actionlog__service_start' => '启动',
    'actionlog__login' => '登录',
    'actionlog__logout' => '注销',
    'actionlog__install' => '安装',
    'actionlog__uninstall' => '卸载',
    'actionlog__reconfigure' => '重新配置',
    // events (PFW schema)
    'actionlog__event_pw_reset' => '密码重设请求',
    'actionlog__event_admin_update' => '管理员信息更新',
    'actionlog__event_admin_preferences_update' => "已更新管理员的偏好设置",
    'actionlog__event_service_restart' => '服务已重启',
    'actionlog__event_service_start' => '服务已启动',
    'actionlog__event_service_stop' => '服务已停止',
    'actionlog__event_ip_address_create' => '已创建IP地址',
    'actionlog__event_ip_address_delete' => 'IP地址已删除',
    'actionlog__event_ip_address_update' => 'IP地址已更新',
    'actionlog__event_client_create' => '已创建客户帐户',
    'actionlog__event_client_delete' => '客户帐户已删除',
    'actionlog__event_client_update' => '客户帐户已更新',
    'actionlog__event_client_status_update' => '客户帐户状态已更新',
    'actionlog__event_client_preferences_update' => "客户界面偏好设置已更新",
    'actionlog__event_client_siteapp_added' => "客户应用程序包已添加到客户帐户应用程序池",
    'actionlog__event_client_siteapp_removed' => "已从客户帐户应用程序池中删除Web应用程序",
    'actionlog__event_domain_limit_size_reached' => '已达到订阅的磁盘空间上限',
    'actionlog__event_domain_limit_traffic_reached' => '已达到订阅的流量上限',
    'actionlog__event_domain_limit_size_reached_powerUser' => '已达到订阅的磁盘空间上限',
    'actionlog__event_domain_limit_traffic_reached_powerUser' => '已达到订阅的流量上限',

    'actionlog__domain_limit_database' => '订阅的数据库配额',
    'actionlog__event_domain_limit_mysql_quota_reached' => '已达到订阅的 MySQL 数据库配额',
    'actionlog__event_domain_limit_mysql_soft_quota_reached' => '已达到订阅的 MySQL 数据库软配额',
    'actionlog__event_domain_limit_mssql_quota_reached' => '已达到订阅的 Microsoft SQL 服务器数据库配额',
    'actionlog__event_domain_limit_mssql_soft_quota_reached' => '已达到订阅的 Microsoft SQL 服务器数据库软配额',
    'actionlog__event_plesk_component_upgrade' => 'Plesk 组件已更新',
    'actionlog__event_plesk_component_install' => 'Plesk 组件已安装',
    'actionlog__event_plesk_component_uninstall' => 'Plesk 组件已卸载',
    'actionlog__event_domain_create' => '已创建默认域名（添加到订阅的第一个域名）',
    'actionlog__event_domain_delete' => '已删除默认域名（添加到订阅的第一个域名）',
    'actionlog__event_domain_update' => '已更新默认域名（添加到订阅的第一个域名）',
    'actionlog__event_domain_owner_change' => '订阅所有者已更改',
    'actionlog__event_domain_plan_change' => '已更改订阅的服务方案',
    'actionlog__event_domain_status_update' => '已更新的默认域名、状态',
    'actionlog__event_domain_dns_update' => '已更新的默认域名、DNS 区域',
    'actionlog__event_subdomain_create' => '已创建默认域名的子域名',
    'actionlog__event_subdomain_delete' => '默认域名的子域名已删除',
    'actionlog__event_subdomain_update' => '默认域的子域已更新',
    'actionlog__event_domain_alias_create' => '已创建默认域名、别名',
    'actionlog__event_domain_alias_delete' => '默认域名、别名已删除',
    'actionlog__event_domain_alias_update' => '默认域名、别名已更新',
    'actionlog__event_domain_limits_update' => '已更新的订阅上限',
    'actionlog__event_cp_user_login' => 'Plesk 用户登录',
    'actionlog__event_cp_user_logout' => 'Plesk 用户注销',
    'actionlog__event_mailname_create' => '已创建邮件帐户',
    'actionlog__event_mailname_delete' => '邮件帐户已删除',
    'actionlog__event_mailname_update' => '邮件帐户已更新',
    'actionlog__event_maillist_create' => '已创建邮件列表',
    'actionlog__event_maillist_delete' => '邮件列表已删除',
    'actionlog__event_maillist_update' => '邮件列表已更新',
    'actionlog__event_phys_hosting_create' => '已创建物理主机',
    'actionlog__event_phys_hosting_delete' => '物理主机已删除',
    'actionlog__event_phys_hosting_update' => '物理主机已更新',
    'actionlog__event_forwarding_create' => '已创建标准或帧转发主机',
    'actionlog__event_forwarding_delete' => '标准或帧转发主机已删除',
    'actionlog__event_forwarding_update' => '标准或帧转发主机已更新',
    'actionlog__event_webuser_create' => '已创建网站用户帐户',
    'actionlog__event_webuser_delete' => '网站用户帐户已删除',
    'actionlog__event_webuser_update' => '网站用户帐户已更新',
    'actionlog__event_siteapp_install' => 'Web应用程序已安装',
    'actionlog__event_siteapp_reconfigure' => 'Web应用程序已重新配置',
    'actionlog__event_siteapp_uninstall' => 'Web应用程序已卸载',
    'actionlog__event_license_update' => '许可证已更新',
    'actionlog__event_admin_alias_create' => '其他所创建的管理员帐户',
    'actionlog__event_admin_alias_delete' => '其他所删除的管理员帐户',
    'actionlog__event_admin_alias_update' => '其他所更新的管理员帐户',
    'actionlog__event_ftpuser_create' => '已创建其他FTP帐户',
    'actionlog__event_ftpuser_update' => '已更新FTP帐户',
    'actionlog__event_ftpuser_delete' => '已删除其他FTP帐户',
    'actionlog__event_template_domain_create' => "已创建代理商服务方案",
    'actionlog__event_template_domain_update' => "代理商服务方案已更新",
    'actionlog__event_template_domain_delete' => "代理商服务方案已删除",
    'actionlog__event_template_admin_create' => "已创建管理员域名方案",
    'actionlog__event_template_admin_update' => "管理员服务方案已更新",
    'actionlog__event_template_admin_delete' => "管理员服务方案已删除",
    'actionlog__event_database_server_create' => '已创建数据库服务器',
    'actionlog__event_database_server_update' => '数据库服务器已更新',
    'actionlog__event_database_server_delete' => '数据库服务器已删除',
    'actionlog__event_remote_dns_status_update' => '远程DNS服务器状态已更新',
    'actionlog__event_session_preferences_update' => '会话设置已更新',
    'actionlog__event_domain_alias_dns_update' => '默认域名、域名别名的 DNS 区域已更新',
    'actionlog__event_domain_move' => '默认的域名已移动到新的订阅',
    'actionlog__event_site_move' => '域名已移动到新的订阅',
    'actionlog__event_site_subdomain_move' => '已移动到新订阅的子域名',
    'actionlog__event_subdomain_move' => '默认域名的子域名已移动到新的订阅',
    'actionlog__event_license_expired' => 'Plesk 许可证已过期',
    'actionlog__event_database_create' => '创建的数据库',
    'actionlog__event_database_delete' => '删除的数据库',
    'actionlog__event_database_user_create' => '创建的数据库用户帐户',
    'actionlog__event_database_user_update' => '更新的数据库用户帐户设置',
    'actionlog__event_database_user_delete' => '删除的数据库用户帐户',
    'actionlog__event_client_guid_update' => "客户GUID已更新",
    'actionlog__event_domain_guid_update' => '默认域名、GUID 已更新',
    'actionlog__event_reseller_create' => '已创建代理商帐户',
    'actionlog__event_reseller_delete' => '代理商帐户已删除',
    'actionlog__event_reseller_update' => '代理商帐户已更新',
    'actionlog__event_reseller_guid_update' => '代理商的GUID已更新',
    'actionlog__event_reseller_ip_pool_update' => "代理商帐户的IP池已更新",
    'actionlog__event_reseller_limit_size_reached' => '已达到代理商帐户磁盘空间限制',
    'actionlog__event_reseller_limit_traffic_reached' => '已达到代理商帐户流量限制',
    'actionlog__event_reseller_limits_update' => '代理商帐户限制已更新',
    'actionlog__event_reseller_permissions_update' => '代理商帐户权限已更新',
    'actionlog__event_reseller_preferences_update' => "代理商界面偏好设置已更新",
    'actionlog__event_reseller_siteapp_added' => "添加到代理商帐户应用程序池中的应用程序",
    'actionlog__event_reseller_siteapp_removed' => "从代理商帐户应用程序池中删除的应用程序",
    'actionlog__event_reseller_status_update' => '代理商帐户状态已更新',
    'actionlog__event_template_reseller_create' => '已创建代理商方案',
    'actionlog__event_template_reseller_delete' => '代理商方案已删除',
    'actionlog__event_template_reseller_update' => '代理商方案已更新',
    'actionlog__event_health_status_change' => '已更改服务器健康状态',
    'actionlog__event_siteapp_upgrade' => 'Web app 已升级',
    'actionlog__event_extension_install' => '扩展已安装',
    'actionlog__event_extension_uninstall' => '扩展已卸载',
    'actionlog__event_extension_upgrade' => '扩展已升级',
    'actionlog__event_extension_status_update' => '扩展状态已更新',
    'actionlog__event_additional_license_expired' => '额外的许可证已到期',
    'actionlog__event_hostname_changed' => '服务器主机名已更改',
    'actionlog__event_smb_user_create' => '已创建其他用户',
    'actionlog__event_smb_user_delete' => '已删除其他用户',
    'actionlog__event_smb_user_update' => '已更新其他用户',

    // REMOTE SESSION
    'rsession_no_api_rpc_errmsg' => "远程主机上尚未安装 Plesk API RPC。请向您的系统管理员寻求协助。",
    'rsession_no_account_errmsg' => "无法访问您帐户下的远程服务。最常见的原因可能是您帐户下的服务尚未启用。请稍候几分钟时间，然后重新尝试。如果再次遇到此问题，请联系您的系统管理员。",
    'rsession_no_domain_errmsg' => "无法访问此域名的远程服务。最常见的原因可能是此域名的服务尚未启用。请稍候几分钟时间，然后重新尝试。如果再次遇到此问题，请联系您的系统管理员。",
    'rsession_unknown_errmsg' => "远程服务器拒绝建立会话。请联系您的系统管理员以获得支持。错误为：%1",
    'rsession_unknown2_errmsg' => "建立远程会话时出现未知错误。最常见的原因可能是远程服务器未正确响应，或根本未响应。请联系系统管理员，查看web服务器错误日志中详细的错误信息。",
    'rsession_no_connect_errmsg' => "无法访问远程服务：连接远程会话失败。请联系您的系统管理员以获得支持。",

    // ANONYMOUS FTP
    'anonftp__allow_upload_incoming' => "允许上传至接收目录",
    'anonftp__allow_create_dirs' => '允许在接收目录中创建目录',
    'anonftp__allow_download_incoming' => '允许从接收目录中下载',
    'anonftp__display_login' => '显示登录信息',
    'anonftp__login_text' => '信息文本',
    'anonftp__limit_incoming_disk_space' => "限制接收目录的磁盘空间",
    'anonftp__limit_maximum_bandwidth' => "限制此虚拟 FTP 域名的下载带宽",
    'anonftp__limit_maximum_connections' => "限制最大并发连接数",
    'anonftp__unable_init' => "无法初始化匿名 FTP 帐户：%1。",
    'anonftp__unable_set_quota' => "无法设置接收目录的磁盘使用限制：%1。",
    'anonftp__unable_update' => "无法更新匿名 FTP 帐户属性：%1。",

    ///
    /// SSL/TLS CERTIFICATES
    ///

    // common keys
    '__certificates' => 'SSL/TLS 证书', // page title
    // errors
    'class_sslcertificate__ca_not_signs' => "CA 证书没有签署此证书。",
    'class_sslcertificate__incompatible_pvt_key_cert' => "私钥/证书对不兼容。",
    'class_sslcertificate__invalid_cert_format' => "无效的证书格式。",
    'class_sslcertificate__invalid_private_key_format' => "无效的私钥格式。",
    'class_sslcertificate__prob_invalid_priv_key' => "私钥格式可能无效。",

    ///
    ///END OF SSL/TLS CERTIFICATES
    ///

    ///
    /// WEB DIRECTORIES (PFW)
    ///

    //
    // DOMAIN
    //

    // Web Directories tab
    // Web Directories - ui__client/domain/hosting/web-directories__title (HOME/DOMAIN)
    'ui__client/domain/hosting/web-directories/create-virtual-dir__short-title' => '创建虚拟目录',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__title' => '创建虚拟目录',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__description' => '创建虚拟目录。',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__short-title' => '创建虚拟目录',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__title' => '创建虚拟目录',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__description' => '创建虚拟目录。',
    'ui__client/domain/hosting/web-directories/create-dir__short-title' => '创建目录',
    'ui__client/domain/hosting/web-directories/create-dir__title' => '创建目录',
    'ui__client/domain/hosting/web-directories/create-dir__description' => '创建一个目录。',
    'ui__client/domain/hosting/web-directories/create-dir_self__short-title' => '创建目录',
    'ui__client/domain/hosting/web-directories/create-dir_self__title' => '创建目录',
    'ui__client/domain/hosting/web-directories/create-dir_self__description' => '创建一个目录。',
    'ui__client/domain/hosting/web-directories/properties__short-title' => '目录属性',
    'ui__client/domain/hosting/web-directories/properties__title' => '虚拟目录属性',
    'ui__client/domain/hosting/web-directories/properties__description' => '查看和更改虚拟目录属性。',
    'ui__client/domain/hosting/web-directories/properties_self__short-title' => '目录属性',
    'ui__client/domain/hosting/web-directories/properties_self__title' => '虚拟目录属性',
    'ui__client/domain/hosting/web-directories/properties_self__description' => '查看和更改虚拟目录属性。',
    'ui__client/domain/hosting/web-directories/permissions__short-title' => '目录访问权限',
    'ui__client/domain/hosting/web-directories/permissions__title' => '目录访问权限',
    'ui__client/domain/hosting/web-directories/permissions__description' => '设置目录访问权限。',
    'ui__client/domain/hosting/web-directories/permissions_self__short-title' => '目录访问权限',
    'ui__client/domain/hosting/web-directories/permissions_self__title' => '目录访问权限',
    'ui__client/domain/hosting/web-directories/permissions_self__description' => '设置目录访问权限。',
    'ui__client/domain/hosting/web-directories/aspdotnet__short-title' => 'ASP.NET设置',
    'ui__client/domain/hosting/web-directories/aspdotnet__title' => '%1的ASP.NET设置',
    'ui__client/domain/hosting/web-directories/aspdotnet__description' => '配置虚拟目录%1所用的ASP.NET设置。',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__short-title' => 'ASP.NET设置',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__title' => '%1的ASP.NET设置',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__description' => '配置虚拟目录%1的ASP.NET设置。',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__short-title' => '更改版本',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__title' => '更改版本',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__description' => '更改虚拟目录%1所用的ASP.NET版本。',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version_self__short-title' => '更改版本',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version_self__title' => '更改版本',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version_self__description' => '更改虚拟目录%1的ASP.NET版本。',
    'ui__client/domain/hosting/web-directories/php__short-title' => 'PHP 设置',
    'ui__client/domain/hosting/web-directories/php__title' => '%1 的PHP设置',
    'ui__client/domain/hosting/web-directories/php__description' => '配置虚拟目录%1的PHP设置。',
    'ui__client/domain/hosting/web-directories/php_self__short-title' => 'PHP 设置',
    'ui__client/domain/hosting/web-directories/php_self__title' => '%1的PHP设置',
    'ui__client/domain/hosting/web-directories/php_self__description' => '配置虚拟目录%1的PHP设置。',

    // list object operations
    'ui__client/domain/hosting/web-directories/delete__short-title' => '移除',
    'ui__client/domain/hosting/web-directories/delete__title' => '移除虚拟目录',
    'ui__client/domain/hosting/web-directories/delete__description' => '移除所选虚拟目录。',
    'ui__client/domain/hosting/web-directories/delete_self__short-title' => '移除',
    'ui__client/domain/hosting/web-directories/delete_self__title' => '移除虚拟目录',
    'ui__client/domain/hosting/web-directories/delete_self__description' => '移除所选虚拟目录。',
    'ui__client/domain/hosting/web-directories/delete#legend__description' => '即将移除下列虚拟目录:',
    'ui__client/domain/hosting/web-directories/delete__empty_selection' => '请选择要移除的目录。',

    // MIME Types tab
    'ui__client/domain/hosting/web-directories/mime-type_unknown__short-title' => 'MIME类型',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__title' => 'MIME类型',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__description' => '查看注册的MIME类型列表。',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__short-title' => '添加MIME类型',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__title' => '添加 MIME 类型',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__description' => '注册新MIME类型。',

    // Error documents tab
    'ui__client/domain/hosting/web-directories/error-doc_unknown__short-title' => '错误文档',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__title' => '错误文档',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__description' => '查看和更改错误文档。',

    // Protection tab
    'ui__client/domain/hosting/web-directories/protection__short-title' => '保护',
    'ui__client/domain/hosting/web-directories/protection__title' => '目录保护',
    'ui__client/domain/hosting/web-directories/protection__description' => '使用密码限制访问目录。',
    'ui__client/domain/hosting/web-directories/protection_self__short-title' => '保护',
    'ui__client/domain/hosting/web-directories/protection_self__title' => '目录保护',
    'ui__client/domain/hosting/web-directories/protection_self__description' => '使用密码保护限制目录访问。',
    'ui__client/domain/hosting/web-directories/protection/properties__short-title' => '设置',
    'ui__client/domain/hosting/web-directories/protection/properties__description' => '查看目录位置，并指定受保护区标题。',
    'ui__client/domain/hosting/web-directories/protection/user/properties__title' => '用户设置',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__title' => '添加用户',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__short-title' => '添加用户',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__description' => '添加用户帐户以允许访问受保护目录。',
    'ui__client/domain/hosting/web-directories/protection/properties__done' => '已应用新设置。',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__done' => '已添加用户帐户。',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__short-title' => '移除',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__description' => '移除受保护目录的用户。',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__title' => '移除用户帐户',
    'ui__client/domain/hosting/web-directories/protection/user/delete#legend__description' => '确认移除用户帐户。',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__done' => '已移除用户帐户。',

    //
    // SUBDOMAIN
    //

    // Web Directories tab

    // list object operations

    // MIME Types tab

    // Protection tab
    // Error documents tab

    ///
    /// END OF WEB DIRECTORIES
    ///

    ///
    /// SUBDOMAIN PAGE
    ///


    ///
    /// END OF SUBDOMAIN PAGE
    ///

    ///
    /// DONE MESSAGES
    ///

    // UI
    'ui____done' => '成功完成操作。',
    'ui__admin/extras-domain__done' => 'MyPlesk.com页面已打开。',
    'ui__admin/report/layout/delete_multi__done' => '所选报告布局已移除。',
    'ui__admin/report/traffic-history__done' => '成功完成操作。',
    'ui__admin/report__done' => '成功完成操作。',
    'ui__admin-alias/delete_multi__done' => "所选管理员子帐户已删除。",
    'ui__admin-alias/properties__done' => "管理员子帐户属性已更新。",
    'ui__admin-alias/properties_new__done' => "已创建管理员其它帐户。",
    'ui__admin-alias/properties_unknown__done' => "管理员子帐户属性已更新。",
    'ui__admin-alias__done' => "管理员子帐户信息已成功更新。",
    'ui__admin/manage-domain__done' => 'MyPlesk.com页面已打开。',
    'ui__admin/register-domain__done' => 'MyPlesk.com页面已打开。',
    'ui__admin/report/layout/auto/delete_multi__done' => '所选报告发送计划已删除。',
    'ui__admin/report/layout/auto/properties__done' => '报告发送计划已更新。',
    'ui__admin/report/layout/auto/properties_new__done' => '已创建报告发送计划。',
    'ui__admin/report/layout/properties__done' => '报告布局%1已更新。',
    'ui__admin/report/layout/properties_new__done' => '报告布局%1已更新。',
    'ui__client/domain/certificate/properties__done' => '已更新 SSL/TLS 证书属性。',
    'ui__client/domain/certificate/properties_new__done' => '已添加新的 SSL/TLS 证书。若要让其运行，需在网站主机设置里选择该证书（进入 网站与域名 标签> 域名）。',
    'ui__client/domain/certificate__done' => '成功完成操作。',
    'ui__client/domain/certificate_self__done' => '成功完成操作。',
    'ui__client/domain/chowner__done' => '现在订阅%1属于另一个用户。',
    'ui__client/domain/chowner_multi__done' => '订阅所有权已更改。',
    'ui__client/domain/chowner_multi-select__done' => '成功完成操作。',
    'ui__client/domain/chowner_select__done' => '成功完成操作。',
    'ui__client/domain/dbbackup/create__done' => "成功备份数据库。", // PFW
    'ui__client/domain/dbbackup/get__done' => "成功备份数据库。", // PFW
    'ui__client/domain/dbbackup/orphaned__done' => "成功修复孤立用户。", // PFW
    'ui__client/domain/dbbackup/remove__done' => "成功删除备份文件。", // PFW
    'ui__client/domain/dbbackup/restore__done' => "成功恢复数据库内容。", // PFW
    'ui__client/domain/dbbackup/upload__done' => "成功完成操作。", // PFW
    'ui__client/domain/dbbackup__done' => "成功完成操作。", // PFW
    'ui__client/domain/dbbackup_self__done' => "成功完成操作。", // PFW
    'ui__client/domain/dbbackup_unknown__done' => "成功完成操作。", // PFW
    'ui__client/domain/delete__done' => "域名%1已删除。",
    'ui__client/domain/delete_multi__done' => "域名已删除。",
    'ui__client/domain/disable__done' => '域名%1已挂起。',
    'ui__client/domain/disable_multi__done' => '选定的域名已挂起。',
    'ui__client/domain/enable__done' => '网站%1已激活。',
    'ui__client/domain/enable_multi__done' => '所选网站已激活。',
    'ui__client/domain/extras__done' => 'MyPlesk.com页面已打开。',
    'ui__client/domain/extras_self__done' => 'MyPlesk.com页面已打开。',
    'ui__client/domain/hosting/file-manager/copy-move__done' => '所选文件及目录已复制或删除。',
    'ui__client/domain/hosting/file-manager/create-dir__done' => '已创建目录。',
    'ui__client/domain/hosting/file-manager/create-file__done' => '已创建文件。',
    'ui__client/domain/hosting/file-manager/edit__done' => '文件已更新。',
    'ui__client/domain/hosting/file-manager/permissions__done' => '文件或目录访问权限已更新。', // PFU
    'ui__client/domain/hosting/file-manager/rename__done' => '目录或文件已重命名。',
    'ui__client/domain/hosting/file-manager/remove__done' => '已移除选定的文件和目录。',
    'ui__client/domain/hosting/file-manager/remove_self__done' => '已移除选定的文件和目录。',
    'ui__client/domain/hosting/file-manager/view__done' => '成功完成操作。',
    'ui__client/domain/hosting/file-manager__done' => '成功完成操作。',
    'ui__client/domain/hosting/file-manager_self__done' => '成功完成操作。',
    'ui__client/domain/hosting/hotlink-protection__done' => '成功完成操作。', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__done' => '成功完成操作。', // PFW
    'ui__client/domain/hosting/logs/rotation__done' => '日志循环设置已更改。',
    'ui__client/domain/hosting/logs/rotation_self__done' => '日志循环设置已更改。',
    'ui__client/domain/hosting/logs__done' => '成功完成操作。',
    'ui__client/domain/hosting/logs_self__done' => '成功完成操作。',
    'ui__client/domain/hosting/performance__done' => '已调整网站%1的主机性能设置。',
    'ui__client/domain/hosting/performance_self__done' => '已调整网站的主机性能设置。',
    'ui__client/domain/hosting/performance_unknown__done' => '已调整主机性能设置。',
    'ui__client/domain/hosting/protected-directories__done' => '成功完成操作。',
    'ui__client/domain/hosting/protected-directories_self__done' => '成功完成操作。',
    'ui__client/domain/hosting/setup__done' => '%1主机已配置。',
    'ui__client/domain/hosting/ssh-terminal__done' => '成功完成操作。', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__done' => '成功完成操作。', // PFU
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__done' => 'ASP.NET版本已更改。', // PFW
    'ui__client/domain/hosting/web-directories/aspdotnet__done' => '%1的ASP.NET设置已更改。', // PFW
    'ui__client/domain/hosting/web-directories/create-dir__done' => '已在网站%1上创建虚拟目录。', // PFW
    'ui__client/domain/hosting/web-directories/create-virtual-dir__done' => '已创建虚拟目录。', // PFW
    'ui__client/domain/hosting/web-directories/delete__done' => '所选目录已移除。', // PFW
    'ui__client/domain/hosting/web-directories/delete_self__done' => '所选目录已移除。', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__done' => '自定义错误文档已更新。', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__done' => '所选MIME类型已移除', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__done' => '新的MIME类型已注册。', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__done' => '成功完成操作。', // PFW
    'ui__client/domain/hosting/web-directories/permissions__done' => '目录访问权限已更新。', // PFW
    'ui__client/domain/hosting/web-directories/permissions_self__done' => '目录访问权限已更新。', // PFW
    'ui__client/domain/hosting/web-directories/php__done' => 'PHP设置%1已更新。', // PFW
    'ui__client/domain/hosting/web-directories/php_self__done' => '%1 PHP设置已更新。', // PFW
    'ui__client/domain/hosting/web-directories/properties__done' => '目录属性已更新。', // PFW
    'ui__client/domain/hosting/web-directories/properties_self__done' => '目录属性已更新。', // PFW
    'ui__client/domain/hosting/web-directories/protection__done' => '目录保护设置已更新。', // PFW
    'ui__client/domain/hosting/web-directories/protection_self__done' => '目录保护设置已更新。', // PFW
    'ui__client/domain/hosting/web-directories__done' => '成功完成操作。', // PFW
    'ui__client/domain/hosting/web-directories_self__done' => "成功完成操作。", // PFW
    'ui__client/domain/mpc-certificates__done' => '在线商店中可用的 SSL/TLS 证书',
    'ui__client/domain/mpc-certificates_self__done' => '在线商店中可用的 SSL/TLS 证书',
    'ui__client/domain/odbc__done' => '成功完成操作。', // PFW
    'ui__client/domain/odbc_self__done' => '成功完成操作。', // PFW
    'ui__client/domain/register__done' => 'MyPlesk.com页面已打开。',
    'ui__client/domain/register_self__done' => 'MyPlesk.com页面已打开。',
    'ui__client/domain/rename__done' => '已更改域名。',
    'ui__client/domain/rename_self__done' => "成功更改域名。",
    'ui__client/domain/settings_self__done' => '成功完成操作。',
    'ui__client/domain/toggle_disable__done' => "域名%1已挂起。",
    'ui__client/domain/toggle_enable__done' => "域名%1已激活。",
    'ui__client/domain/traffic__done' => '成功完成操作。',
    'ui__client/domain/traffic_self__done' => '成功完成操作。',
    'ui__client/domain/traffic_unknown__done' => '成功完成操作。',
    'ui__client/domain-summary-report__done' => '成功完成操作。',
    'ui__client/domain-summary-report_self__done' => '成功完成操作。',
    'ui__client/domain-summary-report_unknown__done' => '成功完成操作。',
    'ui__client/extras-domain__done' => 'MyPlesk.com页面已打开。',
    'ui__client/extras-domain_self__done' => 'MyPlesk.com页面已打开。',
    'ui__client/ipaddress/delete_multi__done' => '成功完成操作。',
    'ui__client/ipaddress/properties__done' => '成功完成操作。',
    'ui__client/ipaddress/properties_new__done' => '成功完成操作。',
    'ui__client/ip-pool/properties__done' => "客户%1的IP池已更新。",
    'ui__client/ip-pool/properties_self__done' => '成功完成操作。',
    'ui__client/limits__done' => "客户%1的资源分配已更改。",
    'ui__client/limits_self__done' => '成功完成操作。',
    'ui__client/logo__done' => '客户%1的徽标设置已应用。',
    'ui__client/logo_reseller__done' => '已应用新的 Panel 品牌自定义设置。',
    'ui__client/logo_self__done' => '徽标设置已应用。',
    'ui__client/logo_self-reseller__done' => '您的控制面板徽标设置已应用。',
    'ui__client/manage-domain__done' => 'MyPlesk.com页面已打开。',
    'ui__client/manage-domain_self__done' => 'MyPlesk.com页面已打开。',
    'ui__client/permissions__done' => "客户%1的权限已更改。",
    'ui__client/permissions_self__done' => '成功完成操作。',
    'ui__client/preferences__done' => "已更改客户 %1 的偏好设置。",
    'ui__client/preferences_self__done' => "已更改您的偏好设置。",
    'ui__client/register-domain__done' => 'MyPlesk.com页面已打开。',
    'ui__client/register-domain_self__done' => 'MyPlesk.com页面已打开。',
    'ui__client/report/traffic-history__done' => '成功完成操作。',
    'ui__client/report/traffic-history_self__done' => '成功完成操作。',
    'ui__client/report__done' => '成功完成操作。',
    'ui__client/report_self__done' => '成功完成操作。',
    'ui__client/sessions/delete__done' => '成功完成操作。',
    'ui__client/sessions/delete_self__done' => '成功完成操作。',
    'ui__client/sessions__done' => '成功完成操作。',
    'ui__client/sessions_self__done' => '成功完成操作。',
    'ui__client/skeleton__done' => '成功完成操作。',
    'ui__client/skeleton_self__done' => '成功完成操作。',
    'ui__client/traffic__done' => "成功完成操作。",
    'ui__client/traffic_unknown__done' => '成功完成操作。',
    'ui__cp-access__done' => '成功完成操作。',
    'ui__cp-session/properties__done' => '成功完成操作。',
    'ui__cp-session__done' => '成功完成操作。',
    'ui__ftp-sessions__done' => '成功完成操作。',
    'ui__license__done' => '成功完成操作。',
    'ui__logo__done' => "Plesk 品牌自定义属性已更改。",
    'ui__longtasks/longtask/properties__done' => "成功更改后台任务设置。",
    'ui__mass-email/delete__done' => "邮件模板%1已删除。", // PFW
    'ui__mass-email/delete_multi__done' => "邮件模板已删除。",  // PFW
    'ui__mass-email/send_main__done' => "已成功完成操作。",  // PFW
    'ui__mass-email/send_selectclients__done' => "已成功选择群发电子邮件模板的客户收件人。",  // PFW
    'ui__mass-email/send_selectdomainusers__done' => "成功选择域名管理员帐户。",  // PFW
    'ui__mass-email/send_selectresellers__done' => '成功选择代理商帐户。',  // PFW
    'ui__mass-email/template/properties_main__done' => '对群发邮件模板所做变更已保存。', // PFW
    'ui__mass-email/template/properties_new-main__done' => '已创建群发邮件模板。', // PFW
    'ui__mass-email/template/properties_new-selectclients__done' => '已成功选择群发电子邮件模板的客户收件人。',  // PFW
    'ui__mass-email/template/properties_new-selectdomainusers__done' => '群发邮件模板的域名管理员帐户已选择。', // PFW
    'ui__mass-email/template/properties_new-selectresellers__done' => '群发邮件模板的代理商帐户已选择。',  // PFW
    'ui__mass-email/template/properties_unknown__done' => "群发电子邮件模板已更改。",  // PFW
    'ui__mass-email/template/properties__invalid_values' => '指定的值无效。', // PFW
    'ui__mass-email__done' => "成功完成操作。", // PFW
    'ui__mass-mail__done' => "成功完成操作", // PFU
    'ui__mass-mail/delete__done' => '邮件模板%1已删除。', // PFU
    'ui__mass-mail/delete_multi__done' => '邮件模板已删除。', // PFU
    'ui__mass-mail/properties__done' => '模板%1已更改。', // PFU
    'ui__mass-mail/properties_new__done' => '已创建模板%1。', // PFU
    'ui__mass-mail/send__done' => '邮件已发送。', // PFU
    'ui__mass-mail/send_new__done' => '邮件已发送。', // PFU
    'ui__mass-mail/send_unknown__done' => '邮件已发送。',  // PFU
    'ui__mass-mail/send_unknown-new__done' => '邮件已发送。', // PFU
    'ui__mass-mail/template/properties_new__done' => '已创建新邮件模板', // PFU
    'ui__mass-mail/template/properties__done' => '邮件模板已更新。', // PFU
    'ui__modules/watchdog/disk/properties__done' => '磁盘监控新设置已应用。', // PFU
    'ui__modules__done' => '成功完成操作。',
    'ui__modules__short-title' => '扩展',
    'ui__modules__title' => '扩展',
    'ui__reseller/client/traffic_unknown__done' => '成功完成操作。',
    'ui__reseller/extras-domain__done' => 'MyPlesk.com页面已打开。',
    'ui__reseller/extras-domain_self__done' => 'MyPlesk.com页面已打开。',
    'ui__reseller/ftp-sessions_self__done' => '成功完成操作。',
    'ui__reseller/limits__done' => "代理商资源限制和资源使用策略已更改。",
    'ui__reseller/limits_readonly-self__done' => '成功完成操作。',
    'ui__reseller/limits_self__done' => '您的资源限制和资源使用策略已更改。',
    'ui__reseller/manage-domain__done' => 'MyPlesk.com页面已打开。',
    'ui__reseller/manage-domain_self__done' => 'MyPlesk.com页面已打开。',
    'ui__reseller/permissions__done' => '已更改代理商%1的权限。',
    'ui__reseller/permissions_readonly-self__done' => '',
    'ui__reseller/permissions_self__done' => '成功完成操作。',
    'ui__reseller/register-domain__done' => 'MyPlesk.com页面已打开。',
    'ui__reseller/register-domain_self__done' => 'MyPlesk.com页面已打开。',
    'ui__reseller/report/layout/auto/delete_multi__done' => '所选报告发送计划已删除。',
    'ui__reseller/report/layout/auto/properties__done' => '报告发送计划已更新。',
    'ui__reseller/report/layout/auto/properties_new__done' => '报告发送计划已添加。',
    'ui__reseller/report/layout/properties__done' => '报告布局已更改。',
    'ui__reseller/report/layout/properties_new__done' => '已创建新报告布局。',
    'ui__reseller/report/traffic-history__done' => '成功完成操作。',
    'ui__reseller/report/traffic-history_self__done' => '成功完成操作。',
    'ui__reseller/report__done' => '成功完成操作。',
    'ui__reseller/report_self__done' => '成功完成操作。',
    'ui__reseller/sessions/delete__done' => '成功完成操作',
    'ui__reseller/sessions/delete_self__done' => '成功完成操作',
    'ui__reseller/sessions__done' => '成功完成操作。',
    'ui__reseller/sessions_self__done' => '成功完成操作。',
    'ui__reseller/traffic__done' => '成功完成操作。',
    'ui__reseller/traffic_self__done' => '成功完成操作。',
    'ui__reseller/traffic_unknown__done' => '成功完成操作。',
    'ui__reseller/logo_self__title' => 'Plesk 品牌自定义',
    'ui__reseller/logo_self__done' => '您的 Plesk 徽标设置已经应用。',
    'ui__server/aspdotnet__done' => '服务器级ASP.NET设置已更改。', // PFW
    'ui__server/certificate/default_multi__done' => '已设置所选 SSL/TLS 证书用于保护新托管网站的连接安全。',
    'ui__server/certificate/delete_multi__done' => '已移除选定的 SSL/TLS 证书。',
    'ui__server/certificate/download__done' => '已下载 SSL/TLS 证书。',
    'ui__server/certificate/properties__done' => '已更新 SSL/TLS 证书属性。',
    'ui__server/certificate/properties_new__done' => '已创建 SSL/TLS 证书 %1。',
    'ui__server/certificate/setup_multi__done' => '已设置所选 SSL/TLS 证书用于保护 Plesk 的连接安全。',
    'ui__server/certificate__done' => '成功完成操作。',
    'ui__server/cp-certificate-download__done' => "已下载 Plesk 的 SSL/TLS 证书。",
    'ui__server/crontab/properties__done' => '%1 的计划任务已更改。',
    'ui__server/crontab/task/delete__done' => '任务已删除。',
    'ui__server/crontab/task/delete_multi__done' => '任务已删除。',
    'ui__server/crontab/task/properties__done' => '计划的任务已更新。',
    'ui__server/crontab/task/properties_new__done' => '已计划新任务。',
    'ui__server/crontab/task/toggle_disable__done' => '已禁用计划任务 %1。',
    'ui__server/crontab/task/toggle_enable__done' => '已启用计划任务 %1。',
    'ui__server/crontab__done' => '成功完成操作。',
    'ui__server/dns__done' => '成功完成操作。',
    'ui__server/ip-address/client/delete__done' => "已从用户的IP池中删除此IP地址。",
    'ui__server/ip-address/client/delete_multi__done' => "已从客户池移除IP地址。",
    'ui__server/ip-address/client/properties_new__done' => 'IP地址已分配给用户。',
    'ui__server/ip-address/ip-address/add-to-clients_add-target__done' => 'IP地址%1已分配给所选客户。',
    'ui__server/ip-addresses__done' => "成功完成操作。",
    'ui__server/mail/statistics/spam/recipients__done' => "成功完成操作。",
    'ui__server/mail/statistics/spam/summary__done' => "成功完成操作。",
    'ui__server/mail/statistics/spam__done' => "成功完成操作。",
    'ui__server/mail/statistics/virus/recipients__done' => "成功完成操作。",
    'ui__server/mail/statistics/virus/summary__done' => "成功完成操作。",
    'ui__server/mail/statistics/virus/viruses__done' => "成功完成操作。",
    'ui__server/mail/statistics/virus__done' => "成功完成操作。",
    'ui__server/mail/statistics__done' => "成功完成操作。",
    'ui__server/mail__done' => '邮件服务器设置已更改。',
    'ui__server/maillists__done' => '成功完成操作。',
    'ui__server/mpc-certificates__done' => '已打开列有可用 SSL/TLS 证书的在线商店页面。',
    'ui__server/odbc__done' => '服务器级ODBC设置已更改。', // PFW
    'ui__server/pmm__done' => '成功完成操作。',
    'ui__server/preferences__done' => "服务器设置已更改。",
    'ui__server/register__done' => 'MyPlesk.com页面已打开。',
    'ui__server/services__done' => '成功完成操作。',
    'ui__server/sitebuilder__done' => '成功完成操作。',
    'ui__server/skeleton__done' => '成功完成操作。',
    'ui__server/spam-filter/black-list/address/delete__done' => '地址%1已从服务器级黑名单中删除。',
    'ui__server/spam-filter/black-list/address/delete_multi__done' => '地址已从服务器级黑名单中删除。',
    'ui__server/spam-filter/black-list/address/properties_new__done' => '地址已被添加至黑名单。',
    'ui__server/spam-filter/black-list/address__done' => '地址已添加至黑名单。',
    'ui__server/spam-filter/black-list__done' => '成功完成操作。', // PFU
    'ui__server/spam-filter/properties__done' => '垃圾邮件过滤器配置已更改。',
    'ui__server/spam-filter/toggle_disable__done' => '已在系统范围禁用垃圾邮件过滤。',
    'ui__server/spam-filter/toggle_enable__done' => '已在系统范围启用了垃圾邮件过滤。',
    'ui__server/spam-filter/white-list/address/delete__done' => '地址%1已从服务器级的白名单中删除。',
    'ui__server/spam-filter/white-list/address/delete_multi__done' => '地址已从服务器级白名单删除。',
    'ui__server/spam-filter/white-list/address/properties_new__done' => '地址已添加至白名单。',
    'ui__server/spam-filter/white-list/address__done' => '地址已添加至白名单。',
    'ui__server/spam-filter/white-list__done' => '成功完成操作。', // PFU
    'ui__server/spam-filter__done' => '成功完成操作。',
    'ui__server/statistics__done' => '成功完成操作。',
    'ui__server/time__done' => "系统日期和时间已更改。",
    'ui__server__done' => "成功完成操作。",
    'ui__sessions/properties__done' => '成功完成操作。',
    'ui__sessions__done' => '成功完成操作。',
    'ui__sessions/delete__done' => '所选会话已删除。',
    'ui__start-page__done' => '成功完成操作。',
    'ui__support__done' => '支持请求表单已在单独的浏览器窗口中打开。',
    'ui__ts-sessions__done' => '成功完成操作。',

    ///
    /// END OF DONE MESSAGES
    ///

    ///
    /// ASSORTED COMMON KEYS / TBI
    ///

    // non-UI
    '__no_files_to_upload' => '无可上传的文件。',
    'login_up__access_denied_no_permission' => "拒绝访问。权限不足，无法登录。",
    'mail__unable_remove_pattern' => "无法从服务器黑名单中移除地址: %1", // PFW
    'mail__incorrect_network_format' => '网络格式错误: %1', // PFW
    'initconf__unable_change_passwd' => "无法更改管理员的密码：%1",
    'initconf__unable_get_passwd' => '无法获取当前的管理员密码：%1 失败：%2',
    'initconf__invalid_hostname' => '主机名 "%1" 中的错误',
    'initconf__unable_reconfig' => '无法配置 Plesk：reconfig 失败：%1',
    'initconf__unable_update_admin' => '无法更新管理员联系信息：%1',
    '__refresh' => '刷新',
    '__dalias_not_exist' => '域名别名不存在。',
    '__bug146523_explanation' => '之前版本的 Plesk 允许 FTP 用户名可以使用最多 16 个字符。该版本的 Plesk 允许 FTP 用户名可以使用最多 15 个字符。若要解决此问题，请将受影响的 FTP 用户名长度减少到 15 个字符，同时更改至少一个字符来避免用户名冲突。由此变动带来的任何不便，我们深表歉意。',
    'domain__cannot_change_webmail' => '无法更改域名上的 web 邮箱: %1',
    'sb_publish_disable_warning' => '如果您关闭使用 Presence Builder 创建的网站，将会移除之前在 Presence Builder 中创建的网站而所有的网站数据都会丢失。 如果您想继续请点击 确定。',
    '__sbnet_client_use_sbnet' => "在 Presence Builder 中创建相应的用户帐户",
    'mail_resp_activate' => '激活自动回复',
    'limitsManger__limit_available_error' => '无法分配要求的资源("%%limitName%%"): 您的帐户仅可以使用%%available%%。',
    'limitsManger__limit_reserved_error' => '无法分配比已用资源更少的资源("%%limitName%%")。',
    'domain__unable_to_rename_vhost_dir_already_exists' => '无法重命名域名：带有指定名称的虚拟目录已存在。',
    'domain_unable_to_rename' => '无法重命名域名。',

    // Greylisting
    'spamfilter__general_settings_legend' => '常用',
    'spamfilter__spamassassin_status_legend' => 'SpamAssassin垃圾邮件过滤',
    'spamfilter__spamassassin_settings_legend' => 'SpamAssassin设置',
    'spamfilter__spamassassin_server_status_legend' =>  "启用服务器级SpamAssassin垃圾邮件过滤",
    'spamfilter__spamassassin_user_status_legend' => '启用SpamAssassin垃圾邮件过滤',
    'spamfilter__greylisting_status_legend' => '启用服务器级灰名单垃圾邮件过滤功能',
    'spamfilter__personal_settings_not_allowed' => '系统策略不允许使用个人垃圾邮件过滤设置。',
    'spamfilter__required_score' => '邮件被标识为垃圾邮件需获得的分值',
    'spamfilter__rewrite_header_subject' => '将下列文本添加至被视为垃圾邮件的每封邮件的主题开头',
    'spamfilter__use_mailuser_prefs' => '将单个设置应用到垃圾邮件过滤中',
    'spamfilter_addresses__text_hint' => '使用空格、Tab 键、逗号、分号或另起一行分隔多个地址。“@”符号左边不得含有非 ASCII 字符。地址可以包含“*”和“?”通配符 (如：*@domain.com、user?@*.com)。域名的非 ASCII 部分不得包含通配符。',
    'spamfilter__score_error' => '分值不得为负数，小数点之前的部分必须小于 100，小数点后不能超过两位数。',
    'spamfilter__rewrite_header_error' => '信息主题可包含除数字标识 (#) 以外的任何可打印的字符。',

    // template conflict keys
    'nonexistent_mail__mode_bounce' => '退信',
    'nonexistent_mail__mode_discard' => '丢弃',
    'nonexistent_mail__mode_catch_addr' => '转发到电子邮件地址',
    'nonexistent_mail__mode_catch_ip' => '转发到 IP',
    'nonexistent_mail__bounce_not_supported' => '不支持退信模式',
    'nonexistent_mail__discard_not_supported' => '不支持丢弃模式',
    'nonexistent_mail__catch_not_supported' => '不支持转发到电子邮件地址',
    'nonexistent_mail__redirect_not_supported' => '转发到IP功能',
    'nonexistent_mail__ip_used_on_this_host' => 'IP地址解析到 localhost',
    'nonexistent_mail_address_should_be_local_domain' => '因为传出邮件控制功能已被打开，所以不存在收件人的电子邮件地址 %1 应属于选定的域名。如若不是，将会应用 "拒绝" 策略而不是转发。',
    'nonexistent_mail_address_should_be_local_domain_not_restricted' => '因为传出邮件控制功能已被打开，为邮件转发指定的电子邮件地址 (%1) 应该属于选定的域名。如若不是，发送到这些地址的邮件将不计入传出邮件控制范畴。',
    // mail acc extras
    '__antivirus' => "防病毒程序",

    // web apps

    // none available
    'ui__admin-alias__none-available' => '无可用的其他管理员帐户。', // PFW
    'ui__client/domain/certificate__none-available' => '客户没有 SSL/TLS 证书。',
    'ui__client/domain/certificate__none-available__1' => '客户没有带有 SSL/TLS 证书的域名。',
    'ui__client/domain/certificate__none-available__2' => '域名没有 SSL/TLS 证书。',
    'ui__reseller/client__none-available' => '无代理商及客户。',

    // empty selection for lists
    'ui__client/ipaddress/delete__empty_selection' => '请选择要从IP池中移除的IP地址。',
    'ui__server/ip-address/client/delete__empty_selection' => '请选择要从其IP池中移除IP地址的代理商帐户。',
    'ui__server/crontab/task/delete__empty_selection' => '您需要选择要取消的任务。',

    // scripting languages errors
    'phosting__php_not_enabled' => '此网站上的PHP支持已停用。',
    'phosting__aspdotnet_not_enabled' => '此网站上的ASP.NET支持已停用。',
    'phosting__php_forced_by_site_isolation' => '无法修改 PHP 设置：无权限覆盖服务器级安全策略。',
    'phosting__option_forced_by_site_isolation' => '无法修改 %1 设置：无权限覆盖服务器级安全策略。',
    'phosting__mod_bw_disabled_by_vps_optimized' => '因为 Plesk 在 VPS 优化模式下运行，mod_bw已被禁用。',
    'phosting__mod_php_disabled_by_vps_optimized' => '因为 Plesk 在 VPS 优化模式下运行，mod_php 已被禁用。',
    'phosting__perl_disabled_by_vps_optimized' => '因为 Plesk 在 VPS 优化模式下运行，Perl 已被禁用。',
    'phosting__asp_disabled_by_vps_optimized' => '因为 Plesk 在 VPS 优化模式下运行，ASP已被禁用。',
    'phosting__python_disabled_by_vps_optimized' => '因为 Plesk 在 VPS 优化模式下运行，Python 已被禁用。',
    'phosting__fastcgi_disabled_by_vps_optimized' => '因为 Plesk 在 VPS 优化模式下运行，fastcgi 已被禁用。',
    'phosting__php_handler_id_not_registered' => '在网站隔离设置中不允许设置 PHP 处理器。将会使用默认的 PHP 处理器。',
    'phosting__php_served_by_nginx_is_not_available' => '不允许在网站隔离设置中设置 PHP 处理程序（由 nginx 服务的 FPM 应用程序）。将会使用默认的 PHP 处理器。',

    // various UI
    'ui__client/ipaddress/properties_readonly__short-title' => '查看IP地址列表',
    'ui__client/ipaddress/properties_readonly__title' => '查看IP地址列表',
    'ui__client/ipaddress/properties_readonly__description' => '查看此用户可用的IP地址列表。',
    'ui__server/certificate__short-title' => 'SSL/TLS 证书',
    'ui__server/certificate__title' => 'SSL/TLS 证书',
    'ui__server/certificate__description' => '查看和管理 SSL/TLS 证书。',

    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__short-title' => '移除MIME类型',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__title' => '移除MIME类型',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__description' => '移除所选MIME类型。',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__short-title' => '添加MIME类型',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__title' => '添加MIME类型',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__description' => '注册 MIME 类型。',

    'ui__client/ipaddress/delete_multi__wizard-title' => '移除IP地址',
    'ui__client/ipaddress/delete_multi__wizard__2_multi' => '选择要从客户%1IP池中移除的IP地址',

    // mail

    // for future use
    'ui__client/domain/hosting/file-manager/create-file__short-title' => '创建文件',
    'ui__client/domain/hosting/file-manager/create-file__title' => '创建文件',
    'ui__client/domain/hosting/file-manager/create-file__description' => '创建一个文件。',
    'ui__client/domain/hosting/file-manager/create-dir__short-title' => '创建文件夹',
    'ui__client/domain/hosting/file-manager/create-dir__title' => '创建文件夹',
    'ui__client/domain/hosting/file-manager/create-dir__description' => '创建文件夹。',
    'ui__client/domain/hosting/file-manager/edit__short-title' => '编辑文件或文件夹',
    'ui__client/domain/hosting/file-manager/edit__title' => '编辑文件或文件夹',
    'ui__client/domain/hosting/file-manager/edit__description' => '编辑所选文件或文件夹。',
    'ui__client/domain/hosting/file-manager/rename__short-title' => '重命名文件或文件夹',
    'ui__client/domain/hosting/file-manager/rename__title' => '重命名文件或文件夹',
    'ui__client/domain/hosting/file-manager/rename__description' => '重命名所选文件或文件夹。',
    'ui__client/domain/hosting/file-manager/permissions__short-title' => '更改权限',
    'ui__client/domain/hosting/file-manager/permissions__title' => '更改权限',
    'ui__client/domain/hosting/file-manager/permissions__description' => '更改文件或文件夹的访问权限。',
    'ui__client/domain/hosting/file-manager/remove__short-title' => '移除文件或文件夹',
    'ui__client/domain/hosting/file-manager/remove__title' => '移除文件或文件夹',
    'ui__client/domain/hosting/file-manager/remove__description' => '移除此文件或文件夹。',
    'ui__client/domain/hosting/file-manager/remove_self__short-title' => '移除文件或文件夹',
    'ui__client/domain/hosting/file-manager/remove_self__title' => '移除文件或文件夹',
    'ui__client/domain/hosting/file-manager/remove_self__description' => '移除此文件或文件夹。',
    'ui__client/domain/hosting/file-manager/copy-move__short-title' => '复制或移动文件/目录',
    'ui__client/domain/hosting/file-manager/copy-move__title' => '复制或移动文件/目录',
    'ui__client/domain/hosting/file-manager/copy-move__description' => '复制或移动所选文件/目录',
    'ui__client/domain/hosting/file-manager/view__short-title' => '查看文件',
    'ui__client/domain/hosting/file-manager/view__title' => '查看文件',
    'ui__client/domain/hosting/file-manager/view__description' => '查看所选文件。',

    'ui__client/ipaddress__short-title' => 'IP 地址',
    'ui__client/ipaddress__title' => 'IP 地址',
    'ui__client/ipaddress__description' => '查看IP地址相关信息。',
    'ui__server/ip-address__short-title' => 'IP 地址',
    'ui__server/ip-address__title' => 'IP 地址',
    'ui__server/ip-address__description' => '查看IP地址相关信息。',
    'ui__client/domain/hosting/setup__short-title' => '主机设置',
    'ui__client/domain/hosting/setup__title' => '主机设置',
    'ui__client/domain/hosting/setup__description' => '设置网站%1的主机设置。',
    'ui__client/domain/hosting/web-directories/mime-type/properties__short-title' => 'MIME类型', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__title' => 'MIME类型属性', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__description' => '查看MIME类型属性。', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__short-title' => '错误文件', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__title' => '错误文件', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__description' => '错误文件属性。', // PFW

    // tooltips

    'b_resellerreportslist_remove' => '移除所选报告布局。',
    'b_resellerreportslist_search' => '输入搜索模式，并单击查找报告布局。',
    'b_resellerreportslist_show_all' => '显示所有可用的报告布局。',

    'l_resellerreportslist_auto' => '按是否自动提交对报告布局进行排序。',
    'l_resellerreportslist_clients' => '按客户信息对报告布局进行排序。',
    'l_resellerreportslist_domains' => '按域名信息对报告布局进行排序。',
    'l_resellerreportslist_general' => '按常规信息对报告布局进行排序。',
    'l_resellerreportslist_name' => '按报告名称对报告布局进行排序。',
    'l_resellerreportslist_personal_domains' => '按个人域名信息对报告布局进行排序。',

    'b_adminreportslist_remove' => '移除所选报告布局。',
    'b_adminreportslist_search' => '输入搜索模式，并单击查找报告布局。',
    'b_adminreportslist_show_all' => '显示所有可用的报告布局。',

    'l_adminreportslist_auto' => '按是否自动提交对报告布局进行排序。',
    'l_adminreportslist_clients' => '按客户信息对报告布局进行排序。',
    'l_adminreportslist_domains' => '按域名信息对报告布局进行排序。',
    'l_adminreportslist_general' => '按常规信息对报告布局进行排序。',
    'l_adminreportslist_name' => '按报告名称对报告布局进行排序。',
    'l_adminreportslist_personal_clients' => '按个人客户信息对报告布局进行排序。',
    'l_adminreportslist_personal_domains' => '按个人域名信息对报告布局进行排序。',
    'l_adminreportslist_resellers' => '按代理商信息对报告布局进行排序。',

    'b_get_password_cancel' => '不发送邮件，并返回上一屏幕。',
    'b_get_password_send' => '单击“确定”发送密码恢复邮件到已在系统中注册的电子邮件地址',



    'b_personaltrafficlist_search' => '输入搜索模式，并单击查找域名。',
    'b_personaltrafficlist_show_all' => '显示所有域名。',

    'b_back' => '返回上一页。',
    'b_next' => '转到下一页。',

    'b_dnsnstemplatelist_remove' => '删除所选的域名服务器。',
    'b_dnsnstemplatelist_search' => '输入搜索模式，然后单击查找域名服务器。',
    'b_dnsnstemplatelist_show_all' => '显示所有域名服务器。',

    'l_dnsnstemplatelist_ns' => '按域名服务器对DNS模板记录进行排序。',

    // filesharing management tool
    'cu__serverfilesharing_fsLinksAsHttps' => '生成到文件与文件夹的安全链接',
    'cu__serverfilesharing_fsPublicFolderEnabled' => '启用共享文件',
    'cu__serverfilesharing_fsPublicFolder' => '用于存储共享文件的文件夹',
    'cu__serverfilesharing_fsPublicUrl' => '访客用于访问共享文件的 URL',
    'cu__serverfilesharing_fsPartnerFolderEnabled' => '共享文件启用密码保护',
    'cu__serverfilesharing_fsPartnerFolder' => '用于存储加密保护文件的文件夹',
    'cu__serverfilesharing_fsPartnersLogin' => '用于文件访问的用户名',
    'cu__serverfilesharing_fsPartnersPassword' => '文件访问的密码',
    'cu__serverfilesharing_fsDomain' => '网站文件夹根目录 URL。域名',
    'cu__serverfilesharing_fsPrefix' => '网站文件夹根目录 URL。前缀',
    'cu__serverfilesharing_commandUpdate' => '更新文件共享设置',
    'cu__serverfilesharing_commandInfo' => '显示现存文件共享设置',
    'subscription_rename_is_forbidden' => '服务器级的策略禁止重命名订阅。',
    ///
    /// END OF RANDOM COMMON KEYS
    ///

    ////
    //// CRONTAB - temporary
    ////

    // wizard:

    'ui__server/crontab/task_unknown__wizard-title' => '管理服务器上的计划任务',
    'ui__server/crontab/task_unknown__wizard__2_unknown' => '选择要管理其计划的任务的系统用户。',

    'ui__server/crontab/task__short-title' => '%1',
    'ui__server/crontab/task__title' => '计划任务 %1',
    'ui__server/crontab/task__description' => '查看计划任务 %1 的属性。',

    ///
    /// SERVER
    ///

    'ui__server/crontab_unknown__short-title' => '系统用户',
    'ui__server/crontab_unknown__title' => '系统用户',
    'ui__server/crontab_unknown__description' => '可为计划的任务所有者的系统用户。',


    'ui__server/crontab__none-available' => '您尚无系统用户帐户。',
    'ui__server/crontab_readonly-unknown__description' => '查看计划的任务。',
    'ui__server/crontab_readonly-unknown__short-title' => '计划的任务',
    'ui__server/crontab_readonly-unknown__title' => '查看计划的任务',
    'ui__server/crontab_readonly-unknown__wizard-title' => '查看计划的任务。',
    'ui__server/crontab_readonly__description' => '查看计划的任务 %1。',
    'ui__server/crontab_readonly__short-title' => '计划任务 %1',
    'ui__server/crontab_readonly__title' => '查看计划的任务 %1',
    'ui__server/crontab_unknown__wizard-title' => '管理计划的任务。',

    'ui__server/crontab/properties__description' => '编辑 %1 的计划任务。',

    'ui__server/crontab/properties__short-title' => '设置',
    'ui__server/crontab/properties__title' => '编辑 %1 的计划任务',
    'ui__server/crontab/properties_readonly-unknown__description' => '查看计划的任务。',
    'ui__server/crontab/properties_readonly-unknown__short-title' => '设置',
    'ui__server/crontab/properties_readonly-unknown__title' => '查看计划的任务',
    'ui__server/crontab/properties_readonly-unknown__wizard-title' => '查看计划的任务。',
    'ui__server/crontab/properties_readonly__description' => '查看 %1 的计划任务。',
    'ui__server/crontab/properties_readonly__short-title' => '设置',
    'ui__server/crontab/properties_readonly__title' => '查看 %1 的计划任务',
    'ui__server/crontab/properties_unknown__description' => '编辑计划的任务。',
    'ui__server/crontab/properties_unknown__short-title' => '属性',
    'ui__server/crontab/properties_unknown__title' => '编辑计划的任务',
    'ui__server/crontab/properties_unknown__wizard-title' => '编辑计划的任务。',
    'ui__server/crontab/properties_unknown__wizard__2_readonly-unknown' => '选择您要查看其任务的系统用户。',
    'ui__server/crontab/properties_unknown__wizard__2_unknown' => '选择您要更改其任务的系统用户。',
    'ui__server/crontab/properties_unknown__wizard__3' => '单击“完成”应用更改并退出向导。',
    'ui__server/crontab/properties_unknown__wizard__3_readonly' => '单击“完成”并退出向导。',

    'ui__server/crontab/task__none-available' => '您尚无计划的任务。',
    'ui__server/crontab/task__none-available__2' => '系统用户%1尚无任何计划的任务。',
    'ui__server/crontab/task_readonly-unknown__description' => '计划的任务。',
    'ui__server/crontab/task_readonly-unknown__short-title' => '任务',
    'ui__server/crontab/task_readonly-unknown__title' => '计划的任务',

    'ui__server/crontab/task/delete__description' => '移除计划任务 %1',

    'ui__server/crontab/task/delete__short-title' => '移除',
    'ui__server/crontab/task/delete__title' => '移除计划任务 %1',
    'ui__server/crontab/task/delete_multi__description' => '删除计划的任务。',

    'ui__server/crontab/task/delete_multi__short-title' => '移除',
    'ui__server/crontab/task/delete_multi__title' => '删除计划的任务',
    'ui__server/crontab/task/delete_multi__wizard-title' => '删除计划的任务。',
    'ui__server/crontab/task/delete_multi__wizard__2_unknown' => '选择您要删除其任务的系统用户。',
    'ui__server/crontab/task/delete_multi__wizard__3_multi' => '选择您要删除的任务。',
    'ui__server/crontab/task/delete_multi__wizard__4_multi' => '通过选中复选框确认删除任务，单击“完成”并退出向导。',
    'ui__server/crontab/task/delete_unknown__description' => '移除计划任务。',
    'ui__server/crontab/task/delete_unknown__short-title' => '移除',
    'ui__server/crontab/task/delete_unknown__title' => '移除计划任务',
    'ui__server/crontab/task/delete_unknown__wizard-title' => '移除计划任务。',
    'ui__server/crontab/task/delete_unknown__wizard__2_unknown' => '选择您要删除其任务的系统用户。',
    'ui__server/crontab/task/delete_unknown__wizard__3_unknown' => '选择您要删除的任务。',
    'ui__server/crontab/task/delete_unknown__wizard__4' => '通过选中复选框确认删除任务，请单击“完成”并退出向导。',

    'ui__server/crontab/task/properties__description' => '编辑计划的任务。',

    'ui__server/crontab/task/properties__short-title' => '编辑任务%1',
    'ui__server/crontab/task/properties__title' => '编辑计划的任务',
    'ui__server/crontab/task/properties_new__description' => '为 %1 创建计划的任务。',

    'ui__server/crontab/task/properties_new__short-title' => '添加任务',
    'ui__server/crontab/task/properties_new__title' => '为 %1 创建计划的任务',
    'ui__server/crontab/task/properties_new__wizard-title' => '创建计划的任务。',
    'ui__server/crontab/task/properties_new__wizard__2_unknown' => '选择您要为其创建计划任务的系统用户。',
    'ui__server/crontab/task/properties_new__wizard__4_new' => '单击“完成”应用更改并退出向导。',
    'ui__server/crontab/task/properties_readonly-unknown__description' => '查看计划的任务。',
    'ui__server/crontab/task/properties_readonly-unknown__short-title' => '属性',
    'ui__server/crontab/task/properties_readonly-unknown__title' => '查看计划的任务',
    'ui__server/crontab/task/properties_readonly-unknown__wizard-title' => '查看计划的任务。',
    'ui__server/crontab/task/properties_readonly__description' => '查看计划的任务。',
    'ui__server/crontab/task/properties_readonly__short-title' => '查看任务%1',
    'ui__server/crontab/task/properties_readonly__title' => '查看计划的任务',
    'ui__server/crontab/task/properties_unknown-new__description' => '创建计划的任务。',
    'ui__server/crontab/task/properties_unknown-new__short-title' => '添加任务',
    'ui__server/crontab/task/properties_unknown-new__title' => '创建计划的任务',
    'ui__server/crontab/task/properties_unknown__description' => '编辑计划的任务。',
    'ui__server/crontab/task/properties_unknown__short-title' => '属性',
    'ui__server/crontab/task/properties_unknown__title' => '编辑计划的任务',
    'ui__server/crontab/task/properties_unknown__wizard-title' => '编辑计划的任务。',
    'ui__server/crontab/task/properties_unknown__wizard__2_readonly-unknown' => '选择您要查看其任务的系统用户。',
    'ui__server/crontab/task/properties_unknown__wizard__2_unknown' => '选择您要更改其任务的系统用户。',
    'ui__server/crontab/task/properties_unknown__wizard__3_readonly-unknown' => '选择计划任务。',
    'ui__server/crontab/task/properties_unknown__wizard__3_unknown' => '选择您要更改的计划任务。',
    'ui__server/crontab/task/properties_unknown__wizard__4' => '单击“完成”应用更改并退出向导。',
    'ui__server/crontab/task/properties_unknown__wizard__4_readonly' => '单击“完成”退出向导。',

    'ui__server/crontab/task/toggle_disable__description' => '禁用计划任务 %1。',

    'ui__server/crontab/task/toggle_disable__short-title' => '禁用',
    'ui__server/crontab/task/toggle_disable__title' => '禁用计划任务 %1',
    'ui__server/crontab/task/toggle_enable__description' => '启用计划任务 %1。',

    'ui__server/crontab/task/toggle_enable__short-title' => '启用',
    'ui__server/crontab/task/toggle_enable__title' => '启用计划任务 %1',
    'ui__server/crontab/task/toggle_unknown__description' => '启用或禁用计划的任务。',
    'ui__server/crontab/task/toggle_unknown__short-title' => '启用或禁用',
    'ui__server/crontab/task/toggle_unknown__title' => '启用或禁用计划的任务',
    'ui__server/crontab/task/toggle_unknown__wizard-title' => '启用或禁用计划的任务',
    'ui__server/crontab/task/toggle_unknown__wizard__2_unknown' => '选择您要启用或禁用其任务的系统用户。',
    'ui__server/crontab/task/toggle_unknown__wizard__3_unknown' => '选择您要启用或禁用的任务。',


    /// not used on HP:

    'ui__client_unknown__short-title' => '客户帐户', // not used on HP?
    'ui__client_unknown__title' => '客户帐户', // not used on HP?
    'ui__client_unknown__description' => '管理客户帐户。', // not used on HP?
    'ui__client/domain/disable_unknown__title' => '挂起域名', // not used on HP
    'ui__client/domain/disable_unknown__short-title' => '挂起域名', // not used on HP,
    'ui__client/domain/disable_unknown__description' => '挂起域名。', // not used on HP
    'ui__client/domain/enable_unknown__title' => '激活域名', // not used on HP
    'ui__client/domain/enable_unknown__short-title' => '激活域名', // not used on HP
    'ui__client/domain/enable_unknown__description' => '激活域名。', // not used on HP

    //Additional FTP Accounts
    'directory_browser__select_folder' => '选择文件夹',
    'ftp__management_domain' => "域名 %1 下的 FTP 帐户", // for Additional FTP Accounts
    '__ftp_users_list' => "FTP子帐户",
    'ftp__user_name' => "FTP 帐户名称",
    'ftp__user_home' => "主目录",
    'ftp__invalid_path' => "所指定的路径无效",
    'ftp__physical_path_not_exist' => "物理路径不存在",
    'i_ftp_ses_sub_user' => 'FTP子帐户会话。',
    '__new_passwd' => "新的%1密码",

    ////
    //// Errors with custom template of Apache configuration
    ////

    'apacheConfigurationFailedMessageSubject' => '无法在主机 <%%host%%> 上配置 web 服务器',
    'apacheConfigurationFailedMessageBody' => "无法在主机 <%%host%%> 上生成 web 服务器配置文件因为以下错误：\n\n%%error%%\n\n请在 web 服务器配置模板中修正该错误并重新生成文件。",

    'apacheConfigurationMessageAdminTitle' => '生成web服务器配置失败',
    'apacheConfigurationMessageClientTitle' => '警告',

    'apacheConfigurationFailedAdminHomeMessage' => '因配置模板错误，导致未建立新配置。错误详情已发送到您的邮箱，请查看邮件，修正错误，并单击 %1 重新尝试生成配置。',
    'apacheConfigurationFailedAdminHomeMessageLink' => '此处', //used on linked text in apacheConfigurationFailedAdminHomeMessage
    'apacheConfigurationFailedAdminDomainMessage' =>  '因配置模板错误，导致未建立域名 %1 的新配置。错误详情已发送到您的邮箱，请查看邮件，修正错误，并单击 %2 重新尝试生成配置。',
    'apacheConfigurationFailedAdminDomainMessageLink' => '此处', //used on linked text in apacheConfigurationFailedAdminDomainMessage

    'apacheConfigurationFailedUserDomainMessage' => '域名%1的Web服务器配置可能不一致。请联系服务器管理员解决此问题。',

    'apacheConfigurationFailedAdminDomainsMessage' => '因配置模板错误，导致未建成部分域名的新配置。错误详情已发送到您的邮箱，请查看邮件，修正错误，并点击 %1 重新尝试生成配置。',
    'apacheConfigurationFailedAdminDomainsMessageLink' => '此处', //used on linked text in apacheConfigurationFailedAdminDomainsMessage

    'apacheConfigurationFailedUserDomainsMessage' => '部分Web服务器配置可能不一致。请联系服务器管理员来解决此问题。',



    ///HOSTING PARAMETERS
    '__apache_errdocs' => "自定义错误文档",
    'dom_pref__webusers_script' => "允许网站用户使用脚本。",
    '__seoRedirect' => '配置偏好的域为',
    '__seoRedirectToLanding' => 'domain.tld',
    '__seoRedirectToWww' => 'www.domain.tld',
    '__seoRedirectNone' => '无',

    '__sites' => '域名',
    'domain_plan__perm_denied_manage_phosting' => '权限不足，无法管理主机设置。',
    '__owned_by_client' => '由客户所有',
    'ui__client/permissions_readonly__description' => "查看客户 %1 可在 Plesk 中执行的操作。",
    'backup__restore__object_client_template' => '客户模板',
    '__template_name' => '服务方案名称',
    'template__not_exists' => '服务方案不存在。',
    'template__exists' => '名为 %1 的方案已经存在。',
    'clientOwnerChanger__ip_not_in_pool' => '指定的 IP 地址未在代理商的池里。',

    //// Change owner of subscription
    'chown__select_title' => "选择新订户",
    'ui__client/domain/chowner_multi__wizard__3_multi-select' => '为所选订阅选择新的所有者并单击下一步 >>。',
    'domains__client_info' => "%1 个订阅，%2 个活动订阅，已使用磁盘空间 %3，已使用流量 %4",
    '__possible_owners' => '可能的新订户',

    'clients_list__filter_owner__filter_title' => '提供商',
    'clients_list__filter_owner_any' => '所有用户',
    'clients_list__filter_owner_my' => '仅限我的客户',
    'clients_list__filter_owner_name__filter_title' => '服务商名称',

    '__owner' => "提供商",
    'l_clientslist_owner' => '按服务商对用户帐户进行排序。',
    'l_clientslist_date' => '按创建日期对用户帐户进行排序。',
    'l_clientslist_name' => '按名称对用户帐户进行排序。',
    'l_clientslist_domains' => '按域名对用户帐户进行排序。',
    'l_clientslist_cname' => '按公司名称对用户帐户进行排序。',

    'ui__client/domain/chowner_multi__wizard-title' => '正在重新分配选定的订阅',
    'chown__check_title' => '更改订户',

    'ui__client/domain/chowner_multi__wizard__3_multi' => "单击“完成”结束操作。完成后，所选订阅则会分配给新的所有者，相关服务商则会更改为新所有者的服务商，且订阅将会与其服务方案解除绑定，成为'自定义'订阅。",

    'chown__error_check' => '尝试分配订阅给新所有者时出现问题。',
    'domain_chown_subscription_will_be_anonymous' => "即将从当前服务方案取消限制订阅，并变成'自定义'。",
    'chown__error_domains_exclude' => "尝试向新的所有者移交某些订阅时出现问题。突出显示的为移交出现问题的订阅。",
    'chown__ip_not_in_client_pool' => "尚未将此订阅的IP地址分配给新的订阅所有者的IP地址池",
    'chown__already_owned_by_client' => "此订阅已属于该用户。",

    /// Protected directories

    'ui__client/domain/hosting/protected-directories/path__short-title' => '/%1',
    'ui__client/domain/hosting/protected-directories/path__title' => '受保护目录/%1',
    'ui__client/domain/hosting/protected-directories/path__description' => '管理受保护目录/%1',
    'ui__client/domain/hosting/protected-directories/path/properties_new__title' => '在网站 %1 下创建受保护目录',
    'ui__client/domain/hosting/protected-directories/path/properties_new__short-title' => '添加受保护目录',
    'ui__client/domain/hosting/protected-directories/path/properties_new__description' => '创建受保护目录。',
    'ui__client/domain/hosting/protected-directories/path/properties_new__done' => '成功创建受保护目录/%1。',
    'ui__client/domain/hosting/protected-directories/path/properties__title' => '受保护目录/%1的设置',
    'ui__client/domain/hosting/protected-directories/path/properties__short-title' => '目录设置',
    'ui__client/domain/hosting/protected-directories/path/properties__description' => '更改受保护目录的位置、名称和区域标题。',
    'ui__client/domain/hosting/protected-directories/path/properties__done' => '已更改受保护目录设置',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__title' => '确认删除',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__short-title' => '移除受保护内容',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__description' => '移除所选目录的保护机制。',
    'ui__client/domain/hosting/protected-directories/path/delete__empty_selection' => '选择要移除保护的目录。',
    'ui__client/domain/hosting/protected-directories/path/delete#legend__description' => '此操作将导致从目录中移除保护功能。Internet用户将可以自由访问这些目录。',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__done' => '从所选目录中成功移除受保护内容。',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__title' => '添加用户',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__short-title' => '添加用户',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__description' => '设置访问受保护目录%1的用户帐户',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__done' => '已创建访问受保护目录的用户帐户。',
    'ui__client/domain/hosting/protected-directories/path/user/properties__done' => "已保存用户凭证。",
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__title' => '已移除受保护目录用户',
    'ui__client/domain/hosting/protected-directories/path/user/delete__empty_selection' => '选定您需移除的用户。',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__short-title' => '移除',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__description' => '移除目录用户。',
    'ui__client/domain/hosting/protected-directories/path/user/delete#legend__description' => '即将删除下列受保护目录:',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__done' => '已移除所选用户帐户。',

    '__redirect_hint' => '即将在15秒内重定向到新地址... 若未自动转到新地址，请启用javascript或点击超链接%%link%%。',

    'backup__restore__object_maillist' => '邮件列表',
    'backup__restore__object_site' => '网站',
    'backup__restore__object_user' => '用户',
    'backup__restore__object_role' => '角色',

    'limit__name_max_site' => '网站',

    'iis_pool__unable_rename_client' => "无法重命名IIS应用程序池: %1。",

    'anonftp__is_not_supported_for_addon_domains' => '仅限此订阅的主域名支持匿名FTP服务。',
    'anonftp__is_not_supported_for_addon_domains_powerUser' => '仅限此订阅的主域名支持匿名FTP服务。',

    '__gb' => 'GB',
    '__tb' => 'TB',
    '__gb_month' => 'GB/月',
    '__tb_month' => 'TB/月',

    '__customers' => '客户',
    '__customer_name' => '客户名称',
    '__customer_total' => '总客户',
    '__site' => '网站',
    '__def_site' => '默认网站',
    '__subscription_name' => '订阅名称',
    '__subscription_name_powerUser' => '订阅名称',

    'limit__units_max_traffic_suffix' => '/月',

    'dom_pref__discard' => "拒绝",

    'mail__pattern_already_exists' => '模板"%1"已在黑名单中。',

    '__not_supported' => '不受支持',

    'plesk_key__sitebuilder' => '通过 Presence Builder 发布网站',
    'limit__name_max_site_builder' => '通过 Presence Builder 发布网站',
    'plesk_key__wpb-multi-language-sites-support' => '在 Presence Builder 中支持多语言网站',

    'ui__client/domain/traffic-hosting__title' => '<b>%1</b> 的数据传输统计',
    'ui__client/domain/traffic-hosting__title_powerUser' => '<b>%1</b> 的数据传输统计',
    'ui__client/domain/traffic-hosting#list__title' => "按服务进行数据传输",

    'login_up__access_denied_no_subscriptions' => "拒绝访问。此帐户无可用订阅。",

    'interval__day' => '%1日',
    'interval__hour' => '%1小时',
    'interval__minute' => '%1分钟',
    'interval__second' => '%1秒',

    ///License options
    'plesk_key__backward_incompatibility' => '您正在尝试使用为其它 Plesk 版本创建的许可证密钥。请联系 Plesk 销售代表获取正确的许可证密钥。',
    //Standalone or virtualization
    'virtualization_any' => "物理服务器或任何虚拟化解决方案",
    'virtualization_pvc' => "Virtuozzo 容器",
    'virtualization_vmware' => "VMWare",
    'virtualization_hyperv' => "Microsoft Hyper-V",
    'virtualization_xen' => "Xen",
    'virtualization_kvm' => "KVM",
    'virtualization_parallels_server' => "Virtuozzo Server",
    'plesk_key__virtualization' => "对下列环境进行验证:",
    'plesk_key__virtualization_only_key' => '此许可证密钥仅适用于在 %1 虚拟环境中操作 Plesk 。',
    'plesk_key__virtualizations_only_key' => '此许可证密钥仅适用于在下列虚拟环境中操作 Plesk：%1.',
    //Language options
    'plesk_key__invalid_locale_signature' => '禁止使用自定义语言包。',
    'plesk_key__allowed-locales' => '可用语言',
    'plesk_key__allowed-locales-any' => '任意语言',

    /// Web hosting settings on domain/subdomain

    '__cgi_bin_mode' => 'cgi-bin目录位于',
    '_cgi_bin_mode_webspace' => '订阅的根目录',
    '_cgi_bin_mode_www_root' => '此域名的文档根目录',

    ///ODBC DSN data sources
    'ui__server/odbc/dsn/properties_unknown-new__short-title' => '添加 ODBC DSN',
    'ui__server/odbc/dsn/properties_unknown-new__description' => '添加ODBC数据源。',
    'ui__server/odbc/dsn/delete_multi__short-title' => '移除',
    'ui__server/odbc/dsn/delete_multi__title' => '确认移除',
    'ui__server/odbc/dsn/delete_multi__description' => '移除所选ODBC DSN数据源。',
    'ui__server/odbc/dsn/delete#legend__description' => '即将移除下列ODBC DSN连线:',
    'ui__server/odbc/dsn/delete__empty_selection' => '未选择ODBC DSN连线。',
    'ui__server/odbc/dsn/delete_multi__done' => '已移除所选数据源。',
    'ui__server/odbc/dsn__title' => 'ODBC DSN连线%1',

    'ui__client/domain/odbc/dsn/properties_new__short-title' => '添加 ODBC DSN',
    'ui__client/domain/odbc/dsn/properties_new__description' => '添加ODBC数据源。',
    'ui__client/domain/odbc/dsn/delete_multi__short-title' => '移除',
    'ui__client/domain/odbc/dsn/delete_multi__title' => '确认移除',
    'ui__client/domain/odbc/dsn/delete_multi__description' => '移除所选ODBC DSN数据源。',
    'ui__client/domain/odbc/dsn/delete#legend__description' => '即将移除下列ODBC DSN连线:',
    'ui__client/domain/odbc/dsn/delete__empty_selection' => '未选择ODBC DSN连线。',
    'ui__client/domain/odbc/dsn/delete_multi__done' => '已移除所选数据源。',
    'ui__client/domain/odbc/dsn__title' => 'ODBC DSN连线%1',


    /// Custom buttons
    'custom_button__sort_key' => '优先级',
    'custom_button__place' => '位置',
    'custom_button__place_navigation' => '通用访问',
    'custom_button__place_admin' => '管理员首页',
    'custom_button__place_admin-settings' => '管理员的 工具与设置 页面',
    'custom_button__place_reseller' => "代理商首页",
    'custom_button__place_reseller-settings' => '代理商的 工具与实用程序 页面',
    'custom_button__place_client' => '客户首页',
    'custom_button__place_domain' => "订阅的 网站与域名 页面",
    'custom_button__place_domain_powerUser' => "订阅的 网站与域名 页面",
    'custom_button__place_domain-properties' => '网站工具',
    'custom_button__private' => '仅向我显示',
    'custom_button__image' => '背景图片',
    'custom_button__conhelp' => "工具提示文本",
    'custom_button__edit' => "其它服务的链接设置",
    'custom_button__include_client_cname' => "包含客户的公司名称",
    'custom_button__include_client_email' => "包含客户的电子邮箱",
    'custom_button__include_client_id' => "包含客户ID",
    'custom_button__include_client_pname' => "包含客户的联系名称",
    'custom_button__include_domain_id' => "包括订阅 ID、域名 ID 和域名别名 ID",
    'custom_button__include_domain_id_powerUser' => "包括订阅 ID、域名 ID 和域名别名 ID",

    'custom_button__include_domain_name' => "包括主域名",
    'custom_button__include_ftp_user' => "包含FTP用户名",
    'custom_button__include_ftp_pass' => "包含FTP密码",
    'custom_button__internal_open' => "在 Plesk 中打开 URL",
    'custom_button__text' => "按钮标签",
    'custom_button__url' => "URL",

    'custom_button__not_image' => '文件不是镜像文件。',
    'custom_button__big_image' => '文件大小不得超过 100 KB。',
    'custom_button__failed_copy_image' => '无法复制文件：%1',


    'backup__restore__cannot_restore_non_power_user_dump_in_power_user_mode' => '无法在高级用户视图下恢复非高级用户备份。',
    '__unknown_network_interface' => '未知网络接口',

    'init_conf__ip_address' => 'IP 地址',

    //Confirmation page
    'bt_confirm' => '确认',
    'b_confirm' => '确认网站所有者。',

    'performance__iss_app_pool_forced_by_site_isolation' => '独立IIS应用百宝箱的设置根据服务器级安全策略（网站隔离配置）而定。',
    'performance__iss_app_pool_forced_by_server_wide_settings' => '独立IIS应用百宝箱的设置根据服务器级性能设置而定。',

    '__current' => '当前',
    'ui__client/domain/hosting/web-directories/protection/user/properties__done' => '用户属性已更新。',



    //// New Promos Block

    'promo__you_are_about_to_exceed_license_limit_max_dom' => '您已几乎使用 Plesk 许可证提供所有的域名（90% 或更多）。',
    'promo__you_are_about_to_exceed_license_limit_max_dom_title' => '您几乎使用了所有域名。',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder' => '您几乎使用了 Plesk 许可证提供的所有 Presence Builder 网站（90% 或甚至更多）。',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder_title' => '您几乎使用了所有 Presence Builder 网站。',
    'promo__button_hide' => '隐藏',
    'promo__button_next' => '下一个 >>',
    'promo__button_prev' => '<< 前一个',
    'promo__button_license' => '更新许可证',

    'promo__google_integration_title' => '与 Google 服务集成',
    'promo__google_integration' => '配置与 Google 服务集成，如 AdSense、Google Apps 与网站管理员工具。',
    'promo__google_integration_button' => '配置',

    'promo__button_learn_more' => '了解更多',

    //// Plesk Branding in 10.1
    'panel_branding__description' => '您可以通过自定义方案定制化界面外观并优化设置。欲了解自定义 Plesk 主题的说明，请参阅 %1。',
    'panel_branding__description_link' => '下面文档',

    ///// File Manager new buttons
    'bt_extract_archive' => '解压文件',
    'b_filemanager__extract' => '从所选的文档里提取文件到现有目录。注意如果文件名包含公共通用字符，在提取后文件名将不正常显示。',
    'filemanager_error_extracting_files' => '解压压缩文件时出现错误：%1',
    'filemanager_no_archive_files_specified' => '指定您要提取的文档。',
    'filemanager_not_zip_archive_specified' => '%1 无法提取，不是 ZIP 文档。',
    'filemanager_files_successfully_extracted' => '压缩文件已被解压。',
    'filemanager_error_file_download' => '下载文件失败：%1',
    'filemanager__user_poolgrp' => '应用程序池群组',

    'loading' => '正在加载...',
    'bt_create_archive' => '添加到压缩文件',
    'filemanager__pack' => "进入压缩文件的路径：%1",
    'filemanager__archive_name' => '压缩文件名',
    'filemanager__empty_filename' => '请输入压缩文件名。',
    'filemanager_archive_created' => '已成功创建压缩文件。',
    'filemanager_error_creating_archive' => '无法创建压缩文件：%1',

    'cmd_dns__aaaa_dns_record_already_exist' => "该记录将会与用于区域的 AAAA 记录相冲突。",
    'defaultcomponents__ftp_ipv6_hosting_not_supported' => "（FTP 服务器不支持 IPv6 地址。）",
    'cmd_dns__glue_dns_record_conflict' => '该记录将会与 \'%1\'区域的粘附 (glue record) 记录相冲突。',
    '__ftp_ipv6_not_supported' => "（FTP 服务器不支持 IPv6 地址。）",
    '__ipv6_not_supported' => '不支持 IPv6。',
    'mail__ipv6_not_supported' => '邮件服务器不支持 IPv6。',
    'mail__relay_while_list_ipv6_not_supported' => '邮件服务器不支持 IPv6 中继白名单。',
    'mail__relay_while_list_ipv6_mask_mul_16' => '设置值必须为 16 的倍数。',
    'mail__ip_or_mask_is_invalid' => 'IP地址/网络掩码无效。',
    'nonexistent_mail__redirect_ipv6_not_supported' => '不支持转发到 IPv6 IP 地址。',
    'sa__invalid_trusted_networks' => '不正确指定的信任网络：%1',
    'dns_add__enter_ipv6_address' => "IPv6 地址",
    'license_trial_days_left' => '您的 Plesk 正使用一个试用许可证进行操作，该许可证将在 %1 天后到期。',
    'excl_ipv6_num' => '独立 IPv6 地址',
    '__ip_mask' => "子网掩码",
    '__ipv4_addr' => 'IPv4 地址',
    '__ipv6_addr' => 'IPv6 地址',
    'template__num_excl_ipv6s' => '分配独立 IPv6 地址给代理商',
    'anonftp__exclusive_ipv4_required' => '需要独立的 IPv4 地址以创建并使用匿名 FTP 服务。',
    'anonftp__ipv4_already_used' => '您无法为此网站创建匿名 FTP 服务因为已在其他域名的同一 IPv4 地址上配置过。',


    'restart__kav' => "Kaspersky Antivirus",
    '__view_migration_log_detailed_info' => '查看日志',

    'chown__ip_address_warn' => '把订阅移动给新的所有者之前，您必须选择该订阅的新 IP 地址。',
    'chown__no_ip_address' => '无',
    'chown__no_ipv4_address' => '无 IPv4 地址',
    'chown__no_ipv6_address' => '无 IPv6 地址',
    'chown__domain_exclude_already_owned_by_client' => '此订阅 %1 已属于该用户。',
    'chown__error_ip_absent_in_ip_pool' => '在目标用户 IP 池里不显示 IP 地址 %1。',
    'chown__error_ip_not_exist' => 'ID 为 \'%1\' 的 IP 地址不存在。',
    'chown__error_domain_ip_not_selected' => '至少应该为域名 %1 选择一个 IP 地址。查看 IP 映射所选择的值。',

    '__new_passwd_single' => "密码",
    '__confirm_passwd_single' => "确认密码",

    'mail__ip_or_mask_is_invalid_ipv6' => 'IPv6 地址或掩码无效：IP 地址应为有效的单播地址。',

    '__subscriptions' => '订阅',

    '__owned_by_reseller' => '代理商所有',
    '__owned_by_provider' => '供应商所有',

    'service_plan__anonymous' => '自定义',
    'subscription_not_locked__change_limits_warning' => '此订阅未锁定：在与服务方案同步时此资源使用上限将被更改。',
    'subscription_not_locked__change_permissions_warning' => '此订阅未锁定：在与服务方案同步时此权限将被更改。',

    'subscription__conflict_resolution_policy' => '冲突解决策略',
    'subscription__conflict_resolution_policy_lock' => "锁定订阅",

    'backup__list__backup_warnings' => '警告',
    'backup__list__backup_info' => '信息',
    'backup__restore__object_reseller_template' => '代理商模板',
    'backup__restore__object_domain_template' => '域名模板',

    'ui__client/permissions_readonly__title' => '权限',
    'ui__client/permissions_readonly__short-title' => '权限',

    'subscription__unable_lock_anonymous' => '此订阅未与服务方案绑定，因此无法解锁。',
    'subscription__unable_sync_anonymous' => '此订阅未与服务方案绑定，因此无法同步。',
    'subscription__unable_sync_locked' => '此订阅被锁定，因此不能同步。',
    'subscription__locked' => '此订阅已被锁定。',
    'component_name__urlrewrite' => "URL 重写",
    '__quantity' => '数量',
    'hst__www_root_dir_absent' =>  '警告：指定作为文档根目录的目录不存在。',
    'object_creation__domain_is_not_a_webspace' => '只能在订阅里创建此对象。',
    'phosting__webspace_hosting_with_sites_cannot_be_deleted' => '订阅包含站点，因此，您无法更改主机类型或移除主机类型。',
    'phosting__addon_domain_ip_must_match_webspace' => '错误：更新 IP 地址失败。不能将未分配给订阅主域名的 IP 地址分配给附加域名。',
    'domain_plan__unable_change' => '无法更改服务方案：%1。',
    'domain_plan__different_hosting_type' => '当前托管类型不同于在服务方案里指定的类型。',
    'domain_plan__addon_text' => '附加方案',
    'domain_plan__addon_description' => '附加方案用于补充主机方案。',
    'asp_net__managed_runtime_version' => 'ASP.NET managed runtime version',
    'plan__can_not_change_hosting_type' => '在编辑方案时无法更改托管类型。',
    'plan__apply_problems' => '因下列功能问题导致未应用方案： %1',
    'plan_save__subscription_update_problem' => '无法在 %1 里应用方案更改。',
    '__perm_denied_subscription_suspended_by_backuprestore' => "在备份或恢复过程完成前订阅暂时挂起。之后请返回。",
    '__login_incorrect_plain_shadow_password' => '您指定的管理员帐户的密码不正确。请使用系统管理员（root）认证，或者获取正确的密码。若要了解获取密码的更多信息，可参阅文件 /etc/psa/README.psa.shadow。',

    '__perm_denied_ip' => '您无法发送不属于您的 IP 地址',

    'dns__dns_zone_not_synchronized' => '已修改 DNS 区域。如果您想要在该区域应用 DNS 模板修改，可在该页面单击 \'应用 DNS 模板更改\' 按钮或进入服务器管理面板 > 工具与设置 > DNS 模板设置 > 应用 DNS 模板更改 选择 \'应用修改到所有区域\' 选项。',
    'dns__dns_zone_synchronize_link' => '单击',
    'dns__dns_zone_synchronize_done' => 'DNS 区已成功同步。',

    'dns__dns_zone_template_error' => '同步 DNS 区域和 DNS 区域模板时出现问题。%1',

    'dns__soa_rname_type_owner' => '网站所有者的邮箱地址',
    'dns__soa_rname_type_domain' => '域名電子電郵地址',
    'dns__soa_rname_type_external' => '外部邮箱地址',
    'dns__soa_rname_enforce_email' => '禁止单独为每个域名更改 RNAME 电子邮箱地址',
    'dns__soa_rname_label' => '電子郵件（RNAME）',
    'dns__soa_rname_hint' => '负责域名 DNS 区域的人的电子邮箱地址。由 DNS 服务器响应 SOA 查询返回。',

    'dns__dns_zone_soa_sync_title' => '覆盖所有现有域名的SOA设置',
    'dns__dns_zone_soa_sync_legend' => '需要确认',
    'dns__dns_zone_soa_sync_text' => '通过应用对 SOA 模板所做的更改来更新所有托管域名的 SOA 记录？',

    'cu_db__repair_mysql_dbus' => "修改 MySQL 用户密码。如果您从以前的版本升级至 Plesk 11 时需要进行此操作。",

    'scheduled_backup_settings__start_at_hint' => '预订备份任务每隔 15 分钟检查一次。如果您想要 Plesk 在某个特定时间开始备份处理，需在该时间至少 15 分钟之前安排好。',
    'cu_scheduled_backup_comment' => '计划的备份',
    'cu_scheduled_backup_error' => '在备份过程中出现一个错误：%1',
    'cu_scheduled_backup_mail_subject' => '<%1> 在计划备份过程中出现了一个错误。',
    'cu_scheduled_backup_mail_message' => "%1\nPlesk 入口点：%2\n\n在计划备份过程中发生了以下错误：\n\n%3",
    'cu_scheduled_backup_comment_backup_all' => '计划备份。所有配置和内容。',
    'cu_scheduled_backup_comment_backup_vhost' => '计划备份。所有配置和除邮件之外的内容。',
    'cu_scheduled_backup_comment_backup_mail' => '计划备份。仅邮件配置和内容。',
    'cu_scheduled_backup_comment_backup_domain' => '计划备份。域名配置。',
    'cu_scheduled_backup_to_cloud_not_allowed' => '在远程云存储中存储计划备份是一项高级功能。请联系您的主机提供商以将其解锁。',

    'i_backup_invalid_file' => '这是无效备份。不能从该文件恢复数据。单击该备份名了解详情。',

    'ui__server/migration/download-agent__short-title' => '下载 迁移与传输代理',
    'ui__server/migration/download-agent__title' => '下载 迁移与传输代理',
    'ui__server/migration/download-agent__description' => '从 Plesk 网站上下载最新版本的 迁移与传输代理。',

    'filemanager_resulting_archive_exists' => '目标目录里已经存在文件 %1。',

    'agent_unable_to_connect' => '无法连接在 \'%2\' 上的代理。请确保已经安装并正在运行代理，而且主机 \'%2\' 没有连接问题。',
    'agent_test_connection_failed' => '连接 \'%2\' 上的代理失败。',

    'agent_unable_to_resolve_host' => '无法找到远程主机 \'%1\'。请确保该主机没有任何连接问题。',
    'agent_unknown_curl_error' => '连接 \'%2\' 上的代理过程中出现错误 \'%1\' .',
    'agent_unexpected_htp_code' => '对 \'%2\' 上的代理进行 HTTP 请求时出现意外的 HTTP 代码 \'%1\'。',
    'agent_unable_to_auth' => '无法在主机 \'%1\' 上验证。要解决该问题，请根据该知识库文章的说明操作：http://kb.plesk.com/116606。',
    'agent_internal_server_error' => '在远程主机 \'%1\' 上执行指令的过程中出现内部服务器错误。',
    'agent_response_is_empty' => '对 \'%1\' 上的代理进行 HTTP 请求时出现空的反应。',

    'migration__disabled_due_to_local_file_does_not_exist' => '在本地缓存中无法找到迁移与传输代理。请再次打开 迁移与传输管理器 修正该问题。',

    '__hosting_webdeploy' => "Web Deploy 发布",
    'cu_domain__webdeploy' => "Web Deploy 发布（默认：%1）",
    'cu_dom_tpl__webdeploy' => "Web Deploy 发布（默认：%1）",
    'cu_subdomain__webdeploy' => "Web Deploy 发布（默认：%1）",
    'webdeploy__not_installed' => "Microsoft Web 部署没有安装在服务器上",
    'webdeploy__forced_by_site_isolation' => "无法更改 Web Deploy 发布设置：您没有权限覆盖服务器级安全策略。联系您提供商了解详情。",



    'backup__restore_options__admin__server_configuration_license' => '许可证密钥',
    'migration_start_migrate_server_license' => '转移许可证密钥',

    'defaultcomponents__delegation_rule_not_exist' => '（所需授权规则 \'appPoolPipeline, appPoolNetFx\' 不存在）',

    '__o' => 'O',

    'i_backup_created_by_admin' => '管理员已创建备份。',
    'i_backup_created_by_reseller' => '代理商已创建备份。',
    'i_backup_created_by_client' => '客户已创建备份。',

    'migration__object_exists_on_target_host' => '（在目标主机上已存在）',

    '__customers_total' => '全部按客户',
    '__resellers_total' => '全部按代理商',
    '__reseller_total' => '代理商总量',


    'cu__mailserver_update_webmail_command' => "指定您需要启用或禁用的 web 邮箱客户端",
    'cu__mailserver_webmail_state' => "指定选定的 web 邮箱客户端的状态（true 启用客户端，false 禁用客户端）",

    'cu_db_set_default_user' => '设置使用数据库的默认用户。该选项的命令：add_user, update_user',

    'cu_role__opt_subscription_name' => '仅允许用户指定的订阅',
    'cu_role__opt_for_all_subscription' => '允许用户可访问一个主机帐户中的所有订阅',
    'cu_role__subscription_not_found_role_is_not_limited' => '无法在此角色中应用更改：未找到订阅 %1 。',

    'cu_cl_pref__manage_website_maintenance' => '访问高级操作： 网站复制',
    'cu_cl_pref__manage_protected_dirs' => '管理有密码保护的目录',
    'cu_cl_pref__manage_mail_settings' => '允许更改邮件设置',


    'cu__command_update_php_settings' => '更新 PHP 设置。',
    'cu__php_settings_option' => '设置可进入带有 PHP 设置的文件的路径。',

    'cu__additional_php_settings_option' => '设置可进入带有其它 PHP 指令的文件的路径。',
    'cu__command_show_php_settings' => '显示当前的 PHP 设置。',
    'cu__general_settings' => '常规设置：',
    'cu__performance_settings' => '性能设置：',
    'cu__php_fpm_settings' => 'PHP-FPM 设置：',
    'cu__additional_directives' => '其它指令：',

    'b_filemanager__pack' => '添加所选的文件到压缩文件。',

    'php_settings_permission_required' => '常用 PHP 设置管理',
    'php_settings_performance_permission_required' => '主机性能设置管理',
    'php_settings_customized' => 'PHP 设置已定制化。',
    'php_settings_synchronized_with_plan' => 'PHP 设置必须与方案同步。',
    'phosting__unknown_shell_type' => '无效的 shell',

    'login_up__access_denied_subscription_deleted' => '访问被拒绝：您的订阅已移除。',

    'role_restricted_to_subscription' => '（与订阅一起传输：%1)',

    'filemanager__extract' => "提取文件至：%1",

    'cu__license_command_check_installed_license' => '查看已安装的许可证的有效性（如果密钥有效返回 0 推出代码，如果密钥无效则返回 1）',

    'promo__mobile_manager_title' => 'Plesk Server Mobile Manager',
    'promo__mobile_manager' => "扩展 Plesk 功能以通过移动设备（BlackBerry、iPhone 与 Android）控制与监控服务器。",
    'promo__mobile_monitor_title' => 'Plesk Server Mobile Monitor',
    'promo__mobile_monitor' => '可通过移动设备（BlackBerry、iPhone 与 Android）随时随地获得有关 Plesk 服务器最重要的信息。',
    'promo__mobile_button' => '了解更多',

    'ui__server/migration/video__short-title' => '视频教程',
    'ui__server/migration/video__title' => '观看视频教程',
    'ui__server/migration/video__description' => '观看视频教程。',

    'subDomainNameHint' => '输入 * 作为子域名以创建一个通配符子域。不管网站访客在浏览器中输入什么子域名都将被重导向该子域。',
    'subdomains__wildcard_name_invalid' => "子域名无效。通配符子域名只能包含字母数字、连字符 (-) 和星号 (*)。",
    'subdomains__name_invalid' => "子域名无效。子域名只能包含字母数字和连字符 (-)。",

    'domain__wildcard_no_www_prefix' => '通配符子域名不能使用 www 前缀。',

    '__service_title__milter' => "Plesk 后缀过滤器",
    '__service_description__milter' => "Plesk 后缀邮件过滤器",
    '__milter' => "后缀过滤器",
    'restart__milter' => "Plesk 邮件过滤器（%1）",
    'restart__pop3' => "Courier POP3 服务器",
    'restart__pop3s' => "带有 SSL/TLS 支持的 Courier POP3 服务器",
    'restart__imap' => "Courier IMAP 服务器",
    'restart__imaps' => "带有 SSL/TLS 支持的 Courier IMAP 服务器",
    'restart__authdaemon' => "Courier IMAP 验证守护进程",
    'restart__imap-pop3' => "Dovecot IMAP 和 POP3 服务器",


    'addon_packages_not_supported' => '不支持用于 APS 打包的 web 应用程序的附件。',
    'cu_domain__unable_to_automaticaly_select_ip' => '无法自动分配 IP 地址给域名。请使用 -ip 选项指定一个 IP 地址。',

    'plesk_key__mb_accounts' => 'Customer and Business Manager 中的用户帐户（代理商与客户）',

    'actionlog__subdomain_dns' => '子域名 DNS 区域',
    'actionlog__site_subdomain_dns' => '其它域名下子域名的 DNS 区域',

    // PfW only
    'actionlog__event_site_create' => '已创建域名',
    'actionlog__event_site_delete' => '已删除的域名',
    'actionlog__event_site_update' => '已更新的域名',

    'actionlog__event_site_status_update' => '已更新的域名状态',
    'actionlog__event_site_dns_update' => '已更新的域名 DNS 区域',
    'actionlog__event_site_guid_update' => '已更新的域名 GUID',

    'actionlog__event_site_subdomain_create' => '已创建子域名',
    'actionlog__event_site_subdomain_delete' => '已删除的子域名',
    'actionlog__event_site_subdomain_update' => '已更新的子域名',

    'actionlog__event_site_alias_create' => '已创建域名别名',
    'actionlog__event_site_alias_delete' => '已删除的域名别名',
    'actionlog__event_site_alias_update' => '已更新的域名别名',

    'actionlog__event_site_alias_dns_update' => '已更新域名别名的 DNS 区域',
    'actionlog__event_subdomain_dns_update' => '默认域名下子域名的 DNS 区域已更新',
    'actionlog__event_site_subdomain_dns_update' => '已更新子域名的 DNS 区域',
    // End of PfW only

    'win_policy__bad_password' => '验证失败。密码无效。',
    'win_policy__password_too_short' => '验证失败。密码太短，不符合密码策略要求。',
    'win_policy__password_too_long' => '验证失败。密码太长，不符合密码策略要求。',
    'win_policy__password_not_complex_enough' => '验证失败。密码不够复杂且不符合服务器策略要求。强密码必须至少包含以下所有项：八个字符；一个大写或小写字符；三个数字和一个特殊字符（!、@、#、$、%、^、&、*、?、 _、~）或一个数字和两个特殊字符。',

    //// Activation Code feature
    'plesk_key__license_update_failed' => '无法更新产品许可证。',


    'filemanager__error_path_is_not_allowed' => '路径不被允许',
    'filemanager__error_path_is_invalid' => '路径无效',
    'filemanager__error_path_not_found' => '路径未找到',
    'filemanager__error_path_already_exists' => '路径已存在',
    'filemanager__error_access_is_denied' => '访问被拒绝',
    'filemanager__error_directory_not_empty' => '文件夹不为空',
    'filemanager__error_sharing_violation' => '共享冲突',
    'filemanager__error_not_same_device' => '目的路径不在同一设备上',
    'filemanager__binary_data_access' => '该文件可能是二进制文件。您想要打开它吗？',
    'filemanager__unable_to_resolve_realpath' => "无法在特定的位置找到 %1 文件",
    'filemanager__access_to_realpath_denied' => "访问 realpath 被拒：%1 到 %2。",
    'bt_exit' => '退出',

    'filemanager__chdir_error__' => "无法更改目录为 %1：%2。",
    'filemanager__chmod_dir' => "更改目录 %1 的权限",
    'filemanager__chmod_error__' => "无法更改文件 %1 的权限：%2。",
    'filemanager__chmod_file' => "更改文件 %1 的权限",
    'filemanager__copy_error__' => "无法复制 %1 到 %2：%3。",
    'filemanager__copy_move' => "从 %1 处复制 (移动) 文件。",
    'filemanager__count_size__' => '所选项大小：%1',
    'filemanager__count_size_error__' => '无法计算 %1 的大小：%2。',
    'filemanager__create_dir' => "目录创建",
    'filemanager__create_dir_error__' => "无法创建目录 %1：%2。",
    'filemanager__dir_not_exists' => "目录 %1 不存在。",
    'filemanager__dirname' => "目录名称",
    'filemanager__filename' => "文件名称",
    'filemanager__is_no_such' => "不存在带有名称 %1 的文件或目录。",
    'filemanager__empty_selection' => "没有选定的文件。",
    'filemanager__file_exists' => "文件 %1 已存在。",
    'filemanager__move_error__' => "无法移动 %1 到 %2：%3。",
    'filemanager__new_dir' => "目录名称",
    'filemanager__not_allowed' => "不允许更改此文件。",
    'filemanager__r_perm_dir' => "列出目录",
    'filemanager__r_perm_file' => "读取数据",
    'filemanager__remove' => "从 %1 中删除文件。",
    'filemanager__remove_error__' => "无法删除文件 %1：%2。",
    'filemanager__rename_dir' => "重命名目录 %1",
    'filemanager__rename_error__' => "无法重命名 %1 为 %2：%3。",
    'filemanager__rename_file' => "重命名文件 %1",
    'filemanager__set_win_permissions_dir' => "设置 %1 文件夹的权限",
    'filemanager__set_win_permissions_file' => "设置 %1 文件的权限",
    'filemanager__touch_confirm' => "您确定要更改所选文件的时间戳吗？",
    'filemanager__no_perms_or_unsupported_file_type' => '无法读取文件或者文件格式不受支持。',
    'filemanager__upload_error__' => "无法上传 %1 到 %2：%3。",
    'filemanager__upload_file' => "上传文件",
    'filemanager__upload_file_src' => "文件路径",
    'filemanager__username' => "用户",
    'filemanager__w_perm_dir' => "创建文件",
    'filemanager__w_perm_file' => "写入数据",
    'filemanager__x_perm_dir' => "遍历目录",
    'filemanager__x_perm_file' => "执行文件",
    'filemanager__max_image_size_exceeded' => '无法显示图像。图像大小不能大于 %2 字节',

    '__fastcgi_unix_support' => 'FastCGI 支持',

    'ts_sessions_list' => '此页面显示了 终端服务 会话列表。',
    'b_tssessionslist_search' => '按名称搜索会话。',
    'b_tssessionslist_show_all' => '显示所有终端服务会话。',
    'l_tssessionslist_state' => '按状态进行排序。',
    'l_tssessionslist_name' => '按名称进行排序。',
    'l_tssessionslist_user' => '按用户进行排序。',
    'b_tssessionslist_logoff' => '单击注销所选会话。',
    'b_tssessionslist_disconnect' => '单击断开连接所选会话。',
    'tssessions_info' => '查看会话属性。',
    'tssessions_disconnect' => '选中确认删除复选框，然后单击“确定”断开连接所选的终端服务器会话。',
    'tssessions_logoff' => '选择确认删除选项框并单击确定退出选中的终端服务器会话。',
    'b_tssession_disconnect_submit' => '单击提交更改。',
    'b_tssession_logoff' => '单击注销会话。',
    'b_tssession_logoff_submit' => '单击提交更改。',
    'i_tssession_active' => '活动',
    'i_tssession_connected' => '已连接',
    'i_tssession_disconnected' => '已断开连接',
    'i_tssession_listen' => '监听',
    'tssessions__tssessionslist' => '会话',
    'tssessionslist__state' => 'S',
    'tssessionslist__name' => '名称',
    'tssessionslist__user' => '用户',
    'bt_logoff_selected' => '注销',
    'bt_logoff' => "注销",
    'bt_disconnect_selected' => '断开连接',
    'bt_tssession_logoff' => '注销',
    'bt_tssession_disconnect' => '断开连接',
    'bt_tssession_disconect' => '断开连接',
    'b_tssession_disconnect' => '单击断开连接会话。',
    'b_tssession_logoff_disabled' => '无法注销该会话。',
    'b_tssession_disconnect_disabled' => '无法断开连接该会话。',
    'tssessions_info__title' => '会话 %1 属性',
    'tssessions_info__property_name' => '属性名',
    'tssessions_info__property_value' => '属性值',
    'tssessions__disconnect_title' => '将断开连接下列终端服务会话：',
    'tssessions__session_cant_disconnect' => '无法断开连接会话',
    'tssessions__logoff_title' => '下列终端服务器会话将被注销：',
    'tssessions__session_cant_logoff' => '不能注销会话',
    'tssessions__select_sessions_to_logoff' => '请选择要注销的会话。',
    'tssessions__select_sessions_to_disconnect' => '请选择要断开连接的会话。',
    'dns__subdomain_dns_zone_parent' => '此子域名的 DNS 区域存储于父 DNS 区域中。您可修改父区域 %1 或为该子域名单独创建一个区域。',
    'dns__subdomain_dns_zone_parent_link' => '此处',
    'dns__no_dns_zone' => '未通过域名分配 DNS 区域。要管理域名的 DNS 区域您应按下 \'恢复默认\' 按钮。',
    'dns__unable_turn_on_subdomain_zone' => '无法打开子域名的区域因为在该子域名的父级域名区域中存在该子域名的 CNAME 记录。',

    '__hosting_write_modify' => '其他写入/修改权限',


    'aspdotnet__title' => "ASP.NET 配置",
    'aspdotnet__dom_title' => "网站的ASP.NET配置",
    'aspdotnet__wdir_title' => "虚拟目录 %1 的 ASP.NET 配置",
    'aspdotnet__group_cas_settings' => "代码访问安全性",
    'aspdotnet__group_client_scripts' => "脚本库设置",
    'aspdotnet__group_conn_strings' => "连接字符串管理器",
    'aspdotnet__group_custom_errors' => "自定义错误设置",
    'aspdotnet__group_framework_version' => "Framework 版本",
    'aspdotnet__group_globalization' => "全局设置",
    'aspdotnet__group_other' => "会话设置",
    'aspdotnet__group_page_and_runtime' => "编译和调试",
    'aspdotnet__invalid_dom_config_file' => "此网站的 ASP.NET 配置文件已损坏。要恢复该文件，请点击 设置为默认值 来应用服务器默认的 ASP.NET 配置。",
    'aspdotnet__invalid_file_enc' => "无效的文件编码参数值。",
    'aspdotnet__invalid_req_enc' => "无效的请求编码参数值。",
    'aspdotnet__invalid_res_enc' => "无效的响应编码参数值。",
    'aspdotnet__invalid_parent_wdir_config_file' => "ASP.NET 配置文件已损坏，因 %1 父目录的 ASP.NET 配置已损坏。\n若要解决此问题，请恢复 %1 ASP.NET 配置。",
    'aspdotnet__invalid_global_config_file_admin' => "ASP.NET配置已损坏，因服务器的ASP.NET配置文件已损坏。",
    'aspdotnet__invalid_global_config_file' => "ASP.NET配置已损坏，因服务器的ASP.NET配置文件已损坏。有关支持信息，请联系服务商寻求协助。",
    'aspdotnet__invalid_sess_timeout' => "无效的会话超时参数值。请输入一个不大于 %1 的正整数。",
    'aspdotnet__invalid_wdir_config_file' => "此虚拟目录的 ASP.NET 配置文件已损坏。若要恢复此配置文件，请单击“设置为默认值”以应用父级虚拟目录的 ASP.NET 配置。",
    'aspdotnet__param_auth_mode' => "验证模式",
    'aspdotnet__param_conn_strings' => "连接字符串",
    'aspdotnet__param_conn_string_name' => "名称",
    'aspdotnet__param_conn_string_value' => "连接参数",
    'aspdotnet__param_culture' => "区域性",
    'aspdotnet__param_custom_err_mode' => "自定义错误模式",
    'aspdotnet__param_custom_error_redirect' => "重定向 URL",
    'aspdotnet__param_custom_error_status' => "状态代码",
    'aspdotnet__param_custom_errors' => "自定义错误",
    'aspdotnet__param_debug_mode' => "启用调试",
    'aspdotnet__param_def_language' => "网页默认语言",
    'aspdotnet__param_temp_directory' => "临时目录",
    'aspdotnet__param_file_enc' => "文件编码",
    'aspdotnet__param_req_enc' => "请求编码",
    'aspdotnet__param_res_enc' => "响应编码",
    'aspdotnet__param_sess_timeout' => "会话超时(分钟)",
    'aspdotnet__param_trust_level' => "代码访问安全性 (CAS) 信任级别",
    'aspdotnet__param_ui_culture' => "UI 区域性",
    'aspdotnet__param_version' => "版本",
    'aspdotnet__param_trust_level_allow_override' => '允许为单个网站更改代码访问安全性 (CAS) 信任级别',
    'aspdotnet__restore_default_confirm' => "恢复默认的 ASP.NET 配置吗？",

    'bt_restore_default' => "重置",
    'b_aspdotnet' => '编辑 ASP.NET 配置。',
    'b_aspdotnet__restore_default' => '恢复默认的 ASP.NET 设置。',
    'b_aspdotnet__restore_wdir_default' => "恢复此虚拟目录的父级目录 ASP.NET 设置。",
    'b_aspdotnet__restore_default_disabled' => '无法恢复默认ASP.NET配置: 服务器或某个父级目录中的ASP.NET配置已损坏。',
    'b_autoinstaller' => '更新 Plesk 或其组件。',
    'b_autoinstaller_configure' => '更新设置。',
    'b_autoinstaller_install' => '安装所选组件。',

    '__iis_app_pool__use_dedicated' => '独立IIS应用程序池',
    '__iis_app_pool__use_dedicated_addons' => '每个网站使用独立 IIS 应用程序池',
    '__iis_app_pool__enable_32bit_app_on_win64' => '启用 32 位应用程序',
    'bt_iis_app_pool' => "IIS 应用程序池",

    'performance__cpu_usage' => '最大 CPU 使用率(%)',
    'performance__cpu_usage_action' => '限制操作',
    'performance__cpu_usage_interval' => '间隔设限（分钟）',
    'performance__cpu_usage_action_not_supported' => 'web 服务器不支持指定的操作。',

    'performance__idle_timeout_action_not_supported' => 'web 服务器不支持指定的闲置超时操作。',
    'performance__max_worker_processes' => 'worker 进程的最大数量',
    'performance__idle_timeout' => '闲置超时 (分钟)',
    'performance__idle_timeout_action' => '闲置超时操作',
    'performance__recycling_by_time' => '定时回收（分钟）',
    'performance__recycling_by_requests' => '当达到最大请求数量时回收',
    'performance__recycling_by_virtual_memory' => '当已使用虚拟内存最大容量时回收',
    'performance__recycling_by_private_memory' => '当已使用专用内存最大容量时回收',
    'performance__managed_pipeline_mode' => '托管管道模式',
    'performance__managed_pipeline_mode_not_supported' => 'web 服务器不支持指定的模式。',

    'iis_app_pool' => 'IIS 应用程序池管理。',
    'b_iis_app_pool' => '管理 IIS 应用程序池。',
    'iis_app_pool_cl_dom' => 'IIS 应用程序池管理',

    'i_webdirs_not_protected' => '目录未受保护。',
    'i_webdirs_protected' => '目录受保护。',
    'i_webdirs_manage_protection' => '管理保护。',
    'i_webdirs_open' => '在浏览器中打开目录/文件。',
    'i_webdirs_preferences_disabled' => '它不是虚拟目录。',
    'i_webdirs_permissions' => '管理权限。',
    'i_webdirs_permissions_disabled' => '目录权限管理不可用。',
    'i_webdirs_type_dir' => '物理目录',
    'i_webdirs_type_vdir' => '虚拟目录',
    'i_webdirs_browse' => '浏览目录内容。',
    'i_webdirs_preferences' => '网站目录设置管理。',

    'l_webdirslist_type' => '按类型对目录进行排序。',
    'l_webdirslist_protected' => '按保护状态对目录进行排序。',
    'l_webdirslist_name' => '按名称对目录进行排序。',

    'b_webdirslist_remove' => '删除所选虚拟目录。',
    'b_webdirslist_search' => '输入搜索模式，然后单击查找虚拟目录。',
    'b_webdirslist_show_all' => '显示所有目录。',

    'l_webdirerrordocslist_code' => '按错误号对错误文档进行排序。',
    'l_webdirerrordocslist_name' => '按描述对错误文档进行排序。',
    'l_webdirerrordocslist_type' => '按类型对错误文档进行排序。',
    'l_webdirerrordocslist_location' => '按位置对错误文档进行排序。',

    'b_webdirerrordocslist_search' => '输入搜索模式，然后单击查找错误文档。',
    'b_webdirerrordocslist_remove' => '删除所选的错误文档。',
    'b_webdirerrordocslist_show_all' => '显示所有错误文档。',

    'l_webdirmimetypeslist_name' => '按扩展名对 MIME 类型进行排序。',
    'l_webdirmimetypeslist_content' => '按内容对 MIME 类型进行排序。',

    'b_webdirmimetypeslist_remove' => '删除所选的 MIME 类型。',
    'b_webdirmimetypeslist_search' => '输入搜索模式并点击查找 MIME 类型。',
    'b_webdirmimetypeslist_show_all' => '显示所有 MIME 类型。',

    'b_webdir_preferences' => "虚拟目录设置。",
    'b_webdir_permissions' => "虚拟目录权限。",
    'b_webdir_permissions_disabled' => "虚拟目录权限管理不可用。",
    'b_to_webdirs' => '返回管理目录。',
    'b_to_webdir_mime_types' => '返回管理MIME类型。',
    'b_to_webdir_error_docs' => '返回管理错误页。',
    'b_to_webdir_protection' => '返回管理虚拟目录保护。',

    'webdirs__title' => '虚拟目录%1',
    'webdirs__preferences_title' => '虚拟目录设置',
    'webdirs__list_legend' => '虚拟目录',
    'webdirs__list_type' => 'T',
    'webdirs__list_protected' => 'P',
    'webdirs__list_name' => '名称',
    'webdirs__list_header' => '%1项目',
    'webdirs__tabs_general' => '常用',
    'webdirs__tabs_mime_types' => 'MIME类型',
    'webdirs__tabs_error_docs' => '错误文档',

    'webdirs__tabs_permissions' => '权限',
    'webdir__remove_vdirs' => '下列虚拟目录将被删除:',
    'webdir__remove_mime_types' => '下列 MIME 类型将被删除：',
    'webdir__mime_types_title' => 'MIME类型',
    'webdir__protection_disable_confirm' => '真的想删除目录保护吗？',
    'webdir__protect_title' => '受保护 URL 用户',
    'webdirs__permissions_title' => '虚拟目录权限',
    'webdirs__browse_content_permission_denied' => '您不具有浏览此目录内容的权限。',
    'error_doc__list_code' => '错误',
    'error_doc__list_code_description' => '描述',
    'error_doc__list_type' => '类型',
    'error_doc__list_location' => '位置',
    'error_doc__code' => '错误',
    'error_doc__type' => '类型',
    'error_doc__type_file' => '文件',
    'error_doc__type_url' => 'URL',
    'error_doc__location' => '位置',
    'error_doc__legend' => '错误文档',
    'error_doc__edit_title' => '编辑错误文档',
    'error_doc_erorr_invalid_url_location' => '该 URL 无效。请指定正确的 URL。',
    'error_doc_erorr_invalid_file_location' => '该文件路径无效。请指定正确的文件路径。',
    'error_doc__type_default' => '默认',

    'webdirs__tabs_protection' => '保护',
    'pb_webdirs' => '虚拟目录',

    'webdirs_remove_title' => '下列虚拟目录将被删除:',
    'webdirs_mime_types_remove_title' => '下列 MIME 类型将被删除：',
    'webdirs_preferences_title' => '虚拟目录设置',
    'webdirs_permissions_title' => '文件和文件夹特定权限',
    'webdi_protection_disable_confirm' => '您确定要删除虚拟目录保护吗？此操作也会删除所有受保护的目录用户和目录保护设置。',
    'bt_protect' => '保护',
    'bt_unprotect' => '取消保护',
    'bt_show_additional_users' => '显示更多用户',
    'bt_hide_additional_users' => '显示更少用户',
    'error_doc__list_title' => '错误文档',
    'error_doc__list_header' => '错误文档',
    'error_doc__code_400' => '错误的请求',
    'error_doc__code_401' => '未经授权',
    'error_doc__code_401.1' => '未经授权 - 登录失败',
    'error_doc__code_401.2' => '未经授权 - 由于服务器配置导致登录失败',
    'error_doc__code_401.3' => '未经授权 - 由于资源 ACL 导致无法授权',
    'error_doc__code_401.4' => '未经授权 - 由于过滤器导致授权失败',
    'error_doc__code_401.5' => '未经授权 - 由于 ISAPI/CGI 应用程序导致授权失败',
    'error_doc__code_401.7' => '未经授权 - 由于URL授权策略被拒绝',
    'error_doc__code_403' => '禁止',
    'error_doc__code_403.1' => '禁止 - 执行访问执行',
    'error_doc__code_403.2' => '禁止 - 读访问被拒绝',
    'error_doc__code_403.3' => '禁止 - 写访问被拒绝',
    'error_doc__code_403.4' => '禁止 - 需要 SSL',
    'error_doc__code_403.5' => '禁止 - 需要SSL 128',
    'error_doc__code_403.6' => '禁止 - IP 地址被拒绝',
    'error_doc__code_403.7' => '禁止 - 需要客户证书',
    'error_doc__code_403.8' => '禁止 - 访问网站被拒绝',
    'error_doc__code_403.9' => '禁止 - 用户太多',
    'error_doc__code_403.10' => '禁止 - 无效配置',
    'error_doc__code_403.11' => '禁止 - 密码更改',
    'error_doc__code_403.12' => '禁止 - Mapper访问被拒绝',
    'error_doc__code_403.13' => '禁止 - 客户证书已被吊销',
    'error_doc__code_403.14' => '禁止 - 列出目录被拒绝',
    'error_doc__code_403.15' => '禁止 - 超出客户访问许可权',
    'error_doc__code_403.16' => '禁止 - 客户证书不被信任或格式错误',
    'error_doc__code_403.17' => '禁止 - 客户证书已到期或无效',
    'error_doc__code_403.18' => '禁止 - 不能执行此应用程序池的请求',
    'error_doc__code_403.19' => '禁止 - CGI访问被拒绝',
    'error_doc__code_403.20' => '禁止 - Passport 登录失败',
    'error_doc__code_404' => '未找到',
    'error_doc__code_404.2' => '未找到 - 由于锁定策略而被拒绝',
    'error_doc__code_404.3' => '未找到 - 由于 MIMEMAP策略而被拒绝',
    'error_doc__code_405' => '方法不被允许',
    'error_doc__code_406' => '不接受',
    'error_doc__code_407' => '必要的代理验证',
    'error_doc__code_412' => '先决条件错误',
    'error_doc__code_414' => '请求URI太长',
    'error_doc__code_415' => '不支持的媒体类型',
    'error_doc__code_500' => '内部服务器错误',
    'error_doc__code_500.12' => '内部服务器错误 - 应用程序正在重启',
    'error_doc__code_500.13' => '内部服务器错误 - 服务器太忙',
    'error_doc__code_500.15' => '内部服务器错误 - 禁止直接请求GLOBAL.ASA',
    'error_doc__code_500.16' => '内部服务器错误 - UNC访问错误',
    'error_doc__code_500.17' => '内部服务器错误 - 未找到URL授权存储',
    'error_doc__code_500.18' => '内部服务器错误 - 无法打开URL授权存储',
    'error_doc__code_500.19' => '内部服务器错误 - 元数据文件损坏',
    'error_doc__code_500.100' => '内部服务器错误 - ASP错误',
    'error_doc__code_501' => '未执行',
    'error_doc__code_502' => '网关错误',
    'error_doc__code_503' => '服务暂时不能使用',

    'mimetype__extension' => '扩展名',
    'mimetype__content' => '内容',
    'mimetypeslist__title' => 'MIME类型',
    'mimetypes__title' => 'MIME类型',
    'mimetypes__select_to_remove' => '选择要移除的 MIME 类型。',
    'mimetypes__select_for_remove' => "选择要删除的 MIME 类型。",
    'mimetypes_remove__title' => '删除 MIMI 类型。',
    'mimetype__legend' => 'MIME 类型',
    'mimetype_edit__title' => '编辑 MIME 类型',
    'mimetype_edit__already_exists' => '已经为此扩展名定义了 MIME 类型。',
    'mimetype_edit__not_exists' => 'MIME 类型不存在。',
    'mimetype__content_type_other' => '自定义',

    'b_webdir_protection_enable' => '设置与有密码保护的目录相对应的 URL。',
    'b_webdir_protection_disable' => '指定所有人都可以访问目录对应的URL。',
    'b_webdir_protection_disabled' => '虚拟目录保护已禁用。',

    'b_pd_usr_create' => '单击创建此受保护 URL 用户。',
    'php__changeversion_title' => "选择PHP版本",
    'php__group_php_version' => "PHP版本",

    'virtualdir__name' => '名称',
    'virtualdir__path' => '路径',
    'virtualdir__read' => '读取权限',
    'virtualdir__read_short' => 'R',
    'virtualdir__write' => '写入权限',
    'virtualdir__write_short' => 'W',
    'virtualdir__source' => '脚本源访问',
    'virtualdir__source_short' => 'S',
    'virtualdir__browse' => '目录浏览',
    'virtualdir__browse_short' => 'B',
    'virtualdir__script_execute' => '执行权限',
    'virtualdir__script_execute_short' => 'E',
    'virtualdir__log_visits' => '日志访问',
    'virtualdir__app_create' => '创建应用程序',
    'virtualdir__app_create_short' => 'A',
    'virtualdir__auth_anon' => '启用匿名验证。',
    'virtualdir__auth_windows' => '启用 Windows 验证。',
    'virtualdir__auth_not_enabled' => '必须启用匿名或 Windows 验证。',
    'virtualdir__require_ssl' => '需要 SSL/TLS',
    'virtualdir__enable_default_doc' => '使用默认文档',
    'virtualdir__default_doc' => '默认文档搜索顺序',
    'virtualdir__enable_parent_paths' => '允许使用父路径',
    'virtualdir__execute_in_mta' => '允许应用程序在MTA(多线程单元)模式下运行',
    'virtualdir_create__title' => '在 %1 中创建虚拟目录',
    'virtualdir_edit__title' => '虚拟目录 %1 的属性',
    'virtualdir_edit__legend' => '虚拟目录',
    'virtualdir_edit__application_legend' => '应用程序设置',
    'virtualdir_edit__security_legend' => '目录安全性',
    'virtualdir_edit__documents_legend' => '文档',
    'virtualdir_edit__list_legend' => '嵌套的虚拟目录',
    'virtualdir_error__path_not_in__' => '指定的路径无效',
    'virtualdir_error__already_exists' => '相同名称的目录已经存在。',
    'virtualdir_root' => '虚拟目录',
    'virtualdir_root__title' => '虚拟目录',
    'virtualdir_root__list_legend' => '虚拟目录',
    'virtualdir_se__none' => '无',
    'virtualdir_se__script' => '仅脚本',
    'virtualdir_se__script_execute' => '脚本和可执行文件',
    'virtualdirs__title' => '虚拟目录',
    'virtualdirs__path_not_exists' => '无效路径。',
    'virtualdirs__select_for_remove' => "选择要删除的虚拟目录。",
    'virtualdirs_remove__title' => '删除虚拟目录',
    'virtualdirs_phys_dir_exist' => '相同名称的物理目录已经存在。如果继续，此目录将变成不可访问。您想要继续吗？',
    'virtualdir_auto_create_dir' => "创建与虚拟目录名称相同的物理目录",

    'asp_max_default_text' => '由主目录定义(%1 KB)',
    'asp_max_default_text_site' => '由IIS定义(%1 KB)',
    'asp_max_buffer_text' =>'ASP最大缓冲大小(KB)',
    'asp_max_body_text' => 'ASP请求邮件正文的最大容量 (KB)',
    'asp_buffers_legend' =>'ASP设置',

    'asp_debug_default_text' =>'由主目录定义',
    'asp_debug_default_text_site' =>'由IIS定义',
    'asp_client_debug_text' =>'启用 ASP 客户端脚本调试',
    'asp_server_debug_text' =>'启用 ASP 服务器端脚本调试',

    'webdirs__list_with_broken_dirs' => "有链接到不存在的物理文件夹虚拟目录。",
    'webdirs__vdir_physical_path_not_exist' => "该虚拟目录链接到不存在的物理文件夹。",
    'webdirs__physical_path_not_exist' => "指定的路径不存在。",

    'filemanager__new_dir_title' => '创建目录',
    'php__configuration_title' => "PHP配置",

    'permissions__title' => '设置访问权限',
    'permissions__title_advanced' => '设置高级访问权限',
    'permissions__inherit_from_parent' => '允许来自父级的可继承权限传播到此对象和所有子对象。包括此处明确定义的项目。',
    'permissions__replace_on_children' => '将所有子对象的权限项替换为此处显示的权限项。',
    'permissions__group_or_user_name' => '群组或用户名',
    'permissions__Permissions_for' => '权限主体',
    'permissions__allow' => '允许',
    'permissions__deny' => '拒绝',
    'permissions__FullControl' => '完全控制',
    'permissions__Modify' => '修改',
    'permissions__ReadAndExecute' => '读取和执行',
    'permissions__ListFolderContents' => '列出文件夹内容',
    'permissions__Read' => '读取',
    'permissions__Write' => '写入',
    'permissions__ReadControl' => '读取控制',
    'permissions__WriteControl' => '写入控制',
    'permissions__ExecuteControl' => '执行控制',
    'permissions__TraverseFolderOrExecuteFile' => '遍历文件夹 / 执行文件',
    'permissions__ListFolderOrRead' => '列出文件夹 / 读取数据',
    'permissions__CreateFilesOrWrite' => '创建文件 / 写入数据',
    'permissions__CreateFoldersOrAppend' => '创建文件 / 附加数据',
    'permissions__DeleteSubfoldersandFiles' => '删除子文件夹和文件',
    'permissions__Delete' => '删除',
    'permissions__ChangePermissions' => '更改权限',
    'permissions__TakeOwnership' => '获取所有权',
    'permissions__inherited_from' => '继承自',
    'permissions__not_inherited' => '<尚未继承>',
    'permissions__apply_to' => '应用到',
    'permissions__apply_onto' => '应用到:',
    'permissions__apply_onto1' => '仅此文件夹',
    'permissions__apply_onto2' => '仅子文件夹',
    'permissions__apply_onto3' => '此文件夹和子文件夹',
    'permissions__apply_onto4' => '仅文件',
    'permissions__apply_onto5' => '此文件夹和文件',
    'permissions__apply_onto6' => '仅子文件夹和文件',
    'permissions__apply_onto7' => '此文件夹、子文件夹和文件',

    'filemanager__not_allowed_dir' => "您不能更改此文件夹的权限。",

    'filemanager__allow' => "允许",
    'filemanager__deny' => "拒绝",
    'filemanager__user_domusr' => '网站管理员',
    'filemanager__user_webusr' => '网站用户',
    'filemanager__user_admins' => '管理员',
    'filemanager__user_system' => '系统',
    'filemanager__user_aspnet' => 'ASP.NET 用户',
    'filemanager__user_poolusr' => '应用程序池用户',
    'filemanager__user_sysaccount' => '其他系统用户',

    'bt_permissions_advanced' => '高级',
    'b_permissions_advanced' => '单击查看和设置特定权限。',

    'b_hotlinkprotection' => '为网站设置盗链防护。',
    'b_hotlinkprotection_on' => '启用网站内容的盗链防护功能。',
    'b_hotlinkprotection_off' => '禁用网站内容的盗链防护功能。',

    'bt_hotlinkprotection' => '盗链防护',
    'hotlinkprotection__title' =>'盗链防护',
    'hotlinkprotection__friend_domains' => '友好网站地址',
    'hotlinkprotection__extensions' => '受保护的文件扩展名',

    'hotlinkprotection_invalid_friend_domains' => '无效的友好域名',
    'hotlinkprotection_invalid_extensions' => '文件扩展名包含错误字符',

    'i_domain_alias_status_on' => '域名别名已启用。',
    'i_domain_alias_status_off' => '域名别名已禁用。',
    'i_domain_alias_status_with_parent' => '域名别名已禁用，因为该域名已关闭。',
    'i_domain_alias_turn_off' => '单击以禁用。',
    'i_domain_alias_turn_on' => '单击以启用。',
    'i_domain_alias_mail_on' => '已启用了该域名别名的邮件服务。',
    'i_domain_alias_mail_off' => '已禁用了该域名别名的邮件服务。',
    'i_domain_alias_mail_with_parent' => '域名别名已禁用，因为该域名已关闭。',
    'i_domain_alias_web_on' => '已启用了该域名别名的网站服务。',
    'i_domain_alias_web_off' => '已禁用了该域名别名的网站服务。',
    'i_domain_alias_web_with_parent' => '网站服务已禁用，因为该域名已关闭。',
    'i_domain_alias_dns_on' => '为此域名别名打开了 DNS 别名服务。',
    'i_domain_alias_dns_off' => '为此域名别名关闭了 DNS 别名服务。',
    'i_domain_alias_dns_with_parent' => '因域名别名已停用，从而无法对 DNS 和主域名进行同步。',
    'i_domain_alias_seoRedirect_on' => '为此域名别名打开了使用 HTTP 301 代码的重定向。',
    'i_domain_alias_seoRedirect_off' => '此域名别名关闭了使用 HTTP 301 代码的重定向',
    'i_domain_alias_seoRedirect_with_parent' => '关闭了使用 HTTP 301 代码的重定向因为关闭了域名别名。',

    'domain_alias__control_title' => '域名别名%1',
    'domain_alias__control_info_legend' => '信息',
    'domain_alias__control_status_title' => 'S',
    'domain_alias__control_name_title' => '服务名称',
    'domain_alias__control_details_title' => '详情',

    'domain_alias__invalid_values' => '您指定的域名无效。域名可由字母、数字和连字符组成。点号之间的每部分域名不得长于 63 个字符。',
    'domain_alias__domain_already_exists' => "域名别名 %1 不正确的名称。已经存在域名 %1。",
    'domain_alias__www_prefix_domain_already_exists' => "域名别名 www.%1 不正确的名称。已为域名 %1 创建了该别名。",
    'domain_alias__webmail_enabled_domain_already_exists' => '域名别名 web 邮箱的名称不正确。%1。已经为域名 %1 创建了该别名。',
    'domain_alias__lists_enabled_domain_already_exists' => '域名别名列表的名称不正确。%1。已经为域名 %1 创建了该别名。',
    'domain_alias__dns_record_already_exists' => '无法设置域名别名 %1 因为指向主机 %1 的 DNS 记录已存在。',
    'domain_alias__domain_alias_already_exists' => "相同名称的域名别名已经存在。",
    'domain_aliases__mail_server_not_support_aliases' => '邮件服务器不支持域名别名功能。域名别名可能无法正常运行。',
    'domain_alias__restrict_domain_creation' => '服务器级的策略禁止为域名别名指定名称。如果该域名别名属于您，请联系您的主机提供商。',
    'domain_alias__restrict_creation_with_www' => '请输入没有带 \'www\' 前缀的域名。域名的 www 前缀将会自动被添加到 web 服务器配置。',
    'domain_unable_to_set_name' => '不正确的名称 %1。',

    'domain_alias__domain_service_dns_disabled' => '该域名由其它的 DNS 服务器管理。',
    'domain_alias__domain_service_dns_enabled_master' => '该 DNS 服务器作为其 DNS 区域的主域名服务器。',
    'domain_alias__domain_service_dns_enabled_slave' => '该 DNS 服务器作为其 DNS 区域的从属域名服务器。',
    'domain_alias__domain_service_mail_enabled' => '已为该域名启用邮件服务。',
    'domain_alias__domain_service_mail_disabled' => '已为该域名关闭了邮件服务。',
    'domain_alias__domain_service_mail_mx' => '%1 用作邮件服务器。',

    'domain_alias__service_seoRedirect_hint' => '当访客打开别名的 URL，他们将会被重定向至主域名的 URL。Plesk 会使用搜索引擎友好 HTTP 301 重定向，这表示搜索引擎排名将不会在两个 URL 之间分割。',

    'bt_task_run_now' => '现在运行',
    'ftp__read_perm' => "读取权限",
    'ftp__write_perm' => "写入权限",

    'filemanager__upload_backup_file_hint' => '在此处您可上传备份文件到 Plesk 存储。最大文件容量限于 2 GB。',

    '__default_for_mssql' => 'MS SQL 默认使用',

    '__login_does_not_pass_validation' => "该用户名无效。请确定用户名符合以下要求：%1",
    '__login_allowed_symbols' => '只允许使用包括点号、破折号与下划线的字母数字字符。首字符应为字母数字。',

    'restart__nginx' => '反向代理服务器（nginx）',
    'restart__php-fpm' => 'PHP-FPM %1',

    'admin_ed__i_would_like_recieve_announce' => "我愿意接收来自 Plesk 的常规产品信息和公告。",
    'admin_ed__i_would_like_recieve_tech_announce' => "我愿意接收来自 Plesk 与安全有关的信息与其他技术通知。",

    '__login_status_inactive' => '您的帐户处于未激活状态。请联系 Plesk 管理员。',

    'migration__task_keep_in_process' => '确定',
    'migration__task_keep_in_process_conhelp' => '返回 工具与设置 页面。迁移将在后台中继续进行。',

    'ui__admin-alias-info__description' => "编辑管理员其它帐户的联系信息。",
    'ui__admin-alias-info__short-title' => "联系信息",
    'ui__admin-alias-info__title' => "管理员其它的帐户信息",
    'ui__admin-alias-password__description' => "更改其它的管理员的密码。",

    'ui__admin-alias-password__short-title' => "更改密码",
    'ui__admin-alias-password__title' => "其它的管理员密码",
    'ui__admin-alias__description' => "查看和更改其它的管理员帐户信息。",

    'chk_js__warning_about_login_syntax' => "用户名中可以包含小写字母数字、破折号和下划线。此用户名应以字母开头。密码不可以包含用户名和引号。",
    'chk_js__warning_about_ftp_login_syntax' => "您可以在用户名中使用字母、数字、短横线和下划线。",
    'chk_js__warning_about_login_syntax_win' => "用户名中可以包含小写字母数字、破折号、点号和下划线。此用户名应以字母或数字开头。密码不可以包含用户名和引号。",
    'chk_js__warning_about_passwd_syntax' => "密码中不得使用引号、空格和国家字母字符。\n密码的长度需介于 %1 到 %2 个字符之间，且不得包含用户名。",
    'chk_js__warning_about_plesk_login_syntax' => "您可以在用户名中使用小写字母数字、点、短横线和下划线符号。",
    'chk_js__warning_about_plesk_login_syntax_win' => "用户名只能包含小写字母、数字、短横线和下划线。用户名应以字母开头。",
    'chk_js__warning_about_plesk_passwd_syntax' => "密码中不得使用引号、空格和国家字母字符。\n密码长度应介于 %1 和 %2 个字符之间，且不得包含用户名。",
    'chk_js__warning_about_pam_passwd_error' => "指定的系统用户帐户错误: %1",

    'cmd_server__admin_alias_not_found' => "无法找到其它管理员帐户。",

    'panel_branding__skins_already_exists' => "注意主题 '%1' 已经存在。您当前正安装的主题将会替换该主题。",
    'panel_branding__skins_file_exists' => "无法为主题 '%1' 创建目录：相同名称的文件已经存在。",

    'actionlog__login_failed' => '登录失败',
    'actionlog__event_cp_user_login_failed' => 'Plesk 用户无法登录',
    'actionlog__api_login_failed' => '通过 API 登录失败',
    'actionlog__event_cp_user_api_login_failed' => '通过 API 登录失败的 Plesk 用户',
    'actionlog__pw_reset' => '请求的密码重设',

    'ch_pass_admin__email_subject' => "Plesk 的密码提示",
    'ch_pass_admin__email_body' => "您好：%1.\n\n因安全原因，管理员的密码无法通过电子邮件发送。\n\n要以 'admin' 身份登录，请使用 'plesk login' 命令。\n\n若要设置新的 'admin' 密码，请使用 'plesk bin admin --set-password -passwd <new_password>' 命令\n\n",
    'ch_pass_admin__message_send_error' => '无法发送电子邮件：%1',

    'ch_pass_by_secret__email_subject' => "Plesk 的密码提示",
    'ch_pass_by_secret__email_body' => "你好 %2，\n\n要设置新密码，请访问此链接：%1\n\n您的登录名：%3",
    'ch_pass_by_secret__message_send_error' => '无法发送秘密代码：%1',
    'ch_pass_by_secret__title' => '更改您的密码',
    'ch_pass_by_secret__secret' => '秘密代码',

    'custom_button__noframe' => "不要使用帧",

    'custom_button__internal_hint' => '指定是否在 Plesk 页面上或新的浏览器窗口中打开 URL。',
    'custom_button__noframe_hint' => '如果您添加一个引向客户面板中的 Plesk 扩展或应用程序的自定义按钮，您可指定该扩展/应用程序显示的方式：在帧中或作为 Plesk GUI 的一部分。',


    'actionlog__patch' => '更新',
    'actionlog__patch_available' => '可用',
    'actionlog__event_patch_available' => '可用更新',
    'actionlog__patch_installed' => '已安装',
    'actionlog__event_patch_installed' => '已安装更新',

    'actionlog__extension' => '扩展',
    'actionlog__extension_status' => '扩展状态',
    'actionlog__cloning' => '服务器克隆',
    'actionlog__cloning_complete' => '完成',
    'actionlog__event_cloning_complete' => '服务器克隆完成',

    'actionlog__ssl_web_binding' => '域中的 SSL/TLS 证书',
    'actionlog__ssl_web_binding_update' => '已分配/未分配',
    'actionlog__event_ssl_web_binding_update' => '域中的 SSL/TLS 证书已分配/未分配',

    'actionlog__ssl_web_mail_binding' => 'Webmail 中的 SSL/TLS 证书',
    'actionlog__ssl_web_mail_binding_update' => '已分配/未分配',
    'actionlog__event_ssl_web_mail_binding_update' => 'Webmail 中的 SSL/TLS 证书已分配/未分配',

    'actionlog__ssl_mail_binding' => '邮件服务器中的 SSL/TLS 证书',
    'actionlog__ssl_mail_binding_update' => '已分配/未分配',
    'actionlog__event_ssl_mail_binding_update' => '邮件服务器中的 SSL/TLS 证书已分配/未分配',

    'actionlog__ssl_panel_binding' => 'Plesk 中的 SSL/TLS 证书',
    'actionlog__ssl_panel_binding_update' => '已分配/未分配',
    'actionlog__event_ssl_panel_binding_update' => 'Plesk 中的 SSL/TLS 证书已分配/未分配',

    'actionlog__hostname' => '服务器主机名',
    'actionlog__hostname_changed' => '更改',

    'actionlog__smb_user' => '其他用户',
    'actionlog__smb_user_create' => '已创建其他用户',
    'actionlog__smb_user_delete' => '已删除其他用户',
    'actionlog__smb_user_update' => '已更新其他用户',

    'actionlog__event_mail_management_status_update' => '邮件管理状态更新',
    'actionlog__mail_management' => '邮件管理状态',
    'actionlog__mail_management_status_update' => '更新',

    'virtualization_openvz' => 'OpenVZ',

    '__domains_total' => '所有（按域名）',

    'chk_js__warning_about_admin_passwd_syntax' => "请不要在密码中使用引号、空格和国家字母字符。\n密码长度应在%1到%2个字符之间，并且不能包含用户名。",

    'passwordSecurityLevelCheckFailed' => '您的密码不够复杂。根据服务器策略，密码的最小强度需为 %1。若要提高密码强度，可使用数字、大写与小写字母与如 !、@、#,$、%、^、&、*、?、_、~ 的特殊符号。',
    'passwordSecurityLevelCheckFailedVeryWeak' => '很弱',
    'passwordSecurityLevelCheckFailedWeak' => '弱',
    'passwordSecurityLevelCheckFailedMediocre' => '适中',
    'passwordSecurityLevelCheckFailedStrong' => '强',
    'passwordSecurityLevelCheckFailedStronger' => '非常强',

    'cu__php_settings__command_update_all' => "根据服务器级 php.ini 文件更新所有域名的每域名  PHP 设置。",
    'cu__php_settings__update_all_done' => "已经成功更新所有域名的每域名  PHP 设置。",

    'filemanager__invalid_path' => "指定的路径无效",

    'ui__client/domain/dns/sync__description' => '在该区域应用服务器级 DNS 模板的修改。',
    'ui__client/domain/dns/sync__disabled-warning' => '无法应用 DNS 模板修改至该区域因为该区域由其它 DNS 服务器服务。',
    'ui__client/domain/dns/sync__short-title' => '应用 DNS 模板修改',
    'ui__client/domain/dns/sync__done' => 'DNS 模板的修改已成功应用至该区域。',
    'ui__client/domain/domain-alias/dns/sync__description' => '应用服务器级 DNS 模板的修改至该区域。',
    'ui__client/domain/domain-alias/dns/sync__disabled-warning' => '无法应用 DNS 模板修改至该区域因为该区域由其它 DNS 服务器服务。',
    'ui__client/domain/domain-alias/dns/sync__short-title' => '应用 DNS 模板修改',
    'ui__client/domain/domain-alias/dns/sync__done' => 'DNS 模板修改已成功应用至该区域。',
    'dns__dns_default_ipv4_modified' => '带有此 IP 地址的记录将被视为用户修改的记录，将不会与服务器级的 DNS 模板同步。',
    'dns__dns_default_ipv6_modified' => '带有此 IP 地址的记录将被视为用户修改的记录，将不会与服务器级的 DNS 模板同步。',

    'dns__view_dns_record_master_title' => '查看资源记录',
    'dns__view_dns_record_off_title' => '查看域名服务器记录',
    'dns__view_dns_record_slave_title' => '查看主要的 DNS 服务器记录',

    'dns_unable_to_resolve_hostname' => "无法解析主机名 \"%1\"：%2\n请确保操作系统的 DNS 解析器得以正确设置且运行正常。",

    'no_database_server_available' => '没有该订阅可用的数据库服务器。',

    'database_used_by_application_can_not_be_moved' => '无法移动数据库：一个网站应用程序在使用该数据库。',
    'database_user_update_orphaned_is_restricted' => '禁止更新孤立数据库用户帐户。您只能删除或修复它们。',

    'database_unable_to_get_max_filesize_default_message' => '无法确定数据库的文件大小最大值：\'%1\'',
    'database_unable_to_set_max_filesize_default_message' => '无法设置数据库的文件大小最大值：\'%1\'',
    'database_unable_to_get_max_log_filesize_default_message' => '无法确定数据库的日志文件大小最大值：\'%1\'',
    'database_unable_to_set_max_log_filesize_default_message' => '无法设置数据库的日志文件大小最大值：\'%1\'',

    'database_unable_to_get_max_filesize' => '无法确定 Microsoft SQL 数据库 \'%1\' 的文件大小的当前限制。不能设置新的限制。',
    'database_unable_to_set_max_filesize' => '无法为 Microsoft SQL 数据库 \'%1\' 的文件大小设置限制。',
    'database_unable_to_get_max_log_filesize' => '无法确定 Microsoft SQL 数据库 \'%1\' 的日志文件大小的当前限制。不能设置新的限制。',
    'database_unable_to_set_max_log_filesize' => '无法为 Microsoft SQL 数据库 \'%1\' 的日志文件大小设置限制。',

    'database_unable_to_create_because_max_filesize' => '无法创建 Microsoft SQL 数据库 \'%1\'：其文件大小超过了允许的最大值。',
    'database_unable_to_move_because_max_filesize' => '无法移动 Microsoft SQL 数据库 \'%1\'：其文件大小超过了允许的最大值：%2.',
    'database_unable_to_create_because_max_log_filesize' => '无法创建 Microsoft SQL 数据库 \'%1\'：其日志文件大小超过了允许的最大值。',
    'database_unable_to_move_because_max_log_filesize' => '无法移动 Microsoft SQL 数据库 \'%1\'：其日志文件大小超过了允许的最大值：%2.',
    'database_unable_to_restore_because_max_filesize' => '无法恢复 Microsoft SQL 数据库 \'%1\'：其文件大小超过了允许的最大值。',

    'sandbox_mssql_server_registered_as_usual_db_server' => 'Plesk 中已注册了相同的 MS SQL 服务器。请指定其它的 MS SQL 服务器作为沙箱。',
    'database_server__mssql_server_registered_as_sandbox' => '在 Plesk 中已经注册了一个相同的沙箱 MS SQL 服务器。请指定其它的 MS SQL 服务器作为沙箱。',

    'database_server_mysql_unable_to_connect_via_cli' => '无法通过\'%1\'连接服务器：%2',

    'bu_conflict_resolver_feature_not_available' => '以下服务节点不支持功能 %1：%2。在这些节点上创建的所有对象都将禁用此功能。',
    'bu_conflict_resolver_feature_not_available_single_server' => '该服务器不支持功能 %1：所有恢复的对象都将禁用此功能。',
    'bu_conflict_resolver_component_unavailable_in_sites' => '未安装组件 %1。以下网站无法使用它：{{objects}}',
    'bu_conflict_resolver_component_replaced_in_sites' => '未安装组件 %1。对于以下网站，它将被 %2 替换：{{objects}}',

    'bu_conflict_resolver_restoration_of_object_end_to_dot_not_supported' => '当前的 Plesk 版本不支持带有点号 (.) 字符的用户名。将不会恢复带有此类用户名的客户和代理商。',
    'bu_conflict_resolver_unable_to_find_backup_part' => '无法找到带有 %1 %2 的数据的备份文件。将不会恢复 %1 %2 的数据。',

    'bu_conflict_resolver_zone_master_removed' => "无法恢复 master DNS 记录：从属区域中的记录指向现有的 IP 地址 %1。将会从 slave 区域中移除 master DNS 记录。",

    'bu_conflict_resolver_not_available_scripting' => '不支持 %1。',
    'bu_conflict_resolver_not_available_scripting_in_sites' => '不支持 %1。以下网站无法使用它：{{objects}}',
    'bu_conflict_resolver_not_available_component' => '未安装组件 %1。',
    'bu_conflict_resolver_disabled_in_multi_server' => '以下服务节点无法使用它：{{objects}}',
    'bu_conflict_resolver_disabled_in_single_server' => '以下对象无法使用它：{{objects}}',
    'bu_conflict_resolver_not_available_db' => '在此服务器上无法使用以下数据库服务器: %1。',

    'bu_conflict_resolver_mssql_native_dump_restore_not_available' => 'MS SQL 数据库备份文件以 MS SQL 本地格式进行存储，此格式的备份文件只能恢复到本地 MS SQL 服务器或到完全配置备份设置的远程 MS SQL 服务器。因为 Plesk 中没有注册相应的 MS SQL 服务器导致一些数据库未得以恢复。以下的域名受到影响：{{objects}}. 请联系您的主机提供商。',

    'bu_conflict_resolver_not_available_webmail' => '%1 web 邮箱服务不可用。对于以下对象，它将被 %2 替换：{{objects}}',
    'bu_conflict_resolver_not_available_webmail_plan' => '%1 web 邮箱服务不可用。对于以下服务方案，它将被 %2 替换：{{objects}}',
    'bu_conflict_resolver_not_available_rename_db_user' => "'%1' 类型的数据库不支持与数据库名称一致的用户名。用户 '%2' 将被重命名为 '%3' 用于数据库 '%4'。",

    'bu_conflict_resolver_wrong_hard_quota_value' => '在目的服务器配置中未设置磁盘空间使用限制。该设置的值将会更改为“无限”。',
    'bu_conflict_resolver_wrong_max_connections_value' => '在目的服务器配置中未设置连接数量限制。该设置的值将会更改为“无限”。',
    'bu_conflict_resolver_wrong_traffic_bandwidth_value' => '在目的服务器配置中未设置流量使用限制。该设置的值将会更改为“无限”。',
    'cu__pleskrestore_backup_file_extracted' => '备份文件摘取自 "%1"。',
    '__mod_bw_not_supported' => '因文件系统的配置，不支持 Apache web 服务器的 mod_bw 模块。流量使用和连接最大数量的限制无效。',
    'bu_conflict_resolver_pop3_only_relay_auth_not_supported' => '不支持邮件中继使用 POP3 验证，而在 SMTP 验证之前将会使用 POP3。({{objects}})',
    'bu_conflict_resolver_service_plan_name' => '服务方案 \'%1\'',
    'bu_conflict_resolver_replaced_in_plans' => '不支持 %1。对于以下服务方案，它将被 %2 替换：{{objects}}',
    'bu_conflict_resolver_replaced_in_sites' => '不支持 %1。对于以下网站，它将被 %2 替换：{{objects}}',
    'bu_conflict_resolver_absent_objects_in_dump' => '未在备份文件中找到以下对象：%1',
    'bu_conflict_resolver_absent_domains' => '无法恢复某些对象因为它们隶属在 Plesk 中无法找到的以下域名：%1',
    'bu_conflict_resolver_absent_parent_domains' => "无法恢复某些网站因为它们隶属在 Plesk 中无法找到的以下父级域名：\n%1",
    'bu_conflict_resolver_dns_not_supported' => '无法恢复 DNS 区域：在服务器配置中已关闭 DNS 服务。',
    'bu_conflict_resolver_mail_not_supported' => '无法恢复邮箱：在服务器配置中已关闭邮件服务。',
    'bu_conflict_resolver__idle_timeout_action_not_supported' => 'IIS web 服务器不支持指定的闲置超时。该值将被重设为 %1。',
    'bu_conflict_resolver__cpu_limit_action_not_supported' => 'IIS web 服务器不支持指定的 CPU 限制操作。该值将被重设为 %1。',
    'bu_conflict_detector_server_ssl_cert_name' => '服务器 SSL/TLS 证书 %1',
    'bu_conflict_detector_domain_ssl_cert_name' => '域名 %1 的 SSL/TLS 证书 %2',
    'bu_conflict_detector_ssl_cert_name' => 'SSL/TLS 证书 %1',
    'bu_conflict_resolver_absent_objects' => '无法恢复以下对象的内容因为这些对象无法在 Plesk 中找到：%1',
    'bu_conflict_resolver_absent_objects_mailuser' => '无法恢复以下邮箱的内容因为这些对象无法在 Plesk 中找到：%1',
    'bu_conflict_resolver_absent_objects_maillist' => '无法恢复以下邮件列表的内容因为这些邮件列表无法在 Plesk 中找到：%1',
    'bu_conflict_resolver_absent_objects_database' => '无法恢复以下数据库的内容因为这些对象无法在 Plesk 中找到：%1',
    'bu_conflict_resolver__remove_conflicted_aps_app' => '在 "%2" 上恢复应用程序 "%1" 失败因为另一个应用程序已被安装到 "%3"。您可以移除已安装的应用程序然后再试。',
    'bu_conflict_resolver_not_available_mail_autoresponders' => '不支持邮件自动回复功能。',
    'bu_conflict_resolver_not_available_mail_content' => '不支持恢复邮件内容。',
    'bu_conflict_resolver_invalid_mail_name' => '下列邮箱未恢复，因为开启了电子邮件子寻址且某些电子邮箱地址包含符号 "%1"：%2',
    'bu_conflict_resolver_invalid_user_name' => '下列用户未恢复，因为开启了电子邮件子寻址且某些电子邮箱地址包含符号 "%1"：%2',
    'bu_conflict_resolver_licenses_expired' => '以下许可证已过期，将无法恢复：{{objects}}',
    'bu_conflict_resolver_licenses_invalid' => '以下许可证已失效或过期，将无法恢复：{{objects}}',
    'expiration_unsupported' => "不支持'到期'限制。",

    'component_name__dbconnector' => "数据库连接器",
    'component_name__mysqlserver' => 'MySQL 服务器',
    'component_name__troubleshooting' => '故障排除',

    '__subscription_has_no_license_key' => '该订阅资源由服务节点 #%1 提供（该服务节点没有相关联的许可证密钥）。',
    '__subscription_has_expired_license_key' => '该订阅资源由服务节点 #%1 提供（该服务节点的许可证密钥 %2 已到期）。',

    '__cfgmonConfigurationFileSaveErrorSubject' => '<%%host%%> 无法保存配置文件',
    '__cfgmonConfigurationFileSaveErrorBody' => "无法在主机 <%%host%%> 上保存一些配置文件： 出现以下错误：\n\n%%errors%%",

    'mail__enable_email_subaddressing_cli_desc' => '此选项会开启为邮件列表配置 VERP 式电子邮箱地址的功能',
    'mail__enter_right_ip_mask' => "输入IP掩码(在1到32之间)",
    'mail__enter_right_ip_mask_24' => "输入IP掩码(在24到32之间)",
    'mail__invalid_dom_name' => "域名 %1 无效。",
    'mail__invalid_pop_lock_time' => "POP3 锁定时间无效。",
    'mail__invalid_rbl_server' => "DNS 区域名无效。",
    'mail__total_files_size' => "总计库大小：%1",
    'mail__filename_already_in_repository' => "repository 中已存在相同名称的文件",
    'mail__no_white_list_mask_feature_24' => "使用掩码值 24 或更高值。\n您的邮件服务器不支持设置掩码。我们只能模拟为值不小于 24 的设置掩码。",
    'mail__unable_add_new_mail_name' => "无法添加邮件账户：%1",
    'mail_server_is_not_installed' => '邮件服务器 (Postfix 或 Qmail) 尚未安装。将其安装以继续运行工作。',
    'mail_server_not_available' => '在服务节点上没有支持的邮件服务器。',
    '__not_installed' => '(尚未安装)',
    'mail__service_node_outgoing_messages_is_disabled' => '禁用在传出邮件信息上进行垃圾邮件过滤。',
    'mail__service_node_does_not_support_outgoing_messages_domain_limit' => '服务节点不支持限制域名 %1 的域名的传出邮件信息数量。',
    'mail__service_node_does_not_support_outgoing_messages_mbox_limit' => '服务节点不支持限制域名 %1 的邮箱的传出邮件信息数量。',

    'mail__outgoing_email_mode_explicit_ip_unspecified' => '至少指定一种类型的一个地址（IPv4 或 IPv6）。',

    'mail__outgoing_email_mode_invalid' => '指定的传出邮件模式无效。',
    'mail__outgoing_email_mode_explicit_ip_v4_invalid' => '指定的 IPv4 地址无效',
    'mail__outgoing_email_mode_explicit_ip_v6_invalid' => '指定的 IPv6 地址无效',
    'mail__outgoing_email_mode_unavailable' => '不支持更改发送邮件模式，可能因为未在此服务器上安装 Postfix 邮件服务器。',

    'mail__autoresponder_attachment_not_supported' => '当前使用的邮件服务器不支持自动回复附件管理。',

    'mail__smtp_white_list_not_supported' => '当前使用的邮件服务器不支持IP地址白名单。',
    'mail__smtp_whitelist_cidr_not_supported' => '当前选定的邮件服务器不支持CIDR掩码。以格式 \'192.*.0.*\' 指定 IP 地址。',
    'mail__smtp_whitelist_mask_not_supported' => '当前选定的邮件服务器不支持通配符IP模式。以格式\'192.0.0.0/8\'指定 IP 地址。',

    'sfdk_server_wide_verify_failed' => '无法更改 DKIM 验证服务的设置',

    'sfdk_domain__serverwide_disabled' => '根据服务器策略关闭',
    'feature__domainkeys__serverwide_disabled' => '服务器级 DKIM 垃圾邮件防护被关闭',

    'defaultcomponents__error_set_default' => '无法将 %1 设置为默认的 %2：%3',
    'defaultcomponents__error_set_default_none' => '无法为 %1 设置无默认的组件：%2',
    'defaultcomponents__required_package_not_default' => '工作所需的 %1 组件不是默认组件。',

    '__percentage' => '%',
    '__seconds' => '秒',
    '__resource_remain' => '重命名',

    '__not_registered' => '（未注册）',
    '__php_handler_id' => 'PHP 版本',
    '__php_handler_id_string' => 'PHP %1 (%2)',
    '__php_handler_not_registered' => 'PHP 处理程序 &quot;%1&quot; 未被注册。它可能已被从服务器删除。使用相同的属性注册一个处理程序然后再试。',
    '__php_handler_not_registered_on_domain' => '域名 &quot;%1&quot;：PHP 处理程序 &quot;%2&quot; 未被注册。它可能已被从服务器删除。使用相同的属性注册一个处理程序然后再试。',
    '__php_fpm_handler' => 'FPM 应用程序',
    '__php_fpm-dedicated_handler' => '专用 FPM 应用程序',

    'mailname_create_assigned_user_dublicate_error' => '无法为邮箱创建用户。用户名为 %1 的用户已存在并且有其它的邮箱。',
    'mailname_create_assigned_user_role_absent_error' => '无法为邮箱创建用户。用户默认的角色 %1 不存在。',

    'gphd__mime_types' => 'MIME 类型',
    'gphd__handlers' => 'Apache 处理程序',
    'gphd__ip_restrictions_allow' => '允许访问指定主机和网络的网站（拒绝访问的除外）',
    'gphd__ip_restrictions_deny' => '拒绝访问指定主机和网络的网站',
    'gphd__directory_index' => '索引文件',
    'gphd__nginx_transparent_mode' => 'Apache 处理静态和动态内容而 nginx 仅通过 HTTP 请求和响应不做修改的模式。',
    'gphd__nginx_serve_static' => '由 nginx 直接服务静态文件',
    'gphd__nginx_static_extensions' => '必须由 nginx 处理的静态文件扩展',
    'gphd__nginx_serve_php' => '由 nginx 处理 PHP 文件',
    'gphd__www_root' => 'WWW 根目录',

    'eol__none' => '不修改',
    'eol__lf' => '转换到Unix风格',
    'eol__cr' => '转换为MacOS风格',
    'eol__crlf' => '转换为Windows风格',

    'ui__dns_bad_zone' => '不一致的区域 &quot;%1&quot;。',
    'ui__dns_ns_has_no_address_records' => 'NS 记录 &quot;%1&quot; 没有地址记录 (A 或 AAAA)。',
    '__dns_bad_zone' => '不一致的区域 &quot;%1&quot;。',
    '__dns_ns_has_no_address_records' => 'NS 记录 &quot;%1&quot; 没有地址记录 (A 或 AAAA)。',
    '__dns_ptr_is_wildcard' => 'PTR 记录 &quot;%1&quot; 无效。记录指向一个通配符域名。',

    'firewall_database_user_remote_access_rule_name' => '[%1][%2] 允许客户 \\&apos;%4\\&apos; 的数据库用户 \\&apos;%3\\&apos; 使用远程访问。',
    'firewall_database_user_remote_access_rule_name_removed' => '[%1][%2] %3',
    'firewall_database_user_remote_access_mssql_server_port_undefined' => '无法允许数据库用户 \\&apos;%1\\&apos; 使用远程连接。无法确定 Microsoft SQL server \\&apos;%2\\&apos; 使用的 TCP 端口号。可能的原因有：TCP/IP 协议未在服务器网络配置中启用或服务器被配置使用动态 TCP 端口。请配置服务器监听指定的固定 TCP 端口并再次尝试允许远程连接。',

    'command__convertResellerHasCustomer' => '代理商帐户 \\&apos;%1\\&apos;  有一或多个客户帐户。若要转换此代理商帐户为客户帐户，请转换这些客户帐户给新所有者，或转换为代理商帐户。',
    'command__convertResellerNotReseller' => '仅代理商帐户可被转换为客户帐户。\\&apos;%1\\&apos; 不是一个代理商。',
    'command__convertResellerToCustomerSubscriptionNotSynchronized' => '无法将订阅与服务方案同步。订阅的下列设置与服务方案冲突：%%problems%%。',

    'moveCustomer__wrong_customer_type' => '帐户 \\&apos;%1\\&apos; 是一个代理商帐户。无法移动代理商帐户给新的所有者因为这些帐户由服务器管理员所有。',
    'moveCustomer__wrong_owner_type' => "可以把客户帐户 \\\\&apos;%1\\\\&apos; 仅移动给一个代理商或 admin，而不能移给其它客户。",
    'moveCustomer__customer_already_belongs_to_owner' => '客户帐户 \\&apos;%1\\&apos; 已属于选定所有者。',
    'upgradeClient__user_is_admin' => '帐户 \\&apos;%1\\&apos; 无法被转换为代理商帐户因为该帐户是管理员帐户。',

    'mail__error_setting_max_connections_courier' => '无法设置连接（IMAP、POP3、IMAP over SSL/TLS 或 POP3 over SSL/TLS）的最大数量：%1',
    'mail__error_setting_max_connections_dovecot' => '无法设置连接（IMAP、POP3、IMAP over SSL/TLS 或 POP3 over SSL/TLS）的最大数量：%1',
    'mail__error_setting_max_connections_per_ip_courier' => '无法按 IP 地址设置连接（IMAP、POP3、IMAP over SSL/TLS 或 POP3 over SSL/TLS）的最大数量：%1',
    'mail__error_setting_max_connections_per_ip_dovecot' => '无法为某个特定用户按 IP 地址设置连接（IMAP、POP3、IMAP over SSL/TLS 或 POP3 over SSL/TLS）的最大数量：%1',
    'outgoing_messages_limit_value_invalid' => '该值必须介于 %%MIN%%..%%MAX%% 之间。只有 Plesk 管理员可以调整该设置。',
    'outgoing_messages_server_settings_catch_address_are_not_local' => "以下域名使用外部电子邮件地址来对发送到地址不存在的邮件进行转发。发送到这些地址的邮件将不计入传出邮件控制范畴：\n%1",
    'outgoing_messages_white_list_not_empty' => '对传出邮件的限制将不适用于IP地址来自邮件服务器白名单的发件人。例如，如果在白名单中有 localhost (127.0.0.0 / 8, ::1 / 128)，不管该限制如何，所有本地服务器的邮件将被成功发送。发件人可以使用本地IP地址（在本地服务器上托管的网站和自定义脚本）或外部IP地址（通过安装在电脑或移动设备上的邮件客户端发送邮件的客户）。要实现该限制适用于所有发件人（本地的和外部的），请移除所有来自白名单的IP地址和网络。请注意，移除来自白名单的 localhost (127.0.0.0 / 8, ::1 / 128) 可能干扰该服务器发送邮件网站和脚本的操作。了解有关传出邮件限制的详情，请查看管理员指南，来自 Outbound Spam 的防护。',
    'outgoing_messages_relay_open' => '邮件中继已打开：将无法实现对传出邮件的限制。',

    'notification_aps_app_updates_available' => '更新可用于以下应用程序。',
    'notification_aps_app_updates_installed' => '已自动为以下应用程序安装更新：',
    'notification_aps_app_updates_requirements' => '更新可用于以下应用程序但是无法安装因为相应网站的主机设置不符合安装要求：',
    'notification_admin_aps_app_updates_available_item' => '%%name%% (%%url%%).已安装版本：%%from%%.可用版本：%%to%%.',
    'notification_admin_aps_app_updates_available_plugin_item' => '%%parentName%% (%%url%%) 上的插件 &quot;%%name%%&quot;。已安装版本：%%from%%.可用版本：%%to%%.',
    'notification_admin_aps_app_updates_available_theme_item' => '%%parentName%% (%%url%%) 上的主题 &quot;%%name%%&quot;。已安装版本：%%from%%.可用版本：%%to%%.',
    'notification_reseller_aps_app_updates_available_item' => '%%name%% (%%url%%).已安装版本：%%from%%.可用版本：%%to%%.',
    'notification_reseller_aps_app_updates_available_plugin_item' => '%%parentName%% (%%url%%) 上的插件 &quot;%%name%%&quot;。已安装版本：%%from%%.可用版本：%%to%%.',
    'notification_reseller_aps_app_updates_available_theme_item' => '%%parentName%% (%%url%%) 上的主题 &quot;%%name%%&quot;。已安装版本：%%from%%.可用版本：%%to%%.',
    'notification_client_aps_app_updates_available_item' => '%%name%% (%%url%%).您的版本：%%from%%.可用版本：%%to%%.',
    'notification_client_aps_app_updates_available_plugin_item' => '%%parentName%% (%%url%%) 上的插件 &quot;%%name%%&quot;。您的版本：%%from%%.可用版本：%%to%%.',
    'notification_client_aps_app_updates_available_theme_item' => '%%parentName%% (%%url%%) 上的主题 &quot;%%name%%&quot;。您的版本：%%from%%.可用版本：%%to%%.',
    'notification_admin_aps_app_updates_installed_item' => '%%name%% (%%url%%).新版本：%%to%%.旧版本：%%from%%.',
    'notification_reseller_aps_app_updates_installed_item' => '%%name%% (%%url%%).新版本：%%to%%.旧版本：%%from%%.',
    'notification_client_aps_app_updates_installed_item' => '%%name%% (%%url%%).新版本：%%to%%.旧版本：%%from%%.',
    'notification_admin_aps_app_updates_requirements_item' => '%%name%% (%%url%%).已安装版本：%%from%%.可用版本：%%to%%.',
    'notification_reseller_aps_app_updates_requirements_item' => '%%name%% (%%url%%).已安装版本：%%from%%.可用版本：%%to%%.',
    'notification_client_aps_app_updates_requirements_item' => '%%name%% (%%url%%).您的版本：%%from%%.可用版本：%%to%%.',
    'notification_aps_app_updates_no_installation_url' => '外部应用程序',

    'notification_outgoing_mail_exceeded_limits_domains' => '域名',
    'notification_outgoing_mail_exceeded_limits_mails' => '电子邮件地址',
    'notification_outgoing_mail_exceeded_limits_subscriptions' => '订阅',
    'notification_outgoing_mail_exceeded_limits_limit_value' => '每小时 %1 条信息',
    'notification_outgoing_mail_exceeded_limits_limit_value_unlimited' => '无限',
    'notification_outgoing_mail_exceeded_limits_object' => '%1，限制为 %2',
    'notification_outgoing_mail_exceeded_limits_attempt' => '%1 尝试超过限制（从 %2 到 %3）',
    'notification_outgoing_mail_exceeded_limits_attempt_still_exceeding' => '%1 尝试超过限制（从 %2 直到现在）',

    'restart__docker' => "Docker",
    'restart__fail2ban' => "IP 地址禁止 (Fail2ban)",

    'backup__restore__capability_fail2ban_not_installed_text' => '目标服务器上的未安装 Fail2ban 组件。',
    'backup__restore__capability_fail2ban_not_installed_resolution' => '安装 Fail2ban。注意这可能需要几分钟。',

    'plesk_key__no_reseller_support' => '因许可证限制您无法管理代理商。',
    'plesk_key__no_customers_support' => '因许可证限制您无法管理客户。',
    'panel_interface_uimodes__service_provider_view_not_allowed' => '因许可证限制无法切换到服务提供商视图。',
    'plesk_key__no_security_core_support' => '因许可证限制无法使用安全核心功能 (ModSecurity 和 Fail2Ban)。',
    'plesk_key__outgoing-antispam' => '传出邮件控制',
    'plesk_key__security-core' => '安全核心 (ModSecurity 和 Fail2Ban)',
    'plesk_key__can-manage-accounts' => '帐户管理',
    'plesk_key__can-manage-subscriptions' => '订阅管理',
    'plesk_key__can-manage-customers' => '客户管理',
    'plesk_key__can-manage-resellers' => '代理商管理',
    'plesk_key__can-manage-custom-view' => '限制模式可用性',
    'plesk_key__limits_exceeded_no_subscriptions_management' => '订阅管理已被关闭但是您有多个订阅 (%1)。',
    'plesk_key__limits_exceeded_no_resellers_management' => '代理商管理已被关闭但是您有多个代理商 (%1)。',
    'plesk_key__limits_exceeded_no_customers_management' => '客户管理已被关闭但是您有多个客户 (%1)。',
    'plesk_key__no_subscriptions_support' => '因许可证限制您无法管理订阅。',
    'plesk_key__no_custom_view_support' => '由于许可证限制，您不能使用限制模式。',
    'plesk_key__trial_forbidden_region' => '很抱歉，Plesk 目前在您的区域里不供使用。',
    'additional_key__main_key' => '该密钥是主要的密钥：您无法上传主要的密钥作为其它的密钥。',

    'gch__hosting_waf_rule_engine' => 'Web 应用程序防火墙模式',

    'backup__fieldset__restoration_options' => '恢复选项',
    'backup__restore_options__restore' => '恢复',
    'backup__restore_options__domain__domain_configuration' => '域名配置',
    'backup__restore_options__domain__virtual_host_content' => '虚拟主机内容',
    'backup__restore_options__domain__mail' => '邮件',
    'backup__restore_options__domain__databases' => '数据库',
    'backup__restore_options__client__client_configuration' => '客户帐户配置',
    'backup__restore_options__client__domains' => "客户域名",
    'backup__restore_options__reseller__reseller_configuration' => '代理商帐户配置',
    'backup__restore_options__reseller__personal_domains' => "代理商域名",
    'backup__restore_options__reseller__clients' => "代理商客户",
    'backup__restore_options__admin__server_configuration' => '服务器设置',
    'backup__restore_options__admin__administrator_configuration' => '管理员帐户配置',
    'backup__restore_options__admin__personal_domains' => "管理员域名",
    'backup__restore_options__admin__personal_clients' => "管理员客户",
    'backup__restore_options__admin__resellers' => '代理商',

    'badge_new' => '新建',
    'upgrade_php_on_subscription' => '请将您订阅的 PHP 升级到5.3.0或更新版本。',

    'pkey_notify__body_expiration_notification' => '许可证密钥已过期。一些功能特性不可用。请联系您的主机提供商。',

    'crontab__crontab_entry_exists' => "计划任务已存在。",
    'crontab__crontab_entry_not_exists' => "计划任务不存在。",
    'crontab__invalid_values_found' => "参数值错误。",
    'crontab__cmd_max_len' => "该命令不得超过 %1 个字符。",

    'domain__domain_exists' => "有一个域名带有 'www' 前缀和相同名称：%1.%2.",
    'domain__subdomain_exists' => "有一个子域名带有 'www' 前缀和相同名称：%1.%2.",
    'domain__dalias_exists' => "有一个域名别名带有 'www' 前缀和相同名称：%1.%2.",
    'domain__record_exists' => "已有对应于主机%1.%2的DNS记录。",

    'ip_addr__cannot_assign_certificate' => "无法设置证书 '%1' 作为默认的证书：私钥丢失。",
    'ip_addr__update_dns_error' => '在 DNS 区域中更新 IP 地址时出现错误。%1',
    'ip_addr__cannot_add_dhcp_enabled' => '无法添加 IP 地址。该网络接口会自动获取 IP 地址。',
    'ip_addr__cannot_remove_dhcp_enabled' => '无法移除 IP 地址 %1。该网络接口会自动获取 IP 地址。',
    'ip_addr__cannot_repair_dhcp_enabled' => '无法修复 IP 地址 %1。该网络接口会自动获取 IP 地址。',
    'ip_addr__cannot_change_interface_dhcp_enabled' => '无法更改 IP 地址 %1 的接口因为网络接口 %2 会自动获取 IP 地址。',

    'shm_lmsg__limit_for_resource_exceeded' => '已超过订阅对 %%type%% 数量的限制。限制为 %%limit%%，而当前正使用 %%usage%%。',
    'shm_lmsg__resource_is_forbidden_for_creation' => '该订阅没有创建 %%type%% 的权限。',
    'shm_lmsg__resource_title__db-mysql' => 'MySQL 数据库',
    'shm_lmsg__resource_title__db-mssql' => 'MS SQL Server 数据库',
    'shm_lmsg__resource_title__db-postgresql' => 'PostgreSQL 数据库',
    'shm_lmsg__resource_title__db-user' => '数据库用户',
    'shm_lmsg__resource_title__iis-application-pool' => 'IIS 应用程序池',
    'shm_lmsg__resource_title__additional-ftp-account' => '其它 FTP 帐户',

    'db_user_unable_remove_mysql_global_privileges' => '无法移除数据库用户 %1 的 MySQL 全局权限。原因：%2',
    'report__client_description' => '描述',

    'db__user_role_error' => '指定的数据库用户角色不正确：%1。请选择下面当中的一个角色：%2.',

    'subscription_unable_to_set_max_filesize_warning' => '无法为下面的 Microsoft SQL Server 数据库设置文件大小限制因为它们的文件较大：%1.',
    'subscription_unable_to_set_max_log_filesize_warning' => '无法为下面的 Microsoft SQL Server 数据库设置日志文件大小限制因为它们的日志文件较大：%1.',
    'ipaddress__cannot_set_up_public_ip_need_ipaddress' => '无法设置公共 IP 地址：必须存在一个独立的 IP 地址。',
    'ipaddress__cannot_set_up_public_ip_need_ipv6' => '无法为 IPv6 地址设置一个公共的 IPv4 地址。',
    'ipaddress__cannot_set_up_public_ip_need_ipv4' => '无法为 IPv4 地址设置一个公共的 IPv6 地址。',
    'ipaddress__cannot_set_up_public_ip_invalid' => '无法设置公共 IP 地址：无效的 IP 地址。',

    '__user_already_exists' => "用户 %1 已存在。",
    '__user_name_is_empty' => "请指定一个用户名。",

    'upgrade_php_on_domain' => '在您任何的 WordPress 域名上无法找到 PHP 5.3.0 版本或更新版本。请尝试升级 PHP。',

    'component_name__waf' => 'Web 应用程序防火墙',
    'component_name__vcs' => '版本控制系统',

    'virtualization_lxc' => 'LXC',
    'virtualization_docker' => 'Docker',
    'possibleSpoofingDetected' => '已检测到可能的欺骗行为尝试：链接尝试显示不相关的内容。',
    'forceResetPasswordUpdated' => '您的密码已更改。使用新密码登录到Plesk。',

    'php_handlers_error_no_available_instance' => '无法创建域名：没有可用的 PHP 处理程序。',
    'domain_error_unable_to_apply_hosting_settings' => '无法应用主机设置：%1',

    'plesk_not_configured' => 'Plesk 未进行配置。请进入控制面板执行安装后配置。',
    'cmd_mail__mail_password_duplicated' => '邮件服务器上已存在指定的电子邮件地址和密码组合。请指定其它的电子邮件地址或密码。',

    'extensionRequirementOs' => '该程序包不支持操作系统 (%1)。',
    'extensionRequirementPleskMinVersion' => 'Plesk %1 是该程序包支持的最早版本。',
    'extensionRequirementPleskMaxVersion' => '该程序包不支持自 Plesk %1 起的版本。',
    'extensionBlacklisted' => '不允许安装扩展 %1。',
    'extensionDisabled' => '该扩展被禁用。',


    'optimization_settings__unable_set_mpm_event' => '无法设置 mpm_event 模式：需要关闭 Apache PHP5 模块，但是该模块正被域名使用。',
    'optimization_settings__unable_turn_off_php' => '无法关闭 Apache PHP5 模块：正被域名使用。',

    'hst_def__fp_admin_login' =>  'FTP 用户名',
    'hst_def__fp_admin_passwd' =>  'FTP 密码',

    'database_user_orphaned_old_password_wrong' => "无法修复孤立的用户 '%1'：该密码不正确。",
    'cannot_load_partner_central_property_key_no_exist' => "无法检索自定义属性：该许可密钥不存在。",
    'extensionScriptFailure' => "执行 %1 失败，出现以下信息：\n%3",
    '__ssl_redirect' => "SEO 安全 301 永久重定向（从 HTTP 到 HTTPS）",
    'component_name__dotnetcore' => '.NET Core',
    'mail__dkim_not_supported' => '不支持 DKIM 管理。',
    'mail__dmarc_not_supported' => '不支持 DMARC 管理。',
    'mail__relay_white_list_not_supported' => '不支持中继白名单管理。',
    'mail__black_list_not_supported' => '不支持黑名单管理。',
    'mail__autoresponder_not_supported' => '不支持自动回复管理。',
    'defaultcomponents__not_supported_version' => '（不支持的版本）',
    'component_name__nodejs' => 'Node.js',

    'certificate__not_found' => '未找到证书 \'%1\'。',
    'certificate__unable_setup_certificate' => '无法安装证书：%1 私钥和证书内容丢失。',
    'certificate__used_by_panel' => '您要删除的证书中有一个被用于保护 Plesk 的安全。',
    'certificate__used_by_mail_server' => '您要删除的证书中有一个被用于保护邮件服务器的安全。',
    'certificate__used_by_domain_service' => '您要删除的其中一个证书被域名服务使用。',
    'mail_server__not_installed' => '无法为邮件服务器安装证书因为没有安装邮件服务器。',

    'email_activation_mail_subject' => '请在Plesk中激活您的账户',
    'email_activation_mail_body' => "在Plesk服务器上创建了一个账户%1\n\n账户详情：\n姓名：%2\n电子邮件地址：%3\n\n如果这个信息是正确的，并且该账户是为您创建的，请使用以下链接激活它：\n\n%4\n\n激活该账户后，作为合同的一个组成部分，你便授权服务器持有人根据现行的数据保护法收集、传出、处理和使用您的个人数据（姓名和电子邮件），用以创建和支持您的账户。",

    'backup_transport_permission_name' => '%1 管理',
    'backup_transport_permission_description' => '允许使用 %1 来存储备份。',

    'domain_move_err_target_no_hosting' => '无托管，无法将该域移至订阅。',
    'domain_move_err_already_in_target' => '该域已属于目标订阅。',
    'domain_move_err_main_domain' => '无法移动主域。',
    'domain_move_err_subdomain_without_parent' => '没有父域 %2，无法移动子域 %1。',
    'domain_move_err_root_exists' => 'www_root %1 的目标路径已存在。',
    'domain_move_err_nested_roots' => '无法移动该域，因为该域与其他域共享此文档根目录：%1。',
    'domain_move_err_no_mail_service' => '无法移动该域，因为该邮件服务在目标订阅上被禁用。',
    'domain_move_err_app' => "%1 上安装的应用程序未被移至订阅 '%2'：%3",
    'domain_move_database_used_by_app' => "%2 中的数据库 '%1' 被已移动的应用程序使用。要将数据库重新分配至 '%3'，请运行 `plesk bin database --assign-to-subscription`",
    'domain_move_target_locked' => "目标订阅 '%1' 已针对同步锁定。",
    'domain_move_filesharing_disabled' => '文件共享已禁用。',
    'domain_move_website_preview_disabled' => '网站预览已被禁用。',
    'domain_move_additional_webserver_settings' => "检查域的其他网络服务器指令，以防止配置被破坏。",
    'domain_move_no_permission' => "订阅 '%2' 不允许使用 %1。",
    'domain_move_no_access' => "没有对 '%1' 的访问权限。",
    'domain_split_no_create_permission' => "不允许创建域名。",
    'domain_split_empty_login' => '需要提供系统用户登录名。',
    'domain_split_empty_password' => '需要提供系统用户密码。',
    'domain_split_err_home_exists' => '无法移动域名 %1 因为 %2 中已存在其目标主路径。请将域名重命名以将其移动到新的订阅。',
    'domain_split_err_no_hosting_subdomains' => '域名无法移动到新订阅因为该域名没有主机而是有子域名。若要移动域名，请将其 "主机类型" 的值更改为 "网站主机"（在“主机设置”中）。',
    'domain_split_target_locked' => "目标订阅 '%1' 已锁定不能同步。",
    'domain_split_target_unsynced' => "目标订阅 '%1' 未与方案同步，因为：%2。",
    'domain_merge_scheduled_backup_deactivated' => "已在 '%1' 上停用了计划备份。",
    'domain_merge_database_error' => "%2 上的数据库 '%1' 未被移动到订阅 '%3'：%4",
    'domain_merge_anon_ftp_deactivated' => "'%1' 上的匿名 FTP 已被关闭。",
    'domain_merge_smb_user_access' => "其它用户 '%1' 被移动到订阅 '%2' 但是该用户对订阅的访问权限已被取消。",
    'domain_merge_scheduled_tasks' => "计划任务已被移动到目标订阅。请检查任务配置。",
    'domain_merge_scheduled_tasks_deactivated' => "计划任务已被移动到目标订阅且被停用。请检查任务配置。",
    'domain_merge_no_remove_permission' => "不允许移除订阅。",
    'domain_merge_err_has_addons' => '无法移动带有其它域名的主域名；请首先移动域名 %1。',
    'domain_merge_err_has_webusers' => '无法移动带有其 web 用户的主域名。',
    'domain_merge_err_root_exists' => '目标路径 %1 已存在。',

    'database_server_edit_used_for_psa' => '不允许更新本地的 MySQL 数据库服务器。',
    'suggest_repair_main_suggestion_ui' => '<b>您可以修复此错误</b>，通过使用 `plesk repair` 实用工具。',
    'suggest_repair_main_suggestion_cli' =>  '您可以使用 `plesk repair` 实用工具修复此错误。',
    'suggest_repair_repair_kit_link_title' => '转到 “诊断与修复”',
    'suggest_repair_using_cli_and_ui' => '如要实现此目的，可通过 CLI 运行 `plesk repair %1` 命令或者 %2 并点击 “Plesk 数据库” 旁的修复',
    'suggest_repair_using_cli' => '要实现此目的，需通过 CLI 运行 `plesk repair %1` 命令',

    'backup__restore__capability_duplicate_php_handler_resolution' => '',
    'bu_conflict_resolver_dns_not_available' => '当创建了备份时 DNS 服务变得不可用了。但是，在备份中有活动的 DNS 区域，将为以下对象启用这些服务：{{objects}}',
    'plesk_key__system-resources-limits-enabled' => '资源调度控制器 (cgroups)',
    'plesk_key__remote-smartermail-enabled' => '远程 SmarterMail 的支持',
    'plesk_key__complete-backup-solution' => 'Backup to Cloud Pro',
    'defaultcomponents__no_license' => '（许可证密钥不允许）',
    'plesk_key__validation_failed' => '%1（错误代码：%2）',
    'promo__button_details' => '详情',
    'promo__extension_catalog_title' => '扩展目录',
    'promo__extension_catalog_description' => '查看新的扩展目录，并通过各种强大的扩展壮大您的 Plesk！',
    'promo__button_open_catalog' => '打开目录',

    'backup__repository_check_login' => "无法访问存储系统：%1\n请确保您已输入了正确的存储验证凭据。",
    'backup__repository_check_error_list' => "无法访问存储系统：%1\n请确保您已输入了正确的存储设置。",
    'backup__repository_check_error_mkdir' => "无法创建目录：%1\n检查您是否有权限在存储系统中创建文件夹。",
    'backup__repository_check_error_upload' => "无法将文件上传到存储系统： %1\n检查您是否有权限将文件上传到存储系统。",
    'backup__repository_check_error_download' => "无法从存储系统下载文件： %1\n检查您是否有权限将文件上传到存储系统或从存储系统下载文件。",
    'backup__repository_check_error_resume-upload' => "无法恢复上传到存储系统中的文件： %1\n检查您是否有权限恢复上传到存储系统中的文件。",
    'backup__repository_check_error_resume-download' => "无法恢复从存储系统中下载的文件： %1\n检查您是否有权限恢复从存储系统中下载的文件。",
    'backup__repository_check_error_enable-utf8' => "无法操作存储系统：%1\n检查存储系统是否支持 UTF8 编码。",
    'backup__repository_check_error_rm' => "无法操作存储系统：%1\n检查您是否有权限从存储系统删除文件。",
    'backup__repository_check_error_rmdir' => "无法操作存储系统：%1\n检查您是否有权限从存储系统删除文件夹。",

    'backup__ftp_repository_check_login' => "%1 您可以使用命令对其进行独立地检查：\n  %2",
    'backup__ftp_repository_check_error_list' => "%1 您可以使用命令对其进行独立地检查：\n  %2",
    'backup__ftp_repository_check_error_mkdir' => "%1 您可以使用命令对其进行独立地检查：\n  %2",
    'backup__ftp_repository_check_error_upload' => "%1 您可以使用命令对其进行独立地检查：\n  %2\n  %3",
    'backup__ftp_repository_check_error_download' => "%1 您可以使用命令对其进行独立地检查：\n  %2\n  %3",
    'backup__ftp_repository_check_error_resume-upload' => "%1 您可以使用命令对其进行独立地检查：\n  %2\n  %3\n  %4",
    'backup__ftp_repository_check_error_resume-download' => "%1 您可以使用命令对其进行独立地检查：\n  %2\n  %3",
    'backup__ftp_repository_check_error_enable-utf8' => "%1 您可以使用命令对其进行独立地检查：\n  %2",
    'backup__ftp_repository_check_error_rm' => "%1 您可以使用命令对其进行独立地检查：\n  %2\n  %3",
    'backup__ftp_repository_check_error_rmdir' => "%1 您可以使用命令对其进行独立地检查：\n  %2\n  %3",

    'sfdmarc_server_wide_enable_failed' => '无法更改 DMARC 的设置若要启用此选项，请打开 DKIM 和 SPF 垃圾邮件防护服务。',
    'spf_server_wide_disable_failed' => '无法更改 SPF 垃圾邮件防护的设置。若要禁用 SPF，请为传入邮件关闭 DMARC。',
    'sfdk_server_wide_verify_disable_failed' => '无法更改 DKIM 垃圾邮件防护的设置。若要禁用 DKIM，请为传入邮件关闭 DMARC。',

    'ccs_not_supported' => '系统上未配置 IIS Central Certificate Store。',
    'ccs_not_enabled' => '在 Plesk 中未启用 IIS Central Certificate Store 管理。',
    'ad_not_supported' => '服务器未加入到域名中。',

    'component_name__appinit' => "应用程序初始化",
    'component_name__httpcompression' => 'HTTP 内容压缩',
    'common_feature_is_not_supported' => '不再支持此功能。',
    'common_feature_is_not_supported_in_proto' => '对于协议版本 %1 不再支持此功能。',
    'autoinstaller__plesk_component' => 'Plesk 组件',
    'plesk_key__key_expired' => '您的许可证密钥已到期。若要继续使用 Plesk，请购买非到期商业 %1。',
    'plesk_key__key_purchase' => '许可证密钥',

    'sa_action_move' => '将垃圾邮件移动到 "垃圾邮件" 文件夹。',

    'bu_conflict_resolver_tomcat_not_supported' => '不再支持 Java 应用程序。以下网站将不可用这些服务：{{objects}}',
    'bu_conflict_resolver_unity_mobile_not_supported' => '不再支持使用 UNITY Mobile 托管的网站移动版本。以下网站将不可用这些服务：{{objects}}',
    'bu_conflict_resolver_antivirus_personal_management_not_allowed' => '服务器范围的使用策略不允许使用个人的反病毒设置。将会为以下域名上的电子邮件账户不完全的将其恢复：{{objects}}',

    'module__not_installed' => "扩展 %1 未安装",

    'mail__mail_autodiscovery_server_error' => '为邮件 autodiscover 指定一个自定义域名',
    'mail__error_mail_autodiscovery_enable' => '无法设置邮件 autodiscover：%1',
    'mail__error_mail_autodiscovery_server' => '无法为邮件 autodiscover 设置自定义域名：%1',
    'mail__error_mail_autodiscovery_reconfigure_dns' => '无法重新配置域名 autodiscover DNS 记录：%1',

    '__invalid_url' => 'URL "%1" 无效',
    'actionlog__cloning_start' => '开始',
    'actionlog__event_cloning_start' => '服务器克隆开始',

    '__UPLOAD_ERR_FORM_SIZE' => "上传的文件超出了允许的大小。",
    '__UPLOAD_ERR_INI_SIZE' => "上传的文件超出了允许的大小。",
    '__UPLOAD_ERR_NO_FILE' => "未接收到文件。",
    '__UPLOAD_ERR_OK' => "文件成功上传。",
    '__UPLOAD_ERR_PARTIAL' => "仅上传了部分文件，请重试。",
    '__UPLOAD_ERR_NO_TMP_DIR' => '丢失临时文件夹',
    '__UPLOAD_ERR_CANT_WRITE' => '将文件写入磁盘失败',
    '__UPLOAD_ERR_UNKNOWN' => '发生未知的文件上传错误',
    '__accounts' => "帐户",
    '__access' => "访问",
    '__address' => "地址",
    '__addresses' => "地址",
    '__acl_records' => 'ACL记录',
    '__admin_repository' => "管理员的证书库",
    '__all' => '所有',
    '__allowed' => "允许",
    '__anonftp_status' => "匿名FTP",
    '__antispam' => "垃圾邮件",
    '__apache_restart' => "...%1Web服务器正在重启，请等待...",
    '__asp' => "Microsoft ASP",
    '__asp_dot_net' => "Microsoft ASP.NET",
    '__asp_dot_net_support' => "Microsoft ASP.NET支持",
    '__asp_win_support' => "Microsoft ASP支持",
    '__attachments' => "附件",
    '__attachments_list' => "附件",
    '__author' => '创建者',
    '__autoresp_name_already_exists' => "名为%1的自动回复已存在。",
    '__autoresponder' => "自动回复",
    '__autoresponders' => "自动回复",
    '__autoresponders_list' => "自动回复",
    '__autoresponder_attachment_files' => "自动回复附件",
    '__auto_updates_list' => '可用更新',
    '__avail' => "可用",
    '__backup_utilites' => "备份工具",
    '__bind_status' => "DNS 服务器状态",
    '__bu_is_not_installed' => "由于备份程序尚未安装，此服务目前不可用。",
    '__bu_not_support_in_key' => "许可证不支持备份功能。",
    '__notifications_not_support_in_key' => '许可证不支持通知',
    'disabled_by_key' => '许可证不支持',
    '__bytes' => "字节",
    '__can_not_use_reserved_words' => "您不能使用保留字。",
    '__certificate' => "证书",
    '__cgi_support' => "CGI支持",
    '__change_date' => "修改日期",
    '__city' => "城市",
    '__cl_not_exist' => "客户帐户不存在。",
    '__client' => '客户',
    '__client_card' => "客户名片",
    '__client_contact_name' => "客户联系人名称",
    '__client_form' => "个人信息",
    '__client_ip_pool' => "客户IP池",
    '__client_limits' => "客户帐户限制",
    '__client_permissions' => "客户权限",
    '__client_preferences' => "客户偏好设置",
    '__client_status' => "客户状态",
    '__client_name' => "客户名称",
    '__client_total' => "客户总数",
    '__client_with_login_name_already_exists' => "用户名为\"%1\"的用户已存在。",
    '__client_domuser_with_login_already_exists' => "域名 '%1' 的管理员已使用用户名 '%1'。",
    '__clients_global_changes' => "修改所选客户帐户",
    '__clients_list' => "客户",
    '__cmd_not_found' => "未知命令：%1",
    '__comments' => "备注",
    '__company_name' => "公司名称",
    '__component_version' => "组件版本",
    '__component_not_installed' => "尚未安装组件%1",
    '__confirm_del' => "您必须确认删除。",
    '__confirm_overwrite' => "确认覆盖。",
    '__confirm_stop' => "您必须停止确认进程。",
    '__confirm_passwd' => "确认%1密码",
    '__confirm_removal' => "确认删除",
    '__conhelp' => "描述",
    '__contact_name' => "联系名称",
    '__country' => "国家",
    '__countries' => '国家',
    '__country_unknown' => '无法识别国家/地区的子码。',
    '__courier-imap' => 'Courier 服务器',
    '__create_domain' => '创建域名',
    '__crypted' => '已加密',
    '__cp_access' => "访问 Plesk",
    '__cp_user' => "Plesk 用户",
    '__create' => "创建",
    '__create_client_template_without_template' => "不使用模板创建用户帐户",
    '__create_domain_for' => "为 <b>%1 创建域名</b>",
    '__create_domain_template_without_template' => "不使用模板创建域名",
    '__creation_date' => "创建日",
    '__crontab_unix' => "计划程序",
    '__crontab_win' => "计划程序",
    '__ct_month_jan' => '一月',
    '__ct_month_feb' => '二月',
    '__ct_month_mar' => '三月',
    '__ct_month_apr' => '四月',
    '__ct_month_may' => '五月',
    '__ct_month_jun' => '六月',
    '__ct_month_jul' => '七月',
    '__ct_month_aug' => '八月',
    '__ct_month_sep' => '九月',
    '__ct_month_oct' => '十月',
    '__ct_month_nov' => '十一月',
    '__ct_month_dec' => '十二月',
    '__custom_button' => "自定义按钮",
    '__custom_buttons_list' => "其它服务的链接",
    '__daily' => "每日",
    '__database_not_activated' => "尚未在服务器管理页上启用%1。",
    '__database_not_installed' => "数据库 %1 尚未安装。",
    '__database_not_run' => "数据库 %1 没在运行。",
    '__database_is_corrupt' => "Plesk 的数据库已损坏。请启动 Reconfigurator 工具来修复。",
    '__databases' => "数据库",
    '__databases_list' => "数据库",
    '__database_type_not_supported_by_key' => '要使用 %1 服务器，需要您的许可证密钥支持该服务。请咨询您的 Plesk 销售代表。',
    '__date_immediately' => "今天",
    '__date_never' => "从不",
    '__day(s)' => "天",
    '__day0' => "星期日",
    '__day1' => "星期一",
    '__day2' => "星期二",
    '__day3' => "星期三",
    '__day4' => "星期四",
    '__day5' => "星期五",
    '__day6' => "星期六",
    '__days' => "%1日",
    '__db_admin_login_empty' => "您输入的用户名为空，这将导致无法在界面中通过%1启用控制。您想要继续吗？",
    '__db_unable_to_unregister' => '无法删除数据库连接参数',
    '__db_db_exists' => '服务器上至少有一个数据库。',
    '__db_unable_to_change_server_name' => '此服务器名称不能更改',
    '__db_unable_to_change_port' => '不能更改服务器端口',
    '__db_already_exist' => "数据库 %1 已存在。",
    '__db_credentials_invalid' => "数据库凭证无效。",
    '__db_invalid_password_characters' => '密码包含无效的字符',
    '__db_engine' => "数据库引擎", // indirect
    '__db_type' => "数据库类型",
    '__db_user' => "数据库用户",
    '__db_server' => '数据库服务器',
    '__def_domain' => "默认域名",
    '__default_for_mysql' => 'MySQL 默认使用',
    '__default_for_mariadb' => '默认用于 MariaDB',
    '__default_for_percona' => '默认用于 Percona',
    '__default_for_postgresql' => 'PostgreSQL 默认使用',
    '__delete' => "删除",
    '__demo' => "此功能在演示版中不可用。",
    '__directory' => "目录",
    '__disable_lock_screen' => '请阻止用户在界面屏幕完全加载之前使用 Plesk 。',
    '__dismiss_news?' => "您确定要完全关闭新闻区吗？\n\n直到有更多的新闻时，您才可以看到新闻区。",
    '__description' => "描述",
    '__disabled' => "禁用",
    '__disk_space_limit' => "磁盘空间限制",
    '__cgroups_cpu_usage_limit' => 'CPU 使用限制',
    '__cgroups_ram_usage_limit' => 'RAM 内存使用量限制',
    '__cgroups_disk_read_usage_limit' => '磁盘读取带宽限制',
    '__cgroups_disk_write_usage_limit' => '磁盘写入带宽限制',
    '__disk_usage_by' => "%1使用的磁盘空间",
    '__dns' => "DNS",
    '__dns_record_already_exist' => "DNS 记录 '%1' 已存在。",
    '__dns_master_should_be_remote' => "不同主机上需要分别有授权域名服务器。",
    '__dns_record_not_exist' => "DNS 记录不存在。",
    '__dns_server' => "DNS 服务器", // indirect
    '__dom_id_is_undefined' => "域名ID未定义。",
    '__dom_name' => "域名",
    '__dom_name_is_invalid' => "域名无效。请确定您的域名由字母数字、点、连字符组成，且不超过255个字符。点之间的每个域名部分都不超过63个符号。",
    '__dom_not_exist' => "域名不存在。",
    '__domain' => "域名",
    '__domain_' => '域名 %1',
    '__domain_form' => "域名表单",
    '__domain_id' => "域名 ID",
    '__domain_is_turned_off_for_backup' => "网站%1在备份/恢复过程中会被暂时关闭，当前不可用。",
    '__domain_limits' => "域名限额",
    '__domain_name' => "域名",
    '__mail_name_in_ASCII_form' => "ASCII格式的邮件帐户名",
    '__message_error' => '错误',
    '__message_warning' => '警告',
    '__message_info' => '信息',
    '__domain_name_in_ASCII_form' => "ASCII 形式的域名",
    '__domain_repository' => "域名%1的库",
    '__domain_status' => "域名状态",
    '__domain_dns' => '域名 DNS 区域',
    '__domain_total' => "订阅总数",
    '__domain_total_powerUser' => "订阅总数",
    '__domain_user' => "域名管理员",
    '__domains_global_changes' => "修改选定的域名",
    '__mailnames_global_changes' => "对邮件名进行组操作",
    '__backup_manager' => '备份管理器',
    '__domains_list' => "域名",
    'domains_list__list_header' => "域名", //this is a part of phrases like No domains (and others), so it should not be capitalized
    '__double_www_warning' => "虽然WWW前缀功能已启用，域名仍以www开始。\n是否继续？",
    '__dovecot' => 'Dovecot IMAP 和 POP3 服务器',
    '__dsmail' => "邮件服务",
    '__dsmaillist' => "邮件列表服务",
    '__dsr_db' => "DB",
    '__dsr_dname' => "域名",
    '__dsr_du' => "DU",
    '__dsr_ma' => "MA",
    '__dsr_mg' => "MF",
    '__dsr_ml' => "ML",
    '__dsr_mn' => "MBox",
    '__dsr_pname' => "客户名称",
    '__dsr_sd' => "SD",
    '__dsr_tr' => "TR",
    '__dsr_wu' => "WU",
    '__dumps_tot_size' => "本地存储中备份文件的大小总和",
    '__email' => "电子邮箱",
    '__email_addr_is_invalid' => "电子邮件地址无效。",
    '__enabled' => "启用",
    '__enter_cert_text' => "输入证书文本",
    '__enter_size' => "输入大小",
    '__exclusive' => "独立",
    '__expiration_date' => "到期日",
    '__fax' => "传真",
    '__file' => "文件",
    '__file_is_empty' => "文件为空。",
    '__file_name' => "文件名称",
    '__file_type' => '文件类型',
    '__filemanager' => "文件管理器",
    '__filepath_is_empty' => "文件路径为空",
    '__files_list' => "文件",
    '__frontpage' => "Microsoft FrontPage",
    '__ftp' => "FTP", // +indirect
    '__ftp_settings' => "FTP 设置",
    '__ftp_serv' => "FTP 服务器", // indirect
    '__ftp_server_parameters_are_empty' => "您必须先设置FTP帐户属性！",
    '__ftp_status' => "FTP 服务器状态",
    '__full_day0' => "星期日",
    '__full_day1' => "星期一",
    '__full_day2' => "星期二",
    '__full_day3' => "星期三",
    '__full_day4' => "星期四",
    '__full_day5' => "星期五",
    '__full_day6' => "星期六",
    '__full_month1' => "一月",
    '__full_month10' => "十月",
    '__full_month11' => "十一月",
    '__full_month12' => "十二月",
    '__full_month2' => "二月",
    '__full_month3' => "三月",
    '__full_month4' => "四月",
    '__full_month5' => "五月",
    '__full_month6' => "六月",
    '__full_month7' => "七月",
    '__full_month8' => "八月",
    '__full_month9' => "九月",
    '__giga' => "G",
    '__group' => "群组",
    '__h' => "H",
    '__hard_disk_quota' => "硬盘配额",
    '__hard_disk_quota_not_supported' => '因服务器文件系统配置，导致硬盘配额不受支持',
    '__header_text_is_invalid' => "受保护区的标题无效。",
    '__help_topic_not_found' => '您所请求的帮助主题(%1)不存在。',
    '__hosting' => "主机",
    '__hosting_ip_dns_ip_not_equiv' => "在A DNS记录中指定的IP地址与主机使用的IP地址不一致。",
    '__hosting_scripting' => "主机脚本支持",
    '__hosting_setup_page_title' => "域名%1的主机设置",
    '__hosting_title' => "主机 (%1)",
    '__hosting_type' => "主机类型",
    '__hostname' => "主机名",
    '__hostname_is_empty' => "主机名为空。",
    '__hour(s)' => '小时',
    '__hst_type_incorrect' => "主机类型不正确。",
    '__http' => "HTTP", //indirect
    '__htype' => "H",
    '__idle_time' => "闲置时间",
    '__iface' => "接口",
    '__image' => "图像",
    '__imap_status' => "IMAP 服务器状态",
    '__in' => "流入",
    '__in_%' => "以 % 为单位",
    '__incorrect_databases_login_pass' => "您指定的用于访问PostgreSQL的凭据不正确。",
    '__incorrect_ip_or_network_address' => '不正确的IP地址或网络。',
    '__info' => '信息',
    '__install' => "安装",
    '__install_prefix' => "安装前缀",
    '__invalid_cert_id' => "无效的证书ID",
    '__invalid_context' => "无效上下文：%1",
    '__invalid_db_usr_name' => "数据库用户名无效。",
    '__invalid_dir_name' => "目录名无效",
    '__invalid_dom_name' => "域名无效。",
    '__invalid_filename' => "文件名无效。不要使用单引号和/或\"../\"的组合。",
    '__invalid_id' => "无效标识符。",
    '__invalid_lines_num' => "行数值不正确，这个值只能是数字。",
    '__invalid_max_letter_size' => "最大邮件大小无效。",
    '__invalid_pdir_name' => "受保护目录名称无效。",
    '__invalid_restart_apache_interval' => "Apache重启间隔无效。",
    '__invalid_tmpl_name' => "模板名称无效。",
    '__invalid_value' => "错误值。",
    '__ip_addr' => "IP 地址",
    '__ip_address_and_mask' => "IP地址和子网掩码",
    '__ip_alias__mask' => "IP地址和子网掩码",
    '__ip_addr_form' => "IP 地址格式",
    '__ip_addr_is_invalid' => "IP 地址无效。",
    '__ip_addr_list' => "IP地址",
    '__ip_address_does_not_exist' => "IP 地址不存在。",
    '__ip_addresses' => "IP地址",
    '__ip_address_and_mask_hint' => '如%1',
    '__is_owner' => "O",
    '__java_engine' => "Java", // indirect
    '__jdk' => "JDK",
    '__kb' => "KB",
    '__kbps' => "KB/s",
    '__kbytes' => "KB",
    '__key_for_virtuozzo_only' => "您的许可证只能用于 Virtuozzo 容器中。",
    '__key_limits_exceeding' => "此操作超出了您的软件许可证授权。如果您收到此消息，请及时联系您产品的提供商或制造商，以确认或扩展许可证授权。",
    '__kilo' => "K",
    '__keywords' => '关键字',
    '__lang_unknown' => '无法识别此语言。',
    '__languages' => '语言',
    '__learn_more' => '了解更多',
    '__loading' => '正在加载...',
    '__locales' => "语言包",
    '__lists' => "邮件列表",
    '__literal_bytes' => "B",
    '__processing' => "请稍候。<br>加载中...",
    '__locale' => "界面语言",
    '__locale_is_not_defined' => "未定义界面语言。",
    '__local_server_mysql' => '本地 MySQL 服务器',
    '__local_server_postgresql' => '本地 PostgreSQL 服务器',
    '__local_server_mssql' => '本地MSSQL服务器',
    '__log_and_statistics_files' => '日志文件和统计报告',
    '__config_files' => '配置文件',
    '__chroot_files' => 'Chrooted环境',
    '__login' => "%1 登录",
    '__login1' => "登录名",
    '__login_disabled' => "登录名已禁用",
    '__login_enabled' => "所允许的登录名",
    '__login_incorrect' => "您输入的用户名或密码错误。",
    '__login_name' => "%1用户名",
    '__login_name_is_invalid' => "%1用户名无效。",
    '__logon_time' => "登录时间",
    '__ma' => "邮件别名",
    '__mail' => "邮件",
    '__mail_alias_name' => "邮件别名",
    '__mail_autodiscovery' => '邮件 autodiscover',
    '__mail_exchanger_name_is_invalid' => "邮件 exchanger 名称无效。",
    '__mail_groups' => "邮件群组",
    '__mail_list_engine' => "邮件列表软件",
    '__mail_name' => "邮件帐户",
    '__mail_name_form' => "邮件帐户属性",
    '__mail_names' => "邮件帐户",
    '__mail_serv' => "邮件服务器",
    '__mail_user' => '邮件用户',
    '__mailgroup' => "邮件群组",
    '__maillist' => "邮件列表",
    '__maillists' => "邮件列表",
    '__maillist_member' => '邮件列表成员',
    '__mailname' => "邮件帐户",
    '__mailname_redir_self' => "邮件帐户不可以转发给自身。",
    '__max_dom_num_reached_for_cl' => "已达到此客户帐户的域名数量限制。",
    '__max_file_size_available' => "允许的最大文件大小 %1",
    '__max_subdom_num_reached_for_cl' => "已达到此客户帐户的子域名数量限制。",
    '__max_subdom_num_reached_for_dom' => "已达到域名的子域名数量限制。",
    '__max_subdom_num_reached_for_key' => "已达到许可证允许的子域名数量限制。",
    '__max_traffic_limit' => "流量限制",
    '__maximum_excl_ip_num' => "邮件帐户",
    '__mb' => "MB",
    '__mbytes' => "MB",
    '__mb_month' => "MB/月",
    '__mb_sec' => "MB/秒",
    '__gb_sec' => "GB/秒",
    '__tb_sec' => "TB/秒",
    '__mega' => "M",
    '__minute(s)' => '分钟',
    '__mls_not_in_key' => "您的产品许可证不支持多语言界面。",
    '__modification_date' => "修改日期",
    '__module' => "扩展名",
    '__month' => "月",
    '__month(s)' => "月",
    '__month1' => "一月",
    '__month10' => "十月",
    '__month11' => "十一月",
    '__month12' => "十二月",
    '__month2' => "二月",
    '__month3' => "三月",
    '__month4' => "四月",
    '__month5' => "五月",
    '__month6' => "六月",
    '__month7' => "七月",
    '__month8' => "八月",
    '__month9' => "九月",
    '__monthly' => "每月",
    '__months' => "月",
    '__moved_permanently' => '已永久移动',
    '__mssql' => "Microsoft SQL Server",
    '__mssql__server' => "服务器",
    'mssql__server' => "Microsoft SQL Server 名称。",
    'mssql__unable_to_change_server_name_db_exists' => "不能更改服务器名称：因为其中至少有一个数据库。",
    '__mssql_status' => "Microsoft SQL Server 状态",
    '__multiply_login_deny' => "您无法登录。已有其它用户使用相同的用户名 (%1) 登录到 Plesk。",
    '__mysql' => "MySQL",
    '__mysql_status' => "MySQL服务器状态",
    '__mysql_version' => "Mysql版本",
    '__mariadb' => "MariaDB",
    '__mariadb_status' => "MariaDB 服务器状态",
    '__mariadb_version' => "MariaDB 版本",
    '__percona' => "Percona",
    '__percona_status' => "Percona 服务器状态",
    '__percona_version' => "Percona 版本",
    '__name' => "名称",
    '__name_invalid' => "无效名称。",
    '__nameserver' => "域名服务器",
    '__network' => "网络",
    '__networks' => "网络",
    '__no' => "否",
    '__no_ip_address_with_properly_type_available' => "无法恢复备份数据，因为没有匹配的 IP 地址用于恢复。",
    '__no_clients_specified' => "未指定客户帐户。",
    '__no_comments' => "无注释。",
    '__no_ip_specified' => "尚未指定IP。",
    '__nologin' => "禁止",
    '__none' => "无",
    '__not_configured' => "未配置",
    '__not_implemented_yet' => "尚未执行",
    '__not_supported_by_ftp' => "(不被 FTP 服务器支持)",
    '__notification' => "通知",
    '__num_displayed' => "显示了 %1 个(共 %2 个)",
    '__num_is_invalid' => "数值无效。",
    '__object_not_found' => '对象未找到：%1',
    '__of_all' => "%（占总量比例）",
    '__off' => "停用",
    '__ok' => "确定",
    '__old_passwd' => "原有%1密码",
    '__on' => "启用",
    '__others' => "其他",
    '__other_ip__will_be_added' => '其他可用的IP地址(将被添加至客户IP池)',
    '__out' => "流出",
    '__p' => "P",
    '__passwd' => "%1密码",
    '__passwd_is_invalid' => "%1密码无效。",
    '__passwd_not_match' => "密码不匹配!",
    '__path' => "路径",
    '__perl_unix_support' => "Perl支持",
    '__perl_win_support' => "Perl支持",
    '__perm_denied' => "拒绝访问。",
    '__permissions' => "权限",
    '__personal_name' => "个人姓名",
    '__pg_admin_not_activated' => "PostgreSQL尚未在服务器管理页启用。",
    '__pg_not_inst' => "PostgreSQL 尚未安装。",
    '__pg_not_run_or_inst' => "PostgreSQL 尚未安装或没有运行。",
    '__pg_not_support_in_key' => "许可证不支持 PostgreSQL",
    '__phone' => "电话",
    '__phosting' => "物理主机",
    '__php_support' => "PHP 支持",
    '__php_run_as_isapi' => "作为 ISAPI 扩展运行",
    '__php_safe_mode' => "PHP'safe_mode'开启",
    '__php_version' => "PHP 版本",
    '__physical' => "物理主机",
    '__plesk_stat_pdir' => "保护目录 \"/plesk-stat/webstat/\"",
    '__plesk_stat_dir_name' => "域名统计",
    '__plesk_stat_protect' => "使用用户的 FTP 用户名和密码对网站统计访问权限加以保护",
    '__plesk_stat_protect_install' => "可通过有密码保护的目录 '/plesk-stat/webstat/' 进行访问",
    '__pop3_imap' => "POP3/IMAP", // indirect
    '__pop3_status' => "POP3 服务器状态",
    '__popen_error' => "调用 popen 函数时出错。",
    '__port' => '端口',
    '__postgres' => "PostgreSQL",
    '__postgresql' => "PostgreSQL",
    '__postgresql_status' => "PostgreSQL 状态",
    '__preferences' => "设置",
    '__account_preferences' => "帐户设置",
    '__interface_preferences_general' => '常用',
    '__interface_preferences_default' => '默认界面偏好设置',
    '__interface_preferences_admin' => "管理员界面偏好设置",
    '__interface_template' => '界面自定义模板',
    '__interface_preferences' => "界面偏好设置",
    '__proceed?' => "是否继续？",
    '__protect_dir_user' => "受保护目录的用户",
    '__protect_dir_users' => "受保护目录的用户",
    '__protect_dirs' => "受保护目录",
    '__provider_contact_name' => "所有者的联系名称",
    '__python_unix_support' => "Python支持",
    '__python_win_support' => "Python支持",
    '__quota' => "配额",
    '__r' => "R",
    '__reconfigure' => "重新配置",
    '__record_type' => "记录类型",
    '__release' => "发行版本",
    '__remote_db_not_supported_by_key' => '您的许可证不支持远程数据库主机。',
    '__remove' => "移除",
    '__remove_confirmation' => "确认删除",
    '__remove_protection' => '移除受保护内容',
    '__report' => "报告",
    '__report_auto' => '发送计划',
    '__report_form' => "报告格式",
    '__report_size_na' => "服务不可用",
    '__reports_list' => "报告",
    '__requested' => "请求值",
    '__required_fields' => "必填字段",
    '__resp_name_invalid' => "自动回复名称无效。只能使用字母、数字、点、下划线和空格。",
    '__c' => "A", // Access to panel
    '__s' => "S",
    '__server_name_is_invalid' => "服务器名称无效。",
    '__screenshots' => '屏幕截图',
    '__script_warning' => "通过从域名中删除无用的脚本功能，浏览器调用时所有受影响的脚本将以明文形式显示。建议管理员从给定域名中删除所有相关脚本。",
    '__sec' => "秒",
    '__second(s)' => "秒",
    '__see_list_of_logged_in' => "查看当前登录用户的列表。",
    '__select_certs_to_remove' => "选择要删除的证书。",
    '__select_domains_to_default_host' => "选择要设为默认值的域名。",
    '__select_domains_to_remove' => "选择要删除的域名。",
    '__type_domain_name_to_add' => "请输入要添加的域名。",
    '__select_files_to_remove' => "选择要删除的文件。",
    '__select_ip' => "分配IP地址",
    '__select_ip_to_remove' => "选择要删除的 IP 地址。",
    '__select_domain_template' => "使用域名模板设置",
    '__select_templates_to_remove' => "选择要移除的模板。",
    '__server' => "服务器",
    '__server_total' => "服务器总数",
    '__service' => "服务",
    '__service_title__plesk' => "Plesk",
    '__service_description__plesk' => "Plesk",
    '__service_title__mysql' => "MySQL 数据库服务器",
    '__service_description__mysql' => "MySQL 数据库服务器",
    '__service_title__web' => "Web 服务器",
    '__service_description__web' => "Web 服务器",
    '__service_title__smtp' => "SMTP 服务器",
    '__service_description__smtp' => "SMTP 服务器",
    '__service_title__mail' => "IMAP/POP3 服务器",
    '__service_description__mail' => "IMAP/POP3 服务器",
    '__service_title__dns' => "DNS 服务器",
    '__service_description__dns' => "DNS 服务器",
    '__service_title__postgresq' => "PostgreSQL 数据库服务器",
    '__service_description__postgresq' => "PostgreSQL 数据库服务器",
    '__service_title__spamassassin' => "SpamAssassin 垃圾邮件过滤服务",
    '__service_description__spamassassin' => "SpamAssassin 垃圾邮件过滤服务",
    '__services' => "服务",
    '__all_services' => "所有服务",
    '__sessions' => "会话",
    'sessions__feature_ftp_session_manager_not_supported' => "当前的 FTP 服务器不支持 FTP 会话功能。",
    '__sessions_list' => "会话",
    '__set' => "启用",
    '__shared' => "共享",
    '__shell_access_warning' => "允许访问系统对系统安全十分危险。仅在您清楚了解自己在做什么时才允许访问系统，并且仅允许信任的用户访问系统。您真的要允许对于系统的访问吗？",
    '__siteapp_not_support_in_key' => "许可证不支持Web应用程序",
    '__siteapp_cannot_reconfigure_with_remote_database' => '该 web 应用程序的配置已被手动修改。为了保护手动修改数据，通过 Plesk 进行重新配置已被设置不可用。',
    '__site_management' => "Web 发布", // indirect
    '__size' => "大小",
    '__skeleton' => '虚拟主机模板',
    '__skins' => '皮肤',
    '__smtp' => "SMTP", // indirect
    '__smtp_status' => "SMTP 服务器状态",
    '__some_fields_are_empty_or_invalid' => "一些字段为空或者含有不正确的值。",
    '__unable_to_set_parameters' => "无法设置组件的参数",
    '__spamassassin' => "垃圾邮件过滤器",
    '__spamassassin_status' => "SpamAssassin状态",
    '__spamd_status' => '垃圾邮件过滤器状态',
    '__splited_backup' => "(多卷备份)",
    '__split_backup_file' => "创建多卷备份",
    '__split_backup_size' => "卷大小",
    '__split_backup_less_than_500' => "不支持大于500MB的卷",
    '__ssi' => "SSI",
    '__ssi_support' => "SSI支持",
    '__ssi_with_html' => "使用*.htm, *.html文件用于SSI",
    '__ssl' => 'SSL/TLS',
    '__ssl_support' => "SSL/TLS 支持",
    '__same_ssl' => "使用一个目录存放 SSL/TLS 和非 SSL/TLS 内容",
    '__same_ssl_cu' => "通用的 SSL/TLS 和非 SSL/TLS 内容",
    '__state' => "省/市/自治区",

    '__status__Active' => '活动',
    '__status__active' => '活动',
    '__status__Passive' => '已关闭',
    '__status__passive' => '禁用',
    '__status__off' => '禁用',
    '__status__with_parent' => '禁用',
    '__status__backup_restore' => '备份或恢复功能已暂时停用',
    '__status__admin' => '由管理员挂起',
    '__status__resseler' => '由零售商挂起',
    '__status__client' => '由客户挂起',
    '__status__unknown' => '未知状态',

    '__status_of' => "%1状态",
    // end of akss part

    // shramko part

    '__stunnel' => "Stunnel",
    '__stunnel_server' => "Stunnel 服务器", // indirect
    '__subdomain' => "子域名",
    '__subdomain_name' => "子域名",
    '__subdomain_name_in_ASCII_form' => "ASCII格式的子域名",
    '__subdomains' => "子域名",
    '__domainaliases' => "域名别名",
    '__subdomains_list' => "子域名",
    '__subdomains_not_support_in_key' => "许可证不支持子域名操作",
    '__sys_user_type' => "FTP 用户",
    '__sys_user_type_main' => "使用主域名的 FTP 用户帐户",
    '__sys_user_type_native' => "为子域名创建一个独立 FTP 用户帐户",
    '__t' => "T",
    '__target_domain' => "目标域名",
    '__template' => "模板",
    '__template_not_accepted' => "无法接受模板：超出下列限制。",
    '__templates' => "模板",
    '__templates_list' => "模板",
    '__tera' => "T",
    '__title' => "标题",
    '__tools' => "工具",
    '__total' => "所有%1",
    '__total_size' => "总计大小",
    '__total_used' => "总计使用",
    '__traffic' => "流量",
    '__traffic_by_client' => "客户流量",
    '__traffic_by_domain' => "域名流量",
    '__traffic_by_service' => "服务流量",
    '__traffic_history' => "流量历史",
    '__unable_change_locale' => "无法更改界面语言：%1",
    '__unable_create_new_dom' => "无法创建域名：%1",
    '__unable_define_dom_name' => "无法定义域名：%1",
    '__unable_define_necessary_properties' => "无法定义所有需要的属性。",
    '__unable_define_properties' => "无法定义属性：%1。",
    '__unable_exec_util' => "无法执行实用程序：%1",
    '__unable_get_dns_a_recs' => "无法检索 IP 地址查找该主机帐户的 A DNS 记录：%1",
    '__unable_get_mbox_quota' => "无法检索邮箱配额的信息。",
    '__unable_redirect_to_myself' => "无法转发到同一帐户。",
    '__unable_redirect_to_my_alias' => "无法转发到邮件别名。",
    '__default_domain_redirect_to_myself' => "无法将域名设置为IP地址的默认域名：\n系统检测到它会重定向到自身。",
    '__unable_remove_client' => "无法删除客户: %1",
    '__unable_set_up_mbox_quota' => "无法设置邮箱限额：%1。",
    '__unable_setup_pass' => "无法设置密码：%1。",
    '__unable_to_create_new_account' => "无法创建帐户：%1",
    '__unable_to_define_db_size' => "无法定义数据库大小。",
    '__unable_to_enable_short_names' => "无法允许POP3/IMAP帐户使用邮件缩写名。",
    '__unable_to_fetch_data_from_submit' => "无法获取提交的数据：%1",
    '__unable_to_open_file' => "无法打开文件%1: %2",
    '__unable_to_update_subdomain' => "无法更改子域名：%1。",
    '__unable_update_cl_data' => "无法保存对用户帐户所做的更改: %1",
    '__unable_update_db_params' => "无法更新数据库参数：%1。",
    '__unable_update_dom_data' => "无法更新域名信息：%1。",
    '__undefined' => "未定义",
    '__uninstall' => "卸载",
    '__unknown_error' => "未知错误",
    '__unlimited_lower' => "无限",
    '__unset' => "禁用",
    '__update' => "更新",
    '__uploaded_file_is_invalid' => "上传文件无效：%1。",
    '__url' => "URL",
    '__usage' => "磁盘空间",
    '__user' => '用户',
    '__user_already_logged' => "已有其它用户使用相同的用户名 (%1) 登录到 Plesk。",
    '__version' => "版本",
    '__aps_license' => "许可证密钥",
    '__vh_type' => "虚拟主机类型",
    '__vhosts_apache_status' => "Web 服务器状态",
    '__wrong_charset_conversion' => '字符集错误，不允许从%1转换到%2',
    '__warning_' => "警告!",
    '__warning_excl_ip_num' => "独立 IP 地址",
    '__warning_expiration' => "到期日",
    '__web_scripting' => "Web 脚本", // indirect
    '__web_serv' => "Web 服务器", // indirect
    '__web_statistic' => "网站统计", // indirect
    '__webmail' => "Web 邮箱", // +indirect
    '__webstat_not_installed' => "Webalizer目前尚未在此服务器上安装。 请联系服务器管理员来安装Webalizer。",
    '__webstat_support' => "网站统计",
    '__webstat_awstats_support' => "AWstats",
    '__webstat_webalizer_support' => "Webalizer",
    '__webstat_awstats' => "AWstats",
    '__webstat_webalizer' => "Webalizer",
    '__webstat_type_change_warning' => "当您切换统计程序时，系统会删除之前所用的统计程序创建的所有报告，还会根据从服务器上所保留的日志文件读取到的信息来创建新报告。这意味着如果您配置系统(位于“域名 > 域名 > 日志管理器 > 日志循环”)仅保留上月的日志文件，则网站统计仅适用于上月。您确定要切换到另一统计程序包吗？",
    '__webstat_perm_denied' => '您尚无管理网站统计的权限。',
    '__webuser' => "网站用户",
    '__sysusers_list' => "系统用户",
    '__sysuser' => "系统用户",
    '__weekly' => "每周",
    '__whats_new_in_version' => "Plesk %1 新增功能？",
    '__wrong_hosting_type__none' => '域名%1上没有配置主机。',
    '__wrong_hosting_type__std_fwd' => '域名 %1 已配置标准转发。该操作只适用于带有主机的域名。',
    '__wrong_hosting_type__frm_fwd' => '域名 %1 已配置帧转发。该操作只适用于带有主机的域名。',
    '__wu' => "网站用户",
    '__www' => "WWW",
    '__www_prefix_was_changed' => "WWW 前缀已更改。请务必相应地修改 SSL/TLS 证书。",
    '__year' => "年",
    '__year(s)' => "年",
    '__yes' => "是",
    '__you' => "您",
    '__zip_code' => "邮政编码",
    '__form_normal' => "正常",
    '__form_advanced' => "高级",

    'admin_ed__edit_administrator_info' => "编辑管理员信息",
    'admin_ed__create_default_client' => "我想创建一个默认客户帐户。",
    'admin_ed__unable_update' => "无法更新管理员信息：%1。",

    'auth__update_admin_info' => "请输入管理员信息。操作%1需要用到此信息。",
    'auth__you_not_have_perm' => "您无权管理此域名。",
    'auth__key_expired_admin' => '您的 Plesk 许可证已到期。要继续使用 Plesk，请续订更新您的许可证或购买新的许可证。',
    'auth__key_expired_admin_restricted' => '您的 Plesk 许可证已到期。请联系您的服务提供商以继续使用 Plesk。',
    'auth__key_expired_client' => 'Plesk 许可证已到期。请联系您的主机提供商。',
    'autoinstaller__not_installed' => '未安装自动安装程序组件。',
    'autoinstaller__release_action' => '可用操作',
    'autoinstaller__release_action_icon' => 'S',
    'autoinstaller__release_action_upgrade' => '升级到新的 Plesk 版本',
    'autoinstaller__release_action_update' => '更新或添加新组件',
    'autoinstaller__release_action_up2date' => '此为最新版',
    'autoinstaller__component_action' => '状态',
    'autoinstaller__component_action_icon' => 'S',
    'autoinstaller__component_action_install' => '尚未安装',
    'autoinstaller__component_action_update' => '有可用的更新',
    'autoinstaller__component_action_upgrade' => '有可用的更新。',
    'autoinstaller__component_action_up2date' => '此为最新版',
    'autoinstaller__component_action_error' => '更新不可用',
    'autoinstaller__component_serverbuildtime' => '最新版本',
    'autoinstaller__component_localbuildtime' => '您的版本',
    'autoinstaller__component_installed_version' => '您的版本',
    'autoinstaller__component_available_version' => '最新版本',
    'autoinstaller__component' => '组件',
    'autoinstaller__components' => '组件',
    'autoinstaller__components_title' => '%1 组件',
    'autoinstaller__component_dependency_note' => '安装所选组件时需要',
    'autoinstaller__install_confirm' => '是的，我希望安装这些组件。',
    'autoinstaller__install_confirm_request' => '请勾选复选框进行确认',
    'autoinstaller__install_title' => '确认安装所选组件。',
    'autoinstaller__key_update_confirm' => '确认跳过许可证更新，并安装默认许可证',
    'autoinstaller__key_update_confirm_request' => '请选中复选框以进行确认。',
    'autoinstaller__key_update_failed' => '<p> Plesk 无法更新您的产品许可证。</p> <p> %1</p> <p> 在没有合适的产品许可证的支持下继续升级会导致安装带有功能限制的默认许可证。建议管理员在继续产品升级之前首先获取合适的许可证密钥。</p>',
    'autoinstaller__email' => '发送通知到',
    'autoinstaller__email_admin' => "管理员的电子邮件",
    'autoinstaller__email_email' => '自定义电子邮件地址…',
    'autoinstaller__release' => '版本名称',
    'autoinstaller__releases' => '可用版本',
    'autoinstaller__releases_title' => 'Plesk 更新程序',
    'autoinstaller__select_components_to_install' => '请选择要安装的组件。',
    'autoinstaller__status_error' => '错误: %1',
    'autoinstaller__status_install_error' => '安装无法开始: %1',
    'autoinstaller__status_install_busy' => '安装无法开始：另一个安装过程正在运行。',
    'autoinstaller__status_install_ok' => '安装开始。您将通过电子邮件 (%1) 获知安装的进度。',
    'autoinstaller__status_query_busy' => '正在安装。',
    'autoinstaller__status_query_error' => '无法检索安装状态：%1。',
    'autoinstaller__status_unknown' => '无法检索自动安装程序状态。',
    'autoinstaller__status_busy' => '自动安装程序繁忙，请稍候。',
    'autoinstaller__configure_title' => '更新程序设置',
    'autoinstaller__preferences_legend' => '设置',
    'autoinstaller__target' => '临时下载目录',
    'autoinstaller__target_invalid' => "指定绝对路径",
    'autoinstaller__check_updates' => '以管理员身份登录到 Plesk 时检查更新',
    'autoinstaller__check_updates_warning' => '有可用的%2<a href="%1">更新</a>',
    'autoinstaller__source_type' => '来源类型',
    'autoinstaller__source' => '源 URL',
    'autoinstaller_source__preferences_legend' => '设置',
    'autoinstaller_source__type' => '来源类型',
    'autoinstaller_source__url_invalid' => '无效来源',
    'autoinstaller_source__url_invalid_network' => '无效的源URL (示例：http://source, ftp://source)',
    'autoinstaller_source__url' => '源 URL',
    'autoinstaller__source_invalid_network' => '您所指定的网络地址无效',
    'backup__repository' => '备份文件存储位置',
    'backup__error_notify_email' => '如果备份过程中出现错误，请发送通知到邮箱',
    'backup__dump_info' => "备份信息",
    'backup__dump_file_name_not_defined' => "尚未指定备份文件名。",
    'backup__local_file' => '本地备份文件',
    'backup__domain_ftp' => '远程FTP 服务器',
    'backup__wrong_path' => "进入备份文件存储的不正确的路径：不要使用字符的序列../../",
    'backup__unable_to_connect_to_ftp_server' => "无法连接到 FTP 服务器：%1。",
    'backup__unable_to_read_file' => '无法读取备份文件。',
    'backup__backup_task_does_not_exist' => "备份任务不存在，您必须在开始前创建备份任务。",
    'backup__restore_params' => "恢复参数",
    'backup__confirmation' => "警告: 在备份/恢复过程中域名将暂不可用。",
    'backup__backup_method' => '备份方式',
    'backup__dumpfile_name' => "备份文件名称",
    'backup__dumpfile_name_is_invalid' => "备份文件名无效: 只能使用字母数字、破折号、点和下划线，请不要使用类似description.* 的名称作为备份文件名。",
    'backup__email_required' => "请提供电子邮件地址，以便通知您备份/恢复进度。请在帐户信息页上指定电子邮件地址。",
    'backup__error_during_backup' => "无法创建备份文件：%1。",
    'backup__input_email_warning' => "您必须指定用于通知的电子邮件地址，或清空此复选框。",
    'backup__make_download' => "不要保存存储中的备份文件，只下载备份文件",
    'backup__make_dump' => '创建备份文件并存在本地存储中',
    'backup__makedump_to_ftp' => '创建备份文件并将其存储在 FTP 服务器上',
    'backup__restore_ip' => "用于恢复的 IP 地址",
    'backup__select_dumpfile' => "选择备份文件。",
    'backup__time' => "备份时间",
    'backup__day' => '备份日期',
    'backup__view_dump_info' => "查看域名%1的备份信息。",
    'backup__wrong_domain_name' => "备份文件包含的是域名%1的数据，因而不能用于恢复域名%2。",
    'backup__incorrect_ftp_user_or_passwd' => "不正确的FTP用户或密码。请修正“FTP帐户属性”",
    'backup__access_denied' => "拒绝访问。请修正“FTP帐户属性”",
    'backup__restore_from' => "恢复%1",
    'backup__domain_session_failed' => '尚未备份域名%1',
    'backup__client_session_failed' => '尚未备份客户%1',
    'backup__domain_session_restore_failed' => '尚未恢复域名%1',
    'backup__client_session_restore_failed' => '尚未恢复帐户%1',
    'backup__domain_session_complete' => '备份了域名%1',
    'backup__domain_session_backup' => '备份域名%1',
    'backup__client_session_backup' => '备份客户%1',
    'backup__domain_stop_title' => '取消备份域名%1',
    'backup__client_stop_title' => '正在取消备份客户帐户%1',
    'backup__domain_restore_stop_title' => '取消恢复域名%1',
    'backup__client_restore_stop_title' => '正在取消恢复客户帐户%1',
    'backup__domain_session_backup_stop' => '您正要取消活动的备份过程。不会创建备份文件。',
    'backup__backup_stop_confirm' => '是的，我想要停止备份过程',
    'backup__restore_stop_confirm' => '是，我想要停止恢复过程',
    'backup__domain_session_restore' => '恢复域名%1',
    'backup__domain_session_restore_stop' => '您正要取消活动的恢复过程。',
    'backup__domain_backup_file_info' => '域名备份文件信息',
    'backup__domain_backup_file_list' => '现有备份文件',
    'backup__domain_backup_progress' => '备份网站%1过程',
    'backup__domain_restore_progress' => '恢复网站%1过程',
    'backup__domain_backup_progress_elapsed_time' => '用时：%1',
    'backup__domain_restore_progress_elapsed_time' => '用时：%1',
    'backup__ip_map_legend' => 'IP映射',
    'backup__ip_map_list_count' => 'IP地址',
    'backup__domain_restore_session_complete' => '域名%1已恢复。',
    'backup__domain_restore_session_complete_message' => '域名%1已恢复。',
    'backup__domain_backup_file_delete' => '删除下列备份文件：',
    'backup__domain_backup_file_for_remove' => '选择要删除的备份文件',
    'backup__backup_overwrite_file_confirm' => '确认替换',
    'backup__backup_overwrite_file_confirm_text' => '名为“%1”的备份文件已存在。您想要替换它吗？',
    'backup__backup_confirm_overwrite' => '确认文件替换',
    'backup__backup_overwrite_legeng' => '替换',
    'backup__backup_not_contain_domain' => '备份文件不包含关于域名%1的信息',
    'backup__backup_not_contain_client' => '备份文件不包含客户帐户%1相关信息。',
    'backup__backup_client_info' => "备份客户设置和帐户详情",
    'backup__client_backup_progress' => '客户帐户%1备份过程',
    'backup__client_session_complete' => '客户帐户%1备份完成',
    'backup__client_backup_file_info' => '客户备份文件信息',
    'backup__restore_client_info' => "恢复客户设置和帐户详细信息",
    'backup__client_session_restore' => '正在恢复客户帐户%1',
    'backup__client_db_server_map' => '数据库服务器映射',
    'backup__domain_db_server_map' => '数据库服务器映射',
    'backup__client_restore_session_complete_message' => '客户帐户%1已恢复。',
    'backup__client_restore_session_complete' => '客户帐户%1已恢复。',
    'backup__restore_select_some' => '请选择要恢复的对象。',
    'backup__client_restore_progress' => '客户帐户%1恢复过程',
    'backup__new_backup' => '创建备份',
    'backup__done' => '完成：',
    'backup__done_domains' => '%2中的%1域名',
    'backup__done_clients' => '%2中的%1客户',
    'backup__remaining' => '剩余：',
    'backup__remaining_domains' => '%1域名',
    'backup__remaining_clients' => '%1客户',
    'backup__overall_backup_progress' => '整个备份过程',
    'backup__comment_n_a' => 'n/a',
    'backup__command_ignore' => '命令“%1”已忽略',
    'backup__no_objects' => '无可备份的对象',
    'backup__cli_warning_not_enough_ip' => '警告：没有足够的IP地址来执行默认的IP映射：',
    'backup__local_repository' => "Plesk 的存储",
    'backup__ftp_repository' => 'FTP 存储',
    'backup__ftp_login' => '用户名',
    'backup__ftp_password' => '密码',
    'backup__ftp_directory_hint' => '示例：/myfolder/mybackups',
    'backup__ftp_account_settings' => 'FTP帐户设置',
    'backup__ftp_account_preferences' => 'FTP帐户设置',
    'backup__repository_not_exist' => '目录不存在',
    'backup__repository_not_readable' => '指定的目录不可读',
    'backup__ftp_repository_not_configure' => '若要使用 FTP 备份存储，请首先 <a href="%1">指定 FTP 帐户</a />。',
    'backup__ftp_repository_list_not_configure' => '帐户设置未指定',
    'backup__repository_list_unable_listing' => '无法检索文件列表',
    'backup__ftp_repository_unable_listing' => '无法检索目录列表“%1”：',
    'backup__repository_legend' => '备份文件存储',
    'backup__store_in_repository' => '存储文件于',
    'backup__local_repository_lable' => '本地存储',
    'backup__ftp_repository_lable' => 'FTP 存储',
    'backup__ftp_repository_not_configure_hint' => '(帐户设置尚未指定)',
    'backup__ftp_repository_not_configure_or_forbidden_hint' => '(FTP帐户尚未指定或不受支持)',
    'backup__ftp_directory_not_exist' => '指定的目录不存在',
    'backup__other_user_process_modified' => '另一个用户停止了备份或迁移过程。',
    'backup__another_user_exist' => '正在进行的操作由其它 Plesk 用户开始。该用户仍处于登录到 Plesk 的状态。',
    'backup__ftp_repository_wait' => '正在索取有关 FTP 存储的信息请稍后',
    'backup__ftp_write_test_failed' => '向FTP帐户%1写入测试数据失败：',
    'bt_upload_to_repository' => '上传文件到本地存储',
    'bt_new_restore' => "恢复",
    'bt_backup_schedule' => "计划备份",
    'backup_exist_backups' => "现有备份文件",
    'backup_dialog__page_title' => "创建备份文件",
    'backup_dialog__please_wait' => "备份过程即将开始。 此操作可能需要一些时间。请稍候...",
    'backup_conf__page_title' => '备份配置',
    'bt_accept' => "接受",
    'bt_access' => "访问",
    'bt_action_log' => "操作日志",
    'bt_add' => "添加",
    'bt_add_client' => "分配给用户",
    'bt_database_server_add' => '添加数据库服务器',
    'bt_add_services' => "添加服务",
    'bt_anonftp_stats' => "匿名 FTP 数据",
    'bt_anonymous_ftp' => "匿名FTP",
    'bt_aspdotnet' => "ASP.NET",
    'bt_attach' => "附加",
    'bt_autoinstaller' => '更新程序',
    'bt_auto-updates' => '更新程序',
    'bt_back' => "<< 返回",
    'bt_backup' => "备份",
    'bt_backup_configure' => "备份设置",
    'bt_buy_certs' => "购买证书",
    'bt_card' => "卡",
    'bt_cert' => "证书",
    'bt_certificates' => "证书",
    'bt_change_passwd' => "更改密码",
    'bt_clear' => "清空",
    'bt_client_templates' => "客户模板",
    'bt_clients' => "客户",
    'bt_codepage_change' => '更改',
    'bt_comp_info' => "组件管理",
    'bt_configure_maillists' => "Mailman 设置",
    'bt_configure_odbc' => "ODBC数据源",
    'bt_configure' => '配置',
    'bt_copy' => "复制",
    'bt_copy_move' => "复制/移动",
    'bt_create' => "创建",
    'bt_create_account' => "创建帐户",
    'bt_create_dir' => "添加目录",
    'bt_create_file' => "添加文件",
    'bt_count_size' => "计算大小",
    'bt_crontab_unix' => "定期任务",
    'bt_crontab_win' => "任务计划程序",
    'bt_custom_button_new' => "添加按钮",
    'bt_custom_buttons' => "自定义按钮",
    'bt_customize' => "自定义",
    'bt_databases' => "数据库",
    'bt_database_servers' => '数据库服务器',
    'bt_sqlservers' => "数据库服务器",
    'bt_db_usr_new' => "添加数据库用户",
    'bt_db_new' => "添加数据库",
    'bt_db_phpmyadmin' => "MySQL管理员",
    'bt_dbuser_default' => "DB WebAdmin默认值",
    'bt_decline' => "拒绝",
    'bt_default' => "默认",
    'bt_defaultcomponents' => "第三方服务",
    'bt_defaults' => "默认",
    'bt_delete' => "删除",
    'bt_directories' => "受保护目录",
    'bt_disable' => "关闭",
    'bt_dns' => "DNS设置",
    'bt_dns_enable' => '启用',
    'bt_dns_disable' => '禁用',
    'bt_dns_default' => '重设为默认值',
    'bt_dns_zone_sync' => '应用 DNS 模板修改',
    'bt_dnsrecord_add' => '添加记录',
    'bt_do_backup' => "备份",
    'bt_do_restore' => "恢复",
    'bt_do_upload' => "上传",
    'bt_domain_aliases' => "域名别名",
    'bt_domain_templates' => "域名模板",
    'bt_domain_user' => "域名管理员",
    'bt_domain_user_passwd' => "域名管理员密码",
    'bt_domains' => "域名",
    'bt_domain_alias_add' => '添加域名别名',
    'bt_download' => "下载",
    'bt_edit' => "编辑",
    'bt_enable' => "打开",
    'bt_export' => '导出',
    'bt_extras' => "附加",
    'bt_file_manager' => "文件管理器",
    'bt_finish' => "完成",
    'bt_ftp_account' => "FTP 帐户属性",
    'bt_forget_password' => "忘记密码？",
    'bt_fp_ssl_webadmin' => "FP-SSL/TLS Webadmin",
    'bt_fp_webadmin' => "FP Webadmin",
    'bt_ftp_stats' => "FTP 数据",
    'bt_get_password' => "获取密码",
    'bt_global_changes' => "修改",
    'bt_help' => "帮助",
    'bt_hide_aliases' => "隐藏别名",
    'bt_hide_toolbar' => '隐藏工具栏',
    'bt_hide_subdomains' => "隐藏子域名",
    'bt_hide_domainaliases' => "隐藏域名别名",
    'bt_home' => "首页",
    'bt_hosting' => "主机",
    'bt_icf' => '防火墙',
    'bt_install' => "安装",
    'bt_ip_aliasing' => "IP地址",
    'bt_ip_add' => "添加 IP 地址",
    'bt_ip_pool' => "IP 地址池",
    'bt_key_info' => "许可证信息",
    'bt_key_buyonline_addons' => '订购 Plesk 附加方案',
    'bt_key_buyonline_upgrades' => '订购 Plesk 升级',
    'bt_key_buyonline_new' => '订购新的许可证',
    'bt_limits' => "限制",
    'bt_locale_add' => '添加区域设置',
    'bt_locales' => '区域设置',
    'bt_log_manager' => "日志管理器",
    'bt_login' => "登录",
    'bt_logo' => "品牌自定义",
    'bt_logo_send_link' => "附加链接",
    'bt_logo_send_logo' => "附加徽标",
    'bt_logout' => "注销",
    'bt_logrotation' => "日志轮转",
    'bt_mail' => "邮件",
    'bt_mail_alias_add' => "添加邮件别名",
    'bt_mail_aliases' => "邮件别名",
    'bt_mail_group_add' => "添加成员",
    'bt_mail_groups' => "群组",
    'bt_mail_name_add' => "添加邮件帐户",
    'bt_mail_preferences' => "设置",
    'bt_mail_group' => "邮件群组",
    'bt_mail_mailbox' => "邮箱",
    'bt_mail_redirect' => "转发",
    'bt_mail_resp_add' => "添加自动回复",
    'bt_mail_resp_attach_add' => "添加附件",
    'bt_mail_resp_files' => "附件文件",
    'bt_mail_responders' => "自动回复",
    'bt_mail_spamfilter' => "垃圾邮件过滤器",
    'bt_mail_webmail' => "Web 邮箱",
    'bt_maillist_new' => "添加邮件列表",
    'bt_maillists' => "邮件列表",
    'bt_mailman' => "Mailman",
    'bt_make_dump' => "创建备份",
    'bt_manage' => "管理",
    'bt_master' => "主控",
    'bt_migrate' => '迁移',
    'bt_modules_add' => '添加扩展',
    'bt_modules_manage' => '管理扩展',
    'bt_move' => "移动",
    'bt_mimetypes' => 'MIME类型',
    'bt_mimetype_new' => '添加MIME类型',
    'bt_new_client' => "添加客户帐户",
    'bt_new_domain' => "添加站点",
    'bt_next' => "下一个 >>",
    'bt_next_page' => "下一页",
    'bt_network_add' => "添加网络",
    'bt_notifications' => "通知",
    'bt_odbc_dsn_add' => "添加 ODBC DSN",
    'bt_off' => "停用",
    'bt_on' => "启用",
    'bt_on_off' => "开启/关闭",
    'bt_pd_new' => "添加受保护目录",
    'bt_pd_user_new' => "添加用户",
    'bt_performance' => '性能',
    'bt_permissions' => "权限",
    'bt_phpmyadmin' => "PhpMyAdmin",
    'bt_postgre_sql' => "PostgreSQL",
    'bt_preferences' => "设置",
    'bt_prev_page' => "上一页",
    'bt_preview' => '网站预览',
    'bt_print' => "打印",
    'bt_reboot' => "重启",
    'bt_reload' => "重新加载",
    'bt_refresh' => "刷新",
    'bt_register' => "注册",
    'bt_remove' => "移除",
    'bt_enable_selected' => '打开',
    'bt_disable_selected' => '关闭',
    'bt_repair_ip' => "修复 IP",
    'bt_report' => "报告",
    'bt_report_auto' => '报告发送',
    'bt_report_auto_new' => '添加发送计划',
    'bt_report_new' => "添加布局",
    'bt_reset' => "重设",
    'bt_restart_services' => "服务管理",
    'bt_save' => "保存",
    'bt_send_by_email' => "通过电子邮件发送",
    'bt_send_file' => "上传文件",
    'bt_send_mail' => "发送邮件",
    'bt_send_passwd' => "发送密码",
    'bt_send_text' => "发送文本",
    'bt_server' => "服务器",
    'bt_server_add' => "添加服务器",
    'bt_server_preferences' => "服务器设置",
    'bt_servers_list' => "服务器",
    'bt_sessions' => "会话",
    'bt_set' => "设置",
    'bt_set_as_default' => "设为默认值",
    'bt_setup' => '设置',
    'bt_show_aliases' => "显示别名",
    'bt_show_subdomains' => "显示子域名",
    'bt_show_domainaliases' => "显示域名别名",
    'bt_shutdown' => "关机",
    'bt_site_apppkgs' => "应用百宝箱",
    'bt_site_apppool' => "应用程序池",
    'bt_application-pool' => "Web应用程序",
    'bt_site_apps' => "Web应用程序",
    'bt_site_app_add' => "安装应用程序",
    'bt_site_builder' => "Presence Builder 支持",
    'bt_skeleton' => '虚拟主机模板',
    'bt_skins' => '皮肤',
    'bt_skin_add' => '添加皮肤',
    'bt_skin_manual' => '自定义 Plesk 皮肤参考', // not used
    'bt_skin_download' => '下载外观',
    'bt_skin_replace' => '更新外观',
    'bt_skip' => '跳过',
    'bt_spamassassin' => "垃圾邮件过滤器",
    'bt_spamassassin_train' => "培训",
    'bt_spamfilter' => "垃圾邮件过滤器",
    'bt_sshterm' => 'SSH 终端',
    'bt_start' => "启动",
    'bt_stop' => "停止",
    'bt_recycle' => "回收",
    'bt_statistics' => "统计",
    'bt_subdomain_new' => "添加子域名",
    'bt_subdomains' => "子域名",
    'bt_submit' => "提交",
    'bt_summary_report' => "概要报告",
    'bt_support' => "支持",
    'bt_switch' => "切换",
    'bt_system_time' => "系统时间",
    'bt_task_new' => "添加任务",
    'bt_dom_tmpl_add' => '添加域名模板',
    'bt_cl_tmpl_add' => '添加自定义模板',
    'bt_cron_backup' => '计划的备份设置',
    'bt_test' => "测试",
    'bt_text' => "文本",
    'bt_touch' => "更改时间戳",
    'bt_traffic' => "流量",
    'bt_traffic_history' => "流量历史",
    'bt_update' => "更新",
    'bt_upload' => "上传",
    'bt_upload_from_ftp' => "FTP 上传",
    'bt_virtualdirs' => '虚拟目录',
    'bt_virtualdir_new' => '添加虚拟目录',
    'bt_virtualdir_add' => '添加虚拟目录',
    'bt_web_app_new' => "安装Java应用程序",
    'bt_web_stats' => "网站统计",
    'bt_web_stats_ssl' => "网站统计 SSL/TLS",
    'bt_web_user_add' => "添加网站用户",
    'bt_web_users' => "网站用户",
    'bt_webadmin' => "Webadmin",
    'bt_webalizer' => "Webalizer",
    'bt_whats_new_full' => "参见完整的新功能列表",
    'cert_add__unable_set_ca_cert' => "无法设置 CA 证书：%1。",
    'cert_add__unable_set_cert' => "无法设置证书：%1。",
    'cert_add__unable_set_private_key' => "无法设置私钥：%1。",
    'certificates_list__certificate_used_as_default' => "您要删除的证书中有一个被用作默认的证书。",
    'certificates_list__certificates_assigned_on_ip' => "一个或多个证书已被分配给该 IP 地址/域名。",
    'ch_pass__admin_pass' => "更改管理员密码",
    'ch_pass__old_pass' => "旧密码",
    'ch_pass__pass_confirm' => "确认",
    'ch_pass__unable_change_admin_pass' => "无法更改管理员的密码：%1",
    'check_mail_cycle__aliases' => "检测到邮件循环，地址 \"%1\" 包含在此邮件帐户的别名中。",
    'check_mail_cycle__autoresponders' => "检测到邮件循环，地址 \"%1\"包含在此邮件帐户的自动回复中。",
    'check_mail_cycle__mail_groups' => "检测到邮件循环，地址 \"%1\" 包含在此邮件帐户的邮件群组中。",
    'check_mail_cycle__mail_name' => "检测到邮件循环，地址 \"%1\" 与此邮件帐户相符。",
    'check_mail_cycle__redirect' => "检测到邮件循环，地址 \"%1\" 与此邮件帐户的 forwarder 相符。",
    'check_mail_dup__redirect' => "检测到重复的转发，地址“%1”与此邮件帐户的转发目标相同。",
    'check_mail_dup__mail_groups' => "检测到重复的转发，地址 \"%1\" 包含在此邮件帐户的邮件群组里。",
    'check_maillist_cycle__admin' => "检测到邮件循环，管理员的电子邮件  \"%1\" 与邮件列表的地址相符。",
    'check_maillist_cycle__member' => "检测到邮件循环，地址 \"%1\" 与邮件列表的地址相符。",
    'chk_js__enter_login_and_passwd' => "输入用户名和密码。",
    'chk_js__enter_login_name' => "输入用户名。",
    'chk_js__enter_passwd' => "输入密码。",

    // end of shramko part

    // serge part
    'cl_ed__edit_cl' => "%1 的帐户信息",
    'cl_limits__cl' => "客户%1的限制",
    'cl_logo__setup_logo_pref' => "设置客户%1的徽标属性",
    'cl_new__enter_new_cl_data' => "输入新客户信息",
    'cl_new__unable_to_sent_notification' => '已创建用户帐户，但发送客户通知失败: %1',
    'cl_perm__all_ip' => "所有可用的 IP",
    'cl_perm__all_ip_based_hst_will_be_nb' => "客户的所有基于IP的主机帐户都将被转换为基于名称的主机。",
    'cl_perm__allow_client_create_domain' => "您尝试选择的字段仅适用于有权创建域名的客户。",
    'cl_perm__allow_create_nb_w_ip' => "客户可以使用%1创建基于名称的主机",
    'cl_perm__allow_creation_ip_based_hosting' => "允许创建基于 IP 的主机帐户",
    'cl_perm__available_ips' => "可用 IP",
    'cl_perm__change_limits' => "限制调整",
    'cl_perm__cl_disk_space' => "总计可用的磁盘空间",
    'cl_perm__cl_expiration' => "客户帐户有效期",
    'cl_perm__cl_max_box' => "邮箱",
    'cl_perm__cl_max_db' => "数据库",
    'cl_perm__cl_max_dom' => "域名",
    'cl_perm__cl_max_maillists' => "邮件列表",
    'cl_perm__cl_max_subdom' => "子域名",
    'cl_perm__cl_max_traffic' => "可用的总流量",
    'cl_perm__cl_max_wu' => "网站用户",
    'cl_perm__cl_mbox_quota' => "此用户帐户的最大邮箱配额",
    'cl_perm__current_maximum_exp_date' => "当前域名的最大有效期为%1；请求%2。",
    'cl_perm__current_maximum_mailbox_quota' => "当前定义的为该用户帐户下的邮箱分配的磁盘空间量限制为%1；请求%2。",
    'cl_perm__current_total_requested' => "当前%1的域名限制总值为%2；请求%3。",
    'cl_perm__current_total_requested_dom' => "当前属于此客户%1的数量为%2；请求%3。",
    'cl_perm__disk_space' => "最大磁盘空间",
    'cl_perm__dashboard_stdgui' => '用户界面',
    'cl_perm__dashboard' => '首页视图',
    'cl_perm__stdgui' => '标准视图',
    'cl_perm__manage_dashboard' => '首页管理',
    'cl_perm__dashboard_and_stdgui' => '允许首页视图和标准视图',
    'cl_perm__dashboard_only' => '仅允许首页视图',
    'cl_perm__stdgui_only' => '仅允许标准视图',
    'cl_perm__edit_cl' => "客户%1的权限",
    'cl_perm__exp_date_exceeded' => "您尝试设置的验证周期超出了在该客户的个别域名中指定的限制。",
    'cl_perm__invalid_value' => "无效值，只能使用数字。",
    'cl_perm__limit_disk_space' => "%1 限定总磁盘空间量",
    'cl_perm__limit_expiration' => "%1限定客户帐户的有效期",
    'cl_perm__limit_max_box' => "%1 限定邮箱的最大数量",
    'cl_perm__limit_max_db' => "%1 限定数据库的最大数量",
    'cl_perm__limit_max_dom' => "%1 限定域名的最大数量",
    'cl_perm__limit_max_maillists' => "%1 限定邮件列表的最大数量",
    'cl_perm__limit_max_subdom' => "%1 限定子域名的最大数量",
    'cl_perm__limit_max_traffic' => "%1 限定总流量",
    'cl_perm__limit_max_wu' => "%1 限定网站用户的最大数量",
    'cl_perm__limit_mbox_quota' => "%1 限定最大邮箱限额",
    'cl_perm__limits_exceeded' => "您尝试设置的一或多项限制超出了此客户的单个域名限制。\n对于客户帐户的域名设置的限制总数不能超过对于此客户的限制总数。",
    'cl_perm__mailbox_quota_exceeded' => "您尝试设置的邮箱配额超出了此客户域名中定义的限制。",
    'cl_perm__mailbox_quota_exceeds_server_limit' => "您试图设置的分配给邮箱的磁盘空间超出定义的服务器级限制。",
    'cl_perm__make_dumps' => "备份和恢复数据",

    'cl_perm__max_box' => "最大邮箱数量",
    'cl_perm__max_db' => "最大数据库数量",
    'cl_perm__max_dom' => "域名",
    'cl_perm__max_maillists' => "最大邮件列表数量",
    'cl_perm__max_subdom' => "子域名",
    'cl_perm__max_traffic' => "最大流量",
    'cl_perm__max_wu' => "最大网站用户数量",
    'cl_perm__max_dom_aliases' => "域名别名",
    'cl_perm__mbox_quota' => "邮箱配额",
    'cl_perm__not_allow_create_nb_hst' => "客户无法创建基于名称的主机。",
    'cl_perm__select_ip_addrs' => "选择IP地址",
    'cl_perm__this_ip_used_vrt_hst' => "此IP地址用于虚拟主机。\n要删除此IP地址，请删除主机服务或将主机类型更改为基于名称。",
    'cl_perm__unable_off_ipb_creating' => "客户已经设置了基于IP的主机服务。要禁用该功能，请清空 \"域名创建\" 复选框或删除所有基于IP的主机服务帐户。",
    'cl_perm__unable_off_nb_creating' => "客户已经设置了基于名称的主机服务。要禁用该功能，请清空 \"域名创建\" 复选框或删除所有基于名称的主机服务帐户。",
    'cl_perm__unable_set_domain_limit' => "无法限制域名的最大数量: 客户已经拥有%1个域名",
    'cl_perm__unable_update_client_limitations' => "无法修改客户帐户限制: %1",
    'cl_pref__edit_cl' => "客户%1的偏好设置",
    'class_anonftp__create_ftp_domain' => "此域名 ID 没有 FTP 虚拟域名，请先创建。",
    'class_anonftp__incoming_disk_space_should_be_lower' => "您试图设置的磁盘空间限制(%1)不应超过所定义的域名级总磁盘空间限制(%2)。",
    'class_anonftp__invalid_input_only_digits' => "指定值无效，只能使用数字。",
    'class_anonftp__unable_change_ownerships' => "无法更改配额文件的所有者和权限：%1。",
    'class_anonftp__unable_copy_quota_file' => "无法复制配额文件：%1。",
    'class_anonftp__unable_get_disk_usage' => "无法检索接收目录的磁盘空间使用信息：%1。",
    'class_anonftp__unable_parse_quota_file' => "无法分析配额文件。",
    'class_anonftp__unable_read_quota_file' => "无法读取配额文件：%1。",
    'class_anonftp__unable_update_quota' => "无法更新配额: 在接收目录里的文件使用了%1 KB的磁盘空间，它超过了新的配额值。",
    'class_anonftp__unable_write_temp_file' => "无法写入临时文件：%1。",
    'class_bsdomain__warn_max_date__' => "过期日设为%1",
    'class_cList__empty' => "尚无项目。",
    'class_cList__header' => "%1 (%2)",
    'class_cList__not_found' => "尚未在%2中找到<b>“%1”</b>的匹配项 (%4中的%3)。",
    'class_cList__search_result' => "在 %2 中搜索 <b>\"%1\"</b> 的结果(%4 中的 %3)",
    'class_client__client_creation_notification' => "客户创建通知。",
    'class_client__client_with_contact_name_already_exists' => "名为%1的客户已存在。",
    'class_client__disk_space' => "磁盘空间",
    'class_client__invalid_max_dom' => "无效的域名数量值，只能使用数字。",
    'class_client__limit_exceed' => "%1所请求的量无法分配，因为这超出了客户%2的帐户分配(%3)。如果您要分配更多的资源，请转到“客户 > 客户名称 > 限制”并按照需要更改分配。然后返回此屏幕并尝试再次调整分配。",
    'class_client__limit_exceed_unlimited' => "如果您要分配无限的资源量(%1)，那么您应转到“客户 > 客户名称 > 限制”并选中与所选资源类型相对应的“无限”复选框。然后返回此屏幕并尝试再次调整分配。",
    'class_client__max_box' => "邮箱",
    'class_client__max_db' => "数据库",
    'class_client__max_maillists' => "邮件列表",
    'class_client__max_subdom' => "子域名",
    'class_client__max_traffic' => "最大流量",
    'class_client__max_wu' => "网站用户",
    'class_client__max_dom_aliases' => "域名别名",
    'class_client__mbox_quota' => "邮箱配额",
    'class_client__unable_define_cl_status' => "无法定义客户帐户状态: %1",
    'class_client__unable_define_inactive_dom' => "无法定义非活动域名%1。",
    'class_client__unable_del_ip' => "无法删除 IP：%1",
    'class_db__db_name_not_set' => "尚未定义数据库名称。",
    'class_db__db_not_exist_for_curr_dom' => "此域名没有数据库。",
    'class_db__invalid_db_or_dom_name' => "域名或数据库ID无效，或尚未定义数据库名称。",
    'class_db__invalid_pass' => "密码无效。",
    'class_db__mailgrp_member_exist' => "邮件群组成员已存在。",
    'class_db__access_hosts_notsupport' => '此数据库类型不支持访问主机设置',
    'class_db__unable_add' => '无法添加主机访问记录：%1',
    'class_db__unable_del' => '无法删除主机访问记录：%1',
    'class_db__inc_user_not_exist' => '数据库用户%1不存在',
    'class_db__inc_access_record_exist' => '此访问记录已存在',
    'class_db__inc_access_record_not_exist' => '指定的访问记录不存在',
    'class_db__inc_unable_del_last_record' => '无法删除最后一次主机访问记录',
    'class_domtmpleditform__dns_master' => "主控",
    'class_domtmpleditform__dns_slave' => "从属",
    'class_domtmpleditform__dns_type' => "域名 DNS 区域类型",
    'class_traffichistory__no_data_available' => "尚无可用数据。",
    'class_traffichistory__traffic_usage' => "流量使用",
    'clienttrafficlist_header' => "域名流量",
    'clienttrafficlist_header_of_client__' => "客户%1的域名流量",
    'cmd_dns__a_dns_record_already_exist' => "该记录将会与用于区域的 A 记录相冲突。",
    'cmd_dns__domain_last_ns' => '无法删除域名最后的 NS DNS 记录。',
    'cmd_dns__canonical_dom_name_is_invalid' => "规范域名无效。",
    'cmd_dns__cname_dns_record_already_exist' => "该记录将会与用于区域的 CNAME 记录相冲突。",
    'cmd_dns__cname_in_rr_combination' => 'DNS区域中的资源记录组合错误',
    'cmd_dns__cname_coexist_with_data' => 'CNAME DNS记录无法与同一区域中的其他DNS记录共存。',
    'cmd_dns__dns_record_type_is_invalid' => "DNS记录类型无效。",
    'cmd_dns__ext_host_is_not_resolved' => "规范名称 %1 不会解析为A 或AAAA记录。",
    'cmd_dns__domain_restore_dns_zone_failed_add_record' => '无法添加 %1 记录到区域 %2：%3',
    'cmd_dns__mail_dom_name_is_invalid' => "邮件 exchanger 名称无效。",
    'cmd_dns__mx_priority_is_invalid' => "MX 优先级无效。",
    'cmd_dns__name_server_is_invalid' => "域名服务器无效。",
    'cmd_dns__network_mask_should_be_24_16_or_8' => "网络掩码必须为 24、16 或 8。",
    'cmd_dns__this_dns_record_already_exists' => "相同 DNS 记录已存在。",
    'cmd_dns__unable_add_record' => "无法添加%1记录：%2",
    'cmd_dns__unable_add_a_record' => "无法添加 A 记录：%1",
    'cmd_dns__unable_add_cname_record' => "无法添加 CNAME 记录：%1。",
    'cmd_dns__unable_add_dns_record' => "无法添加DNS记录: %1。",
    'cmd_dns__unable_add_ext_ns_record' => "无法添加 EXT_NS 记录：%1",
    'cmd_dns__unable_add_ns_record' => "无法添加 NS 记录：%1",
    'cmd_dns__unable_add_ptr_record' => "无法添加 PTR 记录：%1",
    'cmd_dns__unable_add_txt_record' => "无法添加TXT记录：%1",
    'cmd_dns__unable_create_dns_zone' => "无法创建 DNS 区域 %1",
    'cmd_dns__unable_define_dns_record' => "无法定义DNS记录%1。",
    'cmd_dns__unable_get_default_dns_zone_status_set_true' => "无法检索默认的 DNS 区域状态：%1",
    'cmd_dns__unable_insert_a_record' => "无法插入 A 记录：%1",
    'cmd_dns__unable_insert_mx_record' => "无法插入 MX 记录：%1",
    'cmd_dns__unable_insert_ns_record' => "无法插入 NS 记录：%1",
    'cmd_dns__unable_set_dns_zone_status' => "无法设置  DNS 区域状态：%1",
    'cmd_domains__dom_already_exists' => "域名%1已存在。",
    'cmd_domains__dns_record_already_exists' => "因对应于主机%1的DNS记录已存在，从而无法创建域名%1。",
    'cmd_domains__dom_already_exists1' => "此域名中存在 %2 个子域名，域名%1已存在。",
    'cmd_domains__dom_already_exists2' => "子域名%1已存在",
    'cmd_domains__dalias_already_exists' => "此别名已存在。",
    'cmd_domains__domain_alias_already_exists' => '相同名称的域名别名已经存在。',
    'cmd_domains__unable_del_mail_for_dom' => "无法删除域名的邮件服务：%1。",
    'cmd_domains__unable_delete_anonymous_ftp' => "无法删除域名%1的匿名 FTP 帐户。",
    'cmd_domains__unable_update_dom_param' => "无法更新域名参数：%1。",
    'cmd_domains__unable_rename_client_exist' => "域名管理员的用户名已在使用中。",
    'cmd_hosting__hst_type_is_not_physical_hst' => "主机类型不是本机域名。",
    'cmd_hosting__unable_create_user' => "无法创建用户 %2：%1。",
    'cmd_hosting__unable_define_ip_addr_for_name_based_virtual_hosts' => "无法为基于名称的虚拟主机定义 IP 地址：%1。",
    'cmd_hosting__unable_del_old_hst' => "无法删除之前设置的主机：%1",
    'cmd_hosting__unable_del_protected_directory' => "无法删除受保护目录: %1。",
    'cmd_hosting__unable_del_web_user' => "无法删除网站用户：%1。",
    'cmd_hosting__unable_make/update_virtual_host' => "无法创建或更新虚拟主机：%1。",
    'cmd_hosting__unable_make_frame_forward_hst' => "无法设置帧转发主机。",
    'cmd_hosting__unable_rebuild_ftp_config' => "无法重新建立proftpd配置文件: %1。",
    'cmd_hosting__unable_set_up_ssl' => "无法设置 SSL/TLS：%1.",
    'cmd_hosting__unable_unprotect_ssl_directory' => "无法从 SSL/TLS 目录移除保护：%1",
    'cmd_hosting__unable_update_dest_url' => "无法更新目标URL %1。",
    'cmd_hosting__unable_update_dns_zone_for_dom_unable_exec_util' => "无法更新域名的 DNS 区域：实用程序执行失败。",
    'cmd_hosting__unable_update_ftp_passwd' => "无法更新FTP密码%1。",
    'cmd_hosting__unable_update_user' => "无法更新用户 %2：%1。",
    'cmd_hosting__unknown_hst_type' => "未知主机型号。",
    'cmd_hosting__you_not_have_permission_del_hst' => "您无权终止主机服务。",
    'cmd_mail__autoresponder__not_configured' => "此邮件帐户未配置自动回复功能",
    'cmd_mail__addr_already_used_in_mail_redirect' => "地址%1已被用于邮件转发。",
    'cmd_mail__alias_already_exists' => "别名已存在。",
    'cmd_mail__autoresp_id_and_mailname_id_not_match' => "自动回复ID和邮箱帐户ID不匹配。",
    'cmd_mail__autoresp_id_is_undefined' => "自动回复ID未定义。",
    'cmd_mail__mail_alias_already_exists_in_mail_name' => "邮件帐户 %1 已存在相同名称的邮件别名。",
    'cmd_mail__mail_name_already_exists_in_maillists' => "邮件帐户%1已存在于邮件列表中。",
    'cmd_mail__mail_name_alredy_exist_in_dom' => "邮件帐户%1已在此域名中。",
    'cmd_mail__mail_name_not_exist' => "此邮件帐户不存在。",
    'cmd_mail__mail_name_passwd_part' => "密码不可以包含邮件帐户名。",
    'cmd_mail__maillist_already_exist_in_this_dom' => "此域名已存在邮件列表 %1。",
    'cmd_mail__mailname_already_exist_in_mg' => "邮件帐户%1已存在于邮件群组中。",
    'cmd_mail__mailname_already_exist_in_this_dom' => "邮件帐户%1已在此域名中。",
    'cmd_mail__mailname_already_exists' => "邮件帐户已存在。",
    'cmd_mail__mailname_is_invalid' => "邮件帐户名%1无效。",
    'cmd_mail__mailname_unable_update' => "无法更新邮件帐户属性：",
    'cmd_mail__max_autoresp_reached_for_this_dom' => "已达到此域名的最大自动回复数量。",
    'cmd_mail__max_mail_groups_num_has_been_reached_for_this_dom' => "已达到此域名的最大邮件群组数量。",
    'cmd_mail__max_num_of_redirects_has_been_reached_for_this_dom' => "已达到此域名的最大转发器数量。",
    'cmd_mail__max_postboxes_num_has_been_reached' => "已达到邮箱最大数量。",
    'cmd_mail__no_members_specified' => "尚未指定成员。",
    'cmd_mail__the_passwd_is_too_simple_choose_another' => "密码太简单，请选择其他密码。",
    'cmd_mail__this_addr_already_exist_in_mg_or_mn' => "此电子邮件地址已在使用。",
    'cmd_mail__unable_define_autoresp_id' => "无法定义自动回复ID%1。",
    'cmd_mail__unable_update_mail_for_dom' => "更改域名%1的邮件服务设置失败",
    'cmd_mail__unable_del_mail_for_dom' => "无法从域名%1中删除邮件服务。",
    'cmd_mail__unable_del_mail_redirection' => "无法删除邮件转发服务%1。",
    'cmd_mail__unable_remove_autoresp' => "无法删除自动回复: %1",
    'cmd_mail__unable_remove_mail_group_members' => "无法删除邮件群组成员：%1。",
    'cmd_mail__unable_turn_off_mail_group' => "禁用邮件群组失败：%1",
    'cmd_mail__unable_update_mail_redirect' => "无法重新配置邮件转发服务%1。",
    'cmd_mail__uploaded_file_is_too_big' => "上传文件过大。",
    'cmd_mail__additionally' => "此外：",
    'cmd_pd__invalid_login' => "用户名错误。",
    'cmd_pd__this_user_already_exist' => "相同用户已存在。",
    'cmd_pd__unable_define_hst_type' => "无法定义主机类型。",
    'cmd_pd__unable_upd_pd_usr' => "无法更新受保护目录用户属性: %1。",
    'cmd_pd__user_is_undefined' => "用户未定义。",
    'cmd_server__no_enough_free_disk_space' => "磁盘空间不足。",
    'cmd_server__old_passwd_is_incorrect_please_try_again' => "原有密码错误。请重试。",
    'cmd_web_usr__max_web_users_reached_for_this_dom' => "已达到此域名的最大网站用户数限制。",
    'cmd_web_usr__unable_create_user' => "无法创建系统用户：%1",
    'cmd_web_usr__unable_define_max_web_users_limit' => "无法定义最大网站用户数量：%1。",
    'cmd_web_usr__user_already_exists' => "用户已存在。",
    'cmd_web_usr__web_user_name_is_invalid' => "网站用户名%1无效。",
    'cmd_web_usr__web_user_not_exist' => "网站用户不存在。",
    'common_func__exec_bad_argument' => "exec 参数不应包含单引号。",
    '__eol' => '换行符',
    'eol__binary_file' => '无法更改二进制文件中的换行符风格。',
    'comp_info__header' => '组件',
    'comp_info__comp_name' => "组件名",
    'comp_info__comp_disabled' => '已关闭',
    'comp_info__comp_active' => '活动',
    'comp_info__comp_not_configured' => '未配置',
    'comp_info__comp_not_started' => '未启动，请查看组件设置',
    'comp_info__comp_version' => "组件版本",
    'comp_info__integration_error' => "整合错误",
    'comp_info__title' => "Plesk 组件",
    'comp_info__service_name' => "服务",
    'comp_info__last_updated' => '(上次更新：%1)',
    'cp_access_admin_deny' => "根据当前应用的限制 IP 访问策略，管理员不能从地址 '%1' 进行访问。",
    'create_domain_warn__' => "域名创建过程中出现下列异常：",
    'create_domain__client_select' => '选择创建域名的客户',

    'dashboard__nav_button_name' => "首页",
    'dalias__list_title' => '域名%1的域名别名',
    'dalias__list_legend' => '域名别名',
    'dalias__list_header' => '域名别名',
    'dalias__list_status' => 'S',
    'dalias__list_name' => '域名别名',
    'dalias__list_ascii_name' => '使用ASCII形式',
    'dalias__remove_title' => '域名%1的下列别名将被删除：',
    'dalias__select_domain_aliases_to_remove' => '选择要删除的域名别名。',
    'dalias__mail_turn_on_failed' => '无法启用邮件服务：%1',
    'dalias__web_turn_on_failed' => '无法启用Web服务: %1',
    'db_usr_edit__db_usr_name_old' => "旧数据库用户名",
    'database_server_edit_form__cannot_infer_type' => '无法从所提供的数据中推断出连接方法。指定"127.0.0.1" 为通过TCP/IP与提供的端口进行连接的数据库服务器主机名，或将端口字段留空以使用Unix套接字 "%1"。',
    'database_server_edit_form__duplicate' => '使用此主机地址和端口号的数据库服务器已注册。',
    'database_server_edit_form__host_is_invalid' => '指定的主机名无效。',
    'database_server_edit_form__port_is_invalid' => '指定的端口码无效。',
    'database_server_error__consult_admin' => '请联系服务器管理员。',
    'database_server_error__last__connection_failed' => '由于网络问题，控制此数据库服务器的最后一次尝试失败。',
    'database_server_error__last__permission_denied' => '由于所提供的帐户没有管理权限，控制此数据库服务器的最后一次尝试失败。',
    'database_server_error__last__credentials_not_set' => "上一次尝试连接该服务器失败因为未指定有效的管理员用户名和密码。",
    'database_server_error__last__other_error' => '控制此数据库服务器的最后一次尝试失败。',
    'database_server_error__real__connection_failed' => '由于网络问题，无法连接此数据库服务器。',
    'database_server_error__real__permission_denied' => '由于所提供的帐户没有管理权限，无法连接此数据库服务器：',
    'database_server_error__real__duplicate_object' => '由于名称冲突，无法连接此数据库服务器：',
    'database_server_error__real__unacceptable_name' => '由于对象名称无效，无法连接此数据库服务器：',
    'database_server_error__real__unacceptable_password' => '由于密码不可接受，无法连接此数据库服务器。',
    'database_server_error__real__credentials_not_set' => "Plesk 无法连接到数据库服务器因为未指定有效的管理员用户名和密码。",
    'database_server_error__real__other_error' => '连接此数据库服务器失败:',
    'database_server_error__test__connection_failed' => '因网络问题导致测试连接数据库服务器失败：',
    'database_server_error__test__permission_denied' => '测试连接数据库服务器失败因为提供的帐户没有管理权限：',
    'database_server_error__test__duplicate_object' => '因名字冲突导致测试连接数据库服务器失败：',
    'database_server_error__test__unacceptable_name' => '因无效的对象名称导致测试连接数据库服务器失败：',
    'database_server_error__test__unacceptable_password' => '因不可接受的密码导致测试连接数据库服务器失败：',
    'database_server_error__test__credentials_not_set' => "测试连接该服务器失败因为未指定有效的管理员用户名和密码。",
    'database_server_error__test__other_error' => '测试连接数据库服务器失败：',

    'db__create_new_db' => "添加数据库",
    'db__db_add' => "添加数据库",
    'db__db_for_dom' => "网站%1的数据库",
    'db__db_id_undefined' => "未定义数据库ID。",
    'db__db_name' => "数据库名称",
    'db__db_not_exist' => "数据库并不存在。",
    'db__db_type' => "类型",
    'db__db_server' => "数据库服务器",
    'db_server_not_exist' => "数据库服务器不存在。",
    'db__db_user_not_exist' => "数据库用户不存在。",
    'db__domain_not_exist' => "域名不存在。",
    'db__enter_db_name' => "输入新数据库名。",
    'db__invalid_db_id' => "数据库标识符无效。",
    'db__invalid_db_name' => "数据库名无效。数据库名应只包含拉丁字母表字符、数字或破折号。它不可以超过63个符号。",
    'db__max_db_reached_for_dom' => "已达到此域名的数据库数量上限。",
    'db__max_mssql_db_reached_for_dom' => "已达到此域名的 Microsoft SQL Server 数据库数量上限。",
    'db__postgres_not_connect_for_admin' => "无法连接到PostgreSQL。请在服务器管理页面上启用PostgreSQL支持。",
    'db__postgres_not_connect_for_client' => "无法连接到PostgreSQL。请向系统管理员寻求帮助。",
    'db__remove_db_on_domain' => "客户%1所有的网站%2的下列数据库将被删除:",
    'db__remove_db_on_domain_of_cl' => "客户%1名下域名%2的下列数据库将被删除:",
    'db__remove_db_linked_resource' => '此数据库被web应用程序使用。只有卸载该web应用程序后才能删除此数据库。',
    'db__remove_db_users' => "客户%1名下网站%2上数据库%3的下列用户将被删除:",
    'db__remove_db_users_of_cl' => "客户%1名下网站%2上数据库%3的下列用户将被删除:",
    'db__select_db_for_remove' => "选择要删除的数据库。",
    'db__select_db_users_for_remove' => "选择要删除的数据库用户。",
    'db__unable_create_db_user' => "无法创建数据库用户：%1。",
    'db__unable_define_db_name' => "无法定义数据库名：%1。",
    'db__unable_define_db_user' => "无法定义数据库用户：%1。",
    'db__unable_define_db_users' => "无法定义数据库用户：%1。",
    'db__unable_select_dom_name' => "无法选择域名：%1。",
    'db_edit__db_for_dom' => "域名%2上数据库 %1 的用户",
    'db_edit__invalid_db_name' => "数据库名无效。",
    'db_edit__no_users' => "尚无用户拥有此数据库的凭据。",
    'db_edit__unable_define_db_usrs' => "无法定义数据库用户：%1。",
    'db_edit__unable_select_db_usr' => "无法选择数据库用户。",
    'db_edit__db_user_password_for_' => "请输入数据库用户%1的登录密码",
    'db_list__tab_title_db_type' => "T",
    'db_usr_edit__add_db_usr' => "添加数据库用户",
    'db_usr_edit__db_usr_name' => "数据库用户名",
    'db_usr_edit__edit_db_usr' => "数据库用户编辑",
    'db_usr_edit__for_db' => "用于 %1 数据库",
    'db_usr_edit__not_create_pass' => "此操作将导致创建一个没有密码的数据库用户帐户。\n您希望创建一个没有指定密码的用户吗？",
    'dbuser__only_one_user_can_be_default' => "只能将一名用户设为默认值。",
    'db_server__cannot_delete_default' => "无法删除默认数据库服务器。",
    'db_server__cannot_delete_local' => "无法删除本地数据库服务器。",
    'db_server__cannot_delete_used' => '如果数据库服务器上有托管数据库或数据库用户则无法删除该数据库服务器。',
    'demo__disabled_in_demo' => "此操作在演示版本中不可用。",
    'defaultcomponents__title' => "选择默认组件",
    'defaultcomponents__select_default' => "选择默认%1组件",//to check
    'defaultcomponents__not_installed' => "(尚未安装)",
    'defaultcomponents__not_configured' => "(未配置)", // to check
    'defaultcomponents__not_opted_to_install_support_files' => "某些服务目录包含无效选项，或尚无可用选项。",
    'defaultcomponents__depends_on' => "(要求 %1)",
    'defaultcomponents__parameters' => "%1 的参数",
    'component_name__antivirus' => "防病毒程序",
    'component_name__database' => "SQL 服务器",
    'component_name__sqladmin' => "MySQL Web Admin",
    'component_name__sqladminmysql' => "MySQL Web Admin",
    'component_name__dnsserver' => "DNS 服务器",
    'component_name__firewall' => "防火墙",
    'component_name__ftpserver' => "FTP 服务器",
    'component_name__java' => "Java",
    'component_name__mailserver' => "邮件服务器",
    'component_name__local_mailserver' => "本地邮件服务器",
    'component_name__psa' => "Plesk",
    'component_name__script' => "Web 脚本",
    'component_name__spamfilter' => "垃圾邮件过滤器",
    'component_name__stats' => "网站统计",
    'component_name__stunnel' => "SSL/TLS Wrapper",
    'component_name__webmail' => "Web 邮箱",
    'component_name__webpublish' => "Web 发布",
    'component_name__webserver' => "Web 服务器",
    'dns__dns_record_invalid_values' => '指定了不正确的 DNS 记录值：%1: %2',
    'dns__dns_record_not_found' => 'DNS 记录未找到',
    'dns__dns_zone_invalid_values' => '指定的DNS区域参数值错误。',

    'dns__soa_mname_title' => '主域名服务器',
    'dns__soa_mname_legend' => '域名服务器',
    'dns__soa_mname_autoselect' => '（自动选择）',

    'dns__dns_zone_default' => '区域默认设置',
    'dns__dns_soa_legend' => 'SOA 记录',
    'dns__dns_soa_ttl' => 'TTL',
    'dns__dns_soa_refresh' => '刷新',
    'dns__dns_soa_retry' => '重试',
    'dns__dns_soa_expire' => '过期',
    'dns__dns_soa_minimum' => '最小',
    'dns__dns_soa_ttl_error' => 'TTL值无效，此值应介于1秒到68年之间。',
    'dns__dns_soa_refresh_error' => '刷新值无效，此值应介于1秒到68年之间。',
    'dns__dns_soa_retry_error' => '重试值无效，此值应介于1秒到68年之间。',
    'dns__dns_soa_expire_error' => '过期值无效，此值应介于1秒到68年之间。',
    'dns__dns_soa_minimum_error' => '最小值无效，此值应介于1秒到68年之间。',
    'dns__dns_default_title' => '恢复DNS区域。',
    'dns__dns_default_legend' => "区域恢复选项。",
    'dns__dns_default_text' => "选择恢复 DNS 区域的设置，确认这些设置，并单击“确定”。",
    'dns__dns_default_confirm' => "确认恢复DNS区域",
    'dns__dns_default_confirm_required' => "请确认恢复DNS区域",
    'dns__dns_default_invalid_ip_address' => '无效的IP地址',

    'dns_t__dns_default_title' => '恢复默认的 DNS 区域模板',
    'dns_t__dns_default_legend' => "恢复选项",
    'dns_t__dns_default_text' => '请确认要恢复 DNS 区域模板的默认配置。',
    'dns_t__dns_default_confirm' => "确认恢复",
    'dns_t__dns_default_confirm_required' => "请确认恢复DNS区域模板",
    'dns_t__add_dns_record_master_title' => '添加资源记录到区域模板',
    'dns_t__add_dns_record_off_title' => '添加域名服务器',
    'dns_t__edit_dns_record_master_title' => '编辑DNS记录',
    'dns_t__edit_dns_record_off_title' => '编辑域名服务器',
    'dns_t__edit_dns_record_ttl' => 'TTL',

    'dns__dns_zone_off_remove_title' => "下列资源记录将从区域%1中删除：",
    'dns__dns_zone_master_remove_title' => "从 DNS 区域 %1 移除资源记录",
    'dns__dns_zone_slave_remove_title' => "%1的下列主域名服务器记录将被删除：",
    'dns_add__param_ttl' => "TTL",
    'dns_add__enter_spf' => '输入记录字符串',
    'dns_add__is_spf_syntax' => 'SPF 记录',
    'dns_add__spf_value_is_invalid' => "SPF 记录的值错误，这个值必须以 'v=spf 开头",
    'dns__dns_zone_status' => "DNS 区域状态。",
    'dns__dns_zone_template' => 'DNS设置',
    'dns__host' => "主机",
    'dns__ttl' => "TTL",
    'dns__invalid_ip_address' => "新的 DNS 主服务器的 IP 地址为空或者无效。",
    'dns__ip_address' => "IP 地址",
    'dns__master_dns_type' => "是主 DNS 服务器",
    'dns__masters' => "DNS 主服务器",
    'dns__soa_minimum_too_large' => '不推荐缓存负响应3小时以上。',
    'dns__select_masters_to_remove' => "选择要删除的DNS主控服务器。",
    'dns__select_template_record_to_remove' => '选择要删除的DNS模板记录。',
    'dns__nameservers_for_domain' => "域名的域名服务器",
    'dns__ns' => "域名服务器",
    'dns__ns_record' => "域名服务器",
    'dns__remove_dns_zone_of_domain__' => "从域名%1中删除 DNS 记录",
    'dns__remove_dns_zone_template__' => "下列DNS记录将从模板中删除:",
    'dns__remove_this_dns_record?' => "您确定要删除此 DNS 记录吗？",
    'dns__restore_default' => "通过模板恢复 DNS 区域",
    'dns__restore_default_confirm' => "恢复 DNS 区域将放弃当前的 DNS 区域配置。是否继续？",
    'dns__restore_default_error' => "恢复 DNS 区域时发生错误：",
    'dns__slave_dns_type' => "是从属DNS服务器",
    'dns__soa_refresh_value_is_small' => '刷新间隔值小于一小时，这会大大增加服务器流量和资源使用率。继续使用这个值吗？',
    'dns__subdomain_dns_rec_removed' => "A记录已从子域名区域%1中删除。",
    'dns__zone_switched_off_no_ns' => "因区域中没有本应显示的NS记录%1，导致此区域已关闭。若要将记录添加到此区域中，请单击“添加记录”按钮。",
    'dns__cant_switch_on_no_ns' => "因区域中没有本应显示的NS记录%1，导致无法打开此区域。若要将记录添加到此区域中，请单击“添加记录”按钮。",
    'dns__type' => "记录类型",
    'dns__unable_activate/deactivate_dns' => "无法启用/禁用 DNS：%1。",
    'dns__unable_add_dns_master_duplicate_entry' => "无法添加 DNS 主服务器：项目重复。",
    'dns__unable_add_dns_master_local_ip' => "无法添加 DNS 主 IP 地址：DNS 主记录应放到远程服务器。",
    'dns__unable_define_dns_record' => "无法定义 DNS 记录：%1。",
    'dns__unable_get_dns_template_status' => "无法检索 DNS 模板状态。",
    'dns__unable_remove_dns_rec' => "无法删除 DNS 记录：%1。",
    'dns__val' => "值",
    'dns__warnings__' => "DNS 区域修改结果：",
    'dns__you_not_have_perm_manage_dns' => "您无权管理此域名的 DNS 区域。",
    'dns__zone_record' => "DNS 记录",
    'dns__cant_create_record_with_server_ip' => "无法添加该 IP 地址因为它与该 Plesk 管理的服务器的 IP 地址。",

    'dns__tabs_acl' => "区域传输",
    'dns__acl_add_network_legend' => "添加网络",
    'dns__acl_add_ip_legend' => "添加 IP 地址",
    'dns__acl_network_not_allowed' => "DNS 不允许在 Windows 中使用该网络地址。",
    'dns__acl_enter_ip_address_with_mask' => "IP 地址/掩码",
    'dns__acl_enter_ip_address' => "IP 地址",
    'dns__acl_list_network_legend' => "允许获取 DNS 区域副本的网络",
    'dns__acl_list_ip_legend' => "允许获取 DNS 区域副本的 IP 地址",
    'bt_dns_acl_add_network' => "添加网络",
    'bt_dns_acl_add_ip' => "添加 IP 地址",

    'dns_add__add_rec_for_zone' => "为区域 %2 添加 %1",
    'dns_add__canonical_dom_name_is_invalid' => "规范域名无效。",
    'dns_add__enter_canonical_name' => "规范名称",
    'dns_add__enter_dom_name' => "域名",
    'dns_add__enter_ip_address' => "IP 地址",
    'dns_add__enter_ip_mask' => "IP地址和网络掩码",
    'dns_add__enter_mail_domain' => "邮件域名",
    'dns_add__enter_mail_exchanger' => "邮件交换服务器",
    'dns_add__enter_nameserver' => "域名服务器",
    'dns_add__enter_txt_record' => "TXT 记录",
    'dns_add__enter_service_name' => "服务名称",
    'dns_add__hint_service_name' => "示例：SIP（无下划线符号）",
    'dns_add__enter_protocol' => "协议",
    'dns_add__hint_protocol_name' => "示例：TCP（无下划线符号）",
    'dns_add__protocol_tcp' => "TCP",
    'dns_add__protocol_udp' => "UDP",
    'dns_add__enter_srv_priority' => "优先级",
    'dns_add__specify_weight_of_service' => "拥有相同优先级的记录的相对权重",
    'dns_add__enter_target_host' => "目标主机",
    'dns_add__hint_target_host' => "例如：example.com",
    'dns_add__enter_target_port' => "目标端口",
    'dns_add__caa_tag' => "标签",
    'dns_add__caa_value' => "值",
    'dns_add-invalid-A_ip' => "IP 地址无效。",
    'dns_add-invalid-AAAA_ip' => "IP 地址无效。",
    'dns_add-invalid-PTR_ip_mask' => "无效 IP 地址/掩码对。",
    'dns_add-invalid-SRV_service_name' => "无效的服务名称",
    'dns_add-invalid-SRV_protocol_name' => "无效的协议",
    'dns_add-invalid-SRV_target_port' => "目标端口无效",

    'dns_add__invalid_ip' => "IP 地址无效。",
    'dns_add__low' => "低",
    'dns_add__mail_dom_name_is_invalid' => "邮件域名无效。",
    'dns_add__nameserver_is_invalid' => "域名服务器无效。",
    'dns_add__record' => "%1 记录",
    'dns_add__select_prefer_for_mail_exchange_server' => "指定邮件交换服务器优先级。",
    'dns_add__unable_insert_new_dns_rec' => "无法插入新的 DNS 记录：%1",
    'dns_add__very_high' => "很高",
    'dom_ctrl__allowed' => "允许",
    'dom_ctrl__db' => "MySQL 数据库",
    'dom_ctrl__mssql_db' => "MS SQL Server 数据库",
    'dom_ctrl__disk_space' => "磁盘空间",
    'dom_ctrl__dom_adm' => "%2 的域名 %1",
    'dom_ctrl__dom_cl' => "域名 %1",
    'dom_ctrl__domain_has_forwarding_with_undefined_fwd_url' => "域名已设置转发，但是没有定义转发 URL。",
    'dom_ctrl__domain_has_frame_forwarding' => "域名已有到 URL %1 的帧转发。",
    'dom_ctrl__domain_has_no_hosting' => "域名没有配置主机",
    'dom_ctrl__domain_has_physical_hosting' => "为 IP 地址 %1 上的该域名配置了主机",
    'dom_ctrl__domain_has_standard_forwarding' => "域名已标准转发到 URL %1。",
    'dom_ctrl__maillists' => "邮件列表",
    'dom_ctrl__mboxes' => "邮箱",
    'dom_ctrl__mg' => "邮件转发",
    'dom_ctrl__resource_name' => "资源",
    'dom_ctrl__resp' => "自动回复",
    'dom_ctrl__subdom' => "子域名",
    'dom_ctrl__dom_aliases' => "域名别名",
    'dom_ctrl__traffic' => "流量",
    'dom_ctrl__unable_activate/deactivate_dom' => "无法启用/禁用域名：%1。",
    'dom_ctrl__used' => "已使用",
    // end of serge part

    // maverick part
    'dom_ctrl__wu' => "网站用户",
    'dom_pref__bounce_with_phrase' => "退回信息",
    'dom_pref__bounce' => "退信",
    'dom_pref__catch_addr' => "转发至地址",
    'dom_pref__reject' => '拒绝',
    'dom_pref__confirm_domain_removing' => "请不要忘记通知域名用户域名已经更改。 确定要更改域名吗？",
    'dom_pref__db_inconsystency' => "数据库不一致。",
    'dom_pref__dbs' => "数据库",
    'dom_pref__delete_traffic_stat' => "保留网站和流量统计",
    'dom_pref__delete_traffic_stat_older' => "保留网站和流量统计",
    'dom_pref__dom_level_name_conflict' => "域名管理员的用户名同某个客户的用户名冲突。",
    'dom_pref__invalid_disk_space_limit' => "无效的磁盘空间限制。最大值：%1",
    'dom_pref__invalid_expiration_date_limit' => "无效的有效期限。",
    'dom_pref__invalid_max_traffic_limit' => "无效的流量限制。最大值：%1",
    'dom_pref__limits_of_dom' => "域名%1的限制",
    'dom_pref__mail_grps' => "邮件群组",
    'dom_pref__mail_nonexistent_user' => "如何处理发送到不存在用户的邮件",
    'dom_pref__mail_redirs' => "邮件转发",
    'dom_pref__mail_resps' => "邮件自动回复",
    'dom_pref__max_limit_is_invalid' => "%1 无效。",
    'dom_pref__max_num_of_%objects_is_invalid' => "%1的最大数量无效。",
    'dom_pref__new_limit_less_currently_used' => "%1：请求 - %2，目前使用 - %3",
    'dom_pref__older_that' => "时间长度",
    'dom_pref__postboxes' => "邮箱",
    'dom_pref__preferences_of_dom' => "域名%1设置",
    'dom_pref__redirect_to_itself' => "域名将被设置成转发到自身。",
    'dom_pref__traffic_logging_period_couldnt_be_lower' => "您指定的域名流量统计保留时间小于对服务器定义的总值 (%1 个月)。因此保留时间已被设为服务器的默认值 (%1 个月)。",
    'dom_pref__unable_add_www_prefix_in_dom' => "无法添加 www 前缀到域名：%1。",
    'dom_pref__unable_define_physical_hst_param' => "无法定义物理主机参数：%1。",
    'dom_pref__unable_rename_domain' => "无法重命名域名 %1：%2",
    'dom_pref__unable_set_up_mbox_quota' => "无法设置此域名的邮箱配额：%1。",
    'dom_pref__unable_set_up_web_user_script' => "无法为网站用户设置脚本：%1。",
    'dom_pref__unlimited' => "无限",
    'dom_pref__web_usrs' => "网站用户",
    'dom_pref__you_already_have_%object' => "您已经拥有了 %1",
    'cu_domain__error_unable_update_ftp_users' => '更新域名 FTP 用户失败：%1',
    'dom_cli__warning_ignore_quota' => '警告：已忽略选项“-hard_quota”：不支持硬盘配额',
    'dom_user_client_login_exist' => "无法许可域名管理员访问域名  %1 上的 Plesk：该用户名已在使用当中。",
    'domain__unable_to_turn_on_service' => "启用%1服务失败。",
    'domains__change_the_status_of_domain?' => "您确定要更改域名%1的状态吗？",
    'domains__client_info_hiding_traffic' => "%1个域名、%2个活动域名、已使用%3磁盘空间",
    'domains__unable_to_change_client_status' => "无法更改客户帐户状态: %1",
    'domains__unable_update_apache_settings' => "无法更新Apache设置。",
    'domains__you_do_not_have_permissions_to_delete_domains' => "您无权删除域名。",
    'domains__you_want_change_the_status_of_the_cl??' => "您确定要更改客户帐户的状态吗？",
    'domains__you_want_change_the_cp_access_of_the_cl??' => "您确定要执行此操作吗？",
    'domains_list__unable_remove_doms' => "无法删除域名：%1",
    'domaintrafficlist_header_of_domain__' => "域名%1的流量",

    'domain_aliases_remove__select_domain_aliases_for_remove' => '选择要删除的域名别名。',
    'domain_aliases_remove__title' => '删除域名别名',
    'domain_aliases__max_aliases_reached_for_dom' => "已达到此域名的别名数量上限。",
    'domain_edit__edit_title' => '编辑域名别名',
    'domain_alias_edit__type' => '域名别名类型',
    'domain_aliases__list_header' => '域名别名',
    'domain_aliases__name' => '名称',
    'domain_aliases__type' => '类型',
    'domain_aliases__type_full' => '全部',
    'domain_aliases__type_web_ftp' => 'WEB 与 FTP',
    'domain_aliases__page_title' => '域名别名',
    'domain_aliases__legend' => '域名别名',
    'domain_alias__domain_exists' => '相同名称的域名已经存在',
    'domain_alias__subdomain_exists' => '相同名称的子域名已经存在',
    'domain_alias__dns_record_exists' => '使用指定域名别名的 DNS 记录已存在',
    'domain_alias__domain_alias_exists' => "相同名称的域名别名已经存在",
    'domain_alias__invalid_type_full' => '邮件服务器不支持域名别名',
    'domain_alias__redirect_exists' => '重定向至自我监测',

    'ds__anonymous_ftp' => "匿名FTP",
    'drweb__pagetitle' => '防病毒设置',
    'drweb__drweb' => '邮件防病毒检查',
    'drweb__drweb_direction' => '检查病毒邮件',
    'drweb__drweb_direction_off' => '请不要进行病毒检查',
    'drweb__drweb_direction_any' => '传入和传出的邮件',
    'drweb__drweb_direction_from' => '仅传出的邮件',
    'drweb__drweb_direction_to' => '仅传入的邮件',
    'drweb__disable_reason_key' => '许可证不支持防病毒软件。',
    'drweb__disable_reason_perm' => '您无权管理防病毒程序。',
    'drweb__disable_reason_install' => '尚未安装防病毒软件。',
    'drweb__filters' => '防病毒过滤器',
    'ds__dns' => "DNS 区域",
    'ds__mail' => "邮件",
    'dsr__of_client_title' => "%1 的域名摘要报告",
    'dsr__report_has_been_sent_email' => "报告已发送到邮箱: %1",
    'dsr__title' => "域名摘要报告",
    'dumps_list__deletion_page_title' => "域名%1的下列备份文件将被删除：",
    'dumps_list__dumpfile_is_invalid' => "此文件%1不是有效的备份文件。",
    'dumps_list__page_title' => "备份文件存储",
    'dumps_upload__page_title' => "上传备份文件到存储",
    'dumps_list__repository_is_not_exist' => "备份文件存储不存在。",
    'dumps_list__unable_to_remove' => "无法删除备份文件：%1",
    'dumps_list__dumpfile_can_conflict' => "您指定的文件名与文件%1冲突。请指定其他文件名。",
    'dusr_ed__allow_dl_usr_access' => "允许域名管理员访问",
    'dusr_ed__information' => "域名%1管理员属性",
    'dusr_ed__locale' => "域名管理员的语言",
    'dusr_ed__skin' => "域名管理员的界面皮肤",
    'dusr_ed__personal_information' => '个人信息',
    'ess__error' => "错误",
    'example__' => "示例：%1",
    'extras__allow_certificate_purchasing' => "允许购买证书",
    'extras__allow_domain_registration' => "允许域名注册",
    'extras__allow_extras' => "允许其它服务",
    'extras__buy_new_key' => "您当前的许可证不允许修改这些对象。",
    'extras__setup_services' => "设置其它服务",

    'ruleeditform__error' => '无法更新防火墙规则。',
    'ruleeditform__name_is_required' => '指定规则名称。',
    'ruleeditform__profiles_is_required' => '至少选择一个配置文件。',
    'ruleeditform__invalid_ip' => '指定的 IP 地址或网络无效。',
    'ruleeditform__invalid_port' => '指定的端口无效。可能的值为 1000 或 1000-1051',

    'filemanager__items' => '%1中的项目',
    'filemanager__items_paging' => '%1中的项目',

    'get_password__encrypted_password' => "无法发送密码信息: 密码存放在加密表单中。",
    'get_password__mail_error' => "尝试发送密码到邮箱 %1 时出错: %2",
    'get_password__mail_ok' => "密码已成功发送到邮箱: %1",
    'get_password__message' => "访问系统的用户名为: %1\n密码为%2",
    'get_password__subject' => "用于访问系统的密码",
    'groups__available' => "可用的邮件群组",
    'groups__groups_for_mailname' => "此邮件帐户%1注册的邮件群组",
    'groups__member_of' => "下列邮件群组成员",
    'help__help_area' => "帮助区域。",
    'hst_def__auth_disabled' => "不推荐",
    'hst_def__auth_enabled' => "允许",
    'hst_def__change_curr_dns_ip' => "当前 A DNS 记录的 IP 地址将更改",
    'hst_def__cr_hosting_ip_dns_ip_not_equiv' => "A DNS 记录中的 IP 地址与分配给所创建的主机帐户的 IP 地址不一致。",
    'hst_def__dest_url' => "目标 URL",
    'hst_def__disk_quota' => "磁盘配额",
    'hst_def__disk_space_limit_exceed_incoming_quota' => "您试图设置的磁盘空间限制小于匿名 FTP 接收目录的限制值。匿名 FTP 接收目录的磁盘空间限制值不能超过域名的磁盘空间限制。",
    'hst_def__frame_forwarding_definition' => "域名%1的帧转发分配",
    'hst_def__ftpuser_for_hst_not_exist_in_system' => "警告。FTP 用户%1被用于主机帐户，但在系统中找不到",
    'hst_def__hst_type_is_not_defined' => "主机类型没有定义",
    'hst_def__ip_based' => "基于 IP",
    'hst_def__name_based_power_anonymous_ftp_down' => "此主机帐户转为共享IP地址将导致匿名FTP服务不可用。是否继续？",
    'hst_def__password_is_invalid_password_syntax' => "密码无效。\n不要在密码中使用单引号和国家字母表字符。\n密码的长度应该在5到14个字符之间，而且不能包含用户名。",
    'hst_def__shell' => "通过 SSH 在订阅的系统用户的名下访问服务器 shell",
    'hst_def__shell_windows' => "通过远程桌面在订阅的系统用户的名下访问服务器",
    'hst_def__standard_forwarding_definition' => "域名%1的地址跳转分配",
    'hst_def__title_name_based' => "基于名称",
    'hst_def__unable_create/update_physic_hst' => "无法创建/更新物理主机：%1。",
    'hst_def__unable_create/update_std_fwd' => "无法创建/更新地址跳转：%1。",
    'hst_def__unable_create_forwarding_myself' => "无法创建到域名自身的转发。",
    'hst_def__unable_turn_same_ssl_while_ssl_off' => "无法允许使用一个目录来存储 SSL/TLS 和非 SSL/TLS 内容：未启用 SSL/TLS 支持。",
    'hst_def__unable_turn_on_ssl_cert_not_defined' => "无法启用 SSL/TLS 支持：尚未安装 SSL/TLS 证书。",
    'hst_def__url_is_invalid' => "URL 无效。",
    'hst_def__virtual_host_access' => "域名%1的虚拟主机访问",
    'hst_def__virtual_host_uses_non_existed_ip_address' => "警告。此虚拟主机使用了一个不存在的 IP 地址。",
    'hst_def__you_have_no_ips' => "您没有可用的IP地址，而且您不能创建基于名称的主机。",
    'hst_sel__header' => "若要在此机器上托管网站，请选择“本机网站”选项。\n若要设置网站重定向到另一机器的网站，请选择 帧转发 或 标准转发 选项。\n使用“地址跳转”，用户可以被重定向到该网站，真实网站的URL显示在用户的浏览器窗口中，因此用户会知道有关重定向的情况。使用帧转发，用户可以被重定向到网站，但不了解真实网站的位置。",
    'hst_sel__physical_hst' => "物理主机",
    'hst_sel__select_hst_type' => "选择域名的主机类型",
    'hst_sel__select_hst_type_warning' => "选择域名的主机类型",
    'hst_sel__hosting_exists' => "无法创建主机，因为它已经被配置给此域名。您将被重定向到域名管理页。",
    'hst_sel__standard_frw' => "不隐藏目标地址的 URL 转发(地址跳转)",
    'hst_sel__frame_frw' => "帧转发",
    '__frame_frw' => "帧转发",
    '__hosting_exists' => "无法创建主机，因为它已经被配置给此域名。您将被重定向到域名管理页。",
    '__choose_hst_type' => "请选择所需的主机类型。",
    '__no_hst_conf' => "您的域名没有开通主机服务。",
    '__physical_hst' => "物理主机",
    '__select_hst_type' => "选择域名的主机类型",
    '__standard_frw' => "不隐藏目标地址的 URL 转发(地址跳转)",
    '__warning' => "警告! 所有之前设置的参数都将被丢弃。您确定要更改主机类型吗？",
    'i_cl_off' => "客户处于非活动状态。",
    'i_cl_off_by_admin' => "客户帐户已被服务器管理员挂起。",
    'i_cl_off_expired' => "客户帐户已过期。",
    'i_cl_on' => "客户处于活动状态。",

    'icf__title' => 'Internet 连接防火墙',
    'icf__if_legend' => '接口',
    'icf__mode' => '模式',

    'invalid_value' => '无效值',

    'ip_addr__already_exists' => "IP 地址 %1 已存在。",
    'ip_addr__cant_add' => "IP %1不存在或属于另一客户的IP地址池",
    'ip_addr__cl_list_for_ip' => "使用%1 IP地址%2的代理商",
    'ip_addr__cl_list_for_ip_add' => "添加IP地址到代理商池",
    'ip_addr__domains_list_for_ip' => "使用%1 IP地址%2的网站",
    'ip_addr__ip_used_by_hst_or_frw' => "IP 地址 %1 已被用于主机或转发。",
    'ip_addr__only_one_ip_and_client_have_domain' => "无法删除该IP地址，因为尚有域名托管在该IP地址上。",
    'ip_addr__remove_ip_addr' => "这些 IP 地址将从系统中删除：",
    'ip_addr__select_clients' => "选择客户",
    'ip_addr__select_ip_addr_to_remove' => "选择要删除的 IP 地址。",
    'ip_addr__unallowed_by_license' => "Plesk 该副本并未被许可授权在 IP 地址 %1 上操作。\n允许的 IP 范围是：%2.",
    'ip_alias__interface' => "接口",
    'ip_alias__invalid_ip_nm_bsd_vrt_hsts' => "基于名称的虚拟主机的 %1 IP 地址无效。",
    'ip_alias__invalid_ip_or_netmask' => "无效 IP 地址/掩码对。",
    'ip_alias__orig_ip_can_not_be_deleted' => "该IP地址%1为原有服务器IP，因此您无法将其删除。",
    'ip_alias__ip_is_invalid' => "%1 IP 地址无效。",
    'ip_alias__ip_mask_is_invalid' => "%1 IP 掩码无效。",
    'ip_alias__ip_not_exist' => "IP地址%1不存在。",
    'ip_alias__ip_address_and_mask' => 'IP 地址与子网掩码',
    'ip_alias__mask' => "子网掩码",
    'ip_alias__remove_selected_ip_aliases?' => "您确定要删除所选 IP 地址吗？",
    'ip_alias__select_ip' => "请至少从列表中选择一种要删除的邮件模式。",
    'ip_alias__this_ip_used_for_domain' => "(%1) 此 IP 地址已被用于域名%2。",
    'ip_alias__this_ip_used_for_nm_bsd_vrt_hsts' => "(%1) 此 IP 地址已被用于基于名称的虚拟主机。",
    'ip_alias__unable_add_ip' => "无法添加 IP：%1",
    'ip_alias__unable_remove_ip' => "无法删除 IP：%1",
    'ip_ctrl__anonymous_ftp_exists_in_domain' => "您不能更改 IP 地址类型为共享，因为这样将使得域名 '%1' 的匿名 FTP 不可用。",
    'ip_ctrl__ip_addr' => "IP 地址 %2 位于接口 %1",
    'ip_ctrl__ip_exists_many_pools' => "无法更改IP类型。此IP地址同时属于几个用户的IP池。",
    'ip_ctrl__ssl_cert' => "SSL/TLS 证书",
    'ip_pool__ip_address_is_absend_in_pool' => "IP 地址没找到。",
    'ip_pool__ip_pool_for_client' => "客户%1的IP地址池",
    'ip_pool__no_cliens_avail' => "无可用客户。",
    'ip_pool__no_vacant_ips' => "尚无空闲的IP。",
    'ip_pool__pool_is_empty' => "IP池为空。",
    'ip_pool__remove_ip_addr' => "这些IP地址将从池%1中删除：",
    'ip_pool__select_free_ips' => "空闲 IP",
    'limit__date_in_past' => "有效期无效。%1 已经过去。",
    'limit__enter_date' => "输入日期",
    'limit__max_db' => "数据库",
    'limit__name_disk_space' => "磁盘空间",
    'limit__name_max_box' => "邮箱",
    'limit__name_max_db' => "MySQL 数据库",
    'limit__name_max_dom' => "域名",
    'limit__name_max_maillists' => "邮件列表",
    'limit__name_max_subdom' => "子域名",
    'limit__name_max_traffic' => "流量",
    'limit__name_max_wu' => "网站用户",
    'limit__name_mbox_quota' => "邮箱配额",
    'limit__name_max_mn' => "邮件帐户的最大数量",
    'limit__name_max_cl' => '客户',
    'limit__name_total_mboxes_quota' => "邮箱总配额。",
    'limit__name_mysql_dbase_space' => "MySQL 数据库空间",
    'limit__name_mssql_dbase_space' => "MySQL数据库空间",
    'limit__name_expiration' => '到期日',

    'locale_upload__title' => '添加区域设置',
    'locale_upload__file_name' => '语言包文件路径',
    'locale_upload__unable_to_install' => '无法安装语言包文件',
    'locale_upload__wrong_package' => '你上传的文件不包含该 Plesk 版本有效的语言包。',
    'locale_upload__wrong_locale' => '您上传的文件不包含有效的语言包。',

    'locales_remove__title' => '删除区域设置',
    'locales_remove__select_locales_for_remove' => '选择要删除的区域设置',
    'locales__can_not_remove' => '无法删除区域设置%1的语言包：%2',

    'ma__create_title' => '为 %1 创建邮件别名',
    'ma__edit_title' => "编辑邮件别名 %1",
    'ma__enter_new_alias' => "输入新别名。",
    'ma__invalid_alias' => "无效邮件别名。",
    'ma__mail_aliases_mailname' => "邮件帐户%1的邮件别名",
    'ma__mailname_does_not_exist' => "邮件帐户不存在。",
    'ma__select_ma_for_remove' => "选择要删除的邮件别名。",
    'ma__unable_to_add_new_ma' => "无法添加邮件别名：%1",

    'mail_queue__not_allowed_by_license_key' => '该许可证不允许邮件队列管理。',
    'maillist__' => "邮件列表 %1",
    'maillist__already_exists' => "邮件列表已存在。",
    'maillist__mail_alias_already_exists_in_this_domain' => "邮件别名 %1 已经存在于此域名中。",
    'maillists__' => "邮件列表 %1",
    'maillists__limit_cl_max_maillists' => "已达到客户(限制: %1，已使用: %2)的邮件列表数量上限。",
    'maillists__limit_dom_max_maillists' => "已达到域名的邮件列表数量上限。",
    'maillists__list' => "邮件列表",
    'maillists__mailman_not_installed_or_conf' => "Mailman服务器扩展目前尚未在服务器上安装或配置。\n请联系服务器管理员进行安装或配置。",
    'maillists__status' => "邮件列表服务已启用",
    'maillists__unable_to_delete__' => "无法删除邮件列表：%1",
    'maillists__disabled_text' => '因 Mailman 邮件列表服务器组件尚未安装或未配置，导致无法管理邮件列表。',
    'maillist_member__already_exists' => '邮件列表订户已存在。',
    'maillist_member__not_exists' => '邮件列表中没有此用户。',
    'mailserver_switching_warning' => "警告!\n\n更改邮件服务器仅可以在初始安装时进行，如果服务器已使用，这将会引起下列问题：丢失设置和邮箱内容，如果切换到的目标服务器已完成配置，则会引起各种冲突。\n如果此服务器正在使用，而您确定要切换到另一台服务器，请提前通知客户，以便他们/她们可以下载和保存邮件。",
    'manager__access_denied' => "拒绝访问：%1",
    'manager__admin' => "管理员",
    'manager__client' => '客户',
    'manager__domain' => "域名",
    'manager__domain_cl_limit_exceeding' => "已达到此客户帐户的域名数量限制。",
    'manager__domain_is_not_yours' => "域名%1不属于您。",
    'manager__domain_key_limit_exceeding' => "已达到您的许可证设定的可创建域名数量上限。",
    'manager__no_perm_to_call' => "权限不足，无法调用%1。",
    'manager__no_perm_to_create_domains' => "权限不足，无法创建域名。",
    'manager__no_perm_to_modify_domain' => "权限不足，无法修改域名%1。",
    'manager__no_perm_to_modify_domains' => "权限不足，无法修改域名。",
    'manager__no_perm_to_remove_domain' => "权限不足，无法删除域名%1。",
    'manager__no_perm_to_remove_domains' => "权限不足，无法删除域名。",
    'manager__node_doesnt_exist' => "%1不存在。",
    'manager__user_disabled' => "您的帐户已挂起。您无法操作系统。",
    'mail_quota_unsupported' => "邮件服务器不支持",
    'mbox_quota_unsupported' => "邮件服务器不支持",
    'mn__create_title' => "创建邮件帐户",
    'mn__edit_title' => "设置",
    'mn__files_list_title' => "附件文件",
    'mn__files_remove' => "从附件库中删除文件。这些文件可能被用于自动回复。它们将从附件库和使用它们的自动回复中同时删除。",
    'mn__files_select_for_remove' => "选择要删除的文件。",
    'mn__mail_alias_form' => "邮件别名格式",
    'mn__mail_aliases_list' => "邮件别名",
    'mn__mailbox' => "邮箱管理",
    'mn__unable_define_mn' => "无法设置邮件帐户：%1",
    'mn__unable_remove_mbox_quota' => "无法删除邮箱配额: %1",
    'mn__upload_file' => "上传文件",
    'mn_edit__attach_filename_changed' => '上传的文件%1已被重命名为%2，因为其原名包含非ASCII字符。',
    'mn_edit__add_mail_group_members_or_turn_off_box' => "在启用邮件群组之前，您必须至少添加一位邮件群组成员。",
    'mn_edit__add_resp_or_turn_off_box' => "请添加自动回复，或清空自动回复复选框。",
    'mn_edit__attachments' => "附件",
    'mn_edit__dom_quota_less_then_quota' => "邮箱配额值不可以超出为此域名定义的邮箱配额总量。",
    'mn_edit__enter_external_rcpnt_email' => "输入外部邮件群组成员的邮件地址",
    'mn_edit__enter_mail_redir_or_turn_off_box' => "请输入邮件转发地址，或者清空此复选框。",
    'mn_edit__ext_rcpnt_email_invalid' => "外部收件人的电子邮件地址无效。",
    'mn_edit__file_exists' => "文件已存在。覆盖吗？",
    'mn_edit__files_deld_from_repository' => "这些文件将从包含它们的库中或自动回复中删除。您要继续吗？",
    'mn_edit__mail_name' => "邮件帐户",
    'mn_edit__mail_name_invalid' => "邮件帐户名无效。",
    'mn_edit__mail_redir' => "邮件转发器",
    'mn_edit__mail_redir_add' => "添加邮件群组成员",
    'mn_edit__mail_resps' => "邮件自动回复",
    'mn_edit__mailbox' => "邮箱",
    'mn_edit__enable_mailbox' => "邮箱",
    'mn_edit__mailgroup' => "邮件群组",
    'mn_edit__mailgroup_addresses' => "邮件群组成员",
    'mn_edit__mailgroup_disabled' => "仅当添加邮件名之后才可以使用。",
    'mn_edit__max_dom_quota' => "域名 (%1) 的默认值",
    'mn_edit__mbox_quota_invalid' => "邮箱配额无效。",
    'mn_edit__new_resp_name' => "新建自动回复名",
    'mn_edit__no_autoresponders' => "在打开/关闭自动回复服务之前，您必须至少添加一个自动回复。",
    'mn_edit__no_file_sel' => "尚未选择文件。",
    'mn_edit__no_mail_addresses' => "未指定或选择电子邮件地址。",
    'mn_edit__none' => "无",
    'mn_edit__not_create_pass' => "此项操作不会为帐户创建密码。\n用户不使用密码将无法查看和/或发送邮件。",
    'mn_edit__redir_email_invalid' => "电子邮件转发地址无效。",
    'mn_edit__redirect_addr' => "转发地址",
    'mn_edit__remove_autoresp?' => "您确定要删除自动回复吗？",
    'mn_edit__remove_rcpnts?' => "您确定要删除这些收件人吗？",
    'mn_edit__repository' => "库",
    'mn_edit__resps_attach' => "自动回复邮件的附件",
    'mn_edit__select_rcpnt_from_list' => "请至少从列表中选择一种要删除的收件人。",
    'mn_edit__select_registered_users' => "选择已注册用户",
    'mn_edit__selected_postbox_have_not_setup_passwd' => "您选择创建一个邮箱，但没有为它设置密码。",
    'mn_edit__unable_act_deact_mail_group' => "无法启用/禁用邮件群组: %1",
    'mn_edit__unable_act_deact_mail_redir' => "无法启用/禁用邮件转发: %1",
    'mn_edit__unable_act_deact_postbox' => "无法启用/禁用邮箱: %1",
    'mn_edit__unable_act_deact_resp' => "无法启用/禁用自动回复: %1",
    'mn_edit__unable_add_attach' => "无法添加附件：%1。",
    'mn_edit__unable_add_mail_group_member' => "无法添加邮件群组成员：%1。",
    'mn_edit__unable_add_resp' => "无法添加自动恢复: %1",
    'mn_edit__unable_change_mail_name' => "无法更改邮件帐户名：%1",
    'mn_edit__unable_deactivate_mail_group' => "无法禁用邮件群组：%1。",
    'mn_edit__unable_deactivate_resp' => "无法禁用邮件自动回复: %1",
    'mn_edit__unable_define_resp_id' => "无法定义自动回复ID: %1",
    'mn_edit__unable_remove_attach' => "无法删除附件：%1。",
    'mn_edit__unable_remove_autoresp' => "无法删除自动回复: %1",
    'mn_edit__unable_remove_mail_group_member' => "无法删除邮件群组成员：%1",
    'mn_edit__wrong_way' => '无法将邮件发送到%1，此邮件帐户没有邮箱，或邮件转发器已启用。',
    'mn_edit__mailbox_is_disabled_mail_not_removed' => '地址为%1的邮箱已关闭。此邮箱中的邮件并未删除，但您无法通过IMAP或POP3检索这些邮件。',
    'mn_list__mail_names_for_domain' => "域名%1的邮件帐户",
    'mn_list__sa_cannot_unable' => "无法启用垃圾邮件过滤功能",
    'mn_list__tab_cp_access' => "L",
    'mn_list__tab_title_client' => '客户',
    'mn_list__tab_title_domain' => '域名',
    'mn_list__tab_title_autoresp' => "A",
    'mn_list__tab_title_box' => "B",
    'mn_list__tab_title_group' => "G",
    'mn_list__tab_title_name' => "名称",
    'mn_list__tab_title_redirect' => "F",
    'mn_list__tab_title_spamfilter' => "S",
    'mn_list__tab_title_virusfilter' => 'AV',
    'mn_list__tab_title_drweb' => 'AV',
    'mn_list__unable_remove_mns' => "无法删除邮件帐户：%1",
    'module_upload__module_was_installed' => '该模块已被安装。如果您想要安装该模块的新版本，请通过 Plesk 卸载该模块，然后再试。',
    'module_upload__unable_to_install' => '无法安装模块包文件',
    'module_upload__wrong_package' => '上传的文件不是受支持的模块包。',
    'module_upload__wrong_module' => '上传的文件不包含模块包。',

    'news_articles_title' => 'Plesk 新闻',
    'notification_text__invalid_subject_length' => "通知主题长度无效。应为 1 到 255 个字符。",
    'notification_text__invalid_text_length' => "无效的通知文本长度。应当包含 1 到 65533 个字符。",
    'notification_text__subject' => "通知主题",
    'notification_text__text' => "通知文本",
    'notification_text__title' => "编辑通知",
    'notification_text__unable_set_text' => "无法修改通知文本：",

    'odbc__cant_add_dsn' => "无法添加 DSN %1：%2",
    'odbc__cant_build_connection_string' => "无法使用指定的参数进行连接，请用不同的参数重新尝试。实用程序返回：%1",
    'odbc__cant_connect' => "无法使用定义的设置连接到数据源。服务器返回：%1。",
    'odbc__cant_delete_dsn' => "无法删除 DSN %1：%2。",
    'odbc__cant_get_drivers_info' => "无法获得驱动程序相关信息。",
    'odbc__cant_get_drivers' => "无法检索 ODBC 驱动程序的列表：%1。",
    'odbc__cant_get_list' => "无法检索现有 DSN 的列表：%1。",
    'odbc__cant_get_servers_list' => "无法检索服务器列表。",
    'odbc__cant_open_info_file' => "无法打开ODBC驱动程序信息文件。",
    'odbc__cant_parse_string' => "无法分析连接字符串。",
    'odbc__connect_success' => "连接成功",
    'odbc__driver_not_set' => "驱动程序没有设置",
    'odbc__driver_or_name_not_set' => "ODBC 的驱动程序或名称没有设置",
    'odbc__dsn_already_exists' => "系统中已存在此名称 (%1) 的 DSN",
    'odbc__dsn_not_exists' => "此 DSN 不存在",
    'odbc__enter_connection_params' => "ODBC连接配置",
    'odbc__enter_dsn_name' => "输入 DSN 名称",
    'odbc__invalid_dsn_name' => "ODBC 连接名 (%1) 语法错误：只能使用字母或者数字。",
    'odbc__no_such_driver' => "不支持使用该名称 (%1) 的 ODBC 驱动程序。",
    'odbc__remove_page_title' => "即将移除下列ODBC DSN连线:",
    'odbc__select_dsn_to_remove' => "选择要删除的 DSN。",
    'odbc__unknown_driver' => "未知的驱动程序名称 (%1)。",
    'odbc_add_new' => "添加 DSN 连接",
    'odbc_driver' => "驱动程序",
    'odbc_dsn_description' => "连接描述",
    'odbc_dsn_list' => "ODBC DSN 连接",
    'odbc_dsn_name' => "连接名",
    'odbc_dsn_system' => "系统 DSN",
    'odbc_dsn_text' => "ODBC DSN",
    'odbc_dsn_add__title' => '添加 ODBC DSN',
    'odbc_req_field_not_set' => "未提供所需的参数。",

    // Descriptions of parameters of ODBC connection string
    'odbc__access_dbq' => '数据库文件路径',
    'odbc__access_pagetimeout' => '未使用页面在缓存中保留的时段以 0.1 秒计。该选项适用于所有使用 Microsoft Access 驱动程序的数据源。',
    'odbc__access_maxbuffersize' => '内部缓冲区的大小，以 KB 计，按 256 KB 的单位排列。',
    'odbc__access_readonly' => '将数据库指定为只读状态以禁止任何升级。',
    'odbc__access_exclusive' => '将数据库指定为独占状态以禁止共享更新。',
    'odbc__access_safetransactions' => '如果是默认值 0，所有的事务会立即 commit。如果是 1，所有的事务会通过一次 commit 操作保存到硬盘，但是性能将会略微下降。',
    'odbc__access_threads' => '引擎要使用的后台线程数量。',
    'odbc__access_maxscanrows' => "根据现有数据设置列的数据类型时，要扫描的行数。",
    'odbc__access_implicitcommitsync' => '指定事务外部更改如何写入数据库中。',
    'odbc__access_usercommitsync' => '指定 MS Access 驱动程序是否显式同步执行用户定义的事务。',
    'odbc__mssql_server' => '服务器',
    'odbc__mssql_uid' => '登录 ID',
    'odbc__mssql_pwd' => '密码',
    'odbc__mssql_database' => 'ODBC 数据源的默认数据库',
    'odbc__mssql_app' => '应用程序名称',
    'odbc__mssql_wid' => '工作站ID',
    'odbc__mssql_language' => '默认使用的国家语言',
    'odbc__mssql_oemtoansi' => '此参数指定了是否将扩展字符转换为OEM值',
    'odbc__mysql_server' => 'MySQL服务器的主机名',
    'odbc__mysql_database' => '默认数据库',
    'odbc__mysql_user' => '用于连接到MySQL的用户名',
    'odbc__mysql_password' => '服务器上的用户帐户密码',
    'odbc__mysql_port' => '如果服务器不是本地主机，则使用TCP/IP端口',
    'odbc__mysql_socket' => '如果服务器是本地主机，Windows将使用命名管道来连接',
    'odbc__mysql_option' => '指定MyODBC如何工作的选项。请参见<a target="_blank" href="http://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">http://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html。</a>',
    'odbc__excel_dbq' => '数据库文件路径',
    'odbc__excel_defaultdir' => '默认数据路径',
    'odbc__excel_fil' => '数据库版本',
    'odbc__excel_maxbuffersize' => '缓冲区最大值',
    'odbc__excel_pagetimeout' => '页面超时',

    'pb__aliases' => "别名",
    'pb__anonftp' => "匿名FTP",
    'pb__autoinstaller_releases' => '更新程序',
    'pb__cert' => "证书",
    'pb__cl_pool' => "IP 地址",
    'pb__cl_pool_ctrl' => "%1",
    'pb__cl_pref' => "设置",
    'pb__cl_rpt' => "报告",
    'pb__cl_rpt_list' => "自定义",
    'pb__cl_templates' => "客户模板",
    'pb__cl_traffic' => "流量",
    'pb__cl_traffic_history' => "流量历史",
    'pb__cl_traffic_of' => "%1 的流量",
    'pb__client' => "%1",
    'pb__clients' => "客户",
    'pb__comp_info' => "服务器组件",
    'pb__common_acl' => '解析传递允许列表',
    'pb__cp_access' => "访问",
    'pb__crontab' => "计划程序",
    'pb__scheduler' => "计划程序",
    'pb__custom_buttons' => "自定义按钮",
    'pb__databases_db' => '数据库',
    'pb__sqlservers_db' => 'SQL Server',//to check
    'pb__db' => "数据库",
    'pb__db_edit' => "%1",
    'pb__db_server_edit' => '%1',
    'pb__db_servers' => '数据库服务器',
    'pb__dl_usr_ed' => "域名管理员",
    'pb__dns' => "DNS",
    'pb__dns_template' => "DNS",
    'pb__dns_t' => "DNS",
    'pb__dom_ctrl' => "%1",
    'pb__dom_lim' => "域名限额",
    'pb__dom_pref' => "设置",
    'pb__dom_sum_report' => "域名摘要报告",
    'pb__dom_templates' => "域名模板",
    'pb__dom_traffic' => "%1 的流量",
    'pb__domains' => "域名",
    'pb__domain_aliases' => '域名别名',
    'pb__dumps_list' => "备份文件存储",
    'pb__forwarding_setup' => "转发设置",
    'pb__filemanager' => "文件管理器",
    'pb__ip_aliasing' => "IP地址",
    'pb__ip_clients' => "IP 地址删除",
    'pb__license_management' => '许可证信息',
    'pb__locales' => '区域设置',
    'pb__log_files' => "日志文件",
    'pb__mail' => '邮件',
    'pb__mail_name_files' => "附件文件",
    'pb__mail_name_redirects' => "邮件转发器",
    'pb__mail_name_resp_attach_add' => "新建附件",
    'pb__mail_name_resp_edit' => "%1",
    'pb__mail_name_responders' => "邮件自动回复",
    'pb__mail_names' => "邮件",
    'pb__maillists' => "邮件列表",
    'pb__mimetypes' => 'MIME类型',
    'pb__modules' => '模块',
    'pb__modules_management' => '管理模块',
    'pb__notifications' => "通知",
    'pb__odbc' => "ODBC",
    'pb__phosting_setup' => "物理主机设置",
    'pb__prtd_dirs' => "受保护目录",
    'pb__prtdir_edit' => "%1",
    'pb__report' => "报告",
    'pb__report_auto' => "%1的发送计划",
    'pb__report_list' => "自定义",
    'pb__server' => "服务器",
    'pb__sessions' => "会话",
    'pb__sapp_pool' => "Web应用程序池",
    'pb__siteapp_install' => 'Web应用程序安装',
    'pb__site_app_pkgs' => 'Web应用程序',
    'pb__site_apps' => "Web应用程序",
    'pb__additional_key_info' => '许可证属性',
    'pb__additional_key_properties' => '许可证属性',
    'pb__skeleton' => '虚拟主机模板',
    'pb__skins' => '皮肤',
    'pb__skin_info' => '%1',
    'pb__spamassassin' => "垃圾邮件过滤器",
    'pb__statistics' => "统计",
    'pb__subdom_ctrl' => "%1",
    'pb__subdomains' => "子域名",
    'pb__templates' => "模板",
    'pb__virtualdirs' => '虚拟目录',
    'pb__web_users' => "网站用户",
    'pdir__enter_dir_name' => "输入 URL。",
    'pdir__invalid_hst' => "主机类型无效。必须是本机域名。",
    'pdir__pd_id_is_undefined' => "未定义受保护目录ID。",
    'pdir__pdir_exist' => "相同 URL 已受保护。",
    'pdir__pdir_not_exist' => "受保护目录不存在。",
    'pdir__pdir_usr_not_exist' => "受保护目录的用户不存在。",
    'pdir__prdirs_for_domain' => "%1 的受保护的目录",
    'pdir__prdirs_for_subdomain' => "子域名%1的受保护目录",
    'pdir__remove_pdir_usrs' => "网站%1的受保护目录 %2的下列用户将被删除:",
    'pdir__remove_pdir_usrs_on_subdom' => "子域名%1中受保护目录%2的下列用户将被删除:",
    'pdir__remove_pdirs_on_dom' => "此操作将删除客户%1名下网站%2的受保护目录。目录本身并不会被删除。",
    'pdir__remove_pdirs_on_subdom' => "此操作将删除子域名%1的目录保护，目录本身并不会被删除。",
    'pdir__select_pdir_usrs_for_remove' => "选择要删除的受保护目录的用户。",
    'pdir__select_pdirs_to_remove' => "选择要从中移除保护的 URL。",
    'pdir__unable_define_pdir_users' => "无法定义受保护目录的用户。",
    'pdir__unable_define_pdirs_properties' => "无法设置受保护目录的属性: %1",
    'pdir__unable_select_dom_param' => "无法选择域名参数：%1。",
    'pdir_ed__create_pdir_for_domain' => "在 %1 下创建受保护目录",
    'pdir_ed__create_pdir_for_subdomain' => "在子域名 %1 下创建受保护目录",
    'pdir_ed__dir_already_protect' => "此 URL 已受保护。",
    'pdir_ed__head_txt' => "受保护区的标题",
    'pdir_ed__invalid_login' => "指定的用户名错误。",
    'pdir_ed__login_exists' => "此用户已存在。请尝试指定其他用户名。",
    'pdir_ed__new_usr' => "用户名",
    'pdir_ed__non_ssl' => "非 SSL/TLS",
    'pdir_ed__cgi_bin' => "cgi-bin",
    'pdir_ed__path' => "目录名称",
    'pdir_ed__pdir_for_domain' => "域名 %2 上的受保护目录 %1",
    'pdir_ed__pdir_for_subdomain' => "子域名%2上的受保护目录%1",
    'pdir_ed__pdir_location' => "目录位置",
    'pdir_ed__pdir_users' => "受保护目录的用户",
    'pdir_ed__ssl' => "SSL/TLS",
    'pdir_ed__ssl_or_nonssl_should_be_checked' => "SSL/TLS 复选框和非 SSL/TLS 复选框中至少必须选择一个。",
    'pdir_ed__unable_cr_pdir_usr' => "无法创建受保护目录的用户：%1。",
    'pdir_ed__unable_create_pdir' => "无法创建受保护目录：%1",
    'pdir_ed__unable_define_hst_type' => "无法定义主机类型。",
    'pdir_ed__unable_update_pdir' => "无法更新受保护目录: %1",
    'pdir_ed__wrong_symbol_in_header' => "请不要在目录标题中使用符号%1",
    'pdir_usr_ed__create_pdir_usr_for_pd' => "为受保护目录 %1 创建用户",
    'pdir_usr_ed__not_create_pass' => "此项操作不会为新建的受保护目录用户创建密码。\n用户不使用密码将无法登录。",
    'pdir_usr_ed__pass_for_pdir_usr' => "受保护目录用户 %1 的密码。",
    'pdir_usr_ed__unable_select_pdir_usr' => "无法选择受保护目录的用户：%1。",
    'pdir_usrs_list__unable_define_pdir_usrs' => "无法定义受保护目录的用户：%1。",
    'pdir_usrs_list__unable_remove_pd_usrs' => "无法删除受保护目录的用户：%1。",
    'pdirs_list__name' => "名称",
    'pdirs_list__tab_title_non_secure_dir' => "N",
    'pdirs_list__tab_title_secure_dir' => "S",
    'pdirs_list__tab_title_cgi_bin_dir' => "C",
    'pdirs_list__unable_remove_pdirs' => "无法删除受保护目录：%1。",
    'phosting__anonftp_encrypt' => '由于 FTP 用户的密码已被加密，因此无法用于保护目录 /plesk-stat/webstat/。请重新输入 FTP 密码，或清空选项 "可通过有密码保护的目录 \'/plesk-stat/webstat/\' 进行访问"',
    'phosting__hosting_and_dns_ip_difference_warning' => "该网站名%%domain_name%%解析至IP地址 %%dns_ip_address%%。您的网站被分配IP地址%%hosting_ip_address%%。如果通过网站名无法在Web浏览器中打开网站，那么请转到DNS管理屏幕 (网站 > 网站名称 > DNS) 并更改A资源记录的属性：将IP地址%%hosting_ip_address%%分配给网站名%%domain_name%%。",
    'phosting__ip_change_warning' => "IP 地址已更改。域名的 DNS 区域也已进行了相应更改。",
    'phosting__other_hosting_exists_on_ip' => "无法更改证书，因为此IP地址正被一个或多个主机帐户所使用。",
    'phosting__unable_to_change_certificate' => "无法安装证书：%1",
    'phosting__unable_to_change_ip_address' => "无法更改IP地址：%1",
    'phosting__unable_to_set_cert' => "无法设置 SSL/TLS 证书:%1",
    'phosting__unable_update' => "无法更新主机设置: %1",
    'phosting__unable_manage' => "无法管理主机：%1。",
    'phosting__failed_to_add_logs_fail2ban' => "无法配置 fail2ban 跟踪域名的日志。fail2ban 服务下一次重启时将会自动跟踪日志。\n%1",

    'picker_acl_record__tittle' => '选择一个ACL记录',
    'picker_autoresponder__title' => '选择自动回复',
    'picker_black_list__domain_name' => '选择一个域名',
    'picker_certificate' => '选择一个 SSL/TLS 证书',

    'picker_dns_zone_template__title' => '选择一个资源记录',
    'picker_domain__title' => '选择网站',
    'picker_domain_alias__title' => '选择域名别名',
    'picker_resource_record__title' => '选择一个资源记录',
    'picker_disabled_resource_record__title' => '选择域名服务器',
    'picker_ip_address__title' => '选择IP地址',
    'picker_ip_address_clients__title' => '选择使用此IP地址的客户',
    'picker_mail_queue' => '选择邮件信息',
    'picker_site_application__title' => '选择Web应用程序',
    'picker_subdomain__title' => '选择子域名',
    'picker_web_user__title' => '选择网站用户',
    'picker_custom_button__title' => '选择自定义按钮',
    'picker_license_key__title' => "选择许可证",
    'picker_spamfilter_address__title' => '选择一个垃圾邮件过滤器地址',
    'picker_white_list__networks' => '网络选择',

    'plesk_key__action_logs' => "由 Plesk 用户执行的登录操作",
    'plesk_key__app_vault' => "应用百宝箱",
    'plesk_key__backup' => "备份及恢复功能",
    'plesk_key__client_templs' => "服务方案管理",
    'plesk_key__clients' => "用户帐户(代理商与客户)",
    'plesk_key__resellers_only' => "用户帐户（代理商）",
    'plesk_key__customers_only' => "用户帐户（客户）",
    'plesk_key__domains' => "域名",
    'plesk_key__domain_aliases' => "域名别名",
    'plesk_key__manage_dashboard' => '自定义首页',
    'plesk_key__drweb' => "防病毒管理",
    'plesk_key__event_manager' => "事件管理器",
    'plesk_key__expirations' => "帐户过期日管理",
    'plesk_key__group_ops' => "允许批量修改",
    'plesk_key__expiration' => "许可证过期时间",
    'plesk_key__edition_name' => "Plesk 版本",
    'plesk_key__key_number' => "许可证号",
    'plesk_key__languages' => "语言包",
    'plesk_key__mailnames' => "邮件帐户",
    'plesk_key__migration_manager' => "迁移与传输管理器",
    'plesk_key__mssql' => "Microsoft SQL Server支持",
    'plesk_key__myplesk_func' => "购买 SSL/TLS 证书及域名注册服务的链接",
    'plesk_key__myplesk_server_id' => "MPC 从属服务器标识符",
    'plesk_key__notifications' => "通知管理",
    'plesk_key__postgresql' => "PostgreSQL数据库服务器支持",
    'plesk_key__qmail_queue' => '邮件队列管理',
    'plesk_key__remote_db' => '远程数据库主机',
    'plesk_key__slave_servers' => "从属服务器",
    'plesk_key__spamassassin' => "垃圾邮件过滤器管理",
    'plesk_key__subdomains' => "子域名管理",
    'plesk_key__sys_access' => "对访问服务器的管理",
    'plesk_key__traffic_reports' => "流量使用报告",
    'plesk_key__tts' => "帮助桌面",
    'plesk_key__virtuozzo' => "仅对 Virtuozzo 容器有效",
    'plesk_key__webusers' => "网站用户",
    'plesk_key__license_update_date' => '许可证下一次更新日期',
    'plesk_key__autoinstaller_config' => '更新程序设置管理',
    'plesk_key__check_wrong' => "许可证密钥无效。若要使用 Plesk，请获取并安装一个新的有效的许可证密钥。",
    'plesk_key__upload_check_wrong' => '上传的许可证无效。',
    'plesk_key__revert_check_wrong' => '之前安装的许可证无效。',
    'plesk_key__update_check_wrong' => '更新的许可证无效。',
    'plesk_key__viruozzo_only_key' => '此许可证密钥仅适用于在 Virtuozzo 容器内操作 Plesk。',
    'plesk_key__ip_ranges_exceeded' => '您只能把该许可授权的 Plesk 副本用于以下的 IP 地址：%2。您的许可证并未覆盖以下的 IP 地址：%1.', //%1 not allowed addresses list separated by comma, %2 allowed IP addresses list separated by comma
    'plesk_key__limits_exceeded' => '当前使用的资源量超过了您的许可证定义的限制。',
    // For the keys below: %1 limit value, %2 used value, %3 delta value
    'plesk_key__limits_exceeded_lim_dom' => '服务器上托管的网站数量超出许可证指定的限制。您有%2个托管的网站；您的许可证仅允许托管%1个网站。',
    'plesk_key__limits_exceeded_lim_domain_aliases' => '服务器上域名别名的数量超过了您许可证所定义的限制。您有%2个域名别名；您的许可证仅允许托管%1个域名别名。',
    'plesk_key__limits_exceeded_lim_cl' => '所服务的客户帐户数量超出许可证指定的限制。当前服务的客户帐户为%2；您的许可中仅允许服务%1个客户帐户。',
    'plesk_key__limits_exceeded_lim_mn' => '所服务的电子邮件帐户数量超出许可证指定的限制。当前所服务的电子邮件帐户数量为 %2；您的许可证仅允许服务 %1 个电子邮件帐户。',
    'plesk_key__limits_exceeded_lim_wu' => '所服务的网站用户帐户数量超出许可证指定的限制。当前服务的网站用户帐户为%2；您的许可证仅允许服务%1个网站用户帐户。',
    'plesk_key__limits_exceeded_MLS' => '当前安装的语言包数量超出许可证指定的限制。已安装了%2个语言包；您的许可证只允许安装%1个语言包。',
    'plesk_key__wrong_version' => '您正在尝试使用为其它 Plesk 版本创建的许可证密钥。请联系 Plesk 销售代表获取正确的许可证密钥。',
    'plesk_key__other_product' => '您正在尝试使用为其它产品创建的许可证密钥。请联系 Plesk 销售代表获取正确的许可证密钥。',
    'plesk_key__invalid_machine_id' => '您正在尝试使用为其它 Plesk 服务器实例创建的许可证密钥。请联系 Plesk 销售代表获取正确的许可证密钥。',
    'plesk_key__limits_exceeded_error' => '无法安装许可证: 当前的控制面板资源使用超过了上传的许可证中定义的限制。',
    'plesk_key__limits_exceeded_note' => '当前的控制面板资源使用超过了上传的许可证中定义的限制。',
    'plesk_key__key_file_invalid' => '上传的许可证文件无效或不包含许可证。',
    'plesk_key__server_request_error' => '无法更新该许可证。确保 TCP 端口 %1 上的许可证服务器 ka.plesk.com 连接未被阻止。<a href="https://support.plesk.com/hc/en-us/articles/213383529" target="_blank">请查看如何操作</a>。',
    'key__no_key_file_in_zip' => '上传的 .zip 文件不包含许可证文件',
    'key__key_upload' => '许可证安装',
    'additional_key__prop_name' => '属性',
    'additional_key__prop_value' => '值',
    'additional_key__descr_name' => '许可证名称',
    'additional_key__descr_key_number' => '许可证号',
    'additional_key__descr_key_vz' => "该许可证只能用于 Virtuozzo 容器中。",
    'additional_key__descr_key_mailboxes' => '邮箱',
    'additional_key__descr_lim_date' => '到期日',
    'additional_key__descr_license_update_date' => '许可证下一次更新日期',
    'additional_key__file_invalid' => '上传的许可证文件无效或不包含许可证。',
    'additional_key__file_incompatible' => '上传的许可证文件不能用于此应用程序。',
    'additional_key__expired' => '其他许可证已过期。',
    'additional_key__not_exists' => '尚未安装许可证。',
    'additional_key__viruozzo_only_key' => '该许可证只能用于在 Virtuozzo 容器中安装的 Plesk。',
    'additional_key_update__result_response' => '许可服务器响应：%1',
    'additional_key_update__result_network' => '无法连接许可服务器。请确保网络可以与%1通信：%2。',
    'additional_key_update__result_lock' => '正在更新许可证',
    'additional_key_update__result_internal_error' => '更新许可证时发生错误：%1',

    'proceed_to_cl_pool' => "继续配置客户的IP地址池",
    'proceed_to_hosting_setup' => "进入主机设置",
    'removeCerts__remove_certificates_cp' => "下列证书将被删除：",
    'removeCerts__remove_certificates_domain' => "%1 所有的下列证书将被删除：",
    'removeClientsIP_remove_clients_ip' => "此IP地址将从下列客户的IP地址池中删除:",
    'removeMailAliases__remove_mail_aliases' => "将删除邮件帐户%1的下列邮件别名：",
    'removeMailNames__remove_mailnames' => "将从域名%1上删除下列邮件帐户和别名：",
    'removeMailNames__remove_mailnames_of_cl' => "下列邮件帐户和别名将从客户%1名下的域名%2中删除:",
    'removeMailNames__these_mailnames_will_not_delete' => "这些邮件名将不会被删除。",
    'removeFtpSessions__remove_title' => "下列 FTP 会话将被终止：",
    'removeTemplates__remove_templates' => "下列模板将被删除：",
    'report_auto__list_title' => 'D',
    'report_auto__list_auto' => '频率',
    'report_auto__list_last' => '最后发送日期',
    'report_auto__list_recipient' => '发送到',
    'report_auto__list_select' => '报告',
    'report_auto__title' => '%1的发送计划',
    'report_auto__recipient_email' => '我指定的电子邮件地址',
    'report_auto__recipient_admin' => '服务器管理员',
    'report_auto__recipient_client' => '客户',
    'report_auto__recipient_domain' => '域名管理员',
    'report_auto_edit__select' => '报告',
    'report_auto__select_client_report_all' => '所有客户',
    'report_auto__select_client_report_current' => '此客户',
    'report_auto__select_client_report_other_client' => '%1',
    'report_auto__select_domain_report_all' => '所有域名',
    'report_auto__select_domain_report_other_client' => '%1的所有域名',
    'report_auto__select_domain_report_client' => '此客户名下的所有域名',
    'report_auto__select_domain_report_reseller' => '此代理商的所有域名',
    'report_auto__select_domain_report_current' => '该域名',
    'report_auto__select_domain_report_other_domain' => '%1',
    'report_auto__legend' => '发送计划',
    'report_auto__select_for_remove' => "选择要删除的发送计划。",
    'report_auto_remove__title' => "下列报告发送计划将被删除：",
    'report_auto_edit__title' => '发送计划属性',
    'report_auto_edit__recipient' => '发送到',
    'report_auto_edit__target' => '报告',
    'report_auto_edit__auto' => '发送频率',
    'resp_edit__always_respond' => "总是响应",
    'resp_edit__reply_subject' => "回复主题",
    'resp_edit__answer_subject' => "主题应答",
    'resp_edit__answer_txt' => "回信正文",
    'resp_edit__attach' => "附加文件",
    'resp_edit__default_subject' => "回复：%1",
    'resp_edit__for' => "用于",
    'resp_edit__frw_rqst_email' => "一旦自动回复，请将原始信息转发到指定的邮箱",
    'resp_edit__fwd_email_invalid' => "目的电子邮件地址无效。",
    'resp_edit__in_body' => "在正文中",
    'resp_edit__in_subject' => "在主题中",
    'resp_edit__invalid_resp_freq' => "响应频率无效。",
    'resp_edit__invalid_rqst_txt' => "无效的请求文本。",
    'resp_edit__invalid_store_lim_num' => "限制值无效。",
    'resp_edit__limits_title' => "限制",
    'resp_edit__maximum_allowed_resp_freq_reached' => "每天的最大回复数量超过了设定的数值。允许：%1，请求：%2",
    'resp_edit__no_files_sel' => "尚未选择文件。",
    'resp_edit__no_txt_supplied' => "尚未提供文本。",
    'resp_edit__reply_title' => "回复",
    'resp_edit__reply_to_address' => "回复地址",
    'resp_edit__reply_to_invalid' => "回复地址无效。",
    'resp_edit__reply_uniq_email' => "给同一个电子邮件地址的回复不超过",
    'resp_edit__conditions_title' => "条件",
    'resp_edit__request_title' => "请求",
    'resp_edit__resp' => "自动回复",
    'resp_edit__resp_name' => "自动回复名称",
    'resp_edit__resp_not_exist' => "自动回复不存在。",
    'resp_edit__resp_status' => "自动回复状态",
    'resp_edit__rqst_txt' => '请求文本',
    'resp_edit__select_files_on_server_for_attach' => "选择要附加的文件",
    'resp_edit__store_up_to' => "存储至",
    'resp_edit__subj_line_invalid' => "主题行有错误。",
    'resp_edit__text_too_big' => "回复邮件文本太长。",
    'resp_edit__times_in_a_day' => "次每天。",
    'resp_edit__unable_define_resp_cond' => "无法定义自动回复条件: %1",
    'resp_edit__unable_define_resp_status' => "无法定义自动回复状态: %1",
    'resp_edit__unable_turn_on_resp' => "无法启用自动回复: %1",
    'resp_edit__uniq_email' => "唯一的电子邮件地址",
    'resp_edit__content_type' => '邮件发送格式',
    'resp_edit__content_type_text' => '纯文本',
    'resp_edit__content_type_html' => 'HTML',
    'resp_edit__charset' => '文本编码',
    'restart__dns' => 'DNS 服务器 (%1)',
    'restart__drweb' => 'Plesk Premium Antivirus',
    'restart__mail' => "IMAP/POP3 服务器 (%1)",
    'restart__mssql' => "%1",
    'restart__mysql' => "MySQL Server",
    'restart__postgresql' => "PostgreSQL",
    'restart__psa' => "服务",
    'restart__smtp' => "SMTP 服务器 (%1)",
    'restart__spamd' => "垃圾邮件过滤器",
    'restart__spamassassin' => "SpamAssassin",
    'restart__stunnel' => "Stunnel",
    'restart__web' => "Web 服务器 (%1)",
    'restart__ftp' => "FTP 服务器 (%1)",
    'restart__service_start' => '请允许一定时间启动服务。',
    'restart__service_stop' => '请允许一定时间停止服务。',
    'restart__service_restart' => '请允许一定时间重启服务。',
    'rm_domains__some_domains_are_not_exist' => "指定的部分域名不存在。可能已被其他用户删除。",
    'rpt_cl_dom_data_bases' => "DBMySQL",
    'rpt_cl_dom_mssql_data_bases' => "DBMSSQL",
    'rpt_cl_dom_mail_groups' => "邮件群组",
    'rpt_cl_dom_mail_lists' => "邮件列表(MList)",
    'rpt_cl_dom_mail_resps' => "自动回复",
    'rpt_cl_dom_mail_antispam' => "垃圾邮件",
    'rpt_cl_dom_mail_antivirus' => "防病毒程序",
    'rpt_cl_dom_postboxes' => "邮箱(MBox)",
    'rpt_cl_dom_redirects' => "转发器",
    'rpt_cl_dom_subdomains' => "子域名",
    'rpt_cl_dom_domain_aliases' => "域名别名",
    'rpt_cl_dom_web_users' => "网站用户",
    'rpt_cl_report_for_admin__' => "针对管理员 %1 的报告",
    'rpt_cl_report_for_reseller__' => "针对代理商 %1 的报告",
    'rpt_cl_report_for_cl__' => "关于客户 %1 的报告",
    'rpt_cl_section_domains' => "域名",
    'rpt_cl_section_full_domains' => "域名",
    'rpt_cl_section_general' => "常用",
    'rpt_create' => "创建报告",
    'rpt_empty' => "报告必须至少包含一个小节",
    'rpt_default_report' => "作为默认报告",
    'rpt_dom_report_for_dom__' => "域名%1的报告",
    'rpt_dom_section_databases' => "数据库",
    'rpt_dom_section_full_databases' => "数据库",
    'rpt_dom_section_full_maillists' => "邮件列表",
    'rpt_dom_section_full_mailnames' => "邮件帐户",
    'rpt_dom_section_full_webusers' => "网站用户",
    'rpt_dom_section_full_siteapps' => 'Web应用程序',
    'rpt_dom_section_full_aspnetapps' => 'ASP.NET Web应用程序',
    'rpt_dom_section_general' => "常用",
    'rpt_dom_section_hosting' => "主机",
    'rpt_dom_section_maillists' => "邮件列表",
    'rpt_dom_section_mailnames' => "邮件帐户",
    'rpt_dom_section_siteapps' => 'Web应用程序',
    'rpt_dom_section_aspnetapps' => 'ASP.NET Web应用程序',
    'rpt_dom_section_webusers' => "网站用户",
    'rpt_dom_title_wa_status' => "S",
    'rpt_edit__' => "编辑报告 %1",
    'rpt_enter_email_address' => "输入报告要发往的电子邮件地址。",
    'rpt_list' => "自定义报告布局",
    'rpt_name' => "报告名称",
    'rpt_remove_reports' => "下列报告布局将被删除：",
    'rpt_reports' => "报告",
    'rpt_section_full' => "全量",
    'rpt_section_none' => "无",
    'rpt_section_summary' => "汇总",
    'rpt_select_reports_for_remove' => "选择要删除的报告布局。",
    'rpt_default_full' => '完整报告',
    'rpt_default_summary' => '概要报告',

    // end of kooper part

    // pit part

    'rpt_send_report_by_email_error__' => "发送报告时发生错误：%1。",
    'rpt_send_report_by_email_ok__' => "报告已发送给%1",
    'sa_action' => "操作",
    'sa_action_del' => "删除",
    'sa_action_desc' => "反垃圾邮件的措施",
    'sa_action_save' => "标识为垃圾邮件并保存在邮箱中",
    'sa_admin_blacklist' => "管理员的黑名单",
    'sa_admin_whitelist' => "管理员的白名单",
    'sa_db_del_confirm' => "您确定要清空垃圾邮件过滤器的数据库吗？",
    'sa_eml_in_ignorelist' => "电子邮件在忽略列表中",
    'sa_empty_email' => "不能添加空的电子邮件模式",
    'sa_exists_email' => "相同电子邮件模式已存在。",
    'sa_disabled__mailname_not_filtering' => "当前服务器设置不允许对此邮件帐户使用邮件过滤功能",
    'sa_disabled__filtering_is_disabled' => '服务器管理员已禁用垃圾邮件过滤功能',
    'sa_disabled__hasnt_mailbox' => "如果没有信箱，则无法启用垃圾邮件过滤功能",
    'sa_enable_filter' => "启用垃圾邮件过滤功能",
    'sa_forget' => "忘记",
    'sa_from' => "来自",
    'sa_ham' => "ham",
    'sa_pattern_is_invalid' => "模式无效。",
    'sa_spam' => "垃圾邮件",
    'sa_trainer__page_title' => '垃圾邮件过滤器培训',
    'sa_trainer__tools_legend' => '工具',
    'sa_trainer__info_legend' => '信息',
    'sa_trainer__messages_list_legend' => '邮箱中的邮件',
    'sa_trainer__c' => 'T',
    'sa_trainer__l' => 'L',
    'sa_trainer__subject' => '主题',
    'sa_trainer__from' => '来自',
    'sa_trainer__date' => '日期',
    'sa_trainer__info_text' => '标记邮件：%1为垃圾邮件，%2为非垃圾邮件，%3全部邮件。',
    'sa_trainer__messages' => '邮件',
    'sa_trainer__select__all' => '所有',
    'sa_trainer__select__spam_only' => '垃圾邮件',
    'sa_trainer__select__ham_only' => '非垃圾邮件',
    'sa_trainer__select__unknown_only' => '未知',
    'sa_trainer__cannot_remove_messages' => '无法从邮箱中删除所选邮件。',
    'sa_trainer__remove_messages_confirm' => '您确定要从邮箱中删除所选邮件吗？',
    'sa_subj' => "主题",
    'sa_training' => "垃圾邮件过滤器培训",
    'sa_training_legend' => "贝叶斯过滤器练习",
    'sa_use_srv_settings' => "使用服务器级设置",
    'sa_user_blacklist' => "用户的黑名单",
    'sa_user_whitelist' => "用户的白名单",
    'sa_usr_disabled_by_srv' => "提供商不允许单独设置垃圾邮件过滤功能",
    'sa_usr_no_postbox' => "无法启用垃圾邮件过滤，因为此电子邮件帐户的邮箱已关闭。",
    'sa_filters' => '垃圾邮件过滤器',
    'spamfilter__tools_legend' => '工具',
    'spamfilter__prefs_legend' => '设置',
    'spamfilter__max_children' => '可运行的 worker spamd 进程的最大数量',
    'spamfilter__rewrite_header_subject_hint' => '如果您不想添加任何文本，保持该字段为空。如果您想要把评分包括在信息主题中请输入评分。',
    'spamfilter__reject_spam' => '邮箱接收到垃圾邮件后，将其删除',
    'spamfilter__enabled' => '已启用',
    'spamfilter_addresses_list__tools_legend' => '工具',
    'spamfilter_addresses_list__list_legend' => '地址',
    'spamfilter_addresses_list__items' => '地址',
    'spamfilter_addresses_list__status' => 'S',
    'spamfilter_addresses_list__level' => 'L',
    'spamfilter_addresses_list__address' => '地址',
    'spamfilter_addresses__file_legend' => '来自文件',
    'spamfilter_addresses__file_label' => '文件名称',
    'spamfilter_addresses__file_hint' => '上传 UTF-8 编码的文件。',
    'spamfilter_addresses__text_legend' => '来自列表',
    'spamfilter_addresses__text_label' => '电子邮件地址',
    'spamfilter_addresses__remove_title' => '下列地址将从列表中删除：',
    'spamfilter_addresses__empty_selection' => '尚未选择地址。',
    'server__admin_info' => "管理员信息",
    'server__ctrl_panel' => "Plesk",
    'server__enter_bug_essence_below' => "在下面输入错误描述",
    'server__power_management' => "电源管理",
    'server__services' => "服务",
    'server__system' => "系统",
    'server__title' => "服务器管理",
    'server_preferences__admin_skin' => "管理员的界面皮肤",
    'server_preferences__default_language' => "默认语言",
    'server_preferences__default_skin' => "默认外观",
    'server_preferences__restart_apache_interval' => "Apache 重启间隔",
    'server_preferences__system' => '系统设置',
    'mail__tabs_preferences' => "设置",
    'mail__tabs_white_list' => "白名单",
    'server_preferences__use_vocabulary' => "检查邮箱密码复杂性",
    'sessions__agreement' => "是的，我希望结束这些会话。",
    'sessions__select_sessions_for_remove' => "选择要结束的会话。",
    'sessions__tabs_cp_sessions' => 'Plesk 会话',
    'sessions__tabs_ftp_sessions' => 'FTP 会话',
    'sessions__ftp_sessions_login' => 'FTP帐户用户名',
    'sessions__ftp_sessions_domain' => '域名',
    'sessions__ftp_sessions_path' => '当前位置',
    'sessions__ftp_sessions_file' => '文件名称',
    'sessions__ftp_sessions_action' => '状态',
    'sessions__ftp_sessions_speed' => '速度，KB/S',
    'sessions__ftp_sessions_comp' => '进度，%',

    'site_apps__access_level' => '访问级别',
    'site_apps__access_level_commercial' => '商业',
    'site_apps__access_level_free' => '免费',
    'site_apps__action_installer' => "Web应用程序安装",
    'site_apps__action_reconfigure' => "Web应用程序重新配置",
    'site_apps__custom_button_level' => '您想要创建能够访问该应用程序的自定义按钮吗？',
    'site_apps__custom_button_level_false_domain_user_only' => '否',
    'site_apps__custom_button_level_domain_user_only' => '是',
    'site_apps__custom_button_level_false' => '否',
    'site_apps__custom_button_level_domain' => '是，仅允许当前域名使用。',
    'site_apps__custom_button_level_client' => '是，允许客户的所有域名可用',
    'site_apps__custom_button_level_admin' => '是，允许所有域名使用',
    'site_apps__description' => "描述",
    'site_apps__dir_used_by_sapp__' => "另一web应用程序正在使用目录\"%1\"。",
    'site_apps__dir_used_by_unknown__' => "目录\"%1\"已存在。继续操作将覆盖它的内容。",
    'site_apps__dir_invalid_name__' => "目录名%1不正确",
    'site_apps__file_name' => 'Web应用程序文件名',
    'site_apps__invalid_install_prefix' => "无效安装前缀。",
    'site_apps__invalid_package' => "Web应用程序无效",
    'site_apps__key_status' => '许可',
    'site_apps__key_status_free' => '自由分发，不需要许可证。',
    'site_apps__key_status_ok' => '所需的许可证已经安装',
    'site_apps__key_status_problem' => '所需的许可证尚未安装',
    'site_apps__name' => "名称",
    'site_apps__no_domains' => '无法安装web应用程序。此域名的根目录中已安装其他web应用程序。请考虑为该web应用程序创建子域名。',
    'site_apps__package_info_' => "Web应用程序信息",
    'site_apps__package_integrated' => "内建应用程序，无法删除",
    'site_apps__pool_select_packages_to_add' => '选择要添加到池中的web应用程序',
    'site_apps__release' => "发行版本",
    'site_apps__resource_used_by_sapp' => "此资源正由已安装的web应用程序使用",
    'site_apps__root_used_by_sapp' => "此资源正在由已安装的web应用程序使用。",
    'site_apps__these_domains_will_not_delete' => '这些(子)域名将不会被删除',
    'site_apps__upload_site_app_pkg_title' => '上传新Web应用程序',
    'site_apps__version' => "版本",
    'site_apps__access_to' => "访问 %1",
    'site_builder_requires' => '%1 - %3',
    'skeleton__admin_label' => "虚拟主机模板",
    'skeleton__client_label' => "%1 虚拟主机模板",
    'skeleton__admin_page' => "管理虚拟主机模板",
    'skeleton__files_list' => "文件与目录",
    'skeleton__archiver_not_installed' => "无法解压压缩文件。服务器上可能尚未安装解压程序，请联系{$PROD_NAME}管理员安装解压软件。",
    'skeleton__client_page' => "管理虚拟主机模板",
    'skeleton__archive_corrupted' => "压缩文件检查发现压缩文件已被损坏或该压缩文件类型不被支持。",
    'skeleton__archive_too_large' => "压缩文件检查发现压缩文件过大。",
    'skeleton__not_supported_archive_type' => "此类型的归档(文件%1)不受支持。",
    'skeleton__upload_archive_file' => "上传压缩文件",
    'skin_download__title' => '下载外观',
    'skin_download_now__title' => '正在下载外观',
    'skin_download_now__text' => '正在创建外观包。<br>该过程可能需要一些时间。<br>在对话框窗口出现后，您可以继续操作 Plesk。',
    'skin_file__help_for_using_types' => "请使用下列格式的皮肤压缩文件:",
    'skin_info__title' => '外观属性',
    'skin_mng_err__rpm_not_skin' => '该 RPM 不是 Plesk 皮肤程序包',
    'skin_mng_err__psa_install_noreloc' => '无法在指定位置安装基于RPM的外观。',
    'skin_mng_err__already_exists' => '此外观安装目录已存在，并且已经部署了一个外观包。',
    'skin_mng_err__rpm_upgrade_nonrpm' => '上传的文件没有有效的RPM外观包。',
    'skin_mng_err__rpm_upgrade_noskin' => '上传的文件没有有效的外观包。',
    'skin_mng_err__rpm_upgrade_base' => "上传的文件不是有效的{$PROD_NAME}外观程序包。",
    'skin_mng_err__rpm_upgrade_other' => '无法安装外观：无效的外观格式。',
    'skin_mng_err__no_a_skin' => "上传的文件不是有效的{$PROD_NAME}外观程序包。",
    'skin_upload__title' => '上传新的外观',
    'skin_upload__already_exists' => "外观'%1'已存在。",
    'skin_upload__unable_to_apply' => "上传的文件不包含 Plesk 皮肤，或者压缩文件格式不被支持。",
    'skin_upload__unable_to_rename__' => "无法将外观%2重命名为%1：%3。",
    'skin_upload__file_name' => '外观程序包文件路径',
    'skins_list__title' => '外观库',
    'skins_remove__title' => '删除外观',
    'skins_remove__select_skins_for_remove' => '选择要删除的外观',

    'spf__unable_update' => '无法更新SPF参数',
    'sshterm__title' => '安全 Shell 终端',
    'sshterm__password_authentication_warning' => '注意：本地SSH服务器配置中已禁用密码验证。如果无法使用SSH终端连接，请让管理员在/etc/ssh/sshd_config文件中设置“PasswordAuthentication yes”。',
    'sshterm__password_authentication_warning_admin' => '注意：本地SSH服务器配置中已禁用密码验证。如果无法使用SSH终端连接，请让管理员在/etc/ssh/sshd_config文件中设置"PasswordAuthentication yes"。',
    'statistics__active_domains' => "活动域名",
    'statistics__clients' => "客户",
    'statistics__subdomains' => "子域名",
    'statistics__cpu' => "CPU",
    'statistics__databases' => "数据库",
    'statistics__db_users' => "数据库用户",
    'statistics__dirs' => "受保护目录",
    'statistics__dom_active' => "活动",
    'statistics__dom_passive' => "关闭",
    'statistics__dom_problem' => "问题",
    'statistics__domains' => "域名",
    'statistics__domains_with_host' => "带有主机服务的域名",
    'statistics__doms' => "域名",
    'statistics__filesystem' => "文件系统",
    'statistics__general' => "常用",
    'statistics__hdd_available' => "可用",
    'statistics__hdd_capacity' => "使用",
    'statistics__hdd_total' => "共计",
    'statistics__hdd_usage' => "硬盘使用",
    'statistics__hdd_used' => "已使用",
    'statistics__ip' => "IP 地址",
    'statistics__key_number' => "许可证号",
    'statistics__l1' => "过去 1 分钟",
    'statistics__l15' => "过去 15 分钟",
    'statistics__l5' => "过去 5 分钟",
    'statistics__la' => "CPU使用",
    'statistics__mail_autoresponders' => "自动回复",
    'statistics__mail_boxes' => "邮箱",
    'statistics__mail_groups' => "邮件群组",
    'statistics__mail_lists' => "邮件列表",
    'statistics__mail_redirects' => "邮件转发器",
    'statistics__mem' => "内存使用量",
    'statistics__mem_usage' => "使用",
    'statistics__memory_available' => "可用",
    'statistics__memory_buffer' => "缓冲区",
    'statistics__memory_cached' => "已缓存",
    'statistics__memory_free' => "免费",
    'statistics__memory_shared' => "共享",
    'statistics__memory_total' => "共计",
    'statistics__memory_used' => "已使用",
    'statistics__os' => "操作系统",
    'statistics__problem_clients' => "问题客户",
    'statistics__problem_domains' => "出故障的域名",
    'statistics__swap' => "交换空间使用情况",
    'statistics__swap_free' => "免费",
    'statistics__swap_total' => "共计",
    'statistics__swap_usage' => "使用",
    'statistics__swap_used' => "已使用",
    'statistics__system_stat' => "服务器信息",
    'statistics__unable_define_active_doms' => "无法定义活动域名的数量：%1。",
    'statistics__unable_define_inactive_doms' => "无法定义非活动域名数量：%1。",
    'statistics__failed_define_swap_usage' => '无法定义交换项的用法',
    'statistics__failed_define_load_averages' => '无法定义加载平均值',
    'statistics__up_time' => "系统运行时间",
    'statistics__ver' => "版本",
    'statistics__web_users' => "网站用户",
    'statistics__mem_win' => "物理内存使用量",
    'statistics__memory_total_win' => "共计",
    'statistics__memory_used_win' => "已使用",
    'statistics__memory_free_win' => "可用",
    'statistics__swap_win' => "虚拟内存使用量",
    'statistics__swap_total_win' => "共计",
    'statistics__swap_used_win' => "已使用",
    'statistics__swap_free_win' => "可用",
    'status__domain_has_reasons_to_be_off' => "客户帐户仍处于挂起状况，原因如下：%1",
    'subdomain__create__' => "在域名%1中创建子域名",
    'subdomain__edit__' => "管理子域名%1",
    'subdomain__invalid_name' => "无效的子域名：只能使用数字、字母和破折号。",
    'subdomain__incorrect_name' => "无效的子域名。",
    'subdomains__maillists_enabled_in_domain' => "不正确的子域名列表。%1：域名%1上的邮件列表正使用此域名。",
    'subdomains__dalias_exists' => '相同名称的域名别名已经存在。',
    'subdomains__name_exists' => "相同名称的子域名已经存在。",
    'subdomains__regular_domain_exists' => "相同名称的域名已经存在。",
    'subdomains__domain_alias_exists' => '相同名称的域名别名已经存在。',
    'subdomains__remove_subdomains_on_domain' => "域名%1的下列子域名将被删除：",
    'subdomains__select_subdomains_for_remove' => "选择要删除的子域名。",
    'subdomains__webmail_enabled_in_domain' => "不正确的子域名  web 邮箱。%1: 此域名用于访问域名%1上的 web 邮箱。",
    'subdomains__dns_record_already_exists' => '因已有DNS记录对应主机%1，从而无法创建子域名%1。',
    'subdomains__www_prefix_in_domain' => "不正确的子域名www.%1: 域名%1已有WWW前缀。",
    'subdomains__user_type_quota_exceeds' => '无法更改用户帐户，因为这将导致超出所分配的磁盘空间。',
    'subdomains__creation_in_dns_slave' => "Plesk 的域名服务器用作该域名的二级（从属）域名服务器。为了正确解析您的子域名，请保证主要的（主） 服务器包含记录 %1。",
    'sys_user__attributes_not_changed' => "尚未更改下列系统用户属性：%1",
    'sys_user__no_access_without_password' => "您没有设置密码。系统用户将被创建，但拥有密码之前此用户将不能登录系统。您要继续吗？",
    'sys_user__no_hard_quota' => "不支持",
    'sysuser__zero_quota_is_unlimited' => "0 表示不受限制",
    'template__num_excl_ips' => "向客户分配独立的 IP 地址",
    'template__sel_sh_ips' => "选择共享的IP地址",
    'template__av_sh_ips' => "可用的共享IP地址",
    'template__up_to_excl_ip' => "最多%1个IP地址",
    'templates__all_clients' => "所有客户",
    'templates__cl_domain_templates' => "%1 的模板",
    'templates__cl_templates' => "客户模板",
    'time__invalid_ip' => "无效 IP 地址或域名。",
    '__please_select_country' => '请选择国家/地区',
    'time__unable_set_time' => "无法设置系统时间：%1",
    'time__sinchronization_setup_error' => '无法设置时间同步：timemng failed: %1',
    'time__sinchronization_disable_error' => '无法禁用时间同步：timemng failed: %1',
    'tmpl__create' => "创建模板",
    'tmpl__edit__' => '模板 %1',
    'tmpl__logrotation_warn' => "套用模板创建的域名，其日志循环功能仅在物理主机帐户创建之后方可生效。",
    'tmpl__name' => "模板名称",
    'tmpl__dom_exist' => "管理员或客户的模板池中已存在相同名称的域名模板。",
    'tmpl__name_invalid' => "模板名称无效或为空。",
    'tmpl__use_next_ip_addr' => "将使用下一个空缺的IP地址",
    'tmpl_name_already_exists' => "名为“%1”的模版已存在。",
    'traffic__no_periods_found' => "无法显示网站和流量统计。此功能在下一次计算统计数据时才可用。",

    'vh_based__no_free_ip_for_vh' => "基于 IP 的虚拟主机没有可用的 IP 地址。 请增加 IP 地址。",

    'wu__at_domains_text' => "允许webuser@%1访问格式",
    'wu__unable_create' => "无法创建网站用户：%1",
    'wu_edit__disk_quota' => "磁盘配额",
    'wu_edit__invalid_pass' => "密码无效。",
    'wu_edit__invalid_quota' => "指定的磁盘空间配额值无效。请输入一个正整数。",
    'wu_edit__invalid_quota_value' => "指定的硬盘空间配额少于当前使用的数量 (%1MB)。这样设置可能造成一些功能无法使用。您确定要继续吗？",
    'wu_edit__not_create_pass' => "此操作不会为新网站用户创建密码。\n如果没有密码，用户将无法登录。",
    'wu_edit__unable_update' => "无法更新网站用户的属性：%1。",

    'bt_webdirs' => '虚拟目录',

    'dns__tabs_general' => '区域设置',
    'dns__tabs_zone_settings' => 'SOA记录',
    'soa__seconds' => '秒',
    'soa__minutes' => '分钟',
    'soa__hours' => '小时',
    'soa__days' => '天',

    'DomainSubdirectory' => '子目录路径',

    'filemanager__select_codepage' => '选择代码页面：',

    'bt_server_app_add' => '添加服务器应用程序',
    'packages_list' => '服务器应用程序',

    'bt_packages_management' => '程序包管理',
    'pb__packages_management' => '应用程序管理',
    'bt_package_new' => '添加应用程序',
    '__packages' => '服务器应用程序',

    'dom_ctrl__mysql_dbase_space' => '所有的 MySQL 数据库配额',
    'dom_ctrl__mssql_dbase_space' => '所有的 MS SQL 数据库配额',

    'dns_add__enter_ixfr_path' => '输入 IXFR 路径',

    'cmd_dns__txt_dns_record_already_exist' => 'SPF TXT 记录已经存在。只能有一个 SPF 记录。若要添加记录，请删除现有的记录。',

    'component_name__network' => '网络',
    'component_name__sitebuilder' => 'Presence Builder',

    'bt_skin_set' => '设置外观',
    'bt_set_skin' => '设置外观',
    'firewall__rule_already_exists' => '名为 &quot;%1&quot; 的规则已存在。',
    'firewall__rule_readonly' => '规则 "%1" 为只读',
    'pb__firewall' => '防火墙',

    '__webstat_smarterstats' => 'SmarterStats',

    'error_doc__erorr_invalid_file_location' => '文件位置无效。',

    'error_doc__erorr_invalid_url_location' =>  'URL 格式错误。请输入网站内的绝对 URL。',

    'mn_list__tab_title_antivirus' => 'AV',

    'bt_antivirus' => '防病毒程序',
    'antivirus__antivirus' => '防病毒保护',
    'antivirus__antivirus_direction_off' => '已关闭',
    'antivirus__antivirus_direction_any' => '传入和传出的邮件',
    'antivirus__antivirus_direction_from' => '仅传出的邮件',
    'antivirus__antivirus_direction_to' => '仅传入的邮件',
    'antivirus__unable_to_update_settings' => '无法更新防病毒设置：%1。',




    '__normal' => '正常',
    '__low' => '低',
    '__high' => '高',

    'mail__antivirus' => "内部邮件服务器的防病毒程序",
    'mail__use_internal_antivirus' => '使用内部防病毒程序',

    'sa__tabs_blacklist' => '黑名单',

    '__mysql_databases' => 'MySQL 数据库',

    'cl_perm__mysql_dbase_space' => '所有的 MySQL 数据库配额',
    'cl_perm__mssql_dbase_space' => '所有的 MS SQL 数据库配额',
    'cl_perm__max_mssql_db' => '最大 Microsoft SQL Server 数据库数量',
    'cl_perm__total_mboxes_quota' => '总邮箱配额',

    'i_i_cl_on' => '客户帐户处于活动状态。',
    'i_i_cl_off_by_admin' => '服务器管理员已挂起此客户帐户。',

    'sa_exists_tn' => '网络已经存在于列表中。',

    'webdir__select_vdirs_to_remove' => '选择要删除的目录',
    'webdir__select_mime_types_to_remove' => '选择要删除的 MIME 类型',

    'defaultcomponents__not_activated' => '尚未激活',

    'bt_traffic_at_domains' => '流量',

    '__awstats_perl_warning' => '不安装 Perl，客户将不能通过 AWStats 去读取往年的统计数据。',

    'class_client__mysql_dbase_space' => '值超出客户限制',
    'class_client__mssql_dbase_space' => '值超出客户限制',
    'class_client__max_mssql_db' => '值超出客户限制',

    'dns__remove_transfer_restrictions_list_items' => '下列网络将会从访问控制列表中删除：',

    'bt_up' => "向上",
    'bt_down' => "向下",
    'virtualdir__type_default_doc_name_to_add' => '输入要添加到列表的文件名',
    'virtualdir__select_default_doc_to_remove' => '删除要从列表中删除的文件',

    'bt_install_selected' => '安装所选许可证', // SELECTED


    'dom_pref__the_domain_resolves_to_another_ip_address' => '该域名解析为其它的 IP 地址：(%1)。请更正 DNS 设置。',

    'mn_edit__mailbox_enable_if_mailgroup_enabled' => '当前所用的邮件服务器不支持同时启用邮箱和邮件群组。按“确定”可在启用邮箱的同时禁用邮件群组。按“取消”则保留原设置不变。',

    'mn_edit__mailgroup_enable_if_mailbox_enabled' => '当前使用的邮件服务器不支持同时启用邮箱和邮件群组。按“确定”可在启用邮件群组的同时禁用邮箱。按“取消”则保留原设置不变。',

    'mysql_dbase_space_limit' => 'MySQL 数据库空间限制',
    'mysql_dbase_usage' => 'MySQL 数据库空间使用率',
    'mssql_dbase_space_limit' => 'Microsoft SQL Server 数据库空间限制',
    'mssql_dbase_usage' => 'Microsoft SQL Server 数据库空间使用率',

    '__statistics' => "统计数据", //indirect

    'dns__soa_minimum_value_is_big' => '设置大于3小时的最小TTL值会使某些域名管理员无法访问您的域名。建议仅当您的域名注册商要求这样设置时，才设置这样的值。',

    'virusfilter__interface_not_available' => '尚无可用病毒过滤器。',
    'virusfilter__none_virus_filter' => '无',
    'virusfilter__mailname_status_text' => '防病毒程序 (%1)',
    'virusfilter__status_none' => '禁用',
    'virusfilter__status_any' => '传入和传出邮件',
    'virusfilter__status_outgoing' => '仅限传出邮件',
    'virusfilter__status_incoming' => '仅限传入邮件',

    'visibility__adminonly' => '仅管理员',
    'visibility__button_sets' => '控件',
    'visibility__control' => '单击自定义此控件。',
    'visibility__customization_footnote' => '单击“确定”完成屏幕自定义。',
    'visibility__default' => '默认',
    'visibility__export_note' => "将要导出您所做的自定义设置。现在将会下载 shell 脚本到您的电脑。要在其它的 Plesk 服务器上应用这些设置，覆盖任何现有的界面管理设置，请上传并执行该脚本。\n请注意如果您在此屏幕上做了任何修改而还未点击确定，导出的数据将不会包括您最新所做的修改。",
    'visibility__hide' => '隐藏',
    'visibility__reset_all' => '全部重置为默认值',
    'visibility__reset_screen' => '恢复此屏幕的原始布局',
    'visibility__root_override_parse_error' => '文件%1的第%2行有语法错误。',
    'visibility__screen_title' => '界面管理',
    'visibility__set_billing_enabled' => '断开连接 Customer and Business Manager',
    'visibility__set_cert_puchasing' => '隐藏用于购买证书的按钮',
    'visibility__set_domain_registration' => '隐藏域名注册的按钮',
    'visibility__set_extras' => '隐藏用于其它服务的按钮',
    'visibility__set_mail_bounce' => '隐藏邮件地址不存在的退信控件',
    'visibility__show' => '显示',
    'visibility__show_toolbar' => '显示界面管理工具栏',
    'visibility__standby_footnote' => '单击自定义当前屏幕的控件。',
    'visibility__standby_footnote_nocontrols' => '此屏幕上没有自定义控件。',

    'bt_mpc' => "MyPlesk.com",
    'sb__not_support_publishing_api' => "组件不支持自动发布",

    'component_name__cphosting' => "Plesk 主机",

    'dom_pref__unable_set_up_total_mboxes_quota' => '当前邮件服务器不支持设置邮箱配额。',
    '__unable_get_total_mboxes_quota' => '当前邮件服务器不支持设置邮箱配额。',

    'install_prefix__parent_not_exists' => "父目录不存在。",

    'bt_change_version' => '更改版本',
    'aspdotnet__changeversion_title' => '选择 ASP.NET 版本',
    'pb__aspdotnet' => 'ASP.NET',

    '__check_all' => "全选",
    '__uncheck_all' => "清空全部",

    'dns__editing_domain_controller_zone' => "编辑域名控制器的 DNS 区域记录可能会导致域名功能出现问题",

    'pb__interface_management' => "界面管理",
    'interface_management__tabs_skins' => "皮肤",
    'interface_management__tabs_interface_templates' => "界面模板",
    'interface_management__tabs_locales' => "区域设置",
    'locales_list__title' => "语言包的库",
    'locales_list__legend' => "可用语言",
    'locales_list__active_title' => "S",
    'locales_list__locale_title' => "语言包",
    'locales_list__lang_title' => "语言",
    'locales_list__country_title' => "国家",
    'locales_list__used_title' => "已使用",

    'backup__suspend_warning_during_backup' => "备份过程中，此域名不可用",
    'backup__suspend_warning_during_restore' => "恢复过程中，此域名不可用",
    'backup__suspend_domain' => "挂起域名",

    'locales_list__mls_limit' => "您当前的 Plesk 许可证允许使用 %2 种语言。目前，您已设置用户可使用 %1 种语言，这超过了许可证允许的数量。请选择您想要使用的 %2 种语言，且通过点击 'S' 栏中的相应图标来设置用户不可使用剩下的语言。",

    'bt_change_owner' => '分配新所有者',
    'chown__new_owner' => '新的所有者',
    'chown__selected_domains' => '所选订阅',
    'chown__limits_legend' => '资源',
    'chown__limit_name' => '资源名称',
    'chown__limit_value' => '已分配资源',
    'chown__limit_assigned_before' => '移交前',
    'chown__limit_assigned_after' => '移交后',
    'chown__error_limits' => "无法移交域名。目标用户帐户所能提供的资源数量无法满足此域名的需要。",
    'chown__error_no_domains' => '无法继续移交订阅：未选择订阅，或选择的订阅已属于目标客户。',
    'chown__error_empty_ip_pool' => "无法继续移交订阅：新所有者的提供商的 IP 池为空。请确保提供商的 IP 池中至少有一个 IP 地址。",
    'chown__please_select_new_domain_owner' => '请为此域名选择新的所有者。',
    'chown__old_ip_address' => '当前IP地址',
    'chown__new_ip_address' => '新的IP地址',

    'chown__error_ssl_already_used' => "SSL/TLS 支持已用于以下目的 IP：%1 因此，无法迁移下列带有 SSL/TLS 支持的域名：%2。请解决该问题再重试",
    'chown__sitebuilder_not_installed' => '未安装 Presence Builder',
    'chown__domain_exclude_sitebuilder_not_installed' => '未安装 Presence Builder，无法移交域名 %1 给另一所有者。',

    'backup__backup_time' => '备份时间',
    'backup__backup_time_hour' => '小时',
    'backup__backup_time_minute' => '分钟',
    'backup__every' => '每',
    'backup__day_of_month' => '日期',

    'subdomain__select_hst_type' => '选择子域名的主机类型',
    'hst_sel__subdom_subfolder_hst' => '子文件夹中的子域名',
    'subdomain__www_root_folder_not_exists' => '网站主目录%1不存在',
    '__site_home_dir' => '网站主目录',
    'subdomain__aspnet_disabled_domain' => '按域名禁用',

    'domains__remove_description' => '所有域名数据（包括域名及其对应的子域名内容与设置、web 应用程序数据、邮箱内容、邮件、防病毒程序和垃圾邮件过滤设置、日志文件、域名备份 repository 数据和 SSL/TLS 证书）都将被删除。如果您未在本机上备份，所有的数据将会永久丢失。',
    'subdomains__remove_description' => '所有子域名数据(包括子域名内容和设置、web应用程序和记录文件)将被删除。如果您未在本机上备份这些文件，所有的资料将会永久丢失。',

    'mail__tabs_spam_filtering' => '垃圾邮件过滤',
    'mail__tabs_antivirus' => '防病毒程序',
    'antivirus__use_server_settings_scan' => '使用默认服务器级的设置(扫描)',
    'antivirus__use_server_settings_no_scan' => '使用默认的服务器级的设置(请不要扫描)',
    'antivirus__check_for_viruses' => '扫描病毒',
    'antivirus__dont_check_for_viruses' => '请不要扫描病毒',
    'antivirus__incoming_mail' => '传入邮件',
    'antivirus__outgoing_mail' => '传出的邮件',

    'domain_alias__CNAME_dns_record_exists' => '相同名称的 DNS CNAME 记录已经存在',
    'domain_alias__A_dns_record_exists' => '相同名称的 DNS 记录已经存在',
    'domain_alias__bad_prefix' => '域名别名的前缀错误',
    'domain_alias__domain_doesnt_exist' => "域名不存在",

    'dns__zone_ttl_message_info' => '若未指定 TTL 值，SOA 记录模板 (%1) 中的 TTL 值将用于此 DNS 记录。',

    '__webalizer_support' => 'Webalizer',
    '__awstats_support' => 'AWstats',
    '__smarterstats_support' => 'SmarterStats',

    'site_apps__make_default_warning_message' => "创建名称为index.html的文件，用于跳转到所选的web应用程序。如果名称为index.html的文件已存在，它将被备份为index.html.old，并被新文件取代。请按“确认”来确认。",

    'bt_ftp_ctrl' => "其他FTP帐户",
    'ftp_users_no_permission' => "您尚无管理此域名FTP子帐户的权限",
    'ftp_users_limit_reached' => "已达到此域名的FTP子帐户限制",
    'pb__ftp_ctrl' => "FTP管理",
    'class_client__max_subftp_users' => "其它 FTP 帐户",

    '__client_form_settings' => "客户设置",
    '__sbnet_client_keep_sbnet' => "在 Presence Builder 中保留相应用户帐户",
    '__sbnet_cant_add_more_sites' => "此客户可以使用的 Presence Builder 网站已达到数量限制",
    '__sbnet_legend_text' => "Presence Builder 整合",
    '__sbnet_synchronize_user_with_sbnet' => "在 Presence Builder 中创建相应的用户帐户",
    '__sbnet_client_warning_delete_sb_user' => "您正尝试删除与此客户相关的 Presence Builder 用户。这项操作将会删除所有的 Presence Builder 用户设置和数据，并禁止通过 Presence Builder 编辑现有网站(即使您稍后启用此选项)。如果稍后再创建 Presence Builder 用户，您将需要重新创建和发布所有网站。您确定要禁止通过 Presence Builder 创建和发布网站吗？",
    'sb__build_site_with_subdomains' => "创建博客和照片图库子域名",
    '__sbnet_client_dont_have_sbuser' => "无法使用创建和发布网站 Presence Builder:Presence Builder 用户不存在",

    '__component_disabled' => "禁用组件",

    'subdomains__physical_path_not_exist' => "子域名链接到不存在的物理文件夹",

    'dnsserver_bind_to_msdns_switching_warning' => "警告：仅限于传输“访问控制列表”上掩码为/8和/16的254个子网IP地址(从开始计算)。它们将会被作为单个IP地址进行传输。您想要继续吗？",

    '__sbnet_net_framework_required_for_site' => "Presence Builder 网站可能需要在您的域名上启用 ASP.NET 2.0 支持。如果您正使用 Presence Builder 我们建议启用 ASP.NET 2.0 支持。",

    'subdomain_auto_create_dir' => "为子域名创建物理目录",

    'sa_trainer__unable_to_get_messages_list' => "无法在邮箱中取得邮件列表：%1",
    'sa_trainer__pass_doesnt_exist' => "此邮件帐户的密码丢失",

    '__sitebuilder_error' => "尝试连接 Presence Builder 时出错。请联系 Panel 服务商寻求协助。",
    'wsb_error_user_not_exist' => "Presence Builder 用户不存在。",
    'wsb_error_site_already_exist' => "网站已在 Presence Builder 中。",
    'wsb_error_site_limit_reached' => "达到 Presence Builder 网站数限制。",
    'wsb_error_internal_error' => "发生 Presence Builder 内部错误。请联系管理员。",
    'wsb_error_user_already_exist' => "Presence Builder 中已存在带有相同名称的 Presence Builder 用户。",
    'sb_error_user_not_exist' => "Presence Builder 用户不存在。",
    'wsb_error_object_not_found' => "Presence Builder 无法找到正确的主机项。",

    'mg_no_mail_groups' => "无邮件群组",

    'drweb__drweb_incoming' => '对传入的邮件进行防病毒检查',
    'drweb__drweb_outgoing' => '对传出的邮件进行防病毒检查',
    'drweb__disable_reason_serv' => '邮件服务器不支持邮箱级别的防病毒过滤器设置',

    'vz_sitebuilder3_client_cant_be_created' => "无法创建客户帐户: 未安装SiteBuilder 3.1或更高版本",

    'chown__client_without_sitebuilder_support' => "无法继续移交订阅: 新所有者或其提供商的服务方案不包括 Presence Builder 服务。",

    // new limits

    'class_client__max_odbc' => "ODBC 连接",
    'cl_perm__max_odbc' => "ODBC连接的最大数量",

    // domain aliases DNS
    'domain_alias__list_status' => 'S',
    'domain_alias__list_name' => '域名别名',
    'domain_alias__list_ascii_name' => '使用ASCII形式',


    // Interface Customization Templates
    'interface_preferences' => '界面管理',
    'pb__interface_templates' => '界面管理',
    'pb__interface_clients' => '使用%1的客户',

    // service management
    'bt_service_showall' => "显示全部",
    'bt_service_hideall' => "隐藏全部",
    'bt_service_start' => "启动",
    'bt_service_stop' => "停止",
    'bt_service_restart' => "重新启动",
    'bt_service_disable' => "关闭",
    'bt_service_manual' => "手动",
    'bt_service_auto' => "自动",
    'comp_info__statup_type' => '启动类型',
    'service_startup_auto' => '自动',
    'service_startup_manual' => '手动',
    'service_startup_disabled' => '关闭',
    'service_action_ok' => "%1服务操作成功完成",
    'service_action_failed_disabled_service' => "无法完成%1服务操作，因它已禁用",
    'service_action_failed_error' => "无法完成操作：%1",
    'service_group_action_ok' => "下列服务操作已成功完成：%1",
    'service_group_action_disabled' => "无法完成下列服务操作，因它们已禁用：\n%1",
    'service_group_action_failed' => "无法完成下列服务操作：%1。要接收关于错误的详细信息，请分别执行每个服务操作",

    // php 4vs5
    'bt_php' => "PHP 设置",

    // Mass mail

    'massmail__resellers_list_available_for_select' => '可用代理商',
    'massmail__resellers_list_selected' => '所选代理商',
    'massmail__clients_list_available_for_select' => '可用客户',
    'massmail__clients_list_selected' => '所选客户',
    'massmail__advanced' => '高级',
    'bt_massmail_send' => '发送',
    'massmail__save_template_name' => '将文本保存至新命名的模板',
    'massmail__template' => '模板',
    'massmail__compose_mail' => '信息',
    'massmail__from' => '来自',
    'massmail__to' => '至',
    'massmail__subject' => '主题',
    'massmail__body' => '信息文本',
    'massmail__body_hint' => '使用<name>变量向您的邮件自动插入联系人姓名信息。',
    'massmail__send_to_clients' => "客户",
    'massmail__send_to_domainusers' => "域名管理员",
    'massmail__send_to_admins' => "Plesk 管理员",
    'massmail_select' => '选择地址',
    'massmail_showhide_selected' => "显示/隐藏所选项",
    'massmail_send_all' => "所有",
    'massmail_send_selected' => "仅所选项",
    'massmail_send_except' => "除所选外的全部项",
    'bt_new_mass_mail_template' => "添加群发邮件模板",
    '__mass_mail_templates_list' => "群发电子邮件模板列表",
    'massmail__template_name' => '模板名称',
    'massmail__receivers' => '收件人',
    'massmail__created' => '发件人',
    'massmail__date_created' => '创建日',
    'massmail__compose' => '发送',
    'mass_mail__resellers_all' => '所有代理商',
    'mass_mail__clients_all' => '所有客户',
    'mass_mail__domainusers_all' => '所有域名管理员',
    'mass_mail__resellers_selected' => '所选代理商',
    'mass_mail__clients_selected' => '所选客户',
    'mass_mail__domainusers_selected' => '所选域名管理员',
    'mass_mail__resellers_except' => '排除所选之外的其他代理商',
    'mass_mail__clients_except' => '除选中之外的所有客户',
    'mass_mail__domainusers_except' => '除所选的之外的所有域名管理员',
    'mass_mail__admins_all' => '所有管理员',
    'massmailtemplateslist__title' => '群发邮件模板',
    'massmail__insert_from_template' => "从模板插入数据",
    'massmail__select_template' => "所选模板",
    'massmail__body_short_hint' => "(仅纯文本)",
    'massmail__from_short_hint' => "(电子邮件或名称)",
    'bt_insert' => "插入",
    'massmail__mail_send_successfully' => "邮件发送成功",
    'massmail__mail_send_successfully_with_some_errors' => "邮件已发出，但出现数个错误。一些收件人可能没有收到邮件。如需更多信息，请参见下面的日志文件：%plesk_dir%\\admin\\logs\\send_mass_mail.log",
    'massmail__mail_send_failed' => "信息未被发出。请确定至少选定了一个收件人且 Plesk 的邮件服务器运行正常。欲了解更多信息，请查看以下日志文件：%plesk_dir%\\admin\\logs\\send_mass_mail.log",
    'massmail__template_data_inserted' => "模板%1的数据已成功插入。",
    'massmail__template_added_successfully' => "群发电子邮件消息数据已保存在名为%1的模板中。",

    // wsb integration
    'wsb_error_sitebuilder_database_error' => "Presence Builder 数据库错误。请联系服务商寻求协助。",
    'wsb_error_sitebuilder_access_denied_error' => "无法访问文件: Presence Builder 不具有访问所请求文件或文件夹的权限。请联系服务商寻求协助。",
    'wsb_error_sitebuilder_connection_failed' => "无法连接 Presence Builder: 连接丢失。请联系服务商寻求协助。",
    'wsb_error_critical_during_operation' => "Presence Builder 严重错误:\n%1",
    'wsb_error_license_during_operation' => "出现的 Presence Builder 许可证错误：\n%1",
    'wsb_error_during_operation' => "出现的 Presence Builder 错误：\n%1",
    'wsb_error_license_error' => "遇到 Presence Builder 许可证限制",

    // Other
    '__confrim_service_stop' => "警告！如果您停止服务 %1，Plesk 可能也会停止工作。您确定要停止服务 %1 吗？",
    'virtualdir__name_is_reserved' => "该名称已保留",
    'index_redirect_help_text' => '现在您将被自动重定向到所需网站。如果您的浏览器不支持重定向，请单击%1此处%2',
    'bt_default_settings' => "恢复默认",
    'logfiles__remove_failed' => "无法删除文件%1：文件被另一个应用程序锁定。请稍候重试",
    'subdomain__invalid_homedirectory' => "指定的子域名主目录无效",
    'scheduler_item__empty_filename' => "请指定可执行文件以运行",
    'subdomains__overlapped_domain_exists' => '子域名与域名 %1 的 DNS 区域重叠',
    'subdomains__overlapped_domain_alias_exists' => '子域名与域名别名 %1 的 DNS 区域重叠',
    'services_action_none_selected' => '无法完成操作：请选择所需服务',
    'cl_perm__max_subftp_users' => "FTP子帐户的最大数量",
    'login_up__access_denied_no_cp_access' => '访问被拒绝。您无权访问 Plesk。',
    'drweb__disable_reason_admin' => "服务器策略不允许邮箱级反病毒过滤器设置。",

    'webdirs__name_is_invalid' => '仅可在目录名中使用字母数字、下划线和破折号字符。',
    'webdirs__physical_path_is_invalid' => '物理路径无效或不存在',
    '__use_default' => '使用默认',
    'odbc__dsn_list_legend' => 'ODBC DSN 连接',

    'webalizer_hidden_referrer__already_exist' => '该项目已存在。',
    'webalizer_group_referrer__already_exist' => '使用相同名称的一组反向链接已经存在。',

    'pb__dashboard' => '首页',

    'server_interface__page_title' => '服务器界面设置',
    'server_interface__tabs_locales' => '区域设置',
    'server_interface__tabs_skins' => '皮肤',
    'server_interface__tabs_interface_templates' => '界面模板',
    'bt_server_interface' => '界面偏好设置',
    'pb__server_interface' => '界面偏好设置',

    'bt_wizard_next' => '下一个 >>',
    'bt_wizard_prev' => '<< 返回',

    '__limit_exceeded_max_dom_server' => '无法在此服务器上托管更多域名，因为已达到许可证对该台服务器域名数量的限制。请联系您的服务提供商解决此问题。',
    '__limit_exceeded_max_subdom_server' => '您无法在此服务器上托管更多的子域名。请联系您的服商。',
    '__limit_exceeded_max_dom_aliases_server' => '您无法在此服务器上设置更多的域名别名。请联系您的服务商。',
    '__limit_exceeded_max_wu_server' => '因达到许可证允许的服务器上网站用户的数量限制，无法创建更多的网站用户。请联系服务商解决此问题。',
    '__limit_exceeded_max_mn_server' => '因达到许可证允许的服务器上邮件帐户的数量限制，无法创建更多的邮件帐户。请联系服务商解决此问题。',

    '__limit_exceeded_max_cl_useradmin' => '已达到许可证所定义的客户帐户数量限制(%2)',
    '__limit_exceeded_max_dom_useradmin' => '已达到许可证所定义的域名数量限制(%2)',
    '__limit_exceeded_max_subdom_useradmin' => '已达到许可证定义的子域名数量限制(%2)。',
    '__limit_exceeded_max_dom_aliases_useradmin' => '已达到许可证定义的域名别名数量限制(%2)',
    '__limit_exceeded_disk_space_useradmin' => '磁盘空间已满',
    '__limit_exceeded_max_wu_useradmin' => '已达到许可证所定义的网站用户帐户数量限制(%2)',
    '__limit_exceeded_max_db_useradmin' => '已达到许可证所定义的数据库数量限制(%2)',
    '__limit_exceeded_max_box_useradmin' => '已达到许可证所定义的邮箱数量限制(%2)',
    '__limit_exceeded_max_mn_useradmin' => '已达到许可证所定义的电子邮件帐户数量限制(%2)',
    '__limit_exceeded_max_maillists_useradmin' => '已达到许可证所定义的邮件列表数量限制(%2)',

    '__limit_exceeded_max_dom_userclient' => '已达到域名数量限制(%2)。',
    '__limit_exceeded_max_subdom_userclient' => '您已达到服务提供商允许的子域名数量限制(%2)',
    '__limit_exceeded_max_dom_aliases_userclient' => '已达到域名别名数量限制(%2)',
    '__limit_exceeded_disk_space_userclient' => '已达到磁盘空间使用限制(%2)',
    '__limit_exceeded_max_traffic_userclient' => '已达到每月使用的带宽量限制(%2)',
    '__limit_exceeded_max_wu_userclient' => '已达到服务提供商允许的网站用户数量限制(%2)。',
    '__limit_exceeded_max_db_userclient' => '已达到数据库数量限制(%2)',
    '__limit_exceeded_max_box_userclient' => '已达到邮箱数量限制(%2)',
    '__limit_exceeded_max_maillists_userclient' => '已达到邮件列表数量限制(%2)。',
    '__limit_exceeded_expiration_userclient' => '您的帐户终止期为%2。',

    '__limit_exceeded_max_subdom_userdomain' => '您已达到服务提供商允许的子域名数量限制(%2)',
    '__limit_exceeded_max_dom_aliases_userdomain' => '已达到域名别名数量限制(%2)',
    '__limit_exceeded_disk_space_userdomain' => '已达到磁盘空间使用限制(%2)',
    '__limit_exceeded_max_traffic_userdomain' => '已达到每月使用的带宽量限制(%2)',
    '__limit_exceeded_max_wu_userdomain' => '已达到网站用户帐户的数量限制(%2)',
    '__limit_exceeded_max_db_userdomain' => '已达到数据库数量限制(%2)',
    '__limit_exceeded_max_box_userdomain' => '已达到邮箱数量限制(%2)',
    '__limit_exceeded_max_maillists_userdomain' => '已达到邮件列表数量限制(%2)。',
    '__limit_exceeded_expiration_userdomain' => '您的帐户终止期为%2。',

    'mmt__to_none' => '无',
    'mmt__to_admin' => '管理员',
    'mmt__to_resellers_all' => '所有代理商',
    'mmt__to_resellers_select' => '所选代理商',
    'mmt__to_resellers_select__available' => '可用代理商',
    'mmt__to_resellers_except' => '排除所选之外的其他代理商',
    'mmt__to_clients_all' => '所有客户',
    'mmt__to_clients_select' => '所选客户',
    'mmt__to_clients_select__available' => '可用客户',
    'mmt__to_clients_except' => '除选中之外的所有客户',

    'mmt__unable_send_empty_selection' => '无法群发邮件，尚未选择电子邮件地址。',
    'mmt__unable_send_to__' => '无法群发邮件至：',
    'mmt__unable_send_to_email' => '%1 <%2>',

    'sapp_error_validation_not_found' => '因未找到所需文件(%1)，导致无法验证web应用程序。请联系技术支持代表寻求协助。',
    'sapp_error_validation_spec_failed' => '上传的web应用程序不符合应用程序包规范: %1。',
    'sapp_error_validation_register' => '无法注册目录"%1"中的web应用程序: %2请从服务器上删除web应用程序，它才可以正常运行。',

    'sapp__install_failed' => 'Web应用程序安装失败: %1',
    'sapp__install_res_failed' => '创建请求的资源失败。',

    'server_preferences__subdomains_blog_and_photo' => '默认创建博客和图片库子域名',
    'plesk_key__blog_and_photo' => '允许管理“创建博客”和“图片库”子域名复选框的默认状态',
    'ip_ctrl__cannot_make_exclusive_ip_with_more_than_one_client' => '如果 IP 被分配给一个以上的客户，则无法将其设置为独立型',

    // 8.1.1

    '__write_modify_warning' => '选择其他写入/修改权限将使得一些 web 应用程序正常运行，但是也会大大增加安全风险',
    '__write_modify_subdomain_warning' => '选择其他写入/修改权限将使得一些 web 应用程序正常运行，但是也会大大增加安全风险',

    'phosting__php_incorrect_version_used' => "发现 PHP 版本问题。若要解决这些问题，请选中下面所需PHP版本对应的复选框并单击“确定”。若要禁用该域名的PHP，无需选择PHP版本直接单击“确定”即可。",
    'fp__mail_preferences' => '邮件设置',

    'mail__invalid_white_pattern' => '指定的值无效。请使用下列格式: mail@example.com 用于电子邮件地址，example.com 用于域名。',
    'mail__invalid_black_pattern' => '指定的值无效。请使用下列格式: mail@example.com 用于电子邮件地址，example.com 用于域名。',

    'resp_edit__reply_as_html' => '以 HTML 发送',
    'exception__path_very_long' => "路径过长。请确定路径长度不超过%1个字符。",

    // 8.2


    //SAPP
    'sapp_on' => '启用',
    'sapp_off' => '停用',
    'sapp_directive_aspect' => '需要',
    'sapp_databases_num' => '数据库',
    'sapp_db_required' => '需要',
    'sapp_Required' => '需要',
    'sapp_Variant' => '变量',
    'sapp_db_id' => '数据库ID',
    'sapp_db_id_type' => 'DB (id: %1)类型',
    'sapp_db_id_min_version' => 'DB (id: %1)最低版本',
    'sapp_db_id_table_prefix' => 'DB (id: %1)表前缀',
    'sapp_Default' => '默认值',
    'sapp_apache_mod_req' => 'Apache模块',
    'sapp_dbtype_not_installed' => '未安装',
    'sapp_apache_mod_not_installed' => '未安装',
    'sapp__value_error_empty' => '不允许空值。',
    'sapp_error_invalid_type' => '应用程序“%1”不支持所请求的操作。',
    'sapp_error_unknown_app_type' => '不受支持的应用程序类型：%1。',
    'sapp__ssl_text' => '将应用程序安装到“http://”或“https://”虚拟主机？',
    'sapp__app_to_upgrade' => '待升级的应用程序',
    'sapp__upgrade_apps_title' => '升级应用程序',
    'sapp__upgrade_to_ver' => '升级到',
    'sapp__choose_pkg_ver' => '选择程序包...',
    'sapp__pkg_cant_upgrade_pkg' => '程序包"%1" 无法用于升级web应用程序"%2"。',
    'sapp__app_ugrade_error' => '无法升级应用程序：%1。请联系系统管理员。',
    'sapp__no_suitable_db_found' => '未找到合适的数据库。',
    'sapp__upgrade_success' =>  '应用程序已成功升级。',
    'sapp__pkg_info_changelog' => '变更历史记录',
    'sapp_requirement_legend' => '此应用程序需要主机功能',

    // other
    'odbc__mssql_wsid' => '工作站ID',
    'odbc__mssql_driver' => '驱动程序',
    'bt_apply' => '应用',
    'mn_edit__add_alias_if_mailbox_disabled' => '若要创建邮件别名，此邮件帐户的邮箱应处于启用状态。是否启用邮箱？',
    'mn_edit__mailbox_disable_if_has_alias' => '禁用邮箱将会删除所有的邮件别名，因它们将停止工作。是否禁用邮箱？',
    'odbc__mysql_driver' => 'MySQL ODBC驱动程序',
    'antivirus__disable_reason_install' => '因尚未安装，导致无法管理防病毒软件。',
    'antivirus__disable_reason_key' => '因由不正确的许可证激活，导致无法管理防病毒功能。',
    'antivirus__disable_reason_deny_personal_settings' => '因服务器策略禁止单独进行防病毒设置，导致无法管理防病毒功能。',
    'component_name__sqladminmssql' => 'Microsoft SQL Webadmin',
    'change_foreign_user_password' => '更改密码',
    'change_foreign_user_password_hint' => "此用户不属于该应用程序。单击此链接转到另一应用程序，并在该处更改用户密码。若要执行此操作，您必须在此应用程序中具备相应权限。",
    'cf_url_text' => 'JDBC URL',
    'cf_sendStringParametersAsUnicode_text' => '字符串格式',
    'lang_unknown' => '未知语言',
    'odbc__access_driver' => '驱动程序',
    'odbc__access_pwd' => '密码',
    'odbc__access_uid' => '登录 ID',
    'odbc__excel_driver' => '驱动程序',
    'pb__cl_ed' => '客户详情',
    'pb__actionlog' => '操作日志',
    'pb__cl_limits' => '客户限制',
    'pb__edit' => '编辑',
    'pb__subdom_edit' => '主机设置',
    'cf__select_dsn_to_remove' => '选择至少一个待删除的DNS',

    // NEW 8.3 FEATURES

    'backup_mail_content' => '备份邮箱内容',

    'maillist_import_result' => "文件中的总电子邮件地址数：%1\n所导入的电子邮件地址数：%2\n已存在的电子邮件地址数：%3\n指定文件中重复的电子邮件地址数：%4\n文件中无效的电子邮件地址数：%5",
    'maillist_import_error' => '无法导出电子邮件地址列表',

    //  spaw

    'spaw__unable_to_edit_no_body' => "您已选定的文件要么为空要么是选定编码无效的 HTML 文件。请选择正确的编码或简单地添加内容到文件。",

    'dom_pref__external_mail_srv' => "重定向到该 IP 地址的外部邮件服务器：",
    'mn_edit__store_messages' => '邮箱',

    // aps

    'sapp__before_upgrade_notice' => '建议您在启动升级进程之前备份应用程序和用户数据。',
    'sapp__application_properties' => '应用程序属性',
    'sapp__application_root_descr' => '应用程序主首页',

    'sapp__aps_license_invalid_id' => '许可证ID有效：%1。',
    'sapp__aps_lic_key_alredy_exists' => '数据库中已有许可证号为%1的许可证。',
    'sapp__aps_lic_del_used' => '无法删除此许可证，所安装的某个应用程序正在使用此许可证。',
    'sapp__aps_lic_del_unknown' => '无法删除许可证：%1',
    'sapp__aps_cappi_duplicate' => "此应用程序已在该客户的应用程序池中",
    'sapp__appi_not_shared_no_install' => "客户应用程序池中没有此应用程序。如果您想在网站上安装此应用程序，请先将此应用程序添加到客户应用程序池中。",
    'sapp__appi_shared_not_client' => "客户应用程序池中没有此应用程序。如果您想将此应用程序升级到指定版本，请先将此版应用程序添加到客户应用程序池中。",
    'sapp__apply_license_script_not_found' => '无法找到此web应用程序的"apply-license"脚本。',
    'sapp__unable_to_activate_key' => '尝试激活许可证的过程中出错：%1',
    'sapp__unable_to_delete_ai_instances_exists' => '系统中已安装所需web应用程序。',
    'sapp__unable_to_delete_ai_in_pool' => '此应用程序仍在客户池中。如果要删除此应用程序，您需要先从所有客户应用程序池中删除它，或允许用户免费使用它。',
    'sapp__unable_to_delete_app_template' => '无法删除应用程序#%1: %2',
    'sapp__limit_exceeded_client' => '您已达到此web应用程序的安装次数限制(%2)。',


    // atis module

    '_week_on' => '周',
    '__week_first' => '首页',
    '__week_second' => '第二',
    '__week_third' => '第三',
    '__week_fourth' => '第四',
    '__week_last' => '最后',
    '__not_started' => '等待',
    '__started' => '正在运行',
    '__cancel_pending' => '正在取消',
    '__canceled' => '已取消',
    '__error' => '错误',
    '__done' => '完成',

    '__php_cgi_handler' => 'CGI应用程序',
    '__php_isapi_handler' => 'ISAPI扩展',
    '__php_fastcgi_handler' => 'FastCGI应用程序',
    '__php_module_handler' => 'mod_php',
    '__php_run_as' => '运行身份',

    'cf_dbfolder_text' =>'数据库文件夹',
    'cf_isnewdb_text' => '创建数据库',
    'cf_isnewdb_title' => '若必须创建数据库数据库，请选中复选库',

    'pb__site_apps_upgrade' => 'Web应用程序升级',

    'detach' => '断开连接',
    'preferences' => "更改密码",

    'toolsbar__switch_user?' => "您确定要使用另一用户帐户登录吗？",
    '__aps_left' => '可用的安装',
    'aps__license_key' => '许可证密钥',
    'aps__download_code' => '许可证下载和激活码',
    'aps__license_key_hint' => '使用激活码从授权服务器进行检索',
    'aps__database_not_available' => '不可用，请检查域名或客户限制',
    'aps__yes' => '是',
    'aps__no' => '否',
    '__click_to_enlarge' => '点击放大',
    'site_apps__back_to_list' => '返回列表',
    'sapp__pkg_info_installation_requirements' => '安装要求',
    '__close_window' => '关闭',

    //SAPP END

    'skin_info__already_default' => '已将此外观设置为默认外观。',

    //move this to other file after splitting drweb to module
    'drweb:virus_filter_full_name' => 'Plesk Premium Antivirus',
    'drweb:properties_page_title' => '针对 %1 的 Plesk Premium Antivirus 设置',
    'drweb:properties_legend' => '设置',
    'drweb:status' => '检查病毒邮件',

    // sb integration
    'sitebuilder_wizard' => 'Presence Builder 向导',
    'dom_site_builder' => '点击打开 Presence Builder 向导。',
    'sb_plesk_admin_url' => 'Presence Builder 服务器URL。确保此地址在 DNS 中正确解析。',
    'sb_plesk_admin_login' => '服务器管理员登录 Presence Builder 所用的用户名',
    'sb_plesk_admin_password' => '管理员密码',
    'sb_sitebuilder_preferences' => 'Presence Builder 管理员凭据',
    'sb__server' => 'Presence Builder 系统管理员偏好设置',
    'sb__sitebuilder_support' => 'Presence Builder 支持',
    'sb_keep_sb_user' => '在 Presence Builder 中保留相应用户帐户',
    'sb_create_sb_user' => '在 Presence Builder 中创建相应的用户帐户',
    'sb__build_site_using_sitebuilder' => "使用 Presence Builder 创建网站",
    'sb_no_current_sb_server_set' => '尚未配置 Presence Builder 连接: 您需要在 DNS 区域模板中添加指向 Presence Builder 服务器的记录。',
    'sb_unable_update_sb_server_sb_return_message' => "无法从 Presence Builder 系统检索信息:\n%1",
    'sb_unable_connect_sb_wrong_con_params' => "无法连接 Presence Builder : 用户名或密码错误。",
    'sb_init_sb_manager' => "初始化 Presence Builder 管理器: %1",
    'sb_err_couldnt_connect_sb' => "连接 Presence Builder 系统失败。",
    'sb_err_client_dont_have_sbuser' => "此客户在 Presence Builder 中没有用户帐户。",
    'sb_err_sitebuilder_not_configured' => "未配置 Presence Builder 。",
    'sb_err_you_dont_have_sbaccount' => "在 Presence Builder 中给您授权时失败。",
    'sb_error_critical_during_operation' => "Presence Builder 中出现下列错误:\n%1",
    'sb_err_sso_is_not_enabled' => "在 Plesk 中并未启用单点登录支持。",

    'warning__super_zone_exist' => "已创建区域%1，但此区域名是另一区域%2(该区域属于另一用户%3)的子区域名。有这种可能，但请确认您已选择正确的用户帐户。",
    'error__super_zone_exist' => "无法创建DNS区域，因它的主区域属于另一用户。",

    'locales__files_not_exits' => '无法更改语言: 系统中没有指定的界面语言包。',
    'locales__unavailable' => '无法更改语言: 指定的界面语言包不可用。',

    // DB BU

    'pb__dbbackup_list' => '数据库备份文件',
    // server
    'dbbackup__server_backup_settings' => '备份',
    'dbbackup__network_temp_dir' => '临时网络目录',
    'dbbackup__network_user' => '用户名',
    'dbbackup__network_pass' => '密码',
    // domain
    'dbbackup__add_database_legend' => '恢复备份的数据库',
    'dbbackup__add_database_restore' => '从备份文件恢复数据库',
    'dbbackup__add_database_file' => '数据库备份文件',
    'dbbackup__add_database_user' => '默认用户名',
    'dbbackup__add_database_pass' => '默认用户密码',
    'dbbackup__add_database_pass2' => '默认用户密码确认',

    'bt_dbbackup_now' => '备份',

    'bt_repair' => '修理',

    'dbbackup__mssql_dump_upload_not_allowed' => '主机提供商禁止上传 SQL 服务器数据库转存。',

    // APS categories

    'cf_invalid_password' => '密码不可以超过16个字符',
    'cf_invalid_description_length' => '描述不可以超过256个符号',
    'ip_addr__ip_used_by_external_mail_server' => 'IP地址%1已被外部邮件服务器使用',

    // 8.4.1

    '__ftp_login_is_invalid' => 'FTP帐户用户名或密码无效。请指定正确的FTP用户凭据。',

    // 8.6

    'dns__dns_serial_update_limit_warning' => '已达到序列号更改限制。今日不可以再进行任何DNS区域更改。',
    'dns__zone_apply_changes' => '尚未保存对DNS记录所做的更改。下方高亮显示这些更改。单击更新将这些更改应用到DNS区域，或单击恢复放弃更改。',
    'dns__update_dns_zone' => '单击保存对DNS记录所做的更改。',
    'dns__revert_dns_zone' => '单击取消对DNS记录所做的更改。',
    'bt_revert' => '还原',
    'dns__dns_zone_has_beed_updated' => '已保存对DNS记录所做的更改。',
    'dns__dns_zone_has_beed_reverted' => '已取消对DNS记录所做的更改。',
    'db__nondefault_server_not_allowed' => '不允许使用非默认的数据库服务器',


    //// UI POINTER CAPTIONS START HERE
    ////
    // *** The strings below have been generated automatically from @@CAPTION directives.

    'ui__client__description' => '客户%1的帐户和域名。',
    'ui__client__disabled-warning' => '客户%1的帐户已挂起。',
    'ui__client__none-available' => '未配置客户帐户。',
    'ui__client__short-title' => '%1',
    'ui__client__title' => '客户%1',
    'ui__client_self__description' => '我的域名列表。',
    'ui__client_self__short-title' => '我的域名',
    'ui__client_self__title' => '我的域名',


    'site_apps__non_removable' => '无法删除的项目',
    'site_apps__non_removable_items' => '无法删除下列web应用程序:',

    'ui__client/custom-buttons/custom-button__none-available' => '尚无自定义按钮。',
    'ui__client/custom-buttons/custom-button__none-available__1' => '在客户 %1 的客户面板中没有自定义按钮。',

    'ui__client/custom-buttons/custom-button/delete__description' => '删除按钮%1。',
    'ui__client/custom-buttons/custom-button/delete__short-title' => '移除',
    'ui__client/custom-buttons/custom-button/delete__title' => '删除按钮%1',
    'ui__client/custom-buttons/custom-button/delete_multi__description' => '从客户的客户面板移除自定义按钮',
    'ui__client/custom-buttons/custom-button/delete_multi__short-title' => '移除',
    'ui__client/custom-buttons/custom-button/delete_multi__title' => '删除自定义按钮',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard-title' => '删除按钮',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => '选择要删除其自定义按钮的客户，并单击“下一步 >>”。',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__3_multi' => '选择您要删除的按钮，并单击“下一步 >>”。',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__4_multi' => '通过选中屏幕上的复选框确认删除该按钮，并单击“完成”。',
    'ui__client/custom-buttons/custom-button/delete_unknown__description' => '从客户的客户面板移除自定义按钮。',
    'ui__client/custom-buttons/custom-button/delete_unknown__short-title' => '移除',
    'ui__client/custom-buttons/custom-button/delete_unknown__title' => '删除自定义按钮',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard-title' => '删除自定义按钮',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => '选择要删除其自定义按钮的客户，并单击“下一步 >>”。',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => '选择要删除的自定义按钮，并单击“下一步 >>”。',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__4' => '通过选中屏幕上的复选框来确认删除自定义按钮，并单击“完成”。',

    'ui__client/custom-buttons/custom-button/properties__description' => '编辑客户级按钮%1的属性。',
    'ui__client/custom-buttons/custom-button/properties__short-title' => '设置',
    'ui__client/custom-buttons/custom-button/properties__title' => '修改客户按钮%1',
    'ui__client/custom-buttons/custom-button/properties_new__wizard-title' => '添加自定义按钮',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__1_unknown' => '请选定您想要在其客户面板中创建自定义按钮的的客户并点击下一步 >>。',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__4_new' => '单击“完成”创建按钮。',
    'ui__client/custom-buttons/custom-button/properties_unknown__description' => '请在客户的客户面板中更改按钮权限。',
    'ui__client/custom-buttons/custom-button/properties_unknown__short-title' => '属性',
    'ui__client/custom-buttons/custom-button/properties_unknown__title' => '请在客户的客户面板中更改按钮权限',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard-title' => '更改自定义按钮属性',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => '选择您要修改其自定义按钮的客户，并单击“下一步 >>”。',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => '选择要修改的自定义按钮，并单击“下一步 >>”。',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__4' => '完成编辑按钮属性之后，请单击“完成”应用更改并退出向导。',

    'ui__client/custom-buttons/custom-button/toggle_private__description' => '使得按钮%1对您的客户不可用。',
    'ui__client/custom-buttons/custom-button/toggle_private__short-title' => '对您的客户不可用',
    'ui__client/custom-buttons/custom-button/toggle_private__title' => '使得按钮%1对您的客户不可用',
    'ui__client/custom-buttons/custom-button/toggle_public__description' => '让按钮%1对客户的用户可见。',
    'ui__client/custom-buttons/custom-button/toggle_public__short-title' => '对您的客户可用',
    'ui__client/custom-buttons/custom-button/toggle_public__title' => '让按钮%1对客户的用户可见',
    'ui__client/custom-buttons/custom-button/toggle_unknown__description' => '使得自定义按钮对您的客户可用/不可用。',
    'ui__client/custom-buttons/custom-button/toggle_unknown__short-title' => '对您的客户可用/不可用',
    'ui__client/custom-buttons/custom-button/toggle_unknown__title' => '使得自定义按钮对您的客户可用/不可用',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard-title' => '使得自定义按钮对您的客户可用/不可用。',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => '选择可以使用其自定义按钮的客户，并单击“下一步>>”。',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => '选择您要使其对您的客户可用或不可用的自定义按钮，并单击“下一步 >>”。',

    'ui__client/domain__description' => '管理域名%1。',
    'ui__client/domain__disabled-warning' => '域名%1已挂起。',
    'ui__client/domain__none-available' => '您尚无任何域名。',
    'ui__client/domain__none-available__1' => '帐户%1尚无任何域名。',
    'ui__client/domain__none-available__2' => '帐户%1尚无任何域名。',
    'ui__client/domain__short-title' => '%1',
    'ui__client/domain__title' => '域名 %1',
    'ui__client/domain_self__description' => '管理域名。',
    'ui__client/domain_self__disabled-warning' => '您的域名已挂起。',
    'ui__client/domain_self__quick-search' => '我的域名',
    'ui__client/domain_self__short-title' => '我的域名',
    'ui__client/domain_self__title' => '我的域名',

    'ui__client/domain/custom-buttons/custom-button__none-available' => '客户的客户面板中没有放置自定义按钮。',
    'ui__client/domain/custom-buttons/custom-button__none-available__1' => '客户 %1 在客户面板中没有放置自定义按钮。',
    'ui__client/domain/custom-buttons/custom-button__none-available__2' => '域名%1没有自定义按钮',
    'ui__client/domain/custom-buttons/custom-button/delete__description' => '删除自定义按钮%1。',
    'ui__client/domain/custom-buttons/custom-button/delete__short-title' => '移除',
    'ui__client/domain/custom-buttons/custom-button/delete__title' => '删除自定义按钮%1',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__description' => '删除自定义按钮。',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__short-title' => '移除',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__title' => '删除自定义按钮',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard-title' => '删除自定义按钮',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => '选择要从其域名管理员面板删除按钮的客户，并单击“下一步 >>”。',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__2_unknown' => '选择要从其管理员面板删除按钮的域名，并单击“下一步 >>”。',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__4_multi' => '选择您要删除的按钮，并单击“下一步 >>”。',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__5_multi' => '通过选中相应复选框确认删除按钮，单击“完成”以删除该按钮并退出向导。',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__description' => '删除级自定义按钮。',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__short-title' => '移除',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__title' => '删除自定义按钮',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard-title' => '删除自定义按钮',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => '选择要从其域名管理员面板删除自定义按钮的客户，并单击“下一步 >>”。',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => '选择要从其管理员面板删除按钮的域名，并单击“下一步 >>”。',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__4_unknown' => '选择要删除的自定义按钮，并单击“下一步 >>”。',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__5' => '通过选中复选框确认删除自定义按钮，单击“完成”删除该按钮，并退出向导。',

    'ui__client/domain/custom-buttons/custom-button/properties__title' => "更改自定义按钮%1的属性",
    'ui__client/domain/custom-buttons/custom-button/properties__short-title' => "属性",
    'ui__client/domain/custom-buttons/custom-button/properties__description' => "请在客户面板中更改自定义按钮 %1 的权限。",

    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard-title' => '添加按钮',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__1_unknown' => '请选定您想要在其客户面板中放置按钮的的客户并点击下一步 >>。',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__2_unknown' => '选择要为其控制面板修改按钮的域名，并单击“下一步 >>”。',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__5_new' => '单击“完成”以创建按钮并退出向导。',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__description' => "请在客户面板中更改按钮权限。",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__short-title' => '属性',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__title' => '请在客户面板中更改按钮权限',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard-title' => '更改按钮属性',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__4_unknown' => "选择要修改其设置的自定义按钮，并单击“下一步 >>”。",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__5' => '更改按钮属性之后，单击“完成”应用更改并退出向导。',

    'ui__client/domain/custom-buttons/custom-button/toggle_private__description' => '使得按钮%1在此域名中对邮件用户不可用。',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__short-title' => '对邮件用户不可用',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__title' => '使得按钮%1在此域名中对邮件用户不可用。',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__description' => '使得按钮%1在此域名中对邮件用户不可用。',

    'ui__client/domain/custom-buttons/custom-button/toggle_public__short-title' => '该域名下的邮件用户可对其进行访问',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__title' => '使得自定义按钮%1对该域名下的邮件用户可见',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__description' => '使得自定义按钮对其他用户可用或不可用。',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__short-title' => '对其他用户可用/不可用',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__title' => '使得自定义按钮对邮件用户可用/不可用',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard-title' => '使得自定义按钮对其他用户可用/不可用',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => '选择存放该按钮的域名，并单击“下一步 >>”。',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__4_unknown' => '选择要使其对其他用户可用或不可用的按钮，并单击“下一步 >>”。',

    'ui__client/domain/delete__description' => '删除域名%1。',
    'ui__client/domain/delete__short-title' => '移除',
    'ui__client/domain/delete__title' => '删除域名%1',
    'ui__client/domain/delete_multi__description' => '删除域名。',

    'ui__client/domain/delete_multi__short-title' => '移除',
    'ui__client/domain/delete_multi__title' => '删除域名',
    'ui__client/domain/delete_multi__wizard-title' => '删除域名',
    'ui__client/domain/delete_multi__wizard__2_multi' => '选择您要删除的域名并单击“下一步 >>”。',
    'ui__client/domain/delete_multi__wizard__3_multi' => '通过选中复选框确认移除域名，单击“完成”以完成移除并退出向导。',
    'ui__client/domain/delete_unknown__description' => '删除域名。',
    'ui__client/domain/delete_unknown__short-title' => '移除',
    'ui__client/domain/delete_unknown__title' => '删除域名',
    'ui__client/domain/delete_unknown__wizard-title' => '删除域名',
    'ui__client/domain/delete_unknown__wizard__2_unknown' => '选择要删除的域名，并单击“下一步 >>”。',
    'ui__client/domain/delete_unknown__wizard__3' => '通过选中复选框以确认删除域名，单击“完成”彻底删除并退出向导。',

    'ui__client/domain/hosting__none-available' => '无配置主机的域名。创建域名并配置主机才可以访问此功能。',
    'ui__client/domain/hosting__none-available__1' => '此用户帐户没有配置主机的域名。在所需域名上配置主机才可以访问此功能。',
    'ui__client/domain/hosting__none-available__2' => '尚未在域名%1上配置主机。在域名%1上配置主机才可以访问此功能。',

    'ui__client/domain/hosting/file-manager_unknown__wizard-title' => '管理您的文件和目录',
    'ui__client/domain/hosting/file-manager_unknown__wizard__2_unknown' => '选择要使用的其文件的域名。',
    'ui__client/domain/hosting/file-manager_unknown__wizard__3/properties_phosting' => '尚未在域名上配置主机。请设置物理主机，并单击“下一步 >>”转到文件管理器。',
    'ui__client/domain/hosting/file-manager_unknown__wizard__3/properties_self-phosting' => '尚未在您的域名上配置主机。请设置物理主机，并单击“下一步>>”转到文件管理器。',
    'ui__client/domain/hosting/file-manager_unknown__wizard__4' => '使用文件和目录后，单击“完成”退出向导。',
    'ui__client/domain/hosting/file-manager_unknown__wizard__4_self' => '使用文件和目录后，单击“完成”退出向导。',

    'ui__client/domain/hosting/performance_readonly-unknown__wizard-title' => '查看主机性能设置',

    'ui__client/domain/hosting/performance_unknown__wizard-title' => '调整主机性能设置',
    'ui__client/domain/hosting/performance_unknown__wizard__2_readonly-unknown' => '选择您希望查看其主机性能设置的域名，并单击“下一步 >>”。',
    'ui__client/domain/hosting/performance_unknown__wizard__2_unknown' => '选择您希望配置其主机性能设置的域名，并单击“下一步 >>”。',
    'ui__client/domain/hosting/performance_unknown__wizard__4' => '调整域名上的虚拟主机性能设置，并单击“完成”。',
    'ui__client/domain/hosting/performance_unknown__wizard__4_readonly' => '查看域名的主机性能设置之后，请单击“完成”。',
    'ui__client/domain/hosting/performance_unknown__wizard__4_readonly-self' => '查看域名的主机性能设置之后，请单击“完成”。',
    'ui__client/domain/hosting/performance_unknown__wizard__4_readonly-unknown' => '查看域名的主机性能设置之后，请单击“完成”。',
    'ui__client/domain/hosting/performance_unknown__wizard__4_self' => '查看域名的主机性能设置之后，请单击“完成”。',
    'ui__client/domain/hosting/performance_unknown__wizard__4_unknown' => '查看域名的主机性能设置之后，请单击“完成”。',

    'ui__client/domain/hosting/application#list_header__clients_number__title' => "客户",
    'ui__client/domain/hosting/application#list_header__description__title' => "描述",
    'ui__client/domain/hosting/application#list_header__items_number__title' => "项目",
    'ui__client/domain/hosting/application#list_header__name__title' => "名称",
    'ui__client/domain/hosting/application#list_header__release__title' => "发行版本",
    'ui__client/domain/hosting/application#list_header__sort_by_clients_number__title' => "按客户进行排序",
    'ui__client/domain/hosting/application#list_header__sort_by_description__title' => "按描述进行排序",
    'ui__client/domain/hosting/application#list_header__sort_by_items_number__title' => "按项目进行排序",
    'ui__client/domain/hosting/application#list_header__sort_by_name__title' => "按名称进行排序",
    'ui__client/domain/hosting/application#list_header__sort_by_release__title' => "按版本进行排序",
    'ui__client/domain/hosting/application#list_header__sort_by_version__title' => "按版本进行排序",
    'ui__client/domain/hosting/application#list_header__title' => "Web应用程序",
    'ui__client/domain/hosting/application#list_header__version__title' => "版本",

    'rpt_reseller_section_general' => '常用',
    'rpt_reseller_section_domains' => '域名',
    'rpt_reseller_section_clients' => '客户',
    'statistics__cl_active_domains' => "活动域名",
    'rpt_reseller_cl_domains' => "域名",
    'rpt_reseller_cl_subdomains' => "子域名",
    'by__cl_domains' => "客户域名",
    'dom_ctrl__cl_mboxes' => "邮箱",
    'rpt_reseller_cl_redirects' => "转发器",
    'rpt_reseller_cl_mail_groups' => "邮件群组",
    'rpt_reseller_cl_mail_resps' => "自动回复",
    'rpt_reseller_cl_mail_lists' => "邮件列表",
    'rpt_reseller_cl_web_users' => "网站用户",
    'rpt_reseller_cl_data_bases' => "数据库",

    'statistics__active_clients' => '有活动订阅的客户',
    'statistics__clients_active_domains' => '活动域名',
    'statistics__clients_doms' => '域名',
    'statistics__cl_doms' => '域名',
    '__clients_subdomains' => '子域名',
    '__clients_domains' => '域名',
    'dom_ctrl__clients_mboxes' => '邮箱',
    'dom_ctrl__clients_redir' => '转发器',
    'dom_ctrl__clients_mg' => '邮件群组',
    'dom_ctrl__clients_resp' => '自动回复',
    'dom_ctrl__clients_maillists' => '邮件列表',
    'dom_ctrl__clients_wu' => '网站用户',
    'dom_ctrl__clients_db' => '数据库',

    'dom_ctrl__cl_redir' => '转发器', // to resolve!
    'dom_ctrl__cl_mg' => '邮件群组', // to resolve!
    'dom_ctrl__cl_resp' => '自动回复', // to resolve!
    'dom_ctrl__cl_maillists' => '邮件列表', // to resolve!
    'dom_ctrl__cl_wu' => '网站用户', // to resolve!
    'dom_ctrl__cl_db' => '数据库', // to resolve!

    'rpt_cl_section_clients' => '客户',

    'rpt_admin_section_general' => '常用',
    'rpt_admin_section_resellers' => '代理商',
    'rpt_admin_section_clients' => '客户',
    'rpt_admin_section_personal_clients' => '个人客户',
    'rpt_admin_section_domains' => '域名',
    'rpt_admin_section_personal_domains' => '个人域名',

    'rpt_reseller_section_personal_domains' => '个人域名',

    'ui__client/domain/toggle_unknown__wizard__2_unknown' => '选择要挂起或激活的域名。',
    'ui__client/domain/toggle_unknown__wizard-title' => '挂起或激活域名',

    'ui__client/ip-pool__description' => '分配或重新分配 IP 地址和 SSL/TLS 证书给客户 %1。',
    'ui__client/ip-pool__short-title' => 'IP池',
    'ui__client/ip-pool__title' => '客户%1的IP池',
    'ui__client/ip-pool_self__description' => '查看您的IP池。',
    'ui__client/ip-pool_self__short-title' => 'IP池',
    'ui__client/ip-pool_self__title' => '我的IP池',
    'ui__client/ip-pool/properties__description' => '设置客户%1的IP池。',

    'ui__client/ip-pool/properties__short-title' => 'IP池',
    'ui__client/ip-pool/properties__title' => '设置客户%1的IP池',
    'ui__client/ip-pool/properties_self__description' => '查看您的IP池。',

    'ui__client/ip-pool/properties_self__short-title' => '我的IP池',
    'ui__client/ip-pool/properties_self__title' => '我的IP池',
    'ui__client/ip-pool/properties_unknown__description' => '分配或重新分配客户的 IP 地址和 SSL/TLS 证书。',
    'ui__client/ip-pool/properties_unknown__short-title' => 'IP池',
    'ui__client/ip-pool/properties_unknown__title' => '设置客户IP池',
    'ui__client/ip-pool/properties_unknown__wizard-title' => '设置客户IP池',
    'ui__client/ip-pool/properties_unknown__wizard__1_unknown' => '选择要配置其IP池的客户。',
    'ui__client/ip-pool/properties_unknown__wizard__3' => '编辑客户IP池之后，单击“完成”应用更改，并退出向导。',


    'ui__client/limits_readonly-unknown__description' => '查看客户的资源限制。',
    'ui__client/limits_readonly-unknown__short-title' => '资源限制',
    'ui__client/limits_readonly-unknown__title' => '查看客户帐户的资源限制。',
    'ui__client/limits_readonly-unknown__wizard-title' => '查看或更改客户的资源限制',

    'ui__client/limits_unknown__wizard-title' => '查看或更改客户的资源限制',
    'ui__client/limits_unknown__wizard__1_readonly-unknown' => '请选择所需客户。',
    'ui__client/limits_unknown__wizard__1_unknown' => '请选择所需客户。',
    'ui__client/limits_unknown__wizard__2' => '要应用更改，单击“完成”。',
    'ui__client/limits_unknown__wizard__2_readonly' => '要退出向导，请单击“完成”。',
    'ui__client/limits_unknown__wizard__2_readonly-self' => '要退出向导，请单击“完成”。',
    'ui__client/limits_unknown__wizard__2_readonly-self-reseller' => '要退出向导，请单击“完成”。',

    'ui__client/permissions_unknown__wizard-title' => '查看或更改客户权限',
    'ui__client/permissions_unknown__wizard__1/properties_self' => '查看您的权限后，请单击“完成”应用更改，并退出向导。',
    'ui__client/permissions_unknown__wizard__1_unknown' => '选择要查看或编辑其权限的客户。',
    'ui__client/permissions_unknown__wizard__2' => '更改客户权限后，请单击“完成”应用更改，并退出向导。',

    'ui__client/preferences_unknown__wizard-title' => '编辑客户偏好设置',
    'ui__client/preferences_unknown__wizard__1_unknown' => '选择要管理其会话和界面偏好设置的客户。',
    'ui__client/preferences_unknown__wizard__2' => '更改客户偏好设置后，单击“完成”。',
    'ui__client/preferences_unknown__wizard__2_self' => '更改偏好设置后，单击“完成”。',

    'ui__custom-buttons/custom-button__none-available' => '您尚无自定义按钮。',
    'ui__custom-buttons/custom-button/delete__description' => '删除自定义按钮%1。',
    'ui__custom-buttons/custom-button/delete__short-title' => '移除',
    'ui__custom-buttons/custom-button/delete__title' => '删除自定义按钮%1',
    'ui__custom-buttons/custom-button/delete_multi__description' => '删除自定义按钮。',

    'ui__custom-buttons/custom-button/delete_multi__short-title' => '移除',
    'ui__custom-buttons/custom-button/delete_multi__title' => '删除自定义按钮',
    'ui__custom-buttons/custom-button/delete_multi__wizard-title' => '删除自定义按钮',
    'ui__custom-buttons/custom-button/delete_multi__wizard__2_multi' => '选择您要删除的自定义按钮。',
    'ui__custom-buttons/custom-button/delete_multi__wizard__3_multi' => '通过选中复选框确认删除按钮，单击“完成”并退出向导。',
    'ui__custom-buttons/custom-button/delete_unknown__description' => '删除自定义按钮。',
    'ui__custom-buttons/custom-button/delete_unknown__short-title' => '移除',
    'ui__custom-buttons/custom-button/delete_unknown__title' => '删除自定义按钮',
    'ui__custom-buttons/custom-button/delete_unknown__wizard-title' => '删除自定义按钮',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => '选择要删除的自定义按钮。',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__3' => '通过选中复选框来确认按钮的删除，单击“完成”退出向导。',
    'ui__custom-buttons/custom-button/properties__description' => '更改按钮%1的属性。',

    'ui__custom-buttons/custom-button/properties__short-title' => '属性',
    'ui__custom-buttons/custom-button/properties__title' => '更改按钮%1的属性',

    'ui__custom-buttons/custom-button/properties_new__wizard-title' => '创建按钮',
    'ui__custom-buttons/custom-button/properties_new__wizard__3_new' => '单击“完成”创建按钮。',
    'ui__custom-buttons/custom-button/properties_unknown__description' => '更改自定义按钮的属性。',
    'ui__custom-buttons/custom-button/properties_unknown__short-title' => '属性',
    'ui__custom-buttons/custom-button/properties_unknown__title' => '更改自定义按钮属性',
    'ui__custom-buttons/custom-button/properties_unknown__wizard-title' => '更改自定义按钮属性',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__2_unknown' => '选择要更改其属性的自定义按钮。',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__3' => '要应用更改，单击“完成”。',
    'ui__custom-buttons/custom-button/toggle_private__description' => '使自定义按钮%1对其他用户不可用。',

    'ui__custom-buttons/custom-button/toggle_private__short-title' => '对其他用户不可用',
    'ui__custom-buttons/custom-button/toggle_private__title' => '使自定义按钮%1对其他用户不可用',
    'ui__custom-buttons/custom-button/toggle_public__description' => '使自定义按钮%1对其他用户可用。',

    'ui__custom-buttons/custom-button/toggle_public__short-title' => '对其他用户可用',
    'ui__custom-buttons/custom-button/toggle_public__title' => '使自定义按钮%1对其他用户可用',
    'ui__custom-buttons/custom-button/toggle_unknown__description' => '使自定义按钮对其他用户可用或不可用。',
    'ui__custom-buttons/custom-button/toggle_unknown__short-title' => '对其他用户可用或不可用。',
    'ui__custom-buttons/custom-button/toggle_unknown__title' => '使自定义按钮对其他用户可用或不可用。',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard-title' => '使自定义按钮对其他用户可用或不可用。',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => '选择您要将其设置为对其他用户可用或不可用的自定义按钮，并单击“下一步 >>”。',

    'ui__longtasks#list_header__name__title' => "名称",
    'ui__longtasks#list_header__owner__title' => "所有者",
    'ui__longtasks#list_header__start_time__title' => "创建时间",
    'ui__longtasks#list_header__status__title' => "状态",
    'ui__longtasks#list_header__title' => "任务",
    'ui__longtasks#list_header__finish_time__title' => "完成时间",
    'ui__longtasks#task_list_legend__title' => "任务",
    'ui__longtasks#tools_legend__title' => "工具",
    'ui__longtasks__description' => "管理后台任务",
    'ui__longtasks__short-title' => "后台任务",
    'ui__longtasks__title' => "后台任务",
    'ui__longtasks/longtask/properties#current_operation__title' => "当前操作：",
    'ui__longtasks/longtask/properties#finish_time__title' => "预计完成时间：",
    'ui__longtasks/longtask/properties#general_legend__title' => "常用",
    'ui__longtasks/longtask/properties#owner__title' => "任务开始时间：",
    'ui__longtasks/longtask/properties#progress__title' => "整体进程：",
    'ui__longtasks/longtask/properties#start_time__title' => "任务开始：",
    'ui__longtasks/longtask/properties#status_legend__title' => "任务状态",
    'ui__longtasks/longtask/properties__description' => "后台任务状态和信息",

    'ui__longtasks/properties__description' => "后台任务设置",
    'ui__longtasks/properties__short-title' => "设置",
    'ui__longtasks/properties__title' => "后台任务",

    // updated
    'ui__mass-mail/template#list_header__title' => '群发邮件模板',
    'ui__mass-mail/template#list_header__name__title' => '模板名称',
    'ui__mass-mail/template#list_header__from_email__title' => '发件人',
    'ui__mass-mail/template#list_header__to__title' => '收件人',
    'ui__mass-mail/template#list_header__subject__title' => '主题',
    'ui__mass-mail/template#list_header__cdate__title' => '创建日',
    'ui__mass-mail/template#list_header__send__title' => '发送',

    'ui__mass-mail/template/properties__short-title' => '%1',
    'ui__mass-mail/template/properties__title' => '编辑群发邮件模板',
    'ui__mass-mail/template/properties__description' => '编辑此群发邮件模板',

    'ui__mass-mail/template/properties_unknown-new__short-title' => '添加群发邮件模板',
    'ui__mass-mail/template/properties_unknown-new__title' => '添加群发邮件模板',
    'ui__mass-mail/template/properties_unknown-new__description' => '添加群发邮件信息模板。',
    'ui__mass-mail/send__short-title' => '群发邮件',
    'ui__mass-mail/send__title' => '群发邮件',
    'ui__mass-mail/send__description' => '向所选收件人群发邮件。',
    'ui__mass-mail/template/delete_multi__short-title' => '删除群发邮件模板',
    'ui__mass-mail/template/delete_multi__title' => '删除群发邮件模板:',
    'ui__mass-mail/template/delete_multi__description' => '删除所选的群发邮件模板。',
    'ui__mass-mail/template/delete_multi__done' => '所选邮件模板已移除。',
    'ui__mass-mail/template/properties__invalid_values' => '指定的值无效',


    // old
    'ui__mass-mail#body_text__description' => '您可以在信息文本（但不是标头）中使用<name> 变量。这将会被客户或代理商的联系人名称代替。',
    'ui__mass-mail#body_text__title' => '信息文本',
    'ui__mass-mail#compose_legend__title' => '信息',
    'ui__mass-mail#from_email_text__title' => '发自（电子邮件地址）',
    'ui__mass-mail#list_header__cdate__title' => '已创建',
    'ui__mass-mail#list_header__from_email__title' => '来自',
    'ui__mass-mail#list_header__name__title' => '名称',
    'ui__mass-mail#list_header__send__title' => '创建邮件',
    'ui__mass-mail#list_header__subject__title' => '主题',
    'ui__mass-mail#list_header__title' => '群发邮件模板',
    'ui__mass-mail#list_header__to__title' => '至',
    'ui__mass-mail#list_legend__title' => '群发邮件模板',
    'ui__mass-mail#load_template_text__title' => '加载',
    'ui__mass-mail#name_text__title' => '模板名称',
    'ui__mass-mail#option_mode_all__title' => '所有',
    'ui__mass-mail#option_mode_except__title' => '除所选外的全部项',
    'ui__mass-mail#option_mode_select__title' => '仅所选项',
    'ui__mass-mail#option_select_template__title' => '---选择模板---',
    'ui__mass-mail#picker_legend__title' => '电子邮件模板',
    'ui__mass-mail#picker_title__title' => '选择一个模板',
    'ui__mass-mail#save_as_legend__title' => '另存为模板',
    'ui__mass-mail#save_as_text__title' => '保存组合信息到一个新的模板（名为',
    'ui__mass-mail#subject_text__title' => '主题',
    'ui__mass-mail#template_legend__title' => '模板',
    'ui__mass-mail#to_admin_text__title' => 'Plesk 管理员',
    'ui__mass-mail#to_clients_text__title' => '客户',
    'ui__mass-mail#to_domains_text__title' => '域名管理员',
    'ui__mass-mail#to_select_text__title' => '选择地址',
    'ui__mass-mail#to_show_hide_text__title' => '显示/隐藏所选项',
    'ui__mass-mail#to_text__title' => '至',
    'ui__mass-mail#tools_legend__title' => '工具',
    'ui__mass-mail__already_exists' => '名为%1的模板已存在',
    'ui__mass-mail__none-available' => '您尚无邮件模板',

    'ui__mass-mail/delete__description' => '删除群发电子邮件模板 %1',

    'ui__mass-mail/delete__empty_selection' => '请选择您要删除的模板',
    'ui__mass-mail/delete__short-title' => '删除%1',
    'ui__mass-mail/delete__title' => '删除群发电子邮件模板 %1',
    'ui__mass-mail/delete_multi__description' => '删除群发电子邮件模板。',

    'ui__mass-mail/delete_multi__short-title' => '移除',
    'ui__mass-mail/delete_multi__title' => '删除群发电子邮件模板',
    'ui__mass-mail/delete_multi__wizard-title' => '删除群发电子邮件模板',
    'ui__mass-mail/delete_multi__wizard__1_multi' => '选择您要删除的群发电子邮件模板。',
    'ui__mass-mail/delete_multi__wizard__2_multi' => '通过选中复选框确认删除模板，单击“完成”并退出向导。',
    'ui__mass-mail/delete_unknown__description' => '删除群发电子邮件模板。',
    'ui__mass-mail/delete_unknown__short-title' => '移除',
    'ui__mass-mail/delete_unknown__title' => '删除群发电子邮件模板',
    'ui__mass-mail/delete_unknown__wizard-title' => '删除群发电子邮件模板。',
    'ui__mass-mail/delete_unknown__wizard__1_unknown' => '选择您要删除的群发电子邮件模板。',
    'ui__mass-mail/delete_unknown__wizard__2' => '通过选中复选框确认删除模板，单击“完成”并退出向导。',

    'ui__mass-mail/properties__description' => '编辑电子邮件模板 %1。',

    'ui__mass-mail/properties__invalid_values' => '指定的值不正确',
    'ui__mass-mail/properties__short-title' => '%1',
    'ui__mass-mail/properties__title' => '编辑电子邮件模板%1。',

    'ui__mass-mail/properties_new__wizard-title' => '创建群发电子邮件模板',
    'ui__mass-mail/properties_unknown-new__description' => '创建电子邮件模板。',
    'ui__mass-mail/properties_unknown-new__short-title' => '添加电子邮件模板',
    'ui__mass-mail/properties_unknown-new__title' => '创建电子邮件模板',
    'ui__mass-mail/properties_unknown__wizard-title' => '编辑群发电子邮件模板',
    'ui__mass-mail/properties_unknown__wizard__1_unknown' => '选择您要修改的模板并单击“下一步 >>”。',
    'ui__mass-mail/properties_unknown__wizard__2' => '编辑模板完成后，请单击“完成”应用更改并退出向导。',

    'ui__mass-mail/send__invalid_values' => '您指定了不正确的值',

    'ui__mass-mail/send_new__wizard-title' => '创建邮件模板并发送电子邮件',
    'ui__mass-mail/send_unknown-new__description' => '向所选收件人发送电子邮件',

    'ui__mass-mail/send_unknown-new__short-title' => '群发邮件',
    'ui__mass-mail/send_unknown-new__title' => '群发邮件',
    'ui__mass-mail/send_unknown__description' => '向所选收件人发送电子邮件',

    'ui__mass-mail/send_unknown__short-title' => '群发邮件',
    'ui__mass-mail/send_unknown__title' => '群发邮件',
    'ui__mass-mail/send_unknown__wizard-title' => '群发邮件',
    'ui__mass-mail/send_unknown__wizard__1_unknown' => '选择您所需的模板并单击“下一步 >>”。',
    'ui__mass-mail/send_unknown__wizard__2' => '编辑模板属性完成后，请单击“完成”发送邮件并退出向导。',

    'ui__mass-email/delete__description' => '删除所选的群发邮件模板。',

    'ui__mass-email/delete__empty_selection' => "请选择您要删除的模板。",
    'ui__mass-email/delete__short-title' => "删除%1",
    'ui__mass-email/delete__title' => "删除群发电子邮件模板 %1",
    'ui__mass-email/delete_multi__description' => "删除群发电子邮件模板。",

    'ui__mass-email/delete_multi__short-title' => "移除",
    'ui__mass-email/delete_multi__title' => "删除群发电子邮件模板",
    'ui__mass-email/delete_multi__wizard__mass-mail/delete_multi' => "通过选中复选框确认删除模板，单击“完成”并退出向导。",
    'ui__mass-email/delete_multi__wizard__mass-mail_multi' => "选择您要删除的群发电子邮件模板。",
    'ui__mass-email/delete_multi__wizard-title' => "删除群发电子邮件模板",
    'ui__mass-email/delete_unknown__description' => "删除群发电子邮件模板。",
    'ui__mass-email/delete_unknown__short-title' => "移除",
    'ui__mass-email/delete_unknown__title' => "删除群发电子邮件模板",
    'ui__mass-email/delete_unknown__wizard__mass-mail/delete' => "通过选中复选框确认删除模板，单击“完成”并退出向导。",
    'ui__mass-email/delete_unknown__wizard__mass-mail_unknown' => "选择您要删除的群发电子邮件模板。",
    'ui__mass-email/delete_unknown__wizard-title' => "删除群发电子邮件模板。",
    'ui__mass-email/send__description' => "向所选收件人发送电子邮件",
    'ui__mass-email/send__short-title' => "群发电子邮件",
    'ui__mass-email/send__title' => "群发邮件",
    'ui__mass-email/send_main__description' => "向所选收件人发送电子邮件",

    'ui__mass-email/send_main__short-title' => "群发电子邮件",
    'ui__mass-email/send_main__title' => "群发电子邮件",
    'ui__mass-email/send_selectresellers__title' => '所选代理商',
    'ui__mass-email/send_selectresellers__short-title' => '代理商',
    'ui__mass-email/send_selectresellers__description' => '所选代理商帐户',

    'ui__mass-email/send_selectclients__description' => "选择客户帐户",

    'ui__mass-email/send_selectclients__short-title' => "客户",
    'ui__mass-email/send_selectclients__title' => "选择客户",
    'ui__mass-email/send_selectdomainusers__description' => "选择域名管理员帐户",

    'ui__mass-email/send_selectdomainusers__short-title' => "域名管理员",
    'ui__mass-email/send_selectdomainusers__title' => "选择域名管理员",
    'ui__mass-email/template/properties_main__description' => "创建群发电子邮件模板",
    'ui__mass-email/template/properties_main__short-title' => "编辑模板",
    'ui__mass-email/template/properties_main__title' => "编辑群发电子邮件模板",
    'ui__mass-email/template/properties_new-main__description' => "为群发电子邮件创建模板。",
    'ui__mass-email/template/properties_new-main__short-title' => "创建群发电子邮件模板",
    'ui__mass-email/template/properties_new-main__title' => "创建群发电子邮件模板",
    'ui__mass-email/template/properties_new-selectclients__description' => "选择要基于该模板接收群发电子邮件的客户",
    'ui__mass-email/template/properties_new-selectclients__title' => "选择要基于该模板接收群发电子邮件的客户",
    'ui__mass-email/template/properties_new-selectdomainusers__description' => "选择要基于此模板接收群发电子邮件的域名管理员。",
    'ui__mass-email/template/properties_new-selectdomainusers__title' => "选择要基于此模板接收群发电子邮件的域名管理员。",
    'ui__mass-email/template/properties_selectclients__title' => "选择要基于该模板接收群发电子邮件的客户",
    'ui__mass-email/template/properties_selectdomainusers__title' => "选择要基于此模板接收群发电子邮件的域名管理员。",

    'ui__mass-email/template/properties_unknown-new__description' => "创建群发邮件信息模板",
    'ui__mass-email/template/properties_unknown-new__short-title' => "创建模板",
    'ui__mass-email/template/properties_unknown-new__title' => "创建群发电子邮件模板",
    'ui__news/dismiss__description' => '点击关闭新闻框架。Plesk 将不会显示该框架除非已更新新闻文章。',

    'ui__news/dismiss__title' => '关闭新闻',

    'ui__server__description' => '服务器管理。',
    'ui__server__short-title' => '管理您的服务器',
    'ui__server__title' => '服务器管理',


    // UNUSED SINCE 9.2



    // END OF UNUSED SINCE 9.2

    'ui__server/ip-address__disabled-warning' => 'IP地址%1不可用。',
    'ui__server/ip-address__none-available' => '无IP地址。',
    'ui__server/ip-addresses/ip-address__title' => "IP 地址",
    'ui__server/ip-address/client/properties_new__description' => "分配IP地址%1给代理商。",
    'ui__server/ip-address/client/properties_new__short-title' => '分配',
    'ui__server/ip-address/client/properties_new__title' => "分配IP地址%1给代理商",
    'ui__server/ip-address/client__none-available' => '无用户帐户',
    'ui__server/ip-address/client_unknown__quick_search' => '用户',
    'ui__server/ip-address/client_unknown__wizard-title' => '使用此IP地址的用户列表。',
    'ui__server/ip-address/client_unknown__wizard__3_unknown' => '请选择IP地址。',
    'ui__server/ip-address/client/delete__description' => '移除用户的IP地址。',
    'ui__server/ip-address/client/delete__short-title' => '移除',
    'ui__server/ip-address/client/delete__title' => '移除用户的IP地址。',
    'ui__server/ip-address/client/delete_multi__description' => "从代理商池移除IP地址。",

    'ui__server/ip-address/client/delete_multi__short-title' => '移除',
    'ui__server/ip-address/client/delete_multi__title' => '移除代理商的IP地址。',
    'ui__server/ip-address/client/delete_multi__wizard-title' => "已从用户池中移除此IP地址。",
    'ui__server/ip-address/client/delete_multi__wizard__3_unknown' => '选择要移除的用户IP地址，并单击“下一步 >>”。',
    'ui__server/ip-address/client/delete_multi__wizard__3_multi' => '选择要移除的用户IP地址，并单击“下一步 >>”。',
    'ui__server/ip-address/client/delete_multi__wizard__4_multi' => '勾选复选框确认移除用户的IP地址，并单击“完成”退出向导。',
    'ui__server/ip-address/client/delete_unknown__description' => '移除代理商的IP地址。',
    'ui__server/ip-address/client/delete_unknown__short-title' => '移除',
    'ui__server/ip-address/client/delete_unknown__title' => '移除代理商的IP地址',
    'ui__server/ip-address/client/delete_unknown__wizard-title' => '移除用户的IP地址',
    'ui__server/ip-address/client/delete_unknown__wizard__3_unknown' => '选择要移除的用户IP地址，并单击“下一步 >>”。',
    'ui__server/ip-address/client/delete_unknown__wizard__4_unknown' => '选择要移除的用户IP地址，并单击“下一步>>”。',
    'ui__server/ip-address/client/delete_unknown__wizard__5' => '勾选复选框确认移除用户的IP地址，并单击“完成”退出向导。',

    'ui__server/ip-address/domain__description' => "IP地址%1上的所有域名。",
    'ui__server/ip-address/domain__short-title' => "域名",
    'ui__server/ip-address/domain__title' => "IP地址%1上的域名",
    'ui__server/ip-address/domain_unknown__description' => "IP地址上的所有域名。",
    'ui__server/ip-address/domain_unknown__short-title' => "域名",
    'ui__server/ip-address/domain_unknown__title' => "IP地址上的域名",
    'ui__server/ip-address/domain_unknown__wizard__3_unknown' => "选择所需的IP地址，并单击“下一步>>”。",

    'ui__server/ip-address/properties__description' => '更改IP地址%1的属性。',
    'ui__server/ip-address/properties__short-title' => '属性',
    'ui__server/ip-address/properties__title' => '更改IP地址%1的属性',

    'ui__server/ip-address/properties_new__wizard-title' => '添加 IP 地址',
    'ui__server/ip-address/properties_new__wizard__4_new' => '更改IP地址属性后，单击“完成”应用更改。',
    'ui__server/ip-address/properties_unknown__description' => '更改IP地址属性',
    'ui__server/ip-address/properties_unknown__short-title' => '属性',
    'ui__server/ip-address/properties_unknown__title' => '更改IP地址属性',
    'ui__server/ip-address/properties_unknown__wizard-title' => '更改IP地址属性',
    'ui__server/ip-address/properties_unknown__wizard__3_unknown' => '选择待更改其属性的IP地址。',
    'ui__server/ip-address/properties_unknown__wizard__4' => '更改IP地址属性后，单击“完成”应用更改。',

    'ui__server/spam-filter/black-list__description' => '为服务器级的垃圾邮件过滤器设置黑名单。',
    'ui__server/spam-filter/black-list__short-title' => '黑名单',
    'ui__server/spam-filter/black-list__title' => '服务器级的垃圾邮件过滤器的黑名单',

    'ui__server/spam-filter/black-list/address__addresses_available' => '将仅添加 %1 首个唯一电子邮件地址。',
    'ui__server/spam-filter/black-list/address__description' => '垃圾邮件过滤器黑名单地址。',

    'ui__server/spam-filter/black-list/address__empty_content' => '列表中尚无电子邮件地址。',
    'ui__server/spam-filter/black-list/address__file_size' => '上传的文件为空。',
    'ui__server/spam-filter/black-list/address__invalid_addresses' => '下列电子邮件地址无效：%1。',
    'ui__server/spam-filter/black-list/address__none-available' => '垃圾邮件过滤器黑名单中尚无地址。',
    'ui__server/spam-filter/black-list/address__short-title' => '地址',
    'ui__server/spam-filter/black-list/address__title' => '黑名单地址%1',
    'ui__server/spam-filter/black-list/address_unknown__description' => '将地址添加到黑名单中。',
    'ui__server/spam-filter/black-list/address_unknown__short-title' => '添加地址',
    'ui__server/spam-filter/black-list/address_unknown__title' => '将地址添加到黑名单中。',

    'ui__server/spam-filter/black-list/address/delete__description' => '从服务器级黑名单中删除地址%1。',

    'ui__server/spam-filter/black-list/address/delete__short-title' => '移除',
    'ui__server/spam-filter/black-list/address/delete__title' => '从服务器级黑名单中删除地址%1',
    'ui__server/spam-filter/black-list/address/delete_multi__description' => '从服务器级黑名单中删除地址。',

    'ui__server/spam-filter/black-list/address/delete_multi__short-title' => '移除',
    'ui__server/spam-filter/black-list/address/delete_multi__title' => '从服务器级黑名单中删除地址',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard-title' => '服务器级垃圾邮件过滤器黑名单地址删除',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__4_multi' => '选择您要删除其地址的垃圾邮件过滤器，并单击“下一步 >>”',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__5_multi' => '通过选中复选框删除垃圾邮件过滤器地址，单击“完成”彻底删除并退出向导。',
    'ui__server/spam-filter/black-list/address/delete_unknown__description' => '从服务器级黑名单中删除地址。',
    'ui__server/spam-filter/black-list/address/delete_unknown__short-title' => '移除',
    'ui__server/spam-filter/black-list/address/delete_unknown__title' => '从服务器级黑名单中删除地址',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard-title' => '服务器级垃圾邮件过滤器黑名单地址删除',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__4_unknown' => '选择您要删除其地址的垃圾邮件过滤器，并单击“下一步 >>”',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__5' => '通过选中复选框确认删除垃圾邮件过滤器地址，单击“完成”彻底删除并退出向导。',

    'ui__server/spam-filter/black-list/address/properties__addresses_available' => '将仅添加 %1 首个唯一电子邮件地址。',
    'ui__server/spam-filter/black-list/address/properties__empty_content' => '列表中尚无电子邮件地址。',
    'ui__server/spam-filter/black-list/address/properties__file_size' => '无法上传文件。上传的文件的最大容量为 %1。',
    'ui__server/spam-filter/black-list/address/properties__invalid_addresses' => '下列电子邮件地址无效：%1。',

    'ui__server/spam-filter/black-list/address/properties_unknown-new__description' => '将地址添加到黑名单中。',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__short-title' => '添加地址',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__title' => '将地址添加到黑名单中。',

    'ui__server/spam-filter/properties__description' => '设置服务器级的垃圾邮件过滤器。',

    'ui__server/spam-filter/properties__short-title' => '设置',
    'ui__server/spam-filter/properties__title' => '垃圾邮件过滤器设置。',

    'ui__server/spam-filter/toggle_disable__description' => '禁用整个系统的垃圾邮件过滤。',

    'ui__server/spam-filter/toggle_disable__short-title' => '禁用',
    'ui__server/spam-filter/toggle_disable__title' => '禁用垃圾邮件过滤',
    'ui__server/spam-filter/toggle_enable__description' => '启用整个服务器的垃圾邮件过滤。',

    'ui__server/spam-filter/toggle_enable__short-title' => '启用',
    'ui__server/spam-filter/toggle_enable__title' => '启用垃圾邮件过滤',
    'ui__server/spam-filter/toggle_unknown__description' => '启用或禁用整个服务器的垃圾邮件过滤。',
    'ui__server/spam-filter/toggle_unknown__short-title' => '启用或禁用',
    'ui__server/spam-filter/toggle_unknown__title' => '启用或禁用垃圾邮件过滤',
    'ui__server/spam-filter/toggle_unknown__wizard-title' => '启用或禁用垃圾邮件过滤器',

    'ui__server/spam-filter/white-list__description' => '设置服务器级的垃圾邮件过滤器白名单。',
    'ui__server/spam-filter/white-list__short-title' => '白名单',
    'ui__server/spam-filter/white-list__title' => '服务器级的垃圾邮件过滤器白名单',

    'ui__server/spam-filter/white-list/address__addresses_available' => '将仅添加 %1 首个唯一电子邮件地址。',
    'ui__server/spam-filter/white-list/address__description' => '垃圾邮件过滤器的白名单地址。',

    'ui__server/spam-filter/white-list/address__empty_content' => '列表中尚无电子邮件地址。',
    'ui__server/spam-filter/white-list/address__file_size' => '上传的文件为空。',
    'ui__server/spam-filter/white-list/address__invalid_addresses' => '下列电子邮件地址无效：%1。',
    'ui__server/spam-filter/white-list/address__none-available' => '垃圾邮件过滤器服务器级白名单中尚无地址。',
    'ui__server/spam-filter/white-list/address__short-title' => '地址',
    'ui__server/spam-filter/white-list/address__title' => '白名单地址%1',
    'ui__server/spam-filter/white-list/address_unknown__description' => '将地址添加到白名单中。',
    'ui__server/spam-filter/white-list/address_unknown__short-title' => '添加地址',
    'ui__server/spam-filter/white-list/address_unknown__title' => '将地址添加到白名单中。',

    'ui__server/spam-filter/white-list/address/delete__description' => '从服务器级的白名单中删除地址%1。',

    'ui__server/spam-filter/white-list/address/delete__short-title' => '移除',
    'ui__server/spam-filter/white-list/address/delete__title' => '从服务器级的白名单中删除地址%1',
    'ui__server/spam-filter/white-list/address/delete_multi__description' => '从服务器级白名单删除地址。',

    'ui__server/spam-filter/white-list/address/delete_multi__short-title' => '移除',
    'ui__server/spam-filter/white-list/address/delete_multi__title' => '从服务器级白名单删除地址',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard-title' => '服务器级垃圾邮件过滤器白名单地址删除',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__4_multi' => '选择您要删除其地址的垃圾邮件过滤器，并单击“下一步 >>”',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__5_multi' => '通过选中复选框删除垃圾邮件过滤器地址，单击“完成”彻底删除并退出向导。',
    'ui__server/spam-filter/white-list/address/delete_unknown__description' => '从服务器级白名单删除地址。',
    'ui__server/spam-filter/white-list/address/delete_unknown__short-title' => '移除',
    'ui__server/spam-filter/white-list/address/delete_unknown__title' => '从服务器级白名单删除地址',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard-title' => '服务器级垃圾邮件过滤器白名单地址删除',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__4_unknown' => '选择您要删除其地址的垃圾邮件过滤器，并单击“下一步 >>”',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__5' => '通过选中复选框确认删除垃圾邮件过滤器地址，单击“完成”彻底删除并退出向导。',

    'ui__server/spam-filter/white-list/address/properties__addresses_available' => '将仅添加 %1 首个唯一电子邮件地址。',
    'ui__server/spam-filter/white-list/address/properties__empty_content' => '列表中尚无电子邮件地址。',
    'ui__server/spam-filter/white-list/address/properties__file_size' => '无法上传文件。上传的文件的最大容量为 %1。',
    'ui__server/spam-filter/white-list/address/properties__invalid_addresses' => '下列电子邮件地址无效：%1。',

    'ui__server/spam-filter/white-list/address/properties_unknown-new__description' => '将地址添加到白名单中。',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__short-title' => '添加地址',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__title' => '将地址添加到白名单中。',

    'ui__server/mail/statistics#apply__description' => "应用过滤器",
    'ui__server/mail/statistics#apply__title' => "应用",
    'ui__server/mail/statistics#custom_from__title' => "发件人",
    'ui__server/mail/statistics#custom_to__title' => "收件人",
    'ui__server/mail/statistics#period_all__title' => "所有",
    'ui__server/mail/statistics#period_custom__title' => "自定义",
    'ui__server/mail/statistics#period_month__title' => "本月",
    'ui__server/mail/statistics#period_prev_month__title' => "上月",
    'ui__server/mail/statistics#period_prev_week__title' => "上周",
    'ui__server/mail/statistics#period_today__title' => "今日",
    'ui__server/mail/statistics#period_week__title' => "本周",
    'ui__server/mail/statistics#period_yesterday__title' => "昨日",
    'ui__server/mail/statistics#show_for_period__title' => "显示时段",
    'ui__server/mail/statistics#tools_legend__title' => "工具",
    'ui__server/mail/statistics__description' => "查看垃圾邮件和病毒统计数据",

    'ui__server/mail/statistics__short-title' => "统计",
    'ui__server/mail/statistics__title' => "邮件设置",
    'ui__server/mail/statistics/spam#statistics_legend__title' => "垃圾邮件统计",
    'ui__server/mail/statistics/spam#tools_legend__title' => "工具",
    'ui__server/mail/statistics/spam__description' => "查看垃圾邮件统计",

    'ui__server/mail/statistics/spam__short-title' => "垃圾邮件统计",
    'ui__server/mail/statistics/spam__title' => "垃圾邮件统计",
    'ui__server/mail/statistics/spam/recipients#list_header__name__title' => "邮件名",
    'ui__server/mail/statistics/spam/recipients#list_header__ratio__title' => "全部%",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_name__title' => "按邮件帐户进行排序",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_ratio__title' => "按全部%进行排序",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_val__title' => "按所接收的垃圾邮件进行排序",
    'ui__server/mail/statistics/spam/recipients#list_header__title' => "邮件帐户的最大数量",
    'ui__server/mail/statistics/spam/recipients#list_header__val__title' => "所接收的垃圾邮件",
    'ui__server/mail/statistics/spam/recipients__description' => "收件人",

    'ui__server/mail/statistics/spam/recipients__short-title' => "收件人",
    'ui__server/mail/statistics/spam/recipients__title' => "收件人",
    'ui__server/mail/statistics/spam/summary#clean__title' => "未感染病毒",
    'ui__server/mail/statistics/spam/summary#infected__title' => "已感染病毒",
    'ui__server/mail/statistics/spam/summary#list_header__name__title' => "状态",
    'ui__server/mail/statistics/spam/summary#list_header__ratio__title' => "全部%",
    'ui__server/mail/statistics/spam/summary#list_header__val__title' => "计数",
    'ui__server/mail/statistics/spam/summary#protected__title' => "受保护",
    'ui__server/mail/statistics/spam/summary#skipped__title' => "未检查",
    'ui__server/mail/statistics/spam/summary__description' => "汇总",

    'ui__server/mail/statistics/spam/summary__short-title' => "汇总",
    'ui__server/mail/statistics/spam/summary__title' => "汇总",
    'ui__server/mail/statistics/virus#statistics_legend__title' => "病毒统计数据",
    'ui__server/mail/statistics/virus#tools_legend__title' => "工具",
    'ui__server/mail/statistics/virus__description' => "查看病毒统计数据",

    'ui__server/mail/statistics/virus__short-title' => "病毒统计数据",
    'ui__server/mail/statistics/virus__title' => "病毒统计数据",
    'ui__server/mail/statistics/virus/recipients#list_header__name__title' => "邮件帐户",
    'ui__server/mail/statistics/virus/recipients#list_header__ratio__title' => "全部%",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_name__title' => "按邮件名进行排序",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_ratio__title' => "按全部%进行排序",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_val__title' => "按所收病毒进行排序",
    'ui__server/mail/statistics/virus/recipients#list_header__title' => "邮件帐户",
    'ui__server/mail/statistics/virus/recipients#list_header__val__title' => "所收病毒",
    'ui__server/mail/statistics/virus/recipients__description' => "收件人",

    'ui__server/mail/statistics/virus/recipients__short-title' => "收件人",
    'ui__server/mail/statistics/virus/recipients__title' => "收件人",
    'ui__server/mail/statistics/virus/summary#clean__title' => "未感染病毒",
    'ui__server/mail/statistics/virus/summary#infected__title' => "已感染病毒",
    'ui__server/mail/statistics/virus/summary#list_header__name__title' => "状态",
    'ui__server/mail/statistics/virus/summary#list_header__ratio__title' => "全部%",
    'ui__server/mail/statistics/virus/summary#list_header__val__title' => "计数",
    'ui__server/mail/statistics/virus/summary#protected__title' => "受保护",
    'ui__server/mail/statistics/virus/summary#skipped__title' => "未检查",
    'ui__server/mail/statistics/virus/summary__description' => "汇总",

    'ui__server/mail/statistics/virus/summary__short-title' => "汇总",
    'ui__server/mail/statistics/virus/summary__title' => "汇总",
    'ui__server/mail/statistics/virus/viruses#list_header__name__title' => "名称",
    'ui__server/mail/statistics/virus/viruses#list_header__ratio__title' => "全部%",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_name__title' => "按名称进行排序",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_ratio__title' => "按全部%进行排序",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_val__title' => "按感染对象进行排序",
    'ui__server/mail/statistics/virus/viruses#list_header__title' => "病毒",
    'ui__server/mail/statistics/virus/viruses#list_header__val__title' => "感染对象",
    'ui__server/mail/statistics/virus/viruses__description' => "病毒",

    'ui__server/mail/statistics/virus/viruses__short-title' => "病毒",
    'ui__server/mail/statistics/virus/viruses__title' => "病毒",

    'ui__support#param_company__title' => "公司",
    'ui__support#param_email__title' => "电子邮箱",
    'ui__support#param_firstname__title' => "名字",
    'ui__support#param_keynumber__title' => "产品许可证号",
    'ui__support#param_operatingsystem__title' => "操作系统",
    'ui__support#param_phone__title' => "电话",
    'ui__support#param_psabuild__title' => "Plesk 版本号",
    'ui__support#param_psainsttype__title' => "Plesk 安装类型",
    'ui__support#param_psaversion__title' => "Plesk 版本",

    // *** The strings above have been generated automatically from @@CAPTION directives.

    ////
    //// UI POINTER CAPTIONS END HERE


    // RESELLERS

    // Resellers
    'ui__reseller#tools__title' => "工具",

    'ui__reseller/traffic-history_unknown__short-title' => "按代理商查看流量",
    'ui__reseller/traffic-history_unknown__title' => "按代理商查看流量",
    'ui__reseller/traffic-history_unknown__description' => "查看代理商帐户所用流量。",
    'ui__reseller#list__title' => "代理商",
    'accounts_list__name__filter_title' => "名称",
    'accounts_list__resource__filter_title' => "资源使用量",
    'resellers_list__filter_resource_usage_any' => "任何",
    'resellers_list__filter_resource_usage_overuse' => "超额使用",
    'resellers_list__filter_resource_usage_normal' => "在限制内",
    'accounts_list__status__filter_title' => "状态",
    'resellers_list__filter_status_any' => "任何",
    'resellers_list__filter_status_blocked' => "挂起",
    'resellers_list__filter_status_active' => "活动",
    'resellers_list__filter_clients__filter_title' => "显示",
    'resellers_list__filter_clients_on' => "代理商及其客户",
    'resellers_list__filter_clients_off' => "仅限代理商",
    '__disk_usage' => "所用磁盘空间",
    'ui__reseller/traffic_unknown__short-title' => "按代理商查看流量",
    'ui__reseller/traffic_unknown__title' => "按代理商查看流量",
    'ui__reseller/traffic#list__title' => "查看代理商所用流量",
    'ui__reseller/traffic_unknown__description' => "查看流量使用报告。",

    // Resellers > Traffic by resellers
    '__traffic_by_reseller' => "查看代理商所用流量",

    '__reseller_name' => "代理商名称",
    '__reseller' => "代理商",
    'resellertrafficlist_header' => "按代理商查看流量",
    '__reseller_personal' => "代理商域名所用的流量",
    'ui__reseller/traffic-history__short-title' => "按代理商查看流量",
    'ui__reseller/traffic-history__title' => "按代理商查看流量",
    'ui__reseller/traffic-history__description' => "查看流量使用报告。",

    // Resellers > Create Reseller Account
    'ui__reseller__short-title' => "%1",

    // Resellers > Reseller preferences

    // Resellers > Reseller Account Templates

    // Resellers > Reseller Account Templates > Create Reseller Account Template
    'limits__oversell_text' => "允许超额销售",
    'limits__reseller_oversell_description' => "过度销售允许代理商售出多于实际分配的资源。如果允许过度销售，则代理商可以使用实际的资源量，而不是开始时所分配的资源量。",
    'limits__overuse_block_text' => "超额使用策略",
    'limits__overuse_block_true_text' => "不允许超额使用",
    'limits__reseller_overuse_block_true_description' => "阻止超额使用资源。真正使用的资源则无法超出所分配的资源",
    'limits__overuse_block_false_text' => "允许超额使用",
    'limits__reseller_overuse_block_false_description' => "请不要阻止超额使用资源，允许代理商使用多于初始分配的资源。真正使用的资源可以超出初始分配的资源。",
    'limits__reseller_overuse_notify_text' => "达到资源限制时，通知代理商",
    'reseller_perm__manage_sh_access_disabled' => "代理商无法允许或禁止shell访问",
    'reseller_perm__manage_sh_access_chrooted' => "代理商仅可以允许访问更改根文件系统的环境",
    'reseller_perm__manage_sh_access_any' => "代理商可以允许任何类型的shell访问",
    'template__reseller_num_excl_ips' => "分配独立 IP 地址给代理商",

    // Reseller's Home page
    'ui__reseller#tools2__title' => "帐户",
    'ui__reseller#info__title' => "信息",
    'ui__reseller#clientsTab__title' => "客户",
    'ui__reseller#domainsTab__title' => "域名",
    'ui__reseller__title' => "管理%1代理商帐户",
    'domains__reseller_info' => "%1 个客户，%2 个域名，已使用 %3 磁盘空间，已迁移 %4 数据。",
    'domains__reseller_info_hiding_traffic' => "%1 个客户，%2 个域名，已使用 %3 磁盘空间。",
    'ui__reseller__description' => "管理%1代理商帐户。",

    'ui__reseller/limits_unknown__wizard-title' => '查看或更改代理商资源限制',
    'ui__reseller/limits_unknown__wizard__1_unknown' => '选择所需的代理商。',
    'ui__reseller/limits_unknown__wizard__2' => '要应用更改，单击“完成”。',

    'ui__client/report_reseller__short-title' => "报告",
    'ui__client/report_reseller__title' => "查看帐户报告",
    'ui__client/report_reseller__description' => "查看代理商帐户报告。",
    'ui__client/ip-pool_reseller__short-title' => "IP池",
    'ui__client/ip-pool_reseller__description' => "分配 IP 地址和 SSL/TLS 证书给代理商帐户。",

    //'ui__client/preferences_reseller__short-title' => "Settings",
    //'ui__client/preferences_reseller__description' => "Set Plesk session settings.",

    'ui__reseller/preferences_unknown__wizard__2_self' => "指定帐户设置，并单击“完成”。",

    //'ui__client/permissions_reseller__short-title' => "Permissions",
    //'ui__client/permissions_reseller__description' => "View or change permissions for the reseller's account.",

    'ui__reseller/permissions_unknown__wizard-title' => '查看或更改代理商的权限',
    'ui__reseller/permissions_unknown__wizard__1_unknown' => '选择要查看或更改其权限的代理商。',
    //'ui__reseller/permissions_unknown__wizard__1/properties_self' => 'When done with viewing your permissions, click Finish to to apply the changes and exit the wizard.',
    'ui__reseller/permissions_unknown__wizard__2' => '更改代理商权限后，单击“完成”应用更改，并退出向导。',

    // Customers > create customer account

    '__resellers_list' => '代理商',
    'picker_reseller__title' => '选择代理商',

    // Resellers > reseller name > customer name
    'ui__client#tools1__title' => "工具",
    'ui__client#tools2__title' => "帐户",
    'ui__client#info__title' => "信息",
    'ui__client#clientslist__title' => "客户",
    'ui__client#domainslist__title' => "域名",

    // Reseller's session in the Customer Panel - Home page

    'feature__aps_categories__reseller' => "所有web应用程序现按类别进行排序，这会便于正确选择待安装的应用程序。",
    'feature__domainkeys__reseller' => "您可以使用 DKIM 电子邮件发件人验证机制来减少垃圾邮件和钓鱼邮件的数量。",

    '__reseller_form' => "代理商表单",

    // Reseller's session in the control panel - Home page > Manage Customer Settings
    'ui__client/preferences_unknown__wizard__reseller' => "选择要更改其设置的客户帐户。",

    // Reseller's session in the control panel - Home page > Suspend/Activate Customer Account

    // Reseller's session in the control panel - Home page > Change Customer Limits
    'ui__client/limits_unknown__wizard__1' => "若要更改资源使用限制，单击“资源限制”。",

    // Reseller's session in the control panel - Home page > Change Customer Permissions
    'ui__client/permissions_unknown__wizard__1' => "要更改客户可在 Plesk 中执行操作的权限，请点击 权限。",

    // Reseller's session in the control panel - Home page > Create Customer Template
    'template__shared_text' => "让其他用户可以使用此模板",
    'template__shared_description' => "若允许客户使用此模板，请选择此选项。",

    // CLIENT (updated for reseller feature):

    // Customers
    'ui__client#tools__title' => '工具',

    'ui__client/traffic-history_unknown__short-title' => '客户所用流量',
    'ui__client/traffic-history_unknown__title' => '客户所用流量',
    'ui__client/traffic-history_unknown__description' => '查看所有客户的流量使用报告',
    'ui__client/traffic-history__short-title' => '客户所用流量',
    'ui__client/traffic-history__title' => '客户所用流量',
    'ui__client/traffic-history__description' => '查看所有客户的流量使用报告',

    'ui__client/traffic#list__title' => '客户所用流量',
    'ui__reseller/client/traffic#list__title' => '客户所用流量',

    'clients_list__filter_type__filter_title' => '显示',
    'clients_list__filter_type_any' => '客户与代理商',
    'clients_list__filter_type_clients' => '仅限客户',
    'clients_list__filter_type_resellers' => '仅限代理商',
    'ui__client/domain_unknown-new__short-title' => "创建域名",

    // Customers > View traffic by customers
    '__personal' => "代理商域名所用流量",
    'PersonalTrafficList_header_of_client__' => "查看帐户的流量使用报告",

    // DOMAINS

    // Domain > Domain Admin Permissions

    'domain_perm__manage_sh_access_disabled' => "域名管理员无法允许或禁止shell访问",
    'domain_perm__manage_sh_access_chrooted' => "域名管理员仅可以允许访问改变根文件系统的环境",
    'domain_perm__manage_sh_access_any' => "域名管理员可以运行任何类型的shell访问",

    // APS Catalog
    'bt_add_to_vault' => "添加到百宝箱",
    'bt_hide_updates' => "隐藏可用更新",
    'bt_show_updates' => "显示可用更新",

    '__site_apps__applications' => "应用程序",
    //search elements
    // Application; Vendor; Packager; Certification level;

    '__site_apps__apps_selected_to_add_to_vault' => "选择待添加到百宝箱中的应用程序",
    'site_apps__application_selected' => "所选项",
    'site_apps__currently_in_vault' => "其他版本已在百宝箱中:",
    'site_apps__new_versions' => "新版本:",
    'site_apps__patches' => "补丁:",
    'site_apps__applications_have_been_scheduled_for_adding_to_application_vault' => "计划添加到百宝箱中的应用程序数量: %1",
    'site_apps__applications_downloading_now' => "即将下载下列应用程序: %1", // temporary workaround string, to be removed later

    'site_apps__package_already_exist_in_vault' => "已在百宝箱中",

    // Server > Action Log
    'bt_skin_edit' => "编辑外观描述",
    'domains__you_want_change_the_status_of_the_reseller??' => "您确定要更改此代理商帐户的状态吗？",
    'limits__oversell_legend' => "过度销售",
    'limitsManager__limit_available_error' => "无法分配所需资源量(%%quantity%% %%limitName%%)。仅有%%available%% %%limitName%%可用。",
    'limitsManager__limit_reserved_error' => "无法设置要求的资源使用限制(%%quantity%% %%limitName%%)，因新值小于为客户保留的或自用的资源量(%%reserved%% %%limitName%%)。",
    'limitsManager__limit_used_error' => "无法设置要求的资源使用限制(%%quantity%% %%limitName%%)，因新值小于您的客户和网站实际使用的资源量(%%used%% %%limitName%%)。",

    'ui__client/domain/traffic#list__title' => "服务所用流量",

    'ui__client/domain/traffic_unknown-reseller__short-title' => "查看流量使用报告",
    'ui__client/domain/traffic_unknown-reseller__title' => "查看流量使用报告",

    'ui__client/domain_new__short-title' => "创建域名",

    'ui__client_reseller__description' => "管理代理商帐户%1。",
    'ui__client_reseller__short-title' => "%1",
    'ui__client_reseller__title' => "管理代理商帐户",

    '__owner_name' => "所有者名称",
    'domains_list__resource__filter_title' => "资源使用量",

    // APS CATALOG
    'site_apps__application_catalog_preferences' => "APS应用程序目录",
    'site_apps__applications_have_updates' => "下列应用程序的更新版本可用: \n%1 \n若要查看更新，请确定搜索区可用，并勾选<b>仅显示更新</b>复选框，并搜索所需的应用程序。",
    'site_apps__progress_adding_to_vault' => "添加到百宝箱:",
    'site_apps__progress_done_message' => "进度:",
    'site_apps__progress_applications_left' => "共 %2 个应用程序剩下 %1 个",
    'site_apps__download_item_long_task_title' => "下载APS应用程序(%1)",
    'site_apps__download_transaction_long_task_title' => "从APS目录下载APS应用程序",
    'site_apps__last_check_for_updates' => "上次检查更新: %1",
    'site_apps__all_sucessfully_added_to_app_vault' => "成功添加所有计划的应用程序到应用百宝箱中",
    'site_apps__number_of_apps_sucessfully_added_to_app_vault' => "成功添加%1计划应用程序到应用百宝箱。",
    'site_apps__no_search_results' => '未找到应用程序。请尝试不同的搜索请求，或按类别浏览应用程序。',
    'site_apps__search_results_title' => '搜索结果',
    '__site_apps__search_by_application' => '应用程序名称',
    '__site_apps__search_by_vendor' => '厂商',
    '__site_apps__search_by_vendor__all' => '所有代理商',
    '__site_apps__search_by_packager' => '打包者',
    '__site_apps__search_by_certification_level' => '证书级别',
    '__site_apps__search_by_cert__any' => '任何',
    '__site_apps__search_by_cert__silver_and_higher' => '银牌或更高',
    '__site_apps__search_by_cert__gold_and_higher' => '金牌或更高',
    '__retry' => '重试',
    'site_apps__application_packager_site' => '打包者',
    'site_apps__add_to_pool_message' => "会自动将标记为\"对所有用户可用\"的应用程序分配给所有享有无限安装实例的代理商和客户。仅可以按个人手动分配受限应用程序及其指定数量的安装给所有代理商和客户。",
    'site_apps__make_available_for_all' => "让所选应用程序对所有用户可用",

    'site_apps__broadcast_app_text' => "会自动将标记为\"对所有用户可用\"的应用程序分配给所有享有无限安装实例的代理商和客户。仅可以按个人手动分配受限应用程序及其指定数量的安装给所有代理商和客户。",
    'site_apps__broadcast_app_name' => '让应用程序对所有用户可用',

    // User Application Pool per application
    'site_apps__available_clients' => '可用用户',
    'site_apps__no_more_clients_to_add_to_pool' => '无可供分配此应用程序的用户帐户',

    // Installed application instances
    'site_apps__installations' => '安装',

    // Hosting setup redesign
    '__domain_name_and_ip_address' => "域名和IP地址",
    '__assign_ip_address' => "分配IP地址",
    '__switch_on_service' => "启用服务",
    '__hosting_configuration' => "主机配置",
    '__vrt_hst' => "网站主机",
    '__vrt_hst_hint' => "在此服务器上托管网站。",
    '__fwd' => "转发",
    '__web_hosting_settings' => "主机设置",
    '__fwd_hint' => "重定向访客到另一网站。",
    '__none_hint' => "此刻不要托管网站。",
    '__login_hint' => "此用户名用于通过FTP访问您的网站",
    '__password_hint' => "此密码用于通过FTP访问您的网站",
    '__advanced_hosting_setup' => "配置网站高级主机设置",
    '__domain_creation_successful' => "已创建域名。",
    'bt_hosting_settings' => "主机设置",
    '__change_hosting_type' => "更改域名%1的主机类型",
    '__hosting_type_change_warning' => "更改主机类型为转发时，则会从服务器上删除所有相关的文件、目录和邮件。请确定本地保存有网站和邮件副本。",
    '__current_hosting_type' => "当前主机类型",
    '__new_hosting_type' => "新主机类型",
    '__fwd_settings' => "转发设置",
    '__fwd_settings_legend' => "转发设置",
    '__fwd_destination_url' => "目标 URL",
    '__fwd_type' => "转发类型",
    '__fwd_type_standart' => "不隐藏目标地址的 URL 转发(地址跳转)",
    '__fwd_type_standart_hint' => "重定向访客到另一网站，显示目标地址，向访客公开重定向动作。",
    '__fwd_type_frame' => "帧转发",
    '__fwd_type_frame_hint' => "重定向网站访客到另一网站，但不向访客显示目标地址，让访客不知道被重定向。",
    '__hosting_type_template_warning' => "所选主机类型不同于模板中指定的类型。如果继续，则会忽略所选模板中的主机设置。您确定要设置所选的主机类型吗？",

    '__no_resellers_selected' => "您必须选择至少一个代理商帐户。",

    'ui__client/logo_unknown__wizard-title' => '设置徽标',
    'ui__client/logo_unknown__wizard__1_unknown' => '请选择您要更改其徽标属性的客户。',
    'ui__client/logo_unknown__wizard__2' => '单击“完成”应用更改。',
    'ui__client/logo_unknown__wizard__2_self' => '单击“完成”应用更改。',

    'ui__client/ipaddress/properties_new__short-title' => "添加 IP 地址",
    'ui__client/ipaddress/properties_new__title' => '添加 IP 地址',
    'ui__client/ipaddress/properties_new__description' => "添加IP地址。",
    'ui__client/ipaddress/properties_unknown-new__short-title' => "添加 IP 地址",
    'ui__client/ipaddress/properties_unknown-new__title' => "添加 IP 地址",
    'ui__client/ipaddress/properties_unknown-new__description' => "添加 IP 地址",
    'ui__client/ipaddress/delete_multi__short-title' => "删除IP地址",
    'ui__client/ipaddress/delete_multi__description' => "删除IP地址。",
    'ippool_Manager__no_available_ips' => "此IP池中没有空闲的IP地址。",
    'ippool_Manager__ip_shared' => "共享",
    'ippool_Manager__ip_exclusive' => "独立",
    'ui__client/ipaddress/properties__title' => "管理IP地址",
    'ui__client/ipaddress/properties__description' => "查看或更改IP地址属性。",
    'ui__client/ipaddress_unknown-new__title' => "添加 IP 地址",
    'ui__client/ipaddress_unknown-new__short-title' => "添加 IP 地址",
    'ui__client/ipaddress_unknown-new__description' => "添加 IP 地址。",

    'ui__mass-mail#to_resellers_text__title' => "代理商",
    'ui__mass-mail#to_domainusers_text__title' => "域名管理员",
    'ui__mass-email#tools_legend__title' => "工具",
    'ui__mass-email#list_legend__title' => '群发邮件模板',
    'ui__mass-email#template_legend__title' => "模板",
    'ui__mass-email#from_email_text__title' => "来自",
    'ui__mass-email#to_text__title' => '至',
    'ui__mass-email#to_resellers_text__title' => "代理商",
    'ui__mass-email#to_clients_text__title' => "客户",
    'ui__mass-email#to_domainusers_text__title' => "域名管理员",
    'ui__mass-email#to_admin_text__title' => "Plesk 管理员",
    'ui__mass-email#option_mode_all__title' => "所有",
    'ui__mass-email#option_mode_select__title' => "仅所选项",
    'ui__mass-email#option_mode_except__title' => "除所选外的全部项",
    'ui__mass-email#option_select_template__title' => '---选择模板---',
    'ui__mass-email#subject_text__title' => "主题",
    'ui__mass-email#body_text__title' => "信息文本",
    'ui__mass-email#save_as_legend__title' => "另存为模板",
    'ui__mass-email#save_as_text__title' => "保存组合信息到一个新的模板（名为",
    'ui__reseller/preferences_unknown__wizard-title' => "更改帐户设置",
    'ui__reseller/preferences_unknown__wizard__1_unknown' => "选择要更改其设置的帐户，并单击“下一步”。",
    'ui__reseller/preferences_unknown__wizard__2' => "指定帐户设置，并单击“确定”。",
    'ippoolManager__ip_shared' => "共享",
    'ippoolManager__ip_exclusive' => "独立",

    '__users_list' => "用户",
    '__users' => "用户",
    '__user_name' => "用户名",

    'limit__name_max_dom_aliases' => "域名别名",
    'limit__name_max_subftp_users' => "其它 FTP 帐户",
    'limit__name_max_mssql_db' => "Microsoft SQL Server数据库",
    'limit__name_max_iis_app_pools' => "IIS 应用程序池",
    'limit__name_max_odbc' => "ODBC 连接",
    'total_mboxes_quota_unsupported' => '邮件服务器不支持',
    'limit_soft__disk_space' => '达到磁盘空间即通知',
    'limit_soft__max_traffic' => '达到流量即通知',
    'dsr__of_reseller_title' => "域名所用资源",
    'limitsManager__commit_failed' => "无法更改资源限制。",
    'limitsManager__date_in_past' => "错误的过期日%1。",
    'limitsManager__limit_not_supported' => "无法设置资源类型%1的限制。",
    'limitsManager__limit_oversell_inconsistency' => "因过度销售已停用，无法分配指定的资源量。",
    'limitsManager__limit_overuse_inconsistency' => "资源使用超出定义的限制。",
    'limitsManager__no_resource_available' => "没有剩下此类 (%%limitName%%) 资源。 请求： %%quantity%%; 可用： %%unused%%.",
    'limitsManager__no_total_resource_available' => "没有来自服务提供商的可用 (%%limitName%%) 资源。 请求： %%quantity%%; 可用： %%unused%%.",
    'limitsManager__invalid_expiration_limit' => "过期日必须小于或等于%1。",
    'limitsManager__invalid_disk_space_limit' => "磁盘空间量必须小于或等于%1。",
    'limitsManager__invalid_max_traffic_limit' => "流量必须小于或等于%1。",
    'ippoolManager__ip_has_suballocations' => "因IP地址%%ip%%已分配给用户，无法更改它的类型。IP地址%%ip%%已归为%%reserved%%IP地址，并已分配给用户。",
    'ippoolManager__ip_is_already_in_pool' => "此IP地址已分配给用户。",
    'ippoolManager__ip_is_not_in_pool' => "IP 池中没有 IP 地址 %%ip%%。",
    'ippoolManager__can_not_allocate_ip' => "IP地址%%ip%%仅可归类为%%available%%。",
    'ippoolManager__unable_to_set_default_type' => "此IP地址%%ip%% 无法归类为独立型。",
    'ippoolManager__ip_used_by_hst_or_frw' => "此IP地址%%ip%%已用于主机。",
    'ippoolManager__active_anon_ftp_on_ip' => "已启用IP地址%%ip%%的匿名FTP访问",
    'ippoolManager__no_vacant_ips' => "无空闲的IP地址。",
    'ippoolManager__no_available_ips' => "无可用的IP地址。",
    'templates__dublicate_name' => "相同名称的模板已经存在。请为该模板选择其它名称。",
    'cl_perm__client_limits_exceeded' => "指定资源限制值超过主机方案允许的值，或这些值小于网站当前所用的资源。",
    'cl_perm__reseller_limits_exceeded' => "指定资源限制值超过主机方案允许的值，或这些值小于用户帐户当前所用的资源。",

    'site_apps__preferences_show_all_versions_title' => "显示从该类别中检索的每个应用程序版本的完整列表",
    'site_apps__preferences_show_all_versions_hint' => "如果选择此选项，则需要在每次打开该类别时花时间检索各个应用程序的版本。如果不选择此选项，则只显示最新版。",
    '__select_user_template' => "基于模板创建用户帐户",
    'ip_already_added_to_all_clients' => "此IP地址已分配给所有用户。",
    'ui__server/ip-address/client/delete#legend__description' => "即将从此系统和用户的IP池中删除下列IP地址:",

    'site_apps__cancelled_apps' => "您已取消增加下列应用程序: %2",

    'sb_url_is_not_resolved' => 'URL 无法解析: 检查您的 DNS 设置。URL %1 必须解析成安装有 Presence Builder 的服务器IP地址。',

    'ip_addr__is_last_on_interface' => '因IP地址%%ip%%是出现在网络接口上的最后一个IP地址，导致无法删除。',
    'ip_addr__used_for_current_session' => '因活动会话正使用IP地址%%ip%%，导致无法删除。',
    'ip_addr__used_for_hosting' => '因主机网站正使用IP地址%%ip%%，导致无法删除。',
    'ip_addr__is_main' => '因IP地址%%ip%%是网络接口的主IP地址，导致无法删除。',
    'ip_addr__ip_used_by_message_submission' => '您不可以删除用于提交邮件的IP地址%%ip%%',

    // RESELLER ACTION LOG

    '__cl_domains' => '客户域名',
    'excl_ip_num' => '独立 IP 地址',

    'sb_err_sitebuilder_not_installed' => '未安装 Presence Builder。',

    '__perm_allow_oversell_can_not_be_revoked' => '不可以撤销此用户的过度销售权，因已分配给该用户超出可用量的资源，变为过度销售模式。',
    'limitsManager__invalid_limit_value' => '指定的%%limit_name%%限制值%%value%%错误',
    'ip_alias__type' => "IP地址类型",
    'ip_alias__in_type' => '分配的IP地址类型',
    'ui__client/ipaddress/delete_multi__title' => '移除IP地址',
    'ui__client/ipaddress/delete#legend__short-title' => '待删除项目',
    'ui__client/ipaddress/delete#legend__description' => "即将从用户IP池删除下列IP地址:",
    'ui__client/ipaddress/delete#nlegend__short-title' => '无法删除的项目',
    'ui__client/ipaddress/delete#nlegend__description' => '无法删除下列IP地址:',
    'ui__server/ip-address/delete#legend__description' => '即将从服务器IP池中删除下列IP地址:',
    'confirmationForm_default_agreement_text' => '确认操作',
    'confirmationForm_default_confirm_message' => '请确认操作。',
    'limit__max_mn' => '邮件帐户的最大数量',

    'limits__client_overuse_description' => '超额使用策略会在资源使用超过初始资源分配量时指令 Plesk 如何进行操作。',
    'limits__client_overuse_block_true_description' => '阻止超额使用资源。真正使用的资源则无法超出所分配的资源',
    'limits__client_overuse_block_false_description' => '不阻止超额使用资源，允许客户使用多于初始分配的资源。真正使用的资源则可以超出初始分配的资源',
    'limits__client_overuse_notify_text' => '达到资源限制时通知客户',

    'limits__domain_overuse_description' => '超额使用策略会在资源使用超过初始资源分配量时指令 Plesk 如何进行操作。',
    'limits__domain_overuse_block_true_description' => '超额使用策略会在资源超额使用时指令 Plesk 如何进行操作。',
    'limits__domain_overuse_block_false_description' => '不阻止超额使用资源，允许域名使用多于初始分配的资源。真正使用的资源可以超出初始分配的资源',
    'limits__domain_overuse_notify_text' => '达到资源限制时，通知域名所有者',


    'cancel_remove' => '单击放弃全部更改并返回上一页。',
    'php_not_installed' => '未安装PHP',

    'dns__dns_rr_delete' => '待删除项目',
    'dns__delete_rr' => '即将从DNS区域删除下列资源记录:',
    'dns__dns_rr_delete_non_removable' => '无法删除的项目',
    'dns__non_delete_rr' => '无法删除下列DNS记录:',
    'dns__dns_rr_delete_confirm_message' => '确认删除DNS记录',

    'site_apps__format_is_unsupported_broadcast_not_set' => '未知的web应用程序格式: web应用程序可能无法安装或使用。',

    '__php_handler_type_desc' => 'PHP运行方式',
    'sfdk_domain_sign__failed' => '尝试在域名上启用通过 DKIM 签名邮件时出现未定义错误。请参考服务器错误日志了解更多信息。',

    // key management ported from cpp to php
    'pkey_notify__subj_update_success_notification' => 'Plesk 密钥更新成功通知',
    'pkey_notify__subj_update_deferral_notification' => 'Plesk 密钥更新延迟通知',
    'pkey_notify__subj_update_error_notification' => 'Plesk 密钥更新错误通知',
    'pkey_notify__update_successful' => '成功更新%1。',
    'pkey_notify__update_failed_no_more_try' => '无法更新%1。您尝试发送的许可证无效。此许可证无法再更新。',
    'pkey_notify__update_failed_try_later' => '无法更新 %1：处理您的密钥时出现一个错误。您可以尝试在 Plesk（工具与设置>许可证信息）中手动索取密钥或让 Plesk 尝试在 24 小时内更新密钥。如果您不想再收到该通知，请从 Plesk 移除该密钥。',

    // spam assassin error messages
    'ui__server/spam-filter/toggle__unable_disable' => '无法禁用服务器级垃圾邮件过滤。',
    'ui__server/spam-filter/toggle__unable_enable' => '无法启用服务器级垃圾邮件过滤',

    // Application vault/ application pool for admin mapping - TEMPORARY

    // report
    'report_auto__recipient_reseller' => '此代理商',
    'report_auto__select_reseller_report_all' => '所有代理商',
    'report_auto__select_reseller_report_client' => '此客户的所有代理商',
    'report_auto__select_reseller_report_current' => '此代理商',
    'report_auto__select_reseller_report_reseller' => '%1',
    'report_auto__select_client_report_reseller' => '此代理商的所有客户',
    'report_auto__select_client_report_client' => '此客户',
    'report_auto__select_client_report_other_reseller' => '%1',
    'report_auto__select_admin_report_all' => '代理商、客户和域名',

    'rpt_reseller_section_full_domains' => '域名',
    'rpt_reseller_dom_subdomains' => '子域名',
    'rpt_reseller_dom_domain_aliases' => '域名别名',
    'rpt_reseller_dom_postboxes' => '邮箱(MBox)',
    'rpt_reseller_dom_redirects' => '转发器',
    'rpt_reseller_dom_mail_groups' => '邮件群组',
    'rpt_reseller_dom_mail_resps' => '自动回复',
    'rpt_reseller_dom_mail_antispam' => '防垃圾邮件',
    'rpt_reseller_dom_mail_antivirus' => '防病毒程序',
    'rpt_reseller_dom_mail_lists' => '邮件列表(MList)',
    'rpt_reseller_dom_web_users' => '网站用户',
    'rpt_reseller_dom_data_bases' => 'DBMySQL',
    'rpt_reseller_dom_mssql_data_bases' => 'DBMSSQL',

    'rpt_reseller_section_full_clients' => '客户',
    '__cl_name' => '客户名称',
    '__cl_creation_date' => '创建日',
    '__clients_traffic' => '客户流量',
    'rpt_reseller_cl_mail_antispam' => '防垃圾邮件',
    'rpt_reseller_cl_mail_antivirus' => '防病毒程序',

    // CONHELPS FOR HOME PAGE
    // common:
    'sitebuilder_not_installed' => '未安装 Presence Builder。',
    'sitebuilder_disabled' => '已停用 Presence Builder。',
    'b_sitebuilder_disabled' => '已停用 Presence Builder。',
    'webmail_not_installed' => 'Web 邮箱未安装。',
    'webmail_disabled' => 'Web 邮箱服务已停用。',
    'spamassassin_not_installed' => 'SpamAssassin未安装。',
    // pfu:
    'anonymous_ftp_shared' => '无法设置匿名FTP: 共享的IP地址类型。',
    'anonymous_ftp_used' => '无法设置匿名FTP: 此IP地址已被另一域名用于匿名FTP服务。',
    'sshterm__not_installed' => 'SSH终端未安装。',
    'sshterm__empty_shell' => '若要使用终端客户端，请允许shell访问此域名。',
    // pfw:
    'aspdotnet_not_installed' => '未安装 ASP.NET',
    'site_builder_no_package' => 'Presence Builder 不可用。请检查 Presence Builder 是否已安装，并选为活动组件。',
    'site_builder_not_configured' => '未配置 Presence Builder 。',

    // LIST OF CLIENTS
    // under reseller
    'ui__reseller/client#tools__title' => '工具',
    'ui__reseller/client#clientslist__title' => '客户',

    //reseller accounts removal





    // NEW HOME PAGE WIZARDS

    // PFW-only

    'ui__client/domain/odbc_unknown__wizard-title' => "设置网站的ODBC数据源",
    'ui__client/domain/odbc_unknown__wizard__2_unknown' => "选择要设置其ODBC数据源的网站。",

    'ui__client/domain/hosting/web-directories_unknown__wizard-title' => '管理网站上的虚拟目录',
    'ui__client/domain/hosting/web-directories_unknown__wizard__2_unknown' => "选择要管理其目录的网站。",

    'ui__client/domain/hosting/hotlink-protection_unknown__wizard-title' => "设置域名的防盗链功能",
    'ui__client/domain/hosting/hotlink-protection_unknown__wizard__2_unknown' => "选择要防止其文件被盗链的域名。",

    // COMMON WIZARDS


    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard-title' => '设置域名的匿名FTP',
    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard__2_unknown' => '选择您想要为其设置匿名 FTP 的域名。',

    'ui__client/domain/hosting/protected-directories_unknown__wizard-title' => '管理域名上有密码保护的目录',
    'ui__client/domain/hosting/protected-directories_unknown__wizard__2_unknown' => '选择要管理有密码保护的目录所在的域名。',

    'ui__client/domain/hosting/logs_unknown__wizard-title' => '设置域名的日志管理器并查看域名的日志文件',
    'ui__client/domain/hosting/logs_unknown__wizard__2_unknown' => '选择要设置其日志管理器并查看其日志文件的域名。',

    'ui__client/domain/certificate_unknown__wizard-title' => '管理域名的 SSL/TLS 证书',
    'ui__client/domain/certificate_unknown__wizard__2_unknown' => '选择要管理其 SSL/TLS 证书的域名。',

    'ui__client/domain/disable_multi__wizard-title' => '挂起域名',
    'ui__client/domain/disable_multi__wizard__2_multi' => '选择要挂起的域名。',

    'ui__client/domain/enable_multi__wizard-title' => '激活域名',
    'ui__client/domain/enable_multi__wizard__2_multi' => '选择要激活的域名。',

    'ui__client/domain_unknown__wizard-title' => '查看域名',
    'ui__client/domain_unknown__wizard__1_unknown' => '选择要查看其域名的客户。',

    'ui__client/domain/register_unknown__wizard-title' => '注册域名',
    'ui__client/domain/register_unknown__wizard__2_unknown' => '选择要注册的域名。',

    'ui__client/domain/extras_unknown__wizard-title' => '使用来自MyPlesk.com的工具',
    'ui__client/domain/extras_unknown__wizard__2_unknown' => '选择要使用来自MyPlesk.com的工具管理的域名。',



    'ui__client/domain/hosting/ssh-terminal_unknown__wizard-title' => '通过SSH访问服务器', // PFU
    'ui__client/domain/hosting/ssh-terminal_unknown__wizard__2_unknown' => '选择要通过SSH连接其虚拟机的域名。', // PFU

    // various

    'ui__server/ip-address/client_unknown__short-title' => 'IP地址用户',
    'ui__server/ip-address/client_unknown__title' => 'IP地址用户',
    'ui__server/ip-address/client_unknown__description' => 'IP地址%1用户',

    'disabled_by_admin' => '由服务器管理员禁用',






    'ui__client/domain/chowner_multi__short-title' => '更改所有权',
    'ui__client/domain/chowner_multi__title' => '更改域名所有权',
    'ui__client/domain/chowner_multi__description' => '更改域名所有权。',

    'ui__client/domain/chowner_multi__wizard__2_multi' => '选择您要更改其所有权的域名并单击“下一步 >>”。',
    'ui__client/domain/chowner_unknown__short-title' => '更改所有权',
    'ui__client/domain/chowner_unknown__title' => '更改域名所有权',
    'ui__client/domain/chowner_unknown__description' => '更改域名所有权。',

    'ui__client/domain/chowner_unknown__wizard-title' => '更改域名所有权',

    //custom buttons reseller home support
    //ui captions
    'ui__reseller/custom-buttons/custom-button__none-available' => '尚无自定义按钮。',
    'ui__reseller/custom-buttons/custom-button__none-available__1' => '在代理商 %1 的界面中没有自定义按钮。',

    'ui__reseller/custom-buttons/custom-button/delete__description' => '删除按钮%1。',

    'ui__reseller/custom-buttons/custom-button/delete__short-title' => '移除',
    'ui__reseller/custom-buttons/custom-button/delete__title' => '删除按钮%1',
    'ui__reseller/custom-buttons/custom-button/delete_multi__description' => '请从代理商的界面移除自定义按钮',

    'ui__reseller/custom-buttons/custom-button/delete_multi__short-title' => '移除',
    'ui__reseller/custom-buttons/custom-button/delete_multi__title' => '删除自定义按钮',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard-title' => '删除按钮',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => '选择要删除其自定义按钮的代理商，并单击"下一步 >>"。',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__3_multi' => '选择您要删除的按钮，并单击“下一步 >>”。',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__4_multi' => '通过选中屏幕上的复选框确认删除该按钮，并单击“完成”。',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__description' => '请从代理商的界面移除一个自定义按钮。',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__short-title' => '移除',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__title' => '删除自定义按钮',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard-title' => '删除自定义按钮',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => '选择要删除其自定义按钮的代理商，并单击"下一步 >>"。',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => '选择要删除的自定义按钮，并单击“下一步 >>”。',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__4' => '通过选中屏幕上的复选框来确认删除自定义按钮，并单击“完成”。',

    'ui__reseller/custom-buttons/custom-button/properties__description' => '编辑代理商级自定义按钮%1属性。',

    'ui__reseller/custom-buttons/custom-button/properties__short-title' => '设置',
    'ui__reseller/custom-buttons/custom-button/properties__title' => '修改代理商自定义按钮%1',

    'ui__reseller/custom-buttons/custom-button/properties_new__wizard-title' => '添加自定义按钮',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__1_unknown' => '请选定您想要在其界面中创建自定义按钮的的代理商并点击下一步 >>。',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__4_new' => '单击“完成”创建按钮。',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__description' => '请在代理商界面中修改按钮权限。',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__short-title' => '属性',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__title' => '请在代理商界面中修改按钮权限',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard-title' => '更改自定义按钮属性',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => '选择要修改其自定义按钮的代理商，并单击"下一步 >>"。',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => '选择要修改的自定义按钮，并单击“下一步 >>”。',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__4' => '完成编辑按钮属性之后，请单击“完成”应用更改并退出向导。',

    'ui__reseller/custom-buttons/custom-button/toggle_private__description' => '使得按钮%1对您的客户不可用。',

    'ui__reseller/custom-buttons/custom-button/toggle_private__short-title' => '对您的客户不可用',
    'ui__reseller/custom-buttons/custom-button/toggle_private__title' => '使得按钮%1对您的客户不可用',
    'ui__reseller/custom-buttons/custom-button/toggle_public__description' => '设置按钮%1对代理商客户可见。',
    'ui__reseller/custom-buttons/custom-button/toggle_public__short-title' => '对您的客户可用',
    'ui__reseller/custom-buttons/custom-button/toggle_public__title' => '设置按钮%1对代理商客户可见',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__description' => '使得自定义按钮对您的客户可用/不可用。',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__short-title' => '对您的客户可用/不可用',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__title' => '使得自定义按钮对您的客户可用/不可用',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard-title' => '使得自定义按钮对您的客户可用/不可用。',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => '选择要设置其自定义按钮对代理商客户可用的代理商，并单击"下一步 >>"。',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => '选择您要使其对您的客户可用或不可用的自定义按钮，并单击“下一步 >>”。',




    'ui__server/ip-addresses__short-title' => 'IP地址',
    'ui__server/ip-addresses__title' => 'IP地址管理',
    'ui__server/ip-addresses__description' => '添加、删除和分配IP地址。',

    'ip_ctrl__allow_ftps' => '允许 FTP over SSL/TLS',
    '__ftps' => 'FTP over SSL/TLS',
    '__not_allowed' => '不允许',



    'ui__client/ipaddress/domain_unknown__short-title' => '使用%2的域名',
    'ui__client/ipaddress/domain_unknown__title' => '使用%1 IP地址%2的域名',
    'ui__client/ipaddress/domain_unknown__description' => '查看使用 %1 IP地址 %2 的域名列表',

    'ui__client/ipaddress__none-available' => '无可用的IP地址',
    'ui__client/ipaddress__none-available__1' => '无可用的IP地址',

    'ui__client/domain/chowner__wizard__3' => '',
    'ui__client/domain/chowner__wizard__3_select' => '选择域名的新所有者。',

    '__ip_addr_state_unknown' => "因系统仍在处理您的请求，导致IP地址无法运行。请稍候。",


    'resellers_list__accounts' => '用户',

    'ip_addr__repair_is_not_allowed' => '无法修复Virtuozzo环境下的IP地址。',

    'ui__reseller/client__none-available__1' => '代理商%1无客户。',

    'ippoolManager__ip_used_by_nohost_domain' => "因一或多个无主机的域名使用 IP 地址 %%ip%%，导致无法移除该地址。",
    'ippoolManager__ip_used_for_mail_service' => "因 IP 地址 %%ip%% 被一个或多个域名用于其邮件服务 IP 地址而不能被移除。",
    'ippoolManager__ip_used_for_send_emails' => "IP 地址 %%ip%% 因被用于从指定 IP 发送电子邮件而不能被移除（请查看邮件服务器设置）。",
    'ippoolManager__ip_used_in_dns_zone' => '因一或多个域名的DNS区域使用IP地址%%ip%%，导致无法删除该地址。',
    'ip_ctrl__cannot_manage_on_vz' => '正在 Virtuozzo 容器下安装 Plesk 。只有 Virtuozzo 容器节点管理员才能添加新的 IP 地址。',

    'client_template__limits_auto_adjusted' => '已自动调整来自客户模板的限制。',

    '__entries' => '项目',

    '__path_is_not_set' => '未指定此路径。请指定有效路径。',

    'defaultcomponents__imap_required' => '(当前邮件服务器不支持IMAP)',

    // Hotlink protection conhelp // PFW
    'i_hotlinkprotection_on' => '此域名的防盗链功能已启用。',
    'i_hotlinkprotection_off' => '此域名的防盗链功能已停用。',

    '__commercial_web_stats_not_installed' => 'Plesk 仅支持使用商业网站统计软件用于子域名的统计计算。目前系统中还未安装此类软件。',

    'mail__spamassassin_personal_settings_disallowed' => '服务器管理员已禁止使用个人垃圾邮件过滤设置。不会应用下面指定的垃圾邮件过滤设置。',

    // CLI keys, should be moved to separate file after 9.0
    'cu__unable_create_object' => '无法创建%1对象：%2',
    'cu_dom_pref__invalid_expiration_date' => '过期日无效: %1',
    'cu_cl_pref__illegal_date_val' => '您指定的日期值无效("%1")',
    'cu_cl_pref__illegal_date_greater_less' => '输入从“%1”到“%2”的年份',
    'cu_initconf__unable_set_ip_alias_type' => '无法设置 IP 别名类型：%1',
    'cu_mlist__unable_change_status' => "无法更改邮件列表状态：%1",
    'cu_initconf__unable_change_passwd' => "无法更改管理员密码：%1",
    'cu_serverpref__option_description_include_remote_databases' => '把远程的 MySQL 数据库计算在磁盘空间使用内。',
    'cu_siteapp_item__add_to_pool_success' => 'Web应用程序已添加到web应用程序池。',
    'cu_siteapp_item__remove_from_pool_success' => 'Web应用程序已从web应用程序池移除。',
    'cu_traffic_command_description_add_user' => '若已被客户/代理商使用，则注册指定量的流量',
    'cu_traffic_command_description_sub_user' => '若已被客户/代理商使用，则从总流量中减去指定量',
    'cu_traffic_command_description_add_batch_user' => '注册指定流量，就像已被客户/代理商使用(批量模式)',
    'cu_traffic_command_description_del_user' => '重置此客户/代理商的注册流量为零',
    'cu_resellerpref__option_lock_screen' => '请阻止用户在界面屏幕完全加载之前使用 Plesk 。',

    'server_settings_invalid_traffic_statistics' => '保留流量统计数据参数无效。',
    'server_settings_invalid_logrotate_period' => '日志循环时段参数无效。',
];