<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx“502无效网关：上游读取响应头时发送了太大的信息头”',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.title' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.text' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache“500内部服务器错误：此处不允许选项 FollowSymLinks”',
    'problem-detail.apache-followsymlinks-not-allowed.description' => '',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "服务器达到 max_children 设置"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>症状</h4><ul><li><p>有 PHP 处理程序的网站设置为 <strong>Apache 服务的 FPM 应用程序</strong>或<strong>nginx 服务的 FPM 应用程序</strong>（位于 <strong>域名</strong> &gt; <strong>example.com</strong> &gt;）<strong>PHP 设置</strong>遇到以下当中的一个问题：</p><ul><li><p>加载慢</p></li><li><p>不可访问（永久或定期），web 浏览器中出现50x错误：</p><pre>502 无效网关</pre><hr><pre>503 服务暂时不可用</pre><hr><pre>504 网关超时</pre></li></ul></li><li><p>以下信息出现在 PHP-FPM 错误日志文件<code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code>中（其中 <em>XX</em> 是网站使用的 PHP 版本）：</p><pre>警告： [pool example.com] 服务器达到 max_children 设置 (*)，考虑将其提升</pre><ul><li><p>以上信息通常伴随此错误：</p><pre>无法读取子代所说的内容：错误的文件描述符(9)</pre></li></ul></li><li><p>如果在服务器上启用了nginx，则域名的错误日志文件中可能会出现以下错误消息之一 <code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 connect() to unix:///var/www/vhosts/system/example.com/php-fpm.sock failed (11: 资源临时不可用)，连接上游时，客户端：203.0.113.2，服务器：example.com，请求： "GET / HTTP/1.1"，上游："fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:"，主机："example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 从上游读取响应头时，上游连接过早关闭连接，客户端：203.0.113.2，服务器：example.com，请求："POST /path/to/some/file HTTP/2.0"，上游：</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>网站已达到 PHP-FPM <code>pm.max_children</code>。</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1.title' => 'Increase the pm.max_children limit',
    'problem-detail.phpfpm-server-reached-max-children.solution1.text' => '<p>提高受影响的域名的 <code>pm.max_children</code> 限制：</p><ol><li><p>连接到 Plesk 服务器，通过 <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener">SSH</a>。</p></li><li><p>使用以下命令查找受影响的域名：</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>注意：</strong> 左边的数据表示网站已达到 <code>pm.max_children</code> 限制的次数。</div><pre style="white-space: pre-wrap;"># grep -r "服务器已达到 max_children 设置" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener">登录到 Plesk</a>。</p></li><li><p>转到 <strong>域名</strong> &gt; <strong>example.com</strong> &gt; <strong>PHP 设置</strong> &gt; <strong>PHP-FPM 设置</strong>.</p></li><li><p>增加域名的 <code>pm.max_children</code> 值并应用更改。在第2步骤为所有列出的域名增加此值。</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "太多打开的文件"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx 无法在 Plesk 服务器上启动/加载：太多打开的文件</p><h4>症状</h4><ul><li><p>nginx 服务无法启动/加载，在 <code>/var/log/nginx/error.log</code> 文件中出现以下问题：</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" failed (24: 太多打开的文件)</pre></li><li><p>某些或所有的网站不可访问</p></li><li><p>警告在<strong>工具与设置 &gt;诊断与修复</strong>中显示：</p><pre style="white-space: pre-wrap;">查找nginx ULIMIT 值，在服务器上找到 N 个域名。可能会出现已打开文件的 nginx 默认限制的问题</pre></li><li><p>NodeJS和Rubyweb应用程序在执行一些Plesk任务时显示502无效网关错误，例如在创建域名、订阅或在Apache或Nginx上更改时：</p><pre style="white-space: pre-wrap;">服务器错误<br>502 无效网关<br>Web服务器在作为网关或代理服务器时收到了一个无效的响应。</pre></li><li><p>在<a href="https://support.plesk.com/hc/en-us/articles/213946825-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">为域名安装新的证书后</a>，旧的证书仍会在web 浏览器中显示，但是会在 <strong>域名 &gt; example.com &gt; 主机设置</strong> 页面中选定正确的证书。</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>Nginx的虚拟主机为带有物理主机的每个虚拟主机打开了 4 个日志文件：</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>因域名众多（通常超过100个）所以会导致超过nginx服务器可打开的文件的最大数量。</p>',
    'problem-detail.nginx-too-many-open-files.solution1.title' => 'Increase the open files limit',
    'problem-detail.nginx-too-many-open-files.solution1.text' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>警告：</strong> 执行<code>websrv_ulimits</code> 工具而无<strong>--no-restart</strong> 选项会启动为所有域名重建 web 配置文件，可能会因为托管网站数量众多而导致严重的宕机。<br><br>在维护期间框架内执行该命令</div><p>最好是将打开的文件限制值设置至少不超过<strong>Plesk * 16</strong> 中域名的数量。在下面的示例中，提供了如何设置限制为4096的操作步骤：</p><ol><li><p>通过<a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener noreferrer">SSH连接到服务器</a></p></li><li><p>为Apache和 Nginx将打开的文件限制设置为4096：</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>在 <strong><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>工具 &amp; 设置 &gt; 服务管理</strong> 重启Apache 和 nginx以应用更改。</p></li><li><p>在web服务重启后检查 \'打开文件限制最大值\' 是否正确应用：</p><pre># grep \'Max open files\' /proc/$(cat /var/run/nginx.pid)/limits<br>打开文件最大值 4096 4096 个文件</pre></li><li><p>若上述方案没有帮助，请使用 <code>ulimit</code> 工具设置限制：</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "响应主体太大"',
    'problem-detail.apache-modsec-response-body-too-large.description' => '',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "访问被拒，代码 403"',
    'problem-detail.modsec-access-denied.description' => '',
    'problem-detail.modsec-access-denied.cause' => '',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "内部服务器错误 500: 允许的内存容量 XXX 已耗尽"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "open_basedir 限制有效"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => '',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403禁止AH01797：客户端被服务器配置拒绝"',
    'problem-detail.apache-client-denied-by-server.description' => '',
    'problem-detail.apache-client-denied-by-server.cause' => '',
    'problem-detail.apache-no-directory-index.name' => 'Apache“无法访问Plesk中的网站目录：403禁止”',
    'problem-detail.apache-no-directory-index.description' => '',
    'problem-detail.apache-no-directory-index.cause' => '',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx“无法访问Plesk中的网站目录：403禁止”',
    'problem-detail.nginx-no-directory-index.description' => '',
    'problem-detail.nginx-no-directory-index.cause' => '',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "服务器达到了 MaxRequestWorkers 设置"',
    'problem-detail.apache-reached-max-request-workers.description' => '',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'PHP请求主体限制“客户端计划发送过大主体”',
    'problem-detail.php-post-content-length-exceeds-limit.description' => '',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'PHP请求主体限制“客户端计划发送过大主体”',
    'problem-detail.nginx-client-sent-too-large-body.description' => '',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'PHP会话“503内部服务器错误”或“读取会话数据失败”',
    'problem-detail.php-failed-to-read-session-data.description' => '',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Forbidden: pcfg_openfile: 无法检查htaccess文件，以确保其可读性”',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => '',
];