<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "502 Gateway non valido: upstream ha inviato un\'intestazione troppo grande durante la lettura dell\'intestazione della risposta"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.title' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.text' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache "500 Errore interno del server: opzione FollowSymLinks non consentita qui"',
    'problem-detail.apache-followsymlinks-not-allowed.description' => '',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "il server ha raggiunto il parametro max_children"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Sintomi</h4><ul><li><p>I siti che hanno un gestore PHP impostato come <strong>Applicazione FPM fornita da Apache</strong> o <strong>Applicazione FPM fornita da nginx</strong> in <strong>Domini</strong> &gt; <strong>example.com</strong> &gt; <strong>Impostazioni PHP</strong> incorrono in uno di questi problemi:</p><ul><li><p>caricamento lento</p></li><li><p>non accessibile (in modo permanente o temporaneo) con un errore 50x nel browser web:</p><pre>502 Gateway non valido</pre><hr><pre>503 Servizio temporaneamente non disponibile</pre><hr><pre>504 Time-out del gateway</pre></li></ul></li><li><p>Il seguente messaggio appare nel file di registro degli errori PHP-FPM<code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> (dove <em>XX</em> è la versione PHP usata dai siti):</p><pre>ATTENZIONE: [pool esempio.com] il server ha raggiunto il parametro max_children (*), considerare la possibilità di aumentarlo</pre><ul><li><p>Il messaggio su indicato è accompagnato di solito da questo errore:</p><pre>impossibile leggere ciò che dice il processo figlio: descrittore file non valido (9)</pre></li></ul></li><li><p>Se nginx è attivo sul server, potrebbe apparire uno dei seguenti messaggi di errore nel file di registro degli errori del dominio<code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 connessione() a unix:///var/www/vhosts/system/example.com/php-fpm.sock fallita (11: Risorsa temporaneamente non disponibile) durante la connessione a upstream, client: 203.0.113.2, server: example.com, richiesta: "GET / HTTP/1.1", upstream: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", host: "esempio.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 upstream ha chiuso prematuramente la connessione durante la lettura dell\'intestazione della risposta da upstream, client: 203.0.113.2, server: esempio.com, richiesta: "POST /path/to/some/file HTTP/2.0", upstream:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>Il PHP-FPM <code>pm.max_children</code> è stato raggiunto dal sito/i.</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1.title' => 'Increase the pm.max_children limit',
    'problem-detail.phpfpm-server-reached-max-children.solution1.text' => '<p>Aumenta il limite <code>pm.max_children</code> per i domini interessati:</p><ol><li><p>Connessione al server Plesk via <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener">SSH</a>.</p></li><li><p>Trova i domini interessati utilizzando questo comando:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Nota:</strong> il numero a sinistra indica quante volte il limite <code>pm.max_children</code> è stato raggiunto dal sito.</div><pre style="white-space: pre-wrap;"># grep -r "server reached max_children setting" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 esempio.com<br>50 esempio.net<br>25 esempio.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener">Accedi a Plesk</a>.</p></li><li><p>Vai in <strong>Domini</strong> &gt; <strong>esempio.com</strong> &gt; <strong>Impostazioni PHP</strong> &gt; <strong>Impostazioni PHP-FPM</strong>.</p></li><li><p>Aumenta il valore <code>pm.max_children</code> per il dominio e applica le modifiche. Aumenta questo valore per tutti i domini elencati nel passaggio 2.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "Troppi file aperti"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx non si avvia/ricarica su un server Plesk: troppi file aperti</p><h4>Sintomi</h4><ul><li><p>Il servizio nginx non si avvia/ricarica col seguente errore nel file <code>/var/log/nginx/error.log</code>:</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/www/vhosts/system/esempio.com/logs/proxy_access_ssl_log" failed (24: Troppi file aperti)</pre></li><li><p>Alcuni o tutti i siti non sono accessibili</p></li><li><p>Avviso mostrato in <strong>Strumenti e impostazioni &gt; Diagnostica e ripara</strong>:</p><pre style="white-space: pre-wrap;">Durante la verifica del valore nginx ULIMIT, sono stati trovati N domini sul server. È possibile che ci sia un problema con il limite predefinito di nginx per i file aperti</pre></li><li><p>Le applicazioni web NodeJS e Ruby mostrano un errore 502 Gateway non valido quando eseguono alcuni task di Plesk come la creazione di domini, abbonamenti, modifiche ad Apache o Nginx, ecc.:</p><pre style="white-space: pre-wrap;">Errore del server<br>502 Gateway non valido<br>Il server web ha ricevuto una risposta non valida mentre fungeva da gateway o server proxy.</pre></li><li><p>Dopo <a href="https://support.plesk.com/hc/en-us/articles/213946825-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">aver installato un nuovo certificato per il dominio</a>, quello vecchio appare ancora in un browser. Tuttavia, il certificato corretto è selezionato nella pagina <strong>Domini &gt; esempio.com &gt; Impostazioni di hosting</strong>.</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>L\'host virtuale di Nginx apre 4 file di registro per ogni host virtuale con hosting fisico:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>Di conseguenza, il numero massimo di file aperti è stato superato dal server nginx a causa dell\'elevato numero di domini (solitamente più di 100).</p>',
    'problem-detail.nginx-too-many-open-files.solution1.title' => 'Increase the open files limit',
    'problem-detail.nginx-too-many-open-files.solution1.text' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Attenzione:</strong> l\'esecuzione dell\'utility <code>websrv_ulimits</code> senza l\'opzione <strong>--no-restart</strong> avvia la ricostruzione dei file di configurazione web per tutti i domini e può causare interruzioni significative in presenza di un elevato numero di siti ospitati.<br><br>Eseguire il comando durante la manutenzione.</div><p>È buona pratica impostare il limite di file aperti ad un numero almeno superiore al <strong>numero di domini in Plesk * 16</strong>. L\'esempio riportato mostra le azioni da compiere per impostare il limite a 4096:</p><ol><li><p>Connettiti al server via <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener noreferrer">SSH</a></p></li><li><p>Imposta il limite di file aperti a 4096 per Apache e Nginx:</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>Riavvia i servizi Apache e nginx in <strong><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>Strumenti e impostazioni &gt; Gestione di servizi</strong> per applicare le modifiche.</p></li><li><p>Verifica che \'Limite file aperti\' sia impostato correttamente dopo il riavvio dei servizi web:</p><pre># grep \'Max open files\' /proc/$(cat /var/run/nginx.pid)/limits<br>Limite file aperti 4096 4096 file</pre></li><li><p>Se la soluzione indicata non ha risolto il problema, imposta il imite usando l\'utility <code>ulimit</code>:</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "Corpo risposta troppo grande"',
    'problem-detail.apache-modsec-response-body-too-large.description' => '',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "Accesso negato con codice 403"',
    'problem-detail.modsec-access-denied.description' => '',
    'problem-detail.modsec-access-denied.cause' => '',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "Errore interno server 500: esaurita dimensione memoria consentita di XXX"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "Restrizione open_basedir in vigore"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => '',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 Proibito AH01797: client proibito dalla configurazione del server"',
    'problem-detail.apache-client-denied-by-server.description' => '',
    'problem-detail.apache-client-denied-by-server.cause' => '',
    'problem-detail.apache-no-directory-index.name' => 'Apache "Impossibile accedere alla directory di un sito in Plesk: 403 Proibito"',
    'problem-detail.apache-no-directory-index.description' => '',
    'problem-detail.apache-no-directory-index.cause' => '',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "Impossibile accedere alla directory di un sito in Plesk: 403 Proibito"',
    'problem-detail.nginx-no-directory-index.description' => '',
    'problem-detail.nginx-no-directory-index.cause' => '',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "Il server ha raggiunto l\'impostazione MaxRequestWorkers"',
    'problem-detail.apache-reached-max-request-workers.description' => '',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'PHP limite corpo richiesta "Il client voleva inviare un corpo troppo grande"',
    'problem-detail.php-post-content-length-exceeds-limit.description' => '',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'PHP limite corpo richiesta "Il client voleva inviare un corpo troppo grande"',
    'problem-detail.nginx-client-sent-too-large-body.description' => '',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'PHP Sessioni "503 Errore interno server" o "Impossibile leggere dati sessione"',
    'problem-detail.php-failed-to-read-session-data.description' => '',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Forbidden: pcfg_openfile: impossibile verificare il file htaccess, assicurarsi che sia leggibile"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => '',
];