<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'admin-info.adminInfoSection' => 'Informationen für den Administrator',
    'admin-info.description-admin' => 'Beschreibung des Administrators',
    'admin-info.description-reseller' => 'Beschreibung des Resellers',
    'admin-info.description-owner' => 'Beschreibung des übergeordneten Verantwortlichen',
    'admin-info.description' => 'Beschreibung',
    'admin-info.descriptionSuccess' => 'Die Beschreibung wurde aktualisiert.',
    'admin-info.longDescription' => 'Die angegebene Beschreibung ist zu lang. Es dürfen höchstens %%max%% Zeichen verwendet werden.',
    'admin-info.add' => 'Beschreibung hinzufügen',
    'admin-info.edit' => 'Bearbeiten',
    'admin-info.remove' => 'Löschen',
    'admin-info.confirmOnRemove' => 'Möchten Sie die Beschreibung entfernen?',
    'admin-info.popupTitle-customer' => '%%descriptionType%% zum Kunden %%name%%',
    'admin-info.popupTitle-reseller' => '%%descriptionType%% zum Reseller %%name%%',
    'admin-info.popupTitle-subscription' => '%%descriptionType%% zum Abonnement %%name%%',
    'admin-info.popupTitle-site' => '%%descriptionType%% zu %%name%%',
    'admin-info.popupHint-admin' => 'Diese Beschreibung ist nur für den Administrator sichtbar.',
    'admin-info.popupHint-reseller' => 'Diese Beschreibung ist für den Reseller und den Administrator sichtbar.',
    'admin-info.popupHint-owner' => 'Diese Beschreibung ist für deren Verfasser und den Hosting-Provider des Verfassers sichtbar.',
    'admin-info.customerDescriptionHint' => 'Kunden können die Beschreibung nicht sehen.',
    'admin-info.subscriptionDescriptionHint' => "Diese Information ist nur für den Hosting-Provider sichtbar (Plesk Administrator oder Reseller).",

    'apache-settings.formGeneralHint' => 'Hier können Sie die Apache-Webserver-Einstellungen für diese Website angeben. Eine benutzerdefinierte Apache-Konfiguration ist zum Beispiel dann nützlich, wenn Sie einen neuen Typ von Indexdateien auf Ihrer Website verwenden wollen oder einen bestimmten MIME-Typ mit bestimmten Dateinamenerweiterungen verbinden möchten. Der Standardwert bedeutet, dass Apache die entsprechende Anweisung aus seiner serverweiten Konfiguration verwendet. Wenn Apache mit nginx als Front-End-Server ausgeführt wird, können Sie die nginx-Einstellungen ebenfalls auf dieser Seite angeben.',
    'apache-settings.general' => 'Allgemeine Apache-Einstellungen',
    'apache-settings.example' => "Zum Beispiel:\n%%example%%",
    'apache-settings.settingOn' => 'Ein',
    'apache-settings.settingOff' => 'Aus (Standard)',
    'apache-settings.settingDefault' => 'Standard',
    'apache-settings.settingCustom' => 'Eigenen Wert eingeben',
    'apache-settings.mimeTypes' => 'MIME-Typen',
    'apache-settings.mimeTypesExample' => "text/plain .txt\nimage/jpeg .jpeg \n\nMIME-Typen verbinden die Dateierweiterungen mit Dateitypen. Dies wird üblicherweise verwendet, um benutzerdefinierte Dateierweiterungen für gängige Dateitypen zu erstellen.",
    'apache-settings.handlers' => 'Handler',
    'apache-settings.handlersExample' => "php-script .php\ncgi-script .cgi \n\nApache Handler definieren, wie der Webserver Dateien mit bestimmten Erweiterungen verarbeitet, wenn sie abgefragt werden. Beispielsweise bedeutet der String 'php-script .script', dass Apache .script-Dateien als PHP-Skripte behandelt.",
    'apache-settings.deny' => 'Zugriff auf Website verweigern',
    'apache-settings.allow' => 'Ausnahmen',
    'apache-settings.denyExample' => "10.1.0.0/16\n192.168.1.110\n\nDen angegebenen Hosts und Netzwerken ist untersagt, auf die Website zuzugreifen. Verwenden Sie '*', um alle Verbindungen abzulehnen.",
    'apache-settings.allowExample' => "192.168.0.0/16\n10.1.1.21\n\nDie angegebenen Hosts und Netzwerke dürfen auf die Website zugreifen.",
    'apache-settings.directoryIndex' => 'Indexdateien',
    'apache-settings.directoryIndexExample' => "index.htm index.php index.pl \n\nApache sucht nach den angegebenen Dateien, wenn die Indexseite der Website abgefragt wird.",
    'apache-settings.expires' => 'Ablaufdatum',
    'apache-settings.expiresStaticOnly' => 'Antwort mit Headern "Ablaufdatum" nur für statische Dateien',
    'apache-settings.expiresDescription' => 'Der Webserver fügt die Antwortheader "Ablaufdatum" zu Webpages hinzu. Zur Berechnung des Zeitstempels für das Ablaufdatum wird die oben genannte Dauer zum Zeitpunkt hinzugefügt, an dem eine Webpage angefordert wird.',
    'apache-settings.expiresStaticOnlyDescription' => 'Der Header "Ablaufdatum" wird nur in statischen Dateien hinzugefügt. Welche Dateien als statisch angesehen werden, hängt von den Optionen "Intelligente Bearbeitung statischer Dateien" und "Statische Dateien direkt durch nginx bedienen" ab.',
    'apache-settings.expiresUnitDays' => 'Tage',
    'apache-settings.expiresUnitHours' => 'Stunden',
    'apache-settings.expiresUnitMinutes' => 'Minuten',
    'apache-settings.expiresUnitSeconds' => 'Sekunden',
    'apache-settings.headers' => 'Zusätzliche Header',
    'apache-settings.headersExample' => "Cache-Control: public Strict-Transport-Security: max-age=63072000 X-Frame-Options: DENY Die angegebenen HTTP-Antwortheader werden im Webserver hinzugefügt.",
    'apache-settings.restrictFollowSymLinks' => 'Fähigkeit, symbolischen Verknüpfungen zu folgen, einschränken',
    'apache-settings.restrictFollowSymLinksDescription' => "Wählen Sie diese Option aus, um Benutzer daran zu hindern, die Anweisung FollowSymLink in .htaccess zu verwenden und um so die Serversicherheit zu verbessern.",
    'apache-settings.nginx' => 'nginx-Einstellungen',
    'apache-settings.nginxProxyMode' => 'Proxymodus',
    'apache-settings.nginxProxyModeDescription' => 'Nginx leitet Anfragen über Proxys an Apache weiter. Deaktivieren, um Apache nicht mehr zu verwenden',
    'apache-settings.nginxTransparentMode' => 'Intelligente Bearbeitung statischer Dateien',
    'apache-settings.nginxTransparentModeDescription' => 'Wenn ausgeschaltet, werden alle Abfragen statischer Dateien von Apache bearbeitet. Nginx wird Abfragen und Antworten dann ohne Modifikation weitergeben. Schalten Sie diese Option bitte nur zur Problembehebung aus.',
    'apache-settings.nginxServeStatic' => 'Statische Dateien direkt durch nginx bedienen',
    'apache-settings.nginxStaticExtensions' => 'Geben Sie Dateierweiterungen getrennt durch Leerzeichen oder das Symbol "|" an. Abfragen dieser Dateien werden von nginx bearbeitet und erreichen Apache niemals. Achtung: Apache-Rewrite-Regeln werden nicht angewendet.',
    'apache-settings.nginxServePhp' => 'PHP von nginx verarbeiten lassen',
    'apache-settings.nginxServePhpDescription' => 'PHP-Dateien (.php) werden von nginx und PHP-FPM gehandhabt. Wenn ausgeschaltet, werden PHP-Dateien von Apache verarbeitet.',
    'apache-settings.nginxCacheEnabled' => 'nginx-Caching aktivieren',
    'apache-settings.nginxCacheEnabledDescription' => 'Caching kann die Reaktionszeit Ihrer Website, sowie die Serverauslastung verringern, sollte jedoch mit Vorsicht ausgeführt werden.',
    'apache-settings.nginxCacheSize' => 'Cache-Größe',
    'apache-settings.nginxCacheSizeGb' => 'GB',
    'apache-settings.nginxCacheSizeMb' => 'MB',
    'apache-settings.nginxCacheSizeKb' => 'KB',
    'apache-settings.nginxCacheSizeBytes' => 'B',
    'apache-settings.nginxCacheTimeout' => 'Cache-Zeitlimit',
    'apache-settings.nginxCacheTimeoutDays' => 'Tage',
    'apache-settings.nginxCacheTimeoutHours' => 'Stunden',
    'apache-settings.nginxCacheTimeoutMinutes' => 'Minuten',
    'apache-settings.nginxCacheTimeoutSeconds' => 'Sekunden',
    'apache-settings.nginxCacheKey' => 'Cache-Schlüssel',
    'apache-settings.nginxCacheCookies' => 'Abfragen mit Cookies zwischenspeichern',
    'apache-settings.nginxCacheBypassLocations' => 'Caching deaktivieren für Standorte',
    'apache-settings.nginxCacheBypass' => 'Cache umgehen, wenn',
    'apache-settings.nginxCacheBypassHeaderNocache' => 'bei der Abfrage HTTP-Header des Typs "no-cache" erhalten werden',
    'apache-settings.nginxCacheBypassHeaderAuth' => 'bei der Abfrage HTTP-Autorisierungs-Header erhalten werden',
    'apache-settings.nginxCacheBypassGetNocache' => 'bei der Abfrage der GET-Parameter des Typs "no-cache" erhalten wird',
    'apache-settings.nginxCacheUseStale' => 'Überholte Cache-Einträge zurückgeben',
    'apache-settings.nginxCacheUseStale5xx' => 'Upstream gibt Client-Fehler 5xx zurück',
    'apache-settings.nginxCacheUseStale4xx' => 'Upstream gibt Client-Fehler 4xx zurück',
    'apache-settings.nginxCacheUseStaleUpdating' => 'Cache wird gerade aktualisiert',
    'apache-settings.additional' => 'Zusätzliche Apache-Anweisungen',
    'apache-settings.additionalSettingsDescription' => 'Wenn Sie bestimmte Einstellungen nicht finden, fügen Sie sie in den unten stehenden Feldern hinzu. Diese Einstellungen werden die serverweiten Apache-Anweisungen überschreiben. Die Anweisungen aus dem ersten Feld werden verwendet, wenn ein Besucher über HTTP auf die Website zugreift. Das zweite Feld enthält die Anweisungen für HTTPS. Im Allgemeinen sollten Sie Ihre Anweisungen in beiden Feldern hinzufügen. Verwenden Sie dieselbe Syntax, die Sie für httpd.include verwenden. Beispiel: Wenn Sie eine benutzerdefinierte Fehlerseite einrichten möchten, müssen Sie diese Zeile hinzufügen: ErrorDocument 401 /my_error_page.html',
    'apache-settings.additionalSettings' => 'Zusätzliche Anweisungen für HTTP',
    'apache-settings.additionalSslSettings' => 'Zusätzliche Anweisungen für HTTPS',
    'apache-settings.additionalSettingsError' => 'Ungültige Apache-Konfiguration: %%error%%',
    'apache-settings.rollbackFailed' => 'Es ist nicht möglich, die aktuelle Apache-Konfigurationsdatei zu verwenden und zur vorherigen Version der Datei zurückzukehren, da sie eine ungültige Konfiguration enthält.',
    'apache-settings.additionalNginx' => 'Zusätzliche nginx-Anweisungen',
    'apache-settings.additionalNginxSettingsDescription' => 'Hier können Sie die Einstellungen für den nginx-Reverse-Proxyserver, der Apache vorgeschaltet ist, angeben. Ihre Anweisungen werden die serverweite nginx-Konfiguration überschreiben. Beispielsweise möchten Sie vielleicht die Verbindungszeitüberschreitung ändern oder Abfragen mit Gzip packen. Verwenden Sie dieselbe Syntax, die Sie für nginx.conf verwenden. Beispiel: Wenn Sie alle über den Proxy gelaufenen Abfragen mit Gzip packen möchten, fügen Sie diese Zeile hinzu: \'gzip_proxied any;\'.',
    'apache-settings.additionalNginxSettings' => 'Zusätzliche nginx-Anweisungen',
    'apache-settings.additionalNginxSettingsError' => 'Ungültige nginx-Konfiguration: %%error%%',
    'apache-settings.nginxRollbackFailed' => 'Es ist nicht möglich, die aktuelle nginx-Konfigurationsdatei zu verwenden sowie zur vorherigen Version der Datei zurückzukehren, da beide eine ungültige Konfiguration enthalten.',

    'backup.backup-password-protection.securitySettingsSection' => 'Einstellungen zur Backupsicherheit',
    'backup.backup-password-protection.backupPasswordFromFtpSettings' => 'Passwort aus Einstellungen des Remote-Speichers abrufen',
    'backup.backup-password-protection.backupPasswordManualInput' => 'Passwort manuell eingeben',
    'backup.backup-password-protection.providePasswordCheckbox' => 'Passwort angeben',
    'backup.backup-password-protection.backupPassword' => 'Passwort',
    'backup.backup-password-protection.inputPasswordType' => 'Art des Passworts',
    'backup.backup-password-protection.confirmBackupPassword' => 'Passwort wiederholen',
    'backup.backup-password-protection.backupPasswordHint' => 'Wenn Sie Ihr Passwort vergessen haben, lassen Sie diese Option leer. Beachten Sie, dass in diesem Fall einige sensible Daten nicht richtig wiederhergestellt werden. Zum Beispiel werden Benutzerpasswörter durch zufällige Passwörter ersetzt oder die Informationen zu bereits installierten APS-Apps gehen verloren usw.',
    'backup.backup-password-protection.backupPasswordFtpHint' => 'Wenn Sie dieses Backup mit einem Passwortschutz erstellt haben, geben Sie bitte das Passwort in den nachfolgenden Feldern ein. Beachten Sie, dass Plesk das Backup nicht wiederherstellt, wenn Sie ein falsches Passwort eingeben. Das Backup wird stattdessen in den lokale Speicher kopiert.',

    'backup.conflict-database.dbMappingLegend' => 'Zuordnung des Datenbankservers',
    'backup.conflict-database.serverType' => 'Servertyp',
    'backup.conflict-database.hostName' => 'Hostname',
    'backup.conflict-database.port' => 'Port',
    'backup.conflict-database.destinationDbServer' => 'Zieldatenbankserver',
    'backup.conflict-database.mysql' => 'MySQL',
    'backup.conflict-database.postgresql' => 'PostgreSQL',
    'backup.conflict-database.mssql' => 'MSSQL',
    'backup.conflict-database.migrationDbServerNotFind' => 'Die Datenbank kann nicht wiederhergestellt werden: Es ist kein geeigneter Datenbankserver vorhanden.',

    'backup.conflict-ip.buttonUploadMappingFile' => 'IP-Mapping-Datei hochladen',
    'backup.conflict-ip.ipMappingLegend' => 'IP-Mapping',
    'backup.conflict-ip.buttonSaveCurrentMapping' => 'Aktuelles IP-Mapping in Datei speichern',
    'backup.conflict-ip.ipAddressNotFound' => 'Es sind keine freien IP-Adressen dieses Typs vorhanden.',
    'backup.conflict-ip.sharedIp' => 'gemeinsam genutzt',
    'backup.conflict-ip.dedicatedIp' => 'dediziert',
    'backup.conflict-ip.fileNotFound' => 'Die Datei darf nicht leer sein.',
    'backup.conflict-ip.invalidIpToMap' => 'Ungültiger Wert für eine alte IP-Adresse: %%ip%%',
    'backup.conflict-ip.invalidMappingValue' => 'Ungültiger Wert für eine neue IP-Adresse: %%ip%%',
    'backup.conflict-ip.ipNotFound' => 'Die IP-Adresse %%ip%% kann nicht in der Datenbank gefunden werden.',
    'backup.conflict-ip.uploadIpMappingFileLegend' => 'IP-Mapping-Datei hochladen',
    'backup.conflict-ip.ipMappingFileHint' => 'Eine IP-Mapping-Datei ist eine Textdatei. Jede Zeile dieser Datei enthält IP-Mapping-Informationen im Format: <alte IP-Adresse> <neue IP-Adresse>',
    'backup.conflict-ip.oldIp' => 'Alte IP-Adressen',
    'backup.conflict-ip.newIp' => 'Neue IP-Adressen',

    'backup.copy-to-server.ignoreBackupSign' => 'Backupdatei ohne gültige Signatur hochladen',
    'backup.copy-to-server.wrongPassword' => 'Das angegebene Passwort ist falsch. Während der Backupwiederherstellung werden Sie von Plesk aufgefordert, das Passwort erneut einzugeben.',
    'backup.copy-to-server.corruptedSignatureUploaded' => 'Die hochgeladene Backupdatei %%fileName%% wurde modifiziert, beschädigt, auf einem anderen Server erstellt oder in einer älteren Plesk Version erstellt, die das Signieren von Backups nicht unterstützt. Bevor Sie Daten aus dieser Backupdatei wiederherstellen, sollten Sie sich vergewissern, dass Sie der Quelle dieser Datei vertrauen können.',
    'backup.copy-to-server.corruptedSignatureNotUploadedUser' => 'Die Backupdatei %%fileName%% kann nicht hochgeladen werden. Die Datei enthält entweder modifizierte oder beschädigte Dateien, oder wurde auf einem anderen Server oder in einer älteren Plesk Version erstellt. Wenden Sie sich an Ihren Hosting-Provider, um Daten aus dieser Datei wiederherstellen zu lassen.',
    'backup.copy-to-server.corruptedSignatureNotUploadedAdmin' => 'Die Backupdatei %%fileName%% kann nicht hochgeladen werden. Die Datei wurde modifiziert, beschädigt, auf einem anderen Server erstellt oder in einer älteren Plesk Version erstellt, die das Signieren von Backups nicht unterstützt. Wenn Sie diesem Backup vertrauen, wählen Sie die Option "Backupdatei ohne gültige Signatur hochladen" und laden Sie sie erneut hoch.',
    'backup.copy-to-server.unableToMoveToLocalRepository' => "Das ausgewählte Backup %%fileName%% kann nicht in den Serverspeicher verschoben werden. Fehler: %%error%%.",
    'backup.copy-to-server.missedPartsWarning' => "Die folgenden Bestandteile des inkrementellen Backups wurden nicht kopiert:%%endl%%%%missedParts%%%%endl%%Bitte kopieren Sie die fehlenden Bestandteile.",

    'backup.ftp-settings.isActive' => 'FTP(S)-Speicher verwenden',
    'backup.ftp-settings.host' => 'Hostname oder IP des FTP-Servers',
    'backup.ftp-settings.directory' => 'Verzeichnis zum Speichern von Backupdateien',
    'backup.ftp-settings.directoryHint' => 'Zum Beispiel /meinOrdner/meineBackups/',
    'backup.ftp-settings.ftpLogin' => 'FTP-Benutzername',
    'backup.ftp-settings.ftpPassword' => 'FTP-Passwort',
    'backup.ftp-settings.usePassiveMode' => 'Passivmodus verwenden',
    'backup.ftp-settings.useFtps' => 'FTPS verwenden',
    'backup.ftp-settings.errorHostIsLocal' => 'Die Verwendung des FTP-Servers des lokalen Plesk als Remote-Speicher ist nicht zulässig. Bitte geben Sie einen Remote-Standort an.',
    'backup.ftp-settings.warningHostIsLocal' => 'Die Einstellungen zum FTP(S)-Speicher wurden so konfiguriert, dass Backups auf demselben Server gespeichert werden, auf dem sich auch die Dateien Ihrer Abonnements befinden. Solch eine Konfiguration wird nicht empfohlen, da die Gefahr eines Datenverlustes und einer Speicherplatz-Überbeanspruchung besteht.',
    'backup.ftp-settings.enterFtpLogin' => 'Geben Sie einen korrekten Benutzernamen ein.',
    'backup.ftp-settings.enterFtpPassword' => 'Geben Sie ein korrektes Passwort ein.',

    'backup.remote-settings.isActive' => 'Speicher verwenden',
    'backup.remote-settings.initError' => 'Die Seite mit den Einstellungen für %%extName%% konnte nicht initialisiert werden: %%error%%',

    'backup.remote-storages.backupSecuritySettings' => 'Einstellungen zur Backupsicherheit',

    'backup.restore.detailsSection' => 'Details',
    'backup.restore.contentInfoSection' => 'Backup-Inhalt',
    'backup.restore.restorationOptionsSection' => 'Wiederherstellungsoptionen',
    'backup.restore.emailNotification' => 'Nach Abschluss der Wiederherstellung Benachrichtigung senden an',
    'backup.restore.comments' => 'Anmerkungen',
    'backup.restore.creationDate' => 'Erstellungsdatum',
    'backup.restore.systemNotes' => 'Systemhinweise',
    'backup.restore.ownerAdmin' => 'Erstellt vom Administrator.',
    'backup.restore.ownerReseller' => 'Erstellt von einem Reseller.',
    'backup.restore.ownerCustomer' => 'Erstellt von einem Kunden.',
    'backup.restore.ownerServiceUser' => 'Erstellt von einem zusätzlichen Benutzer.',
    'backup.restore.partOfParentBackup' => 'Teil des Backuptyps %%type%%.',
    'backup.restore.server' => 'Server',
    'backup.restore.reseller' => 'Reseller',
    'backup.restore.client' => 'Kunde',
    'backup.restore.incremental' => 'Inkrementell.',
    'backup.restore.multiVolume' => 'Auf mehreren Datenträgern.',
    'backup.restore.backupSize' => 'Backup-Größe',
    'backup.restore.backupSizeFirstIncremental' => '%%this%% (diese Ergänzung) + %%base%% (erstes Backup) = %%total%%',
    'backup.restore.backupSizeIncremental' => '%%this%% (diese Ergänzung) + %%prev%% (vorherige Ergänzungen) + %%base%% (erstes Backup) = %%total%%',
    'backup.restore.download' => 'Herunterladen',
    'backup.restore.downloadHint' => 'Laden Sie die Backupdatei auf Ihren lokalen Computer.',
    'backup.restore.downloadDisabled' => 'Das Herunterladen von Backupdateien ist temporär nicht möglich. Bitte versuchen Sie es später erneut oder wenden Sie sich an Ihren Service-Provider.',
    'backup.restore.copy' => 'In Serverspeicher kopieren',
    'backup.restore.copyHint' => 'Kopieren Sie die ausgewählten Backupdateien in den Serverspeicher.',
    'backup.restore.contentInfo' => 'Backup enthält',
    'backup.restore.restoreButton' => 'Wiederherstellen',
    'backup.restore.mail' => 'E-Mail',
    'backup.restore.domainConfiguration' => 'Domainkonfiguration',
    'backup.restore.virtualHost' => 'Inhalt des virtuellen Hosts',
    'backup.restore.database' => 'Datenbanken',
    'backup.restore.serverConfiguration' => 'Servereinstellungen',
    'backup.restore.serverConfigurationLicense' => 'Lizenzschlüssel',
    'backup.restore.serverPersonalConfiguration' => 'Konfiguration des Administratorkontos',
    'backup.restore.serverPersonalDomains' => 'Domains des Administrators',
    'backup.restore.serverPersonalClients' => 'Kunden des Administrators',
    'backup.restore.resellers' => 'Reseller',
    'backup.restore.resellerPersonalConfiguration' => 'Konfiguration des Reseller-Kontos',
    'backup.restore.resellerPersonalDomains' => 'Domains des Resellers',
    'backup.restore.resellerPersonalClients' => 'Kunden des Resellers',
    'backup.restore.clientPersonalConfiguration' => 'Konfiguration des Kundenkontos',
    'backup.restore.clientPersonalDomains' => 'Domains des Kunden',
    'backup.restore.restoreModifiedSection' => 'Backupdatei trotz fehlerhafter Signatur wiederherstellen',
    'backup.restore.restoreModifiedDump' => 'Backup wiederherstellen, auch wenn es keine gültige Signatur besitzt',
    'backup.restore.resolutionPolicy' => 'Konfliktlösungsrichtlinie',
    'backup.restore.resolutionPolicyDescription' => 'Zeitkonflikte treten auf, wenn das wiederhergestellte Objekt im System bereits mit einem neueren Änderungsdatum besteht oder wenn das wiederhergestellte Objekt im System momentan nicht vorhanden ist.',
    'backup.restore.backupRestoreFtpWrongPassword' => 'Das angegebene Passwort ist falsch. Die Backupdatei wird in den lokalen Speicher des Servers kopiert.',
    'backup.restore.backupRestoreLocalWrongPassword' => 'Das Backup kann nicht wiederhergestellt werden. Das angegebene Passwort ist falsch.',
    'backup.restore.serverContentAndConfiguration' => 'Serverkonfiguration und -inhalt',
    'backup.restore.serverConfigurationOnly' => 'Serverkonfiguration',
    'backup.restore.resellerContentAndConfiguration' => 'Konfiguration und Inhalt des Reseller-Kontos',
    'backup.restore.resellerConfigurationOnly' => 'Konfiguration des Reseller-Kontos',
    'backup.restore.clientContentAndConfiguration' => 'Konfiguration und Inhalte des Kundenkontos',
    'backup.restore.clientConfigurationOnly' => 'Konfiguration des Kundenkontos',
    'backup.restore.domainContentAndConfiguration' => 'Domainkonfiguration und Inhalt',
    'backup.restore.domainConfigurationOnly' => 'Domainkonfiguration',
    'backup.restore.restoreType' => 'Was möchten Sie wiederherstellen?',
    'backup.restore.restoreTypeFull' => 'Alle Objekte (gesamtes System)',
    'backup.restore.restoreTypeGranular' => 'Ausgewählte Objekte',
    'backup.restore.restoreObjectType' => 'Art des wiederherzustellenden Objekts',
    'backup.restore.restoreObjectTypeSubscriptions' => 'Abonnement',
    'backup.restore.restoreObjectTypeCustomers' => 'Kunde',
    'backup.restore.restoreObjectTypeResellers' => 'Reseller',
    'backup.restore.restoreObjectTypeMailUsers' => 'E-Mail-Konto',
    'backup.restore.restoreObjectTypeDatabases' => 'Datenbank',
    'backup.restore.restoreObjectTypeCertificates' => 'SSL/TLS-Zertifikate',
    'backup.restore.restoreObjectTypeSites' => 'Websites',
    'backup.restore.restoreObjectTypeDnsZones' => 'DNS-Zone',
    'backup.restore.restoreObjectTypeMailLists' => 'Mailinglisten',
    'backup.restore.restoreObjectTypeWebContent' => 'Dateien von Domains',
    'backup.restore.restoreObjects' => '%%objectType%%',
    'backup.restore.restoreObjectsWebContent' => 'Ausgewählte Dateien',
    'backup.restore.restoreSubscriptionLookup' => 'Abonnement',
    'backup.restore.restoreComponents' => 'Wiederherzustellende Komponenten',
    'backup.restore.errorLog' => 'Fehlerprotokoll',
    'backup.restore.backupDetailsLogDoesntExist' => 'Das Backupprotokoll ist nicht verfügbar.',
    'backup.restore.dumpFailedSection' => 'Fehlerprotokoll',
    'backup.restore.dumpFailed' => 'Ein Wiederherstellen der Daten ist nicht möglich: Die Backupdatei ist ungültig.',
    'backup.restore.granularNotSupported' => 'Sie können wiederherzustellende Objekte nur dann auswählen, wenn Sie Backups wiederherstellen wollen, die in Plesk 12.0 oder neuer erstellt wurden.',
    'backup.restore.fullNotSupportedInResellerPowerUser' => 'Die Wiederherstellung aller Daten aus den Backups wird in der Power-User-Ansicht für Reseller nicht unterstützt. Bitte wählen Sie die Objekte für die Wiederherstellung aus. Sie können die Ansicht Ihrer Benutzeroberfläche ändern in den %%interfaceLink%%',
    'backup.restore.interfaceLink' => 'Einstellungen zur Benutzeroberfläche',
    'backup.restore.contentRestoreType' => 'Wiederherstellen',
    'backup.restore.contentRestoreTypeSettingsOnly' => 'Nur die Konfiguration der ausgewählten Objekte',
    'backup.restore.contentRestoreTypeFull' => 'Konfiguration und Inhalte der ausgewählten Objekte',
    'backup.restore.errorWrongFormat' => 'Das Backup kann nicht wiederhergestellt werden: Die Datei enthält eine falsche Formatierung.',
    'backup.restore.errorContentError' => 'Nicht alle Daten können wiederhergestellt werden: Das Backup weist Inhaltsfehler auf.',
    'backup.restore.warningSignError' => 'Die Backup-Signatur kann nicht überprüft werden. Die Backupdatei wurde möglicherweise modifiziert, beschädigt, auf einem anderen Server oder in einer früheren Plesk Version erstellt.',
    'backup.restore.warningSignErrorNotAdmin' => 'Dieses Backup kann nur vom Plesk Administrator wiederhergestellt werden.',
    'backup.restore.warningPartial' => "Die folgenden Bestandteile des inkrementellen Backups wurden nicht gefunden:%%endl%%%%missedParts%%%%endl%%Möglicherweise werden nicht alle Dateien wiederhergestellt. Laden Sie die fehlenden Bestandteile hoch und versuchen Sie die Wiederherstellung erneut.",
    'backup.restore.warningDeprecatedBackupVersion' => 'Das Backup, das Sie wiederherzustellen versuchen, wurde in einer nicht unterstützten Plesk Version erstellt und kann nicht wiederhergestellt werden. Verwenden Sie die Plesk Migrator-Erweiterung, um Ihre Daten von alten Plesk Versionen zu übertragen.',
    'backup.restore.encryptionKeyError' => 'Die Passwörter für ein oder mehrere Konten in diesem Backup können nicht wiederhergestellt werden und werden zurückgesetzt. Möglicherweise wurde dieses Backup auf einem anderen Plesk Server erstellt und mit dessen Verschlüsselungscode verschlüsselt.',
    'backup.restore.errorCorruptedContent' => 'Die folgenden Dateien wurden nicht gefunden oder sind beschädigt: ',
    'backup.restore.statusSection' => 'Backupstatus',
    'backup.restore.statusDetails' => 'Statusdetails',
    'backup.restore.restoreBlocked' => 'Das Backup kann nicht wiederhergestellt werden.',
    'backup.restore.restoreBlockedDescription' => 'Der Backuptyp %%backupType%% kann derzeit nicht wiederhergestellt werden. Zur Wiederherstellung melden Sie sich als Backup-Inhaber an und klicken Sie auf den Namen des Backups im Backup-Manager.',

    'backup.schedule.scheduleSection' => 'Zeitplan',
    'backup.schedule.backupEnable' => 'Diese Backup-Aufgabe aktivieren',
    'backup.schedule.backupPeriod' => 'Ausführung der Backup-Aufgabe',
    'backup.schedule.on' => 'am',
    'backup.schedule.at' => 'um',
    'backup.schedule.useIncremental' => 'Inkrementelles Backup nutzen',
    'backup.schedule.fullBackupPeriod' => 'Vollständiges Backup durchführen',
    'backup.schedule.daily' => 'Täglich',
    'backup.schedule.weekly' => 'Wöchentlich',
    'backup.schedule.monthly' => 'Monatlich',
    'backup.schedule.yearly' => 'Jährlich',
    'backup.schedule.days' => 'Tage',
    'backup.schedule.weeks' => 'Wochen',
    'backup.schedule.months' => 'Monate',
    'backup.schedule.years' => 'Jahre',
    'backup.schedule.backupTimeDescription' => 'Zeitzone: %%timezone%%.',
    'backup.schedule.systemTimeZone' => 'Standardzeitzone des Systems',
    'backup.schedule.first' => 'erster',
    'backup.schedule.last' => 'letzter',
    'backup.schedule.dayOfMonth' => 'Tag',
    'backup.schedule.email' => 'Falls Fehler bei der Ausführung dieser Backup-Aufgabe auftreten, Benachrichtigungs-E-Mail senden an',
    'backup.schedule.invalidFields' => 'Einige Felder sind leer oder enthalten einen ungültigen Wert: %%fields%%.',
    'backup.schedule.maxDumpFiles' => 'Maximale Anzahl der Dateien, die für vollständige Backups gespeichert werden können (gilt sowohl für geplante als auch manuelle Backups)',
    'backup.schedule.maxDumpFilesUnlimitedDescription' => 'Wenn Sie vollständige Backups nicht automatisch entfernen lassen möchten, müssen Sie das Feld leer lassen.',
    'backup.schedule.maxDumpFilesLimitedDescription' => 'Der vom Hosting-Provider angegebene Grenzwert für Serverspeicher ist %%max%%. Ihr Grenzwert darf höchstens %%max%% sein.',
    'backup.schedule.backupToCloudIsNotAllowed' => 'Das Speichern von geplanten Abonnement-Backups in einem Remote-Speicher in der Cloud ist eine Premium-Funktion, die Sie im Plesk Online-Shop käuflich erwerben können.',

    'backup.secure-backup.hint' => 'Sie können die Benutzerpasswörter, die in einer gesicherten Plesk Datenbank enthalten sind, mit einem Passwort verschlüsseln. Beachten Sie, dass beim Wiederherstellen eines passwortgeschützten Backups ohne die Angabe des Passworts Benutzerpasswörter in Plesk zufällig generiert werden.',
    'backup.secure-backup.hintAdmin' => 'Sie können Passwörter für Plesk Datenbanken in Backups mit dem Plesk Verschlüsselungsschlüssel oder mit einem Passwort verschlüsseln. Der Schlüssel wird für jede Plesk Installation individuell erstellt. Backups, die mit diesem Schlüssel verschlüsselt werden, können nur in der Plesk Installation wiederhergestellt werden, in der sie erstellt wurden. Beachten Sie, dass die vertraulichen Daten in einem Backup nicht von Plesk geschützt werden. Wir empfehlen, Backups in Remote-Cloud-Speichern aufzubewahren und die Backup-Verschlüsselung im Cloud-Dienst zu aktivieren.',
    'backup.secure-backup.usePasswordProtection' => 'Passwortschutz verwenden (empfohlen)',
    'backup.secure-backup.backupPasswordSource' => 'Art des Passworts',
    'backup.secure-backup.pleskKey' => 'Plesk Verschlüsselungscode',
    'backup.secure-backup.userPassword' => 'Angegebenes Passwort',
    'backup.secure-backup.password' => 'Passwort',
    'backup.secure-backup.passwordConfirmation' => 'Passwort wiederholen',

    'backup.subform.settingsSection' => 'Backup-Einstellungen',
    'backup.subform.prefix' => 'Präfix an Backupnamen anfügen',
    'backup.subform.comment' => 'Anmerkungen',
    'backup.subform.splitSize' => 'Backup über mehrere Datenträger erstellen, Datenträgergröße (MB)',
    'backup.subform.repository' => 'Speichern in',
    'backup.subform.repositoryDescription' => 'Die FTP(S)-Speicher-Einstellungen sind nicht festgelegt. %%configure%%',
    'backup.subform.localAndSpecialRepositoryBackup' => 'Sowohl Serverspeicher als auch %%name%%',
    'backup.subform.remoteRepository' => 'Remote-Speicher',
    'backup.subform.remoteRepositoryText' => 'Remote-Speicher in der Cloud auswählen',
    'backup.subform.configureRemoteRepositories' => 'Sie können <a href="%%url%%">Remote-Speicher konfigurieren</a>, um Ihre Backups in der Cloud aufzubewahren.',
    'backup.subform.configureFtpRepository' => 'Sie können <a href="%%url%%">FTP-Speicher konfigurieren</a>, um Ihre Backups dort aufzubewahren.',
    'backup.subform.repositoryConfigure' => 'Konfigurieren',
    'backup.subform.email' => 'Benachrichtigungs-E-Mail nach Abschluss einer Backup-Aufgabe senden an',
    'backup.subform.contentSection' => 'Backup-Inhalt',
    'backup.subform.domainConfiguration' => 'Konfiguration',
    'backup.subform.domainConfigurationVhost' => 'Benutzerdateien und -datenbanken',
    'backup.subform.domainConfigurationMail' => 'E-Mail-Nachrichten',
    'backup.subform.content' => 'Backup von',
    'backup.subform.backupAll' => 'Gesamte Konfiguration und gesamter Inhalt',
    'backup.subform.backupConfiguration' => 'Nur Konfiguration',
    'backup.subform.backupVhost' => 'Gesamte Konfiguration und gesamter Inhalte außer E-Mail-Nachrichten',
    'backup.subform.backupMail' => 'Nur Konfiguration und E-Mail-Nachrichten',
    'backup.subform.mssqlNativeBackup' => 'Native MS-SQL-Backup-Funktionalität nutzen, wenn möglich',
    'backup.subform.mssqlNativeBackupAdmin' => 'Native MS-SQL-Backup-Funktionalität verwenden (bei Remote-Datenbanken müssen Sie sichergehen, dass Sie die Backup-Einstellungen des Remote-MSSQL-Servers unter Tools & Einstellungen >  Datenbankserver konfiguriert haben)',
    'backup.subform.localRepository' => 'Serverspeicher',
    'backup.subform.localRepositoryPath' => 'Serverspeicher unter %%path%%',
    'backup.subform.backupNodeRepository' => '',
    'backup.subform.ftpRepository' => 'FTP(S)-Speicher unter %%uri%% <a href="%%link%%">Einstellungen ändern</a>',
    'backup.subform.ftpRepositoryText' => 'FTP(S)-Speicher unter %%uri%%',
    'backup.subform.type' => 'Typ',
    'backup.subform.typeFullBackup' => 'Vollständig',
    'backup.subform.typeIncremental' => 'Inkrementell',
    'backup.subform.typeIncrementalDescription' => 'Sichern Sie Web- und E-Mail-Hosting-Daten, die seit dem letzten Backup geändert wurden (Datenbankdaten werden immer vollständig gesichert).',
    'backup.subform.incrementalNotAvailable' => 'Um inkrementelle Backups erstellen zu können, müssen Sie zuerst ein vollständiges Backup erstellen.',
    'backup.subform.excludeLogs' => 'Protokolldateien ausschließen',
    'backup.subform.excludeFiles' => 'Bestimmte Dateien vom Backup ausschließen',
    'backup.subform.excludeFilesDescription' => 'Sie können nur Dateien innerhalb des Webspace ausschließen. Geben Sie den Pfad oder die Pfade zum Webspace-Stamm an. Trennen Sie einzelne Dateien mit Kommas. Sie können Asteriske verwenden (z. B. /verzeichnis/log*).',

    'backup.upload.uploadHint' => 'Hier können Sie Backupdateien zum Plesk Speicher hochladen. Die maximale Größe einer Datei ist auf zwei Gigabyte begrenzt.',
    'backup.upload.backupFile' => 'Backupdatei',
    'backup.upload.removeLink' => 'Entfernen',
    'backup.upload.addFileLink' => 'Weitere Dateien hochladen',
    'backup.upload.backupSecuritySettings' => 'Einstellungen zur Backupsicherheit',
    'backup.upload.signatureHint' => 'Plesk überprüft Backupdateien auf eine gültige Struktur und Signatur. Dateien, die modifiziert, beschädigt oder auf einem anderen Server erstellt wurden, wird nicht vertraut. Die unten stehende Option ermöglicht Ihnen, Daten aus solchen Dateien wiederherzustellen. Wählen Sie diese Option nur aus, wenn Sie der Backupquelle vertrauen, denn durch das Hochladen einer solchen Datei kann die Sicherheit oder der Betrieb des Servers beeinträchtigt werden. Hinweis: Backupdateien, die in Plesk Versionen vor 11.5 erstellt wurden, werden als nicht vertrauenswürdig eingestuft, da sie keine Signaturen besitzen. Stellen Sie solche Dateien wieder her, wenn Sie deren Quelle vertrauen.',
    'backup.upload.ignoreSign' => 'Backupdatei ohne gültige Signatur hochladen',
    'backup.upload.passwordHint' => 'Wenn Sie dieses Backup mit einem Passwortschutz erstellt haben, geben Sie bitte das Passwort in den nachfolgenden Feldern ein. Beachten Sie, dass Plesk Sie zwar warnen wird, wenn Sie ein falsches Passwort eingeben, jedoch das Backup trotzdem zum Server hochlädt. Während der Backupwiederherstellung werden Sie aufgefordert, das Passwort erneut einzugeben.',
    'backup.upload.alreadyExistsWarning' => 'Die Backupdatei %%fileName%% ist bereits im lokalen Speicher des Servers vorhanden.',
    'backup.upload.incorrectPasswordWarning' => 'Das angegebene Passwort ist falsch. Während der Backupwiederherstellung werden Sie von Plesk aufgefordert, das Passwort erneut einzugeben.',
    'backup.upload.deprecatedDumpError' => 'Das Backup, das Sie versuchen hochzuladen, wurde in einer nicht unterstützten Plesk Version erstellt und kann nicht importiert werden. Verwenden Sie die Plesk Migrator-Erweiterung, um Ihre Daten von alten Plesk Versionen zu übertragen.',
    'backup.upload.mailFormatWarning' => 'Die Backupdatei %%fileName%% wurde in den Speicher hochgeladen. Wichtig: Die Backupdatei %%fileName%% enthält E-Mail-Content, der nicht wiederhergestellt werden kann, da sein Format (Plesk 8.3 - 8.6) nicht unterstützt wird. Um diesen E-Mail-Content wiederherstellen zu können, müssen Sie ein Backup dieses Contents mit dem Plesk Backup-Tool erstellen, dann die Option "Backup des Postfachinhalts erstellen" auswählen und anschließend die Option "Mit auf beliebigem Mailserver wiederhergestelltem Dump".',
    'backup.upload.corruptedSignatureAdminWarning' => 'Die hochgeladene Backupdatei (%%fileName%%) wurde modifiziert, beschädigt, auf einem anderen Server erstellt oder in einer älteren Plesk Version erstellt, die das Signieren von Backups nicht unterstützt. Bevor Sie Daten aus dieser Backupdatei wiederherstellen, sollten Sie sich vergewissern, dass Sie der Quelle dieser Datei vertrauen können.',
    'backup.upload.corruptedSignatureAdminError' => 'Die Backupdatei (%%fileName%%) kann nicht hochgeladen werden. Die Datei wurde modifiziert, beschädigt, auf einem anderen Server erstellt oder in einer älteren Plesk Version erstellt, die das Signieren von Backups nicht unterstützt. Wenn Sie diesem Backup vertrauen, wählen Sie die Option "Backupdatei ohne gültige Signatur hochladen" und laden Sie sie erneut hoch.',
    'backup.upload.corruptedSignatureUserWarning' => 'Die hochgeladene Backupdatei (%%fileName%%) enthält entweder modifizierte bzw. beschädigte Dateien oder wurde auf einem anderen Server bzw. in einer älteren Plesk Version erstellt.',
    'backup.upload.corruptedSignatureUserError' => 'Die Backupdatei (%%fileName%%) kann nicht hochgeladen werden. Die Datei enthält entweder modifizierte oder beschädigte Dateien, oder wurde auf einem anderen Server oder in einer älteren Plesk Version erstellt. Wenden Sie sich an Ihren Hosting-Provider, um Daten aus dieser Datei wiederherstellen zu lassen.',
    'backup.upload.uploadError' => '%%fileName%% kann nicht in den Serverspeicher hochgeladen werden: %%error%%',
    'backup.upload.fileNotSelected' => 'Es wurden keine Dateien zum Hochladen ausgewählt. Wählen Sie mindestens eine Datei aus.',
    'backup.upload.missedPartsWarning' => "Die folgenden Bestandteile des inkrementellen Backups wurden nicht hochgeladen:%%endl%%%%missedParts%%%%endl%%Bitte laden Sie die fehlenden Bestandteile hoch.",
    'backup.upload.unknownType' => 'Unbekannter Objekttyp',
    'backup.upload.storageLink' => 'einen anderen Speicher',
    'backup.upload.anotherStorage' => 'Das Abbild wurde in %%storageLink%% hochgeladen.',
    'backup.upload.resellerNotFound' => 'Der Reseller %%name%% wurde nicht gefunden. Sie müssen ihn zuerst erstellen, um das hochgeladene Abbild wiederherstellen zu können.',
    'backup.upload.clientNotFound' => 'Der Kunde %%name%% wurde nicht gefunden. Sie müssen ihn zuerst erstellen, um das hochgeladene Abbild wiederherstellen zu können.',
    'backup.upload.domainNotFound' => 'Die Domain %%name%% wurde nicht gefunden. Sie müssen sie zuerst erstellen, um das hochgeladene Abbild wiederherstellen zu können.',

    'backup.web-content-dynamic.addButtonTitle' => 'Dateien hinzufügen',
    'backup.web-content-dynamic.noItems' => 'Keine Dateien ausgewählt',
    'backup.web-content-dynamic.hint' => 'Nutzen Sie die Kontrollkästchen, um Dateien und Ordner auszuwählen.',
    'backup.web-content-dynamic.title' => 'Dateien auswählen',
    'backup.web-content-dynamic.columnName' => 'Name',
    'backup.web-content-dynamic.columnChangeDate' => 'Geändert',
    'backup.web-content-dynamic.columnSize' => 'Größe',
    'backup.web-content-dynamic.columnPermissions' => 'Berechtigungen',
    'backup.web-content-dynamic.columnUser' => 'Benutzer',
    'backup.web-content-dynamic.columnGroup' => 'Gruppe',
    'backup.web-content-dynamic.waitButtonTitle' => 'Bitte warten',
    'backup.web-content-dynamic.loadingTitle' => 'Bitte warten. Wird geladen...',

    'backup.invalidFields' => 'Einige Felder sind leer oder enthalten einen ungültigen Wert.',
    'backup.notEnoughDiskSpace' => 'Für das Erstellen des Backups ist nicht genügend Speicherplatz unter %%path%% vorhanden. Mindestens %%required%% GB freier Speicher ist erforderlich (%%available%% GB verfügbar)',

    'cgroups-settings.cgroupsSettingsTab' => 'RAM, CPU, Datenträger-E/A',
    'cgroups-settings.cgroupsSettingsTabDescription' => 'Legen Sie Grenzwerte für den Verbrauch von Systemressourcen durch ein Abonnement fest. In Plesk wird eine Linux-Kernelfunktion namens Kontrollgruppe (cgroups) verwendet, um sicherzustellen, dass die Grenzwerte nicht überschritten werden.',
    'cgroups-settings.cpuSettings' => 'CPU',
    'cgroups-settings.cpuSettingsDescription' => 'Legen Sie für einzelne Abonnements bestimmte Grenzwerte für die CPU-Nutzung fest.',
    'cgroups-settings.cpuPeriodLimit' => 'Zeitraum für die Überprüfung der CPU-Auslastung',
    'cgroups-settings.percentUsageDescription' => 'Die CPU-Zeit insgesamt entspricht %%total%% %%units%% für Ihren Server.',
    'cgroups-settings.ramSettings' => 'RAM',
    'cgroups-settings.ramSettingsDescription' => 'Legen Sie für einzelne Abonnements bestimmte Grenzwerte für die RAM-Nutzung fest. Beachten Sie, dass bei Überschreitung des Grenzwerts im Abonnement der Prozess angehalten wird, der am meisten verbraucht.',
    'cgroups-settings.ramPeriodLimit' => 'Zeitraum für die Überprüfung der RAM-Nutzung',
    'cgroups-settings.diskSettings' => 'Datenträger-E/A',
    'cgroups-settings.diskReadSettings' => 'Lesen auf Datenträger',
    'cgroups-settings.diskReadSettingsDescription' => 'Grenzen Sie die verfügbare Bandbreite zum Lesen auf dem Datenträger für einzelne Abonnements ein.',
    'cgroups-settings.diskReadPeriodLimit' => 'Zeitraum für die Überprüfung der Auslastung des Datenträgerlesevorgangs',
    'cgroups-settings.diskWriteSettings' => 'Schreiben auf Datenträger',
    'cgroups-settings.diskWriteSettingsDescription' => 'Grenzen Sie die verfügbare Bandbreite zum Schreiben auf dem Datenträger für einzelne Abonnements ein.',
    'cgroups-settings.diskWritePeriodLimit' => 'Zeitraum für die Überprüfung der Auslastung des Datenträgerschreibvorgangs',
    'cgroups-settings.limit' => 'Grenzwert',
    'cgroups-settings.threshold' => 'Benachrichtigung erhalten, wenn Grenzwert überschritten wird',
    'cgroups-settings.limitNotificationEnabled' => 'Benachrichtigung aktiviert',
    'cgroups-settings.periodFiveMinutes' => '5 Minuten',
    'cgroups-settings.periodHour' => '1 Stunde',
    'cgroups-settings.periodDay' => '1 Tag (24 Stunden)',
    'cgroups-settings.mb' => 'MB',
    'cgroups-settings.mbs' => 'MB/s',

    'custom-button.privateLabel' => 'Nur mir anzeigen',
    'custom-button.textLabel' => 'Schaltflächenbeschriftung',
    'custom-button.tooltipLabel' => 'Tooltip-Text',
    'custom-button.iconLabel' => 'Hintergrundbild',
    'custom-button.priorityLabel' => 'Priorität',
    'custom-button.urlLabel' => 'URL',
    'custom-button.urlParamsLabel' => 'Parameter zur URL hinzufügen',
    'custom-button.placeLabel' => 'Ort',
    'custom-button.internalLabel' => 'URL in Plesk öffnen',
    'custom-button.internalDescription' => 'Geben Sie an, ob die URL auf einer Plesk Seite geöffnet werden soll oder in einem neuen Browserfenster.',
    'custom-button.noFrameLabel' => 'Keinen Rahmen verwenden',
    'custom-button.noFrameDescription' => 'Wenn Sie eine benutzerdefinierte Schaltfläche hinzufügen, die zu einer Plesk Erweiterung oder einer App im Kunden-Panel führt, können Sie angeben, wie diese Erweiterung/App angezeigt werden soll: in einem Frame oder als Teil der Plesk Benutzeroberfläche.',
    'custom-button.urlParamLabel_dom_id' => 'Abonnement-ID, Domain-ID und Domain-Alias-ID einschließen',
    'custom-button.urlParamLabel_dom_name' => 'Primären Domainnamen einfügen',
    'custom-button.urlParamLabel_ftp_user' => 'FTP-Benutzername einfügen',
    'custom-button.urlParamLabel_ftp_pass' => 'FTP-Passwort einschließen',
    'custom-button.urlParamLabel_cl_id' => 'Kunden-ID einfügen',
    'custom-button.urlParamLabel_cname' => 'Firmennamen des Kunden einfügen',
    'custom-button.urlParamLabel_pname' => 'Name des Kundenkontakts einfügen',
    'custom-button.urlParamLabel_email' => 'E-Mail-Adresse des Kunden einfügen',
    'custom-button.buttonPlace_navigation' => 'Für alle zugänglich',
    'custom-button.buttonPlace_admin' => 'Administrator-Startseite',
    'custom-button.buttonPlace_admin-settings' => 'Seite "Tools & Einstellungen" des Administrators',
    'custom-button.buttonPlace_reseller' => "Startseite des Resellers",
    'custom-button.buttonPlace_reseller-settings' => 'Seite "Tools & Dienstprogramme" für Reseller',
    'custom-button.buttonPlace_client' => 'Startseite des Kunden',
    'custom-button.buttonPlace_domain' => "Seite \"Websites & Domains\" des Abonnements",
    'custom-button.buttonPlace_domain_powerUser' => "Seite \"Websites & Domains\" des Webspace",
    'custom-button.buttonPlace_domain-properties' => 'Website-Tools',

    'domain.connection-info.title' => 'Informationen zur Verbindung',
    'domain.connection-info.systemUserCredentials' => 'Anmeldedaten für Systembenutzer',
    'domain.connection-info.systemUserCredentialsHint' => 'Zugriff via FTP ist immer aktiviert, Zugriff über SSH oder Remotedesktop jedoch nur, wenn die %%details%%.',
    'domain.connection-info.systemUserCredentialsHintDetails' => 'Berechtigung gegeben wird',
    'domain.connection-info.systemUserRemoveAccessEnabled' => 'Ihr Zugriff über SSH oder Remotedesktop ist aktiviert und Sie können den Status nicht bearbeiten.',
    'domain.connection-info.systemUserRemoveAccessDisabled' => 'Ihr Zugriff über SSH oder Remotedesktop ist deaktiviert und Sie können den Status nicht bearbeiten.',
    'domain.connection-info.ipAddress' => 'IP-Adresse',
    'domain.connection-info.copyToClipboard' => 'In die Zwischenablage kopieren',
    'domain.connection-info.username' => 'Benutzername',
    'domain.connection-info.password' => 'Passwort',
    'domain.connection-info.changeSystemUserPasswordTitle' => 'Ändern des Systembenutzerpassworts',
    'domain.connection-info.changePasswordTooltip' => 'Passwort ändern',
    'domain.connection-info.newPassword' => 'Neues Passwort',
    'domain.connection-info.manageAccess' => 'Zugriff verwalten',
    'domain.connection-info.additionalFtpAccounts' => 'Zusätzliche FTP-Konten',
    'domain.connection-info.database' => 'Datenbank',
    'domain.connection-info.databaseHint' => '1 von %%number%% Datenbanken, die zu diesem Abonnement gehören.',
    'domain.connection-info.databaseNotCreatedHint' => 'Datenbank wurde nicht erstellt.',
    'domain.connection-info.databaseType.mysql' => 'MySQL',
    'domain.connection-info.databaseType.mssql' => 'MS SQL Server',
    'domain.connection-info.databaseType.postgresql' => 'PostgreSQL',
    'domain.connection-info.databaseType.mariadb' => 'MariaDB',
    'domain.connection-info.databaseType.percona' => 'Percona',
    'domain.connection-info.databaseHost' => 'Host',
    'domain.connection-info.databaseHostValue' => '%%value%% (%%fork%%)',
    'domain.connection-info.databaseName' => 'Datenbankname',
    'domain.connection-info.addDatabase' => 'Datenbank hinzufügen',
    'domain.connection-info.manageDatabases' => 'Datenbanken verwalten',
    'domain.connection-info.phpMyAdmin' => 'phpMyAdmin',
    'domain.connection-info.myLittleAdmin' => 'myLittleAdmin',
    'domain.connection-info.changeDatabaseUserPasswordTitle' => 'Ändern des Passworts des Datenbankbenutzers',
    'domain.connection-info.changeDatabaseUserPasswordNotice' => 'Vergessen Sie nicht, das Passwort in den Konfigurationsdateien Ihrer Anwendung anzupassen, nachdem Sie es hier geändert haben.',
    'domain.connection-info.buttonSave' => 'Speichern',
    'domain.connection-info.buttonSaving' => 'Wird gespeichert...',
    'domain.connection-info.buttonCancel' => 'Abbrechen',

    'domain.move.title' => 'Domain %%name%% verschieben',
    'domain.move.hint' => 'Die Domain (Inhalt, Konfigurationsdateien, Protokolldateien und APS-Anwendungen) wird in ein neues Abonnement verschoben.',
    'domain.move.hintMain' => 'Die Domain wird in ein neues Abonnement verschoben. Davon betroffen sind der komplette Inhalt, Konfigurationsdateien, Protokolldateien, Datenbanken, Datenbankbenutzer, zusätzliche FTP-Benutzer, geplante Aufgaben, SMB-Benutzer und APS-Anwendungen.',
    'domain.move.hintSubdomains' => 'Die Subdomains %%subdomains%% werden zusammen mit der übergeordneten Domain verschoben.',
    'domain.move.hintAliases' => 'Die Domain-Aliasse %%aliases%% werden zusammen mit der übergeordneten Domain verschoben.',
    'domain.move.hintSubdomainsAndAliases' => 'Die Subdomains %%subdomains%% und Domain-Aliasse %%aliases%% werden zusammen mit der übergeordneten Domain verschoben.',
    'domain.move.labelDatabases' => 'Nachdem Sie die Domain verschoben haben, öffnen Sie den Tab "Datenbanken", um verknüpfte Datenbanken zu verschieben.',
    'domain.move.hintDatabases' => 'Verschieben Sie die Datenbanken falls notwendig separat.',

    'domain.move.Form.submitButton' => 'Verschieben',
    'domain.move.Form.cancelButton' => 'Abbrechen',

    'domain.move.selectTarget' => 'Verfügbare Abonnements',
    'domain.move.nothingFound' => 'Nichts gefunden',
    'domain.move.targetIsRequred' => 'Wählen Sie das Abonnement aus, in das die Domain verschoben werden soll.',
    'domain.move.selectNewSubscription' => 'Neues Abonnement',
    'domain.move.ipv4Address' => 'IPv4-Adresse',
    'domain.move.ipv4AddressHint' => 'Die IP-Adresse, auf der die Website gehostet wird, ist eine Netzwerkadresse des virtuellen Hosts der Website.',
    'domain.move.ipv6Address' => 'IPv6-Adresse',
    'domain.move.ipv6AddressHint' => 'Die IP-Adresse, auf der die Website gehostet wird, ist eine Netzwerkadresse des virtuellen Hosts der Website.',
    'domain.move.ipAddressIsNotSelected' => 'Es muss mindestens eine IP-Adresse ausgewählt werden.',
    'domain.move.username' => 'Benutzername',
    'domain.move.usernameHint' => 'Das Systembenutzerkonto, das mit dem Webspace verknüpft ist. Wird für den Zugriff auf die gehosteten Dateien via FTP und SSH verwendet.',
    'domain.move.usernameIsRequred' => 'Bitte geben Sie einen Benutzernamen an.',
    'domain.move.password' => 'Passwort',
    'domain.move.passwordIsRequred' => 'Bitte geben Sie ein Passwort an.',
    'domain.move.noAvailableSubscriptions' => 'Keine verfügbaren Abonnements',
    'domain.move.noWebHosting' => 'Es wird kein Systembenutzer erstellt, da die Domain kein Webhosting hat.',

    'domain.rename.title' => 'Domainnamen ändern',
    'domain.rename.titleAlias' => 'Namen des Domainalias ändern',
    'domain.rename.hint' => 'Sie ändern jetzt den Domainnamen %%domainName%%',
    'domain.rename.hintAlias' => 'Sie ändern jetzt den Namen des Domainalias %%domainName%%',
    'domain.rename.name' => 'Neuer Domainname',
    'domain.rename.nameAlias' => 'Neuer Name des Domainalias',
    'domain.rename.domainNameIsRequired' => 'Dieses erforderliche Feld ist leer. Sie müssen einen Wert angeben.',
    'domain.rename.submitButton' => 'Ändern',
    'domain.rename.submitButtonProgress' => 'Ändern',
    'domain.rename.successMessage' => 'Domainname %%oldName%% wurde in %%newName%% geändert.',
    'domain.rename.successMessageAlias' => 'Name des Domainalias %%oldName%% wurde in %%newName%% geändert.',

    'domain.rename.Form.cancelButton' => 'Abbrechen',

    'domain.outgoing-messages.hint' => 'Hier können Sie die Grenze für die Anzahl an ausgehenden Nachrichten für diese Domain ändern. Es wird nicht möglich sein, mehr Nachrichten als hier angegeben zu senden.',
    'domain.outgoing-messages.domainOutgoingMessagesSubscriptionDefault' => 'Standard (%%domainOutgoingMessages%% Nachrichten pro Stunde)',
    'domain.outgoing-messages.domainOutgoingMessagesSpecificHint' => 'Nachrichten pro Stunde',
    'domain.outgoing-messages.domainOutgoingMessages' => 'Grenze für ausgehende Nachrichten',
    'domain.outgoing-messages.domainOutgoingMessagesCustomLimit' => 'Benutzerdefinierter Wert für diese Domain',

    'domain.tech-domain-name.title' => 'Domainnamen auswählen',
    'domain.tech-domain-name.techDomainTitle' => 'Temporärer Domainname',
    'domain.tech-domain-name.customDomainTitle' => 'Registrierter Domainname',
    'domain.tech-domain-name.techDomainText' => 'Ich habe noch keinen registrierten Domainnamen',
    'domain.tech-domain-name.customDomainText' => 'Ich habe einen registrierten Domainnamen',
    'domain.tech-domain-name.techDomain' => 'Ihr temporärer Domainname',
    'domain.tech-domain-name.customDomain' => 'Registrierter Domainname',
    'domain.tech-domain-name.domainName' => 'Domainname',
    'domain.tech-domain-name.techDomainDesc' => 'Temporäre Domainnamen werden für den Zugriff auf Ihre Website verwendet, bevor Sie einen eigenen Domainnamen kaufen und registrieren lassen. Vorübergehende Domainnamen werden unter den folgenden Bedingungen kostenlos zur Verfügung gestellt:',
    'domain.tech-domain-name.techDomainRandom' => 'Die Namen werden nach dem Zufallsprinzip generiert.',
    'domain.tech-domain-name.techDomainDns' => 'Die Domainnamen werden in der DNS-Zone ".plesk.page" gehostet.',
    'domain.tech-domain-name.techDomainSwitch' => 'Sie können später jederzeit zu einem registrierten Domainnamen wechseln, indem Sie Ihre Domain in den Domaineinstellungen umbenennen.',
    'domain.tech-domain-name.error' => 'Ein unerwarteter Fehler ist aufgetreten.',
    'domain.tech-domain-name.errorNoIpAddress' => 'Sie müssen die IP-Adresse auswählen.',
    'domain.tech-domain-name.generating' => 'Wird erstellt...',

    'get-password.label' => 'Passwort zurücksetzen',
    'get-password.text' => 'Geben Sie Ihre in Plesk registrierte E-Mail-Adresse oder Ihren Benutzernamen ein. Sie erhalten dann eine E-Mail zum Zurücksetzen des Passworts.',
    'get-password.emailLabel' => 'E-Mail-Adresse',
    'get-password.loginLabel' => 'Benutzername',
    'get-password.send' => 'Senden',
    'get-password.cancel' => 'Abbrechen',
    'get-password.errorInvalidEmail' => 'Die E-Mail-Adresse wurde nicht erkannt. Bitte überprüfen Sie die Angabe und versuchen Sie es erneut.',
    'get-password.messageSend' => "Die E-Mail zum Zurücksetzen des Passworts wurde an die zugehörige E-Mail-Adresse gesendet.\nWenn die E-Mail nicht ankommt, wenden Sie sich bitte an Ihren Plesk Administrator.",

    'iis-settings.formGeneralHint' => 'Hier können Sie die IIS-Webserver-Einstellungen für Ihre Website angeben, indem Sie die Standardwerte ändern. Eine benutzerdefinierte IIS-Konfiguration ist zum Beispiel dann nützlich, wenn Sie einen neuen Typ von Indexdateien auf Ihrer Website verwenden wollen oder einen bestimmten MIME-Typ mit bestimmten Dateinamenerweiterungen verbinden möchten. Die Standardwerte werden von Ihrem Hosting-Provider bestimmt.',
    'iis-settings.formGeneralHint_powerUser' => 'Hier können Sie die IIS-Webserver-Einstellungen für diese Website angeben. Eine benutzerdefinierte IIS-Konfiguration ist zum Beispiel dann nützlich, wenn Sie einen neuen Typ von Indexdateien auf Ihrer Website verwenden wollen oder einen bestimmten MIME-Typ mit bestimmten Dateinamenerweiterungen verbinden möchten. Die Standardwerte bedeuten, dass IIS die entsprechenden Anweisungen aus seiner Standardkonfiguration verwenden wird.',
    'iis-settings.virtualDirectoryLoadError' => 'Die Eigenschaften des angegebenen virtuellen Verzeichnisses können nicht abgerufen werden: %%errorMessage%%',
    'iis-settings.general' => 'Allgemeine Einstellungen',
    'iis-settings.example' => "Zum Beispiel:\n%%example%%",
    'iis-settings.settingOn' => 'Ein',
    'iis-settings.settingOff' => 'Aus (Standard)',
    'iis-settings.settingDefault' => 'Standard',
    'iis-settings.settingCustom' => 'Eigenen Wert eingeben',
    'iis-settings.mimeTypes' => 'MIME-Typen',
    'iis-settings.mimeTypesExample' => "text/plain .mytxt\nimage/jpeg .myjpeg \n\nMIME-Typen ordnen Dateierweiterungen Dateitypen zu. Dies wird üblicherweise verwendet, um benutzerdefinierte Dateierweiterungen für gängige Dateitypen zu erstellen.",
    'iis-settings.documents' => 'Standarddokumente',
    'iis-settings.documentsOff' => 'Deaktiviert',
    'iis-settings.documentsCustom' => 'Werte eingeben',
    'iis-settings.documentsExample' => "Index.html\nIndex.htm\nIndex.cfm \n\nWenn Browser den Namen eines Dokuments innerhalb Ihrer Website nicht bereitstellen, sucht IIS nach den angegebenen Standarddokumenten und bedient das erste, das gefunden wird. Falls Sie die Standarddokumente nicht angeben, aber die Verzeichnissuche einschalten, wird in den Browsern eine Auflistung der Verzeichnisse anstatt der Indexseite angezeigt.",
    'iis-settings.expires' => 'Ablaufdatum',
    'iis-settings.expiresDescription' => 'Der Webserver fügt die Antwortheader "Ablaufdatum" zu Webpages hinzu. Zur Berechnung des Zeitstempels für das Ablaufdatum wird die oben genannte Dauer zum Zeitpunkt hinzugefügt, an dem eine Webpage angefordert wird.',
    'iis-settings.expiresUnitDays' => 'Tage',
    'iis-settings.expiresUnitHours' => 'Stunden',
    'iis-settings.expiresUnitMinutes' => 'Minuten',
    'iis-settings.expiresUnitSeconds' => 'Sekunden',
    'iis-settings.headers' => 'Zusätzliche Header',
    'iis-settings.headersExample' => "Cache-Control: public Strict-Transport-Security: max-age=63072000; includeSubdomains; X-Frame-Options: DENY Die angegebenen HTTP-Antwortheader werden vom Webserver hinzugefügt.",
    'iis-settings.directoryBrowsing' => 'Verzeichnissuche',
    'iis-settings.directoryBrowsingDescription' => 'Lassen Sie zu, dass Nutzer eine Verzeichnisauflistung der Website in Webbrowsern sehen können, z. B. wenn die Standard-Indexseite nicht verfügbar ist.',
    'iis-settings.securityTabDirectory' => 'Verzeichnissicherheit',
    'iis-settings.allowAnonymous' => 'Anonyme Authentifizierung',
    'iis-settings.allowAnonymousDescription' => 'Die anonyme Authentifizierung ermöglicht Nutzern, auf den öffentlichen Content Ihrer Website zuzugreifen. Nicht zugänglich für anonyme Nutzer ist der passwortgeschützte Content Ihrer Website sowie der Content, der auf Dateisystemebene geschützt ist.',
    'iis-settings.allowWindows' => 'Windows Authentifizierung',
    'iis-settings.allowWindowsDescription' => 'Die Windows Authentifizierung (ehemals "NTLM") schützt den Content Ihrer Website auf Dateisystemebene.',
    'iis-settings.requireSsl' => 'SSL/TLS erforderlich',
    'iis-settings.requireSslDescription' => 'Wenn Sie die Unterstützung von SSL/TLS für Ihre Website aktiviert haben und diese Option auswählen, dürfen Webclients (Browser) nur sichere HTTPS-Verbindungen verwenden.',
    'iis-settings.securityTabIpDeny' => 'Zugriffsbeschränkung',
    'iis-settings.deny' => 'Zugriff auf Website verweigern',
    'iis-settings.denyOff' => 'Standard',
    'iis-settings.denyCustom' => 'Benutzerdefinierten Wert eingeben',
    'iis-settings.allow' => 'Ausnahmen',
    'iis-settings.denyExample' => "10.1.0.0/16\n192.168.1.110\n\nDen angegebenen Hosts und Netzwerken ist untersagt, auf die Website zuzugreifen. Verwenden Sie '*', um alle Verbindungen abzulehnen.",
    'iis-settings.allowExample' => "192.168.0.0/16\n10.1.1.21\n\nDie angegebenen Hosts und Netzwerke dürfen auf die Website zugreifen.",
    'iis-settings.dynamicIpSecurity' => 'Verhindern von DoS-Angriffen durch dynamische IP-Einschränkung von IIS',
    'iis-settings.isDenyByConcurrentRequests' => 'IP-Adressen ablehnen basierend auf der Anzahl an gleichzeitigen von einer einmaligen IP-Adresse ausgehenden Anfragen',
    'iis-settings.maxConcurrentRequests' => 'Maximale Anzahl an gleichzeitigen Anfragen',
    'iis-settings.isDenyByRequestRate' => 'IP-Adressen ablehnen basierend auf der Anzahl von Anfragen über einen Zeitraum',
    'iis-settings.maxRequests' => 'Maximale Anzahl an Anfragen',
    'iis-settings.requestInterval' => 'Zeitraum (in Millisekunden)',

    'ip-addresses-selector.ipAddress' => 'IP-Adresse',
    'ip-addresses-selector.ipv4Address' => 'IPv4-Adresse',
    'ip-addresses-selector.ipv4AddressHint' => "Die IP-Adresse, auf der die Website gehostet wird, ist eine Netzwerkadresse des virtuellen Hosts der Website.",
    'ip-addresses-selector.ipv6Address' => 'IPv6-Adresse',
    'ip-addresses-selector.ipv6AddressHint' => "Die IP-Adresse, auf der die Website gehostet wird, ist eine Netzwerkadresse des virtuellen Hosts der Website.",
    'ip-addresses-selector.noIpAddressHint' => 'Keine Angabe',
    'ip-addresses-selector.shared' => 'gemeinsam genutzt',
    'ip-addresses-selector.exclusive' => 'dediziert',
    'ip-addresses-selector.ipV6OnlyNotSupported' => 'Der FTP-Server unterstützt kein IPv6 .Weisen Sie mindestens eine IPv4-Adresse zu, andernfalls wird der Benutzer nicht in der Lage sein, Dateien auf den Server via FTP hochzuladen.',

    'log-rotation.customLogsDescription' => 'Beachten Sie, dass Ihre benutzerdefinierten Protokolle nicht rotiert wurden.',
    'log-rotation.logRotation' => 'Protokoll-Rotation',
    'log-rotation.logRotationCondition' => 'Bedingung für Protokoll-Rotation',
    'log-rotation.logRotationBySize' => 'Nach Größe',
    'log-rotation.logRotationByTime' => 'Nach Zeit',
    'log-rotation.logRotationDaily' => 'Täglich',
    'log-rotation.logRotationWeekly' => 'Wöchentlich',
    'log-rotation.logRotationMonthly' => 'Monatlich',
    'log-rotation.logRotationSizeDescription' => 'Der Wert für die Größe muss zwischen %%min%% und %%max%% KB liegen.',
    'log-rotation.maximumNumberOfFiles' => 'Maximale Anzahl an Protokolldateien',
    'log-rotation.compress' => 'Protokolldateien komprimieren',
    'log-rotation.sendLogToEmail' => 'Nachdem Plesk die Daten aus den Protokolldateien von Web- oder FTP-Servern abgerufen hat, die Protokolldateien an diese E-Mail-Adresse senden',
    'log-rotation.kb' => 'KB',
    'log-rotation.logRotationPeriodGreater' => 'Die Dauer kann nicht über dem serverweiten Grenzwert von %%max%% liegen.',

    'login.loginLabel' => 'Benutzername',
    'login.passwdLabel' => 'Passwort',
    'login.localeLabel' => 'Sprache der Oberfläche',
    'login.defaultLocale' => 'Standard',
    'login.loginButtonLabel' => 'Anmelden',
    'login.enterLoginAndPasswd' => 'Geben sie Ihren Benutzernamen und Ihr Passwort ein.',
    'login.whatUsernamePassword' => 'Welcher Benutzername und welches Passwort sind hier zu verwenden?',
    'login.forgotPasswordLabel' => 'Passwort vergessen?',
    'login.cookies' => 'Cookie-Richtlinie in Plesk',
    'login.avoidSSLWarningsMsg' => 'Um SSL-Warnmeldungen bei der Anmeldung in Plesk zu vermeiden, verwenden Sie %%link%%',
    'login.digitalOceanMsg' => 'Sie nutzen Plesk zum ersten Mal über DigitalOcean? Verwenden Sie zur Anmeldung "root" und das Passwort, das Sie beim Erstellen dieses Droplets angegeben haben. %%link%%',
    'login.amazonLightsailMsg' => 'Sie nutzen Plesk zum ersten Mal über Lightsail? Um sich in Plesk anzumelden, greifen Sie über SSH auf den Server zu und verwenden Sie den Befehl "plesk login". %%link%%',
    'login.readGuide' => 'Das komplette Handbuch aufrufen.',

    'panel-access.title' => 'Plesk URL anpassen',
    'panel-access.hint' => 'Wählen Sie benutzerdefinierte URLs für die Anmeldung in Plesk aus. Sie können sich jedoch weiterhin über den Port %%httpsPort%% in Plesk anmelden. %%link%%',
    'panel-access.details' => 'Weitere Details',
    'panel-access.proxyEnabled' => 'Alle Domains oder Subdomains, die sich in die IP-Adresse des Servers auflösen, aber nicht für das Hosting verwendet werden',
    'panel-access.proxyDomain' => 'Die angegebene Domain oder Subdomain, die sich in die IP-Adresse des Servers auflöst, aber nicht für das Hosting verwendet wird',
    'panel-access.proxyDisabled' => 'Keine benutzerdefinierten URLs. Nur https://<server-IP-or-hostname>:%%httpsPort%%',

    'panel-access.Form.submitButton' => 'Speichern',
    'panel-access.Form.cancelButton' => 'Abbrechen',

    'panel-access.domainNameIsRequired' => 'Bitte geben Sie einen Domainnamen an.',
    'panel-access.successMessage' => 'Die ausgewählte Anmeldemethode wurde umgesetzt.',
    'panel-access.notSupported' => 'Ihr Plesk-Konto unterstützt diese Art der Anmeldung nicht.',
    'panel-access.notViaDomainName' => 'Wenn Sie diese Methode verwenden möchten, wählen Sie die erste Option ("Alle Domains oder Subdomains...") aus. Melden Sie sich dann über https://%%domainName%% in Plesk an und wählen Sie die zweite Option aus.',
    'panel-access.notViaPort' => 'Wenn Sie diese Methode verwenden möchten, melden Sie sich zuerst über https://<server-IP-or-hostname>:%%httpsPort%% in Plesk an.',

    'php-settings.performance' => 'Einstellungen zur Leistung und Sicherheit',
    'php-settings.settings' => 'Allgemeine Einstellungen',
    'php-settings.fastCgiSettings' => 'FastCGI-Einstellungen',
    'php-settings.fpmSettings' => 'PHP-FPM-Einstellungen',
    'php-settings.enableFastcgi' => 'FastCGI-Einstellungen aktivieren',
    'php-settings.plainTextEditing' => 'Zusätzliche Anweisungen',
    'php-settings.placeAdditionalCustomizationDirectivesHere' => 'Sie können PHP-Parameter definieren, indem Sie sie in das Feld unten eingeben. Die Anweisungen werden in die PHP-Konfiguration eingefügt. Verwenden Sie dieselbe Syntax wie in php.ini. Wenn Sie zum Beispiel die mSQL-Erweiterung automatisch laden möchten, fügen Sie diese Zeile hinzu: extension=msql.so.',
    'php-settings.placeAdditionalCustomizationDirectivesHereAddonPlan' => 'Wenn Sie bestimmte PHP-Parameter nicht finden, fügen Sie sie im unten stehenden Feld hinzu. Diese zusätzlichen Anweisungen werden mit den Anweisungen des Haupt-Service-Pakets zusammengeführt. Verwenden Sie dieselbe Syntax, die Sie für php.ini verwenden. Beispiel: Wenn Sie die mSQL-Erweiterung automatisch laden möchten, fügen Sie diese Zeile hinzu: extension=msql.so.',
    'php-settings.placeFpmAdditionalCustomizationDirectivesHere' => 'Sie können PHP-Parameter definieren, indem Sie sie in das Feld unten eingeben. Die Anweisungen werden in die PHP-Konfiguration eingefügt. Verwenden Sie dieselbe Syntax wie in php.ini. Wenn Sie zum Beispiel die mSQL-Erweiterung automatisch laden möchten, fügen Sie diese Zeile hinzu: extension=msql.so. Wenn Sie die PHP-FPM-Pool-Einstellungen anpassen möchten, fügen Sie die [php-fpm-pool-settings]-Trennlinie hinzu und geben Sie die gewünschten Einstellungen darunter ein.',
    'php-settings.additionalConfigurationDirectives' => 'Zusätzliche Konfigurationsanweisungen',
    'php-settings.defaultValue' => 'Standard',
    'php-settings.predefinedValue' => 'Wert auswählen',
    'php-settings.customValue' => 'Eigenen Wert eingeben',
    'php-settings.phpSettingDescription_memory_limit' => 'Die maximale Menge des Arbeitsspeichers (in Byte), die ein Skript zuweisen darf.',
    'php-settings.phpSettingDescription_max_execution_time' => 'Die maximale Zeit (in Sekunden), in der ein Skript ausgeführt werden darf, bevor es beendet wird.',
    'php-settings.phpSettingDescription_max_input_time' => 'Die maximale Zeit (in Sekunden), in der ein Skript Eingangsdaten parsen darf.',
    'php-settings.phpSettingDescription_post_max_size' => 'Die maximale Größe der Daten (in Byte), die mit der POST-Methode gesendet werden können. Sollte üblicherweise größer als upload_max_filesize und kleiner als memory_limit sein.',
    'php-settings.phpSettingDescription_upload_max_filesize' => 'Die maximale Größe einer hochgeladenen Datei in Byte.',
    'php-settings.phpSettingDescription_safe_mode' => 'Der abgesicherte Modus von PHP belegt die Ausführung von Skripten hauptsächlich aus Sicherheitsgründen mit Einschränkungen.',
    'php-settings.phpSettingDescription_safe_mode_include_dir' => 'Dateien im angegebenen Verzeichnis können von PHP-Skripten aufgerufen werden, wenn die Anweisung safe_mode aktiv ist. Das Verzeichnis muss auch in include_path enthalten sein.',
    'php-settings.phpSettingDescription_safe_mode_exec_dir' => 'Programme im angegebenen Verzeichnis können von PHP-Skripten ausgeführt werden, wenn die Anweisung safe_mode aktiv ist.',
    'php-settings.phpSettingDescription_include_path' => 'Die Liste der Verzeichnisse, in denen Skripte nach Dateien suchen (ähnlich der PATH-Variable des Systems). Zum Trennen von Verzeichnissen verwenden Sie bei Linux einen Doppelpunkt (:) und bei Windows ein Semikolon (;).',
    'php-settings.phpSettingDescription_sessionsave_path' => 'Das Verzeichnis zur Speicherung von PHP-Sitzungsdateien.',
    'php-settings.phpSettingDescription_mailforce_extra_parameters' => 'Zusätzliche Parameter für die mail()-Funktion.',
    'php-settings.phpSettingDescription_register_globals' => 'Registrieren Sie die Inhalte der EGPCS-Variablen (Environment, GET, POST, Cookie, Server) als globale Variablen.',
    'php-settings.phpSettingDescription_open_basedir' => 'Dateien in den angegebenen Verzeichnissen können von PHP-Skripten aufgerufen werden. Zum Trennen von Verzeichnissen verwenden Sie bei Linux einen Doppelpunkt (:) und bei Windows ein Semikolon (;).',
    'php-settings.phpSettingDescription_error_reporting' => 'Die Ebene der Fehlerberichterstattung.',
    'php-settings.phpSettingDescription_display_errors' => 'Bestimmt, ob Fehler als Teil der Ausgabe angezeigt werden sollen.',
    'php-settings.phpSettingDescription_log_errors' => 'Aktivieren Sie die Protokollierung von PHP-Fehlern.',
    'php-settings.phpSettingDescription_allow_url_fopen' => 'Lassen Sie zu, dass PHP-Dateifunktionen Daten von entfernten Speicherorten über FTP oder HTTP abrufen.',
    'php-settings.phpSettingDescription_file_uploads' => 'Ermöglicht das Hochladen von Dateien über HTTP.',
    'php-settings.phpSettingDescription_short_open_tag' => 'Erlaubt die Kurzform ( ) des PHP-Anfangstags.',
    'php-settings.phpSettingDescription_magic_quotes_gpc' => 'Legt den magic_quotes-Status für die GPC-Operationen (Get/Post/Cookie) fest. Ist diese Einstellung auf on, werden alle einfachen Anführungszeichen, doppelten Anführungszeichen, Backslashes und NULL-Sonderzeichen automatisch mit einem Backslash geschützt.',
    'php-settings.phpSettingDescription_disable_functions' => 'Diese Anweisung erlaubt Ihnen, bestimmte Funktionen zu deaktivieren. Es kann eine durch Trennzeichen getrennte Liste der Funktionsnamen angegeben werden.',
    'php-settings.phpSupport' => 'PHP-Unterstützung',
    'php-settings.phpRunAs' => 'PHP ausführen als',
    'php-settings.phpVersion' => 'PHP-Version',
    'php-settings.phpHandlerOutdated' => '(Überholt)',
    'php-settings.phpHandlerDeprecated' => '(Veraltet)',
    'php-settings.phpServedByApache' => '(Apache)',
    'php-settings.phpServedByNginx' => '(nginx)',
    'php-settings.phpSettingsPhpVersion' => 'Ihre PHP-Version ist %%version%%.',
    'php-settings.phpSettingsPhpDisabled' => 'PHP ist deaktiviert.',
    'php-settings.phpHandlerTypeHint' => 'Nachfolgend finden Sie die Details zur PHP-Konfiguration der Website. Sie können die PHP-Konfiguration ändern, sofern der Hosting-Provider Ihnen die entsprechende Berechtigung eingeräumt hat.',
    'php-settings.fpmDedicatedHandlerHint' => 'Mit diesem Handler wird die Stabilität der Website erhöht, aber mehr Speicher verbraucht.',
    'php-settings.phpHandlerChangeHint' => 'Sie haben die Einstellungen für den PHP-Handler geändert. Wenn Sie diese Änderungen speichern, werden die PHP-Skripte auf Ihrer Website aufgrund Ihrer Serverkonfiguration möglicherweise für %%interval%% Sekunden angehalten.',
    'php-settings.phpHandlerTypeHelpLink' => 'Erfahren Sie, wie Sie die passendsten PHP-Einstellungen wählen',
    'php-settings.phpHandlerTypeNotAvailableHint' => 'Die PHP-Unterstützung kann nicht aktiviert werden, da die derzeitige Hosting-Konfiguration keine für diese Domain verfügbaren PHP-Versionen enthält.',
    'php-settings.phpHandlersNotAvailableHint' => 'Die PHP-Unterstützung kann nicht aktiviert werden, da die derzeitige Plesk Konfiguration keine verfügbaren PHP-Versionen enthält.',
    'php-settings.phpHandlerTypeNotAvailableHelpLink' => 'Finden Sie heraus, wie Sie andere PHP-Versionen aktivieren können.',
    'php-settings.phpSupportEditable' => '(PHP-Version %%version%%, PHP ausführen als %%handler%%) %%link%%',
    'php-settings.phpSupportReadonly' => '(Version: %%version%%; Handler: %%handler%%) %%link%%',
    'php-settings.phpSupportReadonlyNotRegistered' => '(nicht registriert) %%link%%',
    'php-settings.showPhpInfo' => 'Die phpinfo() Seite ansehen',
    'php-settings.phpSettingsFormError' => 'Die PHP-Einstellungen können nicht abgerufen werden, da die erforderlichen Daten fehlen.',
    'php-settings.phpSettingsFormBrokenPhpHandler' => 'Die PHP-Einstellungen können nicht abgerufen werden, da der Handler beschädigt ist.',
    'php-settings.showPhpInfoTitle' => 'phpinfo() ansehen',
    'php-settings.showPhpInfoDescription' => 'Einige Ihrer PHP-Einstellungen wurden geändert, aber die Änderungen wurden noch nicht gespeichert. Um die neuen Werte auf der phpinfo() Seite sehen zu können, müssen Sie zuerst die Änderungen übernehmen. Ansonsten sehen Sie nur die aktuellen Werte.',
    'php-settings.showPhpInfoButton' => 'phpinfo() ansehen',
    'php-settings.onState' => 'An',
    'php-settings.offState' => 'Aus',

    'pmm.agent.sync.check' => 'Migrations- & Transfer-Assistent sucht nach Updates.',
    'pmm.agent.sync.updating' => 'Synchronisierung und Download des Migrations- & Transfer-Assistenten',
    'pmm.agent.sync.done' => 'Migrations- & Transfer-Assistent wurde erfolgreich synchronisiert.',
    'pmm.agent.sync.downloadLink' => 'Klicken Sie auf die entsprechende Schaltfläche, um die auf dem Quellhost zu installierende Datei des Migrations- & Transfer-Assistenten herunterzuladen, bevor Sie die Migration gestartet wird.',
    'pmm.agent.sync.error' => 'Der Migrations- & Transfer-Assistent konnte keine neuen Updates finden. Bitte versuchen Sie es später erneut.',

    'restore-password.title' => 'Passwort ändern',
    'restore-password.passwordLabel' => 'Neues Passwort',
    'restore-password.buttonRestore' => 'Speichern',
    'restore-password.buttonCancel' => 'Abbrechen',
    'restore-password.isEmpty' => 'Das erforderliche Feld ist leer. Sie müssen einen Wert angeben.',
    'restore-password.errorInvalidSecret' => 'Ungültiger Geheimcode',
    'restore-password.errorNotFoundSecret' => 'Fordern Sie bitte einen neuen Geheimcode an',
    'restore-password.restoreSuccess' => 'Ihr Passwort wurde aktualisiert. Mit dem Passwort können Sie sich in Plesk oder in Ihrem E-Mail-Postfach anmelden.',

    'scheduler.settings.schedulerNotification' => 'Benachrichtigung durch Planer',
    'scheduler.settings.notificationOff' => "Ausgeschaltet",
    'scheduler.settings.notificationDefault' => "An Standard-E-Mail-Adresse senden (%%email%%)",
    'scheduler.settings.notificationCustom' => "An die von mir angegebene E-Mail-Adresse senden",
    'scheduler.settings.crontabSecureShell' => 'Crontab-Shell',
    'scheduler.settings.schedulerTimezoneSelector' => 'Aufgabenzeitplan unter Verwendung einer Zeitzone einblenden',
    'scheduler.settings.schedulerTimezoneSelectorDefaultWithLabel' => 'Standardzeitzone des Systems verwenden (%%timezone%%)',
    'scheduler.settings.schedulerTimezoneSelectorDefault' => 'Standardzeitzone des Systems verwenden',
    'scheduler.settings.schedulerTimezoneSelectorCustom' => 'Zeitzone verwenden, die ich angebe',

    'scheduler.task.active' => 'Aktiv',
    'scheduler.task.subscription' => 'Abonnement',
    'scheduler.task.subscription_powerUser' => 'Webspace',
    'scheduler.task.type' => 'Aufgabentyp',
    'scheduler.task.typeCommand' => 'Befehl ausführen',
    'scheduler.task.typeUrl' => 'URL abrufen',
    'scheduler.task.typeScript' => 'PHP-Skript ausführen',
    'scheduler.task.command' => 'Befehl',
    'scheduler.task.arguments' => 'mit Argumenten',
    'scheduler.task.url' => 'URL',
    'scheduler.task.urlDescription' => 'Geben Sie eine absolute URL an, z. B. http://example.com. Wenn der Statuscode 2xx oder 3xx zurückgegeben wird, wird die Aufgabe als erfolgreich ausgeführt angesehen.',
    'scheduler.task.script' => 'Skriptpfad',
    'scheduler.task.scriptRelativePathDescription' => 'Beispiel: %%path%%',
    'scheduler.task.scriptAbsolutePathDescription' => 'Geben Sie den vollständigen Pfad zum Skript an. Beispiel: %%path%%',
    'scheduler.task.scriptPhpVersion' => 'Zu verwendende PHP-Version',
    'scheduler.task.scriptPathPopupTitle' => 'Skriptpfad',
    'scheduler.task.run' => 'Ausführen',
    'scheduler.task.on' => 'am',
    'scheduler.task.at' => 'um',
    'scheduler.task.sysUser' => 'Systembenutzer',
    'scheduler.task.hourly' => 'Stündlich',
    'scheduler.task.daily' => 'Täglich',
    'scheduler.task.weekly' => 'Wöchentlich',
    'scheduler.task.monthly' => 'Monatlich',
    'scheduler.task.yearly' => 'Jährlich',
    'scheduler.task.cronStyle' => 'Cron-Stil',
    'scheduler.task.cronStyleError' => 'Ungültige Crontab-Syntax.',
    'scheduler.task.cronStyleErrorWin' => 'Schrägstrich (/) und Bindestrich (-) sind nicht zulässig.',
    'scheduler.task.cronStyleHint' => 'Verwenden Sie das UNIX-Crontab-Format "Minute Stunde Tag-des-Monats Wochentag". Zum Beispiel "0 22 * * 1-5". Plesk wird die Standardzeitzone des Systems verwenden, um die Aufgabe auszuführen.',
    'scheduler.task.cronStyleWinHint' => 'Verwenden Sie das Format "Minute Stunde Tag-des-Monats Wochentag", zum Beispiel "0 22 * * 6,7". Plesk wird die Standardzeitzone des Systems verwenden, um die Aufgabe auszuführen.',
    'scheduler.task.notify' => 'Benachrichtigen',
    'scheduler.task.notifyIgnore' => 'Nicht benachrichtigen',
    'scheduler.task.notifyErrors' => 'Nur Fehler',
    'scheduler.task.notifyAlways' => 'Jedes Mal',
    'scheduler.task.notifyErrorsHint' => 'Benachrichtigungen enthalten die Standardfehlerausgabe des Befehls. Wenn die Ausgabe leer ist, wird keine Benachrichtigung gesendet.',
    'scheduler.task.notifyErrorsHintWin' => 'Benachrichtigungen enthalten das Ergebnis des Befehls und werden nur gesendet, wenn der Exitcode nicht gleich null ist.',
    'scheduler.task.notifyAlwaysHint' => 'Benachrichtigungen enthalten das Ergebnis des Befehls. Wenn das Ergebnis leer ist, wird keine Benachrichtigung gesendet.',
    'scheduler.task.notifyAlwaysHintWin' => 'Benachrichtigungen enthalten das Ergebnis des Befehls und werden ungeachtet des Exitcodes des Befehls gesendet.',
    'scheduler.task.emailType' => 'Benachrichtigungen senden an',
    'scheduler.task.emailTypeDefault' => 'Standardsystembenutzer (%%email%%)',
    'scheduler.task.emailTypeOwner' => 'Abonnement-Inhaber (%%email%%)',
    'scheduler.task.emailTypeOwnerAdmin' => 'Administrator (%%email%%)',
    'scheduler.task.emailTypeCustom' => 'Andere Benutzer',
    'scheduler.task.emailTypeCustomDescription' => 'Sie können mehrere Adressen durch Kommata getrennt angeben.',
    'scheduler.task.minute' => 'Minute',
    'scheduler.task.shortMinute' => 'Min.',
    'scheduler.task.dayOfMonth' => 'Tag',
    'scheduler.task.description' => 'Beschreibung',
    'scheduler.task.scheduleTimezoneHint' => 'Die Zeitzone zum Ausführen der Aufgabe ist %%timezone%%',
    'scheduler.task.runTaskNow' => 'Jetzt ausführen',
    'scheduler.task.runningTask' => 'Führe Aufgabe "%%task%%" aus...',

    'service-plan.mail.outgoing-messages.outgoingMessagesDefault' => 'Serverweiter Standardwert (%%default%% Nachrichten pro Stunde)',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificPlan' => 'Benutzerdefinierter Wert für das Paket',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificSubscription' => 'Benutzerdefinierter Wert für das Abonnement',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificHint' => 'Nachrichten',
    'service-plan.mail.outgoing-messages.mboxOutgoingMessages' => 'Ausgehende Nachrichten von einem Postfach (pro Stunde)',
    'service-plan.mail.outgoing-messages.domainOutgoingMessages' => 'Ausgehende Nachrichten von einer Domain (pro Stunde)',
    'service-plan.mail.outgoing-messages.subscriptionOutgoingMessages' => 'Ausgehende Nachrichten von einem Abonnement (pro Stunde)',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimit' => 'Der Anteil an Nachrichten oberhalb der Stundengrenze (in Prozent), die in der nachfolgenden Stunde gesendet werden sollen',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimitDescription' => 'Wenn beispielsweise die Grenze für die pro Stunde von einem Postfach abgehenden E-Mail-Nachrichten den Wert 100 hat und der Prozentwert 10% ist, dann darf der Benutzer 110 Nachrichten senden. 100 Nachrichten werden während der einen Stunde gesendet und 10 Nachrichten kommen in die E-Mail-Warteschlange und werden für die darauffolgende Stunde zum Senden vorgemerkt.',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmail' => 'Sendmail-Nutzungsregelung',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailDefault' => 'Serverweite Standardeinstellungen (Sendmail ist zugelassen)',
    'service-plan.mail.outgoing-messages.outgoingMessagesNotEnableSendmailDefault' => 'Serverweite Standardeinstellungen (Sendmail ist nicht zugelassen)',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomPlan' => 'Benutzerdefinierte Einstellungen für das Paket',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomSubscription' => 'Benutzerdefinierte Einstellungen für das Abonnement',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomLabel' => 'Skripte und Benutzer in diesem Abonnement dürfen Sendmail nutzen',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomHint' => 'Skripte und Benutzer können E-Mail-Nachrichten (aufseiten des Systembenutzers des Abonnements) über Sendmail senden, auch wenn die Grenzen für ein Postfach und eine Domain überschritten sind. Die maximale Anzahl an Nachrichten, die via Sendmail gesendet werden können, werden von dem Grenzwert für ein gesamtes Abonnement definiert.',

    'setup.hint' => 'Willkommen bei Plesk, dem Control Panel zur Serververwaltung. Dank der unkomplizierten Plesk Umgebung sowie einer Reihe von leistungsstarken Erweiterungen können Sie Websites und Apps einfacher denn je entwickeln. Schließen Sie die Einrichtung ab, um Plesk zu verwenden. Dies dauert nur einen Moment.',
    'setup.contactInfoSection' => 'Kontaktdaten',
    'setup.contactInfoSectionHint' => 'Geben Sie Ihren Namen und Ihre E-Mail-Adresse ein, um sich als Eigentümer des Servers zu identifizieren und wichtige Mitteilungen über den Server zu erhalten. Wenn Sie der Administrator eines betrieblichen Servers sind, geben Sie nicht Ihren persönlichen Namen oder Ihre persönliche E-Mail-Adresse ein. Verwenden Sie stattdessen Ihre Berufsbezeichnung und Firmen-E-Mail-Adresse, damit eine mögliche Verletzung des Datenschutzgesetzes vermieden wird.',
    'setup.contactName' => 'Kontaktname',
    'setup.emptyContactName' => 'Bitte geben Sie einen Kontaktnamen an.',
    'setup.contactNameTooLong' => 'Der Kontaktname ist zu lang (maximal %max% Zeichen sind zulässig).',
    'setup.email' => 'E-Mail-Adresse',
    'setup.emptyEmail' => 'Bitte geben Sie eine E-Mail-Adresse an.',
    'setup.passwordSection' => 'Passwort',
    'setup.passwordSectionHint' => 'Verwenden Sie bei der nächsten Anmeldung in Plesk den Benutzernamen \'admin\' und das Passwort unten.',
    'setup.password' => 'Passwort',
    'setup.licenseSection' => 'Lizenz',
    'setup.licenseSectionHint' => 'Um Plesk verwenden zu können, müssen Sie eine Lizenz installieren.',
    'setup.licenseType' => 'Lizenztyp auswählen',
    'setup.licenseTypePaid' => 'Mit einer bezahlten Lizenz fortfahren',
    'setup.onlineStoreLink' => 'Online-Shop',
    'setup.licenseTypeTrial' => 'Mit der Lizenz einer voll funktionsfähigen Testversion fortfahren',
    'setup.activationCodeHint' => 'Wenn Sie bereits eine Plesk Lizenz erworben haben, fügen Sie hier den Aktivierungscode ein, den Sie erhalten haben. Anderenfalls können Sie in unserem %%onlineStoreLink%% eine neue Lizenz erwerben.',
    'setup.privacyPolicyLink' => 'Datenschutzrichtlinie von Plesk',
    'setup.trialLicenseAgreement' => 'Um eine Testlizenz auszustellen, verwendet und verarbeitet Plesk die zur Verfügung gestellten Informationen in seinen internen Systemen gemäß der %%privacyPolicyLink%%.',
    'setup.eulaAgreementLabel' => 'Ich habe den %%link%% gelesen und akzeptiere ihn.',
    'setup.eula' => 'Endbenutzer-Lizenzvertrag',
    'setup.invalidEulaAgreementValue' => 'Sie müssen den Endbenutzer-Lizenzvertrag akzeptieren.',
    'setup.sendButton' => 'Plesk öffnen >>',

    'ssl-certificate.add.name' => 'Name des Zertifikats',
    'ssl-certificate.add.longName' => 'Der angegebene Zertifikatsname ist zu lang (maximal %max% Zeichen sind zulässig).',
    'ssl-certificate.add.certificateNameUsed' => 'Ein Zertifikat mit dem Namen %%name%% ist bereits vorhanden.',
    'ssl-certificate.add.certificateAdded' => 'Es wurde ein SSL/TLS-Zertifikat ausgestellt. Um eine Domain, E-Mails oder Webmail zu schützen, weisen Sie das Zertifikat zu.',
    'ssl-certificate.add.certificateUpdated' => 'Das SSL/TLS-Zertifikat wurde erfolgreich aktualisiert.',
    'ssl-certificate.add.settings' => 'Einstellungen',
    'ssl-certificate.add.settingsHint' => 'Verwenden Sie dieses Formular, um eine Anforderung für ein Zertifikat zu generieren, um ein Zertifikat bei Ihrem Provider zu kaufen oder um ein selbstsigniertes Zertifikat zu erstellen.',
    'ssl-certificate.add.settingsHint2' => 'Die Anforderung ist eine CSR-Datei, die Informationen über Ihre im Formular angegebene Domain enthält. Sie können die Anforderung an eine Zertifizierungsstelle senden, damit diese Ihnen ein Zertifikat ausstellt. Dann können Sie es mithilfe eines der Upload-Formulare hochladen.',
    'ssl-certificate.add.settingsHint3' => 'Ein selbstsigniertes Zertifikat ist ein Identitätszertifikat, das vom Ersteller signiert wird. Wenn Sie ein solches Zertifikat nutzen, bestätigen Sie damit selbst die Identität Ihrer Websites. Auch wenn selbstsignierte Zertifikate die Verwendung von SSL/TLS zulassen, gelten sie als weniger vertrauenswürdig und weniger sicher.',
    'ssl-certificate.add.bits' => 'Bit',
    'ssl-certificate.add.country' => 'Land',
    'ssl-certificate.add.state' => 'US-Staat/Provinz/Region',
    'ssl-certificate.add.longState' => 'Der angegebene Staat oder die angegebene Provinz ist zu lang.',
    'ssl-certificate.add.city' => 'Standort (Stadt)',
    'ssl-certificate.add.longCity' => 'Der angegebene Städtename ist zu lang.',
    'ssl-certificate.add.shortCity' => 'Der angegebene Städtename ist zu kurz.',
    'ssl-certificate.add.companyName' => 'Organisationsname (Firma)',
    'ssl-certificate.add.longCompanyName' => 'Der angegebene Firmenname ist zu lang.',
    'ssl-certificate.add.companyUnitName' => 'Abteilungsname der Organisation',
    'ssl-certificate.add.longCompanyUnitName' => 'Der angegebene Abteilungsname der Organisation ist zu lang (maximal %max% Zeichen sind zulässig).',
    'ssl-certificate.add.domainName' => 'Domainname',
    'ssl-certificate.add.email' => 'E-Mail',
    'ssl-certificate.add.request' => 'Anfordern',
    'ssl-certificate.add.buyCertificate' => 'SSL/TLS-Zertifikat kaufen',
    'ssl-certificate.add.selfSigned' => 'Selbstsigniert',
    'ssl-certificate.add.invalidCertificateParams' => 'Einige Felder sind leer oder enthalten ungültige Werte. Die Werte dürfen höchstens 64 Zeichen umfassen. Falls Sie einen internationalen Domainnamen verwenden, stellen Sie sicher, dass kein Teil des Domainnamens (zwischen Punkten) länger als 63 Zeichen ist, wenn er ins ASCII-Format konvertiert wird. Überprüfen Sie die Felder:',
    'ssl-certificate.add.unableCreateCsr' => 'Die Zertifikatsignieranforderung kann nicht erstellt werden: %%error%%',
    'ssl-certificate.add.unableCreateSelfSigned' => 'Das selbstsignierte Zertifikat kann nicht erstellt werden: %%error%%',
    'ssl-certificate.add.unableCreateUpload' => 'Die Zertifikatsdaten können nicht konfiguriert werden: %%error%%',
    'ssl-certificate.add.unableSaveCertificate' => 'Das Zertifikat kann nicht in der Datenbank gespeichert werden: %%error%%',
    'ssl-certificate.add.uploadFiles' => 'Zertifikatsdateien hochladen',
    'ssl-certificate.add.uploadFilesHint' => 'Verwenden Sie dieses Formular, um die Komponenten eines Zertifikats als Teildateien hochzuladen.',
    'ssl-certificate.add.csr' => 'CSR',
    'ssl-certificate.add.privateKey' => "Privater Schlüssel (*.key)",
    'ssl-certificate.add.certificate' => "Zertifikat (*.crt)",
    'ssl-certificate.add.caCertificate' => "CA-Zertifikat (*-ca.crt)",
    'ssl-certificate.add.sendFiles' => "Zertifikat hochladen",
    'ssl-certificate.add.fileNotUploaded' => 'Die Zertifikatsdatei %%name%% kann nicht hochgeladen werden.',
    'ssl-certificate.add.unableSetPrivateKey' => 'Der private Schlüssel kann nicht eingerichtet werden: %%error%%',
    'ssl-certificate.add.unableSetCertificate' => 'Das Zertifikat kann nicht konfiguriert werden: %%error%%',
    'ssl-certificate.add.unableSetCaCertificate' => 'Das CA-Zertifikat kann nicht konfiguriert werden: %%error%%',
    'ssl-certificate.add.unableCheckCaCertificate' => 'Es kann nicht überprüft werden, ob das Zertifikat vom CA-Zertifikat signiert wird: %%error%%',
    'ssl-certificate.add.removeCaCertificate' => 'Entfernen',
    'ssl-certificate.add.removeCaCertificateConfirmation' => 'Möchten Sie das CA-Zertifikat wirklich entfernen?',
    'ssl-certificate.add.unableRemoveCaCertificate' => 'Das CA-Zertifikat kann nicht gelöscht werden: %%error%%',
    'ssl-certificate.add.caCertificateRemoved' => 'Der CA-Teil des Zertifikats wurde entfernt.',
    'ssl-certificate.add.rename' => 'Umbenennen',
    'ssl-certificate.add.unableRenameCertificate' => 'Das Zertifikat kann nicht umbenannt werden: %%error%%',
    'ssl-certificate.add.certificateRenamed' => 'Das Zertifikat wurde in %%name%% umbenannt.',
    'ssl-certificate.add.uploadText' => "Zertifikat als Text hochladen",
    'ssl-certificate.add.uploadTextHint' => 'Verwenden Sie dieses Formular, um die Komponenten eines Zertifikats als Text hochzuladen. Kopieren Sie dazu den Inhalt einer Datei und fügen Sie ihn in das entsprechende Feld ein.',
    'ssl-certificate.add.sendText' => "Zertifikat hochladen",
    'ssl-certificate.add.componentIsMissing' => 'Die Komponente fehlt.',

    'ssl-certificate.find-private-key.findPrivateKey' => 'Zertifikat hier hochladen',
    'ssl-certificate.find-private-key.formGeneralHint' => 'Wenn Sie eine Zertifikatsignieranforderung auf diesem Server erstellt haben und die Zertifikatsdatei erhalten haben, können Sie sie hier hochladen. Wollen Sie jedoch ein auf einem anderen Server generiertes Zertifikat und ein privates Schlüsselpaar hochladen oder ein selbstsigniertes Zertifikat generieren, klicken Sie auf <b>SSL/TLS-Zertifikat hinzufügen</b>.',
    'ssl-certificate.find-private-key.formCertificateAddingHint' => 'Nachdem Sie einer Domain ein SSL/TLS-Zertifikat hinzugefügt haben, müssen Sie die SSL/TLS-Unterstützung aktivieren und das Zertifikat in den Hosting-Einstellungen der Website auswählen: <b>Websites & Domains</b>> <b>Hosting-Einstellungen</b> der Domain> <b>Sicherheit</b>.',
    'ssl-certificate.find-private-key.uploadCertificate' => 'Zertifikat (*.crt)',
    'ssl-certificate.find-private-key.sendFile' => 'Zertifikat hochladen',
    'ssl-certificate.find-private-key.fileNotUploaded' => 'Die Zertifikatsdatei kann nicht hochgeladen werden.',
    'ssl-certificate.find-private-key.invalidCertificateFormat' => 'Ungültiges Zertifikatsformat.',
    'ssl-certificate.find-private-key.unableFindPrivateKey' => 'Für das Zertifikat wurde kein passender privater Schlüssel gefunden.',

    'ssl-certificate.secure.certificate' => 'Zertifikat auswählen',
    'ssl-certificate.secure.serverPool' => 'Serverpool',
    'ssl-certificate.secure.certificateName' => '%%certificateName%% (%%repositoryName%%)',

    'web-app-firewall.pageHint' => 'Web Application Firewall schützt Webanwendungen vor Angriffen, indem eingehende HTTP-Anfragen anhand von benutzerdefinierten Regeln überprüft und gefiltert werden.',
    'web-app-firewall.webSitePageHint' => 'Hier können Sie die Web Application Firewall (ModSecurity) konfigurieren.',
    'web-app-firewall.ruleEngine' => 'Modus der Web Application Firewall',
    'web-app-firewall.ruleEngineOn' => 'Ein',
    'web-app-firewall.ruleEngineOnDescription' => 'Jede eingehende HTTP-Anforderung und die zugehörige Antwort werden mit einem Regelsatz verglichen. Wenn diese Überprüfung erfolgreich verläuft, wird die HTTP-Anforderung an den Website-Content weitergegeben. Wenn die Überprüfung negativ ausfällt, wird das Ereignis protokolliert, eine Benachrichtigung gesendet und eine HTTP-Antwort mit Fehlercode zurückgegeben.',
    'web-app-firewall.ruleEngineOff' => 'Aus',
    'web-app-firewall.ruleEngineOffDescription' => 'Eingehende HTTP-Anfragen und zugehörige Antworten werden nicht überprüft.',
    'web-app-firewall.ruleEngineDetectionOnly' => 'Nur Erkennung',
    'web-app-firewall.ruleEngineDetectionOnlyDescription' => 'Jede eingehende HTTP-Anforderung und die zugehörige Antwort werden mit einem Regelsatz verglichen. Wenn diese Überprüfung erfolgreich verläuft, wird die HTTP-Anforderung an den Website-Content weitergegeben. Wenn die Überprüfung negativ ausfällt, wird das Ereignis protokolliert und ModSecurity führt keine weiteren Aktionen aus. Andere Dienste wie Fail2ban können trotzdem eigene Aktionen für HTTP-Anforderungen ausführen, die die Überprüfung nicht bestanden haben.',
    'web-app-firewall.ruleSetsSection' => 'Regelsätze',
    'web-app-firewall.ruleSetsSectionHint' => 'Wählen Sie aus, welcher Regelsatz (Dateipaket mit Sicherheitsregeln) für die Überprüfung der eingehenden HTTP-Anfragen verwendet werden soll.',
    'web-app-firewall.ruleSet' => 'Regelsatz',
    'web-app-firewall.ruleSetCrs' => 'OWASP (kostenlos)',
    'web-app-firewall.ruleSetCrsDescription' => 'Der Regelsatz "OWASP ModSecurity Core Rule Set" ist ziemlich restriktiv. Einige Funktionen wie die Dateifreigabe oder Webmail bzw. Funktionen von Webanwendungen wie WordPress-Plug-ins können möglicherweise blockiert werden.',
    'web-app-firewall.ruleSetCrsConfirmTitle' => 'Änderungen übernehmen?',
    'web-app-firewall.ruleSetCrsConfirmDescription' => 'OWASP-Regeln können u. U. zu streng sein und daher einige Funktionen blockieren, wie z. B. Filesharing, Webmail und einige Webanwendungen.',
    'web-app-firewall.ruleSetTortix' => 'Atomic Standard (kostenlos; Upgrade auf Atomic Advanced möglich)',
    'web-app-firewall.ruleSetTortixDescription' => 'Version der ModSecurity-Regeln von Atomicorp für den Einstieg. Bieten einen Basisschutz und werden monatlich aktualisiert.',
    'web-app-firewall.ruleSetTortixHowTo' => 'So führen Sie ein Upgrade dieses Regelsatzes auf Atomic Advanced durch:',
    'web-app-firewall.ruleSetTortixBuy' => 'Kaufen Sie %%linkPleskStore%% auf der Plesk Website und %%linkDocumentation%%.',
    'web-app-firewall.ruleSetTortixLinkPleskStoreLabel' => 'Advanced ModSecurity-Regeln von Atomicorp',
    'web-app-firewall.ruleSetTortixLinkDocumentationLabel' => 'installieren Sie den erworbenen zusätzlichen Lizenzschlüssel',
    'web-app-firewall.ruleSetTortixSelect' => 'Wählen Sie diesen Regelsatz aus. Der Name ändert sich dann in "Atomic Advanced (erworben über Plesk)".',
    'web-app-firewall.ruleSetTortixPro' => 'Atomic Advanced (erworben über Plesk)',
    'web-app-firewall.ruleSetTortixProDescription' => 'Die Regeln "Advanced ModSecurity Rules by Atomicorp" enthalten die Atomic Standard-Regeln sowie eine Reihe von erweiterten Funktionen.',
    'web-app-firewall.ruleSetAtomic' => 'Atomic Advanced (erworben über Atomicorp)',
    'web-app-firewall.ruleSetAtomicDescription' => 'Die Regeln "Advanced ModSecurity Rules by Atomicorp" enthalten die Atomic Standard-Regeln sowie eine Reihe von erweiterten Funktionen.',
    'web-app-firewall.ruleSetAtomicInstall' => 'Wechseln Sie zu einem anderen Atomicorp-Konto.',
    'web-app-firewall.ruleSetAtomicInstalled' => 'Der Regelsatz ist aktiviert.',
    'web-app-firewall.ruleSetAtomicHowTo' => 'Falls Sie bereits ein Atomicorp-Konto besitzen und Atomic Advanced-Regeln erworben haben, geben Sie die Kontoanmeldedaten unten ein, um diesen Regelsatz zu aktivieren.',
    'web-app-firewall.ruleSetAtomicSwitchHowTo' => 'Falls Sie bereits ein Atomicorp-Konto besitzen und Atomic Advanced-Regeln erworben haben, geben Sie die Kontoanmeldedaten unten ein, um zu diesem Konto zu wechseln.',
    'web-app-firewall.ruleSetAtomicLogin' => 'Benutzername',
    'web-app-firewall.ruleSetAtomicPassword' => 'Passwort',
    'web-app-firewall.ruleSetComodo' => 'Comodo (kostenloses Abonnement)',
    'web-app-firewall.ruleSetComodoDescription' => 'Kostenlose ModSecurity-Regeln von Comodo. Bieten einen Basisschutz.',
    'web-app-firewall.ruleSetComodoInstall' => 'Wechseln Sie zu einem anderen Comodo-Konto.',
    'web-app-firewall.ruleSetComodoInstalled' => 'Der Regelsatz ist aktiviert.',
    'web-app-firewall.ruleSetComodoHowTo' => 'So aktivieren Sie diesen Regelsatz:',
    'web-app-firewall.ruleSetComodoSwitchHowTo' => 'So wechseln Sie zu einem anderen Konto:',
    'web-app-firewall.ruleSetComodoRegister' => 'Registrieren Sie sich auf der Comodo-Website.',
    'web-app-firewall.ruleSetComodoCredentials' => 'Geben Sie Ihren Benutzernamen und Ihr Passwort von der Website ein.',
    'web-app-firewall.ruleSetComodoLogin' => 'Benutzername',
    'web-app-firewall.ruleSetComodoPassword' => 'Passwort',
    'web-app-firewall.ruleSetComodoFree' => 'Comodo (kostenlos)',
    'web-app-firewall.ruleSetComodoFreeDescription' => 'Kostenlose ModSecurity-Regeln von Comodo. Bieten einen Basisschutz.',
    'web-app-firewall.ruleSetCustom' => 'Benutzerdefinierter Regelsatz',
    'web-app-firewall.ruleSetCustomDescription' => 'Laden Sie einen eigenen Regelsatz für die Web Application Firewall hoch. Unterstützte Formate: zip, tar.gz, tgz, tar.bz2, conf.',
    'web-app-firewall.ruleSetCustomUpload' => 'Andere Datei auswählen',
    'web-app-firewall.ruleSetError' => 'Der ModSecurity-Regelsatz konnte nicht installiert werden: %%error%%',
    'web-app-firewall.ruleSetOWASPMissingError' => 'Der OWASP-Regelsatz fehlt. Installieren Sie ModSecurity mithilfe des Plesk Installers.',
    'web-app-firewall.ruleSetCustomMissingError' => 'Der benutzerdefinierte Regelsatz fehlt. Installieren Sie den Regelsatz erneut.',
    'web-app-firewall.ruleSetAuthError' => 'Der angegebene Benutzername oder das Passwort ist ungültig.',
    'web-app-firewall.ruleSetInvalid' => 'Der ausgewählte Regelsatz kann nicht auf %%webServer%%% ausgeführt werden.',
    'web-app-firewall.ruleSetSelectedInvalid' => 'Der ausgewählte Regelsatz kann nicht auf dem ausgewählten Webserver ausgeführt werden.',
    'web-app-firewall.webServer' => 'Regeln ausführen auf',
    'web-app-firewall.webServerHint' => 'Wählen Sie die gewünschte Kombination aus Webserver und ModSecurity-Version aus, um die kompatiblen Regelsätze zu sehen.',
    'web-app-firewall.webServerApache' => 'Apache (ModSecurity 2.9)',
    'web-app-firewall.webServerNginx' => 'Nginx (ModSecurity 3.0)',
    'web-app-firewall.webServerIis' => 'IIS (ModSecurity 2.9)',
    'web-app-firewall.nginxNotRunning' => 'Der Reverse-Proxy-Server (nginx) ist deaktiviert und kann nicht zur Bearbeitung von Anfragen verwendet werden. Wählen Sie <a href="%%serverUrl%%">einen anderen Webserver</a> aus oder aktivieren Sie den Reverse-Proxy-Server auf der Seite <a href="%%servicesUrl%%">Service-Verwaltung</a>.',
    'web-app-firewall.nginxIsIncompatible' => 'Wenn Sie eine andere ModSecurity-Version auswählen, sind einige Einstellungen möglicherweise nicht mehr gültig (z. B. können Sie mit ModSecurity 3 keine regulären Ausdrücke zum Deaktivieren von Sicherheitsregeln verwenden). Vergewissern Sie sich, dass Ihre Einstellungen nach den Änderungen wie erwartet funktionieren. Sie können die Einstellungen zum Deaktivieren von Sicherheitsregeln auch auf die Standardwerte zurücksetzen.',
    'web-app-firewall.nginxResetCustomizations' => 'Server- und Domaineinstellungen zum Deaktivieren von Sicherheitsregeln auf die Standardwerte zurücksetzen.',
    'web-app-firewall.ruleSetUpdate' => 'Regelsätze aktualisieren',
    'web-app-firewall.ruleSetUpdateDaily' => 'Täglich',
    'web-app-firewall.ruleSetUpdateWeekly' => 'Wöchentlich',
    'web-app-firewall.ruleSetUpdateMonthly' => 'Monatlich',
    'web-app-firewall.currentRuleSet' => 'Regelsatz',
    'web-app-firewall.currentRuleSetValue' => '%%ruleSet%% %%changeRuleSetLink%%',
    'web-app-firewall.currentRuleSetRunningOn' => '%%ruleSet%% wird ausgeführt auf %%webServer%%',
    'web-app-firewall.changeRuleSetLink' => 'Regelsatz ändern',
    'web-app-firewall.ruleSetRollbackFailed' => 'Der aktuelle ModSecurity Regelsatz kann nicht verwendet werden und die vorherige Version kann nicht wiederhergestellt werden, da beide ungültige Regeln enthalten.',
    'web-app-firewall.configurationSection' => 'Konfiguration',
    'web-app-firewall.configurationSectionHint' => 'Konfigurieren Sie Web Application Firewall, indem Sie entweder eine vordefinierte Zusammenstellung von Parametern oder Ihre eigenen ModSecurity-Anweisungen verwenden.',
    'web-app-firewall.configPreset' => 'Vordefinierte Werte',
    'web-app-firewall.configPresetFast' => 'Schnell',
    'web-app-firewall.configPresetFastDescription' => 'Analysiert werden der URI der HTTP-Anfrage und Teile der Header.',
    'web-app-firewall.configPresetTradeOff' => 'Ausgewogen',
    'web-app-firewall.configPresetTradeOffDescription' => 'Analysiert werden der URI und die Header der HTTP-Anfrage sowie die POST-Daten der Anfrage.',
    'web-app-firewall.configPresetThrough' => 'Gründlich',
    'web-app-firewall.configPresetThroughDescription' => 'Analysiert werden die vollständigen Header der HTTP-Anfrage, die POST-Daten der Anfrage und der Body-Content der HTTP-Antwort.',
    'web-app-firewall.configCustom' => 'Benutzerdefinierte Anweisungen',
    'web-app-firewall.configCustomDescription' => "Geben Sie hier eine ModSecurity-Anweisung ein. Sie wird die zuvor angegebenen Anweisungen überschreiben (Regelsätze, spezifische Regeln, die vordefinierten Werte und so weiter).\nZum Beispiel: SecDebugLogLevel 6",
    'web-app-firewall.configCustomError' => 'Ungültige ModSecurity Konfiguration: %%error%%',
    'web-app-firewall.configRollbackFailed' => 'Die aktuelle ModSecurity Konfigurationsdatei kann nicht verwendet werden und die vorherige Version der Datei kann nicht wiederhergestellt werden, da beide eine ungültige Konfiguration enthalten.',
    'web-app-firewall.rulesSection' => 'Sicherheitsregeln ausschalten',
    'web-app-firewall.rulesSectionHint' => 'Hier können Sie Sicherheitsregeln deaktivieren. Dies ist hilfreich, wenn eine Sicherheitsregel für einige Websites zu streng ist. Zum Deaktivieren von Sicherheitsregeln geben Sie die IDs (z. B. 340003 oder 340005-340007), Tags (z. B. CVE-2011-4898) oder reguläre Ausdrücke in Regelnachrichten (z. B. XSS) ein.',
    'web-app-firewall.rulesSectionNginxHint' => 'Hier können Sie Sicherheitsregeln deaktivieren. Dies ist hilfreich, wenn eine Sicherheitsregel für einige Websites zu streng ist. Zum Deaktivieren von Sicherheitsregeln geben Sie die IDs (z. B. 340003 oder 340005-340007), Tags (z. B. CVE-2011-4898) oder Regelnachrichten (z. B. "Found User-Agent associated with security scanner") ein.',
    'web-app-firewall.filterById' => 'Sicherheitsregel-IDs',
    'web-app-firewall.filterByIdInvalid' => 'Die folgenden Werte sind nicht gültig: %%values%%. Die Regel-ID muss aus Ziffern oder Ziffernbereichen (z. B. 913100, 913105-913107) bestehen.',
    'web-app-firewall.filterByIdInvalidRanges' => 'Die folgenden Bereiche sind nicht gültig: %%ranges%%.',
    'web-app-firewall.filterByTag' => 'Tags',
    'web-app-firewall.filterByTagActive' => 'Aktiv:',
    'web-app-firewall.filterByTagDeactivated' => 'Deaktiviert:',
    'web-app-firewall.filterByTagInvalid' => 'Die folgenden ausgewählten Werte sind nicht gültig: %%values%%.',
    'web-app-firewall.filterByRegexp' => 'Reguläre Ausdrücke in Regelnachrichten',
    'web-app-firewall.filterByRegexpInvalid' => 'Die folgenden Werte sind nicht gültig: %%values%%. Es dürfen keine der folgenden Zeichen enthalten sein: \', "',
    'web-app-firewall.filterByRegexpNginx' => 'Regelnachrichten',
    'web-app-firewall.filterByRegexpNginxHint' => 'Nur genaue Übereinstimmungen werden unterstützt.',
    'web-app-firewall.filterByRegexpNginxInvalid' => 'Die folgenden Werte sind nicht gültig: %%values%%. Die Regelnachricht darf nur Buchstaben, Ziffern, Leerzeichen und die folgenden Zeichen enthalten: -:;.,!?#&$%*()/.',
    'web-app-firewall.auditLogSection' => 'ModSecurity-Auditprotokoll',
    'web-app-firewall.auditLogHint1' => 'Die ModSecurity-Auditprotokolldatei ist die nützlichste Informationsquelle im System. Sobald ModSecurity erkennt, dass ein Ereignis eintritt, generiert es einen Eintrag in der Auditprotokolldatei.',
    'web-app-firewall.auditLogHint2' => 'Eine Website kann u. U. nicht mehr wie erwartet funktionieren, wenn Sie den Modus der Web Application Firewall von "Aus" oder "Nur Erkennung" zu "Ein" ändern. In diesem Fall sollten Sie das ModSecurity-Auditprotokoll analysieren, um herauszufinden, was genau passiert. Sie können zu strenge Sicherheitsregeln ausschalten oder die Website anpassen.',
    'web-app-firewall.auditLogHint3' => 'So finden Sie heraus, warum eine HTTP-Anfrage für eine Website nicht abgeschlossen werden konnte:',
    'web-app-firewall.auditLogPoint1' => 'Klicken Sie unten auf die ModSecurity-Protokolldatei und öffnen Sie das Auditprotokoll in einem neuen Browserfenster.',
    'web-app-firewall.auditLogPoint2' => 'Verwenden Sie die Suche (Strg+F in den meisten Webbrowsern), um Ereignisse zu finden, die mit der Website (dem Domainnamen), die Probleme aufweist, in Verbindung stehen. Suchen Sie zum Beispiel nach "ihre_domain.tld". Der Browser wird Einträge markieren wie HOST: ihre_domain.tld.',
    'web-app-firewall.auditLogPoint3' => 'Suchen Sie drei Zeilen über dem markierten Eintrag eine Zeichenfolge wie --eece5138-B--. Die acht Zeichen zwischen den Bindestrichen (in unserem Beispiel: eece5138) sind die ID des Ereignisses, das von der HTTP-Anfrage ausgelöst wurde.',
    'web-app-firewall.auditLogPoint4' => 'Suchen Sie weiter nach anderen Einträgen mit derselben Ereignis-ID. Halten Sie Ausschau nach einem Eintrag mit einem H nach der Ereignis- ID (in unserem Beispiel: eece5138-H--). Dieser Eintrag enthält die ID und die Beschreibung der Sicherheitsregel, die während der Überprüfung der HTTP-Anfrage ausgelöst wurde. Die ID der Sicherheitsregel ist eine ganzzahlige Nummer, die mit 3 beginnt, in Anführungszeichen gesetzt ist und zusammen mit dem Präfix "id" in eckige Klammern gesetzt ist. Zum Beispiel [id "340003"].',
    'web-app-firewall.auditLogPoint5' => 'Finden Sie eine Sicherheitsregel-ID in dem Ereignis mithilfe einer Teilzeichenfolge wie [id "3.',
    'web-app-firewall.auditLogPoint6' => 'Schalten Sie die Sicherheitsregel mit dieser ID unten im Abschnitt der Sicherheitsregeln aus: Geben Sie die ID der Sicherheitsregel (nur Ziffern) in das Feld der Sicherheitsregel-IDs ein und klicken Sie auf OK.',
    'web-app-firewall.auditLogViewLink' => 'ModSecurity-Protokolldatei',
    'web-app-firewall.auditLogListLink' => 'Protokollarchiv',
    'web-app-firewall.errorLogSection' => 'Fehlerprotokoll',
    'web-app-firewall.errorLogSectionHint' => 'Eine Website kann u. U. nicht mehr wie erwartet funktionieren, wenn Sie den Modus der Web Application Firewall von "Aus" oder "Nur Erkennung" zu "Ein" ändern. In diesem Fall sollten Sie das Fehlerprotokoll analysieren, um herauszufinden, was genau passiert. Sie können zu strenge Sicherheitsregeln ausschalten oder die Website anpassen.',
    'web-app-firewall.errorLogViewLink' => 'Fehlerprotokolldatei',
    'web-app-firewall.notificationStateEnabled' => 'Benachrichtigungen in der Plesk Benutzeroberfläche zu Regelsatz-Updates sind aktiviert. %%notificationLink%%',
    'web-app-firewall.notificationStateDisabled' => 'Benachrichtigungen in der Plesk Benutzeroberfläche zu Regelsatz-Updates sind deaktiviert. %%notificationLink%%',
    'web-app-firewall.notificationLink' => 'Auf der Benachrichtigungsseite verwalten',
    'web-app-firewall.detectionOnlyAndThoroughModeWarning' => 'Selecting the "Thorough" option in "Detection Only" mode may cause WordPress sites to malfunction, among other unwanted side effects, because of the following<a href="https://github.com/SpiderLabs/ModSecurity/issues/562" target="_blank">ModSecurity issue</a>.',
];