<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "502 Bad Gateway: upstream enviou cabeçalho muito grande ao ler o cabeçalho de resposta"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache "500 Internal Server Error: Opção FollowSymLinks não permitida aqui"',
    'problem-detail.apache-followsymlinks-not-allowed.description' => '',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "servidor atingiu a configuração max_children"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Sintomas</h4><ul><li><p>Webites que têm manipulador PHP definido como <strong>aplicativo FPM servido por Apache</strong> ou <strong>aplicativo FPM servido por nginx</strong> em <strong>Domínios</strong> &gt; <strong>example.com</strong> &gt; As <strong>Configurações do PHP</strong> apresentam um dos seguintes problemas:</p><ul><li><p>carregamento lento</p></li><li><p>não acessível (permanentemente ou periodicamente) com um erro de 50x em um navegador da Web:</p><pre>502 Bad Gateway</pre><hr><pre>503 Serviço temporariamente indisponível</pre><hr><pre>504 Tempo limite do gateway</pre></li></ul></li><li><p>A seguinte mensagem aparece no arquivo de log de erros PHP-FPM <code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> (onde <em>XX</em> é uma versão PHP usada pelos websites):</p><pre>AVISO: servidor [pool example.com] alcançado configuração max_children (*), considere aumentá-la</pre><ul><li><p>A mensagem acima geralmente é acompanhada com este erro:</p><pre>não é possível ler o que o filho diz: Descritor de arquivo incorreto (9)</pre></li></ul></li><li><p>Se o nginx estiver habilitado no servidor, uma das seguintes mensagens de erro pode aparecer no arquivo de log de erros do domínio <code>/var/ www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 conectar() para unix:///var/www/vhosts/system /example.com/php-fpm.sock falhou (11: Recurso temporariamente indisponível) durante a conexão com upstream, cliente: 203.0.113.2, servidor: example.com, request: "GET / HTTP/1.1", upstream: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", host: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 upstream conexão fechada prematuramente ao ler o cabeçalho de resposta do upstream, cliente: 203.0.113.2, servidor: example.com, solicitação: "POST /path/to/some/file HTTP/2.0", upstream:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>O PHP-FPM <code>pm.max_children</code> foi alcançado pelo(s) website(s).</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1' => '<p>Aumente o limite de <code>pm.max_children</code> para os domínios afetados:</p><ol><li><p>Conecte-se ao servidor Plesk via <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener">SSH</a>.</p></li><li><p>Encontre os domínios afetados usando o comando abaixo:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Observação:</strong> o número à esquerda indica quantas vezes o limite de <code>pm.max_children</code> foi atingido pelo website.</div><pre style="white-space: pre-wrap;"># grep -r "servidor alcançado configuração max_children" /var/log/*php*-fpm/error.log | corte -d\' \' -f5 | tr -d \']\' | classificar | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><0 ><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener">Faça login no Plesk</a>.</p></li><li><p>Vá para <strong>Domínios</strong> &gt; <strong>example.com</strong> &gt; <strong>Configurações do PHP</strong> &gt; <strong>Configurações do PHP-FPM</strong>.</p></li><li><p>Aumente o valor <code>pm.max_children</code> para o domínio e aplique as alterações. Aumente esse valor para todos os domínios listados na etapa 2.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "Muitos arquivos abertos"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx falha ao iniciar/recarregar em um servidor Plesk: muitos arquivos abertos</p><h4>Sintomas</h4><ul><li><p>O serviço nginx falha ao iniciar/recarregar com o seguinte erro no arquivo <code>/var/log/nginx/error.log</code>:</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/www/vhosts/system/example.com /logs/proxy_access_ssl_log" falhou (24: muitos arquivos abertos)</pre></li><li><p>Alguns ou todos os websites não estão acessíveis</p></li><li><p>Aviso é mostrado em <strong>Ferramentas &amp; Configurações &gt; Diagnosticar &amp; reparar</strong>:</p><pre style="white-space: pre-wrap;">Verificando para nginx ULIMIT value N domínios foram encontrados no servidor. Problema com o limite padrão do nginx para arquivos abertos é possível</pre></li><li><p>Aplicativos da web NodeJS e Ruby estão mostrando o erro 502 Bad Gateway ao executar algumas tarefas do Plesk, como criar domínios, assinaturas, alterações no Apache ou Nginx, etc:</p><pre style="white-space: pre-wrap;">Erro de Servidor<br>502 Bad Gateway <br>O servidor Web recebeu uma resposta inválida enquanto atuava como um gateway ou servidor proxy.</pre></li><li><p>Após <a href="https://support.plesk.com/hc/en-us/articles/213946825-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">instalar um novo certificado para o domínio</a>, o antigo ainda é exibido em um navegador da Web, no entanto, o certificado correto é selecionado em <strong>Domínios &gt; example.com &gt; Página de configurações de hospedagem</strong>.</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>O host virtual do Nginx abre 4 arquivos de log para cada host virtual com hospedagem física:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>Como resultado deste fato, o número máximo de arquivos abertos é excedido pelo servidor nginx devido a um grande número de domínios (geralmente, mais de 100).</p>',
    'problem-detail.nginx-too-many-open-files.solution1' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Aviso:</strong> Execução do utilitário <code>websrv_ulimits</code> sem <strong>- A opção -no-restart</strong> inicia a reconstrução dos arquivos de configuração da Web para todos os domínios e pode causar um tempo de inatividade significativo no caso de um grande número de websites hospedados.<br><br>Execute o comando durante o período de manutenção.</div><p>É uma boa prática definir o valor limite de arquivos abertos acima do <strong>número de domínios no Plesk * 16</strong> pelo menos. No exemplo abaixo forneceu ações como definir o limite para 4096:</p><ol><li><p>Conecte-se ao servidor via <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener noreferrer">SSH</a></p></li><li><p>Defina o limite de arquivos abertos para 4096 para Apache e Nginx:</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></9 ><li><p>Reinicie os serviços Apache e nginx em <strong><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>Ferramentas &amp; Configurações &gt; Gerenciamento de serviços</strong> para aplicar as alterações.</p></li><li><p>Verifique se \'Limite máximo de arquivos abertos\' foi aplicado corretamente após a reinicialização dos serviços da Web:</p><pre># grep \'Máximo de arquivos abertos\' /proc/$(cat /var/run/nginx.pid)/limits<br>Máximo de arquivos abertos 4096 4096 file</pre></li><li><p>Se a solução acima fez não ajudou, defina o limite usando o utilitário <code>ulimit</code>:</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "Corpo de resposta muito grande"',
    'problem-detail.apache-modsec-response-body-too-large.description' => '',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "Acesso negado com código 403"',
    'problem-detail.modsec-access-denied.description' => '',
    'problem-detail.modsec-access-denied.cause' => '',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "Erro de servidor interno 500: tamanho de memória permitido de XXX esgotado"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "restrição open_basedir em vigor"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => '',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 Proibido AH01797: cliente negado pela configuração do servidor"',
    'problem-detail.apache-client-denied-by-server.description' => '',
    'problem-detail.apache-client-denied-by-server.cause' => '',
    'problem-detail.apache-no-directory-index.name' => 'Apache "Não é possível acessar um diretório de websites no Plesk: 403 Proibido"',
    'problem-detail.apache-no-directory-index.description' => '',
    'problem-detail.apache-no-directory-index.cause' => '',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "Não é possível acessar um diretório de websites no Plesk: 403 Proibido"',
    'problem-detail.nginx-no-directory-index.description' => '',
    'problem-detail.nginx-no-directory-index.cause' => '',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "servidor atingiu a configuração MaxRequestWorkers"',
    'problem-detail.apache-reached-max-request-workers.description' => '',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'Limite do corpo da solicitação PHP "cliente destinado a enviar corpo muito grande"',
    'problem-detail.php-post-content-length-exceeds-limit.description' => '',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'Limite do corpo da solicitação PHP "cliente destinado a enviar corpo muito grande"',
    'problem-detail.nginx-client-sent-too-large-body.description' => '',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'Sessões PHP "503 Erro Interno do Servidor" ou "Falha ao ler os dados da sessão"',
    'problem-detail.php-failed-to-read-session-data.description' => '',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Forbidden: pcfg_openfile: não foi possível verificar o arquivo htaccess, certifique-se de que seja legível"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => '',
];