<?php
// Copyright 1999-2021. Plesk International GmbH. All rights reserved.
$messages = [
    'admin-info.adminInfoSection' => '管理者用の情報',
    'admin-info.descriptionAdmin' => '管理者の説明',
    'admin-info.descriptionReseller' => 'リセラーの説明',
    'admin-info.descriptionOwner' => '所有者の説明',
    'admin-info.description' => '説明',
    'admin-info.descriptionSuccess' => '説明が更新されました。',
    'admin-info.longDescription' => '入力した説明が長すぎます。%%max%% 文字以内にしてください。',
    'admin-info.add' => '説明を追加',
    'admin-info.edit' => '編集',
    'admin-info.remove' => '削除',
    'admin-info.confirmOnRemove' => 'この説明を削除しますか？',
    'admin-info.popupTitleCustomer' => '顧客 %%name%% に関する %%descriptionType%%',
    'admin-info.popupTitleReseller' => 'リセラー %%name%% に関する %%descriptionType%%',
    'admin-info.popupTitleSubscription' => '契約 %%name%% に関する %%descriptionType%%',
    'admin-info.popupHintAdmin' => 'この説明は管理者にのみ表示されます。',
    'admin-info.popupHintReseller' => 'この説明はリセラーおよび管理者に表示されます。',
    'admin-info.popupHintOwner' => 'この説明は作成者および作成者のホスティング事業者に表示されます。',
    'admin-info.customerDescriptionHint' => '顧客はこの説明を参照できません。',
    'admin-info.subscriptionDescriptionHint' => "この情報はホスティング事業者にのみ表示されます（Plesk 管理者またはリセラー）。",

    'apache-settings.formGeneralHint' => 'このウェブサイトの Apache ウェブサーバ設定を指定することができます。カスタム Apache 構成は、ウェブサイトのインデックスファイルに新しいファイルタイプを使用したい場合や、特定のファイル名拡張子と特定の MIME タイプを関連付けたい場合に便利です。デフォルト値にすると、Apache はサーバ全体の構成に定義されたディレクティブを使用します。Apache のフロントエンドサーバとして nginx を使用している場合、このページで nginx 設定も指定することができます。',
    'apache-settings.general' => 'Apache 共通設定',
    'apache-settings.example' => "例：\n%%example%%",
    'apache-settings.settingOn' => 'オン',
    'apache-settings.settingOff' => 'オフ（デフォルト）',
    'apache-settings.settingDefault' => 'デフォルト',
    'apache-settings.settingCustom' => 'カスタム値を入力',
    'apache-settings.mimeTypes' => 'MIME タイプ',
    'apache-settings.mimeTypesExample' => "text/plain .txt\nimage/jpeg .jpeg \n\nMIME タイプは、ファイルの拡張子とファイルタイプを関連付けます。通常は、一般的なファイルタイプ用にカスタムファイル拡張子を作成するために使用されます。",
    'apache-settings.handlers' => 'ハンドラ',
    'apache-settings.handlersExample' => "php-script .php\ncgi-script .cgi \n\nApache ハンドラは、特定の拡張子のファイルが要求された場合にウェブサーバがファイルをどのように処理するかを定義します。例えば、「php-script .script」という文字列は、Apache が .script ファイルを php スクリプトとして処理することを意味します。",
    'apache-settings.deny' => 'サイトへのアクセスを拒否',
    'apache-settings.allow' => '除外',
    'apache-settings.denyExample' => "10.1.0.0/16\n192.168.1.110\n\n指定されたホストとネットワークに対して、このサイトへのアクセスを禁止します。すべての接続を拒否するには「*」を使用します。",
    'apache-settings.allowExample' => "192.168.0.0/16\n10.1.1.21\n\n指定したホストとネットワークは、サイトへのアクセスが許可されます。",
    'apache-settings.directoryIndex' => 'インデックスファイル',
    'apache-settings.directoryIndexExample' => "index.htm index.php index.pl \n\nサイトのインデックスページが要求された場合、Apache は指定されたファイルを探します。",
    'apache-settings.expires' => '期限切れ',
    'apache-settings.expiresStaticOnly' => '静的ファイルに対してのみ期限切れヘッダ付きで応答',
    'apache-settings.expiresDescription' => 'ウェブサーバは「期限切れ」応答ヘッダをウェブページに追加します。期限切れタイムスタンプは、ウェブページがリクエストされた時間に、上に指定された時間を加算することで計算されます。',
    'apache-settings.expiresStaticOnlyDescription' => '「期限切れ」ヘッダは静的ファイルにのみ追加されます。どのファイルが静的ファイルとして処理されるかは、「スマート統計ファイル処理」および「静的ファイルを nginx で直接処理」オプションによって制御されます。',
    'apache-settings.expiresUnitDays' => '日',
    'apache-settings.expiresUnitHours' => '時間',
    'apache-settings.expiresUnitMinutes' => '分',
    'apache-settings.expiresUnitSeconds' => '秒',
    'apache-settings.headers' => '追加ヘッダ',
    'apache-settings.headersExample' => "Cache-Control: public Strict-Transport-Security: max-age=63072000 X-Frame-Options: DENY\n\nウェブサーバにより、指定した HTTP 応答ヘッダが追加されます。",
    'apache-settings.restrictFollowSymLinks' => 'シンボリックリンクのフォローを制限する',
    'apache-settings.restrictFollowSymLinksDescription' => "このオプションをオンにすると、ユーザが FollowSymLink ディレクティブを .htaccess で使用することが禁止され、サーバのセキュリティが強化されます。",
    'apache-settings.nginx' => 'nginx 設定',
    'apache-settings.nginxProxyMode' => 'プロキシモード',
    'apache-settings.nginxProxyModeDescription' => 'Nginx が Apache にリクエストをプロキシします。Apache の使用を停止する場合はオフにしてください。',
    'apache-settings.nginxTransparentMode' => 'スマート統計ファイル処理',
    'apache-settings.nginxTransparentModeDescription' => 'オフにすると、静的ファイルに対するすべての要求は Apache で処理されます。nginx は要求を変更せずに受け渡すだけです。このオプションをオフにするのは、トラブルシューティング目的のみにしてください。',
    'apache-settings.nginxServeStatic' => '静的ファイルを nginx で直接処理',
    'apache-settings.nginxStaticExtensions' => 'ファイル拡張子をスペースまたは「|」記号で区切って指定します。これらのファイルへの要求は nginx で処理され、Apache には送られません。注意：Apache の書き換えルールは適用されません。',
    'apache-settings.nginxServePhp' => 'PHP を nginx で処理',
    'apache-settings.nginxServePhpDescription' => 'PHP ファイル（.php）は nginx と PHP-FPM で処理されます。オフにすると、PHP ファイルは Apache で処理されます。',
    'apache-settings.nginxCacheEnabled' => 'nginx キャッシュを有効にする',
    'apache-settings.nginxCacheEnabledDescription' => 'キャッシュにより、ウェブサイトの応答時間が短縮され、サーバの負荷が軽減されますが、取り扱いには注意が必要です。',
    'apache-settings.nginxCacheSize' => 'キャッシュサイズ',
    'apache-settings.nginxCacheSizeGb' => 'GB',
    'apache-settings.nginxCacheSizeMb' => 'MB',
    'apache-settings.nginxCacheSizeKb' => 'KB',
    'apache-settings.nginxCacheSizeBytes' => 'B',
    'apache-settings.nginxCacheTimeout' => 'キャッシュタイムアウト',
    'apache-settings.nginxCacheTimeoutDays' => '日',
    'apache-settings.nginxCacheTimeoutHours' => '時間',
    'apache-settings.nginxCacheTimeoutMinutes' => '分',
    'apache-settings.nginxCacheTimeoutSeconds' => '秒',
    'apache-settings.nginxCacheKey' => 'キャッシュキー',
    'apache-settings.nginxCacheCookies' => 'cookie のあるリクエストをキャッシュ',
    'apache-settings.nginxCacheBypassLocations' => '次の場所でキャッシュを無効にする',
    'apache-settings.nginxCacheBypass' => '次の場合にキャッシュをバイパス：',
    'apache-settings.nginxCacheBypassHeaderNocache' => 'リクエストで HTTP no-cache ヘッダを受け取った',
    'apache-settings.nginxCacheBypassHeaderAuth' => 'リクエストで HTTP 認証ヘッダを受け取った',
    'apache-settings.nginxCacheBypassGetNocache' => 'リクエストで GET nocache パラメータを受け取った',
    'apache-settings.nginxCacheUseStale' => 'キャッシュが古いレコードを戻す',
    'apache-settings.nginxCacheUseStale5xx' => 'Upstream が 5xx サーバエラーを返す',
    'apache-settings.nginxCacheUseStale4xx' => 'Upstream が 4xx クライアントエラーを返す',
    'apache-settings.nginxCacheUseStaleUpdating' => 'キャッシュを更新中です',
    'apache-settings.additional' => 'Apache 追加ディレクティブ',
    'apache-settings.additionalSettingsDescription' => '特定の設定が見つからない場合、以下のフィールドに追加してください。ディレクティブは最終的な Apache 構成に追加されます。最初のフィールドのディレクティブは、訪問者がサイトに HTTP アクセスすると使用されます。2 番目のフィールドは、HTTPS 用ディレクティブです。一般に、両フィールドにディレクティブを追加する必要があります。httpd.include と同じ構文にしてください。例えば、カスタムエラーページを設定したい場合、「ErrorDocument 401 /my_error_page.html」という行を追加してください。',
    'apache-settings.additionalSettings' => 'HTTP 用追加ディレクティブ',
    'apache-settings.additionalSslSettings' => 'HTTPS 用追加ディレクティブ',
    'apache-settings.additionalSettingsError' => 'Apache 構成が無効です。%%error%%',
    'apache-settings.rollbackFailed' => '現在の Apache 構成ファイルを使用したり、このファイルの旧バージョンにロールバックすることができません。無効な構成が含まれています。',
    'apache-settings.additionalNginx' => 'nginx 追加ディレクティブ',
    'apache-settings.additionalNginxSettingsDescription' => 'Apache の手前で機能する nginx リバースプロキシサーバの設定を指定します。ディレクティブによって、サーバ全体の nginx 構成がオーバーライドされます。例えば、接続タイムアウトの設定を変更したり、要求を gzip でパックすることができます。構文は、nginx.conf で使用する構文と同じものを使用してください。例えば、プロキシされたすべての要求を gzip で圧縮したい場合、「gzip_proxied any;」という行を追加します。',
    'apache-settings.additionalNginxSettings' => 'nginx 追加ディレクティブ',
    'apache-settings.additionalNginxSettingsError' => 'nginx 構成が無効です。%%error%%',
    'apache-settings.nginxRollbackFailed' => '最新の nginx 構成ファイルを使用することや、構成ファイルを前バージョンにロールバックすることができません。これらの両バージョンに、無効な構成が含まれています。',

    'backup.backup-password-protection.securitySettingsSection' => 'バックアップのセキュリティ設定',
    'backup.backup-password-protection.backupPasswordFromFtpSettings' => 'リモートストレージの設定からパスワードを取得',
    'backup.backup-password-protection.backupPasswordManualInput' => 'パスワードを手入力',
    'backup.backup-password-protection.providePasswordCheckbox' => 'パスワードを入力',
    'backup.backup-password-protection.backupPassword' => 'パスワード',
    'backup.backup-password-protection.inputPasswordType' => 'パスワードのタイプ',
    'backup.backup-password-protection.confirmBackupPassword' => 'パスワード再入力',
    'backup.backup-password-protection.backupPasswordHint' => 'パスワードを忘れた場合は、このオプションをオフにしてください。オフにすると、一部の機密データが正しく復元されなくなる可能性があります。例えば、ユーザパスワードがランダムなパスワードに変更され、インストール済み APS アプリケーションに関する情報が削除されます。',
    'backup.backup-password-protection.backupPasswordFtpHint' => 'このバックアップにパスワード保護を適用した場合、下のフィールドにパスワードを入力してください。パスワードを誤入力すると、バックアップが復元できません。代わりに、バックアップはローカルストレージに復元されます。',

    'backup.conflict-database.dbMappingLegend' => 'データベースサーバのマッピング',
    'backup.conflict-database.serverType' => 'サーバのタイプ',
    'backup.conflict-database.hostName' => 'ホスト名',
    'backup.conflict-database.port' => 'ポート',
    'backup.conflict-database.destinationDbServer' => '宛先データベースサーバ',
    'backup.conflict-database.mysql' => 'MySQL',
    'backup.conflict-database.postgresql' => 'PostgreSQL',
    'backup.conflict-database.mssql' => 'MSSQL',
    'backup.conflict-database.migrationDbServerNotFind' => 'データベースを復元できません。適切なデータベースサーバがありません。',

    'backup.conflict-ip.buttonUploadMappingFile' => 'IP マッピングファイルをアップロード',
    'backup.conflict-ip.ipMappingLegend' => 'IP マッピング',
    'backup.conflict-ip.buttonSaveCurrentMapping' => '現在の IP マッピングをファイルに保存',
    'backup.conflict-ip.ipAddressNotFound' => 'このタイプの IP アドレスには空きがありません。',
    'backup.conflict-ip.sharedIp' => '共用',
    'backup.conflict-ip.dedicatedIp' => '専用',
    'backup.conflict-ip.fileNotFound' => 'ファイルは空でなければなりません。',
    'backup.conflict-ip.invalidIpToMap' => '古い IP アドレスの値が無効です。%%ip%%',
    'backup.conflict-ip.invalidMappingValue' => '新しい IP アドレスの値が無効です。%%ip%%',
    'backup.conflict-ip.ipNotFound' => 'IP アドレス %%ip%% がデータベースにありません。',
    'backup.conflict-ip.uploadIpMappingFileLegend' => 'IP マッピングファイルをアップロード',
    'backup.conflict-ip.ipMappingFileHint' => 'IP マッピングファイルはテキストファイルです。ファイルの各行に、IP マッピングが <old IP address> <new IP address> という書式で含まれています。',
    'backup.conflict-ip.oldIp' => '古い IP アドレス',
    'backup.conflict-ip.newIp' => '新しい IP アドレス',

    'backup.copy-to-server.ignoreBackupSign' => '有効な署名のないバックアップファイルをアップロード',
    'backup.copy-to-server.wrongPassword' => '指定したパスワードが正しくありません。バックアップの復元中に、パスワードを再入力する必要があります。',
    'backup.copy-to-server.corruptedSignatureUploaded' => 'アップロード済みのバックアップファイル %%fileName%% は、変更または破損しているか、別のサーバで作成されたものか、バックアップファイルの署名をサポートしていない旧バージョンの Plesk で作成されたものです。このバックアップファイルからデータを復元する前に、このファイルのソースを信頼できるか確認してください。',
    'backup.copy-to-server.corruptedSignatureNotUploadedUser' => 'バックアップファイル %%fileName%% をアップロードできません。このファイルのデータは、変更または破損しているか、別のサーバまたは旧バージョンの Plesk で作成されています。このファイルのデータを復元するためには、ホスティング事業者までお問い合わせください。',
    'backup.copy-to-server.corruptedSignatureNotUploadedAdmin' => 'バックアップファイル %%fileName%% をアップロードできません。このファイルは変更されたか、破損しています。あるいは、別のサーバで作成されたか、バックアップファイルの署名をサポートしていない旧バージョンの Plesk で作成されています。このバックアップが信頼できる場合、［有効な署名のないバックアップファイルをアップロード］オプションをオンにしてアップロードをやり直してください。',
    'backup.copy-to-server.unableToMoveToLocalRepository' => "選択したバックアップ %%fileName%% をサーバストレージに移動できません。エラー：%%error%%。",
    'backup.copy-to-server.missedPartsWarning' => "増分バックアップのうち、次の部分がコピーされていません。%%endl%%%%missedParts%%%%endl%% 欠落部分をコピーしてください。",

    'backup.ftp-settings.isActive' => 'FTP（S）ストレージを使用',
    'backup.ftp-settings.host' => 'FTP サーバのホスト名または IP',
    'backup.ftp-settings.directory' => 'バックアップファイルストレージのディレクトリ',
    'backup.ftp-settings.directoryHint' => '例： /myfolder/mybackups/',
    'backup.ftp-settings.ftpLogin' => 'FTP ユーザ名',
    'backup.ftp-settings.ftpPassword' => 'FTP パスワード',
    'backup.ftp-settings.usePassiveMode' => 'パッシブモードを使用',
    'backup.ftp-settings.useFtps' => 'FTPS を使用',
    'backup.ftp-settings.errorHostIsLocal' => 'ローカル Plesk の FTP サーバをリモートストレージとして使用することは禁止されています。 リモートロケーションを指定してください。',
    'backup.ftp-settings.warningHostIsLocal' => 'FTP（S）ストレージ設定は、契約のファイルの保存先サーバにバックアップを保存するように構成されています。このような構成は、データ損失およびディスクスペース利用超過のリスクがあるため、推奨されません。',
    'backup.ftp-settings.enterFtpLogin' => '正しいユーザ名を入力してください。',
    'backup.ftp-settings.enterFtpPassword' => '正しいパスワードを入力してください。',

    'backup.remote-settings.isActive' => 'ストレージを使用',
    'backup.remote-settings.initError' => '%%extName%% 設定ページを初期化できません。%%error%%',

    'backup.remote-storages.backupSecuritySettings' => 'バックアップのセキュリティ設定',

    'backup.restore.detailsSection' => '説明',
    'backup.restore.contentInfoSection' => 'バックアップのコンテンツ',
    'backup.restore.restorationOptionsSection' => '復元オプション',
    'backup.restore.emailNotification' => '復元作業の完了時に通知を送信',
    'backup.restore.comments' => 'コメント',
    'backup.restore.creationDate' => '作成日',
    'backup.restore.systemNotes' => 'システムノート',
    'backup.restore.ownerAdmin' => '管理者が作成',
    'backup.restore.ownerReseller' => 'リセラーが作成',
    'backup.restore.ownerCustomer' => '顧客が作成',
    'backup.restore.ownerServiceUser' => '追加ユーザによって作成',
    'backup.restore.partOfParentBackup' => '%%type%% バックアップの一部。',
    'backup.restore.server' => 'サーバ',
    'backup.restore.reseller' => 'リセラー',
    'backup.restore.client' => '顧客',
    'backup.restore.incremental' => '増分',
    'backup.restore.multiVolume' => 'マルチボリューム',
    'backup.restore.backupSize' => 'バックアップサイズ',
    'backup.restore.backupSizeFirstIncremental' => '%%this%%（今回の増分）+ %%base%%（初回バックアップ）= %%total%%',
    'backup.restore.backupSizeIncremental' => '%%this%%（今回の増分）+ %%prev%%（過去の増分） + %%base%%（初回バックアップ）= %%total%%',
    'backup.restore.download' => 'ダウンロード',
    'backup.restore.downloadHint' => 'バックアップファイルをローカルコンピュータにダウンロードします。',
    'backup.restore.downloadDisabled' => '現在、バックアップファイルのダウンロードは実行できません。後でお試しいただくか、サービスプロバイダまでお問い合わせください。',
    'backup.restore.copy' => 'サーバストレージにコピー',
    'backup.restore.copyHint' => '選択したバックアップファイルをサーバストレージにコピーします。',
    'backup.restore.contentInfo' => 'バックアップの内容',
    'backup.restore.restoreButton' => '復元',
    'backup.restore.mail' => 'メール',
    'backup.restore.domainConfiguration' => 'ドメイン構成',
    'backup.restore.virtualHost' => '仮想ホストのコンテンツ',
    'backup.restore.database' => 'データベース',
    'backup.restore.serverConfiguration' => 'サーバ設定',
    'backup.restore.serverConfigurationLicense' => 'ライセンスキー',
    'backup.restore.serverPersonalConfiguration' => '管理者アカウントの構成',
    'backup.restore.serverPersonalDomains' => '管理者のドメイン',
    'backup.restore.serverPersonalClients' => '管理者の顧客',
    'backup.restore.resellers' => 'リセラー',
    'backup.restore.resellerPersonalConfiguration' => 'リセラーアカウントの構成',
    'backup.restore.resellerPersonalDomains' => 'リセラーのドメイン',
    'backup.restore.resellerPersonalClients' => 'リセラーの顧客',
    'backup.restore.clientPersonalConfiguration' => '顧客アカウントの構成',
    'backup.restore.clientPersonalDomains' => '顧客のドメイン',
    'backup.restore.restoreModifiedSection' => '署名が破損していてもバックアップファイルを復元する',
    'backup.restore.restoreModifiedDump' => '有効な署名がなくてもこのバックアップを復元する',
    'backup.restore.resolutionPolicy' => '解決ポリシー',
    'backup.restore.resolutionPolicyDescription' => '変更日がより新しい復元対象オブジェクトが既に存在しているか、復元対象オブジェクトが現在システムに存在しない場合、タイミングの競合が発生します。',
    'backup.restore.backupRestoreFtpWrongPassword' => '指定したパスワードが正しくありません。バックアップファイルがサーバのローカルストレージにコピーされます。',
    'backup.restore.backupRestoreLocalWrongPassword' => 'バックアップを復元できません。指定したパスワードが正しくありません。',
    'backup.restore.serverContentAndConfiguration' => 'サーバの構成とコンテンツ',
    'backup.restore.serverConfigurationOnly' => 'サーバ構成',
    'backup.restore.resellerContentAndConfiguration' => 'リセラーアカウントの構成とコンテンツ',
    'backup.restore.resellerConfigurationOnly' => 'リセラーアカウントの構成',
    'backup.restore.clientContentAndConfiguration' => '顧客アカウントの構成とコンテンツ',
    'backup.restore.clientConfigurationOnly' => '顧客アカウントの構成',
    'backup.restore.domainContentAndConfiguration' => 'ドメインの構成とコンテンツ',
    'backup.restore.domainConfigurationOnly' => 'ドメイン構成',
    'backup.restore.restoreType' => '復元対象範囲',
    'backup.restore.restoreTypeFull' => 'すべてのオブジェクト（システム全体）',
    'backup.restore.restoreTypeGranular' => '選択したオブジェクト',
    'backup.restore.restoreObjectType' => '復元対象オブジェクトのタイプ',
    'backup.restore.restoreObjectTypeSubscriptions' => '契約',
    'backup.restore.restoreObjectTypeCustomers' => '顧客',
    'backup.restore.restoreObjectTypeResellers' => 'リセラー',
    'backup.restore.restoreObjectTypeMailUsers' => 'メールアカウント',
    'backup.restore.restoreObjectTypeDatabases' => 'データベース',
    'backup.restore.restoreObjectTypeCertificates' => 'SSL/TLS 証明書',
    'backup.restore.restoreObjectTypeSites' => 'サイト',
    'backup.restore.restoreObjectTypeDnsZones' => 'DNS ゾーン',
    'backup.restore.restoreObjectTypeMailLists' => 'メーリングリスト',
    'backup.restore.restoreObjectTypeWebContent' => 'ドメインのファイル',
    'backup.restore.restoreObjects' => '%%objectType%%',
    'backup.restore.restoreObjectsWebContent' => '選択したファイル',
    'backup.restore.restoreSubscriptionLookup' => '契約',
    'backup.restore.restoreComponents' => '復元対象コンポーネント',
    'backup.restore.errorLog' => 'エラーログ',
    'backup.restore.backupDetailsLogDoesntExist' => 'バックアップログがありません。',
    'backup.restore.dumpFailedSection' => 'エラーログ',
    'backup.restore.dumpFailed' => 'データを復元できません。このバックアップファイルは無効です。',
    'backup.restore.granularNotSupported' => '復元対象のオブジェクトを選択することができるのは、Plesk 12.0 以降で作成したバックアップを復元する場合に限られます。',
    'backup.restore.fullNotSupportedInResellerPowerUser' => 'バックアップからの全データの復元は、リセラーのパワーユーザビューではサポートされていません。復元するオブジェクトを選択してください。%%interfaceLink%% でインターフェースビューを変更することができます。',
    'backup.restore.interfaceLink' => 'インターフェース設定',
    'backup.restore.contentRestoreType' => '復元',
    'backup.restore.contentRestoreTypeSettingsOnly' => '選択したオブジェクトの構成のみ',
    'backup.restore.contentRestoreTypeFull' => '選択したオブジェクトの構成とコンテンツ',
    'backup.restore.errorWrongFormat' => 'バックアップを復元できません。ファイルのフォーマットが正しくありません。',
    'backup.restore.errorContentError' => '一部のデータを復元できません。バックアップにコンテンツエラーが含まれています。',
    'backup.restore.warningSignError' => 'バックアップの署名を検証できません。このバックアップファイルは変更されているか、破損しているか、別のサーバまたは旧バージョンの Plesk で作成されています。',
    'backup.restore.warningSignErrorNotAdmin' => 'このバックアップは Plesk 管理者のみが復元できます。',
    'backup.restore.warningPartial' => "増分バックアップのうち次の部分が見つかりません。 %%endl%%%%missedParts%%%%endl%% 一部のファイルが復元されない可能性があります。欠落部分をアップロードし、再び復元を試みてください。",
    'backup.restore.warningDeprecatedBackupVersion' => '復元しようとしているバックアップは、サポートされない Plesk バージョンで作成されており、復元できません。古い Plesk バージョンからデータを移行するには、Plesk Migrator 拡張を使用してください。',
    'backup.restore.encryptionKeyError' => 'このバックアップの 1 つ以上のアカウントのパスワードが復元できないため、リセットされます。このバックアップは、別の Plesk サーバに作成され、その暗号化キーで暗号化された可能性があります。',
    'backup.restore.errorCorruptedContent' => '以下のファイルが見つからないか、破損しています：',
    'backup.restore.statusSection' => 'バックアップステータス',
    'backup.restore.statusDetails' => 'ステータスの詳細',
    'backup.restore.restoreBlocked' => 'バックアップを復元できません。',
    'backup.restore.restoreBlockedDescription' => '現在、タイプ %%backupType%% のバックアップを復元できません。復元するには、バックアップの所有者としてログインし、バックアップマネージャでこのバックアップ名をクリックします。',

    'backup.schedule.scheduleSection' => 'スケジュール',
    'backup.schedule.backupEnable' => 'このバックアップタスクをアクティブにする',
    'backup.schedule.backupPeriod' => 'バックアップタスクの実行スケジュール',
    'backup.schedule.on' => 'on',
    'backup.schedule.at' => 'at',
    'backup.schedule.useIncremental' => '増分バックアップを使用',
    'backup.schedule.fullBackupPeriod' => 'フルバックアップを実行',
    'backup.schedule.daily' => '毎日',
    'backup.schedule.weekly' => '毎週',
    'backup.schedule.monthly' => '毎月',
    'backup.schedule.yearly' => '毎年',
    'backup.schedule.days' => '日',
    'backup.schedule.weeks' => '週間',
    'backup.schedule.months' => 'ヶ月',
    'backup.schedule.years' => '年',
    'backup.schedule.backupTimeDescription' => 'タイムゾーン：%%timezone%%',
    'backup.schedule.systemTimeZone' => 'デフォルトのシステムタイムゾーン',
    'backup.schedule.first' => '1',
    'backup.schedule.last' => '最終',
    'backup.schedule.dayOfMonth' => '日',
    'backup.schedule.email' => 'このバックアップタスクを実行中にエラーが発生したときに、次の宛先に通知メールを送信',
    'backup.schedule.invalidFields' => '一部のフィールド（%%fields%%）が空であるか無効な値が含まれています。',
    'backup.schedule.maxDumpFiles' => '保存するフルバックアップファイルの最大数（スケジュール済みバックアップと手動バックアップの両方を含む）',
    'backup.schedule.maxDumpFilesUnlimitedDescription' => 'フルバックアップを自動削除しない場合、このフィールドは空欄にしてください。',
    'backup.schedule.maxDumpFilesLimitedDescription' => 'ホスティング事業者がサーバストレージに指定した上限は %%max%% です。したがって制限値は %%max%% 以下にしてください。',
    'backup.schedule.backupToCloudIsNotAllowed' => 'リモートクラウドストレージに契約のスケジュール済みバックアップを保存する機能は有料であり、Plesk オンラインストアからご購入いただけます。',

    'backup.secure-backup.hint' => 'パスワードを使用して、Plesk データベースに含まれているユーザのパスワードをバックアップ内で暗号化することができます。パスワード保護されたバックアップを復元するときにパスワードを指定しなければ、Plesk によってユーザのパスワードがランダムに生成されます。',
    'backup.secure-backup.hintAdmin' => 'Plesk 暗号化キーまたはパスワードを使用して、バックアップ内に含まれる Plesk データベースのパスワードを暗号化できます。このキーは Plesk インストールごとに一意です。このキーで暗号化されたバックアップは、それが作成された Plesk インストールでのみ復元可能で、別の Plesk インストールでは復元できません。Plesk では、バックアップ内の機密データの一部が保護されません。リモートクラウドストレージにバックアップを保存し、クラウドストレージ側でバックアップの暗号化を有効にすることをお勧めします。',
    'backup.secure-backup.usePasswordProtection' => 'パスワード保護を使用する（推奨）',
    'backup.secure-backup.backupPasswordSource' => 'パスワードのタイプ',
    'backup.secure-backup.pleskKey' => 'Plesk の暗号化キー',
    'backup.secure-backup.userPassword' => '指定されたパスワード',
    'backup.secure-backup.password' => 'パスワード',
    'backup.secure-backup.passwordConfirmation' => 'パスワード再入力',

    'backup.subform.settingsSection' => 'バックアップ設定',
    'backup.subform.prefix' => 'バックアップ名にプレフィックスを追加',
    'backup.subform.comment' => 'コメント',
    'backup.subform.splitSize' => 'マルチボリュームバックアップを作成、ボリュームサイズ（MB）',
    'backup.subform.repository' => '保存場所',
    'backup.subform.repositoryDescription' => 'FTP（S）ストレージ設定が指定されていません。%%configure%%',
    'backup.subform.localAndSpecialRepositoryBackup' => 'サーバストレージと%%name%%の両方',
    'backup.subform.remoteRepository' => 'リモートストレージ',
    'backup.subform.remoteRepositoryText' => 'リモートクラウドストレージを選択',
    'backup.subform.configureRemoteRepositories' => 'クラウドにバックアップを保存するには、<a href="%%url%%">リモートストレージを構成</a>できます',
    'backup.subform.configureFtpRepository' => '<a href="%%url%%">FTP ストレージを構成</a>して、このストレージにバックアップを保持できます',
    'backup.subform.repositoryConfigure' => '構成',
    'backup.subform.email' => 'バックアップタスクの完了時に、次の宛先に通知メールを送信',
    'backup.subform.contentSection' => 'バックアップのコンテンツ',
    'backup.subform.domainConfiguration' => 'ドメイン構成',
    'backup.subform.domainConfigurationVhost' => 'ユーザファイルおよびデータべース',
    'backup.subform.domainConfigurationMail' => 'メールの構成とコンテンツ',
    'backup.subform.content' => 'バックアップ',
    'backup.subform.backupAll' => 'すべての構成とコンテンツ',
    'backup.subform.backupVhost' => 'メール以外のすべての構成とコンテンツ',
    'backup.subform.backupMail' => 'メールの構成とコンテンツのみ',
    'backup.subform.mssqlNativeBackup' => '可能であればネイティブ MS SQL バックアップ機能を使用',
    'backup.subform.mssqlNativeBackupAdmin' => 'ネイティブ MS SQL バックアップ機能を使用（リモートデータベースの場合、［ツールと設定］ >  ［データベースサーバ］でリモート MS SQL サーバのバックアップ設定を構成したことを確認してください）',
    'backup.subform.localRepository' => 'サーバストレージ',
    'backup.subform.localRepositoryPath' => 'サーバストレージ %%path%%',
    'backup.subform.backupNodeRepository' => '',
    'backup.subform.ftpRepository' => 'FTP（S）ストレージ（%%uri%%）の<a href="%%link%%">設定変更</a>',
    'backup.subform.ftpRepositoryText' => 'FTP（S）ストレージ（%%uri%%）',
    'backup.subform.type' => 'タイプ',
    'backup.subform.typeFullBackup' => 'フル',
    'backup.subform.typeIncremental' => '増分',
    'backup.subform.typeIncrementalDescription' => '前回のバックアップ後に変更されたウェブホスティングデータをバックアップします（データベースデータは常にフルバックアップされます）。',
    'backup.subform.incrementalNotAvailable' => '増分バックアップを作成するには、まずフルバックアップを作成してください。',
    'backup.subform.excludeLogs' => 'ログファイルを除外',
    'backup.subform.excludeFiles' => 'バックアップから特定のファイルを除外',
    'backup.subform.excludeFilesDescription' => 'ウェブスペース内のファイルのみを除外できます。ウェブスペースのルートを基準にして相対パスを指定します。個々のファイルはコンマで区切ってください。マスクシンボルの使用が許可されます（例： /somedir/log*）。',

    'backup.upload.uploadHint' => 'ここで Plesk ストレージにバックアップファイルをアップロードできます。最大ファイルサイズは 2 GB に制限されています。',
    'backup.upload.backupFile' => 'バックアップファイル',
    'backup.upload.removeLink' => '削除',
    'backup.upload.addFileLink' => '追加ファイルをアップロード',
    'backup.upload.backupSecuritySettings' => 'バックアップのセキュリティ設定',
    'backup.upload.signatureHint' => 'Plesk はバックアップファイルの構造と署名が有効であるかどうかをチェックします。変更されたファイル、破損ファイル、別のサーバで作成されたファイルは信頼できません。以下のオプションで、このようなファイルからデータを復元できます。このようなファイルをアップロードすると、セキュリティ上問題があるか、サーバが破壊する可能性があります。したがって、このオプションは、バックアップソースを信頼できる場合に限って選択してください。注記：11.5 より前の Plesk バージョンで作成したバックアップファイルには署名がないため、信頼できないと見なされます。このようなファイルは、ソースが信頼できる場合に復元してください。',
    'backup.upload.ignoreSign' => '有効な署名のないバックアップファイルをアップロード',
    'backup.upload.passwordHint' => 'このバックアップに対してパスワード保護を使用した場合、下のフィールドにパスワードを入力してください。パスワードを誤入力すると、警告が表示されますが、サーバへのバックアップファイルのアップロードは実行されます。バックアップを復元するときに、このパスワードの入力が再び要求されます。',
    'backup.upload.alreadyExistsWarning' => 'バックアップファイル %%fileName%% はサーバのローカルストレージに既に存在します。',
    'backup.upload.incorrectPasswordWarning' => '指定したパスワードが正しくありません。バックアップの復元中に、パスワードを再入力する必要があります。',
    'backup.upload.deprecatedDumpError' => 'アップロードしようとしているバックアップは、サポートされない Plesk バージョンで作成されており、インポートできません。古い Plesk バージョンからデータを移行するには、Plesk Migrator 拡張を使用してください。',
    'backup.upload.mailFormatWarning' => 'バックアップファイル %%fileName%% がストレージにアップロードされました。重要：バックアップファイル %%fileName%% には、サポートされないフォーマット（Plesk 8.3～8.6）が原因で復元できないメールコンテンツが含まれています。このメールコンテンツを復元するためには、Plesk バックアップツールを使用してこれをバックアップし、メールボックスコンテンツのバックアップオプションを選択し、メールサーバにダンプを復元するオプションを選択してください。',
    'backup.upload.corruptedSignatureAdminWarning' => 'アップロード済みのバックアップファイル（%%fileName%%）は、変更または破損しているか、別のサーバで作成されたものか、バックアップファイルの署名をサポートしていない旧バージョンの Plesk で作成されたものです。このバックアップファイルからデータを復元する前に、このファイルのソースを信頼できるか確認してください。',
    'backup.upload.corruptedSignatureAdminError' => 'バックアップファイル（%%fileName%%）をアップロードできません。このファイルは変更または破損しているか、別のサーバで作成されたものか、バックアップファイルの署名をサポートしていない旧バージョンの Plesk で作成されたものです。このバックアップを信頼できる場合、［有効な署名のないバックアップファイルをアップロード］オプションをオンにしてアップロードをやり直してください。',
    'backup.upload.corruptedSignatureUserWarning' => 'アップロード済みのバックアップファイル（%%fileName%%）は、変更または破損しているか、別のサーバまたは旧バージョンの Plesk で作成されています。',
    'backup.upload.corruptedSignatureUserError' => 'バックアップファイル（%%fileName%%）をアップロードできません。このファイルのデータは、変更または破損しているか、別のサーバまたは旧バージョンの Plesk で作成されています。このファイルのデータを復元するためには、ホスティング事業者までお問い合わせください。',
    'backup.upload.uploadError' => '%%fileName%% をサーバストレージ %%error%% にアップロードできません',
    'backup.upload.fileNotSelected' => 'アップロード用に選択されたファイルがありません。ファイルを少なくとも 1 つ選択してください。',
    'backup.upload.missedPartsWarning' => "増分バックアップのうち、次の部分がアップロードされていません。%%endl%%%%missedParts%%%%endl%% 欠落部分をアップロードしてください。",
    'backup.upload.unknownType' => '不明なオブジェクトタイプ',
    'backup.upload.storageLink' => '別のストレージ',
    'backup.upload.anotherStorage' => 'ダンプは%%storageLink%%にアップロードされました。',
    'backup.upload.resellerNotFound' => 'リセラー %%name%% が見つかりません。これを作成してから、アップロードしたダンプを復元してください。',
    'backup.upload.clientNotFound' => '顧客 %%name%% が見つかりません。これを作成してから、アップロードしたダンプを復元してください。',
    'backup.upload.domainNotFound' => 'ドメイン %%name%% が見つかりません。これを作成してから、アップロードしたダンプを復元してください。',

    'backup.web-content-dynamic.addButtonTitle' => 'ファイルを追加',
    'backup.web-content-dynamic.noItems' => 'ファイルが選択されていません',
    'backup.web-content-dynamic.hint' => 'チェックボックスでファイルとフォルダを選択してください。',
    'backup.web-content-dynamic.title' => 'ファイルを選択',
    'backup.web-content-dynamic.columnName' => '名前',
    'backup.web-content-dynamic.columnChangeDate' => '変更済み',
    'backup.web-content-dynamic.columnSize' => 'サイズ',
    'backup.web-content-dynamic.columnPermissions' => 'パーミッション',
    'backup.web-content-dynamic.columnUser' => 'ユーザ',
    'backup.web-content-dynamic.columnGroup' => 'グループ',
    'backup.web-content-dynamic.waitButtonTitle' => 'お待ちください',
    'backup.web-content-dynamic.loadingTitle' => '読み込み中...しばらくお待ちください。',

    'backup.invalidFields' => '一部のフィールドが空であるか無効な値が含まれています。',
    'backup.notEnoughDiskSpace' => '%%path%% には、バックアップの作成に十分なディスク容量がありません。空き容量が少なくとも %%required%% GB 必要です（空き容量は %%available%% GB）',

    'cgroups-settings.cgroupsSettingsTab' => 'RAM、CPU、ディスク I/O',
    'cgroups-settings.cgroupsSettingsTabDescription' => '契約によるシステムリソースの使用量に上限を設定します。Plesk はこの上限が超過されていないことを確認するために、Linux カーネルのコントロールグループ（cgroup）機能を使用します。',
    'cgroups-settings.cpuSettings' => 'CPU',
    'cgroups-settings.cpuSettingsDescription' => '各契約の CPU 使用率に上限を設定します。',
    'cgroups-settings.cpuPeriodLimit' => 'CPU 使用率をチェックする期間',
    'cgroups-settings.percentUsageDescription' => 'サーバの合計 CPU 時間は %%total%%%%units%% です',
    'cgroups-settings.ramSettings' => 'RAM',
    'cgroups-settings.ramSettingsDescription' => '各契約の RAM 使用量に上限を設定します。契約でこの上限を超過すると、最も消費の多いプロセスが停止されます。',
    'cgroups-settings.ramPeriodLimit' => 'RAM 使用量をチェックする期間',
    'cgroups-settings.diskSettings' => 'ディスク I/O',
    'cgroups-settings.diskReadSettings' => 'ディスク読取',
    'cgroups-settings.diskReadSettingsDescription' => '各契約のディスク読取帯域幅使用量に上限を設定します。',
    'cgroups-settings.diskReadPeriodLimit' => 'ディスク読取帯域幅の使用量をチェックする期間',
    'cgroups-settings.diskWriteSettings' => 'ディスク書込',
    'cgroups-settings.diskWriteSettingsDescription' => '各契約のディスク書込帯域幅使用量に上限を設定します。',
    'cgroups-settings.diskWritePeriodLimit' => 'ディスク書込帯域幅の使用量をチェックする期間',
    'cgroups-settings.limit' => '上限',
    'cgroups-settings.threshold' => '超過時に通知',
    'cgroups-settings.limitNotificationEnabled' => '通知は有効です',
    'cgroups-settings.periodFiveMinutes' => '5 分',
    'cgroups-settings.periodHour' => '1 時間',
    'cgroups-settings.periodDay' => '1 日（24 時間）',
    'cgroups-settings.mb' => 'MB',
    'cgroups-settings.mbs' => 'MB/秒',

    'custom-button.privateLabel' => '自分にのみ表示する',
    'custom-button.textLabel' => 'ボタンラベル',
    'custom-button.tooltipLabel' => 'ヘルプのテキスト',
    'custom-button.iconLabel' => '背景画像',
    'custom-button.priorityLabel' => '優先度',
    'custom-button.urlLabel' => 'URL',
    'custom-button.urlParamsLabel' => 'URL にパラメータを追加する',
    'custom-button.placeLabel' => '場所',
    'custom-button.internalLabel' => 'URL を Plesk で開く',
    'custom-button.internalDescription' => 'URL を Plesk 内のページで開くか、新しいブラウザウィンドウで開くかを指定してください。',
    'custom-button.noFrameLabel' => 'フレームを使用しない',
    'custom-button.noFrameDescription' => 'Plesk 拡張やアプリケーションにリンクするカスタムボタンを顧客パネルに追加する場合、この拡張/アプリケーションの表示形態（フレーム内に表示、Plesk GUI の一部として表示）を指定できます。',
    'custom-button.urlParamLabel_dom_id' => '契約 ID、ドメイン ID、およびドメインエイリアス ID を含める',
    'custom-button.urlParamLabel_dom_name' => 'プライマリドメイン名を含める',
    'custom-button.urlParamLabel_ftp_user' => 'FTP ユーザ名を含める',
    'custom-button.urlParamLabel_ftp_pass' => 'FTP パスワードを含める',
    'custom-button.urlParamLabel_cl_id' => '顧客 ID を含める',
    'custom-button.urlParamLabel_cname' => '顧客の会社名を含める',
    'custom-button.urlParamLabel_pname' => '顧客の担当者名を含める',
    'custom-button.urlParamLabel_email' => '顧客のメールアドレスを含める',
    'custom-button.buttonPlace_navigation' => '共通アクセス',
    'custom-button.buttonPlace_admin' => '管理者のホームページ',
    'custom-button.buttonPlace_admin-settings' => '管理者の［ツールと設定］ページ',
    'custom-button.buttonPlace_reseller' => "リセラーのホームページ",
    'custom-button.buttonPlace_reseller-settings' => 'リセラーの［ツールとユーティリティ］ページ',
    'custom-button.buttonPlace_client' => '顧客のホームページ',
    'custom-button.buttonPlace_domain' => "契約の［ウェブサイトとドメイン］ページ",
    'custom-button.buttonPlace_domain_powerUser' => "ウェブスペースの［ウェブサイトとドメイン］ページ",
    'custom-button.buttonPlace_domain-properties' => 'ウェブサイトツール',

    'domain.connection-info.title' => '接続情報',
    'domain.connection-info.systemUserCredentials' => 'システムユーザのクレデンシャル',
    'domain.connection-info.systemUserCredentialsHint' => 'FTP 経由のアクセスは常に有効です。SSH またはリモートデスクトップ経由のアクセス — %%details%%のみ。',
    'domain.connection-info.systemUserCredentialsHintDetails' => 'パーミッションが付与されている',
    'domain.connection-info.systemUserRemoveAccessEnabled' => 'SSH またはリモートデスクトップ経由のアクセスは有効で、状態を管理することはできません。',
    'domain.connection-info.systemUserRemoveAccessDisabled' => 'SSH またはリモートデスクトップ経由のアクセスは無効で、状態を管理することはできません。',
    'domain.connection-info.ipAddress' => 'IP アドレス',
    'domain.connection-info.copyToClipboard' => 'クリップボードにコピー',
    'domain.connection-info.username' => 'ユーザ名',
    'domain.connection-info.password' => 'パスワード',
    'domain.connection-info.changeSystemUserPasswordTitle' => 'システムユーザパスワードの変更',
    'domain.connection-info.changePasswordTooltip' => 'パスワード変更',
    'domain.connection-info.newPassword' => '新規パスワード',
    'domain.connection-info.manageAccess' => 'アクセス管理',
    'domain.connection-info.additionalFtpAccounts' => '追加 FTP アカウント',
    'domain.connection-info.database' => 'データベース',
    'domain.connection-info.databaseHint' => '%%number%% データベースのうち 1 つがこの契約に属しています。',
    'domain.connection-info.databaseNotCreatedHint' => 'データベースは作成されていません。',
    'domain.connection-info.databaseType.mysql' => 'MySQL',
    'domain.connection-info.databaseType.mssql' => 'MS SQL サーバ',
    'domain.connection-info.databaseType.postgresql' => 'PostgreSQL',
    'domain.connection-info.databaseType.mariadb' => 'MariaDB',
    'domain.connection-info.databaseType.percona' => 'Percona',
    'domain.connection-info.databaseHost' => 'ホスト',
    'domain.connection-info.databaseHostValue' => '%%value%%（%%fork%%）',
    'domain.connection-info.databaseName' => 'データベース名',
    'domain.connection-info.addDatabase' => 'データベースを追加',
    'domain.connection-info.manageDatabases' => 'データベースを管理',
    'domain.connection-info.phpMyAdmin' => 'PhpMyAdmin',
    'domain.connection-info.myLittleAdmin' => 'myLittleAdmin',
    'domain.connection-info.changeDatabaseUserPasswordTitle' => 'データベースユーザのパスワード変更',
    'domain.connection-info.changeDatabaseUserPasswordNotice' => 'ここで変更した後で、忘れずにアプリケーションの構成ファイルでパスワードを更新してください。',
    'domain.connection-info.buttonSave' => '保存',
    'domain.connection-info.buttonSaving' => '保存中...',
    'domain.connection-info.buttonCancel' => 'キャンセル',

    'domain.move.title' => 'ドメイン %%name%% を移動',
    'domain.move.hint' => 'ドメインは、そのコンテンツ、構成ファイル、ログファイル、APS アプリケーションを含めて新しい契約に移動されます。',
    'domain.move.hintMain' => 'ドメインは、そのコンテンツ、構成ファイル、ログファイル、データベース、データベースユーザ、追加 FTP ユーザ、スケジュール済みタスク、SMB ユーザ、APS アプリケーションを含めて新しい契約に移動されます。',
    'domain.move.hintSubdomains' => 'サブドメイン %%subdomains%% は親ドメインとともに移動されます。',
    'domain.move.hintAliases' => 'ドメインエイリアス %%aliases%% は親ドメインとともに移動されます。',
    'domain.move.hintSubdomainsAndAliases' => 'サブドメイン %%subdomains%% とエイリアス %%aliases%% は親ドメインとともに移動されます。',
    'domain.move.labelDatabases' => 'ドメインを移動した後で、［データベース］タブを開いて関連するデータベースを移動してください。',
    'domain.move.hintDatabases' => '必要であれば、データベースを個別に移動してください。',

    'domain.move.Form.submitButton' => '移動',
    'domain.move.Form.cancelButton' => 'キャンセル',

    'domain.move.selectTarget' => '利用可能な契約',
    'domain.move.nothingFound' => '何も見つかりませんでした',
    'domain.move.targetIsRequred' => 'ドメインの移動先にする契約を選択してください。',
    'domain.move.selectNewSubscription' => '新規契約を作成',
    'domain.move.ipv4Address' => 'IPv4 アドレス',
    'domain.move.ipv4AddressHint' => 'ウェブサイトのホストに使用されている IP アドレスは、ウェブサイトの仮想ホストのネットワークアドレスです。',
    'domain.move.ipv6Address' => 'IPv6 アドレス',
    'domain.move.ipv6AddressHint' => 'ウェブサイトのホストに使用されている IP アドレスは、ウェブサイトの仮想ホストのネットワークアドレスです。',
    'domain.move.ipAddressIsNotSelected' => 'IP アドレスを少なくとも 1 つ選択する必要があります。',
    'domain.move.username' => 'ユーザ名',
    'domain.move.usernameHint' => 'ウェブサイトに紐付けられたシステムユーザアカウント。ホストされているファイルに FTP または SSH 経由でアクセスするために使用されます。',
    'domain.move.usernameIsRequred' => 'ユーザ名を指定する必要があります。',
    'domain.move.password' => 'パスワード',
    'domain.move.passwordIsRequred' => 'パスワードを指定する必要があります。',
    'domain.move.noAvailableSubscriptions' => '利用可能な契約がありません',
    'domain.move.noWebHosting' => 'ドメインにウェブホスティングがないため、現時点ではシステムユーザは作成されません。',

    'domain.rename.title' => 'ドメイン名を変更',
    'domain.rename.titleAlias' => 'ドメインエイリアス名を変更',
    'domain.rename.hint' => 'ドメイン名 %%domainName%% を変更しています',
    'domain.rename.hintAlias' => 'ドメインエイリアス名 %%domainName%% を変更しています',
    'domain.rename.name' => '新しいドメイン名',
    'domain.rename.nameAlias' => '新しいドメインエイリアス名',
    'domain.rename.domainNameIsRequired' => '必須フィールドが空です。 値を入力してください。',
    'domain.rename.submitButton' => '変更',
    'domain.rename.submitButtonProgress' => '変更中',
    'domain.rename.successMessage' => 'ドメイン名 %%oldName%% は %%newName%% に変更されました。',
    'domain.rename.successMessageAlias' => 'ドメインエイリアス名 %%oldName%% は %%newName%% に変更されました。',

    'domain.rename.Form.cancelButton' => 'キャンセル',

    'domain.outgoing-messages.hint' => 'このドメインからの送信メッセージ数の上限を変更することができます。指定した上限を超えてメッセージを送信することはできません。',
    'domain.outgoing-messages.domainOutgoingMessagesSubscriptionDefault' => 'デフォルト（%%domainOutgoingMessages%% 通/時間）',
    'domain.outgoing-messages.domainOutgoingMessagesSpecificHint' => '通/時間',
    'domain.outgoing-messages.domainOutgoingMessages' => '送信メッセージ数の上限',
    'domain.outgoing-messages.domainOutgoingMessagesCustomLimit' => 'このドメインのカスタム値',

    'domain.tech-domain-name.title' => 'ドメイン名を選択',
    'domain.tech-domain-name.techDomainTitle' => '一時ドメイン名',
    'domain.tech-domain-name.customDomainTitle' => '登録済みドメイン名',
    'domain.tech-domain-name.techDomainText' => '登録済みのドメイン名はありません',
    'domain.tech-domain-name.customDomainText' => '登録済みのドメイン名はあります',
    'domain.tech-domain-name.techDomain' => '一時ドメイン名',
    'domain.tech-domain-name.customDomain' => '登録済みドメイン名',
    'domain.tech-domain-name.domainName' => 'ドメイン名',
    'domain.tech-domain-name.techDomainDesc' => '適切なドメイン名を登録して購入するまで、一時ドメイン名がサイトへのアクセスに使用されます。このドメイン名は以下の条件に基づいて無料で提供されます。',
    'domain.tech-domain-name.techDomainRandom' => '名前はランダムに生成されます',
    'domain.tech-domain-name.techDomainDns' => '.plesk.page DNS ゾーンでホストされます',
    'domain.tech-domain-name.techDomainMail' => '一時ドメイン名でメールを使用することはできません',
    'domain.tech-domain-name.techDomainSwitch' => '後でいつでも、ドメイン設定でドメインの名前を変更することで、登録済みドメイン名に切り替えることができます。',
    'domain.tech-domain-name.error' => '予期しないエラーが発生しました。',
    'domain.tech-domain-name.errorNoIpAddress' => 'IP アドレスを選択する必要があります。',
    'domain.tech-domain-name.generating' => '生成中...',

    'get-password.label' => 'パスワードをリセット',
    'get-password.text' => 'Plesk に登録されたメールアドレスまたはユーザ名を入力すると、パスワードのリセットメールが届きます。',
    'get-password.emailLabel' => 'メールアドレス',
    'get-password.loginLabel' => 'ユーザ名',
    'get-password.send' => '送信',
    'get-password.cancel' => 'キャンセル',
    'get-password.errorInvalidEmail' => 'メールアドレスが認識されませんでした。再確認してやり直してください。',
    'get-password.messageSend' => "パスワードのリセットメールが、関連するメールアドレスに送信されました。\nメールが届かない場合、Plesk 管理者までお問い合わせください。",

    'iis-settings.formGeneralHint' => 'デフォルト値を変更して、ウェブサイトの IIS ウェブサーバ設定を指定することができます。カスタム IIS 構成は、ウェブサイトのインデックスファイルに新しいファイルタイプを使用したい場合や、特定のファイル名拡張子と特定の MIME タイプを関連付けたい場合に便利です。デフォルト値はホスティング事業者によって定義されています。',
    'iis-settings.formGeneralHint_powerUser' => 'このウェブサイトの IIS ウェブサーバ設定を指定することができます。カスタム IIS 構成は、ウェブサイトのインデックスファイルに新しいファイルタイプを使用したい場合や、特定のファイル名拡張子と特定の MIME タイプを関連付けたい場合に便利です。デフォルト値にすると、IIS はデフォルト構成に定義されたディレクティブを使用します。',
    'iis-settings.virtualDirectoryLoadError' => '指定した仮想ディレクトリのプロパティを取得できません。%%errorMessage%%',
    'iis-settings.general' => '共通設定',
    'iis-settings.example' => "例：\n%%example%%",
    'iis-settings.settingOn' => 'オン',
    'iis-settings.settingOff' => 'オフ（デフォルト）',
    'iis-settings.settingDefault' => 'デフォルト',
    'iis-settings.settingCustom' => 'カスタム値を入力',
    'iis-settings.mimeTypes' => 'MIME タイプ',
    'iis-settings.mimeTypesExample' => "text/plain .mytxt\nimage/jpeg .myjpeg \n\nMIME タイプは、ファイル拡張子とファイルタイプを関連付けます。通常は、一般的なファイルタイプにカスタムのファイル拡張子を作成する場合に使用します。",
    'iis-settings.documents' => 'デフォルトドキュメント',
    'iis-settings.documentsOff' => '無効',
    'iis-settings.documentsCustom' => '値を入力',
    'iis-settings.documentsExample' => "Index.html\nIndex.htm\nIndex.cfm \n\nブラウザがサイト内のドキュメント名を指定しない場合、IIS は既定のデフォルトドキュメントを探し、最初に検出されたドキュメントを提供します。デフォルトドキュメントが設定されていない場合、ディレクトリブラウジングをオンにすると、索引ページではなくディレクトリリスティングがブラウザに表示されます。",
    'iis-settings.expires' => '期限切れ',
    'iis-settings.expiresDescription' => 'ウェブサーバは「期限切れ」応答ヘッダをウェブページに追加します。期限切れタイムスタンプは、ウェブページがリクエストされた時間に、上に指定された時間を加算することで計算されます。',
    'iis-settings.expiresUnitDays' => '日',
    'iis-settings.expiresUnitHours' => '時間',
    'iis-settings.expiresUnitMinutes' => '分',
    'iis-settings.expiresUnitSeconds' => '秒',
    'iis-settings.headers' => '追加ヘッダ',
    'iis-settings.headersExample' => "Cache-Control: public Strict-Transport-Security: max-age=63072000; includeSubdomains; X-Frame-Options: DENY ウェブサーバにより、指定した HTTP 応答ヘッダが追加されます。",
    'iis-settings.directoryBrowsing' => 'ディレクトリ参照',
    'iis-settings.directoryBrowsingDescription' => 'ユーザに対し、デフォルト索引ページが使用できない場合などに、ウェブブラウザでのサイトのディレクトリリスティングの参照を許可します。',
    'iis-settings.securityTabDirectory' => 'ディレクトリセキュリティ設定',
    'iis-settings.allowAnonymous' => '匿名認証',
    'iis-settings.allowAnonymousDescription' => '匿名認証により、ユーザはサイトのパブリックコンテンツにアクセスできますが、パスワード保護されたサイトコンテンツおよびファイルシステムレベルで保護されたコンテンツを使用することはできません。',
    'iis-settings.allowWindows' => 'Windows 認証',
    'iis-settings.allowWindowsDescription' => 'Windows 認証（旧名 NTLM）は、ファイルシステムレベルでサイトのコンテンツを保護します。',
    'iis-settings.requireSsl' => 'SSL/TLS が必要',
    'iis-settings.requireSslDescription' => 'サイトで SSL/TLS サポートが有効になっている場合、このオプションを選択するとウェブクライアント（ブラウザ）に対して HTTPS 接続の使用が強制されます。',
    'iis-settings.securityTabIpDeny' => 'アクセス制限設定',
    'iis-settings.deny' => 'サイトへのアクセスを拒否',
    'iis-settings.denyOff' => 'デフォルト',
    'iis-settings.denyCustom' => 'カスタム値を入力',
    'iis-settings.allow' => '除外',
    'iis-settings.denyExample' => "10.1.0.0/16\n192.168.1.110\n\n指定されたホストとネットワークに対して、このサイトへのアクセスを禁止します。すべての接続を拒否するには「*」を使用します。",
    'iis-settings.allowExample' => "192.168.0.0/16\n10.1.1.21\n\n指定したホストとネットワークは、サイトへのアクセスが許可されます。",
    'iis-settings.dynamicIpSecurity' => 'IIS Dynamic IP Restriction による DoS 攻撃の阻止',
    'iis-settings.isDenyByConcurrentRequests' => '1 つの IP アドレスからの同時要求数に基づいて IP アドレスを拒否する',
    'iis-settings.maxConcurrentRequests' => '同時要求の最大数',
    'iis-settings.isDenyByRequestRate' => '一定期間内の要求数に基づいて IP アドレスを拒否する',
    'iis-settings.maxRequests' => '要求の最大数',
    'iis-settings.requestInterval' => '期間（ミリ秒）',

    'ip-addresses-selector.ipAddress' => 'IP アドレス',
    'ip-addresses-selector.ipv4Address' => 'IPv4 アドレス',
    'ip-addresses-selector.ipv4AddressHint' => "ウェブサイトをホスティングしている IP アドレス。ウェブサイトの仮想ホストのネットワークアドレスです。",
    'ip-addresses-selector.ipv6Address' => 'IPv6 アドレス',
    'ip-addresses-selector.ipv6AddressHint' => "ウェブサイトをホスティングしている IP アドレス。ウェブサイトの仮想ホストのネットワークアドレスです。",
    'ip-addresses-selector.noIpAddressHint' => 'なし',
    'ip-addresses-selector.shared' => '共有',
    'ip-addresses-selector.exclusive' => '専用',
    'ip-addresses-selector.ipV6OnlyNotSupported' => 'FTP サーバが IPv6 をサポートしていません。IPv4 アドレスを少なくとも 1 つ割り当ててください。これを行わないと、FTP 経由でサーバにファイルをアップロードできなくなります。',

    'log-rotation.customLogsDescription' => 'カスタムログはローテーションされていません。',
    'log-rotation.logRotation' => 'ログローテーション',
    'log-rotation.logRotationCondition' => 'ログローテーション条件',
    'log-rotation.logRotationBySize' => 'サイズ単位',
    'log-rotation.logRotationByTime' => '時間単位',
    'log-rotation.logRotationDaily' => '毎日',
    'log-rotation.logRotationWeekly' => '毎週',
    'log-rotation.logRotationMonthly' => '毎月',
    'log-rotation.logRotationSizeDescription' => 'サイズは %%min%%～%%max%% kB にする必要があります。',
    'log-rotation.maximumNumberOfFiles' => '最大ログファイル数',
    'log-rotation.compress' => 'ログファイルを圧縮',
    'log-rotation.sendLogToEmail' => 'Plesk はウェブサーバと FTP サーバのログファイルからデータを取得後、このアドレスにログファイルをメール送信します。',
    'log-rotation.kb' => 'KB',
    'log-rotation.logRotationPeriodGreater' => '期間がサーバ全体の限度 %%max%% を超えてはいけません。',

    'login.loginLabel' => 'ユーザ名',
    'login.passwdLabel' => 'パスワード',
    'login.localeLabel' => 'インターフェース言語',
    'login.defaultLocale' => 'デフォルト',
    'login.loginButtonLabel' => 'ログイン',
    'login.enterLoginAndPasswd' => 'ログイン名とパスワードを入力してください。',
    'login.whatUsernamePassword' => 'What username and password to use?',
    'login.forgotPasswordLabel' => 'パスワードを忘れた場合',
    'login.cookies' => 'Cookies policy in Plesk',
    'login.avoidSSLWarningsMsg' => 'Plesk ログイン時に SSL に関する警告を回避するには、%%link%% を使用してください',
    'login.digitalOceanMsg' => 'New to Plesk on DigitalOcean? Use "root" and the password entered when creating this droplet to log in. %%link%%',
    'login.amazonLightsailMsg' => 'New to Plesk on Lightsail? To log in to Plesk, access the server via SSH and use the "plesk login" command. %%link%%',
    'login.readGuide' => 'Read the complete guide.',

    'panel-access.title' => 'Plesk URL のカスタマイズ',
    'panel-access.hint' => 'Plesk へのログイン用カスタム URL を選択してください。これにより、ポート %%httpsPort%% 経由での Plesk ログインが不可能になることはありません。%%link%%',
    'panel-access.details' => '詳細',
    'panel-access.proxyEnabled' => 'サーバの IP アドレスに解決されるがホスティングに使用されない、すべてのドメインまたはサブドメイン',
    'panel-access.proxyDomain' => 'サーバの IP アドレスに解決されるがホスティングに使用されない、指定されたドメインまたはサブドメイン',
    'panel-access.proxyDisabled' => 'カスタム URL はありません。https://<server-IP-or-hostname>:%%httpsPort%% のみです',

    'panel-access.Form.submitButton' => '保存',
    'panel-access.Form.cancelButton' => 'キャンセル',

    'panel-access.domainNameIsRequired' => 'ドメイン名を指定する必要があります。',
    'panel-access.successMessage' => '選択されたログイン方法は適用されませんでした。',
    'panel-access.notSupported' => 'Plesk で、選択したログイン方法がサポートされていません。',
    'panel-access.notViaDomainName' => 'このログイン方法を適用するには、最初のオプション（［...すべてのドメインまたはサブドメイン］）を選択し、https://%%domainName%% 経由で Plesk にログインしてから、2 番目のオプションを選択してください。',
    'panel-access.notViaPort' => 'このログイン方法を適用するには、まず Plesk に https://<server-IP-or-hostname>:%%httpsPort%% からログインしてください。',

    'php-settings.performance' => 'パフォーマンスとセキュリティの設定',
    'php-settings.settings' => '共通設定',
    'php-settings.fastCgiSettings' => 'FastCGI 設定',
    'php-settings.fpmSettings' => 'PHP-FPM 設定',
    'php-settings.enableFastcgi' => 'FastCGI 設定を有効化',
    'php-settings.plainTextEditing' => '追加ディレクティブ',
    'php-settings.placeAdditionalCustomizationDirectivesHere' => '以下のフィールの入力することで、任意の PHP パラメータを定義できます。ディレクティブは PHP 構成に追加されます。php.ini と同じ構文を使用してください。たとえば、mSQL 拡張を自動的に読み込むには、「extension=msql.so」という行を追加します。',
    'php-settings.placeAdditionalCustomizationDirectivesHereAddonPlan' => '特定の PHP パラメータが見つからない場合、下のフィールドに追加してください。これらの追加ディレクティブは、メインサービスプランのディレクティブとマージされます。php.ini と同じ構文を使用してください。例えば、mSQL 拡張モジュールを自動的にロードしたい場合、「extension=msql.so」という行を追加します。',
    'php-settings.placeFpmAdditionalCustomizationDirectivesHere' => '以下のフィールの入力することで、任意の PHP パラメータを定義できます。ディレクティブは PHP 構成に追加されます。php.ini と同じ構文を使用してください。たとえば、mSQL 拡張を自動的に読み込むには、「extension=msql.so」という行を追加します。PHP-FPM プール設定をカスタマイズするには、[php-fpm-pool-settings] セパレータを追加し、その下に必要な設定を入力します。',
    'php-settings.additionalConfigurationDirectives' => '追加構成ディレクティブ',
    'php-settings.defaultValue' => 'デフォルト',
    'php-settings.predefinedValue' => '値を選択',
    'php-settings.customValue' => 'カスタム値を入力',
    'php-settings.phpSettingDescription_memory_limit' => 'スクリプトが確保できる最大メモリを、バイト数で指定します。',
    'php-settings.phpSettingDescription_max_execution_time' => 'スクリプトが強制終了されるまでの最大時間を、秒単位で指定します。',
    'php-settings.phpSettingDescription_max_input_time' => 'スクリプトが入力をパースする最大の時間を、秒単位で指定します。',
    'php-settings.phpSettingDescription_post_max_size' => 'POST メソッドで送信可能な最大データ量（バイト）です。通常、upload_max_filesize より大きく、memory_limit より小さく設定します。',
    'php-settings.phpSettingDescription_upload_max_filesize' => 'アップロードするファイルの最大サイズ（バイト）です。',
    'php-settings.phpSettingDescription_safe_mode' => 'PHP セーフモードは、主にセキュリティ上の理由でスクリプトの実行に様々な制約を加えます。',
    'php-settings.phpSettingDescription_safe_mode_include_dir' => 'safe_mode ディレクティブが有効な場合、指定したディレクトリ内のファイルは PHP スクリプトでアクセスできます。ディレクトリは include_path に存在する必要があります。',
    'php-settings.phpSettingDescription_safe_mode_exec_dir' => 'safe_mode ディレクティブが有効な場合、指定したディレクトリ内のプログラムは PHP スクリプトで実行できます。',
    'php-settings.phpSettingDescription_include_path' => 'スクリプトがファイルを 探すディレクトリのリスト（システムの PATH 変数と同じフォーマットにします）。ディレクトリを区切るには、Linux ではコロン（:）、Windows ではセミコロン（;）を使用します。',
    'php-settings.phpSettingDescription_sessionsave_path' => 'PHP セッションファイルを保存するディレクトリです。',
    'php-settings.phpSettingDescription_mailforce_extra_parameters' => 'mail() 関数の追加パラメータです。',
    'php-settings.phpSettingDescription_register_globals' => 'EGPCS（環境、GET、POST、Cookie、サーバ）変数のコンテンツをグローバル変数として登録します。',
    'php-settings.phpSettingDescription_open_basedir' => 'PHP スクリプトからアクセスできるファイルを、指定したディレクトリ内のファイルに限定します。ディレクトリを区切るには、Linux ではコロン（:）、Windows ではセミコロン（;）を使用します。',
    'php-settings.phpSettingDescription_error_reporting' => 'エラーレポートのレベルを指定します。',
    'php-settings.phpSettingDescription_display_errors' => 'エラーを出力に含めるかどうかを決定します。',
    'php-settings.phpSettingDescription_log_errors' => 'PHP エラーをログに記録するかどうかを指定します。',
    'php-settings.phpSettingDescription_allow_url_fopen' => 'PHP ファイル関数を使用してリモートロケーションから FTP または HTTP 経由でデータを取得することを許可します。',
    'php-settings.phpSettingDescription_file_uploads' => 'HTTP 経由のファイルアップロードを許可します。',
    'php-settings.phpSettingDescription_short_open_tag' => 'PHP タグの短縮型 ( ) を許可します。',
    'php-settings.phpSettingDescription_magic_quotes_gpc' => 'GPC（Get/Post/Cookie）処理に関する magic_quotes の状態\nを設定します。magic_quotes が on の場合、単一引用符、二重引用符、バックスラッシュ、NULL にはすべて自動的にバックスラッシュでエスケープ処理が行われます。',
    'php-settings.phpSettingDescription_disable_functions' => 'このディレクティブにより、特定の機能を無効にできます。関数名のコンマ区切りリストを受け付けます',
    'php-settings.phpSupport' => 'PHP サポート',
    'php-settings.phpRunAs' => 'PHP の実行タイプ',
    'php-settings.phpVersion' => 'PHP バージョン',
    'php-settings.phpHandlerOutdated' => '（サポート終了）',
    'php-settings.phpHandlerDeprecated' => '（非推奨）',
    'php-settings.phpServedByApache' => '＋Apache',
    'php-settings.phpServedByNginx' => '＋nginx',
    'php-settings.phpSettingsPhpVersion' => 'ご使用の PHP バージョンは %%version%% です。',
    'php-settings.phpSettingsPhpDisabled' => 'PHP はオフになっています。',
    'php-settings.phpHandlerTypeHint' => '以下は、ウェブサイトの PHP 構成の詳細です。ホスティング事業者から該当するパーミッションが付与されていれば、PHP 構成を変更することができます。',
    'php-settings.fpmDedicatedHandlerHint' => 'このハンドラを使用すると、ウェブサイトの安定性は向上しますが、メモリ消費量も増加します。',
    'php-settings.phpHandlerChangeHint' => 'PHP ハンドラの設定を変更しました。これらの変更を保存すると、サーバの構成のために、ウェブサイトの PHP スクリプトが %%interval%% 秒間停止する可能性があります。',
    'php-settings.phpHandlerTypeHelpLink' => '最も適切な PHP 設定を選択する方法について',
    'php-settings.phpHandlerTypeNotAvailableHint' => 'PHP サポートは有効にできません。現在のホスティング構成に、このドメインで使用できる PHP が含まれていません。',
    'php-settings.phpHandlersNotAvailableHint' => 'PHP サポートを有効にできません。現在の Plesk 構成に、使用可能な PHP が含まれていません。',
    'php-settings.phpHandlerTypeNotAvailableHelpLink' => '他の PHP バージョンを有効にする方法を確認してください。',
    'php-settings.phpSupportReadonly' => '（バージョン：%%version%%; ハンドラ：%%handler%%）%%link%%',
    'php-settings.phpSupportReadonlyNotRegistered' => '（未登録）%%link%%',
    'php-settings.showPhpInfo' => 'phpinfo() ページを表示',
    'php-settings.phpSettingsFormError' => 'PHP 設定を取得できません。必要なデータがありません。',
    'php-settings.phpSettingsFormBrokenPhpHandler' => 'PHP 設定を取得できません。このハンドラは破損しています。',
    'php-settings.showPhpInfoTitle' => 'phpinfo() を表示',
    'php-settings.showPhpInfoDescription' => '一部の PHP 設定が変更されましたが、変更が保存されていません。phpinfo() ページに新しい値を表示するには、まず変更を適用してください。適用しないと、現在の値が表示されます。',
    'php-settings.showPhpInfoButton' => 'phpinfo() を表示',

    'pmm.agent.sync.check' => '移行・移管エージェントがアップデートをチェックしています。',
    'pmm.agent.sync.updating' => '移行・移管エージェントの同期およびダウンロードを実行中',
    'pmm.agent.sync.done' => '移行・移管エージェントは正常に同期されました。',
    'pmm.agent.sync.downloadLink' => '移行開始前にソースホストにインストールする必要がある移行・移管エージェントファイルをダウンロードします。',
    'pmm.agent.sync.error' => '移行・移管エージェントがアップデートの取得に失敗しました。後でもう一度やり直してください。',

    'restore-password.title' => 'パスワード変更',
    'restore-password.passwordLabel' => '新規パスワード',
    'restore-password.buttonRestore' => '保存',
    'restore-password.buttonCancel' => 'キャンセル',
    'restore-password.isEmpty' => '必須フィールドが空欄になっています。値を入力してください。',
    'restore-password.errorInvalidSecret' => '無効なシークレットコード',
    'restore-password.errorNotFoundSecret' => '新しいシークレットコードをリクエストしてください',
    'restore-password.restoreSuccess' => 'パスワードが更新されました。新しいパスワードで Plesk またはメールアドレスにログインします。',

    'scheduler.settings.schedulerNotification' => 'スケジューラ通知',
    'scheduler.settings.notificationOff' => "オフ",
    'scheduler.settings.notificationDefault' => "デフォルトメールアドレスに送信（%%email%%）",
    'scheduler.settings.notificationCustom' => "指定メールアドレスに送信",
    'scheduler.settings.crontabSecureShell' => 'Crontab シェル',
    'scheduler.settings.schedulerTimezoneSelector' => 'タスクスケジュールの表示に使用するタイムゾーン',
    'scheduler.settings.schedulerTimezoneSelectorDefaultWithLabel' => 'システムのデフォルトタイムゾーンを使用（%%timezone%%）',
    'scheduler.settings.schedulerTimezoneSelectorDefault' => 'システムのデフォルトタイムゾーンを使用',
    'scheduler.settings.schedulerTimezoneSelectorCustom' => '使用するタイムゾーンを指定',

    'scheduler.task.active' => 'アクティブ',
    'scheduler.task.subscription' => '契約',
    'scheduler.task.subscription_powerUser' => 'ウェブスペース',
    'scheduler.task.type' => 'タスクタイプ',
    'scheduler.task.typeCommand' => 'コマンドを実行',
    'scheduler.task.typeUrl' => 'URL をフェッチ',
    'scheduler.task.typeScript' => 'PHP スクリプトを実行',
    'scheduler.task.command' => 'コマンド',
    'scheduler.task.arguments' => '引数',
    'scheduler.task.url' => 'URL',
    'scheduler.task.urlDescription' => '絶対 URL（http://example.com など）を指定してください。応答ステータスコードが 2xx または 3xx の場合、タスクは正常に実行されたとみなされます。',
    'scheduler.task.script' => 'スクリプトパス',
    'scheduler.task.scriptRelativePathDescription' => '例：%%path%%',
    'scheduler.task.scriptAbsolutePathDescription' => 'スクリプトのフルパスを指定します。例：%%path%%',
    'scheduler.task.scriptPhpVersion' => 'PHP バージョンを使用',
    'scheduler.task.scriptPathPopupTitle' => 'スクリプトパス',
    'scheduler.task.run' => '実行',
    'scheduler.task.on' => 'on',
    'scheduler.task.at' => 'at',
    'scheduler.task.sysUser' => 'システムユーザ',
    'scheduler.task.hourly' => '毎時',
    'scheduler.task.daily' => '毎日',
    'scheduler.task.weekly' => '毎週',
    'scheduler.task.monthly' => '毎月',
    'scheduler.task.yearly' => '毎年',
    'scheduler.task.cronStyle' => 'Cron スタイル',
    'scheduler.task.cronStyleError' => 'crontab 構文が無効です。',
    'scheduler.task.cronStyleErrorWin' => 'スラッシュ（/）とハイフン（-）は許可されません。',
    'scheduler.task.cronStyleHint' => 'UNIX crontab は「分 時 日 月 曜日」形式で指定します。例えば、「0 22 * * 1-5」のようにします。Plesk はデフォルトシステムタイムゾーンを使用してタスクを実行します。',
    'scheduler.task.cronStyleWinHint' => '「分 時 日 月 曜日」形式で「0 22 * * 6,7」のように指定します。Plesk はデフォルトシステムタイムゾーンを使用してタスクを実行します。',
    'scheduler.task.notify' => '通知',
    'scheduler.task.notifyIgnore' => '通知しない',
    'scheduler.task.notifyErrors' => 'エラーのみ',
    'scheduler.task.notifyAlways' => '毎回',
    'scheduler.task.notifyErrorsHint' => '通知にはコマンドの標準エラーストリームが含まれます。ストリームが空の場合、通知は送信されません。',
    'scheduler.task.notifyErrorsHintWin' => '通知にはコマンド出力が含まれ、終了コードがゼロ以外の場合のみ送信されます。',
    'scheduler.task.notifyAlwaysHint' => '通知にはコマンド出力が含まれます。出力が空の場合、通知は送信されません。',
    'scheduler.task.notifyAlwaysHintWin' => '通知にはコマンド出力が含まれ、コマンド終了コードに関わらず送信されます。',
    'scheduler.task.emailType' => '通知の送信先',
    'scheduler.task.emailTypeDefault' => 'デフォルトのシステムユーザ（%%email%%）',
    'scheduler.task.emailTypeOwner' => '契約所有者（%%email%%）',
    'scheduler.task.emailTypeOwnerAdmin' => '管理者（%%email%%）',
    'scheduler.task.emailTypeCustom' => '他のユーザ',
    'scheduler.task.emailTypeCustomDescription' => '複数のアドレスをコンマで区切って指定できます。',
    'scheduler.task.minute' => '分',
    'scheduler.task.shortMinute' => '分',
    'scheduler.task.dayOfMonth' => '日',
    'scheduler.task.description' => '説明',
    'scheduler.task.scheduleTimezoneHint' => 'タスク実行時間のタイムゾーンは %%timezone%% です',
    'scheduler.task.runTaskNow' => '今すぐ実行',
    'scheduler.task.runningTask' => 'タスク "%%task%%" を実行中...',

    'service-plan.mail.outgoing-messages.outgoingMessagesDefault' => 'サーバ全体のデフォルト値（%%default%% 通/時間）',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificPlan' => 'プランのカスタム値',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificSubscription' => '契約のカスタム値',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificHint' => '通',
    'service-plan.mail.outgoing-messages.mboxOutgoingMessages' => 'メールボックスからの送信メッセージ数（1 時間あたり）',
    'service-plan.mail.outgoing-messages.domainOutgoingMessages' => 'ドメインからの送信メッセージ数（1 時間あたり）',
    'service-plan.mail.outgoing-messages.subscriptionOutgoingMessages' => '契約からの送信メッセージ数（1 時間あたり）',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimit' => '1 時間あたりの上限を超えており、次の時間に送信すべきメッセージの割合（%）',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimitDescription' => '1 時間あたりにメールボックスから送信するメールメッセージの上限を 100 に、割合（%）を 10% に設定すると、ユーザは 1 時間あたり 110 件までメッセージを送信することができます。このうち 100 件は 1 時間の間に送信されますが、残りの 10 件はメールキューに入れられ、次の時間に送信するようスケジュールされます。',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmail' => 'Sendmail 使用ポリシー',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailDefault' => 'サーバ全体のデフォルト設定（Sendmail 許可）',
    'service-plan.mail.outgoing-messages.outgoingMessagesNotEnableSendmailDefault' => 'サーバ全体のデフォルト設定（Sendmail 不許可）',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomPlan' => 'プランのカスタム設定',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomSubscription' => '契約のカスタム設定',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomLabel' => 'この契約でスクリプトとユーザに Sendmail の使用を許可する',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomHint' => 'オンにすると、スクリプトおよびユーザは、たとえメールボックスおよびドメインの上限を超過していても、（契約のシステムユーザの代理として）Sendmail を使用してメールメッセージを送信することができます。Sendmail 経由で送信できるメッセージの最大数は、契約全体の上限によって定義されます。',

    'setup.hint' => 'サーバ管理のためのコントロールパネル、Plesk へようこそ。Plesk は、コーディング対応環境を提供し、パワフルな拡張の数々が用意されているため、ウェブサイトとアプリの開発に役立ちます。Plesk を使い始めるには、セットアップを完了してください（数分ほどかかります）。',
    'setup.contactInfoSection' => '連絡先情報',
    'setup.contactInfoSectionHint' => '名前とメールアドレスを入力してサーバの所有者であることを証明すると、サーバに関する重要な通知をお届けします。企業のサーバ管理者である場合、個人名または個人のメールアドレスは入力しないでください。データ保護法の違反を防止するために、役職と会社メールアドレスを使用してください。',
    'setup.contactName' => '担当者名',
    'setup.emptyContactName' => '担当者名を入力してください。',
    'setup.contactNameTooLong' => 'この担当者名は長すぎます（%max% 文字以内にしてください）',
    'setup.email' => 'メール',
    'setup.emptyEmail' => 'メールアドレスを入力してください。',
    'setup.passwordSection' => 'パスワード',
    'setup.passwordSectionHint' => '次回 Plesk にログインするときは、ユーザ名は「admin」を、パスワードを以下に入力したものを使用してください。',
    'setup.password' => 'パスワード',
    'setup.licenseSection' => 'ライセンス',
    'setup.licenseSectionHint' => 'Plesk の使用を介しするには、ライセンスをインストールする必要があります。',
    'setup.licenseType' => 'ライセンスタイプを選択',
    'setup.licenseTypePaid' => '有料ライセンスで続ける',
    'setup.onlineStoreLink' => 'オンラインストア',
    'setup.licenseTypeTrial' => 'すべての機能を使用できる評価版ライセンスで続ける',
    'setup.activationCodeHint' => '購入済みの Plesk ライセンスがある場合、受信したアクティベーションコードをここに貼り付けてください。ない場合は%%onlineStoreLink%%で新規ライセンスを購入できます。',
    'setup.privacyPolicyLink' => 'Plesk プライバシーポリシー',
    'setup.trialLicenseAgreement' => 'Plesk International GmbH は、評価版ライセンスを発行するために、%%privacyPolicyLink%%に従い、提供された情報を内部システムで使用、処理します。',
    'setup.eulaAgreementLabel' => '私は%%link%%を読み、その内容に同意します。',
    'setup.eula' => 'エンドユーザライセンス契約（EULA）',
    'setup.invalidEulaAgreementValue' => 'エンドユーザライセンス契約に同意していただく必要があります。',
    'setup.sendButton' => 'Plesk にログイン >>',

    'ssl-certificate.add.name' => '証明書名',
    'ssl-certificate.add.longName' => '指定した証明書名が長過ぎます（最大 %max% 文字まで許可されます）。',
    'ssl-certificate.add.certificateNameUsed' => '%%name%% という名前の証明書は既に存在します。',
    'ssl-certificate.add.certificateAdded' => 'SSL/TLS 証明書が発行されました。機能させるには、証明書を割り当ててドメイン、メール、ウェブメールを保護してください。',
    'ssl-certificate.add.certificateUpdated' => 'SSL/TLS 証明書が正常に更新されました。',
    'ssl-certificate.add.settings' => '設定',
    'ssl-certificate.add.settingsHint' => 'このフォームを使用して、証明書のリクエストの生成、プロバイダから証明書の購入、または自己署名証明書の生成を実行します。',
    'ssl-certificate.add.settingsHint2' => 'リクエストとは、フォームで指定したドメインについての情報が含まれる CSR ファイルのことです。リクエストを認証局に送信し、証明書の発行を依頼することができます。次に、以下のいずれかのアップロードフォームを使用してアップロードします。',
    'ssl-certificate.add.settingsHint3' => '自己署名証明書とは、発行者自身が署名した身元証明書のことです。このような証明書を使用する場合、自らのサイトの身元を自ら証明することになります。自己署名証明書では SSL/TLS を使用できますが、信頼性と安全性は低いと見なされます。',
    'ssl-certificate.add.bits' => 'ビット',
    'ssl-certificate.add.country' => '国',
    'ssl-certificate.add.state' => '都道府県',
    'ssl-certificate.add.longState' => '指定した都道府県名が長過ぎます。',
    'ssl-certificate.add.city' => '所在地（市区町村）',
    'ssl-certificate.add.longCity' => '入力した市区町村名が長すぎます。',
    'ssl-certificate.add.shortCity' => '指定した市区町村名が短すぎます。',
    'ssl-certificate.add.companyName' => '組織名（会社）',
    'ssl-certificate.add.longCompanyName' => '入力した会社名が長すぎます。',
    'ssl-certificate.add.companyUnitName' => '部/課名',
    'ssl-certificate.add.longCompanyUnitName' => '指定した組織部門名が長過ぎます（最大 %max% 文字まで許可されます）。',
    'ssl-certificate.add.domainName' => 'ドメイン名',
    'ssl-certificate.add.email' => 'メール',
    'ssl-certificate.add.request' => 'リクエスト',
    'ssl-certificate.add.buyCertificate' => 'SSL/TLS 証明書を購入',
    'ssl-certificate.add.selfSigned' => '自己署名',
    'ssl-certificate.add.invalidCertificateParams' => '一部のフィールドが空であるか不適切な値が含まれています。値は 64 文字以内にする必要があります。国際化ドメイン名を使用している場合、ドメイン名のドットとドットの間のいずれの部分についても、ASCII 文字に変換して 63 文字を超えないことを確認してください。次のフィールドをチェックしてください。',
    'ssl-certificate.add.unableCreateCsr' => 'CSR を作成することができません。%%error%%',
    'ssl-certificate.add.unableCreateSelfSigned' => '自己署名証明書を作成することができません。%%error%%',
    'ssl-certificate.add.unableCreateUpload' => '証明書データを設定することができません。%%error%%',
    'ssl-certificate.add.unableSaveCertificate' => 'データベースに証明書を保存することができません。%%error%%',
    'ssl-certificate.add.uploadFiles' => '証明書ファイルをアップロード',
    'ssl-certificate.add.uploadFilesHint' => '証明書のコンポーネントをファイルとしてアップロードするには、このフォームを使用します。',
    'ssl-certificate.add.csr' => 'CSR',
    'ssl-certificate.add.privateKey' => "秘密キー（*.key）",
    'ssl-certificate.add.certificate' => "証明書（*.crt）",
    'ssl-certificate.add.caCertificate' => "CA 証明書（*-ca.crt）",
    'ssl-certificate.add.sendFiles' => "証明書をアップロード",
    'ssl-certificate.add.fileNotUploaded' => '証明書ファイル %%name%% をアップロードできません。',
    'ssl-certificate.add.unableSetPrivateKey' => '秘密キーを設定できません。%%error%%',
    'ssl-certificate.add.unableSetCertificate' => '証明書を設定できません。%%error%%',
    'ssl-certificate.add.unableSetCaCertificate' => 'CA 証明書を設定できません。%%error%%',
    'ssl-certificate.add.unableCheckCaCertificate' => 'CA 証明書が証明書に署名しているかどうかを確認できません。%%error%%',
    'ssl-certificate.add.removeCaCertificate' => '削除',
    'ssl-certificate.add.removeCaCertificateConfirmation' => 'CA 証明書を削除しますか？',
    'ssl-certificate.add.unableRemoveCaCertificate' => 'CA 証明書をクリアできません。%%error%%',
    'ssl-certificate.add.caCertificateRemoved' => '証明書の CA 部分が削除されました。',
    'ssl-certificate.add.rename' => '名前変更',
    'ssl-certificate.add.unableRenameCertificate' => '証明書名を変更できません。%%error%%',
    'ssl-certificate.add.certificateRenamed' => '証明書名は %%name%% に変更されました。',
    'ssl-certificate.add.uploadText' => "証明書をテキスト形式でアップロード",
    'ssl-certificate.add.uploadTextHint' => '証明書のコンポーネントをテキストとしてアップロードするには、このフォームを使用します。ファイルのコンテンツを該当フィールドにコピー＆ペーストしてください。',
    'ssl-certificate.add.sendText' => "証明書をアップロード",
    'ssl-certificate.add.componentIsMissing' => 'このコンポーネントはありません。',

    'ssl-certificate.find-private-key.findPrivateKey' => '証明書をアップロード',
    'ssl-certificate.find-private-key.formGeneralHint' => 'このサーバで証明書署名リクエストを作成した場合、証明書ファイルを受信したらここからアップロードします。別のサーバで生成された証明書と秘密キーのペアをアップロードしたい場合や、自己署名証明書を生成したい場合には、<b>［SSL/TLS 証明書を追加］</b>をクリックしてください。',
    'ssl-certificate.find-private-key.formCertificateAddingHint' => 'SSL/TLS 証明書をドメインに追加した後で、SSL/TLS サポートを有効化して、ウェブサイトのホスティング設定で証明書を選択する必要があります（<b>［ウェブサイトとドメイン］</b> > このドメインの<b>［ホスティング設定］</b> > <b>［セキュリティ］</b>）。',
    'ssl-certificate.find-private-key.uploadCertificate' => '証明書（*.crt）',
    'ssl-certificate.find-private-key.sendFile' => '証明書をアップロード',
    'ssl-certificate.find-private-key.fileNotUploaded' => '証明書ファイルをアップロードできません。',
    'ssl-certificate.find-private-key.invalidCertificateFormat' => '無効な証明書フォーマットです。',
    'ssl-certificate.find-private-key.unableFindPrivateKey' => '証明書に適した秘密キーが見つかりません。',

    'ssl-certificate.secure.certificate' => '証明書を選択',
    'ssl-certificate.secure.serverPool' => 'サーバプール',
    'ssl-certificate.secure.certificateName' => '%%certificateName%%（%%repositoryName%%）',

    'web-app-firewall.pageHint' => 'ウェブアプリケーションファイアウォールは、ユーザの定義したルールに基づいて受信 HTTP 要求のチェックとフィルタリングを行うことで、ウェブアプリケーションを保護します。',
    'web-app-firewall.webSitePageHint' => 'ウェブアプリケーションファイアウォール（ModSecurity）を構成します。',
    'web-app-firewall.ruleEngine' => 'ウェブアプリケーションファイアウォールのモード',
    'web-app-firewall.ruleEngineOn' => 'オン',
    'web-app-firewall.ruleEngineOnDescription' => 'それぞれの受信 HTTP 要求および関連する応答は、ルールのセットに対してチェックされます。チェックが成功すると、HTTP 要求がウェブサイトコンテンツに渡されます。チェックが失敗すると、イベントはログに記録され、通知が送信され、HTTP 応答にエラーコードが割り当てられます。',
    'web-app-firewall.ruleEngineOff' => 'オフ',
    'web-app-firewall.ruleEngineOffDescription' => '受信 HTTP 要求および関連する応答はチェックされません。',
    'web-app-firewall.ruleEngineDetectionOnly' => '検出のみ',
    'web-app-firewall.ruleEngineDetectionOnlyDescription' => 'それぞれの受信 HTTP 要求および関連する応答は、ルールのセットに対してチェックされます。チェックが成功すると、HTTP 要求がウェブサイトコンテンツに渡されます。チェックが失敗すると、イベントはログに記録され、ModSecurity は追加の処理を行いません。その他のサービス（Fail2ban など）は、引き続き、チェックが失敗した HTTP 要求で処理を実行できます。',
    'web-app-firewall.ruleSetsSection' => 'ルールセット',
    'web-app-firewall.ruleSetsSectionHint' => '受信 HTTP 要求のチェックに使用するルールセット（セキュリティルールが含まれるファイルパッケージ）を選択してください。',
    'web-app-firewall.ruleSet' => 'ルールセット',
    'web-app-firewall.ruleSetCrs' => 'OWASP（無料）',
    'web-app-firewall.ruleSetCrsDescription' => 'OWASP ModSecurity Core Rule Set は制限が多く、一部の機能がブロックされる可能性があります（ファイル共有、ウェブメールなど）。また、ウェブアプリケーションの一部の機能（WordPress プラグインなど）もブロックされる可能性があります。',
    'web-app-firewall.ruleSetCrsConfirmTitle' => '変更内容を適用しますか？',
    'web-app-firewall.ruleSetCrsConfirmDescription' => '時に、OWASP ルールが厳格すぎて、ファイル共有、ウェブメール、一部のウェブアプリケーションがブロックされる場合があります。',
    'web-app-firewall.ruleSetTortix' => 'Atomic Standard（無料、Atomic Advanced にアップグレード可能です）',
    'web-app-firewall.ruleSetTortixDescription' => 'ModSecurity Rules by Atomicorp のスターターバージョンです。基本的な保護を提供し、毎月更新されます。',
    'web-app-firewall.ruleSetTortixHowTo' => 'このルールセットを Atomic Advanced にアップグレードするには：',
    'web-app-firewall.ruleSetTortixBuy' => 'Plesk ウェブサイトと %%linkDocumentation%% から %%linkPleskStore%% を購入してください。',
    'web-app-firewall.ruleSetTortixLinkPleskStoreLabel' => 'Advanced ModSecurity Rules by Atomicorp',
    'web-app-firewall.ruleSetTortixLinkDocumentationLabel' => '購入した追加ライセンスキーをインストール',
    'web-app-firewall.ruleSetTortixSelect' => 'このルールセットを選択してください。名前が「Atomic Advanced（Plesk から購入）」に変わります。',
    'web-app-firewall.ruleSetTortixPro' => 'Atomic Advanced（Plesk から購入）',
    'web-app-firewall.ruleSetTortixProDescription' => 'Advanced ModSecurity Rules by Atomicorp は、Atomic Standard ルールと多数の高度な機能を提供します。',
    'web-app-firewall.ruleSetAtomic' => 'Atomic Advanced（Atomicorp から購入）',
    'web-app-firewall.ruleSetAtomicDescription' => 'Advanced ModSecurity Rules by Atomicorp は、Atomic Standard ルールと多数の高度な機能を提供します。',
    'web-app-firewall.ruleSetAtomicInstall' => '別の Atomicorp アカウントに切り替えます。',
    'web-app-firewall.ruleSetAtomicInstalled' => 'ルールセットがアクティブ化されました。',
    'web-app-firewall.ruleSetAtomicHowTo' => '既に Atomicorp アカウントをお持ちで、Atomic Advanced ルールを購入済みの場合、以下にアカウントのクレデンシャルを入力してこのルールセットを有効にしてください。',
    'web-app-firewall.ruleSetAtomicSwitchHowTo' => '既に Atomicorp アカウントをお持ちで、Atomic Advanced ルールを購入済みの場合、以下にアカウントのクレデンシャルを入力してアカウントを切り替えてください。',
    'web-app-firewall.ruleSetAtomicLogin' => 'ユーザ名',
    'web-app-firewall.ruleSetAtomicPassword' => 'パスワード',
    'web-app-firewall.ruleSetComodo' => 'Comodo（無料サブスクリプション）',
    'web-app-firewall.ruleSetComodoDescription' => 'Comodo の無料 ModSecurity ルール。基本的な保護を提供します。',
    'web-app-firewall.ruleSetComodoInstall' => '別の Comodo アカウントに切り替えます。',
    'web-app-firewall.ruleSetComodoInstalled' => 'ルールセットがアクティブ化されました。',
    'web-app-firewall.ruleSetComodoHowTo' => 'このルールセットを有効化するには：',
    'web-app-firewall.ruleSetComodoSwitchHowTo' => '別のアカウントに切り替えるには：',
    'web-app-firewall.ruleSetComodoRegister' => 'Comodo ウェブサイトで登録してください。',
    'web-app-firewall.ruleSetComodoCredentials' => 'このウェブサイトのユーザ名とパスワードを入力してください。',
    'web-app-firewall.ruleSetComodoLogin' => 'ユーザ名',
    'web-app-firewall.ruleSetComodoPassword' => 'パスワード',
    'web-app-firewall.ruleSetComodoFree' => 'Comodo（無料）',
    'web-app-firewall.ruleSetComodoFreeDescription' => 'Comodo の無料 ModSecurity ルール。基本的な保護を提供します。',
    'web-app-firewall.ruleSetCustom' => 'カスタムルールセット',
    'web-app-firewall.ruleSetCustomDescription' => 'ウェブアプリケーションファイアウォールのカスタムルールセットをアップロードします。サポートされるフォーマット：zip、tar.gz、tgz、tar.bz2、conf',
    'web-app-firewall.ruleSetCustomUpload' => '別のファイルを選択',
    'web-app-firewall.ruleSetError' => 'ModSecurity ルールセットのインストールに失敗しました。%%error%%',
    'web-app-firewall.ruleSetAuthError' => '指定したユーザ名またはパスワードが無効です。',
    'web-app-firewall.ruleSetInvalid' => '選択したルールセットは %%webServer%% で機能しません。',
    'web-app-firewall.ruleSetSelectedInvalid' => '選択されたルールセットは、選択されたウェブサーバ上で機能しません。',
    'web-app-firewall.webServer' => 'ルールを実行:',
    'web-app-firewall.webServerHint' => '対応するルールセットを確認するには、ウェブサーバと ModSecurity バージョンの適切な組み合わせを選択してください。',
    'web-app-firewall.webServerApache' => 'Apache (ModSecurity 2.9)',
    'web-app-firewall.webServerNginx' => 'Nginx (ModSecurity 3.0)',
    'web-app-firewall.webServerIis' => 'IIS (ModSecurity 2.9)',
    'web-app-firewall.nginxNotRunning' => 'リバースプロキシサーバ（nginx）がオフになっており、要求の処理に使用できません。<a href="%%serverUrl%%">別のウェブサーバ</a>を選択するか、<a href="%%servicesUrl%%">［サービス管理］ページ</a>でリバースプロキシサーバをオンに切り替えてください。',
    'web-app-firewall.nginxIsIncompatible' => '別の ModSecurity バージョンを選択すると、一部の設定が有効ではなくなる可能性があります（たとえば、ModSecurity 3 では正規表現を使用してセキュリティルールをオフにすることはできません）。変更を適用した後で、設定が期待どおりに機能することを確認してください。あるいは、設定をリセットして、セキュリティルールをデフォルト値に戻すこともできます。',
    'web-app-firewall.nginxResetCustomizations' => 'サーバとドメインの設定をリセットし、セキュリティルールをデフォルト値に戻すことができます。',
    'web-app-firewall.ruleSetUpdate' => 'ルールセットを更新',
    'web-app-firewall.ruleSetUpdateDaily' => '毎日',
    'web-app-firewall.ruleSetUpdateWeekly' => '毎週',
    'web-app-firewall.ruleSetUpdateMonthly' => '毎月',
    'web-app-firewall.currentRuleSet' => 'ルールセット',
    'web-app-firewall.currentRuleSetValue' => '%%ruleSet%% %%changeRuleSetLink%%',
    'web-app-firewall.currentRuleSetRunningOn' => '%%webServer%% で実行中の %%ruleSet%%',
    'web-app-firewall.changeRuleSetLink' => 'ルールセットを変更',
    'web-app-firewall.ruleSetRollbackFailed' => '現在の ModSecurity ルールセットを使用したり、前のバージョンにロールバックすることができません。無効なルールが含まれています。',
    'web-app-firewall.configurationSection' => '構成',
    'web-app-firewall.configurationSectionHint' => '事前定義されたパラメータセットまたはカスタム ModSecurity ディレクティブを使用してウェブアプリケーションファイアウォールを構成します。',
    'web-app-firewall.configPreset' => '事前定義された値セット',
    'web-app-firewall.configPresetFast' => '高速',
    'web-app-firewall.configPresetFastDescription' => 'HTTP 要求 の URI およびヘッダ部分が解析されます。',
    'web-app-firewall.configPresetTradeOff' => 'トレードオフ',
    'web-app-firewall.configPresetTradeOffDescription' => 'HTTP 要求の URI、ヘッダ、および要求の POST データが解析されます。',
    'web-app-firewall.configPresetThrough' => '完全',
    'web-app-firewall.configPresetThroughDescription' => 'HTTP 要求のヘッダ全体、要求の POST データ、および HTTP 応答の本文が解析されます。',
    'web-app-firewall.configCustom' => 'カスタムディレクティブ',
    'web-app-firewall.configCustomDescription' => "ここに ModSecurity ディレクティブを入力します。これは、以前に指定したディレクティブ（ルールセット、特定のルール、事前定義された値セットなど）をオーバーライドします。\n例：SecDebugLogLevel 6",
    'web-app-firewall.configCustomError' => '無効な ModSecurity 構成：%%error%%',
    'web-app-firewall.configRollbackFailed' => '最新の ModSecurity 構成ファイルを使用したり、前のバージョンにロールバックすることができません。無効な構成が含まれています。',
    'web-app-firewall.rulesSection' => 'セキュリティルールをオフにする',
    'web-app-firewall.rulesSectionHint' => 'セキュリティルールをオフにすることができます。これは、セキュリティルールが一部のウェブサイトに対して厳格すぎると思われる場合に役に立ちます。セキュリティルールを無効にするには、ルールの ID（340003、340005-340007 など）、タグ（CVE-2011-4898 など）、またはルールメッセージで使用される正規表現（XSS など）を指定してください。',
    'web-app-firewall.rulesSectionNginxHint' => 'セキュリティルールをオフにすることができます。これは、セキュリティルールが一部のウェブサイトに対して厳格すぎると思われる場合に役に立ちます。セキュリティルールを無効にするには、ルールの ID（340003、340005-340007 など）、タグ（CVE-2011-4898 など）、またはルールメッセージ（「セキュリティスキャナーに関連付けられている User-Agent が検出されました」など）を指定してください。',
    'web-app-firewall.filterById' => 'セキュリティルール ID',
    'web-app-firewall.filterByIdInvalid' => '次の値は有効ではありません: %%values%%。ルール ID は 913100、913105-913107 のように数字または数字の範囲で構成する必要があります。',
    'web-app-firewall.filterByIdInvalidRanges' => '次の範囲は有効ではありません：%%ranges%%。',
    'web-app-firewall.filterByTag' => 'タグ',
    'web-app-firewall.filterByTagActive' => 'アクティブ：',
    'web-app-firewall.filterByTagDeactivated' => '非アクティブ：',
    'web-app-firewall.filterByTagInvalid' => '次の選択した値が無効です: %%values%%。',
    'web-app-firewall.filterByRegexp' => 'ルールメッセージの正規表現',
    'web-app-firewall.filterByRegexpInvalid' => '次の値は有効ではありません：%%values%%。\', " のいずれも含めないでください。',
    'web-app-firewall.filterByRegexpNginx' => 'ルールメッセージ',
    'web-app-firewall.filterByRegexpNginxHint' => '厳密な一致のみがサポートされます。',
    'web-app-firewall.filterByRegexpNginxInvalid' => '次の値は有効ではありません：%%values%%。ルールメッセージには、文字、数字、スペース、または -:;.,!?#&$%*()/ を含める必要があります。',
    'web-app-firewall.auditLogSection' => 'ModSecurity 監査ログ',
    'web-app-firewall.auditLogHint1' => 'ModSecurity 監査ログファイルは、システム内で最も有益な情報を提供します。ModSecurity が何らかのイベントが発生したことを検知すると、監査ログファイルにエントリが生成されます。',
    'web-app-firewall.auditLogHint2' => 'ウェブアプリケーションファイアウォールのモードを「オフ」または「検出のみ」から「オン」に変更した後で、ウェブサイトの機能が停止することがあります。この場合、ModSecurity 監査ログを参照し、何が起こっているのかを確認してください。厳格すぎるセキュリティルールをオフにしたり、ウェブサイトを調整することができます。',
    'web-app-firewall.auditLogHint3' => 'あるウェブサイトに対し、HTTP 要求が完了しない理由を確認するには：',
    'web-app-firewall.auditLogPoint1' => '下の［ModSecurity ログファイル］リンクをクリックすると、新しいブラウザ画面に監査ログが表示されます。',
    'web-app-firewall.auditLogPoint2' => '検索機能（大部分のブラウザでは Ctrl+F）を使用して、問題が発生しているウェブサイト（ドメイン名）のイベントを探します（例：「your_domain.tld」）。ブラウザで「HOST: your_domain.tld」のようなエントリがハイライトされます。',
    'web-app-firewall.auditLogPoint3' => 'ハイライトされたエントリの 3 行上に「--eece5138-B--」のようなエントリがあります。ハイフンの間の 8 文字（この例では「eece5138」）は、HTTP 要求でトリガされたイベントの ID です。',
    'web-app-firewall.auditLogPoint4' => 'さらに、同じイベント ID を持つエントリを探します。イベント ID の後に「H」という文字が付いたエントリを探します（この例では「eece5138-H--」）。このエントリには、HTTP 要求のチェック時にトリガされたセキュリティルールの ID と説明が含まれています。セキュリティルール ID とは、引用符に囲まれた 3 から始まる整数であり、プレフィックス「id」付きで角括弧に囲まれています（例：[id "340003"]）。',
    'web-app-firewall.auditLogPoint5' => '「[id "3」という文字列の一部を使用して、イベント内でセキュリティルール ID を探します。',
    'web-app-firewall.auditLogPoint6' => '下のセキュリティルールセクションで、この ID のセキュリティルールをオフにします。［セキュリティルール ID］フィールドにセキュリティルール ID（数字のみ）を入力し、［OK］をクリックしてください。',
    'web-app-firewall.auditLogViewLink' => 'ModSecurity ログファイル',
    'web-app-firewall.auditLogListLink' => 'ログアーカイブ',
    'web-app-firewall.errorLogSection' => 'エラーログ',
    'web-app-firewall.errorLogSectionHint' => 'ウェブアプリケーションファイアウォールのモードを「オフ」または「検出のみ」から「オン」に変更した後で、ウェブサイトの機能が停止することがあります。この場合、エラーログを参照し、何が起こっているのかを確認してください。厳格すぎるセキュリティルールをオフにしたり、ウェブサイトを調整することができます。',
    'web-app-firewall.errorLogViewLink' => 'エラーログファイル',
    'web-app-firewall.notificationStateEnabled' => 'ルールセットのアップデートに関する Plesk UI 通知はオンになっています。%%notificationLink%%',
    'web-app-firewall.notificationStateDisabled' => 'ルールセットのアップデートに関する Plesk UI 通知はオフになっています。%%notificationLink%%',
    'web-app-firewall.notificationLink' => '通知ページで管理する',
];