<?php
// Copyright 1999-2021. Plesk International GmbH. All rights reserved.
$messages = [
    'access-network.subnetOrIpAddressLabel' => 'Подсеть или IP-адрес',
    'access-network.subnetOrIpAddressHint' => 'Например, 2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'admin.announcement-settings.announcementLegend' => 'Информационные сообщения',
    'admin.announcement-settings.getConsentLoading' => 'Получение данных об информационных сообщениях...',
    'admin.announcement-settings.getConsentWarning' => 'Не удалось получить состояние подписки.',
    'admin.announcement-settings.sendAnnounceConsent' => 'Я хочу получать информационные сообщения от Plesk. Они могут содержать информацию, относящуюся к безопасности, техническим деталям и продукту в целом. Я разрешаю и уполномочиваю Plesk собирать, обрабатывать и использовать мои персональные данные (адрес электронной почты), включая трансграничную передачу данных, в соответствии с действующими законами о защите данных, чтобы отправлять мне информационные сообщения либо напрямую, либо через стороннюю службу. Снятие этой галочки отменяет мое разрешение и означает требование того, чтобы Plesk прекратил отправлять мне письма и безвозвратно удалил мои персональные данные из всех своих систем.',
    'admin.announcement-settings.sendAnnouncePersonalizedConsent' => 'Да, я даю свое согласие на получение персонализированной новостной рассылки Plesk. Я разрешаю компании Plesk International GmbH и ее аффилированным лицам хранить и обрабатывать предоставленные мной данные с целью рассылки новостей в соответствии с %%privacyPolicy%%. Для подготовки адресованных мне писем и предложений Plesk может также использовать дополнительную информацию обо мне, например, данные об использовании Plesk и сценариях поведения. Я могу отменить эту подписку в любое время.',
    'admin.announcement-settings.privacyPolicy' => 'Политикой конфиденциальности Plesk',
    'admin.announcement-settings.noConsent' => 'Отменить подписку на новостную рассылку Plesk.',
    'admin.announcement-settings.reportConsentError' => 'Не удалось сохранить настройки получения информации от Plesk: %%error%%.',
    'admin.announcement-settings.profileUpdateError' => 'К сожалению, в настоящий момент мы не можем обновить ваш профиль. Пожалуйста, повторите попытку позже.',
    'admin.announcement-settings.invalidConsentType' => "Неизвестный тип подтверждения согласия: '%%type%%'",
    'admin.announcement-settings.retry' => 'Повторить',
    'admin.announcement-settings.consentGivenInfo' => 'Надеемся, наша основная новостная рассылка была вам полезна. Предлагаем вам другой вариант ― подписаться на персонализированную рассылку, содержащую действительно нужную информацию и советы, подходящие именно вам. Чтобы получать такую рассылку, выберите первый из предложенных ниже вариантов и нажмите "ОК".',
    'admin.announcement-settings.consentNotGivenInfo' => 'Похоже, вы не подписаны на нашу основную новостную рассылку. Предлагаем вам другой вариант ― подписаться на персонализированную рассылку, содержащую действительно полезную информацию и советы, подходящие именно вам.',

    'admin.personal-info.title' => 'Изменение сведений об администраторе',
    'admin.personal-info.pleskSettingsSectionLegend' => 'Настройки Plesk',
    'admin.personal-info.settingsSectionLegend' => 'Настройки',

    'admin-alias.login' => 'Имя пользователя',
    'admin-alias.password' => 'Пароль',
    'admin-alias.passwordConfirmation' => 'Подтверждение пароля',
    'admin-alias.email' => 'Электронная почта',
    'admin-alias.contact' => 'Контактное имя',
    'admin-alias.comments' => 'Комментарии',
    'admin-alias.emptyLogin' => 'Пожалуйста, укажите имя пользователя.',
    'admin-alias.loginTooLong' => 'Длина имени пользователя превышает 20 символов.',
    'admin-alias.emptyEmail' => 'Пожалуйста, укажите адрес электронной почты.',
    'admin-alias.emptyContactName' => 'Пожалуйста, укажите контактное имя.',
    'admin-alias.contactNameTooLong' => 'Длина контактного имени превышает 255 символов.',
    'admin-alias.emptyPassword' => 'Пожалуйста, укажите пароль.',
    'admin-alias.commentsTooLong' => 'Длина комментария превышает 255 символов.',
    'admin-alias.emailActivation' => 'Активировать учетную запись по электронной почте',
    'admin-alias.simplePanel' => 'Включить Ограниченный режим',
    'admin-alias.simplePanelHint' => 'Выберите эту опцию, чтобы ограничить количество операций, которые дополнительный администратор сможет выполнять в Plesk. Чтобы изменить набор доступных операций, перейдите по ссылке %%link%%.',
    'admin-alias.simplePanelLink' => 'Инструменты и настройки > Настройки Ограниченного режима',
    'admin-alias.lockPowerUser' => 'Принудительно включить режим Power User для дополнительного администратора',
    'admin-alias.lockPowerUserHint' => 'Возможность включить Ограниченный режим для дополнительного администратора Plesk (без доступа к клиентам, реселлерам и тарифным планам).',

    'admin-info.plesk-settings.multiplyLogin' => 'Разрешить несколько сеансов для этой учетной записи',
    'admin-info.plesk-settings.adminLanguage' => 'Язык интерфейса администратора',
    'admin-info.plesk-settings.password' => 'Пароль',
    'admin-info.plesk-settings.passwordConfirmation' => 'Подтверждение пароля',

    'admin-panel.form.contact-info.contactName' => 'Контактное имя',
    'admin-panel.form.contact-info.emptyContactName' => 'Пожалуйста, укажите контактное имя.',
    'admin-panel.form.contact-info.contactNameTooLong' => 'Контактное имя слишком длинное (максимальная длина — %max% символов).',
    'admin-panel.form.contact-info.email' => 'Электронная почта',
    'admin-panel.form.contact-info.emptyEmail' => 'Пожалуйста, укажите адрес электронной почты.',
    'admin-panel.form.contact-info.companyName' => 'Название компании',
    'admin-panel.form.contact-info.longCompanyName' => 'Слишком длинное название компании (максимальная длина — %max% символов).',
    'admin-panel.form.contact-info.phone' => 'Номер телефона',
    'admin-panel.form.contact-info.longPhone' => 'Слишком длинный номер телефона (максимальная длина — %max% символов).',
    'admin-panel.form.contact-info.fax' => 'Факс',
    'admin-panel.form.contact-info.imNumber' => 'Программа для мгновенного обмена сообщениями',
    'admin-panel.form.contact-info.longFax' => 'Слишком длинный номер факса (максимальная длина — %max% символов).',
    'admin-panel.form.contact-info.phoneRegexNotMatch' => 'Недопустимый номер телефона.',
    'admin-panel.form.contact-info.faxRegexNotMatch' => 'Неверный номер факса.',
    'admin-panel.form.contact-info.address' => 'Адрес',
    'admin-panel.form.contact-info.longAddress' => 'Слишком длинный адрес (максимальная длина — %max% символов).',
    'admin-panel.form.contact-info.city' => 'Город',
    'admin-panel.form.contact-info.longCity' => 'Слишком длинное название города',
    'admin-panel.form.contact-info.shortCity' => 'Слишком короткое название города',
    'admin-panel.form.contact-info.state' => 'Область/регион',
    'admin-panel.form.contact-info.postalCode' => 'Почтовый индекс',
    'admin-panel.form.contact-info.country' => 'Страна',
    'admin-panel.form.contact-info.additionalInfo' => 'Дополнительная информация',
    'admin-panel.form.contact-info.additionalInfoHint' => 'Только текст: все HTML-теги будут опущены.',
    'admin-panel.form.contact-info.duplicateEmail' => 'Пользователь с таким адресом электронной почты уже существует в системе.',

    'admin-panel.form.domain-info-section.domainInfoSection' => 'Подписка',
    'admin-panel.form.domain-info-section.domainInfoSectionForCustomerHint' => 'Свойства сайта, входящего в подписку.',
    'admin-panel.form.domain-info-section.domainInfoSectionForResellerHint' => 'Свойства сайта, входящего в подписку.',
    'admin-panel.form.domain-info-section.domainInfoSectionOwnHint' => 'Свойства сайта, входящего в подписку.',
    'admin-panel.form.domain-info-section.createSubscription' => 'Создать подписку для клиента',
    'admin-panel.form.domain-info-section.createSubscriptionHint' => 'Снимите этот флажок, если пока не хотите создавать подписку или сайт для этого клиента. Без подписки клиент не сможет войти в Панель клиента.',
    'admin-panel.form.domain-info-section.domainName' => 'Имя домена',
    'admin-panel.form.domain-info-section.emptyDomainName' => 'Вы должны указать имя домена.',
    'admin-panel.form.domain-info-section.shared' => 'общий',
    'admin-panel.form.domain-info-section.exclusive' => 'выделенный',
    'admin-panel.form.domain-info-section.userName' => 'Имя пользователя',
    'admin-panel.form.domain-info-section.userNameHint' => 'Системная учетная запись пользователя, служащая для управления файлами и папками сайтов, созданных в рамках этой подписки.',
    'admin-panel.form.domain-info-section.emptyLogin' => 'Вы должны указать имя пользователя.',
    'admin-panel.form.domain-info-section.password' => 'Пароль',
    'admin-panel.form.domain-info-section.emptyPassword' => 'Вы должны указать пароль.',
    'admin-panel.form.domain-info-section.passwordConfirmation' => 'Подтвердите пароль',
    'admin-panel.form.domain-info-section.ipv4AddressHint' => "IP-адрес, на котором размещен сайт, является сетевым адресом виртуального сервера сайта.",
    'admin-panel.form.domain-info-section.ipv4Address' => 'IPv4-адрес',
    'admin-panel.form.domain-info-section.ipv6AddressHint' => "IP-адрес, на котором размещен сайт, является сетевым адресом виртуального сервера сайта.",
    'admin-panel.form.domain-info-section.ipv6Address' => 'IPv6-адрес',
    'admin-panel.form.domain-info-section.noIpAddressHint' => 'Нет',
    'admin-panel.form.domain-info-section.subscriptionSettings' => 'Настройки дополнительной подписки',
    'admin-panel.form.domain-info-section.credentials' => 'Учетные данные системного пользователя',
    'admin-panel.form.domain-info-section.credentialsHint' => 'для доступа к размещенным файлам по FTP и SSH',

    'admin-panel.form.login-info.userName' => 'Имя пользователя',
    'admin-panel.form.login-info.emptyUserName' => 'Пожалуйста, укажите имя пользователя.',
    'admin-panel.form.login-info.password' => 'Пароль',
    'admin-panel.form.login-info.emptyPassword' => 'Пожалуйста, укажите пароль.',
    'admin-panel.form.login-info.passwordConfirmation' => 'Повторите пароль',
    'admin-panel.form.login-info.emailActivation' => 'Активировать учетную запись по электронной почте',
    'admin-panel.form.login-info.emailActivationHint' => 'Созданная учетная запись неактивна до тех пор, пока пользователь не активирует ее с помощью ссылки, отправленной по электронной почте, либо администратор не активирует ее вручную.',

    'admin-panel.form.subscription-info-section.subscription' => 'Подписка',
    'admin-panel.form.subscription-info-section.servicePlan' => 'Тарифный план',
    'admin-panel.form.subscription-info-section.oldServicePlan' => 'Текущий тарифный план',
    'admin-panel.form.subscription-info-section.newServicePlan' => 'Новый тарифный план',
    'admin-panel.form.subscription-info-section.adminPlan' => 'Упрощенный план',
    'admin-panel.form.subscription-info-section.none' => 'нет',
    'admin-panel.form.subscription-info-section.addonPlans' => 'Дополнения',
    'admin-panel.form.subscription-info-section.customizeSubscription' => 'После изменения связи плана перейти к настройке параметров подписки. Учтите, что это приведет к блокировке синхронизации подписки.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionOnCreateSubscription' => 'После создания подписки перейти к настройке ее параметров.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionForCustomer' => "После создания клиента перейти к настройке параметров подписки. Учтите, что это приведет к блокировке синхронизации подписки.",
    'admin-panel.form.subscription-info-section.customizeSubscriptionForSelf' => 'После создания подписки перейти к настройке ее параметров. Учтите, что это приведет к блокировке синхронизации подписки.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionHint' => 'Учтите, что это приведет к блокировке синхронизации подписки.',
    'admin-panel.form.subscription-info-section.buttonOk' => 'Добавить подписку',

    'admin-panel.form.subscription.subscriptionNotSynchronized' => 'Не удалось синхронизировать подписку с тарифным планом. Следующие настройки подписки конфликтуют с тарифным планом: %%problems%%.',

    'app.configure.otherSettings' => 'Другое',
    'app.configure.passwordConfirmation' => 'Подтверждение пароля',

    'app.update-settings.description' => '',
    'app.update-settings.forceUpdates' => 'Принудительно обновлять все приложения',
    'app.update-settings.forceUpdatesHint' => 'Эта опция позволяет включить автоматическую установку обновлений для всех приложений клиентов. Сами клиенты отключить эту возможность не смогут. Предупреждение: пожалуйста, учтите, что обновления могут серьезно повлиять на работу приложений. Например, после перехода на новую версию приложения могут перестать работать некоторые из его расширений.',
    'app.update-settings.suggestUpdates' => 'Опция "Автоматически обновлять это приложение" включена по умолчанию',
    'app.update-settings.suggestUpdatesHint' => 'В настройках вновь устанавливаемых приложений будет включена опция "Автоматически обновлять это приложение".',

    'backup.server-settings.rotation' => 'Максимальное количество хранимых полных резервных копий (включая созданные по расписанию и вручную)',
    'backup.server-settings.rotationDescription' => 'Пользователи могут хранить не больше указанного здесь количества полных резервных копий. Если количество полных резервных копий в хранилище превышает это ограничение, сохраняются только недавно созданные резервные копии. Ограничение не распространяется на инкрементные резервные копии.',
    'backup.server-settings.maxProcesses' => 'Максимальное число одновременно запущенных плановых процессов резервного копирования',
    'backup.server-settings.niceScheduled' => 'Запускать запланированные процессы резервного копирования с низким приоритетом',
    'backup.server-settings.niceScheduledPriority' => 'Приоритет',
    'backup.server-settings.niceScheduledPriorityDescription' => 'Введите значение от 1 до 19 включительно. Чем больше число, тем ниже приоритет.',
    'backup.server-settings.niceScheduledIoPriority' => 'Приоритет ввода-вывода процесса',
    'backup.server-settings.niceScheduledIoPriorityDescription' => 'Введите значение от 0 до 7 включительно. Чем больше число, тем ниже приоритет.',
    'backup.server-settings.niceAlways' => 'Запускать все процессы резервного копирования с низким приоритетом',
    'backup.server-settings.niceAlwaysPriority' => 'Приоритет',
    'backup.server-settings.niceAlwaysPriorityDescription' => 'Введите значение от 1 до 19 включительно. Чем больше число, тем ниже приоритет.',
    'backup.server-settings.niceAlwaysIoPriority' => 'Приоритет ввода-вывода процесса',
    'backup.server-settings.niceAlwaysIoPriorityDescription' => 'Введите значение от 0 до 7 включительно. Чем больше число, тем ниже приоритет.',
    'backup.server-settings.noCompression' => 'Не сжимать файлы резервных копий',
    'backup.server-settings.freeSpaceRequired' => 'Выполнять резервное копирование, только если на сервере свободно указанное количество места (в мегабайтах)',
    'backup.server-settings.checkBackupDiskSpace' => 'Запускать резервное копирование, только если на сервере достаточно свободного места',
    'backup.server-settings.mssqlNativeBackupEnabled' => 'Используйте собственную функциональность резервного копирования MS SQL (для удаленных баз данных нужно сначала настроить удаленный сервер MSSQL на странице Инструменты и настройки >  Серверы баз данных)',
    'backup.server-settings.localFtpRestriction' => 'Разрешить добавление FTP-хранилищ резервных копий на локальном сервере',
    'backup.server-settings.backupSecuritySettings' => 'Настройки безопасности резервного копирования',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailed' => 'Сохранить резервные копии в хранилище сервера, если не удается загрузить их в удаленное хранилище',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailedDescription' => 'Запланированные и созданные вручную резервные копии, которые должны быть сохранены в удаленном хранилище, будут сохранены в локальном хранилище сервера, если не удастся загрузить их в удаленное хранилище. Пользователям нужно обладать правами для сохранения резервных копий в хранилище сервера.',

    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupLabel' => 'Клиенты администратора',
    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupDescription' => 'Все учетные записи клиентов, принадлежавшие администратору в предыдущей версии Plesk, были преобразованы в учетные записи клиентов, принадлежащие администратору: (1) Ресурсы каждого клиента были сохранены (доступны в разделе \'Мои ресурсы\' вверху списка подписок клиента), они будут удалены после завершения переноса; (2) Все их домены были преобразованы в подписки (одна новая подписка из каждого домена); (3) Администраторы доменов были преобразованы в пользователей клиента и имеют доступ только к подписке, содержащией их домен.',
    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupSettingsLabel' => 'Предыдущее состояние клиента',
    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupNumberLabel' => 'Количество клиентов',
    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupMethodLabel' => 'Схема переноса',
    'business-model-upgrade.bunch.t1s1-settingsDescription' => 'Один домен; изменение ограничений запрещено.',
    'business-model-upgrade.bunch.t1s1-solutionDescription' => 'Набор ресурсов в новой подписке эквивалентен прошлому минимальному набору ресурсов клиента или домена.',
    'business-model-upgrade.bunch.t1s1-apply' => 'Перенести этих клиентов',
    'business-model-upgrade.bunch.t1s2-settingsDescription' => 'Один домен; изменение ограничений разрешено.',
    'business-model-upgrade.bunch.t1s2-solutionDescription' => 'Набор ресурсов в новой подписке равен ограничениям прежнего клиента.',
    'business-model-upgrade.bunch.t1s2-apply' => 'Перенести этих клиентов',
    'business-model-upgrade.bunch.t1s3-settingsDescription' => 'Несколько доменов; создание доменов и изменение ограничений запрещены.',
    'business-model-upgrade.bunch.t1s3-solutionDescription' => 'Ресурсы новой подписки соответствуют ограничениям бывшего домена.',
    'business-model-upgrade.bunch.t1s3-apply' => 'Перенести этих клиентов',
    'business-model-upgrade.bunch.t1s6-settingsDescription' => 'Несколько доменов; создание доменов и изменение ограничений разрешено.',
    'business-model-upgrade.bunch.t1s6-solutionDescription' => 'Перенести как:',
    'business-model-upgrade.bunch.t1s6r-solutionDescription' => 'Реселлер. Бывший клиент преобразуется в реселлера. Ресурсы подписки реселлера соответствуют ограничениям бывшего клиента. Если для домена была включена учетная запись администратора, она будет преобразована в учетную запись клиента, и ей будет присвоена соответствующая подписка. В противном случае подписки будут присвоены напрямую реселлеру.',
    'business-model-upgrade.bunch.t1s6c-solutionDescription' => 'Клиент. Клиент остается в этой же роли. Ресурсы клиента распределяются между его подписками.',
    'business-model-upgrade.bunch.t1s6r-solutionName' => 'Реселлеры',
    'business-model-upgrade.bunch.t1s6c-solutionName' => 'Клиенты',
    'business-model-upgrade.bunch.t1s6-apply' => 'Перенести этих клиентов как',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupLabel' => 'Клиенты реселлеров',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupDescription' => 'Все учетные записи клиентов, принадлежавшие реселлеру в Plesk 9, были преобразованы в учетные записи клиентов, принадлежащие соответствующим реселлерам: (1) Ресурсы каждого клиента были сохранены (доступны в разделе \'Мои ресурсы\' вверху списка подписок клиента), они будут удалены после завершения переноса; (2) Все их домены были преобразованы в подписки (одна новая подписка из каждого домена); (3) Администраторы доменов были преобразованы в пользователей клиента и имеют доступ только к подписке, содержащией их домен.',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupSettingsLabel' => 'Предыдущее состояние клиента',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupNumberLabel' => 'Количество клиентов',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupMethodLabel' => 'Схема переноса',
    'business-model-upgrade.bunch.t2s1-settingsDescription' => 'Один домен; изменение ограничений запрещено.',
    'business-model-upgrade.bunch.t2s1-solutionDescription' => 'Набор ресурсов в новой подписке эквивалентен прошлому минимальному набору ресурсов клиента или домена.',
    'business-model-upgrade.bunch.t2s1-apply' => 'Перенести этих клиентов',
    'business-model-upgrade.bunch.t2s2-settingsDescription' => 'Один домен; изменение ограничений разрешено.',
    'business-model-upgrade.bunch.t2s2-solutionDescription' => 'Набор ресурсов в новой подписке равен ограничениям прежнего клиента.',
    'business-model-upgrade.bunch.t2s2-apply' => 'Перенести этих клиентов',
    'business-model-upgrade.bunch.t2s3-settingsDescription' => 'Несколько доменов; создание доменов и изменение ограничений запрещены.',
    'business-model-upgrade.bunch.t2s3-solutionDescription' => 'Ресурсы новой подписки соответствуют ограничениям бывшего домена.',
    'business-model-upgrade.bunch.t2s3-apply' => 'Перенести этих клиентов',
    'business-model-upgrade.bunch.t2s6-settingsDescription' => 'Несколько доменов; создание доменов и изменение ограничений разрешено.',
    'business-model-upgrade.bunch.t2s6-solutionDescription' => 'Ресурсы клиентов уже распределены между их подписками.',
    'business-model-upgrade.bunch.t2s6-apply' => 'Перенести этих клиентов',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupLabel' => 'Подписки администратора',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupDescription' => 'Все домены, принадлежавшие администратору в предыдущей версии Plesk, были преобразованы в его подписки. Администраторы доменов были преобразованы в пользователей Панели клиента и имеют доступ только к подписке, содержащей их домен. Используйте рекомендованную процедуру переноса этих подписок или выберите индивидуальную схему переноса для каждой из них на вкладке \'Выборочный перенос подписок\'.',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupSettingsLabel' => 'Предыдущее состояние домена',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupNumberLabel' => 'Количество подписок',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupMethodLabel' => 'Схема переноса',
    'business-model-upgrade.bunch.subscriptionAdministrator-settingsDescription' => 'Домен принадлежал администратору; Учетная запись администратора домена была включена.',
    'business-model-upgrade.bunch.subscriptionAdministrator-solutionDescription' => 'Бывший администратор домена преобразуется в клиента и становится подписчиком, т.е. за ним закрепляется подписка.',
    'business-model-upgrade.bunch.subscriptionAdministrator-apply' => 'Перенести эти подписки',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupLabel' => 'Подписки реселлеров',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupDescription' => 'Все домены, принадлежавшие реселлерам в предыдущей версии Plesk, были преобразованы в подписки реселлеров с сохраненим владельцев. Администраторы доменов были преобразованы в пользователей Панели клиента и имеют доступ только к подписке, содержащей их домен. Используйте рекомендованную процедуру переноса этих подписок или выберите индивидуальную схему переноса для каждой из них на вкладке \'Выборочный перенос подписок\'.',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupSettingsLabel' => 'Предыдущее состояние домена',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupNumberLabel' => 'Количество подписок',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupMethodLabel' => 'Схема переноса',
    'business-model-upgrade.bunch.subscriptionReseller-settingsDescription' => 'Домен принадлежал реселлеру; учетная запись администратора домена была включена.',
    'business-model-upgrade.bunch.subscriptionReseller-solutionDescription' => 'Бывший администратор домена преобразуется в клиента и становится подписчиком, т.е. за ним закрепляется подписка.',
    'business-model-upgrade.bunch.subscriptionReseller-apply' => 'Перенести эти подписки',
    'business-model-upgrade.bunch.thereWereSomeErrors' => 'Некоторые из выбранных клиентов и подписок не были перенесены.',

    'change-current-subscription.hint' => 'Здесь вы можете изменить тарифный план подписки. Учтите, что выбор пункта \'нет\' в качестве нового плана удаляет связь между подпиской и тарифным планом и делает ее  \'Персональной\'.',
    'change-current-subscription.subscriptionNotSynchronized' => 'Не удалось синхронизировать подписку с тарифным планом. Следующие настройки подписки конфликтуют с тарифным планом: %%problems%%.',

    'change-password.oldPassword' => 'Старый пароль',
    'change-password.password' => 'Новый пароль',
    'change-password.passwordConfirmation' => 'Подтверждение пароля',
    'change-password.oldPasswordIsIncorrect' => 'Неверный старый пароль. Пожалуйста, попробуйте еще раз.',
    'change-password.unableToFindAdditionalAdminAccount' => 'Не удается найти дополнительную учетную запись администратора.',
    'change-password.warningAboutAdminPasswordSyntax' => "Пароль должен быть длиной от %%min%% до %%max%% символов и не должен содержать имени пользователя.\nПароль не должен содержать кавычки, пробелы и национальные символы.",
    'change-password.warningAboutWinAdminPasswordSyntax' => "Пароль не должен содержать кавычки, пробелы, двоеточия и национальные символы. Пароль должен быть длиной от %%min%% до %%max%% символов и не должен содержать имени пользователя.",

    'change-reseller-oversell-policy.oversellPolicy' => 'Продажа сверх запасов',
    'change-reseller-oversell-policy.oversellPolicyAllowed' => 'Продажа сверх запасов разрешена',
    'change-reseller-oversell-policy.oversellPolicyAllowedHint' => 'Продажа сверх запасов позволяет реселлеру продавать больше ресурсов, чем доступно в его плане. Если продажа сверх запасов разрешена, то реселлер руководствуется фактическим использованием ресурсов вместо изначально выделенного объема ресурсов.',
    'change-reseller-oversell-policy.oversellPolicyNotAllowed' => 'Продажа сверх запасов запрещена',
    'change-reseller-oversell-policy.oversellPolicyNotAllowedHint' => 'Если продажа сверх запасов не разрешена, реселлер может продавать только столько ресурсов, сколько изначально было доступно в его плане, независимо от того, сколько ресурсов используется фактически.',

    'change-reseller-subscription.hint' => 'Здесь вы можете изменить тарифный план для выбранного реселлера. Учтите, что выбор пункта \'нет\' в качестве нового плана удаляет связь между подпиской и тарифными планами и делает ее  \'Персональной\'.',
    'change-reseller-subscription.subscriptionNotSynchronized' => 'Не удалось синхронизировать подписку с тарифным планом. Следующие настройки подписки конфликтуют с тарифным планом: %%problems%%.',
    'change-reseller-subscription.servicePlan' => 'Новый план',
    'change-reseller-subscription.oldSubscription' => 'Текущий план',
    'change-reseller-subscription.none' => 'нет',
    'change-reseller-subscription.infoSubscriptionChanged' => 'Связь подписки с тарифным планом обновлена.',
    'change-reseller-subscription.customizeSubscription' => 'После изменения привязки к тарифному плану плану перейти к настройке параметров подписки. Учтите, что это приведет к блокировке синхронизации подписки.',

    'change-subscription.hint' => 'Здесь вы можете изменить тарифный план для выбранных подписок.',
    'change-subscription.selectPlanLegend' => 'Тарифный план',
    'change-subscription.selectPlanDescription' => 'Чтобы переключиться на другой тарифный план, выберите новый план из списка. Учтите, что выбор пункта \'нет\' в качестве нового плана удаляет связь между подпиской и тарифными планами и делает ее \'Персональной\'.',
    'change-subscription.servicePlan' => 'Новый тарифный план',
    'change-subscription.selectAddonPlansLegend' => 'Дополнительные планы',
    'change-subscription.selectAddonPlansDescription' => 'Добавить или удалить дополнительные планы.',
    'change-subscription.noChange' => 'без изменения',
    'change-subscription.none' => 'нет',
    'change-subscription.add' => 'добавить',
    'change-subscription.del' => 'Удалить',
    'change-subscription.separator' => '-------',

    'control-panel-access.network.subnetOrIpAddressLabel' => 'Подсеть или IP-адрес',
    'control-panel-access.network.subnetOrIpAddressHint' => 'Например, 2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'control-panel-access.settings.accessPolicyLabel' => 'Доступ к Plesk с правами администратора',
    'control-panel-access.settings.policyAllow' => 'Разрешить доступ из всех сетей, кроме указанных ниже.',
    'control-panel-access.settings.policyDeny' => 'Запретить доступ из всех сетей, кроме указанных ниже.',

    'create-subscription.title' => 'Добавление подписки',
    'create-subscription.titleOwn' => 'Добавление вашей личной подписки',
    'create-subscription.poolIsEmpty' => 'Не удалось создать подписку, так как в Plesk нет общих IP-адресов, и нет свободных выделенных IP-адресов.',
    'create-subscription.infoNewSubscriptionCreated' => 'Подписка %%name%% создана.',
    'create-subscription.createBeforeAppInstall' => 'Для установки приложения у вас должна быть подписка.',

    'customer.hint' => 'Здесь вы можете подписать нового клиента на свои услуги хостинга. Это означает, что в Plesk будет создана учетная запись и подписка на один из ваших хостинг-планов (и, возможно, дополнительных планов). Подписка также может предоставлять полностью индивидуальный набор ресурсов и услуг без привязки к планам ‒ в этом случае выберите \'нет\' в поле "Тарифный план".',
    'customer.contactInfoSection' => 'Контактная информация',
    'customer.accessToPanelSection' => 'Доступ к Plesk',
    'customer.contactInfoSectionHint' => 'Введите контактные данные клиента.',
    'customer.accessToPanelSectionHint' => 'Учетные данные, которые клиент будет использовать для входа в Панель клиента.',
    'customer.unableCreateSubscription' => 'Подписка не может быть создана: %%reason%%',
    'customer.poolIsEmpty' => 'IP-пул пуст',

    'database-settings.dbPrefixRadio' => 'Добавлять префикс и подчерк в начало имен баз данных',
    'database-settings.dbPrefixNone' => 'Нет',
    'database-settings.dbPrefixUsername' => 'Имя пользователя',
    'database-settings.dbPrefixExternalId' => 'Внешний ID подписки',
    'database-settings.dbUserPrefix' => 'Добавлять имя пользователя и подчерк в начало имен пользователей базы данных',
    'database-settings.dbUserPrefixHint' => 'Имена пользователей баз данных будут иметь вид <имя_пользователя_plesk>_<имя_пользователя_базы_данных>. В связи с ограничением базы данных на длину имен пользователей <имя_пользователя_plesk> может быть сокращено.',
    'database-settings.grantAlterDatabase' => 'Предоставлять право ALTER DATABASE всем пользователям баз данных Microsoft SQL Server',
    'database-settings.grantAlterDatabaseHint' => 'Эта опция распространяется на новых и существующих пользователей.',
    'database-settings.enableBackupOperator' => 'Включить членство в роли db_backupoperator для всех пользователей баз данных Microsoft SQL Server',
    'database-settings.enableBackupOperatorHint' => 'Все новые и существующие пользователи будут членами этой роли.',
    'database-settings.aclRadio' => 'Стандартные настройки удаленного доступа для пользователей баз данных',
    'database-settings.aclLocalhost' => 'Разрешить только локальные подключения',
    'database-settings.aclAny' => 'Разрешить удаленные подключения с любого компьютера',
    'database-settings.aclCustom' => 'Разрешить удаленные подключения с указанных компьютеров',
    'database-settings.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nУказанным здесь компьютерам разрешено подключаться к базе данных от лица этого пользователя.",
    'database-settings.aclDescription' => 'Эта настройка позволяет изменять только права пользователей. Чтобы включить удаленный доступ к локальному серверу MySQL, выберите соответствующую опцию в разделе <a href="/server/db_server_edit.php?db_server_id=%d">Настройки локального сервера MySQL</a>.',
    'database-settings.example' => "Пример:\n%%example%%",

    'dns.template.synchronize-done' => 'Шаблон DNS-зоны успешно применен.',
    'dns.template.synchronize-error' => 'Шаблон DNS-зоны не был применен к некоторым DNS-зонам.',
    'dns.template.synchronize-progress' => 'Выполняется применение шаблона DNS-зоны.',

    'domain-restriction.name' => 'Имя домена',
    'domain-restriction.nameDescription' => 'Можно использовать подстановочный символ *. Например, *.example.com',
    'domain-restriction.domainAlreadyExists' => 'Указанное имя домена уже есть в списке.',

    'event-handler.eventLabel' => 'Событие',
    'event-handler.priorityLabel' => 'Приоритет',
    'event-handler.userLabel' => 'Пользователь',
    'event-handler.commandLabel' => 'Команда',
    'event-handler.commandHint' => 'Рекомендуется ввести полный путь к файлу скрипта в поле \'Команда\'. Мы не рекомендуем вводить системные команды, так как не все из них поддерживаются. Например, команды с операторами перенаправления вывода > или < работать не будут.',
    'event-handler.priorityHighestText' => 'высший',
    'event-handler.priorityHighText' => 'высокий',
    'event-handler.priorityNormalText' => 'нормальный',
    'event-handler.priorityLowText' => 'низкий',
    'event-handler.priorityLowestText' => 'низший',
    'event-handler.priorityCustomText' => 'другой',
    'event-handler.priorityHighestOption' => 'высший (%%value%%)',
    'event-handler.priorityHighOption' => 'высокий (%%value%%)',
    'event-handler.priorityNormalOption' => 'нормальный (%%value%%)',
    'event-handler.priorityLowOption' => 'низкий (%%value%%)',
    'event-handler.priorityLowestOption' => 'низший (%%value%%)',

    'extension.upload.fileUpload' => 'Путь к файлу пакета расширения',

    'external-webmail.hint' => 'После регистрации дополнительной веб-почты в Plesk она станет доступна вашим клиентам: она появится в качестве варианта для выбора на вкладке \'Почта\' в свойствах планов хостинга и подписок. Имя веб-почты будет отображаться в списке опций веб-почты, а при нажатии на значок веб-почты рядом с почтовым ящиком в Панели клиента будет открываться соответствующий URL-адрес.',
    'external-webmail.name' => 'Имя почтовой веб-службы',
    'external-webmail.url' => 'URL почтовой веб-службы',
    'external-webmail.enabled' => 'Доступна',

    'ftp-settings.generalSection' => 'Общие',
    'ftp-settings.portRange' => 'Порт или диапазон портов для соединений в режиме пассивного FTP',
    'ftp-settings.hintPortRange' => '(значение по умолчанию: %%defaultPortRange%%)',

    'health.upload.hint' => 'Загрузите вашу конфигурацию проверки состояния сервера. Конфигурация будет применена сразу после загрузки.',
    'health.upload.selectFile' => 'Конфигурационный файл',

    'install-local-package.selectUploadType' => 'Выберите один из вариантов:',
    'install-local-package.uploadAsFile' => 'Загрузить APS-пакет',
    'install-local-package.downloadFromCatalog' => 'Выбрать приложение из каталога',
    'install-local-package.formInfo' => "Загрузите файл с новым приложением или выберите подходящее приложение из каталога.",
    'install-local-package.invalidFileExtension' => 'Загружаемое приложение должно быть ZIP-архивом и иметь расширение .zip.',
    'install-local-package.packagesNotSelected' => 'Не выбрано ни одного пакета.',
    'install-local-package.visible' => 'Разрешить доступ для клиентов',
    'install-local-package.isCommercial' => 'Это платное приложение, для которого необходимо купить лицензию.',
    'install-local-package.visibleDescription' => 'Разрешить клиентам устанавливать это приложение.',

    'ip-address.generalSection' => 'Общие',
    'ip-address.interface' => 'Интерфейс',
    'ip-address.addressAndSubnetPrefixLength' => 'IP-адрес и маска подсети',
    'ip-address.publicIp' => 'Внешний IP-адрес',
    'ip-address.hintPublicIp' => 'Можно использовать внешний IP-адрес, если ваш сервер Plesk работает под управлением NAT',
    'ip-address.distributionType' => 'Тип IP-адреса',
    'ip-address.distributionTypeShared' => 'Общий',
    'ip-address.distributionTypeExclusive' => 'Выделенный',
    'ip-address.certificate' => 'SSL/TLS-сертификат',
    'ip-address.defaultSite' => 'Сайт по умолчанию',
    'ip-address.ftpOverSslNotSupportedByServer' => 'Установленный FTP-сервер не поддерживает FTPS.',
    'ip-address.ftpOverSslIpv6NotSupportedByServer' => 'Установленный FTP-сервер не поддерживает IPv6-адреса.',
    'ip-address.interfaceDHCPEnabled' => 'Невозможно добавить IP-адрес. Этот сетевой интерфейс получает IP-адреса автоматически.',
    'ip-address.accessDomainOnAnyDomainWinWarning' => 'Примечание: Настраиваемый URL-адрес Plesk включен для всех неизвестных доменов. Вместо сайта по умолчанию по адресу "https://%%ip%%/" будет отображаться интерфейс Plesk',

    'ip-ban.filter.name' => 'Имя',
    'ip-ban.filter.content' => 'Содержимое',
    'ip-ban.filter.filterExistsError' => 'Фильтр с таким именем уже существует.',

    'ip-ban.jail.name' => 'Имя',
    'ip-ban.jail.filter' => 'Фильтр',
    'ip-ban.jail.filterDescription' => 'Выберите фильтр.',
    'ip-ban.jail.action' => 'Действие',
    'ip-ban.jail.actionDescription' => 'Выберите действие и нажмите Добавить.',
    'ip-ban.jail.logPath' => 'Путь к журналу',
    'ip-ban.jail.banTime' => 'Период блокировки IP-адреса',
    'ip-ban.jail.maxRetry' => 'Максимальное количество неудачных попыток входа',
    'ip-ban.jail.timeUnit' => 'секунд',
    'ip-ban.jail.addAction' => 'Добавить',
    'ip-ban.jail.chooseAction' => 'Выберите:',
    'ip-ban.jail.apache-auth-filter-description' => 'Ошибки авторизации Apache (при записи журналов в файл)',
    'ip-ban.jail.apache-auth[logging=all]-filter-description' => 'Ошибки авторизации Apache (при любой записи журналов)',
    'ip-ban.jail.apache-auth[logging=syslog]-filter-description' => 'Ошибки авторизации Apache (при записи журналов в syslog)',
    'ip-ban.jail.apache-badbots-filter-description' => 'спам-боты и нежелательные поисковые роботы',
    'ip-ban.jail.plesk-courierlogin-filter-description' => 'Ошибки IMAP- и POP3-аутентификации Courier',
    'ip-ban.jail.plesk-dovecot-filter-description' => 'Ошибки IMAP-, POP3- и Sieve-аутентификации Dovecot',
    'ip-ban.jail.plesk-dovecot[mode=aggressive]-filter-description' => 'Ошибки IMAP-, POP3- и Sieve-аутентификации Dovecot (режим aggressive)',
    'ip-ban.jail.plesk-horde-filter-description' => 'ошибки аутентификации Horde',
    'ip-ban.jail.plesk-modsecurity-filter-description' => 'Нарушения безопасности и контроля доступа брандмауэра для веб-приложений (ModSecurity)',
    'ip-ban.jail.plesk-panel-filter-description' => 'ошибки аутентификации Plesk',
    'ip-ban.jail.plesk-qmail-filter-description' => 'ошибки SMTP-аутентификации QMail',
    'ip-ban.jail.plesk-roundcube-filter-description' => 'ошибки аутентификации Roundcube',
    'ip-ban.jail.plesk-wordpress-filter-description' => 'Ошибки аутентификации WordPress',
    'ip-ban.jail.postfix-filter-description' => 'Ошибки SMTP-клиента Postfix (включая RBL)',
    'ip-ban.jail.postfix[mode=aggressive]-filter-description' => 'Ошибки SMTP-клиента Postfix, ошибки аутентификации и DDoS-атаки',
    'ip-ban.jail.postfix[mode=auth]-filter-description' => 'Ошибки SMTP- и SASL-аутентификации Postfix',
    'ip-ban.jail.postfix[mode=ddos]-filter-description' => 'DDoS-атаки SMTP-клиента Postfix',
    'ip-ban.jail.postfix[mode=extra]-filter-description' => 'Ошибки SMTP-клиента Postfix и ошибки аутентификации',
    'ip-ban.jail.postfix[mode=normal]-filter-description' => 'Ошибки SMTP-клиента Postfix (включая RBL)',
    'ip-ban.jail.postfix[mode=rbl]-filter-description' => 'Ошибки SMTP-клиента Postfix (только RBL)',
    'ip-ban.jail.proftpd-filter-description' => 'ошибки входа по ProFTPD',
    'ip-ban.jail.recidive-filter-description' => 'повторно заблокированные адреса',
    'ip-ban.jail.sshd-filter-description' => 'ошибки входа по SSH',
    'ip-ban.jail.sshd[mode=aggressive]-filter-description' => 'Ошибки входа по SSH, ошибки согласования и DDoS-атаки',
    'ip-ban.jail.sshd[mode=ddos]-filter-description' => 'Ошибки входа по SSH и DDoS-атаки',
    'ip-ban.jail.sshd[mode=extra]-filter-description' => 'Ошибки входа по SSH и согласования',
    'ip-ban.jail.firewallcmd-allports-action-description' => 'Блокировка через брандмауэр firewalld на всех портах',
    'ip-ban.jail.firewallcmd-multiport-action-description' => 'Блокировка через брандмауэр firewalld на нескольких портах',
    'ip-ban.jail.firewallcmd-new-action-description' => 'Блокировка через брандмауэр firewalld на одном порту',
    'ip-ban.jail.iptables-action-description' => 'блокировать через iptables, на одном порту',
    'ip-ban.jail.iptables-allports-action-description' => 'блокировать через iptables, на всех портах',
    'ip-ban.jail.iptables-multiport-action-description' => 'блокировать через iptables, на нескольких портах',
    'ip-ban.jail.sendmail-action-description' => 'отправлять уведомление через sendmail',
    'ip-ban.jail.jailExistsError' => 'Джейл с таким именем уже существует.',
    'ip-ban.jail.invalidInteger' => 'Недопустимое значение. Укажите целое положительное число.',

    'ip-ban.settings.pageHint' => 'Здесь вы можете настроить блокировку IP-адресов, чтобы защитить свой сервер и размещаемые вами сайты от вредоносного трафика.',
    'ip-ban.settings.detectionEnabled' => 'Включить обнаружение атак',
    'ip-ban.settings.banPeriod' => 'Период блокировки IP-адреса',
    'ip-ban.settings.banTimeWindow' => 'Интервал обнаружения последующих атак',
    'ip-ban.settings.maxRetries' => 'Допустимое количество неудачных попыток входа перед блокировкой IP-адреса',
    'ip-ban.settings.timeUnit' => 'секунд',
    'ip-ban.settings.invalidInteger' => 'Недопустимое значение. Введите положительное целое число.',

    'ip-ban.trusted-ip.ipAddress' => 'IP-адрес',
    'ip-ban.trusted-ip.hintIpAddress' => 'Введите IP-адрес, маску CIDR или имя узла DNS.',
    'ip-ban.trusted-ip.specialCharactersInIpAddress' => 'Недопустимый IP-адрес, сетевой адрес или имя узла.',

    'login-info.hint' => 'Здесь вы можете изменить имя пользователя и пароль клиента для входа в Панель клиента.',
    'login-info.resellerHint' => 'Здесь вы можете изменить имя пользователя и/или пароль, которые данный реселлер использует для входа в Plesk.',
    'login-info.myProfileHint' => 'Здесь вы можете изменить свой пароль для входа в Plesk.',

    'mail.lists-server-settings.email' => "Адрес электронной почты администратора рассылки",
    'mail.lists-server-settings.emptyEmail' => 'Пожалуйста, укажите адрес электронной почты.',
    'mail.lists-server-settings.newPassword' => 'Новый пароль',
    'mail.lists-server-settings.emptyPassword' => 'Пожалуйста, укажите пароль.',
    'mail.lists-server-settings.passwordConfirmation' => 'Подтверждение пароля',
    'mail.lists-server-settings.mailingListSoftwareWasConfigured' => 'Программа почтовых рассылок настроена.',

    'mail.outgoing-messages.hint' => 'Здесь вы можете настроить ограничение исходящих сообщений для почтового ящика.',
    'mail.outgoing-messages.mailBoxOutgoingMessages' => 'Максимальное количество исходящих сообщений',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainDefault' => 'По умолчанию (%%domainOutgoingMessages%% сообщений в час)',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecific' => 'Отдельное значение',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecificHint' => 'сообщений в час',

    'mail-gate-settings.host' => 'Имя или IP-адрес компьютера',
    'mail-gate-settings.port' => 'Порт',
    'mail-gate-settings.login' => 'Имя пользователя',
    'mail-gate-settings.password' => 'Пароль',
    'mail-gate-settings.encryption' => 'Сервер SMTP требует зашифрованное соединение',
    'mail-gate-settings.allowUsers' => 'Разрешить скриптам пользователей отправлять почту через этот сервер SMTP (используя указанное имя пользователя и пароль)',
    'mail-gate-settings.useDefaultSettings' => 'Использовать почтовый сервер, установленный в Plesk, и почтового пользователя по умолчанию, созданного Plesk',

    'mail-gate.hint' => 'Здесь вы можете указать сервер SMTP, который следует использовать, если почтовый сервер Plesk не установлен или ему запрещено отправлять почту. Этот сервер будет выступать как SMTP-релей для отправки сообщений от Plesk и пользовательских скриптов.',
    'mail-gate.enableMailGate' => 'Разрешить Plesk отправлять уведомления через этот сервер SMTP',
    'mail-gate.notifications' => 'Отправка уведомлений через внешний сервер SMTP',
    'mail-gate.smtpSettings' => 'Настройки внешнего сервера SMTP',

    'optimization-settings.apacheModulesSection' => 'Модули Apache',
    'optimization-settings.apacheSettingsSection' => 'Общие настройки',
    'optimization-settings.additionalPageHint' => 'Включение/выключение модулей следует выполнять, только если вы полностью осознаете связанные с этим последствия. Учтите, что некоторые изменения могут снизить производительность Apache или даже привести к его неработоспособности.',
    'optimization-settings.pageHint' => 'На этой странице вы можете оптимизировать работу Plesk, отключив неиспользуемые модули Apache. Это поможет улучшить использование памяти и увеличить количество обслуживаемых клиентов. Пожалуйста, помните, что некоторые модули взаимосвязаны и могут быть отключены/включены только одновременно друг с другом.',
    'optimization-settings.advancedUsersOnlyWarning' => 'Эта функция предназначена только для опытных пользователей.',
    'optimization-settings.apacheRestartInterval' => 'Интервал перезапуска Apache (в секундах)',
    'optimization-settings.apacheRestartIntervalHint' => 'Это интервал, с которым Plesk будет проверять наличие изменений в настройках доменов и субдоменов. В случае обнаружения изменений, требующих перезапуска веб-сервера, будет происходить перезапуск Apache.',
    'optimization-settings.gracefulRestart' => 'Мягкий перезапуск Apache',
    'optimization-settings.gracefulRestartHint' => 'Выберите эту опцию, если хотите избежать простоя всех сайтов на сервере при каждом изменении настроек хостинга.',
    'optimization-settings.pipedLog' => 'Перенаправление журналов',
    'optimization-settings.mpmMode' => 'Режим MPM',
    'optimization-settings.moduleDeprecated' => '(Не рекомендуется)',

    'personal-info.contactInfoSection' => 'Контакты',
    'personal-info.hint' => 'Здесь вы можете изменить контактную информацию пользователя.',
    'personal-info.hintMyProfile' => 'Здесь вы можете изменить свою контактную информацию.',

    'php-handler.ini.formHint' => 'Этот файл php.ini используется только этим обработчиком.',
    'php-handler.ini.formHintSharedIni' => 'Этот файл php.ini используется также следующими обработчиками PHP: %%handlers%%. Настройки действуют для всех сайтов, использующих эти обработчики.',
    'php-handler.ini.incorrectTextForIniFile' => "Указанные настройки не верны и их нельзя сохранить в файле php.ini. Ошибка: %%message%%.",

    'php-handler.modules.formHint' => 'Эти настройки библиотек PHP действуют только для этого обработчика.',
    'php-handler.modules.formHintSharedModules' => 'Эти настройки являются общими для следующих обработчиков PHP: %%handlers%%. Настройки действуют для всех сайтов, использующих эти обработчики.',

    'plan-item-custom.planItemName' => 'Название услуги',
    'plan-item-custom.buttonLabel' => 'Это имя также будет использоваться как название персональной кнопки.',
    'plan-item-custom.planItemDescription' => 'Описание услуги',
    'plan-item-custom.buttonTooltip' => 'Этоn текст также будет использоваться как всплывающая подсказка для персональной кнопки.',
    'plan-item-custom.url' => 'URL персональной кнопки',
    'plan-item-custom.backgroundImage' => 'Фоновое изображение для персональной кнопки',
    'plan-item-custom.emptyItemName' => 'Пожалуйста, укажите название услуги.',
    'plan-item-custom.emptyItemDescription' => 'Пожалуйста, укажите текст для всплывающей подсказки.',
    'plan-item-custom.emptyUrl' => 'Пожалуйста, укажите URL.',
    'plan-item-custom.longItemName' => 'Слишком длинное название услуги. Максимальная длина — %max% символов.',
    'plan-item-custom.longItemDescription' => 'Слишком длинный текст. Максимальная длина — %max% символов.',
    'plan-item-custom.longUrl' => 'Слишком длинный URL. Максимальная длина — %max% символов.',
    'plan-item-custom.useCustomButton' => 'Использовать персональную кнопку для услуги',
    'plan-item-custom.useCustomButtonHint' => 'Поместить персональную кнопку на домашнюю страницу пользователя и страницы сайтов.',
    'plan-item-custom.openCustomButtonInSameWindow' => 'Открывать ссылку в Plesk',
    'plan-item-custom.openCustomButtonInSameWindowDescription' => 'Укажите, где следует открывать ссылку: на странице Plesk или в новом окне браузера.',
    'plan-item-custom.openCustomButtonWithoutFrame' => 'Не использовать фреймы',
    'plan-item-custom.openCustomButtonWithoutFrameDescription' => 'Если персональная кнопка ведет на какое-либо расширение Plesk или приложение в Панели клиента, вы можете указать, как его следует показывать: во фрейме или как часть интерфейса Plesk.',
    'plan-item-custom.includeDomId' => 'Включить ID подписки',
    'plan-item-custom.includeDomIdDescription' => '&dom_id=<dom_id>',
    'plan-item-custom.includeDomName' => 'Включить основное имя домена',
    'plan-item-custom.includeDomNameDescription' => '&dom_name=<dom_name>',
    'plan-item-custom.includeFtpUser' => 'Включить имя пользователя FTP',
    'plan-item-custom.includeFtpUserDescription' => '&ftp_user=<ftp_user>',
    'plan-item-custom.includeFtpPass' => 'Включить пароль FTP',
    'plan-item-custom.includeFtpPassDescription' => '&ftp_pass=<ftp_pass>',
    'plan-item-custom.includeClId' => 'Включить ID клиента',
    'plan-item-custom.includeClIdDescription' => '&cl_id=<cl_id>',
    'plan-item-custom.includeCname' => "Включить название компании клиента",
    'plan-item-custom.includeCnameDescription' => '&cname=<cname>',
    'plan-item-custom.includePname' => "Включить контактное имя клиента",
    'plan-item-custom.includePnameDescription' => '&pname=<pname>',
    'plan-item-custom.includeEmail' => "Включить адрес электронной почты клиента",
    'plan-item-custom.includeEmailDescription' => '&email=<email>',

    'preview-domain-settings.previewType' => 'Выбрать способ просмотра сайтов',
    'preview-domain-settings.previewQuick' => 'Быстрый просмотр по умолчанию',
    'preview-domain-settings.previewDisabled' => 'Отключить быстрый просмотр',
    'preview-domain-settings.previewQuickDescription' => 'Рекомендуемая опция, которая работает без дополнительной настройки.',
    'preview-domain-settings.previewZoneTypeInternal' => 'Быстрый предпросмотр на домене из Plesk',
    'preview-domain-settings.previewZoneDomainIdDescription' => 'Выберите для предпросмотра один из своих сайтов, зарегистрированных в Plesk.',
    'preview-domain-settings.previewZoneDomainCreate' => 'Чтобы использовать эту функцию, %%link%% хотя бы один домен.',
    'preview-domain-settings.subscriptionCreateLink' => 'создайте',
    'preview-domain-settings.previewZoneTypeExternal' => 'Быстрый просмотр на внешнем домене',
    'preview-domain-settings.previewZoneDomainNameDescription' => 'Укажите внешнее имя домена (зону DNS). Если вы используете эту опцию, добавьте следующую A-запись DNS в зону внешнего домена: <Plesk_IP />*.<Plesk_IP>.external.dom. <Plesk_IP /><Plesk_IP> — это IP-адрес сервера Plesk, в котором вместо точек (.) для IPv4 и двоеточиий (:) для IPv6 подставляются дефисы (-). Например, *.192-0-2-12.external.dom. Если Plesk имеет несколько IP-адресов, нужно добавить отдельную запись для каждого из них.',
    'preview-domain-settings.sitePreviewProtection' => 'Требовать авторизацию',
    'preview-domain-settings.sitePreviewProtectionDescription' => 'Требовать логин и пароль пользователя FTP для доступа к предпросмотру.',
    'preview-domain-settings.nginxNotInstalled' => 'Быстрый просмотр по умолчанию недоступен, потому что не установлен веб-сервер nginx.',
    'preview-domain-settings.nginxDisabled' => 'Быстрый просмотр по умолчанию недоступен, потому что отключен веб-сервер nginx.',

    'reseller-preferences.settingsSection' => 'Настройки',
    'reseller-preferences.multiLogin' => 'Разрешить несколько сеансов',
    'reseller-preferences.language' => 'Язык интерфейса',
    'reseller-preferences.interfaceView' => 'Режим интерфейса',
    'reseller-preferences.serviceProviderView' => 'Service Provider',
    'reseller-preferences.serviceProviderViewHint' => 'Этот режим предназначен для тех реселлеров, у которых есть клиенты. В нем вы можете управлять как клиентами, так и собственными сайтами и услугами хостинга.',
    'reseller-preferences.powerUserView' => 'Power User',
    'reseller-preferences.powerUserViewHint' => 'Этот режим обеспечивает облегченный интерфейс для управления вашими собственными сайтами, почтовыми ящиками и другими услугами хостинга. Управление клиентами в нем недоступно.',

    'reseller.hint' => 'Здесь вы можете подписать нового реселлера на ваши услуги хостинга.',
    'reseller.contactInfoSection' => 'Контактная информация',
    'reseller.contactInfoSectionHint' => 'Введите контактные данные реселлера.',
    'reseller.accessToPanelSection' => 'Доступ к Plesk',
    'reseller.accessToPanelSectionHint' => 'Учетные данные, которые реселлер будет использовать для доступа в Plesk и управления своими услугами.',
    'reseller.subscription' => 'Подписка',
    'reseller.subscriptionSectionHint' => 'Выберите тарифный план для этого реселлера.',
    'reseller.servicePlan' => 'Тарифный план',
    'reseller.none' => 'нет',
    'reseller.customizeSubscription' => 'После создания реселлера перейти к настройке параметров подписки. Учтите, что это приведет к блокировке синхронизации подписки.',
    'reseller.subscriptionNotSynchronized' => 'Не удалось синхронизировать подписку с тарифным планом. Следующие настройки подписки конфликтуют с тарифным планом: %%problems%%.',

    'security-policy.encryptionSection' => 'Режим повышенной безопасности',
    'security-policy.encryptionSectionHint' => 'Режим повышенной безопасности обеспечивает усиленную защиту конфиденциальных данных в Plesk. В этом режиме Plesk использует ряд механизмов защиты, которые абсолютно прозрачны для пользователей. Мы рекомендуем вам включить этот режим для усиления безопасности Plesk.',
    'security-policy.encryptionEnable' => 'Режим повышенной безопасности',
    'security-policy.securePassword' => 'Режим повышенной безопасности',
    'security-policy.strengthSection' => 'Надежность паролей',
    'security-policy.strengthSectionHint' => 'Когда пользователь задает в системе новый пароль (создает новый или изменяет существующий), ему необходимо скорректировать пароль в соответствии с минимальными требованиями к уровню надежности, указанными на этой странице. Надежность пароля определяется его длиной и сложностью (наличием цифр, букв в разных регистрах и специальных символов). Мы рекомендуем вам выбирать уровень надежности не ниже среднего.',
    'security-policy.passwordStrength' => 'Минимальная надежность паролей',
    'security-policy.passwordStrengthVeryWeakHint' => 'Обычно это короткие пароли, состоящие из одного вида символов (буквы в нижнем или верхнем регистре или цифры). Пример: password. Пароли этого уровня устойчивы только к простейшим атакам методом угадывания.',
    'security-policy.passwordStrengthWeakHint' => 'Обычно это короткие пароли, которые большей частью состоят из одного вида символов (буквы в нижнем или верхнем регистре или цифры) и содержат всего несколько символов другого вида. Пример: password12. Такие пароли обеспечивают базовую защиту от угадывания паролей.',
    'security-policy.passwordStrengthMediocreHint' => 'Обычно это короткие пароли, которые содержат как минимум два вида символов (буквы в нижнем или верхнем регистре, цифры или специальные символы). Пример: Password12. Такие пароли обеспечивают надежную защиту от атак, нацеленных на кражу паролей.',
    'security-policy.passwordStrengthStrongHint' => 'Такие пароли содержат не менее восьми символов, среди которых есть хотя бы по одной букве в нижнем и верхнем регистре, цифра и специальный символ. Например: P@ssw0rd12. Такие пароли обеспечивают надежную защиту от атак методом перебора.',
    'security-policy.passwordStrengthStrongerHint' => 'Такие пароли содержат не менее 16 символов, включая по несколько букв в нижнем и верхнем регистре, цифры и специальные символы. Например: ~!my_P@$$w0rD123. Такие пароли довольно сложны для запоминания, однако обеспечивают максимально возможную защиту.',
    'security-policy.secureFtpSection' => 'Безопасность FTP-соединений',
    'security-policy.ftpOverSsl' => 'Политика использования FTPS',
    'security-policy.ftpOverSslHint' => 'FTPS позволяет защитить обмен данными между FTP-сервером и внешними FTP-клиентами с помощью протокола SSL/TLS. Здесь вы можете указать разрешенные виды соединений.',
    'security-policy.ftpOverSslWithCustomOptionHint' => 'FTPS позволяет защитить обмен данными между FTP-сервером и внешними FTP-клиентами с помощью протокола SSL/TLS. Здесь вы можете указать разрешенные виды соединений. Выбранный вариант будет применен ко всем IP-адресам на сервере. Чтобы установить индивидуальные настройки для отдельных IP-адресов, выберите соответствующий вариант, а затем внесите необходимые изменения в FTPS-политику на странице "Инструменты и настройки" > "IP-адреса".',
    'security-policy.ftpOverSslCustomHint' => 'FTPS позволяет защитить обмен данными между FTP-сервером и внешними FTP-клиентами с помощью протокола SSL/TLS.',
    'security-policy.ftpOverSslCustomDisabledHint' => 'FTPS позволяет защитить обмен данными между FTP-сервером и внешними FTP-клиентами с помощью протокола SSL/TLS. Если вы хотите настроить FTPS отдельно для каждого IP-адреса, сначала включите опцию "Использовать отдельную политику FTPS для каждого IP-адреса" в разделе "Инструменты и настройки" > "Политика безопасности" > "Безопасность FTP-соединений".',
    'security-policy.ftpOverSslOptionRequired' => 'Разрешить только безопасные соединения (FTPS)',
    'security-policy.ftpOverSslOptionEnabled' => 'Разрешить и безопасные соединения (FTPS), и небезопасные (FTP)',
    'security-policy.ftpOverSslOptionDisabled' => 'Разрешить только небезопасные соединения (FTP). Не использовать FTPS',
    'security-policy.ftpOverSslOptionCustom' => 'Использовать отдельную политику FTPS для каждого IP-адреса',
    'security-policy.prohibitWebConfigHandlersSection' => 'Политика пользовательских обработчиков',
    'security-policy.prohibitWebConfigHandlersSectionHint' => 'Используйте эту опцию, чтобы запретить клиентам переопределять определенные на уровне сервера обработчики IIS через файл web.config.',
    'security-policy.prohibitWebConfigHandlers' => 'Отключить возможность обходить обработчики через web.config',

    'service-instance.setup-instance.resourcesSection' => 'Ресурсы услуги',
    'service-instance.setup-instance.requiredServiceAlreadyInstalled' => 'Уже установлена',
    'service-instance.setup-instance.requirementsSection' => 'Необходимые услуги',
    'service-instance.setup-instance.requiredServiceNotSelected' => 'Не выбрана',

    'service-node.ipAddress' => 'IP-адрес узла обслуживания',
    'service-node.ipAddressLocal' => 'Локальный узел обслуживания',
    'service-node.description' => 'Описание узла обслуживания',
    'service-node.accessKey' => 'Пароль',
    'service-node.useAccessKey' => 'Использовать проверку подлинности',
    'service-node.useAccessKeyDescription' => 'Совет по использованию проверки подлинности.',
    'service-node.oldAccessKey' => 'Старый пароль',
    'service-node.newAccessKey' => 'Новый пароль',
    'service-node.noAccessKeySpecified' => 'Не указан пароль',

    'service-plan.admin-plan.subscription_section' => 'Общее',
    'service-plan.admin-plan.tools_section' => 'Инструменты и ресурсы',
    'service-plan.admin-plan.apps_section' => 'Приложения и базы данных',
    'service-plan.admin-plan.panel_section' => 'Plesk',
    'service-plan.admin-plan.appearance_section' => 'Интерфейс Plesk',
    'service-plan.admin-plan.statistics_section' => 'Статистика',
    'service-plan.admin-plan.general_section' => 'Общие',
    'service-plan.admin-plan.mail_section' => 'Почта',
    'service-plan.admin-plan.server_section' => 'Сервер',
    'service-plan.admin-plan.modules_section' => 'Расширения',
    'service-plan.admin-plan.simplePanel' => 'Ограниченный режим',
    'service-plan.admin-plan.enabled' => 'Включить Ограниченный режим',
    'service-plan.admin-plan.enabledDescription' => 'Выберите эту опцию, чтобы ограничить набор операций, доступных администратору в Plesk.',
    'service-plan.admin-plan.aliasEnabledDescription' => 'Выберите эту опцию, чтобы ограничить набор операций, доступных дополнительному администратору в Plesk.',

    'service-plan.applications-subscription.useFilterLabel' => 'Предоставлять только выбранные мной приложения',
    'service-plan.applications-subscription.useFilterDescription' => 'Используйте эту опцию, чтобы выбрать приложения, которые должны быть доступны подписчику.',
    'service-plan.applications-subscription.applications' => 'Приложения',
    'service-plan.applications-subscription.isCommercial' => 'Это платное приложение, для которого необходимо купить лицензию.',

    'service-plan.applications.useFilterLabel' => 'Предоставлять только выбранные мной приложения',
    'service-plan.applications.useFilterDescription' => 'Используйте эту опцию, чтобы выбрать приложения, которые должны быть доступны подписчикам.',
    'service-plan.applications.applications' => 'Приложения',
    'service-plan.applications.isCommercial' => 'Это платное приложение, для которого необходимо купить лицензию.',

    'service-plan.dns.dnsZoneType' => 'Зона DNS домена',
    'service-plan.dns.dnsZoneTypeMaster' => 'Мастер',
    'service-plan.dns.dnsZoneTypeSlave' => 'Вторичный',

    'service-plan.extras.groupOtherServices' => 'Другие службы',
    'service-plan.extras.none' => 'Нет',

    'service-plan.hosting.enablePhysicalHosting' => 'Включить хостинг',
    'service-plan.hosting.sectionCoreHosting' => 'Основные параметры',
    'service-plan.hosting.sectionScripting' => 'Скрипты',
    'service-plan.hosting.defaultDatabaseServer' => 'Сервер баз данных по умолчанию',
    'service-plan.hosting.versionCut' => 'версия %%version%%',
    'service-plan.hosting.sectionAdvanced' => 'Дополнительно',
    'service-plan.hosting.phpSettingsHelpLink' => 'Узнайте, как выбрать оптимальные настройки PHP',
    'service-plan.hosting.unpaidWebsiteStatusLabelSubscription' => 'Статус сайтов в случае приостановки этой подписки',
    'service-plan.hosting.unpaidWebsiteStatusLabel' => 'Статус сайтов в приостановленных подписках',
    'service-plan.hosting.unpaidWebsiteStatusDescription' => 'Выбранный статус будет применен ко всем сайтам в подписках данного плана в случае приостановки подписки (например, из-за истечения ее срока).',
    'service-plan.hosting.unpaidWebsiteStatusDescriptionSubscription' => 'Выбранный статус будет применен к сайтам в случае приостановки подписки (например, из-за истечения ее срока).',
    'service-plan.hosting.unpaidWebsiteStatusDisabled' => 'Отключен',
    'service-plan.hosting.unpaidWebsiteStatusDisabledHint' => 'Посетители сайта будут перенаправляться на страницу по умолчанию, определенную в настройках веб-сервера.',
    'service-plan.hosting.unpaidWebsiteStatusSuspended' => 'Приостановлен',
    'service-plan.hosting.unpaidWebsiteStatusSuspendedHint' => 'Посетители сайта будут перенаправляться на специально настроенную страницу ошибки с HTTP-кодом 503.',
    'service-plan.hosting.unpaidWebsiteStatusActive' => 'Активен',
    'service-plan.hosting.unpaidWebsiteStatusActiveHint' => 'Сайт будет по-прежнему доступен в Интернете.',

    'service-plan.ip.sharedIpAddresses' => 'Выделить общие IP-адреса',
    'service-plan.ip.allocateExclusiveIp' => 'Предоставить выделенные IP-адреса',
    'service-plan.ip.allocateExclusiveIpV4' => 'Предоставить выделенные IPv4-адреса',
    'service-plan.ip.allocateExclusiveIpV6' => 'Предоставить выделенные IPv6-адреса',

    'service-plan.mail.mailService' => 'Включить почтовую службу',
    'service-plan.mail.webMail' => 'Веб-почта',
    'service-plan.mail.mailingLists' => 'Включить списки рассылки',
    'service-plan.mail.mailToNonExistentUser' => 'Действия с почтой, отправленной на несуществующий почтовый ящик',
    'service-plan.mail.mailToNonExistentUserBounce' => 'Возвращать с уведомлением',
    'service-plan.mail.mailToNonExistentUserRedirect' => 'Перенаправлять на адрес',
    'service-plan.mail.mailToNonExistentUserReject' => 'Отклонять',
    'service-plan.mail.mailAutodiscovery' => 'Включить автообнаружение почты',
    'service-plan.mail.mailAutodiscoveryDescription' => 'О том, как это сделать, читайте в <a href="%%link%%" target="_blank">статье базы знаний</a>',
    'service-plan.mail.bounceMessage' => 'Этот адрес больше не принимает почту.',
    'service-plan.mail.mailToNonExistentUserexternalMailServer' => 'Перенаправлять на внешний почтовый сервер с IP-адресом',
    'service-plan.mail.webmailDisabled' => '%%webmail%% — отключен',

    'service-plan.misc.retainEnabled' => 'Хранить веб-статистику и статистику трафика в течение',
    'service-plan.misc.logRotation' => 'Ротация журналов',
    'service-plan.misc.logRotationCondition' => 'Условие ротации журналов',
    'service-plan.misc.logRotationBySize' => 'по объему',
    'service-plan.misc.logRotationByTime' => 'по времени',
    'service-plan.misc.logRotationDaily' => 'Ежедневно',
    'service-plan.misc.logRotationWeekly' => 'Еженедельно',
    'service-plan.misc.logRotationMonthly' => 'Ежемесячно',
    'service-plan.misc.logRotationSizeDescription' => 'Размер должен находиться в диапазоне от %%min%% до %%max%% Кб.',
    'service-plan.misc.maximumNumberOfFiles' => 'Максимальное количество журналов',
    'service-plan.misc.compress' => 'Архивировать журналы',
    'service-plan.misc.sendLogToEmail' => 'После того как Plesk получит данные из журналов веб- и FTP-серверов, отправлять журналы на этот адрес',
    'service-plan.misc.kb' => 'Кб',
    'service-plan.misc.months' => 'месяцев',
    'service-plan.misc.logRotationPeriodGreater' => 'Периодичность ротации журналов не может превышать серверное ограничение %%max%%.',

    'service-plan.performance.iisAppPoolAddonsHint' => 'Если выключено, все сайты подписки используют один и тот же пул приложений IIS, выделенный для обслуживания этой подписки.',

    'service-plan.permissions-subscription.permissionsTabDescription' => 'Выберите услуги и права, входящие в подписку.',
    'service-plan.permissions-subscription.showMorePermissions' => 'Показать дополнительные права',
    'service-plan.permissions-subscription.hideMorePermissions' => 'Скрыть дополнительные права',
    'service-plan.permissions-subscription.noShellManagement' => 'Запрещено',
    'service-plan.permissions-subscription.systemAccessLabel' => 'Управление доступом к серверу по SSH',
    'service-plan.permissions-subscription.systemAccessLabel_hint' => 'Позволяет клиентам включать SSH для своих системных пользователей. При этом параметр хостинга "SSH-доступ к серверу под системным пользователем подписки" используется в качестве шаблона.',

    'service-plan.permissions.permissionsTabDescription' => 'Выберите услуги и права, предоставляемые планом.',
    'service-plan.permissions.permissionsAddonTabDescription' => 'Выберите услуги и права, которые будут добавлены в подписки с этим дополнительным планом. Права, которые не выбраны в дополнении, никоим образом не будут менять параметры подписки.',
    'service-plan.permissions.permissionsBehaviorDescription' => 'Права позволяют клиентам изменять отдельные настройки подписок. Когда создается новая подписка, Plesk применяет к настройкам заранее установленные планом значения, а клиент после этого может их изменять. Дальнейшее обновление плана или добавление дополнительного плана не перезаписывает изменения, внесенные клиентом.',
    'service-plan.permissions.showMorePermissions' => 'Показать дополнительные права',
    'service-plan.permissions.hideMorePermissions' => 'Скрыть дополнительные права',
    'service-plan.permissions.noShellManagement' => 'Запрещено',
    'service-plan.permissions.systemAccessLabel' => 'Управление доступом к серверу по SSH',
    'service-plan.permissions.systemAccessLabel_hint' => 'Выберите эту опцию, чтобы параметр хостинга "SSH-доступ к серверу под системным пользователем подписки" использовался в качестве шаблона.',

    'service-plan.resources-subscription.overusePolicy' => 'Перерасход',
    'service-plan.resources-subscription.overusePolicyNotAllowed' => 'Перерасход запрещен',
    'service-plan.resources-subscription.overusePolicyNotAllowedHint' => 'Запретить перерасход ресурсов. В случае превышения ограничений действие подписки автоматически приостанавливается.',
    'service-plan.resources-subscription.overusePolicySoftAllowed' => 'Перерасход дискового пространства и трафика разрешен',
    'service-plan.resources-subscription.overusePolicySoftAllowedHint' => 'Разрешить перерасход дискового пространства и трафика. Запретить перерасход других ресурсов.',
    'service-plan.resources-subscription.overusePolicyAllowed' => 'Перерасход разрешен (не рекомендуется)',
    'service-plan.resources-subscription.overusePolicyAllowedHint' => 'Разрешить подписчику использовать больше ресурсов, чем было изначально включено в подписку.',
    'service-plan.resources-subscription.overuseNotify' => 'Отправлять уведомления о перерасходе',
    'service-plan.resources-subscription.oversellPolicy' => 'Продажа сверх запасов',
    'service-plan.resources-subscription.oversellPolicyAllowed' => 'Продажа сверх запасов разрешена',
    'service-plan.resources-subscription.oversellPolicyAllowedHint' => 'Продажа сверх запасов позволяет реселлеру продавать больше ресурсов, чем доступно в его подписке. Если продажа сверх запасов разрешена, то реселлер руководствуется фактическим использованием ресурсов вместо изначально выделенного объема ресурсов.',
    'service-plan.resources-subscription.oversellPolicyNotAllowed' => 'Продажа сверх запасов запрещена',
    'service-plan.resources-subscription.oversellPolicyNotAllowedHint' => 'Если продажа сверх запасов запрещена, реселлер может продавать только столько ресурсов, сколько изначально было доступно в его подписке, независимо от того, сколько ресурсов используется фактически.',
    'service-plan.resources-subscription.mainGroupTitle' => 'Определите ограничения на расход ресурсов, входящих в подписку.',
    'service-plan.resources-subscription.additionalGroupTitle' => 'Показать больше ресурсов',
    'service-plan.resources-subscription.hideMoreResources' => 'Показать меньше ресурсов',

    'service-plan.resources.overusePolicy' => 'Перерасход',
    'service-plan.resources.overusePolicyNotAllowed' => 'Перерасход запрещен',
    'service-plan.resources.overusePolicyNotAllowedHint' => 'Запретить перерасход ресурсов. В случае превышения ограничений действие подписки автоматически приостанавливается.',
    'service-plan.resources.overusePolicySoftAllowed' => 'Перерасход дискового пространства и трафика разрешен',
    'service-plan.resources.overusePolicySoftAllowedHint' => 'Разрешить перерасход дискового пространства и трафика. Запретить перерасход других ресурсов.',
    'service-plan.resources.overusePolicyAllowed' => 'Перерасход разрешен (не рекомендуется)',
    'service-plan.resources.overusePolicyAllowedHint' => 'Разрешить клиентам использовать больше ресурсов, чем было изначально включено в план.',
    'service-plan.resources.overuseNotify' => 'Отправлять уведомления о перерасходе',
    'service-plan.resources.oversellPolicy' => 'Продажа сверх запасов',
    'service-plan.resources.oversellPolicyAllowed' => 'Продажа сверх запасов разрешена',
    'service-plan.resources.oversellPolicyAllowedHint' => 'Продажа сверх запасов позволяет реселлеру продавать больше ресурсов, чем доступно в его плане. Если продажа сверх имеющихся объемов разрешена, то реселлер руководствуется фактическим использованием ресурсов вместо изначально выделенного объема ресурсов.',
    'service-plan.resources.oversellPolicyNotAllowed' => 'Продажа сверх запасов запрещена',
    'service-plan.resources.oversellPolicyNotAllowedHint' => 'Если продажа сверх запасов запрещена, реселлер может продавать только столько ресурсов, сколько изначально было доступно в его плане, независимо от того, сколько ресурсов используется фактически.',
    'service-plan.resources.mainGroupTitle' => 'Укажите ресурсы, входящие в план.',
    'service-plan.resources.additionalGroupTitle' => 'Показать больше ресурсов',
    'service-plan.resources.hideMoreResources' => 'Показать меньше ресурсов',
    'service-plan.resources.allowSitebuilderUpsell' => 'Разрешить клиенту создавать пробные сайты в Presence Builder.',
    'service-plan.resources.allowSitebuilderUpsellDescription' => 'Этот параметр позволяет клиенту создавать больше сайтов Presence Builder, чем включает тарифный план. Для публикации этих сайтов клиенту нужно будет их купить.',

    'service-plan.servicePlanName' => 'Имя тарифного плана',
    'service-plan.resellerPlanName' => 'План реселлера',
    'service-plan.addonPlanName' => 'Имя дополнительного плана',
    'service-plan.adminPlanPermissionsTab' => 'Администрирование',
    'service-plan.adminPlanPermissionsTabDescription' => 'Выберите функции, доступные администратору в Ограниченном режиме.',
    'service-plan.hostingPermissionsTab' => 'Хостинг',
    'service-plan.hostingPermissionsTabDescription' => 'Выберите инструменты и настройки хостинга, которые будут доступны администратору в режиме Power User, когда включен Ограниченный режим.',
    'service-plan.resourcesTab' => 'Ресурсы',
    'service-plan.resourcesTabDescription' => 'Определить ресурсы, входящие в план, и политику перерасхода ресурсов.',
    'service-plan.subscriptionResourcesTabDescription' => 'Определите ресурсы, входящие в эту подписку, и политику перерасхода ресурсов.',
    'service-plan.hostingTab' => 'Параметры хостинга',
    'service-plan.hostingTabDescription' => 'Укажите параметры услуги хостинга, входящей в план. Обратите внимание, что указанные для дополнительного плана настройки хостинга не применяются к подпискам, в которых "Управление настройками хостинга" разрешено тарифным или дополнительным планом.',
    'service-plan.secureSettingsDescription' => 'Если вы хотите обеспечить своим клиентам максимальную безопасность, %%link%%. Учтите, что некоторые права позволяют подписчикам менять эти настройки. %%helpLink%%.',
    'service-plan.secureSettingsLink' => 'примените шаблон безопасных настроек',
    'service-plan.secureSettingsHelpLink' => 'Подробнее о настройках безопасности хостинга',
    'service-plan.mailTab' => 'Почта',
    'service-plan.mailTabDescription' => 'Настройте параметры почты для данного плана.',
    'service-plan.dnsTab' => 'DNS',
    'service-plan.dnsTabDescription' => 'Укажите параметры службы DNS, входящей в план.',
    'service-plan.performanceTab' => 'Производительность',
    'service-plan.performanceTabDescription' => 'Настройте параметры производительности для всех услуг, входящих в этот план.',
    'service-plan.permissionsTab' => 'Права',
    'service-plan.miscTab' => 'Журналы и статистика',
    'service-plan.miscTabDescription' => 'Укажите, как хранить статистику и журналы подписок плана. Обратите внимание, что в подписках эти настройки не синхронизируются.',
    'service-plan.miscTabAdminPlanDescription' => 'Укажите, как хранить статистику и журналы подписок.',
    'service-plan.extrasTab' => 'Дополнительные услуги',
    'service-plan.extrasTabDescription' => 'Выберите услуги, которые должны быть включены в план помимо веб-хостинга, DNS и почты.',
    'service-plan.ipTab' => 'IP-адреса',
    'service-plan.ipTabDescription' => 'Укажите параметры ресурсов IP, входящих в план.',
    'service-plan.applicationsTab' => 'Приложения',
    'service-plan.applicationsTabDescription' => 'Выберите приложения, которые будут доступны в этом плане. Вы можете предоставить все приложения, доступные в каталоге и загруженные вами на сервер, или выбрать отдельные приложения. Если вы хотите предоставить все доступные приложения, вам не нужно ничего делать на этой вкладке — просто откройте вкладку Права и выберите опцию Доступ к каталогу приложений. Если вы хотите выбрать приложения вручную, вы можете сделать это на этой вкладке.',
    'service-plan.applicationsTabDescription-addon' => 'Выберите приложения, которые будут включены в эту дополнительную услугу.',
    'service-plan.applicationsTabDescription-subscription' => 'Выберите приложения, которые будут доступны в этой подписке. Вы можете предоставить все приложения, доступные в каталоге и загруженные вами на сервер, или выбрать отдельные приложения. Если вы хотите предоставить все доступные приложения, вам не нужно ничего делать на этой вкладке — просто откройте вкладку Права и выберите опцию Доступ к каталогу приложений. Если вы хотите выбрать приложения вручную, вы можете сделать это на этой вкладке.',
    'service-plan.planSyncSubsriptionWarning' => 'Некоторые подписки не были синхронизированы с планом. Они были помечены как \'Несинхронизированные\' в списке подписок. Чтобы повторить попытку синхронизации, откройте страницу подписки и нажмите кнопку Синхронизировать.',
    'service-plan.planSyncResellerWarning' => 'Некоторые реселлеры не были синхронизированы с планом. Они были помечены как \'Несинхронизированные\' в списке реселлеров. Чтобы повторить попытку синхронизации, откройте страницу реселлера и нажмите Синхронизировать.',
    'service-plan.planSyncAdminWarning' => 'Невозможно применить изменения к подпискам, так как Plesk не предоставляет некоторые из услуг или ресурсов, затрагиваемых этими изменениями. Причина: %%reason%%',
    'service-plan.duplicateName' => 'План с таким именем уже существует.',
    'service-plan.phpSettingsTab' => 'Настройки PHP',
    'service-plan.phpSettingsTabDescription' => 'Здесь вы можете указать индивидуальные настройки PHP для отдельных веб-пространств, которые будут действовать вместо глобальных настроек из файла php.ini. Это может пригодиться, если вы, например, захотите ограничить потребление системных ресурсов PHP-скриптами клиентов. Клиенты (если им разрешено) могут указать собственные настройки на уровне домена. Параметры, для которых вы оставите значение по умолчанию, будут взяты из глобальных настроек PHP. Поддерживаемые замещающие символы: {DOCROOT} и {WEBSPACEROOT} служат для обозначения корневой папки того домена или подписки, для которых предназначена индивидуальная конфигурация PHP; {TMP} служит для обозначения папки, в которой будут храниться временные файлы.',
    'service-plan.phpSettingsTabDescriptionAddon' => 'Здесь вы можете указать индивидуальные настройки PHP для отдельных подписок, которые будут действовать вместо настроек из основного тарифного плана. Это может пригодиться, если вы, например, захотите отменить некоторые ограничения, заданные в основном тарифном плане. Параметры, для которых вы оставите значение по умолчанию, будут взяты из настроек PHP тарифного плана. Поддерживаемые замещающие символы: {DOCROOT} и {WEBSPACEROOT} служат для обозначения корневой папки того домена или подписки, для которых предназначена индивидуальная конфигурация PHP; {TMP} служит для обозначения папки, в которой будут храниться временные файлы.',
    'service-plan.phpSettingsPhpVersion' => 'Ваша текущая версия PHP — %%version%%.',
    'service-plan.phpSettingsTabAdminPlanDescription' => 'Здесь вы можете указать индивидуальные настройки PHP, которые будут действовать для отдельных веб-пространств вместо глобальных настроек из файла php.ini. Параметры, для которых вы оставите значение по умолчанию, будут взяты из глобальных настроек PHP.',
    'service-plan.webServerSettingsTab' => 'Веб-сервер',
    'service-plan.webServerSettingsTabDescription' => 'Здесь вы можете указать настройки веб-сервера Apache для этого тарифного плана. Если Apache работает в связке с nginx, то на этой странице также можно указать настройки nginx. Указанные здесь настройки будут применены только ко вновь создаваемым доменам. Уже существующие домены останутся без изменений.',
    'service-plan.servicesTab' => 'Услуги',
    'service-plan.servicesTabDescription' => 'Здесь вы можете указать услуги, закрепленные за этим тарифным планом.',
    'service-plan.servicePropertiesTab' => 'Свойства %%serviceName%%',
    'service-plan.servicePropertiesTabDescription' => 'Здесь вы можете указать свойства услуги %%serviceName%%, закрепленной за этим тарифным планом.',
    'service-plan.longTaskWarning' => 'У вас %%subscriptionsCount%% подписок на этом плане. Обратите внимание, что синхронизация может занять много времени и она будет выполнена в фоновом режиме.',
    'service-plan.hostingParametersTab' => 'Параметры хостинга',
    'service-plan.adminInfoSection' => 'Информация для администратора',
    'service-plan.descriptionInPanel' => 'Описание',
    'service-plan.longDescription' => 'Слишком длинное описание.',
    'service-plan.conflictPermissions' => 'Невозможно предоставить следующие права, потому что они конфликтуют с планом реселлера: %%permissions%%.',

    'services.change-startup-type.startupTypeLabel' => 'Тип запуска',
    'services.change-startup-type.autoStartupTypeLabel' => 'Автоматически',
    'services.change-startup-type.manualStartupTypeLabel' => 'Вручную',
    'services.change-startup-type.disabledStartupTypeLabel' => 'Отключить',
    'services.change-startup-type.autoActionError' => 'Невозможно установить тип запуска \'авто\': %%error%%',
    'services.change-startup-type.manualActionError' => 'Невозможно установить тип запуска \'вручную\': %%error%%',
    'services.change-startup-type.disableActionError' => 'Невозможно установить тип запуска \'выключено\': %%error%%',

    'sessions.settings.restoreDefaultButton' => 'Восстановить значения по умолчанию',
    'sessions.settings.restoreDefaultButtonDescription' => 'Восстановить значения по умолчанию для параметров сеанса.',
    'sessions.settings.restoreDefaultButtonDescriptionDisable' => 'Параметры сеанса имеют значения по умолчанию.',
    'sessions.settings.idleTime' => 'Время простоя сеанса',
    'sessions.settings.disableCheckSessionIp' => 'Разрешить изменение IP-адреса во время одного сеанса',
    'sessions.settings.minuteShortTitle' => 'мин',

    'settings-ui.controls.title' => 'Элементы управления',

    'settings-ui.interface-views.description' => "Интерфейс Plesk имеет несколько режимов просмотра. От выбранного режима зависит расположение и даже состав функций и настроек. Каждый из режимов предназначен для определенного типа пользователей.",
    'settings-ui.interface-views.panelSimpleLink' => 'Инструменты и настройки > Настройки Ограниченного режима',
    'settings-ui.interface-views.useCustomView' => 'Включить Ограниченный режим',
    'settings-ui.interface-views.useCustomViewHint' => 'Выберите эту опцию, чтобы ограничить набор операций, доступных администратору в Plesk. Настроить список таких операций можно на странице %%customViewSettingsLink%%.',
    'settings-ui.interface-views.powerUserViewHint' => "Этот режим обеспечивает единый упрощенный интерфейс, позволяющий администратору сервера управлять своими сайтами, почтовыми учетными записями и другими компонентами.",
    'settings-ui.interface-views.selectUiModeTitle' => "Режим интерфейса",
    'settings-ui.interface-views.uiModeTitlePowerUser' => "Режим Power User",
    'settings-ui.interface-views.uiModeTitleServiceProvider' => "Режим Service Provider",
    'settings-ui.interface-views.uiModeHintServiceProvider' => "Этот режим предназначен для администратора сервера, реселлеров и конечных пользователей хостинга.",

    'sitebuilder.trial.description' => 'На этой странице вы можете настроить пробный режим (бывший сценарий привлечения клиентов). Этот режим позволит клиентам создавать сайты в Presence Builder, используя все доступные функции программы. Однако для публикации таких пробных сайтов клиентам нужно будет купить дополнительный тарифный план или подписку на хостинг. Пробный режим также можно сделать доступным для существующих клиентов — с помощью хостинг-плана или дополнительного плана. %%link%%',
    'sitebuilder.trial.descriptionLink' => 'Более подробная информация содержится в документации.',
    'sitebuilder.trial.lifetimeLabel' => 'Время жизни пробных сайтов',
    'sitebuilder.trial.lifetimeUnits' => 'дней',
    'sitebuilder.trial.lifetimeDescription' => 'Это количество времени, в течение которого пробные сайты, не купленные клиентами, будут храниться на сервере.',
    'sitebuilder.trial.signupLabel' => 'Включить общий доступ к пробному режиму',
    'sitebuilder.trial.signupDescription' => 'Включить открытый доступ к пробной версии Presence Builder.',
    'sitebuilder.trial.signupLinkLabel' => 'URL пробной версии',
    'sitebuilder.trial.signupLinkDescription' => 'URL-адрес пробной версии Presence Builder. Чтобы сделать этот адрес доступным для потенциальных клиентов, опубликуйте его на своем сайте или распространите любым другим способом.',
    'sitebuilder.trial.promotionLabel' => 'Показывать уведомление о пробном режиме в редакторе Presence Builder',
    'sitebuilder.trial.promotionDescription' => 'Включить показ уведомления о том, что Presence Builder работает в пробном режиме.',

    'update-settings.policyHintForPum' => 'Настроить автоматическую установку обновлений можно здесь. Вы можете настроить получение уведомлений по электронной почте, когда появятся доступные обновления для установки вручную, или когда обновления будут установлены автоматически.',
    'update-settings.policyHint' => 'Вы можете настроить получение уведомлений по электронной почте, когда появятся доступные обновления для установки вручную, или когда обновления будут установлены автоматически.',
    'update-settings.branchDisabledDescription' => 'Не сообщать о доступных обновлениях',
    'update-settings.automaticPatchesInstallation' => 'Устанавливать обновления Plesk автоматически (рекомендуется)',
    'update-settings.automaticPatchesInstallationHint' => 'Критические обновления безопасности всегда устанавливаются автоматически.',
    'update-settings.automaticPatchesThirdParty' => 'Автоматически устанавливать обновления для сторонних компонентов, поставляемых с Plesk',
    'update-settings.automaticSystemPackageUpdates' => 'Автоматически устанавливать обновления системных пакетов',
    'update-settings.automaticSystemPackageUpdatesHint' => 'Обратите внимание на то, что будут автоматически установлены обновления для сторонних компонентов, поставляемых с Plesk',
    'update-settings.automaticPatchesNotification' => 'Уведомлять о доступных и установленных обновлениях системных пакетов',
    'update-settings.systemPackageUpdatesNotificationsEmail' => 'Электронная почта',
    'update-settings.systemPackageUpdatesNotificationsPeriod' => 'Частота уведомлений по электронной почте',
    'update-settings.daily' => 'Ежедневно',
    'update-settings.weekly' => 'Еженедельно',
    'update-settings.generalSection' => 'Общие',
    'update-settings.notificationsSection' => 'Уведомления',
    'update-settings.safeUpdatesSection' => 'Безопасные обновления',
    'update-settings.safeUpdatesSectionHint' => 'Plesk следит за тем, чтобы обновления системных пакетов устанавливались из того же репозитория, откуда изначально были установлены пакеты. Такие обновления считаются безопасными. Если вы отключите безопасные обновления, ваш менеджер системных пакетов сможет устанавливать обновления из любого репозитория в системе.',
    'update-settings.safeUpdatesSectionWarn' => 'Если вы не опытный пользователь, мы рекомендуем оставить включенными безопасные обновления. Беспорядочное обновление системных пакетов из разных репозиториев может негативно сказаться на работе сервера.',
    'update-settings.allowSafeUpdates' => 'Включить безопасные обновления для системных пакетов',

    'requiredFields' => 'Обязательные поля',
];