
class Issue(object):
    def __init__(self, problem_text, details_text=None):
        """
        :type problem_text: str | unicode
        :type details_text: str | unicode | None
        """
        self._problem_text = problem_text
        self._details_text = details_text

    @property
    def problem_text(self):
        """
        :rtype: str | unicode
        """
        return self._problem_text

    @property
    def details_text(self):
        """
        :rtype: str | unicode | None
        """
        return self._details_text

    def as_dictionary(self):
        """
        :rtype: dict[str | unicode: str | unicode | None]
        """
        return {
            'problem_text': self.problem_text,
            'details_text': self.details_text
        }
