from parallels.common.actions.base.subscription_backup_action import SubscriptionBackupAction


class RemoveSubdomainMail(SubscriptionBackupAction):
	def get_description(self):
		return "Remove mail for subdomains in backup"

	def get_failure_message(self, global_context, subscription):
		return "Failed to remove mail for subdomains in backup for subscription '%s'" % (subscription.name)

	def is_critical(self):
		"""If action is critical or not

		If action is critical and it failed for a subscription, migration tool
		won't run the next operations for the subscription.

		:rtype: bool
		"""
		return False

	def _run_subscription_backup(
		self, global_context, subscription, subscription_backup
	):
		for site in subscription_backup.iter_sites():
			if site.parent_domain_name is not None:
				site.remove_mailsystem()
