from parallels.common import messages
import logging
import os

from parallels.common import MigrationError
from parallels.common.actions.base.common_action import CommonAction
from parallels.common.actions.migration_list.utils import get_migration_list_file_location

logger = logging.getLogger(__name__)


class CheckMigrationListNotExistsForGeneration(CommonAction):
	def get_description(self):
		return messages.CHECK_IF_MIGRATION_LIST_FILE_ALREADY

	def get_failure_message(self, global_context):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		"""
		return messages.FAILED_CHECK_IF_MIGRATION_LIST_FILE

	def run(self, global_context):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		"""
		migration_list_file = get_migration_list_file_location(global_context)

		if os.path.exists(migration_list_file):
			if not global_context.options.overwrite:
				raise MigrationError(
					messages.MIGRATION_LIST_FILE_S_ALREADY_EXISTS % (migration_list_file,)
				)
			else:
				logger.info(
					messages.MIGRATION_LIST_FILE_S_ALREADY_EXISTS_1,
					migration_list_file
				)
