from parallels.core.actions.base.compound_action import CompoundAction
from parallels.core.actions.content.web.fix_unix_vhost_permissions import FixUnixVhostPermissions
from parallels.core.workflow.shared_hosting_workflow 	import SharedHostingWorkflow
from parallels.source.plesk.actions.aps.restore_applications import RestoreApplications
from parallels.source.plesk.actions.content.web.copy_unix_content import CopyUnixWebContent
from parallels.source.plesk.actions.content.web.copy_windows_content import CopyWindowsWebContent
from parallels.source.plesk.actions.content.web.fix_permissions_for_clients_iis_pools import \
	FixPermissionsForClientsIISPools
from parallels.source.plesk.actions.content.web.fix_security_files import FixSecurityFiles
from parallels.source.plesk.actions.content.web.fix_unix_permissions import FixUnixPermissions
from parallels.source.plesk.actions.content.web.fix_unix_permissions_old_plesk import FixUnixPermissionsOldPlesks
from parallels.source.plesk.actions.content.web.fix_unix_vhost_structure import FixUnixVhostStructure
from parallels.source.plesk.actions.content.web.reset_permissions import ResetPermissions
from parallels.source.plesk.actions.hosting_settings.transfer_error_documents import TransferErrorDocuments
from parallels.source.plesk.actions.hosting_settings.transfer_mime_types import TransferMIMETypes
from parallels.source.plesk.actions.hosting_settings.transfer_virtual_directories import TransferVirtualDirectories
from parallels.source.plesk.actions.wpb.transfer import Transfer as TransferWPBSites
from parallels.source.shm_web_sn.action.fetch_backup import FetchBackupAction
from parallels.source.shm_web_sn.action.fetch_target import FetchTargetAction
from parallels.source.shm_web_sn.action.load_move_list import LoadMoveListAction


class PPAMoveWebspacesWorkflow(SharedHostingWorkflow):
	def __init__(self):
		super(PPAMoveWebspacesWorkflow, self).__init__()

		self.insert_first_shared_action_to_all_entries('load-move-list', LoadMoveListAction())

		fetch_source_action = self.get_shared_action('fetch-source')
		fetch_source_action.insert_action('fetch-data', FetchBackupAction())

		self.replace_shared_action('fetch-target', FetchTargetAction())

		self.replace_shared_action('check-connections', CompoundAction())

		self.get_path('transfer-accounts/restore-hosting/convert-hosting').replace('convert-dns', CompoundAction())

		self.get_path('transfer-accounts/restore-hosting').replace('restore-sysuser-logins', CompoundAction())

		self.replace_shared_action('copy-mail-content', CompoundAction())

		self.get_path('transfer-accounts').replace('verify-hosting', CompoundAction())

		self.get_shared_action('copy-web-files').insert_action(
			'copy-files-linux', CopyUnixWebContent()
		)
		self.get_shared_action('sync-web-content-assets').insert_action(
			'fix-unix-vhost-permissions', FixUnixVhostPermissions()
		)
		self.get_shared_action('sync-web-content-assets').insert_action(
			'fix-unix-vhost-structure', FixUnixVhostStructure()
		)
		self.get_shared_action('sync-web-content-assets').insert_action(
			'fix-permissions-old-plesks', FixUnixPermissionsOldPlesks()
		)
		self.get_shared_action('sync-web-content-assets').insert_action(
			'fix-permissions', FixUnixPermissions()
		)
		self.get_shared_action('sync-web-content-assets').insert_action(
			'copy-files-windows', CopyWindowsWebContent()
		)
		self.get_shared_action('sync-web-content-assets').insert_action(
			'fix-security-files', FixSecurityFiles()
		)
		self.get_shared_action('sync-web-content-assets').insert_action(
			'reset-permissions', ResetPermissions()
		)
		self.get_shared_action('sync-web-content-assets').insert_action(
			'fix-permissions-for-client-iis-pools',
			FixPermissionsForClientsIISPools()
		)
		self.get_shared_action('sync-web-content-assets').insert_action(
			'transfer-wpb-sites', TransferWPBSites()
		)
		self.get_shared_action('sync-web-content-assets').insert_action(
			'restore-aps', RestoreApplications()
		)
		self.get_shared_action('sync-web-content-assets').insert_action(
			'transfer-virtual-directories', TransferVirtualDirectories()
		)
		self.get_shared_action('sync-web-content-assets').insert_action(
			'transfer-error-documents', TransferErrorDocuments()
		)
		self.get_shared_action('sync-web-content-assets').insert_action(
			'transfer-mime-types', TransferMIMETypes()
		)


