import logging

from parallels.core.utils.config_utils import ConfigSection
from parallels.source.plesk.connections import PleskMigratorConnections
from parallels.source.shm_web_sn.source_server import PPAMoveWebspacesSourceServer
from parallels.target.ppa.connections.target_connections import  PPATargetConnections
from parallels.core.utils.common import cached
from parallels.core.utils.common import merge_dicts

logger = logging.getLogger(__name__)

class PPAMoveWebspacesWebSnSourceConnections(PleskMigratorConnections):
	def __init__(self, config, target_panel, migrator_server):
		super(PPAMoveWebspacesWebSnSourceConnections, self).__init__(config, target_panel, migrator_server)
		self.mn_server = PPATargetConnections(config)

	@cached
	def get_source_node(self, node_id):
		all_servers = merge_dicts(
			self.get_source_plesks(), self.get_external_db_servers()
		)
		node_settings = all_servers[node_id]
		return PPAMoveWebspacesSourceServer(
			node_id, node_settings, self._migrator_server, '12.1', self.mn_server
		)

	@staticmethod
	def _read_web_sn_settings(config, section_name):
		section = ConfigSection(config, section_name)
		settings = {}
		for name in ['ip', 'os']:
			settings[name] = section[name]
		return settings
