from parallels.core.utils.config_utils import ConfigSection
from parallels.core.migrator_config import read_ssh_auth
from parallels.core.migrator_config import read_copy_mail_content_settings

# This is the ID used for naming config file sections and migration dump files
PANEL_ID = 'ppcpl'

class PPCPLConfig(object):
	def __init__(self, config):
		self.ip = config['ip']
		self.id = PANEL_ID
		self.is_windows = False
		self.ssh_auth = read_ssh_auth(config)
		self.pmm_agent_name = "PPCPL"
		self.agent_script_name = 'PPCPL.pl'
		self.session_dir = config.get('session-dir', '/tmp')
		self.mail_settings = read_copy_mail_content_settings(
			config, is_windows=False
		)

def init(config):
	confixx_section = ConfigSection(config, PANEL_ID)
	return PPCPLConfig(confixx_section)

