#!/bin/sh -e 

# Old Plesk Panel cronjobs could be dangerous after migration, so we should remove them.
# 
# For example, daily maintenance script cronjob removes Apache server-wide configuration files
# created by target Plesk (PPA Plesk) as the maintenance script know nothing about the files and 
# consider them as old config files that should be removed. So, Apache configuration becomes invalid.

OLD_CRONJOBS_DIR=/root/plesk_old_cronjobs

mkdir -p "$OLD_CRONJOBS_DIR"

# move all cron job files, that are from plesk-core package
for file in `rpm -ql plesk-core | grep ^/etc/cron.`; do
	if [ -f "$file" ]; then
		echo "Moving Plesk cron job file '$file' to '$OLD_CRONJOBS_DIR'"
		mv "$file" "$OLD_CRONJOBS_DIR"
	fi
done

/etc/init.d/crond reload

