from parallels.core.utils.message_utils import single_line_message
from parallels.core.utils.message_utils import multi_line_message

LOG_EXCEPTION = single_line_message("""
	Exception:
""")
COULD_NOT_REMOVE_ZONE_ISSUE = single_line_message("""
	Could not remove the zone '%s' from DNS. The error is: %s
""")
COULD_NOT_ADD_SUBDOMAIN_SLAVE_DNS_ZONE = single_line_message("""
	Could not add a slave DNS zone for subdomain '%s', error: '%s'
""")
COULD_NOT_REMOVE_SUBDOMAIN_DNS_ZONE = single_line_message("""
	Could not remove the DNS zone of subdomain '%s', error: '%s'
""")
LOG_COULD_NOT_ADD_SUBDOMAIN_SLAVE_DNS_ZONES_ISSUE = single_line_message("""
	Could not add slave DNS zones for subdomains, error: %s
""")
COULD_NOT_ADD_ZONE_TO_DNS_ISSUE = single_line_message("""
	Could not add the zone '%s' (secondary, with master server '%s') to DNS. The error is: '%s'
""")
INTERNAL_ERROR_UNKNOWN_DNS_SERVICE_TYPE = single_line_message("""
	Migrator is trying to get the forwarding implementation for an unknown DNS service type: '%s'
""")
LOG_COULD_NOT_REMOVE_SUBDOMAIN_DNS_ZONES = single_line_message("""
	Could not remove subdomains' DNS zones, error: %s
""")

LOG_CREATE_SOURCE_PANEL_MIGRATION_DUMP = single_line_message("""
	Create source panel migration dump.
""")
LOG_CREATE_SOURCE_PANEL_MIGRATION_SHALLOW_DUMP = single_line_message("""
	Create source panel migration dump.
""")
LOG_CREATE_SOURCE_PANEL_MIGRATION_CAPABILITY_DUMP = single_line_message("""
	Create source panel capability dump.
""")
LOG_UNABLE_ADD_SUBDOMAIN_ZONES_UNKNOWN_DNS_SERVICE = single_line_message("""
	Unable to add subdomain zones in slave mode: unknown DNS service type '%s'
""")
FAILED_DNS_FORWARDING_UNDO_MANUAL_SOLUTION = single_line_message("""
	Restore DNS hosting settings manually or from Plesk backup file '%s'
""")
COULD_NOT_UNASSIGN_DNS_SERVER = single_line_message("""
	Could not unassign the DNS server serving domain '%s' in master mode, error code: %s, error message: '%s'
""")
LOG_GET_DNS_TIMINGS_FROM = single_line_message("""
	Get old DNS timing values from '%s' Plesk
""")
LOG_SET_DNS_TIMINGS = single_line_message("""
	Set low DNS timing values on '%s' Plesk
""")
LOG_SKIP_SETTING_UP_DNS_FORWARDING_FOR_SLAVE = single_line_message("""
	Skip setting up the DNS forwarding for domain '%s' zone which is already in slave mode
""")
COULD_NOT_GET_DOMAIN_IDENTIFIER_FROM_PLESK_API = single_line_message("""
	Could not get identifier of domain '%s' on source server using Plesk API, error message: '%s'
""")
LOG_CHANGE_DNS_ZONE_ON_PLESK = single_line_message("""
	Change %d zone(s) on Plesk '%s'
""")
COULD_NOT_ENABLE_DNS_ZONE_OF_DOMAIN = single_line_message("""
	Could not enable the DNS zone of domain '%s', error code: %s, error message: '%s'
""")
LOG_UNDO_DNS_FORWARDING = single_line_message("""
	Undo DNS forwarding on Plesk '%s'
""")
COULD_NOT_SWITCH_TO_SLAVE_DNS_SERVICE = single_line_message("""
	Could not switch to 'slave' the DNS service mode for domain '%s', error code: %s, error message: '%s'
""")
COULD_NOT_DISABLE_DNS_ZONE = single_line_message("""
	Could not disable the DNS zone of domain '%s', error code: %s, error message: '%s'
""")
COULD_NOT_GET_TARGET_DNS_SERVER = single_line_message("""
	Could not get PPA DNS server for zone '%s', error is '%s'
""")
COULD_NOT_SWITCH_DNS_TO_MASTER = single_line_message("""
	Could not switch to 'master' the DNS service mode for domain '%s', error code: %s, error message: '%s'
""")
UNABLE_ADD_SUBDOMAIN_ZONES_UNKNOWN_DNS_SERVICE = single_line_message("""
	Unable to add a slave DNS zone for subdomain '%s': Plesk server '%s' has DNS service of unknown/unsupported type
	'%s'
""")
COULD_NOT_GET_DOMAIN_IDENTIFIER = single_line_message("""
	Could not get identifier of domain '%s' on source server using Plesk API
""")
LOG_STORE_OLD_DNS_TIMINGS_TO = single_line_message("""
	Store old DNS timing values to '%s'
""")
FAILED_DNS_FORWARDING_SET_UP_MANUAL_SOLUTION = single_line_message("""
	Configure this zone on the source server to be served in slave mode, with the corresponding PPA DNS server as
	master.
""")
FILE_WITH_TIMINGS_ALREADY_EXISTS = single_line_message("""
	File '%s' with old DNS timing values already exists. Rewrite is not performed not to loose old timing settings
""")
LOG_UNABLE_REMOVE_SUBDOMAIN_ZONES_UNKNOWN_DNS_SERVICE = single_line_message("""
	Unable to remove subdomain zones: unknown DNS service type '%s'
""")
LOG_SET_UP_DNS_FORWARDING_ON_PLESK_SERVER = single_line_message("""
	Set up DNS forwarding on Plesk '%s'
""")
UNABLE_REMOVE_SUBDOMAIN_ZONES_UNKNOWN_DNS_SERVICE = single_line_message("""
	Unable to remove the DNS zone of subdomain '%s': Plesk server '%s' has DNS service of unknown/unsupported type '%s'
""")
LOG_PLESK_SERVER_INFO = single_line_message("""
	Plesk version '%s', Plesk API version '%s'
""")
INTERNAL_FAILURE_UNABLE_TO_DETECT_SOURCE_PANEL_VERSION = single_line_message("""
	Unable to detect source panel version. Skip checking.
""")
SOURCE_PLESK_VERSION_IS_NOT_SUPPORTED = single_line_message("""
	You are trying to migrate from Plesk version '%s'. Migration from this version is not supported yet.
""")
CHECKING_CONNECTIONS_FAILURE = single_line_message("""
	Error while checking connection settings: '%s'
""")
LOG_REQUIRED_DISK_SPACE_WINDOWS = single_line_message("""
	Required disk space for '%s:' disk: %s bytes
""")
LOG_TOTAL_DISK_USAGE_ON_SOURCE = multi_line_message("""
	Total disk usage on the source nodes for domains migrated to node %s:
	- Web: %s bytes
	- Mail: %s bytes
	- MySQL databases: %s bytes
""")
INSUFFICIENT_DISK_SPACE_TARGET_WINDOWS_ISSUE = multi_line_message("""
	Insufficient disk space on {target}:
	
""")
LOG_AVAILABLE_DISK_SPACE_SOURCE = single_line_message("""
	Available disk space on %s, '%s:' disk: %s bytes
""")
INSUFFICIENT_WINDOWS_DISK_SPACE_SOURCE_ISSUE = multi_line_message("""
	Insufficient disk space on {description}:
	
""")
EXPECTED_DISK_SPACE_BY_WINDOWS_DISKS = multi_line_message("""
	- Disk {disk_letter}: - expected to have more than {required} for migrated content, actually have {available}
	
""")
UNABLE_TO_CHECK_CONNECTION_FROM_TARGET_MSSQL = multi_line_message("""
	Unable to check connection from {target} to MSSQL server '{mssql_host}' (user '{mssql_user}') located on {source}.
	Command the migrator tried to execute on {target} was: {command_str}
	exit code: {exit_code}
	stdout: {stdout}
	stderr: {stderr}
	
""")
INSUFFICIENT_DISK_SPACE_TARGET_ = multi_line_message("""
	Insufficient disk space on {target}:
	
""")
UNIX_RSYNC_PROBLEM_SOLUTION = multi_line_message("""
	Please check that:
	1) There are no firewall rules blocking SSH connections from the target node to the source server.
	TCP port 22 on the source server is open for incoming connections, TCP port 22 on the target node is open for outgoing connections.
	2) The SSH service is running on the source server.
	3) The source server allows using the key-based SSH authentication for the target node.
""")
WINDOWS_RSYNC_PROBLEM_SOLUTION = multi_line_message("""
	Please check that:
	1) There are no firewall rules blocking rsync connections from the target node to the source server.
	TCP port 873 on the source server is open for incoming connections, TCP port 873 on the target node is open for outgoing connections.
	2) rsync server is configured on the source server according to the Migration Guide.
	3) rsync server is started on the source server.
""")
LACK_OF_DISK_SPACE_ON_DEVICE = single_line_message("""
	Required to have more than {required} on {device} device, available: {available}.
""")
RSYNC_CONNECTION_WINDOWS_COPY_CONTENT_SUCCESS = single_line_message("""
	Successfully checked the rsync connection between %s and the source server at %s
""")
ENOUGH_DISK_SPACE_TARGET_WINDOWS = single_line_message("""
	{target} has enough disk space for web content.
""")
ENOUGH_DISK_SPACE_FOR_CONTENT = single_line_message("""
	{target} has enough disk space for content.
""")
UNIX_RSYNC_PROBLEM_INVALID_TEST_FILE_CONTENTS = multi_line_message("""
	Unexpected error: invalid content of file was transferred with '{command_name}'
	Expected content: {expected_file_contents}
	Actual content on target node: {actual_file_contents}
	
""")
LOG_CHECK_CONNECTIONS_TO_TARGET_DATABASE_SERVERS = single_line_message("""
	Check connections to target database servers
""")
ENOUGH_DISK_SPACE_WINDOWS_SOURCE = single_line_message("""
	{source} has enough disk space for temporary files.
""")
NOTICE_THAT_WE_IGNORE_EXCEPTION_AND_USE_0_AS_DISK_SPACE_USAGE = single_line_message("""
	As exception occured - we just consider database uses 0 bytes not to break all checks. It is very likely that
	database simply does not exist which makes command to fail.
""")
MAX_ALLOWED_MYSQL_PACKET_ISSUE_INTRO = multi_line_message("""
	Some database objects might not be restored.
	
""")
MAX_ALLOWED_MYSQL_PACKET_ISSUE_DESCRIPTION = single_line_message("""
	 - The 'max_allowed_packet' parameter on {source_host} is {source}, which is bigger than on {target_host}, where it
	is {target}.
""")
LOG_AVAILABLE_DISK_SPACE_WINDOWS = single_line_message("""
	Available disk space for '%s:' disk: %s bytes
""")
RSYNC_CONNECTION_WINDOWS_COPY_CONTENT_FAILURE = multi_line_message("""
	Unable to check the rsync connection between %s and the source server at %s:
	%s
	While this problem persists, it may not be possible to copy the %s content of the following subscriptions:%s
""")
LOG_REQUIRED_DISK_SPACE = single_line_message("""
	Required disk space for '%s' device: %s bytes
""")
UNIX_DF_OUTPUT_PARSE_ISSUE_EXPECTED_MORE_LINES = single_line_message("""
	Expected to have more than 2 lines from 'df' utility, got %s. 'df' utility output: %s
""")
LOG_TOTAL_DISK_USAGE_ON_TARGET = multi_line_message("""
	Total disk usage on the target node for domains migrated to %s:
	- Web: %s bytes
	- Mail: %s bytes
	- MySQL databases: %s bytes
""")
SELECT_SUMDATA_LENGTH_FROM_INFORMATION_SCHEMATABLES = single_line_message("""
	SELECT SUM(data_length) FROM information_schema.TABLES WHERE information_schema.TABLES.TABLE_SCHEMA = '{db_name}'
""")
UNABLE_CONNECT_NODE_BY_POP3_PORT = multi_line_message("""
	Unable to connect to {node} by POP3 ({port_number} port).
	Please check that:
	1) There are no firewall rules blocking POP3 connections from the current server to the source server.
	2) POP3 server is running on the source server.
""")
MSSQL_UNABLE_TO_FIND_DB_SIZE_IN_SCRIPT_OUTPUT = multi_line_message("""
	Unable to find 'database_size' or/and 'db_file_location' parameter(s) in MSSQL disk usage script's output.
	Command: %s
	Exit code: %s
	stdout: %s
	stderr: %s
""")
LOG_AVAILABLE_DISK_SPACE = single_line_message("""
	Available disk space for '%s' device: %s bytes
""")
COMMAND_DESCRIPTION = multi_line_message("""
	Command the migrator tried to execute on {target} was: {command_str}
	exit code: {exit_code}
	stdout: {stdout}
	stderr: {stderr}
	
""")
LOG_REQUIRED_DISK_SPACE_SOURCE = single_line_message("""
	Required disk space for temporary files on %s, '%s:' disk: %s bytes
""")
MSSQL_UNABLE_TO_PARSE_DISK_SPACE_SCRIPT_OUTPUT = single_line_message("""
	Unable to parse string that should contain disk usage. String: %s
""")
RSYNC_CONNECTION_WINDOWS_COPY_CONTENT_SOLUTION = multi_line_message("""
	Make sure that:
	1) There are no firewall rules blocking rsync connections from the PPA node to the source server:
	the incoming connections on the TCP port 873 of the source server are allowed, the outgoing connections on the TCP port 873 of the PPA service node are allowed.
	2) The rsync service is configured on the source server according to the Migration Guide.
	3) The rsync service is started on the source server.
	4) The following command can be successfully executed on the PPA service node:
	{cmd}
""")
INSUFFICIENT_DISK_SPACE_TARGET_WINDOWS_SOLUTION = multi_line_message("""
	To resolve the issue you could:
	1) Increase disk space on the node.
	2) Migrate subscriptions to another server.

	Fix found issues and run the transfer-accounts command again.
""")
CHECK_CONNECTION_FROM_TARGET_MSSQL_SERVER = single_line_message("""
	Check connection from {target} to MSSQL server '{mssql_host}' (user '{mssql_user}') located on {source}
""")
INSUFFICIENT_WINDOWS_DISK_SPACE_SOURCE_SOLUTION = multi_line_message("""
	To resolve the issue you could:
	1) Free disk space on the disk.
	2) Change 'session-dir' config.ini parameter for the server so it points to directory located on a disk that has enough space.
	
	Fix found issues and run the transfer-accounts command again.
""")
REQUIRED_DISK_SPACE_BY_LETTER = single_line_message("""
	- Disk {disk_letter}: - expected to have more than {required} for migrated content, actually have {available}.
""")
SUCCESSFULLY_CONNECTED_FROM_TARGET_MSSQL_SERVER = single_line_message("""
	Successfully connected from {target} to MSSQL server '{mssql_host}' (user '{mssql_user}') located on {source}
""")
LOG_CHECK_CONNECTION_TO_TARGET_DATABASE_SERVER = single_line_message("""
	Check connection to target database server %s
""")
INSUFFICIENT_DISK_SPACE_SOLUTION = multi_line_message("""
	To resolve the issue you could:
	1) Increase disk space on the node.
	2) Migrate subscriptions to another server.

	Fix found issues and run the transfer-accounts command again.
""")
DATABASE_SERVER_CONNECTION_ISSUE = multi_line_message("""
	1) Check that database server is configured and working.
	2) Check that you can create database from target panel for that database server
	3) Check that there are no firewall rules that may block connection to the server
	4) Check that credentials specified in the target panel are correct for that database server
""")
REPORT_TITLE_CONNECTIONS_TO_TARGET_DATABASE_SERVERS = single_line_message("""
	Connections to target database servers
""")
SESSION_DIR_ENOUGH_DISK_SPACE_SOURCE = single_line_message("""
	{source} has enough disk space for temporary files.
""")
SESSION_DIR_INSUFFICIENT_DISK_SPACE_SOURCE_FAILURE = multi_line_message("""
	Insufficient disk space on {source}:
	
""")
UNABLE_TO_CONNECT_FROM_TARGET_MSSQL_SERVER = multi_line_message("""
	Unable to connect from {target} to MSSQL server '{mssql_host}' (user '{mssql_user}') located on {source}.
	
	Please check that:
	1) There are no firewall rules blocking MSSQL connections from the target node to the source server.
	2) Remote connections to MSSQL server are allowed.
	3) MSSQL server is running.
	
	Connection error message: {connection_error_message}
""")
UNIX_DF_OUTPUT_PARSE_ISSUE_EXPECTED_AT_LEAST_ONE_ITEM = single_line_message("""
	Expected to have at least 4 item in filesystem line of 'df' utility. Parsed filesystem line items as: %r
""")
UNABLE_CONNECT_BY_IMAP_PORT = multi_line_message("""
	Unable to connect to {node} by IMAP ({port_number} port).
	Please check that:
	1) There are no firewall rules blocking IMAP connections from the current server to the source server.
	2) IMAP server is running on the source server
	3) If you have enforced access by SSL, make sure you specified correct value for 'imap-encryption' option in config.ini
	4) If you don't have IMAP on the source server, configure the tool
	to copy Inbox messages only with 'copy-mail-content: messages'
	option in corresponding section of configuration file.
	In that case migration tools will use POP3 to copy messages
""")
INTERNAL_ERROR_CHECKING_TARGET_DATABASE_SERVER = single_line_message("""
	Internal error: failed to check connection to target database server %s: %s
""")
SESSION_DIR_INSUFFICIENT_DISK_SPACE_SOURCE_SOLUTION = multi_line_message("""
	To resolve the issue you could:
	1) Free disk space for the partition.
	2) Change 'session-dir' config.ini parameter for the server so it points to directory located on partition that has enough disk space.
	
	Fix found issues and run the transfer-accounts command again.
""")
UNABLE_TO_CONNECT_TARGET_BY_IMAP_PORT = multi_line_message("""
	Unable to connect to {node} by IMAP ({port_number} port).
	Please check that:
	1) There are no firewall rules blocking IMAP connections from the current server to the target node.
	2) IMAP server is running on the target node
""")
LOG_MAX_ALLOWED_MYSQL_PACKET = single_line_message("""
	Max allowed packet for mysql on '%s': %s bytes
""")
UNIX_COPY_FILE_CONNECTION_FAILED_SOLUTION = multi_line_message("""
	Please check that:
	1) There are no firewall rules blocking SSH connections from the target node to the source server.
	TCP port 22 on the source server is open for incoming connections, TCP port 22 on the target node is open for outgoing connections.
	2) The SSH service is running on the source server.
	3) The source server allows using the key-based SSH authentication for the target node.
""")
LOG_NO_NEED_TO_COPY_CONTENT_BECAUSE_DISABLED_BY_USER = single_line_message("""
	Mail content migration for subscription '%s' is disabled by user
""")
LOG_NO_NEED_TO_COPY_CONTENT_BECAUSE_OF_ASSIMILATION = single_line_message("""
	Mail server of subscription '%s' is migrated in assimilate mode, no need to copy mail content
""")
ACTION_SUSPEND_SOURCE_SUBSCRIPTION_FOR_COLD_MIGRATION_DESCRIPTION = single_line_message("""
	Suspend source subscription for cold migration
""")
ACTION_SUSPEND_SOURCE_SUBSCRIPTION_FOR_COLD_MIGRATION_FAILURE = single_line_message("""
	Failed to suspend subscription
""")
FAILED_TO_READ_INFORMATION_ABOUT_WPB_SITES = single_line_message("""
	Failed to read information about Web Presense Builder sites.
""")
LOG_RESTORE_RELATION_PLESK_DOMAIN_TO_WPB_SITE = single_line_message("""
	Restore relation between Plesk domain and Web Presense Builder site
""")
LOG_UPLOAD_BACKUP_FILE_TO_TARGET = single_line_message("""
	Upload backup file to target panel management node
""")
LOG_DOWNLOAD_BACKUP_FILE_TO_LOCAL_SERVER = single_line_message("""
	Download backup file to local server
""")
LOG_BACKUP_WPB_SITE_ON_SOURCE = single_line_message("""
	Backup Web Presence Builder site on the source node
""")
ACTION_TRANSFER_WPB_FAILURE = single_line_message("""
	Failed to transfer WPB sites of subscription '%s'
""")
ACTION_TRANSFER_WPB_DESRIPTION = single_line_message("""
	Transfer WPB sites
""")
LOG_RESTORE_WPB_SITE_ON_TARGET = single_line_message("""
	Restore Web Presense Builder site on target panel management node
""")
DEBUG_COLLECTING_INFO_ABOUT_WPB_SITES = single_line_message("""
	Collecting information about Web Presense Builder sites
""")

ACTION_FIX_PERMISSIONS_FOR_CLIENT_IIS_POOLS_DESCRIPTION = single_line_message("""
	Fix permissions for domains with client's or reseller's application pool
""")
ACTION_FIX_PERMISSIONS_FOR_CLIENT_IIS_POOLS_FAILURE = single_line_message("""
	Failed to fix permissions of files for subscription '%s'
""")
ACTION_RESTORE_DEDICATED_APPLICATION_POOL_DESCRIPTION = single_line_message("""
	Restore IIS dedicated application pools
""")
ACTION_RESTORE_DEDICATED_APPLICATION_POOL_FAILURE = single_line_message("""
	Failed to restore dedicated application pool for subscription '%s'
""")
ACTION_FIX_SECURITY_FILES_DESCRIPTION = single_line_message("""
	Fix files with permissions settings for Windows
""")
ACTION_FIX_SECURITY_FILES_FAILURE = single_line_message("""
	Failed to restore file permissions for subscription '%s'
""")
LOG_GET_IIS_DEDICATED_APPLICATION_POOL_USER = single_line_message("""
	Get IIS dedicated application pool user on target node
""")
LOG_UPLOAD_FIXED_FILE_TO_TARGET = single_line_message("""
	Upload fixed '%s' file to target node
""")
LOG_SKIP_PROCESSING_SECURITY_FILE = single_line_message("""
	Skip processing '%s' file as it does not exist on source
""")
LOG_GET_FILE_TO_CHANGE_IIS_POOL_USER = single_line_message("""
	Get '%s' file to change dedicated IIS application user that was changed, put it to '%s'
""")
LOG_IIS_DEDICATED_APPLICATION_POOL_USER_ON_TARGET = single_line_message("""
	IIS dedicated application pool user on target node: '%s'
""")
LOG_FIX_SECURITY_FILE = single_line_message("""
	Fix '%s' file, write fixed file to '%s'
""")
ACTION_FIX_UNIX_VHOST_STRUCTURE_FAILURE = single_line_message("""
	Failed to fix vhost structure for subscription '%s'
""")
ACTION_FIX_UNIX_VHOST_STRUCTURE_DESCRIPTION = single_line_message("""
	Fix vhost structure for Unix servers
""")
CAN_NOT_CREATE_LINKS_FOR_SUBSCRIPTION = single_line_message("""
	Can't create links for subscription '%s' with error '%s'.
""")

ACTION_FIX_PERMISSIONS_FOR_IIS6_DOMAIN_DESCRIPTION = single_line_message("""
	Fix permissions for domains from IIS 6 with disabled ASP.NET
""")
ACTION_FIX_PERMISSIONS_FOR_IIS6_DOMAIN_FAILURE = single_line_message("""
	Failed to fix permissions of files for subscription '%s'
""")
ACTION_RESET_PERMISSIONS_DESCRIPTION = single_line_message("""
	Fix file permissions for Windows
""")
ACTION_RESET_PERMISSIONS_FAILURE = single_line_message("""
	Failed to restore file permissions for subscription '%s'
""")
REPAIR_PERMISSIONS_FOR_SUBSCRIPTION = single_line_message("""
	Repair permissions for the '%s' subscription
""")
UPDATE_WEBSPACE_SUBDOMAINS_SECURITY = single_line_message("""
	Update webspace subdomains security for the '%s' subscription
""")
ACTION_FIX_UNIX_PERMISSIONS_DESCRIPTION = single_line_message("""
	Fix permissions for web files
""")
ACTION_FIX_UNIX_PERMISSIONS_FAILED = single_line_message("""
	Failed to fix permissions for web files of subscription '%s'
""")
LOG_FIX_FILE_OWNERSHIP_AFTER_MOVING = single_line_message("""
	Fix file ownership for files in domain directory after moving
""")
ACTION_CHECK_TARGET_WEB_HOSTING_FAILURE = single_line_message("""
	Failed to check if subscription '%s' has web IP
""")
ACTION_CHECK_TARGET_WEB_HOSTING_DESCRIPTION = single_line_message("""
	Check that each subscription with virtual hosting has web IP
""")
NO_WEB_HOSTING_ERROR = single_line_message("""
	Unable to continue migration: web hosting of the corresponding webspace in target panel is not configured.Make sure
	that web hosting of the corresponding webspace is configured.
""")
ACTION_FIX_UNIX_PERMISSIONS_ON_OLD_PLESKS_FAILURE = single_line_message("""
	Failed set permissions for statistics and logs directories for subscription '%s'
""")
ACTION_FIX_UNIX_PERMISSIONS_ON_OLD_PLESKS_DESCRIPTION = single_line_message("""
	Set permissions for statistics and logs directories
""")
LOG_FIX_STATISTICS_AND_LOGS_DIRECTORIES_PERMISSION = single_line_message("""
	Fix statistics and logs directories permission after migration from Plesk 8/9
""")
ACTION_RESTORE_APS_APPLICATIONS_FAILURE = single_line_message("""
	Failed to restore APS applications settings for subscription '%s'
""")
ACTION_TRANSFER_APS_PACKAGES_FAILURE_SOLUTION = single_line_message("""
	Old and custom APS applications will be likely not registered in target panel as APS applications (still migration
	tools. will try to transfer their files and databases). To fix the issue manually, you could try to register APS
	packages manually in the target panel, then restart copy content with 'copy-content' command.
""")
ACTION_TRANSFER_APS_PACKAGES_FAILURE = single_line_message("""
	Failed to transfer APS packages.
""")
FAILED_TO_INSTALL_APS_PACKAGE = single_line_message("""
	Failed to install APS package '%s-%s-%s'. PPA will not consider this application as installed. However all
	application-related content should be restored correctly.
""")
APS_PACKAGE_WAS_NOT_FOUND_SOURCE = single_line_message("""
	APS package was not found on the source Plesk server
""")
UNABLE_TO_FIND_FILENAME_FOR_APS_PACKAGE = single_line_message("""
	Unable to find filename for APS package '%s-%s-%s'. This can cause errors while restoring APS applications.
""")
FAILED_TO_READ_INFORMATION_ABOUT_APS_PACKAGES = single_line_message("""
	Failed to read information about APS packages for subscription.
""")
LOG_LOOKING_FOR_APS_PACKAGES_TO_TRANSFER = single_line_message("""
	Looking for APS packages to transfer
""")
LOG_COPY_PACKAGE = single_line_message("""
	Copy package '%s-%s-%s' required to restore the following subscription(s): %s (#%d out of #%d)
""")
FETCH_CONFIGURATION_DATA_FROM_PLESK_SERVERS = single_line_message("""
	Fetch configuration data from Plesk servers
""")
FAILED_FETCH_CONFIGURATION_DATA_FROM_PLESK = single_line_message("""
	Failed to fetch configuration data from Plesk servers
""")
LOG_USING_CACHED_DUMP = single_line_message("""
	Using the existing dump '{dump_filename}' for '{source_id}'
""")
FETCH_INFORMATION_ABOUT_WEB_APPLICATIONS_INSTALLED = single_line_message("""
	Fetch information about web applications installed on '%s'
""")
ACTION_FETCH_APPLICATIONS_DESCRIPTION = single_line_message("""
	Fetch information about APS web applications
""")
ACTION_FETCH_APPLICATIONS_FAILURE = single_line_message("""
	Failed to fetch information about APS web applications
""")
ACTION_FETCH_SHALLOW_BACKUP_DESCRIPTION = single_line_message("""
	Fetch basic information about resellers, clients and domains data from source servers
""")
LOG_USING_CACHED_SHALLOW_DUMP = single_line_message("""
	Using the existing shallow dump for '%s'
""")
ACTION_FETCH_SHALLOW_BACKUP_FAILURE = single_line_message("""
	Failed to fetch basic information about resellers, clients and domains data from source servers
""")
ACTION_MERGE_APPLICATIONS_DESCRIPTION = single_line_message("""
	Merge information about APS web applications into backup
""")
ACTION_MERGE_APPLICATIONS_FAILURE = single_line_message("""
	Failed to merge information about APS web applications into backup
""")
ACTION_ADD_SOURCE_SERVER_TO_TARGET_DNS_ACL_DESCRIPTION = single_line_message("""
	Add source server to target DNS ACL
""")
ACTION_ADD_SOURCE_SERVER_TO_TARGET_DNS_ACL_FAILURE = single_line_message("""
	Failed to add source server to target DNS ACL
""")
ACTION_ADD_SOURCE_SERVER_TO_TARGET_DNS_AXFR_DESCRIPTION = single_line_message("""
	Add source server's AXFR record to target DNS
""")
ACTION_ADD_SOURCE_SERVER_TO_TARGET_DNS_AXFR_FAILURE = single_line_message("""
	Failed to add source server's AXFR record to target DNS
""")
