from parallels.source.plesk import messages
from parallels.core.actions.base.subscription_action import SubscriptionAction
from parallels.core.actions.utils.logging_properties import LoggingProperties


class CheckTargetWebHosting(SubscriptionAction):
	"""Check that each subscription with virtual hosting has target web IP"""

	def get_description(self):
		return messages.ACTION_CHECK_TARGET_WEB_HOSTING_DESCRIPTION

	def get_failure_message(self, global_context, subscription):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		:type subscription: parallels.core.migrated_subscription.MigratedSubscription
		"""
		return messages.ACTION_CHECK_TARGET_WEB_HOSTING_FAILURE % subscription.name

	def get_logging_properties(self):
		"""Get how action should be logged to migration tools end-user

		:rtype: parallels.core.actions.utils.logging_properties.LoggingProperties
		"""
		return LoggingProperties(info_log=False)

	def filter_subscription(self, global_context, subscription):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		:type subscription: parallels.core.migrated_subscription.MigratedSubscription
		"""
		return subscription.raw_backup.hosting_type == 'phosting'

	def run(self, global_context, subscription):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		:type subscription: parallels.core.migrated_subscription.MigratedSubscription
		"""
		if subscription.web_target_server is None:
			raise Exception(
				messages.NO_WEB_HOSTING_ERROR)
