from parallels.core.actions.hosting_settings.import_backups import ImportBackups


class ImportBackupsForApsRestore(ImportBackups):
	def is_critical(self):
		"""If action is critical or not

		If action is critical and it failed, migration tool won't run the next operations.

		:rtype: bool
		"""
		return False

	@staticmethod
	def _should_import_for_subscription(subscription):
		"""Whether we should import backup for that subscription - only for subscriptions with APS applications

		:type subscription: parallels.core.migrated_subscription.MigratedSubscription
		:rtype: bool
		"""
		return subscription.converted_backup.has_aps