from parallels.source.hsphere import messages
from parallels.core.workflow.shared_hosting_workflow import SharedHostingWorkflow

from parallels.core.actions.base.legacy_action \
	import LegacyAction
from parallels.core.actions.base.entry_point_action \
	import EntryPointAction

from parallels.source.hsphere.actions.hosting_settings.convert.dns \
	import DNS as ActionHostingSettingsConvertDNS
from parallels.source.hsphere.actions.content.web.copy_windows_web_content \
	import CopyWindowsWebContent
from parallels.source.hsphere.actions.content.web.copy_unix_web_content \
	import CopyUnixWebContent
from parallels.core.actions.content.web.fix_unix_vhost_permissions \
	import FixUnixVhostPermissions
from parallels.source.plesk.actions.content.web.reset_permissions \
	import ResetPermissions
from parallels.source.hsphere.actions.hosting_settings.convert.remove_subdomain_mail \
	import RemoveSubdomainMail
from parallels.source.hsphere.actions.hosting_settings.transfer_virtual_directories \
	import TransferVirtualDirectories
from parallels.source.hsphere.actions.hosting_settings.transfer_error_documents \
	import TransferErrorDocuments
from parallels.source.hsphere.actions.hosting_settings.transfer_mime_types \
	import TransferMIMETypes
from parallels.source.hsphere.actions.dns_forwarding.forwarding.undo_not_supported \
	import UndoNotSupported
from parallels.source.hsphere.actions.hosting_settings.check.mailsystem_on_subdomains \
	import MailsystemOnSubdomains

from parallels.core.utils.backup_adapter import SubscriptionBackup
from parallels.core.utils.backup_adapter import SubscriptionBackupRaw


class FromHSphereWorkflow(SharedHostingWorkflow):
	def __init__(self):
		super(FromHSphereWorkflow, self).__init__()

		self.get_shared_action('fetch-source').insert_action(
			'fetch-data', LegacyAction(
				description=messages.FETCH_DATA_FROM_SOURCE_HSPHERE,
				function=lambda ctx: ctx.migrator._fetch_source(
					ctx.options, ctx.options.reload_source_data
				)
			)
		)
		self.get_path('transfer-accounts/restore-hosting').insert_action(
			'transfer-ip-access-restrictions', LegacyAction(
				description=messages.TRANSFER_IP_ACCESS_RESTRICTIONS,
				function=lambda ctx: ctx.migrator._transfer_ip_access_restrictions()
			)
		)

		self.get_shared_action('convert-hosting').replace(
			'convert-dns', ActionHostingSettingsConvertDNS()
		)
		self.get_path('transfer-accounts').insert_action('transfer-resource-limits', LegacyAction(
			description='Transfer resource limits',
			function=lambda ctx: ctx.migrator._transfer_resource_limits(ctx.options)
		), after='restore')

		self.get_shared_action('copy-web-files').insert_action(
			'copy-files-unix', CopyUnixWebContent()
		)
		self.get_shared_action('sync-web-content-assets').insert_action(
			'fix-unix-vhost-permissions', FixUnixVhostPermissions()
		)
		self.get_shared_action('sync-web-content-assets').insert_action(
			'copy-files-windows', CopyWindowsWebContent()
		)
		self.get_shared_action('sync-web-content-assets').insert_action(
			'reset-permissions', ResetPermissions()
		)
		self.get_shared_action('sync-web-content-assets').insert_action(
			'transfer-virtual-directories', TransferVirtualDirectories()
		)
		self.get_shared_action('sync-web-content-assets').insert_action(
			'transfer-mime-types', TransferMIMETypes()
		)
		self.get_shared_action('sync-web-content-assets').insert_action(
			'transfer-error-documents', TransferErrorDocuments()
		)

		self.get_shared_action(
			'convert-hosting'
		).insert_action(
			'remove-subdomains-mail', RemoveSubdomainMail(SubscriptionBackup())
		)

		self.get_path('check/check-data').insert_action(
			'check-mail-on-subdomains', MailsystemOnSubdomains(SubscriptionBackupRaw())
		)

		self.replace_entry_point('set-dns-forwarding', EntryPointAction())
		self.replace_entry_point('undo-dns-forwarding', EntryPointAction())

		self.get_path('set-dns-forwarding').insert_action(
			'check-connections', LegacyAction(
				description='Check connections',
				function=lambda ctx: ctx.migrator._check_connections(ctx.options)
			)
		)
		self.get_path('set-dns-forwarding').insert_action(
			'read-migration-list', LegacyAction(
				description='Read migration list',
				function=lambda ctx: ctx.migrator._read_migration_list_lazy(ctx.options)
			)
		)
		self.get_path('set-dns-forwarding').insert_action(
			'forward-dns', LegacyAction(
				description='Forward DNS',
				function=lambda ctx: ctx.migrator._forward_dns(ctx.dns_forwarding_report)
			)
		)
		self.get_path('set-dns-forwarding').insert_action(
			'cleanup',
			self.get_shared_action('cleanup')
		)
		self.get_path('set-dns-forwarding').insert_action(
			'print-report', LegacyAction(
				description='Print DNS forwarding report',
				function=lambda ctx: ctx.migrator._print_dns_forwarding_report(ctx.dns_forwarding_report)
			)
		)
		self.get_path('set-dns-forwarding').register_overall_shutdown('cleanup')

		self.get_path('undo-dns-forwarding').insert_action(
			'not-supported', UndoNotSupported()
		)
