from parallels.core.utils.common import obj
from parallels.core.actions.content.web.copy_windows_content_base import CopyWindowsWebContentBase


class CopyWindowsWebContent(CopyWindowsWebContentBase):
	def _list_files_to_copy(self, global_context, subscription):
		sysuser = subscription.raw_backup.get_phosting_sysuser_name()
		if sysuser is None:
			# no physical hosting - no content to copy
			return []

		# TODO copy logs
		# problem to include them right now is that the logs are placed in a separate directory
		# (\hslogfiles), all logs for all domains of all users
		# and takes to determine iis svc id to correctly copy them under PPA webspace,
		# but we don't have exec on source server.
		# TODO check - maybe h-sphere db has this svc id

		tocopy = [
			# copy all stuff of H-Sphere Windows system user into webspace root on PPA service node
			# stuff includes:
			# directory of main domain, including virtual directories in it
			# directories of addon domains, including virtual directories in them
			# virtual directories that are placed outside of their respective domains
			# anything else (copy it just to preserve it)
			obj(
				source_filename=sysuser + '/',
				target_filename=subscription.name,
				exclude=[],
				skip_if_source_not_exists=False
			)
		]

		return tocopy