import parallels

from parallels.core.utils.common import cached
from parallels.core.connections.source_server import SourceServer
from parallels.core.utils.migrator_utils import get_package_extras_file_path


class Helm3SourceServer(SourceServer):
	@cached
	def get_path_to_mysqldump(self):
		mysqldump_path = self.get_session_file_path('mysqldump.exe')
		extras_mysqldump_path = get_package_extras_file_path(
			parallels.source.helm3, "mysqldump.exe"
		)
		with self.runner() as runner:
			runner.upload_file(extras_mysqldump_path, mysqldump_path)

		return mysqldump_path

	@cached
	def get_path_to_mysql(self):
		mysql_path = self.get_session_file_path('mysql.exe')
		extras_mysql_path = get_package_extras_file_path(
			parallels.source.helm3, "mysql.exe"
		)
		with self.runner() as runner:
			runner.upload_file(extras_mysql_path, mysql_path)

		return mysql_path

	def mysql_use_skip_secure_auth(self):
		# We deploy own MySQL client, it could be of greater version than server,
		# so we should pass the --skip-secure-auth flag
		return True

	def __repr__(self):
		return 'Helm3SourceServer(%r)' % (self.node_id,)