from parallels.source.helm3 import messages
from parallels.core.target_panels import TargetPanels
from parallels.core.actions.base.subscription_action import SubscriptionAction
from parallels.core.actions.hosting_settings.convert.plesk.dns \
	import DNS as ActionConvertDNSPlesk
from parallels.source.helm3.actions.hosting_settings.convert.ppa.dns \
	import DNS as ActionConvertDNSPPA

class DNS(SubscriptionAction):
	def get_description(self):
		return "Convert DNS records"

	def get_failure_message(self, global_context, subscription):
		return messages.FAILED_TO_CONVERT_DNS_RECORDS_FOR_SUBSCRIPTION % (subscription.name)

	def filter_subscription(self, global_context, subscription):
		return True

	def run(self, global_context, subscription):
		if global_context.target_panel == TargetPanels.PLESK:
			ActionConvertDNSPlesk().run(global_context, subscription)
		elif global_context.target_panel == TargetPanels.PPA:
			ActionConvertDNSPPA().run(global_context, subscription)
		else:
			raise NotImplementedError(
				messages.DNS_CONVERSION_IS_IMPLEMENTED_ONLY_FOR_PLESK_AND_PPA)
