from parallels.core.migrated_subscription import MigratedSubscription
from parallels.core.utils.common import cached


class CustomPanelMigratedSubscription(MigratedSubscription):
	@property
	@cached
	def light_backup(self):
		"""Get light backup of specified subscription

		:rtype: parallels.custom_panel_migrator.light_backup.LightBackupSubscription | None
		"""
		if self._migrator.global_context.conn.has_source_light_backup_config(self.model.source):
			light_backup = self._migrator.global_context.get_light_backup(self.model.source)
			return light_backup.get_subscription(self.name)
		else:
			return None