import textwrap


def single_line_message(message):
	message = message.strip()
	return " ".join([line.strip() for line in message.split('\n')])


def multi_line_message(message):
	lines = [line for line in message.split('\n')]
	empty_lines = 0
	for i, line in enumerate(lines):
		if line.strip() == '':
			empty_lines = i + 1
		else:
			break
	message = "\n".join(lines[empty_lines:])
	return textwrap.dedent(message.rstrip())
