"""
Module for reading and writing Plesk backup files
"""
import logging
import tarfile
import time

from contextlib import closing

from parallels.core.utils.tar_utils import tar_add_empty_file, tar_add_dir, tar_add_file_content

logger = logging.getLogger(__name__)

def save_backup_tar(backup_file_content, backup_save_file):
	xml_name = 'backup_info_%s' % int(time.time())
	with closing(tarfile.open(backup_save_file, 'w')) as backup_tar_file:
		discovered_catalog = ".discovered"
		full_discovered_catalog = discovered_catalog + '/' + xml_name

		tar_add_dir(backup_tar_file, ".discovered")
		tar_add_dir(backup_tar_file, full_discovered_catalog)

		tar_add_empty_file(backup_tar_file, full_discovered_catalog + '/GUID_00000000-0000-0000-0000-000000000000')
		tar_add_empty_file(backup_tar_file, full_discovered_catalog + '/owner_00000000-0000-0000-0000-000000000000')
		tar_add_empty_file(backup_tar_file, full_discovered_catalog + '/objectid_admin')
		tar_add_empty_file(backup_tar_file, full_discovered_catalog + '/ownertype_server')
		tar_add_empty_file(backup_tar_file, full_discovered_catalog + '/status_OK')

		tar_add_file_content(backup_tar_file, backup_file_content, xml_name + '.xml')


