from parallels.core.utils import plesk_utils

class HostingSecurityCommand(object):
	"""Wrapper around HostingSecurity.exe command on Plesk for Windows server/PPA Windows service node"""

	def __init__(self, runner):
		self.runner = runner

	def update_domain_security(self, vhost_name, user_name):
		self.runner.sh(
			u"{hosting_security_util} --update-domain-security --vhost-name={vhost_name} --user-name={user_name}",
			dict(hosting_security_util=self._get_command_path(), vhost_name=vhost_name.encode('idna'), user_name=user_name)
		)

	def _get_command_path(self):
		plesk_dir = plesk_utils.get_windows_plesk_dir(self.runner)
		return plesk_dir + r"\admin\bin\HostingSecurity.exe"
