from parallels.core.actions.base.common_action import CommonAction
from parallels.core.actions.utils.logging_properties import LoggingProperties


class UninstallDumpAgentAction(CommonAction):
	def get_description(self):
		return "Uninstall migration agent files"

	def get_failure_message(self, global_context):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		"""
		return "Could not uninstall the migration agent files."

	def is_critical(self):
		"""If action is critical or not

		If action is critical and it failed, migration tool won't run the next operations.

		:rtype: bool
		"""
		return False

	def run(self, global_context):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		"""
		if global_context.dump_agent:
			global_context.dump_agent.uninstall()

	def get_logging_properties(self):
		"""Get how action should be logged to migration tools end-user"""
		return LoggingProperties(info_log=False)
