from parallels.core import messages
from parallels.core.actions.base.subscription_backup_action import SubscriptionBackupAction
from parallels.core.actions.utils.logging_properties \
	import LoggingProperties


class RemoveSubscriptionToPlanRelation(SubscriptionBackupAction):
	"""When subscription assigned to some plan is provisioned from POA to
	Plesk, a custom subscription is created in Plesk.  No plans are created in
	Plesk. We restore hosting settings at subscriptions level, and Plesk
	restore tries to find plan with the same guid that existed on source panel.
	As no plans are created on target Plesk, Plesk restore issues these errors:
	"There is no such a service plan", "This subscription is not tied to a
	service plan, and so it cannot be synchronized." To avoid these errors we
	break relations between subscriptions and plans in Plesk backup.
	"""

	def get_description(self):
		return messages.REMOVE_RELATION_PLANS_AND_SUBSCRIPTIONS_FROM

	def get_failure_message(self, global_context, subscription):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		:type subscription: parallels.core.migrated_subscription.MigratedSubscription
		"""
		return messages.FAILED_REMOVE_RELATION_PLANS_AND_SUBSCRIPTION % subscription.name

	def get_logging_properties(self):
		return LoggingProperties(info_log=False)

	def _run_subscription_backup(
		self, global_context, subscription, subscription_backup
	):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		:type subscription: parallels.core.migrated_subscription.MigratedSubscription
		"""
		subscription_backup.remove_plans_reference()
