from parallels.core.actions.utils.logging_properties import LoggingProperties


class BaseAction(object):
	def get_description(self):
		"""Get short description of action as string

		:rtype: basestring
		"""
		raise NotImplementedError()

	def get_logging_properties(self):
		"""Get how action should be logged to migration tools end-user

		:rtype: parallels.core.actions.utils.logging_properties.LoggingProperties
		"""
		return LoggingProperties()
