from parallels.core import messages
from parallels.core.actions.base.common_action import CommonAction
from parallels.core.actions.utils.logging_properties \
	import LoggingProperties


class RemoveContent(CommonAction):
	"""Work around Plesk 11.1 being unable to restore content from Plesk 8.6
	for Windows zip archives: cut out content nodes"""

	def __init__(self, subscription_backup):
		"""Class constructor

		Arguments:
		- subscription_backup - object that can retrieve subscription backup
		object for each subscription, list of servers with backups
		"""
		self._subscription_backup = subscription_backup

	def get_description(self):
		return messages.REMOVE_CONTENT_NODES_FROM_BACKUPS

	def get_failure_message(self, global_context):
		return messages.UNABLE_REMOVE_CONTENT_NODES_FROM_BACKUPS

	def get_logging_properties(self):
		return LoggingProperties(info_log=False)

	def run(self, global_context):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		"""
		backup_ids = self._subscription_backup.get_backup_ids(global_context)

		for backup_id in backup_ids:
			backup = global_context.load_converted_plesk_backup(backup_id)

			if backup.container.agent_name == 'pre9-backup-converter' and backup.is_windows:
				backup.remove_content()
