from parallels.core.utils.yaml_utils import read_yaml, write_yaml

class MoveServices(object):
	def __init__(self, move_list, web_service_types, source_web_ips_storage, target_web_ips_storage, source_mail_ips_storage, target_mail_ips_storage, source_db_mysql_hosts_storage):
		"""Parameters:
		move_list - instance of move_list.MoveList
		web_service_types - dictionary with key - webspace name (for each webspace in move_list.web) and value - web type (common.WebServiceType)
		*_storage - persistent storage for data
		"""
		self.web = [] 
		for subscription_name, target_service_node_ip in move_list.web.iteritems():
			self.web.append(SubscriptionWebMoveInfo(
				name=subscription_name,
				target_service_node_ip=target_service_node_ip,
				source_ips_storage=source_web_ips_storage,
				target_ips_storage=target_web_ips_storage,
				service_type=web_service_types.get(subscription_name)
			))
			
		self.mail = [] 
		for subscription_name, target_service_node_ip in move_list.mail.iteritems():
			self.mail.append(SubscriptionMoveInfo(
				name=subscription_name,
				target_service_node_ip=target_service_node_ip,
				source_ips_storage=source_mail_ips_storage,
				target_ips_storage=target_mail_ips_storage,
			))

		self.db_mysql = []
		for subscription_name, target_host in move_list.db_mysql.iteritems():
			self.db_mysql.append(SubscriptionDbMySQLMoveInfo(
				name=subscription_name,
				target_host=target_host,
				source_db_mysql_hosts_storage=source_db_mysql_hosts_storage,
			))

class SubscriptionDictStorage(object):
	def __init__(self):
		self.data_dict = dict()

	def set(self, subscription_name, data):
		self.data_dict[subscription_name] = data 
		self._save()

	def get(self, subscription_name):
		return self.data_dict.get(subscription_name)

	def _save(self):
		pass # do not do anything, override in child classes

class SubscriptionDictStorageFile(SubscriptionDictStorage):
	def __init__(self, filename):
		self.filename = filename	
		self.data_dict = read_yaml(self.filename, file_may_be_absent=True, default=dict())

	def _save(self):
		write_yaml(self.filename, self.data_dict)

class SubscriptionMoveInfo(object):
	def __init__(self, name, target_service_node_ip, source_ips_storage, target_ips_storage):
		self.name = name
		self.target_service_node_ip = target_service_node_ip
		self.source_ips_storage = source_ips_storage
		self.target_ips_storage = target_ips_storage

	@property
	def target_ip(self):
		return self.target_ips_storage.get(self.name)

	@target_ip.setter
	def target_ip(self, ip):
		self.target_ips_storage.set(self.name, ip)

	@property
	def source_ip(self):
		return self.source_ips_storage.get(self.name)

	@source_ip.setter
	def source_ip(self, ip):
		self.source_ips_storage.set(self.name, ip)

class SubscriptionWebMoveInfo(SubscriptionMoveInfo):
	def __init__(self, name, target_service_node_ip, source_ips_storage, target_ips_storage, service_type):
		super(SubscriptionWebMoveInfo, self).__init__(name, target_service_node_ip, source_ips_storage, target_ips_storage)
		self.service_type = service_type

class SubscriptionDbMySQLMoveInfo(object):
	def __init__(self, name, target_host, source_db_mysql_hosts_storage):
		self.name = name
		self.target_host = target_host
		self.source_db_mysql_hosts_storage = source_db_mysql_hosts_storage

	@property
	def source_hosts(self):
		return self.source_db_mysql_hosts_storage.get(self.name)

	@source_hosts.setter
	def source_hosts(self, hosts):
		self.source_db_mysql_hosts_storage.set(self.name, hosts)

